/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2024-12-26 14:51:07 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=10426 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=349703 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=31253 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_appwoodart_woo_api_geo_fencing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `post_id` int(11) NOT NULL,
  `radius` text NOT NULL,
  `lat` double NOT NULL,
  `lng` double NOT NULL,
  `zoom` int(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_appwoodart_woo_api_notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `device_token` text NOT NULL,
  `device_type` tinyint(4) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_appwoodart_woo_api_notifications_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `msg` text NOT NULL,
  `custom_msg` text NOT NULL,
  `not_code` tinyint(4) NOT NULL,
  `created` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_appwoodart_woo_api_notifications_relationships` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `not_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `push_meta_id` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `push_meta_id` (`push_meta_id`),
  CONSTRAINT `wp_appwoodart_woo_api_notifications_relationships_ibfk_2` FOREIGN KEY (`push_meta_id`) REFERENCES `wp_appwoodart_woo_api_notifications_meta` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_appwoodart_woo_api_scratch_coupons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `coupon_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `device_token` text NOT NULL,
  `is_coupon_scratched` varchar(5) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=187 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=68 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_dokan_announcement` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `post_id` bigint(11) NOT NULL,
  `status` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_dokan_orders` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) DEFAULT NULL,
  `seller_id` bigint(20) DEFAULT NULL,
  `order_total` decimal(19,4) DEFAULT NULL,
  `net_amount` decimal(19,4) DEFAULT NULL,
  `order_status` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`),
  KEY `seller_id` (`seller_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_dokan_refund` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `seller_id` bigint(20) NOT NULL,
  `refund_amount` decimal(19,4) NOT NULL,
  `refund_reason` text DEFAULT NULL,
  `item_qtys` varchar(200) DEFAULT NULL,
  `item_totals` text DEFAULT NULL,
  `item_tax_totals` text DEFAULT NULL,
  `restock_items` varchar(10) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `status` int(1) NOT NULL,
  `method` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_dokan_reverse_withdrawal` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `trn_id` bigint(20) unsigned NOT NULL,
  `trn_type` varchar(200) NOT NULL DEFAULT 'order_commission',
  `vendor_id` bigint(20) unsigned NOT NULL,
  `note` mediumtext DEFAULT NULL,
  `debit` decimal(19,4) NOT NULL DEFAULT 0.0000,
  `credit` decimal(19,4) NOT NULL DEFAULT 0.0000,
  `trn_date` int(11) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `trn_date` (`trn_date`),
  KEY `vendor_id_trn_date` (`vendor_id`,`trn_date`),
  KEY `vendor_id` (`vendor_id`),
  KEY `trn_id_type` (`trn_id`,`trn_type`(191)),
  KEY `vendor_id_trn_date_type` (`vendor_id`,`trn_date`,`trn_type`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_dokan_vendor_balance` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `vendor_id` bigint(20) unsigned NOT NULL,
  `trn_id` bigint(20) unsigned NOT NULL,
  `trn_type` varchar(30) NOT NULL,
  `perticulars` text NOT NULL,
  `debit` decimal(19,4) NOT NULL,
  `credit` decimal(19,4) NOT NULL,
  `status` varchar(30) DEFAULT NULL,
  `trn_date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `balance_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_dokan_withdraw` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `amount` decimal(19,4) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `status` int(1) NOT NULL,
  `method` varchar(30) NOT NULL,
  `note` text NOT NULL,
  `details` longtext DEFAULT NULL,
  `ip` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_litespeed_avatar` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(1000) NOT NULL DEFAULT '',
  `md5` varchar(128) NOT NULL DEFAULT '',
  `dateline` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  UNIQUE KEY `md5` (`md5`),
  KEY `dateline` (`dateline`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_litespeed_url` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url` varchar(500) NOT NULL,
  `cache_tags` varchar(1000) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `url` (`url`(191)),
  KEY `cache_tags` (`cache_tags`(191))
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_litespeed_url_file` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `url_id` bigint(20) NOT NULL,
  `vary` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of final vary',
  `filename` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'md5 of file content',
  `type` tinyint(4) NOT NULL COMMENT 'css=1,js=2,ccss=3,ucss=4',
  `mobile` tinyint(4) NOT NULL COMMENT 'mobile=1',
  `webp` tinyint(4) NOT NULL COMMENT 'webp=1',
  `expired` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `filename` (`filename`),
  KEY `type` (`type`),
  KEY `url_id_2` (`url_id`,`vary`,`type`),
  KEY `filename_2` (`filename`,`expired`),
  KEY `url_id` (`url_id`,`expired`)
) ENGINE=InnoDB AUTO_INCREMENT=2326 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailchimp_carts` (
  `id` varchar(255) NOT NULL,
  `email` varchar(100) NOT NULL,
  `user_id` int(11) DEFAULT NULL,
  `cart` text NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`email`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_mailchimp_jobs` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `obj_id` text DEFAULT NULL,
  `job` text NOT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=453907 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=20916 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=9189 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_css_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_layer_animations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_navigations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_sliders7` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_sliders_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_slides7` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(11) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  `static` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_static_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_rtl_rsm_logs` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `section` varchar(255) NOT NULL,
  `result` mediumtext NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=746 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=602 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=53 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_tm_taskmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `task_id` bigint(20) NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `task_id` (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_tm_tasks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `type` varchar(300) NOT NULL,
  `class_identifier` varchar(300) DEFAULT '0',
  `attempts` int(11) DEFAULT 0,
  `description` varchar(300) DEFAULT NULL,
  `time_created` timestamp NOT NULL DEFAULT current_timestamp(),
  `last_locked_at` bigint(20) DEFAULT 0,
  `status` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=7139 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=331 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=64213 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=148 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=323 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(250)),
  KEY `phone` (`phone`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  `global_unique_id` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_ir` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text1` text NOT NULL,
  `text2` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB AUTO_INCREMENT=343 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=6867 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20)),
  KEY `zone_id` (`zone_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woodmart_wishlist_products` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` varchar(255) NOT NULL,
  `wishlist_id` int(11) DEFAULT NULL,
  `date_added` timestamp NOT NULL DEFAULT current_timestamp(),
  `on_sale` tinyint(1) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_woodmart_wishlists` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `wishlist_group` varchar(255) NOT NULL DEFAULT 'علاقه مندی های من',
  `date_created` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=328 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_wpr_above_the_fold` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `is_mobile` tinyint(1) NOT NULL DEFAULT 0,
  `lcp` longtext DEFAULT '',
  `viewport` longtext DEFAULT '',
  `error_message` longtext DEFAULT NULL,
  `status` varchar(255) NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `status_index` (`status`(191))
) ENGINE=MyISAM AUTO_INCREMENT=46 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpr_rocket_cache` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `status` varchar(255) NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `is_locked` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `url` (`url`(191)),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`)
) ENGINE=MyISAM AUTO_INCREMENT=73 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpr_rucss_used_css` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `css` longtext DEFAULT NULL,
  `hash` varchar(32) DEFAULT '',
  `error_code` varchar(32) DEFAULT NULL,
  `error_message` longtext DEFAULT NULL,
  `unprocessedcss` longtext DEFAULT NULL,
  `retries` tinyint(1) NOT NULL DEFAULT 1,
  `is_mobile` tinyint(1) NOT NULL DEFAULT 0,
  `job_id` varchar(255) NOT NULL DEFAULT '',
  `queue_name` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(255) NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `submitted_at` timestamp NULL DEFAULT NULL,
  `next_retry_time` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `status_index` (`status`(191)),
  KEY `error_code_index` (`error_code`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=84 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("22", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "failed", "2023-03-06 13:39:30", "2023-03-06 13:39:30", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "0", "1", "2023-03-06 13:39:43", "2023-03-06 17:09:43", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("595", "action_scheduler/migration_hook", "failed", "2023-05-01 14:07:25", "2023-05-01 14:07:25", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1682950045;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1682950045;}", "1", "1", "2023-05-01 14:07:29", "2023-05-01 17:37:29", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("600", "action_scheduler/migration_hook", "failed", "2023-05-03 14:25:12", "2023-05-03 14:25:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1683123912;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1683123912;}", "1", "1", "2023-05-03 14:25:47", "2023-05-03 17:55:47", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("602", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2023-05-03 14:39:07", "2023-05-03 14:39:07", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1683124747;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1683124747;}", "5", "1", "2023-05-03 14:39:10", "2023-05-03 18:09:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("603", "action_scheduler/migration_hook", "failed", "2023-05-03 14:40:11", "2023-05-03 14:40:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1683124811;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1683124811;}", "1", "1", "2023-05-03 14:40:45", "2023-05-03 18:10:45", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("638", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2023-05-23 16:53:42", "2023-05-23 16:53:42", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1684860822;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1684860822;}", "5", "1", "2023-05-23 16:54:43", "2023-05-23 20:24:43", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("643", "action_scheduler/migration_hook", "failed", "2023-05-27 01:44:37", "2023-05-27 01:44:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1685151877;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1685151877;}", "1", "1", "2023-05-27 01:44:43", "2023-05-27 05:14:43", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("756", "action_scheduler/migration_hook", "failed", "2023-09-09 13:19:38", "2023-09-09 13:19:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1694265578;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1694265578;}", "1", "1", "2023-09-09 13:36:06", "2023-09-09 17:06:06", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("802", "rocket_preload_job_check_finished", "failed", "2023-09-10 07:19:41", "2023-09-10 07:19:41", "[1694330321]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1694330381;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1694330381;}", "7", "1", "2023-09-10 07:20:20", "2023-09-10 10:50:20", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3334", "action_scheduler/migration_hook", "failed", "2023-12-25 12:07:58", "2023-12-25 12:07:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1703506078;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1703506078;}", "1", "1", "2023-12-25 12:15:53", "2023-12-25 15:45:53", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3784", "action_scheduler/migration_hook", "failed", "2024-01-17 05:56:22", "2024-01-17 05:56:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1705470982;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1705470982;}", "1", "1", "2024-01-17 05:56:27", "2024-01-17 09:26:27", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4074", "action_scheduler/migration_hook", "failed", "2024-02-04 21:28:24", "2024-02-04 21:28:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1707082104;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1707082104;}", "1", "1", "2024-02-04 21:28:24", "2024-02-05 00:58:24", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("6598", "action_scheduler/migration_hook", "failed", "2024-05-18 13:32:58", "2024-05-18 13:32:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1716039178;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1716039178;}", "1", "1", "2024-05-18 13:33:59", "2024-05-18 17:03:59", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7262", "action_scheduler/migration_hook", "failed", "2024-06-16 13:55:10", "2024-06-16 13:55:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1718546110;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1718546110;}", "1", "1", "2024-06-16 13:55:19", "2024-06-16 17:25:19", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("7375", "action_scheduler/migration_hook", "failed", "2024-08-05 05:45:06", "2024-08-05 05:45:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1722836706;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1722836706;}", "1", "1", "2024-08-05 05:45:10", "2024-08-05 09:15:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10367", "woocommerce_cleanup_draft_orders", "complete", "2024-11-26 11:03:33", "2024-11-26 11:03:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732619013;s:18:\"\0*\0first_timestamp\";i:1678050967;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732619013;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2024-11-26 11:03:46", "2024-11-26 14:33:46", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10368", "woocommerce_cleanup_draft_orders", "complete", "2024-11-27 11:03:46", "2024-11-27 11:03:46", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732705426;s:18:\"\0*\0first_timestamp\";i:1678050967;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732705426;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2024-11-27 11:04:28", "2024-11-27 14:34:28", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10369", "woocommerce_cleanup_draft_orders", "complete", "2024-11-28 11:04:28", "2024-11-28 11:04:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732791868;s:18:\"\0*\0first_timestamp\";i:1678050967;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732791868;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2024-11-28 11:05:18", "2024-11-28 14:35:18", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10370", "fetch_patterns", "complete", "2024-11-27 17:52:42", "2024-11-27 17:52:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732729962;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732729962;}", "6", "1", "2024-11-27 17:52:52", "2024-11-27 21:22:52", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10371", "woocommerce_run_on_woocommerce_admin_updated", "complete", "2024-11-27 17:52:50", "2024-11-27 17:52:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732729970;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732729970;}", "5", "1", "2024-11-27 17:52:52", "2024-11-27 21:22:52", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10372", "woocommerce_cleanup_draft_orders", "complete", "2024-11-29 11:05:18", "2024-11-29 11:05:18", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732878318;s:18:\"\0*\0first_timestamp\";i:1678050967;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732878318;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2024-11-29 11:05:28", "2024-11-29 14:35:28", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10373", "woocommerce_cleanup_draft_orders", "complete", "2024-11-30 11:05:28", "2024-11-30 11:05:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732964728;s:18:\"\0*\0first_timestamp\";i:1678050967;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732964728;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2024-11-30 11:05:58", "2024-11-30 14:35:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10374", "woocommerce_cleanup_draft_orders", "complete", "2024-12-01 11:05:58", "2024-12-01 11:05:58", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733051158;s:18:\"\0*\0first_timestamp\";i:1678050967;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733051158;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2024-12-01 11:06:31", "2024-12-01 14:36:31", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10375", "woocommerce_cleanup_draft_orders", "complete", "2024-12-02 11:06:31", "2024-12-02 11:06:31", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733137591;s:18:\"\0*\0first_timestamp\";i:1678050967;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733137591;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2024-12-02 11:06:36", "2024-12-02 14:36:36", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10376", "woocommerce_cleanup_draft_orders", "complete", "2024-12-03 11:06:36", "2024-12-03 11:06:36", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733223996;s:18:\"\0*\0first_timestamp\";i:1678050967;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733223996;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2024-12-03 11:06:46", "2024-12-03 14:36:46", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10377", "woocommerce_cleanup_draft_orders", "complete", "2024-12-04 11:06:46", "2024-12-04 11:06:46", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733310406;s:18:\"\0*\0first_timestamp\";i:1678050967;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733310406;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2024-12-04 11:07:54", "2024-12-04 14:37:54", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10378", "woocommerce_cleanup_draft_orders", "complete", "2024-12-05 11:07:54", "2024-12-05 11:07:54", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733396874;s:18:\"\0*\0first_timestamp\";i:1678050967;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733396874;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2024-12-05 11:08:29", "2024-12-05 14:38:29", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10379", "woocommerce_cleanup_draft_orders", "complete", "2024-12-06 11:08:29", "2024-12-06 11:08:29", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733483309;s:18:\"\0*\0first_timestamp\";i:1678050967;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733483309;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2024-12-06 11:08:51", "2024-12-06 14:38:51", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10380", "woocommerce_cleanup_draft_orders", "complete", "2024-12-07 11:08:51", "2024-12-07 11:08:51", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733569731;s:18:\"\0*\0first_timestamp\";i:1678050967;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733569731;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2024-12-07 11:11:30", "2024-12-07 14:41:30", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10381", "woocommerce_cleanup_draft_orders", "complete", "2024-12-08 11:11:30", "2024-12-08 11:11:30", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733656290;s:18:\"\0*\0first_timestamp\";i:1678050967;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733656290;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2024-12-08 11:11:45", "2024-12-08 14:41:45", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10382", "woocommerce_cleanup_draft_orders", "complete", "2024-12-09 11:11:45", "2024-12-09 11:11:45", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733742705;s:18:\"\0*\0first_timestamp\";i:1678050967;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733742705;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2024-12-09 11:12:39", "2024-12-09 14:42:39", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10383", "wc-admin_import_orders", "complete", "2024-12-08 17:01:26", "2024-12-08 17:01:26", "[9131]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1733677286;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1733677286;}", "2", "1", "2024-12-08 17:01:27", "2024-12-08 20:31:27", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10384", "woocommerce_cleanup_draft_orders", "complete", "2024-12-10 11:12:39", "2024-12-10 11:12:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733829159;s:18:\"\0*\0first_timestamp\";i:1678050967;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733829159;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2024-12-10 11:14:23", "2024-12-10 14:44:23", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10385", "woocommerce_cleanup_draft_orders", "complete", "2024-12-11 11:14:23", "2024-12-11 11:14:23", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733915663;s:18:\"\0*\0first_timestamp\";i:1678050967;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733915663;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2024-12-11 11:15:57", "2024-12-11 14:45:57", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10386", "woocommerce_cleanup_draft_orders", "complete", "2024-12-12 11:15:57", "2024-12-12 11:15:57", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734002157;s:18:\"\0*\0first_timestamp\";i:1678050967;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734002157;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2024-12-12 11:19:24", "2024-12-12 14:49:24", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10387", "wc-admin_import_orders", "complete", "2024-12-11 22:10:31", "2024-12-11 22:10:31", "[9135]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1733955031;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1733955031;}", "2", "1", "2024-12-11 22:11:29", "2024-12-12 01:41:29", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10388", "fetch_patterns", "complete", "2024-12-12 08:01:24", "2024-12-12 08:01:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1733990484;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1733990484;}", "6", "1", "2024-12-12 08:01:30", "2024-12-12 11:31:30", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10389", "woocommerce_run_on_woocommerce_admin_updated", "complete", "2024-12-12 08:01:28", "2024-12-12 08:01:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1733990488;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1733990488;}", "5", "1", "2024-12-12 08:01:30", "2024-12-12 11:31:30", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10390", "woocommerce_cleanup_draft_orders", "complete", "2024-12-13 11:19:24", "2024-12-13 11:19:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734088764;s:18:\"\0*\0first_timestamp\";i:1678050967;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734088764;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2024-12-13 11:20:50", "2024-12-13 14:50:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10391", "woocommerce_cleanup_draft_orders", "complete", "2024-12-14 11:20:50", "2024-12-14 11:20:50", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734175250;s:18:\"\0*\0first_timestamp\";i:1678050967;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734175250;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2024-12-14 11:21:25", "2024-12-14 14:51:25", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10392", "woocommerce_cleanup_draft_orders", "complete", "2024-12-15 11:21:25", "2024-12-15 11:21:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734261685;s:18:\"\0*\0first_timestamp\";i:1678050967;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734261685;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2024-12-15 11:23:10", "2024-12-15 14:53:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10393", "woocommerce_cleanup_draft_orders", "complete", "2024-12-16 11:23:10", "2024-12-16 11:23:10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734348190;s:18:\"\0*\0first_timestamp\";i:1678050967;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734348190;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2024-12-16 11:23:26", "2024-12-16 14:53:26", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10394", "woocommerce_cleanup_draft_orders", "complete", "2024-12-17 11:23:26", "2024-12-17 11:23:26", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734434606;s:18:\"\0*\0first_timestamp\";i:1678050967;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734434606;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2024-12-17 11:23:50", "2024-12-17 14:53:50", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10395", "woocommerce_cleanup_draft_orders", "complete", "2024-12-18 11:23:50", "2024-12-18 11:23:50", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734521030;s:18:\"\0*\0first_timestamp\";i:1678050967;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734521030;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2024-12-18 11:24:38", "2024-12-18 14:54:38", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10396", "woocommerce_cleanup_draft_orders", "complete", "2024-12-19 11:24:38", "2024-12-19 11:24:38", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734607478;s:18:\"\0*\0first_timestamp\";i:1678050967;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734607478;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2024-12-19 11:24:39", "2024-12-19 14:54:39", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10397", "woocommerce_cleanup_draft_orders", "complete", "2024-12-20 11:24:39", "2024-12-20 11:24:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734693879;s:18:\"\0*\0first_timestamp\";i:1678050967;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734693879;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2024-12-20 11:25:40", "2024-12-20 14:55:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10398", "woocommerce_cleanup_draft_orders", "complete", "2024-12-21 11:25:40", "2024-12-21 11:25:40", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734780340;s:18:\"\0*\0first_timestamp\";i:1678050967;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734780340;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2024-12-21 11:26:29", "2024-12-21 14:56:29", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10399", "woocommerce_cleanup_draft_orders", "complete", "2024-12-22 11:26:29", "2024-12-22 11:26:29", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734866789;s:18:\"\0*\0first_timestamp\";i:1678050967;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734866789;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2024-12-22 11:26:29", "2024-12-22 14:56:29", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10400", "woocommerce_cleanup_draft_orders", "complete", "2024-12-23 11:26:29", "2024-12-23 11:26:29", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734953189;s:18:\"\0*\0first_timestamp\";i:1678050967;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734953189;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2024-12-23 11:27:43", "2024-12-23 14:57:43", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10401", "woocommerce_cleanup_draft_orders", "complete", "2024-12-24 11:27:43", "2024-12-24 11:27:43", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1735039663;s:18:\"\0*\0first_timestamp\";i:1678050967;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1735039663;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2024-12-24 11:27:49", "2024-12-24 14:57:49", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10402", "woocommerce_cleanup_draft_orders", "complete", "2024-12-25 11:27:49", "2024-12-25 11:27:49", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1735126069;s:18:\"\0*\0first_timestamp\";i:1678050967;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1735126069;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2024-12-25 11:27:55", "2024-12-25 14:57:55", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10403", "woocommerce_cleanup_draft_orders", "complete", "2024-12-26 11:27:55", "2024-12-26 11:27:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1735212475;s:18:\"\0*\0first_timestamp\";i:1678050967;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1735212475;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "1", "2024-12-26 11:28:15", "2024-12-26 14:58:15", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10404", "fetch_patterns", "complete", "2024-12-25 21:35:37", "2024-12-25 21:35:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735162537;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735162537;}", "6", "1", "2024-12-25 21:36:12", "2024-12-26 01:06:12", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10405", "woocommerce_run_on_woocommerce_admin_updated", "complete", "2024-12-25 21:35:45", "2024-12-25 21:35:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735162545;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735162545;}", "5", "1", "2024-12-25 21:36:12", "2024-12-26 01:06:12", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10406", "woocommerce_run_update_callback", "complete", "2024-12-25 21:36:33", "2024-12-25 21:36:33", "{\"update_callback\":\"wc_update_920_add_wc_hooked_blocks_version_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735162593;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735162593;}", "3", "1", "2024-12-25 21:37:18", "2024-12-26 01:07:18", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10407", "woocommerce_run_update_callback", "complete", "2024-12-25 21:36:34", "2024-12-25 21:36:34", "{\"update_callback\":\"wc_update_930_add_woocommerce_coming_soon_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735162594;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735162594;}", "3", "1", "2024-12-25 21:37:18", "2024-12-26 01:07:18", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10408", "woocommerce_run_update_callback", "complete", "2024-12-25 21:36:35", "2024-12-25 21:36:35", "{\"update_callback\":\"wc_update_930_migrate_user_meta_for_launch_your_store_tour\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735162595;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735162595;}", "3", "1", "2024-12-25 21:37:18", "2024-12-26 01:07:18", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10409", "woocommerce_run_update_callback", "complete", "2024-12-25 21:36:36", "2024-12-25 21:36:36", "{\"update_callback\":\"wc_update_940_add_phone_to_order_address_fts_index\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735162596;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735162596;}", "3", "1", "2024-12-25 21:37:18", "2024-12-26 01:07:18", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10410", "woocommerce_run_update_callback", "complete", "2024-12-25 21:36:37", "2024-12-25 21:36:37", "{\"update_callback\":\"wc_update_940_remove_help_panel_highlight_shown\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735162597;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735162597;}", "3", "1", "2024-12-25 21:37:18", "2024-12-26 01:07:18", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10411", "woocommerce_run_update_callback", "complete", "2024-12-25 21:36:38", "2024-12-25 21:36:38", "{\"update_callback\":\"wc_update_950_tracking_option_autoload\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735162598;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735162598;}", "3", "1", "2024-12-25 21:37:18", "2024-12-26 01:07:18", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10412", "woocommerce_update_db_to_current_version", "complete", "2024-12-25 21:36:39", "2024-12-25 21:36:39", "{\"version\":\"9.5.1\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735162599;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735162599;}", "3", "1", "2024-12-25 21:37:18", "2024-12-26 01:07:18", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10413", "woocommerce_run_update_callback", "complete", "2024-12-25 21:37:04", "2024-12-25 21:37:04", "{\"update_callback\":\"wc_update_920_add_wc_hooked_blocks_version_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735162624;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735162624;}", "3", "1", "2024-12-25 21:37:18", "2024-12-26 01:07:18", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10414", "woocommerce_run_update_callback", "complete", "2024-12-25 21:37:05", "2024-12-25 21:37:05", "{\"update_callback\":\"wc_update_930_add_woocommerce_coming_soon_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735162625;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735162625;}", "3", "1", "2024-12-25 21:37:18", "2024-12-26 01:07:18", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10415", "woocommerce_run_update_callback", "complete", "2024-12-25 21:37:06", "2024-12-25 21:37:06", "{\"update_callback\":\"wc_update_930_migrate_user_meta_for_launch_your_store_tour\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735162626;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735162626;}", "3", "1", "2024-12-25 21:37:19", "2024-12-26 01:07:19", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10416", "woocommerce_run_update_callback", "complete", "2024-12-25 21:37:07", "2024-12-25 21:37:07", "{\"update_callback\":\"wc_update_940_add_phone_to_order_address_fts_index\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735162627;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735162627;}", "3", "1", "2024-12-25 21:37:19", "2024-12-26 01:07:19", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10417", "woocommerce_run_update_callback", "complete", "2024-12-25 21:37:08", "2024-12-25 21:37:08", "{\"update_callback\":\"wc_update_940_remove_help_panel_highlight_shown\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735162628;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735162628;}", "3", "1", "2024-12-25 21:37:19", "2024-12-26 01:07:19", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10418", "woocommerce_run_update_callback", "complete", "2024-12-25 21:37:09", "2024-12-25 21:37:09", "{\"update_callback\":\"wc_update_950_tracking_option_autoload\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735162629;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735162629;}", "3", "1", "2024-12-25 21:37:19", "2024-12-26 01:07:19", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10419", "woocommerce_run_update_callback", "complete", "2024-12-25 21:37:05", "2024-12-25 21:37:05", "{\"update_callback\":\"wc_update_920_add_wc_hooked_blocks_version_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735162625;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735162625;}", "3", "1", "2024-12-25 21:37:18", "2024-12-26 01:07:18", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10420", "woocommerce_run_update_callback", "complete", "2024-12-25 21:37:06", "2024-12-25 21:37:06", "{\"update_callback\":\"wc_update_930_add_woocommerce_coming_soon_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735162626;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735162626;}", "3", "1", "2024-12-25 21:37:19", "2024-12-26 01:07:19", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10421", "woocommerce_run_update_callback", "complete", "2024-12-25 21:37:07", "2024-12-25 21:37:07", "{\"update_callback\":\"wc_update_930_migrate_user_meta_for_launch_your_store_tour\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735162627;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735162627;}", "3", "1", "2024-12-25 21:37:19", "2024-12-26 01:07:19", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10422", "woocommerce_run_update_callback", "complete", "2024-12-25 21:37:08", "2024-12-25 21:37:08", "{\"update_callback\":\"wc_update_940_add_phone_to_order_address_fts_index\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735162628;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735162628;}", "3", "1", "2024-12-25 21:37:19", "2024-12-26 01:07:19", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10423", "woocommerce_run_update_callback", "complete", "2024-12-25 21:37:09", "2024-12-25 21:37:09", "{\"update_callback\":\"wc_update_940_remove_help_panel_highlight_shown\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735162629;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735162629;}", "3", "1", "2024-12-25 21:37:19", "2024-12-26 01:07:19", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10424", "woocommerce_run_update_callback", "complete", "2024-12-25 21:37:10", "2024-12-25 21:37:10", "{\"update_callback\":\"wc_update_950_tracking_option_autoload\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735162630;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735162630;}", "3", "1", "2024-12-25 21:37:19", "2024-12-26 01:07:19", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("10425", "woocommerce_cleanup_draft_orders", "pending", "2024-12-27 11:28:15", "2024-12-27 11:28:15", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1735298895;s:18:\"\0*\0first_timestamp\";i:1678050967;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1735298895;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "6", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "wc-admin-data");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "woocommerce-db-updates");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "mc-woocommerce");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "woocommerce-remote-inbox-engine");
INSERT INTO `wp_actionscheduler_groups` VALUES("6", "");
INSERT INTO `wp_actionscheduler_groups` VALUES("7", "rocket-preload");
INSERT INTO `wp_actionscheduler_groups` VALUES("8", "rocket-rucss");
INSERT INTO `wp_actionscheduler_groups` VALUES("9", "wc_update_product_default_cat");
INSERT INTO `wp_actionscheduler_groups` VALUES("10", "rocket-atf-warmup");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("44", "22", "ایجاد فعالیت", "2023-03-06 13:39:30", "2023-03-06 13:39:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("47", "22", "عملیات توسط WP Cron شروع شد", "2023-03-06 13:39:43", "2023-03-06 13:39:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("48", "22", "اقدام از طریق WP Cron انجام نشد: Scheduled action for woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications will not be executed as no callbacks are registered.", "2023-03-06 13:39:44", "2023-03-06 13:39:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1761", "595", "ایجاد فعالیت", "2023-05-01 14:06:25", "2023-05-01 14:06:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1762", "595", "عملیات توسط Async Request شروع شد", "2023-05-01 14:07:29", "2023-05-01 14:07:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1763", "595", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-05-01 14:07:29", "2023-05-01 14:07:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1776", "600", "ایجاد فعالیت", "2023-05-03 14:24:12", "2023-05-03 14:24:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1777", "600", "عملیات توسط WP Cron شروع شد", "2023-05-03 14:25:47", "2023-05-03 14:25:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("1778", "600", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-05-03 14:25:47", "2023-05-03 14:25:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("1780", "602", "ایجاد فعالیت", "2023-05-03 14:39:07", "2023-05-03 14:39:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("1783", "602", "عملیات توسط Async Request شروع شد", "2023-05-03 14:39:10", "2023-05-03 14:39:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1784", "602", "اقدام از طریق Async Request انجام نشد: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.", "2023-05-03 14:39:10", "2023-05-03 14:39:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1785", "603", "ایجاد فعالیت", "2023-05-03 14:39:11", "2023-05-03 14:39:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("1786", "603", "عملیات توسط WP Cron شروع شد", "2023-05-03 14:40:45", "2023-05-03 14:40:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1787", "603", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-05-03 14:40:45", "2023-05-03 14:40:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1890", "638", "ایجاد فعالیت", "2023-05-23 16:53:42", "2023-05-23 16:53:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("1891", "638", "عملیات توسط WP Cron شروع شد", "2023-05-23 16:54:43", "2023-05-23 16:54:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("1892", "638", "اقدام از طریق WP Cron انجام نشد: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.", "2023-05-23 16:54:43", "2023-05-23 16:54:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("1905", "643", "ایجاد فعالیت", "2023-05-27 01:43:37", "2023-05-27 01:43:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1906", "643", "عملیات توسط Async Request شروع شد", "2023-05-27 01:44:43", "2023-05-27 01:44:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("1907", "643", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-05-27 01:44:43", "2023-05-27 01:44:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("2244", "756", "ایجاد فعالیت", "2023-09-09 13:18:38", "2023-09-09 13:18:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("2245", "756", "عملیات توسط Async Request شروع شد", "2023-09-09 13:36:06", "2023-09-09 13:36:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("2246", "756", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-09-09 13:36:06", "2023-09-09 13:36:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("2379", "802", "ایجاد فعالیت", "2023-09-10 07:18:41", "2023-09-10 07:18:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2413", "802", "عملیات توسط Async Request شروع شد", "2023-09-10 07:20:20", "2023-09-10 07:20:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2414", "802", "اقدام از طریق Async Request انجام نشد: Scheduled action for rocket_preload_job_check_finished will not be executed as no callbacks are registered.", "2023-09-10 07:20:20", "2023-09-10 07:20:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("9977", "3334", "ایجاد فعالیت", "2023-12-25 12:06:58", "2023-12-25 12:06:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("9978", "3334", "عملیات توسط WP Cron شروع شد", "2023-12-25 12:15:53", "2023-12-25 12:15:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("9979", "3334", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-12-25 12:15:53", "2023-12-25 12:15:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("11327", "3784", "ایجاد فعالیت", "2024-01-17 05:55:22", "2024-01-17 05:55:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("11328", "3784", "عملیات توسط WP Cron شروع شد", "2024-01-17 05:56:27", "2024-01-17 05:56:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("11329", "3784", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-01-17 05:56:27", "2024-01-17 05:56:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("12197", "4074", "ایجاد فعالیت", "2024-02-04 21:27:24", "2024-02-04 21:27:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("12198", "4074", "عملیات توسط WP Cron شروع شد", "2024-02-04 21:28:24", "2024-02-04 21:28:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("12199", "4074", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-02-04 21:28:24", "2024-02-04 21:28:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("19769", "6598", "ایجاد فعالیت", "2024-05-18 13:31:58", "2024-05-18 13:31:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("19770", "6598", "عملیات توسط WP Cron شروع شد", "2024-05-18 13:33:59", "2024-05-18 13:33:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("19771", "6598", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-05-18 13:33:59", "2024-05-18 13:33:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("21761", "7262", "ایجاد فعالیت", "2024-06-16 13:54:10", "2024-06-16 13:54:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("21762", "7262", "عملیات توسط WP Cron شروع شد", "2024-06-16 13:55:19", "2024-06-16 13:55:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("21763", "7262", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-06-16 13:55:19", "2024-06-16 13:55:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("22100", "7375", "ایجاد فعالیت", "2024-08-05 05:44:06", "2024-08-05 05:44:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("22101", "7375", "عملیات توسط Async Request شروع شد", "2024-08-05 05:45:10", "2024-08-05 05:45:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("22102", "7375", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-08-05 05:45:10", "2024-08-05 05:45:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("31078", "10367", "ایجاد فعالیت", "2024-11-25 11:03:33", "2024-11-25 11:03:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("31079", "10367", "عملیات توسط WP Cron شروع شد", "2024-11-26 11:03:46", "2024-11-26 11:03:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("31080", "10367", "عملیات توسط WP Cron کامل شد", "2024-11-26 11:03:46", "2024-11-26 11:03:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("31081", "10368", "ایجاد فعالیت", "2024-11-26 11:03:46", "2024-11-26 11:03:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("31082", "10368", "عملیات توسط WP Cron شروع شد", "2024-11-27 11:04:28", "2024-11-27 11:04:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31083", "10368", "عملیات توسط WP Cron کامل شد", "2024-11-27 11:04:28", "2024-11-27 11:04:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31084", "10369", "ایجاد فعالیت", "2024-11-27 11:04:28", "2024-11-27 11:04:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31085", "10370", "ایجاد فعالیت", "2024-11-27 17:52:42", "2024-11-27 17:52:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("31086", "10371", "ایجاد فعالیت", "2024-11-27 17:52:50", "2024-11-27 17:52:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("31087", "10370", "عملیات توسط Async Request شروع شد", "2024-11-27 17:52:52", "2024-11-27 17:52:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("31088", "10370", "عملیات توسط Async Request کامل شد", "2024-11-27 17:52:52", "2024-11-27 17:52:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("31089", "10371", "عملیات توسط Async Request شروع شد", "2024-11-27 17:52:52", "2024-11-27 17:52:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("31090", "10371", "عملیات توسط Async Request کامل شد", "2024-11-27 17:52:52", "2024-11-27 17:52:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("31091", "10369", "عملیات توسط WP Cron شروع شد", "2024-11-28 11:05:18", "2024-11-28 11:05:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("31092", "10369", "عملیات توسط WP Cron کامل شد", "2024-11-28 11:05:18", "2024-11-28 11:05:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("31093", "10372", "ایجاد فعالیت", "2024-11-28 11:05:18", "2024-11-28 11:05:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("31094", "10372", "عملیات توسط WP Cron شروع شد", "2024-11-29 11:05:28", "2024-11-29 11:05:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31095", "10372", "عملیات توسط WP Cron کامل شد", "2024-11-29 11:05:28", "2024-11-29 11:05:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31096", "10373", "ایجاد فعالیت", "2024-11-29 11:05:28", "2024-11-29 11:05:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31097", "10373", "عملیات توسط WP Cron شروع شد", "2024-11-30 11:05:58", "2024-11-30 11:05:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("31098", "10373", "عملیات توسط WP Cron کامل شد", "2024-11-30 11:05:58", "2024-11-30 11:05:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("31099", "10374", "ایجاد فعالیت", "2024-11-30 11:05:58", "2024-11-30 11:05:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("31100", "10374", "عملیات توسط WP Cron شروع شد", "2024-12-01 11:06:31", "2024-12-01 11:06:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("31101", "10374", "عملیات توسط WP Cron کامل شد", "2024-12-01 11:06:31", "2024-12-01 11:06:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("31102", "10375", "ایجاد فعالیت", "2024-12-01 11:06:31", "2024-12-01 11:06:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("31103", "10375", "عملیات توسط WP Cron شروع شد", "2024-12-02 11:06:36", "2024-12-02 11:06:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("31104", "10375", "عملیات توسط WP Cron کامل شد", "2024-12-02 11:06:36", "2024-12-02 11:06:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("31105", "10376", "ایجاد فعالیت", "2024-12-02 11:06:36", "2024-12-02 11:06:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("31106", "10376", "عملیات توسط WP Cron شروع شد", "2024-12-03 11:06:46", "2024-12-03 11:06:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("31107", "10376", "عملیات توسط WP Cron کامل شد", "2024-12-03 11:06:46", "2024-12-03 11:06:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("31108", "10377", "ایجاد فعالیت", "2024-12-03 11:06:46", "2024-12-03 11:06:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("31109", "10377", "عملیات توسط WP Cron شروع شد", "2024-12-04 11:07:54", "2024-12-04 11:07:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("31110", "10377", "عملیات توسط WP Cron کامل شد", "2024-12-04 11:07:54", "2024-12-04 11:07:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("31111", "10378", "ایجاد فعالیت", "2024-12-04 11:07:54", "2024-12-04 11:07:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("31112", "10378", "عملیات توسط WP Cron شروع شد", "2024-12-05 11:08:29", "2024-12-05 11:08:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31113", "10378", "عملیات توسط WP Cron کامل شد", "2024-12-05 11:08:29", "2024-12-05 11:08:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31114", "10379", "ایجاد فعالیت", "2024-12-05 11:08:29", "2024-12-05 11:08:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31115", "10379", "عملیات توسط WP Cron شروع شد", "2024-12-06 11:08:51", "2024-12-06 11:08:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("31116", "10379", "عملیات توسط WP Cron کامل شد", "2024-12-06 11:08:51", "2024-12-06 11:08:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("31117", "10380", "ایجاد فعالیت", "2024-12-06 11:08:51", "2024-12-06 11:08:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("31118", "10380", "عملیات توسط WP Cron شروع شد", "2024-12-07 11:11:30", "2024-12-07 11:11:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("31119", "10380", "عملیات توسط WP Cron کامل شد", "2024-12-07 11:11:30", "2024-12-07 11:11:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("31120", "10381", "ایجاد فعالیت", "2024-12-07 11:11:30", "2024-12-07 11:11:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("31121", "10381", "عملیات توسط WP Cron شروع شد", "2024-12-08 11:11:45", "2024-12-08 11:11:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("31122", "10381", "عملیات توسط WP Cron کامل شد", "2024-12-08 11:11:45", "2024-12-08 11:11:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("31123", "10382", "ایجاد فعالیت", "2024-12-08 11:11:45", "2024-12-08 11:11:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("31124", "10383", "ایجاد فعالیت", "2024-12-08 17:01:21", "2024-12-08 17:01:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("31125", "10383", "عملیات توسط WP Cron شروع شد", "2024-12-08 17:01:27", "2024-12-08 17:01:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("31126", "10383", "عملیات توسط WP Cron کامل شد", "2024-12-08 17:01:27", "2024-12-08 17:01:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("31127", "10382", "عملیات توسط WP Cron شروع شد", "2024-12-09 11:12:39", "2024-12-09 11:12:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31128", "10382", "عملیات توسط WP Cron کامل شد", "2024-12-09 11:12:39", "2024-12-09 11:12:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31129", "10384", "ایجاد فعالیت", "2024-12-09 11:12:39", "2024-12-09 11:12:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31130", "10384", "عملیات توسط WP Cron شروع شد", "2024-12-10 11:14:23", "2024-12-10 11:14:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("31131", "10384", "عملیات توسط WP Cron کامل شد", "2024-12-10 11:14:23", "2024-12-10 11:14:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("31132", "10385", "ایجاد فعالیت", "2024-12-10 11:14:23", "2024-12-10 11:14:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("31133", "10385", "عملیات توسط WP Cron شروع شد", "2024-12-11 11:15:57", "2024-12-11 11:15:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("31134", "10385", "عملیات توسط WP Cron کامل شد", "2024-12-11 11:15:57", "2024-12-11 11:15:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("31135", "10386", "ایجاد فعالیت", "2024-12-11 11:15:57", "2024-12-11 11:15:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("31136", "10387", "ایجاد فعالیت", "2024-12-11 22:10:26", "2024-12-11 22:10:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("31137", "10387", "عملیات توسط WP Cron شروع شد", "2024-12-11 22:11:29", "2024-12-11 22:11:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31138", "10387", "عملیات توسط WP Cron کامل شد", "2024-12-11 22:11:29", "2024-12-11 22:11:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31139", "10388", "ایجاد فعالیت", "2024-12-12 08:01:24", "2024-12-12 08:01:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("31140", "10389", "ایجاد فعالیت", "2024-12-12 08:01:28", "2024-12-12 08:01:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("31141", "10388", "عملیات توسط WP Cron شروع شد", "2024-12-12 08:01:30", "2024-12-12 08:01:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("31142", "10388", "عملیات توسط WP Cron کامل شد", "2024-12-12 08:01:30", "2024-12-12 08:01:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("31143", "10389", "عملیات توسط WP Cron شروع شد", "2024-12-12 08:01:30", "2024-12-12 08:01:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("31144", "10389", "عملیات توسط WP Cron کامل شد", "2024-12-12 08:01:30", "2024-12-12 08:01:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("31145", "10386", "عملیات توسط WP Cron شروع شد", "2024-12-12 11:19:24", "2024-12-12 11:19:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("31146", "10386", "عملیات توسط WP Cron کامل شد", "2024-12-12 11:19:24", "2024-12-12 11:19:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("31147", "10390", "ایجاد فعالیت", "2024-12-12 11:19:24", "2024-12-12 11:19:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("31148", "10390", "عملیات توسط WP Cron شروع شد", "2024-12-13 11:20:50", "2024-12-13 11:20:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("31149", "10390", "عملیات توسط WP Cron کامل شد", "2024-12-13 11:20:50", "2024-12-13 11:20:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("31150", "10391", "ایجاد فعالیت", "2024-12-13 11:20:50", "2024-12-13 11:20:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("31151", "10391", "عملیات توسط WP Cron شروع شد", "2024-12-14 11:21:25", "2024-12-14 11:21:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("31152", "10391", "عملیات توسط WP Cron کامل شد", "2024-12-14 11:21:25", "2024-12-14 11:21:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("31153", "10392", "ایجاد فعالیت", "2024-12-14 11:21:25", "2024-12-14 11:21:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("31154", "10392", "عملیات توسط WP Cron شروع شد", "2024-12-15 11:23:10", "2024-12-15 11:23:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("31155", "10392", "عملیات توسط WP Cron کامل شد", "2024-12-15 11:23:10", "2024-12-15 11:23:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("31156", "10393", "ایجاد فعالیت", "2024-12-15 11:23:10", "2024-12-15 11:23:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("31157", "10393", "عملیات توسط WP Cron شروع شد", "2024-12-16 11:23:26", "2024-12-16 11:23:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("31158", "10393", "عملیات توسط WP Cron کامل شد", "2024-12-16 11:23:26", "2024-12-16 11:23:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("31159", "10394", "ایجاد فعالیت", "2024-12-16 11:23:26", "2024-12-16 11:23:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("31160", "10394", "عملیات توسط WP Cron شروع شد", "2024-12-17 11:23:50", "2024-12-17 11:23:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("31161", "10394", "عملیات توسط WP Cron کامل شد", "2024-12-17 11:23:50", "2024-12-17 11:23:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("31162", "10395", "ایجاد فعالیت", "2024-12-17 11:23:50", "2024-12-17 11:23:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("31163", "10395", "عملیات توسط WP Cron شروع شد", "2024-12-18 11:24:38", "2024-12-18 11:24:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("31164", "10395", "عملیات توسط WP Cron کامل شد", "2024-12-18 11:24:38", "2024-12-18 11:24:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("31165", "10396", "ایجاد فعالیت", "2024-12-18 11:24:38", "2024-12-18 11:24:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("31166", "10396", "عملیات توسط WP Cron شروع شد", "2024-12-19 11:24:39", "2024-12-19 11:24:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31167", "10396", "عملیات توسط WP Cron کامل شد", "2024-12-19 11:24:39", "2024-12-19 11:24:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31168", "10397", "ایجاد فعالیت", "2024-12-19 11:24:39", "2024-12-19 11:24:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("31169", "10397", "عملیات توسط WP Cron شروع شد", "2024-12-20 11:25:40", "2024-12-20 11:25:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("31170", "10397", "عملیات توسط WP Cron کامل شد", "2024-12-20 11:25:40", "2024-12-20 11:25:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("31171", "10398", "ایجاد فعالیت", "2024-12-20 11:25:40", "2024-12-20 11:25:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("31172", "10398", "عملیات توسط WP Cron شروع شد", "2024-12-21 11:26:29", "2024-12-21 11:26:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31173", "10398", "عملیات توسط WP Cron کامل شد", "2024-12-21 11:26:29", "2024-12-21 11:26:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31174", "10399", "ایجاد فعالیت", "2024-12-21 11:26:29", "2024-12-21 11:26:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31175", "10399", "عملیات توسط WP Cron شروع شد", "2024-12-22 11:26:29", "2024-12-22 11:26:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31176", "10399", "عملیات توسط WP Cron کامل شد", "2024-12-22 11:26:29", "2024-12-22 11:26:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31177", "10400", "ایجاد فعالیت", "2024-12-22 11:26:29", "2024-12-22 11:26:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("31178", "10400", "عملیات توسط WP Cron شروع شد", "2024-12-23 11:27:43", "2024-12-23 11:27:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("31179", "10400", "عملیات توسط WP Cron کامل شد", "2024-12-23 11:27:43", "2024-12-23 11:27:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("31180", "10401", "ایجاد فعالیت", "2024-12-23 11:27:43", "2024-12-23 11:27:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("31181", "10401", "عملیات توسط WP Cron شروع شد", "2024-12-24 11:27:49", "2024-12-24 11:27:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("31182", "10401", "عملیات توسط WP Cron کامل شد", "2024-12-24 11:27:49", "2024-12-24 11:27:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("31183", "10402", "ایجاد فعالیت", "2024-12-24 11:27:49", "2024-12-24 11:27:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("31184", "10402", "عملیات توسط WP Cron شروع شد", "2024-12-25 11:27:55", "2024-12-25 11:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("31185", "10402", "عملیات توسط WP Cron کامل شد", "2024-12-25 11:27:55", "2024-12-25 11:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("31186", "10403", "ایجاد فعالیت", "2024-12-25 11:27:55", "2024-12-25 11:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("31187", "10404", "ایجاد فعالیت", "2024-12-25 21:35:37", "2024-12-25 21:35:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("31188", "10405", "ایجاد فعالیت", "2024-12-25 21:35:45", "2024-12-25 21:35:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("31189", "10404", "عملیات توسط Async Request شروع شد", "2024-12-25 21:36:12", "2024-12-25 21:36:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("31190", "10404", "عملیات توسط Async Request کامل شد", "2024-12-25 21:36:12", "2024-12-25 21:36:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("31191", "10405", "عملیات توسط Async Request شروع شد", "2024-12-25 21:36:12", "2024-12-25 21:36:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("31192", "10405", "عملیات توسط Async Request کامل شد", "2024-12-25 21:36:12", "2024-12-25 21:36:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("31193", "10406", "ایجاد فعالیت", "2024-12-25 21:36:33", "2024-12-25 21:36:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("31194", "10407", "ایجاد فعالیت", "2024-12-25 21:36:33", "2024-12-25 21:36:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("31195", "10408", "ایجاد فعالیت", "2024-12-25 21:36:33", "2024-12-25 21:36:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("31196", "10409", "ایجاد فعالیت", "2024-12-25 21:36:33", "2024-12-25 21:36:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("31197", "10410", "ایجاد فعالیت", "2024-12-25 21:36:33", "2024-12-25 21:36:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("31198", "10411", "ایجاد فعالیت", "2024-12-25 21:36:33", "2024-12-25 21:36:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("31199", "10412", "ایجاد فعالیت", "2024-12-25 21:36:33", "2024-12-25 21:36:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("31200", "10413", "ایجاد فعالیت", "2024-12-25 21:37:04", "2024-12-25 21:37:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("31201", "10414", "ایجاد فعالیت", "2024-12-25 21:37:04", "2024-12-25 21:37:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("31202", "10415", "ایجاد فعالیت", "2024-12-25 21:37:04", "2024-12-25 21:37:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("31203", "10416", "ایجاد فعالیت", "2024-12-25 21:37:04", "2024-12-25 21:37:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("31204", "10417", "ایجاد فعالیت", "2024-12-25 21:37:04", "2024-12-25 21:37:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("31205", "10418", "ایجاد فعالیت", "2024-12-25 21:37:04", "2024-12-25 21:37:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("31206", "10419", "ایجاد فعالیت", "2024-12-25 21:37:05", "2024-12-25 21:37:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("31207", "10420", "ایجاد فعالیت", "2024-12-25 21:37:05", "2024-12-25 21:37:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("31208", "10421", "ایجاد فعالیت", "2024-12-25 21:37:05", "2024-12-25 21:37:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("31209", "10422", "ایجاد فعالیت", "2024-12-25 21:37:05", "2024-12-25 21:37:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("31210", "10423", "ایجاد فعالیت", "2024-12-25 21:37:05", "2024-12-25 21:37:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("31211", "10424", "ایجاد فعالیت", "2024-12-25 21:37:05", "2024-12-25 21:37:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("31212", "10406", "عملیات توسط Async Request شروع شد", "2024-12-25 21:37:18", "2024-12-25 21:37:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("31213", "10406", "عملیات توسط Async Request کامل شد", "2024-12-25 21:37:18", "2024-12-25 21:37:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("31214", "10407", "عملیات توسط Async Request شروع شد", "2024-12-25 21:37:18", "2024-12-25 21:37:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("31215", "10407", "عملیات توسط Async Request کامل شد", "2024-12-25 21:37:18", "2024-12-25 21:37:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("31216", "10408", "عملیات توسط Async Request شروع شد", "2024-12-25 21:37:18", "2024-12-25 21:37:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("31217", "10408", "عملیات توسط Async Request کامل شد", "2024-12-25 21:37:18", "2024-12-25 21:37:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("31218", "10409", "عملیات توسط Async Request شروع شد", "2024-12-25 21:37:18", "2024-12-25 21:37:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("31219", "10409", "عملیات توسط Async Request کامل شد", "2024-12-25 21:37:18", "2024-12-25 21:37:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("31220", "10410", "عملیات توسط Async Request شروع شد", "2024-12-25 21:37:18", "2024-12-25 21:37:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("31221", "10410", "عملیات توسط Async Request کامل شد", "2024-12-25 21:37:18", "2024-12-25 21:37:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("31222", "10411", "عملیات توسط Async Request شروع شد", "2024-12-25 21:37:18", "2024-12-25 21:37:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("31223", "10411", "عملیات توسط Async Request کامل شد", "2024-12-25 21:37:18", "2024-12-25 21:37:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("31224", "10412", "عملیات توسط Async Request شروع شد", "2024-12-25 21:37:18", "2024-12-25 21:37:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("31225", "10412", "عملیات توسط Async Request کامل شد", "2024-12-25 21:37:18", "2024-12-25 21:37:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("31226", "10413", "عملیات توسط Async Request شروع شد", "2024-12-25 21:37:18", "2024-12-25 21:37:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("31227", "10413", "عملیات توسط Async Request کامل شد", "2024-12-25 21:37:18", "2024-12-25 21:37:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("31228", "10414", "عملیات توسط Async Request شروع شد", "2024-12-25 21:37:18", "2024-12-25 21:37:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("31229", "10414", "عملیات توسط Async Request کامل شد", "2024-12-25 21:37:18", "2024-12-25 21:37:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("31230", "10419", "عملیات توسط Async Request شروع شد", "2024-12-25 21:37:18", "2024-12-25 21:37:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("31231", "10419", "عملیات توسط Async Request کامل شد", "2024-12-25 21:37:18", "2024-12-25 21:37:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("31232", "10415", "عملیات توسط Async Request شروع شد", "2024-12-25 21:37:18", "2024-12-25 21:37:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("31233", "10415", "عملیات توسط Async Request کامل شد", "2024-12-25 21:37:19", "2024-12-25 21:37:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31234", "10420", "عملیات توسط Async Request شروع شد", "2024-12-25 21:37:19", "2024-12-25 21:37:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31235", "10420", "عملیات توسط Async Request کامل شد", "2024-12-25 21:37:19", "2024-12-25 21:37:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31236", "10416", "عملیات توسط Async Request شروع شد", "2024-12-25 21:37:19", "2024-12-25 21:37:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31237", "10416", "عملیات توسط Async Request کامل شد", "2024-12-25 21:37:19", "2024-12-25 21:37:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31238", "10421", "عملیات توسط Async Request شروع شد", "2024-12-25 21:37:19", "2024-12-25 21:37:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31239", "10421", "عملیات توسط Async Request کامل شد", "2024-12-25 21:37:19", "2024-12-25 21:37:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31240", "10417", "عملیات توسط Async Request شروع شد", "2024-12-25 21:37:19", "2024-12-25 21:37:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31241", "10417", "عملیات توسط Async Request کامل شد", "2024-12-25 21:37:19", "2024-12-25 21:37:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31242", "10422", "عملیات توسط Async Request شروع شد", "2024-12-25 21:37:19", "2024-12-25 21:37:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31243", "10422", "عملیات توسط Async Request کامل شد", "2024-12-25 21:37:19", "2024-12-25 21:37:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31244", "10418", "عملیات توسط Async Request شروع شد", "2024-12-25 21:37:19", "2024-12-25 21:37:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31245", "10418", "عملیات توسط Async Request کامل شد", "2024-12-25 21:37:19", "2024-12-25 21:37:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31246", "10423", "عملیات توسط Async Request شروع شد", "2024-12-25 21:37:19", "2024-12-25 21:37:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31247", "10423", "عملیات توسط Async Request کامل شد", "2024-12-25 21:37:19", "2024-12-25 21:37:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31248", "10424", "عملیات توسط Async Request شروع شد", "2024-12-25 21:37:19", "2024-12-25 21:37:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31249", "10424", "عملیات توسط Async Request کامل شد", "2024-12-25 21:37:19", "2024-12-25 21:37:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("31250", "10403", "عملیات توسط WP Cron شروع شد", "2024-12-26 11:28:15", "2024-12-26 11:28:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("31251", "10403", "عملیات توسط WP Cron کامل شد", "2024-12-26 11:28:15", "2024-12-26 11:28:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("31252", "10425", "ایجاد فعالیت", "2024-12-26 11:28:15", "2024-12-26 11:28:15");

/* INSERT TABLE DATA: wp_commentmeta */
INSERT INTO `wp_commentmeta` VALUES("1", "2", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("2", "2", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("3", "2", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("4", "2", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("5", "2", "wd_total_vote", "0");
INSERT INTO `wp_commentmeta` VALUES("6", "3", "rating", "4");
INSERT INTO `wp_commentmeta` VALUES("7", "3", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("8", "3", "wd_likes", "1");
INSERT INTO `wp_commentmeta` VALUES("9", "3", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("10", "3", "wd_total_vote", "1");
INSERT INTO `wp_commentmeta` VALUES("11", "3", "_woodmart_image_id", "");
INSERT INTO `wp_commentmeta` VALUES("12", "3", "wd_pros", "");
INSERT INTO `wp_commentmeta` VALUES("13", "3", "wd_cons", "");
INSERT INTO `wp_commentmeta` VALUES("14", "4", "rating", "3");
INSERT INTO `wp_commentmeta` VALUES("15", "4", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("16", "4", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("17", "4", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("18", "4", "wd_total_vote", "0");
INSERT INTO `wp_commentmeta` VALUES("19", "4", "_woodmart_image_id", "");
INSERT INTO `wp_commentmeta` VALUES("20", "4", "wd_pros", "");
INSERT INTO `wp_commentmeta` VALUES("21", "4", "wd_cons", "");
INSERT INTO `wp_commentmeta` VALUES("22", "5", "rating", "3");
INSERT INTO `wp_commentmeta` VALUES("23", "5", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("24", "5", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("25", "5", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("26", "5", "wd_total_vote", "0");
INSERT INTO `wp_commentmeta` VALUES("27", "5", "_woodmart_image_id", "");
INSERT INTO `wp_commentmeta` VALUES("28", "5", "wd_pros", "");
INSERT INTO `wp_commentmeta` VALUES("29", "5", "wd_cons", "");
INSERT INTO `wp_commentmeta` VALUES("30", "6", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("31", "6", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("32", "6", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("33", "6", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("34", "6", "wd_total_vote", "0");
INSERT INTO `wp_commentmeta` VALUES("35", "6", "_woodmart_image_id", "");
INSERT INTO `wp_commentmeta` VALUES("36", "6", "wd_pros", "");
INSERT INTO `wp_commentmeta` VALUES("37", "6", "wd_cons", "");
INSERT INTO `wp_commentmeta` VALUES("38", "7", "rating", "2");
INSERT INTO `wp_commentmeta` VALUES("39", "7", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("40", "7", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("41", "7", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("42", "7", "wd_total_vote", "0");
INSERT INTO `wp_commentmeta` VALUES("43", "7", "_woodmart_image_id", "");
INSERT INTO `wp_commentmeta` VALUES("44", "7", "wd_pros", "");
INSERT INTO `wp_commentmeta` VALUES("45", "7", "wd_cons", "");
INSERT INTO `wp_commentmeta` VALUES("46", "8", "rating", "4");
INSERT INTO `wp_commentmeta` VALUES("47", "8", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("48", "8", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("49", "8", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("50", "8", "wd_total_vote", "0");
INSERT INTO `wp_commentmeta` VALUES("51", "8", "_woodmart_image_id", "");
INSERT INTO `wp_commentmeta` VALUES("52", "8", "wd_pros", "");
INSERT INTO `wp_commentmeta` VALUES("53", "8", "wd_cons", "");
INSERT INTO `wp_commentmeta` VALUES("54", "9", "rating", "3");
INSERT INTO `wp_commentmeta` VALUES("55", "9", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("56", "9", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("57", "9", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("58", "9", "wd_total_vote", "0");
INSERT INTO `wp_commentmeta` VALUES("59", "9", "_woodmart_image_id", "");
INSERT INTO `wp_commentmeta` VALUES("60", "9", "wd_pros", "");
INSERT INTO `wp_commentmeta` VALUES("61", "9", "wd_cons", "");
INSERT INTO `wp_commentmeta` VALUES("62", "10", "rating", "3");
INSERT INTO `wp_commentmeta` VALUES("63", "10", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("64", "10", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("65", "10", "wd_dislikes", "1");
INSERT INTO `wp_commentmeta` VALUES("66", "10", "wd_total_vote", "1");
INSERT INTO `wp_commentmeta` VALUES("67", "10", "_woodmart_image_id", "");
INSERT INTO `wp_commentmeta` VALUES("68", "10", "wd_pros", "");
INSERT INTO `wp_commentmeta` VALUES("69", "10", "wd_cons", "");
INSERT INTO `wp_commentmeta` VALUES("70", "11", "rating", "2");
INSERT INTO `wp_commentmeta` VALUES("71", "11", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("72", "11", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("73", "11", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("74", "11", "wd_total_vote", "0");
INSERT INTO `wp_commentmeta` VALUES("75", "11", "_woodmart_image_id", "");
INSERT INTO `wp_commentmeta` VALUES("76", "11", "wd_pros", "");
INSERT INTO `wp_commentmeta` VALUES("77", "11", "wd_cons", "");
INSERT INTO `wp_commentmeta` VALUES("78", "12", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("79", "12", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("80", "12", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("81", "12", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("82", "12", "wd_total_vote", "0");
INSERT INTO `wp_commentmeta` VALUES("83", "12", "_woodmart_image_id", "");
INSERT INTO `wp_commentmeta` VALUES("84", "12", "wd_pros", "");
INSERT INTO `wp_commentmeta` VALUES("85", "12", "wd_cons", "");
INSERT INTO `wp_commentmeta` VALUES("86", "13", "rating", "3");
INSERT INTO `wp_commentmeta` VALUES("87", "13", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("88", "13", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("89", "13", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("90", "13", "wd_total_vote", "0");
INSERT INTO `wp_commentmeta` VALUES("91", "13", "_woodmart_image_id", "");
INSERT INTO `wp_commentmeta` VALUES("92", "13", "wd_pros", "");
INSERT INTO `wp_commentmeta` VALUES("93", "13", "wd_cons", "");
INSERT INTO `wp_commentmeta` VALUES("101", "16", "rating", "2");
INSERT INTO `wp_commentmeta` VALUES("102", "16", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("103", "16", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("104", "16", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("105", "16", "wd_total_vote", "0");
INSERT INTO `wp_commentmeta` VALUES("106", "16", "wd_pros", "hihi");
INSERT INTO `wp_commentmeta` VALUES("107", "16", "wd_cons", "chili");
INSERT INTO `wp_commentmeta` VALUES("108", "17", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("109", "17", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("110", "17", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("111", "17", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("112", "17", "wd_total_vote", "0");
INSERT INTO `wp_commentmeta` VALUES("113", "17", "wd_pros", "ببالتتا");
INSERT INTO `wp_commentmeta` VALUES("114", "17", "wd_cons", "لبیبلذ");
INSERT INTO `wp_commentmeta` VALUES("115", "3", "wd_vote", "a:1:{i:246;s:4:\"like\";}");
INSERT INTO `wp_commentmeta` VALUES("116", "10", "wd_vote", "a:1:{i:246;s:7:\"dislike\";}");
INSERT INTO `wp_commentmeta` VALUES("117", "22", "rating", "3");
INSERT INTO `wp_commentmeta` VALUES("118", "22", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("119", "22", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("120", "22", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("121", "22", "wd_total_vote", "0");
INSERT INTO `wp_commentmeta` VALUES("122", "22", "wd_pros", "گوشت");
INSERT INTO `wp_commentmeta` VALUES("123", "22", "wd_cons", "گوه");
INSERT INTO `wp_commentmeta` VALUES("124", "23", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("125", "23", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("126", "23", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("127", "23", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("128", "23", "wd_total_vote", "0");
INSERT INTO `wp_commentmeta` VALUES("129", "23", "wd_pros", "dgsdgdf");
INSERT INTO `wp_commentmeta` VALUES("130", "23", "wd_cons", "sf");
INSERT INTO `wp_commentmeta` VALUES("131", "24", "rating", "4");
INSERT INTO `wp_commentmeta` VALUES("132", "24", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("133", "24", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("134", "24", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("135", "24", "wd_total_vote", "0");
INSERT INTO `wp_commentmeta` VALUES("136", "24", "wd_pros", "");
INSERT INTO `wp_commentmeta` VALUES("137", "24", "wd_cons", "");
INSERT INTO `wp_commentmeta` VALUES("138", "28", "rating", "2");
INSERT INTO `wp_commentmeta` VALUES("139", "28", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("140", "28", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("141", "28", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("142", "28", "wd_total_vote", "0");
INSERT INTO `wp_commentmeta` VALUES("143", "28", "wd_pros", "KennethReilt");
INSERT INTO `wp_commentmeta` VALUES("144", "28", "wd_cons", "KennethReilt");
INSERT INTO `wp_commentmeta` VALUES("145", "47", "rating", "2");
INSERT INTO `wp_commentmeta` VALUES("146", "47", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("147", "47", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("148", "47", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("149", "47", "wd_total_vote", "0");
INSERT INTO `wp_commentmeta` VALUES("150", "47", "wd_pros", "DevinSox");
INSERT INTO `wp_commentmeta` VALUES("151", "47", "wd_cons", "DevinSox");
INSERT INTO `wp_commentmeta` VALUES("152", "48", "rating", "4");
INSERT INTO `wp_commentmeta` VALUES("153", "48", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("154", "48", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("155", "48", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("156", "48", "wd_total_vote", "0");
INSERT INTO `wp_commentmeta` VALUES("157", "48", "wd_pros", "DevinSox");
INSERT INTO `wp_commentmeta` VALUES("158", "48", "wd_cons", "DevinSox");
INSERT INTO `wp_commentmeta` VALUES("159", "49", "rating", "4");
INSERT INTO `wp_commentmeta` VALUES("160", "49", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("161", "49", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("162", "49", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("163", "49", "wd_total_vote", "0");
INSERT INTO `wp_commentmeta` VALUES("164", "49", "wd_pros", "DevinSox");
INSERT INTO `wp_commentmeta` VALUES("165", "49", "wd_cons", "DevinSox");
INSERT INTO `wp_commentmeta` VALUES("166", "56", "rating", "1");
INSERT INTO `wp_commentmeta` VALUES("167", "56", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("168", "56", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("169", "56", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("170", "56", "wd_total_vote", "0");
INSERT INTO `wp_commentmeta` VALUES("171", "56", "wd_pros", "Nickben");
INSERT INTO `wp_commentmeta` VALUES("172", "56", "wd_cons", "Nickben");
INSERT INTO `wp_commentmeta` VALUES("173", "60", "rating", "3");
INSERT INTO `wp_commentmeta` VALUES("174", "60", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("175", "60", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("176", "60", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("177", "60", "wd_total_vote", "0");
INSERT INTO `wp_commentmeta` VALUES("178", "60", "wd_pros", "NatashaHenstrichi");
INSERT INTO `wp_commentmeta` VALUES("179", "60", "wd_cons", "NatashaHenstrichi");
INSERT INTO `wp_commentmeta` VALUES("180", "64", "rating", "2");
INSERT INTO `wp_commentmeta` VALUES("181", "64", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("182", "64", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("183", "64", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("184", "64", "wd_total_vote", "0");
INSERT INTO `wp_commentmeta` VALUES("185", "64", "wd_pros", "RomanSEOman");
INSERT INTO `wp_commentmeta` VALUES("186", "64", "wd_cons", "RomanSEOman");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("2", "215", "tarah", "mohammadizm620@gmail.com", "", "188.211.36.44", "2023-03-09 15:25:03", "2023-03-09 11:55:03", "این یک متن امتحانی است.", "0", "1", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/110.0.0.0 Safari/537.36 Edg/110.0.1587.63", "review", "0", "2");
INSERT INTO `wp_comments` VALUES("3", "185", "tarah", "mohammadizm620@gmail.com", "", "5.211.122.152", "2023-03-14 09:20:09", "2023-03-14 05:50:09", "این یک متن امتحانی است.", "0", "1", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/110.0.0.0 Safari/537.36 Edg/110.0.1587.69", "review", "0", "2");
INSERT INTO `wp_comments` VALUES("4", "180", "tarah", "mohammadizm620@gmail.com", "", "5.211.122.152", "2023-03-14 09:33:15", "2023-03-14 06:03:15", "این یک متن امتحانی است.", "0", "1", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/110.0.0.0 Safari/537.36 Edg/110.0.1587.69", "review", "0", "2");
INSERT INTO `wp_comments` VALUES("5", "195", "tarah", "mohammadizm620@gmail.com", "", "5.211.122.152", "2023-03-14 09:34:05", "2023-03-14 06:04:05", "این یک متن امتحانی است.", "0", "1", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/110.0.0.0 Safari/537.36 Edg/110.0.1587.69", "review", "0", "2");
INSERT INTO `wp_comments` VALUES("6", "205", "tarah", "mohammadizm620@gmail.com", "", "5.211.122.152", "2023-03-14 09:34:43", "2023-03-14 06:04:43", "این یک متن امتحانی است.", "0", "1", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/110.0.0.0 Safari/537.36 Edg/110.0.1587.69", "review", "0", "2");
INSERT INTO `wp_comments` VALUES("7", "210", "tarah", "mohammadizm620@gmail.com", "", "5.211.122.152", "2023-03-14 09:35:10", "2023-03-14 06:05:10", "این یک متن امتحانی است.", "0", "1", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/110.0.0.0 Safari/537.36 Edg/110.0.1587.69", "review", "0", "2");
INSERT INTO `wp_comments` VALUES("8", "200", "tarah", "mohammadizm620@gmail.com", "", "5.211.122.152", "2023-03-14 09:35:58", "2023-03-14 06:05:58", "این یک متن امتحانی است.", "0", "1", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/110.0.0.0 Safari/537.36 Edg/110.0.1587.69", "review", "0", "2");
INSERT INTO `wp_comments` VALUES("9", "190", "tarah", "mohammadizm620@gmail.com", "", "5.211.122.152", "2023-03-14 09:46:01", "2023-03-14 06:16:01", "این یک متن امتحانی است.", "0", "1", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/110.0.0.0 Safari/537.36 Edg/110.0.1587.69", "review", "0", "2");
INSERT INTO `wp_comments` VALUES("10", "170", "tarah", "mohammadizm620@gmail.com", "", "5.211.122.152", "2023-03-14 09:47:07", "2023-03-14 06:17:07", "این یک متن امتحانی است.", "0", "1", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/110.0.0.0 Safari/537.36 Edg/110.0.1587.69", "review", "0", "2");
INSERT INTO `wp_comments` VALUES("11", "175", "tarah", "mohammadizm620@gmail.com", "", "5.211.122.152", "2023-03-14 09:48:15", "2023-03-14 06:18:15", "این یک متن امتحانی است.", "0", "1", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/110.0.0.0 Safari/537.36 Edg/110.0.1587.69", "review", "0", "2");
INSERT INTO `wp_comments` VALUES("12", "147", "tarah", "mohammadizm620@gmail.com", "", "5.211.122.152", "2023-03-14 09:49:10", "2023-03-14 06:19:10", "این یک متن امتحانی است.", "0", "1", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/110.0.0.0 Safari/537.36 Edg/110.0.1587.69", "review", "0", "2");
INSERT INTO `wp_comments` VALUES("13", "165", "tarah", "mohammadizm620@gmail.com", "", "5.211.122.152", "2023-03-14 09:49:48", "2023-03-14 06:19:48", "این یک متن امتحانی است.", "0", "1", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/110.0.0.0 Safari/537.36 Edg/110.0.1587.69", "review", "0", "2");
INSERT INTO `wp_comments` VALUES("15", "412", "حسین اسماعیلیان", "nextaopooo@gmail.com", "", "89.199.114.142", "2023-10-08 17:57:32", "2023-10-08 14:27:32", "تست دیدگاه گذاری", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/117.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("16", "185", "j", "j@yahoo.com", "", "185.214.97.119", "2024-01-20 17:24:20", "2024-01-20 13:54:20", "kheili tokhmie", "0", "0", "Mozilla/5.0 (Macintosh; Intel Mac OS X 10_15_7) AppleWebKit/605.1.15 (KHTML, like Gecko) Version/17.2.1 Safari/605.1.15", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("17", "170", "اتا", "ata@rrr.mmm", "", "5.232.10.133", "2024-05-28 18:42:38", "2024-05-28 15:12:38", "تست", "0", "0", "Mozilla/5.0 (X11; Linux x86_64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/125.0.0.0 Safari/537.36", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("18", "412", "علی علاوی", "shame2@gmail.com", "", "5.214.44.203", "2024-07-29 11:05:17", "2024-07-29 07:35:17", "هله والله", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("19", "9010", "ووکامرس", "", "", "", "2024-08-16 10:38:41", "2024-08-16 07:08:41", "نگهداری سهام 60 دقیقه روی <br>- تلویزیون دوو ۸۰ اینچ (#180) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("20", "9010", "ووکامرس", "", "", "", "2024-08-16 10:38:41", "2024-08-16 07:08:41", "سطح موجودی کاهش یافت: تلویزیون دوو ۸۰ اینچ (#180) 5&rarr;4", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("21", "9010", "ووکامرس", "", "", "", "2024-08-16 10:38:41", "2024-08-16 07:08:41", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("22", "185", "کصشر", "cdcwerfwefsdfwef@gamil.com", "", "5.208.36.226", "2024-08-28 11:41:20", "2024-08-28 08:11:20", "بد نیست", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/128.0.0.0 Safari/537.36", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("23", "205", "sdgsdgsdg", "sadeghjalali1751@gmail.com", "", "5.126.153.245", "2024-08-30 12:23:37", "2024-08-30 08:53:37", "sdgvzfcgbf", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("24", "175", "Dorie", "doriemontanez@att.net", "", "212.102.36.181", "2024-09-06 09:23:54", "2024-09-06 05:53:54", "I couldd nott resist commenting. Exceptionally well written!\r\n\r\nFeeel free to surf to mmy blog - <a href=\"https://pornfaphub.com/sitemap11.xml\" rel=\"nofollow ugc\">sitemap</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/114.0.0.0 Safari/537.36", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("25", "9037", "ووکامرس", "", "", "", "2024-09-28 17:50:49", "2024-09-28 14:20:49", "نگهداری سهام 60 دقیقه روی <br>- تلویزیون دوو ۸۰ اینچ (#180) &times; 1<br>- هدفون انکر مدل ۱ (#170) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("26", "9037", "ووکامرس", "", "", "", "2024-09-28 17:50:49", "2024-09-28 14:20:49", "سطح موجودی کاهش یافت: تلویزیون دوو ۸۰ اینچ (#180) 4&rarr;3, هدفون انکر مدل ۱ (#170) 5&rarr;4", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("27", "9037", "ووکامرس", "", "", "", "2024-09-28 17:50:49", "2024-09-28 14:20:49", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("28", "185", "KennethReilt", "kennethnug@gmail.com", "", "65.108.13.173", "2024-09-28 19:27:49", "2024-09-28 15:57:49", "<a href=\"https://gogocasino.one\" rel=\"nofollow ugc\">https://gogocasino.one</a>", "0", "0", "Mozilla/5.0 (Windows NT 10.0.0; Win64; x64; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.6367.93 Chrome/124.0.6367.93 Not-A.Brand/99  Safari/537.36", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("29", "9040", "ووکامرس", "", "", "", "2024-09-30 03:11:51", "2024-09-29 23:41:51", "نگهداری سهام 60 دقیقه روی <br>- تلویزیون جی پلاس ۵۰ اینچ (#185) &times; 1<br>- تلویزیون دوو ۸۰ اینچ (#180) &times; 1<br>- کتاب بی حد و مرز (#195) &times; 1<br>- کتاب قدرت شروع ناقص (#200) &times; 1<br>- کتاب زندگی بیافرینید (#210) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("30", "9040", "ووکامرس", "", "", "", "2024-09-30 03:11:56", "2024-09-29 23:41:56", "سطح موجودی کاهش یافت: تلویزیون جی پلاس ۵۰ اینچ (#185) 15&rarr;14, تلویزیون دوو ۸۰ اینچ (#180) 3&rarr;2, کتاب بی حد و مرز (#195) 5&rarr;4, کتاب قدرت شروع ناقص (#200) 5&rarr;4, کتاب زندگی بیافرینید (#210) 5&rarr;4", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("31", "9040", "ووکامرس", "", "", "", "2024-09-30 03:11:56", "2024-09-29 23:41:56", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("32", "9041", "ووکامرس", "", "", "", "2024-10-02 16:57:34", "2024-10-02 13:27:34", "نگهداری سهام 60 دقیقه روی <br>- کتاب اوضاع خراب است - آبی (45131)<span class=\"description\"></span> &times; 1<br>- کتاب خرده عادت ها (#205) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("33", "9041", "ووکامرس", "", "", "", "2024-10-02 16:57:35", "2024-10-02 13:27:35", "سطح موجودی کاهش یافت: کتاب اوضاع خراب است - آبی (45131)<span class=\"description\"></span> 1&rarr;0, کتاب خرده عادت ها (#205) 5&rarr;4", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("34", "9041", "ووکامرس", "", "", "", "2024-10-02 16:57:35", "2024-10-02 13:27:35", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("35", "9042", "ووکامرس", "", "", "", "2024-10-05 02:13:53", "2024-10-04 22:43:53", "نگهداری سهام 60 دقیقه روی <br>- هدفون انکر مدل ۱ (#170) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("36", "9042", "ووکامرس", "", "", "", "2024-10-05 02:13:53", "2024-10-04 22:43:53", "سطح موجودی کاهش یافت: هدفون انکر مدل ۱ (#170) 4&rarr;3", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("37", "9042", "ووکامرس", "", "", "", "2024-10-05 02:13:53", "2024-10-04 22:43:53", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("38", "9055", "ووکامرس", "", "", "", "2024-10-12 01:06:45", "2024-10-11 21:36:45", "نگهداری سهام 60 دقیقه روی <br>- تلویزیون جی پلاس ۵۰ اینچ (#185) &times; 1<br>- تلویزیون دوو ۸۰ اینچ (#180) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("39", "9055", "ووکامرس", "", "", "", "2024-10-12 01:06:51", "2024-10-11 21:36:51", "سطح موجودی کاهش یافت: تلویزیون جی پلاس ۵۰ اینچ (#185) 14&rarr;13, تلویزیون دوو ۸۰ اینچ (#180) 2&rarr;1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("40", "9055", "ووکامرس", "", "", "", "2024-10-12 01:06:51", "2024-10-11 21:36:51", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("41", "9056", "ووکامرس", "", "", "", "2024-10-12 22:55:40", "2024-10-12 19:25:40", "نگهداری سهام 60 دقیقه روی <br>- کتاب بی حد و مرز (#195) &times; 1<br>- کتاب اوضاع خراب است - نارنجی (45131)<span class=\"description\"></span> &times; 1<br>- هدفون سونی مدل ۲ (#165) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("42", "9056", "ووکامرس", "", "", "", "2024-10-12 22:55:43", "2024-10-12 19:25:43", "سطح موجودی کاهش یافت: کتاب بی حد و مرز (#195) 4&rarr;3, کتاب اوضاع خراب است - نارنجی (45131)<span class=\"description\"></span> 1&rarr;0, هدفون سونی مدل ۲ (#165) 5&rarr;4", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("43", "9056", "ووکامرس", "", "", "", "2024-10-12 22:55:43", "2024-10-12 19:25:43", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("44", "9058", "ووکامرس", "", "", "", "2024-10-14 16:13:42", "2024-10-14 12:43:42", "نگهداری سهام 60 دقیقه روی <br>- تلویزیون دوو ۸۰ اینچ (#180) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("45", "9058", "ووکامرس", "", "", "", "2024-10-14 16:13:44", "2024-10-14 12:43:44", "سطح موجودی کاهش یافت: تلویزیون دوو ۸۰ اینچ (#180) 1&rarr;0", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("46", "9058", "ووکامرس", "", "", "", "2024-10-14 16:13:44", "2024-10-14 12:43:44", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("47", "185", "DevinSox", "xixuu8lj@2mailcache.com", "", "5.42.103.77", "2024-10-14 20:05:44", "2024-10-14 16:35:44", "Dating between men and women has evolved with technology and shifting gender roles, present more opportunities but also hip challenges. \r\nhttps://voyeurporn.one/\r\n \r\nThe Digital Gang \r\nOnline dating apps like Tinder and Bumble fantasize connecting easier but can have a astounding due to too innumerable choices. Women take gained more sway, such as initiating conversations on Bumble, reflecting broader gender equality. \r\n \r\nChallenges in Dating \r\nGhosting and Random Dating: Fleet exits and occasional encounters are customary, peerless to confusion. \r\nExpectations: Miscommunication about commitment can case frustration. \r\nConstraint: Social media creates delusional expectations of pronouncement the superlative partner. \r\nGender Stereotypes: Antique stereotypes in the matter of dating roles hushed stay alive, complicating things. \r\nKeys to Healthy Relationships \r\nhttps://asianxxx.one/\r\n \r\nCommunication: Roomy, honest conversations bod trust. \r\nAttend to and Similarity: Valuing each other as equals fosters balance. \r\nLeniency: Irresistible habits to set up connections reduces pressure. \r\nLooking At the \r\nAs dating continues to evolve with technology, the fundamentals of defer to, communication, and patience wait basic repayment for long-term relationships.", "0", "0", "Mozilla/5.0 (Windows NT 10.0.0; Win64; x64; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.6367.60 Chrome/124.0.6367.60 Not-A.Brand/99  Safari/537.36", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("48", "185", "DevinSox", "vfjht8ks@3way3.com", "", "5.42.103.77", "2024-10-14 22:54:08", "2024-10-14 19:24:08", "Dating between men and women has evolved with technology and shifting gender roles, present more opportunities but also different challenges. \r\nhttps://outdoorporn.one/\r\n \r\nThe Digital Gang \r\nOnline dating apps like Tinder and Bumble flourish connecting easier but can feel astounding satisfactory to too innumerable choices. Women take gained more charge, such as initiating conversations on Bumble, reflecting broader gender equality. \r\n \r\nChallenges in Dating \r\nGhosting and Random Dating: Quick exits and casual encounters are common, peerless to confusion. \r\nExpectations: Miscommunication about commitment can cause frustration. \r\nConstraint: Popular media creates unrealistic expectations of declaration the correct partner. \r\nGender Stereotypes: Bygone stereotypes round dating roles even so exist, complicating things. \r\nKeys to Healthful Relationships \r\nhttps://voyeurporn.one/\r\n \r\nCommunication: Unbarred, square conversations set up trust. \r\nVeneration and Congruence: Valuing each other as equals fosters balance. \r\nDiligence: Taking delay to establish connections reduces pressure. \r\nLooking Vanguard \r\nAs dating continues to evolve with technology, the fundamentals of veneration, communication, and patience wait basic in place of long-term relationships.", "0", "0", "Mozilla/5.0 (Windows NT 15.0.0; Win64; x64; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.6367.60 Chrome/124.0.6367.60 Not-A.Brand/99  Safari/537.36", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("49", "185", "DevinSox", "4mk2zqni@2mailcache.com", "", "5.42.103.77", "2024-10-25 00:14:34", "2024-10-24 20:44:34", "Dating between men and women has evolved with technology and shifting gender roles, present more opportunities but also new challenges. \r\nhttps://latinaporn.one/\r\n \r\nThe Digital Gang \r\nOnline dating apps like Tinder and Bumble make connecting easier but can feel irresistible well-earned to too multifarious choices. Women prepare gained more control, such as initiating conversations on Bumble, reflecting broader gender equality. \r\n \r\nChallenges in Dating \r\nGhosting and Random Dating: Far-sighted exits and unexpected encounters are customary, matchless to confusion. \r\nExpectations: Miscommunication far commitment can case frustration. \r\nPressure: Popular media creates unreasonable expectations of pronouncement the perfect partner. \r\nGender Stereotypes: Old stereotypes in the matter of dating roles silent exist, complicating things. \r\nKeys to Strong Relationships \r\nhttps://erhe.me/\r\n \r\nCommunication: Open, square conversations figure trust. \r\nRespect and Congruence: Valuing each other as equals fosters balance. \r\nPersistence: Irresistible time to establish connections reduces pressure. \r\nLooking Before \r\nAs dating continues to evolve with technology, the fundamentals of respect, communication, and tenacity remain basic in place of everlasting relationships.", "0", "0", "Mozilla/5.0 (Windows NT 10.0.0; Win64; x64; ) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.6367.63 Chrome/124.0.6367.63 Not-A.Brand/99  Safari/537.36", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("50", "9067", "ووکامرس", "", "", "", "2024-10-25 00:28:57", "2024-10-24 20:58:57", "نگهداری سهام 60 دقیقه روی <br>- تلویزیون جی پلاس ۵۰ اینچ (#185) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("51", "9067", "ووکامرس", "", "", "", "2024-10-25 00:28:57", "2024-10-24 20:58:57", "سطح موجودی کاهش یافت: تلویزیون جی پلاس ۵۰ اینچ (#185) 13&rarr;12", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("52", "9067", "ووکامرس", "", "", "", "2024-10-25 00:28:57", "2024-10-24 20:58:57", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("53", "9072", "ووکامرس", "", "", "", "2024-11-01 19:20:01", "2024-11-01 15:50:01", "نگهداری سهام 60 دقیقه روی <br>- تلویزیون جی پلاس ۵۰ اینچ (#185) &times; 1<br>- هدفون انکر مدل ۱ (#170) &times; 1<br>- هدفون سونی مدل ۱ (#147) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("54", "9072", "ووکامرس", "", "", "", "2024-11-01 19:20:02", "2024-11-01 15:50:02", "سطح موجودی کاهش یافت: تلویزیون جی پلاس ۵۰ اینچ (#185) 12&rarr;11, هدفون انکر مدل ۱ (#170) 3&rarr;2, هدفون سونی مدل ۱ (#147) 5&rarr;4", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("55", "9072", "ووکامرس", "", "", "", "2024-11-01 19:20:02", "2024-11-01 15:50:02", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("56", "185", "Nickben", "zzpurcjo@5way5.com", "", "37.139.53.195", "2024-11-08 17:52:52", "2024-11-08 14:22:52", "Tender thanks you after sharing this! \r\nhttps://realamateurporntube.com\r\n \r\nIt’s ever interesting to glimpse unalike perspectives on this topic. \r\nI rate the effort and fine points rest into this post – it provides valuable insights and for all gives me something to think about. \r\nLooking head to more theme like this! \r\nApprehend also - https://twinkporn.one", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/124.0.6367.92 Safari/537.36", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("57", "9101", "ووکامرس", "", "", "", "2024-11-13 00:07:07", "2024-11-12 20:37:07", "نگهداری سهام 60 دقیقه روی <br>- کتاب بی حد و مرز (#195) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("58", "9101", "ووکامرس", "", "", "", "2024-11-13 00:07:08", "2024-11-12 20:37:08", "سطح موجودی کاهش یافت: کتاب بی حد و مرز (#195) 3&rarr;2", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("59", "9101", "ووکامرس", "", "", "", "2024-11-13 00:07:08", "2024-11-12 20:37:08", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("60", "185", "NatashaHenstrichi", "totorulla98@gmail.com", "", "77.105.166.134", "2024-12-01 19:54:01", "2024-12-01 16:24:01", "Sorry for being a bit off-topic. Help me understand  How are such videos made, and why do dogs have 6 legs while cats have 4? \r\nhttps://thebestoptions.net/catsvsdogs.html", "0", "0", "Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.0.0 Safari/537.36", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("61", "9131", "ووکامرس", "", "", "", "2024-12-08 20:31:21", "2024-12-08 17:01:21", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- هدفون سونی مدل ۱ (#147) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("62", "9131", "ووکامرس", "", "", "", "2024-12-08 20:31:21", "2024-12-08 17:01:21", "سطح موجودی کاهش یافت: هدفون سونی مدل ۱ (#147) 4&rarr;3", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("63", "9131", "ووکامرس", "", "", "", "2024-12-08 20:31:21", "2024-12-08 17:01:21", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("64", "185", "RomanSEOman", "totorulla98@gmail.com", "", "77.105.166.134", "2024-12-11 08:18:55", "2024-12-11 04:48:55", "If you\'re reading this, it means your competitors are already leveraging a new approach to accelerate their business growth. Don’t let them get ahead – discover what’s driving this trend and how it can impact your success! \r\nhttps://trendhub.tv/seo-marketing/", "0", "0", "Mozilla/5.0 (Windows NT 6.3; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/103.0.5060.114 Safari/537.36", "review", "0", "0");
INSERT INTO `wp_comments` VALUES("65", "9135", "ووکامرس", "", "", "", "2024-12-12 01:40:26", "2024-12-11 22:10:26", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- تلویزیون جی پلاس ۵۰ اینچ (#185) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("66", "9135", "ووکامرس", "", "", "", "2024-12-12 01:40:26", "2024-12-11 22:10:26", "سطح موجودی کاهش یافت: تلویزیون جی پلاس ۵۰ اینچ (#185) 11&rarr;10", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("67", "9135", "ووکامرس", "", "", "", "2024-12-12 01:40:26", "2024-12-11 22:10:26", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("11", "20230527_d982d8a7d984d8a8d8a7d8aed8aad8", "4f2abd5df2a21f912555_20241226145047", "22", "2024-12-26 14:51:07", "admina", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-12-26 14:50:47\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.7.1\";s:9:\"VersionDB\";s:7:\"10.6.19\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:11;s:4:\"Name\";s:39:\"20230527_d982d8a7d984d8a8d8a7d8aed8aad8\";s:4:\"Hash\";s:35:\"4f2abd5df2a21f912555_20241226145047\";s:8:\"NameHash\";s:75:\"20230527_d982d8a7d984d8a8d8a7d8aed8aad8_4f2abd5df2a21f912555_20241226145047\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:85:\"20230527_d982d8a7d984d8a8d8a7d8aed8aad8_4f2abd5df2a21f912555_20241226145047_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"22.0\";s:6:\"WPUser\";s:6:\"admina\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:87:\"20230527_d982d8a7d984d8a8d8a7d8aed8aad8_4f2abd5df2a21f912555_20241226145047_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:63:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/w-pluss7\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2962;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:20634;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-12-26 14:50:47\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.7.1\";s:9:\"VersionDB\";s:7:\"10.6.19\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20230527_d982d8a7d984d8a8d8a7d8aed8aad8\";s:4:\"Hash\";s:35:\"4f2abd5df2a21f912555_20241226145047\";s:8:\"NameHash\";s:75:\"20230527_d982d8a7d984d8a8d8a7d8aed8aad8_4f2abd5df2a21f912555_20241226145047\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:93:\"20230527_d982d8a7d984d8a8d8a7d8aed8aad8_4f2abd5df2a21f912555_20241226145047_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:77:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/w-pluss7/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:88:\"20230527_d982d8a7d984d8a8d8a7d8aed8aad8_4f2abd5df2a21f912555_20241226145047_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:184:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/w-pluss7/wp-content/backups-dup-lite/tmp/20230527_d982d8a7d984d8a8d8a7d8aed8aad8_4f2abd5df2a21f912555_20241226145047_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:72:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/w-pluss7/wp-admin\";i:1;s:75:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/w-pluss7/wp-includes\";i:2;s:84:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/w-pluss7/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:63:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/w-pluss7\";i:1;s:63:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/w-pluss7\";i:2;s:74:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/w-pluss7/wp-content\";i:3;s:82:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/w-pluss7/wp-content/uploads\";i:4;s:82:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/w-pluss7/wp-content/plugins\";i:5;s:85:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/w-pluss7/wp-content/mu-plugins\";i:6;s:81:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/w-pluss7/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:95:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/w-pluss7/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_litespeed_avatar */
INSERT INTO `wp_litespeed_avatar` VALUES("1", "https://secure.gravatar.com/avatar/7960b9d5ce3ba9d86afbd4c73620542c?s=64&d=mm&r=g", "46fd4ec60f768e3aa9c2dc7d5459ea72", "1684929233");
INSERT INTO `wp_litespeed_avatar` VALUES("2", "https://secure.gravatar.com/avatar/7960b9d5ce3ba9d86afbd4c73620542c?s=32&d=mm&r=g", "9f748681a75f7d801be5432c361cd7fe", "1684929233");

/* INSERT TABLE DATA: wp_litespeed_url */
INSERT INTO `wp_litespeed_url` VALUES("1", "https://demoes.aramis-co.ir/w-pluss7", "");
INSERT INTO `wp_litespeed_url` VALUES("2", "404", "");
INSERT INTO `wp_litespeed_url` VALUES("3", "https://demoes.aramis-co.ir/w-pluss7/product/%d8%aa%d9%84%d9%88%db%8c%d8%b2%db%8c%d9%88%d9%86-%d8%ac%db%8c-%d9%be%d9%84%d8%a7%d8%b3-%db%b5%db%b0-%d8%a7%db%8c%d9%86%da%86", "");
INSERT INTO `wp_litespeed_url` VALUES("4", "https://demoes.aramis-co.ir/w-pluss7/shop", "");
INSERT INTO `wp_litespeed_url` VALUES("5", "https://demoes.aramis-co.ir/w-pluss7/product/%d8%aa%d9%84%d9%88%db%8c%d8%b2%db%8c%d9%88%d9%86-%d8%af%d9%88%d9%88-%db%b8%db%b0-%d8%a7%db%8c%d9%86%da%86", "");
INSERT INTO `wp_litespeed_url` VALUES("6", "https://demoes.aramis-co.ir/w-pluss7/product/%da%a9%d8%aa%d8%a7%d8%a8-%d8%ae%d8%b1%d8%af%d9%87-%d8%b9%d8%a7%d8%af%d8%aa-%d9%87%d8%a7", "");
INSERT INTO `wp_litespeed_url` VALUES("7", "https://demoes.aramis-co.ir/w-pluss7/product/%d9%87%d8%af%d9%81%d9%88%d9%86-%d8%a7%d9%86%da%a9%d8%b1-%d9%85%d8%af%d9%84-%db%b1", "");
INSERT INTO `wp_litespeed_url` VALUES("8", "https://demoes.aramis-co.ir/w-pluss7/product/%d9%87%d8%af%d9%81%d9%88%d9%86-%d8%b3%d9%88%d9%86%db%8c-%d9%85%d8%af%d9%84-%db%b1", "");
INSERT INTO `wp_litespeed_url` VALUES("9", "https://demoes.aramis-co.ir/w-pluss7/compare", "");
INSERT INTO `wp_litespeed_url` VALUES("10", "https://demoes.aramis-co.ir/w-pluss7/product/%d9%87%d8%af%d9%81%d9%88%d9%86-%d8%a7%d9%86%da%a9%d8%b1-%d9%85%d8%af%d9%84-%db%b2", "");
INSERT INTO `wp_litespeed_url` VALUES("11", "https://demoes.aramis-co.ir/w-pluss7/product/%d9%87%d8%af%d9%81%d9%88%d9%86-%d8%b3%d9%88%d9%86%db%8c-%d9%85%d8%af%d9%84-%db%b2", "");
INSERT INTO `wp_litespeed_url` VALUES("12", "https://demoes.aramis-co.ir/w-pluss7/product/%da%a9%d8%aa%d8%a7%d8%a8-%d8%a7%d9%88%d8%b6%d8%a7%d8%b9-%d8%ae%d8%b1%d8%a7%d8%a8-%d8%a7%d8%b3%d8%aa", "");
INSERT INTO `wp_litespeed_url` VALUES("13", "https://demoes.aramis-co.ir/w-pluss7/product/%da%a9%d8%aa%d8%a7%d8%a8-%d8%a8%db%8c-%d8%ad%d8%af-%d9%88-%d9%85%d8%b1%d8%b2", "");
INSERT INTO `wp_litespeed_url` VALUES("14", "https://demoes.aramis-co.ir/w-pluss7/product-category/%d8%aa%d9%84%d9%88%db%8c%d8%b2%db%8c%d9%88%d9%86", "");
INSERT INTO `wp_litespeed_url` VALUES("15", "https://demoes.aramis-co.ir/w-pluss7/product/%da%a9%d8%aa%d8%a7%d8%a8-%d8%b2%d9%86%d8%af%da%af%db%8c-%d8%a8%db%8c%d8%a7%d9%81%d8%b1%db%8c%d9%86%db%8c%d8%af", "");
INSERT INTO `wp_litespeed_url` VALUES("16", "https://demoes.aramis-co.ir/w-pluss7/author/tarah", "");
INSERT INTO `wp_litespeed_url` VALUES("17", "https://demoes.aramis-co.ir/w-pluss7/2023/03/07/ps5%d8%8c-%d8%a8%d8%b1%da%af-%d8%a8%d8%b1%d9%86%d8%af%d9%87-%d8%b3%d8%a7%d9%85%d9%88%d8%b1%d8%a7%db%8c%db%8c-%d9%87%d8%a7", "");
INSERT INTO `wp_litespeed_url` VALUES("18", "https://demoes.aramis-co.ir/w-pluss7/2023/03/07/%d8%ac%d9%87%d8%a7%d9%86-%d8%b1%d9%88%db%8c-%d8%af%d8%b3%d8%aa-%d9%87%d8%a7%db%8c-%d8%aa%d9%88", "");
INSERT INTO `wp_litespeed_url` VALUES("19", "https://demoes.aramis-co.ir/w-pluss7/2023/03/07/%d8%a8%d9%84%d9%88-%d8%b4%d9%86%d9%84%d8%8c-%d8%aa%d9%84%d8%ae%d8%8c-%d8%ae%d9%86%da%a9%d8%8c-%d9%85%d8%ad%d8%a8%d9%88%d8%a8", "");
INSERT INTO `wp_litespeed_url` VALUES("20", "https://demoes.aramis-co.ir/w-pluss7/product/%da%a9%d8%aa%d8%a7%d8%a8-%d9%82%d8%af%d8%b1%d8%aa-%d8%b4%d8%b1%d9%88%d8%b9-%d9%86%d8%a7%d9%82%d8%b5", "");
INSERT INTO `wp_litespeed_url` VALUES("21", "https://demoes.aramis-co.ir/w-pluss7/product/%DA%A9%D8%AA%D8%A7%D8%A8-%DA%A9%D8%AA%D8%A7%D8%A8%D8%AE%D8%A7%D9%86%D9%87-%D9%86%DB%8C%D9%85%D9%87-%D8%B4%D8%A8", "");
INSERT INTO `wp_litespeed_url` VALUES("22", "https://demoes.aramis-co.ir/w-pluss7/category/%D8%AF%D8%B3%D8%AA%D9%87%D8%A8%D9%86%D8%AF%DB%8C-%D9%86%D8%B4%D8%AF%D9%87", "");
INSERT INTO `wp_litespeed_url` VALUES("23", "https://demoes.aramis-co.ir/w-pluss7/2023/03/07/%DA%A9%D9%88%DA%A9%D9%88%D8%B4%D9%86%D9%84%D8%8C-%D8%B1%D8%A7%DB%8C%D8%AD%D9%87-%D8%A7%DB%8C-%D8%AC%D8%B0%D8%A7%D8%A8", "");
INSERT INTO `wp_litespeed_url` VALUES("24", "https://demoes.aramis-co.ir/w-pluss7/product-category/%D9%87%D8%AF%D9%81%D9%88%D9%86", "");
INSERT INTO `wp_litespeed_url` VALUES("25", "https://demoes.aramis-co.ir/w-pluss7/product-category/%DA%A9%D8%AA%D8%A7%D8%A8", "");
INSERT INTO `wp_litespeed_url` VALUES("26", "https://demoes.aramis-co.ir/w-pluss7/2023/03", "");
INSERT INTO `wp_litespeed_url` VALUES("27", "https://demoes.aramis-co.ir/w-pluss7/2023/03/07/%D8%AA%D9%82-%D9%87%D8%B1%D9%85%D8%B3%D8%8C-%D8%B9%D8%B7%D8%B1%DB%8C-%D8%AE%D9%88%D8%A7%D8%B3%D8%AA%D9%86%DB%8C", "");
INSERT INTO `wp_litespeed_url` VALUES("28", "https://demoes.aramis-co.ir/w-pluss7/product-tag/%DA%A9%D8%AA%D8%A7%D8%A8%D8%8C-%D8%B9%D9%84%D9%85", "");
INSERT INTO `wp_litespeed_url` VALUES("29", "https://demoes.aramis-co.ir/w-pluss7/2023/03/07/%D8%A8%D8%B1%D8%B1%D8%B3%DB%8C-%DA%AF%D9%88%D8%B4%DB%8C-%D8%A2%DB%8C%D9%81%D9%88%D9%86-%DB%B1%DB%B4", "");
INSERT INTO `wp_litespeed_url` VALUES("30", "https://demoes.aramis-co.ir/w-pluss7/2023/03/07/%D8%A8%D8%B1%D8%B1%D8%B3%DB%8C-%DA%AF%D9%88%D8%B4%DB%8C-mi-11t", "");
INSERT INTO `wp_litespeed_url` VALUES("31", "https://demoes.aramis-co.ir/w-pluss7/2023/03/07/%D8%A8%D8%B1%D8%B1%D8%B3%DB%8C-%DA%AF%D9%88%D8%B4%DB%8C-s23-ultra", "");
INSERT INTO `wp_litespeed_url` VALUES("32", "https://demoes.aramis-co.ir/w-pluss7/my-account", "");
INSERT INTO `wp_litespeed_url` VALUES("33", "https://demoes.aramis-co.ir/w-pluss7/checkout", "");
INSERT INTO `wp_litespeed_url` VALUES("34", "https://demoes.aramis-co.ir/w-pluss7/cart", "");
INSERT INTO `wp_litespeed_url` VALUES("35", "https://demoes.aramis-co.ir/w-pluss7/my-account/lost-password", "");
INSERT INTO `wp_litespeed_url` VALUES("36", "https://demoes.aramis-co.ir/w-pluss7/shop/page/2", "");
INSERT INTO `wp_litespeed_url` VALUES("37", "https://demoes.aramis-co.ir/w-pluss7/product/تلویزیون-جی-پلاس-۵۰-اینچ", "");
INSERT INTO `wp_litespeed_url` VALUES("38", "https://demoes.aramis-co.ir/w-pluss7/%d8%af%d8%b1%d8%a8%d8%a7%d8%b1%d9%87-%d9%85%d8%a7", "");
INSERT INTO `wp_litespeed_url` VALUES("39", "https://demoes.aramis-co.ir/w-pluss7/%d8%aa%d9%85%d8%a7%d8%b3-%d8%a8%d8%a7-%d9%85%d8%a7", "");
INSERT INTO `wp_litespeed_url` VALUES("40", "https://demoes.aramis-co.ir/w-pluss7/2023", "");
INSERT INTO `wp_litespeed_url` VALUES("41", "https://demoes.aramis-co.ir/w-pluss7/product/تلویزیون-دوو-۸۰-اینچ", "");
INSERT INTO `wp_litespeed_url` VALUES("42", "https://demoes.aramis-co.ir/w-pluss7/product-category/woodshop_tv", "");
INSERT INTO `wp_litespeed_url` VALUES("43", "https://demoes.aramis-co.ir/w-pluss7/product-category/woodshop_book", "");
INSERT INTO `wp_litespeed_url` VALUES("44", "https://demoes.aramis-co.ir/w-pluss7/product-category/woodshop_headphone", "");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "https://demoes.aramis-co.ir/w-pluss7/", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "https://demoes.aramis-co.ir/w-pluss7", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "قالب اختصاصی وودمارت", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "0", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "info@gmail.com", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "6", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:438:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:21:\"^wc/file/transient/?$\";s:33:\"index.php?wc-transient-file-name=\";s:24:\"^wc/file/transient/(.+)$\";s:44:\"index.php?wc-transient-file-name=$matches[1]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:12:\"portfolio/?$\";s:29:\"index.php?post_type=portfolio\";s:42:\"portfolio/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:37:\"portfolio/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:29:\"portfolio/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=portfolio&paged=$matches[1]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:31:\"^favorite/([^/]*)/page/([^/]*)?\";s:64:\"index.php?page_id=1552&wishlist_id=$matches[1]&paged=$matches[2]\";s:23:\"^favorite/page/([^/]*)?\";s:40:\"index.php?page_id=1552&paged=$matches[1]\";s:19:\"^favorite/([^/]*)/?\";s:46:\"index.php?page_id=1552&wishlist_id=$matches[1]\";s:15:\"wplus_ticket/?$\";s:32:\"index.php?post_type=wplus_ticket\";s:45:\"wplus_ticket/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=wplus_ticket&feed=$matches[1]\";s:40:\"wplus_ticket/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=wplus_ticket&feed=$matches[1]\";s:32:\"wplus_ticket/page/([0-9]{1,})/?$\";s:50:\"index.php?post_type=wplus_ticket&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:43:\"category/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?category_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:40:\"tag/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?tag=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:42:\"e-landing-page/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"e-landing-page/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"e-landing-page/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"e-landing-page/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"e-landing-page/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"e-landing-page/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"e-landing-page/([^/]+)/embed/?$\";s:47:\"index.php?e-landing-page=$matches[1]&embed=true\";s:35:\"e-landing-page/([^/]+)/trackback/?$\";s:41:\"index.php?e-landing-page=$matches[1]&tb=1\";s:43:\"e-landing-page/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&paged=$matches[2]\";s:50:\"e-landing-page/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?e-landing-page=$matches[1]&cpage=$matches[2]\";s:51:\"e-landing-page/([^/]+)/wc/file/transient(/(.*))?/?$\";s:66:\"index.php?e-landing-page=$matches[1]&wc/file/transient=$matches[3]\";s:40:\"e-landing-page/([^/]+)/wc-api(/(.*))?/?$\";s:55:\"index.php?e-landing-page=$matches[1]&wc-api=$matches[3]\";s:57:\"e-landing-page/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:68:\"e-landing-page/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:46:\"e-landing-page/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:57:\"e-landing-page/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:39:\"e-landing-page/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?e-landing-page=$matches[1]&page=$matches[2]\";s:31:\"e-landing-page/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"e-landing-page/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"e-landing-page/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"e-landing-page/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"e-landing-page/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"e-landing-page/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:43:\"woodmart_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"woodmart_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"woodmart_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"woodmart_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"woodmart_layout/([^/]+)/embed/?$\";s:48:\"index.php?woodmart_layout=$matches[1]&embed=true\";s:36:\"woodmart_layout/([^/]+)/trackback/?$\";s:42:\"index.php?woodmart_layout=$matches[1]&tb=1\";s:44:\"woodmart_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?woodmart_layout=$matches[1]&paged=$matches[2]\";s:51:\"woodmart_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?woodmart_layout=$matches[1]&cpage=$matches[2]\";s:52:\"woodmart_layout/([^/]+)/wc/file/transient(/(.*))?/?$\";s:67:\"index.php?woodmart_layout=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"woodmart_layout/([^/]+)/wc-api(/(.*))?/?$\";s:56:\"index.php?woodmart_layout=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_layout/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:69:\"woodmart_layout/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:47:\"woodmart_layout/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_layout/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:40:\"woodmart_layout/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?woodmart_layout=$matches[1]&page=$matches[2]\";s:32:\"woodmart_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"woodmart_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"woodmart_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"woodmart_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:43:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"woodmart_woo_lv/([^/]+)/embed/?$\";s:48:\"index.php?woodmart_woo_lv=$matches[1]&embed=true\";s:36:\"woodmart_woo_lv/([^/]+)/trackback/?$\";s:42:\"index.php?woodmart_woo_lv=$matches[1]&tb=1\";s:44:\"woodmart_woo_lv/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?woodmart_woo_lv=$matches[1]&paged=$matches[2]\";s:51:\"woodmart_woo_lv/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?woodmart_woo_lv=$matches[1]&cpage=$matches[2]\";s:52:\"woodmart_woo_lv/([^/]+)/wc/file/transient(/(.*))?/?$\";s:67:\"index.php?woodmart_woo_lv=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"woodmart_woo_lv/([^/]+)/wc-api(/(.*))?/?$\";s:56:\"index.php?woodmart_woo_lv=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_woo_lv/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:69:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:47:\"woodmart_woo_lv/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:40:\"woodmart_woo_lv/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?woodmart_woo_lv=$matches[1]&page=$matches[2]\";s:32:\"woodmart_woo_lv/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"woodmart_woo_lv/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"woodmart_woo_lv/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_woo_lv/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_woo_lv/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"woodmart_woo_lv/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"woodmart_woo_fbt/([^/]+)/embed/?$\";s:49:\"index.php?woodmart_woo_fbt=$matches[1]&embed=true\";s:37:\"woodmart_woo_fbt/([^/]+)/trackback/?$\";s:43:\"index.php?woodmart_woo_fbt=$matches[1]&tb=1\";s:45:\"woodmart_woo_fbt/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?woodmart_woo_fbt=$matches[1]&paged=$matches[2]\";s:52:\"woodmart_woo_fbt/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?woodmart_woo_fbt=$matches[1]&cpage=$matches[2]\";s:53:\"woodmart_woo_fbt/([^/]+)/wc/file/transient(/(.*))?/?$\";s:68:\"index.php?woodmart_woo_fbt=$matches[1]&wc/file/transient=$matches[3]\";s:42:\"woodmart_woo_fbt/([^/]+)/wc-api(/(.*))?/?$\";s:57:\"index.php?woodmart_woo_fbt=$matches[1]&wc-api=$matches[3]\";s:59:\"woodmart_woo_fbt/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:70:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:48:\"woodmart_woo_fbt/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:59:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:41:\"woodmart_woo_fbt/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?woodmart_woo_fbt=$matches[1]&page=$matches[2]\";s:33:\"woodmart_woo_fbt/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"woodmart_woo_fbt/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"woodmart_woo_fbt/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"woodmart_woo_fbt/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"woodmart_woo_fbt/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"woodmart_woo_fbt/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:54:\"cms_block_cat/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?cms_block_cat=$matches[1]&feed=$matches[2]\";s:49:\"cms_block_cat/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?cms_block_cat=$matches[1]&feed=$matches[2]\";s:30:\"cms_block_cat/([^/]+)/embed/?$\";s:46:\"index.php?cms_block_cat=$matches[1]&embed=true\";s:42:\"cms_block_cat/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?cms_block_cat=$matches[1]&paged=$matches[2]\";s:24:\"cms_block_cat/([^/]+)/?$\";s:35:\"index.php?cms_block_cat=$matches[1]\";s:42:\"woodmart_slide/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"woodmart_slide/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"woodmart_slide/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"woodmart_slide/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"woodmart_slide/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"woodmart_slide/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"woodmart_slide/([^/]+)/embed/?$\";s:47:\"index.php?woodmart_slide=$matches[1]&embed=true\";s:35:\"woodmart_slide/([^/]+)/trackback/?$\";s:41:\"index.php?woodmart_slide=$matches[1]&tb=1\";s:43:\"woodmart_slide/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?woodmart_slide=$matches[1]&paged=$matches[2]\";s:50:\"woodmart_slide/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?woodmart_slide=$matches[1]&cpage=$matches[2]\";s:51:\"woodmart_slide/([^/]+)/wc/file/transient(/(.*))?/?$\";s:66:\"index.php?woodmart_slide=$matches[1]&wc/file/transient=$matches[3]\";s:40:\"woodmart_slide/([^/]+)/wc-api(/(.*))?/?$\";s:55:\"index.php?woodmart_slide=$matches[1]&wc-api=$matches[3]\";s:57:\"woodmart_slide/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:68:\"woodmart_slide/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:46:\"woodmart_slide/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:57:\"woodmart_slide/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:39:\"woodmart_slide/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?woodmart_slide=$matches[1]&page=$matches[2]\";s:31:\"woodmart_slide/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"woodmart_slide/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"woodmart_slide/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"woodmart_slide/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"woodmart_slide/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"woodmart_slide/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:56:\"woodmart_slider/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:68:\"index.php?taxonomy=woodmart_slider&term=$matches[1]&feed=$matches[2]\";s:51:\"woodmart_slider/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:68:\"index.php?taxonomy=woodmart_slider&term=$matches[1]&feed=$matches[2]\";s:32:\"woodmart_slider/([^/]+)/embed/?$\";s:62:\"index.php?taxonomy=woodmart_slider&term=$matches[1]&embed=true\";s:44:\"woodmart_slider/([^/]+)/page/?([0-9]{1,})/?$\";s:69:\"index.php?taxonomy=woodmart_slider&term=$matches[1]&paged=$matches[2]\";s:26:\"woodmart_slider/([^/]+)/?$\";s:51:\"index.php?taxonomy=woodmart_slider&term=$matches[1]\";s:37:\"portfolio/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"portfolio/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:30:\"portfolio/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:50:\"portfolio/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:45:\"portfolio/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:38:\"portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:45:\"portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:46:\"portfolio/([^/]+)/wc/file/transient(/(.*))?/?$\";s:61:\"index.php?portfolio=$matches[1]&wc/file/transient=$matches[3]\";s:35:\"portfolio/([^/]+)/wc-api(/(.*))?/?$\";s:50:\"index.php?portfolio=$matches[1]&wc-api=$matches[3]\";s:52:\"portfolio/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:63:\"portfolio/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"portfolio/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:52:\"portfolio/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:34:\"portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:26:\"portfolio/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"portfolio/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"portfolio/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:50:\"project-cat/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project-cat=$matches[1]&feed=$matches[2]\";s:45:\"project-cat/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project-cat=$matches[1]&feed=$matches[2]\";s:26:\"project-cat/(.+?)/embed/?$\";s:44:\"index.php?project-cat=$matches[1]&embed=true\";s:38:\"project-cat/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?project-cat=$matches[1]&paged=$matches[2]\";s:20:\"project-cat/(.+?)/?$\";s:33:\"index.php?project-cat=$matches[1]\";s:47:\"برند/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:42:\"برند/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:23:\"برند/(.+?)/embed/?$\";s:46:\"index.php?product_brand=$matches[1]&embed=true\";s:35:\"برند/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?product_brand=$matches[1]&paged=$matches[2]\";s:17:\"برند/(.+?)/?$\";s:35:\"index.php?product_brand=$matches[1]\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:44:\"product/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?product=$matches[1]&wc/file/transient=$matches[3]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"product/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:38:\"mc4wp-form/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:48:\"mc4wp-form/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:68:\"mc4wp-form/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:63:\"mc4wp-form/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:44:\"mc4wp-form/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"mc4wp-form/([^/]+)/embed/?$\";s:43:\"index.php?mc4wp-form=$matches[1]&embed=true\";s:31:\"mc4wp-form/([^/]+)/trackback/?$\";s:37:\"index.php?mc4wp-form=$matches[1]&tb=1\";s:39:\"mc4wp-form/([^/]+)/page/?([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&paged=$matches[2]\";s:46:\"mc4wp-form/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?mc4wp-form=$matches[1]&cpage=$matches[2]\";s:47:\"mc4wp-form/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?mc4wp-form=$matches[1]&wc/file/transient=$matches[3]\";s:36:\"mc4wp-form/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?mc4wp-form=$matches[1]&wc-api=$matches[3]\";s:53:\"mc4wp-form/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:64:\"mc4wp-form/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:42:\"mc4wp-form/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:53:\"mc4wp-form/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:35:\"mc4wp-form/([^/]+)(?:/([0-9]+))?/?$\";s:49:\"index.php?mc4wp-form=$matches[1]&page=$matches[2]\";s:27:\"mc4wp-form/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"mc4wp-form/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"mc4wp-form/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"mc4wp-form/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"mc4wp-form/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:58:\"priorities_ticket/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?priorities_ticket=$matches[1]&feed=$matches[2]\";s:53:\"priorities_ticket/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?priorities_ticket=$matches[1]&feed=$matches[2]\";s:34:\"priorities_ticket/([^/]+)/embed/?$\";s:50:\"index.php?priorities_ticket=$matches[1]&embed=true\";s:46:\"priorities_ticket/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?priorities_ticket=$matches[1]&paged=$matches[2]\";s:28:\"priorities_ticket/([^/]+)/?$\";s:39:\"index.php?priorities_ticket=$matches[1]\";s:57:\"departman_ticket/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?departman_ticket=$matches[1]&feed=$matches[2]\";s:52:\"departman_ticket/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?departman_ticket=$matches[1]&feed=$matches[2]\";s:33:\"departman_ticket/([^/]+)/embed/?$\";s:49:\"index.php?departman_ticket=$matches[1]&embed=true\";s:45:\"departman_ticket/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?departman_ticket=$matches[1]&paged=$matches[2]\";s:27:\"departman_ticket/([^/]+)/?$\";s:38:\"index.php?departman_ticket=$matches[1]\";s:40:\"wplus_ticket/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"wplus_ticket/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"wplus_ticket/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"wplus_ticket/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"wplus_ticket/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"wplus_ticket/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"wplus_ticket/([^/]+)/embed/?$\";s:45:\"index.php?wplus_ticket=$matches[1]&embed=true\";s:33:\"wplus_ticket/([^/]+)/trackback/?$\";s:39:\"index.php?wplus_ticket=$matches[1]&tb=1\";s:53:\"wplus_ticket/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?wplus_ticket=$matches[1]&feed=$matches[2]\";s:48:\"wplus_ticket/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?wplus_ticket=$matches[1]&feed=$matches[2]\";s:41:\"wplus_ticket/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?wplus_ticket=$matches[1]&paged=$matches[2]\";s:48:\"wplus_ticket/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?wplus_ticket=$matches[1]&cpage=$matches[2]\";s:49:\"wplus_ticket/([^/]+)/wc/file/transient(/(.*))?/?$\";s:64:\"index.php?wplus_ticket=$matches[1]&wc/file/transient=$matches[3]\";s:38:\"wplus_ticket/([^/]+)/wc-api(/(.*))?/?$\";s:53:\"index.php?wplus_ticket=$matches[1]&wc-api=$matches[3]\";s:55:\"wplus_ticket/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:66:\"wplus_ticket/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:44:\"wplus_ticket/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:55:\"wplus_ticket/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:37:\"wplus_ticket/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?wplus_ticket=$matches[1]&page=$matches[2]\";s:29:\"wplus_ticket/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"wplus_ticket/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"wplus_ticket/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"wplus_ticket/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"wplus_ticket/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"wplus_ticket/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\"wplus_ticket_message/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:58:\"wplus_ticket_message/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:78:\"wplus_ticket_message/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:73:\"wplus_ticket_message/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:73:\"wplus_ticket_message/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:54:\"wplus_ticket_message/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:37:\"wplus_ticket_message/([^/]+)/embed/?$\";s:53:\"index.php?wplus_ticket_message=$matches[1]&embed=true\";s:41:\"wplus_ticket_message/([^/]+)/trackback/?$\";s:47:\"index.php?wplus_ticket_message=$matches[1]&tb=1\";s:49:\"wplus_ticket_message/([^/]+)/page/?([0-9]{1,})/?$\";s:60:\"index.php?wplus_ticket_message=$matches[1]&paged=$matches[2]\";s:56:\"wplus_ticket_message/([^/]+)/comment-page-([0-9]{1,})/?$\";s:60:\"index.php?wplus_ticket_message=$matches[1]&cpage=$matches[2]\";s:57:\"wplus_ticket_message/([^/]+)/wc/file/transient(/(.*))?/?$\";s:72:\"index.php?wplus_ticket_message=$matches[1]&wc/file/transient=$matches[3]\";s:46:\"wplus_ticket_message/([^/]+)/wc-api(/(.*))?/?$\";s:61:\"index.php?wplus_ticket_message=$matches[1]&wc-api=$matches[3]\";s:63:\"wplus_ticket_message/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:74:\"wplus_ticket_message/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:52:\"wplus_ticket_message/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:63:\"wplus_ticket_message/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:45:\"wplus_ticket_message/([^/]+)(?:/([0-9]+))?/?$\";s:59:\"index.php?wplus_ticket_message=$matches[1]&page=$matches[2]\";s:37:\"wplus_ticket_message/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"wplus_ticket_message/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"wplus_ticket_message/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"wplus_ticket_message/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"wplus_ticket_message/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"wplus_ticket_message/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=13&cpage=$matches[1]\";s:28:\"wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:18:\"tickets(/(.*))?/?$\";s:30:\"index.php?&tickets=$matches[2]\";s:17:\"offers(/(.*))?/?$\";s:29:\"index.php?&offers=$matches[2]\";s:24:\"notifications(/(.*))?/?$\";s:36:\"index.php?&notifications=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:37:\"comments/wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:40:\"search/(.+)/wc/file/transient(/(.*))?/?$\";s:53:\"index.php?s=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:43:\"author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?author_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc/file/transient=$matches[5]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:52:\"([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:77:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc/file/transient=$matches[4]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:39:\"([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?year=$matches[1]&wc/file/transient=$matches[3]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:36:\"(.?.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?pagename=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:27:\"(.?.+?)/waitlist(/(.*))?/?$\";s:51:\"index.php?pagename=$matches[1]&waitlist=$matches[3]\";s:26:\"(.?.+?)/tickets(/(.*))?/?$\";s:50:\"index.php?pagename=$matches[1]&tickets=$matches[3]\";s:25:\"(.?.+?)/offers(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&offers=$matches[3]\";s:32:\"(.?.+?)/notifications(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&notifications=$matches[3]\";s:42:\".?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\".?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:36:\"([^/]+)/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?name=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\"[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:8:{i:0;s:29:\"RTL-CareUnit/RTL-CareUnit.php\";i:1;s:36:\"contact-form-7/wp-contact-form-7.php\";i:2;s:25:\"duplicator/duplicator.php\";i:3;s:23:\"elementor/elementor.php\";i:4;s:37:\"mailchimp-for-wp/mailchimp-for-wp.php\";i:5;s:27:\"woocommerce/woocommerce.php\";i:6;s:31:\"woodmart-core/woodmart-core.php\";i:7;s:31:\"woodmart-plus/woodmart-plus.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "http://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "+3.5", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:5:{i:0;s:104:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/w-pluss7/wp-content/themes/woodmart/functions.php\";i:1;s:100:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/w-pluss7/wp-content/themes/woodmart/style.css\";i:3;s:119:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/w-pluss7/wp-content/themes/woodmart/inc/admin/settings/other.php\";i:4;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/w-pluss7/wp-content/themes/woodmart/inc/enqueue.php\";i:5;s:0:\"\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "woodmart", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "woodmart", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("46", "db_version", "58975", "yes");
INSERT INTO `wp_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("49", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("67", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("71", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("76", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("77", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "uninstall_plugins", "a:3:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:35:\"litespeed-cache/litespeed-cache.php\";s:47:\"LiteSpeed\\Activation::uninstall_litespeed_cache\";s:27:\"wp-optimize/wp-optimize.php\";s:21:\"wpo_uninstall_actions\";}", "no");
INSERT INTO `wp_options` VALUES("80", "timezone_string", "", "yes");
INSERT INTO `wp_options` VALUES("81", "page_for_posts", "2278", "yes");
INSERT INTO `wp_options` VALUES("82", "page_on_front", "13", "yes");
INSERT INTO `wp_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("86", "site_icon", "422", "yes");
INSERT INTO `wp_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("91", "admin_email_lifespan", "1745227438", "yes");
INSERT INTO `wp_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wp_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("99", "initial_db_version", "53496", "yes");
INSERT INTO `wp_options` VALUES("100", "wp_user_roles", "a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:157:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:8:\"dokandar\";b:1;s:25:\"dokan_view_sales_overview\";b:1;s:29:\"dokan_view_sales_report_chart\";b:1;s:23:\"dokan_view_announcement\";b:1;s:23:\"dokan_view_order_report\";b:1;s:25:\"dokan_view_review_reports\";b:1;s:32:\"dokan_view_product_status_report\";b:1;s:26:\"dokan_view_overview_report\";b:1;s:28:\"dokan_view_daily_sale_report\";b:1;s:29:\"dokan_view_top_selling_report\";b:1;s:29:\"dokan_view_top_earning_report\";b:1;s:27:\"dokan_view_statement_report\";b:1;s:16:\"dokan_view_order\";b:1;s:18:\"dokan_manage_order\";b:1;s:23:\"dokan_manage_order_note\";b:1;s:19:\"dokan_manage_refund\";b:1;s:18:\"dokan_export_order\";b:1;s:16:\"dokan_add_coupon\";b:1;s:17:\"dokan_edit_coupon\";b:1;s:19:\"dokan_delete_coupon\";b:1;s:18:\"dokan_view_reviews\";b:1;s:20:\"dokan_manage_reviews\";b:1;s:21:\"dokan_manage_withdraw\";b:1;s:17:\"dokan_add_product\";b:1;s:18:\"dokan_edit_product\";b:1;s:20:\"dokan_delete_product\";b:1;s:18:\"dokan_view_product\";b:1;s:23:\"dokan_duplicate_product\";b:1;s:20:\"dokan_import_product\";b:1;s:20:\"dokan_export_product\";b:1;s:24:\"dokan_view_overview_menu\";b:1;s:23:\"dokan_view_product_menu\";b:1;s:21:\"dokan_view_order_menu\";b:1;s:22:\"dokan_view_coupon_menu\";b:1;s:22:\"dokan_view_report_menu\";b:1;s:22:\"dokan_view_review_menu\";b:1;s:24:\"dokan_view_withdraw_menu\";b:1;s:30:\"dokan_view_store_settings_menu\";b:1;s:29:\"dokan_view_store_payment_menu\";b:1;s:30:\"dokan_view_store_shipping_menu\";b:1;s:28:\"dokan_view_store_social_menu\";b:1;s:25:\"dokan_view_store_seo_menu\";b:1;s:15:\"manage_security\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:3:{s:4:\"read\";b:1;s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:134:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:8:\"dokandar\";b:1;s:25:\"dokan_view_sales_overview\";b:1;s:29:\"dokan_view_sales_report_chart\";b:1;s:23:\"dokan_view_announcement\";b:1;s:23:\"dokan_view_order_report\";b:1;s:25:\"dokan_view_review_reports\";b:1;s:32:\"dokan_view_product_status_report\";b:1;s:26:\"dokan_view_overview_report\";b:1;s:28:\"dokan_view_daily_sale_report\";b:1;s:29:\"dokan_view_top_selling_report\";b:1;s:29:\"dokan_view_top_earning_report\";b:1;s:27:\"dokan_view_statement_report\";b:1;s:16:\"dokan_view_order\";b:1;s:18:\"dokan_manage_order\";b:1;s:23:\"dokan_manage_order_note\";b:1;s:19:\"dokan_manage_refund\";b:1;s:18:\"dokan_export_order\";b:1;s:16:\"dokan_add_coupon\";b:1;s:17:\"dokan_edit_coupon\";b:1;s:19:\"dokan_delete_coupon\";b:1;s:18:\"dokan_view_reviews\";b:1;s:20:\"dokan_manage_reviews\";b:1;s:21:\"dokan_manage_withdraw\";b:1;s:17:\"dokan_add_product\";b:1;s:18:\"dokan_edit_product\";b:1;s:20:\"dokan_delete_product\";b:1;s:18:\"dokan_view_product\";b:1;s:23:\"dokan_duplicate_product\";b:1;s:20:\"dokan_import_product\";b:1;s:20:\"dokan_export_product\";b:1;s:24:\"dokan_view_overview_menu\";b:1;s:23:\"dokan_view_product_menu\";b:1;s:21:\"dokan_view_order_menu\";b:1;s:22:\"dokan_view_coupon_menu\";b:1;s:22:\"dokan_view_report_menu\";b:1;s:22:\"dokan_view_review_menu\";b:1;s:24:\"dokan_view_withdraw_menu\";b:1;s:30:\"dokan_view_store_settings_menu\";b:1;s:29:\"dokan_view_store_payment_menu\";b:1;s:30:\"dokan_view_store_shipping_menu\";b:1;s:28:\"dokan_view_store_social_menu\";b:1;s:25:\"dokan_view_store_seo_menu\";b:1;}}s:6:\"seller\";a:2:{s:4:\"name\";s:14:\"فروشنده\";s:12:\"capabilities\";a:66:{s:4:\"read\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:12:\"delete_posts\";b:1;s:17:\"manage_categories\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:16:\"edit_shop_orders\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:8:\"dokandar\";b:1;s:25:\"dokan_view_sales_overview\";b:1;s:29:\"dokan_view_sales_report_chart\";b:1;s:23:\"dokan_view_announcement\";b:1;s:23:\"dokan_view_order_report\";b:1;s:25:\"dokan_view_review_reports\";b:1;s:32:\"dokan_view_product_status_report\";b:1;s:26:\"dokan_view_overview_report\";b:1;s:28:\"dokan_view_daily_sale_report\";b:1;s:29:\"dokan_view_top_selling_report\";b:1;s:29:\"dokan_view_top_earning_report\";b:1;s:27:\"dokan_view_statement_report\";b:1;s:16:\"dokan_view_order\";b:1;s:18:\"dokan_manage_order\";b:1;s:23:\"dokan_manage_order_note\";b:1;s:19:\"dokan_manage_refund\";b:1;s:18:\"dokan_export_order\";b:1;s:16:\"dokan_add_coupon\";b:1;s:17:\"dokan_edit_coupon\";b:1;s:19:\"dokan_delete_coupon\";b:1;s:18:\"dokan_view_reviews\";b:1;s:20:\"dokan_manage_reviews\";b:1;s:21:\"dokan_manage_withdraw\";b:1;s:17:\"dokan_add_product\";b:1;s:18:\"dokan_edit_product\";b:1;s:20:\"dokan_delete_product\";b:1;s:18:\"dokan_view_product\";b:1;s:23:\"dokan_duplicate_product\";b:1;s:20:\"dokan_import_product\";b:1;s:20:\"dokan_export_product\";b:1;s:24:\"dokan_view_overview_menu\";b:1;s:23:\"dokan_view_product_menu\";b:1;s:21:\"dokan_view_order_menu\";b:1;s:22:\"dokan_view_coupon_menu\";b:1;s:22:\"dokan_view_report_menu\";b:1;s:22:\"dokan_view_review_menu\";b:1;s:24:\"dokan_view_withdraw_menu\";b:1;s:30:\"dokan_view_store_settings_menu\";b:1;s:29:\"dokan_view_store_payment_menu\";b:1;s:30:\"dokan_view_store_shipping_menu\";b:1;s:28:\"dokan_view_store_social_menu\";b:1;s:25:\"dokan_view_store_seo_menu\";b:1;}}}", "yes");
INSERT INTO `wp_options` VALUES("101", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("102", "WPLANG", "fa_IR", "yes");
INSERT INTO `wp_options` VALUES("103", "user_count", "8", "off");
INSERT INTO `wp_options` VALUES("104", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:170:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>نوشته‌های تازه</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:242:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>آخرین دیدگاه‌ها</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>بایگانی‌ها</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:155:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>دسته‌ها</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("105", "sidebars_widgets", "a:15:{s:19:\"wp_inactive_widgets\";a:5:{i:0;s:34:\"woodmart-woocommerce-layered-nav-4\";i:1;s:34:\"woodmart-woocommerce-layered-nav-2\";i:2;s:34:\"woodmart-woocommerce-layered-nav-3\";i:3;s:23:\"woodmart-price-filter-4\";i:4;s:24:\"wd-widget-stock-status-2\";}s:9:\"sidebar-1\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:22:\"portfolio-widgets-area\";a:0:{}s:12:\"sidebar-shop\";a:3:{i:0;s:26:\"woocommerce_price_filter-2\";i:1;s:27:\"woocommerce_rating_filter-2\";i:2;s:24:\"wd-widget-stock-status-3\";}s:12:\"filters-area\";a:2:{i:0;s:27:\"woocommerce_rating_filter-3\";i:1;s:23:\"woodmart-price-filter-5\";}s:22:\"sidebar-product-single\";a:0:{}s:18:\"sidebar-my-account\";a:0:{}s:24:\"sidebar-full-screen-menu\";a:0:{}s:19:\"mobile-menu-widgets\";a:0:{}s:8:\"footer-1\";a:0:{}s:8:\"footer-2\";a:0:{}s:8:\"footer-3\";a:0:{}s:8:\"footer-4\";a:0:{}s:8:\"footer-5\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("106", "cron", "a:31:{i:1735224686;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1735225099;a:1:{s:40:\"woodmart_wishlist_send_promotional_email\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1735225870;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1735226161;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1735226196;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1735226725;a:2:{s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1735227345;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1735228216;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1735233522;a:1:{s:36:\"puc_cron_check_updates-woodmart-plus\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1735236415;a:1:{s:13:\"rsmAutoUpdate\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1735238727;a:1:{s:29:\"wpo_smush_clear_backup_images\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1735246800;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1735248955;a:2:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1735248984;a:1:{s:45:\"woocommerce_marketplace_cron_fetch_promotions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1735251378;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1735258270;a:3:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1735258280;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1735259745;a:2:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"woocommerce_cleanup_rate_limits\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1735278660;a:1:{s:29:\"mc4wp_refresh_mailchimp_lists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1735301470;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1735301480;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1735301481;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1735301809;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1735507572;a:1:{s:32:\"copy_the_code_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1735554600;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1735560670;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1735566324;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1735683328;a:1:{s:21:\"wpo_weekly_cron_tasks\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1735755374;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1736458605;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("107", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("114", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("115", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("116", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("117", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("118", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("119", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("120", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("124", "recovery_keys", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("125", "theme_mods_twentytwentythree", "a:2:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1678018517;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "no");
INSERT INTO `wp_options` VALUES("128", "https_detection_errors", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("157", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("158", "current_theme", "Woodmart", "yes");
INSERT INTO `wp_options` VALUES("159", "theme_mods_woodmart", "a:5:{i:0;b:0;s:18:\"nav_menu_locations\";a:2:{s:9:\"main-menu\";i:34;s:11:\"mobile-menu\";i:34;}s:18:\"custom_css_post_id\";i:229;s:11:\"custom_logo\";i:424;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1713676317;s:4:\"data\";a:14:{s:19:\"wp_inactive_widgets\";a:4:{i:0;s:34:\"woodmart-woocommerce-layered-nav-2\";i:1;s:34:\"woodmart-woocommerce-layered-nav-3\";i:2;s:23:\"woodmart-price-filter-4\";i:3;s:24:\"wd-widget-stock-status-2\";}s:9:\"sidebar-1\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:22:\"portfolio-widgets-area\";a:0:{}s:12:\"sidebar-shop\";a:3:{i:0;s:26:\"woocommerce_price_filter-2\";i:1;s:27:\"woocommerce_rating_filter-2\";i:2;s:34:\"woodmart-woocommerce-layered-nav-4\";}s:12:\"filters-area\";a:1:{i:0;s:27:\"woocommerce_rating_filter-3\";}s:22:\"sidebar-product-single\";a:0:{}s:18:\"sidebar-my-account\";a:0:{}s:24:\"sidebar-full-screen-menu\";a:0:{}s:19:\"mobile-menu-widgets\";a:0:{}s:8:\"footer-1\";a:0:{}s:8:\"footer-2\";a:0:{}s:8:\"footer-3\";a:0:{}s:8:\"footer-4\";a:0:{}s:8:\"footer-5\";a:0:{}}}}", "yes");
INSERT INTO `wp_options` VALUES("160", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("161", "woodmart-generated-wpbcss-file", "", "yes");
INSERT INTO `wp_options` VALUES("162", "woodmart_is_activated", "", "yes");
INSERT INTO `wp_options` VALUES("164", "xts-options-presets", "", "yes");
INSERT INTO `wp_options` VALUES("165", "xts-woodmart-options", "a:740:{s:12:\"last_message\";s:4:\"save\";s:11:\"insta_token\";s:0:\"\";s:28:\"insta_delete_outdated_images\";s:1:\"0\";s:18:\"google_map_api_key\";s:0:\"\";s:9:\"fb_app_id\";s:0:\"\";s:13:\"fb_app_secret\";s:0:\"\";s:9:\"fb_notice\";s:0:\"\";s:10:\"goo_app_id\";s:0:\"\";s:14:\"goo_app_secret\";s:0:\"\";s:10:\"goo_notice\";s:0:\"\";s:9:\"vk_app_id\";s:0:\"\";s:13:\"vk_app_secret\";s:0:\"\";s:9:\"vk_notice\";s:0:\"\";s:15:\"alt_auth_method\";s:1:\"0\";s:9:\"ajax_shop\";s:1:\"1\";s:11:\"ajax_scroll\";s:1:\"1\";s:21:\"shop_page_breadcrumbs\";s:1:\"1\";s:17:\"cat_desc_position\";s:6:\"before\";s:14:\"products_hover\";s:5:\"icons\";s:23:\"base_hover_mobile_click\";s:1:\"0\";s:21:\"products_color_scheme\";s:7:\"default\";s:22:\"products_bordered_grid\";s:1:\"0\";s:28:\"products_bordered_grid_style\";s:7:\"outside\";s:24:\"products_with_background\";s:1:\"0\";s:19:\"products_background\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"products_shadow\";s:1:\"1\";s:23:\"stretch_product_desktop\";s:1:\"1\";s:22:\"stretch_product_tablet\";s:1:\"0\";s:22:\"stretch_product_mobile\";s:1:\"0\";s:25:\"product_title_lines_limit\";s:3:\"one\";s:22:\"show_empty_star_rating\";s:1:\"0\";s:11:\"hover_image\";s:1:\"0\";s:12:\"grid_gallery\";s:1:\"0\";s:20:\"grid_gallery_control\";s:5:\"hover\";s:26:\"grid_gallery_enable_arrows\";s:4:\"none\";s:16:\"product_quantity\";s:1:\"0\";s:18:\"base_hover_content\";s:7:\"excerpt\";s:21:\"stock_status_position\";s:9:\"thumbnail\";s:27:\"show_stock_quantity_on_grid\";s:1:\"0\";s:23:\"grid_stock_progress_bar\";s:1:\"0\";s:14:\"shop_countdown\";s:1:\"0\";s:22:\"categories_under_title\";s:1:\"0\";s:18:\"brands_under_title\";s:1:\"0\";s:15:\"sku_under_title\";s:1:\"0\";s:18:\"show_reviews_count\";s:1:\"0\";s:17:\"categories_design\";s:7:\"default\";s:19:\"categories_rounding\";s:0:\"\";s:31:\"custom_categories_rounding_size\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:23:\"categories_color_scheme\";s:7:\"default\";s:22:\"categories_with_shadow\";s:6:\"enable\";s:29:\"hide_categories_product_count\";s:1:\"0\";s:11:\"shop_layout\";s:12:\"sidebar-left\";s:18:\"shop_sidebar_width\";s:1:\"3\";s:25:\"shop_hide_sidebar_desktop\";s:1:\"0\";s:24:\"shop_hide_sidebar_tablet\";s:1:\"1\";s:17:\"shop_hide_sidebar\";s:1:\"1\";s:20:\"sticky_filter_button\";s:1:\"0\";s:10:\"shop_title\";s:1:\"1\";s:15:\"shop_categories\";s:1:\"1\";s:25:\"shop_categories_ancestors\";s:1:\"0\";s:25:\"show_categories_neighbors\";s:1:\"0\";s:19:\"shop_products_count\";s:1:\"1\";s:37:\"shop_page_title_hide_empty_categories\";s:1:\"0\";s:34:\"shop_page_title_categories_exclude\";s:0:\"\";s:24:\"mobile_categories_layout\";s:9:\"accordion\";s:29:\"mobile_categories_menu_layout\";s:8:\"dropdown\";s:37:\"mobile_categories_drilldown_animation\";s:5:\"slide\";s:40:\"mobile_categories_submenu_opening_action\";s:10:\"only_arrow\";s:26:\"mobile_categories_position\";s:4:\"left\";s:30:\"mobile_categories_color_scheme\";s:7:\"default\";s:27:\"mobile_categories_close_btn\";s:1:\"0\";s:9:\"shop_view\";s:4:\"grid\";s:16:\"products_columns\";s:1:\"3\";s:23:\"products_columns_tablet\";s:4:\"auto\";s:23:\"products_columns_mobile\";s:1:\"2\";s:16:\"products_spacing\";s:2:\"20\";s:23:\"products_spacing_tablet\";s:0:\"\";s:23:\"products_spacing_mobile\";s:0:\"\";s:24:\"per_row_columns_selector\";s:1:\"1\";s:27:\"products_columns_variations\";a:3:{i:0;s:1:\"2\";i:1;s:1:\"3\";i:2;s:1:\"4\";}s:16:\"products_masonry\";s:1:\"0\";s:24:\"products_different_sizes\";s:1:\"0\";s:13:\"shop_per_page\";s:2:\"12\";s:14:\"per_page_links\";s:1:\"1\";s:16:\"per_page_options\";s:10:\"9,12,18,24\";s:15:\"shop_pagination\";s:10:\"pagination\";s:25:\"load_more_button_page_url\";s:1:\"1\";s:17:\"categories_toggle\";s:1:\"1\";s:14:\"widgets_scroll\";s:1:\"1\";s:14:\"widget_heights\";s:3:\"223\";s:21:\"shop_widgets_collapse\";s:3:\"all\";s:12:\"shop_filters\";s:1:\"1\";s:17:\"shop_filters_type\";s:7:\"widgets\";s:20:\"shop_filters_columns\";s:0:\"\";s:27:\"shop_filters_columns_tablet\";s:4:\"auto\";s:27:\"shop_filters_columns_mobile\";s:4:\"auto\";s:20:\"shop_filters_spacing\";s:2:\"30\";s:27:\"shop_filters_spacing_tablet\";s:0:\"\";s:27:\"shop_filters_spacing_mobile\";s:0:\"\";s:12:\"hide_sort_by\";s:1:\"0\";s:17:\"hide_price_filter\";s:1:\"0\";s:20:\"shop_filters_content\";s:0:\"\";s:24:\"shop_filters_always_open\";s:1:\"0\";s:18:\"shop_filters_close\";s:1:\"0\";s:14:\"default_header\";s:13:\"header_982405\";s:14:\"sticky_toolbar\";s:1:\"1\";s:20:\"sticky_toolbar_label\";s:1:\"1\";s:21:\"sticky_toolbar_fields\";a:5:{i:0;s:4:\"shop\";i:1;s:7:\"sidebar\";i:2;s:8:\"wishlist\";i:3;s:4:\"cart\";i:4;s:7:\"account\";}s:10:\"link_1_url\";s:0:\"\";s:11:\"link_1_text\";s:0:\"\";s:11:\"link_1_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_2_url\";s:0:\"\";s:11:\"link_2_text\";s:0:\"\";s:11:\"link_2_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_3_url\";s:0:\"\";s:11:\"link_3_text\";s:0:\"\";s:11:\"link_3_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_4_url\";s:0:\"\";s:11:\"link_4_text\";s:0:\"\";s:11:\"link_4_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_5_url\";s:0:\"\";s:11:\"link_5_text\";s:0:\"\";s:11:\"link_5_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"age_verify\";s:1:\"0\";s:15:\"age_verify_text\";s:22:\"[html_block id=\"2205\"]\";s:21:\"age_verify_text_error\";s:0:\"\";s:21:\"age_verify_background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:23:\"age_verify_color_scheme\";s:4:\"dark\";s:16:\"age_verify_width\";s:3:\"500\";s:11:\"promo_popup\";s:1:\"1\";s:24:\"promo_popup_content_type\";s:10:\"html_block\";s:10:\"popup_text\";s:0:\"\";s:16:\"popup_html_block\";s:4:\"2205\";s:12:\"popup_scroll\";s:4:\"1000\";s:16:\"popup-background\";a:7:{s:5:\"color\";s:16:\"rgba(15,15,15,0)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:7:\"contain\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:11:\"left center\";}s:18:\"popup_color_scheme\";s:4:\"dark\";s:11:\"popup_width\";s:4:\"1000\";s:13:\"popup_padding\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:23:\"promo_popup_hide_mobile\";s:1:\"1\";s:11:\"popup_event\";s:4:\"time\";s:13:\"promo_timeout\";s:4:\"2000\";s:11:\"popup_pages\";s:1:\"0\";s:13:\"promo_version\";s:1:\"2\";s:12:\"cookies_info\";s:1:\"0\";s:12:\"cookies_text\";s:235:\"ما از کوکی ها برای بهبود تجربه شما در وب سایتمان استفاده می کنیم. با مشاهده این وب سایت، شما برای استفاده از کوکی ها موافقت می کنید.\";s:19:\"cookies_policy_page\";s:0:\"\";s:15:\"cookies_version\";s:1:\"1\";s:13:\"header_banner\";s:1:\"1\";s:18:\"header_banner_link\";s:42:\"https://demoes.aramis-co.ir/w-pluss7/shop/\";s:26:\"header_banner_content_type\";s:4:\"text\";s:24:\"header_banner_html_block\";s:0:\"\";s:23:\"header_banner_shortcode\";s:0:\"\";s:16:\"header_banner_bg\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:78:\"https://demoes.aramis-co.ir/w-pluss7/wp-content/uploads/2023/03/Untitled-2.jpg\";s:2:\"id\";s:4:\"1376\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:5:\"cover\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:13:\"center center\";}s:19:\"header_banner_color\";s:5:\"light\";s:20:\"header_banner_height\";s:2:\"50\";s:27:\"header_banner_mobile_height\";s:2:\"40\";s:16:\"header_close_btn\";s:1:\"1\";s:21:\"header_banner_version\";s:1:\"1\";s:21:\"enqueue_posts_results\";s:1:\"0\";s:27:\"search_posts_results_column\";s:1:\"2\";s:13:\"search_by_sku\";s:1:\"1\";s:17:\"relevanssi_search\";s:1:\"0\";s:16:\"popular_requests\";s:0:\"\";s:24:\"full_search_content_type\";s:7:\"content\";s:24:\"full_search_content_text\";s:0:\"\";s:30:\"full_search_content_html_block\";s:0:\"\";s:23:\"ajax_fullscreen_content\";s:1:\"1\";s:10:\"site_width\";s:6:\"custom\";s:17:\"site_custom_width\";s:4:\"1350\";s:11:\"main_layout\";s:13:\"sidebar-right\";s:13:\"sidebar_width\";s:1:\"3\";s:24:\"hide_main_sidebar_mobile\";s:1:\"1\";s:17:\"page-title-design\";s:8:\"centered\";s:15:\"page-title-size\";s:7:\"default\";s:16:\"title-background\";a:7:{s:5:\"color\";s:7:\"#0a0a0a\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:5:\"cover\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:13:\"center center\";}s:16:\"page-title-color\";s:5:\"light\";s:14:\"page_title_tag\";s:7:\"default\";s:11:\"breadcrumbs\";s:1:\"1\";s:22:\"yoast_shop_breadcrumbs\";s:1:\"0\";s:23:\"yoast_pages_breadcrumbs\";s:1:\"0\";s:14:\"disable_footer\";s:1:\"1\";s:19:\"footer_content_type\";s:10:\"html_block\";s:13:\"footer-layout\";s:2:\"13\";s:17:\"footer_html_block\";s:3:\"435\";s:13:\"footer-bar-bg\";a:7:{s:5:\"color\";s:7:\"#ffffff\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:12:\"footer-style\";s:4:\"dark\";s:13:\"sticky_footer\";s:1:\"0\";s:23:\"collapse_footer_widgets\";s:1:\"1\";s:14:\"scroll_top_btn\";s:1:\"1\";s:18:\"disable_copyrights\";s:1:\"0\";s:17:\"copyrights-layout\";s:11:\"two-columns\";s:10:\"copyrights\";s:266:\"<small><a href=\"http://woodmart.xtemos.com\"><strong>WOODMART</strong></a> <i class=\"fa fa-copyright\"></i>  ایجاد شده در 2023<a href=\"http://xtemos.com\"><strong>XTEMOS STUDIO</strong></a>. راه حل های تجارت الکترونیک ممتاز.</small>\";s:11:\"copyrights2\";s:110:\"<img src=\"https://demoes.aramis-co.ir/w-pluss7/wp-content/themes/woodmart/images/payments.png\" alt=\"payments\">\";s:22:\"prefooter_content_type\";s:4:\"text\";s:14:\"prefooter_area\";s:21:\"[html_block id=\"258\"]\";s:20:\"prefooter_html_block\";s:0:\"\";s:9:\"text-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:9:\"font-size\";s:2:\"13\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:7:\"#777777\";}}s:12:\"primary-font\";a:1:{i:0;a:7:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:13:\"rgb(66,66,66)\";}}s:16:\"post-titles-font\";a:1:{i:0;a:8:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:13:\"rgb(86,86,86)\";s:5:\"hover\";a:1:{s:5:\"color\";s:16:\"rgb(249, 67, 39)\";}}}s:14:\"secondary-font\";a:1:{i:0;a:5:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";}}s:18:\"widget-titles-font\";a:1:{i:0;a:10:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:2:\"13\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:13:\"rgb(96,96,96)\";}}s:15:\"navigation-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"15\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}}}s:17:\"typography_notice\";s:0:\"\";s:19:\"advanced_typography\";a:2:{i:0;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}}s:26:\"advanced_typography_notice\";s:0:\"\";s:25:\"multi_custom_fonts_notice\";s:0:\"\";s:18:\"multi_custom_fonts\";a:3:{i:0;a:4:{s:9:\"font-name\";s:7:\"Morabba\";s:11:\"font-weight\";s:3:\"500\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:83:\"https://demoes.aramis-co.ir/w-pluss7/wp-content/uploads/2024/02/Morabba-Medium.woff\";s:2:\"id\";s:4:\"2217\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:84:\"https://demoes.aramis-co.ir/w-pluss7/wp-content/uploads/2024/02/Morabba-Medium.woff2\";s:2:\"id\";s:4:\"2219\";}}i:1;a:4:{s:9:\"font-name\";s:7:\"Morabba\";s:11:\"font-weight\";s:3:\"700\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:81:\"https://demoes.aramis-co.ir/w-pluss7/wp-content/uploads/2024/02/Morabba-Bold.woff\";s:2:\"id\";s:4:\"2216\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:82:\"https://demoes.aramis-co.ir/w-pluss7/wp-content/uploads/2024/02/Morabba-Bold.woff2\";s:2:\"id\";s:4:\"2218\";}}s:9:\"{{index}}\";a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}}s:9:\"icon_font\";a:2:{s:4:\"font\";s:1:\"2\";s:6:\"weight\";s:3:\"700\";}s:14:\"typekit_notice\";s:0:\"\";s:10:\"typekit_id\";s:0:\"\";s:13:\"typekit_fonts\";s:0:\"\";s:13:\"rounding_size\";s:1:\"8\";s:20:\"custom_rounding_size\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:12:\"dark_version\";s:1:\"0\";s:13:\"primary-color\";a:1:{s:4:\"idle\";s:14:\"rgb(249,67,39)\";}s:15:\"secondary-color\";a:1:{s:4:\"idle\";s:13:\"rgb(27,40,69)\";}s:10:\"link-color\";a:2:{s:4:\"idle\";s:7:\"#333333\";s:5:\"hover\";s:15:\"#rgb(249,67,39)\";}s:25:\"android_browser_bar_color\";a:1:{s:4:\"idle\";s:13:\"rgb(27,40,69)\";}s:15:\"body-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:16:\"pages-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"shop-background\";a:7:{s:5:\"color\";s:16:\"rgb(243,243,243)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"product-background\";a:7:{s:5:\"color\";s:16:\"rgb(243,243,243)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"blog-background\";a:7:{s:5:\"color\";s:16:\"rgb(243,243,243)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"blog-post-background\";a:7:{s:5:\"color\";s:16:\"rgb(243,243,243)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"portfolio-background\";a:7:{s:5:\"color\";s:16:\"rgb(243,243,243)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:28:\"portfolio-project-background\";a:7:{s:5:\"color\";s:16:\"rgb(243,243,243)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"btns_default_style\";s:4:\"flat\";s:23:\"btns_default_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";}}s:15:\"btns_default_bg\";a:1:{s:4:\"idle\";s:7:\"#f7f7f7\";}s:21:\"btns_default_bg_hover\";a:1:{s:4:\"idle\";s:7:\"#efefef\";}s:25:\"btns_default_color_scheme\";s:4:\"dark\";s:31:\"btns_default_color_scheme_hover\";s:4:\"dark\";s:32:\"btns_default_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"btns_default_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"btns_shop_style\";s:2:\"3d\";s:20:\"btns_shop_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";}}s:12:\"btns_shop_bg\";a:1:{s:4:\"idle\";s:14:\"rgb(249,67,39)\";}s:18:\"btns_shop_bg_hover\";a:1:{s:4:\"idle\";s:14:\"rgb(219,47,35)\";}s:22:\"btns_shop_color_scheme\";s:5:\"light\";s:28:\"btns_shop_color_scheme_hover\";s:5:\"light\";s:29:\"btns_shop_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:35:\"btns_shop_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"advanced_typography_button\";a:2:{i:0;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}}s:17:\"form_fields_style\";s:12:\"semi-rounded\";s:17:\"form_border_width\";s:1:\"1\";s:10:\"form_color\";a:1:{s:4:\"idle\";s:16:\"rgb(132,132,132)\";}s:22:\"form_placeholder_color\";a:1:{s:4:\"idle\";s:16:\"rgb(193,193,193)\";}s:14:\"form_brd_color\";a:1:{s:4:\"idle\";s:16:\"rgb(186,186,186)\";}s:20:\"form_brd_color_focus\";a:1:{s:4:\"idle\";s:16:\"rgb(178,178,178)\";}s:7:\"form_bg\";a:1:{s:4:\"idle\";s:16:\"rgb(255,255,255)\";}s:23:\"success_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#459647\";}s:25:\"success_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:23:\"warning_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#E0B252\";}s:25:\"warning_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:24:\"carousel_arrows_position\";s:3:\"sep\";s:25:\"carousel_arrows_icon_type\";s:1:\"1\";s:27:\"carousel_arrows_hover_style\";s:1:\"1\";s:24:\"carousel_arrows_sep_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:29:\"carousel_arrows_sep_icon_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:28:\"carousel_arrows_sep_offset_h\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:28:\"carousel_arrows_sep_offset_v\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:25:\"carousel_arrows_sep_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:31:\"carousel_arrows_sep_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:29:\"carousel_arrows_sep_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:28:\"carousel_arrows_sep_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:34:\"carousel_arrows_sep_bg_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:32:\"carousel_arrows_sep_bg_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:33:\"carousel_arrows_sep_border_radius\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:32:\"carousel_arrows_sep_border_style\";s:0:\"\";s:32:\"carousel_arrows_sep_border_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:32:\"carousel_arrows_sep_border_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"carousel_arrows_sep_border_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:36:\"carousel_arrows_sep_border_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:36:\"carousel_arrows_sep_box_shadow_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:39:\"carousel_arrows_sep_box_shadow_offset_x\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:39:\"carousel_arrows_sep_box_shadow_offset_y\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:35:\"carousel_arrows_sep_box_shadow_blur\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:37:\"carousel_arrows_sep_box_shadow_spread\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:28:\"carousel_arrows_together_gap\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:29:\"carousel_arrows_together_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:34:\"carousel_arrows_together_icon_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:33:\"carousel_arrows_together_offset_h\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:33:\"carousel_arrows_together_offset_v\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:30:\"carousel_arrows_together_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:36:\"carousel_arrows_together_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:34:\"carousel_arrows_together_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:33:\"carousel_arrows_together_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:39:\"carousel_arrows_together_bg_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:37:\"carousel_arrows_together_bg_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"carousel_arrows_together_border_radius\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:37:\"carousel_arrows_together_border_style\";s:0:\"\";s:37:\"carousel_arrows_together_border_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:37:\"carousel_arrows_together_border_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:43:\"carousel_arrows_together_border_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:41:\"carousel_arrows_together_border_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:41:\"carousel_arrows_together_box_shadow_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:44:\"carousel_arrows_together_box_shadow_offset_x\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:44:\"carousel_arrows_together_box_shadow_offset_y\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:40:\"carousel_arrows_together_box_shadow_blur\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:42:\"carousel_arrows_together_box_shadow_spread\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:19:\"carousel_pagin_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:23:\"carousel_pagin_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:29:\"carousel_pagin_bg_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:30:\"carousel_pagin_bg_color_active\";a:1:{s:4:\"idle\";s:0:\"\";}s:28:\"carousel_pagin_border_radius\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:27:\"carousel_pagin_border_style\";s:0:\"\";s:27:\"carousel_pagin_border_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:27:\"carousel_pagin_border_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:33:\"carousel_pagin_border_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:34:\"carousel_pagin_border_color_active\";a:1:{s:4:\"idle\";s:0:\"\";}s:25:\"carousel_scrollbar_height\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:24:\"carousel_scrollbar_width\";s:152:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoiJSJ9LCJ0YWJsZXQiOnsidmFsdWUiOiIiLCJ1bml0IjoiJSJ9LCJtb2JpbGUiOnsidmFsdWUiOiIiLCJ1bml0IjoiJSJ9fX0=\";s:27:\"carousel_scrollbar_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:32:\"carousel_scrollbar_drag_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"carousel_scrollbar_drag_bg_hover_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:11:\"blog_layout\";s:13:\"sidebar-right\";s:18:\"blog_sidebar_width\";s:1:\"3\";s:29:\"single_post_justified_gallery\";s:1:\"0\";s:11:\"blog_design\";s:7:\"masonry\";s:10:\"blog_style\";s:6:\"shadow\";s:16:\"blog_with_shadow\";s:1:\"1\";s:12:\"blog_columns\";s:1:\"3\";s:19:\"blog_columns_tablet\";s:4:\"auto\";s:19:\"blog_columns_mobile\";s:4:\"auto\";s:12:\"blog_spacing\";s:2:\"20\";s:19:\"blog_spacing_tablet\";s:0:\"\";s:19:\"blog_spacing_mobile\";s:0:\"\";s:15:\"blog_pagination\";s:10:\"pagination\";s:12:\"blog_excerpt\";s:7:\"excerpt\";s:21:\"blog_words_or_letters\";s:6:\"letter\";s:19:\"blog_excerpt_length\";s:3:\"135\";s:11:\"parts_title\";s:1:\"1\";s:10:\"parts_meta\";s:1:\"1\";s:10:\"parts_text\";s:1:\"1\";s:9:\"parts_btn\";s:1:\"1\";s:18:\"single_post_design\";s:7:\"default\";s:18:\"single_post_header\";s:4:\"none\";s:10:\"blog_share\";s:1:\"1\";s:15:\"blog_navigation\";s:1:\"1\";s:15:\"blog_author_bio\";s:1:\"1\";s:18:\"blog_related_posts\";s:1:\"1\";s:9:\"portfolio\";s:1:\"1\";s:14:\"portfolio_page\";s:0:\"\";s:19:\"portfolio_item_slug\";s:0:\"\";s:18:\"portfolio_cat_slug\";s:0:\"\";s:20:\"portfolio_full_width\";s:1:\"0\";s:16:\"projects_columns\";s:1:\"3\";s:23:\"projects_columns_tablet\";s:4:\"auto\";s:23:\"projects_columns_mobile\";s:4:\"auto\";s:17:\"portfolio_spacing\";s:1:\"0\";s:24:\"portfolio_spacing_tablet\";s:0:\"\";s:24:\"portfolio_spacing_mobile\";s:0:\"\";s:18:\"portoflio_per_page\";s:1:\"6\";s:20:\"portfolio_pagination\";s:9:\"load_more\";s:17:\"portoflio_orderby\";s:4:\"date\";s:15:\"portoflio_order\";s:4:\"DESC\";s:15:\"portoflio_style\";s:5:\"hover\";s:20:\"portoflio_image_size\";s:5:\"large\";s:17:\"portoflio_filters\";s:1:\"1\";s:22:\"portfolio_filters_type\";s:5:\"links\";s:14:\"ajax_portfolio\";s:1:\"1\";s:23:\"single_portfolio_header\";s:4:\"none\";s:36:\"single_portfolio_title_in_page_title\";s:1:\"0\";s:20:\"portfolio_navigation\";s:1:\"1\";s:17:\"portfolio_related\";s:1:\"1\";s:18:\"add_to_cart_action\";s:6:\"widget\";s:26:\"add_to_cart_action_timeout\";s:1:\"0\";s:33:\"add_to_cart_action_timeout_number\";s:1:\"3\";s:18:\"mini_cart_quantity\";s:1:\"0\";s:21:\"show_sku_in_mini_cart\";s:1:\"0\";s:16:\"show_sku_in_cart\";s:1:\"0\";s:25:\"show_sku_in_checkout_page\";s:1:\"0\";s:26:\"show_sku_in_thank_you_page\";s:1:\"0\";s:23:\"show_sku_in_email_order\";s:1:\"0\";s:16:\"show_sku_on_ajax\";s:1:\"0\";s:12:\"catalog_mode\";s:1:\"0\";s:11:\"size_guides\";s:1:\"1\";s:12:\"login_prices\";s:1:\"0\";s:19:\"quick_shop_variable\";s:1:\"0\";s:24:\"quick_shop_variable_type\";s:14:\"select_options\";s:23:\"quick_shop_clear_action\";s:4:\"none\";s:23:\"grid_swatches_attribute\";s:0:\"\";s:14:\"swatches_limit\";s:1:\"0\";s:20:\"swatches_limit_count\";s:1:\"5\";s:29:\"single_product_swatches_limit\";s:1:\"0\";s:35:\"single_product_swatches_limit_count\";s:2:\"10\";s:29:\"swatches_use_variation_images\";s:1:\"0\";s:20:\"swatches_labels_name\";s:1:\"0\";s:27:\"swatches_scroll_top_desktop\";s:1:\"0\";s:26:\"swatches_scroll_top_mobile\";s:1:\"0\";s:17:\"variation_gallery\";s:1:\"1\";s:32:\"variation_gallery_storage_method\";s:3:\"old\";s:24:\"ajax_variation_threshold\";s:2:\"30\";s:17:\"hide_larger_price\";s:1:\"0\";s:31:\"single_product_variations_price\";s:1:\"0\";s:11:\"label_shape\";s:10:\"rounded-sm\";s:16:\"percentage_label\";s:1:\"1\";s:19:\"sale_label_bg_color\";a:1:{s:4:\"idle\";s:14:\"rgb(249,67,39)\";}s:21:\"sale_label_text_color\";a:1:{s:4:\"idle\";s:16:\"rgb(255,255,255)\";}s:9:\"new_label\";s:1:\"1\";s:27:\"new_label_days_after_create\";s:2:\"15\";s:18:\"new_label_bg_color\";a:1:{s:4:\"idle\";s:13:\"rgb(27,40,69)\";}s:20:\"new_label_text_color\";a:1:{s:4:\"idle\";s:16:\"rgb(255,255,255)\";}s:9:\"hot_label\";s:1:\"0\";s:18:\"hot_label_bg_color\";a:1:{s:4:\"idle\";s:15:\"rgb(39,110,249)\";}s:20:\"hot_label_text_color\";a:1:{s:4:\"idle\";s:16:\"rgb(255,255,255)\";}s:20:\"stock_label_bg_color\";a:1:{s:4:\"idle\";s:16:\"rgb(226,226,226)\";}s:22:\"stock_label_text_color\";a:1:{s:4:\"idle\";s:13:\"rgb(89,89,89)\";}s:24:\"attribute_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"attribute_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:16:\"brands_attribute\";s:8:\"pa_brand\";s:18:\"product_page_brand\";s:1:\"1\";s:22:\"product_brand_location\";s:7:\"sidebar\";s:9:\"brand_tab\";s:1:\"1\";s:14:\"brand_tab_name\";s:1:\"0\";s:10:\"quick_view\";s:1:\"0\";s:17:\"quick_view_layout\";s:10:\"horizontal\";s:15:\"quickview_width\";s:3:\"920\";s:19:\"quick_view_variable\";s:1:\"0\";s:7:\"compare\";s:1:\"1\";s:12:\"compare_page\";s:4:\"1561\";s:14:\"fields_compare\";a:7:{i:0;s:11:\"description\";i:1;s:10:\"dimensions\";i:2;s:6:\"weight\";i:3;s:8:\"pa_brand\";i:4;s:8:\"pa_color\";i:5;s:3:\"sku\";i:6;s:12:\"availability\";}s:18:\"empty_compare_text\";s:274:\"هیچ محصولی در لیست مقایسه اضافه نشده است. شما باید برخی از محصولات را برای مقایسه آنها اضافه کنید.<br> در صفحه \"فروشگاه\" ما محصولات جالب زیادی خواهید یافت.\";s:15:\"compare_on_grid\";s:1:\"1\";s:25:\"compare_save_button_state\";s:1:\"0\";s:19:\"compare_by_category\";s:1:\"0\";s:22:\"show_more_products_btn\";s:1:\"1\";s:27:\"update_cart_quantity_change\";s:1:\"0\";s:15:\"empty_cart_text\";s:144:\"Before proceed to checkout you must add some products to your shopping cart.<br> You will find a lot of interesting products on our \"Shop\" page.\";s:27:\"thank_you_page_content_type\";s:4:\"text\";s:28:\"thank_you_page_extra_content\";s:0:\"\";s:25:\"thank_you_page_html_block\";s:0:\"\";s:30:\"thank_you_page_default_content\";s:1:\"1\";s:21:\"single_product_layout\";s:10:\"full-width\";s:19:\"full_height_sidebar\";s:1:\"0\";s:20:\"single_sidebar_width\";s:1:\"3\";s:20:\"single_product_style\";s:1:\"2\";s:14:\"product_design\";s:7:\"default\";s:14:\"product_sticky\";s:1:\"1\";s:22:\"product_summary_shadow\";s:1:\"0\";s:17:\"single_full_width\";s:1:\"0\";s:21:\"single_product_header\";s:4:\"none\";s:32:\"single_product_builder_post_data\";s:0:\"\";s:12:\"image_action\";s:4:\"zoom\";s:15:\"photoswipe_icon\";s:1:\"1\";s:26:\"product_slider_auto_height\";s:1:\"1\";s:23:\"pagination_main_gallery\";s:1:\"1\";s:23:\"product_images_captions\";s:1:\"0\";s:14:\"thums_position\";s:6:\"bottom\";s:31:\"single_product_grid_columns_gap\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:34:\"single_product_grid_column_desktop\";s:0:\"\";s:33:\"single_product_grid_column_tablet\";s:0:\"\";s:33:\"single_product_grid_column_mobile\";s:0:\"\";s:37:\"single_product_gallery_column_desktop\";s:1:\"1\";s:36:\"single_product_gallery_column_tablet\";s:0:\"\";s:36:\"single_product_gallery_column_mobile\";s:0:\"\";s:40:\"single_product_thumbnails_vertical_items\";s:1:\"3\";s:39:\"single_product_thumbnails_items_desktop\";s:1:\"4\";s:38:\"single_product_thumbnails_items_tablet\";s:1:\"4\";s:38:\"single_product_thumbnails_items_mobile\";s:1:\"3\";s:22:\"main_gallery_on_tablet\";s:1:\"1\";s:22:\"main_gallery_on_mobile\";s:1:\"1\";s:24:\"main_gallery_center_mode\";s:1:\"0\";s:48:\"single_product_thumbnails_wrap_in_mobile_devices\";s:1:\"1\";s:39:\"single_product_thumbnails_gallery_width\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:40:\"single_product_thumbnails_gallery_height\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:45:\"single_product_thumbnails_gallery_image_width\";s:3:\"150\";s:23:\"single_ajax_add_to_cart\";s:1:\"1\";s:25:\"single_sticky_add_to_cart\";s:1:\"0\";s:32:\"mobile_single_sticky_add_to_cart\";s:1:\"0\";s:33:\"sticky_add_to_cart_height_desktop\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_tablet\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_mobile\";s:2:\"42\";s:31:\"before_add_to_cart_content_type\";s:4:\"text\";s:26:\"content_before_add_to_cart\";s:0:\"\";s:29:\"before_add_to_cart_html_block\";s:0:\"\";s:30:\"after_add_to_cart_content_type\";s:4:\"text\";s:25:\"content_after_add_to_cart\";s:0:\"\";s:28:\"after_add_to_cart_html_block\";s:0:\"\";s:27:\"single_breadcrumbs_position\";s:7:\"default\";s:24:\"product_page_breadcrumbs\";s:1:\"1\";s:12:\"products_nav\";s:1:\"1\";s:25:\"product_short_description\";s:1:\"1\";s:21:\"attr_after_short_desc\";s:1:\"1\";s:19:\"stock_status_design\";s:7:\"with-bg\";s:25:\"single_stock_progress_bar\";s:1:\"1\";s:17:\"product_countdown\";s:1:\"1\";s:23:\"sale_countdown_variable\";s:1:\"1\";s:17:\"product_show_meta\";s:11:\"add_to_cart\";s:13:\"product_share\";s:1:\"1\";s:18:\"product_share_type\";s:5:\"share\";s:16:\"related_products\";s:1:\"1\";s:16:\"upsells_position\";s:8:\"standard\";s:20:\"related_product_view\";s:6:\"slider\";s:23:\"related_product_columns\";s:1:\"4\";s:30:\"related_product_columns_tablet\";s:4:\"auto\";s:30:\"related_product_columns_mobile\";s:4:\"auto\";s:21:\"related_product_count\";s:1:\"8\";s:19:\"product_tabs_layout\";s:4:\"tabs\";s:21:\"product_tabs_location\";s:8:\"standard\";s:23:\"product_accordion_state\";s:5:\"first\";s:16:\"hide_tabs_titles\";s:1:\"1\";s:20:\"additional_tab_title\";s:0:\"\";s:27:\"additional_tab_content_type\";s:4:\"text\";s:19:\"additional_tab_text\";s:0:\"\";s:25:\"additional_tab_html_block\";s:0:\"\";s:22:\"additional_tab_2_title\";s:0:\"\";s:29:\"additional_tab_2_content_type\";s:4:\"text\";s:21:\"additional_tab_2_text\";s:0:\"\";s:27:\"additional_tab_2_html_block\";s:0:\"\";s:22:\"additional_tab_3_title\";s:0:\"\";s:29:\"additional_tab_3_content_type\";s:4:\"text\";s:21:\"additional_tab_3_text\";s:0:\"\";s:27:\"additional_tab_3_html_block\";s:0:\"\";s:10:\"login_tabs\";s:1:\"1\";s:9:\"reg_title\";s:13:\"ثبت نام\";s:8:\"reg_text\";s:489:\"ثبت نام در این سایت به شما امکان می دهد به وضعیت و سابقه سفارش خود دسترسی داشته باشید. فقط کافی است فیلدهای زیر را پر کنید، و ما در کمترین زمان یک حساب کاربری جدید برای شما راه اندازی خواهیم کرد. ما فقط از شما اطلاعات لازم را برای سریعتر و آسان تر کردن فرآیند خرید می خواهیم.\";s:11:\"login_title\";s:22:\"ورود به سایت\";s:10:\"login_text\";s:0:\"\";s:16:\"my_account_links\";s:1:\"1\";s:10:\"custom_css\";s:3421:\"/* حتما باید تغییرات به نحوی باشد که روی همه المان ها تاثیر نگذارد */\r\n.carousel-item--data\r\n{\r\n	max-height:500px;\r\n}\r\n\r\n\r\n\r\n.wd-nav-vertical .wd-dropdown-menu\r\n{\r\n	    transform: translateX(0px) translateY(0) translateZ(0);\r\n	border-radius:0px;\r\n}\r\n\r\n.whb-with-shadow\r\n{\r\n	box-shadow:0px 15px 20px rgb(183 181 181 / 10%) !important;\r\n}\r\n.flickity-page-dots\r\n{\r\n	bottom:50px !important;\r\n}\r\n\r\n\r\n\r\n.fa-circle {\r\n    position: absolute;\r\n    transform: translateX(103%) translateY(-50%);\r\n    width: 10px;\r\n    height: 10px;\r\n}\r\n  .fa-circle:before {\r\n    content: \'\';\r\n    position: relative;\r\n    display: block;\r\n    width: 200%;\r\n    height: 200%;\r\n    box-sizing: border-box;\r\n   margin-right: -55%;\r\n    margin-top: -50%;\r\n    border-radius: 45px;\r\n    background-color: #01a4e9;\r\n    animation: pulse-ring 1.25s cubic-bezier(0.215, 0.61, 0.355, 1) infinite;\r\n  }\r\n  \r\n  .fa-circle:after {\r\n    content: \'\';\r\n    position: absolute;\r\n    left: 0; \r\n    top: 0;\r\n    display: block;\r\n    width: 100%;\r\n    height: 100%;\r\n    background-color: white;\r\n    border-radius: 15px;\r\n    box-shadow: 0 0 8px rgba(0,0,0,.3);\r\n    animation: pulse-dot 1.25s cubic-bezier(0.455, 0.03, 0.515, 0.955) -.4s infinite;\r\n  }\r\n\r\n\r\n@keyframes pulse-ring {\r\n  0% {\r\n    transform: scale(.33);\r\n  }\r\n  80%, 100% {\r\n    opacity: 0;\r\n  }\r\n}\r\n\r\n@keyframes pulse-dot {\r\n  0% {\r\n    transform: scale(.8);\r\n  }\r\n  50% {\r\n    transform: scale(1);\r\n  }\r\n  100% {\r\n    transform: scale(.8);\r\n  }\r\n}\r\n\r\n\r\n\r\n\r\n\r\n/* این بین حتما باید بررسی شود  */\r\n\r\n.stories.carousel\r\n{\r\n	text-align:center;\r\n}\r\n\r\n\r\n\r\n.stories.snapgram .story.seen,.stories.carousel .story\r\n{\r\n	margin:65px 30px 4px 30px !important;\r\n}\r\n.stories.carousel .story>.item-link>.info .name\r\n{\r\n	font-weight:600 ;\r\n}\r\n\r\n\r\n\r\n.form7 input.wpcf7-form-control.wpcf7-text.wpcf7-email.wpcf7-validates-as-required.wpcf7-validates-as-email\r\n{\r\n	width:77% !important;\r\n	border-radius:0px 8px 8px 0px\r\n		\r\n}\r\ninput.wpcf7-form-control.has-spinner.wpcf7-submit\r\n{\r\n	    background-image: linear-gradient(to right,#ff3a30,#ff6a00)!important;\r\n    color: white;\r\n    border-radius: 8px 0px 0px 8px;\r\n	width:13%;\r\n}\r\n\r\n\r\n\r\n\r\n.lblcat:hover .wp-caption-text\r\n{\r\n	color:white\r\n}\r\n.btnofferheader\r\n{\r\ncolor: white !important;\r\n    background-image: linear-gradient(to right,#ff3a30,#ff6a00)!important;\r\n    border-radius: 15px;\r\n    padding: 0px 25px;	\r\n}\r\n\r\n\r\nheader .wd-header-my-account\r\n{\r\nborder: 1px solid #dbcece;\r\n    border-radius: 9px;\r\n\r\n    background-color: white;\r\n    box-shadow: 0 2px 7px -5px #7a7777a1;\r\n}\r\n.lblinfobox:hover .elementor-icon-box-title span,.lblinfobox:hover .elementor-icon-box-wrapper  .elementor-icon-box-description{\r\ncolor:white;\r\n}\r\n\r\n.product-image-link{\r\n	padding:1em;\r\n}\r\n\r\n.timemande{\r\n	font-size:12px;\r\n		padding:1em;\r\n}\r\n\r\n.off-amount{\r\n	color:var(--e-global-color-primary );\r\n}\r\n.item-sell-price{\r\n		color:var(--e-global-color-primary );\r\n}\r\n\r\n\r\n\r\n\r\n\r\n.wd-nav-wrapper.wd-nav-tabs-wrapper.text-center{\r\n	border: 1px solid #E8E2E2;\r\n	border-radius:10px;\r\n	padding:8px\r\n}\r\n.no-sale-image{\r\n	z-index:1;\r\n}\r\n#shop-carousel .carousel-swiper-slides{\r\n	overflow-y: inherit;\r\n\r\n}\r\n\r\n.attachment-shop_catalog.size-shop_catalog{\r\n	margin-top:20px;\r\n}\r\n\r\n\r\n\r\n@media screen and (max-width: 768px)\r\n{\r\n	.carousel-item--data\r\n	{\r\n		display:inline-table;\r\n		grid-column: 1/-1;\r\n    grid-row: 1/-2;\r\n	}\r\n}\";s:11:\"css_desktop\";s:59:\"#shop-carousel .carousel-image img\r\n{\r\n	min-width:250px;\r\n}\";s:10:\"css_tablet\";s:0:\"\";s:15:\"css_wide_mobile\";s:0:\"\";s:10:\"css_mobile\";s:0:\"\";s:11:\"css_backend\";s:0:\"\";s:9:\"custom_js\";s:0:\"\";s:8:\"js_ready\";s:0:\"\";s:13:\"sticky_social\";s:1:\"0\";s:18:\"sticky_social_type\";s:6:\"follow\";s:22:\"sticky_social_position\";s:5:\"right\";s:20:\"social_follow_notice\";s:0:\"\";s:7:\"fb_link\";s:1:\"#\";s:12:\"twitter_link\";s:1:\"#\";s:14:\"isntagram_link\";s:1:\"#\";s:14:\"pinterest_link\";s:1:\"#\";s:12:\"youtube_link\";s:1:\"#\";s:11:\"tumblr_link\";s:0:\"\";s:13:\"linkedin_link\";s:0:\"\";s:10:\"vimeo_link\";s:0:\"\";s:11:\"flickr_link\";s:0:\"\";s:11:\"github_link\";s:0:\"\";s:13:\"dribbble_link\";s:0:\"\";s:12:\"behance_link\";s:0:\"\";s:15:\"soundcloud_link\";s:0:\"\";s:12:\"spotify_link\";s:0:\"\";s:7:\"ok_link\";s:0:\"\";s:7:\"vk_link\";s:0:\"\";s:13:\"whatsapp_link\";s:0:\"\";s:13:\"snapchat_link\";s:0:\"\";s:7:\"tg_link\";s:0:\"\";s:11:\"tiktok_link\";s:0:\"\";s:12:\"discord_link\";s:0:\"\";s:18:\"social_email_links\";s:1:\"0\";s:19:\"social_share_notice\";s:0:\"\";s:8:\"share_fb\";s:1:\"1\";s:13:\"share_twitter\";s:1:\"1\";s:15:\"share_pinterest\";s:1:\"1\";s:14:\"share_linkedin\";s:1:\"1\";s:8:\"share_ok\";s:1:\"0\";s:14:\"share_whatsapp\";s:1:\"0\";s:8:\"share_vk\";s:1:\"0\";s:8:\"share_tg\";s:1:\"1\";s:11:\"share_viber\";s:1:\"0\";s:11:\"share_email\";s:1:\"0\";s:19:\"mobile_optimization\";s:1:\"0\";s:16:\"load_text_domain\";s:1:\"1\";s:21:\"disable_gutenberg_css\";s:1:\"1\";s:29:\"disable_gutenberg_backend_css\";s:1:\"1\";s:17:\"styles_always_use\";s:0:\"\";s:14:\"styles_not_use\";s:0:\"\";s:26:\"disable_owl_mobile_devices\";s:1:\"1\";s:21:\"remove_jquery_migrate\";s:1:\"1\";s:18:\"advanced_js_notice\";s:0:\"\";s:11:\"advanced_js\";s:1:\"1\";s:20:\"autocomplete_library\";s:8:\"required\";s:14:\"cookie_library\";s:8:\"required\";s:24:\"countdown-bundle_library\";s:8:\"required\";s:14:\"device_library\";s:8:\"required\";s:22:\"isotope-bundle_library\";s:8:\"required\";s:17:\"justified_library\";s:8:\"required\";s:16:\"magnific_library\";s:8:\"required\";s:28:\"panr-parallax-bundle_library\";s:8:\"required\";s:16:\"parallax_library\";s:8:\"required\";s:30:\"parallax-scroll-bundle_library\";s:8:\"required\";s:25:\"photoswipe-bundle_library\";s:8:\"required\";s:12:\"pjax_library\";s:8:\"required\";s:18:\"sticky-kit_library\";s:8:\"required\";s:17:\"wd_swiper_library\";s:8:\"required\";s:18:\"threesixty_library\";s:8:\"required\";s:16:\"tooltips_library\";s:8:\"required\";s:13:\"vivus_library\";s:8:\"required\";s:17:\"waypoints_library\";s:8:\"required\";s:15:\"leaflet_library\";s:8:\"required\";s:20:\"vimeo_player_library\";s:8:\"required\";s:18:\"scripts_always_use\";s:0:\"\";s:15:\"scripts_not_use\";s:0:\"\";s:15:\"dequeue_scripts\";s:0:\"\";s:12:\"lazy_loading\";s:1:\"0\";s:19:\"lazy_loading_offset\";s:1:\"0\";s:11:\"lazy_effect\";s:4:\"fade\";s:22:\"lazy_generate_previews\";s:1:\"1\";s:12:\"lazy_base_64\";s:1:\"1\";s:19:\"lazy_proprtion_size\";s:1:\"1\";s:23:\"lazy_custom_placeholder\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:30:\"disable_wordpress_lazy_loading\";s:1:\"1\";s:26:\"rocket_delay_js_exclusions\";s:1:\"1\";s:6:\"cf7_js\";s:1:\"1\";s:20:\"elementor_animations\";s:1:\"1\";s:15:\"elementor_icons\";s:1:\"1\";s:24:\"elementor_dialog_library\";s:1:\"1\";s:18:\"elementor_frontend\";s:1:\"1\";s:14:\"swiper_library\";s:6:\"always\";s:20:\"el_waypoints_library\";s:6:\"always\";s:19:\"google_font_display\";s:7:\"disable\";s:18:\"icons_font_display\";s:7:\"disable\";s:16:\"font_awesome_css\";s:7:\"not_use\";s:23:\"font_icon_woff2_preload\";s:1:\"0\";s:9:\"preloader\";s:1:\"0\";s:15:\"preloader_image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"preloader_background_color\";a:1:{s:4:\"idle\";s:7:\"#ffffff\";}s:22:\"preloader_color_scheme\";s:4:\"dark\";s:12:\"negative_gap\";s:7:\"enabled\";s:20:\"sticky_notifications\";s:1:\"0\";s:13:\"page_comments\";s:1:\"1\";s:15:\"custom_404_page\";s:0:\"\";s:16:\"widget_title_tag\";s:2:\"h5\";s:15:\"woodmart_slider\";s:1:\"1\";s:16:\"allow_upload_svg\";s:1:\"1\";s:29:\"rev_slider_inherit_theme_font\";s:1:\"0\";s:13:\"site_viewport\";s:12:\"not_scalable\";s:16:\"maintenance_mode\";s:1:\"0\";s:22:\"maintenance_access_key\";s:0:\"\";s:11:\"white_label\";s:1:\"0\";s:22:\"white_label_theme_name\";s:0:\"\";s:12:\"dummy_import\";s:1:\"1\";s:29:\"white_label_theme_license_tab\";s:1:\"1\";s:25:\"white_label_changelog_tab\";s:1:\"1\";s:20:\"theme_admin_bar_menu\";s:1:\"1\";s:23:\"white_label_theme_hints\";s:1:\"1\";s:29:\"white_label_sidebar_icon_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"white_label_dashboard_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:33:\"white_label_appearance_screenshot\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:27:\"white_label_dashboard_title\";s:0:\"\";s:26:\"white_label_dashboard_text\";s:0:\"\";s:5:\"reset\";s:0:\"\";s:12:\"reset_notice\";s:0:\"\";s:8:\"wishlist\";s:1:\"1\";s:13:\"wishlist_page\";s:4:\"1552\";s:15:\"wishlist_logged\";s:1:\"0\";s:20:\"wishlist_bulk_action\";s:1:\"1\";s:19:\"wishlist_empty_text\";s:171:\"هنوز هیچ محصولی به علاقه مندی ها اضافه نکردی:(. <br> مطمئنم می تونی لوازم خوبی تو سایت ما پیدا کنی.\";s:17:\"wishlist_expanded\";s:1:\"1\";s:19:\"wishlist_show_popup\";s:6:\"enable\";s:21:\"product_loop_wishlist\";s:1:\"1\";s:26:\"wishlist_save_button_state\";s:1:\"1\";s:29:\"shipping_progress_bar_enabled\";s:1:\"0\";s:33:\"shipping_progress_bar_calculation\";s:6:\"custom\";s:28:\"shipping_progress_bar_amount\";s:3:\"100\";s:36:\"shipping_progress_bar_include_coupon\";s:7:\"exclude\";s:40:\"shipping_progress_bar_location_card_page\";s:1:\"1\";s:40:\"shipping_progress_bar_location_mini_cart\";s:1:\"1\";s:39:\"shipping_progress_bar_location_checkout\";s:1:\"0\";s:45:\"shipping_progress_bar_location_single_product\";s:1:\"0\";s:37:\"shipping_progress_bar_message_initial\";s:46:\"Add [remainder] to cart and get free shipping!\";s:37:\"shipping_progress_bar_message_success\";s:39:\"Your order qualifies for free shipping!\";s:15:\"buy_now_enabled\";s:1:\"0\";s:16:\"buy_now_redirect\";s:8:\"checkout\";s:23:\"counter_visitor_enabled\";s:1:\"1\";s:27:\"counter_visitor_data_source\";s:9:\"fake_data\";s:38:\"counter_visitor_data_source_min_number\";s:3:\"100\";s:38:\"counter_visitor_data_source_max_number\";s:3:\"200\";s:25:\"counter_visitor_live_mode\";s:1:\"0\";s:27:\"counter_visitor_ajax_update\";s:1:\"0\";s:29:\"counter_visitor_live_duration\";s:2:\"10\";s:23:\"bought_together_enabled\";s:1:\"1\";s:22:\"bought_together_column\";s:1:\"3\";s:29:\"bought_together_column_tablet\";s:4:\"auto\";s:29:\"bought_together_column_mobile\";s:4:\"auto\";s:26:\"bought_together_form_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:17:\"discounts_enabled\";s:1:\"0\";s:20:\"show_discounts_table\";s:1:\"0\";s:27:\"checkout_show_product_image\";s:1:\"0\";s:25:\"checkout_product_quantity\";s:1:\"0\";s:22:\"checkout_remove_button\";s:1:\"0\";s:24:\"checkout_link_to_product\";s:1:\"0\";s:16:\"reviews_location\";s:4:\"tabs\";s:23:\"reviews_section_columns\";s:10:\"two-column\";s:15:\"reviews_columns\";s:1:\"1\";s:22:\"reviews_columns_tablet\";s:1:\"1\";s:22:\"reviews_columns_mobile\";s:1:\"1\";s:21:\"reviews_form_location\";s:5:\"after\";s:13:\"reviews_style\";s:7:\"style-1\";s:24:\"reviews_enable_pros_cons\";s:1:\"1\";s:20:\"reviews_enable_likes\";s:1:\"1\";s:32:\"show_reviews_purchased_indicator\";s:1:\"1\";s:15:\"reviews_sorting\";s:1:\"1\";s:29:\"single_product_comment_images\";s:1:\"1\";s:35:\"single_product_comment_images_count\";s:1:\"3\";s:41:\"single_product_comment_images_upload_size\";s:1:\"1\";s:38:\"single_product_comment_images_required\";s:1:\"0\";s:30:\"show_reviews_only_image_filter\";s:1:\"0\";s:22:\"reviews_rating_summary\";s:1:\"1\";s:30:\"reviews_rating_summary_content\";s:6:\"rating\";s:29:\"reviews_rating_summary_filter\";s:1:\"0\";s:26:\"reviews_rating_by_criteria\";s:1:\"0\";s:32:\"reviews_criteria_rating_required\";s:1:\"0\";s:38:\"reviews_rating_summary_criteria_1_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_1\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_2_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_2\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_3_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_3\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_4_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_4\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_5_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_5\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_6_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_6\";s:0:\"\";s:24:\"sticky_navigation_notice\";s:0:\"\";s:22:\"sticky_navigation_menu\";s:0:\"\";s:23:\"sticky_navigation_title\";s:0:\"\";s:30:\"sticky_navigation_content_type\";s:4:\"text\";s:22:\"sticky_navigation_area\";s:0:\"\";s:28:\"sticky_navigation_html_block\";s:0:\"\";s:33:\"single_product_main_gallery_video\";s:1:\"1\";s:23:\"checkout_fields_enabled\";s:1:\"1\";s:17:\"linked_variations\";s:1:\"1\";s:21:\"show_single_variation\";s:1:\"0\";s:21:\"hide_variation_parent\";s:1:\"0\";s:20:\"sold_counter_enabled\";s:1:\"0\";s:23:\"sold_counter_sales_type\";s:9:\"real_data\";s:24:\"sold_counter_shown_after\";s:1:\"0\";s:22:\"sold_counter_min_count\";s:2:\"10\";s:22:\"sold_counter_max_count\";s:2:\"20\";s:31:\"sold_counter_hide_on_outofstock\";s:1:\"0\";s:22:\"sold_counter_timeframe\";s:1:\"3\";s:29:\"sold_counter_timeframe_period\";s:7:\"minutes\";s:28:\"sold_counter_transient_hours\";s:2:\"24\";s:8:\"last_tab\";s:13:\"login_section\";}", "yes");
INSERT INTO `wp_options` VALUES("166", "woodmart_setup_status", "done", "yes");
INSERT INTO `wp_options` VALUES("167", "wd_import_theme_version", "7.2.4", "yes");
INSERT INTO `wp_options` VALUES("168", "woodmart-plugins-update-time", "1735215120", "yes");
INSERT INTO `wp_options` VALUES("169", "woodmart_js_composer_version", "8.1", "yes");
INSERT INTO `wp_options` VALUES("170", "woodmart_revslider_version", "6.7.24", "yes");
INSERT INTO `wp_options` VALUES("171", "wd_wishlist_installed", "1", "yes");
INSERT INTO `wp_options` VALUES("172", "woodmart_upgrade_database_wishlist", "1", "yes");
INSERT INTO `wp_options` VALUES("173", "woodmart_added_column_on_sale_in_product_db", "1", "yes");
INSERT INTO `wp_options` VALUES("174", "xts-theme_settings_default-css-data", "@font-face {\n	font-weight: normal;\n	font-style: normal;\n	font-family: \"woodmart-font\";\n	src: url(\"//demoes.aramis-co.ir/w-pluss7/wp-content/themes/woodmart/fonts/woodmart-font-2-700.woff2?v=8.0.6\") format(\"woff2\");\n}\n\n:root {\n	--wd-header-banner-h: 50px;\n	--wd-text-font: YekanBakhFaNum;\n	--wd-text-font-weight: 400;\n	--wd-text-color: #777777;\n	--wd-text-font-size: 13px;\n	--wd-title-font: YekanBakhFaNum;\n	--wd-title-font-weight: 500;\n	--wd-title-color: rgb(66,66,66);\n	--wd-entities-title-font: YekanBakhFaNum;\n	--wd-entities-title-font-weight: 500;\n	--wd-entities-title-color: rgb(86,86,86);\n	--wd-entities-title-color-hover: rgb(249, 67, 39);\n	--wd-alternative-font: YekanBakhFaNum;\n	--wd-widget-title-font: YekanBakhFaNum;\n	--wd-widget-title-font-weight: 500;\n	--wd-widget-title-transform: none;\n	--wd-widget-title-color: rgb(96,96,96);\n	--wd-widget-title-font-size: 13px;\n	--wd-header-el-font: YekanBakhFaNum;\n	--wd-header-el-font-weight: 500;\n	--wd-header-el-transform: uppercase;\n	--wd-header-el-font-size: 15px;\n	--wd-primary-color: rgb(249,67,39);\n	--wd-alternative-color: rgb(27,40,69);\n	--wd-link-color: #333333;\n	--wd-link-color-hover: #rgb(249,67,39);\n	--btn-default-bgcolor: #f7f7f7;\n	--btn-default-bgcolor-hover: #efefef;\n	--btn-accented-bgcolor: rgb(249,67,39);\n	--btn-accented-bgcolor-hover: rgb(219,47,35);\n	--wd-form-brd-width: 1px;\n	--notices-success-bg: #459647;\n	--notices-success-color: #fff;\n	--notices-warning-bg: #E0B252;\n	--notices-warning-color: #fff;\n}\n.wd-popup.wd-age-verify {\n	--wd-popup-width: 500px;\n}\n.wd-popup.wd-promo-popup {\n	background-color: rgba(15,15,15,0);\n	background-image: none;\n	background-repeat: no-repeat;\n	background-size: contain;\n	background-position: left center;\n	--wd-popup-width: 1000px;\n}\n.header-banner {\n	background-image: url(https://demoes.aramis-co.ir/w-pluss7/wp-content/uploads/2023/03/Untitled-2.jpg);\n	background-repeat: no-repeat;\n	background-size: cover;\n	background-position: center center;\n}\n.woodmart-woocommerce-layered-nav .wd-scroll-content {\n	max-height: 223px;\n}\n.wd-page-title {\n	background-color: #0a0a0a;\n	background-image: none;\n	background-size: cover;\n	background-position: center center;\n}\n.wd-footer {\n	background-color: #ffffff;\n	background-image: none;\n}\n.woodmart-archive-shop:not(.single-product) .wd-page-content {\n	background-color: rgb(243,243,243);\n	background-image: none;\n}\n.single-product .wd-page-content {\n	background-color: rgb(243,243,243);\n	background-image: none;\n}\n.woodmart-archive-blog .wd-page-content {\n	background-color: rgb(243,243,243);\n	background-image: none;\n}\n.single-post .wd-page-content {\n	background-color: rgb(243,243,243);\n	background-image: none;\n}\n.woodmart-archive-portfolio .wd-page-content {\n	background-color: rgb(243,243,243);\n	background-image: none;\n}\n.single-portfolio .wd-page-content {\n	background-color: rgb(243,243,243);\n	background-image: none;\n}\nbody, [class*=color-scheme-light], [class*=color-scheme-dark], .wd-search-form[class*=\"wd-header-search-form\"] form.searchform, .wd-el-search .searchform {\n	--wd-form-color: rgb(132,132,132);\n	--wd-form-placeholder-color: rgb(193,193,193);\n	--wd-form-brd-color: rgb(186,186,186);\n	--wd-form-brd-color-focus: rgb(178,178,178);\n	--wd-form-bg: rgb(255,255,255);\n}\n.product-labels .product-label.onsale {\n	background-color: rgb(249,67,39);\n	color: rgb(255,255,255);\n}\n.product-labels .product-label.new {\n	background-color: rgb(27,40,69);\n	color: rgb(255,255,255);\n}\n.product-labels .product-label.featured {\n	background-color: rgb(39,110,249);\n	color: rgb(255,255,255);\n}\n.product-labels .product-label.out-of-stock {\n	background-color: rgb(226,226,226);\n	color: rgb(89,89,89);\n}\n.wd-popup.popup-quick-view {\n	--wd-popup-width: 920px;\n}\n\n@media (max-width: 1024px) {\n	:root {\n		--wd-header-banner-h: 40px;\n	}\n\n}\n:root{\n--wd-container-w: 1350px;\n--wd-form-brd-radius: 5px;\n--btn-default-color: #333;\n--btn-default-color-hover: #333;\n--btn-accented-color: #fff;\n--btn-accented-color-hover: #fff;\n--btn-default-brd-radius: 0px;\n--btn-default-box-shadow: none;\n--btn-default-box-shadow-hover: none;\n--btn-default-box-shadow-active: none;\n--btn-default-bottom: 0px;\n--btn-accented-bottom-active: -1px;\n--btn-accented-brd-radius: 0px;\n--btn-accented-box-shadow: inset 0 -2px 0 rgba(0, 0, 0, .15);\n--btn-accented-box-shadow-hover: inset 0 -2px 0 rgba(0, 0, 0, .15);\n--wd-brd-radius: 8px;\n}\n\n@media (min-width: 1367px) {\n.platform-Windows .wd-section-stretch > .elementor-container {\nmargin-left: auto;\nmargin-right: auto;\n}\n}\n\n@media (min-width: 1350px) {\nhtml:not(.platform-Windows) .wd-section-stretch > .elementor-container {\nmargin-left: auto;\nmargin-right: auto;\n}\n}\n\n\n@font-face {\n	font-family: \"Morabba\";\n	src: url(\"//demoes.aramis-co.ir/w-pluss7/wp-content/uploads/2024/02/Morabba-Medium.woff2\") format(\"woff2\"), \nurl(\"//demoes.aramis-co.ir/w-pluss7/wp-content/uploads/2024/02/Morabba-Medium.woff\") format(\"woff\");\n	font-weight: 500;\n	font-style: normal;\n}\n\n@font-face {\n	font-family: \"Morabba\";\n	src: url(\"//demoes.aramis-co.ir/w-pluss7/wp-content/uploads/2024/02/Morabba-Bold.woff2\") format(\"woff2\"), \nurl(\"//demoes.aramis-co.ir/w-pluss7/wp-content/uploads/2024/02/Morabba-Bold.woff\") format(\"woff\");\n	font-weight: 700;\n	font-style: normal;\n}\n\n/* حتما باید تغییرات به نحوی باشد که روی همه المان ها تاثیر نگذارد */\r\n.carousel-item--data\r\n{\r\n	max-height:500px;\r\n}\r\n\r\n\r\n\r\n.wd-nav-vertical .wd-dropdown-menu\r\n{\r\n	    transform: translateX(0px) translateY(0) translateZ(0);\r\n	border-radius:0px;\r\n}\r\n\r\n.whb-with-shadow\r\n{\r\n	box-shadow:0px 15px 20px rgb(183 181 181 / 10%) !important;\r\n}\r\n.flickity-page-dots\r\n{\r\n	bottom:50px !important;\r\n}\r\n\r\n\r\n\r\n.fa-circle {\r\n    position: absolute;\r\n    transform: translateX(103%) translateY(-50%);\r\n    width: 10px;\r\n    height: 10px;\r\n}\r\n  .fa-circle:before {\r\n    content: \'\';\r\n    position: relative;\r\n    display: block;\r\n    width: 200%;\r\n    height: 200%;\r\n    box-sizing: border-box;\r\n   margin-right: -55%;\r\n    margin-top: -50%;\r\n    border-radius: 45px;\r\n    background-color: #01a4e9;\r\n    animation: pulse-ring 1.25s cubic-bezier(0.215, 0.61, 0.355, 1) infinite;\r\n  }\r\n  \r\n  .fa-circle:after {\r\n    content: \'\';\r\n    position: absolute;\r\n    left: 0; \r\n    top: 0;\r\n    display: block;\r\n    width: 100%;\r\n    height: 100%;\r\n    background-color: white;\r\n    border-radius: 15px;\r\n    box-shadow: 0 0 8px rgba(0,0,0,.3);\r\n    animation: pulse-dot 1.25s cubic-bezier(0.455, 0.03, 0.515, 0.955) -.4s infinite;\r\n  }\r\n\r\n\r\n@keyframes pulse-ring {\r\n  0% {\r\n    transform: scale(.33);\r\n  }\r\n  80%, 100% {\r\n    opacity: 0;\r\n  }\r\n}\r\n\r\n@keyframes pulse-dot {\r\n  0% {\r\n    transform: scale(.8);\r\n  }\r\n  50% {\r\n    transform: scale(1);\r\n  }\r\n  100% {\r\n    transform: scale(.8);\r\n  }\r\n}\r\n\r\n\r\n\r\n\r\n\r\n/* این بین حتما باید بررسی شود  */\r\n\r\n.stories.carousel\r\n{\r\n	text-align:center;\r\n}\r\n\r\n\r\n\r\n.stories.snapgram .story.seen,.stories.carousel .story\r\n{\r\n	margin:65px 30px 4px 30px !important;\r\n}\r\n.stories.carousel .story>.item-link>.info .name\r\n{\r\n	font-weight:600 ;\r\n}\r\n\r\n\r\n\r\n.form7 input.wpcf7-form-control.wpcf7-text.wpcf7-email.wpcf7-validates-as-required.wpcf7-validates-as-email\r\n{\r\n	width:77% !important;\r\n	border-radius:0px 8px 8px 0px\r\n		\r\n}\r\ninput.wpcf7-form-control.has-spinner.wpcf7-submit\r\n{\r\n	    background-image: linear-gradient(to right,#ff3a30,#ff6a00)!important;\r\n    color: white;\r\n    border-radius: 8px 0px 0px 8px;\r\n	width:13%;\r\n}\r\n\r\n\r\n\r\n\r\n.lblcat:hover .wp-caption-text\r\n{\r\n	color:white\r\n}\r\n.btnofferheader\r\n{\r\ncolor: white !important;\r\n    background-image: linear-gradient(to right,#ff3a30,#ff6a00)!important;\r\n    border-radius: 15px;\r\n    padding: 0px 25px;	\r\n}\r\n\r\n\r\nheader .wd-header-my-account\r\n{\r\nborder: 1px solid #dbcece;\r\n    border-radius: 9px;\r\n\r\n    background-color: white;\r\n    box-shadow: 0 2px 7px -5px #7a7777a1;\r\n}\r\n.lblinfobox:hover .elementor-icon-box-title span,.lblinfobox:hover .elementor-icon-box-wrapper  .elementor-icon-box-description{\r\ncolor:white;\r\n}\r\n\r\n.product-image-link{\r\n	padding:1em;\r\n}\r\n\r\n.timemande{\r\n	font-size:12px;\r\n		padding:1em;\r\n}\r\n\r\n.off-amount{\r\n	color:var(--e-global-color-primary );\r\n}\r\n.item-sell-price{\r\n		color:var(--e-global-color-primary );\r\n}\r\n\r\n\r\n\r\n\r\n\r\n.wd-nav-wrapper.wd-nav-tabs-wrapper.text-center{\r\n	border: 1px solid #E8E2E2;\r\n	border-radius:10px;\r\n	padding:8px\r\n}\r\n.no-sale-image{\r\n	z-index:1;\r\n}\r\n#shop-carousel .carousel-swiper-slides{\r\n	overflow-y: inherit;\r\n\r\n}\r\n\r\n.attachment-shop_catalog.size-shop_catalog{\r\n	margin-top:20px;\r\n}\r\n\r\n\r\n\r\n@media screen and (max-width: 768px)\r\n{\r\n	.carousel-item--data\r\n	{\r\n		display:inline-table;\r\n		grid-column: 1/-1;\r\n    grid-row: 1/-2;\r\n	}\r\n}@media (min-width: 1025px) {\n	#shop-carousel .carousel-image img\r\n{\r\n	min-width:250px;\r\n}\n}\n\n", "on");
INSERT INTO `wp_options` VALUES("175", "xts-theme_settings_default-status", "valid", "yes");
INSERT INTO `wp_options` VALUES("176", "xts-theme_settings_default-version", "8.0.6", "on");
INSERT INTO `wp_options` VALUES("177", "xts-theme_settings_default-site-url", "02e3ca4e24ef49e63113cf8011ed666f", "on");
INSERT INTO `wp_options` VALUES("178", "woodmart-update-time", "1735215121", "yes");
INSERT INTO `wp_options` VALUES("179", "woodmart-update-info", "O:8:\"stdClass\":6:{s:11:\"new_version\";s:5:\"8.0.6\";s:7:\"version\";s:5:\"8.0.6\";s:5:\"theme\";s:8:\"woodmart\";s:7:\"checked\";i:1735215121;s:3:\"url\";s:41:\"https://xtemos.com/woodmart-changelog.php\";s:7:\"package\";s:57:\"https://xtemos.com/wp-json/xts/v1/download?theme=woodmart\";}", "yes");
INSERT INTO `wp_options` VALUES("184", "elementor_active_kit", "5", "yes");
INSERT INTO `wp_options` VALUES("185", "elementor_font_display", "swap", "yes");
INSERT INTO `wp_options` VALUES("188", "revslider_servers", "a:3:{i:0;s:22:\"themepunch-ext-a.tools\";i:1;s:22:\"themepunch-ext-b.tools\";i:2;s:22:\"themepunch-ext-c.tools\";}", "yes");
INSERT INTO `wp_options` VALUES("189", "revslider_server_refresh", "1732013142", "yes");
INSERT INTO `wp_options` VALUES("190", "revslider-update-check-short", "1732013142", "yes");
INSERT INTO `wp_options` VALUES("191", "revslider-connection", "1", "yes");
INSERT INTO `wp_options` VALUES("192", "revslider-update-hash", "247a80a6f0799fca00943cb82c6ef99f", "yes");
INSERT INTO `wp_options` VALUES("193", "revslider-latest-version", "6.7.21", "yes");
INSERT INTO `wp_options` VALUES("194", "revslider-stable-version", "4.2.0", "yes");
INSERT INTO `wp_options` VALUES("195", "revslider-notices", "a:3:{i:0;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:952:\"<div style=\"display: block; background: #1b0e41;text-align: center; height:300px;\"><noscript><img src=\"//updates.themepunch-ext-b.tools//banners/rs60/cyberweek.jpg\" usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\"></noscript><img usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\" src=\"//updates.themepunch-ext-b.tools//banners/rs60/cyberweek.jpg\"></div>\n<map name=\"srbannermap\">\n    <area target=\"_blank\" alt=\"Slider Revolution\" title=\"Slider Revolution\" href=\"https://www.sliderrevolution.com/black-friday-and-cyber-monday-sale/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=cyberweeks22\" coords=\"569,135,890,196\" shape=\"rect\">\n    <area target=\"_blank\" alt=\"Essential Grid\" title=\"Essential Grid\" href=\"https://www.essential-grid.com/?utm_source=admin&utm_medium=banner&utm_campaign=esgusers&utm_content=cyberweeks22\" coords=\"570,200,889,260\" shape=\"rect\">\n</map>\";s:4:\"code\";s:9:\"TPSRCW111\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:1;O:8:\"stdClass\":10:{s:7:\"version\";s:5:\"9.9.9\";s:4:\"text\";s:527:\"<div style=\"display: block; background: #0d0d0e;text-align: center; height: 504px;\"><a href=\"https://account.sliderrevolution.com/portal/pricing/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=getpremium3\" target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: cover; background-size: cover; opacity: 1; width: 900px; height: 504px; display: inline-block;\" muted loop autoplay preload=\"auto\"><source src=\"//updates.themepunch-ext-b.tools//banners/rs60/buypremium3.mp4\" type=\"video/mp4\"></video></a></div>\";s:4:\"code\";s:11:\"TPSNOTR3011\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:2;O:8:\"stdClass\":10:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:302:\"<div style=\"display: block; background: #0d0d0e;text-align: center; height: 250px;\"><a href=\"https://forms.gle/jrzzrpu34VvrFDsMA\" target=\"_blank\" rel=\"noopener\">\n<img style=\"min-width:920px;height:250px;display: inline-block;\" src=\"//updates.themepunch-ext-b.tools//banners/SR2024survey.jpg\"></a></div>\";s:4:\"code\";s:12:\"TPSURVEY2024\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:1;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("196", "revslider-additions", "O:8:\"stdClass\":2:{s:9:\"templates\";O:8:\"stdClass\":3:{s:9:\"tutorials\";a:3:{i:0;O:8:\"stdClass\":2:{s:5:\"title\";s:19:\"Rapid Fire Overview\";s:3:\"url\";s:49:\"https://www.youtube.com/watch?v=LRNTFu-MFgw&t=25s\";}i:1;O:8:\"stdClass\":2:{s:5:\"title\";s:34:\"Responsiveness in Edited Templates\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=hP4oV8SWgKY\";}i:2;O:8:\"stdClass\":2:{s:5:\"title\";s:16:\"Animation Basics\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=nn3azizwpbs\";}}s:5:\"guide\";O:8:\"stdClass\":3:{s:5:\"title\";s:78:\"Require Expert Technical Advice?<br />Submit a Ticket for Dedicated 1on1 Help.\";s:3:\"url\";s:36:\"https://support.sliderrevolution.com\";s:3:\"img\";s:67:\"//updates.themepunch-ext-b.tools/banners/default_template_guide.jpg\";}s:6:\"bottom\";O:8:\"stdClass\":2:{s:5:\"title\";s:32:\"Load A Template From The Library\";s:3:\"img\";s:61:\"//updates.themepunch-ext-b.tools/banners/guide_mod_banner.png\";}}s:7:\"selling\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("197", "rs-addons-counter", "1", "yes");
INSERT INTO `wp_options` VALUES("198", "revslider-addons", "O:8:\"stdClass\":35:{s:28:\"revslider-particlewave-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"559\";s:9:\"releaseid\";s:2:\"29\";s:4:\"slug\";s:28:\"revslider-particlewave-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Particle Wave\";s:6:\"line_1\";s:36:\"Create 3D particle and polygon grids\";s:6:\"line_2\";s:40:\"with lots of style and animation options\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:1:\"9\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:79:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_particlewave.jpg\";s:8:\"img_file\";s:46:\"revslider/addons/images/addon_particlewave.jpg\";s:7:\"img_md5\";s:32:\"623bec30f175f4cc541048f1d6d5fd07\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PW\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-particles-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"558\";s:9:\"releaseid\";s:1:\"7\";s:4:\"slug\";s:25:\"revslider-particles-addon\";s:12:\"version_from\";s:5:\"6.7.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Particle Effects\";s:6:\"line_1\";s:17:\"Let\'s Parti(cle)!\";s:6:\"line_2\";s:51:\"Add interactive particle animations to your sliders\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:2:\"10\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_particles.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_particles.jpg\";s:7:\"img_md5\";s:32:\"b668a4015ddc6a532b43bb558967a062\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-bubblemorph-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"405\";s:9:\"releaseid\";s:2:\"20\";s:4:\"slug\";s:27:\"revslider-bubblemorph-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"BubbleMorph\";s:6:\"line_1\";s:26:\"Include BubbleMorph Layers\";s:6:\"line_2\";s:33:\"for a decorative lava lamp effect\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"20\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_bubblemorph.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_bubblemorph.jpg\";s:7:\"img_md5\";s:32:\"22d03d5de3034069c6db1fdeafd467cd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BM\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-thecluster-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"567\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:26:\"revslider-thecluster-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"The Cluster\";s:6:\"line_1\";s:24:\"Cluster Particle Effects\";s:6:\"line_2\";s:27:\"with millions of Variations\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"22\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_cluster.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_cluster.jpg\";s:7:\"img_md5\";s:32:\"7ada93a9f08a3bcfddc078699674d755\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TC\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:29:\"revslider-fluiddynamics-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"551\";s:9:\"releaseid\";s:2:\"31\";s:4:\"slug\";s:29:\"revslider-fluiddynamics-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Fluid Dynamics\";s:6:\"line_1\";s:46:\"Creating breathtaking Dynamic Fluid animations\";s:6:\"line_2\";s:25:\"as layer or as background\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"27\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:72:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_fluid.png\";s:8:\"img_file\";s:39:\"revslider/addons/images/addon_fluid.png\";s:7:\"img_md5\";s:32:\"4e52333540d80bcb2a41b8ed5961e088\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FD\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-transitionpack-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"568\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:30:\"revslider-transitionpack-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Advanced Transitions\";s:6:\"line_1\";s:43:\"Add never-before-seen slide transitions to \";s:6:\"line_2\";s:42:\"Slider Revolution with the power of WEBGL.\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"30\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_transition.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_transition.jpg\";s:7:\"img_md5\";s:32:\"fe0f1c539053620039a0ad96c4ac27e6\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"AT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-beforeafter-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"545\";s:9:\"releaseid\";s:2:\"15\";s:4:\"slug\";s:27:\"revslider-beforeafter-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Before & After\";s:6:\"line_1\";s:35:\"Compare two slides before and after\";s:6:\"line_2\";s:33:\"use it vertically or horizontally\";s:9:\"available\";s:5:\"6.7.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"40\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_beforeafter.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_beforeafter.jpg\";s:7:\"img_md5\";s:32:\"5a34f20417a7874e1b95693ef37a0758\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BA\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-typewriter-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"569\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:26:\"revslider-typewriter-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"Typewriter Effect\";s:6:\"line_1\";s:27:\"Enhance your slider\'s text \";s:6:\"line_2\";s:24:\"with typewriter effects \";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:2:\"50\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_typewriter.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_typewriter.jpg\";s:7:\"img_md5\";s:32:\"727b604f6fd3fc55894ba50eb566efed\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TW\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-mousetrap-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"555\";s:9:\"releaseid\";s:2:\"24\";s:4:\"slug\";s:25:\"revslider-mousetrap-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Mousetrap\";s:6:\"line_1\";s:31:\"Create all kinds of interesting\";s:6:\"line_2\";s:19:\" mouse interactions\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"60\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_mousetrap.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_mousetrap.jpg\";s:7:\"img_md5\";s:32:\"2329053c3b1d19bdaee131c3dc258d3a\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:28:\"revslider-liquideffect-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"552\";s:9:\"releaseid\";s:2:\"21\";s:4:\"slug\";s:28:\"revslider-liquideffect-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Distortion\";s:6:\"line_1\";s:22:\"Add Distortion Effects\";s:6:\"line_2\";s:30:\"to your slides and transitions\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"70\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_distortion.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_distortion.jpg\";s:7:\"img_md5\";s:32:\"c26c52a563008b7dc907a288c1e4bb8e\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LE\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-lottie-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"553\";s:9:\"releaseid\";s:2:\"25\";s:4:\"slug\";s:22:\"revslider-lottie-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Lottie\";s:6:\"line_1\";s:53:\"Adds support for the popular Lottie Animation format,\";s:6:\"line_2\";s:70:\" including animation control, style customization and a local library.\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"80\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_lottie.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_lottie.jpg\";s:7:\"img_md5\";s:32:\"4aa677a45bb13732e4f10bcb632afcce\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-paintbrush-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"556\";s:9:\"releaseid\";s:2:\"23\";s:4:\"slug\";s:26:\"revslider-paintbrush-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Paintbrush\";s:6:\"line_1\";s:14:\"Paint or Erase\";s:6:\"line_2\";s:22:\"your background images\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"90\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_paintbrush.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_paintbrush.jpg\";s:7:\"img_md5\";s:32:\"308a56289b9a29d1916c2acfc141b699\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-charts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"547\";s:9:\"releaseid\";s:2:\"27\";s:4:\"slug\";s:22:\"revslider-charts-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Charts\";s:6:\"line_1\";s:93:\"The Charts addon allows you to create visually impressive line or bar graphs from .csv data, \";s:6:\"line_2\";s:56:\"with tons of options to take full control of the design.\";s:9:\"available\";s:5:\"6.7.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:3:\"100\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_charts.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_charts.jpg\";s:7:\"img_md5\";s:32:\"d2c184371a575faade425c0377c1fdbd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"CH\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-slicey-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"417\";s:9:\"releaseid\";s:2:\"13\";s:4:\"slug\";s:22:\"revslider-slicey-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Slicey\";s:6:\"line_1\";s:20:\"Slice \'em up nicely!\";s:6:\"line_2\";s:38:\"Create image slices of your background\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"110\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_slicey.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_slicey.jpg\";s:7:\"img_md5\";s:32:\"28afd29b7738a452194f0a0bc1d21cbe\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SL\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-filmstrip-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"550\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:25:\"revslider-filmstrip-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Filmstrip\";s:6:\"line_1\";s:44:\"Display a continously rotating set of images\";s:6:\"line_2\";s:26:\"for your slide backgrounds\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"125\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_filmstrip.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_filmstrip.jpg\";s:7:\"img_md5\";s:32:\"dac40ee57d2be9aaf01faacf51ccb412\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FS\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-maintenance-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"554\";s:9:\"releaseid\";s:1:\"4\";s:4:\"slug\";s:27:\"revslider-maintenance-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:15:\"Coming & Maint.\";s:6:\"line_1\";s:37:\"Simple Coming Soon & Maintenance Page\";s:6:\"line_2\";s:42:\"Let your visitors know what\'s up and when!\";s:9:\"available\";s:5:\"6.7.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"127\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:84:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_underconstruction.jpg\";s:8:\"img_file\";s:51:\"revslider/addons/images/addon_underconstruction.jpg\";s:7:\"img_md5\";s:32:\"17f8cba84931541c065cfb1943edafb2\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-revealer-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"562\";s:9:\"releaseid\";s:2:\"19\";s:4:\"slug\";s:24:\"revslider-revealer-addon\";s:12:\"version_from\";s:5:\"6.7.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Reveal\";s:6:\"line_1\";s:9:\"Reveal...\";s:6:\"line_2\";s:37:\"...your inner beast... and RevSliders\";s:9:\"available\";s:5:\"6.7.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"130\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_reveal.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_reveal.jpg\";s:7:\"img_md5\";s:32:\"a7ce4bf5eb6fdc1497ed6276ca623046\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RV\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-panorama-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"616\";s:9:\"releaseid\";s:2:\"17\";s:4:\"slug\";s:24:\"revslider-panorama-addon\";s:12:\"version_from\";s:6:\"6.7.21\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"Panorama\";s:6:\"line_1\";s:14:\"Panorama AddOn\";s:6:\"line_2\";s:28:\"Display images in 360 degree\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"135\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:75:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_panorama.jpg\";s:8:\"img_file\";s:42:\"revslider/addons/images/addon_panorama.jpg\";s:7:\"img_md5\";s:32:\"210953d59903bed91688138cb60777d2\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-scrollvideo-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"575\";s:9:\"releaseid\";s:2:\"26\";s:4:\"slug\";s:27:\"revslider-scrollvideo-addon\";s:12:\"version_from\";s:5:\"6.7.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Scroll Video\";s:6:\"line_1\";s:114:\"This addon allows you to generate a sequence of images from any html5 video and play them with scroll interaction.\";s:6:\"line_2\";s:49:\"Quality options are included for optimal results!\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:15:\"background_file\";s:45:\"revslider/addons/images/addon_scrollvideo.jpg\";s:14:\"background_md5\";s:32:\"82b2706dfa20a7b0cfabfe7ff28562f9\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"140\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_scrollvideo.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_scrollvideo.jpg\";s:7:\"img_md5\";s:32:\"82b2706dfa20a7b0cfabfe7ff28562f9\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SV\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:31:\"revslider-explodinglayers-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"549\";s:9:\"releaseid\";s:2:\"22\";s:4:\"slug\";s:31:\"revslider-explodinglayers-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Exploding Layers\";s:6:\"line_1\";s:23:\"Add explosive particles\";s:6:\"line_2\";s:24:\"to your layers animation\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"150\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_exploding.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_exploding.jpg\";s:7:\"img_md5\";s:32:\"44d60b83cdf5b29033d41feb516b47e1\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"EL\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-sharing-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"564\";s:9:\"releaseid\";s:1:\"5\";s:4:\"slug\";s:23:\"revslider-sharing-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Social Sharing\";s:6:\"line_1\";s:17:\"Share your slides\";s:6:\"line_2\";s:50:\"with RevSlider \"actions\" because sharing is caring\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"165\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:80:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_socialsharing.jpg\";s:8:\"img_file\";s:47:\"revslider/addons/images/addon_socialsharing.jpg\";s:7:\"img_md5\";s:32:\"6b074630853c4f95d5337bc85e496cbe\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SH\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-whiteboard-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"571\";s:9:\"releaseid\";s:1:\"1\";s:4:\"slug\";s:26:\"revslider-whiteboard-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Whiteboard\";s:6:\"line_1\";s:31:\"Create Hand-Drawn Presentations\";s:6:\"line_2\";s:45:\"that are understandable, memorable & engaging\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:81:\"//updates.themepunch-ext-b.tools/revslider/addons/images/whiteboard_widget_bg.jpg\";s:15:\"background_file\";s:48:\"revslider/addons/images/whiteboard_widget_bg.jpg\";s:14:\"background_md5\";s:32:\"cc69160eb95469dc033e0cc094a24847\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"170\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_whiteboard.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_whiteboard.jpg\";s:7:\"img_md5\";s:32:\"b0bb636fb30ffc3d112ba4c563395ee6\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-polyfold-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"560\";s:9:\"releaseid\";s:2:\"14\";s:4:\"slug\";s:24:\"revslider-polyfold-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:22:\"Polyfold Scroll Effect\";s:6:\"line_1\";s:32:\"Add sharp edges to your sliders \";s:6:\"line_2\";s:35:\"as they scroll into and out of view\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"180\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:75:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_polyfold.jpg\";s:8:\"img_file\";s:42:\"revslider/addons/images/addon_polyfold.jpg\";s:7:\"img_md5\";s:32:\"02c6af89e4208f0da5920c6c3e6bb744\";s:5:\"color\";s:7:\"#3e186f\";s:4:\"text\";s:2:\"PF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:29:\"revslider-domain-switch-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"78\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:29:\"revslider-domain-switch-addon\";s:12:\"version_from\";s:5:\"6.0.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Domain Switch\";s:6:\"line_1\";s:17:\"Switch Image URLs\";s:6:\"line_2\";s:37:\"in sliders from one domain to another\";s:9:\"available\";s:5:\"1.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"300\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:79:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_domainswitch.jpg\";s:8:\"img_file\";s:46:\"revslider/addons/images/addon_domainswitch.jpg\";s:7:\"img_md5\";s:32:\"f2036924e7993f94bd5c9876fa0bf09b\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"DS\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-refresh-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"561\";s:9:\"releaseid\";s:2:\"10\";s:4:\"slug\";s:23:\"revslider-refresh-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:8:\"(Re)Load\";s:6:\"line_1\";s:39:\"Reload the current page or a custom URL\";s:6:\"line_2\";s:34:\"after a certain time, loops, slide\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"330\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_reload.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_reload.jpg\";s:7:\"img_md5\";s:32:\"d1d34d204e627168f4cc4e7422a6d40c\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-rel-posts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"55\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:25:\"revslider-rel-posts-addon\";s:12:\"version_from\";s:7:\"5.2.4.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Related Posts\";s:6:\"line_1\";s:25:\"Add related Posts Sliders\";s:6:\"line_2\";s:31:\"at the end of your post content\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"340\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wprelated.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_wprelated.jpg\";s:7:\"img_md5\";s:32:\"e2e7d6c3a428a55442ba90131556c930\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"RP\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:20:\"revslider-snow-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"566\";s:9:\"releaseid\";s:1:\"6\";s:4:\"slug\";s:20:\"revslider-snow-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:12:\"Holiday Snow\";s:6:\"line_1\";s:12:\"Let it snow!\";s:6:\"line_2\";s:32:\"Add animated snow to any Slider \";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"380\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:71:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_snow.jpg\";s:8:\"img_file\";s:38:\"revslider/addons/images/addon_snow.jpg\";s:7:\"img_md5\";s:32:\"d6bac718866b0070198a4340041bc60b\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"SN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-gallery-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"378\";s:9:\"releaseid\";s:1:\"2\";s:4:\"slug\";s:23:\"revslider-gallery-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"WordPress Gallery\";s:6:\"line_1\";s:31:\"Replace the standard WP Gallery\";s:6:\"line_2\";s:31:\"with the Sliders of your choice\";s:9:\"available\";s:5:\"2.0.7\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"430\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wpgallery.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_wpgallery.jpg\";s:7:\"img_md5\";s:32:\"74392a04b741d83c51e55059dbb388ef\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"GA\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-backup-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"53\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:22:\"revslider-backup-addon\";s:12:\"version_from\";s:5:\"5.2.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Backup\";s:6:\"line_1\";s:12:\"Make Backups\";s:6:\"line_2\";s:25:\"Revisions for your safety\";s:9:\"available\";s:5:\"2.0.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:3:\"500\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_backup.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_backup.jpg\";s:7:\"img_md5\";s:32:\"104797323a0293cd3f200b0172db1186\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BU\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:19:\"revslider-404-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"62\";s:9:\"releaseid\";s:1:\"8\";s:4:\"slug\";s:19:\"revslider-404-addon\";s:12:\"version_from\";s:3:\"5.3\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:3:\"404\";s:6:\"line_1\";s:39:\"Build custom 404 \"Page not Found\" Pages\";s:6:\"line_2\";s:28:\"with Slider Revolution swag!\";s:9:\"available\";s:5:\"2.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"620\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:70:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_404.jpg\";s:8:\"img_file\";s:37:\"revslider/addons/images/addon_404.jpg\";s:7:\"img_md5\";s:32:\"217b0d118a107dc50979740dd61228df\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"404\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-prevnext-posts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:2:\"63\";s:9:\"releaseid\";s:1:\"9\";s:4:\"slug\";s:30:\"revslider-prevnext-posts-addon\";s:12:\"version_from\";s:3:\"5.4\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Adjacent Posts\";s:6:\"line_1\";s:30:\"Display previous and next post\";s:6:\"line_2\";s:28:\"to the currently showing one\";s:9:\"available\";s:5:\"2.0.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"630\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wpadjacent.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_wpadjacent.jpg\";s:7:\"img_md5\";s:32:\"cb1feb1257e55d0f42c29dfde2d809ed\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PN\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:21:\"revslider-login-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"388\";s:9:\"releaseid\";s:2:\"11\";s:4:\"slug\";s:21:\"revslider-login-addon\";s:12:\"version_from\";s:5:\"6.5.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Login Page\";s:6:\"line_1\";s:25:\"Very simple WP Login Page\";s:6:\"line_2\";s:34:\"enhanced with your favorite slider\";s:9:\"available\";s:5:\"3.0.2\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"650\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:72:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_login.jpg\";s:8:\"img_file\";s:39:\"revslider/addons/images/addon_login.jpg\";s:7:\"img_md5\";s:32:\"f0f2edffb4e155acf67799692428644d\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LI\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:24:\"revslider-featured-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"379\";s:9:\"releaseid\";s:2:\"12\";s:4:\"slug\";s:24:\"revslider-featured-addon\";s:12:\"version_from\";s:6:\"6.4.11\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Post Featured Slider\";s:6:\"line_1\";s:25:\"Display a featured Slider\";s:6:\"line_2\";s:41:\"instead of a featured Image in your Posts\";s:9:\"available\";s:5:\"2.0.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"660\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:1;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_wpfeatured.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_wpfeatured.jpg\";s:7:\"img_md5\";s:32:\"bcc840e68194f3eb05795e1353954bda\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:23:\"revslider-weather-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"570\";s:9:\"releaseid\";s:2:\"16\";s:4:\"slug\";s:23:\"revslider-weather-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Weather\";s:6:\"line_1\";s:21:\"Every where you go...\";s:6:\"line_2\";s:36:\"...always take the weather with you!\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:3:\"690\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_weather.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_weather.jpg\";s:7:\"img_md5\";s:32:\"c69d1c9a69c2dec43ca0578ac35792bd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"WT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-duotonefilters-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"548\";s:9:\"releaseid\";s:2:\"18\";s:4:\"slug\";s:30:\"revslider-duotonefilters-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:7:\"Duotone\";s:6:\"line_1\";s:7:\"Duotone\";s:6:\"line_2\";s:25:\"Because one is not enough\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:3:\"710\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-b.tools/revslider/addons/images/addon_duotone.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_duotone.jpg\";s:7:\"img_md5\";s:32:\"fb666e487e7ac28e6a2a157eed1fb682\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:3:\"DTF\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("199", "revslider-library-check", "1732013142", "yes");
INSERT INTO `wp_options` VALUES("200", "revslider-library-hash", "dae3de1eb57eeeee008b70e9a23844b5", "yes");
INSERT INTO `wp_options` VALUES("201", "rs-library", "a:3:{s:4:\"hash\";s:32:\"dae3de1eb57eeeee008b70e9a23844b5\";s:7:\"objects\";a:417:{i:0;a:12:{s:2:\"id\";s:3:\"198\";s:6:\"handle\";s:16:\"object_dvd_1.png\";s:4:\"name\";s:3:\"DVD\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:43:17\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:1;a:12:{s:2:\"id\";s:3:\"188\";s:6:\"handle\";s:18:\"object_plant_1.png\";s:4:\"name\";s:7:\"Plant 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:2;a:12:{s:2:\"id\";s:3:\"187\";s:6:\"handle\";s:16:\"object_pen_1.png\";s:4:\"name\";s:5:\"Pen 1\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-12 16:25:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:3;a:12:{s:2:\"id\";s:3:\"172\";s:6:\"handle\";s:16:\"object_egg_1.png\";s:4:\"name\";s:3:\"Egg\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"600\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:4;a:12:{s:2:\"id\";s:3:\"171\";s:6:\"handle\";s:19:\"object_guitar_1.png\";s:4:\"name\";s:6:\"Guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:5;a:12:{s:2:\"id\";s:3:\"170\";s:6:\"handle\";s:21:\"object_envelope_1.png\";s:4:\"name\";s:15:\"Closed Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:6;a:12:{s:2:\"id\";s:3:\"169\";s:6:\"handle\";s:19:\"object_postit_2.png\";s:4:\"name\";s:18:\"Postit Label White\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:7;a:12:{s:2:\"id\";s:3:\"168\";s:6:\"handle\";s:21:\"object_envelope_2.png\";s:4:\"name\";s:13:\"Open Envelope\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:8;a:12:{s:2:\"id\";s:3:\"167\";s:6:\"handle\";s:17:\"object_eggs_1.png\";s:4:\"name\";s:10:\"Egg Carton\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:9;a:12:{s:2:\"id\";s:3:\"166\";s:6:\"handle\";s:25:\"object_bottleopener_1.png\";s:4:\"name\";s:13:\"Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:10;a:12:{s:2:\"id\";s:3:\"165\";s:6:\"handle\";s:23:\"object_blueprints_1.png\";s:4:\"name\";s:10:\"Blueprints\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:11;a:12:{s:2:\"id\";s:3:\"164\";s:6:\"handle\";s:22:\"object_holepunch_1.png\";s:4:\"name\";s:10:\"Hole punch\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:12;a:12:{s:2:\"id\";s:3:\"163\";s:6:\"handle\";s:20:\"object_speaker_1.png\";s:4:\"name\";s:13:\"Black Speaker\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:13;a:12:{s:2:\"id\";s:3:\"162\";s:6:\"handle\";s:19:\"object_eraser_1.png\";s:4:\"name\";s:6:\"Eraser\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"500\";s:6:\"height\";s:3:\"500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:14;a:12:{s:2:\"id\";s:3:\"161\";s:6:\"handle\";s:23:\"object_vinylcover_1.png\";s:4:\"name\";s:11:\"Vinyl Cover\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:15;a:12:{s:2:\"id\";s:3:\"160\";s:6:\"handle\";s:20:\"object_booklet_1.png\";s:4:\"name\";s:9:\"Booklet 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:16;a:12:{s:2:\"id\";s:3:\"159\";s:6:\"handle\";s:22:\"object_earphones_2.png\";s:4:\"name\";s:11:\"Earphones 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:17;a:12:{s:2:\"id\";s:3:\"158\";s:6:\"handle\";s:18:\"object_vinyl_1.png\";s:4:\"name\";s:5:\"Vinyl\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:18;a:12:{s:2:\"id\";s:3:\"157\";s:6:\"handle\";s:19:\"object_postit_1.png\";s:4:\"name\";s:17:\"Postit Label Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:19;a:12:{s:2:\"id\";s:3:\"156\";s:6:\"handle\";s:23:\"object_mechpencil_1.png\";s:4:\"name\";s:17:\"Mechanical Pencil\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:20;a:12:{s:2:\"id\";s:3:\"155\";s:6:\"handle\";s:22:\"object_turntable_1.png\";s:4:\"name\";s:9:\"Turntable\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:21;a:12:{s:2:\"id\";s:3:\"154\";s:6:\"handle\";s:19:\"object_folder_2.png\";s:4:\"name\";s:19:\"Closed Folder Black\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:22;a:12:{s:2:\"id\";s:3:\"153\";s:6:\"handle\";s:19:\"object_postit_4.png\";s:4:\"name\";s:18:\"Postit Label Green\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:23;a:12:{s:2:\"id\";s:3:\"152\";s:6:\"handle\";s:19:\"object_folder_1.png\";s:4:\"name\";s:12:\"Blank Folder\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:24;a:12:{s:2:\"id\";s:3:\"151\";s:6:\"handle\";s:19:\"object_pencup_1.png\";s:4:\"name\";s:7:\"Pen Cup\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:25;a:12:{s:2:\"id\";s:3:\"150\";s:6:\"handle\";s:23:\"object_winebottle_1.png\";s:4:\"name\";s:15:\"Red Wine Bottle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:26;a:12:{s:2:\"id\";s:3:\"149\";s:6:\"handle\";s:23:\"object_headphones_1.png\";s:4:\"name\";s:10:\"Headphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:27;a:12:{s:2:\"id\";s:3:\"148\";s:6:\"handle\";s:22:\"object_earphones_1.png\";s:4:\"name\";s:9:\"Earphones\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:28;a:12:{s:2:\"id\";s:3:\"147\";s:6:\"handle\";s:19:\"object_postit_3.png\";s:4:\"name\";s:19:\"Postit Label Yellow\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:29;a:12:{s:2:\"id\";s:3:\"146\";s:6:\"handle\";s:22:\"object_corkscrew_1.png\";s:4:\"name\";s:23:\"Corkscrew Bottle Opener\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1300\";s:6:\"height\";s:4:\"1300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-18 15:34:49\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:30;a:12:{s:2:\"id\";s:3:\"145\";s:6:\"handle\";s:19:\"object_muffin_1.png\";s:4:\"name\";s:16:\"Chocolate Muffin\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"900\";s:6:\"height\";s:3:\"900\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:31;a:12:{s:2:\"id\";s:3:\"144\";s:6:\"handle\";s:18:\"object_chair_2.png\";s:4:\"name\";s:12:\"Yellow Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:32;a:12:{s:2:\"id\";s:3:\"143\";s:6:\"handle\";s:18:\"object_knife_2.png\";s:4:\"name\";s:7:\"Knife 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:33;a:12:{s:2:\"id\";s:3:\"142\";s:6:\"handle\";s:26:\"object_choppingboard_2.png\";s:4:\"name\";s:16:\"Chopping Board 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:34;a:12:{s:2:\"id\";s:3:\"141\";s:6:\"handle\";s:26:\"object_choppingboard_3.png\";s:4:\"name\";s:16:\"Chopping Board 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:35;a:12:{s:2:\"id\";s:3:\"140\";s:6:\"handle\";s:19:\"object_coffee_2.png\";s:4:\"name\";s:12:\"Coffee Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1200\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:36;a:12:{s:2:\"id\";s:3:\"139\";s:6:\"handle\";s:18:\"object_bread_1.png\";s:4:\"name\";s:15:\"Croissant Bread\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:37;a:12:{s:2:\"id\";s:3:\"138\";s:6:\"handle\";s:18:\"object_spoon_2.png\";s:4:\"name\";s:12:\"Wodden Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:38;a:12:{s:2:\"id\";s:3:\"137\";s:6:\"handle\";s:26:\"object_choppingboard_1.png\";s:4:\"name\";s:16:\"Chopping Board 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:39;a:12:{s:2:\"id\";s:3:\"136\";s:6:\"handle\";s:16:\"object_cup_2.png\";s:4:\"name\";s:11:\"Empty Cup 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:40;a:12:{s:2:\"id\";s:3:\"135\";s:6:\"handle\";s:18:\"object_knife_1.png\";s:4:\"name\";s:5:\"Knife\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:41;a:12:{s:2:\"id\";s:3:\"134\";s:6:\"handle\";s:18:\"object_spoon_1.png\";s:4:\"name\";s:5:\"Spoon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:42;a:12:{s:2:\"id\";s:3:\"133\";s:6:\"handle\";s:16:\"object_cup_1.png\";s:4:\"name\";s:9:\"Empty Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:43;a:12:{s:2:\"id\";s:3:\"132\";s:6:\"handle\";s:18:\"object_chair_3.png\";s:4:\"name\";s:11:\"White Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:44;a:12:{s:2:\"id\";s:3:\"131\";s:6:\"handle\";s:19:\"object_coffee_1.png\";s:4:\"name\";s:10:\"Coffee Cup\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:45;a:12:{s:2:\"id\";s:3:\"130\";s:6:\"handle\";s:19:\"object_frypan_2.png\";s:4:\"name\";s:9:\"Fry Pan 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:46;a:12:{s:2:\"id\";s:3:\"129\";s:6:\"handle\";s:19:\"object_frypan_1.png\";s:4:\"name\";s:9:\"Fry Pan 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:47;a:12:{s:2:\"id\";s:3:\"128\";s:6:\"handle\";s:17:\"object_fork_1.png\";s:4:\"name\";s:4:\"Fork\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:48;a:12:{s:2:\"id\";s:3:\"127\";s:6:\"handle\";s:20:\"object_dishrag_1.png\";s:4:\"name\";s:13:\"Dishrag Cloth\";s:4:\"tags\";a:0:{}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-17 13:48:44\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:49;a:12:{s:2:\"id\";s:3:\"126\";s:6:\"handle\";s:20:\"object_wacom_pen.png\";s:4:\"name\";s:17:\"Wacom Drawing Pen\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1060\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:50;a:12:{s:2:\"id\";s:3:\"125\";s:6:\"handle\";s:21:\"object_occulus_vr.png\";s:4:\"name\";s:23:\"Occulus Virtual Reality\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:51;a:12:{s:2:\"id\";s:3:\"124\";s:6:\"handle\";s:18:\"object_antenna.png\";s:4:\"name\";s:13:\"Antenna Radar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:52;a:12:{s:2:\"id\";s:3:\"123\";s:6:\"handle\";s:21:\"object_solarpanel.png\";s:4:\"name\";s:11:\"Solar Panel\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:53;a:12:{s:2:\"id\";s:3:\"122\";s:6:\"handle\";s:16:\"object_wacom.png\";s:4:\"name\";s:20:\"Wacom Drawing Tablet\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:54;a:12:{s:2:\"id\";s:3:\"121\";s:6:\"handle\";s:18:\"object_earth_2.png\";s:4:\"name\";s:20:\"Earth Globe Planet 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:55;a:12:{s:2:\"id\";s:3:\"120\";s:6:\"handle\";s:18:\"object_chair_1.png\";s:4:\"name\";s:12:\"Office Chair\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:56;a:12:{s:2:\"id\";s:3:\"119\";s:6:\"handle\";s:24:\"object_windturbine_2.png\";s:4:\"name\";s:14:\"Wind Turbine 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:57;a:12:{s:2:\"id\";s:3:\"118\";s:6:\"handle\";s:22:\"object_windturbine.png\";s:4:\"name\";s:12:\"Wind Turbine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:58;a:12:{s:2:\"id\";s:3:\"117\";s:6:\"handle\";s:16:\"object_earth.png\";s:4:\"name\";s:18:\"Earth Globe Planet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 16:50:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:59;a:12:{s:2:\"id\";s:2:\"88\";s:6:\"handle\";s:24:\"object_eiffeltower_2.png\";s:4:\"name\";s:13:\"Eiffeltower 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:60;a:12:{s:2:\"id\";s:2:\"87\";s:6:\"handle\";s:21:\"object_notebook_1.png\";s:4:\"name\";s:11:\"Notebook PC\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:61;a:12:{s:2:\"id\";s:2:\"86\";s:6:\"handle\";s:20:\"object_macbook_1.png\";s:4:\"name\";s:20:\"Apple Macbook Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:62;a:12:{s:2:\"id\";s:2:\"85\";s:6:\"handle\";s:18:\"object_canon_2.png\";s:4:\"name\";s:21:\"Canon Camera DSLR Top\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:63;a:12:{s:2:\"id\";s:2:\"84\";s:6:\"handle\";s:19:\"object_iphone_3.png\";s:4:\"name\";s:25:\"Apple iPhone Silver White\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:64;a:12:{s:2:\"id\";s:2:\"83\";s:6:\"handle\";s:18:\"object_candy_2.png\";s:4:\"name\";s:15:\"Candy Colored 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:65;a:12:{s:2:\"id\";s:2:\"82\";s:6:\"handle\";s:21:\"object_macmouse_1.png\";s:4:\"name\";s:15:\"Apple Mac Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:66;a:12:{s:2:\"id\";s:2:\"81\";s:6:\"handle\";s:19:\"object_iphone_1.png\";s:4:\"name\";s:18:\"Apple iPhone Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:67;a:12:{s:2:\"id\";s:2:\"80\";s:6:\"handle\";s:17:\"object_deco_1.png\";s:4:\"name\";s:17:\"White Deco Object\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:68;a:12:{s:2:\"id\";s:2:\"79\";s:6:\"handle\";s:23:\"object_applewatch_1.png\";s:4:\"name\";s:24:\"Apple Watch White Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:69;a:12:{s:2:\"id\";s:2:\"78\";s:6:\"handle\";s:23:\"object_swissknife_1.png\";s:4:\"name\";s:11:\"Swiss Knife\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:70;a:12:{s:2:\"id\";s:2:\"77\";s:6:\"handle\";s:23:\"object_applewatch_2.png\";s:4:\"name\";s:17:\"Apple Watch Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:71;a:12:{s:2:\"id\";s:2:\"76\";s:6:\"handle\";s:18:\"object_candy_1.png\";s:4:\"name\";s:13:\"Candy Colored\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:72;a:12:{s:2:\"id\";s:2:\"75\";s:6:\"handle\";s:17:\"object_ipad_1.png\";s:4:\"name\";s:16:\"Apple iPad Black\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:73;a:12:{s:2:\"id\";s:2:\"74\";s:6:\"handle\";s:17:\"object_lamp_2.png\";s:4:\"name\";s:15:\"Black Desk Lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:74;a:12:{s:2:\"id\";s:2:\"73\";s:6:\"handle\";s:18:\"object_canon_1.png\";s:4:\"name\";s:17:\"Canon Camera DLSR\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:75;a:12:{s:2:\"id\";s:2:\"72\";s:6:\"handle\";s:23:\"object_blackberry_2.png\";s:4:\"name\";s:12:\"Blackberry 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:76;a:12:{s:2:\"id\";s:2:\"71\";s:6:\"handle\";s:19:\"object_iphone_2.png\";s:4:\"name\";s:19:\"Apple iPhone Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:77;a:12:{s:2:\"id\";s:2:\"70\";s:6:\"handle\";s:17:\"object_ipad_2.png\";s:4:\"name\";s:15:\"Apple iPad Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:78;a:12:{s:2:\"id\";s:2:\"69\";s:6:\"handle\";s:20:\"object_printer_1.png\";s:4:\"name\";s:7:\"Printer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:79;a:12:{s:2:\"id\";s:2:\"68\";s:6:\"handle\";s:20:\"object_pcmouse_1.png\";s:4:\"name\";s:14:\"Black PC Mouse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:80;a:12:{s:2:\"id\";s:2:\"67\";s:6:\"handle\";s:17:\"object_ipad_3.png\";s:4:\"name\";s:17:\"Apple iPad Silver\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:81;a:12:{s:2:\"id\";s:2:\"66\";s:6:\"handle\";s:17:\"object_lamp_1.png\";s:4:\"name\";s:13:\"Desk Lamp Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:82;a:12:{s:2:\"id\";s:2:\"65\";s:6:\"handle\";s:22:\"object_macscreen_1.png\";s:4:\"name\";s:16:\"Apple Mac Screen\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"2000\";s:6:\"height\";s:4:\"2000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:83;a:12:{s:2:\"id\";s:2:\"64\";s:6:\"handle\";s:23:\"object_blackberry_3.png\";s:4:\"name\";s:12:\"Blackberry 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:84;a:12:{s:2:\"id\";s:2:\"63\";s:6:\"handle\";s:23:\"object_applewatch_3.png\";s:4:\"name\";s:16:\"Apple Watch Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"800\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:85;a:12:{s:2:\"id\";s:2:\"62\";s:6:\"handle\";s:23:\"object_blackberry_1.png\";s:4:\"name\";s:10:\"Blackberry\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 16:51:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:86;a:12:{s:2:\"id\";s:2:\"49\";s:6:\"handle\";s:19:\"object_bottle_1.png\";s:4:\"name\";s:18:\"Brown Glass Bottle\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:1;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:87;a:12:{s:2:\"id\";s:2:\"48\";s:6:\"handle\";s:20:\"object_glasses_1.png\";s:4:\"name\";s:19:\"Hipster Glasses Top\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:88;a:12:{s:2:\"id\";s:2:\"47\";s:6:\"handle\";s:21:\"object_magazine_1.png\";s:4:\"name\";s:14:\"Blank Magazine\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:89;a:12:{s:2:\"id\";s:2:\"46\";s:6:\"handle\";s:28:\"object_leatherdocument_2.png\";s:4:\"name\";s:24:\"Black Leather Document 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:90;a:12:{s:2:\"id\";s:2:\"45\";s:6:\"handle\";s:18:\"object_purse_2.png\";s:4:\"name\";s:13:\"Black Purse 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:91;a:12:{s:2:\"id\";s:2:\"44\";s:6:\"handle\";s:23:\"object_typewriter_1.png\";s:4:\"name\";s:18:\"Retro Typewriter 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:92;a:12:{s:2:\"id\";s:2:\"43\";s:6:\"handle\";s:17:\"object_book_5.png\";s:4:\"name\";s:9:\"Old Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:93;a:12:{s:2:\"id\";s:2:\"42\";s:6:\"handle\";s:28:\"object_leatherdocument_1.png\";s:4:\"name\";s:29:\"Black Leather Document Closed\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:94;a:12:{s:2:\"id\";s:2:\"41\";s:6:\"handle\";s:17:\"object_book_4.png\";s:4:\"name\";s:8:\"Old Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:95;a:12:{s:2:\"id\";s:2:\"40\";s:6:\"handle\";s:19:\"object_wallet_2.png\";s:4:\"name\";s:22:\"Black Leather Document\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:96;a:12:{s:2:\"id\";s:2:\"39\";s:6:\"handle\";s:18:\"object_quill_2.png\";s:4:\"name\";s:15:\"Quill Feather 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:97;a:12:{s:2:\"id\";s:2:\"38\";s:6:\"handle\";s:24:\"object_eiffeltower_1.png\";s:4:\"name\";s:11:\"Eiffeltower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:98;a:12:{s:2:\"id\";s:2:\"37\";s:6:\"handle\";s:21:\"object_magazine_2.png\";s:4:\"name\";s:11:\"Open Book 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1333\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:99;a:12:{s:2:\"id\";s:2:\"36\";s:6:\"handle\";s:17:\"object_book_1.png\";s:4:\"name\";s:10:\"Blank Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:100;a:12:{s:2:\"id\";s:2:\"35\";s:6:\"handle\";s:20:\"object_glasses_2.png\";s:4:\"name\";s:15:\"Hipster Glasses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:101;a:12:{s:2:\"id\";s:2:\"34\";s:6:\"handle\";s:17:\"object_book_2.png\";s:4:\"name\";s:11:\"Open Book 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:102;a:12:{s:2:\"id\";s:2:\"33\";s:6:\"handle\";s:19:\"object_gloves_1.png\";s:4:\"name\";s:12:\"Black Gloves\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:103;a:12:{s:2:\"id\";s:2:\"32\";s:6:\"handle\";s:23:\"object_typewriter_2.png\";s:4:\"name\";s:16:\"Retro Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:104;a:12:{s:2:\"id\";s:2:\"31\";s:6:\"handle\";s:17:\"object_book_3.png\";s:4:\"name\";s:9:\"Open Book\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:105;a:12:{s:2:\"id\";s:2:\"30\";s:6:\"handle\";s:19:\"object_wallet_1.png\";s:4:\"name\";s:12:\"Black Wallet\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1500\";s:6:\"height\";s:4:\"1500\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:106;a:12:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:18:\"object_purse_1.png\";s:4:\"name\";s:11:\"Black Purse\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:107;a:12:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:18:\"object_quill_1.png\";s:4:\"name\";s:13:\"Quill Feather\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 12:57:32\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:108;a:12:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:19:\"object_artbox_2.png\";s:4:\"name\";s:16:\"Art Box Colors 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:109;a:12:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:18:\"object_cloth_1.png\";s:4:\"name\";s:17:\"Cloth Paint Color\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:110;a:12:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:21:\"object_brushpot_1.png\";s:4:\"name\";s:9:\"Brush Pot\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"984\";s:6:\"height\";s:3:\"984\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:111;a:12:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:24:\"object_paintbucket_1.png\";s:4:\"name\";s:12:\"Paint Bucket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1400\";s:6:\"height\";s:4:\"1400\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:112;a:12:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:23:\"object_paintbrush_2.png\";s:4:\"name\";s:12:\"Paintbrush 3\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:3:\"700\";s:6:\"height\";s:3:\"700\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:113;a:12:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:19:\"object_artbox_1.png\";s:4:\"name\";s:14:\"Art Box Colors\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:114;a:12:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:23:\"object_paintbrush_3.png\";s:4:\"name\";s:12:\"Paintbrush 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:115;a:12:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:23:\"object_paintbrush_1.png\";s:4:\"name\";s:12:\"Paintbrush 1\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1000\";s:6:\"height\";s:4:\"1000\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-12 10:59:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:116;a:12:{s:2:\"id\";s:2:\"11\";s:6:\"handle\";s:21:\"table_radio_right.png\";s:4:\"name\";s:18:\"Radio Speaker Wood\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:117;a:12:{s:2:\"id\";s:2:\"10\";s:6:\"handle\";s:18:\"keyboard_apple.png\";s:4:\"name\";s:14:\"Apple Keyboard\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:118;a:12:{s:2:\"id\";s:1:\"9\";s:6:\"handle\";s:20:\"macbook_top_gold.png\";s:4:\"name\";s:18:\"Apple Macbook Gold\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1600\";s:6:\"height\";s:4:\"1600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:119;a:12:{s:2:\"id\";s:1:\"8\";s:6:\"handle\";s:21:\"nexus6_front_blue.png\";s:4:\"name\";s:19:\"Google Nexus 6 Blue\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:1;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1100\";s:6:\"height\";s:4:\"1100\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-11 13:37:51\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"1\";}i:120;a:12:{s:2:\"id\";s:3:\"479\";s:6:\"handle\";s:31:\"Tram-beside-waiting-station.jpg\";s:4:\"name\";s:27:\"Tram beside waiting station\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:52:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:121;a:12:{s:2:\"id\";s:3:\"478\";s:6:\"handle\";s:14:\"Pulling-up.jpg\";s:4:\"name\";s:10:\"Pulling up\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1297\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:122;a:12:{s:2:\"id\";s:3:\"477\";s:6:\"handle\";s:16:\"Snowboarding.jpg\";s:4:\"name\";s:12:\"Snowboarding\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1290\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:41:20\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:123;a:12:{s:2:\"id\";s:3:\"476\";s:6:\"handle\";s:16:\"Morning-yoga.jpg\";s:4:\"name\";s:12:\"Morning yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1346\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:124;a:12:{s:2:\"id\";s:3:\"475\";s:6:\"handle\";s:8:\"Yoga.jpg\";s:4:\"name\";s:4:\"Yoga\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:125;a:12:{s:2:\"id\";s:3:\"474\";s:6:\"handle\";s:14:\"Golf-balls.jpg\";s:4:\"name\";s:10:\"Golf balls\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:126;a:12:{s:2:\"id\";s:3:\"473\";s:6:\"handle\";s:19:\"Confident-Boxer.jpg\";s:4:\"name\";s:15:\"Confident Boxer\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:127;a:12:{s:2:\"id\";s:3:\"472\";s:6:\"handle\";s:11:\"Aerobic.jpg\";s:4:\"name\";s:7:\"Aerobic\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:40:23\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:128;a:12:{s:2:\"id\";s:3:\"471\";s:6:\"handle\";s:18:\"Riding-bicycle.jpg\";s:4:\"name\";s:14:\"Riding bicycle\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1358\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:129;a:12:{s:2:\"id\";s:3:\"470\";s:6:\"handle\";s:27:\"woman-with-barbell-back.jpg\";s:4:\"name\";s:23:\"woman with barbell back\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:130;a:12:{s:2:\"id\";s:3:\"469\";s:6:\"handle\";s:24:\"Woman-lying-on-floor.jpg\";s:4:\"name\";s:20:\"Woman lying on floor\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1318\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:131;a:12:{s:2:\"id\";s:3:\"468\";s:6:\"handle\";s:27:\"Holding-black-dumbbells.jpg\";s:4:\"name\";s:23:\"Holding black dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:132;a:12:{s:2:\"id\";s:3:\"467\";s:6:\"handle\";s:25:\"Woman-using-dumbbells.jpg\";s:4:\"name\";s:21:\"Woman using dumbbells\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1425\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:133;a:12:{s:2:\"id\";s:3:\"466\";s:6:\"handle\";s:16:\"Soccer-cleat.jpg\";s:4:\"name\";s:12:\"Soccer cleat\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:134;a:12:{s:2:\"id\";s:3:\"465\";s:6:\"handle\";s:16:\"Soccer-field.jpg\";s:4:\"name\";s:12:\"Soccer field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:135;a:12:{s:2:\"id\";s:3:\"464\";s:6:\"handle\";s:23:\"Man-tying-his-shoes.jpg\";s:4:\"name\";s:19:\"Man tying his shoes\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1200\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:136;a:12:{s:2:\"id\";s:3:\"463\";s:6:\"handle\";s:10:\"Boxing.jpg\";s:4:\"name\";s:6:\"Boxing\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:137;a:12:{s:2:\"id\";s:3:\"462\";s:6:\"handle\";s:22:\"woman-with-barbell.jpg\";s:4:\"name\";s:18:\"woman with barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:138;a:12:{s:2:\"id\";s:3:\"461\";s:6:\"handle\";s:12:\"Crossfit.jpg\";s:4:\"name\";s:8:\"Crossfit\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:139;a:12:{s:2:\"id\";s:3:\"460\";s:6:\"handle\";s:25:\"Man-and-woman-jogging.jpg\";s:4:\"name\";s:21:\"Man and woman jogging\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:140;a:12:{s:2:\"id\";s:3:\"459\";s:6:\"handle\";s:16:\"Playing-golf.jpg\";s:4:\"name\";s:12:\"Playing golf\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:141;a:12:{s:2:\"id\";s:3:\"458\";s:6:\"handle\";s:18:\"Surfer-in-wave.jpg\";s:4:\"name\";s:14:\"Surfer in wave\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:142;a:12:{s:2:\"id\";s:3:\"457\";s:6:\"handle\";s:25:\"Woman-lifting-barbell.jpg\";s:4:\"name\";s:21:\"Woman lifting barbell\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:143;a:12:{s:2:\"id\";s:3:\"456\";s:6:\"handle\";s:14:\"Stretching.jpg\";s:4:\"name\";s:10:\"Stretching\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:144;a:12:{s:2:\"id\";s:3:\"455\";s:6:\"handle\";s:18:\"Snowboarding-2.jpg\";s:4:\"name\";s:14:\"Snowboarding 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:145;a:12:{s:2:\"id\";s:3:\"454\";s:6:\"handle\";s:11:\"Balance.jpg\";s:4:\"name\";s:7:\"Balance\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:146;a:12:{s:2:\"id\";s:3:\"453\";s:6:\"handle\";s:19:\"Pool-meditation.jpg\";s:4:\"name\";s:15:\"Pool meditation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:147;a:12:{s:2:\"id\";s:3:\"452\";s:6:\"handle\";s:18:\"Soccer-stadium.jpg\";s:4:\"name\";s:14:\"Soccer stadium\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:148;a:12:{s:2:\"id\";s:3:\"451\";s:6:\"handle\";s:25:\"Soccer-field-top-view.jpg\";s:4:\"name\";s:21:\"Soccer field top view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:149;a:12:{s:2:\"id\";s:3:\"450\";s:6:\"handle\";s:14:\"Basketball.jpg\";s:4:\"name\";s:10:\"Basketball\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:150;a:12:{s:2:\"id\";s:3:\"449\";s:6:\"handle\";s:14:\"in-the-fog.jpg\";s:4:\"name\";s:10:\"in the fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:151;a:12:{s:2:\"id\";s:3:\"448\";s:6:\"handle\";s:13:\"Handstand.jpg\";s:4:\"name\";s:9:\"Handstand\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:38:24\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:152;a:12:{s:2:\"id\";s:3:\"447\";s:6:\"handle\";s:11:\"Friends.jpg\";s:4:\"name\";s:7:\"Friends\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:153;a:12:{s:2:\"id\";s:3:\"446\";s:6:\"handle\";s:28:\"Sneakers-on-the-railroad.jpg\";s:4:\"name\";s:24:\"Sneakers on the railroad\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:154;a:12:{s:2:\"id\";s:3:\"445\";s:6:\"handle\";s:23:\"Family-on-the-ocean.jpg\";s:4:\"name\";s:19:\"Family on the ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:155;a:12:{s:2:\"id\";s:3:\"444\";s:6:\"handle\";s:10:\"Sunset.jpg\";s:4:\"name\";s:6:\"Sunset\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:156;a:12:{s:2:\"id\";s:3:\"443\";s:6:\"handle\";s:9:\"Books.jpg\";s:4:\"name\";s:5:\"Books\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:157;a:12:{s:2:\"id\";s:3:\"442\";s:6:\"handle\";s:25:\"Looking-at-the-window.jpg\";s:4:\"name\";s:21:\"Looking at the window\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:158;a:12:{s:2:\"id\";s:3:\"441\";s:6:\"handle\";s:48:\"woman-standing-near-buildings-during-daytime.jpg\";s:4:\"name\";s:44:\"woman standing near buildings during daytime\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:159;a:12:{s:2:\"id\";s:3:\"440\";s:6:\"handle\";s:12:\"Lollipop.jpg\";s:4:\"name\";s:8:\"Lollipop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1395\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:160;a:12:{s:2:\"id\";s:3:\"439\";s:6:\"handle\";s:26:\"People-crossing-street.jpg\";s:4:\"name\";s:22:\"People crossing street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:161;a:12:{s:2:\"id\";s:3:\"438\";s:6:\"handle\";s:24:\"Friends-on-the-shore.jpg\";s:4:\"name\";s:20:\"Friends on the shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:162;a:12:{s:2:\"id\";s:3:\"437\";s:6:\"handle\";s:13:\"Coworkers.jpg\";s:4:\"name\";s:9:\"Coworkers\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:163;a:12:{s:2:\"id\";s:3:\"436\";s:6:\"handle\";s:27:\"Hiking-in-the-Dolomites.jpg\";s:4:\"name\";s:23:\"Hiking in the Dolomites\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:164;a:12:{s:2:\"id\";s:3:\"435\";s:6:\"handle\";s:18:\"Successful-man.jpg\";s:4:\"name\";s:14:\"Successful man\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:165;a:12:{s:2:\"id\";s:3:\"434\";s:6:\"handle\";s:23:\"Beautiful-sunny-day.jpg\";s:4:\"name\";s:19:\"Beautiful sunny day\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:166;a:12:{s:2:\"id\";s:3:\"433\";s:6:\"handle\";s:8:\"Guys.jpg\";s:4:\"name\";s:4:\"Guys\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:167;a:12:{s:2:\"id\";s:3:\"432\";s:6:\"handle\";s:19:\"Confetti-Shower.jpg\";s:4:\"name\";s:15:\"Confetti Shower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:168;a:12:{s:2:\"id\";s:3:\"431\";s:6:\"handle\";s:24:\"Sun-was-setting-down.jpg\";s:4:\"name\";s:20:\"Sun was setting down\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:169;a:12:{s:2:\"id\";s:3:\"430\";s:6:\"handle\";s:9:\"Jumps.jpg\";s:4:\"name\";s:5:\"Jumps\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:170;a:12:{s:2:\"id\";s:3:\"429\";s:6:\"handle\";s:23:\"Friends-by-the-fire.jpg\";s:4:\"name\";s:19:\"Friends by the fire\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:171;a:12:{s:2:\"id\";s:3:\"428\";s:6:\"handle\";s:21:\"Under-the-blanket.jpg\";s:4:\"name\";s:17:\"Under the blanket\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1413\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:172;a:12:{s:2:\"id\";s:3:\"427\";s:6:\"handle\";s:18:\"Pretty-in-Pink.jpg\";s:4:\"name\";s:14:\"Pretty in Pink\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1394\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:173;a:12:{s:2:\"id\";s:3:\"426\";s:6:\"handle\";s:31:\"Discussions-at-a-long-table.jpg\";s:4:\"name\";s:27:\"Discussions at a long table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1268\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:174;a:12:{s:2:\"id\";s:3:\"425\";s:6:\"handle\";s:18:\"Lost-in-Lemons.jpg\";s:4:\"name\";s:14:\"Lost in Lemons\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:175;a:12:{s:2:\"id\";s:3:\"424\";s:6:\"handle\";s:13:\"Team-work.jpg\";s:4:\"name\";s:9:\"Team work\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:176;a:12:{s:2:\"id\";s:3:\"423\";s:6:\"handle\";s:20:\"Romantic-evening.jpg\";s:4:\"name\";s:16:\"Romantic evening\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1263\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:36:58\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:177;a:12:{s:2:\"id\";s:3:\"422\";s:6:\"handle\";s:19:\"Crew-collective.jpg\";s:4:\"name\";s:15:\"Crew collective\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:178;a:12:{s:2:\"id\";s:3:\"421\";s:6:\"handle\";s:8:\"Code.jpg\";s:4:\"name\";s:4:\"Code\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:179;a:12:{s:2:\"id\";s:3:\"420\";s:6:\"handle\";s:48:\"Yellow-ceramic-mug-beside-gray-aluminum-iMac.jpg\";s:4:\"name\";s:44:\"Yellow ceramic mug beside gray aluminum iMac\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:180;a:12:{s:2:\"id\";s:3:\"419\";s:6:\"handle\";s:11:\"My-desk.jpg\";s:4:\"name\";s:7:\"My desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1315\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:181;a:12:{s:2:\"id\";s:3:\"418\";s:6:\"handle\";s:17:\"Cooperation-2.jpg\";s:4:\"name\";s:13:\"Cooperation 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:182;a:12:{s:2:\"id\";s:3:\"417\";s:6:\"handle\";s:33:\"MacBook-on-top-of-brown-table.jpg\";s:4:\"name\";s:29:\"MacBook on top of brown table\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:183;a:12:{s:2:\"id\";s:3:\"416\";s:6:\"handle\";s:27:\"Beautiful-working-place.jpg\";s:4:\"name\";s:23:\"Beautiful working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:184;a:12:{s:2:\"id\";s:3:\"415\";s:6:\"handle\";s:14:\"Typewriter.jpg\";s:4:\"name\";s:10:\"Typewriter\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:185;a:12:{s:2:\"id\";s:3:\"414\";s:6:\"handle\";s:19:\"White-desk-lamp.jpg\";s:4:\"name\";s:15:\"White desk lamp\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:186;a:12:{s:2:\"id\";s:3:\"413\";s:6:\"handle\";s:18:\"Office-working.jpg\";s:4:\"name\";s:14:\"Office working\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:187;a:12:{s:2:\"id\";s:3:\"412\";s:6:\"handle\";s:36:\"Silver-iMac-on-brown-wooden-desk.jpg\";s:4:\"name\";s:32:\"Silver iMac on brown wooden desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1240\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:188;a:12:{s:2:\"id\";s:3:\"411\";s:6:\"handle\";s:23:\"Working-in-progress.jpg\";s:4:\"name\";s:19:\"Working in progress\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:189;a:12:{s:2:\"id\";s:3:\"410\";s:6:\"handle\";s:15:\"Cooperation.jpg\";s:4:\"name\";s:11:\"Cooperation\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:190;a:12:{s:2:\"id\";s:3:\"409\";s:6:\"handle\";s:17:\"Working-place.jpg\";s:4:\"name\";s:13:\"Working place\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:191;a:12:{s:2:\"id\";s:3:\"408\";s:6:\"handle\";s:16:\"Working-desk.jpg\";s:4:\"name\";s:12:\"Working desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:33:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:192;a:12:{s:2:\"id\";s:3:\"407\";s:6:\"handle\";s:23:\"low-angle-of-forest.jpg\";s:4:\"name\";s:19:\"low angle of forest\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:193;a:12:{s:2:\"id\";s:3:\"406\";s:6:\"handle\";s:23:\"Lake-under-blue-sky.jpg\";s:4:\"name\";s:19:\"Lake under blue sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1351\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:194;a:12:{s:2:\"id\";s:3:\"405\";s:6:\"handle\";s:21:\"Blue-starry-night.jpg\";s:4:\"name\";s:17:\"Blue starry night\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:195;a:12:{s:2:\"id\";s:3:\"404\";s:6:\"handle\";s:22:\"Aerial-photography.jpg\";s:4:\"name\";s:18:\"Aerial photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:196;a:12:{s:2:\"id\";s:3:\"403\";s:6:\"handle\";s:14:\"Red-clouds.jpg\";s:4:\"name\";s:10:\"Red clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:197;a:12:{s:2:\"id\";s:3:\"402\";s:6:\"handle\";s:14:\"Snow-field.jpg\";s:4:\"name\";s:10:\"Snow field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1227\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:198;a:12:{s:2:\"id\";s:3:\"401\";s:6:\"handle\";s:13:\"White-sky.jpg\";s:4:\"name\";s:9:\"White sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:199;a:12:{s:2:\"id\";s:3:\"400\";s:6:\"handle\";s:24:\"Trees-covered-by-fog.jpg\";s:4:\"name\";s:20:\"Trees covered by fog\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:200;a:12:{s:2:\"id\";s:3:\"399\";s:6:\"handle\";s:26:\"Red-and-white-mushroom.jpg\";s:4:\"name\";s:22:\"Red and white mushroom\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:201;a:12:{s:2:\"id\";s:3:\"398\";s:6:\"handle\";s:24:\"Lake-near-pine-trees.jpg\";s:4:\"name\";s:20:\"Lake near pine trees\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:202;a:12:{s:2:\"id\";s:3:\"397\";s:6:\"handle\";s:35:\"After-a-long-day-of-backpacking.jpg\";s:4:\"name\";s:31:\"After a long day of backpacking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:203;a:12:{s:2:\"id\";s:3:\"396\";s:6:\"handle\";s:32:\"Mountains-during-golden-hour.jpg\";s:4:\"name\";s:28:\"Mountains during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:204;a:12:{s:2:\"id\";s:3:\"395\";s:6:\"handle\";s:27:\"Man-looking-on-mountain.jpg\";s:4:\"name\";s:23:\"Man looking on mountain\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:205;a:12:{s:2:\"id\";s:3:\"394\";s:6:\"handle\";s:19:\"Body-of-water-2.jpg\";s:4:\"name\";s:15:\"Body of water 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:206;a:12:{s:2:\"id\";s:3:\"393\";s:6:\"handle\";s:15:\"Brown-cliff.jpg\";s:4:\"name\";s:11:\"Brown cliff\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:207;a:12:{s:2:\"id\";s:3:\"392\";s:6:\"handle\";s:20:\"Green-foggy-tree.jpg\";s:4:\"name\";s:16:\"Green foggy tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1417\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:208;a:12:{s:2:\"id\";s:3:\"391\";s:6:\"handle\";s:32:\"Grayscale-photo-of-mountains.jpg\";s:4:\"name\";s:28:\"Grayscale photo of mountains\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:209;a:12:{s:2:\"id\";s:3:\"390\";s:6:\"handle\";s:19:\"Under-sunny-sky.jpg\";s:4:\"name\";s:15:\"Under sunny sky\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:31:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:210;a:12:{s:2:\"id\";s:3:\"389\";s:6:\"handle\";s:16:\"Rock-concert.jpg\";s:4:\"name\";s:12:\"Rock concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1443\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:211;a:12:{s:2:\"id\";s:3:\"388\";s:6:\"handle\";s:30:\"Group-of-people-in-concert.jpg\";s:4:\"name\";s:26:\"Group of people in concert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:212;a:12:{s:2:\"id\";s:3:\"387\";s:6:\"handle\";s:6:\"DJ.jpg\";s:4:\"name\";s:2:\"DJ\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:213;a:12:{s:2:\"id\";s:3:\"386\";s:6:\"handle\";s:56:\"Woman-standing-watching-LED-light-musical-instrument.jpg\";s:4:\"name\";s:52:\"Woman standing watching LED light musical instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:214;a:12:{s:2:\"id\";s:3:\"385\";s:6:\"handle\";s:16:\"Concert-hall.jpg\";s:4:\"name\";s:12:\"Concert hall\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:215;a:12:{s:2:\"id\";s:3:\"384\";s:6:\"handle\";s:18:\"Concert-hall-2.jpg\";s:4:\"name\";s:14:\"Concert hall 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:216;a:12:{s:2:\"id\";s:3:\"383\";s:6:\"handle\";s:29:\"man-playing-upright-piano.jpg\";s:4:\"name\";s:25:\"man playing upright piano\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1340\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:217;a:12:{s:2:\"id\";s:3:\"382\";s:6:\"handle\";s:30:\"person-performing-on-stage.jpg\";s:4:\"name\";s:26:\"person performing on stage\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:218;a:12:{s:2:\"id\";s:3:\"381\";s:6:\"handle\";s:27:\"Brown-string-instrument.jpg\";s:4:\"name\";s:23:\"Brown string instrument\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:219;a:12:{s:2:\"id\";s:3:\"380\";s:6:\"handle\";s:36:\"silhouette-of-person-with-guitar.jpg\";s:4:\"name\";s:32:\"silhouette of person with guitar\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:220;a:12:{s:2:\"id\";s:3:\"379\";s:6:\"handle\";s:14:\"Party-fans.jpg\";s:4:\"name\";s:10:\"Party fans\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:221;a:12:{s:2:\"id\";s:3:\"378\";s:6:\"handle\";s:24:\"Condenser-microphone.jpg\";s:4:\"name\";s:20:\"Condenser microphone\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:25:26\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:222;a:12:{s:2:\"id\";s:3:\"377\";s:6:\"handle\";s:42:\"Low-angle-photo-of-high-rise-buildings.jpg\";s:4:\"name\";s:38:\"Low angle photo of high rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:223;a:12:{s:2:\"id\";s:3:\"376\";s:6:\"handle\";s:23:\"High-rise-buildings.jpg\";s:4:\"name\";s:19:\"High rise buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:224;a:12:{s:2:\"id\";s:3:\"375\";s:6:\"handle\";s:16:\"Cable-bridge.jpg\";s:4:\"name\";s:12:\"Cable bridge\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:225;a:12:{s:2:\"id\";s:3:\"374\";s:6:\"handle\";s:35:\"Bokeh-effect-from-street-lights.jpg\";s:4:\"name\";s:31:\"Bokeh effect from street lights\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:226;a:12:{s:2:\"id\";s:3:\"373\";s:6:\"handle\";s:18:\"Low-angle-view.jpg\";s:4:\"name\";s:14:\"Low angle view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:227;a:12:{s:2:\"id\";s:3:\"372\";s:6:\"handle\";s:21:\"Double-decker-bus.jpg\";s:4:\"name\";s:17:\"Double decker bus\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1373\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:228;a:12:{s:2:\"id\";s:3:\"371\";s:6:\"handle\";s:32:\"Buildings-near-body-of-water.jpg\";s:4:\"name\";s:28:\"Buildings near body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1370\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:229;a:12:{s:2:\"id\";s:3:\"370\";s:6:\"handle\";s:18:\"Satellite-view.jpg\";s:4:\"name\";s:14:\"Satellite view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:230;a:12:{s:2:\"id\";s:3:\"369\";s:6:\"handle\";s:14:\"Twin-Tower.jpg\";s:4:\"name\";s:10:\"Twin Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:231;a:12:{s:2:\"id\";s:3:\"368\";s:6:\"handle\";s:22:\"Two-person-walking.jpg\";s:4:\"name\";s:18:\"Two person walking\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1345\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:232;a:12:{s:2:\"id\";s:3:\"367\";s:6:\"handle\";s:15:\"Sears-Tower.jpg\";s:4:\"name\";s:11:\"Sears Tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:233;a:12:{s:2:\"id\";s:3:\"366\";s:6:\"handle\";s:19:\"Night-cityscape.jpg\";s:4:\"name\";s:15:\"Night cityscape\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:234;a:12:{s:2:\"id\";s:3:\"365\";s:6:\"handle\";s:25:\"Empire-State-Building.jpg\";s:4:\"name\";s:21:\"Empire State Building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:235;a:12:{s:2:\"id\";s:3:\"364\";s:6:\"handle\";s:9:\"Paris.jpg\";s:4:\"name\";s:5:\"Paris\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:236;a:12:{s:2:\"id\";s:3:\"363\";s:6:\"handle\";s:31:\"Building-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Building during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1288\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:237;a:12:{s:2:\"id\";s:3:\"362\";s:6:\"handle\";s:21:\"Afternoon-skyline.jpg\";s:4:\"name\";s:17:\"Afternoon skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:238;a:12:{s:2:\"id\";s:3:\"361\";s:6:\"handle\";s:22:\"Concrete-buildings.jpg\";s:4:\"name\";s:18:\"Concrete buildings\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:239;a:12:{s:2:\"id\";s:3:\"360\";s:6:\"handle\";s:26:\"Architectural-building.jpg\";s:4:\"name\";s:22:\"Architectural building\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1382\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:240;a:12:{s:2:\"id\";s:3:\"359\";s:6:\"handle\";s:23:\"Skyline-photography.jpg\";s:4:\"name\";s:19:\"Skyline photography\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:241;a:12:{s:2:\"id\";s:3:\"358\";s:6:\"handle\";s:38:\"People-standing-on-pedestrian-lane.jpg\";s:4:\"name\";s:34:\"People standing on pedestrian lane\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1154\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:242;a:12:{s:2:\"id\";s:3:\"357\";s:6:\"handle\";s:16:\"Burj-Khalifa.jpg\";s:4:\"name\";s:12:\"Burj Khalifa\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:243;a:12:{s:2:\"id\";s:3:\"356\";s:6:\"handle\";s:13:\"Skycraper.jpg\";s:4:\"name\";s:9:\"Skycraper\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:244;a:12:{s:2:\"id\";s:3:\"355\";s:6:\"handle\";s:14:\"Gray-tower.jpg\";s:4:\"name\";s:10:\"Gray tower\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1433\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-16 10:24:11\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:245;a:12:{s:2:\"id\";s:3:\"354\";s:6:\"handle\";s:28:\"One-fine-day-in-Maldives.jpg\";s:4:\"name\";s:24:\"One fine day in Maldives\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1116\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:246;a:12:{s:2:\"id\";s:3:\"353\";s:6:\"handle\";s:25:\"Boat-on-body-of-water.jpg\";s:4:\"name\";s:21:\"Boat on body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:247;a:12:{s:2:\"id\";s:3:\"352\";s:6:\"handle\";s:33:\"Aerial-photo-of-body-of-water.jpg\";s:4:\"name\";s:29:\"Aerial photo of body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1078\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:248;a:12:{s:2:\"id\";s:3:\"351\";s:6:\"handle\";s:31:\"Assorted-color-beach-houses.jpg\";s:4:\"name\";s:27:\"Assorted color beach houses\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1135\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:249;a:12:{s:2:\"id\";s:3:\"350\";s:6:\"handle\";s:36:\"Woman-leaning-on-tree-near-beach.jpg\";s:4:\"name\";s:32:\"Woman leaning on tree near beach\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1559\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:250;a:12:{s:2:\"id\";s:3:\"349\";s:6:\"handle\";s:17:\"Body-of-water.jpg\";s:4:\"name\";s:13:\"Body of water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1269\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:251;a:12:{s:2:\"id\";s:3:\"348\";s:6:\"handle\";s:17:\"People-on-sea.jpg\";s:4:\"name\";s:13:\"People on sea\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:252;a:12:{s:2:\"id\";s:3:\"347\";s:6:\"handle\";s:31:\"Man-sitting-beside-of-woman.jpg\";s:4:\"name\";s:27:\"Man sitting beside of woman\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:253;a:12:{s:2:\"id\";s:3:\"346\";s:6:\"handle\";s:22:\"woman-in-the-water.jpg\";s:4:\"name\";s:18:\"woman in the water\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:254;a:12:{s:2:\"id\";s:3:\"345\";s:6:\"handle\";s:39:\"Brown-stone-near-sea-at-golden-hour.jpg\";s:4:\"name\";s:35:\"Brown stone near sea at golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:255;a:12:{s:2:\"id\";s:3:\"344\";s:6:\"handle\";s:18:\"Birds-eye-view.jpg\";s:4:\"name\";s:14:\"Birds eye view\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1079\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:256;a:12:{s:2:\"id\";s:3:\"343\";s:6:\"handle\";s:18:\"Empty-seashore.jpg\";s:4:\"name\";s:14:\"Empty seashore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1365\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:257;a:12:{s:2:\"id\";s:3:\"342\";s:6:\"handle\";s:31:\"Seashore-during-golden-hour.jpg\";s:4:\"name\";s:27:\"Seashore during golden hour\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:258;a:12:{s:2:\"id\";s:3:\"341\";s:6:\"handle\";s:16:\"Coconut-tree.jpg\";s:4:\"name\";s:12:\"Coconut tree\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:259;a:12:{s:2:\"id\";s:3:\"340\";s:6:\"handle\";s:37:\"Aerial-photography-of-beach-shore.jpg\";s:4:\"name\";s:33:\"Aerial photography of beach shore\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1439\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-15 14:18:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:260;a:12:{s:2:\"id\";s:3:\"197\";s:6:\"handle\";s:17:\"relax_hammock.jpg\";s:4:\"name\";s:13:\"Relax Hammock\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:261;a:12:{s:2:\"id\";s:3:\"196\";s:6:\"handle\";s:16:\"beach_houses.jpg\";s:4:\"name\";s:12:\"Beach Houses\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:262;a:12:{s:2:\"id\";s:3:\"195\";s:6:\"handle\";s:17:\"forest_road_2.jpg\";s:4:\"name\";s:13:\"Forest Road 2\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:263;a:12:{s:2:\"id\";s:3:\"194\";s:6:\"handle\";s:14:\"clean_desk.jpg\";s:4:\"name\";s:10:\"Clean Desk\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:264;a:12:{s:2:\"id\";s:3:\"193\";s:6:\"handle\";s:19:\"mountain_view_6.jpg\";s:4:\"name\";s:15:\"Mountain View 6\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1249\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:265;a:12:{s:2:\"id\";s:3:\"192\";s:6:\"handle\";s:14:\"corn_field.jpg\";s:4:\"name\";s:10:\"Corn Field\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1320\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:266;a:12:{s:2:\"id\";s:3:\"191\";s:6:\"handle\";s:21:\"stylish_apartment.jpg\";s:4:\"name\";s:17:\"Stylish Apartment\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:267;a:12:{s:2:\"id\";s:3:\"190\";s:6:\"handle\";s:24:\"hipster_coffee_house.jpg\";s:4:\"name\";s:20:\"Hipster Coffee House\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:268;a:12:{s:2:\"id\";s:3:\"189\";s:6:\"handle\";s:16:\"blurry_beach.jpg\";s:4:\"name\";s:12:\"Blurry Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-10-17 12:41:12\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:269;a:12:{s:2:\"id\";s:3:\"186\";s:6:\"handle\";s:17:\"greens_street.jpg\";s:4:\"name\";s:13:\"Greens Street\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:270;a:12:{s:2:\"id\";s:3:\"185\";s:6:\"handle\";s:10:\"desert.jpg\";s:4:\"name\";s:6:\"Desert\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:271;a:12:{s:2:\"id\";s:3:\"184\";s:6:\"handle\";s:19:\"mountain_view_5.jpg\";s:4:\"name\";s:15:\"Mountain View 5\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:272;a:12:{s:2:\"id\";s:3:\"183\";s:6:\"handle\";s:10:\"laptop.jpg\";s:4:\"name\";s:6:\"Laptop\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1391\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:273;a:12:{s:2:\"id\";s:3:\"182\";s:6:\"handle\";s:16:\"grand_canyon.jpg\";s:4:\"name\";s:12:\"Grand Canyon\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1287\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:274;a:12:{s:2:\"id\";s:3:\"181\";s:6:\"handle\";s:20:\"landscape_clouds.jpg\";s:4:\"name\";s:16:\"Landscape Clouds\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1272\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:275;a:12:{s:2:\"id\";s:3:\"180\";s:6:\"handle\";s:17:\"highway_night.jpg\";s:4:\"name\";s:13:\"Highway Night\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1440\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:276;a:12:{s:2:\"id\";s:3:\"179\";s:6:\"handle\";s:15:\"beach_water.jpg\";s:4:\"name\";s:11:\"Beach Water\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:277;a:12:{s:2:\"id\";s:3:\"177\";s:6:\"handle\";s:15:\"woman_beach.jpg\";s:4:\"name\";s:11:\"Woman Beach\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:3;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:278;a:12:{s:2:\"id\";s:3:\"175\";s:6:\"handle\";s:12:\"cool_guy.jpg\";s:4:\"name\";s:8:\"Cool Guy\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:279;a:12:{s:2:\"id\";s:3:\"174\";s:6:\"handle\";s:13:\"beach_sea.jpg\";s:4:\"name\";s:9:\"Beach Sea\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:280;a:12:{s:2:\"id\";s:3:\"173\";s:6:\"handle\";s:17:\"bridge_clouds.jpg\";s:4:\"name\";s:13:\"Bridge Clouds\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-09-05 15:29:22\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:281;a:12:{s:2:\"id\";s:3:\"116\";s:6:\"handle\";s:19:\"mountain_view_2.jpg\";s:4:\"name\";s:15:\"Mountain View 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:282;a:12:{s:2:\"id\";s:3:\"115\";s:6:\"handle\";s:16:\"desert_trees.jpg\";s:4:\"name\";s:12:\"Desert Trees\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1275\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:283;a:12:{s:2:\"id\";s:3:\"114\";s:6:\"handle\";s:20:\"explore_moutains.jpg\";s:4:\"name\";s:17:\"Explore Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:284;a:12:{s:2:\"id\";s:3:\"113\";s:6:\"handle\";s:19:\"night_skyline_2.jpg\";s:4:\"name\";s:15:\"Night Skyline 2\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:285;a:12:{s:2:\"id\";s:3:\"112\";s:6:\"handle\";s:15:\"cliff_ocean.jpg\";s:4:\"name\";s:11:\"Cliff Ocean\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:286;a:12:{s:2:\"id\";s:3:\"111\";s:6:\"handle\";s:14:\"city_smoke.jpg\";s:4:\"name\";s:10:\"City Smoke\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:287;a:12:{s:2:\"id\";s:3:\"110\";s:6:\"handle\";s:16:\"surfer_beach.jpg\";s:4:\"name\";s:12:\"Surfer Beach\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1278\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:288;a:12:{s:2:\"id\";s:3:\"109\";s:6:\"handle\";s:13:\"sky_night.jpg\";s:4:\"name\";s:9:\"Sky Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:289;a:12:{s:2:\"id\";s:3:\"108\";s:6:\"handle\";s:15:\"palm_sunset.jpg\";s:4:\"name\";s:11:\"Palm Sunset\";s:4:\"tags\";a:4:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:3;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1372\";s:6:\"height\";s:4:\"1920\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:290;a:12:{s:2:\"id\";s:3:\"107\";s:6:\"handle\";s:18:\"concert_people.jpg\";s:4:\"name\";s:14:\"Concert People\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:291;a:12:{s:2:\"id\";s:3:\"106\";s:6:\"handle\";s:15:\"forest_road.jpg\";s:4:\"name\";s:11:\"Forest Road\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:292;a:12:{s:2:\"id\";s:3:\"105\";s:6:\"handle\";s:15:\"beach_ocean.jpg\";s:4:\"name\";s:11:\"Beach Ocean\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:293;a:12:{s:2:\"id\";s:3:\"104\";s:6:\"handle\";s:18:\"mountain_night.jpg\";s:4:\"name\";s:14:\"Mountain Night\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1277\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:294;a:12:{s:2:\"id\";s:3:\"103\";s:6:\"handle\";s:19:\"ocean_mountains.jpg\";s:4:\"name\";s:15:\"Ocean Mountains\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1282\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:295;a:12:{s:2:\"id\";s:3:\"102\";s:6:\"handle\";s:10:\"forest.jpg\";s:4:\"name\";s:6:\"Forest\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:296;a:12:{s:2:\"id\";s:3:\"101\";s:6:\"handle\";s:16:\"ocean_stones.jpg\";s:4:\"name\";s:12:\"Ocean Stones\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:2;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:297;a:12:{s:2:\"id\";s:3:\"100\";s:6:\"handle\";s:16:\"country_road.jpg\";s:4:\"name\";s:12:\"Country Road\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:2;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:3:\"800\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:298;a:12:{s:2:\"id\";s:2:\"99\";s:6:\"handle\";s:9:\"beach.jpg\";s:4:\"name\";s:5:\"Beach\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:299;a:12:{s:2:\"id\";s:2:\"98\";s:6:\"handle\";s:16:\"city_skyline.jpg\";s:4:\"name\";s:12:\"City Skyline\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:300;a:12:{s:2:\"id\";s:2:\"97\";s:6:\"handle\";s:17:\"night_skyline.jpg\";s:4:\"name\";s:13:\"Night Skyline\";s:4:\"tags\";a:3:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:2;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:301;a:12:{s:2:\"id\";s:2:\"96\";s:6:\"handle\";s:14:\"city_river.jpg\";s:4:\"name\";s:10:\"City River\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:302;a:12:{s:2:\"id\";s:2:\"95\";s:6:\"handle\";s:19:\"mountain_view_3.jpg\";s:4:\"name\";s:15:\"Mountain View 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1281\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:303;a:12:{s:2:\"id\";s:2:\"94\";s:6:\"handle\";s:14:\"misty_farm.jpg\";s:4:\"name\";s:10:\"Misty Farm\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:304;a:12:{s:2:\"id\";s:2:\"93\";s:6:\"handle\";s:17:\"mountain_path.jpg\";s:4:\"name\";s:13:\"Mountain Path\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1280\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:305;a:12:{s:2:\"id\";s:2:\"92\";s:6:\"handle\";s:19:\"night_skyline_3.jpg\";s:4:\"name\";s:15:\"Night Skyline 3\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:306;a:12:{s:2:\"id\";s:2:\"91\";s:6:\"handle\";s:17:\"mountain_view.jpg\";s:4:\"name\";s:13:\"Mountain View\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1160\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:307;a:12:{s:2:\"id\";s:2:\"90\";s:6:\"handle\";s:19:\"rocky_landscape.jpg\";s:4:\"name\";s:15:\"Rocky Landscape\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:308;a:12:{s:2:\"id\";s:2:\"89\";s:6:\"handle\";s:19:\"mountain_view_4.jpg\";s:4:\"name\";s:15:\"Mountain View 4\";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1203\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2016-08-15 14:29:46\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"2\";}i:309;a:13:{s:2:\"id\";s:3:\"529\";s:6:\"handle\";s:13:\"Fitness-4.jpg\";s:5:\"video\";s:13:\"Fitness-4.mp4\";s:4:\"name\";s:10:\"Fitness 4 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:310;a:13:{s:2:\"id\";s:3:\"528\";s:6:\"handle\";s:13:\"Fitness-3.jpg\";s:5:\"video\";s:13:\"Fitness-3.mp4\";s:4:\"name\";s:10:\"Fitness 3 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:311;a:13:{s:2:\"id\";s:3:\"527\";s:6:\"handle\";s:9:\"Chess.jpg\";s:5:\"video\";s:9:\"Chess.mp4\";s:4:\"name\";s:6:\"Chess \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:312;a:13:{s:2:\"id\";s:3:\"526\";s:6:\"handle\";s:13:\"Fitness-2.jpg\";s:5:\"video\";s:13:\"Fitness-2.mp4\";s:4:\"name\";s:10:\"Fitness 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:313;a:13:{s:2:\"id\";s:3:\"525\";s:6:\"handle\";s:11:\"Fitness.jpg\";s:5:\"video\";s:11:\"Fitness.mp4\";s:4:\"name\";s:8:\"Fitness \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:46:50\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:314;a:13:{s:2:\"id\";s:3:\"524\";s:6:\"handle\";s:9:\"Earth.jpg\";s:5:\"video\";s:9:\"Earth.mp4\";s:4:\"name\";s:6:\"Earth \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:315;a:13:{s:2:\"id\";s:3:\"523\";s:6:\"handle\";s:11:\"Space-2.jpg\";s:5:\"video\";s:11:\"Space-2.mp4\";s:4:\"name\";s:8:\"Space 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1440\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:316;a:13:{s:2:\"id\";s:3:\"522\";s:6:\"handle\";s:13:\"Asteroids.jpg\";s:5:\"video\";s:13:\"Asteroids.mp4\";s:4:\"name\";s:10:\"Asteroids \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:317;a:13:{s:2:\"id\";s:3:\"521\";s:6:\"handle\";s:9:\"Space.jpg\";s:5:\"video\";s:9:\"Space.mp4\";s:4:\"name\";s:6:\"Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:44:06\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:318;a:13:{s:2:\"id\";s:3:\"520\";s:6:\"handle\";s:10:\"People.jpg\";s:5:\"video\";s:10:\"People.mp4\";s:4:\"name\";s:7:\"People \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:319;a:13:{s:2:\"id\";s:3:\"519\";s:6:\"handle\";s:11:\"Walking.jpg\";s:5:\"video\";s:11:\"Walking.mp4\";s:4:\"name\";s:8:\"Walking \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:320;a:13:{s:2:\"id\";s:3:\"518\";s:6:\"handle\";s:19:\"Double-Exposure.jpg\";s:5:\"video\";s:19:\"Double-Exposure.mp4\";s:4:\"name\";s:16:\"Double Exposure \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:321;a:13:{s:2:\"id\";s:3:\"517\";s:6:\"handle\";s:8:\"Girl.jpg\";s:5:\"video\";s:8:\"Girl.mp4\";s:4:\"name\";s:5:\"Girl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1088\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:322;a:13:{s:2:\"id\";s:3:\"516\";s:6:\"handle\";s:17:\"Bengal-Lights.jpg\";s:5:\"video\";s:17:\"Bengal-Lights.mp4\";s:4:\"name\";s:14:\"Bengal Lights \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:42:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:323;a:13:{s:2:\"id\";s:3:\"515\";s:6:\"handle\";s:13:\"Swiping-2.jpg\";s:5:\"video\";s:13:\"Swiping-2.mp4\";s:4:\"name\";s:10:\"Swiping 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:324;a:13:{s:2:\"id\";s:3:\"514\";s:6:\"handle\";s:11:\"Mock-Up.jpg\";s:5:\"video\";s:11:\"Mock-Up.mp4\";s:4:\"name\";s:8:\"Mock Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:325;a:13:{s:2:\"id\";s:3:\"513\";s:6:\"handle\";s:13:\"Countdown.jpg\";s:5:\"video\";s:13:\"Countdown.mp4\";s:4:\"name\";s:10:\"Countdown \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:326;a:13:{s:2:\"id\";s:3:\"512\";s:6:\"handle\";s:18:\"Wall-Sketching.jpg\";s:5:\"video\";s:18:\"Wall-Sketching.mp4\";s:4:\"name\";s:15:\"Wall Sketching \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:327;a:13:{s:2:\"id\";s:3:\"511\";s:6:\"handle\";s:26:\"Typing-on-the-keyboard.jpg\";s:5:\"video\";s:26:\"Typing-on-the-keyboard.mp4\";s:4:\"name\";s:23:\"Typing on the keyboard \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:328;a:13:{s:2:\"id\";s:3:\"510\";s:6:\"handle\";s:11:\"Meeting.jpg\";s:5:\"video\";s:11:\"Meeting.mp4\";s:4:\"name\";s:8:\"Meeting \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:329;a:13:{s:2:\"id\";s:3:\"509\";s:6:\"handle\";s:11:\"Swiping.jpg\";s:5:\"video\";s:11:\"Swiping.mp4\";s:4:\"name\";s:8:\"Swiping \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:330;a:13:{s:2:\"id\";s:3:\"508\";s:6:\"handle\";s:9:\"Alarm.jpg\";s:5:\"video\";s:9:\"Alarm.mp4\";s:4:\"name\";s:6:\"Alarm \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1013\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:331;a:13:{s:2:\"id\";s:3:\"507\";s:6:\"handle\";s:13:\"Hey-World.jpg\";s:5:\"video\";s:13:\"Hey-World.mp4\";s:4:\"name\";s:10:\"Hey World \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:332;a:13:{s:2:\"id\";s:3:\"506\";s:6:\"handle\";s:28:\"Typing-on-the-keyboard-2.jpg\";s:5:\"video\";s:28:\"Typing-on-the-keyboard-2.mp4\";s:4:\"name\";s:25:\"Typing on the keyboard 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:39:19\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:333;a:13:{s:2:\"id\";s:3:\"505\";s:6:\"handle\";s:10:\"Valley.jpg\";s:5:\"video\";s:10:\"Valley.mp4\";s:4:\"name\";s:7:\"Valley \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:334;a:13:{s:2:\"id\";s:3:\"504\";s:6:\"handle\";s:9:\"Stars.jpg\";s:5:\"video\";s:9:\"Stars.mp4\";s:4:\"name\";s:6:\"Stars \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:335;a:13:{s:2:\"id\";s:3:\"503\";s:6:\"handle\";s:21:\"Car-in-the-forest.jpg\";s:5:\"video\";s:21:\"Car-in-the-forest.mp4\";s:4:\"name\";s:18:\"Car in the forest \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1012\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:336;a:13:{s:2:\"id\";s:3:\"502\";s:6:\"handle\";s:15:\"Aerial-Shot.jpg\";s:5:\"video\";s:15:\"Aerial-Shot.mp4\";s:4:\"name\";s:12:\"Aerial Shot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:35:27\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:337;a:13:{s:2:\"id\";s:3:\"501\";s:6:\"handle\";s:14:\"Disco-Ball.jpg\";s:5:\"video\";s:14:\"Disco-Ball.mp4\";s:4:\"name\";s:11:\"Disco Ball \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:338;a:13:{s:2:\"id\";s:3:\"500\";s:6:\"handle\";s:22:\"Man-Playing-Guitar.jpg\";s:5:\"video\";s:22:\"Man-Playing-Guitar.mp4\";s:4:\"name\";s:19:\"Man Playing Guitar \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:339;a:13:{s:2:\"id\";s:3:\"499\";s:6:\"handle\";s:14:\"Live-Music.jpg\";s:5:\"video\";s:14:\"Live-Music.mp4\";s:4:\"name\";s:11:\"Live Music \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:340;a:13:{s:2:\"id\";s:3:\"498\";s:6:\"handle\";s:12:\"Cheer-Up.jpg\";s:5:\"video\";s:12:\"Cheer-Up.mp4\";s:4:\"name\";s:9:\"Cheer Up \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:341;a:13:{s:2:\"id\";s:3:\"497\";s:6:\"handle\";s:14:\"Night-club.jpg\";s:5:\"video\";s:14:\"Night-club.mp4\";s:4:\"name\";s:11:\"Night club \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:33:16\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:342;a:13:{s:2:\"id\";s:3:\"496\";s:6:\"handle\";s:17:\"Cup-Of-Coffee.jpg\";s:5:\"video\";s:17:\"Cup-Of-Coffee.mp4\";s:4:\"name\";s:14:\"Cup Of Coffee \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:343;a:13:{s:2:\"id\";s:3:\"495\";s:6:\"handle\";s:7:\"Pot.jpg\";s:5:\"video\";s:7:\"Pot.mp4\";s:4:\"name\";s:4:\"Pot \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:344;a:13:{s:2:\"id\";s:3:\"494\";s:6:\"handle\";s:11:\"Grill-2.jpg\";s:5:\"video\";s:11:\"Grill-2.mp4\";s:4:\"name\";s:8:\"Grill 2 \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:345;a:13:{s:2:\"id\";s:3:\"493\";s:6:\"handle\";s:13:\"Rice-Bowl.jpg\";s:5:\"video\";s:13:\"Rice-Bowl.mp4\";s:4:\"name\";s:10:\"Rice Bowl \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1010\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:346;a:13:{s:2:\"id\";s:3:\"492\";s:6:\"handle\";s:9:\"Grill.jpg\";s:5:\"video\";s:9:\"Grill.mp4\";s:4:\"name\";s:6:\"Grill \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:30:48\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:347;a:13:{s:2:\"id\";s:3:\"491\";s:6:\"handle\";s:9:\"Water.jpg\";s:5:\"video\";s:9:\"Water.mp4\";s:4:\"name\";s:6:\"Water \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:348;a:13:{s:2:\"id\";s:3:\"490\";s:6:\"handle\";s:17:\"Feet-and-Sand.jpg\";s:5:\"video\";s:17:\"Feet-and-Sand.mp4\";s:4:\"name\";s:14:\"Feet and Sand \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:349;a:13:{s:2:\"id\";s:3:\"489\";s:6:\"handle\";s:9:\"Ocean.jpg\";s:5:\"video\";s:9:\"Ocean.mp4\";s:4:\"name\";s:6:\"Ocean \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:350;a:13:{s:2:\"id\";s:3:\"488\";s:6:\"handle\";s:9:\"Waves.jpg\";s:5:\"video\";s:9:\"Waves.mp4\";s:4:\"name\";s:6:\"Waves \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:24:15\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:351;a:13:{s:2:\"id\";s:3:\"487\";s:6:\"handle\";s:10:\"Hearts.jpg\";s:5:\"video\";s:10:\"Hearts.mp4\";s:4:\"name\";s:7:\"Hearts \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:352;a:13:{s:2:\"id\";s:3:\"486\";s:6:\"handle\";s:12:\"Octagons.jpg\";s:5:\"video\";s:12:\"Octagons.mp4\";s:4:\"name\";s:9:\"Octagons \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:353;a:13:{s:2:\"id\";s:3:\"485\";s:6:\"handle\";s:11:\"Squares.jpg\";s:5:\"video\";s:11:\"Squares.mp4\";s:4:\"name\";s:8:\"Squares \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:354;a:13:{s:2:\"id\";s:3:\"484\";s:6:\"handle\";s:12:\"Pink-ink.jpg\";s:5:\"video\";s:12:\"Pink-ink.mp4\";s:4:\"name\";s:9:\"Pink ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:355;a:13:{s:2:\"id\";s:3:\"483\";s:6:\"handle\";s:22:\"Blurred-Background.jpg\";s:5:\"video\";s:22:\"Blurred-Background.mp4\";s:4:\"name\";s:19:\"Blurred Background \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:356;a:13:{s:2:\"id\";s:3:\"482\";s:6:\"handle\";s:20:\"Blinking-bubbles.jpg\";s:5:\"video\";s:20:\"Blinking-bubbles.mp4\";s:4:\"name\";s:17:\"Blinking bubbles \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:357;a:13:{s:2:\"id\";s:3:\"481\";s:6:\"handle\";s:13:\"Fireworks.jpg\";s:5:\"video\";s:13:\"Fireworks.mp4\";s:4:\"name\";s:10:\"Fireworks \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:358;a:13:{s:2:\"id\";s:3:\"480\";s:6:\"handle\";s:12:\"Dark-ink.jpg\";s:5:\"video\";s:12:\"Dark-ink.mp4\";s:4:\"name\";s:9:\"Dark ink \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-04-23 11:20:38\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:359;a:13:{s:2:\"id\";s:3:\"238\";s:6:\"handle\";s:12:\"Mt_Baker.jpg\";s:5:\"video\";s:12:\"Mt_Baker.mp4\";s:4:\"name\";s:9:\"Mt Baker \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:360;a:13:{s:2:\"id\";s:3:\"237\";s:6:\"handle\";s:16:\"Two-Swimmers.jpg\";s:5:\"video\";s:16:\"Two-Swimmers.mp4\";s:4:\"name\";s:13:\"Two Swimmers \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:361;a:13:{s:2:\"id\";s:3:\"236\";s:6:\"handle\";s:14:\"Boats_Maze.jpg\";s:5:\"video\";s:14:\"Boats_Maze.mp4\";s:4:\"name\";s:11:\"Boats Maze \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:362;a:13:{s:2:\"id\";s:3:\"235\";s:6:\"handle\";s:18:\"Candolim-Beach.jpg\";s:5:\"video\";s:18:\"Candolim-Beach.mp4\";s:4:\"name\";s:15:\"Candolim Beach \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:363;a:13:{s:2:\"id\";s:3:\"234\";s:6:\"handle\";s:17:\"Working-Space.jpg\";s:5:\"video\";s:17:\"Working-Space.mp4\";s:4:\"name\";s:14:\"Working Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:364;a:13:{s:2:\"id\";s:3:\"233\";s:6:\"handle\";s:9:\"Wavez.jpg\";s:5:\"video\";s:9:\"Wavez.mp4\";s:4:\"name\";s:6:\"Wavez \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:365;a:13:{s:2:\"id\";s:3:\"232\";s:6:\"handle\";s:17:\"Coconut-Grove.jpg\";s:5:\"video\";s:17:\"Coconut-Grove.mp4\";s:4:\"name\";s:14:\"Coconut Grove \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:366;a:13:{s:2:\"id\";s:3:\"231\";s:6:\"handle\";s:19:\"Very-Open-Space.jpg\";s:5:\"video\";s:19:\"Very-Open-Space.mp4\";s:4:\"name\";s:16:\"Very Open Space \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:367;a:13:{s:2:\"id\";s:3:\"230\";s:6:\"handle\";s:14:\"Office-Day.jpg\";s:5:\"video\";s:14:\"Office-Day.mp4\";s:4:\"name\";s:11:\"Office Day \";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:368;a:13:{s:2:\"id\";s:3:\"229\";s:6:\"handle\";s:12:\"The-Hill.jpg\";s:5:\"video\";s:12:\"The-Hill.mp4\";s:4:\"name\";s:9:\"The Hill \";s:4:\"tags\";a:2:{i:0;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:1;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}}s:11:\"description\";s:8:\"New File\";s:5:\"width\";s:4:\"1920\";s:6:\"height\";s:4:\"1080\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:0:\"\";s:5:\"added\";s:19:\"2018-07-16 15:34:55\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"3\";}i:369;a:13:{s:2:\"id\";s:3:\"339\";s:6:\"handle\";s:19:\"best_price_dark.jpg\";s:5:\"video\";s:19:\"best_price_dark.mp4\";s:4:\"name\";s:15:\"best_price_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"best_price_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:370;a:13:{s:2:\"id\";s:3:\"337\";s:6:\"handle\";s:27:\"limited_time_offer_dark.jpg\";s:5:\"video\";s:27:\"limited_time_offer_dark.mp4\";s:4:\"name\";s:23:\"limited_time_offer_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:23:\"limited_time_offer_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:371;a:13:{s:2:\"id\";s:3:\"336\";s:6:\"handle\";s:26:\"slider_revolution_dark.jpg\";s:5:\"video\";s:26:\"slider_revolution_dark.mp4\";s:4:\"name\";s:22:\"slider_revolution_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:22:\"slider_revolution_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:372;a:13:{s:2:\"id\";s:3:\"335\";s:6:\"handle\";s:19:\"mick_brown_dark.jpg\";s:5:\"video\";s:19:\"mick_brown_dark.mp4\";s:4:\"name\";s:15:\"mick_brown_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"mick_brown_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-26 09:24:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:373;a:13:{s:2:\"id\";s:3:\"334\";s:6:\"handle\";s:14:\"sales_dark.jpg\";s:5:\"video\";s:14:\"sales_dark.mp4\";s:4:\"name\";s:10:\"sales_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:10:\"sales_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:374;a:13:{s:2:\"id\";s:3:\"333\";s:6:\"handle\";s:21:\"robert_smith_dark.jpg\";s:5:\"video\";s:21:\"robert_smith_dark.mp4\";s:4:\"name\";s:17:\"robert_smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"robert_smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:375;a:13:{s:2:\"id\";s:3:\"332\";s:6:\"handle\";s:21:\"product_name_dark.jpg\";s:5:\"video\";s:21:\"product_name_dark.mp4\";s:4:\"name\";s:17:\"product_name_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"product_name_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:376;a:13:{s:2:\"id\";s:3:\"331\";s:6:\"handle\";s:21:\"high_quality_dark.jpg\";s:5:\"video\";s:21:\"high_quality_dark.mp4\";s:4:\"name\";s:17:\"high_quality_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"high_quality_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:377;a:13:{s:2:\"id\";s:3:\"330\";s:6:\"handle\";s:24:\"robert_johnson_light.jpg\";s:5:\"video\";s:24:\"robert_johnson_light.mp4\";s:4:\"name\";s:20:\"robert_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"robert_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:378;a:13:{s:2:\"id\";s:3:\"329\";s:6:\"handle\";s:21:\"jake_collins_dark.jpg\";s:5:\"video\";s:21:\"jake_collins_dark.mp4\";s:4:\"name\";s:17:\"jake_collins_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"jake_collins_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:32:18\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:379;a:13:{s:2:\"id\";s:3:\"328\";s:6:\"handle\";s:22:\"daniele_wood_light.jpg\";s:5:\"video\";s:22:\"daniele_wood_light.mp4\";s:4:\"name\";s:18:\"daniele_wood_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"daniele_wood_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-12 08:31:30\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:380;a:13:{s:2:\"id\";s:3:\"327\";s:6:\"handle\";s:23:\"michael_blake_light.jpg\";s:5:\"video\";s:23:\"michael_blake_light.mp4\";s:4:\"name\";s:19:\"michael_blake_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"michael_blake_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:381;a:13:{s:2:\"id\";s:3:\"326\";s:6:\"handle\";s:22:\"product_name_light.jpg\";s:5:\"video\";s:22:\"product_name_light.mp4\";s:4:\"name\";s:18:\"product_name_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"product_name_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:382;a:13:{s:2:\"id\";s:3:\"325\";s:6:\"handle\";s:24:\"rebecca_cooper_light.jpg\";s:5:\"video\";s:24:\"rebecca_cooper_light.mp4\";s:4:\"name\";s:20:\"rebecca_cooper_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:20:\"rebecca_cooper_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:383;a:13:{s:2:\"id\";s:3:\"324\";s:6:\"handle\";s:28:\"limited_time_offer_light.jpg\";s:5:\"video\";s:28:\"limited_time_offer_light.mp4\";s:4:\"name\";s:24:\"limited_time_offer_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:24:\"limited_time_offer_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:384;a:13:{s:2:\"id\";s:3:\"322\";s:6:\"handle\";s:22:\"jake_michael_light.jpg\";s:5:\"video\";s:22:\"jake_michael_light.mp4\";s:4:\"name\";s:18:\"jake_michael_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"jake_michael_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:385;a:13:{s:2:\"id\";s:3:\"321\";s:6:\"handle\";s:23:\"colin_johnson_light.jpg\";s:5:\"video\";s:23:\"colin_johnson_light.mp4\";s:4:\"name\";s:19:\"colin_johnson_light\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:19:\"colin_johnson_light\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-03-05 09:20:21\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:386;a:13:{s:2:\"id\";s:3:\"320\";s:6:\"handle\";s:21:\"colin_morris_dark.jpg\";s:5:\"video\";s:21:\"colin_morris_dark.mp4\";s:4:\"name\";s:17:\"colin_morris_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"colin_morris_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:387;a:13:{s:2:\"id\";s:3:\"319\";s:6:\"handle\";s:22:\"justin_cooper_dark.jpg\";s:5:\"video\";s:22:\"justin_cooper_dark.mp4\";s:4:\"name\";s:18:\"justin_cooper_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"justin_cooper_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:388;a:13:{s:2:\"id\";s:3:\"318\";s:6:\"handle\";s:21:\"james-dodson_dark.jpg\";s:5:\"video\";s:21:\"james-dodson_dark.mp4\";s:4:\"name\";s:17:\"james-dodson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"james-dodson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:389;a:13:{s:2:\"id\";s:3:\"317\";s:6:\"handle\";s:23:\"robert_sanders_dark.jpg\";s:5:\"video\";s:23:\"robert_sanders_dark.mp4\";s:4:\"name\";s:19:\"robert_sanders_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"robert_sanders_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:390;a:13:{s:2:\"id\";s:3:\"316\";s:6:\"handle\";s:21:\"emily_carney_dark.jpg\";s:5:\"video\";s:21:\"emily_carney_dark.mp4\";s:4:\"name\";s:17:\"emily_carney_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"emily_carney_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:391;a:13:{s:2:\"id\";s:3:\"315\";s:6:\"handle\";s:22:\"michael-smith_dark.jpg\";s:5:\"video\";s:22:\"michael-smith_dark.mp4\";s:4:\"name\";s:18:\"michael-smith_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"michael-smith_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:392;a:13:{s:2:\"id\";s:3:\"314\";s:6:\"handle\";s:23:\"sandra_johnson_dark.jpg\";s:5:\"video\";s:23:\"sandra_johnson_dark.mp4\";s:4:\"name\";s:19:\"sandra_johnson_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:19:\"sandra_johnson_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:393;a:13:{s:2:\"id\";s:3:\"313\";s:6:\"handle\";s:22:\"robert_bolton_dark.jpg\";s:5:\"video\";s:22:\"robert_bolton_dark.mp4\";s:4:\"name\";s:18:\"robert_bolton_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:18:\"robert_bolton_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-21 09:07:08\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:394;a:13:{s:2:\"id\";s:3:\"312\";s:6:\"handle\";s:25:\"elegant_captions_dark.png\";s:5:\"video\";s:25:\"elegant_captions_dark.mp4\";s:4:\"name\";s:21:\"elegant_captions_dark\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:21:\"elegant_captions_dark\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-18 14:41:45\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:395;a:13:{s:2:\"id\";s:3:\"311\";s:6:\"handle\";s:19:\"Caption_Dark_06.png\";s:5:\"video\";s:19:\"Caption_Dark_06.mp4\";s:4:\"name\";s:15:\"Caption_Dark_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_06\";s:5:\"width\";s:3:\"414\";s:6:\"height\";s:3:\"225\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:396;a:13:{s:2:\"id\";s:3:\"310\";s:6:\"handle\";s:19:\"Header_Light_02.png\";s:5:\"video\";s:19:\"Header_Light_02.mp4\";s:4:\"name\";s:15:\"Header_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:397;a:13:{s:2:\"id\";s:3:\"309\";s:6:\"handle\";s:21:\"Columns_4_Dark_01.png\";s:5:\"video\";s:21:\"Columns_4_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_4_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_4_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:398;a:13:{s:2:\"id\";s:3:\"308\";s:6:\"handle\";s:18:\"Header_Dark_01.png\";s:5:\"video\";s:18:\"Header_Dark_01.mp4\";s:4:\"name\";s:14:\"Header_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:399;a:13:{s:2:\"id\";s:3:\"307\";s:6:\"handle\";s:19:\"Caption_Dark_03.png\";s:5:\"video\";s:19:\"Caption_Dark_03.mp4\";s:4:\"name\";s:15:\"Caption_Dark_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:400;a:13:{s:2:\"id\";s:3:\"306\";s:6:\"handle\";s:21:\"Columns_3_Dark_01.png\";s:5:\"video\";s:21:\"Columns_3_Dark_01.mp4\";s:4:\"name\";s:17:\"Columns_3_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"Columns_3_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:401;a:13:{s:2:\"id\";s:3:\"305\";s:6:\"handle\";s:19:\"Caption_Dark_05.png\";s:5:\"video\";s:19:\"Caption_Dark_05.mp4\";s:4:\"name\";s:15:\"Caption_Dark_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_05\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:402;a:13:{s:2:\"id\";s:3:\"304\";s:6:\"handle\";s:20:\"Caption_Light_06.png\";s:5:\"video\";s:20:\"Caption_Light_06.mp4\";s:4:\"name\";s:16:\"Caption_Light_06\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_06\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:403;a:13:{s:2:\"id\";s:3:\"303\";s:6:\"handle\";s:19:\"Header_Light_01.png\";s:5:\"video\";s:19:\"Header_Light_01.mp4\";s:4:\"name\";s:15:\"Header_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:15:\"Header_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:404;a:13:{s:2:\"id\";s:3:\"302\";s:6:\"handle\";s:20:\"Caption_Light_03.png\";s:5:\"video\";s:20:\"Caption_Light_03.mp4\";s:4:\"name\";s:16:\"Caption_Light_03\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_03\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:405;a:13:{s:2:\"id\";s:3:\"301\";s:6:\"handle\";s:19:\"Caption_Dark_01.png\";s:5:\"video\";s:19:\"Caption_Dark_01.mp4\";s:4:\"name\";s:15:\"Caption_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:406;a:13:{s:2:\"id\";s:3:\"300\";s:6:\"handle\";s:21:\"PromoCode_Dark_01.png\";s:5:\"video\";s:21:\"PromoCode_Dark_01.mp4\";s:4:\"name\";s:17:\"PromoCode_Dark_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:17:\"PromoCode_Dark_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:407;a:13:{s:2:\"id\";s:3:\"299\";s:6:\"handle\";s:19:\"Caption_Dark_02.png\";s:5:\"video\";s:19:\"Caption_Dark_02.mp4\";s:4:\"name\";s:15:\"Caption_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:408;a:13:{s:2:\"id\";s:3:\"298\";s:6:\"handle\";s:18:\"Header_Dark_02.png\";s:5:\"video\";s:18:\"Header_Dark_02.mp4\";s:4:\"name\";s:14:\"Header_Dark_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:14:\"Header_Dark_02\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:409;a:13:{s:2:\"id\";s:3:\"297\";s:6:\"handle\";s:22:\"Columns_3_Light_01.png\";s:5:\"video\";s:22:\"Columns_3_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_3_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_3_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:410;a:13:{s:2:\"id\";s:3:\"296\";s:6:\"handle\";s:20:\"Caption_Light_01.png\";s:5:\"video\";s:20:\"Caption_Light_01.mp4\";s:4:\"name\";s:16:\"Caption_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:411;a:13:{s:2:\"id\";s:3:\"295\";s:6:\"handle\";s:19:\"Caption_Dark_04.png\";s:5:\"video\";s:19:\"Caption_Dark_04.mp4\";s:4:\"name\";s:15:\"Caption_Dark_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}}s:11:\"description\";s:15:\"Caption_Dark_04\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:412;a:13:{s:2:\"id\";s:3:\"294\";s:6:\"handle\";s:20:\"Caption_Light_02.png\";s:5:\"video\";s:20:\"Caption_Light_02.mp4\";s:4:\"name\";s:16:\"Caption_Light_02\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_02\";s:5:\"width\";s:3:\"828\";s:6:\"height\";s:3:\"450\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:413;a:13:{s:2:\"id\";s:3:\"293\";s:6:\"handle\";s:20:\"Caption_Light_04.png\";s:5:\"video\";s:20:\"Caption_Light_04.mp4\";s:4:\"name\";s:16:\"Caption_Light_04\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_04\";s:5:\"width\";s:4:\"1104\";s:6:\"height\";s:3:\"600\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:414;a:13:{s:2:\"id\";s:3:\"292\";s:6:\"handle\";s:22:\"Columns_4_Light_01.png\";s:5:\"video\";s:22:\"Columns_4_Light_01.mp4\";s:4:\"name\";s:18:\"Columns_4_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"Columns_4_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:415;a:13:{s:2:\"id\";s:3:\"291\";s:6:\"handle\";s:20:\"Caption_Light_05.png\";s:5:\"video\";s:20:\"Caption_Light_05.mp4\";s:4:\"name\";s:16:\"Caption_Light_05\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:16:\"Caption_Light_05\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}i:416;a:13:{s:2:\"id\";s:3:\"290\";s:6:\"handle\";s:22:\"PromoCode_Light_01.png\";s:5:\"video\";s:22:\"PromoCode_Light_01.mp4\";s:4:\"name\";s:18:\"PromoCode_Light_01\";s:4:\"tags\";a:1:{i:0;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}}s:11:\"description\";s:18:\"PromoCode_Light_01\";s:5:\"width\";s:3:\"552\";s:6:\"height\";s:3:\"300\";s:7:\"version\";s:3:\"1.0\";s:14:\"plugin_version\";s:5:\"6.0.0\";s:5:\"added\";s:19:\"2019-02-14 13:18:35\";s:6:\"active\";s:1:\"1\";s:4:\"type\";s:1:\"4\";}}s:4:\"tags\";a:18:{i:28;a:3:{s:2:\"id\";s:2:\"28\";s:6:\"handle\";s:11:\"abstraction\";s:4:\"name\";s:11:\"Abstraction\";}i:1;a:3:{s:2:\"id\";s:1:\"1\";s:6:\"handle\";s:11:\"accessories\";s:4:\"name\";s:11:\"Accessories\";}i:5;a:3:{s:2:\"id\";s:1:\"5\";s:6:\"handle\";s:3:\"art\";s:4:\"name\";s:3:\"Art\";}i:20;a:3:{s:2:\"id\";s:2:\"20\";s:6:\"handle\";s:5:\"Beach\";s:4:\"name\";s:5:\"Beach\";}i:21;a:3:{s:2:\"id\";s:2:\"21\";s:6:\"handle\";s:4:\"City\";s:4:\"name\";s:4:\"City\";}i:25;a:3:{s:2:\"id\";s:2:\"25\";s:6:\"handle\";s:4:\"dark\";s:4:\"name\";s:4:\"Dark\";}i:2;a:3:{s:2:\"id\";s:1:\"2\";s:6:\"handle\";s:6:\"device\";s:4:\"name\";s:6:\"Device\";}i:16;a:3:{s:2:\"id\";s:2:\"16\";s:6:\"handle\";s:4:\"food\";s:4:\"name\";s:4:\"Food\";}i:26;a:3:{s:2:\"id\";s:2:\"26\";s:6:\"handle\";s:5:\"light\";s:4:\"name\";s:5:\"Light\";}i:18;a:3:{s:2:\"id\";s:2:\"18\";s:6:\"handle\";s:4:\"misc\";s:4:\"name\";s:4:\"Misc\";}i:4;a:3:{s:2:\"id\";s:1:\"4\";s:6:\"handle\";s:5:\"music\";s:4:\"name\";s:5:\"Music\";}i:19;a:3:{s:2:\"id\";s:2:\"19\";s:6:\"handle\";s:6:\"nature\";s:4:\"name\";s:6:\"Nature\";}i:23;a:3:{s:2:\"id\";s:2:\"23\";s:6:\"handle\";s:5:\"Night\";s:4:\"name\";s:5:\"Night\";}i:3;a:3:{s:2:\"id\";s:1:\"3\";s:6:\"handle\";s:6:\"office\";s:4:\"name\";s:6:\"Office\";}i:24;a:3:{s:2:\"id\";s:2:\"24\";s:6:\"handle\";s:6:\"People\";s:4:\"name\";s:6:\"People\";}i:22;a:3:{s:2:\"id\";s:2:\"22\";s:6:\"handle\";s:3:\"Sky\";s:4:\"name\";s:3:\"Sky\";}i:29;a:3:{s:2:\"id\";s:2:\"29\";s:6:\"handle\";s:5:\"space\";s:4:\"name\";s:5:\"Space\";}i:27;a:3:{s:2:\"id\";s:2:\"27\";s:6:\"handle\";s:5:\"sport\";s:4:\"name\";s:5:\"Sport\";}}}", "no");
INSERT INTO `wp_options` VALUES("202", "revslider-templates-check", "1732013142", "yes");
INSERT INTO `wp_options` VALUES("203", "revslider-templates-hash", "946c0d4f47d3ad7163d2be422620df85", "yes");
INSERT INTO `wp_options` VALUES("204", "rs-templates-new", "", "off");
INSERT INTO `wp_options` VALUES("205", "rs-templates", "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", "off");
INSERT INTO `wp_options` VALUES("206", "rs-templates-counter", "80", "off");
INSERT INTO `wp_options` VALUES("210", "action_scheduler_hybrid_store_demarkation", "6", "yes");
INSERT INTO `wp_options` VALUES("211", "schema-ActionScheduler_StoreSchema", "7.0.1691853926", "yes");
INSERT INTO `wp_options` VALUES("212", "schema-ActionScheduler_LoggerSchema", "3.0.1678018602", "yes");
INSERT INTO `wp_options` VALUES("215", "woocommerce_schema_version", "920", "yes");
INSERT INTO `wp_options` VALUES("216", "woocommerce_store_address", "", "yes");
INSERT INTO `wp_options` VALUES("217", "woocommerce_store_address_2", "", "yes");
INSERT INTO `wp_options` VALUES("218", "woocommerce_store_city", "", "yes");
INSERT INTO `wp_options` VALUES("219", "woocommerce_default_country", "IR:KHZ", "yes");
INSERT INTO `wp_options` VALUES("220", "woocommerce_store_postcode", "", "yes");
INSERT INTO `wp_options` VALUES("221", "woocommerce_allowed_countries", "all", "yes");
INSERT INTO `wp_options` VALUES("222", "woocommerce_all_except_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("223", "woocommerce_specific_allowed_countries", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("224", "woocommerce_ship_to_countries", "specific", "yes");
INSERT INTO `wp_options` VALUES("225", "woocommerce_specific_ship_to_countries", "a:1:{i:0;s:2:\"IR\";}", "yes");
INSERT INTO `wp_options` VALUES("226", "woocommerce_default_customer_address", "base", "yes");
INSERT INTO `wp_options` VALUES("227", "woocommerce_calc_taxes", "no", "yes");
INSERT INTO `wp_options` VALUES("228", "woocommerce_enable_coupons", "yes", "yes");
INSERT INTO `wp_options` VALUES("229", "woocommerce_calc_discounts_sequentially", "no", "no");
INSERT INTO `wp_options` VALUES("230", "woocommerce_currency", "IRT", "yes");
INSERT INTO `wp_options` VALUES("231", "woocommerce_currency_pos", "right_space", "yes");
INSERT INTO `wp_options` VALUES("232", "woocommerce_price_thousand_sep", ",", "yes");
INSERT INTO `wp_options` VALUES("233", "woocommerce_price_decimal_sep", ".", "yes");
INSERT INTO `wp_options` VALUES("234", "woocommerce_price_num_decimals", "0", "yes");
INSERT INTO `wp_options` VALUES("235", "woocommerce_shop_page_id", "7", "yes");
INSERT INTO `wp_options` VALUES("236", "woocommerce_cart_redirect_after_add", "no", "yes");
INSERT INTO `wp_options` VALUES("237", "woocommerce_enable_ajax_add_to_cart", "yes", "yes");
INSERT INTO `wp_options` VALUES("238", "woocommerce_placeholder_image", "6", "yes");
INSERT INTO `wp_options` VALUES("239", "woocommerce_weight_unit", "kg", "yes");
INSERT INTO `wp_options` VALUES("240", "woocommerce_dimension_unit", "cm", "yes");
INSERT INTO `wp_options` VALUES("241", "woocommerce_enable_reviews", "yes", "yes");
INSERT INTO `wp_options` VALUES("242", "woocommerce_review_rating_verification_label", "yes", "no");
INSERT INTO `wp_options` VALUES("243", "woocommerce_review_rating_verification_required", "no", "no");
INSERT INTO `wp_options` VALUES("244", "woocommerce_enable_review_rating", "yes", "yes");
INSERT INTO `wp_options` VALUES("245", "woocommerce_review_rating_required", "yes", "no");
INSERT INTO `wp_options` VALUES("246", "woocommerce_manage_stock", "yes", "yes");
INSERT INTO `wp_options` VALUES("247", "woocommerce_hold_stock_minutes", "60", "no");
INSERT INTO `wp_options` VALUES("248", "woocommerce_notify_low_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("249", "woocommerce_notify_no_stock", "yes", "no");
INSERT INTO `wp_options` VALUES("250", "woocommerce_stock_email_recipient", "info@gmail.com", "no");
INSERT INTO `wp_options` VALUES("251", "woocommerce_notify_low_stock_amount", "2", "no");
INSERT INTO `wp_options` VALUES("252", "woocommerce_notify_no_stock_amount", "0", "yes");
INSERT INTO `wp_options` VALUES("253", "woocommerce_hide_out_of_stock_items", "no", "yes");
INSERT INTO `wp_options` VALUES("254", "woocommerce_stock_format", "", "yes");
INSERT INTO `wp_options` VALUES("255", "woocommerce_file_download_method", "force", "no");
INSERT INTO `wp_options` VALUES("256", "woocommerce_downloads_redirect_fallback_allowed", "no", "no");
INSERT INTO `wp_options` VALUES("257", "woocommerce_downloads_require_login", "no", "no");
INSERT INTO `wp_options` VALUES("258", "woocommerce_downloads_grant_access_after_payment", "yes", "no");
INSERT INTO `wp_options` VALUES("259", "woocommerce_downloads_deliver_inline", "", "no");
INSERT INTO `wp_options` VALUES("260", "woocommerce_downloads_add_hash_to_filename", "yes", "yes");
INSERT INTO `wp_options` VALUES("262", "woocommerce_attribute_lookup_direct_updates", "no", "yes");
INSERT INTO `wp_options` VALUES("263", "woocommerce_prices_include_tax", "no", "yes");
INSERT INTO `wp_options` VALUES("264", "woocommerce_tax_based_on", "shipping", "yes");
INSERT INTO `wp_options` VALUES("265", "woocommerce_shipping_tax_class", "inherit", "yes");
INSERT INTO `wp_options` VALUES("266", "woocommerce_tax_round_at_subtotal", "no", "yes");
INSERT INTO `wp_options` VALUES("267", "woocommerce_tax_classes", "", "yes");
INSERT INTO `wp_options` VALUES("268", "woocommerce_tax_display_shop", "excl", "yes");
INSERT INTO `wp_options` VALUES("269", "woocommerce_tax_display_cart", "excl", "yes");
INSERT INTO `wp_options` VALUES("270", "woocommerce_price_display_suffix", "", "yes");
INSERT INTO `wp_options` VALUES("271", "woocommerce_tax_total_display", "itemized", "no");
INSERT INTO `wp_options` VALUES("272", "woocommerce_enable_shipping_calc", "yes", "no");
INSERT INTO `wp_options` VALUES("273", "woocommerce_shipping_cost_requires_address", "no", "yes");
INSERT INTO `wp_options` VALUES("274", "woocommerce_ship_to_destination", "billing", "no");
INSERT INTO `wp_options` VALUES("275", "woocommerce_shipping_debug_mode", "no", "yes");
INSERT INTO `wp_options` VALUES("276", "woocommerce_enable_guest_checkout", "yes", "no");
INSERT INTO `wp_options` VALUES("277", "woocommerce_enable_checkout_login_reminder", "no", "no");
INSERT INTO `wp_options` VALUES("278", "woocommerce_enable_signup_and_login_from_checkout", "no", "no");
INSERT INTO `wp_options` VALUES("279", "woocommerce_enable_myaccount_registration", "yes", "no");
INSERT INTO `wp_options` VALUES("280", "woocommerce_registration_generate_username", "yes", "no");
INSERT INTO `wp_options` VALUES("281", "woocommerce_registration_generate_password", "yes", "no");
INSERT INTO `wp_options` VALUES("282", "woocommerce_erasure_request_removes_order_data", "no", "no");
INSERT INTO `wp_options` VALUES("283", "woocommerce_erasure_request_removes_download_data", "no", "no");
INSERT INTO `wp_options` VALUES("284", "woocommerce_allow_bulk_remove_personal_data", "no", "no");
INSERT INTO `wp_options` VALUES("285", "woocommerce_registration_privacy_policy_text", "اطلاعات شخصی شما برای پردازش سفارش شما استفاده می‌شود، و پشتیبانی از تجربه شما در این وبسایت، و برای اهداف دیگری که در [privacy_policy] توضیح داده شده است.", "yes");
INSERT INTO `wp_options` VALUES("286", "woocommerce_checkout_privacy_policy_text", "اطلاعات شخصی شما برای پردازش سفارش شما، پشتیبانی از تجربه شما در سراسر این وب سایت و برای اهدافی که در [privacy_policy] ذکر شده است استفاده می شود.", "yes");
INSERT INTO `wp_options` VALUES("287", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_options` VALUES("288", "woocommerce_trash_pending_orders", "", "no");
INSERT INTO `wp_options` VALUES("289", "woocommerce_trash_failed_orders", "", "no");
INSERT INTO `wp_options` VALUES("290", "woocommerce_trash_cancelled_orders", "", "no");
INSERT INTO `wp_options` VALUES("291", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "no");
INSERT INTO `wp_options` VALUES("292", "woocommerce_email_from_name", "قالب اختصاصی وودمارت", "no");
INSERT INTO `wp_options` VALUES("293", "woocommerce_email_from_address", "info@gmail.com", "no");
INSERT INTO `wp_options` VALUES("294", "woocommerce_email_header_image", "", "no");
INSERT INTO `wp_options` VALUES("295", "woocommerce_email_footer_text", "{site_title} &mdash; Built with {WooCommerce}", "no");
INSERT INTO `wp_options` VALUES("296", "woocommerce_email_base_color", "#7f54b3", "no");
INSERT INTO `wp_options` VALUES("297", "woocommerce_email_background_color", "#f7f7f7", "no");
INSERT INTO `wp_options` VALUES("298", "woocommerce_email_body_background_color", "#ffffff", "no");
INSERT INTO `wp_options` VALUES("299", "woocommerce_email_text_color", "#3c3c3c", "no");
INSERT INTO `wp_options` VALUES("300", "woocommerce_merchant_email_notifications", "no", "no");
INSERT INTO `wp_options` VALUES("301", "woocommerce_cart_page_id", "8", "no");
INSERT INTO `wp_options` VALUES("302", "woocommerce_checkout_page_id", "9", "no");
INSERT INTO `wp_options` VALUES("303", "woocommerce_myaccount_page_id", "10", "no");
INSERT INTO `wp_options` VALUES("304", "woocommerce_terms_page_id", "", "no");
INSERT INTO `wp_options` VALUES("305", "woocommerce_checkout_pay_endpoint", "order-pay", "yes");
INSERT INTO `wp_options` VALUES("306", "woocommerce_checkout_order_received_endpoint", "order-received", "yes");
INSERT INTO `wp_options` VALUES("307", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "yes");
INSERT INTO `wp_options` VALUES("308", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "yes");
INSERT INTO `wp_options` VALUES("309", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "yes");
INSERT INTO `wp_options` VALUES("310", "woocommerce_myaccount_orders_endpoint", "orders", "yes");
INSERT INTO `wp_options` VALUES("311", "woocommerce_myaccount_view_order_endpoint", "view-order", "yes");
INSERT INTO `wp_options` VALUES("312", "woocommerce_myaccount_downloads_endpoint", "downloads", "yes");
INSERT INTO `wp_options` VALUES("313", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "yes");
INSERT INTO `wp_options` VALUES("314", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "yes");
INSERT INTO `wp_options` VALUES("315", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "yes");
INSERT INTO `wp_options` VALUES("316", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "yes");
INSERT INTO `wp_options` VALUES("317", "woocommerce_logout_endpoint", "customer-logout", "yes");
INSERT INTO `wp_options` VALUES("318", "woocommerce_api_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("319", "woocommerce_allow_tracking", "no", "on");
INSERT INTO `wp_options` VALUES("320", "woocommerce_show_marketplace_suggestions", "yes", "no");
INSERT INTO `wp_options` VALUES("321", "woocommerce_analytics_enabled", "yes", "yes");
INSERT INTO `wp_options` VALUES("322", "woocommerce_navigation_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("323", "woocommerce_new_product_management_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("324", "woocommerce_feature_custom_order_tables_enabled", "no", "yes");
INSERT INTO `wp_options` VALUES("325", "woocommerce_single_image_width", "600", "yes");
INSERT INTO `wp_options` VALUES("326", "woocommerce_thumbnail_image_width", "300", "yes");
INSERT INTO `wp_options` VALUES("327", "woocommerce_checkout_highlight_required_fields", "yes", "yes");
INSERT INTO `wp_options` VALUES("328", "woocommerce_demo_store", "no", "no");
INSERT INTO `wp_options` VALUES("329", "wc_downloads_approved_directories_mode", "enabled", "yes");
INSERT INTO `wp_options` VALUES("330", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:7:\"product\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:0;}", "yes");
INSERT INTO `wp_options` VALUES("331", "current_theme_supports_woocommerce", "yes", "yes");
INSERT INTO `wp_options` VALUES("332", "woocommerce_queue_flush_rewrite_rules", "no", "yes");
INSERT INTO `wp_options` VALUES("335", "default_product_cat", "15", "yes");
INSERT INTO `wp_options` VALUES("337", "woocommerce_refund_returns_page_id", "11", "yes");
INSERT INTO `wp_options` VALUES("340", "woocommerce_paypal_settings", "a:23:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:13:\"پی‌پال\";s:11:\"description\";s:168:\"پرداخت از راه پی‌پال، اگر حساب کاربری پی‌پال ندارید، می توانید با کارت اعتباری پرداخت کنید.\";s:5:\"email\";s:14:\"info@gmail.com\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:14:\"info@gmail.com\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:9:\"image_url\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:12:\"_should_load\";s:2:\"no\";}", "yes");
INSERT INTO `wp_options` VALUES("341", "woocommerce_version", "9.5.1", "yes");
INSERT INTO `wp_options` VALUES("342", "woocommerce_db_version", "9.5.1", "yes");
INSERT INTO `wp_options` VALUES("343", "woocommerce_admin_install_timestamp", "1678018610", "yes");
INSERT INTO `wp_options` VALUES("344", "woocommerce_inbox_variant_assignment", "10", "yes");
INSERT INTO `wp_options` VALUES("348", "recently_activated", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("349", "revslider-update-check", "1732013146", "yes");
INSERT INTO `wp_options` VALUES("350", "revslider_update_info", "O:8:\"stdClass\":0:{}", "yes");
INSERT INTO `wp_options` VALUES("352", "action_scheduler_lock_async-request-runner", "676d6d26d3f644.71740712|1735224674", "yes");
INSERT INTO `wp_options` VALUES("353", "woocommerce_admin_notices", "a:2:{i:0;s:6:\"update\";i:1;s:14:\"template_files\";}", "yes");
INSERT INTO `wp_options` VALUES("354", "revslider_update_version", "6.6.21", "yes");
INSERT INTO `wp_options` VALUES("355", "elementor_version", "3.26.3", "yes");
INSERT INTO `wp_options` VALUES("356", "elementor_install_history", "a:5:{s:6:\"3.11.2\";i:1678050960;s:6:\"3.12.2\";i:1683124748;s:6:\"3.15.2\";i:1694961751;s:6:\"3.23.2\";i:1721839127;s:6:\"3.26.3\";i:1735162583;}", "yes");
INSERT INTO `wp_options` VALUES("357", "elementor_events_db_version", "1.0.0", "no");
INSERT INTO `wp_options` VALUES("358", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"sKcqlKur723Am2iiD8OFQRFSYPgsHFpt\";}", "yes");
INSERT INTO `wp_options` VALUES("360", "widget_rev-slider-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("361", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("362", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("363", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("364", "widget_woocommerce_price_filter", "a:2:{i:2;a:1:{s:5:\"title\";s:33:\"فیلتر براساس قیمت:\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("365", "widget_woocommerce_product_categories", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("366", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("367", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("368", "widget_woocommerce_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("369", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("370", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("371", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("372", "widget_woocommerce_rating_filter", "a:3:{i:2;a:1:{s:5:\"title\";s:23:\"امتیاز محصول\";}i:3;a:1:{s:5:\"title\";s:36:\"میانگین رای (امتیاز)\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("373", "widget_nav_mega_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("374", "widget_woodmart-banner", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("375", "widget_woodmart-author-information", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("376", "widget_woodmart-instagram", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("377", "widget_woodmart-html-block", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("378", "widget_woodmart-recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("379", "widget_woodmart-twitter", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("380", "widget_wd-mailchimp-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("381", "widget_woodmart-user-panel", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("382", "widget_woodmart-woocommerce-layered-nav", "a:4:{i:2;a:11:{s:5:\"title\";s:32:\"فیلتر بر اساس رنگ:\";s:9:\"attribute\";s:5:\"color\";s:8:\"category\";a:1:{i:0;s:3:\"all\";}s:10:\"query_type\";s:3:\"and\";s:7:\"display\";s:4:\"list\";s:4:\"size\";s:6:\"normal\";s:5:\"style\";s:7:\"inherit\";s:5:\"shape\";s:7:\"inherit\";s:6:\"labels\";s:2:\"on\";s:8:\"tooltips\";s:2:\"on\";s:17:\"search_by_filters\";b:0;}i:3;a:11:{s:5:\"title\";s:35:\"فیلتر بر اساس برند :\";s:9:\"attribute\";s:5:\"brand\";s:8:\"category\";a:1:{i:0;s:3:\"all\";}s:10:\"query_type\";s:3:\"and\";s:7:\"display\";s:4:\"list\";s:4:\"size\";s:6:\"normal\";s:5:\"style\";s:7:\"inherit\";s:5:\"shape\";s:7:\"inherit\";s:6:\"labels\";s:2:\"on\";s:8:\"tooltips\";s:2:\"on\";s:17:\"search_by_filters\";b:0;}i:4;a:11:{s:5:\"title\";s:26:\"فیلتر بر اساس :\";s:9:\"attribute\";s:5:\"brand\";s:8:\"category\";a:1:{i:0;s:3:\"all\";}s:10:\"query_type\";s:3:\"and\";s:7:\"display\";s:4:\"list\";s:4:\"size\";s:6:\"normal\";s:5:\"style\";s:7:\"inherit\";s:5:\"shape\";s:5:\"round\";s:6:\"labels\";s:2:\"on\";s:8:\"tooltips\";s:2:\"on\";s:17:\"search_by_filters\";b:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("383", "widget_woodmart-woocommerce-sort-by", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("384", "widget_woodmart-price-filter", "a:3:{i:4;a:2:{s:5:\"title\";s:33:\"فیلتر بر اساس قیمت\";s:11:\"show_ranges\";s:1:\"1\";}i:5;a:2:{s:5:\"title\";s:19:\"فیلتر قیمت\";s:11:\"show_ranges\";b:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("385", "widget_woodmart-ajax-search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("386", "widget_wd-widget-stock-status", "a:3:{i:2;a:4:{s:5:\"title\";s:34:\"وضعیت موجودی محصول\";s:7:\"instock\";s:1:\"1\";s:6:\"onsale\";s:1:\"1\";s:11:\"onbackorder\";b:0;}i:3;a:4:{s:5:\"title\";s:23:\"وضعیت موجودی\";s:7:\"instock\";s:1:\"1\";s:6:\"onsale\";s:1:\"1\";s:11:\"onbackorder\";b:0;}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("392", "wc_remote_inbox_notifications_stored_state", "O:8:\"stdClass\":2:{s:22:\"there_were_no_products\";b:1;s:22:\"there_are_now_products\";b:1;}", "no");
INSERT INTO `wp_options` VALUES("398", "wc_blocks_db_schema_version", "260", "yes");
INSERT INTO `wp_options` VALUES("416", "_elementor_installed_time", "1678050991", "yes");
INSERT INTO `wp_options` VALUES("417", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:28:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:3:\"faq\";i:9;s:8:\"features\";i:10;s:6:\"footer\";i:11;s:7:\"Gallery\";i:12;s:6:\"header\";i:13;s:4:\"hero\";i:14;s:11:\"Link in Bio\";i:15;s:9:\"portfolio\";i:16;s:7:\"pricing\";i:17;s:15:\"product archive\";i:18;s:5:\"Quote\";i:19;s:15:\"Service Details\";i:20;s:8:\"services\";i:21;s:11:\"single page\";i:22;s:11:\"single post\";i:23;s:14:\"single product\";i:24;s:5:\"stats\";i:25;s:9:\"subscribe\";i:26;s:4:\"team\";i:27;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:28:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:3:\"faq\";i:9;s:8:\"features\";i:10;s:6:\"footer\";i:11;s:7:\"Gallery\";i:12;s:6:\"header\";i:13;s:4:\"hero\";i:14;s:11:\"Link in Bio\";i:15;s:9:\"portfolio\";i:16;s:7:\"pricing\";i:17;s:15:\"product archive\";i:18;s:5:\"Quote\";i:19;s:15:\"Service Details\";i:20;s:8:\"services\";i:21;s:11:\"single page\";i:22;s:11:\"single post\";i:23;s:14:\"single product\";i:24;s:5:\"stats\";i:25;s:9:\"subscribe\";i:26;s:4:\"team\";i:27;s:12:\"testimonials\";}s:9:\"templates\";a:823:{i:0;a:19:{s:4:\"tmpl\";i:1280;s:2:\"id\";i:22403;s:5:\"title\";s:40:\"Hello Bar | Subscribe | Aesthetic Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/aesthetic-clinic-19.jpg\";s:12:\"tmpl_created\";i:1647354307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/hello-bar-subscribe-aesthetic-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:48:\"[\"Barbershop\",\"Business\",\"Discount\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:1;a:19:{s:4:\"tmpl\";i:1281;s:2:\"id\";i:22410;s:5:\"title\";s:32:\"Fly-In | Discount | Hair Stylist\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/hair-stylist-20.jpg\";s:12:\"tmpl_created\";i:1647354614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-discount-hair-stylist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Barbershop\",\"Discount\",\"Hair\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:2;a:19:{s:4:\"tmpl\";i:1285;s:2:\"id\";i:22440;s:5:\"title\";s:32:\"Classic | Subscribe | Shoe Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/shoes-store-21.jpg\";s:12:\"tmpl_created\";i:1647418620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-subscribe-shoe-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:37:\"[\"Ecommerce\",\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:3;a:19:{s:4:\"tmpl\";i:1286;s:2:\"id\";i:22446;s:5:\"title\";s:37:\"Full Screen | Subscribe | Denim Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/denim-store-22.jpg\";s:12:\"tmpl_created\";i:1647419614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/full-screen-subscribe-denim-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:4;a:19:{s:4:\"tmpl\";i:1287;s:2:\"id\";i:22452;s:5:\"title\";s:37:\"Fly-In | Subscribe | Pizza Restaurant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/pizza-restaurant-23.jpg\";s:12:\"tmpl_created\";i:1647420733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-subscribe-pizza-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:19:\"[\"Business\",\"Food\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:5;a:19:{s:4:\"tmpl\";i:1288;s:2:\"id\";i:22458;s:5:\"title\";s:38:\"Full Screen | Subscribe | Fashion Shop\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-shop-24.jpg\";s:12:\"tmpl_created\";i:1647426379;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-subscribe-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Ecommerce\",\"Fashion\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:6;a:19:{s:4:\"tmpl\";i:1289;s:2:\"id\";i:22464;s:5:\"title\";s:32:\"Fly-In | Contact | Makeup Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/makeup-studio-25.jpg\";s:12:\"tmpl_created\";i:1647427026;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-makeup-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:7;a:19:{s:4:\"tmpl\";i:1290;s:2:\"id\";i:22470;s:5:\"title\";s:32:\"Fly-In | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-26.jpg\";s:12:\"tmpl_created\";i:1647428250;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:8;a:19:{s:4:\"tmpl\";i:1291;s:2:\"id\";i:22480;s:5:\"title\";s:27:\"Classic | CTA | MasterClass\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/master-class-27.jpg\";s:12:\"tmpl_created\";i:1647428474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-masterclass/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"cta\",\"Magazine\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:9;a:19:{s:4:\"tmpl\";i:1292;s:2:\"id\";i:22489;s:5:\"title\";s:29:\"Classic | CTA | Music Concert\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/music-concert-29.jpg\";s:12:\"tmpl_created\";i:1647429738;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-music-concert/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"cta\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:10;a:19:{s:4:\"tmpl\";i:1293;s:2:\"id\";i:22495;s:5:\"title\";s:27:\"Classic | CTA | Music Album\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/music-album-30.jpg\";s:12:\"tmpl_created\";i:1647430056;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-music-album/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Ba\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:11;a:19:{s:4:\"tmpl\";i:1294;s:2:\"id\";i:22501;s:5:\"title\";s:37:\"Fly-In | CTA | Photography Exhibition\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/photography-exhibition-31.jpg\";s:12:\"tmpl_created\";i:1647430512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-photography-exhibition/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:12;a:19:{s:4:\"tmpl\";i:1295;s:2:\"id\";i:22507;s:5:\"title\";s:34:\"Classic | CTA | Clothing Shop Sale\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/clothing-shop-sale-32.jpg\";s:12:\"tmpl_created\";i:1647430774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-cta-clothing-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:13;a:19:{s:4:\"tmpl\";i:1296;s:2:\"id\";i:22486;s:5:\"title\";s:30:\"Classic | CTA | Shop Promotion\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/shop-promotion-28.jpg\";s:12:\"tmpl_created\";i:1647430951;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-shop-promotion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"cta\",\"Magazine\",\"Photography\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:14;a:19:{s:4:\"tmpl\";i:1297;s:2:\"id\";i:22516;s:5:\"title\";s:32:\"Fly-In | CTA | Glasses Shop Sale\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/glasses-shop-sale-33.jpg\";s:12:\"tmpl_created\";i:1647431136;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-cta-glasses-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:30:\"[\"Business\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:15;a:19:{s:4:\"tmpl\";i:1298;s:2:\"id\";i:22522;s:5:\"title\";s:30:\"Fly-In | Discount | Skate Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/50-skate-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647434058;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-skate-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:16;a:19:{s:4:\"tmpl\";i:1299;s:2:\"id\";i:22532;s:5:\"title\";s:43:\"Classic | Subscription | Basketball Academy\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/21-basketball-academy-Subscription.jpg\";s:12:\"tmpl_created\";i:1647434608;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/classic-subscription-basketball-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Education\",\"Marketing\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:17;a:19:{s:4:\"tmpl\";i:1300;s:2:\"id\";i:22543;s:5:\"title\";s:38:\"Classic | Discount | Veterinary Clinic\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/veterinery-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647435581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-discount-veterinary-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Discount\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:18;a:19:{s:4:\"tmpl\";i:1301;s:2:\"id\";i:22553;s:5:\"title\";s:39:\"Classic | Contact | Business Consulting\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/27-business-consulting-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647439935;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/classic-contact-business-consulting/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:19;a:19:{s:4:\"tmpl\";i:1302;s:2:\"id\";i:22562;s:5:\"title\";s:28:\"Classic | Contact | Handyman\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/handyman-small.jpg\";s:12:\"tmpl_created\";i:1647440333;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-contact-handyman/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:20;a:19:{s:4:\"tmpl\";i:1303;s:2:\"id\";i:22573;s:5:\"title\";s:40:\"Classic | Discount | Online Fashion Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/31-online-fashion-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647462549;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-online-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:21;a:19:{s:4:\"tmpl\";i:1304;s:2:\"id\";i:22583;s:5:\"title\";s:36:\"Fly-In | Discount | Personal Trainer\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/personal-trainer-small.jpg\";s:12:\"tmpl_created\";i:1647503781;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-personal-trainer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:22;a:19:{s:4:\"tmpl\";i:1305;s:2:\"id\";i:22592;s:5:\"title\";s:41:\"Classic | Contact | Illustrator Portfolio\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/illustrator-protfolio-small.jpg\";s:12:\"tmpl_created\";i:1647504218;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-contact-illustrator-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:49:\"[\"Contact\",\"Creative Portfolio\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:23;a:19:{s:4:\"tmpl\";i:1306;s:2:\"id\";i:22602;s:5:\"title\";s:46:\"Bottom Bar | Discount | Handmade Ceramics Shop\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2022/03/handmade-ceramic-shop-36-small.jpg\";s:12:\"tmpl_created\";i:1647507007;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-ceramics-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:48:\"[\"Business\",\"cta\",\"Ecommerce\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:24;a:19:{s:4:\"tmpl\";i:1307;s:2:\"id\";i:22612;s:5:\"title\";s:51:\"Classic | Contact | Classic Car Restoration Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/restoration-car-shop-37-small.jpg\";s:12:\"tmpl_created\";i:1647507310;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/classic-contact-classic-car-restoration-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:25;a:19:{s:4:\"tmpl\";i:1308;s:2:\"id\";i:22621;s:5:\"title\";s:30:\"Classic | Booking | Life Coach\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/38-life-coach-Booking.jpg\";s:12:\"tmpl_created\";i:1647508596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-booking-life-coach/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Booking\",\"Business\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:26;a:19:{s:4:\"tmpl\";i:1309;s:2:\"id\";i:22632;s:5:\"title\";s:42:\"Classic |  Subscription | Merchandise Shop\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/Merchandise-Shop-39-small.jpg\";s:12:\"tmpl_created\";i:1647509196;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-subscription-merchandise-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Ecommerce\",\"Marketing\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:27;a:19:{s:4:\"tmpl\";i:1310;s:2:\"id\";i:22643;s:5:\"title\";s:48:\"Fly-In | Contact | Non-Governmental Organization\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/NGO-41-small.jpg\";s:12:\"tmpl_created\";i:1647509528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:150:\"https://library.elementor.com/popups/fly-in-contact-non-governmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:28;a:19:{s:4:\"tmpl\";i:1311;s:2:\"id\";i:22654;s:5:\"title\";s:35:\"Hello Bar | Contact | Family Doctor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/family-doctor-44-small.jpg\";s:12:\"tmpl_created\";i:1647509732;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/hello-bar-contact-family-doctor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Contact\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:29;a:19:{s:4:\"tmpl\";i:1312;s:2:\"id\";i:22663;s:5:\"title\";s:36:\"Classic | Subscription | Sports Blog\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/45-sport-blog-Subscription.jpg\";s:12:\"tmpl_created\";i:1647509908;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-sports-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:30;a:19:{s:4:\"tmpl\";i:1313;s:2:\"id\";i:22673;s:5:\"title\";s:30:\"Hello Bar | Booking | Event DJ\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/DJ-service-46-small.jpg\";s:12:\"tmpl_created\";i:1647510160;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/hello-bar-booking-event-dj/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Booking\",\"Events\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:31;a:19:{s:4:\"tmpl\";i:1314;s:2:\"id\";i:22684;s:5:\"title\";s:36:\"Fly-In | Discount | Cleaning Company\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/51-cleaning-company-Discount.jpg\";s:12:\"tmpl_created\";i:1647510546;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-cleaning-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Offer\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:32;a:19:{s:4:\"tmpl\";i:1315;s:2:\"id\";i:22693;s:5:\"title\";s:28:\"Fly-In | Contact | Carpenter\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/carpenter-53-small.jpg\";s:12:\"tmpl_created\";i:1647511972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-carpenter/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:33;a:19:{s:4:\"tmpl\";i:1316;s:2:\"id\";i:22703;s:5:\"title\";s:31:\"Classic | Booking | Yoga Studio\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/55-yoga-studio-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647512209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-booking-yoga-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Booking\",\"Contact\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:34;a:19:{s:4:\"tmpl\";i:1317;s:2:\"id\";i:22714;s:5:\"title\";s:37:\"Classic | Discount | Pet Care Company\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/56-Pet-Care-Discount.jpg\";s:12:\"tmpl_created\";i:1647513031;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-pet-care-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:35;a:19:{s:4:\"tmpl\";i:1318;s:2:\"id\";i:22725;s:5:\"title\";s:38:\"Fly-In | Discount | Online Coffee Shop\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/online-coffee-shop-57-small.jpg\";s:12:\"tmpl_created\";i:1647513325;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-discount-online-coffee-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Food\",\"Offer\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:36;a:19:{s:4:\"tmpl\";i:1319;s:2:\"id\";i:22737;s:5:\"title\";s:44:\"Fly-In | CTA | Moving &#038; Storage Company\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/moving-company-59-small.jpg\";s:12:\"tmpl_created\";i:1647520956;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-moving-storage-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:37;a:19:{s:4:\"tmpl\";i:1320;s:2:\"id\";i:22749;s:5:\"title\";s:47:\"Classic | Contact | Industrial Design Portfolio\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/60-industrial-design-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647528116;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/classic-contact-industrial-design-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:40:\"[\"Contact\",\"Interior Design\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:38;a:19:{s:4:\"tmpl\";i:1321;s:2:\"id\";i:22759;s:5:\"title\";s:25:\"Classic | Contact | Drone\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/drone-61-small.jpg\";s:12:\"tmpl_created\";i:1647528899;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-contact-drone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:39;a:19:{s:4:\"tmpl\";i:1322;s:2:\"id\";i:22768;s:5:\"title\";s:46:\"Full Screen | Menu | Fashion Stylist Portfolio\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/62-Fashion-Stylist-Menu.jpg\";s:12:\"tmpl_created\";i:1647529434;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/full-screen-menu-fashion-stylist-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Fashion\",\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:40;a:19:{s:4:\"tmpl\";i:1323;s:2:\"id\";i:22780;s:5:\"title\";s:31:\"Fly-In | CTA | Landscape Design\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/64-Landscape-Design-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647530337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-landscape-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:41;a:19:{s:4:\"tmpl\";i:1324;s:2:\"id\";i:22790;s:5:\"title\";s:48:\"Bottom Bar  | Contact | Architecture Photography\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/architecture-photography-65-small.jpg\";s:12:\"tmpl_created\";i:1647532358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/bottom-bar-contact-architecture-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:26:\"[\"Architecture\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:42;a:19:{s:4:\"tmpl\";i:1325;s:2:\"id\";i:22800;s:5:\"title\";s:41:\"Fly-In  | CTA | Speech-Language Therapist\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/66-Speech-Language-Therapist-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647532720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/fly-in-cta-speech-language-therapist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:25:\"[\"cta\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:43;a:19:{s:4:\"tmpl\";i:1326;s:2:\"id\";i:22812;s:5:\"title\";s:35:\"Full Screen | Verification | Winery\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/67-Winery-Verification.jpg\";s:12:\"tmpl_created\";i:1647761384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/full-screen-verification-winery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:24:\"[\"Alert\",\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:44;a:19:{s:4:\"tmpl\";i:1327;s:2:\"id\";i:22822;s:5:\"title\";s:36:\"Fly-In | Subscription | Nutritionist\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/nutritionist-69-small.jpg\";s:12:\"tmpl_created\";i:1647762620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-subscription-nutritionist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Food\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:45;a:19:{s:4:\"tmpl\";i:1328;s:2:\"id\";i:22833;s:5:\"title\";s:40:\"Classic | Subscription | App &#038; SaaS\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/app-70-small.jpg\";s:12:\"tmpl_created\";i:1647762955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-subscription-app-saas/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:14:\"[\"App\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:46;a:19:{s:4:\"tmpl\";i:1329;s:2:\"id\";i:22844;s:5:\"title\";s:41:\"Bottom Bar | Discount | Handmade Cupcakes\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/72-Handmade-Cupcakes-Discount.jpg\";s:12:\"tmpl_created\";i:1647763350;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-cupcakes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:21:\"[\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:47;a:19:{s:4:\"tmpl\";i:1330;s:2:\"id\";i:22855;s:5:\"title\";s:40:\"Bottom Bar | Subscription | Fashion Blog\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-blog-75-small.jpg\";s:12:\"tmpl_created\";i:1647763907;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/bottom-bar-subscription-fashion-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:30:\"[\"Blog\",\"Fashion\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:48;a:19:{s:4:\"tmpl\";i:1331;s:2:\"id\";i:22866;s:5:\"title\";s:28:\"Fly-In | CTA | Private Tutor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-77-small.jpg\";s:12:\"tmpl_created\";i:1647764062;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-cta-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:49;a:19:{s:4:\"tmpl\";i:1332;s:2:\"id\";i:22876;s:5:\"title\";s:30:\"Classic | CTA | Tennis Academy\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/78-Tennis-Academy-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765192;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-tennis-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:50;a:19:{s:4:\"tmpl\";i:1333;s:2:\"id\";i:22887;s:5:\"title\";s:31:\"Fly-In | CTA | Shared Workspace\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/shared-workspace-79-small.jpg\";s:12:\"tmpl_created\";i:1647765419;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-shared-workspace/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Business\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:51;a:19:{s:4:\"tmpl\";i:1334;s:2:\"id\";i:22899;s:5:\"title\";s:30:\"Bottom Bar | CTA | Art Gallery\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/80-Art-Gallery-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765652;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/bottom-bar-cta-art-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:13:\"[\"Art\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:52;a:19:{s:4:\"tmpl\";i:1335;s:2:\"id\";i:22910;s:5:\"title\";s:44:\"Fly-In | Subscription | Hiking Tours Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/hiking-tours-company-81-small.jpg\";s:12:\"tmpl_created\";i:1647765835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscription-hiking-tours-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Subscribe\",\"Travel\",\"Trip\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:53;a:19:{s:4:\"tmpl\";i:1336;s:2:\"id\";i:22921;s:5:\"title\";s:26:\"Classic | CTA | Music Band\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/music-band-82-small.jpg\";s:12:\"tmpl_created\";i:1647769462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/classic-cta-music-band/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Marketing\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:54;a:19:{s:4:\"tmpl\";i:1337;s:2:\"id\";i:22935;s:5:\"title\";s:35:\"Classic | CTA | Computer Technician\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/comuter-technician-83-small.jpg\";s:12:\"tmpl_created\";i:1647769843;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-computer-technician/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:55;a:19:{s:4:\"tmpl\";i:1338;s:2:\"id\";i:22945;s:5:\"title\";s:37:\"Classic | Discount | Delivery Company\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/delivery-company-88-small.jpg\";s:12:\"tmpl_created\";i:1647770834;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-delivery-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Discount\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:56;a:19:{s:4:\"tmpl\";i:1339;s:2:\"id\";i:22959;s:5:\"title\";s:29:\"Classic | Discount | Eco Shop\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/echo-shop-89-small.jpg\";s:12:\"tmpl_created\";i:1647771211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-discount-eco-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Discount\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:57;a:19:{s:4:\"tmpl\";i:1340;s:2:\"id\";i:22972;s:5:\"title\";s:54:\"Fly-In | Subscription | Health &#038; Mindfulness Blog\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small.jpg\";s:12:\"tmpl_created\";i:1647771461;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/fly-in-subscription-health-mindfulness-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:21:\"[\"Health\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:58;a:19:{s:4:\"tmpl\";i:1341;s:2:\"id\";i:22982;s:5:\"title\";s:31:\"Full Screen | Menu | Art Museum\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/art-museum-112-small.jpg\";s:12:\"tmpl_created\";i:1647771938;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/full-screen-menu-art-museum/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:59;a:19:{s:4:\"tmpl\";i:1342;s:2:\"id\";i:22992;s:5:\"title\";s:40:\"Classic | Discount | Urban Clothing Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small-1.jpg\";s:12:\"tmpl_created\";i:1647773067;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-urban-clothing-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Discount\",\"Ecommerce\",\"Fashion\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:60;a:19:{s:4:\"tmpl\";i:1343;s:2:\"id\";i:23004;s:5:\"title\";s:60:\"Full Screen | Menu | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small-1.jpg\";s:12:\"tmpl_created\";i:1647773366;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:155:\"https://library.elementor.com/popups/full-screen-menu-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:61;a:19:{s:4:\"tmpl\";i:1344;s:2:\"id\";i:23015;s:5:\"title\";s:62:\"Bottom Bar | Contact | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small.jpg\";s:12:\"tmpl_created\";i:1647773492;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/popups/bottom-bar-contact-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:23:\"[\"Contact\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:62;a:19:{s:4:\"tmpl\";i:1345;s:2:\"id\";i:23025;s:5:\"title\";s:32:\"Full Screen | Menu | Flower Shop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small.jpg\";s:12:\"tmpl_created\";i:1647773820;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/full-screen-menu-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:63;a:19:{s:4:\"tmpl\";i:1346;s:2:\"id\";i:23037;s:5:\"title\";s:36:\"Classic | Subscription | Flower Shop\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small-1.jpg\";s:12:\"tmpl_created\";i:1647773949;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Discount\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:64;a:19:{s:4:\"tmpl\";i:1347;s:2:\"id\";i:23056;s:5:\"title\";s:48:\"Classic | Discount | Health &#038; Fitness eBook\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small-1.jpg\";s:12:\"tmpl_created\";i:1647774468;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-discount-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:65;a:19:{s:4:\"tmpl\";i:1348;s:2:\"id\";i:23067;s:5:\"title\";s:37:\"Fly-In | Menu | Baby Sleep Consultant\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small-1.jpg\";s:12:\"tmpl_created\";i:1647778954;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:66;a:19:{s:4:\"tmpl\";i:1349;s:2:\"id\";i:23077;s:5:\"title\";s:46:\"Classic | Subscription | Baby Sleep Consultant\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small.jpg\";s:12:\"tmpl_created\";i:1647779074;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/classic-subscription-baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:12:\"[\"Discount\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:67;a:19:{s:4:\"tmpl\";i:1350;s:2:\"id\";i:23090;s:5:\"title\";s:33:\"Full Screen | Menu | Luxury Hotel\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small.jpg\";s:12:\"tmpl_created\";i:1647779390;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/full-screen-menu-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:68;a:19:{s:4:\"tmpl\";i:1351;s:2:\"id\";i:23100;s:5:\"title\";s:31:\"Fly-In | Booking | Luxury Hotel\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small-1.jpg\";s:12:\"tmpl_created\";i:1647779500;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-booking-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Booking\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:69;a:19:{s:4:\"tmpl\";i:1352;s:2:\"id\";i:23109;s:5:\"title\";s:38:\"Full Screen | Menu | Design Conference\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small.jpg\";s:12:\"tmpl_created\";i:1647779675;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-menu-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:70;a:19:{s:4:\"tmpl\";i:1353;s:2:\"id\";i:23120;s:5:\"title\";s:41:\"Full Screen | Booking | Design Conference\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small-1.jpg\";s:12:\"tmpl_created\";i:1647779793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/full-screen-booking-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Booking\",\"Conference\",\"Creative\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:71;a:19:{s:4:\"tmpl\";i:1354;s:2:\"id\";i:23129;s:5:\"title\";s:29:\"Slide-In | Menu | VR Headsets\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small.jpg\";s:12:\"tmpl_created\";i:1647781211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/slide-in-menu-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:72;a:19:{s:4:\"tmpl\";i:1355;s:2:\"id\";i:23139;s:5:\"title\";s:31:\"Classic | Contact | VR Headsets\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small-1.jpg\";s:12:\"tmpl_created\";i:1647781384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-contact-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:73;a:19:{s:4:\"tmpl\";i:1356;s:2:\"id\";i:23149;s:5:\"title\";s:38:\"Slide-In | Menu | Portrait Photography\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Menu.jpg\";s:12:\"tmpl_created\";i:1647782336;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/slide-in-menu-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:74;a:19:{s:4:\"tmpl\";i:1357;s:2:\"id\";i:23159;s:5:\"title\";s:47:\"Hello Bar | Subscription | Portrait Photography\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Subscription.jpg\";s:12:\"tmpl_created\";i:1647782478;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/hello-bar-subscription-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Blog\",\"Photography\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:75;a:19:{s:4:\"tmpl\";i:1358;s:2:\"id\";i:23169;s:5:\"title\";s:32:\"Full Screen | Menu | English Pub\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Menu.jpg\";s:12:\"tmpl_created\";i:1647782664;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/full-screen-menu-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:76;a:19:{s:4:\"tmpl\";i:1359;s:2:\"id\";i:23179;s:5:\"title\";s:32:\"Classic | Discount | English Pub\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Discount.jpg\";s:12:\"tmpl_created\";i:1647782796;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-discount-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:20:\"[\"Discount\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:77;a:19:{s:4:\"tmpl\";i:1360;s:2:\"id\";i:23189;s:5:\"title\";s:27:\"Full Screen | Menu | Singer\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Menu.jpg\";s:12:\"tmpl_created\";i:1647783070;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/full-screen-menu-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:29:\"[\"Fullscreen\",\"menu\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:78;a:19:{s:4:\"tmpl\";i:1361;s:2:\"id\";i:23200;s:5:\"title\";s:31:\"Classic | Subscription | Singer\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Subscription.jpg\";s:12:\"tmpl_created\";i:1647783249;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-subscription-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Music\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:79;a:19:{s:4:\"tmpl\";i:1362;s:2:\"id\";i:23210;s:5:\"title\";s:38:\"Full Screen | Menu | Virtual Assistant\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistnt-73-small.jpg\";s:12:\"tmpl_created\";i:1647784292;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-menu-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:80;a:19:{s:4:\"tmpl\";i:1363;s:2:\"id\";i:23223;s:5:\"title\";s:39:\"Hello Bar | Contact | Virtual Assistant\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/73-Virtual-Assistant-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647784616;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-contact-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:37:\"[\"Contact\",\"Psychologist\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:81;a:19:{s:4:\"tmpl\";i:1364;s:2:\"id\";i:23234;s:5:\"title\";s:32:\"Slide-In  | Menu | Personal Chef\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Menu.jpg\";s:12:\"tmpl_created\";i:1647798194;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/slide-in-menu-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:82;a:19:{s:4:\"tmpl\";i:1365;s:2:\"id\";i:23244;s:5:\"title\";s:29:\"Classic | CTA | Personal Chef\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647798297;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Booking\",\"Chef\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:83;a:19:{s:4:\"tmpl\";i:1366;s:2:\"id\";i:23254;s:5:\"title\";s:31:\"Full Screen | Menu | Food Truck\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small-1.jpg\";s:12:\"tmpl_created\";i:1647798447;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/full-screen-menu-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:84;a:19:{s:4:\"tmpl\";i:1367;s:2:\"id\";i:23265;s:5:\"title\";s:30:\"Fly-In | Discount | Food Truck\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small.jpg\";s:12:\"tmpl_created\";i:1647798657;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Discount\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:85;a:19:{s:4:\"tmpl\";i:1369;s:2:\"id\";i:23323;s:5:\"title\";s:28:\"Classic | CTA | Black Friday\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-6-Small.jpg\";s:12:\"tmpl_created\";i:1647855505;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:86;a:19:{s:4:\"tmpl\";i:1370;s:2:\"id\";i:23329;s:5:\"title\";s:29:\"Slide-In | CTA | Black Friday\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-5-Small.jpg\";s:12:\"tmpl_created\";i:1647855865;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/slide-in-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:87;a:19:{s:4:\"tmpl\";i:1371;s:2:\"id\";i:23335;s:5:\"title\";s:31:\"Slide-In | CTA | Black Friday 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-1-Small.jpg\";s:12:\"tmpl_created\";i:1647856357;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/slide-in-cta-black-friday-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:88;a:19:{s:4:\"tmpl\";i:1372;s:2:\"id\";i:23341;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-3-Small.jpg\";s:12:\"tmpl_created\";i:1647856493;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:89;a:19:{s:4:\"tmpl\";i:1373;s:2:\"id\";i:23347;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-2-Small.jpg\";s:12:\"tmpl_created\";i:1647856891;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:90;a:19:{s:4:\"tmpl\";i:1374;s:2:\"id\";i:23354;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 4\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-4-Small.jpg\";s:12:\"tmpl_created\";i:1647856996;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:91;a:19:{s:4:\"tmpl\";i:1375;s:2:\"id\";i:23394;s:5:\"title\";s:27:\"Classic | CTA | Halloween 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-3-Small.jpg\";s:12:\"tmpl_created\";i:1647857351;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-halloween-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:31:\"[\"cta\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:92;a:19:{s:4:\"tmpl\";i:1376;s:2:\"id\";i:23401;s:5:\"title\";s:33:\"Slide-In | Discount | Halloween 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-2-Small.jpg\";s:12:\"tmpl_created\";i:1647857567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-halloween-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:36:\"[\"Discount\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:93;a:19:{s:4:\"tmpl\";i:1377;s:2:\"id\";i:23407;s:5:\"title\";s:33:\"Slide-In | Discount | Halloween 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-1-Small.jpg\";s:12:\"tmpl_created\";i:1647857814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-halloween-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:36:\"[\"Discount\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:94;a:19:{s:4:\"tmpl\";i:1378;s:2:\"id\";i:23416;s:5:\"title\";s:31:\"Fly-In | Discount | Halloween 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-5-Small.jpg\";s:12:\"tmpl_created\";i:1647858024;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-discount-halloween-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:44:\"[\"Discount\",\"Ecommerce\",\"Halloween\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:95;a:19:{s:4:\"tmpl\";i:1379;s:2:\"id\";i:23422;s:5:\"title\";s:36:\"Classic | Subscription | Halloween 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-4-Small.jpg\";s:12:\"tmpl_created\";i:1647858246;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-halloween-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:48:\"[\"Discount\",\"Ecommerce\",\"Halloween\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:96;a:19:{s:4:\"tmpl\";i:1380;s:2:\"id\";i:23471;s:5:\"title\";s:28:\"Slide-In | CTA | Christmas 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-2-Small.jpg\";s:12:\"tmpl_created\";i:1647859193;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-cta-christmas-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Christmas\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:97;a:19:{s:4:\"tmpl\";i:1381;s:2:\"id\";i:23477;s:5:\"title\";s:28:\"Slide-In | CTA | Christmas 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-4-Small.jpg\";s:12:\"tmpl_created\";i:1647859838;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-cta-christmas-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Christmas\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:98;a:19:{s:4:\"tmpl\";i:1382;s:2:\"id\";i:23483;s:5:\"title\";s:26:\"Fly-In | CTA | Christmas 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-1-Small.jpg\";s:12:\"tmpl_created\";i:1647860157;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/fly-in-cta-christmas-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Christmas\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:99;a:19:{s:4:\"tmpl\";i:1383;s:2:\"id\";i:23489;s:5:\"title\";s:33:\"Slide-In | Discount | Christmas 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-5-Small.jpg\";s:12:\"tmpl_created\";i:1647860302;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-christmas-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:31:\"[\"Christmas\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:100;a:19:{s:4:\"tmpl\";i:1384;s:2:\"id\";i:23496;s:5:\"title\";s:32:\"Classic | Discount | Christmas 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-3-Small.jpg\";s:12:\"tmpl_created\";i:1647860454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-discount-christmas-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Christmas\",\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:101;a:19:{s:4:\"tmpl\";i:1385;s:2:\"id\";i:23523;s:5:\"title\";s:30:\"Classic | CTA | Valentines Day\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-2-Small.jpg\";s:12:\"tmpl_created\";i:1647860912;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-valentines-day/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"cta\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:102;a:19:{s:4:\"tmpl\";i:1386;s:2:\"id\";i:23529;s:5:\"title\";s:39:\"Hello Bar | Discount | Valentines Day 2\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-1-Small.jpg\";s:12:\"tmpl_created\";i:1647861064;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-discount-valentines-day-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:30:\"[\"Discount\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:103;a:19:{s:4:\"tmpl\";i:1387;s:2:\"id\";i:23536;s:5:\"title\";s:32:\"Classic | CTA | Valentines Day 3\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-3-Small.jpg\";s:12:\"tmpl_created\";i:1647861536;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-cta-valentines-day-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"cta\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:104;a:19:{s:4:\"tmpl\";i:1388;s:2:\"id\";i:23586;s:5:\"title\";s:51:\"Fly-In | Subscribe | Health &#038; Wellness Company\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/35-Subscribe-Health-Wellness-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647862008;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscribe-health-wellness-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:24:\"[\"Business\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:105;a:19:{s:4:\"tmpl\";i:1389;s:2:\"id\";i:23592;s:5:\"title\";s:34:\"Classic | Subscribe | Tech Company\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/36-Subscribe-Tech-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647866706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-subscribe-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:106;a:19:{s:4:\"tmpl\";i:1390;s:2:\"id\";i:23598;s:5:\"title\";s:36:\"Classic | Contact Us | Fight Classes\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/37-Contact-Us-Fight-Classes-Small.jpg\";s:12:\"tmpl_created\";i:1647866869;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-contact-us-fight-classes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:107;a:19:{s:4:\"tmpl\";i:1391;s:2:\"id\";i:23611;s:5:\"title\";s:31:\"Classic | CTA | Mochi Shop Sale\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2022/03/39-Click-Through-Mochi-Shop-Sale-Small.jpg\";s:12:\"tmpl_created\";i:1647867750;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-cta-mochi-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"cta\",\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:108;a:19:{s:4:\"tmpl\";i:1392;s:2:\"id\";i:23618;s:5:\"title\";s:28:\"Classic | CTA | Fashion Shop\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2022/03/40-Click-Through-Fashion-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1647868251;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-cta-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:109;a:19:{s:4:\"tmpl\";i:1393;s:2:\"id\";i:23624;s:5:\"title\";s:29:\"Fly-In | Login | Tech Company\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/41-Login-Tech-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647868704;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/fly-in-login-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:9:\"[\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:110;a:19:{s:4:\"tmpl\";i:1394;s:2:\"id\";i:23630;s:5:\"title\";s:36:\"Fly-In | Verification | Liquor Store\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/42-Verification-Liquor-Store-Small.jpg\";s:12:\"tmpl_created\";i:1647870308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-verification-liquor-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:16:\"[\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:111;a:19:{s:4:\"tmpl\";i:1395;s:2:\"id\";i:23636;s:5:\"title\";s:39:\"Hello Bar | Subscribe | Online Magazine\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/44-Subscribe-Online-Magazine-Small.jpg\";s:12:\"tmpl_created\";i:1647870465;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-subscribe-online-magazine/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:20:\"[\"Blog\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:112;a:19:{s:4:\"tmpl\";i:1396;s:2:\"id\";i:23642;s:5:\"title\";s:27:\"Fly-In | Login | Health Spa\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/43-Login-Health-Spa-Small.jpg\";s:12:\"tmpl_created\";i:1647872427;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/fly-in-login-health-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Login\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:113;a:19:{s:4:\"tmpl\";i:1397;s:2:\"id\";i:23648;s:5:\"title\";s:33:\"Fly-In | Verification | Wine Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/45-Verification-Wine-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1647872627;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/fly-in-verification-wine-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:16:\"[\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:114;a:19:{s:4:\"tmpl\";i:1421;s:2:\"id\";i:24235;s:5:\"title\";s:24:\"Ladydog Club &#8211; NFT\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/05/Ladydog_Club.jpg\";s:12:\"tmpl_created\";i:1651525072;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/ladydog-club-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:115;a:19:{s:4:\"tmpl\";i:1422;s:2:\"id\";i:24166;s:5:\"title\";s:15:\"Dot &#8211; NFT\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2022/05/Dot-250_280.jpg\";s:12:\"tmpl_created\";i:1651525117;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/lp/dot-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:116;a:19:{s:4:\"tmpl\";i:1423;s:2:\"id\";i:24191;s:5:\"title\";s:28:\"Cosmic Neighbors &#8211; NFT\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Cosmic_Neighbors-250_280.jpg\";s:12:\"tmpl_created\";i:1651525124;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/cosmic-neighbors-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:117;a:19:{s:4:\"tmpl\";i:1424;s:2:\"id\";i:24255;s:5:\"title\";s:30:\"Happy Food Friends &#8211; NFT\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/05/Featured_Image.jpg\";s:12:\"tmpl_created\";i:1651525475;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/happy-food-friends-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:118;a:19:{s:4:\"tmpl\";i:1443;s:2:\"id\";i:24599;s:5:\"title\";s:27:\"Wireframe &#8211; Courses 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Courses-1.jpg\";s:12:\"tmpl_created\";i:1653989626;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/wireframe-courses-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:180:\"[\"About\",\"Academy\",\"Booking\",\"Business\",\"Course Online\",\"Features\",\"Footer\",\"Landing Pages\",\"Online Service\",\"Professional\",\"School\",\"Services\",\"Subscribe\",\"Teacher\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:119;a:19:{s:4:\"tmpl\";i:1444;s:2:\"id\";i:24614;s:5:\"title\";s:28:\"Wireframe &#8211; Services 1\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1-2.jpg\";s:12:\"tmpl_created\";i:1653990084;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:139:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Form\",\"Header\",\"Landing Pages\",\"Online Service\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:120;a:19:{s:4:\"tmpl\";i:1445;s:2:\"id\";i:24629;s:5:\"title\";s:28:\"Wireframe &#8211; Services 2\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-2-2.jpg\";s:12:\"tmpl_created\";i:1653990132;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:123:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Form\",\"Gallery\",\"Landing Pages\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:121;a:19:{s:4:\"tmpl\";i:1446;s:2:\"id\";i:24644;s:5:\"title\";s:27:\"Wireframe &#8211; Webinar 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Webinar-1.jpg\";s:12:\"tmpl_created\";i:1653990164;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/wireframe-webinar-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:177:\"[\"About\",\"Academy\",\"Booking\",\"Conference\",\"Course Online\",\"Education\",\"Features\",\"Footer\",\"Form\",\"Landing Pages\",\"Online Event\",\"Online Service\",\"Subscribe\",\"Virtual\",\"Webinar\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:122;a:19:{s:4:\"tmpl\";i:1447;s:2:\"id\";i:24655;s:5:\"title\";s:28:\"Wireframe &#8211; Services 3\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-3-2.jpg\";s:12:\"tmpl_created\";i:1653990198;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:143:\"[\"About\",\"Agency\",\"Business\",\"Contact\",\"Footer\",\"Form\",\"Gallery\",\"Landing Pages\",\"Portfolio\",\"Professional\",\"Project\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:123;a:19:{s:4:\"tmpl\";i:1448;s:2:\"id\";i:24677;s:5:\"title\";s:28:\"Wireframe &#8211; Services 4\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-4.jpg\";s:12:\"tmpl_created\";i:1653990233;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:102:\"[\"About\",\"Business\",\"Contact\",\"Footer\",\"Form\",\"Landing Pages\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:124;a:19:{s:4:\"tmpl\";i:1449;s:2:\"id\";i:24687;s:5:\"title\";s:28:\"Wireframe &#8211; Products 1\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Products-1.jpg\";s:12:\"tmpl_created\";i:1653990273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-products-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:128:\"[\"About\",\"Booking\",\"Business\",\"Clients\",\"Ecommerce\",\"Features\",\"Footer\",\"Landing Pages\",\"Products\",\"Sales\",\"Shop\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:125;a:19:{s:4:\"tmpl\";i:1450;s:2:\"id\";i:24706;s:5:\"title\";s:28:\"Wireframe &#8211; Services 5\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-5.jpg\";s:12:\"tmpl_created\";i:1653990322;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:149:\"[\"About\",\"Booking\",\"Consulting\",\"Contact\",\"Doctor\",\"Footer\",\"Form\",\"Header\",\"Landing Pages\",\"Online Service\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:126;a:19:{s:4:\"tmpl\";i:1451;s:2:\"id\";i:23604;s:5:\"title\";s:38:\"Classic | Subscribe | Nail Polish Shop\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2022/03/38-Subscribe-Nail-Polish-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1660205114;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-subscribe-nail-polish-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:20:\"[\"Blog\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:127;a:19:{s:4:\"tmpl\";i:1452;s:2:\"id\";i:23047;s:5:\"title\";s:46:\"Fly-In | Contact | Health &#038; Fitness eBook\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small.jpg\";s:12:\"tmpl_created\";i:1660205149;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/fly-in-contact-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Contact\",\"Ebook\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:128;a:19:{s:4:\"tmpl\";i:1199;s:2:\"id\";i:18839;s:5:\"title\";s:27:\"Hello Bar | CTA | eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/05/350x250.png\";s:12:\"tmpl_created\";i:1621870603;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/hello-bar-cta-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:41:\"[\"Ecommerce\",\"Online Shop\",\"Sale\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:129;a:19:{s:4:\"tmpl\";i:1247;s:2:\"id\";i:21907;s:5:\"title\";s:50:\"Fly-In | Team Details  | Electronic Music Festival\";s:9:\"thumbnail\";s:104:\"https://library.elementor.com/wp-content/uploads/2022/03/Kit-8-electronic-music-festival-CTA-image-1.jpg\";s:12:\"tmpl_created\";i:1646660881;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/popups/fly-in-team-details-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:130;a:19:{s:4:\"tmpl\";i:1253;s:2:\"id\";i:22162;s:5:\"title\";s:46:\"Full Screen | Menu | Electronic Music Festival\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/8-music-festival-Team-Details.jpg\";s:12:\"tmpl_created\";i:1647272934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:154:\"https://library.elementor.com/popups/full-screen-menu-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:131;a:19:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:22172;s:5:\"title\";s:45:\"Classic | Discount | Health &#038; Beauty Spa\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/health-beauty-spa-small.jpg\";s:12:\"tmpl_created\";i:1647273547;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/classic-discount-popup-health-beauty-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:36:\"[\"Hair\",\"Health\",\"Sales\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:132;a:19:{s:4:\"tmpl\";i:1255;s:2:\"id\";i:22183;s:5:\"title\";s:44:\"Hello Bar | CTA | Environmental Organization\";s:9:\"thumbnail\";s:104:\"https://library.elementor.com/wp-content/uploads/2022/03/11-Environmental-Organization-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647274384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:152:\"https://library.elementor.com/popups/hello-bar-cta-popup-environmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:133;a:19:{s:4:\"tmpl\";i:1256;s:2:\"id\";i:22195;s:5:\"title\";s:39:\"Classic | Discount | Italian Restaurant\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/restaurant-small.jpg\";s:12:\"tmpl_created\";i:1647329432;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:147:\"https://library.elementor.com/popups/classic-discount-popup-italian-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Restaurant\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:134;a:19:{s:4:\"tmpl\";i:1257;s:2:\"id\";i:22210;s:5:\"title\";s:45:\"Bottom Bar | Discount | Technology Conference\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/tech-conference-small.jpg\";s:12:\"tmpl_created\";i:1647330423;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/bottom-bar-discount-popup-technology-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:38:\"[\"Conference\",\"Sales\",\"Save the Date\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:135;a:19:{s:4:\"tmpl\";i:1258;s:2:\"id\";i:22221;s:5:\"title\";s:32:\"Hello Bar | Menu | Tattoo Studio\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small-1.jpg\";s:12:\"tmpl_created\";i:1647330705;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/hello-bar-menu-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:17:\"[\"Header\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:136;a:19:{s:4:\"tmpl\";i:1259;s:2:\"id\";i:22231;s:5:\"title\";s:37:\"Full Screen | Booking | Tattoo Studio\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small.jpg\";s:12:\"tmpl_created\";i:1647331823;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-booking-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:137;a:19:{s:4:\"tmpl\";i:1260;s:2:\"id\";i:22251;s:5:\"title\";s:34:\"Classic | Discount | Dental Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/dental-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647332171;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-popup-dental-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Health\",\"Marketing\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:138;a:19:{s:4:\"tmpl\";i:1261;s:2:\"id\";i:22261;s:5:\"title\";s:34:\"Slide-In | Contact | Makeup Artist\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/20-Makeup-Artist-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647333946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/slide-in-contact-popup-makeup-artist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:139;a:19:{s:4:\"tmpl\";i:1262;s:2:\"id\";i:22271;s:5:\"title\";s:24:\"Fly-In | CTA | Headphone\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/headphones-1-small.jpg\";s:12:\"tmpl_created\";i:1647334784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-cta-popup-headphone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:41:\"[\"cta\",\"Ecommerce\",\"Marketing\",\"Product\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:140;a:19:{s:4:\"tmpl\";i:1263;s:2:\"id\";i:22277;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/online-course-2.jpg\";s:12:\"tmpl_created\";i:1647337110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-popup-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Course Online\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:141;a:19:{s:4:\"tmpl\";i:1264;s:2:\"id\";i:22283;s:5:\"title\";s:40:\"Bottom Bar | Contact | Virtual Assistant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistant-3.jpg\";s:12:\"tmpl_created\";i:1647337517;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-contact-popup-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:142;a:19:{s:4:\"tmpl\";i:1265;s:2:\"id\";i:22289;s:5:\"title\";s:32:\"Fly-In | Contact | Private Tutor\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-4.jpg\";s:12:\"tmpl_created\";i:1647337676;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-contact-popup-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:27:\"[\"Contact\",\"Course Online\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:143;a:19:{s:4:\"tmpl\";i:1266;s:2:\"id\";i:22295;s:5:\"title\";s:31:\"Classic |  Login | Login Travel\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/login-travel-6.jpg\";s:12:\"tmpl_created\";i:1647339467;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-login-popup-login-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:9:\"[\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:144;a:19:{s:4:\"tmpl\";i:1267;s:2:\"id\";i:22301;s:5:\"title\";s:36:\"Full Screen | Login | Login Business\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/login-business-7.jpg\";s:12:\"tmpl_created\";i:1647339782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/full-screen-login-popup-login-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:16:\"[\"Login\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:145;a:19:{s:4:\"tmpl\";i:1268;s:2:\"id\";i:22307;s:5:\"title\";s:28:\"Classic | Login | Login Blog\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/login-blog-8.jpg\";s:12:\"tmpl_created\";i:1647339986;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-login-popup-login-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:146;a:19:{s:4:\"tmpl\";i:1269;s:2:\"id\";i:22313;s:5:\"title\";s:31:\"Classic | Login | Login Fashion\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/login-fashion-9.jpg\";s:12:\"tmpl_created\";i:1647340204;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-login-popup-login-fashion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Fashion\",\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:147;a:19:{s:4:\"tmpl\";i:1270;s:2:\"id\";i:22319;s:5:\"title\";s:40:\"Classic |  Login | Login Design Platform\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/03/login-design-platform-10.jpg\";s:12:\"tmpl_created\";i:1647340531;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:147:\"https://library.elementor.com/popups/classic-login-popup-login-design-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"Design\",\"Login\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:148;a:19:{s:4:\"tmpl\";i:1271;s:2:\"id\";i:22325;s:5:\"title\";s:36:\"Fly-In | Contact | Digital Marketing\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-marketing-11.jpg\";s:12:\"tmpl_created\";i:1647340770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/fly-in-contact-popup-digital-marketing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:51:\"[\"Business\",\"Contact\",\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:149;a:19:{s:4:\"tmpl\";i:1272;s:2:\"id\";i:22331;s:5:\"title\";s:36:\"Fly-In | CTA | Dog Cat Food Delivery\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/dog-cat-food-delivery-5.jpg\";s:12:\"tmpl_created\";i:1647341069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/fly-in-cta-popup-dog-cat-food-delivery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Delivery Service\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:150;a:19:{s:4:\"tmpl\";i:1273;s:2:\"id\";i:22337;s:5:\"title\";s:37:\"Full Screen | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-12.jpg\";s:12:\"tmpl_created\";i:1647341370;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-contact-popup-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:151;a:19:{s:4:\"tmpl\";i:1274;s:2:\"id\";i:22343;s:5:\"title\";s:44:\"Classic | Contact | Support Product Platform\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2022/03/support-13.jpg\";s:12:\"tmpl_created\";i:1647341972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/classic-contact-support-product-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Contact\",\"Support\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:152;a:19:{s:4:\"tmpl\";i:1275;s:2:\"id\";i:22371;s:5:\"title\";s:38:\"Full Screen | Contact | Small Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/small-business-14.jpg\";s:12:\"tmpl_created\";i:1647342508;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-contact-small-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:40:\"[\"Business\",\"Contact\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:153;a:19:{s:4:\"tmpl\";i:1276;s:2:\"id\";i:22377;s:5:\"title\";s:31:\"Classic | Contact | Online Shop\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/online-shop-15.jpg\";s:12:\"tmpl_created\";i:1647352786;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-contact-online-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:154;a:19:{s:4:\"tmpl\";i:1277;s:2:\"id\";i:22383;s:5:\"title\";s:40:\"Classic | Booking | Children Optometrist\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/children-optometrist-16.jpg\";s:12:\"tmpl_created\";i:1647352963;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-booking-children-optometrist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:53:\"[\"Booking\",\"Business\",\"Contact\",\"Education\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:155;a:19:{s:4:\"tmpl\";i:1278;s:2:\"id\";i:22389;s:5:\"title\";s:28:\"Fly-In | Contact | Open Week\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2022/03/open-week17.jpg\";s:12:\"tmpl_created\";i:1647353281;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-open-week/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:34:\"[\"Business\",\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:156;a:19:{s:4:\"tmpl\";i:1279;s:2:\"id\";i:22397;s:5:\"title\";s:43:\"Full Screen | CTA | Plant Pots Online Store\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/plant-pots-online-store-18.jpg\";s:12:\"tmpl_created\";i:1647353429;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-cta-plant-pots-online-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:33:\"[\"Ecommerce\",\"Marketing\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:157;a:19:{s:4:\"tmpl\";i:1054;s:2:\"id\";i:15414;s:5:\"title\";s:32:\"Classic | Contact | Dance Studio\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/PopUp.jpg\";s:12:\"tmpl_created\";i:1603180596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-contact-dance-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:762;s:11:\"trend_index\";i:650;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:158;a:19:{s:4:\"tmpl\";i:1398;s:2:\"id\";i:23687;s:5:\"title\";s:32:\"Pizza Promotion &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/48-Pizza-Promotion.jpg\";s:12:\"tmpl_created\";i:1649670575;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/pizza-promotion-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:92:\"[\"Business\",\"Cooking\",\"Delivery\",\"Discount\",\"Fast Food\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:159;a:19:{s:4:\"tmpl\";i:1400;s:2:\"id\";i:23751;s:5:\"title\";s:33:\"Baby Sleep Webinar &#8211; Events\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/63-Baby-Sleep-Webinar.jpg\";s:12:\"tmpl_created\";i:1649676065;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/baby-sleep-webinar-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:227:\"[\"Baby\",\"Booking\",\"Business\",\"Children\",\"Course Online\",\"Education\",\"Events\",\"Health\",\"Landing Pages\",\"Life Coach\",\"Lifestyle\",\"Online Event\",\"Online Service\",\"Parenting\",\"Professional\",\"Remote\",\"Services\",\"Training\",\"Webinar\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:160;a:19:{s:4:\"tmpl\";i:1401;s:2:\"id\";i:23776;s:5:\"title\";s:34:\"Ski Hotel Promotion &#8211; Travel\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/04/64-Ski-Hotel-Promotion.jpg\";s:12:\"tmpl_created\";i:1649691720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/ski-hotel-promotion-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Travel\";s:4:\"tags\";s:118:\"[\"Accommodation\",\"Booking\",\"Discount. Landing Pages\",\"Lifestyle\",\"Luxury\",\"Services\",\"Spa\",\"Travel\",\"Trip\",\"Vacation\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:161;a:19:{s:4:\"tmpl\";i:1402;s:2:\"id\";i:23804;s:5:\"title\";s:30:\"Cake Delivery &#8211; Business\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/04/67-Cake-Delivery.jpg\";s:12:\"tmpl_created\";i:1649692909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/cake-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:101:\"[\"Bakery\",\"Business\",\"Cake\",\"Cooking\",\"Delivery\",\"Discount\",\"Food\",\"Landing Pages\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:162;a:19:{s:4:\"tmpl\";i:1403;s:2:\"id\";i:23832;s:5:\"title\";s:32:\"Furniture Store &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/87-Furniture-Store.jpg\";s:12:\"tmpl_created\";i:1649694812;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/furniture-store-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:232:\"[\"Architecture\",\"Art\",\"Business\",\"Construction\",\"Coupon\",\"Creative\",\"Decor\",\"Designer\",\"Discount\",\"Fashion\",\"Furniture Design\",\"Home\",\"House\",\"Interior Design\",\"Landing Pages\",\"Lifestyle\",\"Products\",\"Professional\",\"Services\",\"Shop\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:163;a:19:{s:4:\"tmpl\";i:1404;s:2:\"id\";i:23746;s:5:\"title\";s:22:\"Nails &#8211; Business\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2022/04/62-Nails-1.jpg\";s:12:\"tmpl_created\";i:1649704635;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/nails-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:173:\"[\"Art\",\"Beauty\",\"Business\",\"Colorful\",\"Cosmetics\",\"Creative\",\"Design\",\"Discount\",\"Fashion\",\"Girly\",\"Landing Pages\",\"Lifestyle\",\"Manicure\",\"Modern\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:164;a:19:{s:4:\"tmpl\";i:1405;s:2:\"id\";i:23846;s:5:\"title\";s:29:\"Music Festival &#8211; Events\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/04/88-Music-Festival.jpg\";s:12:\"tmpl_created\";i:1649707763;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/music-festival-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:128:\"[\"Author\",\"Booking\",\"Business\",\"Creative\",\"Discount\",\"Events\",\"Landing Pages\",\"Music\",\"Online\",\"Online Event\",\"Party\",\"Virtual\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:165;a:19:{s:4:\"tmpl\";i:1406;s:2:\"id\";i:23872;s:5:\"title\";s:40:\"Fashion Styling Course &#8211; Education\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/89-Fashion-Styling-Course.jpg\";s:12:\"tmpl_created\";i:1649708569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/fashion-styling-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:173:\"[\"Aesthetic\",\"Art\",\"Beauty\",\"Business\",\"Course Online\",\"Creative\",\"Discount\",\"Education\",\"Fashion\",\"Landing Pages\",\"Lifestyle\",\"Online\",\"Online Service\",\"Stylist\",\"Virtual\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:166;a:19:{s:4:\"tmpl\";i:1407;s:2:\"id\";i:23897;s:5:\"title\";s:33:\"Bags Online Shop &#8211; Business\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/04/90-Bags-Online-Shop.jpg\";s:12:\"tmpl_created\";i:1649709513;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/bags-online-shop-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:170:\"[\"Art\",\"Bag\",\"Business\",\"Creative\",\"Design\",\"Discount\",\"Fashion\",\"Landing Pages\",\"Lifestyle\",\"Luxury\",\"Modern\",\"Online\",\"Online Shop\",\"Products\",\"Sales\",\"Shop\",\"Stylist\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:167;a:19:{s:4:\"tmpl\";i:1408;s:2:\"id\";i:23932;s:5:\"title\";s:32:\"Cooking Academy &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/91-Cooking-Academy.jpg\";s:12:\"tmpl_created\";i:1649710216;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/cooking-academy-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:145:\"[\"Academy\",\"Booking\",\"Business\",\"Chef\",\"Cooking\",\"Education\",\"Food\",\"Free Trial\",\"Landing Pages\",\"Professional\",\"School\",\"Teacher\",\"Testimonial\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:168;a:19:{s:4:\"tmpl\";i:1409;s:2:\"id\";i:23970;s:5:\"title\";s:45:\"Ophthalmology Medical Clinic &#8211; Business\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/04/92-Ophthalmology-Medical-Clinic.jpg\";s:12:\"tmpl_created\";i:1649711096;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/ophthalmology-medical-clinic-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:165:\"[\"About\",\"Business\",\"Care\",\"Consulting\",\"Eye\",\"Free Trial\",\"Glasses\",\"Health\",\"Landing Pages\",\"Lifestyle\",\"Medical\",\"Modern\",\"Optometrist\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:169;a:19:{s:4:\"tmpl\";i:1425;s:2:\"id\";i:24331;s:5:\"title\";s:24:\"Wireframe &#8211; Home 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-1.jpg\";s:12:\"tmpl_created\";i:1653988363;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:170;a:19:{s:4:\"tmpl\";i:1218;s:2:\"id\";i:20792;s:5:\"title\";s:26:\"Luxury Car &#8211; Product\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/11/250x280-1.jpg\";s:12:\"tmpl_created\";i:1636903770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/lp/luxury-car-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:54:\"[\"car\",\"Ecommerce\",\"Landing Pages\",\"Luxury\",\"Product\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:171;a:19:{s:4:\"tmpl\";i:1428;s:2:\"id\";i:24398;s:5:\"title\";s:25:\"Wireframe &#8211; About 1\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-1.jpg\";s:12:\"tmpl_created\";i:1653988534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:83:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Professional\",\"Services\",\"Team\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:172;a:19:{s:4:\"tmpl\";i:991;s:2:\"id\";i:13413;s:5:\"title\";s:33:\"Classic | Contact | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Help.jpg\";s:12:\"tmpl_created\";i:1587474761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-contact-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:530;s:11:\"trend_index\";i:369;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:173;a:19:{s:4:\"tmpl\";i:1053;s:2:\"id\";i:15272;s:5:\"title\";s:32:\"Classic | Contact | Psychologist\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/PopUp.png\";s:12:\"tmpl_created\";i:1600170487;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-contact-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:578;s:11:\"trend_index\";i:312;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:174;a:19:{s:4:\"tmpl\";i:899;s:2:\"id\";i:11839;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Header_small.png\";s:12:\"tmpl_created\";i:1569430015;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"header\",\"portfolio\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:189;s:11:\"trend_index\";i:20;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:175;a:19:{s:4:\"tmpl\";i:1433;s:2:\"id\";i:24477;s:5:\"title\";s:27:\"Wireframe &#8211; Gallery 2\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Gallery-2.jpg\";s:12:\"tmpl_created\";i:1653988835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-gallery-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:82:\"[\"Business\",\"Contact\",\"Design\",\"Footer\",\"Gallery\",\"Header\",\"Portfolio\",\"Services\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:176;a:19:{s:4:\"tmpl\";i:1205;s:2:\"id\";i:20233;s:5:\"title\";s:32:\"Art Magazine &#8211; Coming Soon\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Art-Magazine-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633881371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/art-magazine-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:48:\"[\"Art\",\"Coming Soon\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:177;a:19:{s:4:\"tmpl\";i:1214;s:2:\"id\";i:20539;s:5:\"title\";s:31:\"Design Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/design-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:47:\"[\"Blog\",\"Coming Soon\",\"Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:178;a:19:{s:4:\"tmpl\";i:1224;s:2:\"id\";i:21013;s:5:\"title\";s:24:\"Restaurant &#8211; About\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/12/7-About-Restaurant.jpg\";s:12:\"tmpl_created\";i:1638795588;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/restaurant-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:36:\"[\"About\",\"Chef\",\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:179;a:19:{s:4:\"tmpl\";i:992;s:2:\"id\";i:13402;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/04/Popup-Course-Completed.jpg\";s:12:\"tmpl_created\";i:1587474772;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:619;s:11:\"trend_index\";i:582;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:180;a:19:{s:4:\"tmpl\";i:1206;s:2:\"id\";i:20254;s:5:\"title\";s:41:\"Digital Marketing Agency &#8211; Business\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Digital-Marketing-Agency-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633882427;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/lp/digital-marketing-agency-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:65:\"[\"Agency\",\"Business\",\"Digital Agency\",\"Landing Pages\",\"Services\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:181;a:19:{s:4:\"tmpl\";i:1235;s:2:\"id\";i:21281;s:5:\"title\";s:25:\"Law Firm &#8211; Services\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/12/16-Services-Law-firm.jpg\";s:12:\"tmpl_created\";i:1638819128;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/law-firm-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Consulting\",\"Law\",\"Law Firm\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:182;a:19:{s:4:\"tmpl\";i:1017;s:2:\"id\";i:14111;s:5:\"title\";s:36:\"Classic | Japanese restaurant | Sale\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1592300400;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-japanese-restaurant-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:717;s:11:\"trend_index\";i:697;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:183;a:19:{s:4:\"tmpl\";i:1213;s:2:\"id\";i:20509;s:5:\"title\";s:40:\"Dogs Adoption &#8211; Social Involvement\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/10/Dog-Adoption-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/dogs-adoption-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:49:\"[\"Adoption\",\"Involvement\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:184;a:19:{s:4:\"tmpl\";i:1233;s:2:\"id\";i:21205;s:5:\"title\";s:29:\"Photographer &#8211; Projects\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/25-Projects-Photographer.jpg\";s:12:\"tmpl_created\";i:1638818372;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/photographer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:43:\"[\"Black and white\",\"Photography\",\"Project\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:185;a:19:{s:4:\"tmpl\";i:993;s:2:\"id\";i:13422;s:5:\"title\";s:30:\"Classic | Menu | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1587474782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-menu-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:516;s:11:\"trend_index\";i:432;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:186;a:19:{s:4:\"tmpl\";i:925;s:2:\"id\";i:12540;s:5:\"title\";s:33:\"Classic | Menu | Travel and tours\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_Menu_s.png\";s:12:\"tmpl_created\";i:1575960267;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-menu-travel-and-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:690;s:11:\"trend_index\";i:714;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:187;a:19:{s:4:\"tmpl\";i:1208;s:2:\"id\";i:20361;s:5:\"title\";s:51:\"Exercise &#038; Fitness Equipment &#8211; eCommerce\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2021/10/Exercise-Fitness-Equipment-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633883766;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/lp/exercise-fitness-equipment-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:50:\"[\"Fitness\",\"Health\",\"Landing Pages\",\"Online Shop\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:188;a:19:{s:4:\"tmpl\";i:1239;s:2:\"id\";i:21373;s:5:\"title\";s:28:\"Photographer &#8211; Gallery\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/18-Gallery-Photographer.jpg\";s:12:\"tmpl_created\";i:1638821177;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/photographer-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Gallery\",\"Photography\",\"Portfolio\",\"Project\",\"Travel\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:189;a:19:{s:4:\"tmpl\";i:1426;s:2:\"id\";i:24348;s:5:\"title\";s:24:\"Wireframe &#8211; Home 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-2.jpg\";s:12:\"tmpl_created\";i:1653988444;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:190;a:19:{s:4:\"tmpl\";i:958;s:2:\"id\";i:13129;s:5:\"title\";s:28:\"Classic | Menu | Photography\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/PopUp_s.png\";s:12:\"tmpl_created\";i:1582092645;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-menu-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:646;s:11:\"trend_index\";i:521;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:191;a:19:{s:4:\"tmpl\";i:1427;s:2:\"id\";i:24366;s:5:\"title\";s:24:\"Wireframe &#8211; Home 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-3.jpg\";s:12:\"tmpl_created\";i:1653988491;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:192;a:19:{s:4:\"tmpl\";i:1207;s:2:\"id\";i:20299;s:5:\"title\";s:51:\"Interior Design Consultation &#8211; Online Service\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2021/10/Interior-Design-Consultation-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633882989;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/lp/interior-design-consultation-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:65:\"[\"Consulting\",\"Interior Design\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:193;a:19:{s:4:\"tmpl\";i:952;s:2:\"id\";i:12726;s:5:\"title\";s:52:\"Classic | Newsletter | Subscribe | Magazine and Blog\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_Newsletter_s.png\";s:12:\"tmpl_created\";i:1579061019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:152:\"https://library.elementor.com/popups/classic-newsletter-subscribe-magazine-and-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:357;s:11:\"trend_index\";i:281;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:194;a:19:{s:4:\"tmpl\";i:883;s:2:\"id\";i:11468;s:5:\"title\";s:20:\"Classic | Sale | Gym\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/08/PopUp_Small.png\";s:12:\"tmpl_created\";i:1567393182;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-sale-gym/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:696;s:11:\"trend_index\";i:740;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:195;a:19:{s:4:\"tmpl\";i:1216;s:2:\"id\";i:20623;s:5:\"title\";s:57:\"Luxurious Camping Accommodation For Events &#8211; Events\";s:9:\"thumbnail\";s:113:\"https://library.elementor.com/wp-content/uploads/2021/10/Luxurious-Camping-Accommodation-For-Events-250x280-2.jpg\";s:12:\"tmpl_created\";i:1634041681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:151:\"https://library.elementor.com/lp/luxurious-camping-accommodation-for-events-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:43:\"[\"Event\",\"Events\",\"Landing Pages\",\"Travel\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:196;a:19:{s:4:\"tmpl\";i:1219;s:2:\"id\";i:20886;s:5:\"title\";s:28:\"Online Training &#8211; Home\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/12/2-Home-Online-Training.jpg\";s:12:\"tmpl_created\";i:1638784769;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/online-training-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Fitness\",\"Online\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:197;a:19:{s:4:\"tmpl\";i:1065;s:2:\"id\";i:15570;s:5:\"title\";s:33:\"Classic | Subscribe | Travel Blog\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp.jpg\";s:12:\"tmpl_created\";i:1606215555;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-subscribe-travel-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:709;s:11:\"trend_index\";i:459;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:198;a:19:{s:4:\"tmpl\";i:1431;s:2:\"id\";i:24437;s:5:\"title\";s:25:\"Wireframe &#8211; About 4\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-4.jpg\";s:12:\"tmpl_created\";i:1653988733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:74:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:199;a:19:{s:4:\"tmpl\";i:1210;s:2:\"id\";i:20414;s:5:\"title\";s:45:\"Online English Courses &#8211; Online Service\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2021/10/Online-English-Courses-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633884482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/online-english-courses-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:50:\"[\"Course Online\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:200;a:19:{s:4:\"tmpl\";i:1132;s:2:\"id\";i:16553;s:5:\"title\";s:31:\"Fly-In | Contact | Beauty Salon\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/12/PopUp.jpg\";s:12:\"tmpl_created\";i:1608622602;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-contact-beauty-salon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:691;s:11:\"trend_index\";i:428;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:201;a:19:{s:4:\"tmpl\";i:1441;s:2:\"id\";i:24574;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 5\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-5.jpg\";s:12:\"tmpl_created\";i:1653989135;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:88:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Google Maps\",\"Header\",\"Professional\",\"Subscribe\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:202;a:19:{s:4:\"tmpl\";i:1217;s:2:\"id\";i:20333;s:5:\"title\";s:40:\"Plant Pots Online Shop &#8211; eCommerce\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2021/10/Plant-Pots-Online-Shop-250x280-2.jpg\";s:12:\"tmpl_created\";i:1634042184;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/plant-pots-online-shop-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:50:\"[\"Ecommerce\",\"Landing Pages\",\"Online Shop\",\"Shop\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:203;a:19:{s:4:\"tmpl\";i:1211;s:2:\"id\";i:20447;s:5:\"title\";s:33:\"Shared Workspace &#8211; Business\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Shared-Workspace.jpg\";s:12:\"tmpl_created\";i:1633884934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/shared-workspace-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:28:\"[\"Business\",\"Landing Pages\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:204;a:19:{s:4:\"tmpl\";i:1237;s:2:\"id\";i:21313;s:5:\"title\";s:34:\"Spa &#038; Beauty &#8211; Services\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/12/Spa-Beauty-Treatments-page-1.jpg\";s:12:\"tmpl_created\";i:1638819709;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/spa-beauty-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:55:\"[\"Beauty\",\"Hair\",\"Health\",\"Services\",\"Spa\",\"Treatment\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:205;a:19:{s:4:\"tmpl\";i:1004;s:2:\"id\";i:13538;s:5:\"title\";s:32:\"Fly-In | Newsletter | Barbershop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/05/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1589893364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-newsletter-barbershop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:710;s:11:\"trend_index\";i:667;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:206;a:19:{s:4:\"tmpl\";i:924;s:2:\"id\";i:12550;s:5:\"title\";s:32:\"Fly-in | Sale | Travel and Tours\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_s.png\";s:12:\"tmpl_created\";i:1575960263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/flyin-sale-travel-and-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:754;s:11:\"trend_index\";i:791;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:207;a:19:{s:4:\"tmpl\";i:1212;s:2:\"id\";i:20479;s:5:\"title\";s:49:\"Teeth Straightening &#8211; Health &#038; Fitness\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Teeth-Whitening.jpg\";s:12:\"tmpl_created\";i:1633886115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/teeth-straightening-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:46:\"[\"Business\",\"Dental\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:208;a:19:{s:4:\"tmpl\";i:1234;s:2:\"id\";i:21234;s:5:\"title\";s:34:\"Insurance Company &#8211; Services\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/12/15-Services-Insurance-Company.jpg\";s:12:\"tmpl_created\";i:1638818688;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/insurance-company-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"Faq\",\"Form\",\"Insurance\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:209;a:19:{s:4:\"tmpl\";i:1035;s:2:\"id\";i:15062;s:5:\"title\";s:35:\"Fly-In | Sign up | Flooring Company\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp.png\";s:12:\"tmpl_created\";i:1597739629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/fly-in-sign-up-flooring-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:625;s:11:\"trend_index\";i:309;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:210;a:19:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:20394;s:5:\"title\";s:30:\"Time Management &#8211; Events\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/10/Time-Management-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633884077;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/time-management-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:17:\"[\"Landing Pages\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:211;a:19:{s:4:\"tmpl\";i:1229;s:2:\"id\";i:21118;s:5:\"title\";s:28:\"Contact &#8211; Plants Store\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/12-Contact-Plants-Store.jpg\";s:12:\"tmpl_created\";i:1638802472;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/contact-plants-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:40:\"[\"Contact\",\"Info\",\"Plant\",\"Testimonial\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:212;a:19:{s:4:\"tmpl\";i:893;s:2:\"id\";i:11822;s:5:\"title\";s:30:\"Full Screen | Menu | Portfolio\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/09/PopUp_small.png\";s:12:\"tmpl_created\";i:1569429896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/full-screen-menu-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:654;s:11:\"trend_index\";i:626;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:213;a:19:{s:4:\"tmpl\";i:1203;s:2:\"id\";i:18591;s:5:\"title\";s:28:\"Coffee Sale &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/04/250x280-7.png\";s:12:\"tmpl_created\";i:1633877319;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/coffee-sale-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:33:\"[\"Coffee\",\"Landing Pages\",\"Sale\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:214;a:19:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:21184;s:5:\"title\";s:28:\"Dental Care &#8211; Services\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/14-Services-Dental-Care.jpg\";s:12:\"tmpl_created\";i:1638807148;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/dental-care-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:45:\"[\"Dental\",\"Medical\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:215;a:19:{s:4:\"tmpl\";i:1064;s:2:\"id\";i:15580;s:5:\"title\";s:31:\"Fullscreen | Menu | Travel Blog\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1606215358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fullscreen-menu-travel-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:673;s:11:\"trend_index\";i:348;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:216;a:19:{s:4:\"tmpl\";i:1133;s:2:\"id\";i:16645;s:5:\"title\";s:28:\"Headphones &#8211; eCommerce\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_headphones.png\";s:12:\"tmpl_created\";i:1609944115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/commerce-headphones/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:39:\"[\"Ecommerce\",\"Landing Pages\",\"Product\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:633;s:11:\"trend_index\";i:87;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:217;a:19:{s:4:\"tmpl\";i:1442;s:2:\"id\";i:24584;s:5:\"title\";s:27:\"Wireframe &#8211; Pricing 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Pricing-1.jpg\";s:12:\"tmpl_created\";i:1653989152;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-pricing-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:146:\"[\"Booking\",\"Business\",\"Clients\",\"Contact\",\"Faq\",\"Features\",\"Footer\",\"Online Service\",\"Pricing\",\"Products\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:218;a:19:{s:4:\"tmpl\";i:1138;s:2:\"id\";i:16762;s:5:\"title\";s:25:\"Conference &#8211; Events\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Conference.png\";s:12:\"tmpl_created\";i:1610455119;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/conference-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:60:\"[\"Conference\",\"Convention\",\"Event\",\"Events\",\"Landing Pages\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:705;s:11:\"trend_index\";i:216;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:219;a:19:{s:4:\"tmpl\";i:1438;s:2:\"id\";i:24539;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 2\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-2.jpg\";s:12:\"tmpl_created\";i:1653989019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:69:\"[\"Business\",\"Contact\",\"Footer\",\"Google Maps\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:220;a:19:{s:4:\"tmpl\";i:981;s:2:\"id\";i:13281;s:5:\"title\";s:37:\"Hello Bar | Contact | Interior Design\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp.png\";s:12:\"tmpl_created\";i:1586148801;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/hello-bar-contact-interior-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:19:\"[\"Interior Design\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:763;s:11:\"trend_index\";i:679;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:221;a:19:{s:4:\"tmpl\";i:1052;s:2:\"id\";i:15259;s:5:\"title\";s:31:\"Hello Bar | Menu | Psychologist\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/09/Menu-PopUp.png\";s:12:\"tmpl_created\";i:1600170209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/hello-bar-menu-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:739;s:11:\"trend_index\";i:583;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:222;a:19:{s:4:\"tmpl\";i:1434;s:2:\"id\";i:24494;s:5:\"title\";s:28:\"Wireframe &#8211; Services 1\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1.jpg\";s:12:\"tmpl_created\";i:1653988874;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:53:\"[\"Business\",\"Faq\",\"Footer\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:223;a:19:{s:4:\"tmpl\";i:1194;s:2:\"id\";i:18701;s:5:\"title\";s:32:\"Digital Course &#8211; eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/04/250x280.jpg\";s:12:\"tmpl_created\";i:1618995134;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/digital-course-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:57:\"[\"Course Online\",\"Ecommerce\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:224;a:19:{s:4:\"tmpl\";i:1192;s:2:\"id\";i:18612;s:5:\"title\";s:34:\"Bag Product Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Bag-Product.jpeg\";s:12:\"tmpl_created\";i:1618395406;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/bag-product-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:61:\"[\"Bag\",\"Ecommerce\",\"Landing Pages\",\"Product\",\"Sale\",\"Travel\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:875;s:11:\"trend_index\";i:605;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:225;a:19:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:21083;s:5:\"title\";s:26:\"Conference &#8211; Contact\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/10-Contact-Conference.jpg\";s:12:\"tmpl_created\";i:1638799208;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/conference-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:44:\"[\"Conference\",\"Contact\",\"Form\",\"Info\",\"Map\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:226;a:19:{s:4:\"tmpl\";i:1193;s:2:\"id\";i:18644;s:5:\"title\";s:37:\"Camera Product Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/camera_sale_featured-img.jpg\";s:12:\"tmpl_created\";i:1618396388;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/lp/camera-product-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:59:\"[\"Camera\",\"Ecommerce\",\"Landing Pages\",\"Photography\",\"Sale\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:873;s:11:\"trend_index\";i:535;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:227;a:19:{s:4:\"tmpl\";i:951;s:2:\"id\";i:12736;s:5:\"title\";s:41:\"Slide In | Contact Us | Magazine and Blog\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_contact_s.png\";s:12:\"tmpl_created\";i:1579060978;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/slide-in-contact-us/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:734;s:11:\"trend_index\";i:686;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:228;a:19:{s:4:\"tmpl\";i:1222;s:2:\"id\";i:20960;s:5:\"title\";s:26:\"Travel Agency &#8211; Home\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/12/5-Home-Travel-Agency.jpg\";s:12:\"tmpl_created\";i:1638788432;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/travel-agency-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:53:\"[\"Adventures\",\"Experience\",\"Explore\",\"Travel\",\"Trip\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:229;a:19:{s:4:\"tmpl\";i:1196;s:2:\"id\";i:18815;s:5:\"title\";s:25:\"Car Wash &#8211; Business\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Car-Wash.png\";s:12:\"tmpl_created\";i:1621336431;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/car-wash-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:45:\"[\"Business\",\"car\",\"Discount\",\"Landing Pages\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:230;a:19:{s:4:\"tmpl\";i:1242;s:2:\"id\";i:21473;s:5:\"title\";s:40:\"Architecture Photography &#8211; Gallery\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2021/12/20-Gallery-Architecture-Photography.jpg\";s:12:\"tmpl_created\";i:1638822115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/architecture-photography-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:52:\"[\"Architecture\",\"Gallery\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:231;a:19:{s:4:\"tmpl\";i:1015;s:2:\"id\";i:14067;s:5:\"title\";s:37:\"Slide In | Japanese restaurant | Menu\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Menu-Pop-Up-Small.jpg\";s:12:\"tmpl_created\";i:1592290352;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/slide-in-japanese-restaurant-menu/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:650;s:11:\"trend_index\";i:565;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:232;a:19:{s:4:\"tmpl\";i:923;s:2:\"id\";i:12229;s:5:\"title\";s:33:\"Slide In | Law Firm | Information\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/11/popup.png\";s:12:\"tmpl_created\";i:1572847842;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-law-firm-information/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:547;s:11:\"trend_index\";i:413;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:233;a:19:{s:4:\"tmpl\";i:1198;s:2:\"id\";i:18824;s:5:\"title\";s:33:\"Design School &#8211; Coming Soon\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/05/250x280-1.png\";s:12:\"tmpl_created\";i:1621336756;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/design-school-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:49:\"[\"Coming Soon\",\"Design\",\"Landing Pages\",\"School\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:234;a:19:{s:4:\"tmpl\";i:1236;s:2:\"id\";i:21259;s:5:\"title\";s:28:\"3D Designer &#8211; Projects\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/24-Projects-3D-Designer.jpg\";s:12:\"tmpl_created\";i:1638819185;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/3d-designer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:69:\"[\"3D\",\"Creative Portfolio\",\"Design\",\"Designer\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:235;a:19:{s:4:\"tmpl\";i:1028;s:2:\"id\";i:14827;s:5:\"title\";s:39:\"Slide-In | Contact | Luxury Real Estate\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/07/PopUp.png\";s:12:\"tmpl_created\";i:1595323523;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/slide-in-contact-luxury-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:559;s:11:\"trend_index\";i:284;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:236;a:19:{s:4:\"tmpl\";i:1197;s:2:\"id\";i:18819;s:5:\"title\";s:27:\"Dog Walker &#8211; Business\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Dog-Walker.png\";s:12:\"tmpl_created\";i:1621336601;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/dog-walker-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:41:\"[\"Business\",\"Dog\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:237;a:19:{s:4:\"tmpl\";i:1238;s:2:\"id\";i:21349;s:5:\"title\";s:29:\"Architecture &#8211; Projects\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/23-Projects-Architecture.jpg\";s:12:\"tmpl_created\";i:1638820870;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/architecture-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:70:\"[\"Architecture\",\"Creative\",\"Creative Portfolio\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:238;a:19:{s:4:\"tmpl\";i:1034;s:2:\"id\";i:15075;s:5:\"title\";s:34:\"Slide-In | Menu | Flooring Company\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp-1.png\";s:12:\"tmpl_created\";i:1597739605;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/slide-in-menu-flooring-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:383;s:11:\"trend_index\";i:162;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:239;a:19:{s:4:\"tmpl\";i:1414;s:2:\"id\";i:24079;s:5:\"title\";s:32:\"Fashion Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Fashion-Shop.jpg\";s:12:\"tmpl_created\";i:1650988089;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/fashion-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:88:\"[\"Aesthetic\",\"Business\",\"Coming Soon\",\"Ecommerce\",\"Girly\",\"Lifestyle\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:240;a:19:{s:4:\"tmpl\";i:1195;s:2:\"id\";i:18761;s:5:\"title\";s:33:\"Fashion Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Fashion-Store.png\";s:12:\"tmpl_created\";i:1621336146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/fashion-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:56:\"[\"Coming Soon\",\"Fashion\",\"Landing Pages\",\"Shop\",\"store\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:241;a:19:{s:4:\"tmpl\";i:1153;s:2:\"id\";i:17060;s:5:\"title\";s:36:\"Private Tutor &#8211; Online Service\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Tutor-2.png\";s:12:\"tmpl_created\";i:1610631042;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/private-tutor-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:64:\"[\"Education\",\"Landing Pages\",\"Online Service\",\"Teacher\",\"Tutor\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:780;s:11:\"trend_index\";i:628;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:242;a:19:{s:4:\"tmpl\";i:1430;s:2:\"id\";i:24434;s:5:\"title\";s:25:\"Wireframe &#8211; About 3\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-3.jpg\";s:12:\"tmpl_created\";i:1653988697;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:76:\"[\"About\",\"Business\",\"Contact\",\"Faq\",\"Footer\",\"Header\",\"Professional\",\"Team\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:243;a:19:{s:4:\"tmpl\";i:1158;s:2:\"id\";i:17232;s:5:\"title\";s:33:\"Life Coach &#8211; Online Service\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Life-Coach.png\";s:12:\"tmpl_created\";i:1610902793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/life-coach-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:38:\"[\"Coach\",\"Landing Pages\",\"Life Coach\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:787;s:11:\"trend_index\";i:751;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:244;a:19:{s:4:\"tmpl\";i:1436;s:2:\"id\";i:24515;s:5:\"title\";s:28:\"Wireframe &#8211; Services 3\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-3.jpg\";s:12:\"tmpl_created\";i:1653988946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:66:\"[\"Business\",\"Contact\",\"Footer\",\"Header\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:245;a:19:{s:4:\"tmpl\";i:875;s:2:\"id\";i:11241;s:5:\"title\";s:36:\"Classic | Digital Agency | Marketing\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/PopUp_small.jpg\";s:12:\"tmpl_created\";i:1564643043;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-digital-agency-marketing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:362;s:11:\"trend_index\";i:315;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:246;a:19:{s:4:\"tmpl\";i:1146;s:2:\"id\";i:16932;s:5:\"title\";s:35:\"Finance Consulting &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/01/Finance-Consulting.png\";s:12:\"tmpl_created\";i:1610532170;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/lp/finance-consulting-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:80:\"[\"Advisor\",\"Business\",\"Consulting\",\"Finance\",\"Investment\",\"Landing Pages\",\"Tax\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:790;s:11:\"trend_index\";i:630;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:247;a:19:{s:4:\"tmpl\";i:1429;s:2:\"id\";i:24421;s:5:\"title\";s:25:\"Wireframe &#8211; About 2\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-2.jpg\";s:12:\"tmpl_created\";i:1653988579;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:87:\"[\"About\",\"Business\",\"Contact\",\"Faq\",\"Features\",\"Footer\",\"Header\",\"Professional\",\"Team\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:248;a:19:{s:4:\"tmpl\";i:674;s:2:\"id\";i:8505;s:5:\"title\";s:11:\"404 page 01\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/001.jpg\";s:12:\"tmpl_created\";i:1526415501;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:533;s:11:\"trend_index\";i:222;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:249;a:19:{s:4:\"tmpl\";i:1136;s:2:\"id\";i:16721;s:5:\"title\";s:35:\"Dental &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2021/01/Dental.jpg\";s:12:\"tmpl_created\";i:1610448567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/dental-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:44:\"[\"Dental\",\"Doctor\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:801;s:11:\"trend_index\";i:655;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:250;a:19:{s:4:\"tmpl\";i:1417;s:2:\"id\";i:24116;s:5:\"title\";s:32:\"Tech Company &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Tech-Company.jpg\";s:12:\"tmpl_created\";i:1650989265;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/tech-company-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:87:\"[\"Business\",\"Coding\",\"Coming Soon\",\"Computer\",\"Developer\",\"IT\",\"Services\",\"Technology\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:251;a:19:{s:4:\"tmpl\";i:675;s:2:\"id\";i:8511;s:5:\"title\";s:11:\"404 page 02\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/002.jpg\";s:12:\"tmpl_created\";i:1526415528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-02/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:347;s:11:\"trend_index\";i:155;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:252;a:19:{s:4:\"tmpl\";i:1161;s:2:\"id\";i:17269;s:5:\"title\";s:34:\"Electronics Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Electronic-Products.png\";s:12:\"tmpl_created\";i:1610903298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/electronics-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:29:\"[\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:800;s:11:\"trend_index\";i:556;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:253;a:19:{s:4:\"tmpl\";i:1220;s:2:\"id\";i:20908;s:5:\"title\";s:42:\"Packing &#038; Moving Company &#8211; Home\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/12/3-Home-Packing-Moving-Company.jpg\";s:12:\"tmpl_created\";i:1638786127;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/packing-moving-company-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Movers\",\"Moving\",\"Storge\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:254;a:19:{s:4:\"tmpl\";i:1152;s:2:\"id\";i:17032;s:5:\"title\";s:42:\"Donate Computer &#8211; Social Involvement\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Donation-2.png\";s:12:\"tmpl_created\";i:1610630585;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/donate-computer-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:67:\"[\"Computer\",\"Donate\",\"Donation\",\"Kids\",\"Landing Pages\",\"Nonprofit\"]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:718;s:11:\"trend_index\";i:278;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:255;a:19:{s:4:\"tmpl\";i:672;s:2:\"id\";i:8512;s:5:\"title\";s:11:\"404 page 03\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/003.jpg\";s:12:\"tmpl_created\";i:1526415449;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-03/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:450;s:11:\"trend_index\";i:375;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:256;a:19:{s:4:\"tmpl\";i:1245;s:2:\"id\";i:21546;s:5:\"title\";s:28:\"Interior Design &#8211; Home\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/1-Home-Interior-Design-1.jpg\";s:12:\"tmpl_created\";i:1639046269;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/interior-design-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:68:\"[\"Design\",\"Form\",\"Furniture Design\",\"Interior Design\",\"Testimonial\"]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:257;a:19:{s:4:\"tmpl\";i:1135;s:2:\"id\";i:16684;s:5:\"title\";s:34:\"SaaS HR Management &#8211; Product\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_hr.png\";s:12:\"tmpl_created\";i:1609945486;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/saas-hr-management-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:39:\"[\"HR\",\"Landing Pages\",\"Product\",\"SaaS\"]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:708;s:11:\"trend_index\";i:292;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:258;a:19:{s:4:\"tmpl\";i:671;s:2:\"id\";i:8513;s:5:\"title\";s:11:\"404 page 04\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/004.jpg\";s:12:\"tmpl_created\";i:1526415417;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-04/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:420;s:11:\"trend_index\";i:176;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:259;a:19:{s:4:\"tmpl\";i:1249;s:2:\"id\";i:22137;s:5:\"title\";s:31:\"Design Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1647177194;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/design-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:47:\"[\"Blog\",\"Coming Soon\",\"Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:260;a:19:{s:4:\"tmpl\";i:1134;s:2:\"id\";i:16660;s:5:\"title\";s:37:\"Medical center &#8211; Online service\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-medical-cosultation-250_280.png\";s:12:\"tmpl_created\";i:1609945122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/lp/medical-center-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:44:\"[\"Landing Pages\",\"Medical\",\"Online Service\"]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:750;s:11:\"trend_index\";i:332;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:261;a:19:{s:4:\"tmpl\";i:1226;s:2:\"id\";i:21069;s:5:\"title\";s:21:\"Hotel &#8211; Contact\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/12/9-Contact-Hotel.jpg\";s:12:\"tmpl_created\";i:1638798545;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/hotel-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:36:\"[\"Contact\",\"from\",\"Info\",\"Vacation\"]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:262;a:19:{s:4:\"tmpl\";i:1150;s:2:\"id\";i:17001;s:5:\"title\";s:36:\"Parental Counseling &#8211; Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2021/01/Parenting-Coach-2.png\";s:12:\"tmpl_created\";i:1610534999;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/parental-counseling-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:99:\"[\"Advisor\",\"Business\",\"Coach\",\"Counseling\",\"Landing Pages\",\"Online Service\",\"Parental\",\"Parenting\"]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:817;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:263;a:19:{s:4:\"tmpl\";i:1432;s:2:\"id\";i:24461;s:5:\"title\";s:27:\"Wireframe &#8211; Gallery 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Gallery-1.jpg\";s:12:\"tmpl_created\";i:1653988784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-gallery-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:82:\"[\"Business\",\"Contact\",\"Design\",\"Footer\",\"Gallery\",\"Header\",\"Portfolio\",\"Services\"]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:264;a:19:{s:4:\"tmpl\";i:676;s:2:\"id\";i:8514;s:5:\"title\";s:11:\"404 Page 05\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/005.jpg\";s:12:\"tmpl_created\";i:1526415558;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-05/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:419;s:11:\"trend_index\";i:220;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:265;a:19:{s:4:\"tmpl\";i:1137;s:2:\"id\";i:16742;s:5:\"title\";s:31:\"Online Course &#8211; Education\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Course.png\";s:12:\"tmpl_created\";i:1610454122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/online-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:55:\"[\"Academy\",\"Course Online\",\"Education\",\"Landing Pages\"]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:777;s:11:\"trend_index\";i:776;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:266;a:19:{s:4:\"tmpl\";i:668;s:2:\"id\";i:8523;s:5:\"title\";s:11:\"404 page 06\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/006.jpg\";s:12:\"tmpl_created\";i:1526415291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-06/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:298;s:11:\"trend_index\";i:268;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:267;a:19:{s:4:\"tmpl\";i:1440;s:2:\"id\";i:24563;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 4\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-4.jpg\";s:12:\"tmpl_created\";i:1653989095;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:84:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Gallery\",\"Header\",\"Professional\",\"Subscribe\"]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:268;a:19:{s:4:\"tmpl\";i:1162;s:2:\"id\";i:17284;s:5:\"title\";s:38:\"Dietitian &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/01/Dietitian.png\";s:12:\"tmpl_created\";i:1610903484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/dietitian-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:39:\"[\"Fitness\",\"Health\",\"landscape design\"]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:814;s:11:\"trend_index\";i:800;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:269;a:19:{s:4:\"tmpl\";i:1439;s:2:\"id\";i:24553;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 3\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-3.jpg\";s:12:\"tmpl_created\";i:1653989057;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:67:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Professional\",\"Testimonial\"]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:270;a:19:{s:4:\"tmpl\";i:1144;s:2:\"id\";i:16897;s:5:\"title\";s:30:\"Personal Chef &#8211; Business\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/Personal-Chef.png\";s:12:\"tmpl_created\";i:1610466247;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/personal-chef-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:53:\"[\"Business\",\"Chef\",\"Food\",\"Landing Pages\",\"Services\"]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:795;s:11:\"trend_index\";i:617;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:271;a:19:{s:4:\"tmpl\";i:1435;s:2:\"id\";i:24504;s:5:\"title\";s:28:\"Wireframe &#8211; Services 2\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-2.jpg\";s:12:\"tmpl_created\";i:1653988910;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:80:\"[\"Business\",\"Contact\",\"Footer\",\"Header\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:272;a:19:{s:4:\"tmpl\";i:669;s:2:\"id\";i:8524;s:5:\"title\";s:11:\"404 page 07\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/007.jpg\";s:12:\"tmpl_created\";i:1526415337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-07/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:303;s:11:\"trend_index\";i:171;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:273;a:19:{s:4:\"tmpl\";i:1147;s:2:\"id\";i:16946;s:5:\"title\";s:52:\"Online Full-Stack Developer Course &#8211; Education\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Full-Stack-Developer-Course.png\";s:12:\"tmpl_created\";i:1610532778;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/lp/online-full-stack-developer-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:76:\"[\"Academy\",\"Coding\",\"Course Online\",\"Developer\",\"Education\",\"Landing Pages\"]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:805;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:274;a:19:{s:4:\"tmpl\";i:1437;s:2:\"id\";i:24528;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-1.jpg\";s:12:\"tmpl_created\";i:1653988981;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:76:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Google Maps\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:275;a:19:{s:4:\"tmpl\";i:1143;s:2:\"id\";i:16868;s:5:\"title\";s:40:\"Virtual Assistant &#8211; Online Service\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2021/01/Virtual-Assistant-250x280-1.png\";s:12:\"tmpl_created\";i:1610465656;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/virtual-assistant-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:46:\"[\"Assistant\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:793;s:11:\"trend_index\";i:757;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:276;a:19:{s:4:\"tmpl\";i:673;s:2:\"id\";i:8526;s:5:\"title\";s:11:\"404 page 09\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/009.jpg\";s:12:\"tmpl_created\";i:1526415474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-09/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:477;s:11:\"trend_index\";i:285;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:277;a:19:{s:4:\"tmpl\";i:1228;s:2:\"id\";i:21104;s:5:\"title\";s:26:\"Restaurant &#8211; Contact\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/11-Contact-Restaurant.jpg\";s:12:\"tmpl_created\";i:1638800146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/restaurant-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:60:\"[\"Contact\",\"Food\",\"Form\",\"Google Maps\",\"Info\",\"Testimonial\"]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:278;a:19:{s:4:\"tmpl\";i:1140;s:2:\"id\";i:16812;s:5:\"title\";s:40:\"Construction Project &#8211; Real Estate\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/01/Construction-Project.png\";s:12:\"tmpl_created\";i:1610463582;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/construction-project-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:59:\"[\"Construction\",\"Landing Pages\",\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:796;s:11:\"trend_index\";i:724;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:279;a:19:{s:4:\"tmpl\";i:1244;s:2:\"id\";i:21393;s:5:\"title\";s:34:\"Interior Designer &#8211; Projects\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2021/12/big-22-Projects-Interior-Designer-New.jpeg\";s:12:\"tmpl_created\";i:1638823945;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/interior-designer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:93:\"[\"Creative\",\"Creative Portfolio\",\"Design\",\"Designer\",\"Interior Design\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:280;a:19:{s:4:\"tmpl\";i:1148;s:2:\"id\";i:16960;s:5:\"title\";s:44:\"Dog &amp; Cat Food Delivery &#8211; Business\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2021/01/Dog-Food.png\";s:12:\"tmpl_created\";i:1610533581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/lp/dog-cat-food-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:71:\"[\"Business\",\"Cat\",\"Delivery\",\"Dog\",\"Food\",\"Landing Pages\",\"Pet\",\"Pets\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:782;s:11:\"trend_index\";i:510;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:281;a:19:{s:4:\"tmpl\";i:670;s:2:\"id\";i:8525;s:5:\"title\";s:11:\"404 page 08\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/008.jpg\";s:12:\"tmpl_created\";i:1526415374;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-08/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:510;s:11:\"trend_index\";i:575;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:282;a:19:{s:4:\"tmpl\";i:1251;s:2:\"id\";i:22143;s:5:\"title\";s:33:\"Fashion Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Fashion-Store.png\";s:12:\"tmpl_created\";i:1647177389;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/fashion-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Coming Soon\",\"Fashion\",\"Landing Pages\",\"Shop\",\"store\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:283;a:19:{s:4:\"tmpl\";i:1155;s:2:\"id\";i:17095;s:5:\"title\";s:36:\"Mobile Pet Grooming &#8211; Business\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Mobile-Pet-Grooming.png\";s:12:\"tmpl_created\";i:1610632115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/mobile-pet-grooming-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:38:\"[\"Dog\",\"Groom\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:786;s:11:\"trend_index\";i:731;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:284;a:19:{s:4:\"tmpl\";i:1241;s:2:\"id\";i:21451;s:5:\"title\";s:26:\"Exhibition &#8211; Gallery\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/21-Gallery-Exhibition.jpg\";s:12:\"tmpl_created\";i:1638821855;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/exhibition-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:74:\"[\"Art\",\"Creative\",\"Creative Portfolio\",\"Exhibition\",\"Gallery\",\"Portfolio\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:285;a:19:{s:4:\"tmpl\";i:502;s:2:\"id\";i:5438;s:5:\"title\";s:7:\"About 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_4.png\";s:12:\"tmpl_created\";i:1520443512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:147;s:11:\"trend_index\";i:9;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:286;a:19:{s:4:\"tmpl\";i:1159;s:2:\"id\";i:17245;s:5:\"title\";s:34:\"Marketing Course &#8211; Education\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2021/01/PPC.png\";s:12:\"tmpl_created\";i:1610902958;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/marketing-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:45:\"[\"Course Online\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:770;s:11:\"trend_index\";i:430;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:287;a:19:{s:4:\"tmpl\";i:1240;s:2:\"id\";i:21430;s:5:\"title\";s:30:\"Travel Blogger &#8211; Gallery\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/12/19-Gallery-Travel-Blogger.jpg\";s:12:\"tmpl_created\";i:1638821592;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/travel-blogger-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:43:\"[\"Gallery\",\"Photography\",\"Slider\",\"Travel\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:288;a:19:{s:4:\"tmpl\";i:1149;s:2:\"id\";i:16983;s:5:\"title\";s:41:\"Pilates Instructor &#8211; Online Service\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/01/Pilates-Instructor.png\";s:12:\"tmpl_created\";i:1610534138;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/lp/pilates-instructor-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:70:\"[\"Free Trial\",\"Instructor\",\"Landing Pages\",\"Online Service\",\"Pilates\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:778;s:11:\"trend_index\";i:412;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:289;a:19:{s:4:\"tmpl\";i:1416;s:2:\"id\";i:24104;s:5:\"title\";s:33:\"Ceramics Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Ceramics-Shop.jpg\";s:12:\"tmpl_created\";i:1650988949;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/ceramics-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:115:\"[\"Art\",\"Business\",\"Coming Soon\",\"Creative\",\"Decor\",\"Design\",\"Furniture Design\",\"Interior Design\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:290;a:19:{s:4:\"tmpl\";i:557;s:2:\"id\";i:6135;s:5:\"title\";s:8:\"About 10\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_2.png\";s:12:\"tmpl_created\";i:1520443663;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:77;s:11:\"trend_index\";i:47;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:291;a:19:{s:4:\"tmpl\";i:1412;s:2:\"id\";i:24033;s:5:\"title\";s:37:\"Dance Studio &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Dance-Studio.jpg\";s:12:\"tmpl_created\";i:1649881344;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/dance-studio-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:113:\"[\"Academy\",\"Business\",\"Dance Studio\",\"Form\",\"Pilates\",\"School\",\"Sport\",\"Teacher\",\"Training\",\"Under Construction\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:292;a:19:{s:4:\"tmpl\";i:1190;s:2:\"id\";i:18568;s:5:\"title\";s:32:\"Flower Delivery &#8211; Business\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/04/Flower-Delivery.png\";s:12:\"tmpl_created\";i:1617546716;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/flower-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:37:\"[\"Delivery\",\"Flower\",\"Landing Pages\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:874;s:11:\"trend_index\";i:763;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:293;a:19:{s:4:\"tmpl\";i:1145;s:2:\"id\";i:16917;s:5:\"title\";s:22:\"Webinar &#8211; Events\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Webinar-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610466822;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/webinar-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:36:\"[\"Events\",\"Landing Pages\",\"Webinar\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:821;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:294;a:19:{s:4:\"tmpl\";i:1413;s:2:\"id\";i:24049;s:5:\"title\";s:33:\"ECO Shop &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-ECO-Shop.jpg\";s:12:\"tmpl_created\";i:1649882053;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/eco-shop-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:110:\"[\"Aesthetic\",\"Business\",\"Creative\",\"Decor\",\"Health\",\"Help\",\"Lifestyle\",\"Products\",\"Shop\",\"Under Construction\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:295;a:19:{s:4:\"tmpl\";i:497;s:2:\"id\";i:5397;s:5:\"title\";s:8:\"About 11\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1.png\";s:12:\"tmpl_created\";i:1520443503;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:148;s:11:\"trend_index\";i:43;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:296;a:19:{s:4:\"tmpl\";i:1154;s:2:\"id\";i:17079;s:5:\"title\";s:42:\"Calls Volunteer &#8211; Social Involvement\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/01/Calls-Volunteer.png\";s:12:\"tmpl_created\";i:1610631774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/calls-volunteer-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:68:\"[\"Care\",\"Covid-19\",\"Help\",\"Involvement\",\"Landing Pages\",\"Volunteer\"]\";s:10:\"menu_order\";i:47;s:16:\"popularity_index\";i:854;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:297;a:19:{s:4:\"tmpl\";i:1419;s:2:\"id\";i:24136;s:5:\"title\";s:29:\"Food Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Food-Blog.jpg\";s:12:\"tmpl_created\";i:1650990034;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/food-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:62:\"[\"Blog\",\"Business\",\"Coming Soon\",\"Cooking\",\"Education\",\"Food\"]\";s:10:\"menu_order\";i:47;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:298;a:19:{s:4:\"tmpl\";i:1142;s:2:\"id\";i:16836;s:5:\"title\";s:33:\"Marketing Agency &#8211; Business\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/01/Marketing-Agency-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610464490;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/marketing-agency-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:74:\"[\"Agency\",\"Business\",\"Landing Pages\",\"Marketing\",\"Marketing Landing Page\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:816;s:11:\"trend_index\";i:787;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:299;a:19:{s:4:\"tmpl\";i:1411;s:2:\"id\";i:24020;s:5:\"title\";s:35:\"Mobile App &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Mobile-App.jpg\";s:12:\"tmpl_created\";i:1649880955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/mobile-app-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:77:\"[\"App\",\"Business\",\"Coding\",\"Computer\",\"Launch\",\"Mobile\",\"Under Construction\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:300;a:19:{s:4:\"tmpl\";i:498;s:2:\"id\";i:5405;s:5:\"title\";s:8:\"About 12\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1.png\";s:12:\"tmpl_created\";i:1520443505;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:216;s:11:\"trend_index\";i:50;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:301;a:19:{s:4:\"tmpl\";i:1139;s:2:\"id\";i:16785;s:5:\"title\";s:42:\"Gym Promotion &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2021/01/Gym-LP.jpg\";s:12:\"tmpl_created\";i:1610455496;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/gym-promotion-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:42:\"[\"Fitness\",\"Gym\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:49;s:16:\"popularity_index\";i:820;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:302;a:19:{s:4:\"tmpl\";i:1420;s:2:\"id\";i:24152;s:5:\"title\";s:32:\"Perfume Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Perfume-Shop.jpg\";s:12:\"tmpl_created\";i:1650990353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/perfume-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:68:\"[\"Business\",\"Coming Soon\",\"Cosmetics\",\"Lifestyle\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:49;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:303;a:19:{s:4:\"tmpl\";i:1185;s:2:\"id\";i:18492;s:5:\"title\";s:34:\"Bicycle Pre-Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Bike-Landing-Page.png\";s:12:\"tmpl_created\";i:1617535552;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/bicycle-pre-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:34:\"[\"Bicycle\",\"Landing Pages\",\"Sale\"]\";s:10:\"menu_order\";i:50;s:16:\"popularity_index\";i:871;s:11:\"trend_index\";i:826;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:304;a:19:{s:4:\"tmpl\";i:1418;s:2:\"id\";i:24126;s:5:\"title\";s:28:\"Skincare &#8211; Coming Soon\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Skincare.jpg\";s:12:\"tmpl_created\";i:1650989585;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/skincare-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:128:\"[\"Aesthetic\",\"Beauty\",\"Beauty Salon\",\"Business\",\"Coming Soon\",\"Cosmetics\",\"Girly\",\"Lifestyle\",\"Services\",\"Skincare\",\"Treatment\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:305;a:19:{s:4:\"tmpl\";i:1181;s:2:\"id\";i:18349;s:5:\"title\";s:39:\"Virtual try-on glasses &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-8.png\";s:12:\"tmpl_created\";i:1614772569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/lp/virtual-try-on-glasses-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:64:\"[\"Fashion\",\"Glasses\",\"Landing Pages\",\"Online Service\",\"Virtual\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:848;s:11:\"trend_index\";i:803;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:306;a:19:{s:4:\"tmpl\";i:500;s:2:\"id\";i:5421;s:5:\"title\";s:8:\"About 13\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_3.png\";s:12:\"tmpl_created\";i:1520443509;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:215;s:11:\"trend_index\";i:77;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:307;a:19:{s:4:\"tmpl\";i:513;s:2:\"id\";i:5533;s:5:\"title\";s:8:\"About 15\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_10.png\";s:12:\"tmpl_created\";i:1520443534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:21;s:11:\"trend_index\";i:57;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:308;a:19:{s:4:\"tmpl\";i:1410;s:2:\"id\";i:24004;s:5:\"title\";s:33:\"Skincare &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Skincare.jpg\";s:12:\"tmpl_created\";i:1649880534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/skincare-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:144:\"[\"Aesthetic\",\"Beauty\",\"Beauty Salon\",\"Business\",\"Cosmetics\",\"Girly\",\"Lifestyle\",\"Makeup\",\"Services\",\"Skincare\",\"Treatment\",\"Under Construction\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:309;a:19:{s:4:\"tmpl\";i:1172;s:2:\"id\";i:17458;s:5:\"title\";s:31:\"Moving Company &#8211; Business\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Moving-Company.png\";s:12:\"tmpl_created\";i:1612727025;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/moving-company-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:46:\"[\"Business\",\"Landing Pages\",\"Movers\",\"Moving\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:826;s:11:\"trend_index\";i:767;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:310;a:19:{s:4:\"tmpl\";i:1415;s:2:\"id\";i:24092;s:5:\"title\";s:29:\"Vase Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Vase-Shop.jpg\";s:12:\"tmpl_created\";i:1650988613;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/vase-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:115:\"[\"Art\",\"Business\",\"Coming Soon\",\"Creative\",\"Decor\",\"Design\",\"Furniture Design\",\"Interior Design\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:53;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:311;a:19:{s:4:\"tmpl\";i:1186;s:2:\"id\";i:18517;s:5:\"title\";s:29:\"Food Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Food-Blog.png\";s:12:\"tmpl_created\";i:1617539897;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/food-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:45:\"[\"Blog\",\"Coming Soon\",\"Food\",\"Landing Pages\"]\";s:10:\"menu_order\";i:53;s:16:\"popularity_index\";i:844;s:11:\"trend_index\";i:672;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:312;a:19:{s:4:\"tmpl\";i:1167;s:2:\"id\";i:17379;s:5:\"title\";s:33:\"IT Service &#8211; Online Service\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-IT-Service.png\";s:12:\"tmpl_created\";i:1612713022;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/it-service-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:41:\"[\"IT\",\"Landing Pages\",\"Remote\",\"Support\"]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:806;s:11:\"trend_index\";i:634;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:313;a:19:{s:4:\"tmpl\";i:1248;s:2:\"id\";i:22134;s:5:\"title\";s:32:\"Art Magazine &#8211; Coming Soon\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Art-Magazine-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1647176713;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/art-magazine-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:48:\"[\"Art\",\"Coming Soon\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:314;a:19:{s:4:\"tmpl\";i:512;s:2:\"id\";i:5525;s:5:\"title\";s:8:\"About 14\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_10.png\";s:12:\"tmpl_created\";i:1520443532;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:9;s:11:\"trend_index\";i:29;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:315;a:19:{s:4:\"tmpl\";i:1189;s:2:\"id\";i:18560;s:5:\"title\";s:52:\"Finance Learning Platform &#8211; Under Construction\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Finance-Platform.png\";s:12:\"tmpl_created\";i:1617542761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/lp/finance-learning-platform-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:27:\"[\"Finance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:843;s:11:\"trend_index\";i:561;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:316;a:19:{s:4:\"tmpl\";i:1225;s:2:\"id\";i:21041;s:5:\"title\";s:41:\"Business Consulting Company &#8211; About\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2021/12/8-About-Business-Consulting-Company.jpg\";s:12:\"tmpl_created\";i:1638797560;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/business-consulting-company-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"Coach\",\"Collaboration\",\"Consulting\",\"Life Coach\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:317;a:19:{s:4:\"tmpl\";i:1187;s:2:\"id\";i:18528;s:5:\"title\";s:36:\"Home Decor Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Home-Decore.png\";s:12:\"tmpl_created\";i:1617541784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/home-decor-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:57:\"[\"Coming Soon\",\"Decor\",\"Interior Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:872;s:11:\"trend_index\";i:819;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:318;a:19:{s:4:\"tmpl\";i:1243;s:2:\"id\";i:21135;s:5:\"title\";s:28:\"Construction &#8211; Service\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/13-Service-Construction.jpg\";s:12:\"tmpl_created\";i:1638823202;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/construction-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:48:\"[\"Architecture\",\"Construction\",\"Faq\",\"Services\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:319;a:19:{s:4:\"tmpl\";i:501;s:2:\"id\";i:5429;s:5:\"title\";s:8:\"About 16\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_4.png\";s:12:\"tmpl_created\";i:1520443510;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:59;s:11:\"trend_index\";i:8;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:320;a:19:{s:4:\"tmpl\";i:1174;s:2:\"id\";i:17504;s:5:\"title\";s:29:\"Hair Stylist &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-3.png\";s:12:\"tmpl_created\";i:1612883014;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/hair-stylist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:59:\"[\"Business\",\"Hair\",\"hairdresser\",\"Landing Pages\",\"Stylist\"]\";s:10:\"menu_order\";i:57;s:16:\"popularity_index\";i:840;s:11:\"trend_index\";i:806;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:321;a:19:{s:4:\"tmpl\";i:1223;s:2:\"id\";i:20981;s:5:\"title\";s:37:\"Creative Digital Agency &#8211; About\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2021/12/6-About-Creative-Digital-Agency.jpg\";s:12:\"tmpl_created\";i:1638789303;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/creative-digital-agency-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"About\",\"Advisor\",\"Creative\",\"Creative Portfolio\"]\";s:10:\"menu_order\";i:57;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:322;a:19:{s:4:\"tmpl\";i:1184;s:2:\"id\";i:18449;s:5:\"title\";s:45:\"Aesthetic Clinic &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2021/03/Aesthetic-Clinic.png\";s:12:\"tmpl_created\";i:1616682181;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/lp/aesthetic-clinic-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:57:\"[\"Aesthetic\",\"Beauty\",\"Fitness\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:859;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:323;a:19:{s:4:\"tmpl\";i:1221;s:2:\"id\";i:20926;s:5:\"title\";s:33:\"Doctors Online Consultation -Home\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/12/4-Home-Doctors-Online-Consultation.jpg\";s:12:\"tmpl_created\";i:1638787371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/doctors-online-consultation-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:35:\"[\"App\",\"Health\",\"Medical\",\"Online\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:324;a:19:{s:4:\"tmpl\";i:505;s:2:\"id\";i:5464;s:5:\"title\";s:8:\"About 17\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_6.png\";s:12:\"tmpl_created\";i:1520443518;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:220;s:11:\"trend_index\";i:142;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:325;a:19:{s:4:\"tmpl\";i:1165;s:2:\"id\";i:17353;s:5:\"title\";s:44:\"Online Cooking Course &#8211; Online Service\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-2.png\";s:12:\"tmpl_created\";i:1612705144;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/lp/online-cooking-course-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:50:\"[\"Cooking\",\"Course Online\",\"Food\",\"Landing Pages\"]\";s:10:\"menu_order\";i:59;s:16:\"popularity_index\";i:845;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:326;a:19:{s:4:\"tmpl\";i:1188;s:2:\"id\";i:18550;s:5:\"title\";s:39:\"Online Store &#8211; Under Construction\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Online-Store.png\";s:12:\"tmpl_created\";i:1617542506;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/lp/online-store-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:59:\"[\"Landing Pages\",\"Online Shop\",\"Shop\",\"Under Construction\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:832;s:11:\"trend_index\";i:600;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:327;a:19:{s:4:\"tmpl\";i:1250;s:2:\"id\";i:22140;s:5:\"title\";s:33:\"Design School &#8211; Coming Soon\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/05/250x280-1.png\";s:12:\"tmpl_created\";i:1647177317;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/design-school-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:49:\"[\"Coming Soon\",\"Design\",\"Landing Pages\",\"School\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:328;a:19:{s:4:\"tmpl\";i:510;s:2:\"id\";i:5504;s:5:\"title\";s:8:\"About 18\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_9.png\";s:12:\"tmpl_created\";i:1520443528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:104;s:11:\"trend_index\";i:46;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:329;a:19:{s:4:\"tmpl\";i:1191;s:2:\"id\";i:18539;s:5:\"title\";s:40:\"Travel Agency &#8211; Under Construction\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Travel-Agency-1.png\";s:12:\"tmpl_created\";i:1617610273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/travel-agency-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:56:\"[\"Agency\",\"Landing Pages\",\"Travel\",\"Under Construction\"]\";s:10:\"menu_order\";i:61;s:16:\"popularity_index\";i:876;s:11:\"trend_index\";i:652;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:330;a:19:{s:4:\"tmpl\";i:1175;s:2:\"id\";i:18270;s:5:\"title\";s:24:\"Open week &#8211; Events\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280.png\";s:12:\"tmpl_created\";i:1614767186;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/open-week-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:59:\"[\"Education\",\"Event\",\"Events\",\"Landing Pages\",\"University\"]\";s:10:\"menu_order\";i:62;s:16:\"popularity_index\";i:831;s:11:\"trend_index\";i:673;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:331;a:19:{s:4:\"tmpl\";i:1177;s:2:\"id\";i:18300;s:5:\"title\";s:30:\"Makeup Artist &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/