/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-06-10 15:45:19 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=357 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=442 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=1040 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=7166 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=4482 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=532 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_rtl_rsm_logs` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `section` varchar(255) NOT NULL,
  `result` mediumtext NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=468 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=46 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=166 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=46 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=188 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=806 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=67 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_product_date` (`customer_id`,`product_id`,`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_method_title` text DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=MyISAM AUTO_INCREMENT=134 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `global_unique_id` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM AUTO_INCREMENT=125 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=MyISAM AUTO_INCREMENT=74 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `zone_id` (`zone_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woodmart_wishlist_products` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` varchar(255) NOT NULL,
  `wishlist_id` int(11) DEFAULT NULL,
  `date_added` timestamp NOT NULL DEFAULT current_timestamp(),
  `on_sale` tinyint(1) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `product_id` (`product_id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `wp_woodmart_wishlists` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `wishlist_group` varchar(255) NOT NULL DEFAULT 'لیست علاقمندی های من',
  `date_created` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("214", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-19 20:54:24", "2025-05-19 20:54:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747688064;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747688064;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-20 09:59:56", "2025-05-20 13:29:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("14", "action_scheduler/migration_hook", "failed", "2025-03-16 02:10:02", "2025-03-16 02:10:02", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1742091002;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1742091002;}", "2", "1", "2025-03-16 02:10:04", "2025-03-16 05:40:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("213", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-19 19:59:24", "2025-05-19 19:59:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747684764;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747684764;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-20 09:59:56", "2025-05-20 13:29:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("16", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "failed", "2025-03-17 20:22:32", "2025-03-17 20:22:32", "10", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "3", "1", "2025-03-17 20:22:32", "2025-03-17 23:52:32", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("210", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-19 17:29:38", "2025-05-19 17:29:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747675778;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747675778;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-19 19:54:24", "2025-05-19 23:24:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("225", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-21 16:15:01", "2025-05-21 16:15:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747844101;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747844101;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-22 20:48:41", "2025-05-23 00:18:41", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("252", "woocommerce_cleanup_draft_orders", "complete", "2025-05-29 08:48:57", "2025-05-29 08:48:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748508537;s:18:\"\0*\0first_timestamp\";i:1742090881;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748508537;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-05-30 16:02:07", "2025-05-30 19:32:07", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("260", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-30 16:07:07", "2025-05-30 16:07:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748621227;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748621227;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-31 10:20:41", "2025-05-31 13:50:41", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("261", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-30 17:02:07", "2025-05-30 17:02:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748624527;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748624527;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-31 10:20:41", "2025-05-31 13:50:41", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("263", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-31 10:25:41", "2025-05-31 10:25:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748687141;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748687141;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-31 10:29:32", "2025-05-31 13:59:32", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("272", "woocommerce_custom_orders_table_background_sync", "complete", "2025-06-01 07:22:45", "2025-06-01 07:22:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748762565;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748762565;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-06-01 19:05:22", "2025-06-01 22:35:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("289", "woocommerce_custom_orders_table_background_sync", "complete", "2025-06-03 22:18:30", "2025-06-03 22:18:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748989110;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748989110;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-06-04 10:53:51", "2025-06-04 14:23:51", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("329", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-08 07:58:19", "2025-06-08 07:58:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749369499;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749369499;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-08 21:12:41", "2025-06-09 00:42:41", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("330", "woocommerce_custom_orders_table_background_sync", "complete", "2025-06-08 08:53:19", "2025-06-08 08:53:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749372799;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749372799;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-06-08 21:12:41", "2025-06-09 00:42:41", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("331", "woocommerce_cleanup_draft_orders", "complete", "2025-06-09 07:53:19", "2025-06-09 07:53:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749455599;s:18:\"\0*\0first_timestamp\";i:1742090881;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749455599;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-06-09 08:49:43", "2025-06-09 12:19:43", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("299", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-07 11:41:24", "2025-06-07 11:41:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749296484;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749296484;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-07 11:48:22", "2025-06-07 15:18:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("345", "woocommerce_run_update_callback", "complete", "2025-06-10 15:28:59", "2025-06-10 15:28:59", "10", "{\"update_callback\":\"wc_update_980_remove_order_attribution_install_banner_dismissed_option\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749569339;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749569339;}", "4", "1", "2025-06-10 15:29:36", "2025-06-10 18:59:36", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("346", "woocommerce_run_update_callback", "complete", "2025-06-10 15:29:00", "2025-06-10 15:29:00", "10", "{\"update_callback\":\"wc_update_985_enable_new_payments_settings_page_feature\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749569340;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749569340;}", "4", "1", "2025-06-10 15:29:37", "2025-06-10 18:59:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("344", "fetch_patterns", "complete", "2025-06-10 15:28:45", "2025-06-10 15:28:45", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749569325;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749569325;}", "3", "1", "2025-06-10 15:29:36", "2025-06-10 18:59:36", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("343", "woocommerce_cleanup_draft_orders", "pending", "2025-06-11 15:24:01", "2025-06-11 15:24:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749655441;s:18:\"\0*\0first_timestamp\";i:1742090881;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749655441;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("342", "woocommerce_custom_orders_table_background_sync", "pending", "2025-06-10 16:24:01", "2025-06-10 16:24:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749572641;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749572641;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("341", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-10 15:29:01", "2025-06-10 15:29:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749569341;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749569341;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-10 15:29:37", "2025-06-10 18:59:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("169", "woocommerce_cleanup_draft_orders", "complete", "2025-05-11 08:01:15", "2025-05-11 08:01:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746950475;s:18:\"\0*\0first_timestamp\";i:1742090881;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746950475;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-05-12 16:01:38", "2025-05-12 19:31:38", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("171", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-10 12:08:52", "2025-05-10 12:08:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746878932;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746878932;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-10 16:57:52", "2025-05-10 20:27:52", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("173", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-10 17:57:52", "2025-05-10 17:57:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746899872;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746899872;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-11 05:56:42", "2025-05-11 09:26:42", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("170", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-10 11:13:52", "2025-05-10 11:13:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746875632;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746875632;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-10 16:57:52", "2025-05-10 20:27:52", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("176", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-11 07:25:15", "2025-05-11 07:25:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746948315;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746948315;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-11 07:57:02", "2025-05-11 11:27:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("172", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-10 17:02:52", "2025-05-10 17:02:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746896572;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746896572;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-11 05:56:42", "2025-05-11 09:26:42", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("174", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-11 06:01:42", "2025-05-11 06:01:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746943302;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746943302;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-11 07:20:15", "2025-05-11 10:50:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("175", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-11 06:56:42", "2025-05-11 06:56:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746946602;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746946602;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-11 07:20:15", "2025-05-11 10:50:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("180", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-12 16:06:38", "2025-05-12 16:06:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747065998;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747065998;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-13 06:11:01", "2025-05-13 09:41:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("181", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-12 17:01:38", "2025-05-12 17:01:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747069298;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747069298;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-13 06:11:01", "2025-05-13 09:41:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("182", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-13 06:16:01", "2025-05-13 06:16:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747116961;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747116961;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-13 06:16:30", "2025-05-13 09:46:30", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("179", "woocommerce_cleanup_draft_orders", "complete", "2025-05-13 16:01:38", "2025-05-13 16:01:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747152098;s:18:\"\0*\0first_timestamp\";i:1742090881;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747152098;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-05-15 06:52:42", "2025-05-15 10:22:42", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("183", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-13 07:11:01", "2025-05-13 07:11:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747120261;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747120261;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-13 08:46:04", "2025-05-13 12:16:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("190", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-15 06:57:42", "2025-05-15 06:57:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747292262;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747292262;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-15 07:52:02", "2025-05-15 11:22:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("188", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-13 08:51:04", "2025-05-13 08:51:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747126264;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747126264;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-15 06:52:42", "2025-05-15 10:22:42", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("194", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-15 09:33:53", "2025-05-15 09:33:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747301633;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747301633;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-15 17:51:04", "2025-05-15 21:21:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("193", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-15 07:57:02", "2025-05-15 07:57:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747295822;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747295822;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-15 08:33:53", "2025-05-15 12:03:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("198", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-15 17:56:04", "2025-05-15 17:56:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747331764;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747331764;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-16 05:12:48", "2025-05-16 08:42:48", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("196", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-15 09:37:33", "2025-05-15 09:37:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747301853;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747301853;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-15 17:51:04", "2025-05-15 21:21:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("203", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-16 20:26:19", "2025-05-16 20:26:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747427179;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747427179;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-17 16:24:10", "2025-05-17 19:54:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("197", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-15 18:51:04", "2025-05-15 18:51:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747335064;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747335064;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-16 05:12:48", "2025-05-16 08:42:48", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("202", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-16 19:31:19", "2025-05-16 19:31:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747423879;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747423879;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-17 16:24:10", "2025-05-17 19:54:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("205", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-17 16:29:10", "2025-05-17 16:29:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747499350;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747499350;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-18 09:42:42", "2025-05-18 13:12:42", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("206", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-17 17:24:10", "2025-05-17 17:24:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747502650;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747502650;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-18 09:42:42", "2025-05-18 13:12:42", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("212", "woocommerce_cleanup_draft_orders", "complete", "2025-05-20 17:24:38", "2025-05-20 17:24:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747761878;s:18:\"\0*\0first_timestamp\";i:1742090881;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747761878;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-05-21 07:25:17", "2025-05-21 10:55:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("211", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-19 18:24:38", "2025-05-19 18:24:38", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747679078;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747679078;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-19 19:54:24", "2025-05-19 23:24:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("228", "woocommerce_cleanup_draft_orders", "complete", "2025-05-23 20:48:41", "2025-05-23 20:48:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748033321;s:18:\"\0*\0first_timestamp\";i:1742090881;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748033321;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-05-24 08:37:23", "2025-05-24 12:07:23", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("224", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-21 15:20:01", "2025-05-21 15:20:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747840801;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747840801;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-22 20:48:41", "2025-05-23 00:18:41", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("226", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-22 20:53:41", "2025-05-22 20:53:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747947221;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747947221;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-23 04:27:36", "2025-05-23 07:57:36", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("227", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-22 21:48:41", "2025-05-22 21:48:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747950521;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747950521;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-23 04:27:36", "2025-05-23 07:57:36", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("234", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-24 12:28:04", "2025-05-24 12:28:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748089684;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748089684;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-25 05:50:47", "2025-05-25 09:20:47", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("235", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-24 13:23:04", "2025-05-24 13:23:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748092984;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748092984;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-25 05:50:47", "2025-05-25 09:20:47", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("233", "woocommerce_cleanup_draft_orders", "complete", "2025-05-25 08:37:23", "2025-05-25 08:37:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748162243;s:18:\"\0*\0first_timestamp\";i:1742090881;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748162243;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-05-25 15:01:05", "2025-05-25 18:31:05", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("231", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-24 08:42:23", "2025-05-24 08:42:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748076143;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748076143;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-24 12:23:04", "2025-05-24 15:53:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("232", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-24 09:37:23", "2025-05-24 09:37:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748079443;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748079443;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-24 12:23:04", "2025-05-24 15:53:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("239", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-25 16:01:05", "2025-05-25 16:01:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748188865;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748188865;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-25 16:55:42", "2025-05-25 20:25:42", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("238", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-25 15:06:05", "2025-05-25 15:06:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748185565;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748185565;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-25 16:55:42", "2025-05-25 20:25:42", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("241", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-25 17:00:42", "2025-05-25 17:00:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748192442;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748192442;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-26 07:46:37", "2025-05-26 11:16:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("246", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-26 22:19:23", "2025-05-26 22:19:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748297963;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748297963;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-27 16:45:50", "2025-05-27 20:15:50", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("247", "woocommerce_cleanup_draft_orders", "complete", "2025-05-27 21:19:23", "2025-05-27 21:19:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748380763;s:18:\"\0*\0first_timestamp\";i:1742090881;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748380763;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-05-28 08:48:57", "2025-05-28 12:18:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("250", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-28 08:53:57", "2025-05-28 08:53:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748422437;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748422437;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-28 15:53:58", "2025-05-28 19:23:58", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("245", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-26 21:24:23", "2025-05-26 21:24:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748294663;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748294663;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-27 16:45:50", "2025-05-27 20:15:50", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("251", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-28 09:48:57", "2025-05-28 09:48:57", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748425737;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748425737;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-28 15:53:58", "2025-05-28 19:23:58", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("262", "woocommerce_cleanup_draft_orders", "complete", "2025-05-31 16:02:07", "2025-05-31 16:02:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748707327;s:18:\"\0*\0first_timestamp\";i:1742090881;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748707327;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-05-31 18:26:52", "2025-05-31 21:56:52", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("271", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-01 06:27:45", "2025-06-01 06:27:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748759265;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748759265;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-01 19:05:22", "2025-06-01 22:35:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("264", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-31 11:20:41", "2025-05-31 11:20:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748690441;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748690441;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-31 18:26:52", "2025-05-31 21:56:52", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("267", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-31 19:26:52", "2025-05-31 19:26:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748719612;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748719612;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-31 19:54:02", "2025-05-31 23:24:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("284", "woocommerce_custom_orders_table_background_sync", "complete", "2025-06-02 22:16:49", "2025-06-02 22:16:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748902609;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748902609;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-06-03 07:25:36", "2025-06-03 10:55:36", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("275", "woocommerce_cleanup_draft_orders", "complete", "2025-06-02 19:05:22", "2025-06-02 19:05:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748891122;s:18:\"\0*\0first_timestamp\";i:1742090881;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748891122;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-06-02 21:16:49", "2025-06-03 00:46:49", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("274", "woocommerce_custom_orders_table_background_sync", "complete", "2025-06-01 20:05:22", "2025-06-01 20:05:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748808322;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748808322;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-06-02 05:45:37", "2025-06-02 09:15:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("273", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-01 19:10:22", "2025-06-01 19:10:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748805022;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748805022;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-02 05:45:37", "2025-06-02 09:15:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("283", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-02 21:21:49", "2025-06-02 21:21:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748899309;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748899309;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-03 07:25:36", "2025-06-03 10:55:36", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("292", "woocommerce_custom_orders_table_background_sync", "complete", "2025-06-04 11:53:51", "2025-06-04 11:53:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749038031;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749038031;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-06-05 11:17:08", "2025-06-05 14:47:08", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("288", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-03 21:23:30", "2025-06-03 21:23:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748985810;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748985810;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-04 10:53:51", "2025-06-04 14:23:51", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("291", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-04 10:58:51", "2025-06-04 10:58:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749034731;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749034731;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-05 11:17:08", "2025-06-05 14:47:08", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("293", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-05 11:22:08", "2025-06-05 11:22:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749122528;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749122528;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-06 20:27:28", "2025-06-06 23:57:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("294", "woocommerce_custom_orders_table_background_sync", "complete", "2025-06-05 12:17:08", "2025-06-05 12:17:08", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749125828;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749125828;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-06-06 20:27:28", "2025-06-06 23:57:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("295", "woocommerce_cleanup_draft_orders", "complete", "2025-06-06 11:17:09", "2025-06-06 11:17:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749208629;s:18:\"\0*\0first_timestamp\";i:1742090881;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749208629;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-06-06 20:27:28", "2025-06-06 23:57:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("296", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-06 20:32:28", "2025-06-06 20:32:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749241948;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749241948;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-07 11:36:24", "2025-06-07 15:06:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("297", "woocommerce_custom_orders_table_background_sync", "complete", "2025-06-06 21:27:28", "2025-06-06 21:27:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749245248;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749245248;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-06-07 11:36:24", "2025-06-07 15:06:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("298", "woocommerce_cleanup_draft_orders", "complete", "2025-06-07 20:27:28", "2025-06-07 20:27:28", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749328048;s:18:\"\0*\0first_timestamp\";i:1742090881;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749328048;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-06-08 07:53:19", "2025-06-08 11:23:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("300", "woocommerce_custom_orders_table_background_sync", "complete", "2025-06-07 12:36:24", "2025-06-07 12:36:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749299784;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749299784;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-06-07 12:36:43", "2025-06-07 16:06:43", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("333", "woocommerce_custom_orders_table_background_sync", "complete", "2025-06-08 22:12:41", "2025-06-08 22:12:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749420761;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749420761;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-06-09 08:49:43", "2025-06-09 12:19:43", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("332", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-08 21:17:41", "2025-06-08 21:17:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749417461;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749417461;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-09 08:49:43", "2025-06-09 12:19:43", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("177", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-11 08:20:15", "2025-05-11 08:20:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746951615;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746951615;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-12 16:01:38", "2025-05-12 19:31:38", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("178", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-11 08:02:02", "2025-05-11 08:02:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746950522;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746950522;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-12 16:01:38", "2025-05-12 19:31:38", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("184", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-13 06:21:30", "2025-05-13 06:21:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747117290;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747117290;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-13 06:21:41", "2025-05-13 09:51:41", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("185", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-13 06:26:41", "2025-05-13 06:26:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747117601;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747117601;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-13 06:27:05", "2025-05-13 09:57:05", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("186", "action_scheduler/migration_hook", "complete", "2025-05-13 06:26:59", "2025-05-13 06:26:59", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747117619;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747117619;}", "2", "1", "2025-05-13 06:27:05", "2025-05-13 09:57:05", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("187", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-13 06:32:05", "2025-05-13 06:32:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747117925;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747117925;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-13 08:46:04", "2025-05-13 12:16:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("189", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-13 09:46:04", "2025-05-13 09:46:04", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747129564;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747129564;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-15 06:52:42", "2025-05-15 10:22:42", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("191", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-15 07:52:42", "2025-05-15 07:52:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747295562;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747295562;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-15 08:33:53", "2025-05-15 12:03:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("192", "woocommerce_cleanup_draft_orders", "complete", "2025-05-16 06:52:42", "2025-05-16 06:52:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747378362;s:18:\"\0*\0first_timestamp\";i:1742090881;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747378362;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-05-16 19:26:19", "2025-05-16 22:56:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("195", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-15 08:38:53", "2025-05-15 08:38:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747298333;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747298333;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-15 09:32:33", "2025-05-15 13:02:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("201", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-16 05:33:52", "2025-05-16 05:33:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747373632;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747373632;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-16 19:26:19", "2025-05-16 22:56:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("199", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-16 05:17:48", "2025-05-16 05:17:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747372668;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747372668;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-16 05:28:52", "2025-05-16 08:58:52", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("200", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-16 06:12:48", "2025-05-16 06:12:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747375968;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747375968;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-16 19:26:19", "2025-05-16 22:56:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("204", "woocommerce_cleanup_draft_orders", "complete", "2025-05-17 19:26:19", "2025-05-17 19:26:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747509979;s:18:\"\0*\0first_timestamp\";i:1742090881;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747509979;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-05-18 09:42:42", "2025-05-18 13:12:42", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("207", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-18 09:47:42", "2025-05-18 09:47:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747561662;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747561662;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-19 17:24:38", "2025-05-19 20:54:38", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("208", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-18 10:42:42", "2025-05-18 10:42:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747564962;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747564962;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-19 17:24:38", "2025-05-19 20:54:38", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("209", "woocommerce_cleanup_draft_orders", "complete", "2025-05-19 09:42:42", "2025-05-19 09:42:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747647762;s:18:\"\0*\0first_timestamp\";i:1742090881;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747647762;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-05-19 17:24:38", "2025-05-19 20:54:38", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("217", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-20 10:10:07", "2025-05-20 10:10:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747735807;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747735807;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-20 12:17:23", "2025-05-20 15:47:23", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("215", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-20 10:04:56", "2025-05-20 10:04:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747735496;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747735496;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-20 10:05:07", "2025-05-20 13:35:07", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("216", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-20 10:59:56", "2025-05-20 10:59:56", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747738796;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747738796;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-20 12:17:24", "2025-05-20 15:47:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("220", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-20 13:07:30", "2025-05-20 13:07:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747746450;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747746450;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-21 07:25:17", "2025-05-21 10:55:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("218", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-20 12:22:23", "2025-05-20 12:22:23", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747743743;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747743743;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-20 13:02:30", "2025-05-20 16:32:30", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("219", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-20 13:17:24", "2025-05-20 13:17:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747747044;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747747044;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-21 07:25:17", "2025-05-21 10:55:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("221", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-21 07:30:17", "2025-05-21 07:30:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747812617;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747812617;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-21 15:15:01", "2025-05-21 18:45:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("222", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-21 08:25:17", "2025-05-21 08:25:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747815917;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747815917;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-21 15:15:01", "2025-05-21 18:45:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("223", "woocommerce_cleanup_draft_orders", "complete", "2025-05-22 07:25:17", "2025-05-22 07:25:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747898717;s:18:\"\0*\0first_timestamp\";i:1742090881;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747898717;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-05-22 20:48:41", "2025-05-23 00:18:41", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("229", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-23 04:32:36", "2025-05-23 04:32:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747974756;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747974756;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-24 08:37:23", "2025-05-24 12:07:23", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("230", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-23 05:27:36", "2025-05-23 05:27:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747978056;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747978056;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-24 08:37:23", "2025-05-24 12:07:23", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("236", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-25 05:55:47", "2025-05-25 05:55:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748152547;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748152547;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-25 15:01:05", "2025-05-25 18:31:05", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("237", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-25 06:50:47", "2025-05-25 06:50:47", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748155847;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748155847;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-25 15:01:05", "2025-05-25 18:31:05", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("240", "woocommerce_cleanup_draft_orders", "complete", "2025-05-26 15:01:05", "2025-05-26 15:01:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748271665;s:18:\"\0*\0first_timestamp\";i:1742090881;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748271665;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-05-26 21:19:23", "2025-05-27 00:49:23", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("242", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-25 17:55:42", "2025-05-25 17:55:42", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748195742;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748195742;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-26 07:46:37", "2025-05-26 11:16:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("243", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-26 07:51:37", "2025-05-26 07:51:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748245897;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748245897;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-26 21:19:23", "2025-05-27 00:49:23", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("244", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-26 08:46:37", "2025-05-26 08:46:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748249197;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748249197;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-26 21:19:23", "2025-05-27 00:49:23", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("248", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-27 16:50:50", "2025-05-27 16:50:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748364650;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748364650;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-28 08:48:57", "2025-05-28 12:18:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("249", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-27 17:45:50", "2025-05-27 17:45:50", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748367950;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748367950;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-28 08:48:57", "2025-05-28 12:18:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("253", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-28 15:58:58", "2025-05-28 15:58:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748447938;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748447938;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-28 16:02:58", "2025-05-28 19:32:58", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("254", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-28 16:53:58", "2025-05-28 16:53:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748451238;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748451238;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-28 19:13:27", "2025-05-28 22:43:27", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("255", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-28 16:07:58", "2025-05-28 16:07:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748448478;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748448478;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-28 19:13:27", "2025-05-28 22:43:27", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("256", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-28 19:18:27", "2025-05-28 19:18:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748459907;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748459907;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-29 07:47:48", "2025-05-29 11:17:48", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("257", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-28 20:13:27", "2025-05-28 20:13:27", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748463207;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748463207;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-29 07:47:48", "2025-05-29 11:17:48", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("258", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-29 07:52:48", "2025-05-29 07:52:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748505168;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748505168;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-30 16:02:07", "2025-05-30 19:32:07", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("259", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-29 08:47:48", "2025-05-29 08:47:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748508468;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748508468;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-05-30 16:02:07", "2025-05-30 19:32:07", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("266", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-31 18:31:52", "2025-05-31 18:31:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748716312;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748716312;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-31 19:54:02", "2025-05-31 23:24:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("265", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-31 10:34:32", "2025-05-31 10:34:32", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748687672;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748687672;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-05-31 18:26:52", "2025-05-31 21:56:52", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("268", "woocommerce_cleanup_draft_orders", "complete", "2025-06-01 18:26:52", "2025-06-01 18:26:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748802412;s:18:\"\0*\0first_timestamp\";i:1742090881;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748802412;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-06-01 19:05:22", "2025-06-01 22:35:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("269", "image-optimization/cleanup/stuck-operation", "complete", "2025-05-31 19:59:02", "2025-05-31 19:59:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748721542;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748721542;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-01 06:22:45", "2025-06-01 09:52:45", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("270", "woocommerce_custom_orders_table_background_sync", "complete", "2025-05-31 20:54:02", "2025-05-31 20:54:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748724842;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748724842;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-06-01 06:22:45", "2025-06-01 09:52:45", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("278", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-02 06:13:54", "2025-06-02 06:13:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748844834;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748844834;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-02 08:54:48", "2025-06-02 12:24:48", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("276", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-02 05:50:37", "2025-06-02 05:50:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748843437;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748843437;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-02 06:08:54", "2025-06-02 09:38:54", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("277", "woocommerce_custom_orders_table_background_sync", "complete", "2025-06-02 06:45:37", "2025-06-02 06:45:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748846737;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748846737;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-06-02 08:54:48", "2025-06-02 12:24:48", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("281", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-02 10:24:58", "2025-06-02 10:24:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748859898;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748859898;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-02 21:16:49", "2025-06-03 00:46:49", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("279", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-02 08:59:48", "2025-06-02 08:59:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748854788;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748854788;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-02 10:19:58", "2025-06-02 13:49:58", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("280", "woocommerce_custom_orders_table_background_sync", "complete", "2025-06-02 09:54:48", "2025-06-02 09:54:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748858088;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748858088;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-06-02 10:19:58", "2025-06-02 13:49:58", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("282", "woocommerce_custom_orders_table_background_sync", "complete", "2025-06-02 11:19:58", "2025-06-02 11:19:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748863198;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748863198;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-06-02 21:16:49", "2025-06-03 00:46:49", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("285", "woocommerce_cleanup_draft_orders", "complete", "2025-06-03 21:16:49", "2025-06-03 21:16:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748985409;s:18:\"\0*\0first_timestamp\";i:1742090881;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748985409;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-06-03 21:18:30", "2025-06-04 00:48:30", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("286", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-03 07:30:36", "2025-06-03 07:30:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748935836;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748935836;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-03 21:18:30", "2025-06-04 00:48:30", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("287", "woocommerce_custom_orders_table_background_sync", "complete", "2025-06-03 08:25:36", "2025-06-03 08:25:36", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748939136;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748939136;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-06-03 21:18:30", "2025-06-04 00:48:30", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("290", "woocommerce_cleanup_draft_orders", "complete", "2025-06-04 21:18:30", "2025-06-04 21:18:30", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749071910;s:18:\"\0*\0first_timestamp\";i:1742090881;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749071910;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-06-05 11:17:09", "2025-06-05 14:47:09", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("301", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-07 11:53:22", "2025-06-07 11:53:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749297202;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749297202;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-07 11:54:22", "2025-06-07 15:24:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("302", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-07 11:59:22", "2025-06-07 11:59:22", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749297562;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749297562;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-07 12:00:26", "2025-06-07 15:30:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("303", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-07 12:05:26", "2025-06-07 12:05:26", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749297926;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749297926;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-07 12:06:29", "2025-06-07 15:36:29", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("304", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-07 12:11:29", "2025-06-07 12:11:29", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749298289;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749298289;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-07 12:12:31", "2025-06-07 15:42:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("305", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-07 12:17:31", "2025-06-07 12:17:31", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749298651;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749298651;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-07 12:18:34", "2025-06-07 15:48:34", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("306", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-07 12:23:34", "2025-06-07 12:23:34", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749299014;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749299014;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-07 12:24:37", "2025-06-07 15:54:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("307", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-07 12:29:37", "2025-06-07 12:29:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749299377;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749299377;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-07 12:34:43", "2025-06-07 16:04:43", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("308", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-07 12:39:43", "2025-06-07 12:39:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749299983;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749299983;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-07 12:40:45", "2025-06-07 16:10:45", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("309", "woocommerce_custom_orders_table_background_sync", "complete", "2025-06-07 13:36:43", "2025-06-07 13:36:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749303403;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749303403;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-06-07 13:37:13", "2025-06-07 17:07:13", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("310", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-07 12:45:45", "2025-06-07 12:45:45", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749300345;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749300345;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-07 12:47:00", "2025-06-07 16:17:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("311", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-07 12:52:00", "2025-06-07 12:52:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749300720;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749300720;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-07 12:52:52", "2025-06-07 16:22:52", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("312", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-07 12:57:52", "2025-06-07 12:57:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749301072;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749301072;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-07 12:58:54", "2025-06-07 16:28:54", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("313", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-07 13:03:54", "2025-06-07 13:03:54", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749301434;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749301434;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-07 13:04:58", "2025-06-07 16:34:58", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("314", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-07 13:09:58", "2025-06-07 13:09:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749301798;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749301798;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-07 13:11:00", "2025-06-07 16:41:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("315", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-07 13:16:00", "2025-06-07 13:16:00", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749302160;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749302160;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-07 13:17:03", "2025-06-07 16:47:03", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("316", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-07 13:22:03", "2025-06-07 13:22:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749302523;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749302523;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-07 13:23:06", "2025-06-07 16:53:06", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("317", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-07 13:28:06", "2025-06-07 13:28:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749302886;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749302886;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-07 13:29:09", "2025-06-07 16:59:09", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("318", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-07 13:34:09", "2025-06-07 13:34:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749303249;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749303249;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-07 13:35:12", "2025-06-07 17:05:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("319", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-07 13:40:12", "2025-06-07 13:40:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749303612;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749303612;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-07 13:41:15", "2025-06-07 17:11:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("320", "woocommerce_custom_orders_table_background_sync", "complete", "2025-06-07 14:37:13", "2025-06-07 14:37:13", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749307033;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749307033;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-06-07 14:48:09", "2025-06-07 18:18:09", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("321", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-07 13:46:15", "2025-06-07 13:46:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749303975;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749303975;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-07 13:46:18", "2025-06-07 17:16:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("322", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-07 13:51:18", "2025-06-07 13:51:18", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749304278;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749304278;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-07 14:07:39", "2025-06-07 17:37:39", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("323", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-07 14:12:39", "2025-06-07 14:12:39", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749305559;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749305559;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-07 14:13:49", "2025-06-07 17:43:49", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("324", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-07 14:18:49", "2025-06-07 14:18:49", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749305929;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749305929;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-07 14:19:52", "2025-06-07 17:49:52", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("325", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-07 14:24:52", "2025-06-07 14:24:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749306292;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749306292;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-07 14:35:44", "2025-06-07 18:05:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("326", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-07 14:40:44", "2025-06-07 14:40:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749307244;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749307244;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-07 14:48:09", "2025-06-07 18:18:09", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("327", "woocommerce_custom_orders_table_background_sync", "complete", "2025-06-07 15:48:09", "2025-06-07 15:48:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749311289;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749311289;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-06-08 07:53:19", "2025-06-08 11:23:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("328", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-07 14:53:09", "2025-06-07 14:53:09", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749307989;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749307989;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-08 07:53:19", "2025-06-08 11:23:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("334", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-09 08:54:43", "2025-06-09 08:54:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749459283;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749459283;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-10 07:24:55", "2025-06-10 10:54:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("335", "woocommerce_custom_orders_table_background_sync", "complete", "2025-06-09 09:49:43", "2025-06-09 09:49:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749462583;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749462583;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-06-10 07:24:55", "2025-06-10 10:54:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("336", "woocommerce_cleanup_draft_orders", "complete", "2025-06-10 08:49:43", "2025-06-10 08:49:43", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749545383;s:18:\"\0*\0first_timestamp\";i:1742090881;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749545383;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "3", "1", "2025-06-10 15:24:01", "2025-06-10 18:54:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("339", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-10 07:54:41", "2025-06-10 07:54:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749542081;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749542081;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-10 07:59:02", "2025-06-10 11:29:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("337", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-10 07:29:55", "2025-06-10 07:29:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749540595;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749540595;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-10 07:49:41", "2025-06-10 11:19:41", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("338", "woocommerce_custom_orders_table_background_sync", "complete", "2025-06-10 08:24:55", "2025-06-10 08:24:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749543895;s:18:\"\0*\0first_timestamp\";i:1743863812;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749543895;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "3", "1", "2025-06-10 15:24:01", "2025-06-10 18:54:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("340", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-10 08:04:02", "2025-06-10 08:04:02", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749542642;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749542642;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-10 15:24:01", "2025-06-10 18:54:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("347", "woocommerce_run_update_callback", "complete", "2025-06-10 15:29:01", "2025-06-10 15:29:01", "10", "{\"update_callback\":\"wc_update_990_remove_wc_count_comments_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749569341;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749569341;}", "4", "1", "2025-06-10 15:29:37", "2025-06-10 18:59:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("348", "woocommerce_run_update_callback", "complete", "2025-06-10 15:29:02", "2025-06-10 15:29:02", "10", "{\"update_callback\":\"wc_update_990_remove_email_notes\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749569342;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749569342;}", "4", "1", "2025-06-10 15:29:37", "2025-06-10 18:59:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("349", "woocommerce_update_db_to_current_version", "complete", "2025-06-10 15:29:03", "2025-06-10 15:29:03", "10", "{\"version\":\"9.9.3\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749569343;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749569343;}", "4", "1", "2025-06-10 15:29:37", "2025-06-10 18:59:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("350", "woocommerce_run_product_attribute_lookup_regeneration_callback", "complete", "2025-06-10 15:29:00", "2025-06-10 15:29:00", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749569340;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749569340;}", "4", "1", "2025-06-10 15:29:37", "2025-06-10 18:59:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("351", "woocommerce_run_on_woocommerce_admin_updated", "complete", "2025-06-10 15:28:59", "2025-06-10 15:28:59", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749569339;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749569339;}", "8", "1", "2025-06-10 15:29:37", "2025-06-10 18:59:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("352", "woocommerce_refresh_order_count_cache", "pending", "2025-06-11 03:29:01", "2025-06-11 03:29:01", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749612541;s:18:\"\0*\0first_timestamp\";i:1749612541;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749612541;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("353", "action_scheduler/migration_hook", "complete", "2025-06-10 15:30:03", "2025-06-10 15:30:03", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749569403;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749569403;}", "2", "1", "2025-06-10 15:30:41", "2025-06-10 19:00:41", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("355", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-10 15:40:03", "2025-06-10 15:40:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749570003;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749570003;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-10 15:40:52", "2025-06-10 19:10:52", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("354", "image-optimization/cleanup/stuck-operation", "complete", "2025-06-10 15:34:37", "2025-06-10 15:34:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749569677;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749569677;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "1", "2025-06-10 15:35:03", "2025-06-10 19:05:03", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("356", "image-optimization/cleanup/stuck-operation", "pending", "2025-06-10 15:45:52", "2025-06-10 15:45:52", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749570352;s:18:\"\0*\0first_timestamp\";i:1746644954;s:13:\"\0*\0recurrence\";i:300;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749570352;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:300;}", "7", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "image-optimization/migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "woocommerce-db-updates");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "wc-admin-data");
INSERT INTO `wp_actionscheduler_groups` VALUES("6", "wc_batch_processes");
INSERT INTO `wp_actionscheduler_groups` VALUES("7", "image-optimization/cleanup");
INSERT INTO `wp_actionscheduler_groups` VALUES("8", "woocommerce-remote-inbox-engine");
INSERT INTO `wp_actionscheduler_groups` VALUES("9", "count");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("587", "202", "عملیات توسط Async Request کامل شد", "2025-05-17 16:24:10", "2025-05-17 16:24:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("588", "205", "ایجاد فعالیت", "2025-05-17 16:24:10", "2025-05-17 16:24:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("589", "203", "عملیات توسط Async Request شروع شد", "2025-05-17 16:24:10", "2025-05-17 16:24:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("590", "203", "عملیات توسط Async Request کامل شد", "2025-05-17 16:24:10", "2025-05-17 16:24:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("609", "212", "ایجاد فعالیت", "2025-05-19 17:24:38", "2025-05-19 17:24:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("591", "206", "ایجاد فعالیت", "2025-05-17 16:24:10", "2025-05-17 16:24:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("17", "14", "action created", "2025-03-16 02:09:02", "2025-03-16 02:09:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("18", "14", "action started via Async Request", "2025-03-16 02:10:04", "2025-03-16 02:10:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("19", "14", "action failed via Async Request: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2025-03-16 02:10:04", "2025-03-16 02:10:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("608", "209", "عملیات توسط Async Request کامل شد", "2025-05-19 17:24:38", "2025-05-19 17:24:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("23", "16", "action created", "2025-03-17 20:22:32", "2025-03-17 20:22:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("25", "16", "action started via Async Request", "2025-03-17 20:22:32", "2025-03-17 20:22:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("26", "16", "action failed via Async Request: Scheduled action for woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications will not be executed as no callbacks are registered.", "2025-03-17 20:22:32", "2025-03-17 20:22:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("602", "207", "عملیات توسط Async Request کامل شد", "2025-05-19 17:24:38", "2025-05-19 17:24:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("603", "210", "ایجاد فعالیت", "2025-05-19 17:24:38", "2025-05-19 17:24:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("601", "207", "عملیات توسط Async Request شروع شد", "2025-05-19 17:24:38", "2025-05-19 17:24:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("646", "222", "عملیات توسط Async Request شروع شد", "2025-05-21 15:15:01", "2025-05-21 15:15:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("707", "243", "عملیات توسط Async Request کامل شد", "2025-05-26 21:19:23", "2025-05-26 21:19:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("759", "262", "ایجاد فعالیت", "2025-05-30 16:02:07", "2025-05-30 16:02:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("722", "248", "عملیات توسط Async Request کامل شد", "2025-05-28 08:48:57", "2025-05-28 08:48:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("756", "261", "ایجاد فعالیت", "2025-05-30 16:02:07", "2025-05-30 16:02:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("757", "252", "عملیات توسط Async Request شروع شد", "2025-05-30 16:02:07", "2025-05-30 16:02:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("763", "261", "عملیات توسط Async Request شروع شد", "2025-05-31 10:20:41", "2025-05-31 10:20:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("752", "258", "عملیات توسط Async Request کامل شد", "2025-05-30 16:02:07", "2025-05-30 16:02:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("787", "270", "عملیات توسط Async Request شروع شد", "2025-06-01 06:22:45", "2025-06-01 06:22:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("770", "265", "عملیات توسط Async Request کامل شد", "2025-05-31 18:26:52", "2025-05-31 18:26:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("838", "287", "عملیات توسط Async Request شروع شد", "2025-06-03 21:18:30", "2025-06-03 21:18:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("821", "281", "عملیات توسط Async Request کامل شد", "2025-06-02 21:16:49", "2025-06-02 21:16:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("858", "295", "ایجاد فعالیت", "2025-06-05 11:17:09", "2025-06-05 11:17:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("864", "297", "ایجاد فعالیت", "2025-06-06 20:27:28", "2025-06-06 20:27:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("865", "295", "عملیات توسط Async Request شروع شد", "2025-06-06 20:27:28", "2025-06-06 20:27:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("869", "296", "عملیات توسط Async Request کامل شد", "2025-06-07 11:36:24", "2025-06-07 11:36:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("871", "297", "عملیات توسط Async Request شروع شد", "2025-06-07 11:36:24", "2025-06-07 11:36:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("969", "332", "ایجاد فعالیت", "2025-06-08 21:12:41", "2025-06-08 21:12:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("970", "330", "عملیات توسط Async Request شروع شد", "2025-06-08 21:12:41", "2025-06-08 21:12:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("971", "330", "عملیات توسط Async Request کامل شد", "2025-06-08 21:12:41", "2025-06-08 21:12:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("1006", "347", "ایجاد فعالیت", "2025-06-10 15:28:59", "2025-06-10 15:28:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("480", "169", "ایجاد فعالیت", "2025-05-10 08:01:15", "2025-05-10 08:01:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("1002", "343", "ایجاد فعالیت", "2025-06-10 15:24:01", "2025-06-10 15:24:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1003", "344", "ایجاد فعالیت", "2025-06-10 15:28:45", "2025-06-10 15:28:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1004", "345", "ایجاد فعالیت", "2025-06-10 15:28:59", "2025-06-10 15:28:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1005", "346", "ایجاد فعالیت", "2025-06-10 15:28:59", "2025-06-10 15:28:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("996", "341", "ایجاد فعالیت", "2025-06-10 15:24:01", "2025-06-10 15:24:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("997", "338", "عملیات توسط Async Request شروع شد", "2025-06-10 15:24:01", "2025-06-10 15:24:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("998", "338", "عملیات توسط Async Request کامل شد", "2025-06-10 15:24:01", "2025-06-10 15:24:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("999", "342", "ایجاد فعالیت", "2025-06-10 15:24:01", "2025-06-10 15:24:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1000", "336", "عملیات توسط Async Request شروع شد", "2025-06-10 15:24:01", "2025-06-10 15:24:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("496", "173", "عملیات توسط Async Request شروع شد", "2025-05-11 05:56:42", "2025-05-11 05:56:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("1001", "336", "عملیات توسط Async Request کامل شد", "2025-06-10 15:24:01", "2025-06-10 15:24:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("488", "170", "عملیات توسط Async Request کامل شد", "2025-05-10 16:57:52", "2025-05-10 16:57:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("487", "170", "عملیات توسط Async Request شروع شد", "2025-05-10 16:57:52", "2025-05-10 16:57:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("497", "173", "عملیات توسط Async Request کامل شد", "2025-05-11 05:56:42", "2025-05-11 05:56:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("494", "172", "عملیات توسط Async Request کامل شد", "2025-05-11 05:56:42", "2025-05-11 05:56:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("493", "172", "عملیات توسط Async Request شروع شد", "2025-05-11 05:56:42", "2025-05-11 05:56:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("495", "174", "ایجاد فعالیت", "2025-05-11 05:56:42", "2025-05-11 05:56:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("520", "181", "عملیات توسط Async Request شروع شد", "2025-05-13 06:11:01", "2025-05-13 06:11:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("512", "178", "عملیات توسط Async Request کامل شد", "2025-05-12 16:01:38", "2025-05-12 16:01:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("511", "178", "عملیات توسط Async Request شروع شد", "2025-05-12 16:01:38", "2025-05-12 16:01:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("510", "179", "ایجاد فعالیت", "2025-05-12 16:01:38", "2025-05-12 16:01:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("509", "169", "عملیات توسط Async Request کامل شد", "2025-05-12 16:01:38", "2025-05-12 16:01:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("508", "169", "عملیات توسط Async Request شروع شد", "2025-05-12 16:01:38", "2025-05-12 16:01:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("518", "180", "عملیات توسط Async Request کامل شد", "2025-05-13 06:11:01", "2025-05-13 06:11:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("517", "180", "عملیات توسط Async Request شروع شد", "2025-05-13 06:11:00", "2025-05-13 06:11:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("536", "187", "عملیات توسط Async Request کامل شد", "2025-05-13 08:46:04", "2025-05-13 08:46:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("519", "182", "ایجاد فعالیت", "2025-05-13 06:11:01", "2025-05-13 06:11:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("553", "191", "عملیات توسط Async Request شروع شد", "2025-05-15 08:33:53", "2025-05-15 08:33:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("535", "187", "عملیات توسط Async Request شروع شد", "2025-05-13 08:46:04", "2025-05-13 08:46:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("542", "188", "عملیات توسط Async Request کامل شد", "2025-05-15 06:52:42", "2025-05-15 06:52:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("541", "188", "عملیات توسط Async Request شروع شد", "2025-05-15 06:52:41", "2025-05-15 06:52:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("551", "190", "عملیات توسط Async Request کامل شد", "2025-05-15 07:52:02", "2025-05-15 07:52:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("550", "190", "عملیات توسط Async Request شروع شد", "2025-05-15 07:52:02", "2025-05-15 07:52:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("560", "195", "عملیات توسط Async Request کامل شد", "2025-05-15 09:32:33", "2025-05-15 09:32:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("552", "193", "ایجاد فعالیت", "2025-05-15 07:52:02", "2025-05-15 07:52:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("580", "200", "عملیات توسط Async Request شروع شد", "2025-05-16 19:26:19", "2025-05-16 19:26:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("559", "195", "عملیات توسط Async Request شروع شد", "2025-05-15 09:32:32", "2025-05-15 09:32:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("565", "196", "عملیات توسط Async Request شروع شد", "2025-05-15 17:51:04", "2025-05-15 17:51:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("564", "197", "ایجاد فعالیت", "2025-05-15 17:51:04", "2025-05-15 17:51:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("563", "194", "عملیات توسط Async Request کامل شد", "2025-05-15 17:51:04", "2025-05-15 17:51:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("562", "194", "عملیات توسط Async Request شروع شد", "2025-05-15 17:51:04", "2025-05-15 17:51:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("578", "201", "عملیات توسط Async Request کامل شد", "2025-05-16 19:26:19", "2025-05-16 19:26:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("577", "201", "عملیات توسط Async Request شروع شد", "2025-05-16 19:26:19", "2025-05-16 19:26:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("579", "202", "ایجاد فعالیت", "2025-05-16 19:26:19", "2025-05-16 19:26:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("586", "202", "عملیات توسط Async Request شروع شد", "2025-05-17 16:24:10", "2025-05-17 16:24:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("606", "211", "ایجاد فعالیت", "2025-05-19 17:24:38", "2025-05-19 17:24:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("607", "209", "عملیات توسط Async Request شروع شد", "2025-05-19 17:24:38", "2025-05-19 17:24:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("604", "208", "عملیات توسط Async Request شروع شد", "2025-05-19 17:24:38", "2025-05-19 17:24:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("605", "208", "عملیات توسط Async Request کامل شد", "2025-05-19 17:24:38", "2025-05-19 17:24:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("648", "225", "ایجاد فعالیت", "2025-05-21 15:15:01", "2025-05-21 15:15:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("647", "222", "عملیات توسط Async Request کامل شد", "2025-05-21 15:15:01", "2025-05-21 15:15:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("652", "225", "عملیات توسط Async Request شروع شد", "2025-05-22 20:48:41", "2025-05-22 20:48:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("645", "224", "ایجاد فعالیت", "2025-05-21 15:15:01", "2025-05-21 15:15:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("644", "221", "عملیات توسط Async Request کامل شد", "2025-05-21 15:15:01", "2025-05-21 15:15:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("643", "221", "عملیات توسط Async Request شروع شد", "2025-05-21 15:15:01", "2025-05-21 15:15:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("653", "225", "عملیات توسط Async Request کامل شد", "2025-05-22 20:48:41", "2025-05-22 20:48:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("650", "224", "عملیات توسط Async Request کامل شد", "2025-05-22 20:48:41", "2025-05-22 20:48:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("649", "224", "عملیات توسط Async Request شروع شد", "2025-05-22 20:48:41", "2025-05-22 20:48:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("674", "231", "عملیات توسط Async Request کامل شد", "2025-05-24 12:23:04", "2025-05-24 12:23:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("651", "226", "ایجاد فعالیت", "2025-05-22 20:48:41", "2025-05-22 20:48:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("671", "228", "عملیات توسط Async Request کامل شد", "2025-05-24 08:37:23", "2025-05-24 08:37:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("673", "231", "عملیات توسط Async Request شروع شد", "2025-05-24 12:23:04", "2025-05-24 12:23:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("672", "233", "ایجاد فعالیت", "2025-05-24 08:37:23", "2025-05-24 08:37:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("669", "232", "ایجاد فعالیت", "2025-05-24 08:37:23", "2025-05-24 08:37:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("668", "230", "عملیات توسط Async Request کامل شد", "2025-05-24 08:37:23", "2025-05-24 08:37:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("667", "230", "عملیات توسط Async Request شروع شد", "2025-05-24 08:37:23", "2025-05-24 08:37:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("670", "228", "عملیات توسط Async Request شروع شد", "2025-05-24 08:37:23", "2025-05-24 08:37:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("688", "237", "عملیات توسط Async Request شروع شد", "2025-05-25 15:01:05", "2025-05-25 15:01:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("666", "231", "ایجاد فعالیت", "2025-05-24 08:37:23", "2025-05-24 08:37:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("665", "229", "عملیات توسط Async Request کامل شد", "2025-05-24 08:37:23", "2025-05-24 08:37:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("664", "229", "عملیات توسط Async Request شروع شد", "2025-05-24 08:37:23", "2025-05-24 08:37:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("686", "236", "عملیات توسط Async Request کامل شد", "2025-05-25 15:01:05", "2025-05-25 15:01:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("685", "236", "عملیات توسط Async Request شروع شد", "2025-05-25 15:01:05", "2025-05-25 15:01:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("695", "238", "عملیات توسط Async Request کامل شد", "2025-05-25 16:55:42", "2025-05-25 16:55:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("687", "238", "ایجاد فعالیت", "2025-05-25 15:01:05", "2025-05-25 15:01:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("694", "238", "عملیات توسط Async Request شروع شد", "2025-05-25 16:55:42", "2025-05-25 16:55:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("714", "247", "ایجاد فعالیت", "2025-05-26 21:19:23", "2025-05-26 21:19:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("713", "240", "عملیات توسط Async Request کامل شد", "2025-05-26 21:19:23", "2025-05-26 21:19:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("711", "246", "ایجاد فعالیت", "2025-05-26 21:19:23", "2025-05-26 21:19:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("712", "240", "عملیات توسط Async Request شروع شد", "2025-05-26 21:19:23", "2025-05-26 21:19:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("724", "249", "عملیات توسط Async Request شروع شد", "2025-05-28 08:48:57", "2025-05-28 08:48:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("710", "244", "عملیات توسط Async Request کامل شد", "2025-05-26 21:19:23", "2025-05-26 21:19:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("709", "244", "عملیات توسط Async Request شروع شد", "2025-05-26 21:19:23", "2025-05-26 21:19:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("708", "245", "ایجاد فعالیت", "2025-05-26 21:19:23", "2025-05-26 21:19:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("706", "243", "عملیات توسط Async Request شروع شد", "2025-05-26 21:19:23", "2025-05-26 21:19:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("725", "249", "عملیات توسط Async Request کامل شد", "2025-05-28 08:48:57", "2025-05-28 08:48:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("721", "248", "عملیات توسط Async Request شروع شد", "2025-05-28 08:48:57", "2025-05-28 08:48:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("723", "250", "ایجاد فعالیت", "2025-05-28 08:48:57", "2025-05-28 08:48:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("758", "252", "عملیات توسط Async Request کامل شد", "2025-05-30 16:02:07", "2025-05-30 16:02:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("754", "259", "عملیات توسط Async Request شروع شد", "2025-05-30 16:02:07", "2025-05-30 16:02:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("755", "259", "عملیات توسط Async Request کامل شد", "2025-05-30 16:02:07", "2025-05-30 16:02:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("751", "258", "عملیات توسط Async Request شروع شد", "2025-05-30 16:02:07", "2025-05-30 16:02:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("753", "260", "ایجاد فعالیت", "2025-05-30 16:02:07", "2025-05-30 16:02:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("785", "269", "عملیات توسط Async Request کامل شد", "2025-06-01 06:22:45", "2025-06-01 06:22:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("762", "263", "ایجاد فعالیت", "2025-05-31 10:20:41", "2025-05-31 10:20:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("761", "260", "عملیات توسط Async Request کامل شد", "2025-05-31 10:20:41", "2025-05-31 10:20:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("760", "260", "عملیات توسط Async Request شروع شد", "2025-05-31 10:20:41", "2025-05-31 10:20:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("772", "264", "عملیات توسط Async Request شروع شد", "2025-05-31 18:26:52", "2025-05-31 18:26:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("771", "266", "ایجاد فعالیت", "2025-05-31 18:26:52", "2025-05-31 18:26:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("769", "265", "عملیات توسط Async Request شروع شد", "2025-05-31 18:26:52", "2025-05-31 18:26:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("784", "269", "عملیات توسط Async Request شروع شد", "2025-06-01 06:22:45", "2025-06-01 06:22:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("823", "282", "عملیات توسط Async Request شروع شد", "2025-06-02 21:16:49", "2025-06-02 21:16:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("786", "271", "ایجاد فعالیت", "2025-06-01 06:22:45", "2025-06-01 06:22:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("797", "268", "عملیات توسط Async Request کامل شد", "2025-06-01 19:05:22", "2025-06-01 19:05:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("796", "268", "عملیات توسط Async Request شروع شد", "2025-06-01 19:05:22", "2025-06-01 19:05:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("795", "274", "ایجاد فعالیت", "2025-06-01 19:05:22", "2025-06-01 19:05:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("794", "272", "عملیات توسط Async Request کامل شد", "2025-06-01 19:05:22", "2025-06-01 19:05:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("793", "272", "عملیات توسط Async Request شروع شد", "2025-06-01 19:05:22", "2025-06-01 19:05:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("792", "273", "ایجاد فعالیت", "2025-06-01 19:05:22", "2025-06-01 19:05:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("790", "271", "عملیات توسط Async Request شروع شد", "2025-06-01 19:05:22", "2025-06-01 19:05:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("791", "271", "عملیات توسط Async Request کامل شد", "2025-06-01 19:05:22", "2025-06-01 19:05:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("820", "281", "عملیات توسط Async Request شروع شد", "2025-06-02 21:16:49", "2025-06-02 21:16:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("822", "283", "ایجاد فعالیت", "2025-06-02 21:16:49", "2025-06-02 21:16:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("847", "289", "عملیات توسط Async Request شروع شد", "2025-06-04 10:53:51", "2025-06-04 10:53:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("837", "288", "ایجاد فعالیت", "2025-06-03 21:18:30", "2025-06-03 21:18:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("836", "286", "عملیات توسط Async Request کامل شد", "2025-06-03 21:18:30", "2025-06-03 21:18:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("835", "286", "عملیات توسط Async Request شروع شد", "2025-06-03 21:18:30", "2025-06-03 21:18:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("845", "288", "عملیات توسط Async Request کامل شد", "2025-06-04 10:53:51", "2025-06-04 10:53:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("844", "288", "عملیات توسط Async Request شروع شد", "2025-06-04 10:53:51", "2025-06-04 10:53:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("846", "291", "ایجاد فعالیت", "2025-06-04 10:53:51", "2025-06-04 10:53:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("855", "294", "ایجاد فعالیت", "2025-06-05 11:17:09", "2025-06-05 11:17:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("856", "290", "عملیات توسط Async Request شروع شد", "2025-06-05 11:17:09", "2025-06-05 11:17:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("857", "290", "عملیات توسط Async Request کامل شد", "2025-06-05 11:17:09", "2025-06-05 11:17:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("853", "292", "عملیات توسط Async Request شروع شد", "2025-06-05 11:17:08", "2025-06-05 11:17:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("854", "292", "عملیات توسط Async Request کامل شد", "2025-06-05 11:17:08", "2025-06-05 11:17:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("862", "294", "عملیات توسط Async Request شروع شد", "2025-06-06 20:27:28", "2025-06-06 20:27:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("852", "293", "ایجاد فعالیت", "2025-06-05 11:17:08", "2025-06-05 11:17:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("851", "291", "عملیات توسط Async Request کامل شد", "2025-06-05 11:17:08", "2025-06-05 11:17:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("850", "291", "عملیات توسط Async Request شروع شد", "2025-06-05 11:17:08", "2025-06-05 11:17:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("867", "298", "ایجاد فعالیت", "2025-06-06 20:27:28", "2025-06-06 20:27:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("866", "295", "عملیات توسط Async Request کامل شد", "2025-06-06 20:27:28", "2025-06-06 20:27:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("863", "294", "عملیات توسط Async Request کامل شد", "2025-06-06 20:27:28", "2025-06-06 20:27:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("860", "293", "عملیات توسط Async Request کامل شد", "2025-06-06 20:27:28", "2025-06-06 20:27:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("859", "293", "عملیات توسط Async Request شروع شد", "2025-06-06 20:27:28", "2025-06-06 20:27:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("870", "299", "ایجاد فعالیت", "2025-06-07 11:36:24", "2025-06-07 11:36:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("861", "296", "ایجاد فعالیت", "2025-06-06 20:27:28", "2025-06-06 20:27:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("868", "296", "عملیات توسط Async Request شروع شد", "2025-06-07 11:36:24", "2025-06-07 11:36:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("963", "330", "ایجاد فعالیت", "2025-06-08 07:53:19", "2025-06-08 07:53:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("964", "298", "عملیات توسط Async Request شروع شد", "2025-06-08 07:53:19", "2025-06-08 07:53:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("965", "298", "عملیات توسط Async Request کامل شد", "2025-06-08 07:53:19", "2025-06-08 07:53:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("966", "331", "ایجاد فعالیت", "2025-06-08 07:53:19", "2025-06-08 07:53:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("962", "327", "عملیات توسط Async Request کامل شد", "2025-06-08 07:53:19", "2025-06-08 07:53:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("961", "327", "عملیات توسط Async Request شروع شد", "2025-06-08 07:53:19", "2025-06-08 07:53:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("960", "329", "ایجاد فعالیت", "2025-06-08 07:53:19", "2025-06-08 07:53:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("959", "328", "عملیات توسط Async Request کامل شد", "2025-06-08 07:53:19", "2025-06-08 07:53:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("958", "328", "عملیات توسط Async Request شروع شد", "2025-06-08 07:53:19", "2025-06-08 07:53:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("972", "333", "ایجاد فعالیت", "2025-06-08 21:12:41", "2025-06-08 21:12:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("968", "329", "عملیات توسط Async Request کامل شد", "2025-06-08 21:12:41", "2025-06-08 21:12:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("967", "329", "عملیات توسط Async Request شروع شد", "2025-06-08 21:12:40", "2025-06-08 21:12:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("483", "170", "ایجاد فعالیت", "2025-05-10 11:08:52", "2025-05-10 11:08:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("995", "340", "عملیات توسط Async Request کامل شد", "2025-06-10 15:24:01", "2025-06-10 15:24:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("994", "340", "عملیات توسط Async Request شروع شد", "2025-06-10 15:24:00", "2025-06-10 15:24:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("486", "171", "ایجاد فعالیت", "2025-05-10 11:08:52", "2025-05-10 11:08:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("489", "172", "ایجاد فعالیت", "2025-05-10 16:57:52", "2025-05-10 16:57:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("490", "171", "عملیات توسط Async Request شروع شد", "2025-05-10 16:57:52", "2025-05-10 16:57:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("491", "171", "عملیات توسط Async Request کامل شد", "2025-05-10 16:57:52", "2025-05-10 16:57:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("492", "173", "ایجاد فعالیت", "2025-05-10 16:57:52", "2025-05-10 16:57:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("498", "175", "ایجاد فعالیت", "2025-05-11 05:56:42", "2025-05-11 05:56:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("499", "174", "عملیات توسط Async Request شروع شد", "2025-05-11 07:20:14", "2025-05-11 07:20:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("500", "174", "عملیات توسط Async Request کامل شد", "2025-05-11 07:20:15", "2025-05-11 07:20:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("501", "176", "ایجاد فعالیت", "2025-05-11 07:20:15", "2025-05-11 07:20:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("502", "175", "عملیات توسط Async Request شروع شد", "2025-05-11 07:20:15", "2025-05-11 07:20:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("503", "175", "عملیات توسط Async Request کامل شد", "2025-05-11 07:20:15", "2025-05-11 07:20:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("504", "177", "ایجاد فعالیت", "2025-05-11 07:20:15", "2025-05-11 07:20:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("505", "176", "عملیات توسط Async Request شروع شد", "2025-05-11 07:57:02", "2025-05-11 07:57:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("506", "176", "عملیات توسط Async Request کامل شد", "2025-05-11 07:57:02", "2025-05-11 07:57:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("507", "178", "ایجاد فعالیت", "2025-05-11 07:57:02", "2025-05-11 07:57:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("513", "180", "ایجاد فعالیت", "2025-05-12 16:01:38", "2025-05-12 16:01:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("514", "177", "عملیات توسط Async Request شروع شد", "2025-05-12 16:01:38", "2025-05-12 16:01:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("515", "177", "عملیات توسط Async Request کامل شد", "2025-05-12 16:01:38", "2025-05-12 16:01:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("516", "181", "ایجاد فعالیت", "2025-05-12 16:01:38", "2025-05-12 16:01:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("521", "181", "عملیات توسط Async Request کامل شد", "2025-05-13 06:11:01", "2025-05-13 06:11:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("522", "183", "ایجاد فعالیت", "2025-05-13 06:11:01", "2025-05-13 06:11:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("523", "182", "عملیات توسط Async Request شروع شد", "2025-05-13 06:16:30", "2025-05-13 06:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("524", "182", "عملیات توسط Async Request کامل شد", "2025-05-13 06:16:30", "2025-05-13 06:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("525", "184", "ایجاد فعالیت", "2025-05-13 06:16:30", "2025-05-13 06:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("526", "184", "عملیات توسط Async Request شروع شد", "2025-05-13 06:21:41", "2025-05-13 06:21:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("527", "184", "عملیات توسط Async Request کامل شد", "2025-05-13 06:21:41", "2025-05-13 06:21:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("528", "185", "ایجاد فعالیت", "2025-05-13 06:21:41", "2025-05-13 06:21:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("529", "186", "ایجاد فعالیت", "2025-05-13 06:25:59", "2025-05-13 06:25:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("530", "185", "عملیات توسط Async Request شروع شد", "2025-05-13 06:27:05", "2025-05-13 06:27:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("531", "185", "عملیات توسط Async Request کامل شد", "2025-05-13 06:27:05", "2025-05-13 06:27:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("532", "187", "ایجاد فعالیت", "2025-05-13 06:27:05", "2025-05-13 06:27:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("533", "186", "عملیات توسط Async Request شروع شد", "2025-05-13 06:27:05", "2025-05-13 06:27:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("534", "186", "عملیات توسط Async Request کامل شد", "2025-05-13 06:27:05", "2025-05-13 06:27:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("537", "188", "ایجاد فعالیت", "2025-05-13 08:46:04", "2025-05-13 08:46:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("538", "183", "عملیات توسط Async Request شروع شد", "2025-05-13 08:46:04", "2025-05-13 08:46:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("539", "183", "عملیات توسط Async Request کامل شد", "2025-05-13 08:46:04", "2025-05-13 08:46:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("540", "189", "ایجاد فعالیت", "2025-05-13 08:46:04", "2025-05-13 08:46:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("543", "190", "ایجاد فعالیت", "2025-05-15 06:52:42", "2025-05-15 06:52:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("544", "189", "عملیات توسط Async Request شروع شد", "2025-05-15 06:52:42", "2025-05-15 06:52:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("545", "189", "عملیات توسط Async Request کامل شد", "2025-05-15 06:52:42", "2025-05-15 06:52:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("546", "191", "ایجاد فعالیت", "2025-05-15 06:52:42", "2025-05-15 06:52:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("547", "179", "عملیات توسط Async Request شروع شد", "2025-05-15 06:52:42", "2025-05-15 06:52:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("548", "179", "عملیات توسط Async Request کامل شد", "2025-05-15 06:52:42", "2025-05-15 06:52:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("549", "192", "ایجاد فعالیت", "2025-05-15 06:52:42", "2025-05-15 06:52:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("554", "191", "عملیات توسط Async Request کامل شد", "2025-05-15 08:33:53", "2025-05-15 08:33:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("555", "194", "ایجاد فعالیت", "2025-05-15 08:33:53", "2025-05-15 08:33:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("556", "193", "عملیات توسط Async Request شروع شد", "2025-05-15 08:33:53", "2025-05-15 08:33:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("557", "193", "عملیات توسط Async Request کامل شد", "2025-05-15 08:33:53", "2025-05-15 08:33:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("558", "195", "ایجاد فعالیت", "2025-05-15 08:33:53", "2025-05-15 08:33:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("561", "196", "ایجاد فعالیت", "2025-05-15 09:32:33", "2025-05-15 09:32:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("566", "196", "عملیات توسط Async Request کامل شد", "2025-05-15 17:51:04", "2025-05-15 17:51:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("567", "198", "ایجاد فعالیت", "2025-05-15 17:51:04", "2025-05-15 17:51:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("568", "198", "عملیات توسط Async Request شروع شد", "2025-05-16 05:12:48", "2025-05-16 05:12:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("569", "198", "عملیات توسط Async Request کامل شد", "2025-05-16 05:12:48", "2025-05-16 05:12:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("570", "199", "ایجاد فعالیت", "2025-05-16 05:12:48", "2025-05-16 05:12:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("571", "197", "عملیات توسط Async Request شروع شد", "2025-05-16 05:12:48", "2025-05-16 05:12:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("572", "197", "عملیات توسط Async Request کامل شد", "2025-05-16 05:12:48", "2025-05-16 05:12:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("573", "200", "ایجاد فعالیت", "2025-05-16 05:12:48", "2025-05-16 05:12:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("574", "199", "عملیات توسط Async Request شروع شد", "2025-05-16 05:28:52", "2025-05-16 05:28:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("575", "199", "عملیات توسط Async Request کامل شد", "2025-05-16 05:28:52", "2025-05-16 05:28:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("576", "201", "ایجاد فعالیت", "2025-05-16 05:28:52", "2025-05-16 05:28:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("581", "200", "عملیات توسط Async Request کامل شد", "2025-05-16 19:26:19", "2025-05-16 19:26:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("582", "203", "ایجاد فعالیت", "2025-05-16 19:26:19", "2025-05-16 19:26:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("583", "192", "عملیات توسط Async Request شروع شد", "2025-05-16 19:26:19", "2025-05-16 19:26:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("584", "192", "عملیات توسط Async Request کامل شد", "2025-05-16 19:26:19", "2025-05-16 19:26:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("585", "204", "ایجاد فعالیت", "2025-05-16 19:26:19", "2025-05-16 19:26:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("592", "205", "عملیات توسط Async Request شروع شد", "2025-05-18 09:42:42", "2025-05-18 09:42:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("593", "205", "عملیات توسط Async Request کامل شد", "2025-05-18 09:42:42", "2025-05-18 09:42:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("594", "207", "ایجاد فعالیت", "2025-05-18 09:42:42", "2025-05-18 09:42:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("595", "206", "عملیات توسط Async Request شروع شد", "2025-05-18 09:42:42", "2025-05-18 09:42:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("596", "206", "عملیات توسط Async Request کامل شد", "2025-05-18 09:42:42", "2025-05-18 09:42:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("597", "208", "ایجاد فعالیت", "2025-05-18 09:42:42", "2025-05-18 09:42:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("598", "204", "عملیات توسط Async Request شروع شد", "2025-05-18 09:42:42", "2025-05-18 09:42:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("599", "204", "عملیات توسط Async Request کامل شد", "2025-05-18 09:42:42", "2025-05-18 09:42:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("600", "209", "ایجاد فعالیت", "2025-05-18 09:42:42", "2025-05-18 09:42:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("610", "210", "عملیات توسط Async Request شروع شد", "2025-05-19 19:54:24", "2025-05-19 19:54:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("611", "210", "عملیات توسط Async Request کامل شد", "2025-05-19 19:54:24", "2025-05-19 19:54:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("612", "213", "ایجاد فعالیت", "2025-05-19 19:54:24", "2025-05-19 19:54:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("613", "211", "عملیات توسط Async Request شروع شد", "2025-05-19 19:54:24", "2025-05-19 19:54:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("614", "211", "عملیات توسط Async Request کامل شد", "2025-05-19 19:54:24", "2025-05-19 19:54:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("615", "214", "ایجاد فعالیت", "2025-05-19 19:54:24", "2025-05-19 19:54:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("616", "213", "عملیات توسط Async Request شروع شد", "2025-05-20 09:59:56", "2025-05-20 09:59:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("617", "213", "عملیات توسط Async Request کامل شد", "2025-05-20 09:59:56", "2025-05-20 09:59:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("618", "215", "ایجاد فعالیت", "2025-05-20 09:59:56", "2025-05-20 09:59:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("619", "214", "عملیات توسط Async Request شروع شد", "2025-05-20 09:59:56", "2025-05-20 09:59:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("620", "214", "عملیات توسط Async Request کامل شد", "2025-05-20 09:59:56", "2025-05-20 09:59:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("621", "216", "ایجاد فعالیت", "2025-05-20 09:59:56", "2025-05-20 09:59:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("622", "215", "عملیات توسط Async Request شروع شد", "2025-05-20 10:05:07", "2025-05-20 10:05:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("623", "215", "عملیات توسط Async Request کامل شد", "2025-05-20 10:05:07", "2025-05-20 10:05:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("624", "217", "ایجاد فعالیت", "2025-05-20 10:05:07", "2025-05-20 10:05:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("625", "217", "عملیات توسط Async Request شروع شد", "2025-05-20 12:17:23", "2025-05-20 12:17:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("626", "217", "عملیات توسط Async Request کامل شد", "2025-05-20 12:17:23", "2025-05-20 12:17:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("627", "218", "ایجاد فعالیت", "2025-05-20 12:17:24", "2025-05-20 12:17:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("628", "216", "عملیات توسط Async Request شروع شد", "2025-05-20 12:17:24", "2025-05-20 12:17:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("629", "216", "عملیات توسط Async Request کامل شد", "2025-05-20 12:17:24", "2025-05-20 12:17:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("630", "219", "ایجاد فعالیت", "2025-05-20 12:17:24", "2025-05-20 12:17:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("631", "218", "عملیات توسط Async Request شروع شد", "2025-05-20 13:02:30", "2025-05-20 13:02:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("632", "218", "عملیات توسط Async Request کامل شد", "2025-05-20 13:02:30", "2025-05-20 13:02:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("633", "220", "ایجاد فعالیت", "2025-05-20 13:02:30", "2025-05-20 13:02:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("634", "220", "عملیات توسط Async Request شروع شد", "2025-05-21 07:25:17", "2025-05-21 07:25:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("635", "220", "عملیات توسط Async Request کامل شد", "2025-05-21 07:25:17", "2025-05-21 07:25:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("636", "221", "ایجاد فعالیت", "2025-05-21 07:25:17", "2025-05-21 07:25:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("637", "219", "عملیات توسط Async Request شروع شد", "2025-05-21 07:25:17", "2025-05-21 07:25:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("638", "219", "عملیات توسط Async Request کامل شد", "2025-05-21 07:25:17", "2025-05-21 07:25:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("639", "222", "ایجاد فعالیت", "2025-05-21 07:25:17", "2025-05-21 07:25:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("640", "212", "عملیات توسط Async Request شروع شد", "2025-05-21 07:25:17", "2025-05-21 07:25:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("641", "212", "عملیات توسط Async Request کامل شد", "2025-05-21 07:25:17", "2025-05-21 07:25:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("642", "223", "ایجاد فعالیت", "2025-05-21 07:25:17", "2025-05-21 07:25:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("654", "227", "ایجاد فعالیت", "2025-05-22 20:48:41", "2025-05-22 20:48:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("655", "223", "عملیات توسط Async Request شروع شد", "2025-05-22 20:48:41", "2025-05-22 20:48:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("656", "223", "عملیات توسط Async Request کامل شد", "2025-05-22 20:48:41", "2025-05-22 20:48:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("657", "228", "ایجاد فعالیت", "2025-05-22 20:48:41", "2025-05-22 20:48:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("658", "226", "عملیات توسط Async Request شروع شد", "2025-05-23 04:27:36", "2025-05-23 04:27:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("659", "226", "عملیات توسط Async Request کامل شد", "2025-05-23 04:27:36", "2025-05-23 04:27:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("660", "229", "ایجاد فعالیت", "2025-05-23 04:27:36", "2025-05-23 04:27:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("661", "227", "عملیات توسط Async Request شروع شد", "2025-05-23 04:27:36", "2025-05-23 04:27:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("662", "227", "عملیات توسط Async Request کامل شد", "2025-05-23 04:27:36", "2025-05-23 04:27:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("663", "230", "ایجاد فعالیت", "2025-05-23 04:27:36", "2025-05-23 04:27:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("675", "234", "ایجاد فعالیت", "2025-05-24 12:23:04", "2025-05-24 12:23:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("676", "232", "عملیات توسط Async Request شروع شد", "2025-05-24 12:23:04", "2025-05-24 12:23:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("677", "232", "عملیات توسط Async Request کامل شد", "2025-05-24 12:23:04", "2025-05-24 12:23:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("678", "235", "ایجاد فعالیت", "2025-05-24 12:23:04", "2025-05-24 12:23:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("679", "234", "عملیات توسط Async Request شروع شد", "2025-05-25 05:50:47", "2025-05-25 05:50:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("680", "234", "عملیات توسط Async Request کامل شد", "2025-05-25 05:50:47", "2025-05-25 05:50:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("681", "236", "ایجاد فعالیت", "2025-05-25 05:50:47", "2025-05-25 05:50:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("682", "235", "عملیات توسط Async Request شروع شد", "2025-05-25 05:50:47", "2025-05-25 05:50:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("683", "235", "عملیات توسط Async Request کامل شد", "2025-05-25 05:50:47", "2025-05-25 05:50:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("684", "237", "ایجاد فعالیت", "2025-05-25 05:50:47", "2025-05-25 05:50:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("689", "237", "عملیات توسط Async Request کامل شد", "2025-05-25 15:01:05", "2025-05-25 15:01:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("690", "239", "ایجاد فعالیت", "2025-05-25 15:01:05", "2025-05-25 15:01:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("691", "233", "عملیات توسط Async Request شروع شد", "2025-05-25 15:01:05", "2025-05-25 15:01:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("692", "233", "عملیات توسط Async Request کامل شد", "2025-05-25 15:01:05", "2025-05-25 15:01:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("693", "240", "ایجاد فعالیت", "2025-05-25 15:01:05", "2025-05-25 15:01:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("696", "241", "ایجاد فعالیت", "2025-05-25 16:55:42", "2025-05-25 16:55:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("697", "239", "عملیات توسط Async Request شروع شد", "2025-05-25 16:55:42", "2025-05-25 16:55:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("698", "239", "عملیات توسط Async Request کامل شد", "2025-05-25 16:55:42", "2025-05-25 16:55:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("699", "242", "ایجاد فعالیت", "2025-05-25 16:55:42", "2025-05-25 16:55:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("700", "241", "عملیات توسط Async Request شروع شد", "2025-05-26 07:46:36", "2025-05-26 07:46:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("701", "241", "عملیات توسط Async Request کامل شد", "2025-05-26 07:46:37", "2025-05-26 07:46:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("702", "243", "ایجاد فعالیت", "2025-05-26 07:46:37", "2025-05-26 07:46:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("703", "242", "عملیات توسط Async Request شروع شد", "2025-05-26 07:46:37", "2025-05-26 07:46:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("704", "242", "عملیات توسط Async Request کامل شد", "2025-05-26 07:46:37", "2025-05-26 07:46:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("705", "244", "ایجاد فعالیت", "2025-05-26 07:46:37", "2025-05-26 07:46:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("715", "245", "عملیات توسط Async Request شروع شد", "2025-05-27 16:45:50", "2025-05-27 16:45:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("716", "245", "عملیات توسط Async Request کامل شد", "2025-05-27 16:45:50", "2025-05-27 16:45:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("717", "248", "ایجاد فعالیت", "2025-05-27 16:45:50", "2025-05-27 16:45:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("718", "246", "عملیات توسط Async Request شروع شد", "2025-05-27 16:45:50", "2025-05-27 16:45:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("719", "246", "عملیات توسط Async Request کامل شد", "2025-05-27 16:45:50", "2025-05-27 16:45:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("720", "249", "ایجاد فعالیت", "2025-05-27 16:45:50", "2025-05-27 16:45:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("726", "251", "ایجاد فعالیت", "2025-05-28 08:48:57", "2025-05-28 08:48:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("727", "247", "عملیات توسط Async Request شروع شد", "2025-05-28 08:48:57", "2025-05-28 08:48:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("728", "247", "عملیات توسط Async Request کامل شد", "2025-05-28 08:48:57", "2025-05-28 08:48:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("729", "252", "ایجاد فعالیت", "2025-05-28 08:48:57", "2025-05-28 08:48:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("730", "250", "عملیات توسط Async Request شروع شد", "2025-05-28 15:53:57", "2025-05-28 15:53:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("731", "250", "عملیات توسط Async Request کامل شد", "2025-05-28 15:53:58", "2025-05-28 15:53:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("732", "253", "ایجاد فعالیت", "2025-05-28 15:53:58", "2025-05-28 15:53:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("733", "251", "عملیات توسط Async Request شروع شد", "2025-05-28 15:53:58", "2025-05-28 15:53:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("734", "251", "عملیات توسط Async Request کامل شد", "2025-05-28 15:53:58", "2025-05-28 15:53:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("735", "254", "ایجاد فعالیت", "2025-05-28 15:53:58", "2025-05-28 15:53:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("736", "253", "عملیات توسط Async Request شروع شد", "2025-05-28 16:02:58", "2025-05-28 16:02:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("737", "253", "عملیات توسط Async Request کامل شد", "2025-05-28 16:02:58", "2025-05-28 16:02:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("738", "255", "ایجاد فعالیت", "2025-05-28 16:02:58", "2025-05-28 16:02:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("739", "255", "عملیات توسط Async Request شروع شد", "2025-05-28 19:13:27", "2025-05-28 19:13:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("740", "255", "عملیات توسط Async Request کامل شد", "2025-05-28 19:13:27", "2025-05-28 19:13:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("741", "256", "ایجاد فعالیت", "2025-05-28 19:13:27", "2025-05-28 19:13:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("742", "254", "عملیات توسط Async Request شروع شد", "2025-05-28 19:13:27", "2025-05-28 19:13:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("743", "254", "عملیات توسط Async Request کامل شد", "2025-05-28 19:13:27", "2025-05-28 19:13:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("744", "257", "ایجاد فعالیت", "2025-05-28 19:13:27", "2025-05-28 19:13:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("745", "256", "عملیات توسط Async Request شروع شد", "2025-05-29 07:47:47", "2025-05-29 07:47:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("746", "256", "عملیات توسط Async Request کامل شد", "2025-05-29 07:47:48", "2025-05-29 07:47:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("747", "258", "ایجاد فعالیت", "2025-05-29 07:47:48", "2025-05-29 07:47:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("748", "257", "عملیات توسط Async Request شروع شد", "2025-05-29 07:47:48", "2025-05-29 07:47:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("749", "257", "عملیات توسط Async Request کامل شد", "2025-05-29 07:47:48", "2025-05-29 07:47:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("750", "259", "ایجاد فعالیت", "2025-05-29 07:47:48", "2025-05-29 07:47:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("764", "261", "عملیات توسط Async Request کامل شد", "2025-05-31 10:20:41", "2025-05-31 10:20:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("765", "264", "ایجاد فعالیت", "2025-05-31 10:20:41", "2025-05-31 10:20:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("766", "263", "عملیات توسط Async Request شروع شد", "2025-05-31 10:29:32", "2025-05-31 10:29:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("767", "263", "عملیات توسط Async Request کامل شد", "2025-05-31 10:29:32", "2025-05-31 10:29:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("768", "265", "ایجاد فعالیت", "2025-05-31 10:29:32", "2025-05-31 10:29:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("773", "264", "عملیات توسط Async Request کامل شد", "2025-05-31 18:26:52", "2025-05-31 18:26:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("774", "267", "ایجاد فعالیت", "2025-05-31 18:26:52", "2025-05-31 18:26:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("775", "262", "عملیات توسط Async Request شروع شد", "2025-05-31 18:26:52", "2025-05-31 18:26:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("776", "262", "عملیات توسط Async Request کامل شد", "2025-05-31 18:26:52", "2025-05-31 18:26:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("777", "268", "ایجاد فعالیت", "2025-05-31 18:26:52", "2025-05-31 18:26:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("778", "266", "عملیات توسط Async Request شروع شد", "2025-05-31 19:54:02", "2025-05-31 19:54:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("779", "266", "عملیات توسط Async Request کامل شد", "2025-05-31 19:54:02", "2025-05-31 19:54:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("780", "269", "ایجاد فعالیت", "2025-05-31 19:54:02", "2025-05-31 19:54:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("781", "267", "عملیات توسط Async Request شروع شد", "2025-05-31 19:54:02", "2025-05-31 19:54:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("782", "267", "عملیات توسط Async Request کامل شد", "2025-05-31 19:54:02", "2025-05-31 19:54:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("783", "270", "ایجاد فعالیت", "2025-05-31 19:54:02", "2025-05-31 19:54:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("788", "270", "عملیات توسط Async Request کامل شد", "2025-06-01 06:22:45", "2025-06-01 06:22:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("789", "272", "ایجاد فعالیت", "2025-06-01 06:22:45", "2025-06-01 06:22:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("798", "275", "ایجاد فعالیت", "2025-06-01 19:05:22", "2025-06-01 19:05:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("799", "273", "عملیات توسط Async Request شروع شد", "2025-06-02 05:45:36", "2025-06-02 05:45:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("800", "273", "عملیات توسط Async Request کامل شد", "2025-06-02 05:45:37", "2025-06-02 05:45:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("801", "276", "ایجاد فعالیت", "2025-06-02 05:45:37", "2025-06-02 05:45:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("802", "274", "عملیات توسط Async Request شروع شد", "2025-06-02 05:45:37", "2025-06-02 05:45:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("803", "274", "عملیات توسط Async Request کامل شد", "2025-06-02 05:45:37", "2025-06-02 05:45:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("804", "277", "ایجاد فعالیت", "2025-06-02 05:45:37", "2025-06-02 05:45:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("805", "276", "عملیات توسط Async Request شروع شد", "2025-06-02 06:08:53", "2025-06-02 06:08:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("806", "276", "عملیات توسط Async Request کامل شد", "2025-06-02 06:08:54", "2025-06-02 06:08:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("807", "278", "ایجاد فعالیت", "2025-06-02 06:08:54", "2025-06-02 06:08:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("808", "278", "عملیات توسط Async Request شروع شد", "2025-06-02 08:54:48", "2025-06-02 08:54:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("809", "278", "عملیات توسط Async Request کامل شد", "2025-06-02 08:54:48", "2025-06-02 08:54:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("810", "279", "ایجاد فعالیت", "2025-06-02 08:54:48", "2025-06-02 08:54:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("811", "277", "عملیات توسط Async Request شروع شد", "2025-06-02 08:54:48", "2025-06-02 08:54:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("812", "277", "عملیات توسط Async Request کامل شد", "2025-06-02 08:54:48", "2025-06-02 08:54:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("813", "280", "ایجاد فعالیت", "2025-06-02 08:54:48", "2025-06-02 08:54:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("814", "279", "عملیات توسط Async Request شروع شد", "2025-06-02 10:19:57", "2025-06-02 10:19:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("815", "279", "عملیات توسط Async Request کامل شد", "2025-06-02 10:19:58", "2025-06-02 10:19:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("816", "281", "ایجاد فعالیت", "2025-06-02 10:19:58", "2025-06-02 10:19:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("817", "280", "عملیات توسط Async Request شروع شد", "2025-06-02 10:19:58", "2025-06-02 10:19:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("818", "280", "عملیات توسط Async Request کامل شد", "2025-06-02 10:19:58", "2025-06-02 10:19:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("819", "282", "ایجاد فعالیت", "2025-06-02 10:19:58", "2025-06-02 10:19:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("824", "282", "عملیات توسط Async Request کامل شد", "2025-06-02 21:16:49", "2025-06-02 21:16:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("825", "284", "ایجاد فعالیت", "2025-06-02 21:16:49", "2025-06-02 21:16:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("826", "275", "عملیات توسط Async Request شروع شد", "2025-06-02 21:16:49", "2025-06-02 21:16:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("827", "275", "عملیات توسط Async Request کامل شد", "2025-06-02 21:16:49", "2025-06-02 21:16:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("828", "285", "ایجاد فعالیت", "2025-06-02 21:16:49", "2025-06-02 21:16:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("829", "283", "عملیات توسط Async Request شروع شد", "2025-06-03 07:25:36", "2025-06-03 07:25:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("830", "283", "عملیات توسط Async Request کامل شد", "2025-06-03 07:25:36", "2025-06-03 07:25:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("831", "286", "ایجاد فعالیت", "2025-06-03 07:25:36", "2025-06-03 07:25:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("832", "284", "عملیات توسط Async Request شروع شد", "2025-06-03 07:25:36", "2025-06-03 07:25:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("833", "284", "عملیات توسط Async Request کامل شد", "2025-06-03 07:25:36", "2025-06-03 07:25:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("834", "287", "ایجاد فعالیت", "2025-06-03 07:25:36", "2025-06-03 07:25:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("839", "287", "عملیات توسط Async Request کامل شد", "2025-06-03 21:18:30", "2025-06-03 21:18:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("840", "289", "ایجاد فعالیت", "2025-06-03 21:18:30", "2025-06-03 21:18:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("841", "285", "عملیات توسط Async Request شروع شد", "2025-06-03 21:18:30", "2025-06-03 21:18:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("842", "285", "عملیات توسط Async Request کامل شد", "2025-06-03 21:18:30", "2025-06-03 21:18:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("843", "290", "ایجاد فعالیت", "2025-06-03 21:18:30", "2025-06-03 21:18:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("848", "289", "عملیات توسط Async Request کامل شد", "2025-06-04 10:53:51", "2025-06-04 10:53:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("849", "292", "ایجاد فعالیت", "2025-06-04 10:53:51", "2025-06-04 10:53:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("872", "297", "عملیات توسط Async Request کامل شد", "2025-06-07 11:36:24", "2025-06-07 11:36:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("873", "300", "ایجاد فعالیت", "2025-06-07 11:36:24", "2025-06-07 11:36:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("874", "299", "عملیات توسط Async Request شروع شد", "2025-06-07 11:48:22", "2025-06-07 11:48:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("875", "299", "عملیات توسط Async Request کامل شد", "2025-06-07 11:48:22", "2025-06-07 11:48:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("876", "301", "ایجاد فعالیت", "2025-06-07 11:48:22", "2025-06-07 11:48:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("877", "301", "عملیات توسط Async Request شروع شد", "2025-06-07 11:54:22", "2025-06-07 11:54:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("878", "301", "عملیات توسط Async Request کامل شد", "2025-06-07 11:54:22", "2025-06-07 11:54:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("879", "302", "ایجاد فعالیت", "2025-06-07 11:54:22", "2025-06-07 11:54:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("880", "302", "عملیات توسط Async Request شروع شد", "2025-06-07 12:00:25", "2025-06-07 12:00:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("881", "302", "عملیات توسط Async Request کامل شد", "2025-06-07 12:00:26", "2025-06-07 12:00:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("882", "303", "ایجاد فعالیت", "2025-06-07 12:00:26", "2025-06-07 12:00:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("883", "303", "عملیات توسط Async Request شروع شد", "2025-06-07 12:06:28", "2025-06-07 12:06:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("884", "303", "عملیات توسط Async Request کامل شد", "2025-06-07 12:06:29", "2025-06-07 12:06:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("885", "304", "ایجاد فعالیت", "2025-06-07 12:06:29", "2025-06-07 12:06:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("886", "304", "عملیات توسط Async Request شروع شد", "2025-06-07 12:12:31", "2025-06-07 12:12:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("887", "304", "عملیات توسط Async Request کامل شد", "2025-06-07 12:12:31", "2025-06-07 12:12:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("888", "305", "ایجاد فعالیت", "2025-06-07 12:12:31", "2025-06-07 12:12:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("889", "305", "عملیات توسط Async Request شروع شد", "2025-06-07 12:18:34", "2025-06-07 12:18:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("890", "305", "عملیات توسط Async Request کامل شد", "2025-06-07 12:18:34", "2025-06-07 12:18:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("891", "306", "ایجاد فعالیت", "2025-06-07 12:18:34", "2025-06-07 12:18:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("892", "306", "عملیات توسط Async Request شروع شد", "2025-06-07 12:24:37", "2025-06-07 12:24:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("893", "306", "عملیات توسط Async Request کامل شد", "2025-06-07 12:24:37", "2025-06-07 12:24:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("894", "307", "ایجاد فعالیت", "2025-06-07 12:24:37", "2025-06-07 12:24:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("895", "307", "عملیات توسط Async Request شروع شد", "2025-06-07 12:34:43", "2025-06-07 12:34:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("896", "307", "عملیات توسط Async Request کامل شد", "2025-06-07 12:34:43", "2025-06-07 12:34:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("897", "308", "ایجاد فعالیت", "2025-06-07 12:34:43", "2025-06-07 12:34:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("898", "300", "عملیات توسط Async Request شروع شد", "2025-06-07 12:36:43", "2025-06-07 12:36:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("899", "300", "عملیات توسط Async Request کامل شد", "2025-06-07 12:36:43", "2025-06-07 12:36:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("900", "309", "ایجاد فعالیت", "2025-06-07 12:36:43", "2025-06-07 12:36:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("901", "308", "عملیات توسط Async Request شروع شد", "2025-06-07 12:40:45", "2025-06-07 12:40:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("902", "308", "عملیات توسط Async Request کامل شد", "2025-06-07 12:40:45", "2025-06-07 12:40:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("903", "310", "ایجاد فعالیت", "2025-06-07 12:40:45", "2025-06-07 12:40:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("904", "310", "عملیات توسط Async Request شروع شد", "2025-06-07 12:47:00", "2025-06-07 12:47:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("905", "310", "عملیات توسط Async Request کامل شد", "2025-06-07 12:47:00", "2025-06-07 12:47:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("906", "311", "ایجاد فعالیت", "2025-06-07 12:47:00", "2025-06-07 12:47:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("907", "311", "عملیات توسط Async Request شروع شد", "2025-06-07 12:52:52", "2025-06-07 12:52:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("908", "311", "عملیات توسط Async Request کامل شد", "2025-06-07 12:52:52", "2025-06-07 12:52:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("909", "312", "ایجاد فعالیت", "2025-06-07 12:52:52", "2025-06-07 12:52:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("910", "312", "عملیات توسط Async Request شروع شد", "2025-06-07 12:58:54", "2025-06-07 12:58:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("911", "312", "عملیات توسط Async Request کامل شد", "2025-06-07 12:58:54", "2025-06-07 12:58:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("912", "313", "ایجاد فعالیت", "2025-06-07 12:58:54", "2025-06-07 12:58:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("913", "313", "عملیات توسط Async Request شروع شد", "2025-06-07 13:04:57", "2025-06-07 13:04:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("914", "313", "عملیات توسط Async Request کامل شد", "2025-06-07 13:04:58", "2025-06-07 13:04:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("915", "314", "ایجاد فعالیت", "2025-06-07 13:04:58", "2025-06-07 13:04:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("916", "314", "عملیات توسط Async Request شروع شد", "2025-06-07 13:11:00", "2025-06-07 13:11:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("917", "314", "عملیات توسط Async Request کامل شد", "2025-06-07 13:11:00", "2025-06-07 13:11:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("918", "315", "ایجاد فعالیت", "2025-06-07 13:11:00", "2025-06-07 13:11:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("919", "315", "عملیات توسط Async Request شروع شد", "2025-06-07 13:17:03", "2025-06-07 13:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("920", "315", "عملیات توسط Async Request کامل شد", "2025-06-07 13:17:03", "2025-06-07 13:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("921", "316", "ایجاد فعالیت", "2025-06-07 13:17:03", "2025-06-07 13:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("922", "316", "عملیات توسط Async Request شروع شد", "2025-06-07 13:23:06", "2025-06-07 13:23:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("923", "316", "عملیات توسط Async Request کامل شد", "2025-06-07 13:23:06", "2025-06-07 13:23:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("924", "317", "ایجاد فعالیت", "2025-06-07 13:23:06", "2025-06-07 13:23:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("925", "317", "عملیات توسط Async Request شروع شد", "2025-06-07 13:29:09", "2025-06-07 13:29:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("926", "317", "عملیات توسط Async Request کامل شد", "2025-06-07 13:29:09", "2025-06-07 13:29:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("927", "318", "ایجاد فعالیت", "2025-06-07 13:29:09", "2025-06-07 13:29:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("928", "318", "عملیات توسط Async Request شروع شد", "2025-06-07 13:35:12", "2025-06-07 13:35:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("929", "318", "عملیات توسط Async Request کامل شد", "2025-06-07 13:35:12", "2025-06-07 13:35:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("930", "319", "ایجاد فعالیت", "2025-06-07 13:35:12", "2025-06-07 13:35:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("931", "309", "عملیات توسط Async Request شروع شد", "2025-06-07 13:37:13", "2025-06-07 13:37:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("932", "309", "عملیات توسط Async Request کامل شد", "2025-06-07 13:37:13", "2025-06-07 13:37:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("933", "320", "ایجاد فعالیت", "2025-06-07 13:37:13", "2025-06-07 13:37:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("934", "319", "عملیات توسط Async Request شروع شد", "2025-06-07 13:41:15", "2025-06-07 13:41:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("935", "319", "عملیات توسط Async Request کامل شد", "2025-06-07 13:41:15", "2025-06-07 13:41:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("936", "321", "ایجاد فعالیت", "2025-06-07 13:41:15", "2025-06-07 13:41:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("937", "321", "عملیات توسط Async Request شروع شد", "2025-06-07 13:46:18", "2025-06-07 13:46:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("938", "321", "عملیات توسط Async Request کامل شد", "2025-06-07 13:46:18", "2025-06-07 13:46:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("939", "322", "ایجاد فعالیت", "2025-06-07 13:46:18", "2025-06-07 13:46:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("940", "322", "عملیات توسط Async Request شروع شد", "2025-06-07 14:07:39", "2025-06-07 14:07:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("941", "322", "عملیات توسط Async Request کامل شد", "2025-06-07 14:07:39", "2025-06-07 14:07:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("942", "323", "ایجاد فعالیت", "2025-06-07 14:07:39", "2025-06-07 14:07:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("943", "323", "عملیات توسط Async Request شروع شد", "2025-06-07 14:13:49", "2025-06-07 14:13:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("944", "323", "عملیات توسط Async Request کامل شد", "2025-06-07 14:13:49", "2025-06-07 14:13:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("945", "324", "ایجاد فعالیت", "2025-06-07 14:13:49", "2025-06-07 14:13:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("946", "324", "عملیات توسط Async Request شروع شد", "2025-06-07 14:19:52", "2025-06-07 14:19:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("947", "324", "عملیات توسط Async Request کامل شد", "2025-06-07 14:19:52", "2025-06-07 14:19:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("948", "325", "ایجاد فعالیت", "2025-06-07 14:19:52", "2025-06-07 14:19:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("949", "325", "عملیات توسط Async Request شروع شد", "2025-06-07 14:35:44", "2025-06-07 14:35:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("950", "325", "عملیات توسط Async Request کامل شد", "2025-06-07 14:35:44", "2025-06-07 14:35:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("951", "326", "ایجاد فعالیت", "2025-06-07 14:35:44", "2025-06-07 14:35:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("952", "320", "عملیات توسط Async Request شروع شد", "2025-06-07 14:48:09", "2025-06-07 14:48:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("953", "320", "عملیات توسط Async Request کامل شد", "2025-06-07 14:48:09", "2025-06-07 14:48:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("954", "327", "ایجاد فعالیت", "2025-06-07 14:48:09", "2025-06-07 14:48:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("955", "326", "عملیات توسط Async Request شروع شد", "2025-06-07 14:48:09", "2025-06-07 14:48:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("956", "326", "عملیات توسط Async Request کامل شد", "2025-06-07 14:48:09", "2025-06-07 14:48:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("957", "328", "ایجاد فعالیت", "2025-06-07 14:48:09", "2025-06-07 14:48:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("973", "332", "عملیات توسط Async Request شروع شد", "2025-06-09 08:49:43", "2025-06-09 08:49:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("974", "332", "عملیات توسط Async Request کامل شد", "2025-06-09 08:49:43", "2025-06-09 08:49:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("975", "334", "ایجاد فعالیت", "2025-06-09 08:49:43", "2025-06-09 08:49:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("976", "333", "عملیات توسط Async Request شروع شد", "2025-06-09 08:49:43", "2025-06-09 08:49:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("977", "333", "عملیات توسط Async Request کامل شد", "2025-06-09 08:49:43", "2025-06-09 08:49:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("978", "335", "ایجاد فعالیت", "2025-06-09 08:49:43", "2025-06-09 08:49:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("979", "331", "عملیات توسط Async Request شروع شد", "2025-06-09 08:49:43", "2025-06-09 08:49:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("980", "331", "عملیات توسط Async Request کامل شد", "2025-06-09 08:49:43", "2025-06-09 08:49:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("981", "336", "ایجاد فعالیت", "2025-06-09 08:49:43", "2025-06-09 08:49:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("982", "334", "عملیات توسط Async Request شروع شد", "2025-06-10 07:24:54", "2025-06-10 07:24:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("983", "334", "عملیات توسط Async Request کامل شد", "2025-06-10 07:24:55", "2025-06-10 07:24:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("984", "337", "ایجاد فعالیت", "2025-06-10 07:24:55", "2025-06-10 07:24:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("985", "335", "عملیات توسط Async Request شروع شد", "2025-06-10 07:24:55", "2025-06-10 07:24:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("986", "335", "عملیات توسط Async Request کامل شد", "2025-06-10 07:24:55", "2025-06-10 07:24:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("987", "338", "ایجاد فعالیت", "2025-06-10 07:24:55", "2025-06-10 07:24:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("988", "337", "عملیات توسط Async Request شروع شد", "2025-06-10 07:49:41", "2025-06-10 07:49:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("989", "337", "عملیات توسط Async Request کامل شد", "2025-06-10 07:49:41", "2025-06-10 07:49:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("990", "339", "ایجاد فعالیت", "2025-06-10 07:49:41", "2025-06-10 07:49:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("991", "339", "عملیات توسط Async Request شروع شد", "2025-06-10 07:59:02", "2025-06-10 07:59:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("992", "339", "عملیات توسط Async Request کامل شد", "2025-06-10 07:59:02", "2025-06-10 07:59:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("993", "340", "ایجاد فعالیت", "2025-06-10 07:59:02", "2025-06-10 07:59:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1007", "348", "ایجاد فعالیت", "2025-06-10 15:28:59", "2025-06-10 15:28:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1008", "349", "ایجاد فعالیت", "2025-06-10 15:28:59", "2025-06-10 15:28:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1009", "350", "ایجاد فعالیت", "2025-06-10 15:28:59", "2025-06-10 15:28:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1010", "351", "ایجاد فعالیت", "2025-06-10 15:28:59", "2025-06-10 15:28:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1011", "352", "ایجاد فعالیت", "2025-06-10 15:29:01", "2025-06-10 15:29:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1012", "353", "ایجاد فعالیت", "2025-06-10 15:29:03", "2025-06-10 15:29:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1013", "344", "عملیات توسط Async Request شروع شد", "2025-06-10 15:29:36", "2025-06-10 15:29:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("1014", "344", "عملیات توسط Async Request کامل شد", "2025-06-10 15:29:36", "2025-06-10 15:29:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("1015", "345", "عملیات توسط Async Request شروع شد", "2025-06-10 15:29:36", "2025-06-10 15:29:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("1016", "345", "عملیات توسط Async Request کامل شد", "2025-06-10 15:29:36", "2025-06-10 15:29:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("1017", "351", "عملیات توسط Async Request شروع شد", "2025-06-10 15:29:36", "2025-06-10 15:29:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("1018", "351", "عملیات توسط Async Request کامل شد", "2025-06-10 15:29:37", "2025-06-10 15:29:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1019", "346", "عملیات توسط Async Request شروع شد", "2025-06-10 15:29:37", "2025-06-10 15:29:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1020", "346", "عملیات توسط Async Request کامل شد", "2025-06-10 15:29:37", "2025-06-10 15:29:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1021", "350", "عملیات توسط Async Request شروع شد", "2025-06-10 15:29:37", "2025-06-10 15:29:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1022", "350", "عملیات توسط Async Request کامل شد", "2025-06-10 15:29:37", "2025-06-10 15:29:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1023", "341", "عملیات توسط Async Request شروع شد", "2025-06-10 15:29:37", "2025-06-10 15:29:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1024", "341", "عملیات توسط Async Request کامل شد", "2025-06-10 15:29:37", "2025-06-10 15:29:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1025", "354", "ایجاد فعالیت", "2025-06-10 15:29:37", "2025-06-10 15:29:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1026", "347", "عملیات توسط Async Request شروع شد", "2025-06-10 15:29:37", "2025-06-10 15:29:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1027", "347", "عملیات توسط Async Request کامل شد", "2025-06-10 15:29:37", "2025-06-10 15:29:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1028", "348", "عملیات توسط Async Request شروع شد", "2025-06-10 15:29:37", "2025-06-10 15:29:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1029", "348", "عملیات توسط Async Request کامل شد", "2025-06-10 15:29:37", "2025-06-10 15:29:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1030", "349", "عملیات توسط Async Request شروع شد", "2025-06-10 15:29:37", "2025-06-10 15:29:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1031", "349", "عملیات توسط Async Request کامل شد", "2025-06-10 15:29:37", "2025-06-10 15:29:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1032", "353", "عملیات توسط Async Request شروع شد", "2025-06-10 15:30:41", "2025-06-10 15:30:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("1033", "353", "عملیات توسط Async Request کامل شد", "2025-06-10 15:30:41", "2025-06-10 15:30:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("1034", "354", "عملیات توسط Async Request شروع شد", "2025-06-10 15:35:03", "2025-06-10 15:35:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1035", "354", "عملیات توسط Async Request کامل شد", "2025-06-10 15:35:03", "2025-06-10 15:35:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1036", "355", "ایجاد فعالیت", "2025-06-10 15:35:03", "2025-06-10 15:35:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1037", "355", "عملیات توسط Async Request شروع شد", "2025-06-10 15:40:52", "2025-06-10 15:40:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1038", "355", "عملیات توسط Async Request کامل شد", "2025-06-10 15:40:52", "2025-06-10 15:40:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1039", "356", "ایجاد فعالیت", "2025-06-10 15:40:52", "2025-06-10 15:40:52");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "یک نویسنده دیدگاه وردپرس", "wapuu@wordpress.example", "https://fa.wordpress.org/", "", "2025-03-16 05:34:55", "2025-03-16 02:04:55", "سلام، این یک دیدگاه است.\nبرای شروع مدیریت، ویرایش و پاک کردن دیدگاه‌ها، لطفا بخش دیدگاه‌ها در پیشخوان را ببینید.\nتصاویر نویسندگان دیدگاه از <a href=\"https://gravatar.com/\">Gravatar</a> گرفته می‌شود.", "0", "post-trashed", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("2", "479", "ووکامرس", "", "", "", "2025-04-05 13:42:40", "2025-04-05 10:12:40", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- چراغ جلو kmc (#165) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("3", "479", "ووکامرس", "", "", "", "2025-04-05 13:42:40", "2025-04-05 10:12:40", "سطح موجودی کاهش یافت: چراغ جلو kmc (#165) 4&rarr;3", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("4", "479", "ووکامرس", "", "", "", "2025-04-05 13:42:40", "2025-04-05 10:12:40", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("5", "479", "admina", "test@gmail.com", "", "", "2025-04-05 15:35:13", "2025-04-05 12:05:13", "وضعیت سفارش از در انتظار بررسی به تکمیل شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("6", "488", "ووکامرس", "", "", "", "2025-04-05 16:24:53", "2025-04-05 12:54:53", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("7", "488", "admina", "test@gmail.com", "", "", "2025-04-05 16:25:35", "2025-04-05 12:55:35", "وضعیت سفارش از در انتظار بررسی به تکمیل شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("8", "489", "ووکامرس", "", "", "", "2025-04-05 16:29:11", "2025-04-05 12:59:11", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- چراغ جلو kmc (#165) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("9", "489", "ووکامرس", "", "", "", "2025-04-05 16:29:11", "2025-04-05 12:59:11", "سطح موجودی کاهش یافت: چراغ جلو kmc (#165) 3&rarr;2", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("10", "489", "ووکامرس", "", "", "", "2025-04-05 16:29:11", "2025-04-05 12:59:11", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("11", "489", "admina", "test@gmail.com", "", "", "2025-04-05 16:31:24", "2025-04-05 13:01:24", "وضعیت سفارش از در انتظار بررسی به تکمیل شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("12", "490", "ووکامرس", "", "", "", "2025-04-05 16:32:33", "2025-04-05 13:02:33", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- چراغ جلو 207 (#169) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("13", "490", "ووکامرس", "", "", "", "2025-04-05 16:32:33", "2025-04-05 13:02:33", "سطح موجودی کاهش یافت: چراغ جلو 207 (#169) 4&rarr;3", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("14", "490", "ووکامرس", "", "", "", "2025-04-05 16:32:33", "2025-04-05 13:02:33", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("15", "491", "ووکامرس", "", "", "", "2025-04-05 16:45:36", "2025-04-05 13:15:36", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- چراغ جلو 207 (#169) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("16", "491", "ووکامرس", "", "", "", "2025-04-05 16:45:37", "2025-04-05 13:15:37", "سطح موجودی کاهش یافت: چراغ جلو 207 (#169) 3&rarr;2", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("17", "491", "ووکامرس", "", "", "", "2025-04-05 16:45:37", "2025-04-05 13:15:37", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("18", "492", "ووکامرس", "", "", "", "2025-04-05 16:47:35", "2025-04-05 13:17:35", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- چراغ جلو kmc (#165) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("19", "492", "ووکامرس", "", "", "", "2025-04-05 16:47:36", "2025-04-05 13:17:36", "سطح موجودی کاهش یافت: چراغ جلو kmc (#165) 2&rarr;1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("20", "492", "ووکامرس", "", "", "", "2025-04-05 16:47:36", "2025-04-05 13:17:36", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("21", "493", "ووکامرس", "", "", "", "2025-04-05 16:51:37", "2025-04-05 13:21:37", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("22", "494", "ووکامرس", "", "", "", "2025-04-05 16:52:34", "2025-04-05 13:22:34", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("23", "495", "ووکامرس", "", "", "", "2025-04-05 16:55:02", "2025-04-05 13:25:02", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- جلو پنجره فوتون (#149) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("24", "495", "ووکامرس", "", "", "", "2025-04-05 16:55:02", "2025-04-05 13:25:02", "سطح موجودی کاهش یافت: جلو پنجره فوتون (#149) 4&rarr;3", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("25", "495", "ووکامرس", "", "", "", "2025-04-05 16:55:02", "2025-04-05 13:25:02", "وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("26", "495", "admina", "test@gmail.com", "", "", "2025-04-05 17:05:05", "2025-04-05 13:35:05", "وضعیت سفارش از در حال انجام به تکمیل شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("27", "496", "ووکامرس", "", "", "", "2025-04-05 17:05:54", "2025-04-05 13:35:54", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- جلو پنجره فوتون (#149) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("28", "496", "ووکامرس", "", "", "", "2025-04-05 17:05:54", "2025-04-05 13:35:54", "سطح موجودی کاهش یافت: جلو پنجره فوتون (#149) 3&rarr;2", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("29", "496", "ووکامرس", "", "", "", "2025-04-05 17:05:54", "2025-04-05 13:35:54", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("30", "527", "ووکامرس", "", "", "", "2025-05-01 13:05:21", "2025-05-01 09:35:21", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- چراغ جلو 207 (#169) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("31", "527", "ووکامرس", "", "", "", "2025-05-01 13:05:22", "2025-05-01 09:35:22", "سطح موجودی کاهش یافت: چراغ جلو 207 (#169) 2&rarr;1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("32", "527", "ووکامرس", "", "", "", "2025-05-01 13:05:22", "2025-05-01 09:35:22", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("6", "20250330_d8afd985d988d984d988d8a7d8b2d9", "2925cc9489e664bf9755_20250610154457", "21", "2025-06-10 15:45:19", "admina", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-06-10 15:44:57\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.8.1\";s:9:\"VersionDB\";s:7:\"10.6.19\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:6;s:4:\"Name\";s:39:\"20250330_d8afd985d988d984d988d8a7d8b2d9\";s:4:\"Hash\";s:35:\"2925cc9489e664bf9755_20250610154457\";s:8:\"NameHash\";s:75:\"20250330_d8afd985d988d984d988d8a7d8b2d9_2925cc9489e664bf9755_20250610154457\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:85:\"20250330_d8afd985d988d984d988d8a7d8b2d9_2925cc9489e664bf9755_20250610154457_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.1\";s:6:\"WPUser\";s:6:\"admina\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:87:\"20250330_d8afd985d988d984d988d8a7d8b2d9_2925cc9489e664bf9755_20250610154457_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:60:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/spare\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:3032;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:18335;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-06-10 15:44:57\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.8.1\";s:9:\"VersionDB\";s:7:\"10.6.19\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20250330_d8afd985d988d984d988d8a7d8b2d9\";s:4:\"Hash\";s:35:\"2925cc9489e664bf9755_20250610154457\";s:8:\"NameHash\";s:75:\"20250330_d8afd985d988d984d988d8a7d8b2d9_2925cc9489e664bf9755_20250610154457\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:93:\"20250330_d8afd985d988d984d988d8a7d8b2d9_2925cc9489e664bf9755_20250610154457_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:74:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/spare/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:88:\"20250330_d8afd985d988d984d988d8a7d8b2d9_2925cc9489e664bf9755_20250610154457_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:181:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/spare/wp-content/backups-dup-lite/tmp/20250330_d8afd985d988d984d988d8a7d8b2d9_2925cc9489e664bf9755_20250610154457_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:69:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/spare/wp-admin\";i:1;s:72:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/spare/wp-includes\";i:2;s:81:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/spare/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:60:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/spare\";i:1;s:60:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/spare\";i:2;s:71:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/spare/wp-content\";i:3;s:79:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/spare/wp-content/uploads\";i:4;s:79:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/spare/wp-content/plugins\";i:5;s:82:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/spare/wp-content/mu-plugins\";i:6;s:78:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/spare/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:92:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/spare/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "cron", "a:29:{i:1742090695;a:2:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1742090704;a:3:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1742090707;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1742090764;a:1:{s:28:\"wp_update_comment_type_batch\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1742090876;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1742090877;a:2:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1742090879;a:4:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:40:\"woodmart_wishlist_send_promotional_email\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1742090880;a:1:{s:45:\"woocommerce_marketplace_cron_fetch_promotions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1742090886;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1742090887;a:1:{s:30:\"generate_category_lookup_table\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1742094295;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1742096095;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1742097895;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1742177095;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1742244930;a:1:{s:31:\"woocommerce_flush_rewrite_rules\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1743019620;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1743146945;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1743316155;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1743858670;a:1:{s:32:\"connect_hook_send_notif_feedback\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:17:\"every_two_minutes\";s:4:\"args\";a:0:{}s:8:\"interval\";i:120;}}}i:1744293580;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"7378ce546c7910167e088f9493c0db98\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:501;}}}}i:1746644878;a:1:{s:13:\"rsmAutoUpdate\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1747045800;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1749569349;a:2:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1749569399;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}i:1749572939;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1749580139;a:2:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"woocommerce_cleanup_rate_limits\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1749589200;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1749590939;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("2", "siteurl", "https://demoes.aramis-co.ir/spare", "on");
INSERT INTO `wp_options` VALUES("3", "home", "https://demoes.aramis-co.ir/spare", "on");
INSERT INTO `wp_options` VALUES("4", "blogname", "دمو لوازم یدکی وودمارت پلاس", "on");
INSERT INTO `wp_options` VALUES("5", "blogdescription", "", "on");
INSERT INTO `wp_options` VALUES("6", "users_can_register", "0", "on");
INSERT INTO `wp_options` VALUES("7", "admin_email", "devwp98@gmail.com", "on");
INSERT INTO `wp_options` VALUES("8", "start_of_week", "6", "on");
INSERT INTO `wp_options` VALUES("9", "use_balanceTags", "0", "on");
INSERT INTO `wp_options` VALUES("10", "use_smilies", "1", "on");
INSERT INTO `wp_options` VALUES("11", "require_name_email", "1", "on");
INSERT INTO `wp_options` VALUES("12", "comments_notify", "1", "on");
INSERT INTO `wp_options` VALUES("13", "posts_per_rss", "10", "on");
INSERT INTO `wp_options` VALUES("14", "rss_use_excerpt", "0", "on");
INSERT INTO `wp_options` VALUES("15", "mailserver_url", "mail.example.com", "on");
INSERT INTO `wp_options` VALUES("16", "mailserver_login", "login@example.com", "on");
INSERT INTO `wp_options` VALUES("17", "mailserver_pass", "", "on");
INSERT INTO `wp_options` VALUES("18", "mailserver_port", "110", "on");
INSERT INTO `wp_options` VALUES("19", "default_category", "1", "on");
INSERT INTO `wp_options` VALUES("20", "default_comment_status", "open", "on");
INSERT INTO `wp_options` VALUES("21", "default_ping_status", "open", "on");
INSERT INTO `wp_options` VALUES("22", "default_pingback_flag", "0", "on");
INSERT INTO `wp_options` VALUES("23", "posts_per_page", "10", "on");
INSERT INTO `wp_options` VALUES("24", "date_format", "F j, Y", "on");
INSERT INTO `wp_options` VALUES("25", "time_format", "g:i a", "on");
INSERT INTO `wp_options` VALUES("26", "links_updated_date_format", "F j, Y g:i a", "on");
INSERT INTO `wp_options` VALUES("27", "comment_moderation", "0", "on");
INSERT INTO `wp_options` VALUES("28", "moderation_notify", "1", "on");
INSERT INTO `wp_options` VALUES("29", "permalink_structure", "/%year%/%monthnum%/%day%/%postname%/", "on");
INSERT INTO `wp_options` VALUES("30", "rewrite_rules", "a:327:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:21:\"^wc/file/transient/?$\";s:33:\"index.php?wc-transient-file-name=\";s:24:\"^wc/file/transient/(.+)$\";s:44:\"index.php?wc-transient-file-name=$matches[1]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:12:\"portfolio/?$\";s:29:\"index.php?post_type=portfolio\";s:42:\"portfolio/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:37:\"portfolio/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:29:\"portfolio/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=portfolio&paged=$matches[1]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:91:\"^%d8%b9%d9%84%d8%a7%d9%82%d9%87-%d9%85%d9%86%d8%af%db%8c-%d9%87%d8%a7/([^/]*)/page/([^/]*)?\";s:63:\"index.php?page_id=388&wishlist_id=$matches[1]&paged=$matches[2]\";s:83:\"^%d8%b9%d9%84%d8%a7%d9%82%d9%87-%d9%85%d9%86%d8%af%db%8c-%d9%87%d8%a7/page/([^/]*)?\";s:39:\"index.php?page_id=388&paged=$matches[1]\";s:79:\"^%d8%b9%d9%84%d8%a7%d9%82%d9%87-%d9%85%d9%86%d8%af%db%8c-%d9%87%d8%a7/([^/]*)/?\";s:45:\"index.php?page_id=388&wishlist_id=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:43:\"category/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?category_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:40:\"tag/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?tag=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:43:\"woodmart_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"woodmart_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"woodmart_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"woodmart_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"woodmart_layout/([^/]+)/embed/?$\";s:48:\"index.php?woodmart_layout=$matches[1]&embed=true\";s:36:\"woodmart_layout/([^/]+)/trackback/?$\";s:42:\"index.php?woodmart_layout=$matches[1]&tb=1\";s:44:\"woodmart_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?woodmart_layout=$matches[1]&paged=$matches[2]\";s:51:\"woodmart_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?woodmart_layout=$matches[1]&cpage=$matches[2]\";s:52:\"woodmart_layout/([^/]+)/wc/file/transient(/(.*))?/?$\";s:67:\"index.php?woodmart_layout=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"woodmart_layout/([^/]+)/wc-api(/(.*))?/?$\";s:56:\"index.php?woodmart_layout=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_layout/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:69:\"woodmart_layout/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:47:\"woodmart_layout/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_layout/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:40:\"woodmart_layout/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?woodmart_layout=$matches[1]&page=$matches[2]\";s:32:\"woodmart_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"woodmart_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"woodmart_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"woodmart_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:43:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"woodmart_woo_lv/([^/]+)/embed/?$\";s:48:\"index.php?woodmart_woo_lv=$matches[1]&embed=true\";s:36:\"woodmart_woo_lv/([^/]+)/trackback/?$\";s:42:\"index.php?woodmart_woo_lv=$matches[1]&tb=1\";s:44:\"woodmart_woo_lv/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?woodmart_woo_lv=$matches[1]&paged=$matches[2]\";s:51:\"woodmart_woo_lv/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?woodmart_woo_lv=$matches[1]&cpage=$matches[2]\";s:52:\"woodmart_woo_lv/([^/]+)/wc/file/transient(/(.*))?/?$\";s:67:\"index.php?woodmart_woo_lv=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"woodmart_woo_lv/([^/]+)/wc-api(/(.*))?/?$\";s:56:\"index.php?woodmart_woo_lv=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_woo_lv/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:69:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:47:\"woodmart_woo_lv/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:40:\"woodmart_woo_lv/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?woodmart_woo_lv=$matches[1]&page=$matches[2]\";s:32:\"woodmart_woo_lv/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"woodmart_woo_lv/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"woodmart_woo_lv/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_woo_lv/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_woo_lv/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"woodmart_woo_lv/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"woodmart_woo_fbt/([^/]+)/embed/?$\";s:49:\"index.php?woodmart_woo_fbt=$matches[1]&embed=true\";s:37:\"woodmart_woo_fbt/([^/]+)/trackback/?$\";s:43:\"index.php?woodmart_woo_fbt=$matches[1]&tb=1\";s:45:\"woodmart_woo_fbt/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?woodmart_woo_fbt=$matches[1]&paged=$matches[2]\";s:52:\"woodmart_woo_fbt/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?woodmart_woo_fbt=$matches[1]&cpage=$matches[2]\";s:53:\"woodmart_woo_fbt/([^/]+)/wc/file/transient(/(.*))?/?$\";s:68:\"index.php?woodmart_woo_fbt=$matches[1]&wc/file/transient=$matches[3]\";s:42:\"woodmart_woo_fbt/([^/]+)/wc-api(/(.*))?/?$\";s:57:\"index.php?woodmart_woo_fbt=$matches[1]&wc-api=$matches[3]\";s:59:\"woodmart_woo_fbt/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:70:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:48:\"woodmart_woo_fbt/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:59:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:41:\"woodmart_woo_fbt/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?woodmart_woo_fbt=$matches[1]&page=$matches[2]\";s:33:\"woodmart_woo_fbt/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"woodmart_woo_fbt/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"woodmart_woo_fbt/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"woodmart_woo_fbt/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"woodmart_woo_fbt/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"woodmart_woo_fbt/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:54:\"cms_block_cat/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?cms_block_cat=$matches[1]&feed=$matches[2]\";s:49:\"cms_block_cat/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?cms_block_cat=$matches[1]&feed=$matches[2]\";s:30:\"cms_block_cat/([^/]+)/embed/?$\";s:46:\"index.php?cms_block_cat=$matches[1]&embed=true\";s:42:\"cms_block_cat/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?cms_block_cat=$matches[1]&paged=$matches[2]\";s:24:\"cms_block_cat/([^/]+)/?$\";s:35:\"index.php?cms_block_cat=$matches[1]\";s:42:\"woodmart_slide/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"woodmart_slide/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"woodmart_slide/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"woodmart_slide/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"woodmart_slide/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"woodmart_slide/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"woodmart_slide/([^/]+)/embed/?$\";s:47:\"index.php?woodmart_slide=$matches[1]&embed=true\";s:35:\"woodmart_slide/([^/]+)/trackback/?$\";s:41:\"index.php?woodmart_slide=$matches[1]&tb=1\";s:43:\"woodmart_slide/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?woodmart_slide=$matches[1]&paged=$matches[2]\";s:50:\"woodmart_slide/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?woodmart_slide=$matches[1]&cpage=$matches[2]\";s:51:\"woodmart_slide/([^/]+)/wc/file/transient(/(.*))?/?$\";s:66:\"index.php?woodmart_slide=$matches[1]&wc/file/transient=$matches[3]\";s:40:\"woodmart_slide/([^/]+)/wc-api(/(.*))?/?$\";s:55:\"index.php?woodmart_slide=$matches[1]&wc-api=$matches[3]\";s:57:\"woodmart_slide/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:68:\"woodmart_slide/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:46:\"woodmart_slide/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:57:\"woodmart_slide/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:39:\"woodmart_slide/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?woodmart_slide=$matches[1]&page=$matches[2]\";s:31:\"woodmart_slide/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"woodmart_slide/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"woodmart_slide/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"woodmart_slide/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"woodmart_slide/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"woodmart_slide/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:56:\"woodmart_slider/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:68:\"index.php?taxonomy=woodmart_slider&term=$matches[1]&feed=$matches[2]\";s:51:\"woodmart_slider/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:68:\"index.php?taxonomy=woodmart_slider&term=$matches[1]&feed=$matches[2]\";s:32:\"woodmart_slider/([^/]+)/embed/?$\";s:62:\"index.php?taxonomy=woodmart_slider&term=$matches[1]&embed=true\";s:44:\"woodmart_slider/([^/]+)/page/?([0-9]{1,})/?$\";s:69:\"index.php?taxonomy=woodmart_slider&term=$matches[1]&paged=$matches[2]\";s:26:\"woodmart_slider/([^/]+)/?$\";s:51:\"index.php?taxonomy=woodmart_slider&term=$matches[1]\";s:37:\"portfolio/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"portfolio/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:30:\"portfolio/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:50:\"portfolio/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:45:\"portfolio/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:38:\"portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:45:\"portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:46:\"portfolio/([^/]+)/wc/file/transient(/(.*))?/?$\";s:61:\"index.php?portfolio=$matches[1]&wc/file/transient=$matches[3]\";s:35:\"portfolio/([^/]+)/wc-api(/(.*))?/?$\";s:50:\"index.php?portfolio=$matches[1]&wc-api=$matches[3]\";s:52:\"portfolio/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:63:\"portfolio/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"portfolio/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:52:\"portfolio/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:34:\"portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:26:\"portfolio/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"portfolio/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"portfolio/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:50:\"project-cat/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project-cat=$matches[1]&feed=$matches[2]\";s:45:\"project-cat/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project-cat=$matches[1]&feed=$matches[2]\";s:26:\"project-cat/(.+?)/embed/?$\";s:44:\"index.php?project-cat=$matches[1]&embed=true\";s:38:\"project-cat/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?project-cat=$matches[1]&paged=$matches[2]\";s:20:\"project-cat/(.+?)/?$\";s:33:\"index.php?project-cat=$matches[1]\";s:47:\"برند/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:42:\"برند/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:23:\"برند/(.+?)/embed/?$\";s:46:\"index.php?product_brand=$matches[1]&embed=true\";s:35:\"برند/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?product_brand=$matches[1]&paged=$matches[2]\";s:17:\"برند/(.+?)/?$\";s:35:\"index.php?product_brand=$matches[1]\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:44:\"product/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?product=$matches[1]&wc/file/transient=$matches[3]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"product/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=26&cpage=$matches[1]\";s:28:\"wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:37:\"comments/wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:40:\"search/(.+)/wc/file/transient(/(.*))?/?$\";s:53:\"index.php?s=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:43:\"author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?author_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc/file/transient=$matches[5]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:52:\"([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:77:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc/file/transient=$matches[4]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:39:\"([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?year=$matches[1]&wc/file/transient=$matches[3]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:58:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:68:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:88:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:83:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:64:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/embed/?$\";s:91:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/trackback/?$\";s:85:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&tb=1\";s:77:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&feed=$matches[5]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/page/?([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&paged=$matches[5]\";s:72:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/comment-page-([0-9]{1,})/?$\";s:98:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&cpage=$matches[5]\";s:73:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/wc/file/transient(/(.*))?/?$\";s:110:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&wc/file/transient=$matches[6]\";s:62:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)/wc-api(/(.*))?/?$\";s:99:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&wc-api=$matches[6]\";s:73:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:84:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:62:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:73:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:61:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/([^/]+)(?:/([0-9]+))?/?$\";s:97:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&name=$matches[4]&page=$matches[5]\";s:47:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:57:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:77:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:72:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:53:\"[0-9]{4}/[0-9]{1,2}/[0-9]{1,2}/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&cpage=$matches[4]\";s:51:\"([0-9]{4})/([0-9]{1,2})/comment-page-([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&cpage=$matches[3]\";s:38:\"([0-9]{4})/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&cpage=$matches[2]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:36:\"(.?.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?pagename=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:27:\"(.?.+?)/waitlist(/(.*))?/?$\";s:51:\"index.php?pagename=$matches[1]&waitlist=$matches[3]\";s:42:\".?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\".?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";}", "on");
INSERT INTO `wp_options` VALUES("3783", "wcpay_was_in_use", "no", "auto");
INSERT INTO `wp_options` VALUES("7165", "action_scheduler_migration_status", "complete", "auto");
INSERT INTO `wp_options` VALUES("3778", "rtl_rsm_pluginsUpdate", "a:2:{s:4:\"list\";a:0:{}s:9:\"lastCheck\";i:1749580199;}", "off");
INSERT INTO `wp_options` VALUES("1096", "xts-header_228442-file-data", "a:3:{s:4:\"path\";s:41:\"/2025/03/xts-header_228442-1743151594.css\";s:13:\"theme_version\";s:5:\"8.1.1\";s:8:\"site_url\";s:32:\"99503d1d6bed8bf8062fea78189a5fa8\";}", "on");
INSERT INTO `wp_options` VALUES("584", "xts-header_228442-css-data", ":root{\n	--wd-top-bar-h: .00001px;\n	--wd-top-bar-sm-h: 40px;\n	--wd-top-bar-sticky-h: .00001px;\n	--wd-top-bar-brd-w: .00001px;\n\n	--wd-header-general-h: 60px;\n	--wd-header-general-sm-h: 60px;\n	--wd-header-general-sticky-h: .00001px;\n	--wd-header-general-brd-w: .00001px;\n\n	--wd-header-bottom-h: 50px;\n	--wd-header-bottom-sm-h: 50px;\n	--wd-header-bottom-sticky-h: .00001px;\n	--wd-header-bottom-brd-w: .00001px;\n\n	--wd-header-clone-h: .00001px;\n\n	--wd-header-brd-w: calc(var(--wd-top-bar-brd-w) + var(--wd-header-general-brd-w) + var(--wd-header-bottom-brd-w));\n	--wd-header-h: calc(var(--wd-top-bar-h) + var(--wd-header-general-h) + var(--wd-header-bottom-h) + var(--wd-header-brd-w));\n	--wd-header-sticky-h: calc(var(--wd-top-bar-sticky-h) + var(--wd-header-general-sticky-h) + var(--wd-header-bottom-sticky-h) + var(--wd-header-clone-h) + var(--wd-header-brd-w));\n	--wd-header-sm-h: calc(var(--wd-top-bar-sm-h) + var(--wd-header-general-sm-h) + var(--wd-header-bottom-sm-h) + var(--wd-header-brd-w));\n}\n\n\n\n\n\n\n.whb-header-bottom .wd-dropdown {\n	margin-top: 5px;\n}\n\n.whb-header-bottom .wd-dropdown:after {\n	height: 15px;\n}\n\n\n\n		\n.whb-47mq26aomuvud7xa1ge3 form.searchform {\n	--wd-form-height: 46px;\n}", "on");
INSERT INTO `wp_options` VALUES("585", "xts-header_228442-status", "valid", "on");
INSERT INTO `wp_options` VALUES("586", "xts-header_228442-version", "8.2.2", "on");
INSERT INTO `wp_options` VALUES("587", "xts-header_228442-site-url", "99503d1d6bed8bf8062fea78189a5fa8", "on");
INSERT INTO `wp_options` VALUES("588", "whb_header_228442", "a:4:{s:4:\"name\";s:24:\"هدر صفحه اصلی\";s:2:\"id\";s:13:\"header_228442\";s:9:\"structure\";a:3:{s:2:\"id\";s:4:\"root\";s:4:\"type\";s:4:\"root\";s:7:\"content\";a:3:{i:0;a:4:{s:2:\"id\";s:7:\"top-bar\";s:4:\"type\";s:3:\"row\";s:7:\"content\";a:4:{i:0;a:3:{s:2:\"id\";s:7:\"column5\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:1;a:3:{s:2:\"id\";s:7:\"column6\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:2;a:3:{s:2:\"id\";s:7:\"column7\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:3;a:3:{s:2:\"id\";s:14:\"column_mobile1\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}}s:6:\"params\";a:12:{s:11:\"row_columns\";a:3:{s:2:\"id\";s:11:\"row_columns\";s:5:\"value\";s:1:\"3\";s:4:\"type\";s:8:\"selector\";}s:11:\"flex_layout\";a:3:{s:2:\"id\";s:11:\"flex_layout\";s:5:\"value\";s:11:\"flex-middle\";s:4:\"type\";s:8:\"selector\";}s:6:\"height\";a:3:{s:2:\"id\";s:6:\"height\";s:5:\"value\";i:40;s:4:\"type\";s:6:\"slider\";}s:13:\"mobile_height\";a:3:{s:2:\"id\";s:13:\"mobile_height\";s:5:\"value\";i:40;s:4:\"type\";s:6:\"slider\";}s:12:\"hide_desktop\";a:3:{s:2:\"id\";s:12:\"hide_desktop\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:11:\"hide_mobile\";a:3:{s:2:\"id\";s:11:\"hide_mobile\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:6:\"sticky\";a:3:{s:2:\"id\";s:6:\"sticky\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:40;s:4:\"type\";s:6:\"slider\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:4:\"dark\";s:4:\"type\";s:8:\"selector\";}s:10:\"background\";a:3:{s:2:\"id\";s:10:\"background\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:2:\"bg\";}s:6:\"border\";a:3:{s:2:\"id\";s:6:\"border\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"border\";}s:6:\"shadow\";a:3:{s:2:\"id\";s:6:\"shadow\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}}}i:1;a:4:{s:2:\"id\";s:14:\"general-header\";s:4:\"type\";s:3:\"row\";s:7:\"content\";a:6:{i:0;a:3:{s:2:\"id\";s:7:\"column8\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"lgzhih3l6poq36dtw10p\";s:4:\"type\";s:8:\"mainmenu\";s:6:\"params\";a:21:{s:7:\"menu_id\";a:3:{s:2:\"id\";s:7:\"menu_id\";s:5:\"value\";s:43:\"%d9%85%d9%86%d9%88-%d8%a7%d8%b5%d9%84%db%8c\";s:4:\"type\";s:7:\"options\";}s:11:\"full_screen\";a:3:{s:2:\"id\";s:11:\"full_screen\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:4:\"text\";s:4:\"type\";s:8:\"selector\";}s:11:\"icon_design\";a:3:{s:2:\"id\";s:11:\"icon_design\";s:5:\"value\";s:1:\"1\";s:4:\"type\";s:8:\"selector\";}s:9:\"wrap_type\";a:3:{s:2:\"id\";s:9:\"wrap_type\";s:5:\"value\";s:9:\"icon_only\";s:4:\"type\";s:8:\"selector\";}s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:11:\"hover_color\";a:3:{s:2:\"id\";s:11:\"hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:8:\"bg_color\";a:3:{s:2:\"id\";s:8:\"bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:14:\"bg_hover_color\";a:3:{s:2:\"id\";s:14:\"bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:10:\"icon_color\";a:3:{s:2:\"id\";s:10:\"icon_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:16:\"icon_hover_color\";a:3:{s:2:\"id\";s:16:\"icon_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:13:\"icon_bg_color\";a:3:{s:2:\"id\";s:13:\"icon_bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:19:\"icon_bg_hover_color\";a:3:{s:2:\"id\";s:19:\"icon_bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:17:\"custom_icon_width\";a:3:{s:2:\"id\";s:17:\"custom_icon_width\";s:5:\"value\";i:0;s:4:\"type\";s:6:\"slider\";}s:10:\"menu_style\";a:3:{s:2:\"id\";s:10:\"menu_style\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:10:\"menu_align\";a:3:{s:2:\"id\";s:10:\"menu_align\";s:5:\"value\";s:5:\"right\";s:4:\"type\";s:8:\"selector\";}s:9:\"items_gap\";a:3:{s:2:\"id\";s:9:\"items_gap\";s:5:\"value\";s:1:\"s\";s:4:\"type\";s:8:\"selector\";}s:10:\"bg_overlay\";a:3:{s:2:\"id\";s:10:\"bg_overlay\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:6:\"inline\";a:3:{s:2:\"id\";s:6:\"inline\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}}}}}i:1;a:3:{s:2:\"id\";s:7:\"column9\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"cvyzmmaey4pg28awooy6\";s:4:\"type\";s:4:\"logo\";s:6:\"params\";a:6:{s:5:\"image\";a:3:{s:2:\"id\";s:5:\"image\";s:5:\"value\";a:4:{s:2:\"id\";i:87;s:3:\"url\";s:80:\"https://demoes.aramis-co.ir/spare/wp-content/uploads/2025/03/Group-38934-min.png\";s:5:\"width\";i:962;s:6:\"height\";i:430;}s:4:\"type\";s:5:\"image\";}s:5:\"width\";a:3:{s:2:\"id\";s:5:\"width\";s:5:\"value\";s:3:\"115\";s:4:\"type\";s:6:\"slider\";}s:13:\"sticky_notice\";a:3:{s:2:\"id\";s:13:\"sticky_notice\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"notice\";}s:12:\"sticky_image\";a:3:{s:2:\"id\";s:12:\"sticky_image\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:12:\"sticky_width\";a:3:{s:2:\"id\";s:12:\"sticky_width\";s:5:\"value\";i:150;s:4:\"type\";s:6:\"slider\";}s:12:\"width_height\";a:3:{s:2:\"id\";s:12:\"width_height\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}}}}}i:2;a:3:{s:2:\"id\";s:8:\"column10\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:5:{i:0;a:3:{s:2:\"id\";s:20:\"47mq26aomuvud7xa1ge3\";s:4:\"type\";s:6:\"search\";s:6:\"params\";a:30:{s:7:\"display\";a:3:{s:2:\"id\";s:7:\"display\";s:5:\"value\";s:11:\"full-screen\";s:4:\"type\";s:8:\"selector\";}s:16:\"popular_requests\";a:3:{s:2:\"id\";s:16:\"popular_requests\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:19:\"categories_dropdown\";a:3:{s:2:\"id\";s:19:\"categories_dropdown\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:18:\"cat_selector_style\";a:3:{s:2:\"id\";s:18:\"cat_selector_style\";s:5:\"value\";s:8:\"bordered\";s:4:\"type\";s:8:\"selector\";}s:10:\"bg_overlay\";a:3:{s:2:\"id\";s:10:\"bg_overlay\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:4:\"ajax\";a:3:{s:2:\"id\";s:4:\"ajax\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:17:\"ajax_result_count\";a:3:{s:2:\"id\";s:17:\"ajax_result_count\";s:5:\"value\";i:20;s:4:\"type\";s:6:\"slider\";}s:9:\"post_type\";a:3:{s:2:\"id\";s:9:\"post_type\";s:5:\"value\";s:7:\"product\";s:4:\"type\";s:8:\"selector\";}s:12:\"search_style\";a:3:{s:2:\"id\";s:12:\"search_style\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:10:\"form_shape\";a:3:{s:2:\"id\";s:10:\"form_shape\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:7:\"options\";}s:11:\"form_height\";a:3:{s:2:\"id\";s:11:\"form_height\";s:5:\"value\";i:46;s:4:\"type\";s:6:\"slider\";}s:10:\"form_color\";a:3:{s:2:\"id\";s:10:\"form_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:22:\"form_placeholder_color\";a:3:{s:2:\"id\";s:22:\"form_placeholder_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:14:\"form_brd_color\";a:3:{s:2:\"id\";s:14:\"form_brd_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:20:\"form_brd_color_focus\";a:3:{s:2:\"id\";s:20:\"form_brd_color_focus\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:7:\"form_bg\";a:3:{s:2:\"id\";s:7:\"form_bg\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:4:\"icon\";s:4:\"type\";s:8:\"selector\";}s:11:\"icon_design\";a:3:{s:2:\"id\";s:11:\"icon_design\";s:5:\"value\";s:1:\"1\";s:4:\"type\";s:8:\"selector\";}s:9:\"wrap_type\";a:3:{s:2:\"id\";s:9:\"wrap_type\";s:5:\"value\";s:9:\"icon_only\";s:4:\"type\";s:8:\"selector\";}s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:11:\"hover_color\";a:3:{s:2:\"id\";s:11:\"hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:8:\"bg_color\";a:3:{s:2:\"id\";s:8:\"bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:14:\"bg_hover_color\";a:3:{s:2:\"id\";s:14:\"bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:10:\"icon_color\";a:3:{s:2:\"id\";s:10:\"icon_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:16:\"icon_hover_color\";a:3:{s:2:\"id\";s:16:\"icon_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:13:\"icon_bg_color\";a:3:{s:2:\"id\";s:13:\"icon_bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:19:\"icon_bg_hover_color\";a:3:{s:2:\"id\";s:19:\"icon_bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:17:\"custom_icon_width\";a:3:{s:2:\"id\";s:17:\"custom_icon_width\";s:5:\"value\";i:0;s:4:\"type\";s:6:\"slider\";}}}i:1;a:3:{s:2:\"id\";s:20:\"2dyqj126s36rzdzt8of8\";s:4:\"type\";s:7:\"divider\";s:6:\"params\";a:3:{s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:11:\"full_height\";a:3:{s:2:\"id\";s:11:\"full_height\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:9:\"css_class\";a:3:{s:2:\"id\";s:9:\"css_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}i:2;a:3:{s:2:\"id\";s:20:\"5opuva9c8kiugd3u6qrz\";s:4:\"type\";s:4:\"cart\";s:6:\"params\";a:16:{s:8:\"position\";a:3:{s:2:\"id\";s:8:\"position\";s:5:\"value\";s:4:\"side\";s:4:\"type\";s:8:\"selector\";}s:10:\"bg_overlay\";a:3:{s:2:\"id\";s:10:\"bg_overlay\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:6:\"design\";a:3:{s:2:\"id\";s:6:\"design\";s:5:\"value\";s:4:\"icon\";s:4:\"type\";s:8:\"selector\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:1:\"5\";s:4:\"type\";s:8:\"selector\";}s:9:\"wrap_type\";a:3:{s:2:\"id\";s:9:\"wrap_type\";s:5:\"value\";s:9:\"icon_only\";s:4:\"type\";s:8:\"selector\";}s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:11:\"hover_color\";a:3:{s:2:\"id\";s:11:\"hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:8:\"bg_color\";a:3:{s:2:\"id\";s:8:\"bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:14:\"bg_hover_color\";a:3:{s:2:\"id\";s:14:\"bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:10:\"icon_color\";a:3:{s:2:\"id\";s:10:\"icon_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:16:\"icon_hover_color\";a:3:{s:2:\"id\";s:16:\"icon_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:13:\"icon_bg_color\";a:3:{s:2:\"id\";s:13:\"icon_bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:19:\"icon_bg_hover_color\";a:3:{s:2:\"id\";s:19:\"icon_bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:4:\"cart\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:17:\"custom_icon_width\";a:3:{s:2:\"id\";s:17:\"custom_icon_width\";s:5:\"value\";i:0;s:4:\"type\";s:6:\"slider\";}}}i:3;a:3:{s:2:\"id\";s:20:\"ya3jw6cvorl66ss7288e\";s:4:\"type\";s:7:\"divider\";s:6:\"params\";a:3:{s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:11:\"full_height\";a:3:{s:2:\"id\";s:11:\"full_height\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:9:\"css_class\";a:3:{s:2:\"id\";s:9:\"css_class\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}}}i:4;a:3:{s:2:\"id\";s:20:\"ojrw03t454rlxwaeu807\";s:4:\"type\";s:7:\"account\";s:6:\"params\";a:18:{s:13:\"with_username\";a:3:{s:2:\"id\";s:13:\"with_username\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:14:\"login_dropdown\";a:3:{s:2:\"id\";s:14:\"login_dropdown\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:12:\"form_display\";a:3:{s:2:\"id\";s:12:\"form_display\";s:5:\"value\";s:4:\"side\";s:4:\"type\";s:8:\"selector\";}s:7:\"display\";a:3:{s:2:\"id\";s:7:\"display\";s:5:\"value\";s:4:\"text\";s:4:\"type\";s:8:\"selector\";}s:11:\"icon_design\";a:3:{s:2:\"id\";s:11:\"icon_design\";s:5:\"value\";s:1:\"1\";s:4:\"type\";s:8:\"selector\";}s:9:\"wrap_type\";a:3:{s:2:\"id\";s:9:\"wrap_type\";s:5:\"value\";s:9:\"icon_only\";s:4:\"type\";s:8:\"selector\";}s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:11:\"hover_color\";a:3:{s:2:\"id\";s:11:\"hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:8:\"bg_color\";a:3:{s:2:\"id\";s:8:\"bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:14:\"bg_hover_color\";a:3:{s:2:\"id\";s:14:\"bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:10:\"icon_color\";a:3:{s:2:\"id\";s:10:\"icon_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:16:\"icon_hover_color\";a:3:{s:2:\"id\";s:16:\"icon_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:13:\"icon_bg_color\";a:3:{s:2:\"id\";s:13:\"icon_bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:19:\"icon_bg_hover_color\";a:3:{s:2:\"id\";s:19:\"icon_bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:17:\"custom_icon_width\";a:3:{s:2:\"id\";s:17:\"custom_icon_width\";s:5:\"value\";i:0;s:4:\"type\";s:6:\"slider\";}s:10:\"bg_overlay\";a:3:{s:2:\"id\";s:10:\"bg_overlay\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}}}}}i:3;a:3:{s:2:\"id\";s:14:\"column_mobile2\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"p00e860yd867vwihn1fg\";s:4:\"type\";s:6:\"burger\";s:6:\"params\";a:32:{s:9:\"close_btn\";a:3:{s:2:\"id\";s:9:\"close_btn\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:11:\"search_form\";a:3:{s:2:\"id\";s:11:\"search_form\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:9:\"post_type\";a:3:{s:2:\"id\";s:9:\"post_type\";s:5:\"value\";s:7:\"product\";s:4:\"type\";s:8:\"selector\";}s:13:\"show_wishlist\";a:3:{s:2:\"id\";s:13:\"show_wishlist\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:12:\"show_compare\";a:3:{s:2:\"id\";s:12:\"show_compare\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:12:\"show_account\";a:3:{s:2:\"id\";s:12:\"show_account\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:15:\"show_html_block\";a:3:{s:2:\"id\";s:15:\"show_html_block\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:9:\"languages\";a:3:{s:2:\"id\";s:9:\"languages\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:18:\"show_language_flag\";a:3:{s:2:\"id\";s:18:\"show_language_flag\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:15:\"categories_menu\";a:3:{s:2:\"id\";s:15:\"categories_menu\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:18:\"primary_menu_title\";a:3:{s:2:\"id\";s:18:\"primary_menu_title\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:4:\"text\";}s:20:\"secondary_menu_title\";a:3:{s:2:\"id\";s:20:\"secondary_menu_title\";s:5:\"value\";s:32:\"دسته بندی محصولات\";s:4:\"type\";s:4:\"text\";}s:7:\"menu_id\";a:3:{s:2:\"id\";s:7:\"menu_id\";s:5:\"value\";s:62:\"%d8%af%d8%b3%d8%aa%d9%87-%d8%a8%d9%86%d8%af%db%8c-%d9%87%d8%a7\";s:4:\"type\";s:7:\"options\";}s:9:\"tabs_swap\";a:3:{s:2:\"id\";s:9:\"tabs_swap\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:11:\"menu_layout\";a:3:{s:2:\"id\";s:11:\"menu_layout\";s:5:\"value\";s:8:\"dropdown\";s:4:\"type\";s:8:\"selector\";}s:19:\"drilldown_animation\";a:3:{s:2:\"id\";s:19:\"drilldown_animation\";s:5:\"value\";s:5:\"slide\";s:4:\"type\";s:8:\"selector\";}s:22:\"submenu_opening_action\";a:3:{s:2:\"id\";s:22:\"submenu_opening_action\";s:5:\"value\";s:10:\"only_arrow\";s:4:\"type\";s:8:\"selector\";}s:8:\"position\";a:3:{s:2:\"id\";s:8:\"position\";s:5:\"value\";s:4:\"left\";s:4:\"type\";s:8:\"selector\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:4:\"icon\";s:4:\"type\";s:8:\"selector\";}s:11:\"icon_design\";a:3:{s:2:\"id\";s:11:\"icon_design\";s:5:\"value\";s:1:\"1\";s:4:\"type\";s:8:\"selector\";}s:9:\"wrap_type\";a:3:{s:2:\"id\";s:9:\"wrap_type\";s:5:\"value\";s:9:\"icon_only\";s:4:\"type\";s:8:\"selector\";}s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:11:\"hover_color\";a:3:{s:2:\"id\";s:11:\"hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:8:\"bg_color\";a:3:{s:2:\"id\";s:8:\"bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:14:\"bg_hover_color\";a:3:{s:2:\"id\";s:14:\"bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:10:\"icon_color\";a:3:{s:2:\"id\";s:10:\"icon_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:16:\"icon_hover_color\";a:3:{s:2:\"id\";s:16:\"icon_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:13:\"icon_bg_color\";a:3:{s:2:\"id\";s:13:\"icon_bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:19:\"icon_bg_hover_color\";a:3:{s:2:\"id\";s:19:\"icon_bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:7:\"default\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:17:\"custom_icon_width\";a:3:{s:2:\"id\";s:17:\"custom_icon_width\";s:5:\"value\";i:0;s:4:\"type\";s:6:\"slider\";}}}}}i:4;a:3:{s:2:\"id\";s:14:\"column_mobile3\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"s700iqbbwogkd07jo4zm\";s:4:\"type\";s:4:\"logo\";s:6:\"params\";a:6:{s:5:\"image\";a:3:{s:2:\"id\";s:5:\"image\";s:5:\"value\";a:4:{s:2:\"id\";i:87;s:3:\"url\";s:80:\"https://demoes.aramis-co.ir/spare/wp-content/uploads/2025/03/Group-38934-min.png\";s:5:\"width\";i:962;s:6:\"height\";i:430;}s:4:\"type\";s:5:\"image\";}s:5:\"width\";a:3:{s:2:\"id\";s:5:\"width\";s:5:\"value\";i:150;s:4:\"type\";s:6:\"slider\";}s:13:\"sticky_notice\";a:3:{s:2:\"id\";s:13:\"sticky_notice\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"notice\";}s:12:\"sticky_image\";a:3:{s:2:\"id\";s:12:\"sticky_image\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:12:\"sticky_width\";a:3:{s:2:\"id\";s:12:\"sticky_width\";s:5:\"value\";i:150;s:4:\"type\";s:6:\"slider\";}s:12:\"width_height\";a:3:{s:2:\"id\";s:12:\"width_height\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}}}}}i:5;a:3:{s:2:\"id\";s:14:\"column_mobile4\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:1:{i:0;a:3:{s:2:\"id\";s:20:\"b7cdw04yg779gg2hi95y\";s:4:\"type\";s:4:\"cart\";s:6:\"params\";a:16:{s:8:\"position\";a:3:{s:2:\"id\";s:8:\"position\";s:5:\"value\";s:4:\"side\";s:4:\"type\";s:8:\"selector\";}s:10:\"bg_overlay\";a:3:{s:2:\"id\";s:10:\"bg_overlay\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:6:\"design\";a:3:{s:2:\"id\";s:6:\"design\";s:5:\"value\";s:4:\"text\";s:4:\"type\";s:8:\"selector\";}s:5:\"style\";a:3:{s:2:\"id\";s:5:\"style\";s:5:\"value\";s:1:\"6\";s:4:\"type\";s:8:\"selector\";}s:9:\"wrap_type\";a:3:{s:2:\"id\";s:9:\"wrap_type\";s:5:\"value\";s:13:\"icon_and_text\";s:4:\"type\";s:8:\"selector\";}s:5:\"color\";a:3:{s:2:\"id\";s:5:\"color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:11:\"hover_color\";a:3:{s:2:\"id\";s:11:\"hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:8:\"bg_color\";a:3:{s:2:\"id\";s:8:\"bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:14:\"bg_hover_color\";a:3:{s:2:\"id\";s:14:\"bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:10:\"icon_color\";a:3:{s:2:\"id\";s:10:\"icon_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:16:\"icon_hover_color\";a:3:{s:2:\"id\";s:16:\"icon_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:13:\"icon_bg_color\";a:3:{s:2:\"id\";s:13:\"icon_bg_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:19:\"icon_bg_hover_color\";a:3:{s:2:\"id\";s:19:\"icon_bg_hover_color\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"color\";}s:9:\"icon_type\";a:3:{s:2:\"id\";s:9:\"icon_type\";s:5:\"value\";s:4:\"cart\";s:4:\"type\";s:8:\"selector\";}s:11:\"custom_icon\";a:3:{s:2:\"id\";s:11:\"custom_icon\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:5:\"image\";}s:17:\"custom_icon_width\";a:3:{s:2:\"id\";s:17:\"custom_icon_width\";s:5:\"value\";i:0;s:4:\"type\";s:6:\"slider\";}}}}}}s:6:\"params\";a:12:{s:11:\"row_columns\";a:3:{s:2:\"id\";s:11:\"row_columns\";s:5:\"value\";s:1:\"3\";s:4:\"type\";s:8:\"selector\";}s:11:\"flex_layout\";a:3:{s:2:\"id\";s:11:\"flex_layout\";s:5:\"value\";s:11:\"equal-sides\";s:4:\"type\";s:8:\"selector\";}s:6:\"height\";a:3:{s:2:\"id\";s:6:\"height\";s:5:\"value\";i:60;s:4:\"type\";s:6:\"slider\";}s:13:\"mobile_height\";a:3:{s:2:\"id\";s:13:\"mobile_height\";s:5:\"value\";i:60;s:4:\"type\";s:6:\"slider\";}s:12:\"hide_desktop\";a:3:{s:2:\"id\";s:12:\"hide_desktop\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:11:\"hide_mobile\";a:3:{s:2:\"id\";s:11:\"hide_mobile\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:6:\"sticky\";a:3:{s:2:\"id\";s:6:\"sticky\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:60;s:4:\"type\";s:6:\"slider\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:5:\"light\";s:4:\"type\";s:8:\"selector\";}s:10:\"background\";a:3:{s:2:\"id\";s:10:\"background\";s:5:\"value\";a:0:{}s:4:\"type\";s:2:\"bg\";}s:6:\"border\";a:3:{s:2:\"id\";s:6:\"border\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"border\";}s:6:\"shadow\";a:3:{s:2:\"id\";s:6:\"shadow\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}}}i:2;a:4:{s:2:\"id\";s:13:\"header-bottom\";s:4:\"type\";s:3:\"row\";s:7:\"content\";a:4:{i:0;a:3:{s:2:\"id\";s:8:\"column11\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:1;a:3:{s:2:\"id\";s:8:\"column12\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:2;a:3:{s:2:\"id\";s:8:\"column13\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}i:3;a:3:{s:2:\"id\";s:14:\"column_mobile5\";s:4:\"type\";s:6:\"column\";s:7:\"content\";a:0:{}}}s:6:\"params\";a:12:{s:11:\"row_columns\";a:3:{s:2:\"id\";s:11:\"row_columns\";s:5:\"value\";s:1:\"3\";s:4:\"type\";s:8:\"selector\";}s:11:\"flex_layout\";a:3:{s:2:\"id\";s:11:\"flex_layout\";s:5:\"value\";s:11:\"flex-middle\";s:4:\"type\";s:8:\"selector\";}s:6:\"height\";a:3:{s:2:\"id\";s:6:\"height\";s:5:\"value\";i:50;s:4:\"type\";s:6:\"slider\";}s:13:\"mobile_height\";a:3:{s:2:\"id\";s:13:\"mobile_height\";s:5:\"value\";i:50;s:4:\"type\";s:6:\"slider\";}s:12:\"hide_desktop\";a:3:{s:2:\"id\";s:12:\"hide_desktop\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:11:\"hide_mobile\";a:3:{s:2:\"id\";s:11:\"hide_mobile\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:6:\"sticky\";a:3:{s:2:\"id\";s:6:\"sticky\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:50;s:4:\"type\";s:6:\"slider\";}s:12:\"color_scheme\";a:3:{s:2:\"id\";s:12:\"color_scheme\";s:5:\"value\";s:4:\"dark\";s:4:\"type\";s:8:\"selector\";}s:10:\"background\";a:3:{s:2:\"id\";s:10:\"background\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:2:\"bg\";}s:6:\"border\";a:3:{s:2:\"id\";s:6:\"border\";s:5:\"value\";s:0:\"\";s:4:\"type\";s:6:\"border\";}s:6:\"shadow\";a:3:{s:2:\"id\";s:6:\"shadow\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}}}}}s:8:\"settings\";a:9:{s:7:\"overlap\";a:3:{s:2:\"id\";s:7:\"overlap\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:5:\"boxed\";a:3:{s:2:\"id\";s:5:\"boxed\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:10:\"full_width\";a:3:{s:2:\"id\";s:10:\"full_width\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:14:\"dropdowns_dark\";a:3:{s:2:\"id\";s:14:\"dropdowns_dark\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_shadow\";a:3:{s:2:\"id\";s:13:\"sticky_shadow\";s:5:\"value\";b:1;s:4:\"type\";s:8:\"switcher\";}s:14:\"hide_on_scroll\";a:3:{s:2:\"id\";s:14:\"hide_on_scroll\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_effect\";a:3:{s:2:\"id\";s:13:\"sticky_effect\";s:5:\"value\";s:5:\"stick\";s:4:\"type\";s:8:\"selector\";}s:12:\"sticky_clone\";a:3:{s:2:\"id\";s:12:\"sticky_clone\";s:5:\"value\";b:0;s:4:\"type\";s:8:\"switcher\";}s:13:\"sticky_height\";a:3:{s:2:\"id\";s:13:\"sticky_height\";s:5:\"value\";i:50;s:4:\"type\";s:6:\"slider\";}}}", "on");
INSERT INTO `wp_options` VALUES("31", "hack_file", "0", "on");
INSERT INTO `wp_options` VALUES("32", "blog_charset", "UTF-8", "on");
INSERT INTO `wp_options` VALUES("33", "moderation_keys", "", "off");
INSERT INTO `wp_options` VALUES("34", "active_plugins", "a:8:{i:0;s:29:\"RTL-CareUnit/RTL-CareUnit.php\";i:1;s:35:\"classic-widgets/classic-widgets.php\";i:2;s:36:\"contact-form-7/wp-contact-form-7.php\";i:3;s:25:\"duplicator/duplicator.php\";i:4;s:23:\"elementor/elementor.php\";i:5;s:41:\"image-optimization/image-optimization.php\";i:6;s:27:\"woocommerce/woocommerce.php\";i:7;s:31:\"woodmart-core/woodmart-core.php\";}", "on");
INSERT INTO `wp_options` VALUES("35", "category_base", "", "on");
INSERT INTO `wp_options` VALUES("36", "ping_sites", "http://rpc.pingomatic.com/", "on");
INSERT INTO `wp_options` VALUES("37", "comment_max_links", "2", "on");
INSERT INTO `wp_options` VALUES("38", "gmt_offset", "3.5", "on");
INSERT INTO `wp_options` VALUES("39", "default_email_category", "1", "on");
INSERT INTO `wp_options` VALUES("40", "recently_edited", "", "off");
INSERT INTO `wp_options` VALUES("41", "template", "woodmart", "on");
INSERT INTO `wp_options` VALUES("42", "stylesheet", "woodmart", "on");
INSERT INTO `wp_options` VALUES("43", "comment_registration", "0", "on");
INSERT INTO `wp_options` VALUES("44", "html_type", "text/html", "on");
INSERT INTO `wp_options` VALUES("45", "use_trackback", "0", "on");
INSERT INTO `wp_options` VALUES("46", "default_role", "subscriber", "on");
INSERT INTO `wp_options` VALUES("47", "db_version", "58975", "on");
INSERT INTO `wp_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "on");
INSERT INTO `wp_options` VALUES("49", "upload_path", "", "on");
INSERT INTO `wp_options` VALUES("50", "blog_public", "0", "on");
INSERT INTO `wp_options` VALUES("51", "default_link_category", "2", "on");
INSERT INTO `wp_options` VALUES("52", "show_on_front", "page", "on");
INSERT INTO `wp_options` VALUES("53", "tag_base", "", "on");
INSERT INTO `wp_options` VALUES("54", "show_avatars", "1", "on");
INSERT INTO `wp_options` VALUES("55", "avatar_rating", "G", "on");
INSERT INTO `wp_options` VALUES("56", "upload_url_path", "", "on");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_w", "150", "on");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_h", "150", "on");
INSERT INTO `wp_options` VALUES("59", "thumbnail_crop", "1", "on");
INSERT INTO `wp_options` VALUES("60", "medium_size_w", "300", "on");
INSERT INTO `wp_options` VALUES("61", "medium_size_h", "300", "on");
INSERT INTO `wp_options` VALUES("62", "avatar_default", "mystery", "on");
INSERT INTO `wp_options` VALUES("63", "large_size_w", "1024", "on");
INSERT INTO `wp_options` VALUES("64", "large_size_h", "1024", "on");
INSERT INTO `wp_options` VALUES("65", "image_default_link_type", "none", "on");
INSERT INTO `wp_options` VALUES("66", "image_default_size", "", "on");
INSERT INTO `wp_options` VALUES("67", "image_default_align", "", "on");
INSERT INTO `wp_options` VALUES("68", "close_comments_for_old_posts", "0", "on");
INSERT INTO `wp_options` VALUES("69", "close_comments_days_old", "14", "on");
INSERT INTO `wp_options` VALUES("70", "thread_comments", "1", "on");
INSERT INTO `wp_options` VALUES("71", "thread_comments_depth", "5", "on");
INSERT INTO `wp_options` VALUES("72", "page_comments", "0", "on");
INSERT INTO `wp_options` VALUES("73", "comments_per_page", "50", "on");
INSERT INTO `wp_options` VALUES("74", "default_comments_page", "newest", "on");
INSERT INTO `wp_options` VALUES("75", "comment_order", "asc", "on");
INSERT INTO `wp_options` VALUES("76", "sticky_posts", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("77", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("78", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("79", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("80", "uninstall_plugins", "a:1:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}}", "off");
INSERT INTO `wp_options` VALUES("81", "timezone_string", "", "on");
INSERT INTO `wp_options` VALUES("82", "page_for_posts", "0", "on");
INSERT INTO `wp_options` VALUES("83", "page_on_front", "26", "on");
INSERT INTO `wp_options` VALUES("84", "default_post_format", "0", "on");
INSERT INTO `wp_options` VALUES("85", "link_manager_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("86", "finished_splitting_shared_terms", "1", "on");
INSERT INTO `wp_options` VALUES("87", "site_icon", "477", "on");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_w", "768", "on");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_h", "0", "on");
INSERT INTO `wp_options` VALUES("90", "wp_page_for_privacy_policy", "3", "on");
INSERT INTO `wp_options` VALUES("91", "show_comments_cookies_opt_in", "1", "on");
INSERT INTO `wp_options` VALUES("92", "admin_email_lifespan", "1757642695", "on");
INSERT INTO `wp_options` VALUES("93", "disallowed_keys", "", "off");
INSERT INTO `wp_options` VALUES("94", "comment_previously_approved", "1", "on");
INSERT INTO `wp_options` VALUES("95", "auto_plugin_theme_update_emails", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_dev", "enabled", "on");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_minor", "enabled", "on");
INSERT INTO `wp_options` VALUES("98", "auto_update_core_major", "enabled", "on");
INSERT INTO `wp_options` VALUES("99", "wp_force_deactivated_plugins", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("100", "wp_attachment_pages_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("101", "initial_db_version", "58975", "on");
INSERT INTO `wp_options` VALUES("102", "wp_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:115:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:16:\"create_customers\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:3:{s:4:\"read\";b:1;s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:93:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:16:\"create_customers\";b:1;}}}", "on");
INSERT INTO `wp_options` VALUES("103", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("104", "WPLANG", "fa_IR", "auto");
INSERT INTO `wp_options` VALUES("105", "user_count", "4", "off");
INSERT INTO `wp_options` VALUES("106", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:170:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>نوشته‌های تازه</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:242:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>آخرین دیدگاه‌ها</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>بایگانی‌ها</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:155:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>دسته‌ها</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("107", "sidebars_widgets", "a:15:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:22:\"portfolio-widgets-area\";a:0:{}s:12:\"sidebar-shop\";a:3:{i:0;s:24:\"wd-widget-stock-status-2\";i:1;s:34:\"woodmart-woocommerce-layered-nav-2\";i:2;s:26:\"woocommerce_price_filter-2\";}s:12:\"filters-area\";a:0:{}s:22:\"sidebar-product-single\";a:0:{}s:18:\"sidebar-my-account\";a:0:{}s:24:\"sidebar-full-screen-menu\";a:0:{}s:19:\"mobile-menu-widgets\";a:0:{}s:8:\"footer-1\";a:0:{}s:8:\"footer-2\";a:0:{}s:8:\"footer-3\";a:0:{}s:8:\"footer-4\";a:0:{}s:8:\"footer-5\";a:0:{}s:13:\"array_version\";i:3;}", "auto");
INSERT INTO `wp_options` VALUES("108", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("109", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("110", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("111", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("112", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("113", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("114", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("115", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("116", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("117", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("118", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("119", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("120", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("121", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("152", "woodmart-generated-wpbcss-file", "", "auto");
INSERT INTO `wp_options` VALUES("153", "woodmart_is_activated", "", "auto");
INSERT INTO `wp_options` VALUES("155", "xts-options-presets", "", "auto");
INSERT INTO `wp_options` VALUES("7078", "_site_transient_timeout_theme_roots", "1749570744", "off");
INSERT INTO `wp_options` VALUES("7079", "_site_transient_theme_roots", "a:1:{s:8:\"woodmart\";s:7:\"/themes\";}", "off");
INSERT INTO `wp_options` VALUES("4606", "_transient_woocommerce_product_task_product_count_transient", "7", "on");
INSERT INTO `wp_options` VALUES("7125", "woocommerce_email_header_image_width", "120", "on");
INSERT INTO `wp_options` VALUES("7126", "woocommerce_email_header_alignment", "left", "on");
INSERT INTO `wp_options` VALUES("7127", "woocommerce_email_font_family", "Helvetica", "on");
INSERT INTO `wp_options` VALUES("7128", "woocommerce_feature_blueprint_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("7129", "woocommerce_hpos_datastore_caching_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("7130", "woocommerce_feature_block_email_editor_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("7118", "image_optimizer_help_videos", "", "auto");
INSERT INTO `wp_options` VALUES("7087", "_site_transient_timeout_php_check_990bfacb848fa087bcfc06850f5e4447", "1750174047", "off");
INSERT INTO `wp_options` VALUES("7088", "_site_transient_php_check_990bfacb848fa087bcfc06850f5e4447", "a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "off");
INSERT INTO `wp_options` VALUES("137", "can_compress_scripts", "1", "on");
INSERT INTO `wp_options` VALUES("7093", "_site_transient_timeout_community-events-4a08b32e32847ac8b43c09e772bb470b", "1749612452", "off");
INSERT INTO `wp_options` VALUES("7094", "_site_transient_community-events-4a08b32e32847ac8b43c09e772bb470b", "a:4:{s:9:\"sandboxed\";b:0;s:5:\"error\";N;s:8:\"location\";a:1:{s:2:\"ip\";s:12:\"217.182.51.0\";}s:6:\"events\";a:2:{i:0;a:10:{s:4:\"type\";s:6:\"meetup\";s:5:\"title\";s:14:\"Meetup #9 🎉\";s:3:\"url\";s:65:\"https://www.meetup.com/kortrijk-wordpress-meetup/events/307177330\";s:6:\"meetup\";s:25:\"Kortrijk WordPress Meetup\";s:10:\"meetup_url\";s:49:\"https://www.meetup.com/kortrijk-wordpress-meetup/\";s:4:\"date\";s:19:\"2025-06-25 19:00:00\";s:8:\"end_date\";s:19:\"2025-06-25 22:00:00\";s:20:\"start_unix_timestamp\";i:1750870800;s:18:\"end_unix_timestamp\";i:1750881600;s:8:\"location\";a:4:{s:8:\"location\";s:16:\"Kortrijk, Belize\";s:7:\"country\";s:2:\"bz\";s:8:\"latitude\";d:50.829650000000001;s:9:\"longitude\";d:3.255039;}}i:1;a:10:{s:4:\"type\";s:8:\"wordcamp\";s:5:\"title\";s:25:\"WordCamp Netherlands 2025\";s:3:\"url\";s:38:\"https://netherlands.wordcamp.org/2025/\";s:6:\"meetup\";N;s:10:\"meetup_url\";N;s:4:\"date\";s:19:\"2025-11-27 00:00:00\";s:8:\"end_date\";s:19:\"2025-11-28 00:00:00\";s:20:\"start_unix_timestamp\";i:1764198000;s:18:\"end_unix_timestamp\";i:1764284400;s:8:\"location\";a:4:{s:8:\"location\";s:11:\"Netherlands\";s:7:\"country\";s:2:\"NL\";s:8:\"latitude\";d:52.099065600000003;s:9:\"longitude\";d:4.2975317000000004;}}}}", "off");
INSERT INTO `wp_options` VALUES("7095", "_transient_timeout_feed_9ba2df8849616f02166b8f7242d75067", "1749612452", "off");
INSERT INTO `wp_options` VALUES("7096", "_transient_feed_9ba2df8849616f02166b8f7242d75067", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"بلاگ – WordPress.org فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://fa.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Feb 2025 10:36:51 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fa-IR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=6.9-alpha-60294\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:37:\"بلاگ – WordPress.org فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:24:\"https://fa.wordpress.org\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"خطرات استفاده از محصولات نال و کرک شده\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:230:\"https://fa.wordpress.org/2025/02/12/%d8%ae%d8%b7%d8%b1%d8%a7%d8%aa-%d8%a7%d8%b3%d8%aa%d9%81%d8%a7%d8%af%d9%87-%d8%a7%d8%b2-%d9%85%d8%ad%d8%b5%d9%88%d9%84%d8%a7%d8%aa-%d9%86%d8%a7%d9%84-%d9%88-%da%a9%d8%b1%da%a9-%d8%b4%d8%af%d9%87/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:239:\"https://fa.wordpress.org/2025/02/12/%d8%ae%d8%b7%d8%b1%d8%a7%d8%aa-%d8%a7%d8%b3%d8%aa%d9%81%d8%a7%d8%af%d9%87-%d8%a7%d8%b2-%d9%85%d8%ad%d8%b5%d9%88%d9%84%d8%a7%d8%aa-%d9%86%d8%a7%d9%84-%d9%88-%da%a9%d8%b1%da%a9-%d8%b4%d8%af%d9%87/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 12 Feb 2025 09:39:34 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fa.wordpress.org/?p=1120\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:515:\"استفاده از محصولات نال (Null) یا کرک شده در حوزه وردپرس و دیگر نرم‌افزارها ممکن است برای برخی افراد به دلیل رایگان بودن و یا قیمت کمتر از نسخه اصلی آن‌ها جذاب باشد، اما این کار با مشکلات و خطرات بزرگی همراه است.&#160;در ادامه به دلایل اصلی اجتناب از محصولات نال می‌پردازیم. 1. احترام به [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Farhad Sakhaei\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:13685:\"\n<p>استفاده از محصولات نال (Null) یا کرک شده در حوزه وردپرس و دیگر نرم‌افزارها ممکن است برای برخی افراد به دلیل رایگان بودن و یا قیمت کمتر از نسخه اصلی آن‌ها جذاب باشد، اما این کار با مشکلات و خطرات بزرگی همراه است.&nbsp;در ادامه به دلایل اصلی اجتناب از محصولات نال می‌پردازیم.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h4 class=\"wp-block-heading\"><strong>1. احترام به قانون کپی‌رایت</strong></h4>\n\n\n\n<p>هر نرم‌افزاری که توسط توسعه‌دهندگان یا تیم‌های برنامه‌نویسی تولید می‌شود، نتیجه‌ زحمت، زمان و هزینه‌ زیادی است. اکثر این نرم‌افزارها نسخه‌های رایگان یا آزمایشی نیز ارائه می‌دهند تا کاربران بتوانند قبل از خرید، آن‌ها را امتحان کنند.<br>استفاده از نسخه‌های نال شده این محصولات، نه تنها نقض قانون کپی‌رایت، بلکه یک عمل غیر اخلاقی محسوب می‌شود. این کار نه تنها زحمات توسعه‌دهنده را بی‌ارزش می‌کند، بلکه توسعه و نوآوری در نرم‌افزارها را نیز کاهش می‌دهد.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h4 class=\"wp-block-heading\"><strong>2. خطرات امنیتی</strong></h4>\n\n\n\n<p>استفاده از محصولات نال می‌تواند امنیت شما و وب‌سایتتان را به شدت به خطر بیندازد.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>محصول نال چیست؟</strong><strong><br></strong>محصولات نال در واقع نسخه‌های غیرقانونی نرم‌افزارهایی هستند که سیستم لایسنس آن‌ها دور زده شده است. این نسخه‌ها اغلب توسط افرادی عرضه می‌شوند که اهداف نامعلومی دارند، از جمله تزریق کدهای مخرب.</li>\n\n\n\n<li><strong>عدم دریافت به‌روزرسانی‌ها</strong><strong><br></strong>یکی از بزرگ‌ترین مزایای محصولات اصلی، ارائه به‌روزرسانی‌های منظم برای رفع باگ‌ها و ارتقای امنیت است. کاربران محصولات نال، این آپدیت‌ها را دریافت نمی‌کنند و در نتیجه، سایت آن‌ها در برابر حملات سایبری آسیب‌پذیر می‌شود.</li>\n\n\n\n<li><strong>عدم پشتیبانی</strong><strong><br></strong>محصولات پرمیوم معمولاً با پشتیبانی کامل توسعه‌دهندگان همراه هستند. کاربران محصولات نال به این پشتیبانی دسترسی ندارند و در صورت بروز مشکل، باید خودشان آن را حل کنند.</li>\n\n\n\n<li><strong>کدهای مخرب</strong><strong><br></strong>محصولات نال اغلب شامل کدهای مخربی هستند که می‌توانند اطلاعات حساس شما مانند رمزهای عبور، اطلاعات بانکی و حتی اطلاعات مشتریان شما را به سرقت ببرند. این مسئله به ویژه برای سایت‌های فروشگاهی و کسب‌وکارهای آنلاین بسیار خطرناک است.</li>\n\n\n\n<li><strong>سو استفاده از منابع سرور</strong><strong><br></strong>استفاده از محصولات نال در برخی موارد منجر به سوء استفاده هکرها از منابع سرور، ارسال ایمیل‌های تبلیغاتی، دریافت دسترسی و تلاش برای نفوذ به سرور و هک کردن آن می‌شود که می‌تواند نتایج مخرب و مشکل زایی برای سرور و یا آدرس IP آن و حتی سایت‌های مشترک دیگر میزبانی‌شده بر روی آن داشته باشد.</li>\n</ul>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h4 class=\"wp-block-heading\"><strong>3. تاثیرات منفی بر سئو</strong></h4>\n\n\n\n<p>استفاده از محصولات نال ممکن است باعث ایجاد لینک‌های اسپم، پاپ‌آپ‌های تبلیغاتی و حتی تغییرات مخفی در کد سایت شود. این موارد ممکن است باعث کاهش رتبه سایت شما در موتورهای جستجو شده و اعتماد کاربران را نیز از بین ببرد.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h4 class=\"wp-block-heading\"><strong>4. انگیزه‌های ارائه‌دهندگان محصولات نال</strong></h4>\n\n\n\n<p>افرادی که محصولات نال را ارائه می‌دهند، معمولاً به دنبال منافع شخصی هستند. برخی از انگیزه‌های آن‌ها عبارتند از:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>تزریق تبلیغات و لینک‌های اسپم به سایت شما.</li>\n\n\n\n<li>سرقت اطلاعات شخصی مانند نام کاربری، رمز عبور، ایمیل و اطلاعات مالی.</li>\n\n\n\n<li>آلوده کردن فایل‌ها و سرورهای شما به بدافزارها.</li>\n</ul>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h3 class=\"wp-block-heading\"><strong>چگونه بفهمیم یک محصول نال است؟</strong></h3>\n\n\n\n<p>تشخیص محصولات نال برای افرادی که با ویژگی‌های نسخه‌های اورجینال آشنا نیستند، ممکن است دشوار باشد. اما با چند نکته ساده می‌توان از خرید این محصولات جلوگیری کرد:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li><strong>فروشگاه عرضه‌کننده محصول:</strong><strong><br></strong>هر محصول تجاری، تنها در فروشگاه رسمی تولیدکننده آن به فروش می‌رسد. اگر یک فروشگاه دیگر، از جمله فروشگاه‌های ایرانی، محصولاتی مانند قالب وودمارت (WoodMart)، افزونه المنتور (Elementor) یا سایر افزونه‌ها و قالب‌های پرمیوم را با عنوان نگارش اصل و اورجینال ارائه کند، در حال فروش نسخه نال محصول است. توجه داشته باشید هیچ وب‌سایتی از این امر مستثنی نیست.</li>\n\n\n\n<li><strong>قیمت غیرمعقول:</strong><strong><br></strong>محصولات نال معمولاً با قیمتی بسیار کمتر از نسخه اورجینال به فروش می‌رسند. اگر یک قالب یا افزونه با قیمت بسیار پایین‌تر از سایت اصلی عرضه شود، احتمال نال بودن آن بسیار زیاد است.</li>\n\n\n\n<li><strong>عدم ارائه لایسنس معتبر:</strong><strong><br></strong>محصولات اصلی همراه با یک لایسنس معتبر عرضه می‌شوند که امکان فعال‌سازی و دریافت به‌روزرسانی‌ها را فراهم می‌کند. اگر محصولی فاقد لایسنس معتبر باشد یا لایسنس غیرقابل تأیید ارائه دهد، احتمالاً نال شده است.</li>\n\n\n\n<li><strong>بررسی نظرات کاربران و اعتبار فروشنده:</strong><strong><br></strong>پیش از خرید، نظرات کاربران را بررسی کنید و از معتبر بودن فروشگاه اطمینان حاصل کنید. فروشگاه‌های معتبر اطلاعات واضحی درباره محصولات ارائه می‌دهند و به سوالات کاربران پاسخ شفاف می‌دهند.</li>\n\n\n\n<li><strong>محصولات نگارش اصلی کد شده نمی‌باشند</strong><strong><br></strong>باید توجه داشته باشید که وردپرس بر اساس GPL و کد باز (Open Source) منتشر شده است. این به این معنی است که تمامی افزونه‌ها و پوسته‌های مرتبط با آن، باید به صورت کد باز منتشر شوند، حتی هر افزونه و یا پوسته‌ای که نگارش Premium یا Pro باشد باید به صورت Open Source به کاربران ارائه شوند، حال آنکه متاسفانه بسیاری از فروشگاه‌های ایرانی، نسخه‌های Premium و Pro را که کد باز هستند، کدگذاری کرده و با دخل تصرف بیشتر و یا اضافه کردن سیستم‌های لایسنس پیچیده‌تر، سعی در فروش بیشتر و در نتیجه پیچیده‌تر کردن محصول نهایی می‌کنند که این کار در نهایت منجر به سنگین‌تر شدن سایت و زمان بارگذاری بیشتر سایت و مشکلات دیگر می‌شود.</li>\n</ol>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h3 class=\"wp-block-heading\"><strong>چطور محصولات اورجینال بخریم؟</strong></h3>\n\n\n\n<p>با توجه به مشکلات خرید دلاری برای کاربران ایرانی، می‌توانید از روش‌های زیر استفاده کنید:</p>\n\n\n\n<ol class=\"wp-block-list\">\n<li><strong>سایت‌های واسطه:</strong><strong><br></strong>برخی از سایت‌های معتبر واسطه ایرانی امکان خرید دلاری را برای شما فراهم می‌کنند. این سایت‌ها با دریافت مبلغ ریالی، محصول مورد نظر شما را از سایت اصلی خریداری کرده و اطلاعات لایسنس را در اختیار شما قرار می‌دهند. قبل از استفاده از خدمات این سایت‌ها، اعتبار آن‌ها را بررسی کنید.</li>\n\n\n\n<li><strong>دوستان یا آشنایان دارای حساب بین‌المللی:</strong><strong><br></strong>اگر دوستان یا آشنایانی دارید که دسترسی به کارت‌های بین‌المللی مانند مسترکارت یا ویزا کارت دارند، می‌توانید از آن‌ها برای خرید محصولات کمک بگیرید.</li>\n\n\n\n<li><strong>پیشنهاد دیگر: استفاده از تخفیف‌ها و باندل‌ها</strong><strong><br></strong>بسیاری از توسعه‌دهندگان محصولات وردپرس، در بازه‌های زمانی خاص مانند جمعه سیاه (Black Friday) یا مناسبت‌های دیگر، تخفیف‌های چشمگیری ارائه می‌دهند. با کمی برنامه‌ریزی می‌توانید محصولات اورجینال را با هزینه کمتری خریداری کنید.</li>\n</ol>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\" />\n\n\n\n<h3 class=\"wp-block-heading\"><strong>جمع‌بندی:</strong></h3>\n\n\n\n<p>خرید محصولات اصلی، علاوه بر حمایت از توسعه‌دهندگان، به شما این امکان را می‌دهد که از امکانات زیر بهره‌مند شوید:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>پشتیبانی مداوم:</strong> حل مشکلات و پاسخ به سوالات شما.</li>\n\n\n\n<li><strong>دریافت به‌روزرسانی‌ها:</strong> محافظت سایت در برابر آسیب‌پذیری‌ها.</li>\n\n\n\n<li><strong>دسترسی به امکانات کامل و مستندات:</strong> بهره‌گیری از تمامی قابلیت‌های محصول به صورت بهینه.</li>\n</ul>\n\n\n\n<p>با خرید نسخه‌های اورجینال، هم امنیت و عملکرد سایت خود را تضمین می‌کنید و هم به توسعه تکنولوژی‌های بهتر کمک می‌کنید.</p>\n\n\n\n<p>استفاده از محصولات نال نه تنها غیراخلاقی و غیرقانونی است، بلکه می‌تواند خطرات جدی برای امنیت، عملکرد و اعتبار سایت شما ایجاد کند. به جای انتخاب این محصولات، از نسخه‌های رایگان یا لایسنس‌دار استفاده کنید. این کار نه تنها باعث حمایت از توسعه‌دهندگان می‌شود، بلکه امنیت و کیفیت سایت شما را تضمین می‌کند.</p>\n\n\n\n<p>اگر هزینه یک محصول برایتان بالا است، به دنبال جایگزین‌های رایگان یا تخفیف‌های فصلی باشید، اما هرگز امنیت و اعتبار خود را فدای استفاده از محصولات نال نکنید.</p>\n\n\n\n<p><strong>نوشته شده توسط:</strong> <a href=\"https://profiles.wordpress.org/asadiy4n/\" data-type=\"link\" data-id=\"https://profiles.wordpress.org/asadiy4n/\">حسین اسدیان</a> و <a href=\"https://fa.wordpress.org/team/2024/02/17/%d9%85%d8%b9%d8%b1%d9%81%db%8c-%d8%aa%db%8c%d9%85-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c/\" data-type=\"link\" data-id=\"https://fa.wordpress.org/team/2024/02/17/%d9%85%d8%b9%d8%b1%d9%81%db%8c-%d8%aa%db%8c%d9%85-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c/\">تیم وردپرس فارسی</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:235:\"https://fa.wordpress.org/2025/02/12/%d8%ae%d8%b7%d8%b1%d8%a7%d8%aa-%d8%a7%d8%b3%d8%aa%d9%81%d8%a7%d8%af%d9%87-%d8%a7%d8%b2-%d9%85%d8%ad%d8%b5%d9%88%d9%84%d8%a7%d8%aa-%d9%86%d8%a7%d9%84-%d9%88-%da%a9%d8%b1%da%a9-%d8%b4%d8%af%d9%87/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1120\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"وردپرس فارسی نگارش ۶.۷\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:149:\"https://fa.wordpress.org/2024/11/17/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%d9%86%da%af%d8%a7%d8%b1%d8%b4-%db%b7-%db%b6/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 17 Nov 2024 20:15:38 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fa.wordpress.org/?p=1103\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:527:\"به وردپرس ۶.۷ خوش آمدید! وردپرس ۶.۷ با تم مدرن Twenty Twenty-Five معرفی می‌شود که انعطاف‌پذیری طراحی بی‌نظیری را برای هر وبلاگ در هر مقیاسی ارائه می‌دهد. کنترل تایپوگرافی سایت خود را مانند هرگز قبل با ویژگی‌های جدید مدیریت فونت به دست بگیرید. ویژگی جدید Zoom Out به شما این امکان را می‌دهد که سایت [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Saeed Fard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:11038:\"\n<h2 class=\"wp-block-heading has-huge-font-size\"><strong>به وردپرس ۶.۷ خوش آمدید!</strong></h2>\n\n\n\n<p>وردپرس ۶.۷ با تم مدرن Twenty Twenty-Five معرفی می‌شود که انعطاف‌پذیری طراحی بی‌نظیری را برای هر وبلاگ در هر مقیاسی ارائه می‌دهد. کنترل تایپوگرافی سایت خود را مانند هرگز قبل با ویژگی‌های جدید مدیریت فونت به دست بگیرید. ویژگی جدید Zoom Out به شما این امکان را می‌دهد که سایت خود را با یک نمای کلان طراحی کنید و از جزئیات فاصله بگیرید تا تصویر کلی را به زندگی بیاورید</p>\n\n\n\n<h4 class=\"wp-block-heading has-large-font-size\"><strong>معرفی پوسته Twenty Twenty-Five<br>امکان بی‌پایان بدون پیچیدگی</strong></h4>\n\n\n\n<p>پوسته Twenty Twenty-Five یک پوسته انعطاف‌پذیر و متمرکز بر طراحی را ارائه می‌دهد که به شما این امکان را می‌دهد تا سایت‌های خیره‌کننده‌ای را به سادگی بسازید. زیبایی‌شناسی خود را با مجموعه‌ای از گزینه‌های سبک، الگوهای بلوک و پالت‌های رنگی سفارشی کنید. این پوسته که به اصول اساسی خود پایبند است، واقعاً می‌تواند با شما رشد کند</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large is-resized\"><img decoding=\"async\" src=\"https://i0.wp.com/s.w.org/images/core/6.7/feature-tt5-2.webp\" alt=\"\" style=\"aspect-ratio:4/3;object-fit:cover;width:474px;height:auto\" /></figure>\n\n\n\n<h4 class=\"wp-block-heading has-large-font-size\"><strong>تصویر کلی را با ویژگی Zoom Out ببینید<br>محتوای خود را از یک دیدگاه جدید کاوش کنید</strong></h4>\n\n\n\n<p>محتوای خود را به‌طور کامل و به شیوه‌ای بی‌سابقه ویرایش و مرتب کنید. نمای وسیع‌تری از سایت شما این امکان را می‌دهد که الگوها را به دلخواه خود اضافه، ویرایش، جابجا یا حذف کنید. معمار درون خود را در آغوش بگیرید</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large is-resized\"><img decoding=\"async\" src=\"https://i0.wp.com/s.w.org/images/core/6.7/feature-zoom-2.webp?ssl=1\" alt=\"\" style=\"aspect-ratio:4/3;object-fit:cover;width:474px\" /></figure>\n\n\n\n<h4 class=\"wp-block-heading has-large-font-size\"><strong>بلوک‌ها و فیلدهای سفارشی را بدون دردسر (یا کدنویسی) متصل کنید<br>راهی ساده برای ایجاد محتوای پویا</strong></h4>\n\n\n\n<p>این ویژگی یک رابط کاربری جدید برای اتصال بلوک‌ها به فیلدهای سفارشی معرفی می‌کند و کنترل محتوای پویا را به‌طور مستقیم در ویرایشگر قرار می‌دهد. بلوک‌ها را تنها با چند کلیک به فیلدها متصل کنید و انعطاف‌پذیری و کارایی را در هنگام ساخت افزایش دهید. مشتریان شما، شما را دوست خواهند داشت—انگار که قبلاً دوست نداشتند!</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large is-resized\"><img decoding=\"async\" src=\"https://i0.wp.com/s.w.org/images/core/6.7/feature-block-bindings-2.webp?ssl=1\" alt=\"\" style=\"aspect-ratio:4/3;object-fit:cover;width:474px\" /></figure>\n\n\n\n<h4 class=\"wp-block-heading has-large-font-size\"><strong>معمار درون فونت‌شناس خود را در آغوش بگیرید<br>بخش جدید سبک، امکانات جدید</strong></h4>\n\n\n\n<p>با افزودن جدید به رابط Styles، اندازه‌های پیش‌فرض فونت را ایجاد، ویرایش، حذف و اعمال کنید. می‌توانید تنظیمات پیش‌فرض پوسته را نادیده بگیرید یا اندازه فونت سفارشی خود را ایجاد کنید که شامل تایپوگرافی سیال برای مقیاس‌بندی پاسخگو باشد. به جزئیات بپردازید!</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large is-resized\"><img decoding=\"async\" src=\"https://i0.wp.com/s.w.org/images/core/6.7/feature-font-presets-2.png?ssl=1\" alt=\"\" style=\"aspect-ratio:4/3;object-fit:cover;width:474px\" /></figure>\n\n\n\n<h4 class=\"wp-block-heading has-large-font-size\"><strong>عملکرد</strong></h4>\n\n\n\n<p>وردپرس ۶.۷ به‌روزرسانی‌های مهمی در زمینه عملکرد ارائه می‌دهد، از جمله بارگذاری سریع‌تر الگوها، پیش‌نمایش‌های بهینه‌شده در مؤلفه‌های نمای داده، بهبود پشتیبانی از PHP 8+ و حذف کدهای منسوخ، اندازه‌های خودکار برای تصاویر بارگذاری شده به‌صورت تنبل و پردازش کارآمدتر برچسب‌ها در API HTML.</p>\n\n\n\n<h4 class=\"wp-block-heading has-large-font-size\"><strong>دسترس‌پذیری</strong></h4>\n\n\n\n<p>بیش از ۶۵ اصلاح و بهبود در زمینه دسترس‌پذیری بر جنبه‌های بنیادی تجربه وردپرس تمرکز دارد، از بهبود مؤلفه‌های رابط کاربری و ناوبری با کیبورد در ویرایشگر، تا عنوان دسترس‌پذیر در صفحه‌های ورود به وردپرس و برچسب‌گذاری واضح‌تر در سرتاسر.</p>\n\n\n\n<p></p>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/files/2024/11/6-7-feature-heic-1.png?w=960&amp;ssl=1\" alt=\"\" /><figcaption class=\"wp-element-caption\"><strong>پشتیبانی از تصاویر HEIC</strong><br>پشتیبانی از تصاویر HEIC مدیریت رسانه را بهبود می‌بخشد و امکان استفاده از تصاویر با کیفیت بالا و فضای بهینه را در تمام بلوک‌ها فراهم می‌کند</figcaption></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/files/2024/11/6-7-feature-streamlined-query-loops.png?w=960&amp;ssl=1\" alt=\"\" /><figcaption class=\"wp-element-caption\"><strong>بلوک Query Loop بهینه‌شده</strong><br>بهبودهای انجام‌شده در بلوک Query Loop قابلیت استفاده را افزایش می‌دهد و با خودکارسازی تنظیمات پیش‌فرض و تجمیع گزینه‌های کلیدی، سفارشی‌سازی را آسان‌تر می‌کند</figcaption></figure>\n</div>\n</div>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/files/2024/11/6-7-feature-preview-dropdown.png?w=960&amp;ssl=1\" alt=\"\" /><figcaption class=\"wp-element-caption\"><strong>گسترش منوی کشویی پیش‌نمایش</strong><br>بهبودهای انجام‌شده در گزینه‌های پیش‌نمایش به افزونه‌ها و پوسته‌ها این امکان را می‌دهد که موارد سفارشی را به منوی کشویی اضافه کنند و نحوه پیش‌نمایش محتوا را غنی‌تر کنند</figcaption></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/files/2024/11/6-7-feature-site-background.png?w=960&amp;ssl=1\" alt=\"\" /><figcaption class=\"wp-element-caption\"><strong>سفارشی‌سازی پس‌زمینه سایت</strong><br>ابزارهای بهبود یافته پس‌زمینه، سفارشی‌سازی بلوک‌ها را افزایش می‌دهند و امکان تنظیمات جهانی را فراهم می‌کنند، که به حفظ انسجام در سرتاسر سایت کمک کرده و تلاش‌های طراحی را ساده‌تر می‌سازد.</figcaption></figure>\n</div>\n</div>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/files/2024/11/6-7-feature-template-registration.png?w=960&amp;ssl=1\" alt=\"\" /><figcaption class=\"wp-element-caption\"><strong>API ثبت الگو</strong><br>این API جدید ثبت الگوهای سفارشی را برای افزونه‌ها ساده‌تر می‌کند و امکان نادیده‌گیری پوسته و ایجاد الگوهای سفارشی برای دسته‌بندی‌ها را برای انعطاف‌پذیری بیشتر فراهم می‌آورد</figcaption></figure>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/files/2024/11/6-7-feature-refined-pages.png?w=960&amp;ssl=1\" alt=\"\" /><figcaption class=\"wp-element-caption\"><strong>نمای بهبود یافته صفحات در ویرایشگر سایت</strong><br>ویرایش را با نمای صفحات بهبود یافته که گزینه‌های فیلتر سفارشی را ارائه می‌دهند، ساده‌تر کنید. با تغییر نمایش فیلترها، به نمای‌های بهینه‌شده‌ای مانند منتشر شده و پیش‌نویس‌ها بدون شلوغی دسترسی پیدا کنید.</figcaption></figure>\n</div>\n</div>\n\n\n\n<p>برای مشاهدهٔ جامع تمام ویژگی‌ها و بهبودهای جدید در وردپرس ۶.۷، آن را به‌روز و امتحان کنید.</p>\n\n\n\n<div class=\"wp-block-buttons is-horizontal is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-03627597 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-vivid-cyan-blue-background-color has-text-color has-background wp-element-button\" href=\"https://fa.wordpress.org/download/\" style=\"border-radius:8px;color:#ffffff\" target=\"_blank\" rel=\"noreferrer noopener\">دریافت وردپرس فارسی</a></div>\n</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1103\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"وردپرس فارسی نگارش ۶.۶\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:149:\"https://fa.wordpress.org/2024/07/16/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%d9%86%da%af%d8%a7%d8%b1%d8%b4-%db%b6-%db%b6/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 16 Jul 2024 08:08:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fa.wordpress.org/?p=1080\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:646:\"وردپرس فارسی نگارش ۶.۶ منتشر شد، موارد کلیدی این نگارش عبارتند از: پالت‌های رنگ و مجموعه‌های فونت انتخاب‌های طراحی بیشتری را به پوسته‌های بلوکی اضافه کنید.سازندگان پوستهٔ بلوکی می‌توانند مجموعه‌های نامحدود و منحصر بفرد رنگ یا فونت ایجاد کنند تا انتخاب‌های طراحی خاص‌تری را در همان پوسته ارائه دهند. این مجموعه‌ها امکانات طراحی محدودشده‌تری را [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Morteza Geransayeh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5177:\"\n<p>وردپرس فارسی نگارش ۶.۶ منتشر شد، موارد کلیدی این نگارش عبارتند از:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>پالت‌های رنگ و مجموعه‌های فونت</li>\n\n\n\n<li>پیش‌نمایش سریع برای برگه‌ها</li>\n\n\n\n<li>بازگرداندن به‌روزرسانی‌های خودکار افزونه</li>\n\n\n\n<li>باز‌نویسی‌ها</li>\n</ul>\n\n\n\n<p></p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2024/10/6-6-highlight-grid.png\"><img fetchpriority=\"high\" decoding=\"async\" width=\"1024\" height=\"567\" src=\"https://fa.wordpress.org/files/2024/10/6-6-highlight-grid-1024x567.png\" alt=\"\" class=\"wp-image-1081\" srcset=\"https://fa.wordpress.org/files/2024/10/6-6-highlight-grid-1024x567.png 1024w, https://fa.wordpress.org/files/2024/10/6-6-highlight-grid-300x166.png 300w, https://fa.wordpress.org/files/2024/10/6-6-highlight-grid-768x426.png 768w, https://fa.wordpress.org/files/2024/10/6-6-highlight-grid-1536x851.png 1536w, https://fa.wordpress.org/files/2024/10/6-6-highlight-grid-2048x1135.png 2048w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">پالت‌های رنگ و مجموعه‌های فونت</h2>\n\n\n\n<p><strong>انتخاب‌های طراحی بیشتری را به پوسته‌های بلوکی اضافه کنید.</strong><br>سازندگان پوستهٔ بلوکی می‌توانند مجموعه‌های نامحدود و منحصر بفرد رنگ یا فونت ایجاد کنند تا انتخاب‌های طراحی خاص‌تری را در همان پوسته ارائه دهند. این مجموعه‌ها امکانات طراحی محدودشده‌تری را ارائه می‌کنند و امکان سفارشی‌سازی را بدون تغییر استایل گسترده‌تر سایت، فراتر از تنظیمات رنگ یا تایپوگرافی فراهم می‌کنند.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">پیش‌نمایش سریع برای برگه‌ها</h2>\n\n\n\n<p><strong>گردش کاری خود را با چیدمان جدیدی که برای برگه‌ها ایجاد شده‌است، ساده کنید.&nbsp;</strong><br>تمام برگه‌هایتان و پیش‌نمایش هر برگهٔ انتخابی را قبل از ویرایش از طریق یک چیدمان جدید پهلو به پهلو در ویرایشگر سایت مشاهده کنید.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">بازگرداندن به‌روزرسانی‌های خودکار افزونه</h2>\n\n\n\n<p><strong>افزونه‌های خود را با خیال راحت بصورت خودکار به‌روزرسانی کنید.</strong><br>از سهولت به‌روزرسانی خودکار افزونه‌ها با ایمنی بازگرداندن در صورت بروز مشکل، لذت ببرید و امنیت سایتتان را بهبود ببخشید و در عین حال مدت از کار افتادن احتمالی سایت را به حداقل برسانید.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">باز‌نویسی‌ها</h2>\n\n\n\n<p><strong>افزودن قابلیت سفارشی‌سازی محتوا در الگوهای همگام‌سازی شده.</strong><br>اجازه می‌دهد که قطعات خاصی از محتوا در هر نمونه از یک الگوی همگام‌سازی‌شده را سفارشی و در عین حال سبکی ثابت را برای همه نمونه‌ها حفظ کنید و به‌روزرسانی‌های آینده را ساده‌تر می‌کند. در حال حاضر، می‌توانید برای بلوک‌های عنوان، پاراگراف، دکمه و تصویر، از باز‌نویسی‌ها استفاده کنید.</p>\n\n\n\n<p></p>\n\n\n\n<p>ه‌ترین نگارش <a href=\"https://make.wordpress.org/core/2024/06/25/wordpress-6-6-field-guide/\">راهنمای زمینهٔ وردپرس</a> را بررسی نمایید. سرشار از یادداشت‌های دقیق توسعه‌دهنده است که به شما کمک می‌کند با وردپرس بسازید.</p>\n\n\n\n<div class=\"wp-block-buttons is-horizontal is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-03627597 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-vivid-cyan-blue-background-color has-text-color has-background wp-element-button\" href=\"https://fa.wordpress.org/download/\" style=\"border-radius:8px;color:#ffffff\" target=\"_blank\" rel=\"noreferrer noopener\">دریافت وردپرس فارسی</a></div>\n</div>\n\n\n\n<p>برای اطلاعات بیشتر دربارهٔ پیشرفت‌ها و مشکلات حل شده، اطلاعات نصب، یادداشت‌های توسعه‌دهنده و منابع، همکاری‌کنندگان در انتشار، و فهرست تغییرات پرونده در این نسخه <a href=\"https://wordpress.org/documentation/wordpress-version/version-6-6/\">یادداشت‌های انتشار وردپرس ۶.۲ را بخوانید</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1080\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"وردپرس فارسی نگارش ۶.۵\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:149:\"https://fa.wordpress.org/2024/04/02/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%d9%86%da%af%d8%a7%d8%b1%d8%b4-%db%b6-%db%b5/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 02 Apr 2024 07:56:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:32:\"https://fa.wordpress.org/?p=1076\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:536:\"وردپرس فارسی نگارش ۶.۵ منتشر شد، موارد کلیدی این نگارش عبارتند از: با کتابخانه فونت آشنا شوید بدون کدنویسی یا مراحل اضافی، کنترل یک قطعه ضروری از طراحی سایت خود – تایپوگرافی – را حفظ کنید. فونت‌های محلی و گوگل را به راحتی برای هر تم بلوکی نصب، حذف و فعال کنید. گنجاندن مجموعه‌های تایپوگرافی [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Morteza Geransayeh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:7323:\"\n<p>وردپرس فارسی نگارش ۶.۵ منتشر شد، موارد کلیدی این نگارش عبارتند از:<br></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>کتابخانه فونت جدید</li>\n\n\n\n<li>پس زمینه و ابزار سایه پیشرفته</li>\n\n\n\n<li>جزئیات بیشتری در اصلاحات استایل</li>\n\n\n\n<li>کنترل بهتر لینک</li>\n\n\n\n<li>نماهای داده جدید</li>\n\n\n\n<li>به‌روزرسانی عملکرد</li>\n\n\n\n<li>بهبود دسترسی</li>\n\n\n\n<li></li>\n</ul>\n\n\n\n<p></p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2024/10/6-5-highlight-grid.png\"><img decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://fa.wordpress.org/files/2024/10/6-5-highlight-grid-1024x576.png\" alt=\"\" class=\"wp-image-1077\" srcset=\"https://fa.wordpress.org/files/2024/10/6-5-highlight-grid-1024x576.png 1024w, https://fa.wordpress.org/files/2024/10/6-5-highlight-grid-300x169.png 300w, https://fa.wordpress.org/files/2024/10/6-5-highlight-grid-768x432.png 768w, https://fa.wordpress.org/files/2024/10/6-5-highlight-grid-1536x864.png 1536w, https://fa.wordpress.org/files/2024/10/6-5-highlight-grid-2048x1153.png 2048w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a></figure>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">با کتابخانه فونت آشنا شوید</h2>\n\n\n\n<p>بدون کدنویسی یا مراحل اضافی، کنترل یک قطعه ضروری از طراحی سایت خود – تایپوگرافی – را حفظ کنید.</p>\n\n\n\n<p>فونت‌های محلی و گوگل را به راحتی برای هر تم بلوکی نصب، حذف و فعال کنید. گنجاندن مجموعه‌های تایپوگرافی سفارشی به سازندگان سایت و ناشران، حق انتخاب بیشتری می‌دهد.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">پس زمینه و ابزار سایه پیشرفته</h2>\n\n\n\n<p>با استفاده از ابزارهای طراحی به‌روز، راه‌های بیشتری برای افزودن جذابیت بصری به چیدمان‌ها بیابید. تنظیمات اندازه، تکرار و نقطه کانونی را روی تصاویر پس زمینه خود کنترل کنید تا آن‌ها را با هم ترکیب و یا برجسته کنید. با افزودن پشتیبانی از سایه‌ها به بلوک‌های بیشتر، در طرح‌هایتان عمق بصری ایجاد و یا کمی هویت به آن‌ها تزریق کنید.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">جزئیات بیشتری را از اصلاحات استایل خود دریافت کنید</h2>\n\n\n\n<p>پروژه‌های خلاقانه را با داشتن تصویر کامل‌تری از آنچه انجام شده است — و آنچه می‌توانید به آن برگردید، انجام بدهید. جزئیاتی مانند نشان‌های زمانی، خلاصه‌ی سریع و فهرست صفحه‌بندی‌شده‌ی همه ویرایش‌ها را دریافت کنید. برای مشاهده تغییرات، خارج از آنچه روی آن کار می‌کنید، به ویرایش‌های موجود در کتابچه سبک نگاه کنید. اکنون رونوشت‌ها برای الگوها و اجزای قالب نیز در دسترس است.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">کنترل بهتر لینک</h2>\n\n\n\n<p>پیوندها را به راحتی با تجربه پیوندسازی قابل درک‌تر ایجاد و مدیریت کنید، با یک رابط کاربری ساده و میانبرهایی برای کپی کردن پیوندها.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">نماهای داده جدید را کاوش کنید</h2>\n\n\n\n<p>هر بخش از سایت شما با کتابخانه‌ای از اطلاعات و داده‌ها همراه است — اکنون، می‌توانید آنچه را که نیاز دارید به سرعت پیدا کنید و آن را هر طور که دوست دارید سازماندهی کنید. نماهای داده برای صفحات، قالب‌ها، الگوها و بخش‌های قالب به شما امکان می‌دهد داده‌ها را در یک نمای جدول یا شبکه‌ای مشاهده کنید، با گزینه‌هایی برای تغییر زمینه‌ها و ایجاد تغییرات دسته‌جمعی.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">به‌روزرسانی عملکرد</h2>\n\n\n\n<p>این نگارش شامل بیش از ۱۱۰ به روز‌رسانی عملکرد، با افزایش چشمگیر سرعت و کارایی در ویرایشگر پست و ویرایشگر سایت است. بارگیری بیش از دو برابر سریعتر از نگارش ۶٫۴ است، با سرعت پردازش ورودی تا پنج برابر سریعتر از نگارش قبلی. زمان بارگذاری سایت‌های ترجمه شده تا ۲۵٪ در این نگارش بهبود یافته‌ است.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">بهبود دسترسی</h2>\n\n\n\n<p>این نگارش شامل بیش از ۶۵ بهبود دسترسی‌پذیری در سراسر پلتفرم است که آن را بیش از همیشه در دسترس قرار می‌دهد. این شامل یک اصلاح مهم است که دسترسی به منوهای فرعی مدیریت را برای کاربران صفحه‌خوان و دیگرانی که با صفحه‌کلید پیمایش می‌کنند، رفع انسداد می‌کند. این نگارش همچنین اصلاحاتی را برای کنتراست رنگ در حالت‌های تمرکز مدیر، موقعیت‌یابی عناصر و فوکوس مکان‌نما و موارد بسیار دیگر، اضافه می‌کند که به بهبود تجربه وردپرس برای همه کمک می‌کند.</p>\n\n\n\n<p></p>\n\n\n\n<p>تازه‌ترین نگارش <a href=\"https://make.wordpress.org/core/2024/03/15/wordpress-6-5-field-guide/\">راهنمای زمینهٔ وردپرس</a> را بررسی نمایید. سرشار از یادداشت‌های دقیق توسعه‌دهنده است که به شما کمک می‌کند با وردپرس بسازید.</p>\n\n\n\n<div class=\"wp-block-buttons is-horizontal is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-03627597 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-vivid-cyan-blue-background-color has-text-color has-background wp-element-button\" href=\"https://fa.wordpress.org/download/\" style=\"border-radius:8px;color:#ffffff\" target=\"_blank\" rel=\"noreferrer noopener\">دریافت وردپرس فارسی</a></div>\n</div>\n\n\n\n<p>برای اطلاعات بیشتر دربارهٔ پیشرفت‌ها و مشکلات حل شده، اطلاعات نصب، یادداشت‌های توسعه‌دهنده و منابع، همکاری‌کنندگان در انتشار، و فهرست تغییرات پرونده در این نسخه <a href=\"https://wordpress.org/documentation/wordpress-version/version-6-5/\">یادداشت‌های انتشار وردپرس ۶.۲ را بخوانید</a>.</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"1076\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"وردپرس فارسی نگارش ۶.۴\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:121:\"https://fa.wordpress.org/2023/11/07/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-6-4-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 07 Nov 2023 11:20:10 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://fa.wordpress.org/?p=905\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:600:\"این نسخه جدید از وردپرس، یک قالب پیش‌فرض جدید و چندین ارتقاء جهت تقویت هر مرحله از سفر خلاقانه‌تان را معرفی می‌کند. محتوای خود را به‌صورت بی‌درنگ با بهبودهای بیشتر در نوشتن ایجاد کنید. با ابزارهای بهبود یافته، راه‌های بیشتری برای زنده‌سازی دیدگاه‌های خود بیابید و ویرایش سایت را با ابزارهای پیشرفته ساده‌تر کنید. انعطاف [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Farhad Sakhaei\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1955:\"\n<p>این نسخه جدید از وردپرس، یک قالب پیش‌فرض جدید و چندین ارتقاء جهت تقویت هر مرحله از سفر خلاقانه‌تان را معرفی می‌کند. محتوای خود را به‌صورت بی‌درنگ با بهبودهای بیشتر در نوشتن ایجاد کنید. با ابزارهای بهبود یافته، راه‌های بیشتری برای زنده‌سازی دیدگاه‌های خود بیابید و ویرایش سایت را با ابزارهای پیشرفته ساده‌تر کنید. انعطاف بی‌نظیر ساختار با بلوک‌ها را کشف کنید و به ایده‌های خود اجازه بدهید که پرواز کنند.</p>\n\n\n\n<p>بسیاری از ویژگی‌ها و بهبودهای وردپرس 6.4 در دسته &#8220;کوچک اما قدرتمند&#8221; قرار دارند. همراه با زیبایی چند منظوره قالب Twenty Twenty-Four (دو هزار و بیست و چهار)، این به‌روزرسانی‌ها به خالقان محتوا و توسعه‌دهندگان سایت کمک می‌کنند تا زمان و تلاش خود را صرفه‌جویی کنند و در عین حال تجربه وردپرس با ارزش و کم دردسر را که جهان انتظار دارده است، ارائه دهند.</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full\"><a href=\"https://fa.wordpress.org/files/2024/02/tt41.png\"><img decoding=\"async\" width=\"1024\" height=\"666\" src=\"https://fa.wordpress.org/files/2024/02/tt41.png\" alt=\"وردپرس 6.4\" class=\"wp-image-906\" srcset=\"https://fa.wordpress.org/files/2024/02/tt41.png 1024w, https://fa.wordpress.org/files/2024/02/tt41-300x195.png 300w, https://fa.wordpress.org/files/2024/02/tt41-768x500.png 768w\" sizes=\"(max-width: 1024px) 100vw, 1024px\" /></a><figcaption class=\"wp-element-caption\">وردپرس 6.4</figcaption></figure>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"905\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"وردپرس فارسی نگارش ۶.۳\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://fa.wordpress.org/2023/08/20/wordpress-6-3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 20 Aug 2023 20:15:49 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://fa.wordpress.org/?p=858\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:513:\"با وردپرس 6.3 شما می‌توانید وب سایت‌های زیبا و جذاب‌تر از همیشه ایجاد کنید. چه بخواهید یک سایت کامل بدون کدنویسی بسازید یا یک توسعه دهنده باشید که به دنبال سفارشی کردن تمام جزئیات است، وردپرس 6.3 چیزی برای جلب توجه شما دارد. با باز کردن بسته بندی و کاوش در این آخرین نسخه، عملکردها [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Saeed Fard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2248:\"\n<p>با وردپرس 6.3 شما می‌توانید وب سایت‌های زیبا و جذاب‌تر از همیشه ایجاد کنید. چه بخواهید یک سایت کامل بدون کدنویسی بسازید یا یک توسعه دهنده باشید که به دنبال سفارشی کردن تمام جزئیات است، وردپرس 6.3 چیزی برای جلب توجه شما دارد. با باز کردن بسته بندی و کاوش در این آخرین نسخه، عملکردها و پیمایش به روز شده ای را خواهید دید که به شما کمک می کند با تلاش کمتر کار کنید و ایجاد کنید، ابزارهایی طراحی کنید که کنترل بیشتری بر طرح بندی به شما می‌دهد، و عملکردهای افزوده شده‌ای را که تجربه ساخت سایت را غنی می کند. وردپرس 6.3 فصل مهمی را در تکامل وردپرس به عنوان ابزاری برای بیان مشخص می‌کند. این نقطه اوج سال‌ها کار صدها مشارکت‌کننده است که تجربه ویرایش قوی‌تر و منسجم‌تری را برای ساخت وب‌سایت‌هایی با بلوک به ارمغان می‌آورد. این به تلاش برای قابل دسترس ساختن انتشار وب برای همه ادامه می دهد &#8211; بنابراین فقط یک شروع جدید است!</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://i0.wp.com/wordpress.org/news/files/2023/08/site-editor-2.png?resize=1024%2C666&amp;ssl=1\" alt=\"\" /></figure>\n\n\n\n<p>وردپرس جدید را از لینک زیر دریافت نمایید.</p>\n\n\n\n<div class=\"wp-block-buttons is-horizontal is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-03627597 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-vivid-cyan-blue-background-color has-text-color has-background wp-element-button\" href=\"https://fa.wordpress.org/download/\" style=\"border-radius:8px;color:#ffffff\" target=\"_blank\" rel=\"noreferrer noopener\">دریافت وردپرس فارسی</a></div>\n</div>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"858\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"وردپرس فارسی نگارش ۶.۲\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:162:\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 05 Apr 2023 07:13:28 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://fa.wordpress.org/?p=760\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:580:\"وردپرس ۶.۲ شامل بیش از ۲۹۲ بهبود و ۳۹۴ رفع مشکل است. این برگه آخرین امکانات برجسته را از زمان انتشار وردپرس ۶.۱ در نوامبر ۲۰۲۲ نشان می‌دهد. تازه‌ترین نگارش راهنمای زمینهٔ وردپرس را بررسی نمایید. سرشار از یادداشت‌های دقیق توسعه‌دهنده است که به شما کمک می‌کند با وردپرس بسازید. برای اطلاعات بیشتر دربارهٔ پیشرفت‌ها [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Morteza Geransayeh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:10296:\"\n<p>وردپرس ۶.۲ شامل بیش از ۲۹۲ بهبود و ۳۹۴ رفع مشکل است. این برگه آخرین امکانات برجسته را از زمان انتشار وردپرس ۶.۱ در نوامبر ۲۰۲۲ نشان می‌دهد.</p>\n\n\n\n<div class=\"wp-block-jetpack-tiled-gallery alignfull is-style-rectangular\"><div class=\"tiled-gallery__gallery\"><div class=\"tiled-gallery__row\"><div class=\"tiled-gallery__col\" style=\"flex-basis:66.70764%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-site-editor.png\"><img decoding=\"async\" srcset=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-site-editor.png?strip=info&#038;w=600&#038;ssl=1 600w,https://i0.wp.com/fa.wordpress.org/files/2023/04/about-site-editor.png?strip=info&#038;w=872&#038;ssl=1 872w\" alt=\"\" data-height=\"872\" data-id=\"763\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-site-editor/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-site-editor.png\" data-width=\"872\" src=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-site-editor.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div><div class=\"tiled-gallery__col\" style=\"flex-basis:33.29236%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-navigation.png\"><img decoding=\"async\" srcset=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-navigation.png?strip=info&#038;w=600&#038;ssl=1 600w,https://i0.wp.com/fa.wordpress.org/files/2023/04/about-navigation.png?strip=info&#038;w=872&#038;ssl=1 872w\" alt=\"\" data-height=\"872\" data-id=\"764\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-navigation/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-navigation.png\" data-width=\"872\" src=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-navigation.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-block-inserter.png\"><img decoding=\"async\" srcset=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-block-inserter.png?strip=info&#038;w=600&#038;ssl=1 600w,https://i0.wp.com/fa.wordpress.org/files/2023/04/about-block-inserter.png?strip=info&#038;w=872&#038;ssl=1 872w\" alt=\"\" data-height=\"872\" data-id=\"765\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-block-inserter/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-block-inserter.png\" data-width=\"872\" src=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-block-inserter.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div></div><div class=\"tiled-gallery__row\"><div class=\"tiled-gallery__col\" style=\"flex-basis:33.33333%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-split-controls-fixed.png\"><img decoding=\"async\" srcset=\"https://i1.wp.com/fa.wordpress.org/files/2023/04/about-split-controls-fixed.png?strip=info&#038;w=600&#038;ssl=1 600w,https://i1.wp.com/fa.wordpress.org/files/2023/04/about-split-controls-fixed.png?strip=info&#038;w=872&#038;ssl=1 872w\" alt=\"\" data-height=\"872\" data-id=\"766\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-split-controls-fixed/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-split-controls-fixed.png\" data-width=\"872\" src=\"https://i1.wp.com/fa.wordpress.org/files/2023/04/about-split-controls-fixed.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div><div class=\"tiled-gallery__col\" style=\"flex-basis:33.33333%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-openverse.png\"><img decoding=\"async\" srcset=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-openverse.png?strip=info&#038;w=600&#038;ssl=1 600w,https://i0.wp.com/fa.wordpress.org/files/2023/04/about-openverse.png?strip=info&#038;w=872&#038;ssl=1 872w\" alt=\"\" data-height=\"872\" data-id=\"767\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-openverse/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-openverse.png\" data-width=\"872\" src=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-openverse.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div><div class=\"tiled-gallery__col\" style=\"flex-basis:33.33333%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-headers.png\"><img decoding=\"async\" srcset=\"https://i1.wp.com/fa.wordpress.org/files/2023/04/about-headers.png?strip=info&#038;w=600&#038;ssl=1 600w,https://i1.wp.com/fa.wordpress.org/files/2023/04/about-headers.png?strip=info&#038;w=872&#038;ssl=1 872w\" alt=\"\" data-height=\"872\" data-id=\"768\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-headers/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-headers.png\" data-width=\"872\" src=\"https://i1.wp.com/fa.wordpress.org/files/2023/04/about-headers.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div></div><div class=\"tiled-gallery__row\"><div class=\"tiled-gallery__col\" style=\"flex-basis:25.00000%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-out-of-beta.png\"><img decoding=\"async\" srcset=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-out-of-beta.png?strip=info&#038;w=600&#038;ssl=1 600w,https://i0.wp.com/fa.wordpress.org/files/2023/04/about-out-of-beta.png?strip=info&#038;w=872&#038;ssl=1 872w\" alt=\"\" data-height=\"872\" data-id=\"769\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-out-of-beta/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-out-of-beta.png\" data-width=\"872\" src=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-out-of-beta.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div><div class=\"tiled-gallery__col\" style=\"flex-basis:25.00000%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-distraction-free.png\"><img decoding=\"async\" srcset=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-distraction-free.png?strip=info&#038;w=600&#038;ssl=1 600w,https://i0.wp.com/fa.wordpress.org/files/2023/04/about-distraction-free.png?strip=info&#038;w=872&#038;ssl=1 872w\" alt=\"\" data-height=\"872\" data-id=\"770\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-distraction-free/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-distraction-free.png\" data-width=\"872\" src=\"https://i0.wp.com/fa.wordpress.org/files/2023/04/about-distraction-free.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div><div class=\"tiled-gallery__col\" style=\"flex-basis:25.00000%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-custom-css.png\"><img decoding=\"async\" srcset=\"https://i2.wp.com/fa.wordpress.org/files/2023/04/about-custom-css.png?strip=info&#038;w=560&#038;ssl=1 560w\" alt=\"\" data-height=\"560\" data-id=\"771\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-custom-css/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-custom-css.png\" data-width=\"560\" src=\"https://i2.wp.com/fa.wordpress.org/files/2023/04/about-custom-css.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div><div class=\"tiled-gallery__col\" style=\"flex-basis:25.00000%\"><figure class=\"tiled-gallery__item\"><a href=\"https://fa.wordpress.org/files/2023/04/about-copy-paste.png\"><img decoding=\"async\" srcset=\"https://i2.wp.com/fa.wordpress.org/files/2023/04/about-copy-paste.png?strip=info&#038;w=560&#038;ssl=1 560w\" alt=\"\" data-height=\"560\" data-id=\"772\" data-link=\"https://fa.wordpress.org/2023/04/05/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b6-%db%b2-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/about-copy-paste/\" data-url=\"https://fa.wordpress.org/files/2023/04/about-copy-paste.png\" data-width=\"560\" src=\"https://i2.wp.com/fa.wordpress.org/files/2023/04/about-copy-paste.png?ssl=1\" data-amp-layout=\"responsive\" /></a></figure></div></div></div></div>\n\n\n\n<p></p>\n\n\n\n<p>تازه‌ترین نگارش <a href=\"https://make.wordpress.org/core/2023/03/09/wordpress-6-2-field-guide/\">راهنمای زمینهٔ وردپرس</a> را بررسی نمایید. سرشار از یادداشت‌های دقیق توسعه‌دهنده است که به شما کمک می‌کند با وردپرس بسازید.</p>\n\n\n\n<div class=\"wp-block-buttons is-horizontal is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-03627597 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-vivid-cyan-blue-background-color has-text-color has-background wp-element-button\" href=\"https://fa.wordpress.org/download/\" style=\"border-radius:8px;color:#ffffff\" target=\"_blank\" rel=\"noreferrer noopener\">دریافت وردپرس فارسی</a></div>\n</div>\n\n\n\n<p>برای اطلاعات بیشتر دربارهٔ پیشرفت‌ها و مشکلات حل شده، اطلاعات نصب، یادداشت‌های توسعه‌دهنده و منابع، همکاری‌کنندگان در انتشار، و فهرست تغییرات پرونده در این نسخه <a href=\"https://wordpress.org/documentation/wordpress-version/version-6-2/\">یادداشت‌های انتشار وردپرس ۶.۲ را بخوانید</a>.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"760\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"وردپرس فارسی نگارش ۵٫۸\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:167:\"https://fa.wordpress.org/2020/12/09/%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%db%b5%d9%ab%db%b8-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 09 Dec 2020 14:35:04 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://fa.wordpress.org/?p=662\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:611:\"&#8212; سه نیروی اساسی مدیریت ابزارک‌ها با بلوک‌ها بعد از ماه‌ها کار سخت، بلوک‌های پر قدرت ویرایشگر ابزارک‌های بلوکی و سفارشی‌ساز آمده‌اند. هم‌اکنون شما می‌توانید بلوک‌ها را از هر دو طریق ناحیه‌های ابزارک سایتتان و پیش‌نمایش زنده سفارشی‌ساز اضافه کنید. این امکانات جدیدی را برای ایجاد محتوا ایجاد می کند: از طرح بندی کوچک بدون [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Morteza Geransayeh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:16226:\"\n<p class=\"has-text-align-center has-white-color has-text-color\">&#8212;</p>\n\n\n\n<h2 class=\"has-text-align-center has-large-font-size wp-block-heading\"> سه نیروی اساسی </h2>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile\" style=\"grid-template-columns:60% auto\"><figure class=\"wp-block-media-text__media\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"768\" src=\"https://fa.wordpress.org/files/2021/07/about-widgets-blocks-1024x768.png\" alt=\"\" class=\"wp-image-698 size-full\" srcset=\"https://fa.wordpress.org/files/2021/07/about-widgets-blocks-1024x768.png 1024w, https://fa.wordpress.org/files/2021/07/about-widgets-blocks-300x225.png 300w, https://fa.wordpress.org/files/2021/07/about-widgets-blocks-768x576.png 768w, https://fa.wordpress.org/files/2021/07/about-widgets-blocks-440x330.png 440w, https://fa.wordpress.org/files/2021/07/about-widgets-blocks.png 1280w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></figure><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\">مدیریت ابزارک‌ها با بلوک‌ها</h3>\n\n\n\n<p>بعد از ماه‌ها کار سخت، بلوک‌های پر قدرت ویرایشگر ابزارک‌های بلوکی و سفارشی‌ساز آمده‌اند. هم‌اکنون شما می‌توانید بلوک‌ها را از هر دو طریق ناحیه‌های ابزارک سایتتان و پیش‌نمایش زنده سفارشی‌ساز اضافه کنید. این امکانات جدیدی را برای ایجاد محتوا ایجاد می کند: از طرح بندی کوچک بدون کد گرفته تا کتابخانه گسترده بلوک‌های اصلی و شخص ثالث. برای توسعه‌دهندگانمان، شما می‌توانید جزئیات بیشتر را در <a href=\"https://make.wordpress.org/core/2021/06/29/block-based-widgets-editor-in-wordpress-5-8/\">یادداشت توسعه ابزارک‌ها</a> پیدا کنید.</p>\n</div></div>\n\n\n\n<div class=\"wp-block-media-text alignwide has-media-on-the-right is-stacked-on-mobile\" style=\"grid-template-columns:auto 60%\"><figure class=\"wp-block-media-text__media\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"811\" src=\"https://fa.wordpress.org/files/2021/07/about-query-loop-1024x811.png\" alt=\"\" class=\"wp-image-697 size-full\" srcset=\"https://fa.wordpress.org/files/2021/07/about-query-loop-1024x811.png 1024w, https://fa.wordpress.org/files/2021/07/about-query-loop-300x238.png 300w, https://fa.wordpress.org/files/2021/07/about-query-loop-768x608.png 768w, https://fa.wordpress.org/files/2021/07/about-query-loop.png 1280w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></figure><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\">نمایش نوشته‌ها با بلوک‌ها و الگوهای جدید</h3>\n\n\n\n<p>بلوک چرخه درخواست امکان نمایش نوشته‌ها را براساس پارامترهای تعیین‌شده فراهم می‌کند؛ نظیر یک چرخه PHP بدون کدنویسی. به آسانی نوشته‌های یک دسته خاص را نمایش دهید یا کارهایی نظیر ایجاد یک برگه نمونه کار یا یک برگه کامل از دستورات آشپزی مورد علاقه شما انجام دهید. به بلوک آخرین نوشته‌ها به عنوان یک بلوک بسیار پیچیده و قوی فکر کنید! به علاوه، پیشنهادات الگو باعث می‌شود تا ایجاد لیستی از نوشته‌ها با طراحی مورد نظرتان آسان‌تر از گذشته قابل انجام باشد.</p>\n</div></div>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile\" style=\"grid-template-columns:60% auto\"><figure class=\"wp-block-media-text__media\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"666\" src=\"https://fa.wordpress.org/files/2020/12/about-template-1024x666.png\" alt=\"\" class=\"wp-image-699 size-full\" srcset=\"https://fa.wordpress.org/files/2020/12/about-template-1024x666.png 1024w, https://fa.wordpress.org/files/2020/12/about-template-300x195.png 300w, https://fa.wordpress.org/files/2020/12/about-template-768x499.png 768w, https://fa.wordpress.org/files/2020/12/about-template.png 1280w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></figure><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\">ویرایش قالب اطراف نوشته‌ها</h3>\n\n\n\n<p>شما می‌توانید از ویرایشگر بلوک آشنا برای ویرایش قالب‌هایی که محتوای شما را در اختیار دارند استفاده کنید—به سادگی یک بلوک پوسته یا یک پوسته را که این ویژگی را انتخاب کرده است فعال کنید. از ویرایش نوشته‌ها به ویرایش برگه‌های خود بروید و دوباره بازگردید، همه اینها در حالی‌است که از ویرایشگر بلوک آشنا استفاده می‌کنید. بیش از ۲۰ بلوک جدید سارگاز با پوسته‌ها در دسترس است. در مورد این قابلیت و اینکه چطور می‌توان آن را تجربه کرد در یادداشت‌های انتشار بخوانید.</p>\n</div></div>\n\n\n\n<p> </p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"has-text-align-center has-large-font-size wp-block-heading\">سه همیار گردش کار</h2>\n\n\n\n<div class=\"wp-block-media-text alignwide has-media-on-the-right is-stacked-on-mobile\" style=\"grid-template-columns:auto 60%\"><figure class=\"wp-block-media-text__media\"><a href=\"https://fa.wordpress.org/files/2020/12/about-list-view.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"803\" src=\"https://fa.wordpress.org/files/2020/12/about-list-view-1024x803.png\" alt=\"\" class=\"wp-image-700 size-full\" srcset=\"https://fa.wordpress.org/files/2020/12/about-list-view-1024x803.png 1024w, https://fa.wordpress.org/files/2020/12/about-list-view-300x235.png 300w, https://fa.wordpress.org/files/2020/12/about-list-view-768x602.png 768w, https://fa.wordpress.org/files/2020/12/about-list-view.png 1280w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\">نمای کلی ساختار برگه</h3>\n\n\n\n<p>گاهی شما نیاز به یک برگه فرود ساده نیاز داری ، اما گاهی نیاز به یک چیز قوی‌تر دارید. با اضافه شدن بلوک‌ها‌ی بیشتر، ادغام الوگها، و آسان شده ایجاد محتوا، راه‌حل‌های جدیدی لازم است تا بتوان محتوای پیچیده را به راحتی جستجو کرد. مشاهده فهرستی بهترین راه برای پرش بین لایه‌های محتوا و بلوک‌های تو در تو است. از آنجا که مشاهده فهرستی به شما یک نمای کلی از تمام بلوک‌های محتوای شما می‌دهد، اکنون می‌توانید به سرعت و دقیق به بلوک مورد نیاز خود بروید. آماده تمرکز کامل بر روی محتوای خود هستید؟ این را متناسب با گردش کار خود روشن یا خاموش کنید.</p>\n</div></div>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile\" style=\"grid-template-columns:60% auto\"><figure class=\"wp-block-media-text__media\"><a href=\"https://fa.wordpress.org/files/2020/12/about-pattern-suggestions.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"555\" src=\"https://fa.wordpress.org/files/2020/12/about-pattern-suggestions-1024x555.png\" alt=\"\" class=\"wp-image-701 size-full\" srcset=\"https://fa.wordpress.org/files/2020/12/about-pattern-suggestions-1024x555.png 1024w, https://fa.wordpress.org/files/2020/12/about-pattern-suggestions-300x163.png 300w, https://fa.wordpress.org/files/2020/12/about-pattern-suggestions-768x416.png 768w, https://fa.wordpress.org/files/2020/12/about-pattern-suggestions.png 1280w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\">الگوهای پیشنهادی برای بلوک‌ها</h3>\n\n\n\n<p>شروع در این نسخه ابزار دگرگونی الگو که الگوهای بلوک را بر اساس بلوکی که استفاده می‌کنید پیشنهاد می‌دهد. هم‌اکنون، می‌توانید این را در بلوک کوئری و بلوک آیکون شبکه‌های اجتماعی استفاده نمایید. با اضافه شدن الگوهای بیشتر، شما می‌توانید از نحوه سبک دادن به سایت خود بدون اینکه هرگز از ویرایشگر خارج شوید الهام بگیرید!</p>\n</div></div>\n\n\n\n<div class=\"wp-block-media-text alignwide has-media-on-the-right is-stacked-on-mobile\" style=\"grid-template-columns:auto 60%\"><figure class=\"wp-block-media-text__media\"><a href=\"https://fa.wordpress.org/files/2020/12/about-duotone.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"837\" src=\"https://fa.wordpress.org/files/2020/12/about-duotone-1024x837.png\" alt=\"\" class=\"wp-image-702 size-full\" srcset=\"https://fa.wordpress.org/files/2020/12/about-duotone-1024x837.png 1024w, https://fa.wordpress.org/files/2020/12/about-duotone-300x245.png 300w, https://fa.wordpress.org/files/2020/12/about-duotone-768x628.png 768w, https://fa.wordpress.org/files/2020/12/about-duotone.png 1280w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\" /></a></figure><div class=\"wp-block-media-text__content\">\n<h3 class=\"wp-block-heading\">سبک‌دهی و رنگ‌آمیزی تصاویر</h3>\n\n\n\n<p>با جلوه دوتون عکس‌ها و بلوک‌های پوشش را رنگی کنید! دوتون می‌تواند رنگ‌های زیادی را به طرح و سبک عکس‌های شما (یا ویدئوهایی در بلوک پوشش) برای ادغام خوب در پوسته‌های شما اضافه کند. شما می‌توانید جلوه دوتون را به عنوان یک فیلتر سیاه و سفید تصور کنید، اما به جای اینکه سایه‌ها سیاه و سفید و هایلایت باشند، رنگ‌های خود را برای سایه‌ها و هایلایت‌ها انتخاب می‌کنید. چیزهای بیشتری برای آموختن کارکرد آن در مستندات وجود دارد.</p>\n</div></div>\n\n\n\n<p></p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"has-text-align-center has-large-font-size wp-block-heading\">برای توسعه‌دهندگان که بررسی کنند</h2>\n\n\n\n<figure class=\"wp-block-image size-full\"><a href=\"https://fa.wordpress.org/files/2020/12/about-theme-json.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1020\" height=\"610\" src=\"https://fa.wordpress.org/files/2020/12/about-theme-json.png\" alt=\"\" class=\"wp-image-703\" srcset=\"https://fa.wordpress.org/files/2020/12/about-theme-json.png 1020w, https://fa.wordpress.org/files/2020/12/about-theme-json-300x179.png 300w, https://fa.wordpress.org/files/2020/12/about-theme-json-768x459.png 768w\" sizes=\"auto, (max-width: 1020px) 100vw, 1020px\" /></a></figure>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:25%\"></div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:50%\">\n<h3 class=\"wp-block-heading\">Theme.json</h3>\n\n\n\n<p>معرفی APIهای تنظیمات عمومی و سبک‌های عمومی: تنظیمات ویرایشگر، ابزارهای شخصی‌سازی در دسترس، و سبک‌های بلوک‌ها را با استفاده از پرونده theme.json در پوسته فعال کنترل کنید. این پرونده پیکربندی قابلیت‌ها و مجموعه سبک‌های پیش‌فرض برای سایت و بلوک‌ها را فعال یا غیرفعال می‌کند. اگر شما پوسته می‌سازید، شما می‌توانید این ویژگی جدید مفید را آزمایش کنید. برای اینکه بدانید هم‌اکنون چه چیزی در دسترس است و چگونه کار می‌کند، <a href=\"https://make.wordpress.org/core/2021/06/25/introducing-theme-json-in-wordpress-5-8/\">این توضیحات فنی را بخوانید</a>.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\" style=\"flex-basis:25%\"></div>\n</div>\n\n\n\n<p></p>\n\n\n\n<div class=\"wp-block-columns is-layout-flex wp-container-core-columns-is-layout-28f84493 wp-block-columns-is-layout-flex\">\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h3 class=\"wp-block-heading\">کنار گذاشتن پشتیبانی از اینترنت اکسپلورر ۱۱</h3>\n\n\n\n<p>در این انتشار، پشتیبانی از اینترنت اکسپلورر ۱۱ کنار گذاشته شده است. این یعنی شما ممکن است نیاز به مدیریت مشکلاتی روی وبگاه‌تان داشته باشید که در آینده رفع نخواهند شد. اگر در حال حاضر از اینترنت اکسپلورر ۱۱ استفاده می‌کنید، اکیدا پیشنهاد می‌کنیم که <a href=\"https://browsehappy.com/\">به مرورگر مدرن‌تری نقل مکان کنید</a>.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h3 class=\"wp-block-heading\">افزودن پشتیبانی از WebP</h3>\n\n\n\n<p>WebP یک قالب ذخیره تصویر مدرن است که امکان فشرده‌سازی بی‌اتلاف و یا بااتلاف بهبودیافته را برای تصاویر در فضای وب فراهم می‌کند. تصاویر WebP به طور میانگین حدود ۳۰٪ کم‌حجم‌تر از معادل‌های‌شان در قالب‌های JPEG و PNG هستند که این یعنی وب‌گاه‌ها سریع‌تر شده و پهنای باند کم‌تری مصرف می‌کنند.</p>\n</div>\n\n\n\n<div class=\"wp-block-column is-layout-flow wp-block-column-is-layout-flow\">\n<h3 class=\"wp-block-heading\">افزودن پشتیبانی بلوک اضافی</h3>\n\n\n\n<p>به عنوان قابلیتی بسط داده شده بر روی پشتیبانی بلوک پیاده‌سازی شده در وردپرس <a href=\"https://make.wordpress.org/core/2020/11/18/block-supports-in-wordpress-5-6/\">۵٫۶</a> و <a href=\"https://make.wordpress.org/core/2021/02/24/changes-to-block-editor-components-and-blocks/\">۵٬۷</a>، وردپرس ۵٫۸ چندین پرچم و گزینه پشتیبانی بلوک جدید را برای سفارشی‌سازی بلوک‌های ثبت شده معرفی می‌کند. اطلاعات بیشتر در <a href=\"https://make.wordpress.org/core/2021/06/25/block-supports-api-updates-for-wordpress-5-8/\">یادداشت توسعه پشتیبانی بلوک</a> در دسترس است.</p>\n</div>\n</div>\n\n\n\n<p></p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-vivid-cyan-blue-background-color has-text-color has-background\" href=\"https://fa.wordpress.org/download/\" style=\"border-radius:8px;color:#ffffff\" target=\"_blank\" rel=\"noreferrer noopener\">دریافت وردپرس فارسی</a></div>\n</div>\n\n\n\n<p></p>\n\n\n\n<h3 class=\"wp-block-heading\">بخش راهنما را برای توضیحات بیشتر بررسی نمایید.</h3>\n\n\n\n<p>آخرین نگارش از راهنمای میدانی وردپرس را بررسی کنید. این یادداشت‌های توسعه‌دهنده برای هر تغییری که شاید بخواهید از آنها آگاه باشید را برجسته می‌کند. <a href=\"https://make.wordpress.org/core/2021/07/03/wordpress-5-8-field-guide/\">راهنمای میدانی وردپرس .۵.۸</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"662\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"وردپرس فارسی نگارش ۵٫۵\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://fa.wordpress.org/2020/08/11/wp-persian-55/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 11 Aug 2020 20:42:24 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://fa.wordpress.org/?p=641\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:570:\"در وردپرس ۵٫۵، سایت شما در سه بخش اصلی قدرت جدیدی گرفته است: سرعت، جستجو و امنیت. سرعت عکس‌ها لِیزی-لود شده‌اند، و سرعت بارگذاری نوشته‌ها و برگه‌ها سریعتر شدند. تصاویر تأثیر زیادی بر محتوایتان می‌گذارند، اما گاهی اوقات می‌توانند باعث کند شدن سایت شما شوند. در وردپرس ۵.۵، عکس‌ها تا زمانی‌ که با اسکرول قابل [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Morteza Geransayeh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:8171:\"\n<p>در وردپرس ۵٫۵، سایت شما در سه بخش اصلی قدرت جدیدی گرفته است: سرعت، جستجو و امنیت.</p>\n\n\n\n<h2 class=\"wp-block-heading\">سرعت</h2>\n\n\n\n<p><strong>عکس‌ها لِیزی-لود شده‌اند، و سرعت بارگذاری</strong> <strong>نوشته‌ها و برگه‌ها سریعتر شدند.</strong></p>\n\n\n\n<p>تصاویر تأثیر زیادی بر محتوایتان می‌گذارند، اما گاهی اوقات می‌توانند باعث کند شدن سایت شما شوند.</p>\n\n\n\n<p>در وردپرس ۵.۵، عکس‌ها تا زمانی‌ که با اسکرول قابل مشاهده می‌شوند، برای بارگذاری صبر می‌کنند. واژه تکنیکال آن &#8216;lazy loading&#8217; است.</p>\n\n\n\n<p>روی موبایل، لِیزی-لود می‌تواند مرورگرها را از دریافت پرونده‌های درنظرگرفته‌شده برای سایر دستگاه‌ها باز دارد. آن می‌تواند باعث صرفه‌جویی خوانندگان شما در داده شود — و کمک کند عمر باتری حفظ شود.</p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">جستجو</h2>\n\n\n\n<p><strong>به نقشهٔ سایت جدید سلام کنید.</strong></p>\n\n\n\n<p>سایت‌های وردپرس با موتورهای جستجو به خوبی کار می‌کنند.</p>\n\n\n\n<p>اکنون، به طور پیش‌فرض، وردپرس ۵.۵ دارای یک نقشهٔ سایت XML است که به موتورهای جستجو کمک می‌کند تا از همان دقایقی آغاز کار، مهم‌ترین برگه‌های شما را کشف کنند.</p>\n\n\n\n<p>بنابراین تعداد بیشتری از افراد سایت شما را زودتر پیدا می‌کنند و به شما فرصت بیشتری می‌دهند تا مشارکت داشته باشند، آنها را حفظ نمایید و به مشترکین، مشتریان یا هر آن‌چه که با تعریف موفقیت شما مناسب باشد، تبدیل نمایید.</p>\n\n\n\n<p></p>\n\n\n\n<div class=\"wp-block-group\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<div class=\"wp-block-group has-background\" style=\"background-color:#ebcd3d\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<h2 class=\"has-background wp-block-heading\" style=\"background-color:#ebcd3d\">امنیت</h2>\n\n\n\n<p><strong>به‌روزرسانی‌های خودکار برای افزونه‌ها و پوسته‌ها</strong></p>\n\n\n\n<p>اکنون می‌توانید افزونه‌ها و پوسته‌ها را تنظیم نمایید تا به صورت خودکار در مدیریت وردپرس به‌روزرسانی شوند — یا نه! —. بنابراین همیشه می‌دانید سایت شما آخرین کد موجود را اجرا می‌نماید.</p>\n\n\n\n<p>همچنین می‌توانید برای هر افزونه یا پوسته‌ای که نصب نموده‌اید، به‌روزرسانی‌های خودکار را روشن یا خاموش نمایید — همه در همان صفحه‌هایی که همیشه از آن‌ها استفاده شده است.</p>\n\n\n\n<p><strong>به‌روزرسانی با بارگذاری پروندهٔ ZIP</strong> <strong>شده</strong></p>\n\n\n\n<p>اگر به‌روزرسانی افزونه‌ها و پوسته‌هایتان به صورت دستی انجام می‌شود، اکنون این کار نیز ساده‌تر است — فقط یک پروندهٔ ZIP را بارگذاری نمایید.</p>\n</div></div>\n</div></div>\n\n\n\n<p></p>\n\n\n\n<div class=\"wp-block-group has-background\" style=\"background-color:#f3ecda\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<div class=\"wp-block-group\"><div class=\"wp-block-group__inner-container is-layout-flow wp-block-group-is-layout-flow\">\n<h2 class=\"wp-block-heading\">نکات برجسته از بلوک ویرایشگر</h2>\n\n\n\n<p>یک بار دیگر، تازه‌ترین نگارش وردپرس فهرست طولانی از ویژگی‌های جدید هیجان‌انگیز را برای ویرایشگر بلوک منتشر نمود. برای نمونه:</p>\n\n\n\n<h4 class=\"wp-block-heading\">الگوهای بلوک</h4>\n\n\n\n<p>الگوهای بلوک جدید ایجاد طرح‌های زیبا، پیچیده را با کمک ترکیبی از متن و رسانه که می‌توانید آنها را مخلوط و متناسب با داستانتان کنید، ساده و سرگرم‌کننده می‌کند.</p>\n\n\n\n<p>شما همچنین می‌توانید الگوهای بلوک را در طیف گسترده‌ای از افزونه‌ها و پوسته‌ها، با تعداد زیادی که بیشتر از همیشه اضافه شده، پیدا کنید. هر یک از آنها را از یک کشویی انتخاب کنید — فقط کلیک کنید و بروید!</p>\n\n\n\n<h4 class=\"wp-block-heading\">ویرایش تصویر توکار</h4>\n\n\n\n<p>تصاویرتان را به درستی از بلوک تصویر برش داده‌، بچرخانید، و زوم نمایید. اگر زمان زیادی را صرف تصاویر می‌نمایید، این می‌تواند در وقت شما ساعت‌ها صرفه‌جویی نماید.</p>\n\n\n\n<h4 class=\"wp-block-heading\">پوشه بلوک جدید</h4>\n\n\n\n<p>حالا این ساده‌تر از هر زمانی است که بلوک موردنیازتان را پیدا کنید. پوشه بلوک جدید برای ویرایشگر بلوک ساخته شده، پس شما می‌توانید نوع‌های بلوک جدیدی برای سایتتان بدون خروج از ویرایشگر نصب کنید.</p>\n\n\n\n<h4 class=\"wp-block-heading\">و خیلی بیشتر.</h4>\n\n\n\n<p>هایلایت‌های بالا بخش کوچکی از امکانات ویرایشگر بلوک جدید است که شما نصب کردید. ویرایشگر بلوک را باز کنید و لذت ببرید!</p>\n</div></div>\n</div></div>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\">دسترس‌پذیری</h2>\n\n\n\n<p>هر نگارش پیشرفت‌هایی را به تجربهٔ دستر‌س‌پذیری انتشار می‌افزاید، و این دربارهٔ وردپرس ۵.۵ نیز صدق می‌کند.</p>\n\n\n\n<p>هم‌اکنون می‌توانید پیوندها را در صفحه رسانه و کادر مودال با یک دکمه، بجای تلاش برای هایلایت کردن یک خط از متن کپی کنید.</p>\n\n\n\n<p>همچنین شما می‌توانید جعبه‌های متا را با صفحه کلید حرکت دهید، و عکس‌ها را در وردپرس با دستگاه کمک‌کننده خود ویرایش کنید، همان‌گونه که این می‌تواند دستورالعمل‌های موجود را در ویرایشگر تصویر بخواند.</p>\n\n\n\n<p></p>\n\n\n\n<div class=\"wp-block-buttons aligncenter is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-vivid-cyan-blue-background-color has-text-color has-background\" href=\"https://fa.wordpress.org/download/\" style=\"border-radius:8px;color:#ffffff\" target=\"_blank\" rel=\"noreferrer noopener\">دریافت وردپرس فارسی</a></div>\n</div>\n\n\n\n<p class=\"has-text-align-center has-text-color\" style=\"color:#ffffff\">&#8230;..</p>\n\n\n\n<h5 class=\"wp-block-heading\">بخش راهنما را برای توضیحات بیشتر بررسی نمایید.</h5>\n\n\n\n<p>چیزهای بیشتری برای دوست‌داران در وردپرس ۵.۵ وجود دارد. برای کاوش بیشتر و آموختن اینکه چطور این تغییرات سایت‌های شما، پوسته‌ها، افزونه‌ها و موارد دیگر را جلا می‌دهند، <a href=\"https://make.wordpress.org/core/wordpress-5-5-field-guide/\">راهنمای زمینه وردپرس ۵.۵</a> را بررسی نمایید.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"641\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:57:\"\n		\n		\n		\n		\n		\n				\n		\n\n					\n										\n					\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:6:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"وردپرس فارسی نگارش ۵٫۴\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:50:\"https://fa.wordpress.org/2020/04/01/wp-persian-54/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 01 Apr 2020 20:16:55 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"اخبار\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"https://fa.wordpress.org/?p=603\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:614:\"وردپرس فارسی ۵٫۴ منتشر شد. مهمترین قابلیت‌های جدید این نگارش را بصورت خلاصه بررسی می‌کنیم: چند بلوک جدید به این نگارش اضافه شده که امکانات جذابی را برای استفاده فراهم کرده‌ کرده‌اند. بلوک آیکون‌های شبکه‌های اجتماعی و بلوک دکمه‌ها و یک بلوک برای ناوبری اضافه شده است. همچنین بهبودهایی در بلوک‌های متنی/رسانه‌ای انجام گرفته. &#8230;.. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:18:\"Morteza Geransayeh\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:6203:\"\n<p>وردپرس فارسی ۵٫۴ منتشر شد. مهمترین قابلیت‌های جدید این نگارش را بصورت خلاصه بررسی می‌کنیم:</p>\n\n\n\n<div class=\"wp-block-media-text alignwide has-media-on-the-right has-background is-stacked-on-mobile\" style=\"background-color:#f3f4f5\"><figure class=\"wp-block-media-text__media\"><img loading=\"lazy\" decoding=\"async\" width=\"500\" height=\"500\" src=\"https://fa.wordpress.org/files/2020/04/blocks-5-5.png\" alt=\"\" class=\"wp-image-605\" srcset=\"https://fa.wordpress.org/files/2020/04/blocks-5-5.png 500w, https://fa.wordpress.org/files/2020/04/blocks-5-5-300x300.png 300w, https://fa.wordpress.org/files/2020/04/blocks-5-5-150x150.png 150w\" sizes=\"auto, (max-width: 500px) 100vw, 500px\" /></figure><div class=\"wp-block-media-text__content\">\n<p style=\"font-size:15px\" class=\"has-text-align-right\">چند بلوک جدید به این نگارش اضافه شده که امکانات جذابی را برای استفاده فراهم کرده‌ کرده‌اند.</p>\n\n\n\n<p style=\"font-size:15px\" class=\"has-text-align-right\">بلوک آیکون‌های شبکه‌های اجتماعی و بلوک دکمه‌ها و یک بلوک برای ناوبری اضافه شده است. همچنین بهبودهایی در بلوک‌های متنی/رسانه‌ای انجام گرفته.</p>\n</div></div>\n\n\n\n<p style=\"color:#ffffff\" class=\"has-text-color has-text-align-center\">&#8230;..</p>\n\n\n\n<div class=\"wp-block-media-text alignwide is-stacked-on-mobile\"><figure class=\"wp-block-media-text__media\"><img loading=\"lazy\" decoding=\"async\" width=\"500\" height=\"500\" src=\"https://fa.wordpress.org/files/2020/04/ui-5-5.png\" alt=\"\" class=\"wp-image-614\" srcset=\"https://fa.wordpress.org/files/2020/04/ui-5-5.png 500w, https://fa.wordpress.org/files/2020/04/ui-5-5-300x300.png 300w, https://fa.wordpress.org/files/2020/04/ui-5-5-150x150.png 150w\" sizes=\"auto, (max-width: 500px) 100vw, 500px\" /></figure><div class=\"wp-block-media-text__content\">\n<p style=\"font-size:15px\" class=\"has-text-align-right\">در این نگارش رابط کاربری ساده‌تر، راهبری واضح‌تر و تب‌زدن ساده‌تر شده است.</p>\n\n\n\n<p style=\"font-size:15px\" class=\"has-text-align-right\">سرعت بارگذاری ۱۴% سریعتر و زمان نوشتن هم ۵۱% سریعتر شده است!</p>\n\n\n\n<p style=\"font-size:15px\" class=\"has-text-align-right\">در این نگارش، در بخش نوشتن، ویرایشگر بصورت پیش‌فرض تمام صفحه شده است.</p>\n</div></div>\n\n\n\n<p style=\"color:#ffffff\" class=\"has-text-color has-text-align-center\">&#8230;..</p>\n\n\n\n<div class=\"wp-block-media-text alignwide has-media-on-the-right has-background is-stacked-on-mobile\" style=\"background-color:#f3f4f5\"><figure class=\"wp-block-media-text__media\"><img loading=\"lazy\" decoding=\"async\" width=\"500\" height=\"500\" src=\"https://fa.wordpress.org/files/2020/04/privacy-5-5.png\" alt=\"\" class=\"wp-image-607\" srcset=\"https://fa.wordpress.org/files/2020/04/privacy-5-5.png 500w, https://fa.wordpress.org/files/2020/04/privacy-5-5-300x300.png 300w, https://fa.wordpress.org/files/2020/04/privacy-5-5-150x150.png 150w\" sizes=\"auto, (max-width: 500px) 100vw, 500px\" /></figure><div class=\"wp-block-media-text__content\">\n<p style=\"font-size:15px\" class=\"has-text-align-right\">در این نگارش همچنان بخش حفظ حریم خصوصی بهبودهای فنی و ظاهری داشته است.</p>\n\n\n\n<p style=\"font-size:15px\" class=\"has-text-align-right\">هم‌اکنون برون‌بری داده‌های شخصی شامل اطلاعات نشست کاربران و داده‌های موقیعت مکانی کاربران به اضافهٔ جدول محتوا در دسترس است.</p>\n</div></div>\n\n\n\n<p style=\"color:#ffffff\" class=\"has-text-color has-text-align-center\">&#8230;..</p>\n\n\n\n<p><strong>برای توسعه دهندگان:</strong></p>\n\n\n\n<p style=\"font-size:15px\">&#8211; زمینه‌های دلخواه به گزینه‌های فهرست افزوده شدند، بدون افزونه و بدون نوشتن واکرهای سفارشی میتوانید آنها را استفاده نمایید.</p>\n\n\n\n<p style=\"font-size:15px\">&#8211; در بلوک‌ها، هم‌اکنون می‌توانید ظاهر بلوک‌ها را به شیوه‌ای که می‌خواهید تغییر دهید.</p>\n\n\n\n<p style=\"font-size:15px\">&#8211; اگر افزونه‌ای دارید، هم‌اکنون می‌توانید بلوک‌هایتان را در دسته‌های مختلف ثبت نمایید — این یک راهکار عالی برای بیشتر دیده شدن برند شما است.</p>\n\n\n\n<p style=\"font-size:15px\">&#8211; به کاربران اجازه دهید با دو API تازه کارهای بیشتری انجام دهند: متغییرهای بلوک و گرادیانت.</p>\n\n\n\n<p style=\"font-size:15px\">&#8211; همچنین در جاسازها، هم‌اکنون ویرایشگر بلوک، TikTok را پشتیبانی می‌کند— و CollegeHumor حذف شد.</p>\n\n\n\n<p></p>\n\n\n\n<p style=\"color:#ffffff\" class=\"has-text-color has-text-align-center\">&#8230;..</p>\n\n\n\n<div class=\"wp-block-buttons aligncenter is-layout-flex wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link has-text-color has-background has-vivid-cyan-blue-background-color\" href=\"https://fa.wordpress.org/download/\" style=\"color:#ffffff;border-radius:8px\" target=\"_blank\" rel=\"noreferrer noopener\">دریافت وردپرس فارسی</a></div>\n</div>\n\n\n\n<p style=\"color:#ffffff\" class=\"has-text-color has-text-align-center\">&#8230;..</p>\n\n\n\n<p>چیزهای بیشتری برای دوست‌داران در وردپرس ۵٫۴ وجود دارد. برای کاوش بیشتر و آموختن اینکه چطور این تغییرات سایت‌های شما، پوسته‌ها، افزونه‌ها و موارد دیگر را زیبایی و بهبود می‌دهند، <a href=\"https://make.wordpress.org/core/2020/03/03/wordpress-5-4-field-guide/\">راهنمای زمینه وردپرس ۵.۴</a> را بررسی نمایید.</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"603\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:35:\"https://fa.wordpress.org/news/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:8:\"13096050\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Tue, 10 Jun 2025 15:27:32 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:37:\"Accept-Encoding, accept, content-type\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Mon, 26 May 2025 10:43:19 GMT\";s:4:\"link\";s:61:\"<https://fa.wordpress.org/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:4:\"gzip\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 2\";}}s:5:\"build\";i:1732000660;s:21:\"cache_expiration_time\";i:1749612452;s:23:\"__cache_expiration_time\";i:1749612452;}", "off");
INSERT INTO `wp_options` VALUES("140", "_transient_timeout_feed_mod_9ba2df8849616f02166b8f7242d75067", "1749612452", "off");
INSERT INTO `wp_options` VALUES("141", "_transient_feed_mod_9ba2df8849616f02166b8f7242d75067", "1749569252", "off");
INSERT INTO `wp_options` VALUES("7097", "_transient_timeout_feed_813f86eb29c12d6094f1acd1445797e5", "1749612453", "off");
INSERT INTO `wp_options` VALUES("7098", "_transient_feed_813f86eb29c12d6094f1acd1445797e5", "a:6:{s:5:\"child\";a:1:{s:0:\"\";a:1:{s:3:\"rss\";a:1:{i:0;a:6:{s:4:\"data\";s:3:\"\n\n\n\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:7:\"version\";s:3:\"2.0\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:1:{s:7:\"channel\";a:1:{i:0;a:6:{s:4:\"data\";s:52:\"\n	\n	\n	\n	\n	\n	\n	\n	\n	\n\n \n	\n		\n		\n		\n		\n		\n		\n		\n		\n		\n	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:4:{s:0:\"\";a:8:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"تیم وردپرس فارسی – WordPress.org فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://fa.wordpress.org/team\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:13:\"lastBuildDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 15 Feb 2025 19:56:46 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"language\";a:1:{i:0;a:5:{s:4:\"data\";s:5:\"fa-IR\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:9:\"generator\";a:1:{i:0;a:5:{s:4:\"data\";s:40:\"https://wordpress.org/?v=6.9-alpha-60294\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"image\";a:1:{i:0;a:6:{s:4:\"data\";s:11:\"\n	\n	\n	\n	\n	\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:1:{s:0:\"\";a:5:{s:3:\"url\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://s.w.org/favicon.ico?2\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:59:\"تیم وردپرس فارسی – WordPress.org فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:29:\"https://fa.wordpress.org/team\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:5:\"width\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:6:\"height\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"32\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}s:4:\"item\";a:10:{i:0;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:52:\"آموزش مشارکت در ترجمه وردپرس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:71:\"https://fa.wordpress.org/team/2025/02/14/how-to-contribute-translation/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:80:\"https://fa.wordpress.org/team/2025/02/14/how-to-contribute-translation/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 14 Feb 2025 03:50:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"مطالب\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://fa.wordpress.org/team/?p=222\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:650:\"مقدمه‌ای بر ترجمه وردپرس فارسی وردپرس به‌عنوان یک سیستم مدیریت محتوای متن‌باز، توسط میلیون‌ها نفر در سراسر جهان استفاده می‌شود. این سیستم با پشتیبانی از افزونه‌ها، پوسته‌ها، و ابزارهای متنوع، به کاربران این امکان را می‌دهد تا وب‌سایت‌های خود را به شکلی کاملاً شخصی‌سازی‌شده مدیریت نمایند. با وجود این امکانات، وردپرس برای کاربران غیربومی تنها [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Saeed Fard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:37076:\"<h2 class=\"wp-block-heading has-medium-font-size\"><strong>مقدمه‌ای بر ترجمه وردپرس فارسی</strong></h2>\n\n\n\n<p>وردپرس به‌عنوان یک سیستم مدیریت محتوای متن‌باز، توسط میلیون‌ها نفر در سراسر جهان استفاده می‌شود. این سیستم با پشتیبانی از افزونه‌ها، پوسته‌ها، و ابزارهای متنوع، به کاربران این امکان را می‌دهد تا وب‌سایت‌های خود را به شکلی کاملاً شخصی‌سازی‌شده مدیریت نمایند. با وجود این امکانات، وردپرس برای کاربران غیربومی تنها در صورتی مفید خواهد بود که به زبان مادری آن‌ها ترجمه شود.</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large is-resized\"><a href=\"https://fa.wordpress.org/team/files/2025/02/wp-translate.jpg\"><img fetchpriority=\"high\" decoding=\"async\" width=\"1024\" height=\"576\" src=\"https://fa.wordpress.org/team/files/2025/02/wp-translate-1024x576.jpg\" alt=\"\" class=\"wp-image-315\" style=\"width:684px;height:auto\" srcset=\"https://fa.wordpress.org/team/files/2025/02/wp-translate-1024x576.jpg 1024w, https://fa.wordpress.org/team/files/2025/02/wp-translate-300x169.jpg 300w, https://fa.wordpress.org/team/files/2025/02/wp-translate-768x432.jpg 768w, https://fa.wordpress.org/team/files/2025/02/wp-translate.jpg 1280w\" sizes=\"(max-width: 1024px) 100vw, 1024px\"></a></figure>\n\n\n\n<p>ترجمه وردپرس فراتر از برگردان متن‌های ساده است؛ این فرآیند شامل تطبیق مفاهیم و عملکردهای وردپرس با فرهنگ، زبان و نیازهای کاربران محلی می‌باشد. در نتیجه، تجربه کاربری بهتری برای کاربران فارسی‌زبان فراهم می‌شود.</p>\n\n\n\n<p>جامعه وردپرس به‌طور داوطلبانه و با تکیه بر همکاری‌های جهانی، فرآیند ترجمه را انجام می‌دهد. این مشارکت هم به بهبود کیفیت ترجمه‌ها کمک می‌کند و هم دسترسی کاربران به وردپرس را تسهیل می‌نماید. برای پیوستن به این جامعه مترجمان، تنها کافی است علاقه‌مند به زبان فارسی و وردپرس باشید.</p>\n\n\n\n<p>در این نوشته به آموزش ترجمه وردپرس فارسی، افزونه‌ها و پوسته‌های آن می‌پردازیم.</p>\n\n\n\n<h2 class=\"wp-block-heading has-medium-font-size\"><strong>چرا ترجمه وردپرس فارسی اهمیت دارد؟</strong></h2>\n\n\n\n<p>وردپرس به‌عنوان یکی از محبوب‌ترین سیستم‌های مدیریت محتوا در جهان، به میلیون‌ها کاربر در سراسر دنیا امکان ساخت وب‌سایت‌ها را می‌دهد. یکی از عوامل موفقیت وردپرس، <strong>انعطاف‌پذیری و جامعه گسترده‌ای</strong> است که به طور مستمر در بهبود آن مشارکت می‌نمایند.</p>\n\n\n\n<p>در این میان، ترجمه وردپرس به زبان‌های مختلف نقش کلیدی در دسترسی بهتر کاربران به این ابزار قدرتمند ایفا می‌کند. وردپرس فارسی نیز با ارائه رابط کاربری و مستندات به زبان فارسی، تجربه کاربران ایرانی را بهبود می‌بخشد. اما این دستاورد تنها به کمک <strong>مشارکت داوطلبانه جامعه مترجمان</strong> امکان‌پذیر است.</p>\n\n\n\n<p>این مقاله به شما کمک می‌کند تا با فرآیند ترجمه وردپرس فارسی آشنا شوید و بتوانید به راحتی به این پروژه جهانی بپیوندید. با مشارکت در ترجمه، نه تنها مهارت‌های خود را تقویت می‌نمایید، بلکه در ساخت ابزارهای دیجیتال برای دیگر فارسی‌زبانان نیز نقش موثری خواهید داشت.</p>\n\n\n\n<span id=\"more-222\"></span>\n\n\n\n<h2 class=\"wp-block-heading has-medium-font-size\"><strong>نحوه ثبت‌نام و ورود به سیستم ترجمه وردپرس</strong></h2>\n\n\n\n<p>برای مشارکت در ترجمه وردپرس فارسی، اولین گام ثبت‌نام و ورود به سیستم ترجمه وردپرس است. این سیستم به شما امکان می‌دهد تا به صورت آنلاین ترجمه‌ها را مشاهده، ویرایش و پیشنهادهای خود را ارسال نمایید. در ادامه، مراحل ثبت‌نام و ورود را بررسی می‌کنیم:</p>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۱. ایجاد حساب کاربری در WordPress.org</strong></p>\n\n\n\n<p>برای مشارکت در ترجمه وردپرس، نیاز به یک حساب کاربری در وب‌سایت <a href=\"https://wordpress.org/\">WordPress.org</a> دارید. اگر هنوز حساب کاربری ندارید، مراحل زیر را دنبال نمایید:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>به صفحه <a href=\"https://login.wordpress.org/register?locale=fa_IR\">ثبت‌نام</a> بروید.</li>\n\n\n\n<li>نام کاربری و آدرس ایمیل خود را وارد نمایید.</li>\n\n\n\n<li>ایمیلی حاوی پیوند تأیید دریافت خواهید کرد. روی آن کلیک نمایید و رمز عبور خود را تنظیم کنید.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image alignleft size-full is-resized\"><a href=\"https://fa.wordpress.org/team/files/2024/12/image-1.png\"><img decoding=\"async\" width=\"589\" height=\"877\" src=\"https://fa.wordpress.org/team/files/2024/12/image-1.png\" alt=\"\" class=\"wp-image-242\" style=\"width:333px;height:auto\" srcset=\"https://fa.wordpress.org/team/files/2024/12/image-1.png 589w, https://fa.wordpress.org/team/files/2024/12/image-1-201x300.png 201w\" sizes=\"(max-width: 589px) 100vw, 589px\"></a></figure>\n\n\n\n<figure class=\"wp-block-image size-full is-resized\"><a href=\"https://fa.wordpress.org/team/files/2024/12/image.png\"><img decoding=\"async\" width=\"528\" height=\"815\" src=\"https://fa.wordpress.org/team/files/2024/12/image.png\" alt=\"\" class=\"wp-image-240\" style=\"width:321px;height:auto\" srcset=\"https://fa.wordpress.org/team/files/2024/12/image.png 528w, https://fa.wordpress.org/team/files/2024/12/image-194x300.png 194w\" sizes=\"(max-width: 528px) 100vw, 528px\"></a></figure>\n\n\n\n<p class=\"has-small-font-size\"></p>\n\n\n\n<p><strong>نکته مهم در مورد ثبت نام:</strong></p>\n\n\n\n<p class=\"has-light-grey-2-background-color has-background\">وردپرس در سیاست‌های ضد هرزنامه خود ثبت نام را برای همه کاربرهای جدید بسته است، به همین دلیل ایمیل تاییدیه بعد از انجام کار بالا برای شما ارسال نخواهد شد، اگر از قبل در وردپرس حساب کاربری ندارید و نیاز به حساب جدید دارید، بعد از انجام کار بالا باید یک ایمیل با ایمیل ثبت‌نامی به آدرس <a href=\"mailto:forum-password-resets@wordpress.org\" target=\"_blank\" rel=\"noreferrer noopener\">forum-password-resets@wordpress.org</a> ارسال کنید و در متن ایمیل (به انگلیسی) توضیح بدید که برای چی نیاز دارید که حساب کاربری جدید بسازید. بعد از مکاتبه با وردپرس و طی کردن این مرحله حساب شما فعال خواهد شد.</p>\n\n\n\n<div style=\"height:27px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۲. ورود به سیستم ترجمه</strong></p>\n\n\n\n<p>پس از ایجاد حساب کاربری، می‌توانید به سیستم ترجمه وردپرس دسترسی پیدا نمایید:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>به صفحه <a href=\"https://translate.wordpress.org/locale/fa/\">ورود وردپرس</a> بروید. با استفاده از اطلاعات حساب کاربری خود، وارد سیستم شوید.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full is-resized\"><a href=\"https://fa.wordpress.org/team/files/2025/02/image-1.png\"><img loading=\"lazy\" decoding=\"async\" width=\"548\" height=\"799\" src=\"https://fa.wordpress.org/team/files/2025/02/image-1.png\" alt=\"\" class=\"wp-image-260\" style=\"width:366px;height:auto\" srcset=\"https://fa.wordpress.org/team/files/2025/02/image-1.png 548w, https://fa.wordpress.org/team/files/2025/02/image-1-206x300.png 206w\" sizes=\"auto, (max-width: 548px) 100vw, 548px\"></a></figure>\n\n\n\n<p></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>پس از ورود، می‌توانید پروژه‌های ترجمه فعال را مشاهده و پروژه مورد نظر خود را انتخاب نمایید.</li>\n</ul>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۳. شروع به مشارکت در ترجمه</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>پس از ورود به سیستم، به بخش <a href=\"https://translate.wordpress.org/locale/fa/\">زبان فارسی</a> بروید.</li>\n\n\n\n<li>یک پروژه، افزونه یا پوسته را انتخاب نمایید.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large\"><a href=\"https://fa.wordpress.org/team/files/2025/02/image.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"362\" src=\"https://fa.wordpress.org/team/files/2025/02/image-1024x362.png\" alt=\"\" class=\"wp-image-258\" srcset=\"https://fa.wordpress.org/team/files/2025/02/image-1024x362.png 1024w, https://fa.wordpress.org/team/files/2025/02/image-300x106.png 300w, https://fa.wordpress.org/team/files/2025/02/image-768x271.png 768w, https://fa.wordpress.org/team/files/2025/02/image-1536x543.png 1536w, https://fa.wordpress.org/team/files/2025/02/image.png 1868w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\"></a></figure>\n\n\n\n<ul class=\"wp-block-list\">\n<li>بعد از ورود به پروژه بخش‌ها و رشته‌های قابل ترجمه مشخص است. زیر پروژه <strong>Stable (latest release)</strong> در این بخش دارای اولویت بالاتری برای ترجمه است و از اینجا شروع می‌کنیم.<br></li>\n</ul>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large\"><a href=\"https://fa.wordpress.org/team/files/2025/02/image-2.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"154\" src=\"https://fa.wordpress.org/team/files/2025/02/image-2-1024x154.png\" alt=\"\" class=\"wp-image-265\" srcset=\"https://fa.wordpress.org/team/files/2025/02/image-2-1024x154.png 1024w, https://fa.wordpress.org/team/files/2025/02/image-2-300x45.png 300w, https://fa.wordpress.org/team/files/2025/02/image-2-768x116.png 768w, https://fa.wordpress.org/team/files/2025/02/image-2-1536x231.png 1536w, https://fa.wordpress.org/team/files/2025/02/image-2.png 1866w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\"></a></figure>\n\n\n\n<ul class=\"wp-block-list\">\n<li>با باز کردن هر رشته می‌توانید پیشنهادهای ترجمه خود را ارسال نمایید یا ترجمه‌های موجود را بازبینی و اصلاح نمایید.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large\"><a href=\"https://fa.wordpress.org/team/files/2025/02/image-3.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"585\" src=\"https://fa.wordpress.org/team/files/2025/02/image-3-1024x585.png\" alt=\"\" class=\"wp-image-267\" srcset=\"https://fa.wordpress.org/team/files/2025/02/image-3-1024x585.png 1024w, https://fa.wordpress.org/team/files/2025/02/image-3-300x171.png 300w, https://fa.wordpress.org/team/files/2025/02/image-3-768x439.png 768w, https://fa.wordpress.org/team/files/2025/02/image-3.png 1122w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\"></a></figure>\n\n\n\n<p class=\"has-normal-font-size\"><strong>نکته:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>پس از ارسال ترجمه، مدیران پروژه یا مترجمان ارشد ترجمه‌های شما را بررسی و تأیید می‌نمایند. با افزایش مشارکت و دقت در ترجمه‌ها، می‌توانید به یکی از اعضای فعال جامعه مترجمان وردپرس تبدیل شوید.</li>\n\n\n\n<li><strong>بخش‌های مختلف وردپرس از نظر حساسیت ترجمه اولویت‌بندی دارند.</strong> اگر تازه‌کار هستید، بهتر است ابتدا ترجمه افزونه‌ها را انجام دهید. ترجمه هسته وردپرس بیشترین حساسیت را دارد و نیازمند دقت، تجربه و آشنایی بیشتر با استانداردهای ترجمه است.</li>\n</ul>\n\n\n\n<p></p>\n\n\n\n<p></p>\n\n\n\n<h2 class=\"wp-block-heading\"><strong>نکات ترجمه صحیح در وردپرس و تایید شدن آن‌ها</strong></h2>\n\n\n\n<p>ترجمه وردپرس نه‌تنها به برگرداندن متن‌ها از زبان اصلی به فارسی محدود می‌شود، بلکه شامل ارائه ترجمه‌هایی است که مفهوم، کاربردپذیری، و تجربه کاربری مناسبی داشته باشند. در ادامه، نکات عملی برای داشتن ترجمه‌های صحیح و مؤثر ارائه شده است که رعایت آن‌ها واجب و ضروری است:</p>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۱. استفاده و پیروی از واژه‌نامه وردپرس (WordPress Glossary)</strong></p>\n\n\n\n<p>واژه‌نامه ترجمه وردپرس (Glossary) یک ابزار کلیدی برای مترجمان است. با استفاده از این واژه‌نامه می‌توانید:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>از معادل‌های رسمی و استاندارد استفاده نمایید.</li>\n\n\n\n<li>یکپارچگی ترجمه‌ها را تضمین کنید.</li>\n</ul>\n\n\n\n<p>واژه‌نامه وردپرس شامل اصطلاحات رایج و استانداردهایی است که در ترجمه‌ها استفاده می‌شوند. این ابزار کمک می‌نماید تا ترجمه‌ها یکپارچگی بیشتری داشته باشند.<br>برای مشاهده واژه‌نامه، می‌توانید به بخش “<a href=\"https://translate.wordpress.org/locale/fa/default/glossary/\">WordPress Translation Glossary</a>” مراجعه نمایید.</p>\n\n\n\n<p>این واژه‌نامه به صورت تصویر زیر شمارو هنگام ترجمه همراهی و کمک می‌کند.</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full\"><a href=\"https://fa.wordpress.org/team/files/2025/02/image-4.png\"><img loading=\"lazy\" decoding=\"async\" width=\"511\" height=\"414\" src=\"https://fa.wordpress.org/team/files/2025/02/image-4.png\" alt=\"\" class=\"wp-image-271\" srcset=\"https://fa.wordpress.org/team/files/2025/02/image-4.png 511w, https://fa.wordpress.org/team/files/2025/02/image-4-300x243.png 300w\" sizes=\"auto, (max-width: 511px) 100vw, 511px\"></a></figure>\n\n\n\n<p class=\"has-normal-font-size\"></p>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۲. مفهوم را به جای متن ترجمه نمایید</strong></p>\n\n\n\n<p>در ترجمه، به اصل متن پایبند باشید اما تمرکز شما باید بر انتقال صحیح مفهوم باشد، بسیاری از اصطلاحات وردپرس نیاز به تطبیق با فرهنگ و زبان فارسی دارند. متن را به دلخواه تغییر ندهید و سلیقه خود را در ترجمه لحاظ نکنید.<br><strong>مثال:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>به جای ترجمه کلمه‌به‌کلمه “Custom Post Type”، می‌توانید از عبارت “نوع نوشته سفارشی” استفاده نمایید.</li>\n</ul>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۳. به سازگاری و یکنواختی پایبند باشید</strong></p>\n\n\n\n<p>برای ایجاد تجربه کاربری بهتر، لازم است در تمام ترجمه‌ها از واژه‌ها و عبارات یکسان استفاده نمایید. استفاده از واژه‌نامه وردپرس و بررسی ترجمه‌های تأییدشده دیگر می‌تواند کمک زیادی کند.</p>\n\n\n\n<p></p>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۴. به اصول نگارشی فارسی توجه نمایید</strong></p>\n\n\n\n<p>رعایت اصول نگارشی، مانند استفاده از نیم‌فاصله، نشانه‌گذاری مناسب، و دستور زبان فارسی، تأثیر زیادی بر کیفیت ترجمه خواهد داشت.<br><strong>مثال:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>به جای “این ابزار می تواند” از “این ابزار می‌تواند” استفاده نمایید.</li>\n\n\n\n<li>در ترجمه حتماً از نیم‌فاصله در جای درست استفاده نمایید. کلماتی مانند “پوسته‌ ها” و “بلوک‌ ها” که بدون نیم‌فاصله نوشته شوند، تأیید نخواهند شد.</li>\n</ul>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۵. از صفحه‌کلید فارسی و استاندارد استفاده نمایید.</strong><br>وجود کاراکترهای غیراستاندارد مانند “ي” و “ك” در ترجمه باعث رد شدن آن خواهد شد.</p>\n\n\n\n<p>از “هٔ” (ی کوچک) به‌درستی استفاده نمایید. در کلماتی مانند “صفحهٔ قبلی” حتماً از “ٔ” استفاده شود. این کاراکتر با “ه همزه‌دار” یا “همزه” متفاوت است و در صفحه‌کلید استاندارد با کلید Shift + N نوشته می‌شود.</p>\n\n\n\n<p>در انجام ترجمه با موبایل حتما دقت کنید که صفحه‌کلید شما فارسی باشد. (در سیستم عامل ios معمولا صفحه‌کلید عربی است)</p>\n\n\n\n<p></p>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۶. سازگاری با متن اصلی را حفظ نمایید</strong></p>\n\n\n\n<p>ترجمه باید با متن اصلی از نظر ساختار و مفهوم همخوانی داشته باشد. به ویژه در مواردی که رشته‌های ترجمه متغیر یا کد دارند، باید آن‌ها را دقیقاً به همان شکل در ترجمه حفظ نمایید.<br><strong>مثال:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>“Welcome, %s!” به شکل “خوش آمدید، %s!” ترجمه شود.</li>\n\n\n\n<li><strong>علائم خاص مانند (%s) را دقیقاً مطابق با متن اصلی ترجمه نمایید.</strong> تمامی علائم و کاراکترهای ویژه باید دقیقاً همان‌طور که در متن اصلی آمده‌اند، در ترجمه نیز قرار گیرند.</li>\n\n\n\n<li>به‌عنوان‌مثال، نباید علامت “%” را به “٪” تغییر دهید. همچنین علائمی مانند کاما (،)، درصد (%)، هش (#)، و (&amp;) و تگ‌های HTML باید بدون تغییر باقی بمانند.</li>\n</ul>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۷. از ترجمه ماشینی استفاده نکنید</strong></p>\n\n\n\n<p>ابزارهای ترجمه ماشینی می‌توانند به سرعت کار شما کمک کنند، اما همواره باید بازبینی و اصلاح شوند. این ابزارها معمولاً مفهوم یا سبک متن را به درستی درک نمی‌کنند. ترجمه‌های مستقیم ماشینی تایید نمی‌شوند.</p>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۸. به بخش پیشنهادها توجه نمایید</strong></p>\n\n\n\n<p>به بخش پیشنهادها توجه نمایید، اما به آن کاملاً اعتماد نکنید. این بخش بر اساس حافظه ترجمه، پیشنهادهایی ارائه می‌دهد. اگر در حال ترجمه افزونه هستید، ممکن است این پیشنهادات کمک‌کننده باشند، اما برای ترجمه خود وردپرس باید دقت نمایید که پیشنهاد ارائه‌شده از هسته وردپرس باشد.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/team/files/2025/02/image-5.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"593\" src=\"https://fa.wordpress.org/team/files/2025/02/image-5-1024x593.png\" alt=\"\" class=\"wp-image-272\" srcset=\"https://fa.wordpress.org/team/files/2025/02/image-5-1024x593.png 1024w, https://fa.wordpress.org/team/files/2025/02/image-5-300x174.png 300w, https://fa.wordpress.org/team/files/2025/02/image-5-768x445.png 768w, https://fa.wordpress.org/team/files/2025/02/image-5.png 1152w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\"></a></figure>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۹. از بازبینی نهایی غافل نشوید</strong></p>\n\n\n\n<p>قبل از ارسال ترجمه، حتماً آن را بازبینی نمایید تا از صحت ترجمه، اصول نگارشی و روان بودن متن مطمئن شوید.</p>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۱۰. با جامعه مترجمان همکاری نمایید</strong></p>\n\n\n\n<p>یکی از مزایای ترجمه وردپرس، همکاری با جامعه‌ای از مترجمان است. از بازخوردهای دیگر مترجمان استفاده نمایید و در صورت شک، از آن‌ها سؤال کنید.</p>\n\n\n\n<div class=\"wp-block-buttons is-content-justification-center is-layout-flex wp-container-core-buttons-is-layout-a89b3969 wp-block-buttons-is-layout-flex\">\n<div class=\"wp-block-button\"><a class=\"wp-block-button__link wp-element-button\" href=\"https://t.me/wpdevelopers\">عضویت در گروه تلگرام مترجمان</a></div>\n</div>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۱۱. آزمایش و بررسی ترجمه در عمل</strong></p>\n\n\n\n<p>ترجمه‌ها را روی محیط وردپرس آزمایش کنید تا از مناسب بودن آن‌ها در محیط کاربری مطمئن شوید. این کار به شما کمک می‌کند تا خطاها و مشکلات احتمالی را پیش از تأیید نهایی برطرف نمایید. ابزارهایی مانند <a>Loco Translate</a> یا بخش <a href=\"https://translate.wordpress.org/locale/fa/default/wp-plugins/\">ویرایش زنده</a> GlotPress در بخش افزونه‌ها به شما این امکان را می‌دهند.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/team/files/2025/02/image-6.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"360\" src=\"https://fa.wordpress.org/team/files/2025/02/image-6-1024x360.png\" alt=\"\" class=\"wp-image-279\" srcset=\"https://fa.wordpress.org/team/files/2025/02/image-6-1024x360.png 1024w, https://fa.wordpress.org/team/files/2025/02/image-6-300x105.png 300w, https://fa.wordpress.org/team/files/2025/02/image-6-768x270.png 768w, https://fa.wordpress.org/team/files/2025/02/image-6-1536x540.png 1536w, https://fa.wordpress.org/team/files/2025/02/image-6.png 1900w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\"></a></figure>\n\n\n\n<p>با رعایت این نکات، می‌توانید ترجمه‌های باکیفیتی ارائه دهید که تجربه کاربران فارسی‌زبان وردپرس را بهبود بخشد و به گسترش این پلتفرم کمک نماید.</p>\n\n\n\n<p></p>\n\n\n\n<h3 class=\"wp-block-heading\">چالش‌های رایج در ترجمه وردپرس و راه‌حل‌ها</h3>\n\n\n\n<p>در فرآیند ترجمه وردپرس، ممکن است با چالش‌هایی روبه‌رو شوید که کیفیت و سرعت ترجمه را تحت تأثیر قرار دهند. شناخت این چالش‌ها و راه‌حل‌های مناسب، به شما کمک می‌نماید تا فرآیند ترجمه را بهینه‌تر انجام دهید. در ادامه، به برخی از رایج‌ترین چالش‌ها و راهکارهای پیشنهادی پرداخته‌ایم:</p>\n\n\n\n<p class=\"has-charcoal-0-color has-text-color has-link-color has-normal-font-size wp-elements-79296ebdfacd39b15d4f8cd584f1f73f\"><strong>۱. ابهام در پذیرش ترجمه‌ها و تایید نشدن آن‌ها</strong></p>\n\n\n\n<p>گاهی پیشنهادهای ترجمه شما مدت زیادی منتظر تأیید می‌مانند.<br><strong>راه‌حل:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>با مدیران ترجمه پروژه از طریق گروه تلگرام در ارتباط باشید و از آن‌ها برای بازبینی درخواست نمایید.</li>\n\n\n\n<li>وضعیت‌های ترجمه خود را بررسی نمایید.</li>\n</ul>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/team/files/2025/02/image-7.png\"><img loading=\"lazy\" decoding=\"async\" width=\"1024\" height=\"131\" src=\"https://fa.wordpress.org/team/files/2025/02/image-7-1024x131.png\" alt=\"\" class=\"wp-image-280\" srcset=\"https://fa.wordpress.org/team/files/2025/02/image-7-1024x131.png 1024w, https://fa.wordpress.org/team/files/2025/02/image-7-300x38.png 300w, https://fa.wordpress.org/team/files/2025/02/image-7-768x98.png 768w, https://fa.wordpress.org/team/files/2025/02/image-7.png 1318w\" sizes=\"auto, (max-width: 1024px) 100vw, 1024px\"></a></figure>\n\n\n\n<p>ممکن است ترجمه شما توسط مدیران در بخش Fuzzy یا Changes requested قرار گرفته باشد. این حالت یعنی ترجمه شما ایرادی داشته و تایید نشده است و ویرایشگر مربوطه آن را برای تغییر و اصلاح به خود شما ارجاع داده است. پیشنهاد ترجمه اصلاح شده شما بعد از ارسال مجدد بررسی می‌شود.</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>به قسمت بحث‌ها (Disscussion) توجه کنید.</strong></li>\n</ul>\n\n\n\n<p>در بخش Disscussion که در سمت راست ترجمه هر رشته در دسترس است ممکن است دیدگاهی از طرف مدیر یا ویرایشگر آن پروژه برای شما ارسال شده باشد. در این بخش می‌توانید به تبادل نظر و گفتگو بپردازید.</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full is-resized\"><a href=\"https://fa.wordpress.org/team/files/2025/02/image-8.png\"><img loading=\"lazy\" decoding=\"async\" width=\"753\" height=\"526\" src=\"https://fa.wordpress.org/team/files/2025/02/image-8.png\" alt=\"\" class=\"wp-image-288\" style=\"width:593px;height:auto\" srcset=\"https://fa.wordpress.org/team/files/2025/02/image-8.png 753w, https://fa.wordpress.org/team/files/2025/02/image-8-300x210.png 300w\" sizes=\"auto, (max-width: 753px) 100vw, 753px\"></a></figure>\n\n\n\n<ul class=\"wp-block-list\">\n<li>اگر مشارکت شما ادامه‌دار و مؤثر باشد، می‌توانید به عضویت تیم مترجمان ارشد درآیید.</li>\n</ul>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۲. عبارات فنی و نامفهوم</strong></p>\n\n\n\n<p>عبارات فنی یا کدها در متن اصلی ممکن است باعث سردرگمی شوند، به‌ویژه اگر با اصطلاحات برنامه‌نویسی آشنایی کافی نداشته باشید.<br><strong>راه‌حل:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>از واژه‌نامه‌ وردپرس استفاده نمایید.</li>\n\n\n\n<li>اگر عبارت کاملاً نامفهوم است، با جامعه مترجمان مشورت کنید.</li>\n</ul>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۳. رعایت استانداردهای نگارشی</strong></p>\n\n\n\n<p>رعایت نیم‌فاصله، نقطه‌گذاری و سایر استانداردهای نگارشی ممکن است در طول ترجمه فراموش شود.<br><strong>راه‌حل:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>از ابزارهای ویرایش متن با قابلیت بررسی نگارشی (مانند ویراستیار) استفاده نمایید.</li>\n\n\n\n<li>پیش از ارسال، متن ترجمه‌شده را بازبینی نمایید.</li>\n</ul>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۴. واژه‌های بدون معادل فارسی مناسب</strong></p>\n\n\n\n<p>برخی از واژه‌ها، مانند اصطلاحات تخصصی یا مفاهیم نوین، معادل دقیقی در فارسی ندارند.<br><strong>راه‌حل:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>از معادل‌های جاافتاده در واژه‌نامه وردپرس استفاده نمایید.</li>\n\n\n\n<li>اگر معادل مناسبی وجود ندارد، توضیح ساده و روانی ارائه دهید که برای کاربران قابل درک باشد.</li>\n\n\n\n<li>با مدیران ترجمه در میان بگذارید.</li>\n</ul>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۵. طولانی بودن برخی رشته‌ها</strong></p>\n\n\n\n<p>رشته‌هایی که بیش از حد طولانی هستند ممکن است خوانایی را کاهش دهند.<br><strong>راه‌حل:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>ترجمه را به بخش‌های کوتاه‌تر تقسیم کنید تا خوانایی افزایش یابد.</li>\n\n\n\n<li>از جملات روان و ساده استفاده نمایید.</li>\n</ul>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۶. تداخل با ترجمه‌های دیگر</strong></p>\n\n\n\n<p>ممکن است چند نفر روی یک پروژه کار کنند و ترجمه‌ها با یکدیگر ناسازگار باشند.<br><strong>راه‌حل:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>از ابتدا واژه‌نامه‌ها و استانداردهای پروژه را مرور کنید.</li>\n\n\n\n<li>همکاری و تعامل با دیگر مترجمان را جدی بگیرید.</li>\n</ul>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۷. مدیریت زمان و حجم کار</strong></p>\n\n\n\n<p>پروژه‌های بزرگ مانند ترجمه هسته وردپرس یا افزونه‌های معروف ممکن است زمان زیادی ببرند.<br><strong>راه‌حل:</strong></p>\n\n\n\n<ul class=\"wp-block-list\">\n<li>ابتدا روی رشته‌های مهم‌تر و پرکاربردتر تمرکز نمایید.</li>\n\n\n\n<li>فقط رشته‌های کوتاه و تک کلمه‌ای رو ترجمه نکنید.</li>\n\n\n\n<li>مشارکت را به‌صورت تیمی انجام دهید تا بار کار تقسیم شود.</li>\n</ul>\n\n\n\n<p></p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>نکات نهایی ترجمه وردپرس فارسی</strong></h3>\n\n\n\n<p><strong>۱. پایبندی به زبان فارسی</strong></p>\n\n\n\n<p>تحت هیچ شرایطی در ترجمه از کلمات انگلیسی یا فینگلیش استفاده نکنید. فارسی نوشتن کلمه انگلیسی (مثال: پست‌تایپ) مجاز نیست.</p>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۲. ساده‌نویسی و روان‌نویسی</strong></p>\n\n\n\n<p>از کلمات پیچیده و جملات طولانی پرهیز نمایید. سادگی و روانی ترجمه، تجربه کاربری بهتری برای مخاطبان فراهم می‌کند.</p>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۳. تنظیم طول متن‌ها</strong></p>\n\n\n\n<p>ترجمه‌ها باید از نظر طول با متن اصلی هماهنگ باشند. این موضوع به‌ویژه در مواردی که فضا محدود است، مانند دکمه‌ها یا منوها، اهمیت دارد.</p>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۴. همکاری با دیگر مترجمان</strong></p>\n\n\n\n<p>با دیگر مترجمان در پروژه‌ها همکاری نمایید و از بازخورد آن‌ها برای بهبود کار خود استفاده کنید. همچنین می‌توانید ترجمه‌های پیشنهادی آن‌ها را مطالعه و ایده بگیرید.</p>\n\n\n\n<p class=\"has-normal-font-size\"><strong>۵. استفاده از قابلیت‌های GlotPress</strong></p>\n\n\n\n<p>در پلتفرم ترجمه وردپرس (GlotPress)، قابلیت‌هایی وجود دارد که می‌توانند کار شما را آسان‌تر نمایند:</p>\n\n\n\n<ul class=\"wp-block-list\">\n<li><strong>فیلتر رشته‌ها</strong>: برای تمرکز روی ترجمه‌های ناقص یا رشته‌های خاص.</li>\n\n\n\n<li><strong>حالت جستجو</strong>: برای یافتن کلمات یا عبارات خاص در تمام پروژه.</li>\n</ul>\n\n\n\n<p><strong>۶. ابزارهای کمکی آنلاین</strong></p>\n\n\n\n<p>برای بهبود کیفیت ترجمه، می‌توانید از ابزارهای آنلاین مانند Google Translate، DeepL یا <a href=\"https://targoman.ir/\">ترگمان</a> استفاده نمایید. این ابزارها به‌ویژه در ارائه ترجمه اولیه رشته‌های طولانی مفید هستند، اما باید توجه داشته باشید که ترجمه‌ها نیاز به بازبینی و اصلاح و جایگزینی با واژه‌نامه را دارند تا با استانداردهای وردپرس مطابقت داشته باشند.</p>\n\n\n\n<h3 class=\"wp-block-heading\"><strong>پایان: گامی در جهت بهبود وردپرس فارسی</strong></h3>\n\n\n\n<p>مشارکت در ترجمه وردپرس فارسی نه تنها فرصتی برای یادگیری و ارتقای مهارت‌های زبانی و فنی شماست، بلکه اقدامی ارزشمند برای بهبود تجربه کاربری میلیون‌ها کاربر فارسی‌زبان به‌شمار می‌رود. ترجمه باکیفیت و استاندارد، استفاده از وردپرس را ساده‌تر و لذت‌بخش‌تر می‌نماید و جامعه‌ای قوی‌تر و پویا‌تر ایجاد می‌کند.</p>\n\n\n\n<p>در این مقاله، با مراحل مختلف مشارکت در ترجمه، ابزارهای مورد نیاز، چالش‌ها و راهکارها آشنا شدید. هر یک از شما می‌توانید با اختصاص زمان و استفاده از راهنمایی‌های ارائه‌شده، تأثیری مثبت و ماندگار در این پروژه جهانی داشته باشید.</p>\n\n\n\n<p>اگر شما هم به وردپرس علاقه دارید، اکنون زمان مناسبی برای شروع مشارکت است. با ثبت‌نام در بخش ترجمه و همکاری با دیگر اعضای جامعه مترجمان، به یکی از ستون‌های اصلی در توسعه و پیشرفت وردپرس فارسی تبدیل شوید.</p>\n\n\n\n<p>با همکاری، تعهد و تلاش جمعی، می‌توانیم وردپرس فارسی را به سطحی جدید برسانیم و به کاربران بیشتری کمک کنیم تا از این ابزار قدرتمند به ساده‌ترین و بهترین شکل ممکن بهره‌مند شوند.</p>\n\n\n\n<blockquote class=\"wp-block-quote is-layout-flow wp-block-quote-is-layout-flow\">\n<p>این نوشته به مرور به‌روز خواهد شد و موارد و نکات جدیدتر به آن اضافه خواهد شد.</p>\n\n\n\n<p><strong>در صورت داشتن سؤال یا نیاز به راهنمایی، از بخش دیدگاه‌ها استفاده نمایید و پرسش خود را در اینجا مطرح کنید تا راهنمایی لازم دریافت نمایید.</strong></p>\n</blockquote>\n\n\n<div class=\"wp-block-post-author has-large-font-size\"><div class=\"wp-block-post-author__avatar\"><img alt=\"\" src=\"https://secure.gravatar.com/avatar/205c7baf65283c61a8c0a6b6559680fda83297a11c809ec031f5200073e65e0d?s=96&amp;d=mm&amp;r=g\" srcset=\"https://secure.gravatar.com/avatar/205c7baf65283c61a8c0a6b6559680fda83297a11c809ec031f5200073e65e0d?s=192&amp;d=mm&amp;r=g 2x\" class=\"avatar avatar-96 photo\" height=\"96\" width=\"96\"></div><div class=\"wp-block-post-author__content\"><p class=\"wp-block-post-author__byline\">نوشته شده توسط سعید فرد از وردپرس فارسی</p><p class=\"wp-block-post-author__name\"><a href=\"https://profiles.wordpress.org/saeedfard/\" target=\"_self\">Saeed Fard</a></p></div></div>\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:76:\"https://fa.wordpress.org/team/2025/02/14/how-to-contribute-translation/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"5\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"222\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:1;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:94:\"پیوستن به گروه مترجمین و توسعه دهندگان وردپرس فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:240:\"https://fa.wordpress.org/team/2024/04/21/%d9%be%db%8c%d9%88%d8%b3%d8%aa%d9%86-%d8%a8%d9%87-%da%af%d8%b1%d9%88%d9%87-%d9%85%d8%aa%d8%b1%d8%ac%d9%85%db%8c%d9%86-%d9%88-%d8%aa%d9%88%d8%b3%d8%b9%d9%87-%d8%af%d9%87%d9%86%d8%af%da%af%d8%a7%d9%86/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:249:\"https://fa.wordpress.org/team/2024/04/21/%d9%be%db%8c%d9%88%d8%b3%d8%aa%d9%86-%d8%a8%d9%87-%da%af%d8%b1%d9%88%d9%87-%d9%85%d8%aa%d8%b1%d8%ac%d9%85%db%8c%d9%86-%d9%88-%d8%aa%d9%88%d8%b3%d8%b9%d9%87-%d8%af%d9%87%d9%86%d8%af%da%af%d8%a7%d9%86/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sun, 21 Apr 2024 16:51:36 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"مطالب\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://fa.wordpress.org/team/?p=201\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:605:\"با درود،با توجه به محدودیت‌هایی که در Slack برای کاربران ایرانی وجود دارد، تیم وردپرس فارسی، از تلگرام برای هماهنگی و ارتباط تیم استفاده می‌کند. لذا از تمامی مترجمین و توسعه دهندگان فارسی، درخواست می‌شود تا در گروه تلگرامی “توسعه دهندگان وردپرس فارسی” به آدرس زیر: https://t.me/wpdevelopers و همچنین کانال مربوطه به آدرس: https://t.me/fa_wordpress عضو [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Farhad Sakhaei\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:22925:\"<p>با درود،<br>با توجه به محدودیت‌هایی که در Slack برای کاربران ایرانی وجود دارد، تیم وردپرس فارسی، از تلگرام برای هماهنگی و ارتباط تیم استفاده می‌کند. لذا از تمامی مترجمین و توسعه دهندگان فارسی، درخواست می‌شود تا در گروه تلگرامی “توسعه دهندگان وردپرس فارسی” به آدرس زیر:</p>\n\n\n\n<p class=\"has-text-align-center\"><a href=\"https://t.me/wpdevelopers\">https://t.me/wpdevelopers</a></p>\n\n\n\n<p>و همچنین کانال مربوطه به آدرس:</p>\n\n\n\n<p class=\"has-text-align-center\"><a href=\"https://t.me/fa_wordpress\">https://t.me/fa_wordpress</a></p>\n\n\n\n<p>عضو شوند تا هماهنگی‌های لازم برای ترجمه‌ها و توسعه‌ها، صورت پذیرد. ضمنا جهت ارتباط بهتر و پیگیری‌های مورد نیاز، لطفا در زیرگروه “معرفی مترجمین”، <strong>ایمیل مربوط به حساب کاربری وردپرس</strong> خود و <strong>شناسه تلگرام</strong> خود را اعلام نمایید تا ارتباط بهتر و سریعتری برای موارد مورد نیاز صورت پذیرد.</p>\n\n\n\n<p>با سپاس</p>\n\n\n\n<p dir=\"ltr\"><a href=\"https://profiles.wordpress.org/farhad0/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>farhad0</a> <a href=\"https://profiles.wordpress.org/man4toman/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>man4toman</a> <a href=\"https://profiles.wordpress.org/saeedfard/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>SaeedFard</a> <a href=\"https://profiles.wordpress.org/sushyant/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sushyant</a> <a href=\"https://profiles.wordpress.org/asadiy4n/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>asadiy4n</a> <a href=\"https://profiles.wordpress.org/cg-team/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>CG-TEAM</a> <a href=\"https://profiles.wordpress.org/1farakav/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>1farakav</a> <a href=\"https://profiles.wordpress.org/ach1992/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ach1992</a> <a href=\"https://profiles.wordpress.org/aminfa/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>aminfa</a> <a href=\"https://profiles.wordpress.org/hadi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>hadi</a>.omid <a href=\"https://profiles.wordpress.org/yazdaniwp/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>yazdaniwp</a> <a href=\"https://profiles.wordpress.org/aminomidi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>aminomidi</a> <a href=\"https://profiles.wordpress.org/360messenger/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>360messenger</a> <a href=\"https://profiles.wordpress.org/addeveloper/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>addeveloper</a> <a href=\"https://profiles.wordpress.org/affiliatenetworks/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>affiliatenetworks</a> <a href=\"https://profiles.wordpress.org/ahangarha/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ahangarha</a> <a href=\"https://profiles.wordpress.org/aliarjini/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>aliarjini</a> <a href=\"https://profiles.wordpress.org/aliasghar1112/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>aliasghar1112</a> <a href=\"https://profiles.wordpress.org/aligholami/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>aligholami</a> <a href=\"https://profiles.wordpress.org/alirashidnahal/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>alirashidnahal</a> <a href=\"https://profiles.wordpress.org/alixo/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>alixo</a> <a href=\"https://profiles.wordpress.org/alizadegan/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>alizadegan</a> <a href=\"https://profiles.wordpress.org/amatris/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>amatris</a> <a href=\"https://profiles.wordpress.org/ameskaran/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ameskaran</a> <a href=\"https://profiles.wordpress.org/amirarshia/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>amirarshia</a> <a href=\"https://profiles.wordpress.org/amirhosseinhpv/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>amirhosseinhpv</a> <a href=\"https://profiles.wordpress.org/amirhpcom/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>amirhpcom</a> <a href=\"https://profiles.wordpress.org/antialiasfactory/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>antialiasfactory</a> <a href=\"https://profiles.wordpress.org/ardalan13/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ardalan13</a> <a href=\"https://profiles.wordpress.org/ariankeshavarz/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ariankeshavarz</a> <a href=\"https://profiles.wordpress.org/armansiahloo/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>armansiahloo</a> <a href=\"https://profiles.wordpress.org/armenab1/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>armenab1</a> <a href=\"https://profiles.wordpress.org/arshen/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>Arshen</a> <a href=\"https://profiles.wordpress.org/arvancloud/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>arvancloud</a> <a href=\"https://profiles.wordpress.org/as911/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>as911</a> <a href=\"https://profiles.wordpress.org/asterids/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>asterids</a> <a href=\"https://profiles.wordpress.org/aydin714/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>aydin714</a> <a href=\"https://profiles.wordpress.org/basemax/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>basemax</a> <a href=\"https://profiles.wordpress.org/bbkysf/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>bbkysf</a> <a href=\"https://profiles.wordpress.org/blackswanlab/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>blackswanlab</a> <a href=\"https://profiles.wordpress.org/bmoudi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>bmoudi</a> <a href=\"https://profiles.wordpress.org/chilisearch/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>chilisearch</a> <a href=\"https://profiles.wordpress.org/dedidata/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>dedidata</a> <a href=\"https://profiles.wordpress.org/digikotcom/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>digikotcom</a> <a href=\"https://profiles.wordpress.org/djamir121/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>djamir121</a> <a href=\"https://profiles.wordpress.org/domiinodev/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>domiinodev</a> <a href=\"https://profiles.wordpress.org/ebrahimzadeh/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ebrahimzadeh</a> <a href=\"https://profiles.wordpress.org/ee_persian/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ee_persian</a> <a href=\"https://profiles.wordpress.org/elementorir/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>elementorir</a> <a href=\"https://profiles.wordpress.org/ercmanager1/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ercmanager1</a> <a href=\"https://profiles.wordpress.org/esmailfadaei/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>esmailfadaei</a> <a href=\"https://profiles.wordpress.org/farokhheidari/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>farokhheidari</a> <a href=\"https://profiles.wordpress.org/farshadhz/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>farshadhz</a> <a href=\"https://profiles.wordpress.org/feredi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>feredi</a> <a href=\"https://profiles.wordpress.org/foadadeli/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>foadadeli</a> <a href=\"https://profiles.wordpress.org/gamefa/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>gamefa</a> <a href=\"https://profiles.wordpress.org/ghasemi71ir/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ghasemi71ir</a> <a href=\"https://profiles.wordpress.org/ghtali/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ghtali</a> <a href=\"https://profiles.wordpress.org/glboy/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>glboy</a> <a href=\"https://profiles.wordpress.org/goudarz/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>Goudarz</a> <a href=\"https://profiles.wordpress.org/h71/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>h71</a> <a href=\"https://profiles.wordpress.org/ham3da/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ham3da</a> <a href=\"https://profiles.wordpress.org/hanieh729/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>hanieh729</a> <a href=\"https://profiles.wordpress.org/hassantafreshi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>hassantafreshi</a> <a href=\"https://profiles.wordpress.org/hitsteps/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>hitsteps</a> <a href=\"https://profiles.wordpress.org/hosseinsadeghi69/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>hosseinsadeghi69</a> <a href=\"https://profiles.wordpress.org/hsnshfn/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>hsnshfn</a> <a href=\"https://profiles.wordpress.org/imikiani/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>imikiani</a> <a href=\"https://profiles.wordpress.org/infomtaghavi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>infomtaghavi</a> <a href=\"https://profiles.wordpress.org/irangold/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>irangold</a> <a href=\"https://profiles.wordpress.org/irdb/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>irdb</a> <a href=\"https://profiles.wordpress.org/johnbozorgi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>johnbozorgi</a> <a href=\"https://profiles.wordpress.org/kafrashi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>kafrashi</a> <a href=\"https://profiles.wordpress.org/kamalireal/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>kamalireal</a> <a href=\"https://profiles.wordpress.org/kamrankhorsandi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>kamrankhorsandi</a> <a href=\"https://profiles.wordpress.org/kashani/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>kashani</a> <a href=\"https://profiles.wordpress.org/khorshidlab/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>khorshidlab</a> <a href=\"https://profiles.wordpress.org/longman2020/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>longman2020</a> <a href=\"https://profiles.wordpress.org/lord_viper/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>lord_viper</a> <a href=\"https://profiles.wordpress.org/lusha/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>lusha</a> <a href=\"https://profiles.wordpress.org/m0911/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>m0911</a> <a href=\"https://profiles.wordpress.org/mahdi6489/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mahdi6489</a> <a href=\"https://profiles.wordpress.org/mahdiebrahimii/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mahdiebrahimii</a> <a href=\"https://profiles.wordpress.org/mahdiyerezaie/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mahdiyerezaie</a> <a href=\"https://profiles.wordpress.org/mahdyarme/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mahdyarme</a> <a href=\"https://profiles.wordpress.org/mainseo/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mainseo</a> @manzoorwani.jk <a href=\"https://profiles.wordpress.org/mashhadcode/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mashhadcode</a> <a href=\"https://profiles.wordpress.org/masoudnkh/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>masoudnkh</a> <a href=\"https://profiles.wordpress.org/matinbeigi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>matinbeigi</a> <a href=\"https://profiles.wordpress.org/mazraee/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mazraee</a> <a href=\"https://profiles.wordpress.org/mehdibolourian/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mehdibolourian</a> <a href=\"https://profiles.wordpress.org/mehr/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>Mehr</a>.Ban <a href=\"https://profiles.wordpress.org/mehrshad81/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mehrshad81</a> <a href=\"https://profiles.wordpress.org/mehrshaddarzi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mehrshaddarzi</a> <a href=\"https://profiles.wordpress.org/mhmanavi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mhmanavi</a> <a href=\"https://profiles.wordpress.org/michaelpk/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>michaelpk</a> <a href=\"https://profiles.wordpress.org/mihanwp/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mihanwp</a> <a href=\"https://profiles.wordpress.org/milad47/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>Milad47</a> <a href=\"https://profiles.wordpress.org/mo0orteza/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>Mo0orTeZa</a> <a href=\"https://profiles.wordpress.org/moccc/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>moccc</a> <a href=\"https://profiles.wordpress.org/mohadeseghasemi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mohadeseghasemi</a> <a href=\"https://profiles.wordpress.org/mohammad9574/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mohammad9574</a> <a href=\"https://profiles.wordpress.org/mohammadhero/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mohammadhero</a> <a href=\"https://profiles.wordpress.org/mohsengham/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mohsengham</a> <a href=\"https://profiles.wordpress.org/mohsenpazhoohiyani/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mohsenpazhoohiyani</a> <a href=\"https://profiles.wordpress.org/mojtaba-taheri/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mojtaba-taheri</a> <a href=\"https://profiles.wordpress.org/mojtabad/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mojtabad</a> <a href=\"https://profiles.wordpress.org/moreconvert/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>moreconvert</a> <a href=\"https://profiles.wordpress.org/mostafa/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mostafa</a>.s1990 <a href=\"https://profiles.wordpress.org/mostafarouz/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mostafarouz</a> <a href=\"https://profiles.wordpress.org/motefaghehi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>motefaghehi</a> <a href=\"https://profiles.wordpress.org/motlaqcode/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>motlaqcode</a> <a href=\"https://profiles.wordpress.org/mralidoosti/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>mralidoosti</a> <a href=\"https://profiles.wordpress.org/msn6060/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>msn6060</a> <a href=\"https://profiles.wordpress.org/msninsider/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>msninsider</a> <a href=\"https://profiles.wordpress.org/narimonfund/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>narimonfund</a> <a href=\"https://profiles.wordpress.org/native0098/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>native0098</a> <a href=\"https://profiles.wordpress.org/navidos/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>navidos</a> <a href=\"https://profiles.wordpress.org/niloomand/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>niloomand</a> <a href=\"https://profiles.wordpress.org/nima78600/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>nima78600</a> <a href=\"https://profiles.wordpress.org/nirweb/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>nirweb</a> <a href=\"https://profiles.wordpress.org/novinhub/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>novinhub</a> <a href=\"https://profiles.wordpress.org/otoraby/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>otoraby</a> <a href=\"https://profiles.wordpress.org/parnibraan/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>parnibraan</a> <a href=\"https://profiles.wordpress.org/parselearn/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>parselearn</a> <a href=\"https://profiles.wordpress.org/parsmizban/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>parsmizban</a> <a href=\"https://profiles.wordpress.org/pash2048/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>pash2048</a> <a href=\"https://profiles.wordpress.org/payzito/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>payzito</a> @pctricks.ir <a href=\"https://profiles.wordpress.org/pedramrahimi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>pedramrahimi</a> <a href=\"https://profiles.wordpress.org/pegahnorozi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>pegahnorozi</a> <a href=\"https://profiles.wordpress.org/peprodev/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>peprodev</a> <a href=\"https://profiles.wordpress.org/persianscript/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>Persianscript</a> <a href=\"https://profiles.wordpress.org/piman/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>piman</a> <a href=\"https://profiles.wordpress.org/pingmeter/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>pingmeter</a> <a href=\"https://profiles.wordpress.org/poolito/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>poolito</a> <a href=\"https://profiles.wordpress.org/porsline/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>porsline</a> <a href=\"https://profiles.wordpress.org/poshtibancom/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>poshtibancom</a> <a href=\"https://profiles.wordpress.org/qodeinteractive/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>qodeinteractive</a> <a href=\"https://profiles.wordpress.org/qwerty13/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>qwerty13</a> <a href=\"https://profiles.wordpress.org/rahmatmajidi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>rahmatmajidi</a> <a href=\"https://profiles.wordpress.org/rajaeinet/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>rajaeinet</a> <a href=\"https://profiles.wordpress.org/rarathemesupport/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>rarathemesupport</a> <a href=\"https://profiles.wordpress.org/sadeghpm/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sadeghpm</a> <a href=\"https://profiles.wordpress.org/saeed_same/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>saeed_same</a> <a href=\"https://profiles.wordpress.org/safelayout/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>safelayout</a> <a href=\"https://profiles.wordpress.org/sahabi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sahabi</a> <a href=\"https://profiles.wordpress.org/sajjadtalebi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sajjadtalebi</a> <a href=\"https://profiles.wordpress.org/salamzadeh/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>Salamzadeh</a> <a href=\"https://profiles.wordpress.org/salarlotfi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>salarlotfi</a> <a href=\"https://profiles.wordpress.org/salemi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>salemi</a> <a href=\"https://profiles.wordpress.org/salman1990/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>salman1990</a> <a href=\"https://profiles.wordpress.org/samanehmirrajabi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>samanehmirrajabi</a> <a href=\"https://profiles.wordpress.org/samtemehr/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>samtemehr</a> <a href=\"https://profiles.wordpress.org/saniamohammadi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>saniamohammadi</a> <a href=\"https://profiles.wordpress.org/sareham238/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sareham238</a> <a href=\"https://profiles.wordpress.org/sazmankav/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sazmankav</a> <a href=\"https://profiles.wordpress.org/seramo/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>seramo</a> <a href=\"https://profiles.wordpress.org/shayanfp/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>shayanfp</a> <a href=\"https://profiles.wordpress.org/shokrino/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>shokrino</a> <a href=\"https://profiles.wordpress.org/silvercover/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>silvercover</a> <a href=\"https://profiles.wordpress.org/sinashams/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sinashams</a> <a href=\"https://profiles.wordpress.org/smm1378/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>smm1378</a> <a href=\"https://profiles.wordpress.org/smrm/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>smrm</a> <a href=\"https://profiles.wordpress.org/soheilmir/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>soheilmir</a> <a href=\"https://profiles.wordpress.org/sunyniazi/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>sunyniazi</a> <a href=\"https://profiles.wordpress.org/tadeha/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>tadeha</a> <a href=\"https://profiles.wordpress.org/translationsbysemperplugins/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>translationsbysemperplugins</a> <a href=\"https://profiles.wordpress.org/tsina/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>tsina</a> <a href=\"https://profiles.wordpress.org/untashgaal/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>untashgaal</a> <a href=\"https://profiles.wordpress.org/vadatiertebat/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>vadatiertebat</a> <a href=\"https://profiles.wordpress.org/weloper/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>weloper</a> <a href=\"https://profiles.wordpress.org/worldless/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>worldless</a> <a href=\"https://profiles.wordpress.org/wpvar/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>wpvar</a> <a href=\"https://profiles.wordpress.org/yashar_hv/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>yashar_hv</a> <a href=\"https://profiles.wordpress.org/yasser1992/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>yasser1992</a> <a href=\"https://profiles.wordpress.org/ynproduct/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>ynproduct</a> <a href=\"https://profiles.wordpress.org/zareidev/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>zareidev</a> <a href=\"https://profiles.wordpress.org/zeroone2021/\" class=\"mention\"><span class=\"mentions-prefix\">@</span>zeroone2021</a></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:245:\"https://fa.wordpress.org/team/2024/04/21/%d9%be%db%8c%d9%88%d8%b3%d8%aa%d9%86-%d8%a8%d9%87-%da%af%d8%b1%d9%88%d9%87-%d9%85%d8%aa%d8%b1%d8%ac%d9%85%db%8c%d9%86-%d9%88-%d8%aa%d9%88%d8%b3%d8%b9%d9%87-%d8%af%d9%87%d9%86%d8%af%da%af%d8%a7%d9%86/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"3\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"201\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:2;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:41:\"معرفی تیم وردپرس فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:159:\"https://fa.wordpress.org/team/2024/02/17/%d9%85%d8%b9%d8%b1%d9%81%db%8c-%d8%aa%db%8c%d9%85-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:167:\"https://fa.wordpress.org/team/2024/02/17/%d9%85%d8%b9%d8%b1%d9%81%db%8c-%d8%aa%db%8c%d9%85-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 17 Feb 2024 13:06:39 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"مطالب\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://fa.wordpress.org/team/?p=145\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:509:\"تیم وردپرس فارسی یک تشکیل کاملا مستقل است که وابسته به هیچگونه سازمان و یا شرکتی نمی باشد، پروژه وردپرس فارسی به هیچ شخص و یا گروه خاصی تعلق ندارد و توسط تیم وردپرس فارسی که به صورت داوطلبانه فعالیت می کنند، اداره می شود. این بخش از سایت وردپرس، مخصوص تیم وردپرس فارسی می‌باشد. [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Farhad Sakhaei\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:75228:\"<p>تیم وردپرس فارسی یک تشکیل کاملا مستقل است که وابسته به هیچگونه سازمان و یا شرکتی نمی باشد، پروژه وردپرس فارسی به هیچ شخص و یا گروه خاصی تعلق ندارد و توسط تیم وردپرس فارسی که به صورت داوطلبانه فعالیت می کنند، اداره می شود. این بخش از سایت وردپرس، مخصوص تیم وردپرس فارسی می‌باشد. شما می‌توانید اخبار و رویدادهای مربوط به تیم وردپرس فارسی را در اینجا دنبال کنید و در صورت تمایل در ترجمه وردپرس مشارکت کنید.</p>\n\n\n\n<h2 class=\"wp-block-heading\">اعضای تیم وردپرس فارسی</h2>\n\n\n\n<h3 class=\"wp-block-heading has-text-align-center\">مدیران بخش فارسی وردپرس</h3>\n\n\n\n<div class=\"wp-block-group is-content-justification-space-between is-layout-flex wp-container-core-group-is-layout-9366075c wp-block-group-is-layout-flex\">\n<div class=\"wp-block-group is-vertical is-content-justification-center is-nowrap is-layout-flex wp-container-core-group-is-layout-671c4991 wp-block-group-is-layout-flex\">\n<figure class=\"wp-block-image size-large\"><a href=\"https://profiles.wordpress.org/farhad0\" target=\"_blank\" rel=\"noreferrer noopener\"><img decoding=\"async\" src=\"https://secure.gravatar.com/avatar/0ebc32f2dc5921020c3b62738f4fa058?s=160&amp;d=mm&amp;r=g\" alt=\"\"></a></figure>\n\n\n\n<p class=\"has-medium-font-size\"><strong><a href=\"https://profiles.wordpress.org/farhad0\" data-type=\"link\" data-id=\"https://profiles.wordpress.org/farhad0\">فرهاد سخایی</a></strong></p>\n</div>\n\n\n\n<div class=\"wp-block-group is-vertical is-content-justification-center is-nowrap is-layout-flex wp-container-core-group-is-layout-671c4991 wp-block-group-is-layout-flex\">\n<figure class=\"wp-block-image size-large\"><a href=\"https://profiles.wordpress.org/man4toman\" target=\"_blank\" rel=\"noreferrer noopener\"><img decoding=\"async\" src=\"https://secure.gravatar.com/avatar/0223bc303222e11c85b7e780e929bafa?s=160&amp;d=mm&amp;r=g\" alt=\"\"></a></figure>\n\n\n\n<p class=\"has-medium-font-size\"><strong><a href=\"https://profiles.wordpress.org/man4toman\" data-type=\"link\" data-id=\"https://profiles.wordpress.org/man4toman\" target=\"_blank\" rel=\"noreferrer noopener\">مرتضی گرانسایه</a></strong></p>\n</div>\n\n\n\n<div class=\"wp-block-group is-vertical is-content-justification-center is-nowrap is-layout-flex wp-container-core-group-is-layout-d7b04dc7 wp-block-group-is-layout-flex\">\n<figure class=\"wp-block-image size-large\"><a href=\"https://profiles.wordpress.org/saeedfard\" target=\"_blank\" rel=\"noreferrer noopener\"><img decoding=\"async\" src=\"https://secure.gravatar.com/avatar/218e2e8376f15e9d72de62b7a3c28fd4?s=160&amp;d=mm&amp;r=g\" alt=\"\"></a></figure>\n\n\n\n<p class=\"has-text-align-center has-medium-font-size\"><strong><a href=\"https://profiles.wordpress.org/saeedfard\" data-type=\"link\" data-id=\"https://profiles.wordpress.org/saeedfard\" target=\"_blank\" rel=\"noreferrer noopener\">سعید فرد</a></strong></p>\n</div>\n\n\n\n<div class=\"wp-block-group is-vertical is-content-justification-center is-nowrap is-layout-flex wp-container-core-group-is-layout-d7b04dc7 wp-block-group-is-layout-flex\">\n<figure class=\"wp-block-image size-large\"><a href=\"https://profiles.wordpress.org/sushyant\" target=\"_blank\" rel=\"noreferrer noopener\"><img decoding=\"async\" src=\"https://secure.gravatar.com/avatar/6a35a072c0766d41217d17317f3ea057?s=160&amp;d=mm&amp;r=g\" alt=\"\"></a></figure>\n\n\n\n<p class=\"has-medium-font-size\"><strong><a href=\"https://profiles.wordpress.org/sushyant\" data-type=\"link\" data-id=\"https://profiles.wordpress.org/sushyant\" target=\"_blank\" rel=\"noreferrer noopener\">سوشیانت زوار زاده</a></strong></p>\n</div>\n</div>\n\n\n\n<h2 class=\"wp-block-heading\">ویراستاران ترجمه پروژه‌های وردپرس</h2>\n\n\n\n<div style=\"clear:both;overflow: hidden\">\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/1farakav/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/2ac90d3243016ceb85b794693cb21517?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>1farakav</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/360messenger/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/15e0ea462c4401f4f72ecac44e3d748c?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>360messenger</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ach1992/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/210dd07c37484e1ee09f39e0dbe5a98e?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>ACh</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/addeveloper/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/cdfb2b2f869b117b3c7a717f1a0f5199?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>ADDeveloper</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/affiliatenetworks/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/e7f2577d1c64018b09ee9113cd006c8c?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>affiliatenetworks</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ahangarha/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/a7f24279a1c7eb9edfcd4bbfa6405844?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>ahangarha</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/translationsbysemperplugins/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/613ec4dc7a0323e1e04e0484b532e570?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>AIOSEO Translations</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/alizadegan/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/b596479b88c6b78ca32bc068be75bbf7?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Ali Alizadegan</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/aliarjini/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/cf8c1b74d58c3b8ea98b3262e0ae7ebe?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>ali arjini</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/alixo/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d60e3dc2dee03a210fe16337c2021c1c?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Ali Esmaeili</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/aligholami/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/32919c054088aa3dff571ab81c3f5d76?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Ali Gholami</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/alirashidnahal/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d2cc791ce1a9291e06775a1b24c3197e?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Ali Rashidnahal</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/as911/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/28dc5ad2aa7ccc44413057b033a536d4?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Alireza Sedghi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/amatris/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/24758bce866aeb6316f1256e3a1244e2?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>amatris</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ameskaran/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/9cb2521ac836b8c7f042396f1f39a914?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>ameskaran</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/aminfa/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/91a34f1a502004701d8ad2c1e715f3a6?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>amin askari</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/sazmankav/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/bcb756ce8bff9ae05111fc4dc73b8eaa?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Amin Mahjoor</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/aminomidi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/3959eb01b3eca2ac83ec36cbf9f0e9a5?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Amin Omidi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/amirarshia/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/347edea6a33c515fdf20f24240307c20?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>amirarshia</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/djamir121/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/e8eb5ca949a93d2606dc215593e0b2f3?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>AMIR Heydari</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/amirhpcom/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/a4b904ff316d7c98496108e651441624?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Amirhossein Hosseinpour</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/amirhosseinhpv/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/2f6329ce417480573782224099734deb?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>amirhp-com</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/native0098/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/89f22ae87a917b049b02728446c52372?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>ARash Ghanei</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ardalan13/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/760d071079d3ab12e22c545501811838?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Ardalan Davoudi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/aliasghar1112/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/3ffb886ffd1fe939559438c733b3a453?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>arian</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ariankeshavarz/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/91d82f7845cd8c3cf4354b8362a669f4?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Arian Keshavarz</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/armansiahloo/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/1e3fd783b8d49b7f08c8e153548f5673?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>arman siahloo</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/arvancloud/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/08b43a96759f4737ef6d334030e7b873?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>ArvanCloud</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/asadiy4n/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d81955a0f2c8d1b676735b19840fe957?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Asadiyan</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/asterids/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/99ad47b6ac94e4d14028d774771f68bc?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>asterids</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/aydin714/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/8c78459453fee125531ec04d413c7c26?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>aydin714</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/bbkysf/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/3276f73903245fe62deffb331ee11de5?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Babak Yousefzadeh</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/bmoudi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/fcc97bddef8d4e7b89a1911c06d75697?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Bijan Moudi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/blackswanlab/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/1fd03d88ea9dc937939fd0d655df155b?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>BlackSwan</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/chilisearch/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/cc10b45b85557af4b3b5c6022c4f4a05?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Chili Search</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/dedidata/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/f69a56c77882b62840c5f2a40cd1b087?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>DediData</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/digikotcom/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/381714b60533b546fa0b824717122524?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>digikot.com</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/domiinodev/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/ec7ccdac8fceb213e8e367ea310acc3d?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Domino dev</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/parnibraan/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/c121b76ce158eb2a7b88d7535d50e69e?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>ehsaan</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ercmanager1/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/64cb2605e604942bc16980498672f36e?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>ercmanager1</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ee_persian/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/319abf373a18f8bb53935a50ea681fdc?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>esmail ebrahimi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/esmailfadaei/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/db9d5507ce8b01a54c1b2c48593c16d7?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>esmailfadaei</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/feredi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/3f7819027cef1619a8ab2fa678042736?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Farhad Fariborzi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/farokhheidari/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/9da3725eed363a40e6c1a9e4ce59a818?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>farokhheidari</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/farshadhz/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/bae20c1e448d7ed3205e061f2b6571e5?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>farshadhz</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/arshen/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/5ad52ff159fc7d8fc5fe85288cb82319?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Foad Tahmasebi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ghtali/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/81ea8ef483e5fc8d53184fbfbe8c4f8e?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>ghtali</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/goudarz/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/5f663c942d32cc77e51b7ae94a199023?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Goudarz Jafari</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/hadiomid/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/f8ecf070e8d4649c5f03c36a66171eb9?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>hadi.omid</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/silvercover/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/3ced7aa268d0a80d29cee2731a5f589a?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Hamed Takmil</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/yazdaniwp/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/f62756a112ab1b86500c54beaea6dfbd?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Hamid Reza Yazdani</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/hanieh729/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/2cec9118b4afb3d5005c6ba298a5a8cb?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Hanieh Ramzanpour</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/hsnshfn/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/8ae345e1d37b9c3c8eb9470f28929a75?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Hassan Shafiian</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/hassantafreshi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/99a72de762392a5a5efbf36a4367f793?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>hassantafreshi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/hitsteps/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d1adb81e2590e1f3fa943e6865dbf459?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Hitsteps</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/h71/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/8415a8ca663844689b6b0e5f49108e3d?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Hossein</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/hosseinsadeghi69/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/ec5e64b66b43016fa7b635e026569986?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Hossein Sadeghi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/glboy/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/39910273e5a04bb79c64aa0c261d09dc?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>idehweb</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/imikiani/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/17575b917994c7f0273929220bb7f92f?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Iman Kiani</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/infomtaghavi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/796b1ab5fe2646f3ea525b01adbd5599?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>infomtaghavi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/irangold/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/901682cf57b32039d9559850f0871070?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>irangold</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/irdb/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/e0ab2d106c7cae38d826b9ccd0b427e8?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>irdb</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ham3da/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/f2d495a9435381aada34ba96535f1337?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Javad Ehteshami</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/pash2048/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/0bf24dc164ac15d58404ce6ccdf0e41c?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>javad jazandari</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/johnbozorgi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/cb66664459d45128adcff3ae34c99f4b?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>John Bozorgi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/kafrashi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/897230e3d4bc2af09e8cfc169fbc9ec4?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>kafrashi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/kamrankhorsandi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/c134f741d1a58ce5713dca362c454b27?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Kamran Khorsandi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/gamefa/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/4a5f0fbba8fbc26592b2ec5a84b62f4c?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>kasra naraghi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/khorshidlab/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d1005c02764ed93db28fc02af34cf9cc?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Khorshid</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/longman2020/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/c3867746448950074bf44902501e851e?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>longman2020</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/lusha/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/eb729c02496909a29b353fa110ff3abb?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>lumarsha</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mazraee/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/ad7313e9868d0d311cbcd8df3a712fe3?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>M. Mazraee</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mahdiebrahimii/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/fe5eecdeba173ac42d31c888bff1b2a0?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mahdi Ebrahimi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mahdiyerezaie/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/ccef3bc24c6020bad21752125d53bdd3?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>mahdiyerezaie</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mahdyarme/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d0bf590292d00fefbc17b24e7388ea88?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mahdyar Hasanpour</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mainseo/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/1ad550fce817bb096a7fe0eedefd0a41?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>mainseo</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/manzoorwanijk/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/ff0fc68d4d69124a38b4aed217a74ff5?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Manzoor Wani (a11n)</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mashhadcode/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/9b1414b9617f8e7345a01d10073030b9?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>mashhadcode</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/masoudnkh/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/ba3555901bd8c8f5a160af53e67b8ab8?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Masoud NKH</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/matinbeigi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/c9c10181d66be41f25c2fbe17658011e?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Matin Beigi (Rick Sanchez)</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/basemax/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/3cfbe47b6fb1f7c03467b2be20a1904f?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Max Base</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/antialiasfactory/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/1120e8649e76041919b334447228ffd7?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Maziar Firuzmand</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/m0911/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/73faf14ee55c29babb265e20ac22beff?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mehdi Abdollahi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mehdibolourian/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/f64880371f196af7f5d3490954f5d08d?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mehdi Bolourian</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/msn6060/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/f82de68ee8cac799acd5b841e5dbf026?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mehdi Soltani</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mehrban/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/301e39948cca7b82c50222dce2f6464c?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mehr@Ban</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mehrshaddarzi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d88c9733e7ed1deda936e848ee629e63?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mehrshad Darzi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mehrshad81/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/2fada5712ee0951795edd9b43eef90a3?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mehrshad MTI</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/weloper/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/298fae8b228d3d680c5b6b37b1caddb3?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mersad GHasemi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mhmanavi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/c1ce302525f2e6e3f63d1535d86b178a?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>mhmanavi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/michaelpk/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/82343eb50a4d3334144ed232ad8dfacf?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>michaelpk</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mihanwp/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/14144c1a63d0d1cf77ce4629ed77559c?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>MihanWP</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/lord_viper/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/fed8d40c5a576989ab0536611af3aea2?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mobin Ghasempoor</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/moccc/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/a175d00ddc61fdf6b7193fc7a8a82ab4?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>moccc</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mohadeseghasemi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/647aa1d91813a72b594705fdc93ee3fe?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mohadese Ghasemi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mohammad9574/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/1b213544ccfcc3eae61e4640eaa4733a?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mohammad Ahmadi Akbari</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ghasemi71ir/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/7173544c295e4da83c06463894924e24?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mohammad Ghasemi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mohammadhero/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d3cc70e26610175df37e29ad3058476b?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mohammad Hero</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/kamalireal/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/7d12ca5dd6b28c06fb3e6d9bab35d98c?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>MohammadReza Kamali</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mohsenpazhoohiyani/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d1ec0de464dfa603266aafb57893190a?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Moh Sen</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mohsengham/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/64d4e212c9263a72b2fcadbe3951342f?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mohsen Ghiasi Ravari</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mojtaba-taheri/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/dadbd3df6db151c924279a85333be5d3?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mojtaba</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mojtabad/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/bad8c41e73e002d4a356b6f45ea5cbea?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mojtaba Darvishi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/moreconvert/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/4aec5812e3db8673416ae1130567d24a?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>moreconvert</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mo0orteza/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/ff676fc8aefcaba0a322e26cf9b6e33c?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Morteza Gholami</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mostafarouz/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/61cd3a411bf24f29129cc5f6671ca54a?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>mostafarouz</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/pctricksir/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/f3de891086460ebc9d49285dd875d392?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mostafa Shiraali</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mostafas1990/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/e3631726d155eac3e02f76ce86675b5e?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mostafa Soufi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/motefaghehi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/ab18b632dcc092fa8f9186aeda372ca6?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Motefaghehi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/motlaqcode/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/1b483f0e8a37f692326fa773f13fdc67?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>motlaq.code</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mralidoosti/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/a3fb02547f4c5c7b52a0e8f62808e5f2?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Mr.Alidoosti</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/msninsider/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/cbde60e0b6889dce753b42c8902ef5c0?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>msninsider</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/narimonfund/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/5285b112df84b46bdbb74863578eb613?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>narimonfund</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/navidos/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/7dcc163b0e899db1292b87e75f40bda4?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Navid</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/kashani/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/b36d7087386d76b7a19108b02f98f106?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Navid Kashani</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/milad47/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/37274b79cf0175321cb7643fbee5df94?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Nejad (drdgtal.ir)</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/niloomand/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/0cd10486b080d82bfe48daa6230dd935?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Niloufar Firouzmand</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/nima78600/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d748601773ad0279e56aa3c4019115b6?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Nima</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/nirweb/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/c7415431eace690f62db1308c0ad64d9?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>NirWp Team</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/novinhub/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/322d3edcc25fe18b82e463a283cef232?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>novinhub</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/rajaeinet/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/fd7b9df37ca332d1442a0ce3967a7c44?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Omid Rajaei</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/otoraby/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/60ae94ff71f9b47157b12f662edf29c7?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>otoraby</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/parselearn/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/fdaf2d63dcac607c3369add863f92d49?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Parsa</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/rahmatmajidi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/3fec48b6acbb1532a33452201fe96f1b?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>parsamajidi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/saeed_same/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/696fc497c9a2c917559f87d052bc3567?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br></a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/parsmizban/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/f9456e0a85245eddae6ead8ff0fd73ec?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Pars Mizban</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/payzito/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/2a81c9c4689f2161249bd7a7af97fcd2?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Payzito</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/pegahnorozi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/3516a004a13a9aabf580b1af90709f38?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>pegahnorozi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/peprodev/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/ab681a56b7c8835bd5e9115cd2168967?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Pepro Dev. Group</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/persianscript/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/ef45e608481190c18b2af07af5723f9b?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>PersianScript</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/piman/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/6d47c40bb24abd6a4635f8a938833595?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Peyman Naeimi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/pingmeter/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/fef2f4fcb95ba6066ef881890471b601?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Pingmeter</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/poolito/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/f492c9b739e0f81689cdac49f18045d4?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Poolito</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/porsline/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/aa21f1b133d19e3ec284b54f6f66e8d1?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>porsline</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/poshtibancom/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/efe7c8e18dc355f38c206462e2a8fd89?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Poshtiban</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/qodeinteractive/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/b3112ae650270b077c3757e194e07b12?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Qode</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/rarathemesupport/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/fd7624354ed1954db2857defe5d41717?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Rara Themes Support</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/vadatiertebat/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/e19ecf951917ba4664ad0dcb920a86f7?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Rasool Vahdati</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/sadeghpm/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/c63f816d8d209d003b333883a5116d0a?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>sadeghpm</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/safelayout/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/0d8556a5f60d79d46e4a0d99ec3bb01e?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>safelayout</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/sahabi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/713bcf163578d7beaf4fc5633068ee2e?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>sahabi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/sajjadtalebi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/41fdeae6932388edea980feab1ea8878?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>sajjad talebi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/salarlotfi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/19796781761750c8f461faa560255f72?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>salar lotfi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/samanehmirrajabi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/3c249b6aea6b218f100a646dd4236322?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Samaneh Mirrajabi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/samtemehr/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/fb8da7c62925a0f0747d979f5416c005?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>samtemehr</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/saniamohammadi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/4b1289fe9c88fa85980f32b1da0ffa32?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Sania Mohammadi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/sareham238/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/dfda29e07b9ef724e74a5489462acc1d?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>sareham238</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/salamzadeh/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/981c633c2e04866c36713f4c771ead61?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Sasan Salamzadeh</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ebrahimzadeh/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/6a6a7c553627a2f0b1f229ef896f9593?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Sekineh Ebrahimzadeh</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/seramo/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/59a56d919279eb8c099e9ecfde2ac1b1?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>seramo</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/shayanfp/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/e2bd4472eb102fb2523f618f354d20bb?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Shayan Farhang Pazhooh</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/shokrino/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/2c5113e52a9ead1d847a053680b929f5?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Shokrino Team</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/salemi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/9d8d335ac6f18b9d70529ec181e07825?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Siavash</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/sinashams/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/5bc3dc3c1c481092e57d5ee7aaad8d4c?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Sina Shamsizadeh</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/smm1378/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d11d16690e254682f881b95a8906e9b6?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>smm1378</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/smrm/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/917f43c1bc06d82d93b33c6feb567ee3?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>smrmkh</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/soheilmir/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/dd162394cad442a9d41f6e61e9699fcc?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>soheilmir</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/sunyniazi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/9118863f478aacf17e28c9c8eaaac868?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>sunyniazi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/tadeha/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d9d8d1fe52190dd5533faa32084601ba?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>tadeha</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/tsina/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/5175589803cc8209f9d14ff51f21ba6f?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>tsina</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/untashgaal/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/c80bf7c5fe758586a0dd3c57abfa18f8?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Untashgaal</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/worldless/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/647edccfb36251fa1088ac69ddf24e3d?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>worldless</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/wpvar/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/2e7c768382cbc3d2f0a927caea2b8b83?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>wpvar</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/yasser1992/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/7ff577dff2645a4cbd9aaad68cb71b4e?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Yaser Shahi</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/yashar_hv/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/69e51bde3535a671976159ba988d1fc1?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Yashar</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/ynproduct/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/72bcce1fa00e869b00a3ccabff95c6e0?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>ynproduct</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/cg-team/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/b7b3d45881027c27ef020c17b8750480?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Yousefzadeh</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/zareidev/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/fcbc5c441416e2c6ea8f9c9b23001a4d?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>zarei_dev</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/armenab1/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/9c8a84d3ceae3eaa3a7c8b0ad998109b?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>Արմեն</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/elementorir/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d0e9b9be12b8164adb0adf91a980236f?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>المنتور فارسی</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/mahdi6489/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/d35bb6a22a417637fc73beeb92600be1?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>تندر وردپرس</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/zeroone2021/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/75478f3f1929f976951d668ee1e364a3?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>دنیای صفر و یک دیجیتالی</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/salman1990/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/f05fafc0856c43643dd36628b34b9944?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>سلمان محمدی</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/qwerty13/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/e802e5ac490da7d1029b7029265249ef?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>مرتضی رستگار</a>\n				<a style=\"width: calc(25% - 10px);float:left;text-align: center;margin-left: 10px;margin-top: 10px !important\" class=\"profile\" href=\"https://profiles.wordpress.org/pedramrahimi/\"><img loading=\"lazy\" decoding=\"async\" alt=\"\" src=\"https://secure.gravatar.com/avatar/b545db4131a739d2348816b3c6ee12ae?s=40&amp;d=mm&amp;r=g\" class=\"avatar avatar-40 photo\" height=\"40\" width=\"40\"><br>پدرام رحیمی</a>\n</div>\n<div class=\"clear:both;content: \'\';display: flex-row;\"></div>\n\n\n\n<div style=\"height:40px\" aria-hidden=\"true\" class=\"wp-block-spacer\"></div>\n\n\n\n<p class=\"has-text-align-center\"><strong><a href=\"https://make.wordpress.org/polyglots/teams/?locale=fa_IR\" data-type=\"link\" data-id=\"https://make.wordpress.org/polyglots/teams/?locale=fa_IR\" target=\"_blank\" rel=\"noreferrer noopener\">مشاهده لیست کامل توسعه دهندگان بخش فارسی</a></strong></p>\n\n\n\n<h2 class=\"wp-block-heading\">استفاده کنندگان زبان فارسی وردپرس</h2>\n\n\n\n<p>تا سال 2024، 44.26٪ از کل وبسایت های اینترنت از وردپرس استفاده می‌کنند. این مقدار برابر با چیزی حدود ۸۱۰ میلیون وب‌سایت می‌شود و این شماره به سرعت در حال افزایش است. بیش از ۵۰۰ وب‌سایت هر روز با وردپرس ساخته می‌شود. از میان این وب سایت‌ها چیزی حدود ۸۱ میلیون وب سایت، به زبان فارسی می‌باشند (یک دهم درصد)</p>\n\n\n\n<h2 class=\"wp-block-heading\">تاریخچه فعالیت تیم وردپرس فارسی</h2>\n\n\n\n<p>فعالیت تیم وردپرس فارسی تقریبا از ابتدای بوجود آمدن وردپرس شکل گرفت و در فروردین ۱۳۸۶ انتشار افزونه تاریخ شمسی برای وردپرس توسط آقای <a href=\"https://profiles.wordpress.org/mani_monaj\" data-type=\"link\" data-id=\"https://profiles.wordpress.org/mani_monaj\">مانی منجّمی</a>، سرعت بومی‌سازی وردپرس را دو چندان کرد. فعالیت‌های این دوستان و همچنین کاربر <a href=\"https://profiles.wordpress.org/gonahkar\" data-type=\"link\" data-id=\"https://profiles.wordpress.org/gonahkar\">Gonahkar</a> باعث افزایش چشمگیر محبوبیت وردپرس، در میان کاربران وب فارسی زبان شد.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:164:\"https://fa.wordpress.org/team/2024/02/17/%d9%85%d8%b9%d8%b1%d9%81%db%8c-%d8%aa%db%8c%d9%85-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"145\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:3;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:68:\"واژه‌نامه رسمی وردپرس فارسی منتشر شد\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:227:\"https://fa.wordpress.org/team/2024/02/09/%d9%88%d8%a7%da%98%d9%87%d9%86%d8%a7%d9%85%d9%87-%d8%b1%d8%b3%d9%85%db%8c-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:236:\"https://fa.wordpress.org/team/2024/02/09/%d9%88%d8%a7%da%98%d9%87%d9%86%d8%a7%d9%85%d9%87-%d8%b1%d8%b3%d9%85%db%8c-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/#comments\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Fri, 09 Feb 2024 21:23:56 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"مطالب\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:35:\"https://fa.wordpress.org/team/?p=98\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:609:\"واژه‌نامه وردپرس فارسی بر اساس واژه‌های پرتکرار در هسته وردپرس و بخش مدیریت آن ایجاد شده است. شما مترجم عزیز می‌توانید در هنگام ترجمه وردپرس در بخش ترجمه آنلاین وردپرس فارسی، از پیشنهادات ترجمه‌ای که بر اساس این واژه‌نامه به شما داده می‌شود استفاده نمایید و ترجمه خود را ساده‌تر و روان‌تر انجام دهید. این واژه‌نامه شامل بیش [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Farhad Sakhaei\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2087:\"<p><a href=\"https://translate.wordpress.org/locale/fa/default/glossary/\">واژه‌نامه وردپرس فارسی</a> بر اساس واژه‌های پرتکرار در هسته وردپرس و بخش مدیریت آن ایجاد شده است. شما مترجم عزیز می‌توانید در هنگام ترجمه وردپرس در بخش <a rel=\"noreferrer noopener\" href=\"https://translate.wordpress.org/locale/fa/\" target=\"_blank\">ترجمه آنلاین وردپرس فارسی</a>، از پیشنهادات ترجمه‌ای که بر اساس این واژه‌نامه به شما داده می‌شود استفاده نمایید و ترجمه خود را ساده‌تر و روان‌تر انجام دهید.</p>\n\n\n\n<p>این واژه‌نامه شامل بیش از ۱۲۰۰ واژه و عبارت می‌باشد و به دلیل تعداد زیاد کلمات و عبارت‌های درج شده در آن، ممکن است نیاز به بهبود بیشتر نیز داشته باشد. لذا در صورتی که مایل به بهبود این واژه‌نامه هستید می‌توانید پیشنهادات خود را در مورد بهبود ترجمه واژه‌ها به صورت دیدگاه (Comment) بر روی <a href=\"https://docs.google.com/spreadsheets/d/1SrhQknH-gipzFXI6TCu1KEXUF9QivkCo3jp6yJy3CRE/edit?usp=sharing\" target=\"_blank\" rel=\"noreferrer noopener\">منبع Google Sheet این واژه‌نامه</a> ارائه نمایید. ضمنا در صورتی که نیاز به بحث و گفتگو در مورد واژه‌ای دارید، می‌توانید به بخش <a href=\"https://t.me/wpdevelopers\" target=\"_blank\" rel=\"noreferrer noopener\">گفتگوهای مربوط به تیم وردپرس فارسی</a> مراجعه و اقدام به عضویت و ورود نمایید. گردآوری این واژه‌نامه با تلاش <a href=\"https://make.wordpress.org/polyglots/teams/?locale=fa_IR\" target=\"_blank\" rel=\"noreferrer noopener\">تیم وردپرس فارسی</a> انجام شده است.<br></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:232:\"https://fa.wordpress.org/team/2024/02/09/%d9%88%d8%a7%da%98%d9%87%d9%86%d8%a7%d9%85%d9%87-%d8%b1%d8%b3%d9%85%db%8c-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%d9%85%d9%86%d8%aa%d8%b4%d8%b1-%d8%b4%d8%af/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"7\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:2:\"98\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:4;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:69:\"برگزاری تولد وردپرس در میتاپ بندرعباس\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:239:\"https://fa.wordpress.org/team/2023/05/24/%d8%a8%d8%b1%da%af%d8%b2%d8%a7%d8%b1%db%8c-%d8%aa%d9%88%d9%84%d8%af-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%af%d8%b1-%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d8%a8%d9%86%d8%af%d8%b1%d8%b9%d8%a8%d8%a7%d8%b3/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:247:\"https://fa.wordpress.org/team/2023/05/24/%d8%a8%d8%b1%da%af%d8%b2%d8%a7%d8%b1%db%8c-%d8%aa%d9%88%d9%84%d8%af-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%af%d8%b1-%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d8%a8%d9%86%d8%af%d8%b1%d8%b9%d8%a8%d8%a7%d8%b3/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Wed, 24 May 2023 06:17:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"رویدادها\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://fa.wordpress.org/team/?p=102\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:469:\"به همین جهت ما نیز در جامعه وردپرس ایران در این روز دور هم جمع شده و در رویداد تولد ۲۰ سالگی وردپرس دیدار تازه می‌کنیم. از شما علاقمندان به دنیای وردپرس و متن باز دعوت میکنیم که این روز رو در کنار ما باشید. تاریخ برگزاری رویداد: شنبه 6 خرداد، ساعت 18:00 الی 20:15 [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Saeed Fard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:3337:\"<figure class=\"wp-block-image size-full\"><a href=\"https://fa.wordpress.org/files/2023/05/poster-wordpress-2-1024x1024-1.jpg\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2023/05/poster-wordpress-2-1024x1024-1.jpg\" alt=\"\" class=\"wp-image-817\"></a></figure>\n\n\n\n<p>به همین جهت ما نیز در جامعه وردپرس ایران در این روز دور هم جمع شده و در رویداد تولد ۲۰ سالگی وردپرس دیدار تازه می‌کنیم.</p>\n\n\n\n<p>از شما علاقمندان به دنیای وردپرس و متن باز دعوت میکنیم که این روز رو در کنار ما باشید.</p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\">\n\n\n\n<p>تاریخ برگزاری رویداد: <strong>شنبه 6 خرداد، ساعت 18:00 الی 20:15</strong></p>\n\n\n\n<p>محل برگزاری: <strong>بندرعباس، خیابان آیت الله غفاری شمالی، ساختمان پارک علم و فناوری هرمزگان، سالن کنفرانس</strong></p>\n\n\n\n<p>ظرفیت: <strong>50 نفر</strong></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\">\n\n\n\n<h2 class=\"wp-block-heading\">ثبت نام در میتاپ</h2>\n\n\n\n<p>شرکت در این رویداد رایگان است اما حتما برای حضور باید در آن ثبت نام کنید.<br>برای ثبت نام در میتاپ وردپرس بندرعباس به این لینک Attend کرده</p>\n\n\n\n<p><a href=\"https://www.meetup.com/bandarabbas-wordpress-meetup/events/293634850/\">https://www.meetup.com/bandarabbas-wordpress-meetup/</a></p>\n\n\n\n<p>به دلیل محدودیت ظرفیت در این رویداد در صورت ثبت نام و کنسل شدن حضورتون حتما به برگزار کنندگان رویداد اطلاع‌رسانی کنید.</p>\n\n\n\n<p>جهت اطلاع‌رسانی در مورد رویداد در شبکه‌های اجتماعی میتاپ وردپرس عضو شوید.</p>\n\n\n\n<p><a href=\"https://t.me/irwpmeetup\" target=\"_blank\" rel=\"noreferrer noopener\">https://t.me/irwpmeetup</a><br><a href=\"https://instagram.com/irwpmeetup\" target=\"_blank\" rel=\"noreferrer noopener\">https://instagram.com/irwpmeetup</a><br><a href=\"https://wpmeetup.ir/\" target=\"_blank\" rel=\"noreferrer noopener\">https://wpmeetup.ir/</a></p>\n\n\n\n<hr class=\"wp-block-separator has-alpha-channel-opacity\">\n\n\n\n<h2 class=\"wp-block-heading\">برنامه رویداد</h2>\n\n\n\n<figure class=\"wp-block-table is-style-stripes\"><table><tbody><tr><td><strong>برنامه</strong></td><td><strong>ساعت</strong></td></tr><tr><td>معرفی و خوش‌آمد گویی</td><td>18:00 الی 18:15</td></tr><tr><td>فرصت شبکه سازی با متخصصان و علاقه مندان وردپرس</td><td>18:15 الی 18:45</td></tr><tr><td>بحث و گفتگو در مورد سرعت و بهینه سازی وردپرس</td><td>18:45 الی 19:45</td></tr><tr><td>جشن تولد وردپرس همراه با کیک و عکاسی</td><td>19:45 الی 20:15</td></tr></tbody></table></figure>\n\n\n\n<h2 class=\"wp-block-heading\">برگزارکنندگان این رویداد</h2>\n\n\n\n<figure class=\"wp-block-image aligncenter size-full\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2023/05/sponser-bnd.jpg\" alt=\"\" class=\"wp-image-818\"></figure>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:244:\"https://fa.wordpress.org/team/2023/05/24/%d8%a8%d8%b1%da%af%d8%b2%d8%a7%d8%b1%db%8c-%d8%aa%d9%88%d9%84%d8%af-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%af%d8%b1-%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d8%a8%d9%86%d8%af%d8%b1%d8%b9%d8%a8%d8%a7%d8%b3/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"102\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:5;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:91:\"میتاپ تولد ۲۰ سالگی وردپرس در تهران برگزار می‌شود\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:241:\"https://fa.wordpress.org/team/2023/05/16/%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d8%aa%d9%88%d9%84%d8%af-%db%b2%db%b0-%d8%b3%d8%a7%d9%84%da%af%db%8c-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%af%d8%b1-%d8%aa%d9%87%d8%b1%d8%a7%d9%86-%d8%a8%d8%b1%da%af/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:249:\"https://fa.wordpress.org/team/2023/05/16/%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d8%aa%d9%88%d9%84%d8%af-%db%b2%db%b0-%d8%b3%d8%a7%d9%84%da%af%db%8c-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%af%d8%b1-%d8%aa%d9%87%d8%b1%d8%a7%d9%86-%d8%a8%d8%b1%da%af/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 16 May 2023 06:22:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"رویدادها\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://fa.wordpress.org/team/?p=104\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:512:\"در تاریخ ۶ خرداد امسال وردپرس ۲۰ ساله می‌شود. به همین مناسبت در تمامی دنیا رویدادهایی با هدف گرفتن جشن برای این روز برگزار می‌شود. لوکال منیجرها، توسعه‌دهنده‌ها و سایر دوستدارن دنیای متن باز و وردپرس با دورهم جمع شدن این روز رو در کل دنیا با هم جشن می‌گیرند. به همین جهت ما نیز [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Saeed Fard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4439:\"<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2023/05/2.png\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2023/05/2-1024x768.png\" alt=\"\" class=\"wp-image-790\"></a></figure>\n\n\n\n<p>در تاریخ ۶ خرداد امسال وردپرس ۲۰ ساله می‌شود. به همین مناسبت در تمامی دنیا رویدادهایی با هدف گرفتن جشن برای این روز برگزار می‌شود. لوکال منیجرها، توسعه‌دهنده‌ها و سایر دوستدارن دنیای متن باز و وردپرس با دورهم جمع شدن این روز رو در کل دنیا با هم جشن می‌گیرند.</p>\n\n\n\n<p>به همین جهت ما نیز در جامعه وردپرس ایران در این روز دور هم جمع شده و در رویداد تولد ۲۰ سالگی وردپرس دیدار تازه می‌کنیم.</p>\n\n\n\n<p>از شما علاقمندان به دنیای وردپرس و متن باز دعوت میکنیم که این روز رو در کنار ما باشید.</p>\n\n\n\n<p>تاریخ برگزاری رویداد: <strong>جمعه 5 خرداد، ساعت 9:30 الی 14:00</strong></p>\n\n\n\n<p>محل برگزاری: <strong>تهران، کیلومتر 15 بزرگراه فتح (پل ایرانخودرو)، خیابان تولایی،نبش کوچه لاله،کارخانه نوآوری و صنایع خلاق آمپر</strong></p>\n\n\n\n<p>ظرفیت: <strong>45 نفر</strong></p>\n\n\n\n<p>شرکت در این رویداد رایگان است اما حتما برای حضور باید در آن ثبت نام کنید.<br>برای ثبت نام ابتدا در میتاپ وردپرس تهران به این لینک Attend کرده</p>\n\n\n\n<p><a href=\"https://www.meetup.com/tehran-wordpress-meetup/events/293556812/\">https://www.meetup.com/tehran-wordpress-meetup/events/293556812</a></p>\n\n\n\n<p>و سپس اطلاعاتتون رو در این فرم ثبت کنید.</p>\n\n\n\n<p><a href=\"https://wpmeetup.ir/wp20/\">https://wpmeetup.ir/wp20</a><br></p>\n\n\n\n<p><strong>توجه نمایید که ثبت اطلاعات در فرم ذکر شده به منزله نهایی کردن ثبت نام است.</strong></p>\n\n\n\n<p>به دلیل محدودیت ظرفیت در این رویداد در صورت ثبت نام و کنسل شدن حضورتون حتما به برگزار کنندگان رویداد اطلاع‌رسانی کنید.</p>\n\n\n\n<p>جهت اطلاع‌رسانی در مورد رویداد در شبکه‌های اجتماعی میتاپ وردپرس عضو شوید.</p>\n\n\n\n<p><a rel=\"noreferrer noopener\" href=\"https://t.me/irwpmeetup\" target=\"_blank\">https://t.me/irwpmeetup</a><br><a rel=\"noreferrer noopener\" href=\"https://instagram.com/irwpmeetup\" target=\"_blank\">https://instagram.com/irwpmeetup</a><br><a rel=\"noreferrer noopener\" href=\"https://wpmeetup.ir/\" target=\"_blank\">https://wpmeetup.ir/</a></p>\n\n\n\n<span id=\"more-104\"></span>\n\n\n\n<h2 class=\"wp-block-heading\">برنامه رویداد</h2>\n\n\n\n<figure class=\"wp-block-table is-style-stripes\"><table><tbody><tr><td><strong>برنامه</strong></td><td><strong>ساعت</strong></td></tr><tr><td>معرفی و خوش‌آمد گویی (سعید فرد)</td><td>9:45 الی 10</td></tr><tr><td>سخنرانی اول – رسول وحدتی (امنیت وردپرس)</td><td>10 الی 10:45</td></tr><tr><td>وقت استراحت و پذیرایی اول</td><td>10:45 الی 11:15</td></tr><tr><td>سخنرانی دوم – مخاطرات استفاده محصولات وردپرسی نال و غیراصل (صحبت به صورت آزاد)</td><td>11:15 الی 12</td></tr><tr><td>تولد وردپرس، عکاسی و پذیرایی و شبکه‌سازی</td><td>12 الی 13:30</td></tr></tbody></table></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2023/05/2.5.png\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2023/05/2.5-1024x768.png\" alt=\"\" class=\"wp-image-802\"></a></figure>\n\n\n\n<h2 class=\"wp-block-heading\">اسپانسر برگزاری این رویداد</h2>\n\n\n\n<figure class=\"wp-block-image aligncenter size-medium is-resized\"><a href=\"https://limoo.host/\" target=\"_blank\" rel=\"noreferrer noopener\"><img decoding=\"async\" src=\"https://wpmeetup.ir/wp-content/uploads/2023/05/IMG_7339-300x300.png\" alt=\"\" class=\"wp-image-531\" style=\"width:146px;height:146px\"></a></figure>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:246:\"https://fa.wordpress.org/team/2023/05/16/%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d8%aa%d9%88%d9%84%d8%af-%db%b2%db%b0-%d8%b3%d8%a7%d9%84%da%af%db%8c-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%af%d8%b1-%d8%aa%d9%87%d8%b1%d8%a7%d9%86-%d8%a8%d8%b1%da%af/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"104\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:6;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:57:\"میتاپ روز ترجمه وردپرس به فارسی\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:203:\"https://fa.wordpress.org/team/2020/09/01/%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d8%b1%d9%88%d8%b2-%d8%aa%d8%b1%d8%ac%d9%85%d9%87-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%a8%d9%87-%d9%81%d8%a7%d8%b1%d8%b3%db%8c/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:211:\"https://fa.wordpress.org/team/2020/09/01/%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d8%b1%d9%88%d8%b2-%d8%aa%d8%b1%d8%ac%d9%85%d9%87-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%a8%d9%87-%d9%81%d8%a7%d8%b1%d8%b3%db%8c/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Tue, 01 Sep 2020 06:51:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"رویدادها\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://fa.wordpress.org/team/?p=115\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:564:\"رویداد چند روزه ترجمه وردپرس همزمان با روز جهانی ترجمه شروع شد. در این رویداد طبق روال چند سال اخیر، همزمان با سایر مترجمان وردپرس به زبان‌های مختلف، بخش‌های هسته، سایت اصلی، پوسته‌ها، افزونه‌ها و اپ‌های موبایل را در کنار هم به زبان فارسی ترجمه می‌کنیم. رویداد روز ترجمه فارسی، بصورت یک میتاپ آنلاین در [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Saeed Fard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:1895:\"<p>رویداد چند روزه ترجمه وردپرس همزمان با روز جهانی ترجمه شروع شد. در این رویداد طبق روال چند سال اخیر، همزمان با سایر مترجمان وردپرس به زبان‌های مختلف، بخش‌های هسته، سایت اصلی، پوسته‌ها، افزونه‌ها و اپ‌های موبایل را در کنار هم به زبان فارسی ترجمه می‌کنیم.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2020/09/highres_492664489-1024x576.png\" alt=\"\" class=\"wp-image-648\"></figure>\n\n\n\n<p>رویداد روز ترجمه فارسی، بصورت یک میتاپ آنلاین در روز <strong>جمعه ۱۱ مهرماه ۱۳۹۹</strong> انجام می شود. اگر علاقمند به حضور در این رویداد هستید می‌توانید از طریق آدرس زیر اطلاعات بیشتری در مورد آن کسب کنید:<br></p>\n\n\n\n<figure class=\"wp-block-embed-meetup-com wp-block-embed is-type-rich is-provider-meetup\"><div class=\"wp-block-embed__wrapper\">\r\nhttps://www.meetup.com/tehran-wordpress-meetup/events/273541393/\r\n</div></figure>\n\n\n\n<p class=\"has-text-align-right\">و یا می‌توانید در ساعت مشخص شده، بصورت مستقیم به پیوند رویداد وارد و به جمع دیگر دوستان بپیوندید:</p>\n\n\n\n<p class=\"has-text-align-left\" style=\"font-size:18px\"><br><strong><a href=\"https://www.meetup.com/tehran-wordpress-meetup/events/273541393\">https://www.meetup.com/tehran-wordpress-meetup/events/273541393</a></strong></p>\n\n\n\n<p>توجه داشته باشید که برای شرکت در پیوند بالا، نیازی به ثبت نام نیست و رویداد راس ساعت اعلام شده آغاز می‌شود.</p>\n\n\n\n<p></p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:208:\"https://fa.wordpress.org/team/2020/09/01/%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d8%b1%d9%88%d8%b2-%d8%aa%d8%b1%d8%ac%d9%85%d9%87-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%a8%d9%87-%d9%81%d8%a7%d8%b1%d8%b3%db%8c/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"115\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:7;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:77:\"برگزاری روز ترجمه وردپرس به فارسی در تهران\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:241:\"https://fa.wordpress.org/team/2019/05/11/%d8%a8%d8%b1%da%af%d8%b2%d8%a7%d8%b1%db%8c-%d8%b1%d9%88%d8%b2-%d8%aa%d8%b1%d8%ac%d9%85%d9%87-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%a8%d9%87-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%d8%af%d8%b1-%d8%aa%d9%87/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:249:\"https://fa.wordpress.org/team/2019/05/11/%d8%a8%d8%b1%da%af%d8%b2%d8%a7%d8%b1%db%8c-%d8%b1%d9%88%d8%b2-%d8%aa%d8%b1%d8%ac%d9%85%d9%87-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%a8%d9%87-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%d8%af%d8%b1-%d8%aa%d9%87/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 11 May 2019 07:54:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"رویدادها\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://fa.wordpress.org/team/?p=122\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:509:\"امروز (۲۱ اردیبهشت ۱۳۹۸) روز جهانی ترجمه وردپرس بود، یک رویداد که افراد زیادی در سراسر جهان جهت مشارکت برای ترجمه وردپرس، همکاری می‌کنند. ما نیز از این موضوع به دور نبودیم و به صورت گروهی وردپرس را به فارسی ترجمه کردیم و از کنار هم بودن لذت بردیم. روز ترجمه وردپرس باز نیز تکرار [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:14:\"Farhad Sakhaei\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:2346:\"<p>امروز (۲۱ اردیبهشت ۱۳۹۸) روز جهانی ترجمه وردپرس بود، یک رویداد که افراد زیادی در سراسر جهان جهت مشارکت برای ترجمه وردپرس، همکاری می‌کنند. ما نیز از این موضوع به دور نبودیم و به صورت گروهی وردپرس را به فارسی ترجمه کردیم و از کنار هم بودن لذت بردیم. روز ترجمه وردپرس باز نیز تکرار خواهد شد. </p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped wp-block-gallery-1 is-layout-flex wp-block-gallery-is-layout-flex\">\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2019/05/1.jpg\"><img decoding=\"async\" data-id=\"495\" src=\"https://fa.wordpress.org/files/2019/05/1-1024x772.jpg\" alt=\"\" class=\"wp-image-495\"></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2019/05/2.jpg\"><img decoding=\"async\" data-id=\"496\" src=\"https://fa.wordpress.org/files/2019/05/2-1024x767.jpg\" alt=\"\" class=\"wp-image-496\"></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2019/05/3.jpg\"><img decoding=\"async\" data-id=\"497\" src=\"https://fa.wordpress.org/files/2019/05/3-1024x767.jpg\" alt=\"\" class=\"wp-image-497\"></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2019/05/4.jpg\"><img decoding=\"async\" data-id=\"498\" src=\"https://fa.wordpress.org/files/2019/05/4-1024x767.jpg\" alt=\"\" class=\"wp-image-498\"></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2019/05/5.jpg\"><img decoding=\"async\" data-id=\"499\" src=\"https://fa.wordpress.org/files/2019/05/5-1024x767.jpg\" alt=\"\" class=\"wp-image-499\"></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2019/05/6.jpg\"><img decoding=\"async\" data-id=\"500\" src=\"https://fa.wordpress.org/files/2019/05/6-1024x767.jpg\" alt=\"\" class=\"wp-image-500\"></a></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><a href=\"https://fa.wordpress.org/files/2019/05/7.jpg\"><img decoding=\"async\" data-id=\"501\" src=\"https://fa.wordpress.org/files/2019/05/7-1024x533.jpg\" alt=\"\" class=\"wp-image-501\"></a></figure>\n</figure>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:246:\"https://fa.wordpress.org/team/2019/05/11/%d8%a8%d8%b1%da%af%d8%b2%d8%a7%d8%b1%db%8c-%d8%b1%d9%88%d8%b2-%d8%aa%d8%b1%d8%ac%d9%85%d9%87-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%a8%d9%87-%d9%81%d8%a7%d8%b1%d8%b3%db%8c-%d8%af%d8%b1-%d8%aa%d9%87/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"122\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:8;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:47:\"پنجمین میتاپ وردپرس تهران\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:177:\"https://fa.wordpress.org/team/2019/01/03/%d9%be%d9%86%d8%ac%d9%85%db%8c%d9%86-%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%aa%d9%87%d8%b1%d8%a7%d9%86/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:185:\"https://fa.wordpress.org/team/2019/01/03/%d9%be%d9%86%d8%ac%d9%85%db%8c%d9%86-%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%aa%d9%87%d8%b1%d8%a7%d9%86/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Thu, 03 Jan 2019 07:59:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"رویدادها\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://fa.wordpress.org/team/?p=127\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:554:\"پنجمین میتاپ وردپرس تهران در تاریخ 7 دی‌ماه 1397 برگزار شد. میتاپ در این دوره هم با استقبال بی‌نظیر علاقمندان به وردپرس مواجه بود . انتظار می‌رود که شاهدحضور بیشتر شما عزیزان در میتاپ‌های بعد باشیم. آقای سعید فرد با صحبت درباره اهداف میتاپ (برگزاری wordcamp در سال آینده، توسعه وردپرس فارسی) آغاز کننده این [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Saeed Fard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:4863:\"<p>پنجمین میتاپ وردپرس تهران در تاریخ 7 دی‌ماه 1397 برگزار شد. میتاپ در این دوره هم با استقبال بی‌نظیر علاقمندان به وردپرس مواجه بود . انتظار می‌رود که شاهدحضور بیشتر شما عزیزان در میتاپ‌های بعد باشیم.</p>\n\n\n\n<p>آقای سعید فرد با صحبت درباره اهداف میتاپ (برگزاری wordcamp در سال آینده، توسعه وردپرس فارسی) آغاز کننده این رویداد بود.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2020/01/%D8%B3%D8%B9%DB%8C%D8%AF-%D9%81%D8%B1%D8%AF-%D9%85%DB%8C%D8%AA%D8%A7%D9%BE-768x768-1.jpg\" alt=\"\" class=\"wp-image-587\"></figure>\n\n\n\n<p>بعد از اینکه دوستان شرکت کننده خودشان را معرفی کردند نوبت به ارائه آقای مهدی رضایی (طراح وتوسعه دهنده وب) با موضوع: توسعه دهنده بهتری برای وردپرس باشیم رسید .</p>\n\n\n\n<p>آقای رضایی در ابتدا وردپرسفیای را برای دوستان معرفی کرد و مراحل نصب آن را توضیح و انجام داد. به سوالات حضار درباره ودرپرسفیای پاسخ داد .</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2020/01/mehdi-rezaeii-768x768-1.jpg\" alt=\"\" class=\"wp-image-588\"></figure>\n\n\n\n<p>در قسمت دوم ارائه خود آقای رضایی، سایپرس (ابزاری برای آزمایش سایت وردپرسی) را معرفی کرده و مراحل کار با سایپرس را به صورت عملی توضیح داد.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2020/01/member-meetup-768x768-1.jpg\" alt=\"\" class=\"wp-image-589\"></figure>\n\n\n\n<p>بعد از تمام شدن ارائه آقای رضایی نوبت به پذیرایی و تبادل نظر شرکت کنندگان رسید .</p>\n\n\n\n<p>بعد از پذیرایی آقای سعید فرد برد ترلو میتاپ را معرفی کرد و از کاربران خواست که برای مشارکت در زمینه بهبود وردپرس فارسی به آن بپیوندند. تمامی دوستان و شرکت‌کننده‌های میتاپ وردپرس می‌توانند در این بورد نظرات و پیشنهادات خود را برای این رویداد ارسال کنند و در برگزاری میتاپ همکاری داشته باشند.</p>\n\n\n\n<p>قسمت دوم میتاپ به صورت بحث و گفتگو بین شرکت‌کننده‌ها در میتاپ با موضوع فارسی سازی وردپرس و مشکلات آن شکل گرفت.</p>\n\n\n\n<p>آقای سخایی از کاربران وردپرس خواست تا در زمینه ترجمه وردپرس، گروه وردپرس را همراهی کنند و به بحث و تبادل نظر بپردازند.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2020/01/all-member-768x768-1.jpg\" alt=\"\" class=\"wp-image-590\"></figure>\n\n\n\n<p>گفت و گو درباره ترجمه وردپرس فارسی ادامه پیدا کرد و کاربران پیشنهادات و نظرات خود را درباره این موضوع به اشتراک گذاشتند. بعد از جمع‌بندی صحبت‌های کاربران توسط سعید فرد میتاپ پنجم به پایان رسید.</p>\n\n\n\n<p>عکس دسته جمعی در پایان میتاپ</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2020/01/5th-meetup-tehran-768x773-1.jpg\" alt=\"\" class=\"wp-image-591\"></figure>\n\n\n\n<p>اگر تمایل به حضور در دوره‌های بعدی میتاپ وردپرس تهران را دارید می‌توانید جهت اطلاع‌رسانی از برگزاری در اکانت‌های شبکه اجتماعی میتاپ در تلگرام و اینستاگرام عضو شوید.</p>\n\n\n\n<p class=\"has-text-align-center\" dir=\"ltr\"><a href=\"https://t.me/irwpmeetup\">https://t.me/irwpmeetup</a></p>\n\n\n\n<p class=\"has-text-align-center\" dir=\"ltr\"><a href=\"https://instagram.com/irwpmeetup\">https://instagram.com/irwpmeetup</a></p>\n\n\n\n<p>این مژده به کسانی که فرصت حضور در میتاپ ها را ندارند داده می‎‌شود که می‌توانند از طریق اکانت ما در اینستاگرام به صورت زنده و یا از طریق بخش <a href=\"https://wpmeetup.ir/category/videos/\">ویدیوهای میتاپ</a>، میتاپ‌های وردپرس قبلی را مشاهده کنند.</p>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:182:\"https://fa.wordpress.org/team/2019/01/03/%d9%be%d9%86%d8%ac%d9%85%db%8c%d9%86-%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%aa%d9%87%d8%b1%d8%a7%d9%86/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"127\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}i:9;a:6:{s:4:\"data\";s:73:\"\n		\n		\n					\n		\n		\n		\n				\n		\n\n					\n										\n					\n					\n			\n		\n		\n			\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";s:5:\"child\";a:6:{s:0:\"\";a:7:{s:5:\"title\";a:1:{i:0;a:5:{s:4:\"data\";s:49:\"چهارمین میتاپ وردپرس تهران\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:183:\"https://fa.wordpress.org/team/2018/12/01/%da%86%d9%87%d8%a7%d8%b1%d9%85%db%8c%d9%86-%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%aa%d9%87%d8%b1%d8%a7%d9%86/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:191:\"https://fa.wordpress.org/team/2018/12/01/%da%86%d9%87%d8%a7%d8%b1%d9%85%db%8c%d9%86-%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%aa%d9%87%d8%b1%d8%a7%d9%86/#respond\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:7:\"pubDate\";a:1:{i:0;a:5:{s:4:\"data\";s:31:\"Sat, 01 Dec 2018 08:20:00 +0000\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:8:\"category\";a:1:{i:0;a:5:{s:4:\"data\";s:16:\"رویدادها\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:4:\"guid\";a:1:{i:0;a:5:{s:4:\"data\";s:36:\"https://fa.wordpress.org/team/?p=131\";s:7:\"attribs\";a:1:{s:0:\"\";a:1:{s:11:\"isPermaLink\";s:5:\"false\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:11:\"description\";a:1:{i:0;a:5:{s:4:\"data\";s:567:\"چهارمین میتاپ وردپرس ۹ آذر ۹۷ ساعت ۱۰ صبح برگزار شد. این میتاپ هم مانند سه میتاپ قبل شاهد حضور علاقه‌مندان وردپرس در هر زمینه‌ای (توسعه دهنده‌، طراح، کاربران وردپرس وحتی دانشجویان) بود. میتاپ با صحبت‌های آغازین آقای سعید‌‌ فرد با تأکید بر اهداف میتاپ که تشکیل جامعه‌ی وردپرسی، مطرح کردن مباحث فنی و عمومی [&#8230;]\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:32:\"http://purl.org/dc/elements/1.1/\";a:1:{s:7:\"creator\";a:1:{i:0;a:5:{s:4:\"data\";s:10:\"Saeed Fard\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:40:\"http://purl.org/rss/1.0/modules/content/\";a:1:{s:7:\"encoded\";a:1:{i:0;a:5:{s:4:\"data\";s:5455:\"<p>چهارمین میتاپ وردپرس ۹ آذر ۹۷ ساعت ۱۰ صبح برگزار شد. این میتاپ هم مانند سه میتاپ قبل شاهد حضور علاقه‌مندان وردپرس در هر زمینه‌ای (توسعه دهنده‌، طراح، کاربران وردپرس وحتی دانشجویان) بود.</p>\n\n\n\n<p>میتاپ با صحبت‌های آغازین آقای سعید‌‌ فرد با تأکید بر اهداف میتاپ که تشکیل جامعه‌ی وردپرسی، مطرح کردن مباحث فنی و عمومی در رابطه با وردپرس، کمک به توسعه و پیشرفت  وردپرس در ایران و اشاره به این که هدف اصلی برگزاری میتاپ‌ها برگزاری وردکمپ در سال آینده برای اولین بار در آسیا است آغاز شد.</p>\n\n\n\n<figure class=\"wp-block-image aligncenter size-large\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2020/01/%D8%B3%D8%B9%DB%8C%D8%AF-%D9%81%D8%B1%D8%AF-768x623-1.jpg\" alt=\"\" class=\"wp-image-579\"></figure>\n\n\n\n<p>بعد از معرفی شرکت کنندگان مثل میتاپ های گذشته نوبت به ارائه دوستان رسید.</p>\n\n\n\n<p>در این میتاپ آقای مهدی سلطانی که به صورت داوطلب و از طریق قراردادن ارائه خود در قسمت ارسال مقاله در  سایت میتاپ وردپرس علاقه خود را برای به اشتراک گذاشتن تجربیات خود با دیگر دوستان اعلام کرده بود  ارائه‌ی خود را در زمینه برنامه نویسی شی‌گرا در وردپرس آغاز کرد.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2020/01/soltani-768x493-1.jpg\" alt=\"\" class=\"wp-image-580\"></figure>\n\n\n\n<p>در این ارائه نکات کلیدی در استفاده از برنامه نویسی شی‌گرا توسط آقای سلطانی گفته شد، نمونه کدهای نوشته شده OOP نشان دادن و توضیحاتی بر روی کدها دادن.</p>\n\n\n\n<p>بعد از تبادل نظر و استراحت دوستان شرکت کننده و پذیرایی توسط مجموعه آتی ارتباط کیش نوبت به ارائه دوم با عنوان وردپرس ارزان برای شروع کسب و کار توسط آقای شاهین کلانتر آغاز شد.</p>\n\n\n\n<p>آقای کلانتر راهکارهایی ارائه کرد که بتوان کسب و کار نوپایی را با کمترین هزینه شروع کرد . در ادامه اضافه کرد که میتوانید بسته به نیاز وب سایت و کسب و کارتان پوسته ای نزدیک به اهدافتان بیابید و مخازن رایگان پوسته های وردپرس را معرفی کرد.</p>\n\n\n\n<p>آقای کلانتر :باجستجو در شبکه های اجتماعی میتوان از خلاقیت های طراحان صفحات وب استفاده کرد. با استفاده از هشتگ‌ها در شبکه‌های اجتماعی مانند اینستاگرام و پینترست.</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2020/01/kalantar-768x512-1.jpg\" alt=\"\" class=\"wp-image-581\"></figure>\n\n\n\n<p>در ادامه به بررسی و معرفی پلاگین‌های رایگان و مهم و پرکاربرد وردپرس پرداخت و در آخر اضافه کرد که ما با رشد و توسعه وب سایت خود رشد می‌کنیم و بزرگ وبزرگتر می‌شویم  و وقتی وب سایت ما به سود دهی رسید برای برنده شدن در فضای رقابتی باید هزینه کنیم، هیچ رقابتی بدون هزینه نیست و از هزینه کردن نترسیم چون در مقابل بازدهی آن هزینه‌ی کمی است.</p>\n\n\n\n<p>بعد از اتمام ارائه آقای کلانتر دوستان به بحث و گفتگو در زمینه بازار کسب و کار وردپرس پرداختن و نظرات جالب و نکات مثبت زیادی در این زمینه گفته شد.</p>\n\n\n\n<figure class=\"wp-block-gallery has-nested-images columns-default is-cropped wp-block-gallery-2 is-layout-flex wp-block-gallery-is-layout-flex\">\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" data-id=\"582\" src=\"https://fa.wordpress.org/files/2020/01/all1-meetup-768x650-1.jpg\" alt=\"\" class=\"wp-image-582\"></figure>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" data-id=\"583\" src=\"https://fa.wordpress.org/files/2020/01/all2-meetup-768x638-1.jpg\" alt=\"\" class=\"wp-image-583\"></figure>\n</figure>\n\n\n\n<p>گروه وردپرس برای دوستان و علاقه مندانی که موفق به حضور در میتاپ‌ها را نشده‌اند با پخش زنده از طریق اینستاگرام و همچنین قراردادن ویدئوی میتاپ در آپارات امکان استفاده از مطالب گفته شده در میتاپ را فراهم می‌کند.</p>\n\n\n\n<p>عکس دست جمعی در پایان رویداد وردپرس</p>\n\n\n\n<figure class=\"wp-block-image size-large\"><img decoding=\"async\" src=\"https://fa.wordpress.org/files/2020/01/irwpmeetup4-768x830-1.jpg\" alt=\"\" class=\"wp-image-584\"></figure>\n\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:36:\"http://wellformedweb.org/CommentAPI/\";a:1:{s:10:\"commentRss\";a:1:{i:0;a:5:{s:4:\"data\";s:188:\"https://fa.wordpress.org/team/2018/12/01/%da%86%d9%87%d8%a7%d8%b1%d9%85%db%8c%d9%86-%d9%85%db%8c%d8%aa%d8%a7%d9%be-%d9%88%d8%b1%d8%af%d9%be%d8%b1%d8%b3-%d8%aa%d9%87%d8%b1%d8%a7%d9%86/feed/\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:38:\"http://purl.org/rss/1.0/modules/slash/\";a:1:{s:8:\"comments\";a:1:{i:0;a:5:{s:4:\"data\";s:1:\"0\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:7:\"post-id\";a:1:{i:0;a:5:{s:4:\"data\";s:3:\"131\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}s:27:\"http://www.w3.org/2005/Atom\";a:1:{s:4:\"link\";a:1:{i:0;a:5:{s:4:\"data\";s:0:\"\";s:7:\"attribs\";a:1:{s:0:\"\";a:3:{s:4:\"href\";s:35:\"https://fa.wordpress.org/team/feed/\";s:3:\"rel\";s:4:\"self\";s:4:\"type\";s:19:\"application/rss+xml\";}}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:44:\"http://purl.org/rss/1.0/modules/syndication/\";a:2:{s:12:\"updatePeriod\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"\n	hourly	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}s:15:\"updateFrequency\";a:1:{i:0;a:5:{s:4:\"data\";s:4:\"\n	1	\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}s:30:\"com-wordpress:feed-additions:1\";a:1:{s:4:\"site\";a:1:{i:0;a:5:{s:4:\"data\";s:9:\"117865853\";s:7:\"attribs\";a:0:{}s:8:\"xml_base\";s:0:\"\";s:17:\"xml_base_explicit\";b:0;s:8:\"xml_lang\";s:0:\"\";}}}}}}}}}}}}s:4:\"type\";i:128;s:7:\"headers\";O:48:\"WpOrg\\Requests\\Utility\\CaseInsensitiveDictionary\":1:{s:7:\"\0*\0data\";a:11:{s:6:\"server\";s:5:\"nginx\";s:4:\"date\";s:29:\"Tue, 10 Jun 2025 15:27:33 GMT\";s:12:\"content-type\";s:34:\"application/rss+xml; charset=UTF-8\";s:4:\"vary\";s:37:\"Accept-Encoding, accept, content-type\";s:6:\"x-olaf\";s:3:\"⛄\";s:13:\"last-modified\";s:29:\"Sat, 15 Feb 2025 19:56:46 GMT\";s:4:\"link\";s:66:\"<https://fa.wordpress.org/team/wp-json/>; rel=\"https://api.w.org/\"\";s:15:\"x-frame-options\";s:10:\"SAMEORIGIN\";s:16:\"content-encoding\";s:4:\"gzip\";s:7:\"alt-svc\";s:19:\"h3=\":443\"; ma=86400\";s:4:\"x-nc\";s:9:\"HIT ord 1\";}}s:5:\"build\";i:1732000660;s:21:\"cache_expiration_time\";i:1749612453;s:23:\"__cache_expiration_time\";i:1749612453;}", "off");
INSERT INTO `wp_options` VALUES("144", "_transient_timeout_feed_mod_813f86eb29c12d6094f1acd1445797e5", "1749612453", "off");
INSERT INTO `wp_options` VALUES("145", "_transient_feed_mod_813f86eb29c12d6094f1acd1445797e5", "1749569253", "off");
INSERT INTO `wp_options` VALUES("148", "theme_mods_twentytwentyfive", "a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1742090812;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wp_options` VALUES("149", "current_theme", "Woodmart", "auto");
INSERT INTO `wp_options` VALUES("150", "theme_mods_woodmart", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:9:\"main-menu\";i:18;}s:18:\"custom_css_post_id\";i:24;}", "on");
INSERT INTO `wp_options` VALUES("151", "theme_switched", "", "auto");
INSERT INTO `wp_options` VALUES("156", "xts-woodmart-options", "a:799:{s:12:\"last_message\";s:4:\"save\";s:14:\"default_header\";s:13:\"header_817364\";s:14:\"sticky_toolbar\";s:1:\"1\";s:20:\"sticky_toolbar_label\";s:1:\"1\";s:21:\"sticky_toolbar_fields\";a:5:{i:0;s:4:\"shop\";i:1;s:7:\"sidebar\";i:2;s:8:\"wishlist\";i:3;s:4:\"cart\";i:4;s:7:\"account\";}s:10:\"link_1_url\";s:0:\"\";s:11:\"link_1_text\";s:0:\"\";s:11:\"link_1_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_2_url\";s:0:\"\";s:11:\"link_2_text\";s:0:\"\";s:11:\"link_2_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_3_url\";s:0:\"\";s:11:\"link_3_text\";s:0:\"\";s:11:\"link_3_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_4_url\";s:0:\"\";s:11:\"link_4_text\";s:0:\"\";s:11:\"link_4_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_5_url\";s:0:\"\";s:11:\"link_5_text\";s:0:\"\";s:11:\"link_5_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"age_verify\";s:1:\"0\";s:15:\"age_verify_text\";s:157:\"<h4 class=\"text-center\">Are you over 18?</h4>\r\n<p class=\"text-center\">You must be 18 years of age or older to view page. Please verify your age to enter.</p>\";s:21:\"age_verify_text_error\";s:120:\"<h4 class=\"text-center\">Access forbidden</h4>\r\n<p class=\"text-center\">Your access is restricted because of your age.</p>\";s:21:\"age_verify_background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:23:\"age_verify_color_scheme\";s:4:\"dark\";s:16:\"age_verify_width\";s:3:\"500\";s:11:\"promo_popup\";s:1:\"0\";s:24:\"promo_popup_content_type\";s:10:\"html_block\";s:10:\"popup_text\";s:0:\"\";s:16:\"popup_html_block\";s:0:\"\";s:12:\"popup_scroll\";s:4:\"1000\";s:16:\"popup-background\";a:7:{s:5:\"color\";s:7:\"#111111\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:7:\"contain\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:11:\"left center\";}s:18:\"popup_color_scheme\";s:4:\"dark\";s:11:\"popup_width\";s:3:\"800\";s:13:\"popup_padding\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:23:\"promo_popup_hide_mobile\";s:1:\"1\";s:11:\"popup_event\";s:4:\"time\";s:13:\"promo_timeout\";s:4:\"2000\";s:11:\"popup_pages\";s:1:\"0\";s:13:\"promo_version\";s:1:\"1\";s:12:\"cookies_info\";s:1:\"0\";s:12:\"cookies_text\";s:224:\"ما از کوکی ها برای بهبود کارکردن شما با سایت استفاده می کنیم. با استفاده از این سایت شما استفاده ما از کوکی ها را پذیرفته اید.\";s:19:\"cookies_policy_page\";s:0:\"\";s:15:\"cookies_version\";s:1:\"1\";s:13:\"header_banner\";s:1:\"0\";s:18:\"header_banner_link\";s:0:\"\";s:26:\"header_banner_content_type\";s:4:\"text\";s:24:\"header_banner_html_block\";s:0:\"\";s:23:\"header_banner_shortcode\";s:0:\"\";s:16:\"header_banner_bg\";a:7:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:3:\"url\";s:76:\"https://demoes.aramis-co.ir/spare/wp-content/uploads/2025/03/Frame-233-1.png\";s:2:\"id\";s:3:\"392\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:7:\"contain\";s:10:\"attachment\";s:7:\"inherit\";s:8:\"position\";s:13:\"center bottom\";}s:19:\"header_banner_color\";s:5:\"light\";s:20:\"header_banner_height\";s:2:\"40\";s:27:\"header_banner_mobile_height\";s:2:\"40\";s:16:\"header_close_btn\";s:1:\"1\";s:21:\"header_banner_version\";s:1:\"1\";s:21:\"enqueue_posts_results\";s:1:\"0\";s:27:\"search_posts_results_column\";s:1:\"2\";s:13:\"search_by_sku\";s:1:\"1\";s:17:\"relevanssi_search\";s:1:\"0\";s:16:\"popular_requests\";s:0:\"\";s:24:\"full_search_content_type\";s:7:\"content\";s:24:\"full_search_content_text\";s:0:\"\";s:30:\"full_search_content_html_block\";s:0:\"\";s:23:\"ajax_fullscreen_content\";s:1:\"1\";s:10:\"site_width\";s:10:\"full-width\";s:17:\"site_custom_width\";s:4:\"1222\";s:11:\"main_layout\";s:13:\"sidebar-right\";s:13:\"sidebar_width\";s:1:\"3\";s:17:\"hide_main_sidebar\";s:1:\"0\";s:24:\"hide_main_sidebar_tablet\";s:1:\"1\";s:24:\"hide_main_sidebar_mobile\";s:1:\"1\";s:11:\"insta_token\";s:0:\"\";s:28:\"insta_delete_outdated_images\";s:1:\"0\";s:18:\"google_map_api_key\";s:0:\"\";s:9:\"fb_app_id\";s:0:\"\";s:13:\"fb_app_secret\";s:0:\"\";s:9:\"fb_notice\";s:0:\"\";s:10:\"goo_app_id\";s:0:\"\";s:14:\"goo_app_secret\";s:0:\"\";s:10:\"goo_notice\";s:0:\"\";s:9:\"vk_app_id\";s:0:\"\";s:13:\"vk_app_secret\";s:0:\"\";s:9:\"vk_notice\";s:0:\"\";s:15:\"alt_auth_method\";s:1:\"0\";s:9:\"ajax_shop\";s:1:\"1\";s:11:\"ajax_scroll\";s:1:\"1\";s:21:\"shop_page_breadcrumbs\";s:1:\"1\";s:17:\"cat_desc_position\";s:6:\"before\";s:14:\"products_hover\";s:4:\"base\";s:23:\"base_hover_mobile_click\";s:1:\"0\";s:21:\"products_color_scheme\";s:7:\"default\";s:22:\"products_bordered_grid\";s:1:\"0\";s:28:\"products_bordered_grid_style\";s:7:\"outside\";s:24:\"products_with_background\";s:1:\"1\";s:19:\"products_background\";a:1:{s:4:\"idle\";s:16:\"rgb(255,255,255)\";}s:15:\"products_shadow\";s:1:\"1\";s:23:\"stretch_product_desktop\";s:1:\"1\";s:22:\"stretch_product_tablet\";s:1:\"1\";s:22:\"stretch_product_mobile\";s:1:\"1\";s:25:\"product_title_lines_limit\";s:3:\"one\";s:22:\"show_empty_star_rating\";s:1:\"0\";s:11:\"hover_image\";s:1:\"1\";s:12:\"grid_gallery\";s:1:\"0\";s:20:\"grid_gallery_control\";s:5:\"hover\";s:26:\"grid_gallery_enable_arrows\";s:4:\"none\";s:16:\"product_quantity\";s:1:\"0\";s:18:\"base_hover_content\";s:7:\"excerpt\";s:21:\"stock_status_position\";s:9:\"thumbnail\";s:27:\"show_stock_quantity_on_grid\";s:1:\"0\";s:23:\"grid_stock_progress_bar\";s:1:\"0\";s:14:\"shop_countdown\";s:1:\"0\";s:22:\"categories_under_title\";s:1:\"1\";s:18:\"brands_under_title\";s:1:\"0\";s:15:\"sku_under_title\";s:1:\"0\";s:18:\"show_reviews_count\";s:1:\"0\";s:17:\"categories_design\";s:7:\"default\";s:19:\"categories_rounding\";s:0:\"\";s:31:\"custom_categories_rounding_size\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:23:\"categories_color_scheme\";s:7:\"default\";s:22:\"categories_with_shadow\";s:6:\"enable\";s:29:\"hide_categories_subcategories\";s:1:\"0\";s:29:\"hide_categories_product_count\";s:1:\"0\";s:11:\"shop_layout\";s:12:\"sidebar-left\";s:18:\"shop_sidebar_width\";s:1:\"3\";s:25:\"shop_hide_sidebar_desktop\";s:1:\"0\";s:24:\"shop_hide_sidebar_tablet\";s:1:\"1\";s:17:\"shop_hide_sidebar\";s:1:\"1\";s:20:\"sticky_filter_button\";s:1:\"0\";s:10:\"shop_title\";s:1:\"1\";s:15:\"shop_categories\";s:1:\"1\";s:25:\"shop_categories_ancestors\";s:1:\"0\";s:25:\"show_categories_neighbors\";s:1:\"0\";s:19:\"shop_products_count\";s:1:\"1\";s:37:\"shop_page_title_hide_empty_categories\";s:1:\"0\";s:34:\"shop_page_title_categories_exclude\";s:0:\"\";s:24:\"mobile_categories_layout\";s:9:\"accordion\";s:29:\"mobile_categories_menu_layout\";s:8:\"dropdown\";s:37:\"mobile_categories_drilldown_animation\";s:5:\"slide\";s:40:\"mobile_categories_submenu_opening_action\";s:10:\"only_arrow\";s:26:\"mobile_categories_position\";s:4:\"left\";s:30:\"mobile_categories_color_scheme\";s:7:\"default\";s:27:\"mobile_categories_close_btn\";s:1:\"0\";s:9:\"shop_view\";s:4:\"grid\";s:16:\"products_columns\";s:1:\"3\";s:23:\"products_columns_tablet\";s:4:\"auto\";s:23:\"products_columns_mobile\";s:1:\"2\";s:16:\"products_spacing\";s:2:\"20\";s:23:\"products_spacing_tablet\";s:0:\"\";s:23:\"products_spacing_mobile\";s:0:\"\";s:24:\"per_row_columns_selector\";s:1:\"1\";s:27:\"products_columns_variations\";a:3:{i:0;s:1:\"2\";i:1;s:1:\"3\";i:2;s:1:\"4\";}s:16:\"products_masonry\";s:1:\"0\";s:24:\"products_different_sizes\";s:1:\"0\";s:13:\"shop_per_page\";s:2:\"12\";s:14:\"per_page_links\";s:1:\"1\";s:16:\"per_page_options\";s:10:\"9,12,18,24\";s:15:\"shop_pagination\";s:10:\"pagination\";s:25:\"load_more_button_page_url\";s:1:\"1\";s:17:\"categories_toggle\";s:1:\"1\";s:14:\"widgets_scroll\";s:1:\"1\";s:14:\"widget_heights\";s:3:\"223\";s:21:\"shop_widgets_collapse\";s:7:\"disable\";s:12:\"shop_filters\";s:1:\"0\";s:17:\"shop_filters_type\";s:7:\"widgets\";s:20:\"shop_filters_columns\";s:0:\"\";s:27:\"shop_filters_columns_tablet\";s:4:\"auto\";s:27:\"shop_filters_columns_mobile\";s:4:\"auto\";s:20:\"shop_filters_spacing\";s:2:\"30\";s:27:\"shop_filters_spacing_tablet\";s:0:\"\";s:27:\"shop_filters_spacing_mobile\";s:0:\"\";s:12:\"hide_sort_by\";s:1:\"0\";s:17:\"hide_price_filter\";s:1:\"0\";s:20:\"shop_filters_content\";s:0:\"\";s:24:\"shop_filters_always_open\";s:1:\"0\";s:18:\"shop_filters_close\";s:1:\"0\";s:17:\"page-title-design\";s:8:\"centered\";s:15:\"page-title-size\";s:7:\"default\";s:16:\"title-background\";a:7:{s:5:\"color\";s:7:\"#0a0a0a\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:5:\"cover\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:13:\"center center\";}s:16:\"page-title-color\";s:5:\"light\";s:14:\"page_title_tag\";s:7:\"default\";s:11:\"breadcrumbs\";s:1:\"1\";s:22:\"yoast_shop_breadcrumbs\";s:1:\"0\";s:23:\"yoast_pages_breadcrumbs\";s:1:\"0\";s:14:\"disable_footer\";s:1:\"1\";s:19:\"footer_content_type\";s:10:\"html_block\";s:13:\"footer-layout\";s:2:\"13\";s:17:\"footer_html_block\";s:3:\"339\";s:13:\"footer-bar-bg\";a:7:{s:5:\"color\";s:7:\"#ffffff\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:12:\"footer-style\";s:0:\"\";s:13:\"sticky_footer\";s:1:\"0\";s:23:\"collapse_footer_widgets\";s:1:\"1\";s:14:\"scroll_top_btn\";s:1:\"1\";s:18:\"disable_copyrights\";s:1:\"0\";s:17:\"copyrights-layout\";s:11:\"two-columns\";s:10:\"copyrights\";s:243:\"Based on <a href=\"http://woodmart.xtemos.com\"><strong>WoodMart</strong></a> theme<i class=\"fa fa-copyright\"></i> 2025 <a href=\"https://themeforest.net/item/woodmart-woocommerce-wordpress-theme/20264492\"><strong>WooCommerce Themes</strong></a>.\";s:11:\"copyrights2\";s:107:\"<img src=\"https://demoes.aramis-co.ir/spare/wp-content/themes/woodmart/images/payments.png\" alt=\"payments\">\";s:22:\"prefooter_content_type\";s:4:\"text\";s:14:\"prefooter_area\";s:0:\"\";s:20:\"prefooter_html_block\";s:0:\"\";s:9:\"text-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:5:\"peyda\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:9:\"font-size\";s:2:\"14\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:7:\"#767676\";}}s:12:\"primary-font\";a:1:{i:0;a:7:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"600\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#242424\";}}s:16:\"post-titles-font\";a:1:{i:0;a:8:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#333333\";s:5:\"hover\";a:1:{s:5:\"color\";s:19:\"rgb(51 51 51 / 65%)\";}}}s:14:\"secondary-font\";a:1:{i:0;a:5:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";}}s:18:\"widget-titles-font\";a:1:{i:0;a:10:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"600\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"16\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:4:\"#333\";}}s:15:\"navigation-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"700\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"13\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}}}s:17:\"typography_notice\";s:0:\"\";s:19:\"advanced_typography\";a:2:{i:0;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}}s:26:\"advanced_typography_notice\";s:0:\"\";s:25:\"multi_custom_fonts_notice\";s:0:\"\";s:18:\"multi_custom_fonts\";a:2:{i:0;a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}s:9:\"{{index}}\";a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}}s:9:\"icon_font\";a:2:{s:4:\"font\";s:1:\"2\";s:6:\"weight\";s:3:\"400\";}s:14:\"typekit_notice\";s:0:\"\";s:10:\"typekit_id\";s:0:\"\";s:13:\"typekit_fonts\";s:0:\"\";s:13:\"rounding_size\";s:4:\"none\";s:20:\"custom_rounding_size\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:12:\"dark_version\";s:1:\"0\";s:13:\"primary-color\";a:1:{s:4:\"idle\";s:14:\"rgb(254,56,56)\";}s:15:\"secondary-color\";a:1:{s:4:\"idle\";s:13:\"rgb(55,55,55)\";}s:10:\"link-color\";a:2:{s:4:\"idle\";s:7:\"#333333\";s:5:\"hover\";s:13:\"rgb(79,79,79)\";}s:25:\"android_browser_bar_color\";a:1:{s:4:\"idle\";s:13:\"rgb(55,55,55)\";}s:15:\"body-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:16:\"pages-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"shop-background\";a:7:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"product-background\";a:7:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"blog-background\";a:7:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"blog-post-background\";a:7:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"portfolio-background\";a:7:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:28:\"portfolio-project-background\";a:7:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"btns_default_style\";s:7:\"rounded\";s:23:\"btns_default_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";}}s:15:\"btns_default_bg\";a:1:{s:4:\"idle\";s:14:\"rgb(254,56,56)\";}s:21:\"btns_default_bg_hover\";a:1:{s:4:\"idle\";s:14:\"rgb(209,46,46)\";}s:25:\"btns_default_color_scheme\";s:4:\"dark\";s:31:\"btns_default_color_scheme_hover\";s:4:\"dark\";s:32:\"btns_default_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"btns_default_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"btns_shop_style\";s:7:\"rounded\";s:20:\"btns_shop_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";}}s:12:\"btns_shop_bg\";a:1:{s:4:\"idle\";s:14:\"rgb(254,56,56)\";}s:18:\"btns_shop_bg_hover\";a:1:{s:4:\"idle\";s:14:\"rgb(209,46,46)\";}s:22:\"btns_shop_color_scheme\";s:5:\"light\";s:28:\"btns_shop_color_scheme_hover\";s:5:\"light\";s:29:\"btns_shop_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:35:\"btns_shop_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"advanced_typography_button\";a:2:{i:0;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}}s:17:\"form_fields_style\";s:6:\"square\";s:17:\"form_border_width\";s:1:\"2\";s:10:\"form_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"form_placeholder_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:14:\"form_brd_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"form_brd_color_focus\";a:1:{s:4:\"idle\";s:0:\"\";}s:7:\"form_bg\";a:1:{s:4:\"idle\";s:0:\"\";}s:23:\"success_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#459647\";}s:25:\"success_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:23:\"warning_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#E0B252\";}s:25:\"warning_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:24:\"carousel_arrows_position\";s:3:\"sep\";s:25:\"carousel_arrows_icon_type\";s:1:\"1\";s:27:\"carousel_arrows_hover_style\";s:1:\"1\";s:24:\"carousel_arrows_sep_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:29:\"carousel_arrows_sep_icon_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:28:\"carousel_arrows_sep_offset_h\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:28:\"carousel_arrows_sep_offset_v\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:25:\"carousel_arrows_sep_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:31:\"carousel_arrows_sep_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:29:\"carousel_arrows_sep_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:28:\"carousel_arrows_sep_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:34:\"carousel_arrows_sep_bg_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:32:\"carousel_arrows_sep_bg_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:33:\"carousel_arrows_sep_border_radius\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:32:\"carousel_arrows_sep_border_style\";s:0:\"\";s:32:\"carousel_arrows_sep_border_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:32:\"carousel_arrows_sep_border_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"carousel_arrows_sep_border_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:36:\"carousel_arrows_sep_border_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:36:\"carousel_arrows_sep_box_shadow_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:39:\"carousel_arrows_sep_box_shadow_offset_x\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:39:\"carousel_arrows_sep_box_shadow_offset_y\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:35:\"carousel_arrows_sep_box_shadow_blur\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:37:\"carousel_arrows_sep_box_shadow_spread\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:28:\"carousel_arrows_together_gap\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:29:\"carousel_arrows_together_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:34:\"carousel_arrows_together_icon_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:33:\"carousel_arrows_together_offset_h\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:33:\"carousel_arrows_together_offset_v\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:30:\"carousel_arrows_together_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:36:\"carousel_arrows_together_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:34:\"carousel_arrows_together_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:33:\"carousel_arrows_together_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:39:\"carousel_arrows_together_bg_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:37:\"carousel_arrows_together_bg_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"carousel_arrows_together_border_radius\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:37:\"carousel_arrows_together_border_style\";s:0:\"\";s:37:\"carousel_arrows_together_border_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:37:\"carousel_arrows_together_border_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:43:\"carousel_arrows_together_border_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:41:\"carousel_arrows_together_border_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:41:\"carousel_arrows_together_box_shadow_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:44:\"carousel_arrows_together_box_shadow_offset_x\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:44:\"carousel_arrows_together_box_shadow_offset_y\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:40:\"carousel_arrows_together_box_shadow_blur\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:42:\"carousel_arrows_together_box_shadow_spread\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:19:\"carousel_pagin_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:23:\"carousel_pagin_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:29:\"carousel_pagin_bg_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:30:\"carousel_pagin_bg_color_active\";a:1:{s:4:\"idle\";s:0:\"\";}s:28:\"carousel_pagin_border_radius\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:27:\"carousel_pagin_border_style\";s:0:\"\";s:27:\"carousel_pagin_border_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:27:\"carousel_pagin_border_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:33:\"carousel_pagin_border_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:34:\"carousel_pagin_border_color_active\";a:1:{s:4:\"idle\";s:0:\"\";}s:25:\"carousel_scrollbar_height\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:24:\"carousel_scrollbar_width\";s:152:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoiJSJ9LCJ0YWJsZXQiOnsidmFsdWUiOiIiLCJ1bml0IjoiJSJ9LCJtb2JpbGUiOnsidmFsdWUiOiIiLCJ1bml0IjoiJSJ9fX0=\";s:27:\"carousel_scrollbar_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:32:\"carousel_scrollbar_drag_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"carousel_scrollbar_drag_bg_hover_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:11:\"blog_layout\";s:13:\"sidebar-right\";s:18:\"blog_sidebar_width\";s:1:\"3\";s:17:\"blog_hide_sidebar\";s:1:\"0\";s:24:\"blog_hide_sidebar_tablet\";s:1:\"1\";s:24:\"blog_hide_sidebar_mobile\";s:1:\"1\";s:29:\"single_post_justified_gallery\";s:1:\"0\";s:11:\"blog_design\";s:7:\"masonry\";s:10:\"blog_style\";s:6:\"shadow\";s:16:\"blog_with_shadow\";s:1:\"1\";s:12:\"blog_columns\";s:1:\"3\";s:19:\"blog_columns_tablet\";s:4:\"auto\";s:19:\"blog_columns_mobile\";s:4:\"auto\";s:12:\"blog_spacing\";s:2:\"20\";s:19:\"blog_spacing_tablet\";s:0:\"\";s:19:\"blog_spacing_mobile\";s:0:\"\";s:15:\"blog_pagination\";s:10:\"pagination\";s:12:\"blog_excerpt\";s:7:\"excerpt\";s:21:\"blog_words_or_letters\";s:6:\"letter\";s:19:\"blog_excerpt_length\";s:3:\"135\";s:11:\"parts_title\";s:1:\"1\";s:10:\"parts_meta\";s:1:\"1\";s:10:\"parts_text\";s:1:\"1\";s:9:\"parts_btn\";s:1:\"1\";s:20:\"parts_published_date\";s:1:\"1\";s:18:\"single_post_design\";s:7:\"default\";s:18:\"single_post_header\";s:4:\"none\";s:10:\"blog_share\";s:1:\"1\";s:15:\"blog_navigation\";s:1:\"1\";s:15:\"blog_author_bio\";s:1:\"1\";s:18:\"blog_related_posts\";s:1:\"1\";s:19:\"blog_published_date\";s:1:\"1\";s:9:\"portfolio\";s:1:\"1\";s:14:\"portfolio_page\";s:0:\"\";s:19:\"portfolio_item_slug\";s:0:\"\";s:18:\"portfolio_cat_slug\";s:0:\"\";s:20:\"portfolio_full_width\";s:1:\"0\";s:16:\"projects_columns\";s:1:\"3\";s:23:\"projects_columns_tablet\";s:4:\"auto\";s:23:\"projects_columns_mobile\";s:4:\"auto\";s:17:\"portfolio_spacing\";s:1:\"0\";s:24:\"portfolio_spacing_tablet\";s:0:\"\";s:24:\"portfolio_spacing_mobile\";s:0:\"\";s:18:\"portoflio_per_page\";s:1:\"6\";s:20:\"portfolio_pagination\";s:9:\"load_more\";s:17:\"portoflio_orderby\";s:4:\"date\";s:15:\"portoflio_order\";s:4:\"DESC\";s:15:\"portoflio_style\";s:5:\"hover\";s:20:\"portoflio_image_size\";s:5:\"large\";s:17:\"portoflio_filters\";s:1:\"1\";s:22:\"portfolio_filters_type\";s:5:\"links\";s:14:\"ajax_portfolio\";s:1:\"1\";s:23:\"single_portfolio_header\";s:4:\"none\";s:36:\"single_portfolio_title_in_page_title\";s:1:\"0\";s:20:\"portfolio_navigation\";s:1:\"1\";s:17:\"portfolio_related\";s:1:\"1\";s:18:\"add_to_cart_action\";s:6:\"widget\";s:26:\"add_to_cart_action_timeout\";s:1:\"0\";s:33:\"add_to_cart_action_timeout_number\";s:1:\"3\";s:18:\"mini_cart_quantity\";s:1:\"0\";s:21:\"show_sku_in_mini_cart\";s:1:\"0\";s:16:\"show_sku_in_cart\";s:1:\"0\";s:25:\"show_sku_in_checkout_page\";s:1:\"0\";s:26:\"show_sku_in_thank_you_page\";s:1:\"0\";s:23:\"show_sku_in_email_order\";s:1:\"0\";s:16:\"show_sku_on_ajax\";s:1:\"0\";s:12:\"catalog_mode\";s:1:\"0\";s:11:\"size_guides\";s:1:\"1\";s:12:\"login_prices\";s:1:\"0\";s:19:\"quick_shop_variable\";s:1:\"1\";s:24:\"quick_shop_variable_type\";s:14:\"select_options\";s:23:\"quick_shop_clear_action\";s:4:\"none\";s:23:\"grid_swatches_attribute\";s:0:\"\";s:14:\"swatches_limit\";s:1:\"0\";s:20:\"swatches_limit_count\";s:1:\"5\";s:29:\"single_product_swatches_limit\";s:1:\"0\";s:35:\"single_product_swatches_limit_count\";s:2:\"10\";s:29:\"swatches_use_variation_images\";s:1:\"0\";s:20:\"swatches_labels_name\";s:1:\"0\";s:27:\"swatches_scroll_top_desktop\";s:1:\"0\";s:26:\"swatches_scroll_top_mobile\";s:1:\"0\";s:17:\"variation_gallery\";s:1:\"1\";s:32:\"variation_gallery_storage_method\";s:3:\"old\";s:24:\"ajax_variation_threshold\";s:2:\"30\";s:29:\"show_filtered_variation_image\";s:1:\"0\";s:17:\"hide_larger_price\";s:1:\"0\";s:31:\"single_product_variations_price\";s:1:\"0\";s:11:\"label_shape\";s:7:\"rounded\";s:16:\"percentage_label\";s:1:\"1\";s:19:\"sale_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:21:\"sale_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"new_label\";s:1:\"1\";s:27:\"new_label_days_after_create\";s:1:\"0\";s:18:\"new_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"new_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"hot_label\";s:1:\"1\";s:18:\"hot_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"hot_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"stock_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"stock_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:24:\"attribute_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"attribute_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:16:\"brands_attribute\";s:0:\"\";s:18:\"product_page_brand\";s:1:\"1\";s:22:\"product_brand_location\";s:11:\"about_title\";s:9:\"brand_tab\";s:1:\"1\";s:14:\"brand_tab_name\";s:1:\"0\";s:10:\"quick_view\";s:1:\"1\";s:17:\"quick_view_layout\";s:10:\"horizontal\";s:15:\"quickview_width\";s:3:\"920\";s:19:\"quick_view_variable\";s:1:\"1\";s:7:\"compare\";s:1:\"1\";s:12:\"compare_page\";s:3:\"385\";s:14:\"fields_compare\";a:3:{i:0;s:11:\"description\";i:1;s:3:\"sku\";i:2;s:12:\"availability\";}s:18:\"empty_compare_text\";s:146:\"No products added in the compare list. You must add some products to compare them. You will find a lot of interesting products on our \"Shop\" page.\";s:15:\"compare_on_grid\";s:1:\"1\";s:25:\"compare_save_button_state\";s:1:\"0\";s:19:\"compare_by_category\";s:1:\"0\";s:22:\"show_more_products_btn\";s:1:\"1\";s:18:\"cart_totals_layout\";s:8:\"layout-1\";s:27:\"update_cart_quantity_change\";s:1:\"0\";s:15:\"empty_cart_text\";s:140:\"Before proceed to checkout you must add some products to your shopping cart. You will find a lot of interesting products on our \"Shop\" page.\";s:27:\"thank_you_page_content_type\";s:4:\"text\";s:28:\"thank_you_page_extra_content\";s:0:\"\";s:25:\"thank_you_page_html_block\";s:0:\"\";s:30:\"thank_you_page_default_content\";s:1:\"1\";s:21:\"single_product_layout\";s:10:\"full-width\";s:19:\"full_height_sidebar\";s:1:\"0\";s:20:\"single_sidebar_width\";s:1:\"3\";s:27:\"single_product_hide_sidebar\";s:1:\"0\";s:34:\"single_product_hide_sidebar_tablet\";s:1:\"1\";s:34:\"single_product_hide_sidebar_mobile\";s:1:\"1\";s:20:\"single_product_style\";s:1:\"2\";s:14:\"product_design\";s:7:\"default\";s:14:\"product_sticky\";s:1:\"0\";s:22:\"product_summary_shadow\";s:1:\"0\";s:17:\"single_full_width\";s:1:\"0\";s:21:\"single_product_header\";s:4:\"none\";s:32:\"single_product_builder_post_data\";s:0:\"\";s:12:\"image_action\";s:4:\"zoom\";s:15:\"photoswipe_icon\";s:1:\"1\";s:26:\"product_slider_auto_height\";s:1:\"0\";s:23:\"pagination_main_gallery\";s:1:\"0\";s:23:\"product_images_captions\";s:1:\"0\";s:14:\"thums_position\";s:4:\"left\";s:31:\"single_product_grid_columns_gap\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:34:\"single_product_grid_column_desktop\";s:0:\"\";s:33:\"single_product_grid_column_tablet\";s:0:\"\";s:33:\"single_product_grid_column_mobile\";s:0:\"\";s:37:\"single_product_gallery_column_desktop\";s:1:\"1\";s:36:\"single_product_gallery_column_tablet\";s:0:\"\";s:36:\"single_product_gallery_column_mobile\";s:0:\"\";s:40:\"single_product_thumbnails_vertical_items\";s:1:\"3\";s:39:\"single_product_thumbnails_items_desktop\";s:1:\"4\";s:38:\"single_product_thumbnails_items_tablet\";s:1:\"4\";s:38:\"single_product_thumbnails_items_mobile\";s:1:\"3\";s:22:\"main_gallery_on_tablet\";s:1:\"1\";s:22:\"main_gallery_on_mobile\";s:1:\"1\";s:24:\"main_gallery_center_mode\";s:1:\"0\";s:48:\"single_product_thumbnails_wrap_in_mobile_devices\";s:1:\"1\";s:39:\"single_product_thumbnails_gallery_width\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:40:\"single_product_thumbnails_gallery_height\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:45:\"single_product_thumbnails_gallery_image_width\";s:3:\"150\";s:23:\"single_ajax_add_to_cart\";s:1:\"1\";s:25:\"single_sticky_add_to_cart\";s:1:\"0\";s:32:\"mobile_single_sticky_add_to_cart\";s:1:\"0\";s:33:\"sticky_add_to_cart_height_desktop\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_tablet\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_mobile\";s:2:\"42\";s:31:\"before_add_to_cart_content_type\";s:4:\"text\";s:26:\"content_before_add_to_cart\";s:0:\"\";s:29:\"before_add_to_cart_html_block\";s:0:\"\";s:30:\"after_add_to_cart_content_type\";s:4:\"text\";s:25:\"content_after_add_to_cart\";s:0:\"\";s:28:\"after_add_to_cart_html_block\";s:0:\"\";s:27:\"single_breadcrumbs_position\";s:7:\"default\";s:24:\"product_page_breadcrumbs\";s:1:\"1\";s:12:\"products_nav\";s:1:\"1\";s:25:\"product_short_description\";s:1:\"1\";s:21:\"attr_after_short_desc\";s:1:\"0\";s:19:\"stock_status_design\";s:7:\"default\";s:25:\"single_stock_progress_bar\";s:1:\"0\";s:17:\"product_countdown\";s:1:\"0\";s:23:\"sale_countdown_variable\";s:1:\"0\";s:17:\"product_show_meta\";s:11:\"add_to_cart\";s:18:\"show_product_brand\";s:1:\"0\";s:13:\"product_share\";s:1:\"1\";s:18:\"product_share_type\";s:5:\"share\";s:16:\"related_products\";s:1:\"1\";s:16:\"upsells_position\";s:8:\"standard\";s:20:\"related_product_view\";s:6:\"slider\";s:23:\"related_product_columns\";s:1:\"4\";s:30:\"related_product_columns_tablet\";s:4:\"auto\";s:30:\"related_product_columns_mobile\";s:4:\"auto\";s:21:\"related_product_count\";s:1:\"8\";s:19:\"product_tabs_layout\";s:4:\"tabs\";s:21:\"product_tabs_location\";s:8:\"standard\";s:23:\"product_accordion_state\";s:5:\"first\";s:16:\"hide_tabs_titles\";s:1:\"1\";s:20:\"additional_tab_title\";s:19:\"Shipping & Delivery\";s:27:\"additional_tab_content_type\";s:4:\"text\";s:19:\"additional_tab_text\";s:0:\"\";s:25:\"additional_tab_html_block\";s:0:\"\";s:22:\"additional_tab_2_title\";s:0:\"\";s:29:\"additional_tab_2_content_type\";s:4:\"text\";s:21:\"additional_tab_2_text\";s:0:\"\";s:27:\"additional_tab_2_html_block\";s:0:\"\";s:22:\"additional_tab_3_title\";s:0:\"\";s:29:\"additional_tab_3_content_type\";s:4:\"text\";s:21:\"additional_tab_3_text\";s:0:\"\";s:27:\"additional_tab_3_html_block\";s:0:\"\";s:10:\"login_tabs\";s:1:\"1\";s:9:\"reg_title\";s:8:\"Register\";s:8:\"reg_text\";s:258:\"Registering for this site allows you to access your order status and history. Just fill in the fields below, and we\'ll get a new account set up for you in no time. We will only ask you for information necessary to make the purchase process faster and easier.\";s:11:\"login_title\";s:5:\"Login\";s:10:\"login_text\";s:0:\"\";s:16:\"my_account_links\";s:1:\"1\";s:10:\"custom_css\";s:1029:\".light {\r\n  animation: blinker 1.5s linear infinite;\r\n}\r\n\r\n@keyframes blinker {\r\n  50% {\r\n    opacity: 0;\r\n  }\r\n}\r\n.whb-column.whb-col-left.whb-column8.whb-visible-lg{\r\n	background-color:rgba(255, 255, 255, 0.09);\r\nborder-radius:200px;\r\nmargin-left:20px;\r\n	padding-right:20px;\r\n}\r\n.whb-column.whb-col-right.whb-column10.whb-visible-lg{\r\n	background-color:rgba(255, 255, 255, 0.09);\r\nborder-radius:200px;\r\nmargin-right:20px;\r\n	padding-left:20px;\r\n}\r\n.rotimg {\r\n    \r\n    -webkit-animation:spin 4s linear infinite;\r\n    -moz-animation:spin 4s linear infinite;\r\n    animation:spin 4s linear infinite;\r\n}\r\n@-moz-keyframes spin { \r\n    100% { -moz-transform: rotate(360deg); } \r\n}\r\n@-webkit-keyframes spin { \r\n    100% { -webkit-transform: rotate(360deg); } \r\n}\r\n@keyframes spin { \r\n    100% { \r\n        -webkit-transform: rotate(360deg); \r\n        transform:rotate(360deg); \r\n    } \r\n}\r\n.prolist img{\r\n	width:60px\r\n}\r\n@media only screen and (max-width: 768px)\r\n{\r\n\r\n\r\n.whb-main-header{\r\nbackground-color:rgba(255, 255, 255, 0.09);\r\n}\";s:11:\"css_desktop\";s:0:\"\";s:10:\"css_tablet\";s:0:\"\";s:15:\"css_wide_mobile\";s:0:\"\";s:10:\"css_mobile\";s:0:\"\";s:11:\"css_backend\";s:0:\"\";s:9:\"custom_js\";s:0:\"\";s:8:\"js_ready\";s:0:\"\";s:13:\"sticky_social\";s:1:\"0\";s:18:\"sticky_social_type\";s:6:\"follow\";s:22:\"sticky_social_position\";s:5:\"right\";s:20:\"social_follow_notice\";s:0:\"\";s:7:\"fb_link\";s:1:\"#\";s:12:\"twitter_link\";s:1:\"#\";s:12:\"bluesky_link\";s:0:\"\";s:14:\"isntagram_link\";s:1:\"#\";s:12:\"threads_link\";s:0:\"\";s:14:\"pinterest_link\";s:1:\"#\";s:12:\"youtube_link\";s:1:\"#\";s:11:\"tumblr_link\";s:0:\"\";s:13:\"linkedin_link\";s:0:\"\";s:10:\"vimeo_link\";s:0:\"\";s:11:\"flickr_link\";s:0:\"\";s:11:\"github_link\";s:0:\"\";s:13:\"dribbble_link\";s:0:\"\";s:12:\"behance_link\";s:0:\"\";s:15:\"soundcloud_link\";s:0:\"\";s:12:\"spotify_link\";s:0:\"\";s:10:\"skype_link\";s:0:\"\";s:13:\"whatsapp_link\";s:0:\"\";s:13:\"snapchat_link\";s:0:\"\";s:7:\"tg_link\";s:0:\"\";s:10:\"viber_link\";s:0:\"\";s:11:\"tiktok_link\";s:0:\"\";s:12:\"discord_link\";s:0:\"\";s:9:\"yelp_link\";s:0:\"\";s:7:\"vk_link\";s:0:\"\";s:7:\"ok_link\";s:0:\"\";s:18:\"social_email_links\";s:1:\"0\";s:19:\"social_share_notice\";s:0:\"\";s:8:\"share_fb\";s:1:\"1\";s:13:\"share_twitter\";s:1:\"1\";s:15:\"share_pinterest\";s:1:\"1\";s:14:\"share_linkedin\";s:1:\"1\";s:14:\"share_whatsapp\";s:1:\"0\";s:8:\"share_tg\";s:1:\"1\";s:11:\"share_viber\";s:1:\"0\";s:8:\"share_vk\";s:1:\"0\";s:8:\"share_ok\";s:1:\"0\";s:11:\"share_email\";s:1:\"0\";s:19:\"mobile_optimization\";s:1:\"0\";s:16:\"load_text_domain\";s:1:\"1\";s:21:\"disable_gutenberg_css\";s:1:\"0\";s:17:\"styles_always_use\";s:0:\"\";s:14:\"styles_not_use\";s:0:\"\";s:26:\"disable_owl_mobile_devices\";s:1:\"0\";s:21:\"remove_jquery_migrate\";s:1:\"0\";s:18:\"advanced_js_notice\";s:0:\"\";s:11:\"advanced_js\";s:1:\"0\";s:20:\"autocomplete_library\";s:8:\"required\";s:14:\"cookie_library\";s:8:\"required\";s:24:\"countdown-bundle_library\";s:8:\"required\";s:14:\"device_library\";s:7:\"not_use\";s:22:\"isotope-bundle_library\";s:8:\"required\";s:17:\"justified_library\";s:8:\"required\";s:16:\"magnific_library\";s:8:\"required\";s:28:\"panr-parallax-bundle_library\";s:8:\"required\";s:16:\"parallax_library\";s:8:\"required\";s:30:\"parallax-scroll-bundle_library\";s:8:\"required\";s:25:\"photoswipe-bundle_library\";s:8:\"required\";s:12:\"pjax_library\";s:8:\"required\";s:18:\"sticky-kit_library\";s:8:\"required\";s:17:\"wd_swiper_library\";s:8:\"required\";s:18:\"threesixty_library\";s:8:\"required\";s:16:\"tooltips_library\";s:8:\"required\";s:13:\"vivus_library\";s:8:\"required\";s:17:\"waypoints_library\";s:8:\"required\";s:15:\"leaflet_library\";s:8:\"required\";s:20:\"vimeo_player_library\";s:8:\"required\";s:18:\"scripts_always_use\";s:0:\"\";s:15:\"scripts_not_use\";s:0:\"\";s:15:\"dequeue_scripts\";s:0:\"\";s:12:\"lazy_loading\";s:1:\"0\";s:22:\"lazy_loading_bg_images\";s:1:\"0\";s:19:\"lazy_loading_offset\";s:1:\"0\";s:11:\"lazy_effect\";s:4:\"none\";s:23:\"lazy_custom_placeholder\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:30:\"disable_wordpress_lazy_loading\";s:1:\"0\";s:26:\"rocket_delay_js_exclusions\";s:1:\"0\";s:6:\"cf7_js\";s:1:\"1\";s:20:\"elementor_animations\";s:1:\"1\";s:15:\"elementor_icons\";s:1:\"1\";s:24:\"elementor_dialog_library\";s:1:\"1\";s:18:\"elementor_frontend\";s:1:\"1\";s:14:\"swiper_library\";s:6:\"always\";s:19:\"google_font_display\";s:7:\"disable\";s:18:\"icons_font_display\";s:7:\"disable\";s:16:\"font_awesome_css\";s:7:\"not_use\";s:23:\"font_icon_woff2_preload\";s:1:\"0\";s:9:\"preloader\";s:1:\"0\";s:15:\"preloader_image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"preloader_background_color\";a:1:{s:4:\"idle\";s:7:\"#ffffff\";}s:22:\"preloader_color_scheme\";s:4:\"dark\";s:15:\"current_builder\";s:8:\"external\";s:16:\"gutenberg_blocks\";s:1:\"0\";s:29:\"enable_gutenberg_for_products\";s:1:\"0\";s:12:\"negative_gap\";s:7:\"enabled\";s:20:\"sticky_notifications\";s:1:\"0\";s:13:\"page_comments\";s:1:\"1\";s:15:\"custom_404_page\";s:0:\"\";s:16:\"widget_title_tag\";s:2:\"h5\";s:15:\"woodmart_slider\";s:1:\"1\";s:16:\"allow_upload_svg\";s:1:\"1\";s:29:\"rev_slider_inherit_theme_font\";s:1:\"0\";s:13:\"site_viewport\";s:12:\"not_scalable\";s:16:\"maintenance_mode\";s:1:\"0\";s:22:\"maintenance_access_key\";s:0:\"\";s:11:\"white_label\";s:1:\"0\";s:22:\"white_label_theme_name\";s:0:\"\";s:12:\"dummy_import\";s:1:\"1\";s:29:\"white_label_theme_license_tab\";s:1:\"1\";s:25:\"white_label_changelog_tab\";s:1:\"1\";s:20:\"theme_admin_bar_menu\";s:1:\"1\";s:23:\"white_label_theme_hints\";s:1:\"1\";s:29:\"white_label_sidebar_icon_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"white_label_dashboard_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:33:\"white_label_appearance_screenshot\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:27:\"white_label_dashboard_title\";s:0:\"\";s:26:\"white_label_dashboard_text\";s:0:\"\";s:5:\"reset\";s:0:\"\";s:12:\"reset_notice\";s:0:\"\";s:8:\"wishlist\";s:1:\"1\";s:13:\"wishlist_page\";s:3:\"388\";s:15:\"wishlist_logged\";s:1:\"0\";s:20:\"wishlist_bulk_action\";s:1:\"1\";s:19:\"wishlist_empty_text\";s:112:\"You don\'t have any products in the wishlist yet. You will find a lot of interesting products on our \"Shop\" page.\";s:17:\"wishlist_expanded\";s:1:\"0\";s:19:\"wishlist_show_popup\";s:6:\"enable\";s:21:\"product_loop_wishlist\";s:1:\"1\";s:26:\"wishlist_save_button_state\";s:1:\"0\";s:27:\"checkout_show_product_image\";s:1:\"0\";s:25:\"checkout_product_quantity\";s:1:\"0\";s:22:\"checkout_remove_button\";s:1:\"0\";s:24:\"checkout_link_to_product\";s:1:\"0\";s:16:\"reviews_location\";s:4:\"tabs\";s:23:\"reviews_section_columns\";s:10:\"two-column\";s:21:\"reviews_form_location\";s:5:\"after\";s:13:\"reviews_style\";s:7:\"style-1\";s:15:\"reviews_columns\";s:1:\"1\";s:22:\"reviews_columns_tablet\";s:1:\"1\";s:22:\"reviews_columns_mobile\";s:1:\"1\";s:24:\"reviews_enable_pros_cons\";s:1:\"0\";s:20:\"reviews_enable_likes\";s:1:\"0\";s:32:\"show_reviews_purchased_indicator\";s:1:\"0\";s:15:\"reviews_sorting\";s:1:\"0\";s:29:\"single_product_comment_images\";s:1:\"0\";s:35:\"single_product_comment_images_count\";s:1:\"3\";s:41:\"single_product_comment_images_upload_size\";s:1:\"1\";s:38:\"single_product_comment_images_required\";s:1:\"0\";s:30:\"show_reviews_only_image_filter\";s:1:\"0\";s:22:\"reviews_rating_summary\";s:1:\"0\";s:30:\"reviews_rating_summary_content\";s:6:\"rating\";s:29:\"reviews_rating_summary_filter\";s:1:\"0\";s:26:\"reviews_rating_by_criteria\";s:1:\"0\";s:32:\"reviews_criteria_rating_required\";s:1:\"0\";s:38:\"reviews_rating_summary_criteria_1_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_1\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_2_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_2\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_3_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_3\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_4_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_4\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_5_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_5\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_6_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_6\";s:0:\"\";s:24:\"sticky_navigation_notice\";s:0:\"\";s:22:\"sticky_navigation_menu\";s:0:\"\";s:23:\"sticky_navigation_title\";s:0:\"\";s:30:\"sticky_navigation_content_type\";s:4:\"text\";s:22:\"sticky_navigation_area\";s:0:\"\";s:28:\"sticky_navigation_html_block\";s:0:\"\";s:33:\"single_product_main_gallery_video\";s:1:\"1\";s:23:\"checkout_fields_enabled\";s:1:\"0\";s:29:\"shipping_progress_bar_enabled\";s:1:\"0\";s:33:\"shipping_progress_bar_calculation\";s:6:\"custom\";s:28:\"shipping_progress_bar_amount\";s:3:\"100\";s:36:\"shipping_progress_bar_include_coupon\";s:7:\"exclude\";s:40:\"shipping_progress_bar_location_card_page\";s:1:\"1\";s:40:\"shipping_progress_bar_location_mini_cart\";s:1:\"1\";s:39:\"shipping_progress_bar_location_checkout\";s:1:\"0\";s:45:\"shipping_progress_bar_location_single_product\";s:1:\"0\";s:37:\"shipping_progress_bar_message_initial\";s:46:\"Add [remainder] to cart and get free shipping!\";s:37:\"shipping_progress_bar_message_success\";s:39:\"Your order qualifies for free shipping!\";s:15:\"buy_now_enabled\";s:1:\"0\";s:16:\"buy_now_redirect\";s:8:\"checkout\";s:23:\"counter_visitor_enabled\";s:1:\"0\";s:27:\"counter_visitor_data_source\";s:9:\"live_data\";s:38:\"counter_visitor_data_source_min_number\";s:2:\"10\";s:38:\"counter_visitor_data_source_max_number\";s:2:\"20\";s:25:\"counter_visitor_live_mode\";s:1:\"0\";s:27:\"counter_visitor_ajax_update\";s:1:\"0\";s:29:\"counter_visitor_live_duration\";s:2:\"10\";s:17:\"linked_variations\";s:1:\"1\";s:21:\"show_single_variation\";s:1:\"0\";s:21:\"hide_variation_parent\";s:1:\"0\";s:23:\"bought_together_enabled\";s:1:\"1\";s:22:\"bought_together_column\";s:1:\"3\";s:29:\"bought_together_column_tablet\";s:4:\"auto\";s:29:\"bought_together_column_mobile\";s:4:\"auto\";s:26:\"bought_together_form_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:20:\"sold_counter_enabled\";s:1:\"0\";s:23:\"sold_counter_sales_type\";s:9:\"real_data\";s:24:\"sold_counter_shown_after\";s:1:\"0\";s:22:\"sold_counter_min_count\";s:2:\"10\";s:22:\"sold_counter_max_count\";s:2:\"20\";s:31:\"sold_counter_hide_on_outofstock\";s:1:\"0\";s:22:\"sold_counter_timeframe\";s:1:\"3\";s:29:\"sold_counter_timeframe_period\";s:7:\"minutes\";s:28:\"sold_counter_transient_hours\";s:2:\"24\";s:17:\"discounts_enabled\";s:1:\"0\";s:20:\"show_discounts_table\";s:1:\"0\";s:18:\"free_gifts_enabled\";s:1:\"0\";s:16:\"free_gifts_limit\";s:1:\"5\";s:41:\"free_gifts_allow_multiple_identical_gifts\";s:1:\"0\";s:23:\"free_gifts_price_format\";s:4:\"text\";s:17:\"free_gift_on_cart\";s:1:\"1\";s:25:\"free_gifts_table_location\";s:28:\"woocommerce_after_cart_table\";s:21:\"free_gift_on_checkout\";s:1:\"0\";s:28:\"show_out_of_stock_at_the_end\";s:1:\"0\";s:16:\"waitlist_enabled\";s:1:\"0\";s:21:\"waitlist_for_loggined\";s:1:\"0\";s:19:\"waitlist_form_state\";s:13:\"current_state\";s:25:\"waitlist_fragments_enable\";s:1:\"0\";s:22:\"waitlist_wait_interval\";s:4:\"3600\";s:32:\"waitlist_enable_privacy_checkbox\";s:1:\"1\";s:30:\"waitlist_privacy_checkbox_text\";s:85:\"من <strong>[privacy_policy]</strong> را خوانده‌ام و می‌پذیرم.\";s:25:\"estimate_delivery_enabled\";s:1:\"0\";s:40:\"estimate_delivery_show_on_single_product\";s:1:\"1\";s:35:\"estimate_delivery_show_on_mini_cart\";s:1:\"0\";s:35:\"estimate_delivery_show_on_cart_page\";s:1:\"1\";s:39:\"estimate_delivery_show_on_checkout_page\";s:1:\"1\";s:39:\"estimate_delivery_show_on_order_details\";s:1:\"1\";s:37:\"estimate_delivery_show_on_email_order\";s:1:\"1\";s:30:\"estimate_delivery_show_overall\";s:1:\"0\";s:29:\"estimate_delivery_date_format\";s:7:\"default\";s:34:\"estimate_delivery_fragments_enable\";s:1:\"0\";s:21:\"cart_recovery_enabled\";s:1:\"0\";s:26:\"recover_guest_cart_enabled\";s:1:\"0\";s:42:\"recover_guest_cart_enable_privacy_checkbox\";s:1:\"0\";s:40:\"recover_guest_cart_privacy_checkbox_text\";s:447:\"اگر این کادر را علامت بزنید، به ما اجازه می دهید تا برخی از جزئیات خود را در لیست مخاطبین ذخیره کنیم. ممکن است پیام های ایمیلی حاوی اطلاعات تجاری یا تبلیغاتی در مورد این فروشگاه دریافت کنید.\r\nاطلاعات شخصی جمع آوری شده: آدرس ایمیل، نام و نام خانوادگی.\";s:24:\"abandoned_cart_timeframe\";s:1:\"2\";s:31:\"abandoned_cart_timeframe_period\";s:5:\"86400\";s:31:\"abandoned_cart_delete_timeframe\";s:2:\"30\";s:38:\"abandoned_cart_delete_timeframe_period\";s:5:\"86400\";s:29:\"abandoned_cart_coupon_enabled\";s:1:\"0\";s:28:\"abandoned_cart_coupon_prefix\";s:2:\"WD\";s:28:\"abandoned_cart_coupon_amount\";s:2:\"10\";s:35:\"abandoned_cart_coupon_discount_type\";s:7:\"percent\";s:34:\"abandoned_cart_delete_used_coupons\";s:1:\"1\";s:37:\"abandoned_cart_delete_expired_coupons\";s:1:\"1\";s:31:\"abandoned_cart_coupon_timeframe\";s:1:\"1\";s:38:\"abandoned_cart_coupon_timeframe_period\";s:5:\"86400\";s:8:\"last_tab\";s:10:\"custom_css\";}", "auto");
INSERT INTO `wp_options` VALUES("157", "woodmart_setup_status", "", "auto");
INSERT INTO `wp_options` VALUES("158", "wd_import_theme_version", "", "auto");
INSERT INTO `wp_options` VALUES("159", "woodmart-plugins-update-time", "1749417156", "auto");
INSERT INTO `wp_options` VALUES("160", "woodmart_js_composer_version", "8.4.1", "auto");
INSERT INTO `wp_options` VALUES("161", "woodmart_revslider_version", "6.7.34", "auto");
INSERT INTO `wp_options` VALUES("162", "RTL-CareUnit-PIL", "q1bKSS1LzVGyUnJMLsksSyzJzM9T0lEqLkksKS0GigaXJienFhcDhVJSi5OLMgvACqyUlGoB", "off");
INSERT INTO `wp_options` VALUES("163", "rcuPluginHealthyServerIndex", "1", "off");
INSERT INTO `wp_options` VALUES("164", "rcuPluginLastHealthyServerIndex", "1", "off");
INSERT INTO `wp_options` VALUES("169", "RTL-CareUnit-FPA", "1", "auto");
INSERT INTO `wp_options` VALUES("4467", "q0hyNM0pyy4O8iuv8Aw1CSjPdjfxMC5MTUoyDgwrinJ1i7D0zPUuCPN1TLcFAA", "DdDJomswAADQD7JoEcLiLVpSqqVm2p2ZGGpM1Nffdz7hzKY_672mDTKOsnygMbEirS7AG6k6YxOOCTnui729h8f86kVIZ-FbxfUpwtrAmZf7aY2ksGh4DjLWyz0SAaqcZx_8lPNz-iSaoDxGNLxj2ctuqm0oUUGrOIXZU2SThcf9jrtzfNuKXXN40bR-PgfPhXs5rIAhG2gezaCEsphTNRtr5rygSR0b06YfiUgHN1XSIT6N6iUwfvV9ws_oqlcp5txWcBT5cwac_OL6vBnAdcnT0O4DUzCCuy838r49QEb2gDitHLD3Fpj7UtploCJrln5XvNrI2GWJnduViZ2kzp2SjonFqn6XWlruhOxgW0Z3xF3qzbwjWZ2V4MR3i2vqwqRbu0eHNGbtKiX_kCUbjRfQFUXWqaDUlL2Tj4ZzaGdyNfr_B6Y0PxV0aGJAGNju67UZz0inHLoQ9eONDpsKfErLHyi0sSTK2Xp3kjGXv6nwU4LBUYLRuG-3TUtHWXaaSAxhZCyxjZ3XdIrNRPih-0iZi04Yu7J6RPii43X88WQm35ZJlszrriu_AfLNqQi0qPgq61KfSwDwnVepmiYmDfdWONx2XEG79eArmsvKmK9Mx1_ob3snXKBEN0OMukDCqH0y0aXyOytNonq7ja7_hV6VrOkVZheR29CygjnNYD3T2EE0oiePFeyQlt7yFpOZb98ZZUPRJUGmvLuq0gPOqKYdq-rkH4_zjRF5E6n9Vi_XjQJf-FQuijTthhGlr6D2CXsjSVl-01_F39A6YyEB__4A", "off");
INSERT INTO `wp_options` VALUES("168", "bd95de237f3e27423d8db445d2c686719041eab4", "def50200c2b43b03737b5e11b8c7f0effc962596b9ed7975044efb670089092a15e9c5db381fa4891a5ed1d10689ae0c3b2782d8aad956d8292ee344d154ae949cc161e8a66d1e32c7eec21db1fa187ebcbcddc6a85bdb683fee9ef6d38b27a15456b9ec57dc3a8a391316b0cc44b906099d3d7515f84d3d0ca2e22bef94d937a713f15d7bda5574554489cec5c337106943fc855465d9c4ae8dc08345683a5e557aa587855f989de6c29b07f4dbf1182f4c5f8718eab4a765af69b915c8b3c83a6455d47713bc49f7a078095652ab8c348e762ae6b795b28254b634584f44e7376c7f4f3999ee636674bfdfc9ee3ee543aaa8b271b40a1010d9a66e187552f68fb67e9845ec1e5f158080af552ce93378f9646867c5bb2d0c3af48ca42a171746a2522c66a11175191bf2e1b70d209b2c6d5c5238c7ec8b05ec8ad2552f91babfb348075ab07ec4b54e3e98e1d87821bf7aacd6cd8fb2e5b01d2c48751e713a1546a556af372543422ed7f73f9621de4e17344072ef4bbd23ab241b5f66c7445353c7d2554f8db0503317cf3c728bcb7ba2b0884d5f29e0efcffad8d3ab815791958390b70727be9ac699f756858abde28b0d9f66963a38be3b429d3f778ea3973c180b24a0fa4d50c654124c070cbbe752105dc4cdd03d0380f08b53599fb1f33a1ff58e906e21662818c0aa0a84a18d05b74b1d687f9d29712e5bf95e72b0db0da5531e4ad1be9434a1938fd3544e314a9c2dafeda133812867d603bb768da60c7ecfda2186", "off");
INSERT INTO `wp_options` VALUES("172", "wd_wishlist_installed", "1", "auto");
INSERT INTO `wp_options` VALUES("173", "woodmart_upgrade_database_wishlist", "1", "auto");
INSERT INTO `wp_options` VALUES("174", "woodmart_added_column_on_sale_in_product_db", "1", "auto");
INSERT INTO `wp_options` VALUES("175", "xts-theme_settings_default-css-data", "@font-face {\n	font-weight: normal;\n	font-style: normal;\n	font-family: \"woodmart-font\";\n	src: url(\"//demoes.aramis-co.ir/spare/wp-content/themes/woodmart/fonts/woodmart-font-2-400.woff2?v=8.2.2\") format(\"woff2\");\n}\n\n@font-face {\n	font-family: \"star\";\n	font-weight: 400;\n	font-style: normal;\n	src: url(\"//demoes.aramis-co.ir/spare/wp-content/plugins/woocommerce/assets/fonts/star.eot?#iefix\") format(\"embedded-opentype\"), url(\"//demoes.aramis-co.ir/spare/wp-content/plugins/woocommerce/assets/fonts/star.woff\") format(\"woff\"), url(\"//demoes.aramis-co.ir/spare/wp-content/plugins/woocommerce/assets/fonts/star.ttf\") format(\"truetype\"), url(\"//demoes.aramis-co.ir/spare/wp-content/plugins/woocommerce/assets/fonts/star.svg#star\") format(\"svg\");\n}\n\n@font-face {\n	font-family: \"WooCommerce\";\n	font-weight: 400;\n	font-style: normal;\n	src: url(\"//demoes.aramis-co.ir/spare/wp-content/plugins/woocommerce/assets/fonts/WooCommerce.eot?#iefix\") format(\"embedded-opentype\"), url(\"//demoes.aramis-co.ir/spare/wp-content/plugins/woocommerce/assets/fonts/WooCommerce.woff\") format(\"woff\"), url(\"//demoes.aramis-co.ir/spare/wp-content/plugins/woocommerce/assets/fonts/WooCommerce.ttf\") format(\"truetype\"), url(\"//demoes.aramis-co.ir/spare/wp-content/plugins/woocommerce/assets/fonts/WooCommerce.svg#WooCommerce\") format(\"svg\");\n}\n\n:root {\n	--wd-text-font: peyda;\n	--wd-text-font-weight: 400;\n	--wd-text-color: #767676;\n	--wd-text-font-size: 14px;\n	--wd-title-font: YekanBakhFaNum;\n	--wd-title-font-weight: 600;\n	--wd-title-color: #242424;\n	--wd-entities-title-font: YekanBakhFaNum;\n	--wd-entities-title-font-weight: 500;\n	--wd-entities-title-color: #333333;\n	--wd-entities-title-color-hover: rgb(51 51 51 / 65%);\n	--wd-alternative-font: YekanBakhFaNum;\n	--wd-widget-title-font: YekanBakhFaNum;\n	--wd-widget-title-font-weight: 600;\n	--wd-widget-title-transform: uppercase;\n	--wd-widget-title-color: #333;\n	--wd-widget-title-font-size: 16px;\n	--wd-header-el-font: YekanBakhFaNum;\n	--wd-header-el-font-weight: 700;\n	--wd-header-el-transform: uppercase;\n	--wd-header-el-font-size: 13px;\n	--wd-primary-color: rgb(254,56,56);\n	--wd-alternative-color: rgb(55,55,55);\n	--wd-link-color: #333333;\n	--wd-link-color-hover: rgb(79,79,79);\n	--btn-default-bgcolor: rgb(254,56,56);\n	--btn-default-bgcolor-hover: rgb(209,46,46);\n	--btn-accented-bgcolor: rgb(254,56,56);\n	--btn-accented-bgcolor-hover: rgb(209,46,46);\n	--wd-form-brd-width: 2px;\n	--notices-success-bg: #459647;\n	--notices-success-color: #fff;\n	--notices-warning-bg: #E0B252;\n	--notices-warning-color: #fff;\n}\n.wd-popup.wd-age-verify {\n	--wd-popup-width: 500px;\n}\n.wd-popup.wd-promo-popup {\n	background-color: #111111;\n	background-image: none;\n	background-repeat: no-repeat;\n	background-size: contain;\n	background-position: left center;\n	--wd-popup-width: 800px;\n}\n.header-banner {\n	background-color: rgb(255,255,255);\n	background-image: url(https://demoes.aramis-co.ir/spare/wp-content/uploads/2025/03/Frame-233-1.png);\n	background-repeat: no-repeat;\n	background-size: contain;\n	background-attachment: inherit;\n	background-position: center bottom;\n}\n:is(.woodmart-archive-shop .wd-builder-off,.wd-wishlist-content,.related-and-upsells,.cart-collaterals,.wd-shop-product,.wd-fbt) .wd-products-with-bg, :is(.woodmart-archive-shop .wd-builder-off,.wd-wishlist-content,.related-and-upsells,.cart-collaterals,.wd-shop-product,.wd-fbt) .wd-products-with-bg :is(.wd-product,.wd-cat) {\n	--wd-prod-bg:rgb(255,255,255);\n	--wd-bordered-bg:rgb(255,255,255);\n}\n:is(.woodmart-woocommerce-layered-nav, .wd-product-category-filter) .wd-scroll-content {\n	max-height: 223px;\n}\n.wd-page-title {\n	background-color: #0a0a0a;\n	background-image: none;\n	background-size: cover;\n	background-position: center center;\n}\n.wd-footer {\n	background-color: #ffffff;\n	background-image: none;\n}\n.woodmart-archive-shop:not(.single-product) .wd-page-content {\n	background-color: rgb(255,255,255);\n	background-image: none;\n}\n.single-product .wd-page-content {\n	background-color: rgb(255,255,255);\n	background-image: none;\n}\n.woodmart-archive-blog .wd-page-content {\n	background-color: rgb(255,255,255);\n	background-image: none;\n}\n.single-post .wd-page-content {\n	background-color: rgb(255,255,255);\n	background-image: none;\n}\n.woodmart-archive-portfolio .wd-page-content {\n	background-color: rgb(255,255,255);\n	background-image: none;\n}\n.single-portfolio .wd-page-content {\n	background-color: rgb(255,255,255);\n	background-image: none;\n}\n.wd-popup.popup-quick-view {\n	--wd-popup-width: 920px;\n}\n:root{\n--wd-container-w: 1222px;\n--wd-form-brd-radius: 0px;\n--btn-default-color: #333;\n--btn-default-color-hover: #333;\n--btn-accented-color: #fff;\n--btn-accented-color-hover: #fff;\n--btn-default-brd-radius: 35px;\n--btn-default-box-shadow: none;\n--btn-default-box-shadow-hover: none;\n--btn-accented-brd-radius: 35px;\n--btn-accented-box-shadow: none;\n--btn-accented-box-shadow-hover: none;\n--wd-brd-radius: 0px;\n}\n\n@media (min-width: 1222px) {\nsection.elementor-section.wd-section-stretch > .elementor-container {\nmargin-left: auto;\nmargin-right: auto;\n}\n}\n\n\n.light {\r\n  animation: blinker 1.5s linear infinite;\r\n}\r\n\r\n@keyframes blinker {\r\n  50% {\r\n    opacity: 0;\r\n  }\r\n}\r\n.whb-column.whb-col-left.whb-column8.whb-visible-lg{\r\n	background-color:rgba(255, 255, 255, 0.09);\r\nborder-radius:200px;\r\nmargin-left:20px;\r\n	padding-right:20px;\r\n}\r\n.whb-column.whb-col-right.whb-column10.whb-visible-lg{\r\n	background-color:rgba(255, 255, 255, 0.09);\r\nborder-radius:200px;\r\nmargin-right:20px;\r\n	padding-left:20px;\r\n}\r\n.rotimg {\r\n    \r\n    -webkit-animation:spin 4s linear infinite;\r\n    -moz-animation:spin 4s linear infinite;\r\n    animation:spin 4s linear infinite;\r\n}\r\n@-moz-keyframes spin { \r\n    100% { -moz-transform: rotate(360deg); } \r\n}\r\n@-webkit-keyframes spin { \r\n    100% { -webkit-transform: rotate(360deg); } \r\n}\r\n@keyframes spin { \r\n    100% { \r\n        -webkit-transform: rotate(360deg); \r\n        transform:rotate(360deg); \r\n    } \r\n}\r\n.prolist img{\r\n	width:60px\r\n}\r\n@media only screen and (max-width: 768px)\r\n{\r\n\r\n\r\n.whb-main-header{\r\nbackground-color:rgba(255, 255, 255, 0.09);\r\n}", "on");
INSERT INTO `wp_options` VALUES("7146", "_transient_timeout_woocommerce_admin_remote_inbox_notifications_specs", "1750174141", "off");
INSERT INTO `wp_options` VALUES("7147", "_transient_woocommerce_admin_remote_inbox_notifications_specs", "a:1:{s:5:\"fa_IR\";a:61:{s:21:\"wayflyer_bnpl_q4_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:21:\"wayflyer_bnpl_q4_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:48:\"Grow your business with funding through Wayflyer\";s:7:\"content\";s:261:\"Fast, flexible financing to boost cash flow and help your business grow – one fee, no interest rates, penalties, equity, or personal guarantees. Based on your store’s performance, Wayflyer provides funding and analytical insights to invest in your business.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:21:\"wayflyer_bnpl_q4_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"Level up with funding\";}}s:3:\"url\";s:118:\"https://woocommerce.com/products/wayflyer/?utm_source=inbox_note&utm_medium=product&utm_campaign=wayflyer_bnpl_q4_2021\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-17 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-12-18 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:7:{i:0;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"AU\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"BE\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"CA\";}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"IE\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"NL\";}i:5;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"GB\";}i:6;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-affirm\";}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:32:\"afterpay-gateway-for-woocommerce\";}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:31:\"klarna-payments-for-woocommerce\";}}}}}}s:35:\"wc_shipping_mobile_app_usps_q4_2021\";O:8:\"stdClass\":8:{s:4:\"slug\";s:35:\"wc_shipping_mobile_app_usps_q4_2021\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:94:\"Print and manage your shipping labels with WooCommerce Shipping and the WooCommerce Mobile App\";s:7:\"content\";s:210:\"Save time by printing, purchasing, refunding, and tracking shipping labels generated by <a href=\"https://woocommerce.com/woocommerce-shipping/\">WooCommerce Shipping</a> – all directly from your mobile device!\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"wc_shipping_mobile_app_usps_q4_2021\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:24:\"Get WooCommerce Shipping\";}}s:3:\"url\";s:135:\"https://woocommerce.com/woocommerce-shipping/?utm_source=inbox_note&utm_medium=product&utm_campaign=wc_shipping_mobile_app_usps_q4_2021\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-11-12 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2021-11-27 00:00:00\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:25:\"woocommerce-shipping-usps\";}}i:4;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-services\";}}}}}}s:18:\"your-first-product\";O:8:\"stdClass\":8:{s:4:\"slug\";s:18:\"your-first-product\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:18:\"Your first product\";s:7:\"content\";s:467:\"That’s huge! You’re well on your way to building a successful online store — now it’s time to think about how you’ll fulfill your orders.<br/><br/>Read our shipping guide to learn best practices and options for putting together your shipping strategy. And for WooCommerce stores in the United States, you can print discounted shipping labels via USPS with <a href=\"https://href.li/?https://woocommerce.com/shipping\" target=\"_blank\">WooCommerce Shipping</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:130:\"https://woocommerce.com/posts/ecommerce-shipping-solutions-guide/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:19:13\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_were_no_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:12:\"stored_state\";s:5:\"index\";s:22:\"there_are_now_products\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:2:\">=\";s:5:\"value\";i:1;}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:18:\"onboarding_profile\";s:5:\"index\";s:13:\"product_types\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"physical\";s:7:\"default\";a:0:{}}}}s:37:\"wc-admin-optimizing-the-checkout-flow\";O:8:\"stdClass\":8:{s:4:\"slug\";s:37:\"wc-admin-optimizing-the-checkout-flow\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:28:\"Optimizing the checkout flow\";s:7:\"content\";s:177:\"It’s crucial to get your store’s checkout as smooth as possible to avoid losing sales. Let’s take a look at how you can optimize the checkout experience for your shoppers.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:28:\"optimizing-the-checkout-flow\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:144:\"https://woocommerce.com/posts/optimizing-woocommerce-checkout?utm_source=inbox_note&utm_medium=product&utm_campaign=optimizing-the-checkout-flow\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:19:49\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:3;}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:8:\"payments\";s:7:\"default\";a:0:{}}}}s:32:\"wc-payments-qualitative-feedback\";O:8:\"stdClass\":8:{s:4:\"slug\";s:32:\"wc-payments-qualitative-feedback\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:46:\"WooPayments setup - let us know what you think\";s:7:\"content\";s:137:\"Congrats on enabling WooPayments for your store. Please share your feedback in this 2 minute survey to help us improve the setup process.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"qualitative-feedback-from-new-users\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:58:\"https://automattic.survey.fm/woopayments-new-user-feedback\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:21:13\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:45:\"woocommerce_task_list_tracked_completed_tasks\";s:9:\"operation\";s:8:\"contains\";s:5:\"value\";s:20:\"woocommerce-payments\";s:7:\"default\";a:0:{}}}}s:29:\"share-your-feedback-on-paypal\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"share-your-feedback-on-paypal\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:29:\"Share your feedback on PayPal\";s:7:\"content\";s:127:\"Share your feedback in this 2 minute survey about how we can make the process of accepting payments more useful for your store.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"share-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:43:\"http://automattic.survey.fm/paypal-feedback\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:21:50\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-stripe\";}}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}}}s:31:\"google_listings_and_ads_install\";O:8:\"stdClass\":8:{s:4:\"slug\";s:31:\"google_listings_and_ads_install\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Drive traffic and sales with Google\";s:7:\"content\";s:123:\"Reach online shoppers to drive traffic and sales for your store by showcasing products across Google, for free or with ads.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"get-started\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:11:\"Get started\";}}s:3:\"url\";s:122:\"https://woocommerce.com/products/google-listings-and-ads?utm_source=inbox_note&utm_medium=product&utm_campaign=get-started\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2021-06-09 00:00:00\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:23:\"google_listings_and_ads\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:10;}}}s:39:\"wc-subscriptions-security-update-3-0-15\";O:8:\"stdClass\":8:{s:4:\"slug\";s:39:\"wc-subscriptions-security-update-3-0-15\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:42:\"WooCommerce Subscriptions security update!\";s:7:\"content\";s:738:\"We recently released an important security update to WooCommerce Subscriptions. To ensure your site’s data is protected, please upgrade <strong>WooCommerce Subscriptions to version 3.0.15</strong> or later.<br/><br/>Click the button below to view and update to the latest Subscriptions version, or log in to <a href=\"https://woocommerce.com/my-dashboard\">WooCommerce.com Dashboard</a> and navigate to your <strong>Downloads</strong> page.<br/><br/>We recommend always using the latest version of WooCommerce Subscriptions, and other software running on your site, to ensure maximum security.<br/><br/>If you have any questions we are here to help — just <a href=\"https://woocommerce.com/my-account/create-a-ticket/\">open a ticket</a>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:30:\"update-wc-subscriptions-3-0-15\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:19:\"View latest version\";}}s:3:\"url\";s:30:\"&page=wc-addons&section=helper\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:30:32\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"woocommerce-subscriptions\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:6:\"3.0.15\";}}}s:29:\"woocommerce-core-update-5-4-0\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"woocommerce-core-update-5-4-0\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Update to WooCommerce 5.4.1 now\";s:7:\"content\";s:140:\"WooCommerce 5.4.1 addresses a checkout issue discovered in WooCommerce 5.4. We recommend upgrading to WooCommerce 5.4.1 as soon as possible.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:20:\"update-wc-core-5-4-0\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:25:\"How to update WooCommerce\";}}s:3:\"url\";s:64:\"https://docs.woocommerce.com/document/how-to-update-woocommerce/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:31:08\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.0\";}}}s:19:\"wcpay-promo-2020-11\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"wcpay-promo-2020-11\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:19:\"wcpay-promo-2020-11\";s:7:\"content\";s:19:\"wcpay-promo-2020-11\";}}s:7:\"actions\";a:0:{}s:5:\"rules\";a:0:{}}s:19:\"wcpay-promo-2020-12\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"wcpay-promo-2020-12\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:19:\"wcpay-promo-2020-12\";s:7:\"content\";s:19:\"wcpay-promo-2020-12\";}}s:7:\"actions\";a:0:{}s:5:\"rules\";a:0:{}}s:34:\"ppxo-pps-upgrade-paypal-payments-1\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"ppxo-pps-upgrade-paypal-payments-1\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"Get the latest PayPal extension for WooCommerce\";s:7:\"content\";s:442:\"Heads up! There’s a new PayPal on the block!<br/><br/>Now is a great time to upgrade to our latest <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">PayPal extension</a> to continue to receive support and updates with PayPal.<br/><br/>Get access to a full suite of PayPal payment methods, extensive currency and country coverage, and pay later options with the all-new PayPal extension for WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"ppxo-pps-install-paypal-payments-1\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"View upgrade guide\";}}s:3:\"url\";s:96:\"https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:33:53\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;}}}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";i:7;s:7:\"default\";i:1;s:9:\"operation\";s:1:\"<\";}}}s:34:\"ppxo-pps-upgrade-paypal-payments-2\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"ppxo-pps-upgrade-paypal-payments-2\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Upgrade your PayPal experience!\";s:7:\"content\";s:358:\"Get access to a full suite of PayPal payment methods, extensive currency and country coverage, offer subscription and recurring payments, and the new PayPal pay later options.<br /><br />Start using our <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">latest PayPal today</a> to continue to receive support and updates.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"ppxo-pps-install-paypal-payments-2\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:18:\"View upgrade guide\";}}s:3:\"url\";s:96:\"https://docs.woocommerce.com/document/woocommerce-paypal-payments/paypal-payments-upgrade-guide/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:34:30\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-paypal-payments\";}}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:43:\"woocommerce-gateway-paypal-express-checkout\";}}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;}}}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:36:\"woocommerce_inbox_variant_assignment\";s:5:\"value\";i:6;s:7:\"default\";i:1;s:9:\"operation\";s:1:\">\";}}}s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:56:\"Action required: Critical vulnerabilities in WooCommerce\";s:7:\"content\";s:574:\"In response to a critical vulnerability identified on July 13, 2021, we are working with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br /><br />Our investigation into this vulnerability is ongoing, but <strong>we wanted to let you know now about the importance of updating immediately</strong>.<br /><br />For more information on which actions you should take, as well as answers to FAQs, please urgently review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:137:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:59:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:35:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.6\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.8\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.5.9\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.6\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.2\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.4\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.2\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.3\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.3\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.4\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.4\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.5\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.2\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.3\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.3\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.4\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.4\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.2\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.3\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.2\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.3\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.4\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.2\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:31;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.2\";}i:32;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.3\";}i:33;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.4\";}i:34;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.1\";}i:35;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.2\";}i:36;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.2\";}i:37;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.3\";}i:38;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.5.1\";}i:39;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"3.5.10\";}i:40;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.7\";}i:41;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.3\";}i:42;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.3\";}i:43;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.5\";}i:44;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.4\";}i:45;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.4\";}i:46;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.5\";}i:47;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.6\";}i:48;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.4\";}i:49;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.5\";}i:50;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.5\";}i:51;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.4\";}i:52;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.3\";}i:53;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.5\";}i:54;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.3\";}i:55;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.3\";}i:56;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.5\";}i:57;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.3\";}i:58;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.4\";}}}s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:63:\"Action required: Critical vulnerabilities in WooCommerce Blocks\";s:7:\"content\";s:570:\"In response to a critical vulnerability identified on July 13, 2021, we are working with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/>Our investigation into this vulnerability is ongoing, but <strong>we wanted to let you know now about the importance of updating immediately</strong>.<br/><br/>For more information on which actions you should take, as well as answers to FAQs, please urgently review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:137:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:32:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:35:42\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"2.5.16\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.6.2\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.7.2\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.8.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"2.9.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.0.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.1.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.2.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.1\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.5.1\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.6.1\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.7.2\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.8.1\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.9.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.0.1\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.1.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.2.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.3.1\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.4.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.3\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.1\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.2\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.1\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.2\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.1\";}i:31;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.5.1\";}}}s:45:\"woocommerce-core-sqli-july-2021-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:45:\"woocommerce-core-sqli-july-2021-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"Solved: Critical vulnerabilities patched in WooCommerce\";s:7:\"content\";s:433:\"In response to a critical vulnerability identified on July 13, 2021, we worked with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/><strong>Your store has been updated to the latest secure version(s)</strong>. For more information and answers to FAQs, please review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:137:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:36:18\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:23:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.6\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.8\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.9\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.6\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.2\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.4\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.2\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.2\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.1\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.5.1\";}}}}}s:47:\"woocommerce-blocks-sqli-july-2021-store-patched\";O:8:\"stdClass\":8:{s:4:\"slug\";s:47:\"woocommerce-blocks-sqli-july-2021-store-patched\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:62:\"Solved: Critical vulnerabilities patched in WooCommerce Blocks\";s:7:\"content\";s:433:\"In response to a critical vulnerability identified on July 13, 2021, we worked with the WordPress Plugins Team to deploy software updates to stores running WooCommerce (versions 3.3 to 5.5) and the WooCommerce Blocks feature plugin (versions 2.5 to 5.5).<br/><br/><strong>Your store has been updated to the latest secure version(s)</strong>. For more information and answers to FAQs, please review our blog post detailing this issue.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:137:\"https://woocommerce.com/posts/critical-vulnerability-detected-july-2021/?utm_source=inbox_note&utm_medium=product&utm_campaign=learn-more\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";b:0;s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:36:54\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:46:\"woocommerce-core-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"woocommerce-blocks-sqli-july-2021-need-to-update\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:31:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"2.5.16\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.6.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.7.2\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.8.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"2.9.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.0.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.1.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.2.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.1\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.1\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.1\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.1\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.1\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.1\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.1\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.3\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.1\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.1\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.2\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.1\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.1\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.2\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.1\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:28:\"woo-gutenberg-products-block\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.5.1\";}}}}}s:19:\"habit-moment-survey\";O:8:\"stdClass\":8:{s:4:\"slug\";s:19:\"habit-moment-survey\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:63:\"We’re all ears! Share your experience so far with WooCommerce\";s:7:\"content\";s:136:\"We’d love your input to shape the future of WooCommerce together. Feel free to share any feedback, ideas or suggestions that you have.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:14:\"share-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:45:\"https://automattic.survey.fm/store-management\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-27 20:37:30\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:3;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:30;}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:13:\"product_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:0;}}}s:42:\"woocommerce-core-paypal-march-2022-updated\";O:8:\"stdClass\":8:{s:4:\"slug\";s:42:\"woocommerce-core-paypal-march-2022-updated\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Security auto-update of WooCommerce\";s:7:\"content\";s:391:\"<strong>Your store has been updated to the latest secure version of WooCommerce</strong>. We worked with WordPress to deploy PayPal Standard security updates for stores running WooCommerce (version 3.5 to 6.3). It’s recommended to disable PayPal Standard, and use <a href=\"https://woocommerce.com/products/woocommerce-paypal-payments/\" target=\"_blank\">PayPal Payments</a> to accept PayPal.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:88:\"https://developer.woocommerce.com/2022/03/10/woocommerce-3-5-10-6-3-1-security-releases/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:42:\"woocommerce-core-paypal-march-2022-dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-03-10 18:44:57\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:28:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"3.5.10\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.7\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.3\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.5\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.4\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.5\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.6\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.4\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.5\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.5\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.4\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.5\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.3\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.5\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.3\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.4\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.5.4\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.6.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.7.2\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.9.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.1.2\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.2.2\";}}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:3:\"5.5\";}i:1;a:2:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.5\";}i:1;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:27:\"woocommerce_paypal_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:3:\"yes\";s:7:\"default\";b:0;s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:7:\"enabled\";}}}}}}}}}s:47:\"woocommerce-core-paypal-march-2022-updated-nopp\";O:8:\"stdClass\":8:{s:4:\"slug\";s:47:\"woocommerce-core-paypal-march-2022-updated-nopp\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Security auto-update of WooCommerce\";s:7:\"content\";s:237:\"<strong>Your store has been updated to the latest secure version of WooCommerce</strong>. We worked with WordPress to deploy security updates related to PayPal Standard payment gateway for stores running WooCommerce (version 3.5 to 6.3).\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:88:\"https://developer.woocommerce.com/2022/03/10/woocommerce-3-5-10-6-3-1-security-releases/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:0:\"\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-03-10 18:45:04\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:28:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"3.5.10\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.6.7\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.7.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.8.3\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.9.5\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.0.4\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.1.4\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.2.5\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.3.6\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.4.4\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.5\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.5\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.4\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.5\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.3\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.3\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.5\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.3\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.4\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.5.4\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.6.2\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.7.2\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.8.1\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.9.1\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.0.1\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.1.2\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.2.2\";}}}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:42:\"woocommerce-core-paypal-march-2022-updated\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}}}s:24:\"pinterest_03_2022_update\";O:8:\"stdClass\":8:{s:4:\"slug\";s:24:\"pinterest_03_2022_update\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:53:\"Your Pinterest for WooCommerce plugin is out of date!\";s:7:\"content\";s:262:\"Update to the latest version of Pinterest for WooCommerce to continue using this plugin and keep your store connected with Pinterest. To update, visit <strong>Plugins &gt; Installed Plugins</strong>, and click on “update now” under Pinterest for WooCommerce.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:24:\"pinterest_03_2022_update\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:19:\"Update Instructions\";}}s:3:\"url\";s:148:\"https://woocommerce.com/document/pinterest-for-woocommerce/?utm_source=inbox_note&utm_medium=product&utm_campaign=pinterest_03_2022_update#section-3\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-03-23 00:00:39\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"pinterest-for-woocommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"1.0.8\";}}}s:33:\"store_setup_survey_survey_q2_2022\";O:8:\"stdClass\":8:{s:4:\"slug\";s:33:\"store_setup_survey_survey_q2_2022\";s:4:\"type\";s:6:\"survey\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:30:\"How is your store setup going?\";s:7:\"content\";s:232:\"Our goal is to make sure you have all the right tools to start setting up your store in the smoothest way possible.\r\nWe’d love to know if we hit our mark and how we can improve. To collect your thoughts, we made a 2-minute survey.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:53:\"store_setup_survey_survey_q2_2022_share_your_thoughts\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:24:\"Tell us how it’s going\";}}s:3:\"url\";s:52:\"https://automattic.survey.fm/store-setup-survey-2022\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-05-09 08:42:10\";}i:1;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:7;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\"<\";s:4:\"days\";i:9;}}}s:48:\"needs-update-eway-payment-gateway-rin-2022-12-20\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"needs-update-eway-payment-gateway-rin-2022-12-20\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:58:\"Security vulnerability patched in WooCommerce Eway Gateway\";s:7:\"content\";s:323:\"In response to a potential vulnerability identified in WooCommerce Eway Gateway versions 3.1.0 to 3.5.0, we’ve worked to deploy security fixes and have released an updated version.\r\nNo external exploits have been detected, but we recommend you update to your latest supported version 3.1.26, 3.2.3, 3.3.1, 3.4.6, or 3.5.1\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:62:\"needs-update-eway-payment-gateway-rin-action-button-2022-12-20\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:16:\"/update-core.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:63:\"needs-update-eway-payment-gateway-rin-dismiss-button-2022-12-20\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:7:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-03 23:45:53\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:6:\"3.1.26\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.2.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.3.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"3.4.6\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"3.5.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"3.1.0\";}}}s:43:\"updated-eway-payment-gateway-rin-2022-12-20\";O:8:\"stdClass\":8:{s:4:\"slug\";s:43:\"updated-eway-payment-gateway-rin-2022-12-20\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:55:\"WooCommerce Eway Gateway has been automatically updated\";s:7:\"content\";s:280:\"Your store is now running the latest secure version of WooCommerce Eway Gateway. We worked with the WordPress Plugins team to deploy a software update to stores running WooCommerce Eway Gateway (versions 3.1.0 to 3.5.0) in response to a security vulnerability that was discovered.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:57:\"updated-eway-payment-gateway-rin-action-button-2022-12-20\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"See all updates\";}}s:3:\"url\";s:16:\"/update-core.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:58:\"updated-eway-payment-gateway-rin-dismiss-button-2022-12-20\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2022-01-03 23:45:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:11:\"note_status\";s:9:\"note_name\";s:48:\"needs-update-eway-payment-gateway-rin-2022-12-20\";s:6:\"status\";s:7:\"pending\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:5:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:6:\"3.1.26\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.2.3\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.3.1\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.4.6\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:24:\"woocommerce-gateway-eway\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"3.5.1\";}}}}}s:31:\"ecomm-wc-navigation-survey-2023\";O:8:\"stdClass\":8:{s:4:\"slug\";s:31:\"ecomm-wc-navigation-survey-2023\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:39:\"Navigating WooCommerce on WordPress.com\";s:7:\"content\";s:166:\"We are improving the WooCommerce navigation on WordPress.com and would love your help to make it better! Please share your experience with us in this 2-minute survey.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:32:\"share-navigation-survey-feedback\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Share feedback\";}}s:3:\"url\";s:58:\"https://automattic.survey.fm/new-ecommerce-plan-navigation\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-01-16 09:53:44\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:12:\"is_ecommerce\";s:5:\"value\";b:1;}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:180;}}}s:39:\"woopay-beta-merchantrecruitment-04MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:39:\"woopay-beta-merchantrecruitment-04MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:319:\"WooPay, a new express checkout feature built into WooCommerce Payments, is <b>now available</b> —and we’re inviting you to be one of the first to try it. \r\n<br><br>\r\n<b>Boost conversions</b> by offering your customers a simple, secure way to pay with a <b>single click</b>.\r\n<br><br>\r\n<b>Get started in seconds.</b>\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:48:\"woopay-beta-merchantrecruitment-activate-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:58:\"woopay-beta-merchantrecruitment-activate-learnmore-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:155:\"https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-activate-learnmore-04MAY23\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-04 18:00:27\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:144:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"http://pieroatomic3.wpcomstaging.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.handinhandparenting.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://pritikinfoods.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://utahrecsports.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.hunterpta.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://www.smokinbeans.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://shulabeauty.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://bingeworthytvmerch.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://s91.4d8.myftpupload.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://stephanienicolenorris.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://aliensshirt.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://libertyordeathapparelllc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://cowboystatedaily.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:42:\"https://fundrgear.com/beckendorffathletics\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:50:\"http://wordpress-528155-2231771.cloudwaysapps.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://checkout.sohaprice.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://amadozstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://eliwehbe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://lunabra.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://nptixx.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://louisianapantry.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://aplusanatomy.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://wildsvg.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://bleachfilm.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://benabeautyspa.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:47:\"http://barrettfitnessenterprises.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://goabroadable.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://alexoathletica.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.fourpurls.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.hagmannreport.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://busybeeorganics.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://nallsproduce.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://bigtimebats.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://shop.cookingwithkarli.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.queenofpeacemedia.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://bigjohnsbeefjerky.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://paperbyjaney.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://carolinarisemembers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://veroticaevents.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://spira.farm\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:40;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://endlessassist.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:41;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://betterlifeblog.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:42;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://ashleighrenard.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:43;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.turkeymerck.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:44;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://carfiershop.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:45;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://normanmusicfestival.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:46;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"http://www.olfactoryfactoryllc.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:47;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"https://fundrgear.com/anthonyathletics\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:48;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"http://tkechilifestdotcom.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:49;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:15:\"No results foun\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:50;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://pvsa.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:51;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://becbatop.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:52;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wwmeconvention.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:53;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://lswmp.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:54;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://bubbaskincare.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:55;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://fusango.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:56;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://vcdpostershow.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:57;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://www.rileysribz.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:58;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.fakeultrasound.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:59;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://onelongfellowsquare.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:60;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://agodpod.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:61;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/littleladybulldogs\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:62;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://thecirclelarp.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:63;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://byletam.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:64;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.nachonite.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:65;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://designerdab.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:66;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"http://box2151.temp.domains/~lovebyt2/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:67;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://shortporchbaseballcompany.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:68;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://distancecme.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:69;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://middleswarthchips.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:70;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://railblazausa.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:71;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://mikescountrymeats.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:72;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://www.woodenshoe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:73;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://rockspringscafe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:74;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"http://footballfangears.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:75;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://ybtoner.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:76;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://simplyclayyy.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:77;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://naturecreation.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:78;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://marisrodriguez.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:79;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://asanteinternational.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:80;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://theatre55.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:81;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://carolynscreativeclassroom.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:82;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://www.miiriya.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:83;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://trendyds.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:84;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wooedbythefood.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:85;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://papasteamstores.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:86;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://omdurags.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:87;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://happydogbarkery.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:88;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://kitbose.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:89;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://seamossdeals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:90;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://zeatala.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:91;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://shop.atwaterffa.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:92;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://www.brettsfirstresponders.org/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:93;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://shirtactive.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:94;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://boerneparade.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:95;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://zorahshrine.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:96;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://davidcervenka.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:97;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://addisjourney.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:98;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://305ycle.cc\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:99;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"http://yourworstnightmarehaunt.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:100;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://westcoastpreps.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:101;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://checkout.sohaking.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:102;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://www.theunshakeablepundit.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:103;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://www.stellaandchewys.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:104;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://www.raywhitcomb.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:105;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:39:\"http://constellationtheatercompany.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:106;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://stacynguyen.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:107;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:46:\"https://fundrgear.com/lakecreekgirlsbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:108;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://winslowartcenter.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:109;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://flufftastik.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:110;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mygreenbeach.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:111;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://ebookvip.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:112;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://fundrgear.com/needvillevolleyball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:113;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://bifocalmedia.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:114;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://clrc.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:115;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://hyperpins.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:116;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"https://fundrgear.com/lakecreekboysbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:117;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://fundrgear.com/kparktennis\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:118;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://mogadorspices.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:119;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://fundrgear.com/newcaneytrack\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:120;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://sigmascents.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:121;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://bsharisemoore.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:122;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://morrflate.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:123;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://westbrosinc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:124;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://shop.danceplexaz.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:125;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://chikepod.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:126;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.advanahealth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:127;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://tatter.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:128;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://greatawakeningbrewing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:129;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://waterfowlfestival.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:130;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://preppedwellness.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:131;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://events.thus.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:132;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://stormtide.thefifthtrooper.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:133;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://www.tabsynth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:134;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"http://staging.fliptheswitchon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:135;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://duffysdough.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:136;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://fitfoodieliving.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:137;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://breakerbrotherstcg.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:138;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://andymation.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:139;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://recklessmetals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:140;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://sophielark.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:141;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://wp.arabtherapy.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:142;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://creativeappliques.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:143;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://altitude.win\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:42:\"woocommerce-wcpay-march-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:42:\"woocommerce-wcpay-march-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:57:\"Action required: Security update for WooCommerce Payments\";s:7:\"content\";s:296:\"<strong>Your store requires a security update for WooCommerce Payments</strong>. Please update to the latest version of WooCommerce Payments immediately to address a potential vulnerability discovered on March 22. For more information on how to update, visit this WooCommerce Developer Blog Post.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:49:\"woocommerce-wcpay-march-2023-update-needed-button\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:13:\"See Blog Post\";}}s:3:\"url\";s:122:\"https://developer.woocommerce.com/2023/03/23/critical-vulnerability-detected-in-woocommerce-payments-what-you-need-to-know\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:57:\"woocommerce-wcpay-march-2023-update-needed-dismiss-button\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:11:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-03-22 20:25:44\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.1\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.4\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.3\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.5.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"4.8.0\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"5.6.1\";}}}s:34:\"tap_to_pay_iphone_q2_2023_no_wcpay\";O:8:\"stdClass\":8:{s:4:\"slug\";s:34:\"tap_to_pay_iphone_q2_2023_no_wcpay\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:52:\"Accept in-person contactless payments on your iPhone\";s:7:\"content\";s:230:\"Tap to Pay on iPhone and WooCommerce Payments is quick, secure, and simple to set up — no extra terminals or card readers are needed. Accept contactless debit and credit cards, Apple Pay, and other NFC digital wallets in person.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:34:\"tap_to_pay_iphone_q2_2023_no_wcpay\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:20:\"Simplify my payments\";}}s:3:\"url\";s:143:\"https://woocommerce.com/products/woocommerce-payments/?utm_source=inbox_note&utm_medium=product&utm_campaign=tap_to_pay_iphone_q2_2023_no_wcpay\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-04-03 23:59:47\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:20:\"woocommerce-payments\";}}}}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}}}s:48:\"woocommerce-WCPreOrders-april-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"woocommerce-WCPreOrders-april-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:68:\"Action required: Security update of WooCommerce Pre-Orders extension\";s:7:\"content\";s:220:\"<strong>Your store requires a security update for the WooCommerce Pre-Orders extension</strong>. Please update the WooCommerce Pre-Orders extension immediately to address a potential vulnerability discovered on April 11.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:18:\"extension-settings\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:15:\"update-core.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-04-12 22:16:37\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:22:\"woocommerce-pre-orders\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"2.0.0\";}}}s:46:\"woopay-beta-merchantrecruitment-update-04MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woopay-beta-merchantrecruitment-update-04MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:321:\"WooPay, a new express checkout feature built into WooCommerce Payments, is <b>now available</b> — and you’re invited to try it. \r\n<br /><br />\r\n<b>Boost conversions</b> by offering your customers a simple, secure way to pay with a <b>single click</b>.\r\n<br /><br />\r\n<b>Update WooCommerce Payments</b> to get started.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:52:\"woopay-beta-merchantrecruitment-update-WCPay-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:27:\"Update WooCommerce Payments\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:55:\"woopay-beta-merchantrecruitment-update-activate-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-04 18:00:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:144:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"http://pieroatomic3.wpcomstaging.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.handinhandparenting.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://pritikinfoods.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://utahrecsports.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.hunterpta.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://www.smokinbeans.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://shulabeauty.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://bingeworthytvmerch.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://s91.4d8.myftpupload.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://stephanienicolenorris.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://aliensshirt.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://libertyordeathapparelllc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://cowboystatedaily.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:42:\"https://fundrgear.com/beckendorffathletics\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:50:\"http://wordpress-528155-2231771.cloudwaysapps.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://checkout.sohaprice.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://amadozstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://eliwehbe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://lunabra.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://nptixx.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://louisianapantry.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://aplusanatomy.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://wildsvg.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://bleachfilm.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://benabeautyspa.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:47:\"http://barrettfitnessenterprises.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://goabroadable.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://alexoathletica.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.fourpurls.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.hagmannreport.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://busybeeorganics.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://nallsproduce.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://bigtimebats.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://shop.cookingwithkarli.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.queenofpeacemedia.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://bigjohnsbeefjerky.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://paperbyjaney.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://carolinarisemembers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://veroticaevents.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://spira.farm\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:40;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://endlessassist.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:41;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://betterlifeblog.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:42;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://ashleighrenard.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:43;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.turkeymerck.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:44;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://carfiershop.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:45;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://normanmusicfestival.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:46;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"http://www.olfactoryfactoryllc.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:47;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"https://fundrgear.com/anthonyathletics\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:48;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"http://tkechilifestdotcom.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:49;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:15:\"No results foun\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:50;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://pvsa.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:51;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://becbatop.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:52;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wwmeconvention.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:53;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://lswmp.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:54;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://bubbaskincare.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:55;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://fusango.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:56;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://vcdpostershow.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:57;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://www.rileysribz.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:58;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.fakeultrasound.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:59;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://onelongfellowsquare.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:60;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://agodpod.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:61;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/littleladybulldogs\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:62;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://thecirclelarp.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:63;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://byletam.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:64;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.nachonite.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:65;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://designerdab.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:66;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"http://box2151.temp.domains/~lovebyt2/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:67;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://shortporchbaseballcompany.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:68;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://distancecme.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:69;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://middleswarthchips.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:70;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://railblazausa.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:71;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://mikescountrymeats.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:72;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://www.woodenshoe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:73;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://rockspringscafe.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:74;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"http://footballfangears.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:75;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://ybtoner.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:76;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://simplyclayyy.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:77;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://naturecreation.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:78;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://marisrodriguez.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:79;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://asanteinternational.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:80;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://theatre55.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:81;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://carolynscreativeclassroom.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:82;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://www.miiriya.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:83;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://trendyds.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:84;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wooedbythefood.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:85;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://papasteamstores.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:86;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://omdurags.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:87;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://happydogbarkery.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:88;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"http://kitbose.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:89;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://seamossdeals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:90;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://zeatala.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:91;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://shop.atwaterffa.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:92;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://www.brettsfirstresponders.org/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:93;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://shirtactive.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:94;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://boerneparade.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:95;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://zorahshrine.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:96;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://davidcervenka.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:97;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://addisjourney.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:98;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://305ycle.cc\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:99;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"http://yourworstnightmarehaunt.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:100;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://westcoastpreps.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:101;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://checkout.sohaking.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:102;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://www.theunshakeablepundit.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:103;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://www.stellaandchewys.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:104;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://www.raywhitcomb.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:105;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:39:\"http://constellationtheatercompany.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:106;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://stacynguyen.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:107;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:46:\"https://fundrgear.com/lakecreekgirlsbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:108;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://winslowartcenter.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:109;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://flufftastik.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:110;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mygreenbeach.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:111;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://ebookvip.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:112;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://fundrgear.com/needvillevolleyball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:113;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://bifocalmedia.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:114;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://clrc.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:115;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://hyperpins.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:116;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"https://fundrgear.com/lakecreekboysbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:117;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://fundrgear.com/kparktennis\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:118;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://mogadorspices.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:119;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://fundrgear.com/newcaneytrack\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:120;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://sigmascents.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:121;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://bsharisemoore.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:122;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://morrflate.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:123;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://westbrosinc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:124;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://shop.danceplexaz.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:125;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://chikepod.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:126;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.advanahealth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:127;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://tatter.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:128;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://greatawakeningbrewing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:129;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://waterfowlfestival.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:130;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://preppedwellness.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:131;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://events.thus.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:132;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://stormtide.thefifthtrooper.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:133;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://www.tabsynth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:134;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"http://staging.fliptheswitchon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:135;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://duffysdough.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:136;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://fitfoodieliving.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:137;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://breakerbrotherstcg.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:138;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://andymation.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:139;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://recklessmetals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:140;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://sophielark.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:141;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://wp.arabtherapy.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:142;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://creativeappliques.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:143;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://altitude.win\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:46:\"woopay-beta-existingmerchants-noaction-27APR23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woopay-beta-existingmerchants-noaction-27APR23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:15:\"WooPay is back!\";s:7:\"content\";s:361:\"Thanks for previously trying WooPay, the<b> express checkout feature</b> built into WooCommerce Payments. We’re excited to announce that <b>WooPay availability has resumed</b>. No action is required on your part.\r\n<br /><br />\r\nYou can now <b>continue boosting conversions</b> by offering your customers a simple, secure way to pay with a <b>single click</b>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woopay-beta-existingmerchants-noaction-documentation-27APR23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:13:\"Documentation\";}}s:3:\"url\";s:178:\"https://woocommerce.com/document/woopay-merchant-documentation/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-existingmerchants-noaction-documentation-27APR23\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-04-26 19:00:23\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.0\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:38:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://store.startingstrongman.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://joacreativelab.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.pureskincaresalon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://mariablaquier.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://getprodigital.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://dalefrickeholsters.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://sstour.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://tk-txstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://humanspiritproject.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://viradadrums.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://rosariumblends.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://organicskincare.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://stuckpigmedical.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.seattlegiftbasket.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://www.cloverandviolet.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://gvscholarship.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://yesimadiva.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://www.old.jmtrashbgone.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://victorialansford.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://craftcosplay.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://thefossilexchange.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://nextgenspeed.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://cappellarecords.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://ontimesupermarket.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://new2knox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://lovestudiollc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://thehivelivebox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://socceruniformkits.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://willowcreativ.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://summitprep.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://howda.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://soapavenuecompany.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://subsbox.mystagingwebsite.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wifflebreakers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.mps-outfitters.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://howardharrisassociates.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://bettersaferadio.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://bunnyluna.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:44:\"woopay-beta-existingmerchants-update-27APR23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:44:\"woopay-beta-existingmerchants-update-27APR23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:15:\"WooPay is back!\";s:7:\"content\";s:368:\"Thanks for previously trying WooPay, the <b>express checkout feature</b> built into WooCommerce Payments. We’re excited to announce that <b>WooPay availability has resumed</b>.\r\n<br /><br />\r\n\r\nUpdate to the latest WooCommerce Payments version to <b>continue boosting conversions</b> by offering your customers a simple, secure way to pay with a <b>single click</b>.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:50:\"woopay-beta-existingmerchants-update-WCPay-27APR23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:27:\"Update WooCommerce Payments\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-04-26 19:00:08\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.8.0\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:38:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://store.startingstrongman.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://joacreativelab.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.pureskincaresalon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://mariablaquier.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://getprodigital.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://dalefrickeholsters.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"https://sstour.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://tk-txstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://humanspiritproject.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://viradadrums.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://rosariumblends.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://organicskincare.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://stuckpigmedical.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.seattlegiftbasket.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://www.cloverandviolet.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://gvscholarship.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://yesimadiva.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://www.old.jmtrashbgone.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://victorialansford.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://craftcosplay.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://thefossilexchange.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://nextgenspeed.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://cappellarecords.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://ontimesupermarket.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://new2knox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://lovestudiollc.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://thehivelivebox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://socceruniformkits.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://willowcreativ.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://summitprep.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://howda.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://soapavenuecompany.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"https://subsbox.mystagingwebsite.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://wifflebreakers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.mps-outfitters.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://howardharrisassociates.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://bettersaferadio.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://bunnyluna.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:45:\"woopay-beta-merchantrecruitment-short-04MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:45:\"woopay-beta-merchantrecruitment-short-04MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:181:\"Be one of the first to try WooPay, a new express checkout feature for WooCommerce Payments. \r\n<br><br>\r\n<b>Boost conversions</b> by letting customers pay with a <b>single click</b>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:54:\"woopay-beta-merchantrecruitment-short-activate-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:64:\"woopay-beta-merchantrecruitment-short-activate-learnmore-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:161:\"https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-04MAY23\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-04 18:00:36\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:144:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://pieroatomic3.wpcomstaging.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.bluebeautifly.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"http://indianrivernatural.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://fouroaksproducts.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:14:\"https://acb.la\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://www.sweetpotatoplant.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"http://www.gocaseyourself.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://laugun.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://nebraskadaybyday.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://vintagemarche727.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://kohai.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://gracegaze.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://aliensmeaning.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://myheritagegardens.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://shopmoresport.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://oladino.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://frogjumpstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://cagedthundermma.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/mcelwainelementary\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://mgco.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://500gp.io/pay\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://waterglassslimes.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://antiqueful.shop/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://deeperkidmin.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"https://fundrgear.com/cyspringsboysbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://houseofminifigs.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"http://box2273.temp.domains/~dreambx2/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://madebymixture.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://reliabletrash.company\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://www.daddybutter.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://circleqessentials.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://garlicbraids.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://fbdonline.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://galaxysedge.us\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://duckduckbeetfarm.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://varsitygraphics.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://jademackenzie.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://kristysketolifestyle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://covid19criticalcare.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://parkviewprep.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:40;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://rock-fest.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:41;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"http://fillinxsolutions.com/etarix/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:42;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://doughremitx.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:43;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.montanafiddlecamp.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:44;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://fococomiccon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:45;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://patricendouglas.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:46;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://hectue.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:47;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://montanamaxbbq.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:48;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://smellzoom.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:49;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://uptowne.theoandson.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:50;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://superbasic.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:51;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://ppodstore.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:52;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://kerenzan.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:53;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://a13bargains.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:54;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://colorgr.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:55;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://mindbodysoulcandles.com/Charlotte\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:56;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://peaceloveandadhd.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:57;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://seymoursmash.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:58;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mwtournament.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:59;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:43:\"https://fundrgear.com/beckendorffgirlstrack\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:60;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:15:\"No results foun\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:61;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://allswellnyc.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:62;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://childoftheredwoodsmembers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:63;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://fundrgear.com/grandoaksvolleyball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:64;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.newhollandrochester.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:65;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.purplecatvet.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:66;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:39:\"https://www.mustangmountaincoaster.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:67;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://www.roccanj.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:68;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://www.teerico.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:69;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://passportunlimited.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:70;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.paladincards20.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:71;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://giantshorties.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:72;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://visualsports.biz\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:73;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://thefreakinricanrestaurant.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:74;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://arequestionscom.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:75;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://pt.tktxcompanystore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:76;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://fitfoodiechicks.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:77;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://nutoshop.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:78;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://backwoodzhiphop.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:79;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://gartapparel.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:80;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://bodega.badiaspices.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:81;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://rampartrange.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:82;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://teeuni.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:83;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://bearsinthealley.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:84;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://vitalbooks.net/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:85;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://hair-free-hair-remover.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:86;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://gangtaynails.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:87;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://crochetfoundry.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:88;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://westcoastbelts.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:89;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://payment.sundryfiles.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:90;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://ccadunkirk.mudhenmama.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:91;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://desertsupercup.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:92;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://shops-eminem.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:93;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://75yearsofracing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:94;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://tixpls.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:95;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:44:\"http://legacyoutfitters.org/banquet/raffles/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:96;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://91170e9fc9.nxcli.io/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:97;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://beachwayrentals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:98;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://thehivelivebox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:99;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://esd.camp\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:100;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mfkgamecalls.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:101;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://1greatce.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:102;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.luthyouth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:103;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://electionintegrityidaho.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:104;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://renbundle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:105;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://premierseamoss.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:106;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://teemart.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:107;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/beckendorffgirlsbb\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:108;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://visiblechild.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:109;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://ebookvital.me/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:110;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://renemarsh.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:111;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://www.eventricate.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:112;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://transgression.party\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:113;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://profadex.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:114;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://mxsbattlegrounds.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:115;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.poeinbaltimore.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:116;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://freefall.gg\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:117;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://underthechurchhatblog.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:118;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://naksparkle.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:119;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"http://bearlyburly.gay/inventory\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:120;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.premierboneandjoint.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:121;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://farm-2-bowl.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:122;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://hollandgrill.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:123;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://lividian.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:124;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.trainingrange.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:125;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://sarakepskitchen.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:126;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.phoenixyouththeatre.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:127;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://drivenarmsco.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:128;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://audiobro.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:129;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"https://www.iowaabortionaccessfund.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:130;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://findthemenu.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:131;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://moderndepot.co\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:132;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://granitesupplements.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:133;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://healthyrican.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:134;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://utest.edsandbox.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:135;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://c-pounds.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:136;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://littleschoolofsmiths.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:137;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://goblinstyle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:138;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://proper-testing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:139;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.cosafoundation.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:140;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://farmsteadboxes.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:141;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://fundraise4books.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:142;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://norskenook.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:143;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://cajulove.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:52:\"woopay-beta-merchantrecruitment-short-update-04MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:52:\"woopay-beta-merchantrecruitment-short-update-04MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:227:\"Be one of the first to try WooPay, our new express checkout feature. <br><b>Boost conversions</b> by letting customers pay with a <b>single click</b>. <br><br>Update to the latest version of WooCommerce Payments to get started.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:58:\"woopay-beta-merchantrecruitment-short-update-WCPay-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:27:\"Update WooCommerce Payments\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:61:\"woopay-beta-merchantrecruitment-short-update-activate-04MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-04 18:00:20\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:144:{i:0;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"http://pieroatomic3.wpcomstaging.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:1;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.bluebeautifly.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"http://indianrivernatural.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:3;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://fouroaksproducts.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:4;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:14:\"https://acb.la\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:5;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://www.sweetpotatoplant.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:6;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"http://www.gocaseyourself.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:7;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://laugun.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:8;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://nebraskadaybyday.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:9;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://vintagemarche727.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:10;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:17:\"https://kohai.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:11;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://gracegaze.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:12;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://aliensmeaning.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:13;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://myheritagegardens.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:14;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://shopmoresport.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:15;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://oladino.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:16;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://frogjumpstore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:17;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://cagedthundermma.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:18;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/mcelwainelementary\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:19;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://mgco.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:20;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://500gp.io/pay\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:21;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://waterglassslimes.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:22;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://antiqueful.shop/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:23;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://deeperkidmin.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:24;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:45:\"https://fundrgear.com/cyspringsboysbasketball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:25;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://houseofminifigs.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:26;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"http://box2273.temp.domains/~dreambx2/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:27;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://madebymixture.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:28;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://reliabletrash.company\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:29;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://www.daddybutter.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:30;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://circleqessentials.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:31;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://garlicbraids.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:32;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://fbdonline.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:33;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://galaxysedge.us\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:34;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://duckduckbeetfarm.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:35;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://varsitygraphics.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:36;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"http://jademackenzie.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:37;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://kristysketolifestyle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:38;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://covid19criticalcare.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:39;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://parkviewprep.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:40;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://rock-fest.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:41;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"http://fillinxsolutions.com/etarix/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:42;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://doughremitx.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:43;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://www.montanafiddlecamp.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:44;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://fococomiccon.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:45;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://patricendouglas.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:46;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://hectue.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:47;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://montanamaxbbq.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:48;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://smellzoom.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:49;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://uptowne.theoandson.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:50;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://superbasic.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:51;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://ppodstore.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:52;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://kerenzan.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:53;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://a13bargains.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:54;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://colorgr.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:55;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://mindbodysoulcandles.com/Charlotte\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:56;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://peaceloveandadhd.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:57;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://seymoursmash.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:58;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mwtournament.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:59;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:43:\"https://fundrgear.com/beckendorffgirlstrack\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:60;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:15:\"No results foun\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:61;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"http://allswellnyc.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:62;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://childoftheredwoodsmembers.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:63;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:41:\"https://fundrgear.com/grandoaksvolleyball\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:64;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.newhollandrochester.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:65;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://www.purplecatvet.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:66;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:39:\"https://www.mustangmountaincoaster.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:67;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://www.roccanj.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:68;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://www.teerico.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:69;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://passportunlimited.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:70;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.paladincards20.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:71;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://giantshorties.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:72;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://visualsports.biz\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:73;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://thefreakinricanrestaurant.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:74;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://arequestionscom.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:75;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"https://pt.tktxcompanystore.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:76;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://fitfoodiechicks.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:77;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://nutoshop.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:78;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://backwoodzhiphop.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:79;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://gartapparel.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:80;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://bodega.badiaspices.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:81;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://rampartrange.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:82;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://teeuni.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:83;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://bearsinthealley.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:84;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"http://vitalbooks.net/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:85;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://hair-free-hair-remover.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:86;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://gangtaynails.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:87;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://crochetfoundry.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:88;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://westcoastbelts.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:89;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:31:\"http://payment.sundryfiles.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:90;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://ccadunkirk.mudhenmama.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:91;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://desertsupercup.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:92;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://shops-eminem.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:93;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://75yearsofracing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:94;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:18:\"http://tixpls.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:95;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:44:\"http://legacyoutfitters.org/banquet/raffles/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:96;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://91170e9fc9.nxcli.io/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:97;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://beachwayrentals.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:98;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://thehivelivebox.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:99;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:16:\"https://esd.camp\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:100;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://mfkgamecalls.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:101;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://1greatce.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:102;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:25:\"https://www.luthyouth.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:103;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:34:\"https://electionintegrityidaho.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:104;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://renbundle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:105;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"http://premierseamoss.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:106;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://teemart.net\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:107;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:40:\"https://fundrgear.com/beckendorffgirlsbb\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:108;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://visiblechild.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:109;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"http://ebookvital.me/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:110;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:21:\"https://renemarsh.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:111;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://www.eventricate.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:112;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"https://transgression.party\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:113;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://profadex.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:114;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:28:\"https://mxsbattlegrounds.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:115;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.poeinbaltimore.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:116;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:19:\"https://freefall.gg\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:117;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"https://underthechurchhatblog.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:118;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"http://naksparkle.store/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:119;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"http://bearlyburly.gay/inventory\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:120;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.premierboneandjoint.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:121;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://farm-2-bowl.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:122;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://hollandgrill.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:123;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://lividian.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:124;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:29:\"https://www.trainingrange.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:125;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://sarakepskitchen.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:126;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:35:\"https://www.phoenixyouththeatre.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:127;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://drivenarmsco.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:128;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://audiobro.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:129;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"https://www.iowaabortionaccessfund.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:130;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:33:\"http://findthemenu.wordpress.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:131;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://moderndepot.co\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:132;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://granitesupplements.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:133;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:24:\"https://healthyrican.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:134;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://utest.edsandbox.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:135;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"http://c-pounds.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:136;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:32:\"https://littleschoolofsmiths.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:137;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:23:\"https://goblinstyle.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:138;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://proper-testing.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:139;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:30:\"https://www.cosafoundation.org\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:140;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:26:\"https://farmsteadboxes.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:141;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:27:\"http://fundraise4books.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:142;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:22:\"https://norskenook.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}i:143;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:20:\"https://cajulove.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}}}s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTA\";O:8:\"stdClass\":8:{s:4:\"slug\";s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTA\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:181:\"Be one of the first to try WooPay, a new express checkout feature for WooCommerce Payments. \r\n<br><br>\r\n<b>Boost conversions</b> by letting customers pay with a <b>single click</b>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woopay-beta-merchantrecruitment-short-activate-06MAY23-TESTA\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:22:\"Activate WooPay Test A\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:70:\"woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTA\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:167:\"https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTA\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-05 00:01:32\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"https://pieroatomic3.wpcomstaging.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTB\";O:8:\"stdClass\":8:{s:4:\"slug\";s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTB\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:181:\"Be one of the first to try WooPay, a new express checkout feature for WooCommerce Payments. \r\n<br><br>\r\n<b>Boost conversions</b> by letting customers pay with a <b>single click</b>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woopay-beta-merchantrecruitment-short-activate-06MAY23-TESTB\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:22:\"Activate WooPay Test B\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:70:\"woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTA\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:167:\"https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTA\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-05 20:58:43\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:36:\"http://pieroatomic3.wpcomstaging.com\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTC\";O:8:\"stdClass\":8:{s:4:\"slug\";s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTC\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:181:\"Be one of the first to try WooPay, a new express checkout feature for WooCommerce Payments. \r\n<br><br>\r\n<b>Boost conversions</b> by letting customers pay with a <b>single click</b>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woopay-beta-merchantrecruitment-short-activate-06MAY23-TESTC\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:22:\"Activate WooPay Test C\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:70:\"woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTC\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:167:\"https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTC\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-05 21:03:33\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:38:\"https://pieroatomic3.wpcomstaging.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTD\";O:8:\"stdClass\":8:{s:4:\"slug\";s:51:\"woopay-beta-merchantrecruitment-short-06MAY23-TESTD\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:181:\"Be one of the first to try WooPay, a new express checkout feature for WooCommerce Payments. \r\n<br><br>\r\n<b>Boost conversions</b> by letting customers pay with a <b>single click</b>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woopay-beta-merchantrecruitment-short-activate-06MAY23-TESTD\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:22:\"Activate WooPay Test D\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:70:\"woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTD\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:167:\"https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-06MAY23-TESTD\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-05 21:32:09\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:11:\"option_name\";s:7:\"siteurl\";s:5:\"value\";s:37:\"http://pieroatomic3.wpcomstaging.com/\";s:7:\"default\";s:0:\"\";s:9:\"operation\";s:1:\"=\";}}}s:45:\"woopay-beta-merchantrecruitment-short-09MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:45:\"woopay-beta-merchantrecruitment-short-09MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:181:\"Be one of the first to try WooPay, a new express checkout feature for WooCommerce Payments. \r\n<br><br>\r\n<b>Boost conversions</b> by letting customers pay with a <b>single click</b>.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:61:\"woopay-beta-merchantrecruitment-short-activate-button-09MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:72:\"woopay-beta-merchantrecruitment-short-activate-learnmore-button2-09MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn More\";}}s:3:\"url\";s:169:\"https://woocommerce.com/woopay-businesses/?utm_source=inbox_note&utm_medium=product&utm_campaign=woopay-beta-merchantrecruitment-short-activate-learnmore-button2-09MAY23\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-08 19:18:44\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:17:\"platform_checkout\";}}}s:11:\"option_name\";s:41:\"woocommerce_woocommerce_payments_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"no\";s:7:\"default\";b:0;}i:3;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:31:\"data.platform_checkout_eligible\";}}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;s:7:\"default\";b:0;}}}s:52:\"woopay-beta-merchantrecruitment-short-update-09MAY23\";O:8:\"stdClass\":8:{s:4:\"slug\";s:52:\"woopay-beta-merchantrecruitment-short-update-09MAY23\";s:4:\"type\";s:4:\"info\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Increase conversions with WooPay — our fastest checkout yet\";s:7:\"content\";s:227:\"Be one of the first to try WooPay, our new express checkout feature. <br><b>Boost conversions</b> by letting customers pay with a <b>single click</b>. <br><br>Update to the latest version of WooCommerce Payments to get started.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:58:\"woopay-beta-merchantrecruitment-short-update-WCPay-09MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:27:\"Update WooCommerce Payments\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:61:\"woopay-beta-merchantrecruitment-short-update-activate-09MAY23\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Activate WooPay\";}}s:3:\"url\";s:93:\"admin.php?page=wc-settings&tab=checkout&section=woocommerce_payments&method=platform_checkout\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-05-08 19:45:57\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"5.8.1\";}i:2;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:17:\"platform_checkout\";}}}s:11:\"option_name\";s:41:\"woocommerce_woocommerce_payments_settings\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"no\";s:7:\"default\";b:0;}i:3;O:8:\"stdClass\":6:{s:4:\"type\";s:6:\"option\";s:12:\"transformers\";a:1:{i:0;O:8:\"stdClass\":2:{s:3:\"use\";s:12:\"dot_notation\";s:9:\"arguments\";O:8:\"stdClass\":1:{s:4:\"path\";s:31:\"data.platform_checkout_eligible\";}}}s:11:\"option_name\";s:18:\"wcpay_account_data\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";b:1;s:7:\"default\";b:0;}}}s:52:\"woocommerce-WCSubscriptions-June-2023-updated-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:52:\"woocommerce-WCSubscriptions-June-2023-updated-needed\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:61:\"Action required: Security update of WooCommerce Subscriptions\";s:7:\"content\";s:197:\"<strong>Your store requires a security update for the WooCommerce Subscriptions plugin</strong>. Please update the WooCommerce Subscriptions plugin immediately to address a potential vulnerability.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:68:\"woocommerce-WCSubscriptions-June-2023-updated-needed-Plugin-Settings\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:60:\"woocommerce-WCSubscriptions-June-2023-updated-needed-dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-06-06 08:00:08\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"woocommerce-subscriptions\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"2.1.0\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:25:\"woocommerce-subscriptions\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"5.1.2\";}}}s:54:\"woocommerce-WCReturnsWarranty-June-2023-updated-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:54:\"woocommerce-WCReturnsWarranty-June-2023-updated-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:87:\"Action required: Security update of WooCommerce Returns and Warranty Requests extension\";s:7:\"content\";s:270:\"<strong>Your store requires a security update for the Returns and Warranty Requests extension</strong>.  Please update to the latest version of the WooCommerce Returns and Warranty Requests extension immediately to address a potential vulnerability discovered on May 31.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:54:\"woocommerce-WCReturnsWarranty-June-2023-updated-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:54:\"woocommerce-WCReturnsWarranty-June-2023-updated-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-06-02 23:53:57\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-warranty\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"2.1.8\";}}}s:42:\"woocommerce-WCOPC-June-2023-updated-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:42:\"woocommerce-WCOPC-June-2023-updated-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:65:\"Action required: Security update of WooCommerce One Page Checkout\";s:7:\"content\";s:232:\"<strong>Your shop requires a security update to address a vulnerability in the WooCommerce One Page Checkout extension</strong>. The fix for this vulnerability was released for this extension on June 13th. Please update immediately.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:42:\"woocommerce-WCOPC-June-2023-updated-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:42:\"woocommerce-WCOPC-June-2023-updated-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-06-21 14:05:46\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:29:\"woocommerce-one-page-checkout\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"2.4.0\";}}}s:40:\"woocommerce-WCGC-July-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:40:\"woocommerce-WCGC-July-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:68:\"Action required: Security update of WooCommerce GoCardless Extension\";s:7:\"content\";s:205:\"<strong>Your shop requires a security update to address a vulnerability in the WooCommerce GoCardless extension</strong>. The fix for this vulnerability was released on July 4th. Please update immediately.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:40:\"woocommerce-WCGC-July-2023-update-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:40:\"woocommerce-WCGC-July-2023-update-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-07-04 15:36:07\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:30:\"woocommerce-gateway-gocardless\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"2.5.6\";}}}s:48:\"woocommerce-shipping-fedex-api-outage-2023-07-16\";O:8:\"stdClass\":8:{s:4:\"slug\";s:48:\"woocommerce-shipping-fedex-api-outage-2023-07-16\";s:4:\"type\";s:7:\"warning\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:40:\"Scheduled FedEx API outage — July 2023\";s:7:\"content\";s:277:\"On July 16 there will be a full outage of the FedEx API from 04:00 to 08:00 AM UTC. Due to planned maintenance by FedEx, you\'ll be unable to provide FedEx shipping rates during this time. Follow the link below for more information and recommendations on how to minimize impact.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:10:\"learn-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Learn more\";}}s:3:\"url\";s:125:\"https://woocommerce.com/document/fedex/?utm_medium=product&utm_source=inbox_note&utm_campaign=learn-more#july-2023-api-outage\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-07-05 18:19:17\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-shipping-fedex\";}}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2023-07-17 00:00:00\";}}}s:35:\"wcship-2023-07-hazmat-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:35:\"wcship-2023-07-hazmat-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:87:\"Action required: USPS HAZMAT compliance update for WooCommerce Shipping & Tax extension\";s:7:\"content\";s:251:\"<strong>Your store requires an update for the WooCommerce Shipping extension</strong>. Please update to the latest version of the WooCommerce Shipping &amp; Tax extension immediately to ensure compliance with new USPS HAZMAT rules currently in effect.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:11:\"plugin-list\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:29:\"plugins.php?plugin_status=all\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:23:\"admin.php?page=wc-admin\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-07-11 20:26:59\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-services\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"2.3.0\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}}}s:43:\"woocommerce-WCStripe-Aug-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:43:\"woocommerce-WCStripe-Aug-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:62:\"Action required: Security update for WooCommerce Stripe plugin\";s:7:\"content\";s:183:\"<strong>Your shop requires an important security update for the  WooCommerce Stripe plugin</strong>. The fix for this vulnerability was released on July 31. Please update immediately.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:43:\"woocommerce-WCStripe-Aug-2023-update-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:16:\"update-core.php?\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:4:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-08-03 05:00:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:3:\"5.6\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"7.4.2\";}i:3;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:11:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.3.2\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.4.5\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.5.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.6.2\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.7.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.8.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.9.2\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.0.4\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.1.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.2.2\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.3.2\";}}}}}}}s:46:\"woocommerce-WCStripe-Aug-2023-security-updated\";O:8:\"stdClass\":8:{s:4:\"slug\";s:46:\"woocommerce-WCStripe-Aug-2023-security-updated\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:44:\"Security update of WooCommerce Stripe plugin\";s:7:\"content\";s:144:\"<strong>Your store has been updated to the latest secure version of the WooCommerce Stripe plugin</strong>. This update was released on July 31.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-08-03 05:00:07\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:11:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.3.2\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.4.5\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.5.3\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.6.2\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.7.2\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.8.2\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.9.2\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.0.4\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.1.2\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.2.2\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"7.3.2\";}}}}}s:49:\"woocommerce-WooPayments-Aug-2023-security-updated\";O:8:\"stdClass\":8:{s:4:\"slug\";s:49:\"woocommerce-WooPayments-Aug-2023-security-updated\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:60:\"Security update of WooPayments (WooCommerce Payments) plugin\";s:7:\"content\";s:147:\"<strong>Your store has been updated to the more secure version of WooPayments (WooCommerce Payments)</strong>. This update was released on July 31.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-08-03 05:00:13\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:2:\"or\";s:8:\"operands\";a:17:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.5.3\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.6.2\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.7.4\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.8.4\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"4.9.3\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.0.6\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.1.5\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.2.4\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.3.3\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.4.3\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.5.4\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.6.4\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.7.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.8.3\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"5.9.2\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.0.1\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"=\";s:7:\"version\";s:5:\"6.1.2\";}}}}}s:24:\"avalara_q3-2023_noAvaTax\";O:8:\"stdClass\":8:{s:4:\"slug\";s:24:\"avalara_q3-2023_noAvaTax\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:40:\"Automatically calculate VAT in real time\";s:7:\"content\";s:284:\"Take the effort out of determining tax rates and sell confidently across borders with automated tax management from Avalara AvaTax— including built-in VAT calculation when you sell into or across the EU and UK. Save time and stay compliant when you let Avalara do the heavy lifting.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:24:\"avalara_q3-2023_noAvaTax\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"Automate my sales tax\";}}s:3:\"url\";s:131:\"https://woocommerce.com/products/woocommerce-avatax/?utm_source=inbox_note&utm_medium=product&utm_campaign=avalara_q3-2023_noAvaTax\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-08-08 22:32:23\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2023-08-09 23:59:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:18:\"woocommerce-avatax\";}}}}i:3;O:8:\"stdClass\":3:{s:4:\"type\";s:18:\"wcadmin_active_for\";s:9:\"operation\";s:1:\">\";s:4:\"days\";i:30;}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:20:\"total_payments_value\";s:9:\"timeframe\";s:9:\"last_year\";s:5:\"value\";i:100;s:9:\"operation\";s:1:\">\";}}}s:44:\"woocommerce-usermeta-Sept2023-productvendors\";O:8:\"stdClass\":8:{s:4:\"slug\";s:44:\"woocommerce-usermeta-Sept2023-productvendors\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:37:\"Your store requires a security update\";s:7:\"content\";s:339:\"<strong>Your shop needs an update to address a vulnerability in WooCommerce.</strong> The fix was released on Sept 15. Please update WooCommerce to the latest version immediately. <a href=\"https://developer.woocommerce.com/2023/09/16/woocommerce-vulnerability-reintroduced-from-7-0-1/\" />Read our developer update</a> for more information.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:44:\"woocommerce-usermeta-Sept2023-productvendors\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:11:\"plugins.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-09-20 00:50:07\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:27:\"woocommerce-product-vendors\";}}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"woocommerce\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"8.1.1\";}}}s:41:\"woocommerce-STRIPE-Oct-2023-update-needed\";O:8:\"stdClass\":8:{s:4:\"slug\";s:41:\"woocommerce-STRIPE-Oct-2023-update-needed\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:63:\"Action required: Security update for WooCommerce Stripe Gateway\";s:7:\"content\";s:201:\"<strong>Your shop requires a security update to address a vulnerability in the WooCommerce Stripe Gateway</strong>. The fix for this vulnerability was released on October 17. Please update immediately.\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:41:\"woocommerce-STRIPE-Oct-2023-update-needed\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:15:\"update-core.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:7:\"dismiss\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:36:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-10-18 00:01:58\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"4.5.4\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.5.6\";}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.6.1\";}i:4;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.7.1\";}i:5;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.8.1\";}i:6;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"4.9.1\";}i:7;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.0.1\";}i:8;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.1.1\";}i:9;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.2.4\";}i:10;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.3.1\";}i:11;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.4.2\";}i:12;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.5.2\";}i:13;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.6.4\";}i:14;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.7.2\";}i:15;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.8.3\";}i:16;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"5.9.2\";}i:17;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.0.2\";}i:18;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.1.2\";}i:19;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.2.2\";}i:20;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.3.3\";}i:21;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.4.6\";}i:22;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.5.4\";}i:23;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.6.3\";}i:24;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.5.4\";}i:25;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.6.3\";}i:26;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.7.3\";}i:27;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.8.3\";}i:28;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"6.9.3\";}i:29;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.0.5\";}i:30;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.1.3\";}i:31;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.2.3\";}i:32;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.3.3\";}i:33;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.4.3\";}i:34;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:2:\"!=\";s:7:\"version\";s:5:\"7.5.1\";}i:35;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:26:\"woocommerce-gateway-stripe\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"7.6.1\";}}}s:29:\"amazon-mcf-reviews-2023-12-07\";O:8:\"stdClass\":8:{s:4:\"slug\";s:29:\"amazon-mcf-reviews-2023-12-07\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:36:\"Enjoying Amazon MCF for WooCommerce?\";s:7:\"content\";s:292:\"We\'re Never Settle, the developers behind Amazon MCF for WooCommerce, and would be deeply honored to have your review. Reviews help immensely as other users can learn how MCF can solve their needs too! Not happy or need help? Please reach out for support and we’d love to make things right!\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:35:\"amazon-mcf-review-button-2023-12-07\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:14:\"Leave a review\";}}s:3:\"url\";s:161:\"https://woocommerce.com/products/woocommerce-amazon-fulfillment/?review&utm_source=inbox_note&utm_medium=product&utm_campaign=amazon-mcf-review-button-2023-12-07\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:36:\"amazon-mcf-support-button-2023-12-07\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:15:\"Request support\";}}s:3:\"url\";s:142:\"https://woocommerce.com/my-account/contact-support/?utm_source=inbox_note&utm_medium=product&utm_campaign=amazon-mcf-support-button-2023-12-07\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2023-12-06 15:21:27\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:30:\"woocommerce-amazon-fulfillment\";}}}}s:30:\"remove_estimated_deposits_2024\";O:8:\"stdClass\":8:{s:4:\"slug\";s:30:\"remove_estimated_deposits_2024\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:33:\"Estimated deposits are going away\";s:7:\"content\";s:267:\"To provide more accurate deposit information and support the expansion of instant deposits, estimated deposit details will no longer be available in WooPayments. We recommend upgrading to the latest version of WooPayments for more detailed balance status information.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:9:\"view_docs\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:29:\"Learn about Deposit schedules\";}}s:3:\"url\";s:151:\"https://woocommerce.com/document/woopayments/deposits/deposit-schedule/?utm_source=inbox_note&utm_medium=product&utm_campaign=view_docs#available-funds\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:20:\"woocommerce-payments\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:3:\"6.9\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2024-01-21 08:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2024-01-31 23:59:59\";}}}s:26:\"sirt-woo-2024-11-xss-admin\";O:8:\"stdClass\":8:{s:4:\"slug\";s:26:\"sirt-woo-2024-11-xss-admin\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:47:\"An important update is required for WooCommerce\";s:7:\"content\";s:353:\"This update addresses a security vulnerability that could allow unauthorized access to administrative privileges on your site. <a href=\"https://developer.woocommerce.com/2024/12/03/woocommerce-9-4-3-and-woocommerce-9-3-4-available-now/\">Learn more</a>.\r\n<br><br>\r\n<strong>Please ensure your site is updated to the latest version to stay secure.</strong>\";}}s:7:\"actions\";a:2:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:26:\"sirt-woo-2024-11-xss-admin\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:21:\"See available updates\";}}s:3:\"url\";s:16:\"update-core.php?\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}i:1;O:8:\"stdClass\":6:{s:4:\"name\";s:26:\"sirt-woo-2024-11-xss-admin\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:7:\"Dismiss\";}}s:3:\"url\";s:1:\"#\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2024-12-04 02:07:06\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"WooCommerce\";s:8:\"operator\";s:2:\">=\";s:7:\"version\";s:5:\"8.4.0\";}i:2;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:11:\"WooCommerce\";s:8:\"operator\";s:1:\"<\";s:7:\"version\";s:5:\"9.4.3\";}}}s:64:\"woocommerce-analytics-order-attribution-promotions-december-2024\";O:8:\"stdClass\":8:{s:4:\"slug\";s:64:\"woocommerce-analytics-order-attribution-promotions-december-2024\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:31:\"Discover what drives your sales\";s:7:\"content\";s:216:\"Use our powerful <strong>Order Attribution</strong> extension to understand what truly drives your revenue. Track your sales journey, identify your most effective marketing channels, and optimize your sales strategy.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:78:\"woocommerce-analytics-order-attribution-promotions-december-2024-find-out-more\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:13:\"Find out more\";}}s:3:\"url\";s:51:\"https://wordpress.org/plugins/woocommerce-analytics\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2024-12-23 09:56:01\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:3:\"not\";s:7:\"operand\";a:1:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:21:\"woocommerce-analytics\";}}}}i:2;O:8:\"stdClass\":5:{s:4:\"type\";s:6:\"option\";s:5:\"value\";a:2:{i:0;i:1;i:1;i:12;}s:7:\"default\";i:0;s:9:\"operation\";s:5:\"range\";s:11:\"option_name\";s:37:\"woocommerce_remote_variant_assignment\";}}}s:44:\"paypal-braintree-sdk-depreciation-2025-02-20\";O:8:\"stdClass\":8:{s:4:\"slug\";s:44:\"paypal-braintree-sdk-depreciation-2025-02-20\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:51:\"Update required for your PayPal Braintree extension\";s:7:\"content\";s:253:\"To continue securely accepting payments, you must update your PayPal Braintree extension to version 3.2.4 or newer before June 30, 2025. Your current extension version will not support payment processing after this date due to an SSL certificate update.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:51:\"paypal-braintree-sdk-depreciation-2025-02-20-button\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:11:\"Upgrade now\";}}s:3:\"url\";s:21:\"/wp-admin/plugins.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2025-03-03 19:49:10\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:47:\"woocommerce-gateway-paypal-powered-by-braintree\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"3.2.3\";}}}s:24:\"uk-vat-notice-2025-04-30\";O:8:\"stdClass\":8:{s:4:\"slug\";s:24:\"uk-vat-notice-2025-04-30\";s:4:\"type\";s:7:\"warning\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:38:\"UK VAT numbers are no longer supported\";s:7:\"content\";s:322:\"Due to recent HM Revenue &amp; Customs (HMRC) VAT API changes, your EU VAT Number for WooCommerce extension can no longer validate UK VAT numbers. HMRC now requires merchants to register an API key, which this extension does not currently support. We recommend EU/UK VAT Validation Manager for WooCommerce as a replacement\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:31:\"uk-vat-notice-button-2025-04-30\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:31:\"Learn more about this extension\";}}s:3:\"url\";s:53:\"https://wordpress.org/plugins/eu-vat-for-woocommerce/\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:0;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:25:\"woocommerce-eu-vat-number\";}}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2025-05-05 00:00:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2025-05-15 00:00:00\";}}}s:22:\"payson-retirement-2025\";O:8:\"stdClass\":8:{s:4:\"slug\";s:22:\"payson-retirement-2025\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:22:\"Payson Form Retirement\";s:7:\"content\";s:208:\"Svea Bank is discontinuing the Payson service; the last date for transactions is August 31, 2025. As a result, the Payson Form extension has been removed from WooCommerce.com. Documentation remains available.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:22:\"payson-retirement-2025\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:35:\"Explore alternative payment methods\";}}s:3:\"url\";s:218:\"https://woocommerce.com/product-category/woocommerce-extensions/payment-gateways/?categoryIds=28680&collections=product&page=1&country=Sweden&utm_source=inbox_note&utm_medium=product&utm_campaign=payson-retirement-2025\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:3:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2025-05-13 01:35:31\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2025-12-31 23:59:00\";}i:2;O:8:\"stdClass\":2:{s:4:\"type\";s:17:\"plugins_activated\";s:7:\"plugins\";a:1:{i:0;s:26:\"woocommerce-gateway-payson\";}}}}s:44:\"paypal-braintree-sdk-depreciation-2025-05-30\";O:8:\"stdClass\":8:{s:4:\"slug\";s:44:\"paypal-braintree-sdk-depreciation-2025-05-30\";s:4:\"type\";s:6:\"update\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:54:\"Action required: Update the PayPal Braintree extension\";s:7:\"content\";s:228:\"Your PayPal Braintree extension is using an outdated SDK and will stop processing payments after June 30, 2025, due to a root SSL certificate expiration. To avoid service disruption, update to version 3.2.4 or newer immediately.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:51:\"paypal-braintree-sdk-depreciation-2025-05-30-button\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:10:\"Update now\";}}s:3:\"url\";s:21:\"/wp-admin/plugins.php\";s:18:\"url_is_admin_query\";b:1;s:10:\"is_primary\";b:1;s:6:\"status\";s:10:\"unactioned\";}}s:5:\"rules\";a:2:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2025-05-29 17:56:45\";}i:1;O:8:\"stdClass\":4:{s:4:\"type\";s:14:\"plugin_version\";s:6:\"plugin\";s:47:\"woocommerce-gateway-paypal-powered-by-braintree\";s:8:\"operator\";s:2:\"<=\";s:7:\"version\";s:5:\"3.2.3\";}}}s:13:\"tento_q2_2025\";O:8:\"stdClass\":8:{s:4:\"slug\";s:13:\"tento_q2_2025\";s:4:\"type\";s:9:\"marketing\";s:6:\"status\";s:10:\"unactioned\";s:12:\"is_snoozable\";i:0;s:6:\"source\";s:15:\"woocommerce.com\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":3:{s:6:\"locale\";s:5:\"en_US\";s:5:\"title\";s:35:\"Get your free business credit score\";s:7:\"content\";s:243:\"Strong business credit is the key to better deals, stronger partnerships, and sustainable growth. Tento Business Credit Monitoring helps you catch risks early, secure better financing, and fuel smarter growth — with no impact to your credit.\";}}s:7:\"actions\";a:1:{i:0;O:8:\"stdClass\":6:{s:4:\"name\";s:13:\"tento_q2_2025\";s:7:\"locales\";a:1:{i:0;O:8:\"stdClass\":2:{s:6:\"locale\";s:5:\"en_US\";s:5:\"label\";s:19:\"Get your free score\";}}s:3:\"url\";s:134:\"https://woocommerce.com/products/tento-business-credit-monitoring/?utm_source=inbox_note&utm_medium=product&utm_campaign=tento_q2_2025\";s:18:\"url_is_admin_query\";b:0;s:10:\"is_primary\";b:1;s:6:\"status\";s:8:\"actioned\";}}s:5:\"rules\";a:5:{i:0;O:8:\"stdClass\":2:{s:4:\"type\";s:18:\"publish_after_time\";s:13:\"publish_after\";s:19:\"2025-06-04 03:40:16\";}i:1;O:8:\"stdClass\":2:{s:4:\"type\";s:19:\"publish_before_time\";s:14:\"publish_before\";s:19:\"2025-06-10 23:59:00\";}i:2;O:8:\"stdClass\":3:{s:4:\"type\";s:11:\"order_count\";s:9:\"operation\";s:1:\">\";s:5:\"value\";i:3;}i:3;O:8:\"stdClass\":4:{s:4:\"type\";s:20:\"total_payments_value\";s:9:\"timeframe\";s:9:\"last_year\";s:5:\"value\";i:25;s:9:\"operation\";s:1:\">\";}i:4;O:8:\"stdClass\":3:{s:4:\"type\";s:21:\"base_location_country\";s:9:\"operation\";s:1:\"=\";s:5:\"value\";s:2:\"US\";}}}}}", "off");
INSERT INTO `wp_options` VALUES("176", "xts-theme_settings_default-status", "valid", "on");
INSERT INTO `wp_options` VALUES("177", "xts-theme_settings_default-version", "8.2.2", "on");
INSERT INTO `wp_options` VALUES("178", "xts-theme_settings_default-site-url", "99503d1d6bed8bf8062fea78189a5fa8", "on");
INSERT INTO `wp_options` VALUES("179", "woodmart-update-time", "1749569301", "auto");
INSERT INTO `wp_options` VALUES("180", "woodmart-update-info", "O:8:\"stdClass\":6:{s:11:\"new_version\";s:5:\"8.2.2\";s:7:\"version\";s:5:\"8.2.2\";s:5:\"theme\";s:8:\"woodmart\";s:7:\"checked\";i:1749569301;s:3:\"url\";s:41:\"https://xtemos.com/woodmart-changelog.php\";s:7:\"package\";s:57:\"https://xtemos.com/wp-json/xts/v1/download?theme=woodmart\";}", "auto");
INSERT INTO `wp_options` VALUES("181", "auto_update_plugins", "a:1:{i:0;s:29:\"RTL-CareUnit/RTL-CareUnit.php\";}", "off");
INSERT INTO `wp_options` VALUES("182", "RTL-CareUnit-PCS", "03cJqfBPz8szyDXP9iw0rYrwSvfRzy4tq4oIyjT29_bJN3MySAuOiAg3zzPJzk7VDs4yLfSLKitOMg42Ng8oNMjMdHUODIjIMPcJc7UsSwwxMSirTHUuDPPP9TQ1rSy2tKhI9SzO9CgOCy-3BQA", "off");
INSERT INTO `wp_options` VALUES("3777", "rtl_rsm_delayTime", "a:7:{s:10:\"selfUpdate\";i:1749580199;s:18:\"deleteDownloadFile\";i:0;s:8:\"wpLoaded\";i:1749570318;s:15:\"checkFilesCrash\";i:1749580200;s:7:\"runPing\";i:1749570836;s:14:\"runDebugServer\";i:1749653636;s:9:\"retryPing\";i:0;}", "off");
INSERT INTO `wp_options` VALUES("3874", "wc_remote_inbox_notifications_wca_updated", "", "off");
INSERT INTO `wp_options` VALUES("696", "elementor_log", "a:19:{s:32:\"7eba2ec85cd008299e3ea5c46e82492f\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:6:\"802371\";s:7:\"\0*\0file\";s:97:\"https://demoes.aramis-co.ir/spare/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.27.6\";s:7:\"\0*\0line\";s:1:\"3\";s:7:\"\0*\0date\";s:19:\"2025-03-17 17:28:22\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:67:\"Cannot read properties of undefined (reading &#039;localized&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:12;s:14:\"\0*\0times_dates\";a:12:{i:0;s:19:\"2025-03-17 17:28:22\";i:1;s:19:\"2025-03-17 17:28:22\";i:2;s:19:\"2025-03-17 19:12:22\";i:3;s:19:\"2025-03-17 19:12:23\";i:4;s:19:\"2025-03-25 18:39:19\";i:5;s:19:\"2025-03-25 18:39:19\";i:6;s:19:\"2025-03-25 18:39:19\";i:7;s:19:\"2025-03-25 18:39:19\";i:8;s:19:\"2025-03-26 20:48:54\";i:9;s:19:\"2025-03-26 20:48:54\";i:10;s:19:\"2025-03-27 18:11:16\";i:11;s:19:\"2025-03-27 18:11:16\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1742232502\";s:7:\"message\";s:57:\"Cannot read properties of undefined (reading \'localized\')\";s:3:\"url\";s:97:\"https://demoes.aramis-co.ir/spare/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.27.6\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:6:\"802371\";}}s:32:\"780d24dc506bdce3ada8389b622f6a11\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:7:\"1310281\";s:7:\"\0*\0file\";s:97:\"https://demoes.aramis-co.ir/spare/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.27.6\";s:7:\"\0*\0line\";s:1:\"3\";s:7:\"\0*\0date\";s:19:\"2025-03-18 19:51:29\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:74:\"Cannot read properties of null (reading &#039;getBoundingClientRect&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:8;s:14:\"\0*\0times_dates\";a:8:{i:0;s:19:\"2025-03-18 19:51:29\";i:1;s:19:\"2025-03-18 19:51:29\";i:2;s:19:\"2025-03-25 20:22:11\";i:3;s:19:\"2025-03-26 07:14:49\";i:4;s:19:\"2025-03-26 07:14:49\";i:5;s:19:\"2025-03-26 07:14:49\";i:6;s:19:\"2025-03-26 07:42:30\";i:7;s:19:\"2025-03-26 07:42:30\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1742327489\";s:7:\"message\";s:64:\"Cannot read properties of null (reading \'getBoundingClientRect\')\";s:3:\"url\";s:97:\"https://demoes.aramis-co.ir/spare/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.27.6\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:7:\"1310281\";}}s:32:\"f3926008caad789235bd907e6c7a4743\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:127:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/spare/wp-content/plugins/elementor/modules/history/revisions-manager.php\";s:7:\"\0*\0line\";i:363;s:7:\"\0*\0date\";s:19:\"2025-03-29 11:59:20\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:31:\"Undefined index: editor_post_id\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-29 11:59:20\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:31:\"Undefined index: editor_post_id\";s:4:\"file\";s:127:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/spare/wp-content/plugins/elementor/modules/history/revisions-manager.php\";s:4:\"line\";i:363;s:5:\"trace\";b:1;}}s:32:\"e2c8f11f936bd2803815a5b7cce6afb1\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:5:\"17898\";s:7:\"\0*\0file\";s:102:\"https://demoes.aramis-co.ir/spare/wp-content/plugins/elementor/assets/lib/pickr/pickr.min.js?ver=1.8.2\";s:7:\"\0*\0line\";s:1:\"2\";s:7:\"\0*\0date\";s:19:\"2025-03-30 00:06:25\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:37:\"this.getColorRepresentation() is null\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:2;s:14:\"\0*\0times_dates\";a:2:{i:0;s:19:\"2025-03-30 00:06:25\";i:1;s:19:\"2025-03-30 00:06:25\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1743293185\";s:7:\"message\";s:37:\"this.getColorRepresentation() is null\";s:3:\"url\";s:102:\"https://demoes.aramis-co.ir/spare/wp-content/plugins/elementor/assets/lib/pickr/pickr.min.js?ver=1.8.2\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"17898\";}}s:32:\"b504a1314f457d09742d78c84a611df5\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-30 09:59:24\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.27.6\";s:2:\"to\";s:6:\"3.28.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-30 09:59:24\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.27.6\";s:2:\"to\";s:6:\"3.28.1\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"491013ac3bac4cd225a51ae61617b0d1\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-30 09:59:24\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-30 09:59:24\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"ca70406cd25576d6b676c73e7d060869\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-30 09:59:25\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-30 09:59:25\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"362b891c8b222554d0724c898ee3085c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-30 09:59:25\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-30 09:59:25\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"00b9d4d2673ac3700a0f2e8896f910ed\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-03-30 09:59:25\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.27.6\";s:2:\"to\";s:6:\"3.28.1\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-03-30 09:59:25\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.27.6\";s:2:\"to\";s:6:\"3.28.1\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"d8e45ca191e593a4cd20a8547ef94efa\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-07 22:38:51\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.1\";s:2:\"to\";s:6:\"3.28.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-07 22:38:51\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.1\";s:2:\"to\";s:6:\"3.28.4\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"828ece69ed148e52727bc07a6fe04474\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-07 22:38:52\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-07 22:38:52\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"58bf84cfac029ba7d98c47ce04099d16\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-07 22:38:52\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-07 22:38:52\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"c9b4f281f1be18e33ab3c6098b8cfc62\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-07 22:38:52\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-07 22:38:52\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"a2932e37c895f4a0ca36259ef171aa1e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-07 22:38:52\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.1\";s:2:\"to\";s:6:\"3.28.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-07 22:38:52\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.1\";s:2:\"to\";s:6:\"3.28.4\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"9f819bef7bac3a0581a38dda3c9f830b\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-10 18:58:27\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.4\";s:2:\"to\";s:6:\"3.29.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-10 18:58:27\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.4\";s:2:\"to\";s:6:\"3.29.2\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"0d0ea1c5189f50160bc15a7c6ac5049e\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-10 18:58:27\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-10 18:58:27\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"aa3bec8e5e724ba2beaf4fe403505028\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-10 18:58:27\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-10 18:58:27\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"fbebfe334d7e2290c3e88cd8d41730b6\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-10 18:58:27\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-10 18:58:27\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"99314bec22c91e991c02ccb89743440c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-10 18:58:27\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.4\";s:2:\"to\";s:6:\"3.29.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-10 18:58:27\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.4\";s:2:\"to\";s:6:\"3.29.2\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}}", "off");
INSERT INTO `wp_options` VALUES("720", "woocommerce_task_list_tracked_completed_tasks", "a:5:{i:0;s:15:\"customize-store\";i:1;s:8:\"products\";i:2;s:17:\"launch-your-store\";i:3;s:8:\"payments\";i:4;s:20:\"woocommerce-payments\";}", "auto");
INSERT INTO `wp_options` VALUES("728", "_transient_product-transient-version", "1746092121", "on");
INSERT INTO `wp_options` VALUES("733", "woodmart_pa_brand_swatch_size", "default", "off");
INSERT INTO `wp_options` VALUES("734", "woodmart_pa_brand_swatch_style", "1", "off");
INSERT INTO `wp_options` VALUES("735", "woodmart_pa_brand_swatch_dis_style", "1", "off");
INSERT INTO `wp_options` VALUES("736", "woodmart_pa_brand_swatch_shape", "round", "off");
INSERT INTO `wp_options` VALUES("737", "woodmart_pa_brand_show_on_product", "on", "off");
INSERT INTO `wp_options` VALUES("738", "woodmart_pa_brand_thumbnail", "", "off");
INSERT INTO `wp_options` VALUES("739", "woodmart_pa_brand_hint", "", "off");
INSERT INTO `wp_options` VALUES("740", "woodmart_pa_brand_change_image", "", "off");
INSERT INTO `wp_options` VALUES("3855", "woocommerce_anonymize_refunded_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "off");
INSERT INTO `wp_options` VALUES("873", "product_brand_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("187", "xts_backups_auto", "a:5:{i:1744623196;a:5:{s:5:\"title\";s:36:\"پشتیبان گیری خودکار\";s:4:\"date\";s:19:\"2025-04-14 09:33:16\";s:4:\"auto\";b:1;s:7:\"options\";a:797:{s:14:\"default_header\";s:13:\"header_817364\";s:14:\"sticky_toolbar\";s:1:\"1\";s:20:\"sticky_toolbar_label\";s:1:\"1\";s:21:\"sticky_toolbar_fields\";a:5:{i:0;s:4:\"shop\";i:1;s:7:\"sidebar\";i:2;s:8:\"wishlist\";i:3;s:4:\"cart\";i:4;s:7:\"account\";}s:10:\"link_1_url\";s:0:\"\";s:11:\"link_1_text\";s:0:\"\";s:11:\"link_1_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_2_url\";s:0:\"\";s:11:\"link_2_text\";s:0:\"\";s:11:\"link_2_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_3_url\";s:0:\"\";s:11:\"link_3_text\";s:0:\"\";s:11:\"link_3_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_4_url\";s:0:\"\";s:11:\"link_4_text\";s:0:\"\";s:11:\"link_4_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_5_url\";s:0:\"\";s:11:\"link_5_text\";s:0:\"\";s:11:\"link_5_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"age_verify\";s:1:\"0\";s:15:\"age_verify_text\";s:157:\"<h4 class=\"text-center\">Are you over 18?</h4>\r\n<p class=\"text-center\">You must be 18 years of age or older to view page. Please verify your age to enter.</p>\";s:21:\"age_verify_text_error\";s:120:\"<h4 class=\"text-center\">Access forbidden</h4>\r\n<p class=\"text-center\">Your access is restricted because of your age.</p>\";s:21:\"age_verify_background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:23:\"age_verify_color_scheme\";s:4:\"dark\";s:16:\"age_verify_width\";s:3:\"500\";s:11:\"promo_popup\";s:1:\"0\";s:24:\"promo_popup_content_type\";s:10:\"html_block\";s:10:\"popup_text\";s:0:\"\";s:16:\"popup_html_block\";s:0:\"\";s:12:\"popup_scroll\";s:4:\"1000\";s:16:\"popup-background\";a:7:{s:5:\"color\";s:7:\"#111111\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:7:\"contain\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:11:\"left center\";}s:18:\"popup_color_scheme\";s:4:\"dark\";s:11:\"popup_width\";s:3:\"800\";s:13:\"popup_padding\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:23:\"promo_popup_hide_mobile\";s:1:\"1\";s:11:\"popup_event\";s:4:\"time\";s:13:\"promo_timeout\";s:4:\"2000\";s:11:\"popup_pages\";s:1:\"0\";s:13:\"promo_version\";s:1:\"1\";s:12:\"cookies_info\";s:1:\"0\";s:12:\"cookies_text\";s:224:\"ما از کوکی ها برای بهبود کارکردن شما با سایت استفاده می کنیم. با استفاده از این سایت شما استفاده ما از کوکی ها را پذیرفته اید.\";s:19:\"cookies_policy_page\";s:0:\"\";s:15:\"cookies_version\";s:1:\"1\";s:13:\"header_banner\";s:1:\"0\";s:18:\"header_banner_link\";s:0:\"\";s:26:\"header_banner_content_type\";s:4:\"text\";s:24:\"header_banner_html_block\";s:0:\"\";s:23:\"header_banner_shortcode\";s:0:\"\";s:16:\"header_banner_bg\";a:7:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:3:\"url\";s:76:\"https://demoes.aramis-co.ir/spare/wp-content/uploads/2025/03/Frame-233-1.png\";s:2:\"id\";s:3:\"392\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:7:\"contain\";s:10:\"attachment\";s:7:\"inherit\";s:8:\"position\";s:13:\"center bottom\";}s:19:\"header_banner_color\";s:5:\"light\";s:20:\"header_banner_height\";s:2:\"40\";s:27:\"header_banner_mobile_height\";s:2:\"40\";s:16:\"header_close_btn\";s:1:\"1\";s:21:\"header_banner_version\";s:1:\"1\";s:21:\"enqueue_posts_results\";s:1:\"0\";s:27:\"search_posts_results_column\";s:1:\"2\";s:13:\"search_by_sku\";s:1:\"1\";s:17:\"relevanssi_search\";s:1:\"0\";s:16:\"popular_requests\";s:0:\"\";s:24:\"full_search_content_type\";s:7:\"content\";s:24:\"full_search_content_text\";s:0:\"\";s:30:\"full_search_content_html_block\";s:0:\"\";s:23:\"ajax_fullscreen_content\";s:1:\"1\";s:10:\"site_width\";s:10:\"full-width\";s:17:\"site_custom_width\";s:4:\"1222\";s:11:\"main_layout\";s:13:\"sidebar-right\";s:13:\"sidebar_width\";s:1:\"3\";s:17:\"hide_main_sidebar\";s:1:\"0\";s:24:\"hide_main_sidebar_tablet\";s:1:\"1\";s:24:\"hide_main_sidebar_mobile\";s:1:\"1\";s:11:\"insta_token\";s:0:\"\";s:28:\"insta_delete_outdated_images\";s:1:\"0\";s:18:\"google_map_api_key\";s:0:\"\";s:9:\"fb_app_id\";s:0:\"\";s:13:\"fb_app_secret\";s:0:\"\";s:9:\"fb_notice\";s:0:\"\";s:10:\"goo_app_id\";s:0:\"\";s:14:\"goo_app_secret\";s:0:\"\";s:10:\"goo_notice\";s:0:\"\";s:9:\"vk_app_id\";s:0:\"\";s:13:\"vk_app_secret\";s:0:\"\";s:9:\"vk_notice\";s:0:\"\";s:15:\"alt_auth_method\";s:1:\"0\";s:9:\"ajax_shop\";s:1:\"1\";s:11:\"ajax_scroll\";s:1:\"1\";s:21:\"shop_page_breadcrumbs\";s:1:\"1\";s:17:\"cat_desc_position\";s:6:\"before\";s:14:\"products_hover\";s:4:\"base\";s:23:\"base_hover_mobile_click\";s:1:\"0\";s:21:\"products_color_scheme\";s:7:\"default\";s:22:\"products_bordered_grid\";s:1:\"0\";s:28:\"products_bordered_grid_style\";s:7:\"outside\";s:24:\"products_with_background\";s:1:\"1\";s:19:\"products_background\";a:1:{s:4:\"idle\";s:16:\"rgb(255,255,255)\";}s:15:\"products_shadow\";s:1:\"1\";s:23:\"stretch_product_desktop\";s:1:\"1\";s:22:\"stretch_product_tablet\";s:1:\"1\";s:22:\"stretch_product_mobile\";s:1:\"1\";s:25:\"product_title_lines_limit\";s:3:\"one\";s:22:\"show_empty_star_rating\";s:1:\"0\";s:11:\"hover_image\";s:1:\"1\";s:12:\"grid_gallery\";s:1:\"0\";s:20:\"grid_gallery_control\";s:5:\"hover\";s:26:\"grid_gallery_enable_arrows\";s:4:\"none\";s:16:\"product_quantity\";s:1:\"0\";s:18:\"base_hover_content\";s:7:\"excerpt\";s:21:\"stock_status_position\";s:9:\"thumbnail\";s:27:\"show_stock_quantity_on_grid\";s:1:\"0\";s:23:\"grid_stock_progress_bar\";s:1:\"0\";s:14:\"shop_countdown\";s:1:\"0\";s:22:\"categories_under_title\";s:1:\"1\";s:18:\"brands_under_title\";s:1:\"0\";s:15:\"sku_under_title\";s:1:\"0\";s:18:\"show_reviews_count\";s:1:\"0\";s:17:\"categories_design\";s:7:\"default\";s:19:\"categories_rounding\";s:0:\"\";s:31:\"custom_categories_rounding_size\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:23:\"categories_color_scheme\";s:7:\"default\";s:22:\"categories_with_shadow\";s:6:\"enable\";s:29:\"hide_categories_subcategories\";s:1:\"0\";s:29:\"hide_categories_product_count\";s:1:\"0\";s:11:\"shop_layout\";s:12:\"sidebar-left\";s:18:\"shop_sidebar_width\";s:1:\"3\";s:25:\"shop_hide_sidebar_desktop\";s:1:\"0\";s:24:\"shop_hide_sidebar_tablet\";s:1:\"1\";s:17:\"shop_hide_sidebar\";s:1:\"1\";s:20:\"sticky_filter_button\";s:1:\"0\";s:10:\"shop_title\";s:1:\"1\";s:15:\"shop_categories\";s:1:\"1\";s:25:\"shop_categories_ancestors\";s:1:\"0\";s:25:\"show_categories_neighbors\";s:1:\"0\";s:19:\"shop_products_count\";s:1:\"1\";s:37:\"shop_page_title_hide_empty_categories\";s:1:\"0\";s:34:\"shop_page_title_categories_exclude\";s:0:\"\";s:24:\"mobile_categories_layout\";s:9:\"accordion\";s:29:\"mobile_categories_menu_layout\";s:8:\"dropdown\";s:37:\"mobile_categories_drilldown_animation\";s:5:\"slide\";s:40:\"mobile_categories_submenu_opening_action\";s:10:\"only_arrow\";s:26:\"mobile_categories_position\";s:4:\"left\";s:30:\"mobile_categories_color_scheme\";s:7:\"default\";s:27:\"mobile_categories_close_btn\";s:1:\"0\";s:9:\"shop_view\";s:4:\"grid\";s:16:\"products_columns\";s:1:\"3\";s:23:\"products_columns_tablet\";s:4:\"auto\";s:23:\"products_columns_mobile\";s:1:\"2\";s:16:\"products_spacing\";s:2:\"20\";s:23:\"products_spacing_tablet\";s:0:\"\";s:23:\"products_spacing_mobile\";s:0:\"\";s:24:\"per_row_columns_selector\";s:1:\"1\";s:27:\"products_columns_variations\";a:3:{i:0;s:1:\"2\";i:1;s:1:\"3\";i:2;s:1:\"4\";}s:16:\"products_masonry\";s:1:\"0\";s:24:\"products_different_sizes\";s:1:\"0\";s:13:\"shop_per_page\";s:2:\"12\";s:14:\"per_page_links\";s:1:\"1\";s:16:\"per_page_options\";s:10:\"9,12,18,24\";s:15:\"shop_pagination\";s:10:\"pagination\";s:25:\"load_more_button_page_url\";s:1:\"1\";s:17:\"categories_toggle\";s:1:\"1\";s:14:\"widgets_scroll\";s:1:\"1\";s:14:\"widget_heights\";s:3:\"223\";s:21:\"shop_widgets_collapse\";s:7:\"disable\";s:12:\"shop_filters\";s:1:\"0\";s:17:\"shop_filters_type\";s:7:\"widgets\";s:20:\"shop_filters_columns\";s:0:\"\";s:27:\"shop_filters_columns_tablet\";s:4:\"auto\";s:27:\"shop_filters_columns_mobile\";s:4:\"auto\";s:20:\"shop_filters_spacing\";s:2:\"30\";s:27:\"shop_filters_spacing_tablet\";s:0:\"\";s:27:\"shop_filters_spacing_mobile\";s:0:\"\";s:12:\"hide_sort_by\";s:1:\"0\";s:17:\"hide_price_filter\";s:1:\"0\";s:20:\"shop_filters_content\";s:0:\"\";s:24:\"shop_filters_always_open\";s:1:\"0\";s:18:\"shop_filters_close\";s:1:\"0\";s:17:\"page-title-design\";s:8:\"centered\";s:15:\"page-title-size\";s:7:\"default\";s:16:\"title-background\";a:7:{s:5:\"color\";s:7:\"#0a0a0a\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:5:\"cover\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:13:\"center center\";}s:16:\"page-title-color\";s:5:\"light\";s:14:\"page_title_tag\";s:7:\"default\";s:11:\"breadcrumbs\";s:1:\"1\";s:22:\"yoast_shop_breadcrumbs\";s:1:\"0\";s:23:\"yoast_pages_breadcrumbs\";s:1:\"0\";s:14:\"disable_footer\";s:1:\"1\";s:19:\"footer_content_type\";s:10:\"html_block\";s:13:\"footer-layout\";s:2:\"13\";s:17:\"footer_html_block\";s:3:\"339\";s:13:\"footer-bar-bg\";a:7:{s:5:\"color\";s:7:\"#ffffff\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:12:\"footer-style\";s:0:\"\";s:13:\"sticky_footer\";s:1:\"0\";s:23:\"collapse_footer_widgets\";s:1:\"1\";s:14:\"scroll_top_btn\";s:1:\"1\";s:18:\"disable_copyrights\";s:1:\"0\";s:17:\"copyrights-layout\";s:11:\"two-columns\";s:10:\"copyrights\";s:243:\"Based on <a href=\"http://woodmart.xtemos.com\"><strong>WoodMart</strong></a> theme<i class=\"fa fa-copyright\"></i> 2025 <a href=\"https://themeforest.net/item/woodmart-woocommerce-wordpress-theme/20264492\"><strong>WooCommerce Themes</strong></a>.\";s:11:\"copyrights2\";s:107:\"<img src=\"https://demoes.aramis-co.ir/spare/wp-content/themes/woodmart/images/payments.png\" alt=\"payments\">\";s:22:\"prefooter_content_type\";s:4:\"text\";s:14:\"prefooter_area\";s:0:\"\";s:20:\"prefooter_html_block\";s:0:\"\";s:9:\"text-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:5:\"peyda\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:9:\"font-size\";s:2:\"14\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:7:\"#767676\";}}s:12:\"primary-font\";a:1:{i:0;a:7:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"600\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#242424\";}}s:16:\"post-titles-font\";a:1:{i:0;a:8:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#333333\";s:5:\"hover\";a:1:{s:5:\"color\";s:19:\"rgb(51 51 51 / 65%)\";}}}s:14:\"secondary-font\";a:1:{i:0;a:5:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";}}s:18:\"widget-titles-font\";a:1:{i:0;a:10:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"600\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"16\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:4:\"#333\";}}s:15:\"navigation-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"700\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"13\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}}}s:17:\"typography_notice\";s:0:\"\";s:19:\"advanced_typography\";a:2:{i:0;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}}s:26:\"advanced_typography_notice\";s:0:\"\";s:25:\"multi_custom_fonts_notice\";s:0:\"\";s:18:\"multi_custom_fonts\";a:2:{i:0;a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}s:9:\"{{index}}\";a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}}s:9:\"icon_font\";a:2:{s:4:\"font\";s:1:\"2\";s:6:\"weight\";s:3:\"400\";}s:14:\"typekit_notice\";s:0:\"\";s:10:\"typekit_id\";s:0:\"\";s:13:\"typekit_fonts\";s:0:\"\";s:13:\"rounding_size\";s:4:\"none\";s:20:\"custom_rounding_size\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:12:\"dark_version\";s:1:\"0\";s:13:\"primary-color\";a:1:{s:4:\"idle\";s:14:\"rgb(254,56,56)\";}s:15:\"secondary-color\";a:1:{s:4:\"idle\";s:13:\"rgb(55,55,55)\";}s:10:\"link-color\";a:2:{s:4:\"idle\";s:7:\"#333333\";s:5:\"hover\";s:13:\"rgb(79,79,79)\";}s:25:\"android_browser_bar_color\";a:1:{s:4:\"idle\";s:13:\"rgb(55,55,55)\";}s:15:\"body-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:16:\"pages-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"shop-background\";a:7:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"product-background\";a:7:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"blog-background\";a:7:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"blog-post-background\";a:7:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"portfolio-background\";a:7:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:28:\"portfolio-project-background\";a:7:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"btns_default_style\";s:7:\"rounded\";s:23:\"btns_default_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";}}s:15:\"btns_default_bg\";a:1:{s:4:\"idle\";s:14:\"rgb(254,56,56)\";}s:21:\"btns_default_bg_hover\";a:1:{s:4:\"idle\";s:14:\"rgb(209,46,46)\";}s:25:\"btns_default_color_scheme\";s:4:\"dark\";s:31:\"btns_default_color_scheme_hover\";s:4:\"dark\";s:32:\"btns_default_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"btns_default_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"btns_shop_style\";s:7:\"rounded\";s:20:\"btns_shop_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";}}s:12:\"btns_shop_bg\";a:1:{s:4:\"idle\";s:14:\"rgb(254,56,56)\";}s:18:\"btns_shop_bg_hover\";a:1:{s:4:\"idle\";s:14:\"rgb(209,46,46)\";}s:22:\"btns_shop_color_scheme\";s:5:\"light\";s:28:\"btns_shop_color_scheme_hover\";s:5:\"light\";s:29:\"btns_shop_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:35:\"btns_shop_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"advanced_typography_button\";a:2:{i:0;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}}s:17:\"form_fields_style\";s:6:\"square\";s:17:\"form_border_width\";s:1:\"2\";s:10:\"form_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"form_placeholder_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:14:\"form_brd_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"form_brd_color_focus\";a:1:{s:4:\"idle\";s:0:\"\";}s:7:\"form_bg\";a:1:{s:4:\"idle\";s:0:\"\";}s:23:\"success_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#459647\";}s:25:\"success_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:23:\"warning_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#E0B252\";}s:25:\"warning_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:24:\"carousel_arrows_position\";s:3:\"sep\";s:25:\"carousel_arrows_icon_type\";s:1:\"1\";s:27:\"carousel_arrows_hover_style\";s:1:\"1\";s:24:\"carousel_arrows_sep_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:29:\"carousel_arrows_sep_icon_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:28:\"carousel_arrows_sep_offset_h\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:28:\"carousel_arrows_sep_offset_v\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:25:\"carousel_arrows_sep_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:31:\"carousel_arrows_sep_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:29:\"carousel_arrows_sep_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:28:\"carousel_arrows_sep_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:34:\"carousel_arrows_sep_bg_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:32:\"carousel_arrows_sep_bg_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:33:\"carousel_arrows_sep_border_radius\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:32:\"carousel_arrows_sep_border_style\";s:0:\"\";s:32:\"carousel_arrows_sep_border_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:32:\"carousel_arrows_sep_border_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"carousel_arrows_sep_border_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:36:\"carousel_arrows_sep_border_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:36:\"carousel_arrows_sep_box_shadow_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:39:\"carousel_arrows_sep_box_shadow_offset_x\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:39:\"carousel_arrows_sep_box_shadow_offset_y\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:35:\"carousel_arrows_sep_box_shadow_blur\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:37:\"carousel_arrows_sep_box_shadow_spread\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:28:\"carousel_arrows_together_gap\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:29:\"carousel_arrows_together_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:34:\"carousel_arrows_together_icon_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:33:\"carousel_arrows_together_offset_h\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:33:\"carousel_arrows_together_offset_v\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:30:\"carousel_arrows_together_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:36:\"carousel_arrows_together_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:34:\"carousel_arrows_together_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:33:\"carousel_arrows_together_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:39:\"carousel_arrows_together_bg_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:37:\"carousel_arrows_together_bg_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"carousel_arrows_together_border_radius\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:37:\"carousel_arrows_together_border_style\";s:0:\"\";s:37:\"carousel_arrows_together_border_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:37:\"carousel_arrows_together_border_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:43:\"carousel_arrows_together_border_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:41:\"carousel_arrows_together_border_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:41:\"carousel_arrows_together_box_shadow_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:44:\"carousel_arrows_together_box_shadow_offset_x\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:44:\"carousel_arrows_together_box_shadow_offset_y\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:40:\"carousel_arrows_together_box_shadow_blur\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:42:\"carousel_arrows_together_box_shadow_spread\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:19:\"carousel_pagin_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:23:\"carousel_pagin_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:29:\"carousel_pagin_bg_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:30:\"carousel_pagin_bg_color_active\";a:1:{s:4:\"idle\";s:0:\"\";}s:28:\"carousel_pagin_border_radius\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:27:\"carousel_pagin_border_style\";s:0:\"\";s:27:\"carousel_pagin_border_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:27:\"carousel_pagin_border_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:33:\"carousel_pagin_border_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:34:\"carousel_pagin_border_color_active\";a:1:{s:4:\"idle\";s:0:\"\";}s:25:\"carousel_scrollbar_height\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:24:\"carousel_scrollbar_width\";s:152:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoiJSJ9LCJ0YWJsZXQiOnsidmFsdWUiOiIiLCJ1bml0IjoiJSJ9LCJtb2JpbGUiOnsidmFsdWUiOiIiLCJ1bml0IjoiJSJ9fX0=\";s:27:\"carousel_scrollbar_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:32:\"carousel_scrollbar_drag_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"carousel_scrollbar_drag_bg_hover_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:11:\"blog_layout\";s:13:\"sidebar-right\";s:18:\"blog_sidebar_width\";s:1:\"3\";s:17:\"blog_hide_sidebar\";s:1:\"0\";s:24:\"blog_hide_sidebar_tablet\";s:1:\"1\";s:24:\"blog_hide_sidebar_mobile\";s:1:\"1\";s:29:\"single_post_justified_gallery\";s:1:\"0\";s:11:\"blog_design\";s:7:\"masonry\";s:10:\"blog_style\";s:6:\"shadow\";s:16:\"blog_with_shadow\";s:1:\"1\";s:12:\"blog_columns\";s:1:\"3\";s:19:\"blog_columns_tablet\";s:4:\"auto\";s:19:\"blog_columns_mobile\";s:4:\"auto\";s:12:\"blog_spacing\";s:2:\"20\";s:19:\"blog_spacing_tablet\";s:0:\"\";s:19:\"blog_spacing_mobile\";s:0:\"\";s:15:\"blog_pagination\";s:10:\"pagination\";s:12:\"blog_excerpt\";s:7:\"excerpt\";s:21:\"blog_words_or_letters\";s:6:\"letter\";s:19:\"blog_excerpt_length\";s:3:\"135\";s:11:\"parts_title\";s:1:\"1\";s:10:\"parts_meta\";s:1:\"1\";s:10:\"parts_text\";s:1:\"1\";s:9:\"parts_btn\";s:1:\"1\";s:20:\"parts_published_date\";s:1:\"1\";s:18:\"single_post_design\";s:7:\"default\";s:18:\"single_post_header\";s:4:\"none\";s:10:\"blog_share\";s:1:\"1\";s:15:\"blog_navigation\";s:1:\"1\";s:15:\"blog_author_bio\";s:1:\"1\";s:18:\"blog_related_posts\";s:1:\"1\";s:19:\"blog_published_date\";s:1:\"1\";s:9:\"portfolio\";s:1:\"1\";s:14:\"portfolio_page\";s:0:\"\";s:19:\"portfolio_item_slug\";s:0:\"\";s:18:\"portfolio_cat_slug\";s:0:\"\";s:20:\"portfolio_full_width\";s:1:\"0\";s:16:\"projects_columns\";s:1:\"3\";s:23:\"projects_columns_tablet\";s:4:\"auto\";s:23:\"projects_columns_mobile\";s:4:\"auto\";s:17:\"portfolio_spacing\";s:1:\"0\";s:24:\"portfolio_spacing_tablet\";s:0:\"\";s:24:\"portfolio_spacing_mobile\";s:0:\"\";s:18:\"portoflio_per_page\";s:1:\"6\";s:20:\"portfolio_pagination\";s:9:\"load_more\";s:17:\"portoflio_orderby\";s:4:\"date\";s:15:\"portoflio_order\";s:4:\"DESC\";s:15:\"portoflio_style\";s:5:\"hover\";s:20:\"portoflio_image_size\";s:5:\"large\";s:17:\"portoflio_filters\";s:1:\"1\";s:22:\"portfolio_filters_type\";s:5:\"links\";s:14:\"ajax_portfolio\";s:1:\"1\";s:23:\"single_portfolio_header\";s:4:\"none\";s:36:\"single_portfolio_title_in_page_title\";s:1:\"0\";s:20:\"portfolio_navigation\";s:1:\"1\";s:17:\"portfolio_related\";s:1:\"1\";s:18:\"add_to_cart_action\";s:6:\"widget\";s:26:\"add_to_cart_action_timeout\";s:1:\"0\";s:33:\"add_to_cart_action_timeout_number\";s:1:\"3\";s:18:\"mini_cart_quantity\";s:1:\"0\";s:21:\"show_sku_in_mini_cart\";s:1:\"0\";s:16:\"show_sku_in_cart\";s:1:\"0\";s:25:\"show_sku_in_checkout_page\";s:1:\"0\";s:26:\"show_sku_in_thank_you_page\";s:1:\"0\";s:23:\"show_sku_in_email_order\";s:1:\"0\";s:16:\"show_sku_on_ajax\";s:1:\"0\";s:12:\"catalog_mode\";s:1:\"0\";s:11:\"size_guides\";s:1:\"1\";s:12:\"login_prices\";s:1:\"0\";s:19:\"quick_shop_variable\";s:1:\"1\";s:24:\"quick_shop_variable_type\";s:14:\"select_options\";s:23:\"quick_shop_clear_action\";s:4:\"none\";s:23:\"grid_swatches_attribute\";s:0:\"\";s:14:\"swatches_limit\";s:1:\"0\";s:20:\"swatches_limit_count\";s:1:\"5\";s:29:\"single_product_swatches_limit\";s:1:\"0\";s:35:\"single_product_swatches_limit_count\";s:2:\"10\";s:29:\"swatches_use_variation_images\";s:1:\"0\";s:20:\"swatches_labels_name\";s:1:\"0\";s:27:\"swatches_scroll_top_desktop\";s:1:\"0\";s:26:\"swatches_scroll_top_mobile\";s:1:\"0\";s:17:\"variation_gallery\";s:1:\"1\";s:32:\"variation_gallery_storage_method\";s:3:\"old\";s:24:\"ajax_variation_threshold\";s:2:\"30\";s:29:\"show_filtered_variation_image\";s:1:\"0\";s:17:\"hide_larger_price\";s:1:\"0\";s:31:\"single_product_variations_price\";s:1:\"0\";s:11:\"label_shape\";s:7:\"rounded\";s:16:\"percentage_label\";s:1:\"1\";s:19:\"sale_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:21:\"sale_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"new_label\";s:1:\"1\";s:27:\"new_label_days_after_create\";s:1:\"0\";s:18:\"new_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"new_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"hot_label\";s:1:\"1\";s:18:\"hot_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"hot_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"stock_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"stock_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:24:\"attribute_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"attribute_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:16:\"brands_attribute\";s:0:\"\";s:18:\"product_page_brand\";s:1:\"1\";s:22:\"product_brand_location\";s:11:\"about_title\";s:9:\"brand_tab\";s:1:\"1\";s:14:\"brand_tab_name\";s:1:\"0\";s:10:\"quick_view\";s:1:\"1\";s:17:\"quick_view_layout\";s:10:\"horizontal\";s:15:\"quickview_width\";s:3:\"920\";s:19:\"quick_view_variable\";s:1:\"1\";s:7:\"compare\";s:1:\"1\";s:12:\"compare_page\";s:3:\"385\";s:14:\"fields_compare\";a:3:{i:0;s:11:\"description\";i:1;s:3:\"sku\";i:2;s:12:\"availability\";}s:18:\"empty_compare_text\";s:146:\"No products added in the compare list. You must add some products to compare them. You will find a lot of interesting products on our \"Shop\" page.\";s:15:\"compare_on_grid\";s:1:\"1\";s:25:\"compare_save_button_state\";s:1:\"0\";s:19:\"compare_by_category\";s:1:\"0\";s:22:\"show_more_products_btn\";s:1:\"1\";s:18:\"cart_totals_layout\";s:8:\"layout-1\";s:27:\"update_cart_quantity_change\";s:1:\"0\";s:15:\"empty_cart_text\";s:140:\"Before proceed to checkout you must add some products to your shopping cart. You will find a lot of interesting products on our \"Shop\" page.\";s:27:\"thank_you_page_content_type\";s:4:\"text\";s:28:\"thank_you_page_extra_content\";s:0:\"\";s:25:\"thank_you_page_html_block\";s:0:\"\";s:30:\"thank_you_page_default_content\";s:1:\"1\";s:21:\"single_product_layout\";s:10:\"full-width\";s:19:\"full_height_sidebar\";s:1:\"0\";s:20:\"single_sidebar_width\";s:1:\"3\";s:27:\"single_product_hide_sidebar\";s:1:\"0\";s:34:\"single_product_hide_sidebar_tablet\";s:1:\"1\";s:34:\"single_product_hide_sidebar_mobile\";s:1:\"1\";s:20:\"single_product_style\";s:1:\"2\";s:14:\"product_design\";s:7:\"default\";s:14:\"product_sticky\";s:1:\"0\";s:22:\"product_summary_shadow\";s:1:\"0\";s:17:\"single_full_width\";s:1:\"0\";s:21:\"single_product_header\";s:4:\"none\";s:32:\"single_product_builder_post_data\";s:0:\"\";s:12:\"image_action\";s:4:\"zoom\";s:15:\"photoswipe_icon\";s:1:\"1\";s:26:\"product_slider_auto_height\";s:1:\"0\";s:23:\"pagination_main_gallery\";s:1:\"0\";s:23:\"product_images_captions\";s:1:\"0\";s:14:\"thums_position\";s:4:\"left\";s:31:\"single_product_grid_columns_gap\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:34:\"single_product_grid_column_desktop\";s:0:\"\";s:33:\"single_product_grid_column_tablet\";s:0:\"\";s:33:\"single_product_grid_column_mobile\";s:0:\"\";s:37:\"single_product_gallery_column_desktop\";s:1:\"1\";s:36:\"single_product_gallery_column_tablet\";s:0:\"\";s:36:\"single_product_gallery_column_mobile\";s:0:\"\";s:40:\"single_product_thumbnails_vertical_items\";s:1:\"3\";s:39:\"single_product_thumbnails_items_desktop\";s:1:\"4\";s:38:\"single_product_thumbnails_items_tablet\";s:1:\"4\";s:38:\"single_product_thumbnails_items_mobile\";s:1:\"3\";s:22:\"main_gallery_on_tablet\";s:1:\"1\";s:22:\"main_gallery_on_mobile\";s:1:\"1\";s:24:\"main_gallery_center_mode\";s:1:\"0\";s:48:\"single_product_thumbnails_wrap_in_mobile_devices\";s:1:\"1\";s:39:\"single_product_thumbnails_gallery_width\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:40:\"single_product_thumbnails_gallery_height\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:45:\"single_product_thumbnails_gallery_image_width\";s:3:\"150\";s:23:\"single_ajax_add_to_cart\";s:1:\"1\";s:25:\"single_sticky_add_to_cart\";s:1:\"0\";s:32:\"mobile_single_sticky_add_to_cart\";s:1:\"0\";s:33:\"sticky_add_to_cart_height_desktop\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_tablet\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_mobile\";s:2:\"42\";s:31:\"before_add_to_cart_content_type\";s:4:\"text\";s:26:\"content_before_add_to_cart\";s:0:\"\";s:29:\"before_add_to_cart_html_block\";s:0:\"\";s:30:\"after_add_to_cart_content_type\";s:4:\"text\";s:25:\"content_after_add_to_cart\";s:0:\"\";s:28:\"after_add_to_cart_html_block\";s:0:\"\";s:27:\"single_breadcrumbs_position\";s:7:\"default\";s:24:\"product_page_breadcrumbs\";s:1:\"1\";s:12:\"products_nav\";s:1:\"1\";s:25:\"product_short_description\";s:1:\"1\";s:21:\"attr_after_short_desc\";s:1:\"0\";s:19:\"stock_status_design\";s:7:\"default\";s:25:\"single_stock_progress_bar\";s:1:\"0\";s:17:\"product_countdown\";s:1:\"0\";s:23:\"sale_countdown_variable\";s:1:\"0\";s:17:\"product_show_meta\";s:11:\"add_to_cart\";s:18:\"show_product_brand\";s:1:\"0\";s:13:\"product_share\";s:1:\"1\";s:18:\"product_share_type\";s:5:\"share\";s:16:\"related_products\";s:1:\"1\";s:16:\"upsells_position\";s:8:\"standard\";s:20:\"related_product_view\";s:6:\"slider\";s:23:\"related_product_columns\";s:1:\"4\";s:30:\"related_product_columns_tablet\";s:4:\"auto\";s:30:\"related_product_columns_mobile\";s:4:\"auto\";s:21:\"related_product_count\";s:1:\"8\";s:19:\"product_tabs_layout\";s:4:\"tabs\";s:21:\"product_tabs_location\";s:8:\"standard\";s:23:\"product_accordion_state\";s:5:\"first\";s:16:\"hide_tabs_titles\";s:1:\"1\";s:20:\"additional_tab_title\";s:19:\"Shipping & Delivery\";s:27:\"additional_tab_content_type\";s:4:\"text\";s:19:\"additional_tab_text\";s:0:\"\";s:25:\"additional_tab_html_block\";s:0:\"\";s:22:\"additional_tab_2_title\";s:0:\"\";s:29:\"additional_tab_2_content_type\";s:4:\"text\";s:21:\"additional_tab_2_text\";s:0:\"\";s:27:\"additional_tab_2_html_block\";s:0:\"\";s:22:\"additional_tab_3_title\";s:0:\"\";s:29:\"additional_tab_3_content_type\";s:4:\"text\";s:21:\"additional_tab_3_text\";s:0:\"\";s:27:\"additional_tab_3_html_block\";s:0:\"\";s:10:\"login_tabs\";s:1:\"1\";s:9:\"reg_title\";s:8:\"Register\";s:8:\"reg_text\";s:258:\"Registering for this site allows you to access your order status and history. Just fill in the fields below, and we\'ll get a new account set up for you in no time. We will only ask you for information necessary to make the purchase process faster and easier.\";s:11:\"login_title\";s:5:\"Login\";s:10:\"login_text\";s:0:\"\";s:16:\"my_account_links\";s:1:\"1\";s:10:\"custom_css\";s:0:\"\";s:11:\"css_desktop\";s:0:\"\";s:10:\"css_tablet\";s:0:\"\";s:15:\"css_wide_mobile\";s:0:\"\";s:10:\"css_mobile\";s:0:\"\";s:11:\"css_backend\";s:0:\"\";s:9:\"custom_js\";s:0:\"\";s:8:\"js_ready\";s:0:\"\";s:13:\"sticky_social\";s:1:\"0\";s:18:\"sticky_social_type\";s:6:\"follow\";s:22:\"sticky_social_position\";s:5:\"right\";s:20:\"social_follow_notice\";s:0:\"\";s:7:\"fb_link\";s:1:\"#\";s:12:\"twitter_link\";s:1:\"#\";s:12:\"bluesky_link\";s:0:\"\";s:14:\"isntagram_link\";s:1:\"#\";s:12:\"threads_link\";s:0:\"\";s:14:\"pinterest_link\";s:1:\"#\";s:12:\"youtube_link\";s:1:\"#\";s:11:\"tumblr_link\";s:0:\"\";s:13:\"linkedin_link\";s:0:\"\";s:10:\"vimeo_link\";s:0:\"\";s:11:\"flickr_link\";s:0:\"\";s:11:\"github_link\";s:0:\"\";s:13:\"dribbble_link\";s:0:\"\";s:12:\"behance_link\";s:0:\"\";s:15:\"soundcloud_link\";s:0:\"\";s:12:\"spotify_link\";s:0:\"\";s:10:\"skype_link\";s:0:\"\";s:13:\"whatsapp_link\";s:0:\"\";s:13:\"snapchat_link\";s:0:\"\";s:7:\"tg_link\";s:0:\"\";s:10:\"viber_link\";s:0:\"\";s:11:\"tiktok_link\";s:0:\"\";s:12:\"discord_link\";s:0:\"\";s:9:\"yelp_link\";s:0:\"\";s:7:\"vk_link\";s:0:\"\";s:7:\"ok_link\";s:0:\"\";s:18:\"social_email_links\";s:1:\"0\";s:19:\"social_share_notice\";s:0:\"\";s:8:\"share_fb\";s:1:\"1\";s:13:\"share_twitter\";s:1:\"1\";s:15:\"share_pinterest\";s:1:\"1\";s:14:\"share_linkedin\";s:1:\"1\";s:14:\"share_whatsapp\";s:1:\"0\";s:8:\"share_tg\";s:1:\"1\";s:11:\"share_viber\";s:1:\"0\";s:8:\"share_vk\";s:1:\"0\";s:8:\"share_ok\";s:1:\"0\";s:11:\"share_email\";s:1:\"0\";s:19:\"mobile_optimization\";s:1:\"0\";s:16:\"load_text_domain\";s:1:\"1\";s:21:\"disable_gutenberg_css\";s:1:\"0\";s:17:\"styles_always_use\";s:0:\"\";s:14:\"styles_not_use\";s:0:\"\";s:26:\"disable_owl_mobile_devices\";s:1:\"0\";s:21:\"remove_jquery_migrate\";s:1:\"0\";s:18:\"advanced_js_notice\";s:0:\"\";s:11:\"advanced_js\";s:1:\"0\";s:20:\"autocomplete_library\";s:8:\"required\";s:14:\"cookie_library\";s:8:\"required\";s:24:\"countdown-bundle_library\";s:8:\"required\";s:14:\"device_library\";s:7:\"not_use\";s:22:\"isotope-bundle_library\";s:8:\"required\";s:17:\"justified_library\";s:8:\"required\";s:16:\"magnific_library\";s:8:\"required\";s:28:\"panr-parallax-bundle_library\";s:8:\"required\";s:16:\"parallax_library\";s:8:\"required\";s:30:\"parallax-scroll-bundle_library\";s:8:\"required\";s:25:\"photoswipe-bundle_library\";s:8:\"required\";s:12:\"pjax_library\";s:8:\"required\";s:18:\"sticky-kit_library\";s:8:\"required\";s:17:\"wd_swiper_library\";s:8:\"required\";s:18:\"threesixty_library\";s:8:\"required\";s:16:\"tooltips_library\";s:8:\"required\";s:13:\"vivus_library\";s:8:\"required\";s:17:\"waypoints_library\";s:8:\"required\";s:15:\"leaflet_library\";s:8:\"required\";s:20:\"vimeo_player_library\";s:8:\"required\";s:18:\"scripts_always_use\";s:0:\"\";s:15:\"scripts_not_use\";s:0:\"\";s:15:\"dequeue_scripts\";s:0:\"\";s:12:\"lazy_loading\";s:1:\"0\";s:22:\"lazy_loading_bg_images\";s:1:\"0\";s:19:\"lazy_loading_offset\";s:1:\"0\";s:11:\"lazy_effect\";s:4:\"none\";s:23:\"lazy_custom_placeholder\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:30:\"disable_wordpress_lazy_loading\";s:1:\"0\";s:26:\"rocket_delay_js_exclusions\";s:1:\"0\";s:6:\"cf7_js\";s:1:\"1\";s:20:\"elementor_animations\";s:1:\"1\";s:15:\"elementor_icons\";s:1:\"1\";s:24:\"elementor_dialog_library\";s:1:\"1\"