<?php

/*
Plugin Name: وودمارت پلاس - توسعه وردپرس - راست چین
Plugin URI: https://www.rtl-theme.com/author/devwp/products/
Description: افزونه فول فروشگاهی وودمارت پلاس پلاگین اختصاصی توسعه وردپرس که سیستم اتوماسیون کامل فروشگاهی را به وبسایت شما اضافه میکند ، مواردی مانند سیستم کامل اپلیکیشن موبایل اندروید فروشگاهی ، اپلیکیشن آی او اس کامل فروشگاهی ، سیستم باشگاه مشتریان ، سیستم تیکت ، سیستم پنل کاربری ، سیستم ثبت نام ورود پیامکی ، سیستم پنل کاربری ، سیستم های مختلف پیگیری سفارشات ، سیستم های مختلف پیامکی برای انواع قسمت ها ، ویجت های المنتوری مختلف و بسیاری امکاناتی که تنها با خرید محصول از راست چین به آن دسترسی خواهید داشت .
Version: 3.8.4
Author: devwp
Author URI: https://www.rtl-theme.com/author/devwp/products/
Text Domain: woodmartplus
Domain Path: languages
*/



define('WPLUS_FILE', __FILE__);
define('DIR_PATH', plugin_dir_path(__FILE__));
define('DIR_URL', plugin_dir_url(__FILE__));

define("WOODPLUS_ASSET", DIR_URL . 'assets/');
define('WOODMARTPLUSOPTION', 'woodmartplus_settings');
define('PHONEMETA', '_wplus_phone');



add_action('plugins_loaded', function () {

    include_once DIR_PATH . 'inc/save-settings.php';
    include_once DIR_PATH . 'inc/wplus-helper.php';
    include_once DIR_PATH . 'inc/vendor/cities/CityProvince.php';
    include_once DIR_PATH . 'inc/init.php';
    include_once DIR_PATH . 'inc/compatible-themes.php';

    if (class_exists('woocommerce')) {
        new woodmartPlusInit;
    }
});

add_action('init', 'load_plugin_textdomain_woodmartplus');

function load_plugin_textdomain_woodmartplus()
{
    unload_textdomain('woodmartplus', true);
    load_plugin_textdomain('woodmartplus', false, dirname(plugin_basename(__FILE__)) . '/languages');
}

function core_load_template($view, $data = [])
{

    extract($data);

    $path = str_replace('.', '/', $view);
    include plugin_dir_path(__FILE__) . 'template/' . $path . '.php';
}


function elementor_load_template($view, $data = [])
{
    extract($data);
    $path = str_replace('.', '/', $view);
    include plugin_dir_path(__FILE__) . 'woocommerce/' . $path . '.php';
}

add_action('init', function () {
    if (wplus_helper::check_plugin_active('dokan-lite/dokan.php')) {
        require_once DIR_PATH . 'inc/dokan.php';
        new woodplus_dokan;
    }
}, 999);

if (!class_exists('woodmartPlusInit')) {
    include DIR_PATH . '/inc/install.php';
}
