<?php

/**
 * My Account navigation
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/myaccount/navigation.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://docs.woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 2.6.0
 */

if (! defined('ABSPATH')) {
	exit;
}

do_action('woocommerce_before_account_navigation');
global $WooWcWallet;

$menus = wc_get_account_menu_items();
$new_menu = wplus_helper::regenerate_menus_nav_dashboard($menus);

$user_id = get_current_user_id();
$attachment_id = get_user_meta($user_id, '_acount_image', true);
$last_name = get_user_meta($user_id, 'last_name', true);
$first_name = get_user_meta($user_id, 'first_name', true);

$note = __('اطلاعات خود را کامل کنید', 'woodmartplus');

$phone = get_user_meta($user_id, PHONEMETA, true) ? get_user_meta($user_id, PHONEMETA, true) : false;
if (!$phone) {
	$phone = get_user_meta($user_id, 'digits_phone_no', true) ?  get_user_meta($user_id, 'digits_phone_no', true) : null;
}
$full_name = isset($first_name) && !empty($first_name) ? $first_name . ' ' . $last_name : $note;

$original_image_url = wp_get_attachment_url($attachment_id);
?>
<div class="dashboard_side">
	<a href="<?php echo wc_logout_url(); ?>" class="signout_button">
		<p><?php esc_html_e('خروج', 'woodmartplus'); ?></p>
		<i class="fa-light fa-arrow-right-from-bracket-advanced"></i>
	</a>
	<div class="justify_end"></div>

	<div class="dashboard_avatar avatar_image_account">
		<?php if ($original_image_url): ?>
			<img src="<?php echo wp_get_attachment_image_url($attachment_id, 'full'); ?>" alt="user avatar">
		<?php else: ?>
			<img src="<?php echo WOODPLUS_ASSET . 'img/' ?>user.svg" alt="user avatar">
		<?php endif; ?>
	</div>

	<div class="gap-y">
		<div class="justify_end">
			<a href="<?php echo esc_url(wc_get_endpoint_url('edit-account'));  ?>" class="link_gray small">
				<svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14" fill="none">
					<path d="M6.41699 1.16663H5.25033C2.33366 1.16663 1.16699 2.33329 1.16699 5.24996V8.74996C1.16699 11.6666 2.33366 12.8333 5.25033 12.8333H8.75033C11.667 12.8333 12.8337 11.6666 12.8337 8.74996V7.58329" stroke="currentColor" stroke-linecap="round" stroke-linejoin="round"></path>
					<path d="M9.35708 1.76169L4.76042 6.35836C4.58542 6.53336 4.41042 6.87753 4.37542 7.12836L4.12458 8.88419C4.03125 9.52002 4.48042 9.96336 5.11625 9.87586L6.87208 9.62503C7.11708 9.59003 7.46125 9.41503 7.64208 9.24003L12.2388 4.64336C13.0321 3.85003 13.4054 2.92836 12.2388 1.76169C11.0721 0.595025 10.1504 0.968359 9.35708 1.76169Z" stroke="currentColor" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
					<path d="M8.69727 2.42078C9.0881 3.81494 10.1789 4.90578 11.5789 5.30244" stroke="currentColor" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
				</svg>
				<p><?php esc_html_e('ویرایش اطلاعات', 'woodmartplus'); ?></p>
			</a>
		</div>
		<div class="badge_gray space_between">
			<p><?php echo esc_html($full_name); ?></p>
			<p class="font_semibold"><?php echo $phone ? esc_html_e($phone) : '<a href=" ' . esc_url(wc_get_endpoint_url('edit-account')) . ' " >' . __('اضافه کردن شماره موبایل', 'woodmartplus') . '</a>'; ?></p>
		</div>
		<?php if( !is_null( $WooWcWallet ) ): ?>
		<div class="badge_gray space_between">
			<p><?php echo esc_html_e('موجودی کیف پول','woodmartplus'); ?></p>
			<p class="font_semibold"><?php echo wc_price( $WooWcWallet->get_count_wallet() );  ?></p>
		</div>
		<?php endif; ?>
	</div>
	<div class="dashboard_side__body">
		<ul class="dashboard_menu">
			<?php foreach ($new_menu as $endpoint => $label) : ?>

				<?php if ($endpoint === 'customer-logout'): ?>
					<?php continue ?>
				<?php endif; ?>

				<?php if (!$label) continue; ?>

				<li class="dashboard_menu__item <?php echo wc_get_account_menu_item_classes($endpoint); ?>">
					<div class="gap-x">
						<div class="icon">
							<?php if ($endpoint === 'dashboard'): ?>
								<i class="fa-regular fa-house"></i>
							<?php elseif ($endpoint === 'orders'): ?>
								<i class="fa-regular fa-box"></i>
							<?php elseif ($endpoint === 'downloads'): ?>
								<i class="fa-regular fa-arrow-down-to-line"></i>
							<?php elseif ($endpoint === 'edit-address'): ?>
								<i class="fa-regular fa-location-dot"></i>
							<?php elseif ($endpoint === 'edit-account'): ?>
								<i class="fa-regular fa-info-circle"></i>
							<?php elseif ($endpoint === 'offers'): ?>
								<i class="fa-regular fa-ticket"></i>
							<?php elseif ($endpoint === 'notifications'): ?>
								<i class="fa-regular fa-bell"></i>
							<?php elseif ($endpoint === 'tickets'): ?>
								<i class="fa-regular fa-ballot-check"></i>
							<?php elseif ($endpoint === 'wc-wallet'): ?>
								<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"> <path d="M21 12V7H5a2 2 0 0 1 0-4h14v4"></path> <path d="M3 5v14a2 2 0 0 0 2 2h16v-5"></path> <path d="M18 12a2 2 0 0 0 0 4h4v-4Z"></path> </svg>
							<?php elseif ($endpoint === 'wplus_feedback'): ?>
								<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round">
									<path d="M21 15a2 2 0 0 1-2 2H7l-4 4V5a2 2 0 0 1 2-2h14a2 2 0 0 1 2 2z"></path>
								</svg>
							<?php elseif ($endpoint === 'wishlist'): ?>
								<i class="fa-regular fa-heart"></i>
							<?php endif; ?>
						</div>
						 
						<p><a href="<?php echo esc_url(wc_get_account_endpoint_url($endpoint)); ?>"><?php echo esc_html($label); ?></a></p>
					</div>
					<div class="arrow_button">
						<i class="fa-regular fa-arrow-left"></i>
					</div>
				</li>

			<?php endforeach; ?>
		</ul>
			
			<a href="<?php echo wc_logout_url(); ?>" class="btn solid medium">
			<svg xmlns="http://www.w3.org/2000/svg" xmlns:xlink="http://www.w3.org/1999/xlink"  fill="currentColor" height="20px" width="20px" version="1.1" id="Capa_1" viewBox="0 0 384.971 384.971" xml:space="preserve"> <g> <g id="Sign_Out"> <path d="M180.455,360.91H24.061V24.061h156.394c6.641,0,12.03-5.39,12.03-12.03s-5.39-12.03-12.03-12.03H12.03    C5.39,0.001,0,5.39,0,12.031V372.94c0,6.641,5.39,12.03,12.03,12.03h168.424c6.641,0,12.03-5.39,12.03-12.03    C192.485,366.299,187.095,360.91,180.455,360.91z"/> <path d="M381.481,184.088l-83.009-84.2c-4.704-4.752-12.319-4.74-17.011,0c-4.704,4.74-4.704,12.439,0,17.179l62.558,63.46H96.279    c-6.641,0-12.03,5.438-12.03,12.151c0,6.713,5.39,12.151,12.03,12.151h247.74l-62.558,63.46c-4.704,4.752-4.704,12.439,0,17.179    c4.704,4.752,12.319,4.752,17.011,0l82.997-84.2C386.113,196.588,386.161,188.756,381.481,184.088z"/> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> <g> </g> </g> </svg>
				<?php esc_html_e('خروج', 'woodmartplus'); ?>
			</a>
		
	</div>
</div>
<?php do_action('woocommerce_after_account_navigation'); ?>