<?php echo wc_print_notices(true); 

  $getDetial = HelperTransferSetting::getInstance()->getSetting('wallet_setting');
?>
<div class="woodmart-wallet-container">
   <div class="wallet-header">
      <div class="wallet-title">
         <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round"> <path d="M21 12V7H5a2 2 0 0 1 0-4h14v4"></path> <path d="M3 5v14a2 2 0 0 0 2 2h16v-5"></path> <path d="M18 12a2 2 0 0 0 0 4h4v-4Z"></path> </svg>
         <h2><?php echo isset( $getDetial['title_first'] ) ? esc_html($getDetial['title_first']) : __('کیف پول شما','woodmartplus'); ?></h2>
      </div>
   </div>

   <div class="wallet-dashboard">
      <div class="wallet-balance-card">
         <div class="balance-label"><?php echo isset( $getDetial['title_first'] ) ? esc_html($getDetial['title_amount']) : __('موجودی کیف پول','woodmartplus'); ?></div>
         <div class="balance-amount"><?php echo wc_price( $wallet_count ) ?></div>
      </div>

      <div class="wallet-charge-card">
         <h3><?php echo isset( $getDetial['title_increase_amount'] ) ? esc_html($getDetial['title_increase_amount']) : __('افزایش موجودی','woodmartplus'); ?></h3>
         <form method="POST" class="wallet-charge-form">
            <div class="form-group">
               <label for="charge_wallet"><?php esc_html_e('مبلغ مورد نظر (تومان)','woodmartplus'); ?></label>
               <div class="input-group">
                  <input id="charge_wallet" type="text" >
                  <input id="charged_now" type="hidden" placeholder="0" name="charge_wallet">
                  <button type="submit" name="submit_charge" value="yes" class="charge-button">
                     <span><?php echo isset( $getDetial['title_btn_amount'] ) ? esc_html($getDetial['title_btn_amount']) :  __('افزایش','woodmartplus'); ?></span>
                     <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"><line x1="12" y1="5" x2="12" y2="19"></line><line x1="5" y1="12" x2="19" y2="12"></line></svg>
                  </button>
               </div>
            </div>
         </form>
      </div>
   </div>

   <div class="wallet-history">
      <h3><?php esc_html_e('تاریخچه تراکنش‌ها','woodmartplus'); ?></h3>
      
      <?php if(empty($table_detial)): ?>
         <div class="empty-history">
            <svg xmlns="http://www.w3.org/2000/svg" width="48" height="48" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round"><circle cx="12" cy="12" r="10"></circle><line x1="12" y1="8" x2="12" y2="12"></line><line x1="12" y1="16" x2="12.01" y2="16"></line></svg>
            <p><?php esc_html_e('هنوز هیچ تراکنشی انجام نشده است','woodmartplus'); ?></p>
         </div>
      <?php else: ?>
         <div class="transaction-table">
            <table>
               <thead>
                  <tr>
                     <th><?php esc_html_e('شماره سفارش','woodmartplus'); ?></th>
                     <th><?php esc_html_e('نوع تراکنش','woodmartplus'); ?></th>
                     <th><?php esc_html_e('مبلغ','woodmartplus'); ?></th>
                  </tr>
               </thead>
               <tbody>
               <?php foreach( $table_detial as $key => $value ): ?>
                  <tr>
                     <td class="order-id">#<?php echo esc_html( $value['order_id'] ); ?></td>
                     <td class="transaction-type">
                        <?php if( isset( $value['price_cashback'] ) ): ?>
                            <span class="badge badge-info"><?php esc_html_e('کش بک','woodmartplus'); ?></span>
                        <?php else: ?>
                              <?php if( isset( $value['type'] ) && 'increase' === $value['type'] ): ?>
                                  <span class="badge badge-success"><?php esc_html_e('افزایش موجودی','woodmartplus'); ?></span>
                              <?php elseif( isset( $value['type'] ) && 'decrease' === $value['type'] ):  ?>
                                  <span class="badge badge-decrease"><?php esc_html_e('کاهش موجودی','woodmartplus'); ?></span>
                              <?php endif; ?>
                        <?php endif; ?>
                     </td>
                     <td class="transaction-amount">
                        <?php if( isset( $value['price_wallet_charge'] ) ):   ?>
                           <?php $output = isset( $value['charge_wallet'] ) ?  $value['charge_wallet']: '' ?>
                           <span class="amount positive"><?php echo $output.' '.wc_price( $value['price_wallet_charge'] ) ?></span>
                        <?php elseif( isset( $value['price_cashback'] ) ): ?>
                           <?php $output = isset( $value['cashback_message'] ) ?  $value['cashback_message']: '' ?>
                           <span class="amount positive"><?php echo $output. ' '.wc_price($value['price_cashback']); ?></span>
                        <?php endif; ?>
                     </td>
                  </tr>
                <?php endforeach; ?>
               </tbody>
            </table>
         </div>
      <?php endif; ?>
   </div>
</div>
<script>
  const input = document.getElementById("charge_wallet");
  const sendValue = document.getElementById("charged_now");

  input.addEventListener("input", function (e) {
    
    let rawValue = e.target.value.replace(/,/g, '').replace(/\D/g, '');
    e.target.value = Number(rawValue).toLocaleString('en-US');
    // value = Number(value).toLocaleString('en-US');
   
    sendValue.value = rawValue;
  });
</script>
<style>
.woodmart-wallet-container {
  background-color: #fff;
  border-radius: 12px;
  box-shadow: 0 2px 20px rgba(0, 0, 0, 0.05);
  padding: 0;
  margin-bottom: 30px;
  overflow: hidden;
  font-family: inherit;
  max-width: 100%;
}

.wallet-header {
  background: var(--main-color);
  padding: 20px 25px;
  color: white;
}

.wallet-title {
  display: flex;
  align-items: center;
  gap: 12px;
}

.wallet-title svg {
  stroke: white;
  width: 28px;
  height: 28px;
}

.wallet-title h2 {
  margin: 0;
  font-size: 20px;
  font-weight: 600;
  color: white;
}

.wallet-dashboard {
  display: grid;
  grid-template-columns: 1fr 1fr;
  gap: 20px;
  padding: 25px;
}

@media (max-width: 768px) {
  .wallet-dashboard {
     grid-template-columns: 1fr;
  }
}

.wallet-balance-card {
  background: linear-gradient(135deg, #f8f9fa, #e9ecef);
  border-radius: 10px;
  padding: 25px;
  text-align: center;
  display: flex;
  flex-direction: column;
  justify-content: center;
  align-items: center;
  min-height: 150px;
}

.balance-label {
  font-size: 16px;
  color: #495057;
  margin-bottom: 15px;
}

.balance-amount {
  font-size: 28px;
  font-weight: 700;
  color: #2651e8;
}

.wallet-charge-card {
  background-color: #f8f9fa;
  border-radius: 10px;
  padding: 25px;
  box-sizing: border-box;
}

.wallet-charge-card h3 {
  margin-top: 0;
  margin-bottom: 20px;
  font-size: 18px;
  color: #212529;
}

.wallet-charge-form {
  width: 100%;
}

.wallet-charge-form .form-group {
  margin-bottom: 0;
}

.wallet-charge-form label {
  display: block;
  margin-bottom: 10px;
  font-size: 14px;
  color: #495057;
}

.input-group {
  display: flex;
  border-radius: 8px;
  overflow: hidden;
  width: 100%;
}

.input-group input {
  flex: 1;
  border: 1px solid #ced4da;
  border-right: none;
  padding: 12px 15px;
  font-size: 16px;
  border-radius: 8px 0 0 8px;
  box-sizing: border-box;
}

.input-group input:focus {
  outline: none;
  border-color: #4a6cf7;
}

.charge-button {
  background-color: var(--main-color);
  color: white;
  border: none;
  padding: 0 20px;
  font-size: 15px;
  cursor: pointer;
  display: flex;
  align-items: center;
  gap: 8px;
  border-radius: 0 8px 8px 0;
  transition: background-color 0.2s;
}

.charge-button:hover {
  background-color: var(--red-5);
}

.wallet-history {
  padding: 0 25px 25px;
}

.wallet-history h3 {
  margin-bottom: 20px;
  font-size: 18px;
  color: #212529;
}

.empty-history {
  display: flex;
  flex-direction: column;
  align-items: center;
  justify-content: center;
  padding: 40px 0;
  color: #6c757d;
}

.empty-history svg {
  margin-bottom: 15px;
  stroke: #adb5bd;
}

.transaction-table {
  overflow-x: auto;
}

.transaction-table table {
  width: 100%;
  border-collapse: separate;
  border-spacing: 0;
}

.transaction-table th {
  background-color: #f8f9fa;
  padding: 12px 15px;
  text-align: right;
  font-weight: 600;
  color: #495057;
  border-bottom: 1px solid #dee2e6;
}

.transaction-table td {
  padding: 15px;
  border-bottom: 1px solid #f1f3f5;
  color: #495057;
}

.transaction-table tr:last-child td {
  border-bottom: none;
}

.order-id {
  font-weight: 600;
  color: #212529;
}

.badge {
  display: inline-block;
  padding: 5px 10px;
  border-radius: 50px;
  font-size: 12px;
  font-weight: 500;
}

.badge-success {
  background-color: #e6f7ee;
  color: #0ca678;
}
.badge-decrease {
    background-color: #fe0c1a;
    color: #e7e7e7;
}
.badge-info {
  background-color: #e7f5ff;
  color: #1c7ed6;
}

.amount {
  font-weight: 600;
}

.amount.positive {
  color: #0ca678;
}

.amount.negative {
  color: #fa5252;
}
#charge_wallet{
  border: 1px solid #ced4da;
  border-radius: 0px 10px 10px 0px;
}
.charge-button
{
  border-radius: 10px 0px 0px 10px;
}
</style>