<?php defined('ABSPATH') || exit;?>

<div class="white_card--border_row edit-account">
   <div class="item">
      <div class="gap-x">
         <a href="<?php echo esc_url(wc_get_endpoint_url('tickets')); ?>" class="btn link">
            <svg xmlns="http://www.w3.org/2000/svg" width="14" height="14" viewBox="0 0 14 14" fill="none">
               <path d="M5.25005 2.38L9.05338 6.18333C9.50255 6.6325 9.50255 7.36749 9.05338 7.81666L5.25005 11.62" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
            </svg>
            <p><?php esc_html_e('بازگشت', 'woodmartplus'); ?></p>
         </a>
      </div>
   </div>
   <div class="item gap-y-3">
      <div class="card_header">
         <div class="title">
            <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 22 22" fill="none">
               <path d="M14.6663 1.83398H7.33301C3.66634 1.83398 1.83301 3.66732 1.83301 7.33398V19.2507C1.83301 19.7548 2.24551 20.1673 2.74967 20.1673H14.6663C18.333 20.1673 20.1663 18.334 20.1663 14.6673V7.33398C20.1663 3.66732 18.333 1.83398 14.6663 1.83398Z" stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
               <path d="M6.41699 8.70898H15.5837" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
               <path d="M6.41699 13.293H12.8337" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round" />
            </svg>
            <p><?php esc_html_e('ارسال تیکت جدید', 'woodmartplus'); ?></p>
         </div>
         <hr />
      </div>
      <?php if ($before_send_text): ?>
         <div class="gap-y">
            <p class="text_black">
               <?php esc_html_e('لطفا متن زیر را قبل از ارسال تیکت خوانده و سپس ارسال کنید.', 'woodmartplus'); ?>
            </p>
            <p class="text_darkgray">
               <?php echo esc_html($before_send_text); ?>
            </p>
         </div>
      <?php endif; ?>
      <?php if ($qustion_answers): ?>
         <div class="gap-y-2">
            <?php foreach ($qustion_answers as $question_ansewer): ?>
               <div class="accordion_container accordion_notice_container">
                  <button type="button" class="accordion_button">
                     <div class="accordion_button__text">
                        <i class="fa-light fa-arrow-circle-left"></i>
                        <p><?php echo esc_html($question_ansewer['question']); ?></p>
                     </div>
                     <div class="accordion_button__icon">
                        <i class="text_danger fa-light fa-minus"></i>
                        <i class="text_danger fa-light fa-plus"></i>
                     </div>
                  </button>
                  <ul class="accordion_notice__contents">
                     <p>
                        <?php echo esc_html($question_ansewer['answer']); ?>
                     </p>
                  </ul>
               </div>
            <?php endforeach; ?>
         </div>
      <?php endif; ?>
   </div>
   <div class="item">
      <div class="gap-y-3">
         <p class="text_black"><?php esc_html_e('ارسال تیکت جدید', 'woodmartplus'); ?></p>
         <form class="add_ticket__form" action="" method="POST" enctype="multipart/form-data">
            <div class="solid_input">
               <label for="txtTicketTitle"><?php esc_html_e('موضوع', 'woodmartplus'); ?> <?php echo wplus_helper::get_setting('ticket_required_title') ? '<span class="text_danger">*</span>' : '' ?> </label>
               <input type="text" id="txtTicketTitle" <?php echo wplus_helper::get_setting('ticket_required_title') ? 'required' : ''?>  name="ticket_title" placeholder="<?php esc_html_e('موضوع تیکت خود را وارد کنید', 'woodmartplus'); ?>" />
            </div>
            <div class="items_container--2">
               <div class="solid_input">
                  <label for="sltTicketCategory"><?php esc_html_e('دپارتمان', 'woodmartplus'); ?><?php echo wplus_helper::get_setting('ticket_required_departeman') ? '<span class="text_danger">*</span>' : '' ?></label>

                  <select name="departeman" class="select_departeman ticket_select_items" data-required="<?php echo wplus_helper::get_setting('ticket_required_departeman') ? 1 : 0 ?>">
                     <option value="departman_default"><?php esc_html_e('دپارتمان را انتخاب کنید', 'woodmartplus'); ?></option>
                     <?php foreach ($departemans as $key => $departeman): ?>
                        <option value="<?php echo esc_attr($key); ?>"><?php echo esc_html($departeman); ?></option>
                     <?php endforeach; ?>
                  </select>
               </div>
               <div class="solid_input">
                  <label for="sltTicketPriority"><?php esc_html_e('اولویت', 'woodmartplus'); ?><?php echo wplus_helper::get_setting('ticket_required_priority') ? '<span class="text_danger">*</span>' : '' ?></label>
                  <select class="ticket_select_items" name="wplus_ticket_priority"  data-required="<?php echo wplus_helper::get_setting('ticket_required_priority') ? 1 : 0 ?>" >
                     <option value="priority_default"><?php esc_html_e('دپارتمان را انتخاب کنید', 'woodmartplus'); ?></option>
                     <?php foreach ($priorities as $key => $priority): ?>
                        <option value="<?php echo esc_attr($key); ?>"><?php echo esc_html($priority); ?></option>
                     <?php endforeach; ?>
                  </select>
               </div>
               <?php if ($orders && wplus_helper::get_setting('ticket_enable_order')): ?>
                  <div class="solid_input">
                     <label for="sltTicketProduct"><?php esc_html_e('محصولات سفارش', 'woodmartplus'); ?><?php echo wplus_helper::get_setting('ticket_require_order') ? '<span class="text_danger">*</span>' : '' ?></label>
                     <select class="ticket_select_items" name="ticket_customer_product"  data-required="<?php  echo wplus_helper::get_setting('ticket_require_order') ? 1 : 0 ?>">
                        <option value="default"><?php esc_html_e('انتخاب محصول','woodmartplus'); ?></option>
                        <?php foreach ($orders as $key => $product_name): ?>
                           <option value="<?php echo esc_attr($key) ?>">
                                 <?php echo esc_html( $product_name ); ?>
                           </option>
                        <?php endforeach; ?>
                     </select>
                  </div>
               <?php endif; ?>
            </div>
            <div class="solid_input">
               <label for="txtTicketDescription"><?php esc_html_e('توضیحات', 'woodmartplus'); ?> <?php echo wplus_helper::get_setting('ticket_required_description') ? '<span class="text_danger">*</span>' : '' ?></label>
               <textarea rows="5" id="txtTicketDescription" <?php echo wplus_helper::get_setting('ticket_required_description') ? 'required' : '' ?> name="ticket_description" placeholder="<?php esc_html_e('توضیحات تیکت خود را وارد کنید', 'woodmartplus'); ?>"></textarea>
            </div>
            <div class="ticket_images__uploaded">
               <div class="avatar_image">
               </div>
               <div id="uploaded-files-list" class="uploaded-files-list">
               </div>
            </div>
            <?php if( wplus_helper::get_setting('upload_ticket_file') ): ?>
            <label for="uploaderTicket" class="upload_image__button">
               <input id="uploaderTicket" type="file" name="uploadTicket[]" multiple>
               <span data-multiple="true">
                  <svg xmlns="http://www.w3.org/2000/svg" width="20" height="21" viewBox="0 0 20 21" fill="none">
                     <path d="M13.6997 7.91602C16.6997 8.17435 17.9247 9.71602 17.9247 13.091V13.1993C17.9247 16.9243 16.4331 18.416 12.7081 18.416H7.28307C3.55807 18.416 2.06641 16.9243 2.06641 13.1993V13.091C2.06641 9.74102 3.27474 8.19935 6.22474 7.92435" stroke="#4D4D4D" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                     <path d="M10 13.0009V3.51758" stroke="#4D4D4D" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                     <path d="M12.7913 5.37565L9.99967 2.58398L7.20801 5.37565" stroke="#4D4D4D" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
                  </svg>
                  <p><?php esc_html_e('آپلود فایل', 'woodmartplus'); ?></p>
               </span>
            </label>
            <?php endif; ?>
            <div class="justify_end">
               <button type="submit" class="btn solid medium" name="send_ticket">
                  <?php esc_html_e('ارسال تیکت', 'woodmartplus'); ?>
               </button>
            </div>
         </form>
      </div>
   </div>
</div>
<script>
   document.addEventListener('DOMContentLoaded', function() {
      const fileInput = document.getElementById('uploaderTicket');
      const filesList = document.getElementById('uploaded-files-list');

      function updateFileInput(files) {
         const dataTransfer = new DataTransfer();
         for (let i = 0; i < files.length; i++) {
            dataTransfer.items.add(files[i]);
         }
         fileInput.files = dataTransfer.files;

         displayFiles();
      }

      function displayFiles() {
         filesList.innerHTML = '';

         if (fileInput.files.length > 0) {
            for (let i = 0; i < fileInput.files.length; i++) {
               const file = fileInput.files[i];
               const fileItem = document.createElement('div');
               fileItem.className = 'file-item';

               const fileName = document.createElement('span');
               fileName.className = 'file-name';
               fileName.textContent = file.name;

               const removeBtn = document.createElement('button');
               removeBtn.className = 'remove-file';
               removeBtn.innerHTML = '&times;';
               removeBtn.type = 'button';
               removeBtn.dataset.index = i;
               removeBtn.addEventListener('click', function() {
                  const files = Array.from(fileInput.files);
                  files.splice(i, 1);
                  updateFileInput(files);
               });

               fileItem.appendChild(fileName);
               fileItem.appendChild(removeBtn);
               filesList.appendChild(fileItem);
            }
         }
      }

      fileInput.addEventListener('change', function() {
         displayFiles();
      });
   });
</script>
<style>
   .uploaded-files-list {
      margin-top: 10px;
   }

   .file-item {
      display: flex;
      justify-content: space-between;
      align-items: center;
      padding: 5px 10px;
      margin-bottom: 5px;
      background-color: #f5f5f5;
      border-radius: 4px;
   }

   .file-name {
      flex-grow: 1;
      margin-right: 10px;
   }

   .remove-file {
      background: none;
      border: none;
      color: #ff0000;
      cursor: pointer;
      font-size: 18px;
      font-weight: bold;
   }
</style>