<div class="white_card">
    <div class="section_head">
        <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none">
            <path
                d="M22 12C22 17.52 17.52 22 12 22C6.48 22 2 17.52 2 12C2 6.48 6.48 2 12 2C17.52 2 22 6.48 22 12Z"
                stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
            <path d="M15.7099 15.18L12.6099 13.33C12.0699 13.01 11.6299 12.24 11.6299 11.61V7.51001"
                stroke="currentColor" stroke-width="1.5" stroke-linecap="round" stroke-linejoin="round" />
        </svg>
        <p><?php esc_html_e('زمانبندی ارسال', 'woodmartplus'); ?></p>
        <hr />
    </div>
    <div class="tabbar_container--2">
        <div class="tabbar_container__buttons">
            <?php $b = 0;
            foreach ($weeks_time as $key => $value): ?>
                <div class="tabbar_container__button col <?php echo $b === 0 ? 'show' : '' ?>">
                    <div class="gap-y">
                        <p><?php echo $object->get_date_from_day($key); ?></p>
                        <p class="desc"><?php echo $object->translate_day_week($key); ?></p>
                    </div>
                </div>
            <?php $b++;
            endforeach; ?>

        </div>
        <div class="tabbar_container__contents">
            <?php $i = 0;
            foreach ($weeks_time as $key_day => $times): ?>
                <div class="outline_card tabbar_container__content <?php echo $i === 0 ? 'show' : '' ?>">
                    <div class="items_container--4">
                        <?php foreach ($times as $time): ?>
                            <label for="time-<?php echo $i ?>" class="select_box">
                                <input type="radio" id="time-<?php echo $i ?>" name="shipping_time" value="<?php echo $object->generate_value_input($key_day, $time); ?>" />
                                <div class="select_box__content">
                                    <p><?php echo esc_html($time); ?></p>
                                </div>
                            </label>
                        <?php $i++;
                        endforeach; ?>
                    </div>
                </div>
            <?php
            endforeach; ?>
        </div>
    </div>
</div>


<style>
    .woocommerce-checkout .tabbar_container__button p{
        font-size: 12px !important;
    }
    .white_card {
        display: flex;
        flex-direction: column;
        gap: 1.5rem;
        border-radius: 1rem;
        padding: 1.5rem;
        background-color: #FFFFFF;
        box-shadow: 0px 4px 40px 0px rgba(0, 0, 0, 0.05);
    }

    .section_head {
        width: 100%;
        display: flex;
        align-items: center;
        gap: 0.5rem;
        color: #4D4D4D;
    }

    .tabbar_container--2 {
        overflow-x: hidden;
    }

    .section_head svg {
        width: 25px;
        height: 25px;
    }

    .tabbar_container--2 .tabbar_container__buttons {
        display: flex;
        overflow-x: auto;
        padding: 0 1rem;
    }

    .tabbar_container--2 .tabbar_container__buttons .tabbar_container__button.show {
        color: #1280E6;
    }

    .tabbar_container--2 .tabbar_container__buttons .tabbar_container__button.col {
        flex-direction: column;
        gap: 0.5rem;
    }

    .tabbar_container--2 .tabbar_container__buttons .tabbar_container__button {
        display: flex;
        align-items: center;
        gap: 0.5rem;
        position: relative;
        min-width: 100px;
        text-align: center;
        padding: 1rem 1.2rem;
        font-weight: 500;
        cursor: pointer;
    }

    .gap-y {
        display: flex;
        flex-direction: column;
        row-gap: 0.5rem;
    }

    .tabbar_container--2 .tabbar_container__buttons .tabbar_container__button.show::after {
        background: #1280E6;
    }

    .tabbar_container--2 .tabbar_container__buttons .tabbar_container__button::after {
        content: "";
        position: absolute;
        bottom: 0;
        left: 0;
        right: 0;
        width: 100%;
        height: 4px;
        border-radius: 2px 2px 0px 0px;
        background: transparent;
    }

    .tabbar_container--2 .tabbar_container__buttons .tabbar_container__button.show p.desc {
        color: inherit;
    }

    .tabbar_container--2 .tabbar_container__buttons .tabbar_container__button p.desc {
        color: #999999;
        font-size: 0.8rem;
    }

    .tabbar_container--2 .tabbar_container__contents .tabbar_container__content.show {
        display: block;
    }

    .tabbar_container--2 .tabbar_container__contents .tabbar_container__content {
        display: none;
        padding: 1rem;
        width: 100%;
    }

    .outline_card {
        display: flex;
        flex-direction: column;
        gap: 1rem;
        padding: 1rem;
        border-radius: 0.5rem;
        border: 1px solid #E5E5E5;
    }

    .items_container--4 {
        display: grid;
        grid-template-columns: repeat(1, minmax(0, 1fr));
        gap: 1rem;
    }

    @media (min-width: 756px) {
        .items_container--4 {
            grid-template-columns: repeat(2, minmax(0, 1fr));
        }
    }

    @media (min-width: 980px) {
        .items_container--4 {
            grid-template-columns: repeat(4, minmax(0, 1fr));
        }
    }

    .select_box {
        position: relative;
        cursor: pointer;
        transition: background 250ms;
    }

    .select_box input[type=radio] {
        width: 16px;
        height: 16px;
    }

    .select_box input {
        position: absolute;
        right: .5rem;
        top: 50%;
        transform: translateY(-50%);
    }

    input[type=radio]::after {
        content: " ";
        position: absolute;
        top: 4.5px;
        left: 4.5px;
    }

    input[type=radio]::after {
        content: " ";
        position: absolute;
        top: 6px;
        left: 6px;
        transform: scale(0);
        width: 6px;
        height: 6px;
        background-color: #FFFFFF;
        border-radius: 50%;
    }

    .select_box .select_box__content {
        display: flex;
        flex-direction: column;
        padding: 1rem 2rem 1rem 1rem;
        gap: 1rem;
        border-radius: 4px;
        border: 1px solid #E5E5E5;
        transform: all 250ms ease-in;
    }
</style>