<div class="container_orderpage">
    <header>
        <h1><?php esc_html_e('پیگیری سفارش', 'woodmartplus'); ?></h1>
        <p><?php esc_html_e('وضعیت سفارش خود را به راحتی پیگیری کنید', 'woodmartplus'); ?></p>
    </header>

    <div class="search-box">
        <div class="form-container">
            <div class="input-group">
                <label for="order-number"><?php esc_html_e('شماره سفارش', 'woodmartplus'); ?></label>
                <div class="input-wrapper">
                    <svg class="input-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"> <circle cx="9" cy="21" r="1"></circle> <circle cx="20" cy="21" r="1"></circle> <path d="M1 1h4l2.68 13.39a2 2 0 0 0 2 1.61h9.72a2 2 0 0 0 2-1.61L23 6H6"></path> </svg>
                    <input type="text" id="order-number" placeholder="<?php esc_html_e('شماره سفارش خود را وارد کنید', 'woodmartplus'); ?>">
                </div>
            </div>
            <div class="input-group">
                <label for="phone-number"><?php esc_html_e('شماره موبایل', 'woodmartplus'); ?></label>
                <div class="input-wrapper">
                    <svg class="input-icon" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round"> <rect x="5" y="2" width="14" height="20" rx="2" ry="2"></rect> <line x1="12" y1="18" x2="12" y2="18"></line> </svg>
                    <input type="text" id="phone-number" placeholder="<?php esc_html_e('شماره موبایل خود را وارد کنید', 'woodmartplus'); ?>">
                </div>
            </div>
            <button id="track-order" class="btn-track">
                <svg viewBox="0 0 24 24" width="24" height="24">
                    <path fill="currentColor" d="M9.5,3A6.5,6.5 0 0,1 16,9.5C16,11.11 15.41,12.59 14.44,13.73L14.71,14H15.5L20.5,19L19,20.5L14,15.5V14.71L13.73,14.44C12.59,15.41 11.11,16 9.5,16A6.5,6.5 0 0,1 3,9.5A6.5,6.5 0 0,1 9.5,3M9.5,5C7,5 5,7 5,9.5C5,12 7,14 9.5,14C12,14 14,12 14,9.5C14,7 12,5 9.5,5Z" />
                </svg>
                <?php esc_html_e('پیگیری سفارش', 'woodmartplus'); ?>
            </button>
        </div>
    </div>

    <div class="result-container" id="result-container" style="display: none;">

        <div class="order-details">
            <h2><?php esc_html_e('اطلاعات سفارش', 'woodmartplus'); ?> <span id="order-id"></span></h2>

            <div class="details-grid">
                <div class="detail-item">
                    <div class="detail-icon">
                        <svg viewBox="0 0 24 24" width="24" height="24">
                            <path fill="currentColor" d="M12,4A4,4 0 0,1 16,8A4,4 0 0,1 12,12A4,4 0 0,1 8,8A4,4 0 0,1 12,4M12,14C16.42,14 20,15.79 20,18V20H4V18C4,15.79 7.58,14 12,14Z" />
                        </svg>
                    </div>
                    <div class="detail-content">
                        <span class="detail-label"><?php esc_html_e('نام خریدار', 'woodmartplus'); ?></span>
                        <span class="detail-value" id="customer-name"></span>
                    </div>
                </div>

                <div class="detail-item">
                    <div class="detail-icon">
                        <svg viewBox="0 0 24 24" width="24" height="24">
                            <path fill="currentColor" d="M19,19H5V8H19M16,1V3H8V1H6V3H5C3.89,3 3,3.89 3,5V19A2,2 0 0,0 5,21H19A2,2 0 0,0 21,19V5C21,3.89 20.1,3 19,3H18V1" />
                        </svg>
                    </div>
                    <div class="detail-content">
                        <span class="detail-label"><?php esc_html_e('تاریخ سفارش', 'woodmartplus'); ?></span>
                        <span class="detail-value" id="order-date"></span>
                    </div>
                </div>

                <div class="detail-item">
                    <div class="detail-icon">
                        <svg viewBox="0 0 24 24" width="24" height="24">
                            <path fill="currentColor" d="M5,6H23V18H5V6M14,9A3,3 0 0,1 17,12A3,3 0 0,1 14,15A3,3 0 0,1 11,12A3,3 0 0,1 14,9M9,8A2,2 0 0,1 7,10V14A2,2 0 0,1 9,16H19A2,2 0 0,1 21,14V10A2,2 0 0,1 19,8H9M1,10H3V20H19V22H1V10Z" />
                        </svg>
                    </div>
                    <div class="detail-content">
                        <span class="detail-label"><?php esc_html_e('روش پرداخت', 'woodmartplus'); ?></span>
                        <span class="detail-value" id="payment-method"></span>
                    </div>
                </div>

                <div class="detail-item">
                    <div class="detail-icon">
                        <svg viewBox="0 0 24 24" width="24" height="24">
                            <path fill="currentColor" d="M12,11.5A2.5,2.5 0 0,1 9.5,9A2.5,2.5 0 0,1 12,6.5A2.5,2.5 0 0,1 14.5,9A2.5,2.5 0 0,1 12,11.5M12,2A7,7 0 0,0 5,9C5,14.25 12,22 12,22C12,22 19,14.25 19,9A7,7 0 0,0 12,2Z" />
                        </svg>
                    </div>
                    <div class="detail-content">
                        <span class="detail-label"><?php esc_html_e('شهر مقصد', 'woodmartplus'); ?></span>
                        <span class="detail-value" id="destination-city"></span>
                    </div>
                </div>

                <div class="detail-item">
                    <div class="detail-icon">
                        <svg viewBox="0 0 24 24" width="24" height="24">
                            <path fill="currentColor" d="M18,18.5A1.5,1.5 0 0,1 16.5,17A1.5,1.5 0 0,1 18,15.5A1.5,1.5 0 0,1 19.5,17A1.5,1.5 0 0,1 18,18.5M19.5,9.5L21.46,12H17V9.5M6,18.5A1.5,1.5 0 0,1 4.5,17A1.5,1.5 0 0,1 6,15.5A1.5,1.5 0 0,1 7.5,17A1.5,1.5 0 0,1 6,18.5M20,8H17V4H3C1.89,4 1,4.89 1,6V17H3A3,3 0 0,0 6,20A3,3 0 0,0 9,17H15A3,3 0 0,0 18,20A3,3 0 0,0 21,17H23V12L20,8Z" />
                        </svg>
                    </div>
                    <div class="detail-content">
                        <span class="detail-label"><?php esc_html_e('روش ارسال', 'woodmartplus'); ?></span>
                        <span class="detail-value" id="shipping-method"></span>
                    </div>
                </div>

                <div class="detail-item">
                    <div class="detail-icon">
                        <svg viewBox="0 0 24 24" width="24" height="24">
                            <path fill="currentColor" d="M12,2A10,10 0 0,1 22,12A10,10 0 0,1 12,22A10,10 0 0,1 2,12A10,10 0 0,1 12,2M12,4A8,8 0 0,0 4,12A8,8 0 0,0 12,20A8,8 0 0,0 20,12A8,8 0 0,0 12,4M11,17V16H9V14H13V13H10A1,1 0 0,1 9,12V9A1,1 0 0,1 10,8H11V7H13V8H15V10H11V11H14A1,1 0 0,1 15,12V15A1,1 0 0,1 14,16H13V17H11Z" />
                        </svg>
                    </div>
                    <div class="detail-content">
                        <span class="detail-label"><?php esc_html_e('مبلغ کل', 'woodmartplus'); ?></span>
                        <span class="detail-value" id="total-amount"></span>
                    </div>
                </div>
            </div>
        </div>

        <?php $order_settings = wplus_helper::get_setting('order_tracking'); ?>

        <div class="order-status">
            <h2><?php esc_html_e('وضعیت سفارش', 'woodmartplus'); ?></h2>
            <div class="status-timeline">

                <?php if( $steps ): ?>
                    <?php foreach( $steps as $step ):?>
                        <?php 
                            
                            $status = isset( $step['step_status'] ) && !empty( $step['step_status'] ) ? $step['step_status'] : [];
                            $new_status ='';
                            if( $status )
                            {
                                $new_status = str_replace('wc-','',$status);
                            }
                            ?>
                        <div class="status-step" data-step="<?php echo $new_status ? implode(',',$new_status) : '' ?>">
                            <?php if( $step['step_image'] ): ?>
                                <div class="step-icon">
                                    <?php $img_id = $step['step_image']; ?>
                                    <?php
                                        $image = '';
                                        if( $img_id )
                                        {
                                            $img_src = wp_get_attachment_image_src($img_id, 'thumbnail');
                                            if( isset( $img_src[0] ) )
                                            {
                                                $image = $img_src[0];
                                            }
                                        }
                                    ?> 
                                    <img class="img-responsive" src="<?php echo isset($image) ? $image : '' ?>">
                                    <?php else: ?>
                                        <svg viewBox="0 0 24 24" width="24" height="24">
                                            <path fill="currentColor" d="M21,7L9,19L3.5,13.5L4.91,12.09L9,16.17L19.59,5.59L21,7Z" />
                                        </svg>
                                    <?php endif; ?>
                                </div>
                            <div class="step-label"><?php echo isset( $step['step_title'] ) && !empty( $step['step_title'] ) ? $step['step_title'] : '' ?></div>
                            <div class="tooltip"><?php echo isset( $step['step_tooltip'] ) && !empty( $step['step_tooltip'] ) ? $step['step_tooltip'] : '' ?></div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>

            </div>
        </div>

        <div class="order-items" style="display:none;">
            <h2><?php esc_html_e('اقلام سفارش', 'woodmartplus'); ?></h2>
            <div class="items-container" id="items-container">
            </div>
        </div>
    </div>

    <div id="tracking-loader" style="display: none;">
        <div class="loader-spinner"></div>
        <p><?php esc_html_e('در حال پردازش اطلاعات...', 'woodmartplus'); ?></p>
    </div>
</div>