<div class="item br-bottom p-18">
    <span class="title"><?php echo esc_html_e('حداقل مبلغ سفارش', 'woodmartplus'); ?></span>
    <p class="des"><?php esc_html_e('حداقل مبلغ سفارش را تعیین کنید', 'woodmartplus') ?></p>
    <div class="suggestion-inputs gray-inp">

        <input type="number" class="left-text" name="<?php echo wplus_helper::generate_option('[minimum_order_amount]'); ?>" value="<?php wplus_helper::show_value('minimum_order_amount'); ?>">
    </div>
</div>

<div class="item p-18 br-bottom">
    <span class="title"><?php esc_html_e('فروش به استان ها', 'woodmartplus') ?></span>
    <p class="des"><?php esc_html_e('تنظیم فروش به استان ها', 'woodmartplus') ?></p>
    <div class="dropdown_select">
        <select name="<?php echo wplus_helper::generate_option('[state_how_sell]'); ?>" class="dropdown state_how_sell">
            <option disabled=""><?php esc_html_e('لطفا یک گزینه را انتخاب کنید', 'woodmartplus') ?></option>
            <option value="all_state" <?php selected('all_state', wplus_helper::show_value('state_how_sell', false)); ?>><?php esc_html_e('فروش به تمام استان ها', 'woodmartplus'); ?></option>
            <option value="unique_state" <?php selected('unique_state', wplus_helper::show_value('state_how_sell', false));  ?>><?php esc_html_e('فروش به استان های خاص', 'woodmartplus'); ?></option>
        </select>
    </div>
</div>
<?php $states = wplus_helper::get_setting('states', []); ?>
<div class="item p-18 br-bottom unique_state" style="display: none;">
    <span class="title"><?php esc_html_e('انتخاب استان', 'woodmartplus') ?></span>
    <p class="des"><?php esc_html_e('انتخاب یک یا بیش از یک استان', 'woodmartplus') ?></p>
    <div>
        <select class="js-example-basic-multiple" name="<?php echo wplus_helper::generate_option('[states][]'); ?>" multiple="multiple" dir="rtl">
            <?php foreach (wplus_helper::get_iran_state('IR') as $key_state =>  $state): ?>
                <option value="<?php echo esc_html($key_state); ?>" <?php echo in_array($key_state, $states) ? 'selected' : ''; ?>><?php echo esc_html($state); ?></option>
            <?php endforeach; ?>
        </select>
    </div>
</div>

<div class="item p-18 br-bottom">
    <span class="title"><?php esc_html_e('فعال سازی حالت لیستی شهر ها', 'woodmartplus'); ?></span>
    <p class="des"><?php esc_html_e('در حساب کاربری شهر ها حالت سلکت قرار میگیرند', 'woodmartplus') ?></p>
    <div class="btn-select">
        <input type="checkbox" class="switch" name="<?php echo wplus_helper::generate_option('[city_list]'); ?>" <?php echo wplus_helper::show_value('city_list', false) ? 'checked' : '' ?>>
    </div>
</div>

<div class="item p-18 br-bottom">
    <span class="title"><?php esc_html_e('جابه جایی فیلد استان و شهر', 'woodmartplus'); ?></span>
    <p class="des"><?php esc_html_e('امکان دارد در قالب شما مکان فیلد ها تغییر کرده باشد', 'woodmartplus') ?></p>
    <div class="btn-select">
        <input type="checkbox" class="switch" name="<?php echo wplus_helper::generate_option('[displacement_state_city]'); ?>" <?php echo wplus_helper::show_value('displacement_state_city', false) ? 'checked' : '' ?>>
    </div>
</div>

<div class="item p-18 br-bottom">
    <span class="title"><?php esc_html_e('اعداد فارسی در کدپستی', 'woodmartplus'); ?></span>
    <p class="des"><?php esc_html_e('تبدیل اعداد فارسی به انگلیسی', 'woodmartplus') ?></p>
    <div class="btn-select">
        <input type="checkbox" class="switch" name="<?php echo wplus_helper::generate_option('[en_number_postalcode]'); ?>" <?php echo wplus_helper::show_value('en_number_postalcode', false) ? 'checked' : '' ?>>
    </div>
</div>

<div class="item p-18 br-bottom">
    <span class="title"><?php esc_html_e('بررسی کدپستی', 'woodmartplus'); ?></span>
    <p class="des"><?php esc_html_e('بررسی اینکه کدپستی 10 رقمی میباشد', 'woodmartplus') ?></p>
    <div class="btn-select">
        <input type="checkbox" class="switch" name="<?php echo wplus_helper::generate_option('[check_number_postcode]'); ?>" <?php echo wplus_helper::show_value('check_number_postcode', false) ? 'checked' : '' ?>>
    </div>
</div>

<div class="item p-18 br-bottom">
    <span class="title"><?php esc_html_e('اعداد فارسی در موبایل', 'woodmartplus'); ?></span>
    <p class="des"><?php esc_html_e('تبدیل اعداد فارسی به انگلیسی', 'woodmartplus') ?></p>
    <div class="btn-select">
        <input type="checkbox" class="switch" name="<?php echo wplus_helper::generate_option('[en_number_phone]'); ?>" <?php echo wplus_helper::show_value('en_number_phone', false) ? 'checked' : '' ?>>
    </div>
</div>

<div class="item p-18 br-bottom">
    <span class="title"><?php esc_html_e('بررسی شماره موبایل', 'woodmartplus'); ?></span>
    <p class="des"><?php esc_html_e('بررسی اینکه شماره موبایل 11 رقمی میباشد', 'woodmartplus') ?></p>
    <div class="btn-select">
        <input type="checkbox" class="switch" name="<?php echo wplus_helper::generate_option('[check_number_phone]'); ?>" <?php echo wplus_helper::show_value('check_number_phone', false) ? 'checked' : '' ?>>
    </div>
</div>


<div class="item p-18 br-bottom">
    <span class="title"><?php esc_html_e('حذف فیلد های غیر ضروری', 'woodmartplus'); ?></span>
    <p class="des"><?php esc_html_e('صرفا فیلد های که قرار داده میشود (نام و نام خانوادگی ، ایمیل و موبایل)', 'woodmartplus') ?></p>
    <div class="btn-select">
        <input type="checkbox" class="switch" name="<?php echo wplus_helper::generate_option('[remove_fields_checkout]'); ?>" <?php echo wplus_helper::show_value('remove_fields_checkout', false) ? 'checked' : '' ?>>
    </div>
</div>