<?php $ticket_notif = wplus_helper::get_setting('ticket_notif', []); ?>

<div class="item p-18 br-bottom">
   <span class="title"><?php esc_html_e('فعال کردن تیکت', 'woodmartplus'); ?></span>
   <p class="des"><?php esc_html_e('تیکت خود را فعال و یا غیر فعال کنید.', 'woodmartplus'); ?></p>
   <div class="btn-select">
      <input type="checkbox" class="switch" name="<?php echo wplus_helper::generate_option('[setting_ticket_enable]'); ?>" <?php echo wplus_helper::show_value('setting_ticket_enable', false) ? 'checked' : '' ?>>
   </div>
</div>

<div class="item p-18 br-bottom">
   <span class="title"><?php esc_html_e('فعال کردن محصول در تیکت', 'woodmartplus'); ?></span>
   <p class="des"><?php esc_html_e('با فعال کردن این گزینه ، کاربر زمان ارسال تیکت میتواند ، محصول (خریداری شده) خود را انتخاب کند', 'woodmartplus'); ?></p>
   <div class="btn-select">
      <input type="checkbox" class="switch" name="<?php echo wplus_helper::generate_option('[ticket_enable_order]'); ?>" <?php echo wplus_helper::show_value('ticket_enable_order', false) ? 'checked' : '' ?> data-condition="ticker_require_order_condition">
   </div>
</div>
<div class="item p-18 br-bottom ticker_require_order_condition">
   <span class="title"><?php esc_html_e('ضروری بودن محصول', 'woodmartplus'); ?></span>
   <p class="des"><?php esc_html_e('آیا برای ارسال تیکت ، انتخاب محصول ضروری باشد ؟', 'woodmartplus'); ?></p>
   <div class="btn-select">
      <input type="checkbox" class="switch" name="<?php echo wplus_helper::generate_option('[ticket_require_order]'); ?>" <?php echo wplus_helper::show_value('ticket_require_order', false) ? 'checked' : '' ?>>
   </div>
</div>

<div class="item p-18 br-bottom">
   <span class="title"><?php esc_html_e('ضروری بودن عنوان', 'woodmartplus'); ?></span>
   <p class="des"><?php esc_html_e('زمان ارسال تیکت از سمت کاربر عنوان ضروری باشد.', 'woodmartplus'); ?></p>
   <div class="btn-select">
      <input type="checkbox" class="switch" name="<?php echo wplus_helper::generate_option('[ticket_required_title]'); ?>" <?php echo wplus_helper::show_value('ticket_required_title', false) ? 'checked' : '' ?>>
   </div>
</div>

<div class="item p-18 br-bottom">
   <span class="title"><?php esc_html_e('ضروری بودن توضیحات', 'woodmartplus'); ?></span>
   <p class="des"><?php esc_html_e('زمان ارسال تیکت از سمت کاربر توضیحات ضروری باشد.', 'woodmartplus'); ?></p>
   <div class="btn-select">
      <input type="checkbox" class="switch" name="<?php echo wplus_helper::generate_option('[ticket_required_description]'); ?>" <?php echo wplus_helper::show_value('ticket_required_description', false) ? 'checked' : '' ?>>
   </div>
</div>

<div class="item p-18 br-bottom">
   <span class="title"><?php esc_html_e('ضروری بودن دپارتمان', 'woodmartplus'); ?></span>
   <p class="des"><?php esc_html_e('زمان ارسال تیکت از سمت کاربر انتخاب دپارتمان ضروری باشد.', 'woodmartplus'); ?></p>
   <div class="btn-select">
      <input type="checkbox" class="switch" name="<?php echo wplus_helper::generate_option('[ticket_required_departeman]'); ?>" <?php echo wplus_helper::show_value('ticket_required_departeman', false) ? 'checked' : '' ?>>
   </div>
</div>

<div class="item p-18 br-bottom">
   <span class="title"><?php esc_html_e('ضروری بودن اولویت', 'woodmartplus'); ?></span>
   <p class="des"><?php esc_html_e('زمان ارسال تیکت از سمت کاربر انتخاب اولویت ضروری باشد.', 'woodmartplus'); ?></p>
   <div class="btn-select">
      <input type="checkbox" class="switch" name="<?php echo wplus_helper::generate_option('[ticket_required_priority]'); ?>" <?php echo wplus_helper::show_value('ticket_required_priority', false) ? 'checked' : '' ?>>
   </div>
</div>

<div class="item p-18 br-bottom">
   <span class="title"><?php esc_html_e('تعداد فایل', 'woodmartplus') ?></span>
   <p class="des"><?php esc_html_e('کاربر چه تعداد فایل میتواند در تیکت آپلود کند؟', 'woodmartplus'); ?></p>
   <div class="inp-rang p-top-18">
      <input type="range" class="rang" min="1" max="10" name="<?php echo wplus_helper::generate_option('[number_ticket_file_upload]'); ?>" value="<?php wplus_helper::show_value('number_ticket_file_upload'); ?>">
      <div class="br-radius-8 rang-number d-center">
         <span class="num">2</span><span class="text-num"><?php esc_html_e('تعداد', 'woodmartplus'); ?></span>
      </div>
   </div>
</div>

<div class="item p-18 br-bottom">
   <span class="title"><?php esc_html_e('سایز فایل', 'woodmartplus') ?></span>
   <p class="des"><?php esc_html_e('حد اکثیر فایل حجم فایل برای آپلود را تعیین کنید ، بر حسب (MB)', 'woodmartplus'); ?></p>
   <div class="inp-rang p-top-18">
      <input type="range" class="rang" min="1" max="10" name="<?php echo wplus_helper::generate_option('[size_ticket_file_upload]'); ?>" value="<?php wplus_helper::show_value('size_ticket_file_upload'); ?>">
      <div class="br-radius-8 rang-number d-center">
         <span class="num">2</span><span class="text-num"><?php esc_html_e('MB', 'woodmartplus'); ?></span>
      </div>
   </div>
</div>

<div class="item p-top-18 offer_section">
   <span class="title"><?php esc_html_e('سوالات متداول', 'woodmartplus') ?></span>
   <p class="des"><?php esc_html_e('ایجاد سوالات متداول (قبل از ارسال تیکت به کاربر نمایش داده میشود)', 'woodmartplus'); ?></p>
   <div data-repeater-list="<?php echo wplus_helper::generate_option('[ticket_question_answer]'); ?>">
      <?php foreach (
         wplus_helper::get_setting('ticket_question_answer', [
            'default_slider' => [
               'question',
               'answer',
            ]
         ]) as $slider
      ): ?>
         <section class="repeater-sections-slider-images add-suggestions m-t-18 opened" data-repeater-item>
            <div class="br-radius-8 opened">

               <div class="suggestion-title">
                  <span class="suggestion-menu">
                     <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/menu.svg" alt="">
                     <p><?php esc_html_e('سوال جدید', 'woodmartplus'); ?></p>
                  </span>
                  <span class="arrow-icon"><img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/arrow-down2.svg" alt=""></span>
               </div>

               <div class="suggestion-content">
                  <div class="suggestion-inputs">
                     <div>
                        <input type="text" name="question" id="" placeholder="<?php esc_html_e('عنوان', 'woodmartplus'); ?>" value="<?php echo isset($slider['question']) && !empty($slider['question']) ? $slider['question']  : '' ?>">
                     </div>
                     <div>
                        <textarea name="answer" placeholder="<?php esc_html_e('توضیحات', 'woodmartplus'); ?>" id=""><?php echo isset($slider['answer']) && !empty($slider['answer']) ? $slider['answer']  : '' ?></textarea>
                     </div>
                  </div>
               </div>

               <div class="suggestion-btns">
                  <input class="delete-btn" data-repeater-delete type="button" value="<?php esc_html_e('حذف سوال', 'woodmartplus') ?>">
               </div>
            </div>
         </section>
      <?php endforeach; ?>
   </div>
   <input class="add-btn blue-btn m-t-18" style="display:inline-block" data-repeater-create type="button" value="<?php esc_html_e('افزودن سوال', 'woodmartplus') ?>">
</div>

<div class="item p-18 br-bottom">
   <span class="title"><?php esc_html_e('فایل های مجاز', 'woodmartplus') ?></span>
   <p class="des"><?php esc_html_e('چه فایل های برای آپلود مجاز هستند؟', 'woodmartplus'); ?></p>
   <div>
      <?php $mim_type = wplus_helper::get_setting('allowed_mim_type_ticket', []); ?>
      <select class="js-example-basic-multiple" name="<?php echo wplus_helper::generate_option('[allowed_mim_type_ticket][]'); ?>" multiple="multiple" dir="rtl">
         <?php foreach (wplus_helper::allowed_mim_type() as $key => $value): ?>
            <option value="<?php echo esc_attr($key) ?>" <?php echo in_array($key, $mim_type) ? 'selected' : '' ?>><?php echo esc_html($value); ?></option>
         <?php endforeach; ?>
      </select>
   </div>
</div>

