<?php

$shipping_time = wplus_helper::get_setting('shipping_time');
$saturday_times = isset($shipping_time['saturday-time']) && !empty($shipping_time['saturday-time']) ?  $shipping_time['saturday-time'] : [''];
$sunday_times = isset($shipping_time['sunday-time']) && !empty($shipping_time['sunday-time']) ?  $shipping_time['sunday-time'] : [''];
$monday_times = isset($shipping_time['monday-time']) && !empty($shipping_time['monday-time']) ?  $shipping_time['monday-time'] : [''];
$tuesday_times = isset($shipping_time['tuesday-time']) && !empty($shipping_time['tuesday-time']) ?  $shipping_time['tuesday-time'] : [''];
$wednesday_times = isset($shipping_time['wednesday-time']) && !empty($shipping_time['wednesday-time']) ?  $shipping_time['wednesday-time'] : [''];
$thursday_times = isset($shipping_time['thursday-time']) && !empty($shipping_time['thursday-time']) ?  $shipping_time['thursday-time'] : [''];
$friday_times = isset($shipping_time['friday-time']) && !empty($shipping_time['friday-time']) ?  $shipping_time['friday-time'] : [''];

?>
<div class="item p-18 br-bottom">
    <span class="title"><?php esc_html_e('فعال کردن زمان ارسال', 'woodmartplus'); ?></span>
    <p class="des"></p>
    <div class="btn-select">
        <input type="checkbox" class="switch" name="<?php echo wplus_helper::generate_option('[enable_shipping_time]'); ?>" <?php echo wplus_helper::show_value('enable_shipping_time', false) ? 'checked' : '' ?>>
    </div>
</div>

<div class="item p-18 br-bottom">
    <span class="title"><?php esc_html_e('آیا ضروری باشد؟', 'woodmartplus'); ?></span>
    <p class="des"><?php esc_html_e('با ضرور کردن این فیلد کاربر بایستی زمان پرداخت یک زمان ارسال انتخاب کند', 'woodmartplus'); ?></p>
    <div class="btn-select">
        <input type="checkbox" class="switch" name="<?php echo wplus_helper::generate_option('[shipping_time_required]'); ?>" <?php echo wplus_helper::show_value('shipping_time_required', false) ? 'checked' : '' ?>>
    </div>
</div>

<div class="item p-top-18">
    <span class="title"><?php esc_html_e('تنظیمات مروبط به روز های هفته', 'woodmartplus'); ?></span>
    <p class="des"><?php esc_html_e('زمان ارسال در روز های هفته را مشخص کنید.', 'woodmartplus'); ?> </p>
    <div class="setting-days-wrapper">
        <div class="shipping-time br-radius-8">
            <div class="send-day">
                <input type="checkbox" name="<?php echo wplus_helper::generate_option('[shipping_time][saturday]'); ?>" <?php echo isset($shipping_time['saturday']) ? 'checked' : '' ?>>
                <label for=""><?php esc_html_e('شنبه', 'woodmartplus'); ?></label>
            </div>
            <div class="send-time">
                <?php foreach ($saturday_times as $saturday_time): ?>
                    <div class="hours-time">
                        <input type="text" placeholder="<?php esc_html_e('ساعت 10 تا 12', 'woodmartplus'); ?>" name="<?php echo wplus_helper::generate_option('[shipping_time][saturday-time][]'); ?>" autocomplete="disable" value="<?php echo esc_html($saturday_time) ?>">
                        <button class="delete-btn">
                            <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="remove">
                        </button>
                    </div>
                <?php endforeach; ?>
                <div class="add-time">
                    <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/add-square.svg" alt="add">
                    <p><?php esc_html_e('اضافه کردن', 'woodmartplus'); ?></p>
                </div>
            </div>
        </div>
        <div class="shipping-time br-radius-8">
            <div class="send-day">
                <input type="checkbox" name="<?php echo wplus_helper::generate_option('[shipping_time][sunday]'); ?>" <?php echo isset($shipping_time['sunday']) ? 'checked' : '' ?>>
                <label for=""><?php esc_html_e('یک شنبه', 'woodmartplus'); ?></label>
            </div>
            <div class="send-time">
                <?php foreach ($sunday_times as $sunday_time): ?>
                    <div class="hours-time">
                        <input type="text" placeholder="<?php esc_html_e('ساعت 10 تا 12', 'woodmartplus'); ?>" name="<?php echo wplus_helper::generate_option('[shipping_time][sunday-time][]'); ?>" autocomplete="disable" value="<?php echo esc_html($sunday_time) ?>">
                        <button class="delete-btn">
                            <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                        </button>
                    </div>
                <?php endforeach; ?>
                <div class="add-time">
                    <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/add-square.svg" alt="">
                    <p><?php esc_html_e('اضافه کردن', 'woodmartplus'); ?></p>
                </div>
            </div>
        </div>
        <div class="shipping-time br-radius-8">
            <div class="send-day">
                <input type="checkbox" name="<?php echo wplus_helper::generate_option('[shipping_time][monday]'); ?>" <?php echo isset($shipping_time['monday']) ? 'checked' : '' ?>>
                <label for=""><?php esc_html_e('دوشنبه', 'woodmartplus'); ?></label>
            </div>
            <div class="send-time">
                <?php foreach ($monday_times as $monday_time): ?>
                    <div class="hours-time">
                        <input type="text" placeholder="<?php esc_html_e('ساعت 10 تا 12', 'woodmartplus'); ?>" name="<?php echo wplus_helper::generate_option('[shipping_time][monday-time][]'); ?>" autocomplete="disable" value="<?php echo esc_html($monday_time) ?>">
                        <button class="delete-btn">
                            <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                        </button>
                    </div>
                <?php endforeach; ?>
                <div class="add-time">
                    <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/add-square.svg" alt="">
                    <p><?php esc_html_e('اضافه کردن', 'woodmartplus'); ?></p>
                </div>
            </div>
        </div>
        <div class="shipping-time br-radius-8">
            <div class="send-day">
                <input type="checkbox" name="<?php echo wplus_helper::generate_option('[shipping_time][tuesday]'); ?>" <?php echo isset($shipping_time['tuesday']) ? 'checked' : '' ?>>
                <label for=""><?php esc_html_e('سه شنبه', 'woodmartplus'); ?></label>
            </div>
            <div class="send-time">
                <?php foreach ($tuesday_times as $tuesday_time): ?>
                    <div class="hours-time">
                        <input type="text" placeholder="<?php esc_html_e('ساعت 10 تا 12', 'woodmartplus'); ?>" name="<?php echo wplus_helper::generate_option('[shipping_time][tuesday-time][]'); ?>" autocomplete="disable" value="<?php echo esc_html($tuesday_time) ?>">
                        <button class="delete-btn">
                            <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                        </button>
                    </div>
                <?php endforeach; ?>

                <div class="add-time">
                    <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/add-square.svg" alt="">
                    <p><?php esc_html_e('اضافه کردن', 'woodmartplus'); ?></p>
                </div>
            </div>
        </div>
        <div class="shipping-time br-radius-8">
            <div class="send-day">
                <input type="checkbox" name="<?php echo wplus_helper::generate_option('[shipping_time][wednesday]'); ?>" <?php echo isset($shipping_time['wednesday']) ? 'checked' : '' ?>>
                <label for=""><?php esc_html_e('چهارشنبه', 'woodmartplus'); ?></label>
            </div>
            <div class="send-time">
                <?php foreach ($wednesday_times as $wednesday_time): ?>
                    <div class="hours-time">
                        <input type="text" placeholder="<?php esc_html_e('ساعت 10 تا 12', 'woodmartplus'); ?>" name="<?php echo wplus_helper::generate_option('[shipping_time][wednesday-time][]'); ?>" autocomplete="disable" value="<?php echo esc_html($wednesday_time); ?>">
                        <button class="delete-btn">
                            <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                        </button>
                    </div>
                <?php endforeach; ?>
                <div class="add-time">
                    <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/add-square.svg" alt="">
                    <p><?php esc_html_e('اضافه کردن', 'woodmartplus'); ?></p>
                </div>
            </div>
        </div>
        <div class="shipping-time br-radius-8">
            <div class="send-day">
                <input type="checkbox" name="<?php echo wplus_helper::generate_option('[shipping_time][thursday]'); ?>" <?php echo isset($shipping_time['thursday']) ? 'checked' : '' ?>>
                <label for=""><?php esc_html_e('پنج شنبه', 'woodmartplus'); ?></label>
            </div>
            <div class="send-time">
                <?php foreach ($thursday_times as $thursday_time): ?>
                    <div class="hours-time">
                        <input type="text" placeholder="<?php esc_html_e('ساعت 10 تا 12', 'woodmartplus'); ?>" name="<?php echo wplus_helper::generate_option('[shipping_time][thursday-time][]'); ?>" autocomplete="disable" value="<?php echo esc_html($thursday_time); ?>">
                        <button class="delete-btn">
                            <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                        </button>
                    </div>
                <?php endforeach; ?>
                <div class="add-time">
                    <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/add-square.svg" alt="">
                    <p><?php esc_html_e('اضافه کردن', 'woodmartplus'); ?></p>
                </div>
            </div>
        </div>
        <div class="shipping-time br-radius-8">
            <div class="send-day">
                <input type="checkbox" name="<?php echo wplus_helper::generate_option('[shipping_time][friday]'); ?>" <?php echo isset($shipping_time['friday']) ? 'checked' : '' ?>>
                <label for=""><?php esc_html_e('جمعه', 'woodmartplus'); ?></label>
            </div>
            <div class="send-time">
                <?php foreach ($friday_times as $friday_time): ?>
                    <div class="hours-time">
                        <input type="text" placeholder="<?php esc_html_e('ساعت 10 تا 12', 'woodmartplus'); ?>" name="<?php echo wplus_helper::generate_option('[shipping_time][friday-time][]'); ?>" autocomplete="disable" value="<?php echo esc_html($friday_time) ?>">
                        <button class="delete-btn">
                            <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                        </button>
                    </div>
                <?php endforeach; ?>
                <div class="add-time">
                    <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/add-square.svg" alt="">
                    <p><?php esc_html_e('اضافه کردن', 'woodmartplus'); ?></p>
                </div>
            </div>
        </div>
    </div>
</div>