<?php $order_tracking = wplus_helper::get_setting('order_tracking', []); ?>
<div class="item p-18 br-bottom">
    <span class="title"><?php esc_html_e('فعال کردن پیگیری سفارش', 'woodmartplus'); ?></span>
    <p class="des"></p>
    <div class="btn-select">
        <input type="checkbox" class="switch" name="<?php echo wplus_helper::generate_option('[enable-order-tracking]'); ?>" <?php echo wplus_helper::show_value('enable-order-tracking', false) ? 'checked' : '' ?>>
    </div>
</div>

<div class="item p-top-18">
    <span class="title"><?php esc_html_e('شرکت های پستی', 'woodmartplus') ?></span>
    <p class="des"><?php esc_html_e('اسامی شرکت های پستی را که سفارش های خود را از آن طریق ارسال می کنید انتخاب کنید', 'woodmartplus'); ?></p>
    <?php if( wplus_helper::get_setting('enable-order-tracking') ): ?>
        <p class="des"><?php 
            printf(__('برای ایجاد اسامی شرکت های پستی و پیکی از <a href="%s" target="_blank">اینجا</a> اقدام کنید','woodmartplus'),admin_url('edit-tags.php?taxonomy=shipping_company'))
        ?></p>
    <?php endif; ?>
    <div>
        <select class="js-example-basic-multiple" name="<?php echo wplus_helper::generate_option('[order_tracking][shipping_company][]'); ?>" multiple="multiple" dir="rtl">
            <?php $shipping_selected =  isset($order_tracking['shipping_company']) && !empty($order_tracking['shipping_company']) ? $order_tracking['shipping_company'] : []; ?>
            <?php foreach (wplus_helper::get_shipping_company() as $key => $value): ?>
                <option value="<?php echo esc_attr($key) ?>" <?php echo in_array($key, $shipping_selected) ? 'selected' : '' ?>><?php echo esc_html($value); ?></option>
            <?php endforeach; ?>
        </select>
    </div>
</div>

<div class="item">
    <div class="manager-sms-wrapper">
        <div class="br-bottom" style="padding-bottom: 18px;">
            <div class="sms-sent-post m-t-18">
                <div class="short-code-text">
                    <span class="title"><?php esc_html_e('متن پیامک ارسال پستی', 'woodmartplus'); ?></span>
                    <p class="des"><?php esc_html_e('می توانید از این شورت کد ها در متن پیامک استفاده کنید', 'woodmartplus'); ?></p>
                </div>
                <div class="sms-sent-post-detailes br-radius-8">
                    <p>[shipping_tracking] = شرکت حمل و نقل</p>
                    <p>[consignment_tracking] = شماره مرسوله</p>
                    <p>[date_tracking] = تاریخ ارسال</p>
                    <p>[delivery_mob_tracking] = موبایل پیک</p>
                </div>
            </div>

            <div class="add-suggestions open_acard opened" style="margin-top:20px;">
                <div class="suggestion-title">
                    <span class="suggestion-menu">
                        <p><?php esc_html_e('متن پیامک ارسال پستی', 'woodmartplus'); ?></p>
                    </span>
                    <span class="arrow-icon"><img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/arrow-down2.svg" alt=""></span>
                </div>
                <div class="suggestion-content">
                    <div class="suggestion-inputs gray-inp">
                        <!-- Pattern Input -->
                        <div class="suggestion-inputs gray-inp" style="margin-bottom:.8rem;">
                            <input type="text" name="<?php echo wplus_helper::generate_option('[order_tracking][pattern-post]'); ?>" placeholder="<?php esc_html_e('پترن پیامک را وارد کنید', 'woodmartplus'); ?>" value="<?php echo isset($order_tracking['pattern-post']) && !empty($order_tracking['pattern-post']) ? esc_html($order_tracking['pattern-post']) : '' ?>">
                        </div>
                        <!-- Variables Repeater -->
                        <div class="repeater-container">
                            <div data-repeater-list="<?php echo wplus_helper::generate_option('[order_tracking][variables-post]'); ?>">
                                <?php if (isset($order_tracking['variables-post']) && !empty($order_tracking['variables-post'])) : ?>
                                    <?php foreach ($order_tracking['variables-post'] as $key => $value) : ?>

                                        <div data-repeater-item>
                                            <div class="send-time">
                                                <div>
                                                    <input type="text" name="variable" placeholder="<?php esc_html_e('متغیر', 'woodmartplus'); ?>" value="<?php echo isset($value['variable'])  ? esc_html($value['variable']) : '' ?>">
                                                    <input type="text" name="shortcode" placeholder="<?php esc_html_e('شورتکد', 'woodmartplus'); ?>" value="<?php echo isset($value['shortcode']) && !empty($value['shortcode']) ? esc_html($value['shortcode']) : '' ?>">
                                                    <a data-repeater-delete class="delete-btn">
                                                        <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                <?php else : ?>
                                    <div data-repeater-item>
                                        <div class="send-time">
                                            <div>
                                                <input type="text" name="variable" placeholder="<?php esc_html_e('متغیر', 'woodmartplus'); ?>">
                                                <input type="text" name="shortcode" placeholder="<?php esc_html_e('شورتکد', 'woodmartplus'); ?>">
                                                <a data-repeater-delete class="delete-btn">
                                                    <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="add-time">
                                <button data-repeater-create type="button">
                                    <!-- <img src="path/to/plus.svg" alt="add"> -->
                                    <p><?php esc_html_e('افزودن متغیر جدید', 'woodmartplus'); ?></p>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <div class="add-suggestions open_acard" style="margin-top:20px;">
                <div class="suggestion-title">
                    <span class="suggestion-menu">
                        <p><?php esc_html_e('متن پیامک ارسال با پیک', 'woodmartplus'); ?></p>
                    </span>
                    <span class="arrow-icon"><img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/arrow-down2.svg" alt=""></span>
                </div>
                <div class="suggestion-content">
                    <div class="suggestion-inputs gray-inp">
                        <!-- Pattern Input -->
                        <div class="suggestion-inputs gray-inp" style="margin-bottom:.8rem;">
                            <input type="text" name="<?php echo wplus_helper::generate_option('[order_tracking][pattern-delivery]'); ?>" placeholder="<?php esc_html_e('پترن پیامک را وارد کنید', 'woodmartplus'); ?>" value="<?php echo isset($order_tracking['pattern-delivery']) && !empty($order_tracking['pattern-delivery']) ? esc_html($order_tracking['pattern-delivery']) : '' ?>">
                        </div>
                        <!-- Variables Repeater -->
                        <div class="repeater-container">
                            <div data-repeater-list="<?php echo wplus_helper::generate_option('[order_tracking][variables-delivery]'); ?>">
                                <?php if (isset($order_tracking['variables-delivery']) && !empty($order_tracking['variables-delivery'])) : ?>
                                    <?php foreach ($order_tracking['variables-delivery'] as $key => $value) : ?>

                                        <div data-repeater-item>
                                            <div class="send-time">
                                                <div>
                                                    <input type="text" name="variable" placeholder="<?php esc_html_e('متغیر', 'woodmartplus'); ?>" value="<?php echo isset($value['variable']) ? esc_html($value['variable']) : '' ?>">
                                                    <input type="text" name="shortcode" placeholder="<?php esc_html_e('شورتکد', 'woodmartplus'); ?>" value="<?php echo isset($value['shortcode']) && !empty($value['shortcode']) ? esc_html($value['shortcode']) : '' ?>">
                                                    <a data-repeater-delete class="delete-btn">
                                                        <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                <?php else : ?>
                                    <div data-repeater-item>
                                        <div class="send-time">
                                            <div>
                                                <input type="text" name="variable" placeholder="<?php esc_html_e('متغیر', 'woodmartplus'); ?>">
                                                <input type="text" name="shortcode" placeholder="<?php esc_html_e('شورتکد', 'woodmartplus'); ?>">
                                                <a data-repeater-delete class="delete-btn">
                                                    <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                <?php endif; ?>
                            </div>
                            <div class="add-time">
                                <button data-repeater-create type="button">
                                    <p><?php esc_html_e('افزودن متغیر جدید', 'woodmartplus'); ?></p>
                                </button>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

<div class="item p-18 br-bottom">
    <span class="title"><?php esc_html_e('تنظیمات نوار اطلاع از وضعیت', 'woodmartplus'); ?></span>
    <span class="title"><?php esc_html_e('از شورتکد [order_tracking] برای ایجاد برگه استفاده کنید', 'woodmartplus'); ?></span>
</div>

<div class="item p-18 br-bottom">
    <span class="title"><?php esc_html_e('نمایش نوار اطلاعات وضعیت سفارش در جزئیات سفاش کاربر؟', 'woodmartplus'); ?></span>
    <p class="des"></p>
    <div class="btn-select">
        <input type="checkbox" class="switch" name="<?php echo wplus_helper::generate_option('[order_tracking][enable_detial_myaccount]'); ?>" <?php echo isset($order_tracking['enable_detial_myaccount']) ? 'checked' : '' ?> data-condition="order_tracking_steps_condition">
    </div>
</div>


<div class="item p-top-18 offer_section order_tracking_steps_condition">
    <span class="title"><?php esc_html_e('مراحل سفارش','woodmartplus') ?></span>
    <p class="des"><?php esc_html_e('مراحل سفارش خود را ایجاد کنید.','woodmartplus'); ?></p>
    <div data-repeater-list="<?php echo wplus_helper::generate_option('[order_tracking_steps]'); ?>" >
        <?php foreach( wplus_helper::get_setting('order_tracking_steps',[
            'defualt_step' => [
                'step_image',
                'step_title',
                'step_tooltip',
                'step_status'
            ]
        ]) as $step ): ?>
            <section class="repeater-sections-slider-images add-suggestions m-t-18 opened" data-repeater-item >
                <div class="br-radius-8 opened">

                    <div class="suggestion-title">
                        <span class="suggestion-menu">
                            <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/menu.svg" alt="">
                            <p><?php esc_html_e('مرحله جدید','woodmartplus'); ?></p>
                        </span>
                        <span class="arrow-icon"><img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/arrow-down2.svg" alt=""></span>
                    </div>

                    <div class="suggestion-content">

                        <div class="upload-loding">
                            <?php $img_id = isset( $step['step_image'] ) && !empty( $step['step_image'] ) ? $step['step_image'] : '';
                                    $image = '';
                                    if( $img_id )
                                    {
                                        $img_src = wp_get_attachment_image_src($img_id,'medium');
                                        if( isset( $img_src[0] ) )
                                        {
                                            $image = $img_src[0];
                                        }
                                    }
                            
                            ?>
                            <?php if( $image ): ?>
                                <div class="upload-loding-img upload_image">
                                    <img class="img-responsive" src="<?php echo esc_url( $image ); ?>" alt="slider">
                                </div>
                                <div class="upload-loding-btns">
                                    <span class="blue-btn upload-btn upload-image-button"><?php esc_html_e('ویرایش','woodmartplus') ?></span>
                                    <span class="delete-btn remove-image-button">
                                        <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                                    </span>
                                </div>
                                <input type="hidden" name="step_image" id="" class="upload_image_id" value="<?php echo esc_attr( $img_id ); ?>" / >
                            <?php else: ?>
                                <div class="upload-loding-img upload_image">
                                </div>
                                <div class="upload-loding-btns">
                                    <span class="blue-btn upload-btn upload-image-button"><?php esc_html_e('آپلود','woodmartplus') ?></span>
                                    <span class="delete-btn remove-image-button" style="display: none;">
                                        <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="trash">
                                    </span>
                                </div>
                                <input type="hidden" name="step_image" id="" class="upload_image_id" value="" / >
                            <?php endif; ?>
                        </div>

                        <div class="suggestion-inputs">
                            <div>
                                <p><?php esc_html_e('عنوان این مرحله را وارد کنید','woodmartplus'); ?></p>
                                <input type="text" name="step_title" id="" placeholder="<?php esc_html_e('عنوان','woodmartplus') ?>" value="<?php echo isset( $step['step_title'] ) && !empty( $step['step_title'] ) ? $step['step_title'] : ''  ?>">
                            </div>
                            <div>
                                <p><?php esc_html_e('متن تولتیپ این مرحله را وارد کنید','woodmartplus'); ?></p>
                                <input type="text" name="step_tooltip" id="" placeholder="<?php esc_html_e('متن تولتیپ','woodmartplus') ?>" value="<?php echo isset( $step['step_tooltip'] ) && !empty( $step['step_tooltip'] ) ? $step['step_tooltip'] : ''  ?>">
                            </div>
                            <div>
                                <p><?php esc_html_e('انتخاب یک یا بیش از یک وضعیت برای این مرحله', 'woodmartplus'); ?></p>
                                <select class="js-example-basic-multiple" name="step_status" multiple="multiple" dir="rtl">
                                    <?php $selected = isset( $step['step_status'] ) && !empty( $step['step_status'] ) ? $step['step_status'] : [] ?>
                                    <?php foreach (wplus_helper::get_wc_status() as $key => $value): ?>
                                        <option value="<?php echo esc_attr($key) ?>" <?php echo in_array( $key , $selected ) ? 'selected' : '' ?> ><?php echo esc_html($value); ?></option>
                                    <?php endforeach; ?>
                                </select>
                            </div>

                        </div>
                    </div>

                    <div class="suggestion-btns">
                        <input class="delete-btn" data-repeater-delete type="button" value="<?php esc_html_e('حذف مرحله','woodmartplus') ?>" >
                    </div>
                </div>
            </section>
        <?php endforeach; ?>
    </div>
    <input class="add-btn blue-btn m-t-18" style="display:inline-block" data-repeater-create type="button" value="<?php esc_html_e('افزودن مرحله','woodmartplus') ?>" >
</div>
