<?php $notif_manager = wplus_helper::get_setting('notif_manager', []); ?>

<div class="item p-18 br-bottom">
    <span class="title"><?php esc_html_e('فعال کردن اعلان سفارش مدیران', 'woodmartplus'); ?></span>
    <p class="des"></p>
    <div class="btn-select">
        <input type="checkbox" class="switch" name="<?php echo wplus_helper::generate_option('[enable-order-notification-manager]'); ?>" <?php echo wplus_helper::show_value('enable-order-notification-manager', false) ? 'checked' : '' ?>>
    </div>
</div>

<div class="item p-18 br-bottom">
    <span class="title"><?php esc_html_e('انتخاب شماره تماس مدیران', 'woodmartplus') ?></span>
    <p class="des"><?php esc_html_e('شماره تماس مدیران را جهت ارسال پیامک وارد کنید. ', 'woodmartplus'); ?></p>
    <p class="des"><?php esc_html_e('اگر در فیلد زیر مدیری را نمایش نمی دهد ، وارد قسمت کاربران و اکانت مدیر که قصد دارید شماره ارسال شود را انتخاب کنید و گزینه (شماره موبایل وودمارت پلاس) را پر کنید', 'woodmartplus'); ?></p>
    <div>
        <select class="js-example-basic-multiple" name="<?php echo wplus_helper::generate_option('[notif_manager][managers-to-send-sms-order]'); ?>">
            <option value=""><?php echo esc_html_e('انتخاب مدیر','woodmartplu'); ?></option>
            <?php foreach (woodmartPlusInit::get_manager_phone_detail() as $key => $value): ?>
                <?php $selected = isset($notif_manager['managers-to-send-sms-order']) && !empty($notif_manager['managers-to-send-sms-order']) ? $notif_manager['managers-to-send-sms-order'] : [];  ?>
                <option value="<?php echo esc_attr($key) ?>" <?php echo $selected == $key ? 'selected' : '' ?>><?php echo esc_html($value); ?></option>
            <?php endforeach; ?>
        </select>
    </div>
</div>

<div class="item br-bottom p-18">
    <span class="title"><?php esc_html_e('انتخاب وضعیت های ارسال پیامک', 'woodmartplus'); ?></span>
    <p class="des"><?php esc_html_e('انتخاب کنید که در کدام یک از وضعیت های زیر پیامک ارسال شود.', 'woodmartplus'); ?></p>
    <div class="select-sms-setting">
        <div>
            <input type="checkbox" id="Immediately_purchase-cust" class="customer-" name="<?php echo wplus_helper::generate_option('[notif_manager][pending_now]'); ?>" <?php echo isset($notif_manager['pending_now']) && !empty($notif_manager['pending_now']) ? 'checked' : '' ?>>
            <label for="Immediately_purchase-cust"><?php esc_html_e('(بلافاصله بعد از خرید)در انتظار پرداخت', 'woodmartplus'); ?></label>
        </div>
        <div>
            <input type="checkbox" id="awaiting_payment_cust" name="<?php echo wplus_helper::generate_option('[notif_manager][pending]'); ?>" <?php echo isset($notif_manager['pending']) && !empty($notif_manager['pending']) ? 'checked' : '' ?>>
            <label for="awaiting_payment_cust"><?php esc_html_e('در انتظار پرداخت', 'woodmartplus'); ?></label>
        </div>
        <div>
            <input type="checkbox" id="in_progress_cust" name="<?php echo wplus_helper::generate_option('[notif_manager][processing]'); ?>" <?php echo isset($notif_manager['processing']) && !empty($notif_manager['processing']) ? 'checked' : '' ?>>
            <label for="in_progress_cust"><?php esc_html_e('در حال انجام', 'woodmartplus'); ?></label>
        </div>
        <div>
            <input type="checkbox" id="awaiting_review_cust" name="<?php echo wplus_helper::generate_option('[notif_manager][on-hold]'); ?>" <?php echo isset($notif_manager['on-hold']) && !empty($notif_manager['on-hold']) ? 'checked' : '' ?>>
            <label for="awaiting_review_cust"><?php esc_html_e('در انتظار بررسی', 'woodmartplus'); ?></label>
        </div>
        <div>
            <input type="checkbox" id="completed_status_cust" name="<?php echo wplus_helper::generate_option('[notif_manager][completed]'); ?>" <?php echo isset($notif_manager['completed']) && !empty($notif_manager['completed']) ? 'checked' : '' ?>>
            <label for="completed_status_cust"><?php esc_html_e('تکمیل شده', 'woodmartplus'); ?></label>
        </div>
        <div>
            <input type="checkbox" id="canceled_status_cust" name="<?php echo wplus_helper::generate_option('[notif_manager][cancelled]'); ?>" <?php echo isset($notif_manager['cancelled']) && !empty($notif_manager['cancelled']) ? 'checked' : '' ?>>
            <label for="canceled_status_cust"><?php esc_html_e('لغو شده', 'woodmartplus'); ?></label>
        </div>
        <div>
            <input type="checkbox" id="returned_status_cust" name="<?php echo wplus_helper::generate_option('[notif_manager][refunded]'); ?>" <?php echo isset($notif_manager['refunded']) && !empty($notif_manager['refunded']) ? 'checked' : '' ?>>
            <label for="returned_status_cust"><?php esc_html_e('مسترد شده', 'woodmartplus'); ?></label>
        </div>
        <div>
            <input type="checkbox" id="unsuccessful-conditions_cust" name="<?php echo wplus_helper::generate_option('[notif_manager][failed]'); ?>" <?php echo isset($notif_manager['failed']) && !empty($notif_manager['failed']) ? 'checked' : '' ?>>
            <label for="unsuccessful-conditions_cust"><?php esc_html_e('ناموفق', 'woodmartplus'); ?></label>
        </div>
        <div>
            <input type="checkbox" id="draft_sms_cust" name="<?php echo wplus_helper::generate_option('[notif_manager][checkout-draft]'); ?>" <?php echo isset($notif_manager['checkout-draft']) && !empty($notif_manager['checkout-draft']) ? 'checked' : '' ?>>
            <label for="draft_sms_cust"><?php esc_html_e('پیشنویس', 'woodmartplus'); ?></label>
        </div>
    </div>
</div>


<div class="item">
    <div class="manager-sms-wrapper">
        <div class="short-code br-bottom p-18">
            <div class="short-code-text">
                <span class="title"><?php esc_html_e('شورت کد های قابل استفاده', 'woodmartplus'); ?></span>
                <p class="des"><?php esc_html_e('می توانید از این شورت کد ها در متن پیامک استفاده کنید', 'woodmartplus'); ?></p>
            </div>
            <div class="short-code-detailes br-radius-8">
                <p>
                    <?php esc_htmL_e('جزییات سفارش:','woodmartplus'); ?> <br>
                    [billing_phone] = <?php esc_html_e('شماره تلفن مشتری','woodmartplus'); ?>  <br>
                    [billing_email] = <?php esc_html_e('ایمیل مشتری','woodmartplus'); ?> <br>
                    [billing_status] = <?php esc_html_e('وضعیت سفارش','woodmartplus'); ?> <br>
                    [billing_items] = <?php esc_html_e('محصولات سفارش','woodmartplus'); ?> <br>
                    [billing_all_items_qty] = <?php esc_html_e('محصولات سفارش بهمراه تعداد','woodmartplus'); ?> <br>
                    [billing_count_items] = <?php esc_html_e('تعداد محصولات سفارش','woodmartplus'); ?> 
                </p>
                <br>
                <p> 
                [billing_price] = <?php esc_html_e('مبلغ سفارش بدون احتساب مالیات و حمل و نقل و...', 'woodmartplus'); ?> <br> 
                [billing_price_total] = <?php esc_html_e('مبلغ کل سفارش', 'woodmartplus'); ?>  <br>
                [billing_order_id] = <?php esc_html_e('شماره سفارش','woodmartplus'); ?> <br>
                    [billing_date] = <?php esc_html_e('تاریخ سفارش','woodmartplus'); ?> <br> 
                    [billing_customer_not] = <?php esc_html_e('توضیحات مشتری','woodmartplus'); ?> <br>
                    [billing_payment_method] = <?php esc_html_e('روش پرداخت','woodmartplus'); ?> <br> 
                    [billing_shipping_method] = <?php esc_html_e('روش ارسال','woodmartplus'); ?></p>
                <br>
                <p><?php esc_html_e('جزییات صورت حساب :','woodmartplus'); ?><br>
                    [billing_first_name] = <?php esc_html_e('نام مشتری','woodmartplus'); ?> <br>
                    [billing_last_name] = <?php esc_html_e('نام خانوادگی مشتری','woodmartplus'); ?> <br>
                    [billing_company] = <?php esc_html_e('نام شرکت','woodmartplus'); ?> <br> 
                    [billing_country] = <?php esc_html_e('کشور','woodmartplus'); ?> <br>
                    [billing_state] = <?php esc_html_e('ایالت/استان','woodmartplus'); ?> <br>
                    [billing_city] = <?php esc_html_e('شهر','woodmartplus'); ?> <br>
                    [billing_postcode] = <?php esc_html_e('کد پستی','woodmartplus'); ?></p>
                <br>
                <p><?php esc_html_e('جزییات حمل و نقل :','woodmartplus'); ?><br>
                    [shipping_first_name] = <?php esc_html_e('نام مشتری','woodmartplus'); ?> <br> 
                    [shipping_last_name] = <?php esc_html_e('نام خانوادگی مشتری','woodmartplus'); ?> <br>
                    [shipping_company] = <?php esc_html_e('نام شرکت','woodmartplus'); ?> <br>
                    [shipping_country] = <?php esc_html_e('کشور','woodmartplus'); ?> <br>
                    [shipping_state] = <?php esc_html_e('ایالت/استان','woodmartplus'); ?> <br>
                    [shipping_city] = <?php esc_html_e('شهر','woodmartplus'); ?> <br>
                    [shipping_address_1] = <?php esc_html_e('آدرس 1','woodmartplus'); ?> <br>
                    [shipping_address_2] = <?php esc_html_e('آدرس 2','woodmartplus'); ?> <br>
                    [shipping_postcode] = <?php esc_html_e('کد پستی','woodmartplus'); ?></p>
                <br>
            </div>
        </div>
        <div class="add-suggestions open_acard opened" style="margin-top:20px;">
            <div class="suggestion-title">
                <span class="suggestion-menu">
                    <p><?php esc_html_e('(بلافاصله بعد از خرید) در انتظار', 'woodmartplus'); ?></p>
                </span>
                <span class="arrow-icon"><img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/arrow-down2.svg" alt=""></span>
            </div>
            <div class="suggestion-content">
                <div class="suggestion-inputs gray-inp">
                    <!-- Pattern Input -->
                    <div class="suggestion-inputs gray-inp" style="margin-bottom:.8rem;">
                        <input type="text" name="<?php echo wplus_helper::generate_option('[notif_manager][pattern-pending-now]'); ?>" placeholder="<?php esc_html_e('پترن پیامک را وارد کنید', 'woodmartplus'); ?>" value="<?php echo isset($notif_manager['pattern-pending-now']) && !empty($notif_manager['pattern-pending-now']) ? esc_html($notif_manager['pattern-pending-now']) : '' ?>">
                    </div>
                    <!-- Variables Repeater -->
                    <div class="repeater-container">
                        <div data-repeater-list="<?php echo wplus_helper::generate_option('[notif_manager][variables-pending-now]'); ?>">
                            <?php if (isset($notif_manager['variables-pending-now']) && !empty($notif_manager['variables-pending-now'])) : ?>
                                <?php foreach ($notif_manager['variables-pending-now'] as $key => $value) : ?>

                                    <div data-repeater-item>
                                        <div class="send-time">
                                            <div>
                                                <input type="text" name="variable" placeholder="<?php esc_html_e('متغیر', 'woodmartplus'); ?>" value="<?php echo isset($value['variable']) ? esc_html($value['variable']) : '' ?>">
                                                <input type="text" name="shortcode" placeholder="<?php esc_html_e('شورتکد', 'woodmartplus'); ?>" value="<?php echo isset($value['shortcode']) && !empty($value['shortcode']) ? esc_html($value['shortcode']) : '' ?>">
                                                <a data-repeater-delete class="delete-btn">
                                                    <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            <?php else : ?>
                                <div data-repeater-item>
                                    <div class="send-time">
                                        <div>
                                            <input type="text" name="variable" placeholder="<?php esc_html_e('متغیر', 'woodmartplus'); ?>">
                                            <input type="text" name="shortcode" placeholder="<?php esc_html_e('شورتکد', 'woodmartplus'); ?>">
                                            <a data-repeater-delete class="delete-btn">
                                                <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="add-time">
                            <button data-repeater-create type="button">
                                <p><?php esc_html_e('افزودن متغیر جدید', 'woodmartplus'); ?></p>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="add-suggestions open_acard" style="margin-top:20px;">
            <div class="suggestion-title">
                <span class="suggestion-menu">
                    <p><?php esc_html_e('در انتظار پرداخت', 'woodmartplus'); ?></p>
                </span>
                <span class="arrow-icon"><img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/arrow-down2.svg" alt=""></span>
            </div>
            <div class="suggestion-content">
                <div class="suggestion-inputs gray-inp">
                    <!-- Pattern Input -->
                    <div class="suggestion-inputs gray-inp" style="margin-bottom:.8rem;">
                        <input type="text" name="<?php echo wplus_helper::generate_option('[notif_manager][pattern-pending]'); ?>" placeholder="<?php esc_html_e('پترن پیامک را وارد کنید', 'woodmartplus'); ?>" value="<?php echo isset($notif_manager['pattern-pending']) && !empty($notif_manager['pattern-pending']) ? esc_html($notif_manager['pattern-pending']) : '' ?>">
                    </div>
                    <!-- Variables Repeater -->
                    <div class="repeater-container">
                        <div data-repeater-list="<?php echo wplus_helper::generate_option('[notif_manager][variables-pending]'); ?>">
                            <?php if (isset($notif_manager['variables-pending']) && !empty($notif_manager['variables-pending'])) : ?>
                                <?php foreach ($notif_manager['variables-pending'] as $key => $value) : ?>

                                    <div data-repeater-item>
                                        <div class="send-time">
                                            <div>
                                                <input type="text" name="variable" placeholder="<?php esc_html_e('متغیر', 'woodmartplus'); ?>" value="<?php echo isset($value['variable']) ? esc_html($value['variable']) : '' ?>">
                                                <input type="text" name="shortcode" placeholder="<?php esc_html_e('شورتکد', 'woodmartplus'); ?>" value="<?php echo isset($value['shortcode']) && !empty($value['shortcode']) ? esc_html($value['shortcode']) : '' ?>">
                                                <a data-repeater-delete class="delete-btn">
                                                    <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            <?php else : ?>
                                <div data-repeater-item>
                                    <div class="send-time">
                                        <div>
                                            <input type="text" name="variable" placeholder="<?php esc_html_e('متغیر', 'woodmartplus'); ?>">
                                            <input type="text" name="shortcode" placeholder="<?php esc_html_e('شورتکد', 'woodmartplus'); ?>">
                                            <a data-repeater-delete class="delete-btn">
                                                <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="add-time">
                            <button data-repeater-create type="button">
                                <p><?php esc_html_e('افزودن متغیر جدید', 'woodmartplus'); ?></p>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="add-suggestions open_acard" style="margin-top:20px;">
            <div class="suggestion-title">
                <span class="suggestion-menu">
                    <p><?php esc_html_e('در حال انجام', 'woodmartplus'); ?></p>
                </span>
                <span class="arrow-icon"><img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/arrow-down2.svg" alt=""></span>
            </div>
            <div class="suggestion-content">
                <div class="suggestion-inputs gray-inp">
                    <!-- Pattern Input -->
                    <div class="suggestion-inputs gray-inp" style="margin-bottom:.8rem;">
                        <input type="text" name="<?php echo wplus_helper::generate_option('[notif_manager][pattern-processing]'); ?>" placeholder="<?php esc_html_e('پترن پیامک را وارد کنید', 'woodmartplus'); ?>" value="<?php echo isset($notif_manager['pattern-processing']) && !empty($notif_manager['pattern-processing']) ? esc_html($notif_manager['pattern-processing']) : '' ?>">
                    </div>
                    <!-- Variables Repeater -->
                    <div class="repeater-container">
                        <div data-repeater-list="<?php echo wplus_helper::generate_option('[notif_manager][variables-processing]'); ?>">
                            <?php if (isset($notif_manager['variables-processing']) && !empty($notif_manager['variables-processing'])) : ?>
                                <?php foreach ($notif_manager['variables-processing'] as $key => $value) : ?>

                                    <div data-repeater-item>
                                        <div class="send-time">
                                            <div>
                                                <input type="text" name="variable" placeholder="<?php esc_html_e('متغیر', 'woodmartplus'); ?>" value="<?php echo isset($value['variable'])  ? esc_html($value['variable']) : '' ?>">
                                                <input type="text" name="shortcode" placeholder="<?php esc_html_e('شورتکد', 'woodmartplus'); ?>" value="<?php echo isset($value['shortcode']) && !empty($value['shortcode']) ? esc_html($value['shortcode']) : '' ?>">
                                                <a data-repeater-delete class="delete-btn">
                                                    <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            <?php else : ?>
                                <div data-repeater-item>
                                    <div class="send-time">
                                        <div>
                                            <input type="text" name="variable" placeholder="<?php esc_html_e('متغیر', 'woodmartplus'); ?>">
                                            <input type="text" name="shortcode" placeholder="<?php esc_html_e('شورتکد', 'woodmartplus'); ?>">
                                            <a data-repeater-delete class="delete-btn">
                                                <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="add-time">
                            <button data-repeater-create type="button">
                                <!-- <img src="path/to/plus.svg" alt="add"> -->
                                <p><?php esc_html_e('افزودن متغیر جدید', 'woodmartplus'); ?></p>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="add-suggestions open_acard" style="margin-top:20px;">
            <div class="suggestion-title">
                <span class="suggestion-menu">
                    <p><?php esc_html_e('در انتظار بررسی', 'woodmartplus'); ?></p>
                </span>
                <span class="arrow-icon"><img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/arrow-down2.svg" alt=""></span>
            </div>
            <div class="suggestion-content">
                <div class="suggestion-inputs gray-inp">
                    <!-- Pattern Input -->
                    <div class="suggestion-inputs gray-inp" style="margin-bottom:.8rem;">
                        <input type="text" name="<?php echo wplus_helper::generate_option('[notif_manager][pattern-on-hold]'); ?>" placeholder="<?php esc_html_e('پترن پیامک را وارد کنید', 'woodmartplus'); ?>" value="<?php echo isset($notif_manager['pattern-on-hold']) && !empty($notif_manager['pattern-on-hold']) ? esc_html($notif_manager['pattern-on-hold']) : '' ?>">
                    </div>
                    <!-- Variables Repeater -->
                    <div class="repeater-container">
                        <div data-repeater-list="<?php echo wplus_helper::generate_option('[notif_manager][variables-on-hold]'); ?>">
                            <?php if (isset($notif_manager['variables-on-hold']) && !empty($notif_manager['variables-on-hold'])) : ?>
                                <?php foreach ($notif_manager['variables-on-hold'] as $key => $value) : ?>

                                    <div data-repeater-item>
                                        <div class="send-time">
                                            <div>
                                                <input type="text" name="variable" placeholder="<?php esc_html_e('متغیر', 'woodmartplus'); ?>" value="<?php echo isset($value['variable'])  ? esc_html($value['variable']) : '' ?>">
                                                <input type="text" name="shortcode" placeholder="<?php esc_html_e('شورتکد', 'woodmartplus'); ?>" value="<?php echo isset($value['shortcode']) && !empty($value['shortcode']) ? esc_html($value['shortcode']) : '' ?>">
                                                <a data-repeater-delete class="delete-btn">
                                                    <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            <?php else : ?>
                                <div data-repeater-item>
                                    <div class="send-time">
                                        <div>
                                            <input type="text" name="variable" placeholder="<?php esc_html_e('متغیر', 'woodmartplus'); ?>">
                                            <input type="text" name="shortcode" placeholder="<?php esc_html_e('شورتکد', 'woodmartplus'); ?>">
                                            <a data-repeater-delete class="delete-btn">
                                                <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="add-time">
                            <button data-repeater-create type="button">
                                <!-- <img src="path/to/plus.svg" alt="add"> -->
                                <p><?php esc_html_e('افزودن متغیر جدید', 'woodmartplus'); ?></p>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>


        <div class="add-suggestions open_acard" style="margin-top:20px;">
            <div class="suggestion-title">
                <span class="suggestion-menu">
                    <p><?php esc_html_e('تکمیل شده', 'woodmartplus'); ?></p>
                </span>
                <span class="arrow-icon"><img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/arrow-down2.svg" alt=""></span>
            </div>
            <div class="suggestion-content">
                <div class="suggestion-inputs gray-inp">
                    <!-- Pattern Input -->
                    <div class="suggestion-inputs gray-inp" style="margin-bottom:.8rem;">
                        <input type="text" name="<?php echo wplus_helper::generate_option('[notif_manager][pattern-completed]'); ?>" placeholder="<?php esc_html_e('پترن پیامک را وارد کنید', 'woodmartplus'); ?>" value="<?php echo isset($notif_manager['pattern-completed']) && !empty($notif_manager['pattern-completed']) ? esc_html($notif_manager['pattern-completed']) : '' ?>">
                    </div>
                    <!-- Variables Repeater -->
                    <div class="repeater-container">
                        <div data-repeater-list="<?php echo wplus_helper::generate_option('[notif_manager][variables-completed]'); ?>">
                            <?php if (isset($notif_manager['variables-completed']) && !empty($notif_manager['variables-completed'])) : ?>
                                <?php foreach ($notif_manager['variables-completed'] as $key => $value) : ?>

                                    <div data-repeater-item>
                                        <div class="send-time">
                                            <div>
                                                <input type="text" name="variable" placeholder="<?php esc_html_e('متغیر', 'woodmartplus'); ?>" value="<?php echo isset($value['variable'])  ? esc_html($value['variable']) : '' ?>">
                                                <input type="text" name="shortcode" placeholder="<?php esc_html_e('شورتکد', 'woodmartplus'); ?>" value="<?php echo isset($value['shortcode']) && !empty($value['shortcode']) ? esc_html($value['shortcode']) : '' ?>">
                                                <a data-repeater-delete class="delete-btn">
                                                    <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            <?php else : ?>
                                <div data-repeater-item>
                                    <div class="send-time">
                                        <div>
                                            <input type="text" name="variable" placeholder="<?php esc_html_e('متغیر', 'woodmartplus'); ?>">
                                            <input type="text" name="shortcode" placeholder="<?php esc_html_e('شورتکد', 'woodmartplus'); ?>">
                                            <a data-repeater-delete class="delete-btn">
                                                <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="add-time">
                            <button data-repeater-create type="button">
                                <!-- <img src="path/to/plus.svg" alt="add"> -->
                                <p><?php esc_html_e('افزودن متغیر جدید', 'woodmartplus'); ?></p>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="add-suggestions open_acard" style="margin-top:20px;">
            <div class="suggestion-title">
                <span class="suggestion-menu">
                    <p><?php esc_html_e('لغو شده', 'woodmartplus'); ?></p>
                </span>
                <span class="arrow-icon"><img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/arrow-down2.svg" alt=""></span>
            </div>
            <div class="suggestion-content">
                <div class="suggestion-inputs gray-inp">
                    <!-- Pattern Input -->
                    <div class="suggestion-inputs gray-inp" style="margin-bottom:.8rem;">
                        <input type="text" name="<?php echo wplus_helper::generate_option('[notif_manager][pattern-cancelled]'); ?>" placeholder="<?php esc_html_e('پترن پیامک را وارد کنید', 'woodmartplus'); ?>" value="<?php echo isset($notif_manager['pattern-cancelled']) && !empty($notif_manager['pattern-cancelled']) ? esc_html($notif_manager['pattern-cancelled']) : '' ?>">
                    </div>
                    <!-- Variables Repeater -->
                    <div class="repeater-container">
                        <div data-repeater-list="<?php echo wplus_helper::generate_option('[notif_manager][variables-cancelled]'); ?>">
                            <?php if (isset($notif_manager['variables-cancelled']) && !empty($notif_manager['variables-cancelled'])) : ?>
                                <?php foreach ($notif_manager['variables-cancelled'] as $key => $value) : ?>

                                    <div data-repeater-item>
                                        <div class="send-time">
                                            <div>
                                                <input type="text" name="variable" placeholder="<?php esc_html_e('متغیر', 'woodmartplus'); ?>" value="<?php echo isset($value['variable'])  ? esc_html($value['variable']) : '' ?>">
                                                <input type="text" name="shortcode" placeholder="<?php esc_html_e('شورتکد', 'woodmartplus'); ?>" value="<?php echo isset($value['shortcode']) && !empty($value['shortcode']) ? esc_html($value['shortcode']) : '' ?>">
                                                <a data-repeater-delete class="delete-btn">
                                                    <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            <?php else : ?>
                                <div data-repeater-item>
                                    <div class="send-time">
                                        <div>
                                            <input type="text" name="variable" placeholder="<?php esc_html_e('متغیر', 'woodmartplus'); ?>">
                                            <input type="text" name="shortcode" placeholder="<?php esc_html_e('شورتکد', 'woodmartplus'); ?>">
                                            <a data-repeater-delete class="delete-btn">
                                                <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="add-time">
                            <button data-repeater-create type="button">
                                <!-- <img src="path/to/plus.svg" alt="add"> -->
                                <p><?php esc_html_e('افزودن متغیر جدید', 'woodmartplus'); ?></p>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="add-suggestions open_acard" style="margin-top:20px;">
            <div class="suggestion-title">
                <span class="suggestion-menu">
                    <p><?php esc_html_e('مسترد شده', 'woodmartplus'); ?></p>
                </span>
                <span class="arrow-icon"><img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/arrow-down2.svg" alt=""></span>
            </div>
            <div class="suggestion-content">
                <div class="suggestion-inputs gray-inp">
                    <!-- Pattern Input -->
                    <div class="suggestion-inputs gray-inp" style="margin-bottom:.8rem;">
                        <input type="text" name="<?php echo wplus_helper::generate_option('[notif_manager][pattern-refunded]'); ?>" placeholder="<?php esc_html_e('پترن پیامک را وارد کنید', 'woodmartplus'); ?>" value="<?php echo isset($notif_manager['pattern-refunded']) && !empty($notif_manager['pattern-refunded']) ? esc_html($notif_manager['pattern-refunded']) : '' ?>">
                    </div>
                    <!-- Variables Repeater -->
                    <div class="repeater-container">
                        <div data-repeater-list="<?php echo wplus_helper::generate_option('[notif_manager][variables-refunded]'); ?>">
                            <?php if (isset($notif_manager['variables-refunded']) && !empty($notif_manager['variables-refunded'])) : ?>
                                <?php foreach ($notif_manager['variables-refunded'] as $key => $value) : ?>

                                    <div data-repeater-item>
                                        <div class="send-time">
                                            <div>
                                                <input type="text" name="variable" placeholder="<?php esc_html_e('متغیر', 'woodmartplus'); ?>" value="<?php echo isset($value['variable'])  ? esc_html($value['variable']) : '' ?>">
                                                <input type="text" name="shortcode" placeholder="<?php esc_html_e('شورتکد', 'woodmartplus'); ?>" value="<?php echo isset($value['shortcode']) && !empty($value['shortcode']) ? esc_html($value['shortcode']) : '' ?>">
                                                <a data-repeater-delete class="delete-btn">
                                                    <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            <?php else : ?>
                                <div data-repeater-item>
                                    <div class="send-time">
                                        <div>
                                            <input type="text" name="variable" placeholder="<?php esc_html_e('متغیر', 'woodmartplus'); ?>">
                                            <input type="text" name="shortcode" placeholder="<?php esc_html_e('شورتکد', 'woodmartplus'); ?>">

                                            <a data-repeater-delete class="delete-btn">
                                                <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="add-time">
                            <button data-repeater-create type="button">
                                <!-- <img src="path/to/plus.svg" alt="add"> -->
                                <p><?php esc_html_e('افزودن متغیر جدید', 'woodmartplus'); ?></p>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="add-suggestions open_acard" style="margin-top:20px;">
            <div class="suggestion-title">
                <span class="suggestion-menu">
                    <p><?php esc_html_e('ناموفق', 'woodmartplus'); ?></p>
                </span>
                <span class="arrow-icon"><img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/arrow-down2.svg" alt=""></span>
            </div>
            <div class="suggestion-content">
                <div class="suggestion-inputs gray-inp">
                    <!-- Pattern Input -->
                    <div class="suggestion-inputs gray-inp" style="margin-bottom:.8rem;">
                        <input type="text" name="<?php echo wplus_helper::generate_option('[notif_manager][pattern-failed]'); ?>" placeholder="<?php esc_html_e('پترن پیامک را وارد کنید', 'woodmartplus'); ?>" value="<?php echo isset($notif_manager['pattern-failed']) && !empty($notif_manager['pattern-failed']) ? esc_html($notif_manager['pattern-failed']) : '' ?>">
                    </div>
                    <!-- Variables Repeater -->
                    <div class="repeater-container">
                        <div data-repeater-list="<?php echo wplus_helper::generate_option('[notif_manager][variables-failed]'); ?>">
                            <?php if (isset($notif_manager['variables-failed']) && !empty($notif_manager['variables-failed'])) : ?>
                                <?php foreach ($notif_manager['variables-failed'] as $key => $value) : ?>

                                    <div data-repeater-item>
                                        <div class="send-time">
                                            <div>
                                                <input type="text" name="variable" placeholder="<?php esc_html_e('متغیر', 'woodmartplus'); ?>" value="<?php echo isset($value['variable'])  ? esc_html($value['variable']) : '' ?>">
                                                <input type="text" name="shortcode" placeholder="<?php esc_html_e('شورتکد', 'woodmartplus'); ?>" value="<?php echo isset($value['shortcode']) && !empty($value['shortcode']) ? esc_html($value['shortcode']) : '' ?>">
                                                <a data-repeater-delete class="delete-btn">
                                                    <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            <?php else : ?>
                                <div data-repeater-item>
                                    <div class="send-time">
                                        <div>
                                            <input type="text" name="variable" placeholder="<?php esc_html_e('متغیر', 'woodmartplus'); ?>">
                                                <input type="text" name="shortcode" placeholder="<?php esc_html_e('شورتکد', 'woodmartplus'); ?>">
                                            <a data-repeater-delete class="delete-btn">
                                                <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="add-time">
                            <button data-repeater-create type="button">
                                <!-- <img src="path/to/plus.svg" alt="add"> -->
                                <p><?php esc_html_e('افزودن متغیر جدید', 'woodmartplus'); ?></p>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <div class="add-suggestions open_acard" style="margin-top:20px;">
            <div class="suggestion-title">
                <span class="suggestion-menu">
                    <p><?php esc_html_e('پیشنویس', 'woodmartplus'); ?></p>
                </span>
                <span class="arrow-icon"><img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/arrow-down2.svg" alt=""></span>
            </div>
            <div class="suggestion-content">
                <div class="suggestion-inputs gray-inp">
                    <!-- Pattern Input -->
                    <div class="suggestion-inputs gray-inp" style="margin-bottom:.8rem;">
                        <input type="text" name="<?php echo wplus_helper::generate_option('[notif_manager][pattern-checkout-draft]'); ?>" placeholder="<?php esc_html_e('پترن پیامک را وارد کنید', 'woodmartplus'); ?>" value="<?php echo isset($notif_manager['pattern-checkout-draft']) && !empty($notif_manager['pattern-checkout-draft']) ? esc_html($notif_manager['pattern-checkout-draft']) : '' ?>">
                    </div>
                    <!-- Variables Repeater -->
                    <div class="repeater-container">
                        <div data-repeater-list="<?php echo wplus_helper::generate_option('[notif_manager][variables-checkout-draft]'); ?>">
                            <?php if (isset($notif_manager['variables-checkout-draft']) && !empty($notif_manager['variables-checkout-draft'])) : ?>
                                <?php foreach ($notif_manager['variables-checkout-draft'] as $key => $value) : ?>

                                    <div data-repeater-item>
                                        <div class="send-time">
                                            <div>
                                                <input type="text" name="variable" placeholder="<?php esc_html_e('متغیر', 'woodmartplus'); ?>" value="<?php echo isset($value['variable']) ? esc_html($value['variable']) : '' ?>">
                                                <input type="text" name="shortcode" placeholder="<?php esc_html_e('شورتکد', 'woodmartplus'); ?>" value="<?php echo isset($value['shortcode']) && !empty($value['shortcode']) ? esc_html($value['shortcode']) : '' ?>">
                                                <a data-repeater-delete class="delete-btn">
                                                    <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                                                </a>
                                            </div>
                                        </div>
                                    </div>
                                <?php endforeach; ?>
                            <?php else : ?>
                                <div data-repeater-item>
                                    <div class="send-time">
                                        <div>
                                            <input type="text" name="variable" placeholder="<?php esc_html_e('متغیر', 'woodmartplus'); ?>">
                                            <input type="text" name="shortcode" placeholder="<?php esc_html_e('شورتکد', 'woodmartplus'); ?>">
                                            <a data-repeater-delete class="delete-btn">
                                                <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                                            </a>
                                        </div>
                                    </div>
                                </div>
                            <?php endif; ?>
                        </div>
                        <div class="add-time">
                            <button data-repeater-create type="button">
                                <p><?php esc_html_e('افزودن متغیر جدید', 'woodmartplus'); ?></p>
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>