<div class="item p-18 br-bottom">
    <span class="title"><?php esc_html_e('چه وضعیت های در داشبورد کاربر نمایش داده نشود', 'woodmartplus') ?></span>
    <p class="des"><?php esc_html_e('یک یا بیش از یک مورد را میتوانید انتخاب کنید', 'woodmartplus'); ?></p>
    <div>
        <?php $disable_status_order = wplus_helper::get_setting('disable_status_order', []); ?>
        <select class="js-example-basic-multiple" name="<?php echo wplus_helper::generate_option('[disable_status_order][]'); ?>" multiple="multiple" dir="rtl">
            <?php foreach (wplus_helper::get_wc_status() as $key => $value): ?>
                <?php if (strpos($key, '%') !== false) {
                    $key = urldecode($key);
                } ?>
                <option value="<?php echo esc_attr($key) ?>" <?php echo in_array($key, $disable_status_order) ? 'selected' : '' ?>><?php echo esc_html($value); ?></option>
            <?php endforeach; ?>
        </select>
    </div>
</div>

<div class="item p-18 br-bottom">
   <span class="title"><?php esc_html_e('تایید شماره موبایل زمان ثبت نام در پرداخت', 'woodmartplus'); ?></span>
   <p class="des"><?php esc_html_e('اگر شما حالت ثبت نام حین پرداخت از پیکربندی ووکامرس را فعال کرده باشید ، با فعال کردن این گزینه هم ، زمان پرداخت تایید شماره موبایل از کاربر دریافت می شود', 'woodmartplus'); ?></p>
   <div class="btn-select">
      <input type="checkbox" class="switch" name="<?php echo wplus_helper::generate_option('[confirm_phone_payment]'); ?>" <?php echo wplus_helper::show_value('confirm_phone_payment', false) ? 'checked' : '' ?> data-condition="confirm_phone_condition">
   </div>
</div>

<?php $confirm_detial = wplus_helper::get_setting('confirm_phone',[]); ?>
<div class="item confirm_phone_condition">
   <div class="manager-sms-wrapper">
      <div class="br-bottom">
         <div class="sms-sent-post m-t-18" style="margin-bottom: 15px;">
            <div class="short-code-text">
               <span class="title"><?php esc_html_e('شورتکد ها', 'woodmartplus'); ?></span>
               <p class="des"><?php esc_html_e('شورتکد تایید شماره موبایل', 'woodmartplus'); ?></p>
            </div>
            <div class="sms-sent-post-detailes br-radius-8">
               <p><?php esc_html_e('کد احراز هویت = [OTP]', 'woodmartplus'); ?></p>
            </div>
         </div>
      </div>
      <div class="add-suggestions open_acard opened" style="margin-top:20px;">
         <div class="suggestion-title">
            <span class="suggestion-menu">
               <p><?php esc_html_e('قرار دادن اطلاعات پترن زمان ثبت نام حین پرداخت', 'woodmartplus'); ?></p>
            </span>
            <span class="arrow-icon"><img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/arrow-down2.svg" alt=""></span>
         </div>
         <div class="suggestion-content">
            <div class="suggestion-inputs gray-inp">
               <!-- Pattern Input -->
               <div class="suggestion-inputs gray-inp" style="margin-bottom:.8rem;">
                  <input type="text" name="<?php echo wplus_helper::generate_option('[confirm_phone][pattern]'); ?>" placeholder="<?php esc_html_e('پترن پیامک را وارد کنید', 'woodmartplus'); ?>" value="<?php echo isset($confirm_detial['pattern']) && !empty($confirm_detial['pattern']) ? esc_html($confirm_detial['pattern']) : '' ?>">
               </div>
               <!-- Variables Repeater -->
                <?php if (isset($sms_otp['variables']) && !empty($sms_otp['variables'])) : ?>
                    <div class="send-time">
                        <div>
                        <input type="text" name="<?php echo wplus_helper::generate_option('[confirm_phone][variable]'); ?>" placeholder="<?php esc_html_e('متغیر', 'woodmartplus'); ?>" value="<?php echo isset($confirm_detial['variable']) && !empty($confirm_detial['variable']) ? esc_html($confirm_detial['variable']) : '' ?>">
                        <input type="text" name="<?php echo wplus_helper::generate_option('[confirm_phone][shortcode]'); ?>" placeholder="<?php esc_html_e('شورتکد', 'woodmartplus'); ?>" value="<?php echo isset($confirm_detial['shortcode']) && !empty($confirm_detial['shortcode']) ? esc_html($confirm_detial['shortcode']) : '' ?>">
                        </div>
                    </div>
                <?php else : ?>
                    <div class="send-time">
                        <div>
                            <input type="text" name="<?php echo wplus_helper::generate_option('[confirm_phone][variable]'); ?>" placeholder="<?php esc_html_e('متغیر', 'woodmartplus'); ?>">
                            <input type="text" name="<?php echo wplus_helper::generate_option('[confirm_phone][shortcode]'); ?>" placeholder="<?php esc_html_e('شورتکد', 'woodmartplus'); ?>">
                        </div>
                    </div>
                <?php endif; ?>
            </div>
         </div>
      </div>

   </div>
</div>

<div class="item br-bottom p-18 confirm_phone_condition">
   <span class="title"><?php esc_html_e('متغییر های ارسال پیامک', 'woodmartplus'); ?></span>
   <p class="des"><?php esc_html_e('متغییر های خود را تنظیم کنید', 'woodmartplus'); ?></p>
   <div class="progress-wrapper br-radius-8 m-t-18">
      <div class="progress-content">
         <div class="progress-bar-left">
            <p><?php esc_html_e('مدت زمان انتظار ارسال مجدد', 'woodmartplus') ?></p>
            <div class="inp-rang p-top-18">
               <input type="range" class="rang" min="1" max="120" value="<?php echo isset($confirm_detial['wating_resend']) && !empty($confirm_detial['wating_resend']) ? esc_html($confirm_detial['wating_resend']) : 50 ?>" name="<?php echo wplus_helper::generate_option('[confirm_phone][wating_resend]'); ?>">
               <div class="br-radius-8 rang-number d-center">
                  <span class="num">1200</span><span class="text-num"><?php esc_html_e('ثانیه', 'woodmartplus'); ?></span>
               </div>
            </div>
         </div>
         <div class="progress-bar-right">
            <p><?php esc_html_e('تعداد ارقام کد احراز هویت', 'woodmartplus'); ?></p>
            <div class="inp-rang p-top-18">
               <input type="range" class="rang" min="1" max="6" value="<?php echo isset($confirm_detial['number_otp']) && !empty($confirm_detial['number_otp']) ? esc_html($confirm_detial['number_otp']) : 4 ?>" name="<?php echo wplus_helper::generate_option('[confirm_phone][number_otp]'); ?>">
               <div class="br-radius-8 rang-number d-center">
                  <span class="num">1200</span><span class="text-num"><?php esc_html_e('تعداد', 'woodmartplus'); ?></span>
               </div>
            </div>
         </div>
      </div>
   </div>
</div>