<!DOCTYPE html>
<html <?php language_attributes(); ?>>

<head>
   <meta charset="UTF-8">
   <meta name="viewport" content="width=device-width, initial-scale=1.0">
   <title><?php echo __('ثبت نام / ورود','woodmartplus') . ' - ' . get_bloginfo('name'); ?></title>
   <link rel="stylesheet" href="<?php echo WOODPLUS_ASSET ?>css/all.css">
   <link rel="stylesheet" href="<?php echo WOODPLUS_ASSET ?>css/fontawesome.css">
   <link rel="stylesheet" href="<?php echo WOODPLUS_ASSET ?>css/global-fonts.css">
   <link rel="stylesheet" href="<?php echo WOODPLUS_ASSET ?>css/hint.min.css">
   <link rel="stylesheet" href="<?php echo WOODPLUS_ASSET ?>css/global.css">
   <link rel="stylesheet" href="<?php echo WOODPLUS_ASSET ?>css/kamadatepicker.min.css">
   <link rel="icon" href="<?php echo get_site_icon_url() ? get_site_icon_url()  : ''  ?>" />
   <style>
      :root {
         --width-width3: <?php echo wplus_helper::get_setting('width_dashboard') . 'px'; ?>;
         --main-color: <?php echo wplus_helper::get_setting('color_dashboard'); ?>;
         --link-color: <?php echo wplus_helper::get_setting('color_link_dashboard'); ?>;
         --red-1: <?php echo wplus_helper::get_setting('color_dashboard'); ?>;
         --red-5: <?php echo wplus_helper::get_setting('color_dashboard_hover'); ?>;
         --blue-3: <?php echo wplus_helper::get_setting('color_dashboard'); ?>;
      }

      :root {
         --primary-color: var(--main-color);
         --secondary-color: var(--red-5);
         --background-color: #f5f5f5;
         --form-background: rgba(255, 255, 255, 0.98);
         --text-primary: #333;
         --text-secondary: #666;
         --shadow-color: var(--red-5);
         --border-color: #eee;
      }

      <?php 
       $firstColor = wplus_helper::get_background_img_color_login('color_bg_login_register');
       $secoundColor = wplus_helper::get_setting('color_two_bg_login_register');
       $background = $firstColor .'!important';
       if( $secoundColor )
       {
         $background = 'linear-gradient(233deg, '.$firstColor.', '.$secoundColor.') !important';
       }
      ?>

      body {

         font-family: <?php echo wplus_helper::get_setting('font_dashboard', 'IRANSansX');  ?>;
         background: <?php echo $background ?>;
         background-repeat: no-repeat;
         background-size: 100% auto;
         background-position: center top;
         background-attachment: fixed;
      }

      .text_darkgray {
         line-height: 1.7;
         margin-top: 17px;
         text-align: center;
      }

      .login_container img {
         width: 100px;
      }
   </style>
   <script>
      <?php
      $pages = [
         'cart' => wc_get_page_permalink('cart'),
         'myacc' =>  wplus_helper::get_setting('redirect_after_login', wc_get_page_permalink('myaccount')),
         'cart_hash_key' => WC()->ajax_url() . '-wc_cart_hash',
      ];
      ?>
      var optionarray = <?php
                        echo  json_encode([
                           'woodplus_url' => admin_url('admin-ajax.php'),
                           'nonce' => wp_create_nonce('woodplus_script_nonce'),
                           'WcPage'  => $pages,
                           'wating_time_resend_otp' => wplus_helper::get_setting('wating_resend', 30),
                           'add_tocart' => __('محصول را به سبد خرید اضافه شد', 'woodmartplus'),
                           'captcha_is_enable' =>  wplus_helper::get_setting('setting_recaptcha_enable') ? true : false,
                           'resend_text' => __('ارسال مجدد کد تا', 'woodmartplus'),
                           'errors' => [
                              'latinUsername' => __('نام کاربری را به لاتین وارد کنید','woodmartplus'),
                              'passwordNotSame' => __('رمزعبور یکسان نیست','woodmartplus'),
                              'passwordLessThan' => __('رمزعبور نمیتواند کمتر 6 حرف باشد','woodmartplus')
                           ],
                           'change_email' => __('تغییر ایمیل','woodmartplus'),
                           'login_whit_password' =>  __('ورود با رمزعبور','woodmartplus'),
                        ]); ?>
   </script>

   <title><?php esc_html_e('ورود', 'woodmartplus'); ?></title>
</head>
<?php do_action('woodplus_dashboard_head'); ?>
<?php 
$custom_css = wplus_helper::get_setting('wplus_custom_css');
if( $custom_css ){
	echo '<style>'.$custom_css.'</style>';
}
?>
<body <?php body_class(); ?>>


   <?php


   $number_digits = wplus_helper::get_setting('number_otp', 4);
   $how_register = wplus_helper::get_setting('register_login_type', 'layout-4');

   if ('lr_woocommerce' === $how_register) {
      $how_register = 'layout-4';
   }

   if ('layout-3' === $how_register || 'layout-2' === $how_register) {
      $how_register = 'layout-5';
   }

   do_action('woocommerce_before_customer_login_form'); ?>

   <?php include "layout/$how_register.php"; ?>


   <script src="<?php echo WOODPLUS_ASSET ?>js/jquery.min.js"></script>
   <?php if (wplus_helper::get_setting('setting_recaptcha_enable')): ?>
      <script src="https://www.google.com/recaptcha/api.js?onload=onloadCallbackCaptcha&render=explicit"></script>
   <?php endif; ?>
   <script src="<?php echo WOODPLUS_ASSET ?>js/kamadatepicker.min.js"></script>
   <script src="<?php echo WOODPLUS_ASSET ?>js/w-plus.js"></script>
</body>

</html>