<div class="feedback-popup-container">
    <div class="product-feedback-header">
        <div class="product-feedback-image">
            <img src="<?php echo esc_url($product['product_image']); ?>" alt="<?php echo esc_attr($product['product_title']); ?>">
        </div>
        <div class="product-feedback-info">
            <h3 class="product-feedback-title">
                <a href="<?php echo esc_url($product['product_url']) ?>">
                    <?php echo esc_html($product['product_title']); ?>
                </a>
            </h3>
            <p class="product-feedback-subtitle"><?php esc_html_e('لطفا نظر خود را درباره این محصول ثبت کنید', 'woodmartplus'); ?></p>
        </div>
    </div>

    <div class="product-feedback-rating">
        <h4 class="rating-title"><?php esc_html_e('امتیاز شما', 'woodmartplus'); ?></h4>
        <div class="star-rating-feedback-container">
            <div class="star-rating-feedback">
                <input type="radio" id="star5" name="rating_feedback" value="5" />
                <label for="star5" title="5 ستاره">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" class="star-icon">
                        <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                    </svg>
                </label>
                <input type="radio" id="star4" name="rating_feedback" value="4" />
                <label for="star4" title="4 ستاره">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" class="star-icon">
                        <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                    </svg>
                </label>
                <input type="radio" id="star3" name="rating_feedback" value="3" />
                <label for="star3" title="3 ستاره">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" class="star-icon">
                        <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                    </svg>
                </label>
                <input type="radio" id="star2" name="rating_feedback" value="2" />
                <label for="star2" title="2 ستاره">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" class="star-icon">
                        <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                    </svg>
                </label>
                <input type="radio" id="star1" name="rating_feedback" value="1" />
                <label for="star1" title="1 ستاره">
                    <svg xmlns="http://www.w3.org/2000/svg" width="24" height="24" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" class="star-icon">
                        <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                    </svg>
                </label>
            </div>
            <div class="rating-value-display">
                <span class="rating-number">0</span>
                <span class="rating-text"><?php esc_html_e('از 5 ستاره', 'woodmartplus'); ?></span>
            </div>
        </div>
    </div>

    <div class="product-feedback-comment">
        <h4 class="comment-title"><?php esc_html_e('متن دیدگاه', 'woodmartplus'); ?></h4>
        <div class="comment-textarea-container">
            <textarea name="comment_feedback" placeholder="<?php esc_html_e('دیدگاه خود را درباره این محصول بنویسید...', 'woodmartplus') ?>"></textarea>
        </div>
    </div>

    <input type="hidden" name="product_id" value="<?php echo esc_attr($product['product_id']); ?>">
    <?php wp_nonce_field('feedback_nonce', 'nonce_feedback'); ?>

    <div class="product-feedback-submit">
        <button type="submit" class="btn_feedback">
            <div class="lds-ellipsis-feedback">
                <div></div>
                <div></div>
                <div></div>
                <div></div>
            </div>
            <span><?php esc_html_e('ثبت دیدگاه', 'woodmartplus'); ?></span>
        </button>
    </div>
</div>


<script>
jQuery(document).ready(function($) {
    $('.star-rating-feedback input').on('change', function() {
        var ratingValue = $(this).val();
        $('.rating-number').text(ratingValue);
    });
    
    $('.rating-number').text('0');
    
    $('.star-rating-feedback label').hover(
        function() {
            var currentStar = parseInt($(this).prev('input').val(), 10);
            $('.rating-number').text(currentStar);
        },
        function() {
            var checkedStar = $('.star-rating-feedback input:checked').val();
            $('.rating-number').text(checkedStar ? checkedStar : '0');
        }
    );
});
</script>