        
<?php
$getDetial = HelperTransferSetting::getInstance()->getSetting('feedback_setting',[])
?>
<div class="white_card feedback_page">
    <div class="card_header">
        <div class="title">
            <svg xmlns="http://www.w3.org/2000/svg" width="22" height="22" viewBox="0 0 22 22" fill="none">
                <path d="M11.018 2.66748C7.98388 2.66748 5.51805 5.13331 5.51805 8.16748V10.8166C5.51805 11.3758 5.27971 12.2283 4.99555 12.705L3.94138 14.4558C3.29055 15.5375 3.73971 16.7383 4.93138 17.1416C8.88221 18.4616 13.1447 18.4616 17.0955 17.1416C18.2047 16.775 18.6905 15.4641 18.0855 14.4558L17.0314 12.705C16.7564 12.2283 16.518 11.3758 16.518 10.8166V8.16748C16.518 5.14248 14.043 2.66748 11.018 2.66748Z" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round"></path>
                <path d="M12.7139 2.93332C12.4298 2.85082 12.1364 2.78665 11.8339 2.74999C10.9539 2.63999 10.1106 2.70415 9.32227 2.93332C9.5881 2.25499 10.2481 1.77832 11.0181 1.77832C11.7881 1.77832 12.4481 2.25499 12.7139 2.93332Z" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10" stroke-linecap="round" stroke-linejoin="round"></path>
                <path d="M13.7686 17.4717C13.7686 18.9842 12.5311 20.2217 11.0186 20.2217C10.2669 20.2217 9.57022 19.91 9.07522 19.415C8.58022 18.92 8.26855 18.2233 8.26855 17.4717" stroke="currentColor" stroke-width="1.5" stroke-miterlimit="10"></path>
            </svg>
            <p><?php echo isset( $getDetial['title_first'] ) ? esc_html($getDetial['title_first']) : __('تجربه های خرید', 'woodmartplus'); ?></p>
        </div>
        <hr>
    </div>

    <div class="feedback-tabs">
        <div class="tab-header">
            <div class="tab-btn active" data-tab="no-feedback"><?php echo isset( $getDetial['title_wating'] ) ? esc_html($getDetial['title_wating']) :  __('در انتظار ثبت تجربه', 'woodmartplus'); ?></div>
            <div class="tab-btn" data-tab="with-feedback"><?php echo isset( $getDetial['title_have_feedback'] ) ? esc_html( $getDetial['title_have_feedback'] ) : esc_html_e('تجربه های خرید', 'woodmartplus'); ?></div>
        </div>
        
        <div class="tab-content active" id="no-feedback-tab">
            <div class="items">
                <?php if (empty($dont_have_feedback)): ?>
                    <div class="empty-feedback-state">
                        <div class="empty-feedback-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="120" height="120" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round" class="feather-empty-box">
                                <path d="M21 16V8a2 2 0 0 0-1-1.73l-7-4a2 2 0 0 0-2 0l-7 4A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16z"></path>
                                <polyline points="3.27 6.96 12 12.01 20.73 6.96"></polyline>
                                <line x1="12" y1="22.08" x2="12" y2="12"></line>
                                <circle cx="12" cy="12" r="4" class="feedback-circle"></circle>
                            </svg>
                        </div>
                        <h3><?php esc_html_e('محصولی برای ثبت تجربه وجود ندارد', 'woodmartplus'); ?></h3>
                        <p><?php esc_html_e('پس از خرید محصولات، آنها در این قسمت نمایش داده می‌شوند', 'woodmartplus'); ?></p>
                    </div>
                <?php else: ?>
                    <?php foreach ($dont_have_feedback as $product): ?>
                        <div class="product_items no-feedback-item">
                            <div class="header_product_items">
                                <div class="product_image">
                                    <img src="<?php echo esc_url($product['product_image_url']) ?>" alt="<?php echo esc_attr($product['product_name']); ?>">
                                </div>
                                <span class="title">
                                    <a href="<?php echo esc_url($product['product_url']); ?>">
                                        <?php echo esc_html($product['product_name']); ?>
                                    </a>
                                </span>
                            </div>
                            <div class="footer_product_items">
                                <button class="btn_send_review" data-product_id="<?php echo esc_attr($product['product_id']); ?>">
                                    <svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="2" stroke-linecap="round" stroke-linejoin="round" class="feather-star">
                                        <polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon>
                                    </svg>
                                    <span><?php esc_html_e('ثبت بازخورد', 'woodmartplus'); ?></span>
                                </button>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
        
        
        <div class="tab-content" id="with-feedback-tab">
            <div class="items">
                <?php if (empty($have_feedback)): ?>
                    <div class="empty-feedback-state">
                        <div class="empty-feedback-icon">
                            <svg xmlns="http://www.w3.org/2000/svg" width="120" height="120" viewBox="0 0 24 24" fill="none" stroke="currentColor" stroke-width="1" stroke-linecap="round" stroke-linejoin="round" class="feather-empty-box">
                                <path d="M21 16V8a2 2 0 0 0-1-1.73l-7-4a2 2 0 0 0-2 0l-7 4A2 2 0 0 0 3 8v8a2 2 0 0 0 1 1.73l7 4a2 2 0 0 0 2 0l7-4A2 2 0 0 0 21 16z"></path>
                                <polyline points="3.27 6.96 12 12.01 20.73 6.96"></polyline>
                                <line x1="12" y1="22.08" x2="12" y2="12"></line>
                                <circle cx="12" cy="12" r="4" class="feedback-circle"></circle>
                            </svg>
                        </div>
                        <h3><?php esc_html_e('شما هنوز تجربه ای ثبت نکرده‌اید', 'woodmartplus'); ?></h3>
                        <p><?php esc_html_e('پس از ثبت بازخورد برای محصولات، آنها در این قسمت نمایش داده می‌شوند', 'woodmartplus'); ?></p>
                    </div>
                <?php else: ?>
                    <?php foreach ($have_feedback as $product): ?>
                        <div class="product_items feedback-item">
                            <div class="details">
                                <div class="product_image">
                                    <img src="<?php echo esc_url($product['product_image_url']) ?>" alt="<?php echo esc_attr($product['product_name']); ?>">
                                </div>
                                <div class="title_product">
                                    <a href="<?php echo esc_url($product['product_url']); ?>">
                                        <?php echo esc_html($product['product_name']); ?>
                                    </a>
                                </div>
                            </div>
                            
                            <div class="product_body">
                                <div class="rating_user_added">
                                    <?php 
                                    $rating = isset($product['rating']) ? intval($product['rating']) : 0;
                                    for ($i = 1; $i <= 5; $i++) {
                                        if ($i <= $rating) {
                                            echo '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="#FFB900" stroke="#FFB900" stroke-width="1.5" class="star-icon"><polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon></svg>';
                                        } else {
                                            echo '<svg xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 24 24" fill="transparent" stroke="#ccc" stroke-width="1.5" class="star-icon"><polygon points="12 2 15.09 8.26 22 9.27 17 14.14 18.18 21.02 12 17.77 5.82 21.02 7 14.14 2 9.27 8.91 8.26 12 2"></polygon></svg>';
                                        }
                                    }
                                    ?>
                                </div>
                                <div class="date_user_added_rating">
                                    <?php 
                                        $date = isset($product['feedback_date']) ? $product['feedback_date'] : '';
                                        if (!empty($date)) {
                                            echo esc_html(date_i18n(get_option('date_format'), strtotime($date)));
                                        }
                                    ?>
                                </div>
                            </div>
                            
                            <div class="product_footer user_comment">

                                <?php if (!empty($product['feedback_comment'])): ?>
                                    <div class="comment-container">
                                        <p class="comment-text"><?php echo esc_html($product['feedback_comment']); ?></p>
                                        <button class="read-more-btn"><?php esc_html_e('بیشتر', 'woodmartplus'); ?></button>
                                    </div>
                                <?php else: ?>
                                    <p class="no-comment"><?php esc_html_e('بدون دیدگاه', 'woodmartplus'); ?></p>
                                <?php endif; ?>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php endif; ?>
            </div>
        </div>
    </div>

    <div class="popup-overlay"></div>
    <div class="popup-feedback">
        <div class="feedback-popup-close">
            <button style="background:transparent;color:white;">X</button>
        </div>
        <div class="popup-content">
            <div class="notic-feedback">
                <span></span>
            </div>
            <div class="lds-ring-feedback">
                <div></div>
                <div></div>
                <div></div>
                <div></div>
            </div>
            <form class="product_show">

            </form>
        </div>
    </div>

</div>

