<!DOCTYPE html>
<html <?php language_attributes(); ?>>
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php esc_html_e('پیش فاکتور','woodmartplus'); ?></title>
    <link rel="stylesheet" href="<?php echo WOODPLUS_ASSET ?>css/pre-factor.css">
    <?php wp_head(); ?>

    <style>
        :root {
            --color-factor: <?php echo wplus_helper::get_setting('color_pre_factor'); ?>;
            --factor-width: <?php echo wplus_helper::get_setting('width_factor') . 'px'; ?>;
        }
    </style>
</head>
<body <?php body_class(); ?>>
    <div class="action-buttons">
        <button class="action-button print-button" onclick="window.print()">
            <svg><use xlink:href="#icon-print"/></svg>
            <?php esc_html_e('چاپ پیش فاکتور','woodmartplus'); ?>
        </button>
    </div>
    <!-- SVG Definitions (hidden) -->
    <svg xmlns="http://www.w3.org/2000/svg" style="display: none;">
        <symbol id="icon-invoice" viewBox="0 0 24 24">
            <path d="M14 2H6C4.9 2 4 2.9 4 4V20C4 21.1 4.9 22 6 22H18C19.1 22 20 21.1 20 20V8L14 2ZM18 20H6V4H13V9H18V20ZM8 14H16V16H8V14ZM8 10H16V12H8V10Z"/>
        </symbol>
        <symbol id="icon-calendar" viewBox="0 0 24 24">
            <path d="M20 3H19V1H17V3H7V1H5V3H4C2.9 3 2 3.9 2 5V21C2 22.1 2.9 23 4 23H20C21.1 23 22 22.1 22 21V5C22 3.9 21.1 3 20 3ZM20 21H4V8H20V21Z"/>
        </symbol>
        <symbol id="icon-hourglass" viewBox="0 0 24 24">
            <path d="M6 2V8H6.01L6 8.01L10 12L6 16L6.01 16.01H6V22H18V16.01H17.99L18 16L14 12L18 8.01L17.99 8H18V2H6ZM16 16.5V20H8V16.5L12 12.5L16 16.5ZM12 11.5L8 7.5V4H16V7.5L12 11.5Z"/>
        </symbol>
        <symbol id="icon-store" viewBox="0 0 24 24">
            <path d="M20 4H4V6H20V4ZM21 14V12L20 7H4L3 12V14H4V20H14V14H18V20H20V14H21ZM12 18H6V14H12V18Z"/>
        </symbol>
        <symbol id="icon-location" viewBox="0 0 24 24">
            <path d="M12 2C8.13 2 5 5.13 5 9C5 14.25 12 22 12 22C12 22 19 14.25 19 9C19 5.13 15.87 2 12 2ZM12 11.5C10.62 11.5 9.5 10.38 9.5 9C9.5 7.62 10.62 6.5 12 6.5C13.38 6.5 14.5 7.62 14.5 9C14.5 10.38 13.38 11.5 12 11.5Z"/>
        </symbol>
        <symbol id="icon-phone" viewBox="0 0 24 24">
            <path d="M6.62 10.79C8.06 13.62 10.38 15.94 13.21 17.38L15.41 15.18C15.69 14.9 16.08 14.82 16.43 14.94C17.55 15.31 18.76 15.51 20 15.51C20.55 15.51 21 15.96 21 16.51V20C21 20.55 20.55 21 20 21C10.61 21 3 13.39 3 4C3 3.45 3.45 3 4 3H7.5C8.05 3 8.5 3.45 8.5 4C8.5 5.24 8.7 6.45 9.07 7.57C9.18 7.92 9.1 8.31 8.82 8.59L6.62 10.79Z"/>
        </symbol>
        <symbol id="icon-email" viewBox="0 0 24 24">
            <path d="M20 4H4C2.9 4 2.01 4.9 2.01 6L2 18C2 19.1 2.9 20 4 20H20C21.1 20 22 19.1 22 18V6C22 4.9 21.1 4 20 4ZM20 8L12 13L4 8V6L12 11L20 6V8Z"/>
        </symbol>
        <symbol id="icon-info" viewBox="0 0 24 24">
            <path d="M12 2C6.48 2 2 6.48 2 12C2 17.52 6.48 22 12 22C17.52 22 22 17.52 22 12C22 6.48 17.52 2 12 2ZM13 17H11V11H13V17ZM13 9H11V7H13V9Z"/>
        </symbol>
        <symbol id="icon-stamp" viewBox="0 0 24 24">
            <path d="M12 2C6.48 2 2 6.48 2 12C2 17.52 6.48 22 12 22C17.52 22 22 17.52 22 12C22 6.48 17.52 2 12 2ZM12 20C7.59 20 4 16.41 4 12C4 7.59 7.59 4 12 4C16.41 4 20 7.59 20 12C20 16.41 16.41 20 12 20ZM16.59 7.58L10 14.17L7.41 11.59L6 13L10 17L18 9L16.59 7.58Z"/>
        </symbol>
        <symbol id="icon-print" viewBox="0 0 24 24">
            <path d="M19 8H5C3.34 8 2 9.34 2 11V17H6V21H18V17H22V11C22 9.34 20.66 8 19 8ZM16 19H8V14H16V19ZM19 12C18.45 12 18 11.55 18 11C18 10.45 18.45 10 19 10C19.55 10 20 10.45 20 11C20 11.55 19.55 12 19 12ZM18 3H6V7H18V3Z"/>
        </symbol>
        <symbol id="icon-save" viewBox="0 0 24 24">
            <path d="M17 3H5C3.89 3 3 3.9 3 5V19C3 20.1 3.89 21 5 21H19C20.1 21 21 20.1 21 19V7L17 3ZM19 19H5V5H16.17L19 7.83V19ZM12 12C10.34 12 9 13.34 9 15C9 16.66 10.34 18 12 18C13.66 18 15 16.66 15 15C15 13.34 13.66 12 12 12ZM7 7H15V9H7V7Z"/>
        </symbol>
    </svg>
    <?php if( wplus_helper::get_setting('elementor_builder_pre_factor') ): ?>
        <?php do_action('elementor_builder_pre_factor'); ?>
    <?php else: ?>
        <div class="container_prefactor">

        
            <div class="header">
                <div class="logo-container">
                    <?php if($seller_info['seller_logo']['output']): ?>
                        <img src="<?php echo $seller_info['seller_logo']['output']; ?>" alt="<?php esc_html_e('لوگوی فروشگاه','woodmartplus'); ?>" class="logo">
                    <?php endif; ?>
                </div>
                <div class="invoice-info">
                    <p>
                        <svg class="icon"><use xlink:href="#icon-invoice"/></svg>
                        <?php esc_html_e('شماره پیش فاکتور','woodmartplus'); ?>: <?php echo $order_info['order_id']; ?>
                    </p>
                    <p>
                        <svg class="icon"><use xlink:href="#icon-calendar"/></svg>
                        <?php esc_html_e('تاریخ','woodmartplus'); ?>: <?php echo $order_info['order_date']; ?>
                    </p>
                    <p>
                        <svg class="icon"><use xlink:href="#icon-hourglass"/></svg>
                        <?php esc_html_e('تاریخ اعتبار','woodmartplus'); ?>: <?php echo $order_info['order_date_expire']; ?>
                    </p>
                </div>
            </div>

            <h1 class="title"><?php esc_html_e('پیش فاکتور','woodmartplus'); ?></h1>

            <div class="info-container">
                <div class="seller-info">
                    <h3><?php esc_html_e('اطلاعات فروشنده','woodmartplus'); ?></h3>
                    <?php if($seller_info['seller_name']['output'] ): ?>
                        <p>
                            <svg class="icon"><use xlink:href="#icon-store"/></svg>
                            <strong><?php echo $seller_info['seller_name']['label']; ?>:</strong> <?php echo $seller_info['seller_name']['output']; ?>
                        </p>
                    <?php endif; ?>
                    <?php if($seller_info['seller_address']['output'] ): ?>
                        <p>
                            <svg class="icon"><use xlink:href="#icon-location"/></svg>
                            <strong><?php echo $seller_info['seller_address']['label']; ?>:</strong> <?php echo $seller_info['seller_address']['output']; ?>
                        </p>    
                    <?php endif; ?>
                    <?php if($seller_info['seller_phone']['output'] ): ?>
                        <p>
                            <svg class="icon"><use xlink:href="#icon-phone"/></svg>
                            <strong><?php echo $seller_info['seller_phone']['label']; ?>:</strong> <?php echo $seller_info['seller_phone']['output']; ?>
                        </p>
                    <?php endif; ?>
                    <?php if($seller_info['national_id']['output'] ): ?>
                    <p>
                        <svg class="icon"><use xlink:href="#icon-email"/></svg>
                        <strong><?php echo $seller_info['national_id']['label']; ?>:</strong> <?php echo $seller_info['national_id']['output']; ?>
                    </p>
                    <?php endif; ?>
                </div>
                <?php if( $customer_info ): ?>
                <div class="customer-info">
                    <h3><?php esc_html_e('اطلاعات مشتری','woodmartplus'); ?></h3>
                    <?php if(isset($customer_info['customer_name']) && $customer_info['customer_name']): ?>
                        <p>
                            <svg class="icon"><use xlink:href="#icon-store"/></svg>
                            <strong><?php esc_html_e('نام مشتری','woodmartplus'); ?>:</strong> <?php echo $customer_info['customer_name']; ?>
                        </p>
                    <?php endif; ?>
                    <?php if(isset($customer_info['customer_address']) && $customer_info['customer_address']): ?>
                        <p>
                            <svg class="icon"><use xlink:href="#icon-location"/></svg>
                            <strong><?php esc_html_e('آدرس','woodmartplus'); ?>:</strong> <?php echo $customer_info['customer_address']; ?>
                        </p>
                    <?php endif; ?>
                    <?php if(isset($customer_info['customer_phone']) && $customer_info['customer_phone']): ?>
                        <p>
                            <svg class="icon"><use xlink:href="#icon-phone"/></svg>
                            <strong><?php esc_html_e('شماره تماس','woodmartplus'); ?>:</strong> <?php echo $customer_info['customer_phone']; ?>
                        </p>
                    <?php endif; ?>
                    <?php if(isset($customer_info['customer_email']) && $customer_info['customer_email']): ?>
                        <p>
                            <svg class="icon"><use xlink:href="#icon-email"/></svg>
                            <strong><?php esc_html_e('ایمیل','woodmartplus'); ?>:</strong> <?php echo $customer_info['customer_email']; ?>
                        </p>
                    <?php endif; ?>
                    <?php if(isset($customer_info['customer_national_id']) && $customer_info['customer_national_id']): ?>
                        <p>
                            <svg class="icon"><use xlink:href="#icon-info"/></svg>
                            <strong><?php esc_html_e('کد ملی','woodmartplus'); ?>:</strong> <?php echo $customer_info['customer_national_id']; ?>
                        </p>
                    <?php endif; ?>
                </div>
                <?php endif; ?>
            </div>

            <table>
                <thead>
                    <tr>
                        <th><?php esc_html_e('ردیف','woodmartplus'); ?></th>
                        <th><?php esc_html_e('شرح کالا','woodmartplus'); ?></th>
                        <th><?php esc_html_e('قیمت واحد','woodmartplus'); ?></th>
                        <th><?php esc_html_e('تخفیف ','woodmartplus'); ?></th>
                        <th><?php esc_html_e('تعداد','woodmartplus'); ?></th>
                        <th><?php esc_html_e('جمع','woodmartplus'); ?></th>
                    </tr>
                </thead>
                <tbody>
                    <?php foreach ($order_info['order_items'] as $item) : ?>
                        <tr>
                            <td>۱</td>
                            <td><?php echo $item['name']; ?></td>
                            <td><?php echo wc_price(wplus_pre_factor::get_order_subtotal_item($order_info['order'],$item)); ?></td>
                            <td><?php echo wc_price(wplus_pre_factor::calculate_order_item_discount($order_info['order'],$item)); ?></td>
                            <td><?php echo $item->get_quantity(); ?></td>
                            <td><?php echo wc_price($item->get_subtotal()); ?></td>
                        </tr>
                    <?php endforeach; ?>
                    
                    <tr class="total-row">
                        <td colspan="5"><?php esc_html_e('جمع کل','woodmartplus'); ?></td>
                        <td><?php echo wc_price($order_info['order']->get_subtotal()); ?></td>
                    </tr>
                    <?php if($order_info['order']->get_total_tax() > 0): ?>
                        <tr>
                            <td colspan="5"><?php esc_html_e('مالیات','woodmartplus'); ?></td>
                            <td><?php echo wc_price($order_info['order']->get_total_tax()); ?></td>
                        </tr>
                    <?php endif; ?>
                    <tr class="total-row">
                        <td colspan="5"><?php esc_html_e('مبلغ قابل پرداخت','woodmartplus'); ?></td>
                        <td><?php echo wc_price($order_info['order']->get_total()); ?></td>
                    </tr>
                </tbody>
            </table>

            <div class="footer">
            <?php if($seller_info['pre_factor_additional_info']['output']): ?>
                <div class="store-info">
                        <p>
                            <svg class="icon"><use xlink:href="#icon-info"/></svg>
                            <strong><?php esc_html_e('شرایط و توضیحات:','woodmartplus'); ?></strong>
                        </p>
                        <?php foreach($seller_info['pre_factor_additional_info']['output'] as $info): ?>
                            <p><?php echo $info['title']; ?></p>
                        <?php endforeach; ?>
                </div>
                <?php endif; ?>

                <?php if($seller_info['signature_pre_factor']['output']): ?>
                    <div class="signature-area">
                            <img src="<?php echo $seller_info['signature_pre_factor']['output']; ?>" alt="<?php esc_html_e('مهر و امضا فروشگاه','woodmartplus'); ?>" class="signature">
                        <svg><use xlink:href="#icon-stamp"/></svg>
                        <p><?php esc_html_e('محل مهر و امضای فروشگاه','woodmartplus'); ?></p>
                    </div>
                <?php endif; ?>

            </div>
        </div>
    <?php endif; ?>
        
</body>
</html>
