<?php

if (!defined('ABSPATH')) {
    exit; 
}
?>

<div id="otp-confirmation-popup" class="otp-popup-overlay" style="display: none;">
    <div class="otp-popup-container">
        <div class="otp-popup-header">
            <h3><?php _e('تأیید شماره موبایل', 'woodmartplus'); ?></h3>
            <button class="otp-close-btn" type="button">&times;</button>
        </div>
        
        <div class="otp-popup-body">
            <!-- Loading State -->
            <div class="otp-loading" id="otp-loading">
                <div class="otp-spinner"></div>
                <p><?php _e('در حال ارسال کد تأیید...', 'woodmartplus'); ?></p>
            </div>
            
            <!-- OTP Form -->
            <div class="otp-form" id="otp-form" style="display: none;">
                <div class="otp-icon">
                    <svg xmlns="http://www.w3.org/2000/svg" width="64" height="64" fill="none" viewBox="0 0 24 24">
                        <rect x="7" y="2" width="10" height="20" rx="2" ry="2" stroke="var(--wd-primary-color,#4CAF50)" stroke-width="2"/>
                        <circle cx="12" cy="18" r="1.5" fill="var(--wd-primary-color,#4CAF50)"/>
                        <path d="M9 8h6v3H9z" fill="var(--wd-primary-color,#4CAF50)"/>
                    </svg>
                </div>
                
                <p class="otp-message">
                    <?php _e('کد تأیید به شماره', 'woodmartplus'); ?> 
                    <span id="phone-number-display"></span> 
                    <?php _e('ارسال شد', 'woodmartplus'); ?>
                </p>
                
                <form id="otp-verification-form">
                    <div class="otp-input-container">
                        <input type="text" id="otp-code" class="otp-input" maxlength="<?php echo esc_html($number_digits); ?>" placeholder="000000" autocomplete="off">
                    </div>
                    
                    <div class="otp-timer">
                        <span id="timer-text"><?php _e('ارسال مجدد کد در', 'woodmartplus'); ?></span>
                        <span id="countdown_confirm"></span>
                        <span><?php _e('ثانیه', 'woodmartplus'); ?></span>
                    </div>
                    
                    <button type="submit" class="otp-submit-btn" id="otp-submit-btn" disabled>
                        <?php _e('تأیید و پرداخت', 'woodmartplus'); ?>
                    </button>
                    
                    <button type="button" class="otp-resend-btn" id="otp-resend-btn" style="display: none;">
                        <?php _e('ارسال مجدد کد', 'woodmartplus'); ?>
                    </button>
                </form>
            </div>
            
            <!-- Error Message -->
            <div class="otp-error" id="otp-error" style="display: none;">
                <div class="error-icon">⚠️</div>
                <p id="error-message"></p>
            </div>
            
            <!-- Success Message -->
            <div class="otp-success" id="otp-success" style="display: none;">
                <div class="success-icon">✅</div>
                <p><?php _e('کد تأیید صحیح است. در حال پردازش پرداخت...', 'woodmartplus'); ?></p>
            </div>
        </div>
    </div>
</div>

