<style>
    body {
    font-family: 'IRANSans', Tahoma, sans-serif;
    background: #f5f5f5;
    padding: 40px;
    }

    .cashback-widget {
    background: #e3f2fd;
    border: 1px solid #90caf9;
    padding: 20px 24px;
    border-radius: 14px;
    max-width: 520px;
    margin: 0 auto;
    box-shadow: 0 0 12px rgba(0, 0, 0, 0.04);
    }

    .cashback-widget h3 {
    font-size: 18px;
    color: #0277bd;
    margin-bottom: 10px;
    display: flex;
    align-items: center;
    gap: 8px;
    }

    .cashback-widget h3::before {
    content: "💰";
    font-size: 20px;
    }

    .cashback-widget p {
    font-size: 14px;
    color: #37474f;
    margin-bottom: 15px;
    line-height: 1.8;
    }

    .progress-bar {
    width: 100%;
    background-color: #bbdefb;
    border-radius: 10px;
    overflow: hidden;
    height: 18px;
    margin-bottom: 10px;
    }

    .progress-bar-fill {
    height: 100%;
    background: linear-gradient(to left, #42a5f5, #1e88e5);
    width: 0%;
    transition: width 0.4s ease;
    }

    .cashback-status {
    font-size: 14px;
    color: #0d47a1;
    text-align: center;
    margin-top: 10px;
    }

    .highlight {
    color: #1565c0;
    font-weight: bold;
    font-size: 15px;
    background: #e1f5fe;
    padding: 2px 6px;
    border-radius: 8px;
    display: inline-block;
    }
</style>

<div class="cashback-widget">
    <h3><?php esc_html_e('فرصت بازگشت وجه به کیف پول شما!','woodmartplus'); ?></h3>
    <p>
    <?php echo __('با تکمیل خرید، مبلغی به‌عنوان <strong>بازگشت وجه</strong> به <strong>کیف پول حساب کاربری شما</strong> اضافه می‌شود.', 'woodmartplus'); ?>
    <br />
    <?php esc_html_e('فقط کافی‌ست کمی بیشتر خرید کنید تا پاداش بیشتری بگیرید ','woodmartplus'); ?>
    </p>

    <div class="progress-bar">
        <div class="progress-bar-fill" id="cashbackProgress" style="width: 0%;"></div>
    </div>

    <?php
        $remaining_formatted = number_format_i18n($remaining) . ' ' . get_woocommerce_currency_symbol();
        $reward_formatted = number_format_i18n($cashbackReward) . ' ' . get_woocommerce_currency_symbol();
        $message = sprintf(
            __('فقط %s دیگر خرید کنید تا مبلغ %s به %sکیف پول حساب‌تان%s بازگردد 💳', 'woodmartplus'),
            '<span class="highlight">' . $remaining_formatted . '</span>',
            '<span class="highlight">' . $reward_formatted . '</span>',
            '<strong>',
            '</strong>'
        );
    ?>
    <div class="cashback-status" id="cashbackStatus">
    </div>

    <div id="cashbackWidgetData"
        data-current-purchase="<?php echo esc_attr($currentPurchase); ?>"
        data-cashback-goal="<?php echo esc_attr($cashbackGoal); ?>"
        data-cashback-reward="<?php echo esc_attr($cashbackReward); ?>"
        data-remaining="<?php echo esc_attr($remaining); ?>"
        data-message="<?php echo esc_attr($message); ?>">
    </div>
</div>

<script>

    function updateCashbackWidget() {
        
        const widgetData = document.getElementById("cashbackWidgetData");

        if (!widgetData) {
            return; 
        }

        const currentPurchase = parseFloat(widgetData.dataset.currentPurchase);
        const cashbackGoal = parseFloat(widgetData.dataset.cashbackGoal);
        const cashbackReward = parseFloat(widgetData.dataset.cashbackReward);
        const remaining = parseFloat(widgetData.dataset.remaining);

        const percent = Math.min(100, (currentPurchase / cashbackGoal) * 100);

        document.getElementById("cashbackProgress").style.width = percent + "%";
        const statusEl = document.getElementById("cashbackStatus");

        if (remaining > 0) {
            statusEl.innerHTML = widgetData.dataset.message;
        }
    }
    updateCashbackWidget();

    jQuery(document.body).on('updated_wc_div wc_fragments_refreshed', function() {
        updateCashbackWidget();
    });

</script>