<div class="page-header">
    <h1 class="page-title"><?php esc_html_e('مدیریت کمپین های SMS','woodmartplus'); ?></h1>
    <div class="btns">
        <button class="add-campaign-btn" id="addCampaignBtn">
            <?php esc_html_e('اضافه کردن کمپین SMS','woodmartplus'); ?>
        </button>
        <a class="add-campaign-btn remove-all-campaign" style="background-color: #d63638;" href="<?php echo esc_url( add_query_arg(['action' => 'delete_all_campaigns']) ); ?>" onclick="return confirm('<?php esc_html_e('آیا از حذف کمپین ها اطمینان دارید؟','woodmartplus'); ?>');">
            <?php esc_html_e('حذف کمپین ها','woodmartplus'); ?>
        </a>
    </div>
</div>

<?php echo Campaign_Notice::getInstance()->show_notice(); ?>

<div class="campaigns-container" id="campaignsContainer">
    <?php  foreach( $campaigns as $key => $campaign ): ?>
        <div class="campaign-card <?php echo esc_html( $campaign['status_campaing']['class'] ); ?>" data-campaign-id="<?php echo esc_attr( $key ); ?>">
            <div class="campaign-status status-<?php echo esc_html( $campaign['status_campaing']['class'] ); ?>"><?php echo esc_html( $campaign['status_campaing']['output'] ); ?></div>
            <div class="campaign-title"><?php echo esc_html( $campaign['campaignName'] ); ?></div>
            <div class="campaign-description">
                <span><?php esc_html_e('پترن پیامکی :','woodmartplus'); ?></span>
                <span><?php echo esc_html($campaign['campaignPattern']); ?></span>
            </div>
            <div class="campaign-meta">
                <?php 
                    printf(__('ایجاد شده در : %s','woodmartplus'),wplus_helper::date_to_garegorian( strtotime($campaign['campaingCreatedAt']),'Y/m/d' ));
                ?>
            </div>
        </div>
    <?php endforeach; ?>
</div>

<div class="popup-overlay" id="campaignPopup">
    <div class="popup-content">
        <div class="popup-header">
            <h3 class="popup-title"><?php esc_html_e('ایجاد کمپین SMS جدید','woodmartplus'); ?></h3>
            <button class="close-btn" id="closePopup">&times;</button>
        </div>
        
        <div class="popup-tabs">
            <button class="popup-tab-button active" data-tab="campaign-settings">
                <?php esc_html_e('تنظیمات کمپین','woodmartplus'); ?>
            </button>
            <button class="popup-tab-button" data-tab="coupon-settings">
                <?php esc_html_e('کد تخفیف','woodmartplus'); ?>
            </button>
        </div>
        
        <div class="popup-body">
            <form id="campaignForm" method="POST">
                <!-- تب تنظیمات کمپین -->
                <div class="popup-tab-content active" id="campaign-settings">
                    <div class="form-group">
                        <label for="campaignName"><?php esc_html_e('نام کمپین:','woodmartplus'); ?></label>
                        <input type="text" id="campaignName" name="campaignName" placeholder="<?php esc_html_e('مثال: کمپین تشویقی مشتریان وفادار','woodmartplus'); ?>" required>
                    </div>
                    

                        <div class="suggestion-inputs gray-inp" style="background: #f3f3f3; padding: 10px 6px;">
                             <h3>
                                <?php esc_html_e('تنظیمات پیامک','woodmartplus'); ?>
                            </h3>
                            <div class="shortcode_sms_campaign">
                                <h4><?php esc_html_e('از شورتکد های زیر میتوانید استفاده کنید','woodmartplus'); ?></h4>
                                
                                <div class="shortcodes-main">
                                    <p>
                                        اطلاعات مشتری: <br>
                                        [user_fullname] = نام و نام خانوادگی<br>
                                        [user_phone] = شماره موبایل<br>
                                        [user_email] = ایمیل <br>
                                        [coupon_code] = کدتخفیف <br>
                                        [coupon_expire_h] = انقضای تخفیف (نحوه نمایش به ساعت : مثال 72 ساعت) <br>
                                        [coupon_expire_d] = انقضای تخفیف (نحوه نمایش به روز : مثال 2 روز) <br>
                                        [coupon_expire_date] = انقضای تخفیف (نحوه نمایش به تاریخ : مثال 1404/04/10) <br>
                                    </p>
                                </div>
                            </div>

                            <div class="suggestion-inputs gray-inp" style="margin-bottom:.8rem;">
                                <input type="text" name="campaignPattern" placeholder="<?php esc_html_e('پترن پیامک را وارد کنید', 'woodmartplus'); ?>" value="">
                            </div>
                            
                            <!-- Variables Repeater -->
                            <div class="repeater-container">
                                <div data-repeater-list="campaignVariables">
                                        
                                        <div data-repeater-item>
                                            <div class="send-time">
                                                <div>
                                                    <input type="text" name="variable" placeholder="<?php esc_html_e('متغیر','woodmartplus') ?>">
                                                    <input type="text" name="shortcode" placeholder="<?php esc_html_e('شورتکد','woodmartplus') ?>">
                                                    <a data-repeater-delete class="delete-btn">
                                                        <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                                                    </a>
                                                </div>
                                            </div>
                                        </div>
                                </div>
                                <div class="add-time" style="margin: 10px 0px;">
                                    <button data-repeater-create type="button" class="btn btn-primary" >
                                        <p style="margin:0px"><?php esc_html_e('افزودن متغیر جدید','woodmartplus') ?></p>
                                    </button>
                                </div>
                            </div>
                        </div>
                    
                    <div class="form-group">
                        <label><?php esc_html_e('شرط ارسال:','woodmartplus'); ?></label>
                        <div class="condition-row">
                            <div class="form-group">
                                <select id="conditionType" name="conditionType" required>
                                    <option value=""><?php esc_html_e('انتخاب شرط','woodmartplus'); ?></option>
                                    <option value="purchase_count"><?php esc_html_e('تعداد خرید','woodmartplus'); ?></option>
                                    <option value="total_spent"><?php esc_html_e('مجموع خرید','woodmartplus'); ?></option>
                                    <option value="last_purchase"><?php esc_html_e('آخرین خرید','woodmartplus'); ?></option>
                                    <option value="registration_date"><?php esc_html_e('تاریخ عضویت','woodmartplus'); ?></option>
                                    <option value="birthday"><?php esc_html_e('تاریخ تولد','woodmartplus'); ?></option>
                                </select>
                            </div>

                            <div class="form-group">
                                <select id="conditionOperator" name="conditionOperator" required>
                                    <option value=""><?php esc_html_e('عملگر','woodmartplus'); ?></option>
                                    <option value="greater_than"><?php esc_html_e('بیشتر از','woodmartplus'); ?></option>
                                    <option value="less_than"><?php esc_html_e('کمتر از','woodmartplus'); ?></option>
                                    <option value="equal"><?php esc_html_e('برابر با','woodmartplus') ?></option>
                                    <option value="month"><?php esc_html_e('ماه','woodmartplus'); ?></option>
                                </select>
                            </div>
                            <div class="form-group">
                                <input type="text" id="conditionValue" name="conditionValue" placeholder="<?php esc_html_e('مقدار','woodmartplus'); ?>" required>
                            </div>
                        </div>

                        <!-- اضافه کردن چک باکس برای آخرین خرید -->  
                        <div class="form-group" id="feedbackSmsContainer" style="display: none;">
                            <div class="checkbox-container">
                                <input type="checkbox" id="sendFeedbackSms" name="sendFeedbackSms" value="1">
                                <label for="sendFeedbackSms" class="checkbox-label">
                                    <?php esc_html_e('ارسال پیامک ثبت بازخورد؟','woodmartplus'); ?>
                                </label>
                            </div>
                            
                            <!-- توضیحات که با چک کردن چک باکس ظاهر می‌شود -->
                            <div class="feedback-sms-info" id="feedbackSmsInfo" style="display: none; background: #f9f9f9; padding: 15px; border-radius: 5px; margin-top: 10px; border-right: 4px solid #0073aa;">
                                <p style="margin: 0; color: #555; font-size: 14px; line-height: 1.5;">
                                    <?php esc_html_e('کاربر گرامی تنظیمات ثبت بازخورد را باید از تنظیمات پلاگین وودمارت پلاس انجام داده باشید و پیامک ارسال شده، طبق تنظیماتی که در قسمت ثبت بازخوردها انجام داده‌اید ارسال می‌شود.','woodmartplus'); ?>
                                    <a href="<?php echo admin_url('admin.php?page=woodmartplus-settings'); ?>"><?php esc_html_e('ورود به تنظیمات','woodmartplus'); ?></a>
                                </p>
                            </div>
                        </div>

                        <div class="condition-info" id="conditionExample">
                        </div>
                        <input type="hidden" name="conditionExample" id="conditionExampleInput">
                    </div>
                    
                    <div class="form-group">
                        <label for="scheduleType"><?php esc_html_e('زمان ارسال:','woodmartplus'); ?></label>
                        <select id="scheduleType" name="scheduleType" required>
                            <option value="immediate"><?php esc_html_e('فوری','woodmartplus'); ?></option>
                            <option value="scheduled"><?php esc_html_e('زمان‌بندی شده','woodmartplus'); ?></option>
                            <option value="dynamic"><?php esc_html_e('پویا','woodmartplus'); ?></option>
                            <option value="birthday_day" style="display: none;"><?php esc_html_e('در روز تولد','woodmartplus'); ?></option>
                        </select>
                    </div>
                    
                    <div class="form-group" id="scheduleDateTime" style="display: none;">
                        <label for="sendDateTime"><?php esc_html_e('تاریخ شروع ارسال','woodmartplus'); ?></label>
                        <input type="text" id="sendDateTime" name="sendDateTime">
                    </div>

                    <div class="form-group" id="scheduleTime" style="display: none;" >
                        <label for="sendTime"><?php esc_html_e('برای هر کاربر بعد از چند روز پیامک ارسال شود؟','woodmartplus'); ?></label>
                        <input type="number" id="sendTime" name="sendTime">
                    </div>
                </div>

                <!-- تب کد تخفیف -->
                <div class="popup-tab-content" id="coupon-settings">
                    <div class="coupon-settings-container">
                        <div class="form-group">
                            <label for="couponCode"><?php esc_html_e('کد تخفیف:','woodmartplus'); ?></label>
                            <input type="text" id="couponCode" name="couponCode" placeholder="<?php esc_html_e('کد تخفیف را وارد کنید','woodmartplus'); ?>">
                            <div class="coupon-help-text">
                                <p><?php esc_html_e('برای ایجاد کد تخفیف از','woodmartplus'); ?> 
                                   <a href="<?php echo admin_url('edit.php?post_type=shop_coupon'); ?>" target="_blank" class="coupon-link">
                                       <?php esc_html_e('اینجا','woodmartplus'); ?>
                                   </a> 
                                   <?php esc_html_e('اقدام کنید و پس از ایجاد، کد تخفیف را در این قسمت قرار دهید.','woodmartplus'); ?>
                                </p>
                            </div>
                        </div>
                        
                        <div class="form-group">
                            <div class="checkbox-container">
                                <input type="checkbox" id="couponExclusive" name="couponExclusive" value="1">
                                <label for="couponExclusive" class="checkbox-label">
                                    <?php esc_html_e('آیا کد تخفیف فقط برای افراد داخل کمپین استفاده شود؟','woodmartplus'); ?>
                                </label>
                            </div>
                            <div class="checkbox-help-text">
                                <small><?php esc_html_e('با فعال کردن این گزینه، کد تخفیف فقط برای کاربرانی که در این کمپین قرار دارند قابل استفاده خواهد بود.','woodmartplus'); ?></small>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="popup-footer">
                    <button class="btn btn-secondary" id="cancelBtn"><?php esc_html_e('انصراف','woodmartplus') ?></button>
                    <button type="submit" class="btn btn-primary" id="saveCampaignBtn" name="create_campaign" value="create_campaign"><?php esc_html_e('ایجاد کمپین','woodmartplus'); ?></button>
                </div>

            </form>
        </div>
    </div>
</div>


<div class="popup-overlay" id="detailsPopup">
    <div class="popup-content details-popup-content">
        <div class="popup-header">
            <h3 class="popup-title" id="detailsTitle"><?php esc_html_e('جزئیات کمپین','woodmartplus'); ?></h3>
            <button class="close-btn" id="closeDetailsPopup">&times;</button>
        </div>
        
        <div class="details-tabs">
            <button class="tab-button active" data-tab="overview"><?php esc_html_e('خلاصه','woodmartplus'); ?></button>
            <button class="tab-button" data-tab="users"><?php esc_html_e('کاربران','woodmartplus'); ?></button>
            <button class="tab-button" data-tab="logs"><?php esc_html_e('لاگ پیامک‌ها','woodmartplus'); ?></button>
        </div>
        
        <div class="popup-body detials-campaign">
          
        </div>
        
        <div class="popup-footer">
            <button class="btn btn-danger" id="deleteCampaignBtn"><?php esc_html_e('حذف کمپین','woodmartplus'); ?></button>
            <button class="btn btn-secondary" id="closeDetailsBtn"><?php esc_html_e('بستن','woodmartplus'); ?></button>
        </div>
    </div>
</div>
