(function($){


    var cities            = wcPlusCheckout.cities;
    wrapper_selectors = '.woocommerce-billing-fields,' +
        '.woocommerce-shipping-fields,' +
        '.woocommerce-address-fields';
        
        
        $(document).ready(function(){

            $( document.body ).on( 'change refresh', 'select#billing_state', function() {
                
                var $wrapper = $( this ).closest( wrapper_selectors );
        
                if ( ! $wrapper.length ) {
                    $wrapper = $( this ).closest('.solid_input').parent();
                }
                
                
                var country     = $( this ).val(),
                    $citybox     = $wrapper.find( '#billing_city, #shipping_city' ),
                    $parent       = $citybox.closest( '.solid_input' ),
                    input_name    = $citybox.attr( 'name' ),
                    input_id      = $citybox.attr('id'),
                    input_classes = $citybox.attr('data-input-classes'),
                    value         = $citybox.val(),
                    placeholder   = $citybox.attr( 'placeholder' ) || $citybox.attr( 'data-placeholder' ) || '',
                    $newcity;
                   
                if ( cities[ country ] ) {
                    if ( $.isEmptyObject( cities[ country ] ) ) {
                        $newcity = $( '<input type="hidden" />' )
                            .prop( 'id', input_id )
                            .prop( 'name', input_name )
                            .prop( 'placeholder', placeholder )
                            .addClass( 'hidden '  );
                        $parent.hide().find( '.select2-container' ).remove();
                        $citybox.replaceWith( $newcity );
                        $( document.body ).trigger( 'country_to_city_changed', [ country, $wrapper ] );
                    } else {
                        
                        var city = cities[country],
                            $defaultOption = $('<option value=""></option>').text(wcPlusCheckout.checkout_select_city);
        
                        if (!placeholder) {
                            placeholder = wcPlusCheckout.checkout_select_city;
                        }
        
                        $parent.show();
        
                        if ($citybox.is('input')) {
                            $newcity = $('<select></select>')
                                .prop('id', input_id)
                                .prop('name', input_name)
                                .data('placeholder', placeholder)
                                .addClass('state_select ' );
                            $citybox.replaceWith($newcity);
                            $citybox = $wrapper.find('#billing_city, #shipping_city');
                            
                        }
        
                        $citybox.empty().append($defaultOption);
                        $.each(city, function (index) {
                            var $option = $('<option></option>')
                                .prop('value', index)
                                .text(city[index]);
                            $citybox.append($option);
                        });
        
                        $citybox.val(value).trigger('change');
                        
                        $citybox.select2({
                            placeholder: placeholder,
                            allowClear: true,
                            width: '100%'
                        });
        
                        $( document.body ).trigger( 'country_to_city_changed', [country, $wrapper ] );
                    }
                } else {
                    
                    if ( $citybox.is( 'select, input[type="hidden"]' ) ) {
                        $newcity = $( '<input type="text" />' )
                            .prop( 'id', input_id )
                            .prop( 'name', input_name )
                            .prop('placeholder', placeholder)
                            .addClass( 'input-text  '  );
                        $parent.show().find( '.select2-container' ).remove();
                        $citybox.replaceWith( $newcity );
                        $( document.body ).trigger( 'country_to_city_changed', [country, $wrapper ] );
                    }
                }
        
                $( document.body ).trigger( 'country_to_city_changing', [country, $wrapper ] );
            });
        });
})( jQuery );