<?php $getDetial = woodplus_wc_api::get_app_setting('blog_home_layout'); 
$categories = get_categories([ 'hide_empty' => 1, ]);

?>
 
<div class="item p-18 br-bottom">
   <span class="title"><?php esc_html_e('فعال کردن','woodmartplus'); ?></span>
   <p class="des"><?php esc_html_e('فعال کردن وبلاگ اپلیکیشن','woodmartplus') ?></p>
   <div class="btn-select">
      <input type="checkbox" class="switch" name="<?php echo woodplus_wc_api::generate_option_app('[blog_home_layout][status]'); ?>"  <?php echo isset( $getDetial['status'] ) && !empty( $getDetial['status'] ) ? 'checked' : '' ?> >
   </div>
</div>

<div class="suggestion-inputs gray-inp" style="margin-bottom:.8rem;">
    <label><?php esc_html_e("عنوان", 'woodapp-api') ?></label>
    <input type="text" name="<?php echo woodplus_wc_api::generate_option_app('[blog_home_layout][title]') ?>" placeholder="" value="<?php echo isset( $getDetial['title'] ) && !empty( $getDetial['title'] ) ? esc_attr( $getDetial['title'] ) : '' ?>" class="hovered">
</div>

<div class="item p-18 br-bottom">
    <span class="title"><?php esc_html_e('تعداد نمایش پست','woodmartplus') ?></span>
    <p class="des"><?php esc_html_e('تعداد نمایش پست در اسلایدر حداکثر 10','woodmartplus'); ?></p>
    <div class="inp-rang p-top-18">
        <input type="range" class="rang" min="1" max="10" name="<?php echo woodplus_wc_api::generate_option_app('[blog_home_layout][perpage]'); ?>" value="<?php echo isset( $getDetial['perpage'] ) && !empty( $getDetial['perpage'] ) ? esc_html($getDetial['perpage']) : '4' ?>">
        <div class="br-radius-8 rang-number d-center">
            <span class="num">4</span><span class="text-num"><?php esc_html_e('تعداد','woodmartplus'); ?></span>
        </div>
    </div>
</div>

<div class="item p-18 br-bottom">
    <p><?php esc_html_e('دسته بندی وبلاگ', 'woodmartplus'); ?></p>
    <?php $selected = isset( $getDetial['category_id'] ) && !empty( $getDetial['category_id'] ) ? $getDetial['category_id'] : ''; ?>
    <select class="js-example-basic-multiple choose_type_show_app_slider" name="<?php echo woodplus_wc_api::generate_option_app('[blog_home_layout][category_id]'); ?>" dir="rtl">
        <option value="" ><?php esc_html_e('انتخاب دسته بندی','woodmartplus') ?></option>
        <?php foreach ($categories as  $value):  ?>
            <option value="<?php echo esc_attr($value->term_id) ?>" <?php echo  $value->term_id == $selected  ? 'selected' : '' ?> ><?php echo esc_html($value->name); ?></option>
        <?php endforeach; ?>
    </select>
</div>

<?php $blog_icon = isset( $getDetial['icon'] ) && !empty( $getDetial['icon'] ) ? $getDetial['icon'] : ''; ?>
<div class="item p-18">
   <span class="title"><?php esc_html_e('ایکون وبلاگ', 'woocommerce-plus'); ?></span>
   <p class="des"><?php esc_html_e('این آیکون در کنار عنوان نمایش داده میشود', 'woocommerce-plus'); ?></p>
   <div class="logo_login_register <?php echo $blog_icon ? 'upload-loding' : ''  ?>">
      <?php if ($blog_icon): ?>
         <?php
         $img_src = wp_get_attachment_image_src($blog_icon);
         ?>
         <div class="upload-loding-img upload_image ">
            <img src="<?php echo isset($img_src[0]) ? $img_src[0] : '' ?>" class="img-responsive" alt="logo-factor">
         </div>
         <div class="upload-loding-btns">
            <span class="blue-btn upload-btn upload-image-button"><?php esc_html_e('ویرایش', 'woocommerce-plus'); ?></span>
            <span class="delete-btn remove-image-button">
               <img class="img-responisve" src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="trash">
            </span>
            <input type="hidden" name="<?php echo woodplus_wc_api::generate_option_app('[blog_home_layout][icon]'); ?>" class="upload_image_id" value="<?php echo $blog_icon ?>" />
         </div>
      <?php else: ?>

         <div class=" upload_image">
         </div>
         <div class="upload-loding-btns">
            <span class="blue-btn upload-btn upload-image-button"><?php esc_html_e('آپلود', 'woocommerce-plus'); ?></span>
            <span class="delete-btn remove-image-button" style="display: none;">
               <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="trash">
            </span>
            <input type="hidden" name="<?php echo woodplus_wc_api::generate_option_app('[blog_home_layout][icon]'); ?>" class="upload_image_id" value="" />
         </div>
      <?php endif; ?>
   </div>
</div>