
<?php
$static_page = woodplus_wc_api::get_app_setting('static_page');
$about_us = (isset($static_page['about_us'])) ? $static_page['about_us'] : '';
$terms_of_use = (isset($static_page['terms_of_use'])) ? $static_page['terms_of_use'] : '';
$privacy_policy = (isset($static_page['privacy_policy'])) ? $static_page['privacy_policy'] : '';
?>
<div class="item p-18 br-bottom">
    <span class="title"><?php esc_html_e('درباره ما', 'woodmartplus') ?></span>
    <div>
        <select class="js-example-basic-multiple" name="<?php echo woodplus_wc_api::generate_option_app('[static_page][about_us]'); ?>">
            <option value=""><?php esc_html_e('انتخاب برگه', 'woodapp-api') ?></option>
            <?php
                $pages = get_pages();
                if (!empty($pages)):
                    foreach ($pages as $page) {
                    $sel = '';

                    if ($about_us == $page->ID) {
                        $sel = 'selected="selected"';
                    }
                    $option = '<option value="' . $page->ID . '" ' . $sel . '>';
                    $option .= $page->post_title;
                    $option .= '</option>';
                    echo $option;
                    }
                endif;
            ?>
        </select>
    </div>
</div>
<div class="item p-18 br-bottom">
    <span class="title"><?php esc_html_e('قوانین و مقررات', 'woodmartplus') ?></span>
    <div>
        <select class="js-example-basic-multiple" name="<?php echo woodplus_wc_api::generate_option_app('[static_page][terms_of_use]'); ?>">
            <option value=""><?php esc_html_e('انتخاب برگه', 'woodapp-api') ?></option>
            <?php
            $pages = get_pages();
            if (!empty($pages)):
                foreach ($pages as $page) {
                $sel = '';

                if ($terms_of_use == $page->ID) {
                    $sel = 'selected="selected"';
                }
                $option = '<option value="' . $page->ID . '" ' . $sel . '>';
                $option .= $page->post_title;
                $option .= '</option>';
                echo $option;
                }
            endif;
            ?>
        </select>
    </div>
</div>
<div class="item p-18 br-bottom">
    <span class="title"><?php esc_html_e('سیاست حفظ حریم خصوصی', 'woodmartplus') ?></span>
    <div>
        <select class="js-example-basic-multiple" name="<?php echo woodplus_wc_api::generate_option_app('[static_page][privacy_policy]'); ?>">
            <option value=""><?php esc_html_e('انتخاب برگه', 'woodapp-api') ?></option>
            <?php
                $pages = get_pages();
                if (!empty($pages)):
                    foreach ($pages as $page) {
                    $sel = '';

                    if ($privacy_policy == $page->ID) {
                        $sel = 'selected="selected"';
                    }
                    $option = '<option value="' . $page->ID . '" ' . $sel . '>';
                    $option .= $page->post_title;
                    $option .= '</option>';
                    echo $option;
                    }
                endif;
            ?>
        </select>
    </div>
</div>

<?php $info_page = woodplus_wc_api::get_app_setting('info_pages');  ?>
<div class="suggestion-content app_pages">
    <div class="suggestion-inputs gray-inp">
       
        <!-- Variables Repeater -->
        <div class="repeater-container">
            <div data-repeater-list="<?php echo woodplus_wc_api::generate_option_app('[info_pages]'); ?>">
                <?php if (isset($info_page) && !empty($info_page)) : ?>
                    <?php foreach ($info_page as $key => $value) : ?>
                        <div data-repeater-item>
                            <label><?php esc_html_e('افزودن صفحات اطلاعاتی', 'woodapp-api') ?></label>
                            <div class="send-time">
                                <div>
                                    <select class="js-example-basic-multiple" name="info_pages_page_id">
                                        <option value=""><?php esc_html_e('انتخاب برگه', 'woodapp-api') ?></option>
                                        <?php
                                        $pages = get_pages();
                                        if (!empty($pages)):
                                        foreach ($pages as $page) {
                                            $sel = '';

                                            if ($value['info_pages_page_id'] == $page->ID) {
                                                $sel = 'selected="selected"';
                                            }
                                            $option = '<option value="' . $page->ID . '" ' . $sel . '>';
                                            $option .= $page->post_title;
                                            $option .= '</option>';
                                            echo $option;
                                        }
                                        endif;
                                        ?>
                                    </select>
                                    <a data-repeater-delete class="delete-btn">
                                        <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                                    </a>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                <?php else : ?>
                    <div data-repeater-item>
                         <label><?php esc_html_e('افزودن صفحات اطلاعاتی', 'woodapp-api') ?></label>
                                 <select class="woodapp-wc-api-form-control woodapp-wc-api_pages" name="info_pages_page_id">
                                    <option value=""><?php esc_html_e('انتخاب برگه', 'woodapp-api') ?></option>
                                    <?php
                                    $pages = get_pages();
                                    if (!empty($pages)):
                                       foreach ($pages as $page) {
                                          $sel = '';

                                          if (isset( $val['info_pages_page_id']) && $val['info_pages_page_id'] == $page->ID) {
                                             $sel = 'selected="selected"';
                                          }
                                          $option = '<option value="' . $page->ID . '" ' . $sel . '>';
                                          $option .= $page->post_title;
                                          $option .= '</option>';
                                          echo $option;
                                       }
                                    endif;
                                    ?>
                                 </select>
                                 <a data-repeater-delete class="delete-btn">
                                    <img src="<?php echo WOODPLUS_ASSET ?>admin/img/dashboard/trash.svg" alt="">
                                </a>
                    </div>
                <?php endif; ?>
            </div>
            <div class="add-time">
                <button data-repeater-create type="button">
                    <!-- <img src="path/to/plus.svg" alt="add"> -->
                    <p><?php esc_html_e('افزودن برگه', 'woodmartplus'); ?></p>
                </button>
            </div>
        </div>
    </div>
</div>