<?php

class helper_cityProvience
{

    public $cites;

    public static function get_all_city()
    {


        $all_city = file_get_contents(DIR_PATH . 'inc/vendor/cities/cities.json');

        $city_decoded = json_decode($all_city, 'true');

        return $city_decoded;
    }

    public static function get_all_provinc()
    {

        $all_provinc = file_get_contents(DIR_PATH . 'inc/vendor/cities/provinces.json');

        $city_provinc = json_decode($all_provinc, 'true');

        return $city_provinc;
    }

    public static function get_city_by_id($id)
    {
        $all_city = self::get_all_city();


        $filtered_city = array_filter($all_city, function ($city) use ($id) {

            return $city['id'] === $id;
        });
        return $filtered_city;
    }

    public static function get_city_by_slug($slug)
    {
        $all_city = self::get_all_city();


        $filtered_city = array_filter($all_city, function ($city) use ($slug) {

            return $city['province_id'] === $slug;
        });

        return $filtered_city;
    }

    public static function woocommerce_province_slug()
    {
        $province_slugs = [
            'KHZ',
            'THR',
            'ILM',
            'BHR',
            'ADL',
            'ESF',
            'YZD',
            'KRH',
            'KRN',
            'HDN',
            'GZN',
            'ZJN',
            'LRS',
            'ABZ',
            'EAZ',
            'WAZ',
            'CHB',
            'SKH',
            'RKH',
            'NKH',
            'SMN',
            'FRS',
            'QHM',
            'KRD',
            'KBD',
            'GLS',
            'GIL',
            'MZN',
            'MKZ',
            'HRZ',
            'SBN',
        ];
        return $province_slugs;
    }

    public static function get_cities()
    {

        $province_slugs = self::woocommerce_province_slug();

        foreach ($province_slugs as $slug) {
            $all_city = self::get_city_by_slug($slug);
            foreach ($all_city as $city) {
                $cites[$slug][$city['name']] = $city['name'];
            }
        }

        return $cites;
    }

    public static function get_state_by_slug($slug, $just_name = false)
    {
        $all_province = helper_cityProvience::get_all_provinc();

        $filtered_city = array_filter($all_province, function ($province) use ($slug) {

            return $province['provinceSlug'] === $slug;
        });

        if ($just_name) {
            foreach ($filtered_city as $state) {
                return $state['provinceName'];
            }
        }
        return $filtered_city;
    }
}
