<div class="translation-container" dir="rtl">
    <form class="translation-form" method="POST">
        <div class="input-group">
            <label for="original-word"><?php esc_html_e('کلمه اصلی','woodmartplus'); ?> <span class="required">*</span></label>
            <input type="text"
                id="original-word"
                name="needtranslate"
                placeholder="<?php esc_html_e('کلمه اصلی را وارد کنید','woodmartplus'); ?>"
                required>
            <span class="input-hint"><?php esc_html_e('مثال: add to cart','woodmartplus'); ?></span>
        </div>

        <div class="input-group">
            <label for="translated-word"><?php esc_html_e('ترجمه','woodmartplus'); ?> <span class="required">*</span></label>
            <input type="text"
                id="translated-word"
                name="translatetoo"
                placeholder="<?php esc_html_e('ترجمه را وارد کنید','woodmartplus'); ?>"
                required>
            <span class="input-hint"><?php esc_html_e('مثال: افزودن به سبد خرید','woodmartplus'); ?></span>
        </div>

        <button type="submit" name="translate" value="go" class="submit-btn">
            <span class="btn-icon">✓</span>
            <?php esc_html_e('ذخیره ترجمه','woodmartplus'); ?>
        </button>
    </form>

    <div class="translations-list">
        <h3><?php esc_html_e('ترجمه‌های ذخیره شده','woodmartplus'); ?></h3>
        <ul>
            <?php foreach ($this->get_option() as $key => $value): ?>
                <?php foreach($value as $translate_from => $translate_to): ?>
                <li class="translation-item">
                    <div class="translation-text">
                        <span class="original"><?php echo esc_html($translate_from); ?></span>
                        <span class="translated"><?php echo esc_html($translate_to); ?></span>
                    </div>
                    <button class="delete-btn delete-translate" data-delete_translate="<?php echo esc_html($key); ?>"><?php esc_html_e('حذف','woodmartplus'); ?></button>
                </li>
                <?php endforeach; ?>
            <?php endforeach; ?>
            <?php wp_nonce_field('delete_translate', 'delete_translate_nonce'); ?>
        </ul>
    </div>
</div>