<?php

if (!defined('ABSPATH')) exit;

class admin_user_wallet_customers_list extends WP_List_Table
{
    private $per_page = 20;

    public function __construct()
    {

        $this->items = $this->get_query();

        $this->set_pagination_args([
            'total_items' => count($this->get_query(true)),
            'per_page'    => $this->per_page,
            'total_pages' => ceil(count($this->get_query(true)) / $this->per_page),
        ]);

        parent::__construct([
            'singular' => 'user',
            'plural'   => 'users',
            'ajax'     => false,
        ]);

        $what_export = isset($_POST['export_csv']) && !empty($_POST['export_csv']) ? sanitize_text_field($_POST['export_csv']) : false; //loyal;

        if ($what_export && 'all' === $what_export) {
            // $this->export_csv();
        }
    }

    private function export_csv()
    {
        unset($_POST['export_csv']);

        if (ob_get_length()) {
            ob_end_clean();
        }

        $data = [];

        if (isset($_POST['export_fields'])) {

            $temp = [];
            $need = [];

            if (in_array('first_name', $_POST['export_fields'])) {
                $temp[] = 'نام';
                $need[] = 'first_name';
            }

            if (in_array('last_name', $_POST['export_fields'])) {
                $temp[] = 'نام خانوادگی';
                $need[] = 'last_name';
            }
            if (in_array('email', $_POST['export_fields'])) {
                $temp[] = 'ایمیل';
                $need[] = 'email';
            }
            if (in_array('phone', $_POST['export_fields'])) {
                $temp[] = 'موبایل';
                $need[] = 'phone';
            }

            if (!empty($temp) && !empty($need)) {

                $data[] = $temp;
                $datas = array_merge($data, $this->query_for_export($need));
            }
        }

        header('Content-Type: text/csv; charset=utf-8');

        header('Content-Disposition: attachment; filename="users_export.csv"');

        $output = fopen('php://output', 'w');

        fwrite($output, "\xEF\xBB\xBF");

        foreach ($datas as $row) {

            fputcsv($output, $row);
        }

        fclose($output);

        exit;
    }

    private function query_for_export($array)
    {

      
        $args = [
            'role__in' => array('customer'),
            'number' => -1,
            'meta_query' => [
                [
                    'key' => PHONEMETA,
                    'compare' => 'EXISTS'
                ]
            ]
        ];

        $users = get_users($args);
        $datas = [];
        if ($users) {
            $i = 0;
            foreach ($users as $user) {

                if (in_array('first_name', $array)) {
                    $datas[$i]['first_name'] = get_user_meta($user->ID, 'first_name', true);
                }
                if (in_array('last_name', $array)) {
                    $datas[$i]['last_name'] = get_user_meta($user->ID, 'last_name', true);
                }
                if (in_array('email', $array)) {
                    $datas[$i]['email'] = $user->user_email;
                }
                if (in_array('phone', $array)) {
                    $datas[$i]['phone'] = get_user_meta($user->ID, PHONEMETA, true);
                }

                $i++;
            }
        }

        return $datas;
    }

    private function get_query($total = false)
    {
  
        $current_page = $this->get_pagenum();

        $offset = ($current_page - 1) * $this->per_page;

        $args = [
            // 'role__in' => array('customer'),
            'number' => $this->per_page,
            'offset' => $offset,
            'paged' => $this->get_pagenum(),
            'search_columns' => ['user_login'],
            'meta_query' => [
                [
                    'key' => 'user_wc_wallet',
                    'value'   => 0,
                    'compare' => '>',
                    'type' => 'NUMERIC'
                ]
            ]
        ];

        if ($total) {
            $args['number'] = -1;
            unset($args['offset']);
            unset($args['paged']);
        }

        if( isset( $_POST['s'] ) )
        {
            $args['search'] = sanitize_text_field( $_POST['s'] );
        }

        $users = get_users($args);
        
        $datas = [];
        if ($users) {
            $i = 0;
            foreach ($users as $user) {
                
                $datas[$i]['user_login'] = $user->user_login;
                $datas[$i]['first_name'] = get_user_meta($user->ID, 'first_name', true);
                $datas[$i]['last_name'] = get_user_meta($user->ID, 'last_name', true);
                $datas[$i]['phone'] = get_user_meta($user->ID, PHONEMETA, true);
                $datas[$i]['wallet'] = wc_price(get_user_meta($user->ID, 'user_wc_wallet', true));
                $i++;
            }
        }
        
        
        return $datas;
    }

    public function column_default($item, $column_name)
    {
        return $item[$column_name] ?? '';
    }

    public function get_columns()
    {
        return [
            // 'cb'              => '<input type="checkbox" />',
            'user_login'              => 'نام کاربری',
            'first_name'              => 'نام',
            'last_name'      => 'نام خانوادگی',
            'phone' => 'شماره همراه',
            'wallet'      => 'موجودی کیف پول',
        ];
    }

    public function prepare_items()
    {
        $this->_column_headers = [$this->get_columns(), [], []];
        $this->items           = $this->items;
    }

    private function active_tab()
    {
        return isset($_GET['who_customer']) && 'admin_user_wallet' === $_GET['who_customer'];
    }


    public function load_template()
    {

?>  
 
        <div class="wrap">
            <h2><?php esc_html_e('کیف پول کاربران', 'woodmartplus'); ?></h2>
            
            <div class="wallet-charge-section" style="margin: 20px 0;">
                <button type="button" id="charge-wallet-btn" class="button button-primary">
                    <span class="dashicons dashicons-money-alt" style="vertical-align: middle; margin-left: 5px;"></span>
                    <?php esc_html_e('شارژ کیف پول','woodmartplus') ?>
                </button>
            </div>
            <?php $this->show_notice(); ?>
            <form method="post">
                <div class="nav-tab-wrapper">
                    <a href="<?php echo admin_url('admin.php?page=customer_club_tab') ?>" class="nav-tab"><?php esc_html_e('همه مشتریان', 'woodmartplus'); ?></a>
                    <a href="<?php echo add_query_arg([
                                    'who_customer' => 'loyal'
                                ]); ?>" class="nav-tab"><?php esc_html_e('مشتریان وفادار', 'woodmartplus'); ?></a>
                    <a href="<?php echo add_query_arg([
                                    'who_customer' => 'leave_cart'
                    ]); ?>" class="nav-tab"><?php esc_html_e('سبد خریدرها شده', 'woodmartplus') ?></a>

                    <a href="<?php echo add_query_arg([
                                    'who_customer' => 'admin_user_wallet'
                    ]); ?>" class="nav-tab <?php echo $this->active_tab() ? 'nav-tab-active' : '' ?>"><?php esc_html_e('کیف پول کاربران', 'woodmartplus') ?></a>
                    <a href="<?php echo add_query_arg([
                                    'who_customer' => 'sms_campaign'
                    ]); ?>" class="nav-tab"><?php esc_html_e('کمپین ها', 'woodmartplus') ?></a>
                </div>
                <?php
                $this->prepare_items();
                $this->search_box('جستجو', 'wallet-search-input');
                $this->display();
                ?>
            </form>
        </div>

        <div id="wallet-charge-popup" class="wallet-popup-overlay" style="display: none;">
            <div class="wallet-popup-content">
                <div class="wallet-popup-header">
                    <h3><?php esc_html_e('شارژ کیف پول','woodmartplus'); ?></h3>
                    <button type="button" class="wallet-popup-close">&times;</button>
                </div>
                
                <div class="wallet-popup-body">
                    <form id="wallet-charge-form" method="POST">
                        <div class="wallet-form-group">
                            <label for="user-search"><?php esc_html_e('جستجوی کاربر:','woodmartplus'); ?></label>
                            <div class="user-search-container">
                                <input type="text" id="user-search" placeholder="نام کاربری، شماره موبایل یا ID کاربر" autocomplete="off">
                                <div id="user-search-results" class="search-results"></div>
                            </div>
                        </div>

                        <div id="selected-user-info" class="selected-user-info" style="display: none;">
                            <div class="user-info-card">
                                <h4><?php esc_html_e('اطلاعات کاربر انتخاب شده:','woodmartplus'); ?></h4>
                                <div class="user-details">
                                    <input type="hidden" id="wallet_user_id" name="wallet_user_id">
                                    <p><strong><?php esc_html_e('نام کاربری:','woodmartplus') ?></strong> <span id="selected-username"></span></p>
                                    <p><strong><?php esc_html_e('نام:','woodmartplus') ?></strong> <span id="selected-firstname"></span></p>
                                    <p><strong><?php esc_html_e('نام خانوادگی:','woodmartplus') ?></strong> <span id="selected-lastname"></span></p>
                                    <p><strong><?php esc_html_e('شماره موبایل:','woodmartplus'); ?></strong> <span id="selected-phone"></span></p>
                                </div>
                            </div>
                        </div>

                        <div class="wallet-form-group">
                            <label for="charge-amount">
                                <?php
                                    printf( __('مبلغ شارژ (%s):','woodmartplus'),'تومان' );
                                ?>
                            </label>
                            <input type="number" id="charge-amount" name="charge_amount" min="1000" step="1000" placeholder="<?php esc_html_e('مبلغ را وارد کنید','woodmartplus'); ?>" required>
                            <small class="form-help"><?php esc_html_e('حداقل مبلغ شارژ 1,000 تومان می‌باشد','woodmartplus'); ?></small>
                        </div>

                        <div class="wallet-form-actions">
                            <button type="submit" class="button button-primary" id="apply-charge-btn">
                                <input type="hidden" name="do_charge_wallet" value="yes">
                                <span class="dashicons dashicons-yes-alt" style="vertical-align: middle; margin-left: 5px;"></span>
                                <?php esc_html_e('اعمال شارژ','woodmartplus'); ?>
                            </button>
                            <button type="button" class="button" id="cancel-charge-btn"><?php esc_html_e('انصراف','woodmartplus'); ?></button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

<?php
    }

    private function show_notice()
    {
        $option = get_option('wallet_admin_notice');
        
        if( !$option )
        {
            return;
        }

        if( $option['type'] === 'error' )
        {
            ?>
                <p style="padding: 10px; background: white; border-right: 4px solid #d80b03;"><?php echo $option['message']; ?></p>
            <?php
        }

        if( $option['type'] === 'success' )
        {
            ?>
                <p style="padding: 10px; background: white; border-right: 4px solid #acd803;"><?php echo $option['message']; ?></p>
            <?php
        }
        
        delete_option('wallet_admin_notice');
    }
}
