jQuery(function($) {

    if ('undefined' != typeof elementor && 'undefined' !== elementorCommon) {
        elementor.on('preview:loaded', function() {
            var $modal;
        
            var $buttons = $('#tmpl-elementor-add-section');

            var text = $buttons.text().replace(
                '<div class="elementor-add-section-drag-title',
                '<div class="elementor-add-section-area-button woodplus-library-modal-btn" title="woodmartplus Templates">تم پلیت های وودمارت پلاس</div><div class="elementor-add-section-drag-title'
            );

            $buttons.text(text);
            $(elementor.$previewContents[0].body).on('click', '.woodplus-library-modal-btn', function() {
                
                if ($modal) {
                    $modal.show();
                    return;
                }

                var modalOptions = {
                    id           : 'woodplus-library-modal',
                    headerMessage: $('#tmpl-elementor-woodplus-library-modal-header').html(),
                    message      : $('#tmpl-elementor-woodplus-library-modal').html(),
                    className    : 'elementor-templates-modal',
                    closeButton  : true,
                    draggable    : false,
                    hide         : {
                        onOutsideClick: true,
                        onEscKeyPress : true
                    },
                    position     : {
                        my: 'center',
                        at: 'center'
                    }
                };
                $modal = elementorCommon.dialogsManager.createWidget('lightbox', modalOptions);
                $modal.show();

                loadTemplates();
            });

            // Load items.
            function loadTemplates() {
                showLoader();

                $.ajax({
                    url     : woodplus_elementor_template.demoAjaxUrl,
                    method  : 'GET',
                    data    : {
                        action : 'woodmartplus_load_templates',
                        builder: 'elementor'
                    },
                    dataType: 'json',
                    success : function(response) {
                        if (response && response.elements) {
                            var itemTemplate = wp.template('elementor-woodplus-library-modal-item');
                            var itemOrderTemplate = wp.template('elementor-woodplus-library-modal-order');
                            
                            response.elements = response.elements.reverse();
                            $(itemTemplate(response)).appendTo($('#woodplus-library-modal #elementor-template-library-templates-container'));
                            $(itemOrderTemplate(response)).appendTo($('#woodplus-library-modal #elementor-template-library-filter-toolbar-remote'));
                            importTemplate();
                            hideLoader();
                        } else {
                            $('<div class="xts-notice xts-warning">The library can\'t be loaded from the server.</div>').appendTo($('#woodplus-library-modal #elementor-template-library-templates-container'));
                            hideLoader();
                        }
                    },
                    error   : function() {
                        $('<div class="xts-notice xts-warning">The library can\'t be loaded from the server.</div>').appendTo($('#woodplus-library-modal #elementor-template-library-templates-container'));
                        hideLoader();
                    }
                });
            }

            // Loader
            function showLoader() {
                $('#woodplus-library-modal #elementor-template-library-templates').hide();
                $('#woodplus-library-modal .elementor-loader-wrapper').show();
            }

            function hideLoader() {
                $('#woodplus-library-modal #elementor-template-library-templates').show();
                $('#woodplus-library-modal .elementor-loader-wrapper').hide();
            }

            function activateUpdateButton() {
                $('#elementor-panel-saver-button-publish').toggleClass('elementor-disabled');
                $('#elementor-panel-saver-button-save-options').toggleClass('elementor-disabled');
            }


            // Import.
            function importTemplate() {
                $('#woodplus-library-modal .elementor-template-library-template-insert').on('click', function() {
                    showLoader();

                    $.ajax({
                        url     : woodplus_elementor_template.ajaxUrl,
                        method  : 'POST',
                        data    : {
                            action            : 'woodplus_get_templates',
                            template_id       : $(this).data('id'),
                            editor_post_id    : ElementorConfig.initial_document.id
                        },
                        dataType: 'json',
                        success: function success(data) {
                            if (data && data.content) {
                                elementor.getPreviewView().addChildModel(data.content);
                                $modal.hide();
                                setTimeout(function() {
                                    hideLoader();
                                }, 2000);
                                activateUpdateButton();
                            } else {
                                $('<div class="xts-notice xts-warning">The element can\'t be loaded from the server.</div>').prependTo($('#woodplus-library-modal #elementor-template-library-templates-container'));
                                hideLoader();
                            }
                        },
                        error  : function() {
                            $('<div class="xts-notice xts-warning">The element can\'t be loaded from the server.</div>').prependTo($('#woodplus-library-modal #elementor-template-library-templates-container'));
                            hideLoader();
                        }
                    });
                });

                // Close button.
                $('#woodplus-library-modal .elementor-templates-modal__header__close').on('click', function() {
                    $modal.hide();
                    hideLoader();
                });

                // Search.
                $('#woodplus-library-modal #elementor-template-library-filter-text').on('keyup', function() {
                    var val = $(this).val().toLowerCase();

                    $('#woodplus-library-modal').find('.elementor-template-library-template-block').each(function() {
                        var $this = $(this);
                        var title = $this.data('title').toLowerCase();
                        var slug = $this.data('slug').toLowerCase();

                        if (title.indexOf(val) > -1 || slug.indexOf(val) > -1) {
                            $this.show();
                        } else {
                            $this.hide();
                        }
                    });
                });

                // Filters.
                $('#woodplus-library-modal #elementor-template-library-filter-subtype').on('change', function() {
                    var val = $(this).val();

                    $('#woodplus-library-modal').find('.elementor-template-library-template-block').each(function() {
                        var $this = $(this);
                        var tag = $this.data('tag').toLowerCase();

                        if (tag.indexOf(val) > -1 || 'all' === val) {
                            $this.show();
                        } else {
                            $this.hide();
                        }
                    });
                });
            }
        });

    }

});