 
 (function($){

        $(document).ready(function() {
            
             $("#sendDateTime").persianDatepicker({
                formatDate: "YYYY/MM/DD hh:mm:ss", 
            });

            // نمایش کمپین‌های نمونه
            displayCampaigns();
            
            // باز کردن پاپ آپ ایجاد کمپین
            $('#addCampaignBtn').click(function() {
                $('#campaignPopup').fadeIn(300);
            });
            
            // بستن پاپ آپ ایجاد کمپین
            $('#closePopup, #cancelBtn').click(function() {
                $('#campaignPopup').fadeOut(300);
            });
            
            // بستن پاپ آپ جزئیات
            $('#closeDetailsPopup, #closeDetailsBtn').click(function() {
                $('#detailsPopup').fadeOut(300);
            });
            
            // بستن پاپ آپ با کلیک روی پس زمینه
            $('.popup-overlay').click(function(e) {
                if (e.target === this) {
                    $(this).fadeOut(300);
                }
            });
            
            // نمایش/مخفی کردن فیلد تاریخ بر اساس نوع زمان‌بندی
            $('#scheduleType').change(function() {
                if ($(this).val() === 'scheduled') {
                    $('#scheduleDateTime').show();
                    $('#sendDateTime').attr('required', true);
                } else {
                    $('#scheduleDateTime').hide();
                    $('#sendDateTime').removeAttr('required');
                }

                if ($(this).val() === 'dynamic') {
                    $('#scheduleTime').show();
                    // $('#sendTime').attr('required', true);
                } else {
                    $('#scheduleTime').hide();
                    $('#sendTime').removeAttr('required');
                }
            });
            
            $('#deleteCampaignBtn').click(function() {
                if (confirm('آیا از حذف این کمپین اطمینان دارید؟')) {
                    
                    var campaignId = $(this).data('campaign-id');
                    $.ajax({
                        dataType: 'json', type: 'POST', url : ajaxurl,
                        data :{
                            action : "remove_campaign",
                            campaignId : campaignId
                        },
                        success : function(response){
                            if('OK' === response.status)
                            {
                                location.reload();
                            }
                        },
                        error : function(error){}
                    });
                }
            });
            
            

            $(document).keyup(function(e) {
                if (e.keyCode === 27) {
                    $('.popup-overlay:visible').fadeOut(300);
                }
            });
            
            $(document).ready(function($) {
                var feedbackSmsEnabled = false;
                
                $('#conditionType').on('change', function() {
                    var selectedCondition = $(this).val();
                    var feedbackContainer = $('#feedbackSmsContainer');
                    var feedbackCheckbox = $('#sendFeedbackSms');
                    var feedbackInfo = $('#feedbackSmsInfo');
                    
                    if (selectedCondition === 'last_purchase') {
                        feedbackContainer.show();
                    } else {
                        feedbackContainer.hide();
                        feedbackCheckbox.prop('checked', false);
                        feedbackInfo.hide();
                        feedbackSmsEnabled = false;
                    }
                });
                
                $('#sendFeedbackSms').on('change', function() {
                    var feedbackInfo = $('#feedbackSmsInfo');
                    
                    if ($(this).is(':checked')) {
                        $('.suggestion-inputs.gray-inp').hide();
                        feedbackInfo.slideDown(300);
                        feedbackSmsEnabled = true;
                    } else {
                        $('.suggestion-inputs.gray-inp').show();
                        feedbackInfo.slideUp(300);
                        feedbackSmsEnabled = false;
                    }
                });
                
                $('#campaignForm').on('submit', function() {
                    var conditionType = $('#conditionType').val();
                    
                    if (conditionType === 'last_purchase' && feedbackSmsEnabled) {
                        if ($('input[name="conditionTypeWithFeedback"]').length === 0) {
                            $(this).append('<input type="hidden" name="conditionTypeWithFeedback" value="'+ajax_object.conditionTypeWithFeedback+'">');
                        }
                    }
                });
            });

        });
        
        $(document).ready(function($) {
            $('.popup-tab-button').on('click', function(e) {
                e.preventDefault();
                
                var targetTab = $(this).data('tab');
                
                $('.popup-tab-button').removeClass('active');
                $('.popup-tab-content').removeClass('active');
                
                $(this).addClass('active');
                $('#' + targetTab).addClass('active');
            });
        });

        function displayCampaigns() {

            $('.campaign-card').click(function() {
                var campaignId = $(this).data('campaign-id');

                showCampaignLoader();

                $.ajax({
                    dataType: 'json', type: 'POST', url : ajaxurl,
                    data :{
                        action : "get_campaign_detial",
                        campaignId : campaignId
                    },
                    success: function(response){
                        hideCampaignLoader();
                        showCampaignDetails(response.content,campaignId);   
                        loadTabButton();       
                        loadAjaxExport();  
                    },
                    error : function(error){
                        hideCampaignLoader();
                        alert('خطا در بارگذاری اطلاعات کمپین');
                    }
                });
                
            });
        }

        function loadAjaxExport()
        {
            $('#exportExcelBtn').on('click',function(){
            var $this = $(this);
            var $trans_id = $this.data('campaing_id');
            var originalText = $this.html(); 
            
            $this.html('<span class="loader-spinner"></span> در حال تولید فایل...').addClass('loading').prop('disabled', true);
            
            $.ajax({
                type: 'POST', 
                dataType: 'json', 
                url : ajaxurl,
                data :{
                    action : "export_excel",
                    campaignId : $trans_id
                },
                success: function(response){
                    $this.html(originalText).removeClass('loading').prop('disabled', false);
                    
                    if(response.success) {
                        window.location.href = response.download_url;
                    } else {
                        alert(response.msg || 'خطا در تولید فایل اکسل');
                    }
                },
                error : function(error){
                        $this.html(originalText).removeClass('loading').prop('disabled', false);
                        alert('خطا در بارگذاری اطلاعات کمپین');
                    }
                });
            });

        }
        function showCampaignLoader() {
            if ($('#campaignLoader').length === 0) {
                $('body').append(`
                    <div id="campaignLoader" class="campaign-loader-overlay">
                        <div class="campaign-loader-content">
                            <div class="campaign-spinner"></div>
                            <p>در حال بارگذاری اطلاعات کمپین...</p>
                        </div>
                    </div>
                `);
            }
            
            $('#campaignLoader').fadeIn(200);
        }

        // تابع مخفی کردن لودر
        function hideCampaignLoader() {
            $('#campaignLoader').fadeOut(200);
        }
       
        // تابع دریافت متن وضعیت
        function getStatusText(status) {
            switch(status) {
                case 'active': return 'فعال';
                case 'scheduled': return 'زمان‌بندی شده';
                case 'completed': return 'تکمیل شده';
                default: return 'نامشخص';
            }
        }
        
        // تابع دریافت متن شرط
        function getConditionText(type, operator, value) {
            var typeTexts = {
                'purchase_count': 'تعداد خرید',
                'total_spent': 'مجموع خرید',
                'last_purchase': 'آخرین خرید',
                'registration_date': 'تاریخ عضویت',
                'birthday': 'ماه تولد',
                'city': 'شهر'
            };
            
            var operatorTexts = {
                'greater_than': 'بیشتر از',
                'less_than': 'کمتر از',
                'equal': 'برابر با',
                'between': 'بین'
            };
            
            var typeText = typeTexts[type] || type;
            var operatorText = operatorTexts[operator] || operator;
            
            if (type === 'city' && operator === 'equal') {
                return `کاربرانی که در شهر ${value} زندگی می‌کنند`;
            } else if (type === 'total_spent') {
                return `کاربرانی که ${typeText} ${operatorText} ${parseInt(value).toLocaleString()} تومان`;
            } else if (type === 'birthday') {
                var months = ['', 'فروردین', 'اردیبهشت', 'خرداد', 'تیر', 'مرداد', 'شهریور', 'مهر', 'آبان', 'آذر', 'دی', 'بهمن', 'اسفند'];
                return `کاربرانی که در ماه ${months[parseInt(value)] || value} متولد شده‌اند`;
            } else {
                var unit = '';
                if (type === 'last_purchase' || type === 'registration_date') {
                    unit = ' روز';
                }
                return `کاربرانی که ${typeText} ${operatorText} ${value}${unit} دارند`;
            }
        }
        
        function updateConditionExample() {
            var conditionType = $('#conditionType').val();
            var conditionOperator = $('#conditionOperator').val();
            var conditionValue = $('#conditionValue').val();
            
            if (conditionType && conditionOperator && conditionValue) {
                $('#conditionExample').html('<div class="condition-loader"><span class="spinner"></span> در حال محاسبه تعداد کاربران...</div>');
                
                $.ajax({
                    url: ajaxurl,
                    type: 'POST',
                    data: {
                        action: 'estimate_campaign_users',
                        condition_type: conditionType,
                        condition_operator: conditionOperator,
                        condition_value: conditionValue,
                        // nonce: campaign_ajax.nonce
                    },
                    success: function(response) {
                        if (response.success) {
                            var conditionText = getConditionText(conditionType, conditionOperator, conditionValue);
                            var estimatedUsers = response.estimated_users;
                            
                            $('#conditionExample').html('مثال: ' + conditionText + '<br><strong>' + estimatedUsers + '</strong>');
                            $('#conditionExampleInput').attr('value', conditionText);
                        } else {
                            $('#conditionExample').html('<div class="condition-error">خطا در محاسبه تعداد کاربران</div>');
                        }
                    },
                    error: function() {
                        $('#conditionExample').html('<div class="condition-error">خطا در ارتباط با سرور</div>');
                    }
                });
            } else {
                $('#conditionExample').html('');
                $('#conditionExampleInput').attr('value', '');
            }
        }

        // اتصال تابع به تغییرات فیلدها
        $(document).ready(function() {
            $('#conditionType, #conditionOperator, #conditionValue').on('change keyup', function() {
                updateConditionExample();
            });
        });

        // تنظیمات اضافی برای فرم ایجاد کمپین
        $('#conditionType').change(function() {
            var conditionType = $(this).val();
            var valueInput = $('#conditionValue');
            var operatorSelect = $('#conditionOperator');
            var scheduleType = $('#scheduleType');
            // پاک کردن مقادیر قبلی
            valueInput.val('');
            operatorSelect.val('');
            
            // تنظیم placeholder و نوع input
            switch(conditionType) {
                case 'purchase_count':
                    valueInput.attr('type', 'number').attr('placeholder', 'مثال: 10').attr('min', '0');
                    break;
                case 'total_spent':
                    valueInput.attr('type', 'number').attr('placeholder', 'مثال: 1000000').attr('min', '0');
                    break;
                case 'last_purchase':
                case 'registration_date':
                    valueInput.attr('type', 'number').attr('placeholder', 'مثال: 30 (روز)').attr('min', '0');
                    break;
                case 'birthday':
                    valueInput.attr('type', 'number').attr('placeholder', 'مثال: 12 (ماه)').attr('min', '1').attr('max', '12');
                    break;
                case 'city':
                    valueInput.attr('type', 'text').attr('placeholder', 'مثال: تهران').removeAttr('min max');
                    break;
                default:
                    valueInput.attr('type', 'text').attr('placeholder', 'مقدار').removeAttr('min max');
            }
            
            // محدود کردن عملگرها
            operatorSelect.find('option').each(function() {
                var optionValue = $(this).val();
                
                if (conditionType === 'city') {
                    if (optionValue === 'equal' || optionValue === '') {
                        $(this).show().prop('disabled', false);
                    } else {
                        $(this).hide().prop('disabled', true);
                    }
                } else if (conditionType === 'birthday') {
                    if (optionValue === 'month') {
                        $(this).show().prop('disabled', false);
                    } else {
                        $(this).hide().prop('disabled', true);
                    }
                } else {
                    if (optionValue === 'month') {
                        $(this).hide().prop('disabled', true);
                    } else {
                        $(this).show().prop('disabled', false);
                    }
                }
            });

            if( conditionType === 'birthday'){
                scheduleType.find('option[value="birthday_day"]').show().prop('disabled', false);
            }else{
                scheduleType.find('option[value="birthday_day"]').hide().prop('disabled', true);
            }
        });
        
        // تنظیم حداقل تاریخ برای زمان‌بندی
        var now = new Date();
        var year = now.getFullYear();
        var month = String(now.getMonth() + 1).padStart(2, '0');
        var day = String(now.getDate()).padStart(2, '0');
        var hours = String(now.getHours()).padStart(2, '0');
        var minutes = String(now.getMinutes()).padStart(2, '0');
        
        var minDateTime = year + '-' + month + '-' + day + 'T' + hours + ':' + minutes;
        $('#sendDateTime').attr('min', minDateTime);

                // داده‌های نمونه لاگ پیامک‌ها
        var sampleLogs = {
            1: [ // کمپین شماره 1
                {
                    id: 1,
                    phone: "09123456789",
                    status: "delivered",
                    sentAt: "1402/08/15 14:30:25",
                    deliveredAt: "1402/08/15 14:30:28",
                    errorMessage: null
                },
                {
                    id: 2,
                    phone: "09987654321",
                    status: "delivered",
                    sentAt: "1402/08/15 14:30:26",
                    deliveredAt: "1402/08/15 14:30:31",
                    errorMessage: null
                },
                {
                    id: 3,
                    phone: "09111222333",
                    status: "failed",
                    sentAt: "1402/08/15 14:30:27",
                    deliveredAt: null,
                    errorMessage: "شماره نامعتبر"
                },
                {
                    id: 4,
                    phone: "09444555666",
                    status: "delivered",
                    sentAt: "1402/08/15 14:30:28",
                    deliveredAt: "1402/08/15 14:30:35",
                    errorMessage: null
                },
                {
                    id: 5,
                    phone: "09777888999",
                    status: "failed",
                    sentAt: "1402/08/15 14:30:29",
                    deliveredAt: null,
                    errorMessage: "اپراتور در دسترس نیست"
                }
            ],
            2: [ // کمپین شماره 2 (زمان‌بندی شده - هنوز ارسال نشده)
                // خالی چون هنوز ارسال نشده
            ],
            3: [ // کمپین شماره 3
                {
                    id: 6,
                    phone: "09123123123",
                    status: "delivered",
                    sentAt: "1402/07/10 10:15:10",
                    deliveredAt: "1402/07/10 10:15:15",
                    errorMessage: null
                },
                {
                    id: 7,
                    phone: "09456456456",
                    status: "delivered",
                    sentAt: "1402/07/10 10:15:11",
                    deliveredAt: "1402/07/10 10:15:18",
                    errorMessage: null
                },
                {
                    id: 8,
                    phone: "09789789789",
                    status: "failed",
                    sentAt: "1402/07/10 10:15:12",
                    deliveredAt: null,
                    errorMessage: "سقف ارسال روزانه تمام شده"
                }
            ],
            4: [ // کمپین شماره 4
                {
                    id: 9,
                    phone: "09111111111",
                    status: "delivered",
                    sentAt: "1402/08/22 16:45:00",
                    deliveredAt: "1402/08/22 16:45:05",
                    errorMessage: null
                },
                {
                    id: 10,
                    phone: "09222222222",
                    status: "pending",
                    sentAt: "1402/08/22 16:45:01",
                    deliveredAt: null,
                    errorMessage: null
                }
            ]
        };
        
        var currentCampaignId = null;
        var filteredLogs = [];
        
        $(document).ready(function() {
           
            $('#statusFilter, #phoneFilter, #dateFromFilter, #dateToFilter').on('change input', function() {
                if (currentCampaignId) {
                    filterLogs();
                }
            });
            
           
            $('#refreshLogsBtn').click(function() {
                if (currentCampaignId) {
                    loadCampaignLogs(currentCampaignId);
                    $(this).text('🔄 بروزرسانی شد');
                    setTimeout(() => {
                        $(this).text('🔄 بروزرسانی');
                    }, 2000);
                }
            });
        });
        
        function loadTabButton()
        {
             $('.tab-button').click(function() {
                var tabName = $(this).data('tab');
                
                // تغییر کلاس فعال تب‌ها
                $('.tab-button').removeClass('active');
                $(this).addClass('active');
                
                // نمایش محتوای تب مربوطه
                $('.tab-content').removeClass('active');
                $('#' + tabName + 'Tab').addClass('active');
                
                // اگر تب لاگ انتخاب شد، لاگ‌ها را بارگذاری کن
                if (tabName === 'logs' && currentCampaignId) {
                    loadCampaignLogs(currentCampaignId);
                }
            });
        }
        // تابع نمایش جزئیات کمپین (بروزرسانی شده)
        function showCampaignDetails(campainDetial, campaignId) {
            
            
            $('#deleteCampaignBtn').attr('data-campaign-id', campaignId);
            // $('#exportExcelBtn').attr('data-campaigns-id', campaignId);
            
            // بازگشت به تب اول
            $('.tab-button').removeClass('active');
            $('.tab-button[data-tab="overview"]').addClass('active');
            $('.tab-content').removeClass('active');
            $('#overviewTab').addClass('active');
            
            //  $('#detailsBody').html(campainDetial);
             $('.popup-body.detials-campaign').html(campainDetial);
             $('#detailsPopup').fadeIn(300);   
            
        }
        
        // تابع بارگذاری لاگ‌های کمپین
        function loadCampaignLogs(campaignId) {
            var logs = sampleLogs[campaignId] || [];
            filteredLogs = [...logs]; // کپی از لاگ‌ها برای فیلتر
            
            // نمایش خلاصه آمار لاگ
            displayLogsSummary(logs);
            
            // نمایش لاگ‌ها
            displayLogs(filteredLogs);
            
            // پاک کردن فیلترها
            $('#statusFilter').val('');
            $('#phoneFilter').val('');
            $('#dateFromFilter').val('');
            $('#dateToFilter').val('');
        }
        
        // تابع نمایش خلاصه آمار لاگ
        function displayLogsSummary(logs) {
            var total = logs.length;
            var delivered = logs.filter(log => log.status === 'delivered').length;
            var failed = logs.filter(log => log.status === 'failed').length;
            var pending = logs.filter(log => log.status === 'pending').length;
            var sent = logs.filter(log => log.status === 'sent').length;
            
            var summaryHtml = `
                <div class="summary-item">
                    <div class="summary-number">${total}</div>
                    <div class="summary-label">کل پیامک‌ها</div>
                </div>
                <div class="summary-item">
                    <div class="summary-number" style="color: #2e7d32;">${delivered}</div>
                    <div class="summary-label">تحویل شده</div>
                </div>
                <div class="summary-item">
                    <div class="summary-number" style="color: #c62828;">${failed}</div>
                    <div class="summary-label">ناموفق</div>
                </div>
                <div class="summary-item">
                    <div class="summary-number" style="color: #f57c00;">${pending}</div>
                    <div class="summary-label">در انتظار</div>
                </div>
                <div class="summary-item">
                    <div class="summary-number" style="color: #1976d2;">${sent}</div>
                    <div class="summary-label">ارسال شده</div>
                </div>
                <div class="summary-item">
                    <div class="summary-number">${total > 0 ? Math.round((delivered / total) * 100) : 0}%</div>
                    <div class="summary-label">نرخ موفقیت</div>
                </div>
            `;
            
            $('#logsSummary').html(summaryHtml);
        }
        
        // تابع نمایش لاگ‌ها در جدول
        function displayLogs(logs) {
            var tbody = $('#logsTableBody');
            tbody.empty();
            
            if (logs.length === 0) {
                tbody.append(`
                    <tr>
                        <td colspan="5" class="no-logs">
                            هیچ لاگی برای نمایش وجود ندارد
                        </td>
                    </tr>
                `);
                return;
            }
            
            logs.forEach(function(log) {
                var statusBadge = getStatusBadge(log.status);
                var deliveredTime = log.deliveredAt || '-';
                var errorInfo = log.errorMessage ? `<div class="error-message">${log.errorMessage}</div>` : '-';
                
                var rowHtml = `
                    <tr>
                        <td class="phone-number">${log.phone}</td>
                        <td>${statusBadge}</td>
                        <td>${log.sentAt}</td>
                        <td>${deliveredTime}</td>
                        <td>${errorInfo}</td>
                    </tr>
                `;
                
                tbody.append(rowHtml);
            });
        }
        
        // تابع دریافت نشان وضعیت
        function getStatusBadge(status) {
            var badges = {
                'sent': '<span class="status-badge status-sent">ارسال شده</span>',
                'delivered': '<span class="status-badge status-delivered">تحویل شده</span>',
                'failed': '<span class="status-badge status-failed">ناموفق</span>',
                'pending': '<span class="status-badge status-pending">در انتظار</span>'
            };
            
            return badges[status] || '<span class="status-badge">' + status + '</span>';
        }
        
        // تابع فیلتر کردن لاگ‌ها
        function filterLogs() {
            var statusFilter = $('#statusFilter').val();
            var phoneFilter = $('#phoneFilter').val().trim();
            var dateFromFilter = $('#dateFromFilter').val();
            var dateToFilter = $('#dateToFilter').val();
            
            var logs = sampleLogs[currentCampaignId] || [];
            
            filteredLogs = logs.filter(function(log) {
                // فیلتر وضعیت
                if (statusFilter && log.status !== statusFilter) {
                    return false;
                }
                
                // فیلتر شماره تلفن
                if (phoneFilter && !log.phone.includes(phoneFilter)) {
                    return false;
                }
                
                // فیلتر تاریخ (ساده‌سازی شده - در پروژه واقعی باید تبدیل تاریخ انجام شود)
                if (dateFromFilter || dateToFilter) {
                    // اینجا باید تاریخ‌ها را به فرمت قابل مقایسه تبدیل کرد
                    // برای سادگی، فعلاً این بخش را نادیده می‌گیریم
                }
                
                return true;
            });
            
            // نمایش لاگ‌های فیلتر شده
            displayLogs(filteredLogs);
            
            // بروزرسانی خلاصه آمار
            displayLogsSummary(filteredLogs);
        }
        
        // تولید لاگ‌های تصادفی بیشتر برای تست
        function generateMoreSampleLogs() {
            var phones = [
                "09123456789", "09987654321", "09111222333", "09444555666", 
                "09777888999", "09123123123", "09456456456", "09789789789",
                "09111111111", "09222222222", "09333333333", "09555555555",
                "09666666666", "09888888888", "09999999999", "09101010101"
            ];
            
            var statuses = ['delivered', 'delivered', 'delivered', 'failed', 'pending', 'sent'];
            var errors = [
                null, null, null, null, null,
                "شماره نامعتبر", 
                "اپراتور در دسترس نیست", 
                "سقف ارسال روزانه تمام شده",
                "شماره در لیست سیاه",
                "خطای شبکه"
            ];
            
            // اضافه کردن لاگ‌های بیشتر برای کمپین شماره 1
            for (var i = 6; i <= 50; i++) {
                var phone = phones[Math.floor(Math.random() * phones.length)];
                var status = statuses[Math.floor(Math.random() * statuses.length)];
                var error = status === 'failed' ? errors[Math.floor(Math.random() * errors.length)] : null;
                
                var hour = Math.floor(Math.random() * 2) + 14; // 14 یا 15
                var minute = Math.floor(Math.random() * 60);
                var second = Math.floor(Math.random() * 60);
                
                var sentTime = `1402/08/15 ${hour}:${minute.toString().padStart(2, '0')}:${second.toString().padStart(2, '0')}`;
                var deliveredTime = null;
                
                if (status === 'delivered') {
                    var deliveredSecond = second + Math.floor(Math.random() * 10) + 3;
                    if (deliveredSecond >= 60) {
                        deliveredSecond -= 60;
                        minute += 1;
                    }
                    deliveredTime = `1402/08/15 ${hour}:${minute.toString().padStart(2, '0')}:${deliveredSecond.toString().padStart(2, '0')}`;
                }
                
                sampleLogs[1].push({
                    id: i,
                    phone: phone,
                    status: status,
                    sentAt: sentTime,
                    deliveredAt: deliveredTime,
                    errorMessage: error
                });
            }
        }
        
        // تولید لاگ‌های نمونه بیشتر
        generateMoreSampleLogs();

        function load_tab_popup_detial()
        {
            document.addEventListener('DOMContentLoaded', function() {
                // عملکرد دکمه نمایش/مخفی کردن شورتکدها
                const toggleBtn = document.getElementById('toggleShortcodes');
                const extendedSection = document.getElementById('shortcodesExtended');
                
                if (toggleBtn && extendedSection) {
                    toggleBtn.addEventListener('click', function() {
                        const isVisible = extendedSection.style.display !== 'none';
                        const showText = toggleBtn.querySelector('.show-text');
                        const hideText = toggleBtn.querySelector('.hide-text');
                        
                        if (isVisible) {
                            // مخفی کردن
                            extendedSection.style.display = 'none';
                            showText.style.display = 'inline';
                            hideText.style.display = 'none';
                            toggleBtn.classList.remove('expanded');
                        } else {
                            // نمایش دادن
                            extendedSection.style.display = 'block';
                            showText.style.display = 'none';
                            hideText.style.display = 'inline';
                            toggleBtn.classList.add('expanded');
                        }
                    });
                }
            });
        }
})( jQuery );