/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-10-12 06:38:16 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `claim_id_status_priority_scheduled_date_gmt` (`claim_id`,`status`,`priority`,`scheduled_date_gmt`),
  KEY `status_last_attempt_gmt` (`status`,`last_attempt_gmt`),
  KEY `status_claim_id` (`status`,`claim_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2959 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=175312 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=8832 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_appwoodart_woo_api_geo_fencing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `post_id` int(11) NOT NULL,
  `radius` text NOT NULL,
  `lat` double NOT NULL,
  `lng` double NOT NULL,
  `zoom` int(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_appwoodart_woo_api_notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `device_token` text NOT NULL,
  `device_type` tinyint(4) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_appwoodart_woo_api_notifications_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `msg` text NOT NULL,
  `custom_msg` text NOT NULL,
  `not_code` tinyint(4) NOT NULL,
  `created` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_appwoodart_woo_api_notifications_relationships` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `not_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `push_meta_id` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `push_meta_id` (`push_meta_id`),
  CONSTRAINT `wp_appwoodart_woo_api_notifications_relationships_ibfk_2` FOREIGN KEY (`push_meta_id`) REFERENCES `wp_appwoodart_woo_api_notifications_meta` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_appwoodart_woo_api_scratch_coupons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `coupon_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `device_token` text NOT NULL,
  `is_coupon_scratched` varchar(5) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=100 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=495 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=29 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_litespeed_img_optming` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `optm_status` tinyint(4) NOT NULL DEFAULT 0,
  `src` varchar(1000) NOT NULL DEFAULT '',
  `server_info` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `post_id` (`post_id`),
  KEY `optm_status` (`optm_status`),
  KEY `src` (`src`(191))
) ENGINE=InnoDB AUTO_INCREMENT=794 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=372674 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_pgs_woo_api_geo_fencing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `post_id` int(11) NOT NULL,
  `radius` double NOT NULL,
  `lat` double NOT NULL,
  `lng` double NOT NULL,
  `zoom` int(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_pgs_woo_api_notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `device_token` text NOT NULL,
  `device_type` tinyint(4) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_pgs_woo_api_notifications_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `msg` text NOT NULL,
  `custom_msg` text NOT NULL,
  `not_code` tinyint(4) NOT NULL,
  `created` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_pgs_woo_api_notifications_relationships` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `not_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `push_meta_id` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `push_meta_id` (`push_meta_id`),
  CONSTRAINT `wp_pgs_woo_api_notifications_relationships_ibfk_2` FOREIGN KEY (`push_meta_id`) REFERENCES `wp_pgs_woo_api_notifications_meta` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_pgs_woo_api_scratch_coupons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `coupon_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `device_token` text NOT NULL,
  `is_coupon_scratched` varchar(5) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=28574 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=5470 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_css_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_layer_animations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_navigations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_sliders7` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=MyISAM AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_sliders_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_slides7` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(11) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  `static` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_static_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_rtl_rsm_logs` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `section` varchar(255) NOT NULL,
  `result` mediumtext NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10242 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=1216 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_tm_taskmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `task_id` bigint(20) NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `task_id` (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_tm_tasks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `type` varchar(300) NOT NULL,
  `class_identifier` varchar(300) DEFAULT '0',
  `attempts` int(11) DEFAULT 0,
  `description` varchar(300) DEFAULT NULL,
  `time_created` timestamp NOT NULL DEFAULT current_timestamp(),
  `last_locked_at` bigint(20) DEFAULT 0,
  `status` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=10662 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=515 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=44063 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=165 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=539 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(250)),
  KEY `phone` (`phone`)
) ENGINE=MyISAM AUTO_INCREMENT=278 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=MyISAM AUTO_INCREMENT=145 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_product_date` (`customer_id`,`product_id`,`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_method_title` text DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=MyISAM AUTO_INCREMENT=1596 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  `global_unique_id` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wfblockediplog` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `countryCode` varchar(2) NOT NULL,
  `blockCount` int(10) unsigned NOT NULL DEFAULT 0,
  `unixday` int(10) unsigned NOT NULL,
  `blockType` varchar(50) NOT NULL DEFAULT 'generic',
  PRIMARY KEY (`IP`,`unixday`,`blockType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_wfblocks7` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` int(10) unsigned NOT NULL DEFAULT 0,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `blockedTime` bigint(20) NOT NULL,
  `reason` varchar(255) NOT NULL,
  `lastAttempt` int(10) unsigned DEFAULT 0,
  `blockedHits` int(10) unsigned DEFAULT 0,
  `expiration` bigint(20) unsigned NOT NULL DEFAULT 0,
  `parameters` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `IP` (`IP`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_wfconfig` (
  `name` varchar(100) NOT NULL,
  `val` longblob DEFAULT NULL,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_wfcrawlers` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `patternSig` binary(16) NOT NULL,
  `status` char(8) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  `PTR` varchar(255) DEFAULT '',
  PRIMARY KEY (`IP`,`patternSig`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_wffilechanges` (
  `filenameHash` char(64) NOT NULL,
  `file` varchar(1000) NOT NULL,
  `md5` char(32) NOT NULL,
  PRIMARY KEY (`filenameHash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_wffilemods` (
  `filenameMD5` binary(16) NOT NULL,
  `filename` varchar(1000) NOT NULL,
  `real_path` text NOT NULL,
  `knownFile` tinyint(3) unsigned NOT NULL,
  `oldMD5` binary(16) NOT NULL,
  `newMD5` binary(16) NOT NULL,
  `SHAC` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `stoppedOnSignature` varchar(255) NOT NULL DEFAULT '',
  `stoppedOnPosition` int(10) unsigned NOT NULL DEFAULT 0,
  `isSafeFile` varchar(1) NOT NULL DEFAULT '?',
  PRIMARY KEY (`filenameMD5`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_wfhits` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `attackLogTime` double(17,6) unsigned NOT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `jsRun` tinyint(4) DEFAULT 0,
  `statusCode` int(11) NOT NULL DEFAULT 200,
  `isGoogle` tinyint(4) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `newVisit` tinyint(3) unsigned NOT NULL,
  `URL` text DEFAULT NULL,
  `referer` text DEFAULT NULL,
  `UA` text DEFAULT NULL,
  `action` varchar(64) NOT NULL DEFAULT '',
  `actionDescription` text DEFAULT NULL,
  `actionData` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`IP`,`ctime`),
  KEY `attackLogTime` (`attackLogTime`)
) ENGINE=InnoDB AUTO_INCREMENT=38 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_wfhoover` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `owner` text DEFAULT NULL,
  `host` text DEFAULT NULL,
  `path` text DEFAULT NULL,
  `hostKey` varbinary(124) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k2` (`hostKey`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_wfissues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text DEFAULT NULL,
  `data` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_wfknownfilelist` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `path` text NOT NULL,
  `wordpress_path` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_wflivetraffichuman` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `identifier` binary(32) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `expiration` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`,`identifier`),
  KEY `expiration` (`expiration`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_wflocs` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `ctime` int(10) unsigned NOT NULL,
  `failed` tinyint(3) unsigned NOT NULL,
  `city` varchar(255) DEFAULT '',
  `region` varchar(255) DEFAULT '',
  `countryName` varchar(255) DEFAULT '',
  `countryCode` char(2) DEFAULT '',
  `lat` float(10,7) DEFAULT 0.0000000,
  `lon` float(10,7) DEFAULT 0.0000000,
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_wflogins` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `hitID` int(11) DEFAULT NULL,
  `ctime` double(17,6) unsigned NOT NULL,
  `fail` tinyint(3) unsigned NOT NULL,
  `action` varchar(40) NOT NULL,
  `username` varchar(255) NOT NULL,
  `userID` int(10) unsigned NOT NULL,
  `IP` binary(16) DEFAULT NULL,
  `UA` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`IP`,`fail`),
  KEY `hitID` (`hitID`)
) ENGINE=InnoDB AUTO_INCREMENT=33 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_wfls_2fa_secrets` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `secret` tinyblob NOT NULL,
  `recovery` blob NOT NULL,
  `ctime` int(10) unsigned NOT NULL,
  `vtime` int(10) unsigned NOT NULL,
  `mode` enum('authenticator') NOT NULL DEFAULT 'authenticator',
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_wfls_role_counts` (
  `serialized_roles` varbinary(255) NOT NULL,
  `two_factor_inactive` tinyint(1) NOT NULL,
  `user_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`serialized_roles`,`two_factor_inactive`)
) ENGINE=MEMORY DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_wfls_settings` (
  `name` varchar(191) NOT NULL DEFAULT '',
  `value` longblob DEFAULT NULL,
  `autoload` enum('no','yes') NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_wfnotifications` (
  `id` varchar(32) NOT NULL DEFAULT '',
  `new` tinyint(3) unsigned NOT NULL DEFAULT 1,
  `category` varchar(255) NOT NULL,
  `priority` int(11) NOT NULL DEFAULT 1000,
  `ctime` int(10) unsigned NOT NULL,
  `html` text NOT NULL,
  `links` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_wfpendingissues` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `time` int(10) unsigned NOT NULL,
  `lastUpdated` int(10) unsigned NOT NULL,
  `status` varchar(10) NOT NULL,
  `type` varchar(20) NOT NULL,
  `severity` tinyint(3) unsigned NOT NULL,
  `ignoreP` char(32) NOT NULL,
  `ignoreC` char(32) NOT NULL,
  `shortMsg` varchar(255) NOT NULL,
  `longMsg` text DEFAULT NULL,
  `data` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `lastUpdated` (`lastUpdated`),
  KEY `status` (`status`),
  KEY `ignoreP` (`ignoreP`),
  KEY `ignoreC` (`ignoreC`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_wfreversecache` (
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `host` varchar(255) NOT NULL,
  `lastUpdate` int(10) unsigned NOT NULL,
  PRIMARY KEY (`IP`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_wfsecurityevents` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL DEFAULT '',
  `data` text NOT NULL,
  `event_time` double(14,4) NOT NULL,
  `state` enum('new','sending','sent') NOT NULL DEFAULT 'new',
  `state_timestamp` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `wp_wfsnipcache` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `IP` varchar(45) NOT NULL DEFAULT '',
  `expiration` timestamp NOT NULL DEFAULT current_timestamp(),
  `body` varchar(255) NOT NULL DEFAULT '',
  `count` int(10) unsigned NOT NULL DEFAULT 0,
  `type` int(10) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `expiration` (`expiration`),
  KEY `IP` (`IP`),
  KEY `type` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_wfstatus` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `ctime` double(17,6) unsigned NOT NULL,
  `level` tinyint(3) unsigned NOT NULL,
  `type` char(5) NOT NULL,
  `msg` varchar(1000) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `k1` (`ctime`),
  KEY `k2` (`type`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_wftrafficrates` (
  `eMin` int(10) unsigned NOT NULL,
  `IP` binary(16) NOT NULL DEFAULT '\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0\0',
  `hitType` enum('hit','404') NOT NULL DEFAULT 'hit',
  `hits` int(10) unsigned NOT NULL,
  PRIMARY KEY (`eMin`,`IP`,`hitType`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_wfwaffailures` (
  `id` int(10) unsigned NOT NULL AUTO_INCREMENT,
  `throwable` text NOT NULL,
  `rule_id` int(10) unsigned DEFAULT NULL,
  `timestamp` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_ir` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text1` text CHARACTER SET utf8mb3 COLLATE utf8mb3_persian_ci NOT NULL,
  `text2` text CHARACTER SET utf8mb3 COLLATE utf8mb3_persian_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB AUTO_INCREMENT=1778 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=170 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=25812 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20)),
  KEY `zone_id` (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woodapp_wc_api_geo_fencing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `post_id` int(11) NOT NULL,
  `radius` double NOT NULL,
  `lat` double NOT NULL,
  `lng` double NOT NULL,
  `zoom` int(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woodapp_wc_api_notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `device_token` text NOT NULL,
  `device_type` tinyint(4) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woodapp_wc_api_notifications_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `msg` text NOT NULL,
  `custom_msg` text NOT NULL,
  `not_code` tinyint(4) NOT NULL,
  `created` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woodapp_wc_api_notifications_relationships` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `not_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `push_meta_id` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `push_meta_id` (`push_meta_id`),
  CONSTRAINT `wp_woodapp_wc_api_notifications_relationships_ibfk_2` FOREIGN KEY (`push_meta_id`) REFERENCES `wp_woodapp_wc_api_notifications_meta` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woodapp_wc_api_scratch_coupons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `coupon_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `device_token` text NOT NULL,
  `is_coupon_scratched` varchar(5) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woodmart_unsubscribed_emails` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `user_email` varchar(100) NOT NULL,
  `unsubscribed_email_name` varchar(100) NOT NULL,
  `unsubscription_date` datetime NOT NULL DEFAULT current_timestamp(),
  `unsubscription_date_gmt` datetime NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woodmart_wishlist_products` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` varchar(255) NOT NULL,
  `wishlist_id` int(11) DEFAULT NULL,
  `date_added` timestamp NOT NULL DEFAULT current_timestamp(),
  `on_sale` tinyint(1) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_woodmart_wishlists` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `wishlist_group` varchar(255) NOT NULL DEFAULT 'علاقه مندی های من',
  `date_created` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=524 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_wpr_rocket_cache` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `status` varchar(255) NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `is_locked` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `url` (`url`(191)),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`)
) ENGINE=MyISAM AUTO_INCREMENT=35 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpr_rucss_used_css` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `css` longtext DEFAULT NULL,
  `hash` varchar(32) DEFAULT '',
  `error_code` varchar(32) DEFAULT NULL,
  `error_message` longtext DEFAULT NULL,
  `unprocessedcss` longtext DEFAULT NULL,
  `retries` tinyint(1) NOT NULL DEFAULT 1,
  `is_mobile` tinyint(1) NOT NULL DEFAULT 0,
  `job_id` varchar(255) NOT NULL DEFAULT '',
  `queue_name` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(255) NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `status_index` (`status`(191)),
  KEY `error_code_index` (`error_code`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("325", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2023-02-24 23:55:34", "2023-02-24 22:55:34", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1677282934;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1677282934;}", "4", "1", "2023-02-24 23:55:37", "2023-02-24 22:55:37", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("367", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2023-03-15 04:52:22", "2023-03-15 03:52:22", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1678855942;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1678855942;}", "4", "1", "2023-03-15 04:52:23", "2023-03-15 03:52:23", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("370", "action_scheduler/migration_hook", "failed", "2023-03-15 05:24:56", "2023-03-15 04:24:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1678857896;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1678857896;}", "1", "1", "2023-03-15 05:25:10", "2023-03-15 04:25:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("458", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2023-04-28 23:53:00", "2023-04-28 23:53:00", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1682725980;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1682725980;}", "4", "1", "2023-04-28 23:53:02", "2023-04-28 23:53:02", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("468", "action_scheduler/migration_hook", "failed", "2023-04-30 16:44:55", "2023-04-30 16:44:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1682873095;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1682873095;}", "1", "1", "2023-04-30 16:45:00", "2023-04-30 16:45:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("469", "action_scheduler/migration_hook", "failed", "2023-04-30 16:44:55", "2023-04-30 16:44:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1682873095;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1682873095;}", "1", "1", "2023-04-30 16:45:00", "2023-04-30 16:45:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("483", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2023-05-13 12:03:00", "2023-05-13 12:03:00", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1683979380;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1683979380;}", "4", "1", "2023-05-13 12:03:03", "2023-05-13 12:03:03", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("484", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2023-05-13 12:03:04", "2023-05-13 12:03:04", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1683979384;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1683979384;}", "4", "1", "2023-05-13 12:03:06", "2023-05-13 12:03:06", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("494", "action_scheduler/migration_hook", "failed", "2023-05-27 01:39:57", "2023-05-27 01:39:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1685151597;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1685151597;}", "1", "1", "2023-05-27 01:40:59", "2023-05-27 01:40:59", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("503", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2023-06-02 14:15:29", "2023-06-02 14:15:29", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1685715329;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1685715329;}", "4", "1", "2023-06-02 14:16:41", "2023-06-02 14:16:41", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("579", "action_scheduler/migration_hook", "failed", "2023-08-30 19:05:26", "2023-08-30 19:05:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1693422326;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1693422326;}", "1", "1", "2023-08-30 19:05:27", "2023-08-30 19:05:27", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("609", "action_scheduler/migration_hook", "failed", "2023-09-11 07:50:23", "2023-09-11 07:50:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1694418623;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1694418623;}", "1", "1", "2023-09-11 07:52:52", "2023-09-11 07:52:52", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("853", "rocket_preload_job_check_finished", "failed", "2023-09-23 03:17:32", "2023-09-23 03:17:32", "[1695438992]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1695439052;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1695439052;}", "6", "1", "2023-09-23 03:17:47", "2023-09-23 03:17:47", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1045", "action_scheduler/migration_hook", "failed", "2024-01-22 07:23:12", "2024-01-22 06:23:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1705908192;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1705908192;}", "1", "1", "2024-01-22 07:23:40", "2024-01-22 06:23:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1047", "action_scheduler/migration_hook", "failed", "2024-01-22 11:34:20", "2024-01-22 10:34:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1705923260;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1705923260;}", "1", "1", "2024-01-22 11:34:24", "2024-01-22 10:34:24", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1312", "action_scheduler/migration_hook", "failed", "2024-07-01 14:33:10", "2024-07-01 14:33:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1719844390;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1719844390;}", "1", "1", "2024-07-01 14:33:34", "2024-07-01 14:33:34", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1527", "action_scheduler/migration_hook", "failed", "2024-11-19 07:27:51", "2024-11-19 06:27:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732001271;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732001271;}", "1", "1", "2024-11-19 07:27:56", "2024-11-19 06:27:56", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1549", "action_scheduler/migration_hook", "failed", "2024-12-01 13:55:09", "2024-12-01 12:55:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1733061309;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1733061309;}", "1", "1", "2024-12-01 13:55:10", "2024-12-01 12:55:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1715", "action_scheduler/migration_hook", "failed", "2025-03-05 03:13:15", "2025-03-05 02:13:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1741144395;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1741144395;}", "1", "1", "2025-03-05 03:13:28", "2025-03-05 02:13:28", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2300", "woocommerce_geoip_updater", "complete", "2025-09-20 07:31:38", "2025-09-20 07:31:38", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758353498;s:18:\"\0*\0first_timestamp\";i:1755758282;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758353498;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}", "12", "1", "2025-09-20 09:46:14", "2025-09-20 09:46:14", "175080", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2375", "woocommerce_cleanup_draft_orders", "complete", "2025-09-11 18:10:33", "2025-09-11 18:10:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757614233;s:18:\"\0*\0first_timestamp\";i:1668840681;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757614233;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-11 19:23:04", "2025-09-11 19:23:04", "174976", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2376", "woocommerce_scheduled_sales", "complete", "2025-09-11 18:10:33", "2025-09-11 18:10:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757614233;s:18:\"\0*\0first_timestamp\";i:1755820800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757614233;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-11 19:23:04", "2025-09-11 19:23:04", "174976", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2377", "wc_admin_daily_wrapper", "complete", "2025-09-11 18:10:35", "2025-09-11 18:10:35", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757614235;s:18:\"\0*\0first_timestamp\";i:1755758222;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757614235;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-11 19:23:06", "2025-09-11 19:23:06", "174976", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2378", "woocommerce_cleanup_personal_data", "complete", "2025-09-11 18:10:36", "2025-09-11 18:10:36", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757614236;s:18:\"\0*\0first_timestamp\";i:1755758231;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757614236;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-11 19:23:07", "2025-09-11 19:23:07", "174976", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2379", "woocommerce_cleanup_logs", "complete", "2025-09-11 18:10:36", "2025-09-11 18:10:36", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757614236;s:18:\"\0*\0first_timestamp\";i:1755769021;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757614236;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-11 19:23:08", "2025-09-11 19:23:08", "174976", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2380", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-09-11 18:10:36", "2025-09-11 18:10:36", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757614236;s:18:\"\0*\0first_timestamp\";i:1755769022;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757614236;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-11 19:23:08", "2025-09-11 19:23:08", "174976", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2383", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-11 18:10:36", "2025-09-11 18:10:36", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757614236;s:18:\"\0*\0first_timestamp\";i:1755758209;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757614236;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-09-11 19:23:08", "2025-09-11 19:23:08", "174976", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("2385", "woocommerce_refresh_order_count_cache", "complete", "2025-09-11 08:07:47", "2025-09-11 08:07:47", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757578067;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757578067;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-11 17:17:18", "2025-09-11 17:17:18", "174974", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2386", "woocommerce_cleanup_sessions", "complete", "2025-09-11 08:07:47", "2025-09-11 08:07:47", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757578067;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757578067;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-09-11 17:17:18", "2025-09-11 17:17:18", "174974", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2388", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-11 05:21:47", "2025-09-11 05:21:47", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757568107;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757568107;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-11 17:17:18", "2025-09-11 17:17:18", "174974", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2389", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-11 18:17:18", "2025-09-11 18:17:18", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757614638;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757614638;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-11 19:23:08", "2025-09-11 19:23:08", "174976", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2390", "woocommerce_refresh_order_count_cache", "complete", "2025-09-12 05:17:18", "2025-09-12 05:17:18", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757654238;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757654238;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-12 06:49:47", "2025-09-12 06:49:47", "174980", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2391", "woocommerce_cleanup_sessions", "complete", "2025-09-12 05:17:18", "2025-09-12 05:17:18", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757654238;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757654238;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-09-12 06:49:47", "2025-09-12 06:49:47", "174980", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2392", "woocommerce_cleanup_draft_orders", "complete", "2025-09-12 19:23:04", "2025-09-12 19:23:04", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757704984;s:18:\"\0*\0first_timestamp\";i:1668840681;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757704984;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-13 06:27:36", "2025-09-13 06:27:36", "174992", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2393", "woocommerce_scheduled_sales", "complete", "2025-09-12 19:23:04", "2025-09-12 19:23:04", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757704984;s:18:\"\0*\0first_timestamp\";i:1755820800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757704984;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-13 06:27:36", "2025-09-13 06:27:36", "174992", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2394", "wc_admin_daily_wrapper", "complete", "2025-09-12 19:23:06", "2025-09-12 19:23:06", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757704986;s:18:\"\0*\0first_timestamp\";i:1755758222;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757704986;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-13 06:27:39", "2025-09-13 06:27:39", "174992", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2395", "woocommerce_cleanup_personal_data", "complete", "2025-09-12 19:23:07", "2025-09-12 19:23:07", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757704987;s:18:\"\0*\0first_timestamp\";i:1755758231;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757704987;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-13 06:27:40", "2025-09-13 06:27:40", "174992", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2396", "woocommerce_cleanup_logs", "complete", "2025-09-12 19:23:08", "2025-09-12 19:23:08", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757704988;s:18:\"\0*\0first_timestamp\";i:1755769021;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757704988;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-13 06:27:40", "2025-09-13 06:27:40", "174992", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2397", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-09-12 19:23:08", "2025-09-12 19:23:08", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757704988;s:18:\"\0*\0first_timestamp\";i:1755769022;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757704988;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-13 06:27:40", "2025-09-13 06:27:40", "174992", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2398", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-11 20:23:08", "2025-09-11 20:23:08", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757622188;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757622188;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-12 06:49:47", "2025-09-12 06:49:47", "174980", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2399", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-11 20:23:08", "2025-09-11 20:23:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757622188;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757622188;}", "12", "1", "2025-09-12 06:49:47", "2025-09-12 06:49:47", "174980", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2400", "generate_category_lookup_table_wrapper", "complete", "2025-09-11 19:23:18", "2025-09-11 19:23:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757618598;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757618598;}", "12", "1", "2025-09-11 19:29:19", "2025-09-11 19:29:19", "174978", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2401", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-12 19:23:08", "2025-09-12 19:23:08", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757704988;s:18:\"\0*\0first_timestamp\";i:1755758209;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757704988;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-09-13 06:27:40", "2025-09-13 06:27:40", "174992", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("2402", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-12 07:49:47", "2025-09-12 07:49:47", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757663387;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757663387;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-12 09:38:38", "2025-09-12 09:38:38", "174982", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2403", "woocommerce_refresh_order_count_cache", "complete", "2025-09-12 18:49:47", "2025-09-12 18:49:47", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757702987;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757702987;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-13 06:27:36", "2025-09-13 06:27:36", "174992", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2404", "woocommerce_cleanup_sessions", "complete", "2025-09-12 18:49:47", "2025-09-12 18:49:47", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757702987;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757702987;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-09-13 06:27:36", "2025-09-13 06:27:36", "174992", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2405", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-12 10:38:38", "2025-09-12 10:38:38", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757673518;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757673518;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-12 11:48:52", "2025-09-12 11:48:52", "174984", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2406", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-12 12:48:52", "2025-09-12 12:48:52", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757681332;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757681332;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-12 12:57:24", "2025-09-12 12:57:24", "174986", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2407", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-12 13:57:24", "2025-09-12 13:57:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757685444;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757685444;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-12 16:33:32", "2025-09-12 16:33:32", "174988", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2408", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-12 17:33:32", "2025-09-12 17:33:32", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757698412;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757698412;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-12 18:13:25", "2025-09-12 18:13:25", "174990", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2409", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-12 19:13:25", "2025-09-12 19:13:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757704405;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757704405;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-13 06:27:36", "2025-09-13 06:27:36", "174992", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2410", "woocommerce_refresh_order_count_cache", "complete", "2025-09-13 18:27:36", "2025-09-13 18:27:36", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757788056;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757788056;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-13 18:56:37", "2025-09-13 18:56:37", "174996", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2411", "woocommerce_cleanup_sessions", "complete", "2025-09-13 18:27:36", "2025-09-13 18:27:36", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757788056;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757788056;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-09-13 18:56:37", "2025-09-13 18:56:37", "174996", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2412", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-13 07:27:36", "2025-09-13 07:27:36", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757748456;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757748456;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-13 18:56:37", "2025-09-13 18:56:37", "174996", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2413", "woocommerce_cleanup_draft_orders", "complete", "2025-09-14 06:27:36", "2025-09-14 06:27:36", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757831256;s:18:\"\0*\0first_timestamp\";i:1668840681;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757831256;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-14 08:58:13", "2025-09-14 08:58:13", "174998", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2414", "woocommerce_scheduled_sales", "complete", "2025-09-14 06:27:36", "2025-09-14 06:27:36", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757831256;s:18:\"\0*\0first_timestamp\";i:1755820800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757831256;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-14 08:58:13", "2025-09-14 08:58:13", "174998", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2415", "wc_admin_daily_wrapper", "complete", "2025-09-14 06:27:39", "2025-09-14 06:27:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757831259;s:18:\"\0*\0first_timestamp\";i:1755758222;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757831259;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-14 08:58:15", "2025-09-14 08:58:15", "174998", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2416", "woocommerce_cleanup_personal_data", "complete", "2025-09-14 06:27:40", "2025-09-14 06:27:40", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757831260;s:18:\"\0*\0first_timestamp\";i:1755758231;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757831260;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-14 08:58:16", "2025-09-14 08:58:16", "174998", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2417", "woocommerce_cleanup_logs", "complete", "2025-09-14 06:27:40", "2025-09-14 06:27:40", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757831260;s:18:\"\0*\0first_timestamp\";i:1755769021;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757831260;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-14 08:58:16", "2025-09-14 08:58:16", "174998", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2418", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-09-14 06:27:40", "2025-09-14 06:27:40", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757831260;s:18:\"\0*\0first_timestamp\";i:1755769022;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757831260;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-14 08:58:16", "2025-09-14 08:58:16", "174998", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2419", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-13 07:27:40", "2025-09-13 07:27:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757748460;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757748460;}", "12", "1", "2025-09-13 18:56:37", "2025-09-13 18:56:37", "174996", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2420", "generate_category_lookup_table_wrapper", "complete", "2025-09-13 06:27:50", "2025-09-13 06:27:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757744870;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757744870;}", "12", "1", "2025-09-13 07:21:12", "2025-09-13 07:21:12", "174994", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2421", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-14 06:27:40", "2025-09-14 06:27:40", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757831260;s:18:\"\0*\0first_timestamp\";i:1755758209;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757831260;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-09-14 08:58:16", "2025-09-14 08:58:16", "174998", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("2422", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-13 19:56:37", "2025-09-13 19:56:37", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757793397;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757793397;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-14 08:58:13", "2025-09-14 08:58:13", "174998", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2423", "woocommerce_refresh_order_count_cache", "complete", "2025-09-14 06:56:37", "2025-09-14 06:56:37", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757832997;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757832997;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-14 08:58:16", "2025-09-14 08:58:16", "174998", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2424", "woocommerce_cleanup_sessions", "complete", "2025-09-14 06:56:37", "2025-09-14 06:56:37", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757832997;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757832997;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-09-14 08:58:16", "2025-09-14 08:58:16", "174998", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2425", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-14 09:58:13", "2025-09-14 09:58:13", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757843893;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757843893;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-14 14:12:07", "2025-09-14 14:12:07", "175002", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2426", "woocommerce_cleanup_draft_orders", "complete", "2025-09-15 08:58:13", "2025-09-15 08:58:13", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757926693;s:18:\"\0*\0first_timestamp\";i:1668840681;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757926693;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-15 14:33:01", "2025-09-15 14:33:01", "175010", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2427", "woocommerce_scheduled_sales", "complete", "2025-09-15 08:58:13", "2025-09-15 08:58:13", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757926693;s:18:\"\0*\0first_timestamp\";i:1755820800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757926693;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-15 14:33:01", "2025-09-15 14:33:01", "175010", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2428", "wc_admin_daily_wrapper", "complete", "2025-09-15 08:58:15", "2025-09-15 08:58:15", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757926695;s:18:\"\0*\0first_timestamp\";i:1755758222;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757926695;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-15 14:33:03", "2025-09-15 14:33:03", "175010", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2429", "woocommerce_cleanup_personal_data", "complete", "2025-09-15 08:58:16", "2025-09-15 08:58:16", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757926696;s:18:\"\0*\0first_timestamp\";i:1755758231;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757926696;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-15 14:33:05", "2025-09-15 14:33:05", "175010", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2430", "woocommerce_cleanup_logs", "complete", "2025-09-15 08:58:16", "2025-09-15 08:58:16", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757926696;s:18:\"\0*\0first_timestamp\";i:1755769021;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757926696;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-15 14:33:05", "2025-09-15 14:33:05", "175010", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2431", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-09-15 08:58:16", "2025-09-15 08:58:16", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757926696;s:18:\"\0*\0first_timestamp\";i:1755769022;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757926696;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-15 14:33:05", "2025-09-15 14:33:05", "175010", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2432", "woocommerce_refresh_order_count_cache", "complete", "2025-09-14 20:58:16", "2025-09-14 20:58:16", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757883496;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757883496;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-15 07:15:33", "2025-09-15 07:15:33", "175006", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2433", "woocommerce_cleanup_sessions", "complete", "2025-09-14 20:58:16", "2025-09-14 20:58:16", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757883496;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757883496;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-09-15 07:15:33", "2025-09-15 07:15:33", "175006", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2434", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-14 09:58:16", "2025-09-14 09:58:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757843896;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757843896;}", "12", "1", "2025-09-14 14:12:07", "2025-09-14 14:12:07", "175002", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2435", "generate_category_lookup_table_wrapper", "complete", "2025-09-14 08:58:26", "2025-09-14 08:58:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757840306;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757840306;}", "12", "1", "2025-09-14 08:59:20", "2025-09-14 08:59:20", "175000", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2436", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-15 08:58:16", "2025-09-15 08:58:16", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757926696;s:18:\"\0*\0first_timestamp\";i:1755758209;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757926696;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-09-15 14:33:05", "2025-09-15 14:33:05", "175010", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("2437", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-14 15:12:07", "2025-09-14 15:12:07", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757862727;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757862727;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-14 18:37:58", "2025-09-14 18:37:58", "175004", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2438", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-14 19:37:58", "2025-09-14 19:37:58", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757878678;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757878678;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-15 07:15:33", "2025-09-15 07:15:33", "175006", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2439", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-15 08:15:33", "2025-09-15 08:15:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757924133;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757924133;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-15 08:21:25", "2025-09-15 08:21:25", "175008", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2440", "woocommerce_refresh_order_count_cache", "complete", "2025-09-15 19:15:33", "2025-09-15 19:15:33", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757963733;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757963733;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-15 22:03:10", "2025-09-15 22:03:10", "175014", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2441", "woocommerce_cleanup_sessions", "complete", "2025-09-15 19:15:33", "2025-09-15 19:15:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757963733;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757963733;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-09-15 22:03:10", "2025-09-15 22:03:10", "175014", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2442", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-15 09:21:25", "2025-09-15 09:21:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757928085;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757928085;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-15 14:33:05", "2025-09-15 14:33:05", "175010", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2443", "woocommerce_cleanup_draft_orders", "complete", "2025-09-16 14:33:01", "2025-09-16 14:33:01", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758033181;s:18:\"\0*\0first_timestamp\";i:1668840681;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758033181;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-16 20:42:49", "2025-09-16 20:42:49", "175020", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2444", "woocommerce_scheduled_sales", "complete", "2025-09-16 14:33:01", "2025-09-16 14:33:01", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758033181;s:18:\"\0*\0first_timestamp\";i:1755820800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758033181;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-16 20:42:49", "2025-09-16 20:42:49", "175020", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2445", "wc_admin_daily_wrapper", "complete", "2025-09-16 14:33:03", "2025-09-16 14:33:03", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758033183;s:18:\"\0*\0first_timestamp\";i:1755758222;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758033183;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-16 20:42:52", "2025-09-16 20:42:52", "175020", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2446", "woocommerce_cleanup_personal_data", "complete", "2025-09-16 14:33:05", "2025-09-16 14:33:05", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758033185;s:18:\"\0*\0first_timestamp\";i:1755758231;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758033185;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-16 20:42:53", "2025-09-16 20:42:53", "175020", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2447", "woocommerce_cleanup_logs", "complete", "2025-09-16 14:33:05", "2025-09-16 14:33:05", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758033185;s:18:\"\0*\0first_timestamp\";i:1755769021;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758033185;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-16 20:42:53", "2025-09-16 20:42:53", "175020", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2448", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-09-16 14:33:05", "2025-09-16 14:33:05", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758033185;s:18:\"\0*\0first_timestamp\";i:1755769022;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758033185;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-16 20:42:53", "2025-09-16 20:42:53", "175020", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2449", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-15 15:33:05", "2025-09-15 15:33:05", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757950385;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757950385;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-15 16:13:35", "2025-09-15 16:13:35", "175012", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2450", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-15 15:33:05", "2025-09-15 15:33:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757950385;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757950385;}", "12", "1", "2025-09-15 16:13:35", "2025-09-15 16:13:35", "175012", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2451", "generate_category_lookup_table_wrapper", "complete", "2025-09-15 14:33:15", "2025-09-15 14:33:15", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1757946795;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1757946795;}", "12", "1", "2025-09-15 16:13:35", "2025-09-15 16:13:35", "175012", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2452", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-16 14:33:05", "2025-09-16 14:33:05", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758033185;s:18:\"\0*\0first_timestamp\";i:1755758209;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758033185;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-09-16 20:42:53", "2025-09-16 20:42:53", "175020", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("2453", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-15 17:13:35", "2025-09-15 17:13:35", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757956415;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757956415;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-15 22:03:10", "2025-09-15 22:03:10", "175014", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2454", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-15 23:03:10", "2025-09-15 23:03:10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757977390;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757977390;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-16 03:22:09", "2025-09-16 03:22:09", "175016", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2455", "woocommerce_refresh_order_count_cache", "complete", "2025-09-16 10:03:10", "2025-09-16 10:03:10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758016990;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758016990;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-16 20:42:49", "2025-09-16 20:42:49", "175020", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2456", "woocommerce_cleanup_sessions", "complete", "2025-09-16 10:03:10", "2025-09-16 10:03:10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758016990;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758016990;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-09-16 20:42:49", "2025-09-16 20:42:49", "175020", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2457", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-16 04:22:09", "2025-09-16 04:22:09", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1757996529;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1757996529;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-16 09:29:15", "2025-09-16 09:29:15", "175018", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2458", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-16 10:29:16", "2025-09-16 10:29:16", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758018556;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758018556;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-16 20:42:49", "2025-09-16 20:42:49", "175020", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2459", "woocommerce_refresh_order_count_cache", "complete", "2025-09-17 08:42:49", "2025-09-17 08:42:49", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758098569;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758098569;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-17 10:55:13", "2025-09-17 10:55:13", "175030", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2460", "woocommerce_cleanup_sessions", "complete", "2025-09-17 08:42:49", "2025-09-17 08:42:49", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758098569;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758098569;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-09-17 10:55:13", "2025-09-17 10:55:13", "175030", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2461", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-16 21:42:49", "2025-09-16 21:42:49", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758058969;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758058969;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-17 01:15:27", "2025-09-17 01:15:27", "175022", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2462", "woocommerce_cleanup_draft_orders", "complete", "2025-09-17 20:42:49", "2025-09-17 20:42:49", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758141769;s:18:\"\0*\0first_timestamp\";i:1668840681;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758141769;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-18 07:42:36", "2025-09-18 07:42:36", "175046", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2463", "woocommerce_scheduled_sales", "complete", "2025-09-17 20:42:49", "2025-09-17 20:42:49", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758141769;s:18:\"\0*\0first_timestamp\";i:1755820800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758141769;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-18 07:42:36", "2025-09-18 07:42:36", "175046", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2464", "wc_admin_daily_wrapper", "complete", "2025-09-17 20:42:52", "2025-09-17 20:42:52", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758141772;s:18:\"\0*\0first_timestamp\";i:1755758222;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758141772;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-18 07:42:38", "2025-09-18 07:42:38", "175046", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2465", "woocommerce_cleanup_personal_data", "complete", "2025-09-17 20:42:53", "2025-09-17 20:42:53", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758141773;s:18:\"\0*\0first_timestamp\";i:1755758231;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758141773;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-18 07:42:39", "2025-09-18 07:42:39", "175046", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2466", "woocommerce_cleanup_logs", "complete", "2025-09-17 20:42:53", "2025-09-17 20:42:53", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758141773;s:18:\"\0*\0first_timestamp\";i:1755769021;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758141773;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-18 07:42:40", "2025-09-18 07:42:40", "175046", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2467", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-09-17 20:42:53", "2025-09-17 20:42:53", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758141773;s:18:\"\0*\0first_timestamp\";i:1755769022;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758141773;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-18 07:42:40", "2025-09-18 07:42:40", "175046", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2468", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-16 21:42:53", "2025-09-16 21:42:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758058973;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758058973;}", "12", "1", "2025-09-17 01:15:27", "2025-09-17 01:15:27", "175022", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2469", "generate_category_lookup_table_wrapper", "complete", "2025-09-16 20:43:03", "2025-09-16 20:43:03", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758055383;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758055383;}", "12", "1", "2025-09-17 01:15:27", "2025-09-17 01:15:27", "175022", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2470", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-17 20:42:53", "2025-09-17 20:42:53", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758141773;s:18:\"\0*\0first_timestamp\";i:1755758209;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758141773;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-09-18 07:42:40", "2025-09-18 07:42:40", "175046", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("2471", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-17 02:15:27", "2025-09-17 02:15:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758075327;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758075327;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-17 02:15:38", "2025-09-17 02:15:38", "175024", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2472", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-17 03:15:38", "2025-09-17 03:15:38", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758078938;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758078938;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-17 03:20:29", "2025-09-17 03:20:29", "175026", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2473", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-17 04:20:29", "2025-09-17 04:20:29", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758082829;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758082829;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-17 04:45:10", "2025-09-17 04:45:10", "175028", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2474", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-17 05:45:10", "2025-09-17 05:45:10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758087910;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758087910;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-17 10:55:13", "2025-09-17 10:55:13", "175030", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2475", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-17 11:55:13", "2025-09-17 11:55:13", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758110113;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758110113;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-17 11:56:24", "2025-09-17 11:56:24", "175038", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2476", "woocommerce_refresh_order_count_cache", "complete", "2025-09-17 22:55:13", "2025-09-17 22:55:13", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758149713;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758149713;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-18 07:42:40", "2025-09-18 07:42:40", "175046", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2477", "woocommerce_cleanup_sessions", "complete", "2025-09-17 22:55:13", "2025-09-17 22:55:13", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758149713;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758149713;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-09-18 07:42:40", "2025-09-18 07:42:40", "175046", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2478", "fetch_patterns", "complete", "2025-09-17 11:06:19", "2025-09-17 11:06:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758107179;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758107179;}", "5", "1", "2025-09-17 11:06:52", "2025-09-17 11:06:52", "175032", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2479", "woocommerce_run_on_woocommerce_admin_updated", "complete", "2025-09-17 11:06:29", "2025-09-17 11:06:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758107189;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758107189;}", "4", "1", "2025-09-17 11:06:53", "2025-09-17 11:06:53", "175032", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2480", "action_scheduler/migration_hook", "complete", "2025-09-17 11:13:24", "2025-09-17 11:13:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758107604;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758107604;}", "1", "1", "2025-09-17 11:13:43", "2025-09-17 11:13:43", "175034", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2481", "action_scheduler/migration_hook", "failed", "2025-09-17 11:14:43", "2025-09-17 11:14:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758107683;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758107683;}", "1", "1", "2025-09-17 11:14:49", "2025-09-17 11:14:49", "175036", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2482", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-17 12:56:24", "2025-09-17 12:56:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758113784;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758113784;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-17 13:19:39", "2025-09-17 13:19:39", "175040", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2483", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-17 14:19:39", "2025-09-17 14:19:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758118779;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758118779;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-17 14:47:11", "2025-09-17 14:47:11", "175042", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2484", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-17 15:47:11", "2025-09-17 15:47:11", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758124031;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758124031;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-17 18:34:52", "2025-09-17 18:34:52", "175044", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2485", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-17 19:34:52", "2025-09-17 19:34:52", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758137692;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758137692;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-18 07:42:36", "2025-09-18 07:42:36", "175046", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2486", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-18 08:42:36", "2025-09-18 08:42:36", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758184956;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758184956;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-18 11:15:21", "2025-09-18 11:15:21", "175050", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2487", "woocommerce_cleanup_draft_orders", "complete", "2025-09-19 07:42:36", "2025-09-19 07:42:36", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758267756;s:18:\"\0*\0first_timestamp\";i:1668840681;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758267756;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-19 19:30:56", "2025-09-19 19:30:56", "175068", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2488", "woocommerce_scheduled_sales", "complete", "2025-09-19 07:42:36", "2025-09-19 07:42:36", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758267756;s:18:\"\0*\0first_timestamp\";i:1755820800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758267756;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-19 19:30:56", "2025-09-19 19:30:56", "175068", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2489", "wc_admin_daily_wrapper", "complete", "2025-09-19 07:42:38", "2025-09-19 07:42:38", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758267758;s:18:\"\0*\0first_timestamp\";i:1755758222;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758267758;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-19 19:30:58", "2025-09-19 19:30:58", "175068", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2490", "woocommerce_cleanup_personal_data", "complete", "2025-09-19 07:42:39", "2025-09-19 07:42:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758267759;s:18:\"\0*\0first_timestamp\";i:1755758231;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758267759;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-19 19:30:59", "2025-09-19 19:30:59", "175068", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2491", "woocommerce_cleanup_logs", "complete", "2025-09-19 07:42:40", "2025-09-19 07:42:40", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758267760;s:18:\"\0*\0first_timestamp\";i:1755769021;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758267760;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-19 19:30:59", "2025-09-19 19:30:59", "175068", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2492", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-09-19 07:42:40", "2025-09-19 07:42:40", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758267760;s:18:\"\0*\0first_timestamp\";i:1755769022;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758267760;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-19 19:30:59", "2025-09-19 19:30:59", "175068", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2493", "woocommerce_refresh_order_count_cache", "complete", "2025-09-18 19:42:40", "2025-09-18 19:42:40", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758224560;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758224560;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-18 19:51:43", "2025-09-18 19:51:43", "175060", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2494", "woocommerce_cleanup_sessions", "complete", "2025-09-18 19:42:40", "2025-09-18 19:42:40", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758224560;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758224560;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-09-18 19:51:43", "2025-09-18 19:51:43", "175060", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2495", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-18 08:42:40", "2025-09-18 08:42:40", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758184960;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758184960;}", "12", "1", "2025-09-18 11:15:21", "2025-09-18 11:15:21", "175050", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2496", "generate_category_lookup_table_wrapper", "complete", "2025-09-18 07:42:50", "2025-09-18 07:42:50", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758181370;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758181370;}", "12", "1", "2025-09-18 07:44:05", "2025-09-18 07:44:05", "175048", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2497", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-19 07:42:40", "2025-09-19 07:42:40", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758267760;s:18:\"\0*\0first_timestamp\";i:1755758209;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758267760;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-09-19 19:30:59", "2025-09-19 19:30:59", "175068", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("2498", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-18 12:15:21", "2025-09-18 12:15:21", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758197721;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758197721;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-18 13:10:14", "2025-09-18 13:10:14", "175052", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2499", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-18 12:15:21", "2025-09-18 12:15:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758197721;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758197721;}", "12", "1", "2025-09-18 13:10:14", "2025-09-18 13:10:14", "175052", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2500", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-18 14:10:14", "2025-09-18 14:10:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758204614;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758204614;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-18 15:11:06", "2025-09-18 15:11:06", "175054", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2501", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-18 14:10:14", "2025-09-18 14:10:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758204614;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758204614;}", "12", "1", "2025-09-18 15:11:06", "2025-09-18 15:11:06", "175054", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2502", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-18 16:11:06", "2025-09-18 16:11:06", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758211866;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758211866;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-18 17:00:53", "2025-09-18 17:00:53", "175056", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2503", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-18 16:11:06", "2025-09-18 16:11:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758211866;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758211866;}", "12", "1", "2025-09-18 17:00:53", "2025-09-18 17:00:53", "175056", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2504", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-18 18:00:53", "2025-09-18 18:00:53", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758218453;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758218453;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-18 19:22:30", "2025-09-18 19:22:30", "175058", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2505", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-18 18:00:53", "2025-09-18 18:00:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758218453;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758218453;}", "12", "1", "2025-09-18 19:22:30", "2025-09-18 19:22:30", "175058", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2506", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-18 20:22:30", "2025-09-18 20:22:30", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758226950;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758226950;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-19 01:17:10", "2025-09-19 01:17:10", "175062", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2507", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-18 20:22:30", "2025-09-18 20:22:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758226950;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758226950;}", "12", "1", "2025-09-19 01:17:10", "2025-09-19 01:17:10", "175062", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2508", "woocommerce_refresh_order_count_cache", "complete", "2025-09-19 07:51:43", "2025-09-19 07:51:43", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758268303;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758268303;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-19 19:30:59", "2025-09-19 19:30:59", "175068", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2509", "woocommerce_cleanup_sessions", "complete", "2025-09-19 07:51:43", "2025-09-19 07:51:43", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758268303;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758268303;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-09-19 19:30:59", "2025-09-19 19:30:59", "175068", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2510", "wc-admin_import_orders", "complete", "2025-09-18 19:59:24", "2025-09-18 19:59:24", "[5411]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758225564;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758225564;}", "3", "1", "2025-09-19 01:17:10", "2025-09-19 01:17:10", "175062", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2511", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-19 02:17:10", "2025-09-19 02:17:10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758248230;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758248230;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-19 05:08:18", "2025-09-19 05:08:18", "175064", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2512", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-19 02:17:10", "2025-09-19 02:17:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758248230;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758248230;}", "12", "1", "2025-09-19 05:08:18", "2025-09-19 05:08:18", "175064", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2513", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-19 06:08:18", "2025-09-19 06:08:18", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758262098;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758262098;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-19 06:26:24", "2025-09-19 06:26:24", "175066", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2514", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-19 06:08:18", "2025-09-19 06:08:18", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758262098;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758262098;}", "12", "1", "2025-09-19 06:26:24", "2025-09-19 06:26:24", "175066", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2515", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-19 07:26:24", "2025-09-19 07:26:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758266784;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758266784;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-19 19:30:56", "2025-09-19 19:30:56", "175068", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2516", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-19 07:26:24", "2025-09-19 07:26:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758266784;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758266784;}", "12", "1", "2025-09-19 19:30:56", "2025-09-19 19:30:56", "175068", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2517", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-19 20:30:56", "2025-09-19 20:30:56", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758313856;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758313856;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-19 22:26:42", "2025-09-19 22:26:42", "175072", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2518", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-19 20:30:56", "2025-09-19 20:30:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758313856;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758313856;}", "12", "1", "2025-09-19 22:26:42", "2025-09-19 22:26:42", "175072", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2519", "woocommerce_cleanup_draft_orders", "complete", "2025-09-20 19:30:56", "2025-09-20 19:30:56", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758396656;s:18:\"\0*\0first_timestamp\";i:1668840681;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758396656;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-21 03:28:20", "2025-09-21 03:28:20", "175086", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2520", "woocommerce_scheduled_sales", "complete", "2025-09-20 19:30:56", "2025-09-20 19:30:56", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758396656;s:18:\"\0*\0first_timestamp\";i:1755820800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758396656;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-21 03:28:20", "2025-09-21 03:28:20", "175086", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2521", "wc_admin_daily_wrapper", "complete", "2025-09-20 19:30:58", "2025-09-20 19:30:58", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758396658;s:18:\"\0*\0first_timestamp\";i:1755758222;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758396658;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-21 03:28:22", "2025-09-21 03:28:22", "175086", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2522", "woocommerce_cleanup_personal_data", "complete", "2025-09-20 19:30:59", "2025-09-20 19:30:59", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758396659;s:18:\"\0*\0first_timestamp\";i:1755758231;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758396659;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-21 03:28:23", "2025-09-21 03:28:23", "175086", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2523", "woocommerce_cleanup_logs", "complete", "2025-09-20 19:30:59", "2025-09-20 19:30:59", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758396659;s:18:\"\0*\0first_timestamp\";i:1755769021;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758396659;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-21 03:28:24", "2025-09-21 03:28:24", "175086", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2524", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-09-20 19:30:59", "2025-09-20 19:30:59", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758396659;s:18:\"\0*\0first_timestamp\";i:1755769022;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758396659;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-21 03:28:24", "2025-09-21 03:28:24", "175086", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2525", "woocommerce_refresh_order_count_cache", "complete", "2025-09-20 07:30:59", "2025-09-20 07:30:59", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758353459;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758353459;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-20 09:46:14", "2025-09-20 09:46:14", "175080", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2526", "woocommerce_cleanup_sessions", "complete", "2025-09-20 07:30:59", "2025-09-20 07:30:59", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758353459;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758353459;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-09-20 09:46:14", "2025-09-20 09:46:14", "175080", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2527", "generate_category_lookup_table_wrapper", "complete", "2025-09-19 19:31:09", "2025-09-19 19:31:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758310269;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758310269;}", "12", "1", "2025-09-19 19:40:39", "2025-09-19 19:40:39", "175070", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2528", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-20 19:30:59", "2025-09-20 19:30:59", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758396659;s:18:\"\0*\0first_timestamp\";i:1755758209;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758396659;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-09-21 03:28:24", "2025-09-21 03:28:24", "175086", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("2529", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-19 23:26:42", "2025-09-19 23:26:42", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758324402;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758324402;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-20 00:13:11", "2025-09-20 00:13:11", "175074", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2530", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-19 23:26:42", "2025-09-19 23:26:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758324402;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758324402;}", "12", "1", "2025-09-20 00:13:11", "2025-09-20 00:13:11", "175074", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2531", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-20 01:13:11", "2025-09-20 01:13:11", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758330791;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758330791;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-20 04:30:38", "2025-09-20 04:30:38", "175076", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2532", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-20 01:13:11", "2025-09-20 01:13:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758330791;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758330791;}", "12", "1", "2025-09-20 04:30:38", "2025-09-20 04:30:38", "175076", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2533", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-20 05:30:38", "2025-09-20 05:30:38", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758346238;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758346238;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-20 07:10:33", "2025-09-20 07:10:33", "175078", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2534", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-20 05:30:38", "2025-09-20 05:30:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758346238;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758346238;}", "12", "1", "2025-09-20 07:10:33", "2025-09-20 07:10:33", "175078", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2535", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-20 08:10:33", "2025-09-20 08:10:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758355833;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758355833;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-20 09:46:14", "2025-09-20 09:46:14", "175080", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2536", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-20 08:10:33", "2025-09-20 08:10:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758355833;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758355833;}", "12", "1", "2025-09-20 09:46:14", "2025-09-20 09:46:14", "175080", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2537", "woocommerce_refresh_order_count_cache", "complete", "2025-09-20 21:46:14", "2025-09-20 21:46:14", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758404774;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758404774;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-21 03:28:24", "2025-09-21 03:28:24", "175086", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2538", "woocommerce_cleanup_sessions", "complete", "2025-09-20 21:46:14", "2025-09-20 21:46:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758404774;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758404774;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-09-21 03:28:24", "2025-09-21 03:28:24", "175086", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2539", "woocommerce_geoip_updater", "complete", "2025-10-05 09:46:14", "2025-10-05 09:46:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759657574;s:18:\"\0*\0first_timestamp\";i:1755758282;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759657574;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}", "12", "1", "2025-10-05 14:47:44", "2025-10-05 14:47:44", "175248", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2540", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-20 10:46:14", "2025-09-20 10:46:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758365174;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758365174;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-20 16:13:37", "2025-09-20 16:13:37", "175082", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2541", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-20 10:46:14", "2025-09-20 10:46:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758365174;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758365174;}", "12", "1", "2025-09-20 16:13:37", "2025-09-20 16:13:37", "175082", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2542", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-20 17:13:37", "2025-09-20 17:13:37", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758388417;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758388417;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-20 18:07:38", "2025-09-20 18:07:38", "175084", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2543", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-20 17:13:37", "2025-09-20 17:13:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758388417;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758388417;}", "12", "1", "2025-09-20 18:07:38", "2025-09-20 18:07:38", "175084", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2544", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-20 19:07:38", "2025-09-20 19:07:38", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758395258;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758395258;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-21 03:28:20", "2025-09-21 03:28:20", "175086", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2545", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-20 19:07:38", "2025-09-20 19:07:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758395258;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758395258;}", "12", "1", "2025-09-21 03:28:20", "2025-09-21 03:28:20", "175086", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2546", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-21 04:28:20", "2025-09-21 04:28:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758428900;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758428900;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-21 06:11:55", "2025-09-21 06:11:55", "175088", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2547", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-21 04:28:20", "2025-09-21 04:28:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758428900;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758428900;}", "12", "1", "2025-09-21 06:11:55", "2025-09-21 06:11:55", "175088", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2548", "woocommerce_cleanup_draft_orders", "complete", "2025-09-22 03:28:20", "2025-09-22 03:28:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758511700;s:18:\"\0*\0first_timestamp\";i:1668840681;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758511700;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-22 05:08:41", "2025-09-22 05:08:41", "175102", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2549", "woocommerce_scheduled_sales", "complete", "2025-09-22 03:28:20", "2025-09-22 03:28:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758511700;s:18:\"\0*\0first_timestamp\";i:1755820800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758511700;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-22 05:08:41", "2025-09-22 05:08:41", "175102", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2550", "wc_admin_daily_wrapper", "complete", "2025-09-22 03:28:22", "2025-09-22 03:28:22", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758511702;s:18:\"\0*\0first_timestamp\";i:1755758222;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758511702;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-22 05:08:43", "2025-09-22 05:08:43", "175102", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2551", "woocommerce_cleanup_personal_data", "complete", "2025-09-22 03:28:23", "2025-09-22 03:28:23", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758511703;s:18:\"\0*\0first_timestamp\";i:1755758231;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758511703;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-22 05:08:44", "2025-09-22 05:08:44", "175102", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2552", "woocommerce_cleanup_logs", "complete", "2025-09-22 03:28:24", "2025-09-22 03:28:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758511704;s:18:\"\0*\0first_timestamp\";i:1755769021;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758511704;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-22 05:08:44", "2025-09-22 05:08:44", "175102", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2553", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-09-22 03:28:24", "2025-09-22 03:28:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758511704;s:18:\"\0*\0first_timestamp\";i:1755769022;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758511704;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-22 05:08:44", "2025-09-22 05:08:44", "175102", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2554", "woocommerce_refresh_order_count_cache", "complete", "2025-09-21 15:28:24", "2025-09-21 15:28:24", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758468504;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758468504;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-21 17:51:16", "2025-09-21 17:51:16", "175098", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2555", "woocommerce_cleanup_sessions", "complete", "2025-09-21 15:28:24", "2025-09-21 15:28:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758468504;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758468504;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-09-21 17:51:16", "2025-09-21 17:51:16", "175098", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2556", "generate_category_lookup_table_wrapper", "complete", "2025-09-21 03:28:34", "2025-09-21 03:28:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758425314;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758425314;}", "12", "1", "2025-09-21 06:11:55", "2025-09-21 06:11:55", "175088", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2557", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-22 03:28:24", "2025-09-22 03:28:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758511704;s:18:\"\0*\0first_timestamp\";i:1755758209;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758511704;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-09-22 05:08:44", "2025-09-22 05:08:44", "175102", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("2558", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-21 07:11:55", "2025-09-21 07:11:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758438715;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758438715;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-21 08:02:48", "2025-09-21 08:02:48", "175090", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2559", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-21 07:11:55", "2025-09-21 07:11:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758438715;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758438715;}", "12", "1", "2025-09-21 08:02:48", "2025-09-21 08:02:48", "175090", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2560", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-21 09:02:48", "2025-09-21 09:02:48", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758445368;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758445368;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-21 10:36:58", "2025-09-21 10:36:58", "175092", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2561", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-21 09:02:48", "2025-09-21 09:02:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758445368;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758445368;}", "12", "1", "2025-09-21 10:36:58", "2025-09-21 10:36:58", "175092", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2562", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-21 11:36:58", "2025-09-21 11:36:58", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758454618;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758454618;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-21 11:39:21", "2025-09-21 11:39:21", "175094", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2563", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-21 11:36:58", "2025-09-21 11:36:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758454618;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758454618;}", "12", "1", "2025-09-21 11:39:21", "2025-09-21 11:39:21", "175094", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2564", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-21 12:39:21", "2025-09-21 12:39:21", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758458361;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758458361;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-21 13:39:05", "2025-09-21 13:39:05", "175096", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2565", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-21 12:39:21", "2025-09-21 12:39:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758458361;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758458361;}", "12", "1", "2025-09-21 13:39:05", "2025-09-21 13:39:05", "175096", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2566", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-21 14:39:05", "2025-09-21 14:39:05", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758465545;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758465545;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-21 17:51:16", "2025-09-21 17:51:16", "175098", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2567", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-21 14:39:05", "2025-09-21 14:39:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758465545;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758465545;}", "12", "1", "2025-09-21 17:51:16", "2025-09-21 17:51:16", "175098", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2568", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-21 18:51:16", "2025-09-21 18:51:16", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758480676;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758480676;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-21 20:03:33", "2025-09-21 20:03:33", "175100", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2569", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-21 18:51:16", "2025-09-21 18:51:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758480676;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758480676;}", "12", "1", "2025-09-21 20:03:33", "2025-09-21 20:03:33", "175100", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2570", "woocommerce_refresh_order_count_cache", "complete", "2025-09-22 05:51:16", "2025-09-22 05:51:16", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758520276;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758520276;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-22 08:14:10", "2025-09-22 08:14:10", "175104", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2571", "woocommerce_cleanup_sessions", "complete", "2025-09-22 05:51:16", "2025-09-22 05:51:16", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758520276;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758520276;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-09-22 08:14:10", "2025-09-22 08:14:10", "175104", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2572", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-21 21:03:33", "2025-09-21 21:03:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758488613;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758488613;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-22 05:08:41", "2025-09-22 05:08:41", "175102", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2573", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-21 21:03:33", "2025-09-21 21:03:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758488613;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758488613;}", "12", "1", "2025-09-22 05:08:41", "2025-09-22 05:08:41", "175102", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2574", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-22 06:08:41", "2025-09-22 06:08:41", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758521321;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758521321;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-22 08:14:10", "2025-09-22 08:14:10", "175104", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2575", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-22 06:08:41", "2025-09-22 06:08:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758521321;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758521321;}", "12", "1", "2025-09-22 08:14:10", "2025-09-22 08:14:10", "175104", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2576", "woocommerce_cleanup_draft_orders", "complete", "2025-09-23 05:08:41", "2025-09-23 05:08:41", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758604121;s:18:\"\0*\0first_timestamp\";i:1668840681;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758604121;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-23 09:13:20", "2025-09-23 09:13:20", "175124", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2577", "woocommerce_scheduled_sales", "complete", "2025-09-23 05:08:41", "2025-09-23 05:08:41", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758604121;s:18:\"\0*\0first_timestamp\";i:1755820800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758604121;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-23 09:13:20", "2025-09-23 09:13:20", "175124", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2578", "wc_admin_daily_wrapper", "complete", "2025-09-23 05:08:43", "2025-09-23 05:08:43", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758604123;s:18:\"\0*\0first_timestamp\";i:1755758222;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758604123;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-23 09:13:23", "2025-09-23 09:13:23", "175124", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2579", "woocommerce_cleanup_personal_data", "complete", "2025-09-23 05:08:44", "2025-09-23 05:08:44", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758604124;s:18:\"\0*\0first_timestamp\";i:1755758231;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758604124;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-23 09:13:24", "2025-09-23 09:13:24", "175124", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2580", "woocommerce_cleanup_logs", "complete", "2025-09-23 05:08:44", "2025-09-23 05:08:44", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758604124;s:18:\"\0*\0first_timestamp\";i:1755769021;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758604124;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-23 09:13:24", "2025-09-23 09:13:24", "175124", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2581", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-09-23 05:08:44", "2025-09-23 05:08:44", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758604124;s:18:\"\0*\0first_timestamp\";i:1755769022;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758604124;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-23 09:13:24", "2025-09-23 09:13:24", "175124", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2582", "generate_category_lookup_table_wrapper", "complete", "2025-09-22 05:08:54", "2025-09-22 05:08:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758517734;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758517734;}", "12", "1", "2025-09-22 08:14:10", "2025-09-22 08:14:10", "175104", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2583", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-23 05:08:44", "2025-09-23 05:08:44", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758604124;s:18:\"\0*\0first_timestamp\";i:1755758209;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758604124;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-09-23 09:13:24", "2025-09-23 09:13:24", "175124", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("2584", "woocommerce_refresh_order_count_cache", "complete", "2025-09-22 20:14:10", "2025-09-22 20:14:10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758572050;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758572050;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-22 21:19:06", "2025-09-22 21:19:06", "175120", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2585", "woocommerce_cleanup_sessions", "complete", "2025-09-22 20:14:10", "2025-09-22 20:14:10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758572050;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758572050;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-09-22 21:19:06", "2025-09-22 21:19:06", "175120", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2586", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-22 09:14:10", "2025-09-22 09:14:10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758532450;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758532450;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-22 09:59:14", "2025-09-22 09:59:14", "175106", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2587", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-22 09:14:10", "2025-09-22 09:14:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758532450;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758532450;}", "12", "1", "2025-09-22 09:59:14", "2025-09-22 09:59:14", "175106", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2588", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-22 10:59:14", "2025-09-22 10:59:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758538754;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758538754;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-22 11:22:23", "2025-09-22 11:22:23", "175108", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2589", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-22 10:59:14", "2025-09-22 10:59:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758538754;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758538754;}", "12", "1", "2025-09-22 11:22:23", "2025-09-22 11:22:23", "175108", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2590", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-22 12:22:23", "2025-09-22 12:22:23", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758543743;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758543743;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-22 12:54:47", "2025-09-22 12:54:47", "175110", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2591", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-22 12:22:23", "2025-09-22 12:22:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758543743;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758543743;}", "12", "1", "2025-09-22 12:54:47", "2025-09-22 12:54:47", "175110", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2592", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-22 13:54:47", "2025-09-22 13:54:47", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758549287;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758549287;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-22 14:21:14", "2025-09-22 14:21:14", "175112", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2593", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-22 13:54:47", "2025-09-22 13:54:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758549287;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758549287;}", "12", "1", "2025-09-22 14:21:14", "2025-09-22 14:21:14", "175112", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2594", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-22 15:21:14", "2025-09-22 15:21:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758554474;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758554474;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-22 15:23:46", "2025-09-22 15:23:46", "175114", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2595", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-22 15:21:14", "2025-09-22 15:21:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758554474;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758554474;}", "12", "1", "2025-09-22 15:23:46", "2025-09-22 15:23:46", "175114", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2596", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-22 16:23:46", "2025-09-22 16:23:46", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758558226;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758558226;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-22 17:56:04", "2025-09-22 17:56:04", "175116", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2597", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-22 16:23:46", "2025-09-22 16:23:46", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758558226;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758558226;}", "12", "1", "2025-09-22 17:56:04", "2025-09-22 17:56:04", "175116", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2598", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-22 18:56:04", "2025-09-22 18:56:04", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758567364;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758567364;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-22 19:22:57", "2025-09-22 19:22:57", "175118", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2599", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-22 18:56:04", "2025-09-22 18:56:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758567364;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758567364;}", "12", "1", "2025-09-22 19:22:57", "2025-09-22 19:22:57", "175118", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2600", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-22 20:22:57", "2025-09-22 20:22:57", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758572577;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758572577;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-22 21:19:06", "2025-09-22 21:19:06", "175120", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2601", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-22 20:22:57", "2025-09-22 20:22:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758572577;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758572577;}", "12", "1", "2025-09-22 21:19:06", "2025-09-22 21:19:06", "175120", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2602", "woocommerce_refresh_order_count_cache", "complete", "2025-09-23 09:19:06", "2025-09-23 09:19:06", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758619146;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758619146;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-24 03:43:59", "2025-09-24 03:43:59", "175126", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2603", "woocommerce_cleanup_sessions", "complete", "2025-09-23 09:19:06", "2025-09-23 09:19:06", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758619146;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758619146;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-09-24 03:43:59", "2025-09-24 03:43:59", "175126", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2604", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-22 22:19:06", "2025-09-22 22:19:06", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758579546;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758579546;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-22 23:31:01", "2025-09-22 23:31:01", "175122", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2605", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-22 22:19:06", "2025-09-22 22:19:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758579546;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758579546;}", "12", "1", "2025-09-22 23:31:01", "2025-09-22 23:31:01", "175122", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2606", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-23 00:31:01", "2025-09-23 00:31:01", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758587461;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758587461;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-23 09:13:20", "2025-09-23 09:13:20", "175124", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2607", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-23 00:31:01", "2025-09-23 00:31:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758587461;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758587461;}", "12", "1", "2025-09-23 09:13:20", "2025-09-23 09:13:20", "175124", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2608", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-23 10:13:20", "2025-09-23 10:13:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758622400;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758622400;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-24 03:43:59", "2025-09-24 03:43:59", "175126", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2609", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-23 10:13:20", "2025-09-23 10:13:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758622400;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758622400;}", "12", "1", "2025-09-24 03:43:59", "2025-09-24 03:43:59", "175126", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2610", "woocommerce_cleanup_draft_orders", "complete", "2025-09-24 09:13:20", "2025-09-24 09:13:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758705200;s:18:\"\0*\0first_timestamp\";i:1668840681;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758705200;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-24 11:27:53", "2025-09-24 11:27:53", "175130", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2611", "woocommerce_scheduled_sales", "complete", "2025-09-24 09:13:20", "2025-09-24 09:13:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758705200;s:18:\"\0*\0first_timestamp\";i:1755820800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758705200;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-24 11:27:53", "2025-09-24 11:27:53", "175130", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2612", "wc_admin_daily_wrapper", "complete", "2025-09-24 09:13:23", "2025-09-24 09:13:23", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758705203;s:18:\"\0*\0first_timestamp\";i:1755758222;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758705203;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-24 11:27:55", "2025-09-24 11:27:55", "175130", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2613", "woocommerce_cleanup_personal_data", "complete", "2025-09-24 09:13:24", "2025-09-24 09:13:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758705204;s:18:\"\0*\0first_timestamp\";i:1755758231;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758705204;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-24 11:27:56", "2025-09-24 11:27:56", "175130", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2614", "woocommerce_cleanup_logs", "complete", "2025-09-24 09:13:24", "2025-09-24 09:13:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758705204;s:18:\"\0*\0first_timestamp\";i:1755769021;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758705204;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-24 11:27:56", "2025-09-24 11:27:56", "175130", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2615", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-09-24 09:13:24", "2025-09-24 09:13:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758705204;s:18:\"\0*\0first_timestamp\";i:1755769022;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758705204;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-24 11:27:56", "2025-09-24 11:27:56", "175130", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2616", "generate_category_lookup_table_wrapper", "complete", "2025-09-23 09:13:34", "2025-09-23 09:13:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758618814;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758618814;}", "12", "1", "2025-09-24 03:43:59", "2025-09-24 03:43:59", "175126", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2617", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-24 09:13:24", "2025-09-24 09:13:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758705204;s:18:\"\0*\0first_timestamp\";i:1755758209;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758705204;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-09-24 11:27:56", "2025-09-24 11:27:56", "175130", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("2618", "woocommerce_refresh_order_count_cache", "complete", "2025-09-24 15:43:59", "2025-09-24 15:43:59", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758728639;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758728639;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-24 18:01:12", "2025-09-24 18:01:12", "175136", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2619", "woocommerce_cleanup_sessions", "complete", "2025-09-24 15:43:59", "2025-09-24 15:43:59", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758728639;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758728639;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-09-24 18:01:12", "2025-09-24 18:01:12", "175136", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2620", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-24 04:43:59", "2025-09-24 04:43:59", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758689039;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758689039;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-24 11:27:53", "2025-09-24 11:27:53", "175130", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2621", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-24 04:43:59", "2025-09-24 04:43:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758689039;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758689039;}", "12", "1", "2025-09-24 11:27:53", "2025-09-24 11:27:53", "175130", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2622", "fetch_patterns", "complete", "2025-09-24 03:45:48", "2025-09-24 03:45:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758685548;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758685548;}", "5", "1", "2025-09-24 03:46:05", "2025-09-24 03:46:05", "175128", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2623", "woocommerce_run_update_callback", "complete", "2025-09-24 03:45:54", "2025-09-24 03:45:54", "{\"update_callback\":\"wc_update_1020_add_old_refunded_order_items_to_product_lookup_table\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758685554;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758685554;}", "2", "1", "2025-09-24 03:46:05", "2025-09-24 03:46:05", "175128", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2624", "woocommerce_update_db_to_current_version", "complete", "2025-09-24 03:45:55", "2025-09-24 03:45:55", "{\"version\":\"10.2.1\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758685555;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758685555;}", "2", "1", "2025-09-24 03:46:05", "2025-09-24 03:46:05", "175128", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2625", "woocommerce_run_on_woocommerce_admin_updated", "complete", "2025-09-24 03:45:54", "2025-09-24 03:45:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758685554;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758685554;}", "4", "1", "2025-09-24 03:46:05", "2025-09-24 03:46:05", "175128", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2626", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-24 12:27:53", "2025-09-24 12:27:53", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758716873;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758716873;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-24 12:33:37", "2025-09-24 12:33:37", "175134", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2627", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-24 12:27:53", "2025-09-24 12:27:53", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758716873;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758716873;}", "12", "1", "2025-09-24 12:33:37", "2025-09-24 12:33:37", "175134", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2628", "woocommerce_cleanup_draft_orders", "complete", "2025-09-25 11:27:53", "2025-09-25 11:27:53", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758799673;s:18:\"\0*\0first_timestamp\";i:1668840681;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758799673;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-25 11:47:01", "2025-09-25 11:47:01", "175142", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2629", "woocommerce_scheduled_sales", "complete", "2025-09-25 11:27:53", "2025-09-25 11:27:53", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758799673;s:18:\"\0*\0first_timestamp\";i:1755820800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758799673;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-25 11:47:01", "2025-09-25 11:47:01", "175142", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2630", "wc_admin_daily_wrapper", "complete", "2025-09-25 11:27:55", "2025-09-25 11:27:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758799675;s:18:\"\0*\0first_timestamp\";i:1755758222;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758799675;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-25 11:47:03", "2025-09-25 11:47:03", "175142", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2631", "woocommerce_cleanup_personal_data", "complete", "2025-09-25 11:27:56", "2025-09-25 11:27:56", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758799676;s:18:\"\0*\0first_timestamp\";i:1755758231;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758799676;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-25 11:47:04", "2025-09-25 11:47:04", "175142", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2632", "woocommerce_cleanup_logs", "complete", "2025-09-25 11:27:56", "2025-09-25 11:27:56", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758799676;s:18:\"\0*\0first_timestamp\";i:1755769021;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758799676;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-25 11:47:04", "2025-09-25 11:47:04", "175142", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2633", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-09-25 11:27:56", "2025-09-25 11:27:56", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758799676;s:18:\"\0*\0first_timestamp\";i:1755769022;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758799676;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-25 11:47:04", "2025-09-25 11:47:04", "175142", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2634", "generate_category_lookup_table_wrapper", "complete", "2025-09-24 11:28:06", "2025-09-24 11:28:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758713286;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758713286;}", "12", "1", "2025-09-24 11:28:58", "2025-09-24 11:28:58", "175132", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2635", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-25 11:27:56", "2025-09-25 11:27:56", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758799676;s:18:\"\0*\0first_timestamp\";i:1755758209;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758799676;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-09-25 11:47:04", "2025-09-25 11:47:04", "175142", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("2636", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-24 13:33:37", "2025-09-24 13:33:37", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758720817;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758720817;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-24 18:01:12", "2025-09-24 18:01:12", "175136", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2637", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-24 13:33:37", "2025-09-24 13:33:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758720817;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758720817;}", "12", "1", "2025-09-24 18:01:12", "2025-09-24 18:01:12", "175136", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2638", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-24 19:01:12", "2025-09-24 19:01:12", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758740472;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758740472;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-25 01:15:37", "2025-09-25 01:15:37", "175138", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2639", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-24 19:01:12", "2025-09-24 19:01:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758740472;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758740472;}", "12", "1", "2025-09-25 01:15:37", "2025-09-25 01:15:37", "175138", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2640", "woocommerce_refresh_order_count_cache", "complete", "2025-09-25 06:01:12", "2025-09-25 06:01:12", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758780072;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758780072;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-25 11:47:01", "2025-09-25 11:47:01", "175142", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2641", "woocommerce_cleanup_sessions", "complete", "2025-09-25 06:01:12", "2025-09-25 06:01:12", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758780072;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758780072;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-09-25 11:47:01", "2025-09-25 11:47:01", "175142", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2642", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-25 02:15:37", "2025-09-25 02:15:37", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758766537;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758766537;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-25 02:47:05", "2025-09-25 02:47:05", "175140", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2643", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-25 02:15:37", "2025-09-25 02:15:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758766537;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758766537;}", "12", "1", "2025-09-25 02:47:05", "2025-09-25 02:47:05", "175140", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2644", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-25 03:47:05", "2025-09-25 03:47:05", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758772025;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758772025;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-25 11:47:01", "2025-09-25 11:47:01", "175142", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2645", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-25 03:47:05", "2025-09-25 03:47:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758772025;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758772025;}", "12", "1", "2025-09-25 11:47:01", "2025-09-25 11:47:01", "175142", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2646", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-25 12:47:01", "2025-09-25 12:47:01", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758804421;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758804421;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-25 13:18:20", "2025-09-25 13:18:20", "175146", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2647", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-25 12:47:01", "2025-09-25 12:47:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758804421;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758804421;}", "12", "1", "2025-09-25 13:18:20", "2025-09-25 13:18:20", "175146", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2648", "woocommerce_refresh_order_count_cache", "complete", "2025-09-25 23:47:01", "2025-09-25 23:47:01", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758844021;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758844021;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-26 06:55:27", "2025-09-26 06:55:27", "175152", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2649", "woocommerce_cleanup_sessions", "complete", "2025-09-25 23:47:01", "2025-09-25 23:47:01", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758844021;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758844021;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-09-26 06:55:27", "2025-09-26 06:55:27", "175152", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2650", "woocommerce_cleanup_draft_orders", "complete", "2025-09-26 11:47:01", "2025-09-26 11:47:01", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758887221;s:18:\"\0*\0first_timestamp\";i:1668840681;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758887221;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-26 18:11:00", "2025-09-26 18:11:00", "175154", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2651", "woocommerce_scheduled_sales", "complete", "2025-09-26 11:47:01", "2025-09-26 11:47:01", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758887221;s:18:\"\0*\0first_timestamp\";i:1755820800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758887221;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-26 18:11:00", "2025-09-26 18:11:00", "175154", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2652", "wc_admin_daily_wrapper", "complete", "2025-09-26 11:47:03", "2025-09-26 11:47:03", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758887223;s:18:\"\0*\0first_timestamp\";i:1755758222;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758887223;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-26 18:11:02", "2025-09-26 18:11:02", "175154", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2653", "woocommerce_cleanup_personal_data", "complete", "2025-09-26 11:47:04", "2025-09-26 11:47:04", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758887224;s:18:\"\0*\0first_timestamp\";i:1755758231;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758887224;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-26 18:11:03", "2025-09-26 18:11:03", "175154", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2654", "woocommerce_cleanup_logs", "complete", "2025-09-26 11:47:04", "2025-09-26 11:47:04", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758887224;s:18:\"\0*\0first_timestamp\";i:1755769021;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758887224;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-26 18:11:04", "2025-09-26 18:11:04", "175154", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2655", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-09-26 11:47:04", "2025-09-26 11:47:04", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758887224;s:18:\"\0*\0first_timestamp\";i:1755769022;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758887224;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-26 18:11:04", "2025-09-26 18:11:04", "175154", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2656", "generate_category_lookup_table_wrapper", "complete", "2025-09-25 11:47:14", "2025-09-25 11:47:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758800834;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758800834;}", "12", "1", "2025-09-25 11:48:12", "2025-09-25 11:48:12", "175144", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2657", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-26 11:47:04", "2025-09-26 11:47:04", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758887224;s:18:\"\0*\0first_timestamp\";i:1755758209;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758887224;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-09-26 18:11:04", "2025-09-26 18:11:04", "175154", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("2658", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-25 14:18:20", "2025-09-25 14:18:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758809900;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758809900;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-25 17:40:27", "2025-09-25 17:40:27", "175148", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2659", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-25 14:18:20", "2025-09-25 14:18:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758809900;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758809900;}", "12", "1", "2025-09-25 17:40:27", "2025-09-25 17:40:27", "175148", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2660", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-25 18:40:27", "2025-09-25 18:40:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758825627;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758825627;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-25 21:48:36", "2025-09-25 21:48:36", "175150", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2661", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-25 18:40:27", "2025-09-25 18:40:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758825627;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758825627;}", "12", "1", "2025-09-25 21:48:36", "2025-09-25 21:48:36", "175150", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2662", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-25 22:48:36", "2025-09-25 22:48:36", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758840516;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758840516;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-26 06:55:27", "2025-09-26 06:55:27", "175152", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2663", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-25 22:48:36", "2025-09-25 22:48:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758840516;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758840516;}", "12", "1", "2025-09-26 06:55:27", "2025-09-26 06:55:27", "175152", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2664", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-26 07:55:27", "2025-09-26 07:55:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758873327;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758873327;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-26 18:11:00", "2025-09-26 18:11:00", "175154", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2665", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-26 07:55:27", "2025-09-26 07:55:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758873327;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758873327;}", "12", "1", "2025-09-26 18:11:00", "2025-09-26 18:11:00", "175154", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2666", "woocommerce_refresh_order_count_cache", "complete", "2025-09-26 18:55:27", "2025-09-26 18:55:27", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758912927;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758912927;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-26 19:08:22", "2025-09-26 19:08:22", "175156", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2667", "woocommerce_cleanup_sessions", "complete", "2025-09-26 18:55:27", "2025-09-26 18:55:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758912927;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758912927;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-09-26 19:08:22", "2025-09-26 19:08:22", "175156", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2668", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-26 19:11:00", "2025-09-26 19:11:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758913860;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758913860;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-26 20:59:06", "2025-09-26 20:59:06", "175158", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2669", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-26 19:11:00", "2025-09-26 19:11:00", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758913860;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758913860;}", "12", "1", "2025-09-26 20:59:06", "2025-09-26 20:59:06", "175158", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2670", "woocommerce_cleanup_draft_orders", "complete", "2025-09-27 18:11:00", "2025-09-27 18:11:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758996660;s:18:\"\0*\0first_timestamp\";i:1668840681;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758996660;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-27 21:41:24", "2025-09-27 21:41:24", "175168", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2671", "woocommerce_scheduled_sales", "complete", "2025-09-27 18:11:00", "2025-09-27 18:11:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758996660;s:18:\"\0*\0first_timestamp\";i:1755820800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758996660;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-27 21:41:24", "2025-09-27 21:41:24", "175168", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2672", "wc_admin_daily_wrapper", "complete", "2025-09-27 18:11:02", "2025-09-27 18:11:02", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758996662;s:18:\"\0*\0first_timestamp\";i:1755758222;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758996662;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-27 21:41:26", "2025-09-27 21:41:26", "175168", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2673", "woocommerce_cleanup_personal_data", "complete", "2025-09-27 18:11:03", "2025-09-27 18:11:03", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758996663;s:18:\"\0*\0first_timestamp\";i:1755758231;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758996663;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-27 21:41:27", "2025-09-27 21:41:27", "175168", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2674", "woocommerce_cleanup_logs", "complete", "2025-09-27 18:11:04", "2025-09-27 18:11:04", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758996664;s:18:\"\0*\0first_timestamp\";i:1755769021;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758996664;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-27 21:41:27", "2025-09-27 21:41:27", "175168", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2675", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-09-27 18:11:04", "2025-09-27 18:11:04", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758996664;s:18:\"\0*\0first_timestamp\";i:1755769022;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758996664;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-27 21:41:27", "2025-09-27 21:41:27", "175168", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2676", "generate_category_lookup_table_wrapper", "complete", "2025-09-26 18:11:14", "2025-09-26 18:11:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758910274;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758910274;}", "12", "1", "2025-09-26 19:08:22", "2025-09-26 19:08:22", "175156", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2677", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-27 18:11:04", "2025-09-27 18:11:04", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758996664;s:18:\"\0*\0first_timestamp\";i:1755758209;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758996664;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-09-27 21:41:27", "2025-09-27 21:41:27", "175168", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("2678", "woocommerce_refresh_order_count_cache", "complete", "2025-09-27 07:08:22", "2025-09-27 07:08:22", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758956902;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758956902;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-27 07:28:31", "2025-09-27 07:28:31", "175164", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2679", "woocommerce_cleanup_sessions", "complete", "2025-09-27 07:08:22", "2025-09-27 07:08:22", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758956902;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758956902;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-09-27 07:28:31", "2025-09-27 07:28:31", "175164", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2680", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-26 21:59:06", "2025-09-26 21:59:06", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758923946;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758923946;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-26 22:05:59", "2025-09-26 22:05:59", "175160", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2681", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-26 21:59:06", "2025-09-26 21:59:06", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758923946;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758923946;}", "12", "1", "2025-09-26 22:05:59", "2025-09-26 22:05:59", "175160", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2682", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-26 23:05:59", "2025-09-26 23:05:59", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758927959;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758927959;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-27 06:44:59", "2025-09-27 06:44:59", "175162", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2683", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-26 23:05:59", "2025-09-26 23:05:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758927959;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758927959;}", "12", "1", "2025-09-27 06:44:59", "2025-09-27 06:44:59", "175162", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2684", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-27 07:44:59", "2025-09-27 07:44:59", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758959099;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758959099;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-27 16:52:24", "2025-09-27 16:52:24", "175166", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2685", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-27 07:44:59", "2025-09-27 07:44:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758959099;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758959099;}", "12", "1", "2025-09-27 16:52:24", "2025-09-27 16:52:24", "175166", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2686", "wc-admin_import_orders", "complete", "2025-09-27 06:54:57", "2025-09-27 06:54:57", "[5414]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758956097;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758956097;}", "3", "1", "2025-09-27 07:28:31", "2025-09-27 07:28:31", "175164", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2687", "woocommerce_refresh_order_count_cache", "complete", "2025-09-27 19:28:31", "2025-09-27 19:28:31", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759001311;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759001311;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-27 21:41:27", "2025-09-27 21:41:27", "175168", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2688", "woocommerce_cleanup_sessions", "complete", "2025-09-27 19:28:31", "2025-09-27 19:28:31", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759001311;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759001311;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-09-27 21:41:27", "2025-09-27 21:41:27", "175168", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2689", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-27 17:52:24", "2025-09-27 17:52:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1758995544;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1758995544;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-27 21:41:24", "2025-09-27 21:41:24", "175168", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2690", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-27 17:52:24", "2025-09-27 17:52:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1758995544;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1758995544;}", "12", "1", "2025-09-27 21:41:24", "2025-09-27 21:41:24", "175168", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2691", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-27 22:41:24", "2025-09-27 22:41:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759012884;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759012884;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-28 02:29:48", "2025-09-28 02:29:48", "175170", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2692", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-27 22:41:24", "2025-09-27 22:41:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759012884;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759012884;}", "12", "1", "2025-09-28 02:29:48", "2025-09-28 02:29:48", "175170", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2693", "woocommerce_cleanup_draft_orders", "complete", "2025-09-28 21:41:24", "2025-09-28 21:41:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759095684;s:18:\"\0*\0first_timestamp\";i:1668840681;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759095684;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-29 07:30:22", "2025-09-29 07:30:22", "175178", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2694", "woocommerce_scheduled_sales", "complete", "2025-09-28 21:41:24", "2025-09-28 21:41:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759095684;s:18:\"\0*\0first_timestamp\";i:1755820800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759095684;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-29 07:30:22", "2025-09-29 07:30:22", "175178", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2695", "wc_admin_daily_wrapper", "complete", "2025-09-28 21:41:26", "2025-09-28 21:41:26", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759095686;s:18:\"\0*\0first_timestamp\";i:1755758222;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759095686;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-29 07:30:24", "2025-09-29 07:30:24", "175178", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2696", "woocommerce_cleanup_personal_data", "complete", "2025-09-28 21:41:27", "2025-09-28 21:41:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759095687;s:18:\"\0*\0first_timestamp\";i:1755758231;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759095687;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-29 07:30:25", "2025-09-29 07:30:25", "175178", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2697", "woocommerce_cleanup_logs", "complete", "2025-09-28 21:41:27", "2025-09-28 21:41:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759095687;s:18:\"\0*\0first_timestamp\";i:1755769021;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759095687;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-29 07:30:25", "2025-09-29 07:30:25", "175178", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2698", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-09-28 21:41:27", "2025-09-28 21:41:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759095687;s:18:\"\0*\0first_timestamp\";i:1755769022;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759095687;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-29 07:30:25", "2025-09-29 07:30:25", "175178", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2699", "woocommerce_refresh_order_count_cache", "complete", "2025-09-28 09:41:27", "2025-09-28 09:41:27", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759052487;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759052487;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-28 13:38:43", "2025-09-28 13:38:43", "175172", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2700", "woocommerce_cleanup_sessions", "complete", "2025-09-28 09:41:27", "2025-09-28 09:41:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759052487;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759052487;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-09-28 13:38:43", "2025-09-28 13:38:43", "175172", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2701", "generate_category_lookup_table_wrapper", "complete", "2025-09-27 21:41:37", "2025-09-27 21:41:37", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759009297;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759009297;}", "12", "1", "2025-09-28 02:29:48", "2025-09-28 02:29:48", "175170", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2702", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-28 21:41:27", "2025-09-28 21:41:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759095687;s:18:\"\0*\0first_timestamp\";i:1755758209;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759095687;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-09-29 07:30:25", "2025-09-29 07:30:25", "175178", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("2703", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-28 03:29:48", "2025-09-28 03:29:48", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759030188;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759030188;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-28 13:38:43", "2025-09-28 13:38:43", "175172", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2704", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-28 03:29:48", "2025-09-28 03:29:48", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759030188;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759030188;}", "12", "1", "2025-09-28 13:38:43", "2025-09-28 13:38:43", "175172", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2705", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-28 14:38:43", "2025-09-28 14:38:43", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759070323;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759070323;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-28 14:51:07", "2025-09-28 14:51:07", "175174", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2706", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-28 14:38:43", "2025-09-28 14:38:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759070323;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759070323;}", "12", "1", "2025-09-28 14:51:07", "2025-09-28 14:51:07", "175174", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2707", "woocommerce_refresh_order_count_cache", "complete", "2025-09-29 01:38:43", "2025-09-29 01:38:43", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759109923;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759109923;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-29 07:30:25", "2025-09-29 07:30:25", "175178", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2708", "woocommerce_cleanup_sessions", "complete", "2025-09-29 01:38:43", "2025-09-29 01:38:43", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759109923;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759109923;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-09-29 07:30:25", "2025-09-29 07:30:25", "175178", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2709", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-28 15:51:07", "2025-09-28 15:51:07", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759074667;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759074667;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-28 17:18:39", "2025-09-28 17:18:39", "175176", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2710", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-28 15:51:07", "2025-09-28 15:51:07", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759074667;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759074667;}", "12", "1", "2025-09-28 17:18:39", "2025-09-28 17:18:39", "175176", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2711", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-28 18:18:39", "2025-09-28 18:18:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759083519;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759083519;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-29 07:30:22", "2025-09-29 07:30:22", "175178", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2712", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-28 18:18:39", "2025-09-28 18:18:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759083519;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759083519;}", "12", "1", "2025-09-29 07:30:22", "2025-09-29 07:30:22", "175178", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2713", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-29 08:30:22", "2025-09-29 08:30:22", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759134622;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759134622;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-29 09:06:51", "2025-09-29 09:06:51", "175180", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2714", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-29 08:30:22", "2025-09-29 08:30:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759134622;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759134622;}", "12", "1", "2025-09-29 09:06:51", "2025-09-29 09:06:51", "175180", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2715", "woocommerce_cleanup_draft_orders", "complete", "2025-09-30 07:30:22", "2025-09-30 07:30:22", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759217422;s:18:\"\0*\0first_timestamp\";i:1668840681;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759217422;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-09-30 07:46:08", "2025-09-30 07:46:08", "175194", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2716", "woocommerce_scheduled_sales", "complete", "2025-09-30 07:30:22", "2025-09-30 07:30:22", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759217422;s:18:\"\0*\0first_timestamp\";i:1755820800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759217422;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-30 07:46:08", "2025-09-30 07:46:08", "175194", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2717", "wc_admin_daily_wrapper", "complete", "2025-09-30 07:30:24", "2025-09-30 07:30:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759217424;s:18:\"\0*\0first_timestamp\";i:1755758222;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759217424;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-30 07:46:10", "2025-09-30 07:46:10", "175194", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2718", "woocommerce_cleanup_personal_data", "complete", "2025-09-30 07:30:25", "2025-09-30 07:30:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759217425;s:18:\"\0*\0first_timestamp\";i:1755758231;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759217425;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-30 07:46:11", "2025-09-30 07:46:11", "175194", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2719", "woocommerce_cleanup_logs", "complete", "2025-09-30 07:30:25", "2025-09-30 07:30:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759217425;s:18:\"\0*\0first_timestamp\";i:1755769021;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759217425;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-30 07:46:11", "2025-09-30 07:46:11", "175194", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2720", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-09-30 07:30:25", "2025-09-30 07:30:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759217425;s:18:\"\0*\0first_timestamp\";i:1755769022;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759217425;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-09-30 07:46:11", "2025-09-30 07:46:11", "175194", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2721", "woocommerce_refresh_order_count_cache", "complete", "2025-09-29 19:30:25", "2025-09-29 19:30:25", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759174225;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759174225;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-29 19:45:55", "2025-09-29 19:45:55", "175190", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2722", "woocommerce_cleanup_sessions", "complete", "2025-09-29 19:30:25", "2025-09-29 19:30:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759174225;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759174225;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-09-29 19:45:55", "2025-09-29 19:45:55", "175190", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2723", "generate_category_lookup_table_wrapper", "complete", "2025-09-29 07:30:35", "2025-09-29 07:30:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759131035;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759131035;}", "12", "1", "2025-09-29 09:06:50", "2025-09-29 09:06:50", "175180", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2724", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-09-30 07:30:25", "2025-09-30 07:30:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759217425;s:18:\"\0*\0first_timestamp\";i:1755758209;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759217425;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-09-30 07:46:11", "2025-09-30 07:46:11", "175194", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("2725", "wc-admin_import_orders", "complete", "2025-09-29 07:31:28", "2025-09-29 07:31:28", "[5415]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759131088;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759131088;}", "3", "1", "2025-09-29 09:06:51", "2025-09-29 09:06:51", "175180", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2726", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-29 10:06:51", "2025-09-29 10:06:51", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759140411;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759140411;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-29 10:59:13", "2025-09-29 10:59:13", "175182", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2727", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-29 10:06:51", "2025-09-29 10:06:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759140411;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759140411;}", "12", "1", "2025-09-29 10:59:13", "2025-09-29 10:59:13", "175182", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2728", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-29 11:59:13", "2025-09-29 11:59:13", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759147153;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759147153;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-29 13:38:27", "2025-09-29 13:38:27", "175184", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2729", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-29 11:59:13", "2025-09-29 11:59:13", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759147153;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759147153;}", "12", "1", "2025-09-29 13:38:27", "2025-09-29 13:38:27", "175184", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2730", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-29 14:38:27", "2025-09-29 14:38:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759156707;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759156707;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-29 15:29:20", "2025-09-29 15:29:20", "175186", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2731", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-29 14:38:27", "2025-09-29 14:38:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759156707;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759156707;}", "12", "1", "2025-09-29 15:29:20", "2025-09-29 15:29:20", "175186", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2732", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-29 16:29:20", "2025-09-29 16:29:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759163360;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759163360;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-29 16:29:56", "2025-09-29 16:29:56", "175188", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2733", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-29 16:29:20", "2025-09-29 16:29:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759163360;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759163360;}", "12", "1", "2025-09-29 16:29:56", "2025-09-29 16:29:56", "175188", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2734", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-29 17:29:56", "2025-09-29 17:29:56", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759166996;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759166996;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-29 19:45:55", "2025-09-29 19:45:55", "175190", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2735", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-29 17:29:56", "2025-09-29 17:29:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759166996;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759166996;}", "12", "1", "2025-09-29 19:45:55", "2025-09-29 19:45:55", "175190", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2736", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-29 20:45:55", "2025-09-29 20:45:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759178755;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759178755;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-30 02:49:49", "2025-09-30 02:49:49", "175192", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2737", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-29 20:45:55", "2025-09-29 20:45:55", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759178755;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759178755;}", "12", "1", "2025-09-30 02:49:49", "2025-09-30 02:49:49", "175192", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2738", "woocommerce_refresh_order_count_cache", "complete", "2025-09-30 07:45:55", "2025-09-30 07:45:55", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759218355;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759218355;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-09-30 07:46:11", "2025-09-30 07:46:11", "175194", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2739", "woocommerce_cleanup_sessions", "complete", "2025-09-30 07:45:55", "2025-09-30 07:45:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759218355;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759218355;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-09-30 07:46:11", "2025-09-30 07:46:11", "175194", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2740", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-30 03:49:49", "2025-09-30 03:49:49", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759204189;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759204189;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-30 07:46:08", "2025-09-30 07:46:08", "175194", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2741", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-30 03:49:49", "2025-09-30 03:49:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759204189;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759204189;}", "12", "1", "2025-09-30 07:46:08", "2025-09-30 07:46:08", "175194", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2742", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-30 08:46:08", "2025-09-30 08:46:08", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759221968;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759221968;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-30 09:27:58", "2025-09-30 09:27:58", "175198", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2743", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-30 08:46:08", "2025-09-30 08:46:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759221968;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759221968;}", "12", "1", "2025-09-30 09:27:58", "2025-09-30 09:27:58", "175198", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2744", "woocommerce_cleanup_draft_orders", "complete", "2025-10-01 07:46:08", "2025-10-01 07:46:08", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759304768;s:18:\"\0*\0first_timestamp\";i:1668840681;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759304768;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-10-01 08:26:21", "2025-10-01 08:26:21", "175208", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2745", "woocommerce_scheduled_sales", "complete", "2025-10-01 07:46:08", "2025-10-01 07:46:08", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759304768;s:18:\"\0*\0first_timestamp\";i:1755820800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759304768;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-01 08:26:21", "2025-10-01 08:26:21", "175208", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2746", "wc_admin_daily_wrapper", "complete", "2025-10-01 07:46:10", "2025-10-01 07:46:10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759304770;s:18:\"\0*\0first_timestamp\";i:1755758222;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759304770;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-01 08:26:23", "2025-10-01 08:26:23", "175208", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2747", "woocommerce_cleanup_personal_data", "complete", "2025-10-01 07:46:11", "2025-10-01 07:46:11", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759304771;s:18:\"\0*\0first_timestamp\";i:1755758231;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759304771;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-01 08:26:24", "2025-10-01 08:26:24", "175208", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2748", "woocommerce_cleanup_logs", "complete", "2025-10-01 07:46:11", "2025-10-01 07:46:11", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759304771;s:18:\"\0*\0first_timestamp\";i:1755769021;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759304771;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-01 08:26:24", "2025-10-01 08:26:24", "175208", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2749", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-10-01 07:46:11", "2025-10-01 07:46:11", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759304771;s:18:\"\0*\0first_timestamp\";i:1755769022;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759304771;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-01 08:26:24", "2025-10-01 08:26:24", "175208", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2750", "woocommerce_refresh_order_count_cache", "complete", "2025-09-30 19:46:11", "2025-09-30 19:46:11", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759261571;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759261571;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-10-01 08:26:21", "2025-10-01 08:26:21", "175208", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2751", "woocommerce_cleanup_sessions", "complete", "2025-09-30 19:46:11", "2025-09-30 19:46:11", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759261571;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759261571;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-10-01 08:26:21", "2025-10-01 08:26:21", "175208", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2752", "generate_category_lookup_table_wrapper", "complete", "2025-09-30 07:46:21", "2025-09-30 07:46:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759218381;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759218381;}", "12", "1", "2025-09-30 08:23:11", "2025-09-30 08:23:11", "175196", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2753", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-01 07:46:11", "2025-10-01 07:46:11", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759304771;s:18:\"\0*\0first_timestamp\";i:1755758209;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759304771;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-10-01 08:26:24", "2025-10-01 08:26:24", "175208", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("2754", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-30 10:27:58", "2025-09-30 10:27:58", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759228078;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759228078;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-30 10:37:42", "2025-09-30 10:37:42", "175200", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2755", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-30 10:27:58", "2025-09-30 10:27:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759228078;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759228078;}", "12", "1", "2025-09-30 10:37:42", "2025-09-30 10:37:42", "175200", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2756", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-30 11:37:42", "2025-09-30 11:37:42", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759232262;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759232262;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-30 11:39:31", "2025-09-30 11:39:31", "175202", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2757", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-30 11:37:42", "2025-09-30 11:37:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759232262;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759232262;}", "12", "1", "2025-09-30 11:39:31", "2025-09-30 11:39:31", "175202", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2758", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-30 12:39:31", "2025-09-30 12:39:31", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759235971;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759235971;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-30 14:12:01", "2025-09-30 14:12:01", "175204", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2759", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-30 12:39:31", "2025-09-30 12:39:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759235971;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759235971;}", "12", "1", "2025-09-30 14:12:01", "2025-09-30 14:12:01", "175204", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2760", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-30 15:12:01", "2025-09-30 15:12:01", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759245121;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759245121;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-09-30 17:30:24", "2025-09-30 17:30:24", "175206", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2761", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-30 15:12:01", "2025-09-30 15:12:01", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759245121;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759245121;}", "12", "1", "2025-09-30 17:30:24", "2025-09-30 17:30:24", "175206", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2762", "woocommerce_custom_orders_table_background_sync", "complete", "2025-09-30 18:30:24", "2025-09-30 18:30:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759257024;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759257024;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-01 08:26:21", "2025-10-01 08:26:21", "175208", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2763", "woocommerce_cancel_unpaid_orders", "complete", "2025-09-30 18:30:24", "2025-09-30 18:30:24", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759257024;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759257024;}", "12", "1", "2025-10-01 08:26:21", "2025-10-01 08:26:21", "175208", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2764", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-01 09:26:21", "2025-10-01 09:26:21", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759310781;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759310781;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-02 00:27:56", "2025-10-02 00:27:56", "175212", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2765", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-01 09:26:21", "2025-10-01 09:26:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759310781;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759310781;}", "12", "1", "2025-10-02 00:27:56", "2025-10-02 00:27:56", "175212", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2766", "woocommerce_refresh_order_count_cache", "complete", "2025-10-01 20:26:21", "2025-10-01 20:26:21", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759350381;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759350381;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-10-02 00:27:56", "2025-10-02 00:27:56", "175212", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2767", "woocommerce_cleanup_sessions", "complete", "2025-10-01 20:26:21", "2025-10-01 20:26:21", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759350381;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759350381;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-10-02 00:27:56", "2025-10-02 00:27:56", "175212", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2768", "woocommerce_cleanup_draft_orders", "complete", "2025-10-02 08:26:21", "2025-10-02 08:26:21", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759393581;s:18:\"\0*\0first_timestamp\";i:1668840681;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759393581;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-10-02 12:31:12", "2025-10-02 12:31:12", "175218", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2769", "woocommerce_scheduled_sales", "complete", "2025-10-02 08:26:21", "2025-10-02 08:26:21", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759393581;s:18:\"\0*\0first_timestamp\";i:1755820800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759393581;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-02 12:31:12", "2025-10-02 12:31:12", "175218", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2770", "wc_admin_daily_wrapper", "complete", "2025-10-02 08:26:23", "2025-10-02 08:26:23", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759393583;s:18:\"\0*\0first_timestamp\";i:1755758222;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759393583;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-02 12:31:14", "2025-10-02 12:31:14", "175218", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2771", "woocommerce_cleanup_personal_data", "complete", "2025-10-02 08:26:24", "2025-10-02 08:26:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759393584;s:18:\"\0*\0first_timestamp\";i:1755758231;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759393584;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-02 12:31:16", "2025-10-02 12:31:16", "175218", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2772", "woocommerce_cleanup_logs", "complete", "2025-10-02 08:26:24", "2025-10-02 08:26:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759393584;s:18:\"\0*\0first_timestamp\";i:1755769021;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759393584;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-02 12:31:16", "2025-10-02 12:31:16", "175218", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2773", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-10-02 08:26:24", "2025-10-02 08:26:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759393584;s:18:\"\0*\0first_timestamp\";i:1755769022;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759393584;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-02 12:31:16", "2025-10-02 12:31:16", "175218", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2774", "generate_category_lookup_table_wrapper", "complete", "2025-10-01 08:26:34", "2025-10-01 08:26:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759307194;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759307194;}", "12", "1", "2025-10-01 08:27:36", "2025-10-01 08:27:36", "175210", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2775", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-02 08:26:24", "2025-10-02 08:26:24", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759393584;s:18:\"\0*\0first_timestamp\";i:1755758209;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759393584;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-10-02 12:31:16", "2025-10-02 12:31:16", "175218", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("2776", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-02 01:27:56", "2025-10-02 01:27:56", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759368476;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759368476;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-02 06:19:20", "2025-10-02 06:19:20", "175214", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2777", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-02 01:27:56", "2025-10-02 01:27:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759368476;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759368476;}", "12", "1", "2025-10-02 06:19:20", "2025-10-02 06:19:20", "175214", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2778", "woocommerce_refresh_order_count_cache", "complete", "2025-10-02 12:27:56", "2025-10-02 12:27:56", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759408076;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759408076;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-10-02 12:31:16", "2025-10-02 12:31:16", "175218", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2779", "woocommerce_cleanup_sessions", "complete", "2025-10-02 12:27:56", "2025-10-02 12:27:56", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759408076;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759408076;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-10-02 12:31:16", "2025-10-02 12:31:16", "175218", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2780", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-02 07:19:20", "2025-10-02 07:19:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759389560;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759389560;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-02 07:48:16", "2025-10-02 07:48:16", "175216", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2781", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-02 07:19:20", "2025-10-02 07:19:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759389560;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759389560;}", "12", "1", "2025-10-02 07:48:16", "2025-10-02 07:48:16", "175216", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2782", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-02 08:48:16", "2025-10-02 08:48:16", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759394896;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759394896;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-02 12:31:16", "2025-10-02 12:31:16", "175218", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2783", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-02 08:48:16", "2025-10-02 08:48:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759394896;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759394896;}", "12", "1", "2025-10-02 12:31:16", "2025-10-02 12:31:16", "175218", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2784", "woocommerce_cleanup_draft_orders", "complete", "2025-10-03 12:31:12", "2025-10-03 12:31:12", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759494672;s:18:\"\0*\0first_timestamp\";i:1668840681;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759494672;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-10-04 06:43:14", "2025-10-04 06:43:14", "175222", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2785", "woocommerce_scheduled_sales", "complete", "2025-10-03 12:31:12", "2025-10-03 12:31:12", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759494672;s:18:\"\0*\0first_timestamp\";i:1755820800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759494672;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-04 06:43:14", "2025-10-04 06:43:14", "175222", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2786", "wc_admin_daily_wrapper", "complete", "2025-10-03 12:31:14", "2025-10-03 12:31:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759494674;s:18:\"\0*\0first_timestamp\";i:1755758222;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759494674;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-04 06:43:16", "2025-10-04 06:43:16", "175222", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2787", "woocommerce_cleanup_personal_data", "complete", "2025-10-03 12:31:16", "2025-10-03 12:31:16", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759494676;s:18:\"\0*\0first_timestamp\";i:1755758231;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759494676;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-04 06:43:17", "2025-10-04 06:43:17", "175222", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2788", "woocommerce_cleanup_logs", "complete", "2025-10-03 12:31:16", "2025-10-03 12:31:16", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759494676;s:18:\"\0*\0first_timestamp\";i:1755769021;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759494676;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-04 06:43:17", "2025-10-04 06:43:17", "175222", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2789", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-10-03 12:31:16", "2025-10-03 12:31:16", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759494676;s:18:\"\0*\0first_timestamp\";i:1755769022;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759494676;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-04 06:43:17", "2025-10-04 06:43:17", "175222", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2790", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-02 13:31:16", "2025-10-02 13:31:16", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759411876;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759411876;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-02 13:44:33", "2025-10-02 13:44:33", "175220", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2791", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-02 13:31:16", "2025-10-02 13:31:16", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759411876;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759411876;}", "12", "1", "2025-10-02 13:44:33", "2025-10-02 13:44:33", "175220", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2792", "woocommerce_refresh_order_count_cache", "complete", "2025-10-03 00:31:16", "2025-10-03 00:31:16", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759451476;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759451476;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-10-04 06:43:14", "2025-10-04 06:43:14", "175222", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2793", "woocommerce_cleanup_sessions", "complete", "2025-10-03 00:31:16", "2025-10-03 00:31:16", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759451476;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759451476;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-10-04 06:43:14", "2025-10-04 06:43:14", "175222", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2794", "generate_category_lookup_table_wrapper", "complete", "2025-10-02 12:31:26", "2025-10-02 12:31:26", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759408286;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759408286;}", "12", "1", "2025-10-02 13:44:33", "2025-10-02 13:44:33", "175220", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2795", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-03 12:31:16", "2025-10-03 12:31:16", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759494676;s:18:\"\0*\0first_timestamp\";i:1755758209;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759494676;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-10-04 06:43:17", "2025-10-04 06:43:17", "175222", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("2796", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-02 14:44:33", "2025-10-02 14:44:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759416273;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759416273;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-04 06:43:14", "2025-10-04 06:43:14", "175222", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2797", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-02 14:44:33", "2025-10-02 14:44:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759416273;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759416273;}", "12", "1", "2025-10-04 06:43:14", "2025-10-04 06:43:14", "175222", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2798", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-04 07:43:14", "2025-10-04 07:43:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759563794;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759563794;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-04 08:51:59", "2025-10-04 08:51:59", "175226", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2799", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-04 07:43:14", "2025-10-04 07:43:14", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759563794;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759563794;}", "12", "1", "2025-10-04 08:51:59", "2025-10-04 08:51:59", "175226", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2800", "woocommerce_refresh_order_count_cache", "complete", "2025-10-04 18:43:14", "2025-10-04 18:43:14", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759603394;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759603394;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-10-04 19:54:20", "2025-10-04 19:54:20", "175236", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2801", "woocommerce_cleanup_sessions", "complete", "2025-10-04 18:43:14", "2025-10-04 18:43:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759603394;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759603394;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-10-04 19:54:20", "2025-10-04 19:54:20", "175236", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2802", "woocommerce_cleanup_draft_orders", "complete", "2025-10-05 06:43:14", "2025-10-05 06:43:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759646594;s:18:\"\0*\0first_timestamp\";i:1668840681;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759646594;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-10-05 07:49:36", "2025-10-05 07:49:36", "175242", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2803", "woocommerce_scheduled_sales", "complete", "2025-10-05 06:43:14", "2025-10-05 06:43:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759646594;s:18:\"\0*\0first_timestamp\";i:1755820800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759646594;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-05 07:49:36", "2025-10-05 07:49:36", "175242", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2804", "wc_admin_daily_wrapper", "complete", "2025-10-05 06:43:16", "2025-10-05 06:43:16", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759646596;s:18:\"\0*\0first_timestamp\";i:1755758222;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759646596;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-05 07:49:38", "2025-10-05 07:49:38", "175242", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2805", "woocommerce_cleanup_personal_data", "complete", "2025-10-05 06:43:17", "2025-10-05 06:43:17", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759646597;s:18:\"\0*\0first_timestamp\";i:1755758231;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759646597;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-05 07:49:39", "2025-10-05 07:49:39", "175242", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2806", "woocommerce_cleanup_logs", "complete", "2025-10-05 06:43:17", "2025-10-05 06:43:17", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759646597;s:18:\"\0*\0first_timestamp\";i:1755769021;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759646597;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-05 07:49:39", "2025-10-05 07:49:39", "175242", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2807", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-10-05 06:43:17", "2025-10-05 06:43:17", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759646597;s:18:\"\0*\0first_timestamp\";i:1755769022;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759646597;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-05 07:49:39", "2025-10-05 07:49:39", "175242", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2808", "generate_category_lookup_table_wrapper", "complete", "2025-10-04 06:43:27", "2025-10-04 06:43:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759560207;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759560207;}", "12", "1", "2025-10-04 06:47:20", "2025-10-04 06:47:20", "175224", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2809", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-05 06:43:17", "2025-10-05 06:43:17", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759646597;s:18:\"\0*\0first_timestamp\";i:1755758209;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759646597;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-10-05 07:49:39", "2025-10-05 07:49:39", "175242", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("2810", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-04 09:51:59", "2025-10-04 09:51:59", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759571519;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759571519;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-04 10:38:57", "2025-10-04 10:38:57", "175228", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2811", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-04 09:51:59", "2025-10-04 09:51:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759571519;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759571519;}", "12", "1", "2025-10-04 10:38:57", "2025-10-04 10:38:57", "175228", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2812", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-04 11:38:57", "2025-10-04 11:38:57", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759577937;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759577937;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-04 11:53:09", "2025-10-04 11:53:09", "175230", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2813", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-04 11:38:57", "2025-10-04 11:38:57", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759577937;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759577937;}", "12", "1", "2025-10-04 11:53:09", "2025-10-04 11:53:09", "175230", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2814", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-04 12:53:09", "2025-10-04 12:53:09", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759582389;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759582389;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-04 14:33:39", "2025-10-04 14:33:39", "175232", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2815", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-04 12:53:09", "2025-10-04 12:53:09", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759582389;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759582389;}", "12", "1", "2025-10-04 14:33:39", "2025-10-04 14:33:39", "175232", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2816", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-04 15:33:39", "2025-10-04 15:33:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759592019;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759592019;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-04 15:35:10", "2025-10-04 15:35:10", "175234", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2817", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-04 15:33:39", "2025-10-04 15:33:39", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759592019;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759592019;}", "12", "1", "2025-10-04 15:35:10", "2025-10-04 15:35:10", "175234", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2818", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-04 16:35:10", "2025-10-04 16:35:10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759595710;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759595710;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-04 19:54:20", "2025-10-04 19:54:20", "175236", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2819", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-04 16:35:10", "2025-10-04 16:35:10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759595710;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759595710;}", "12", "1", "2025-10-04 19:54:20", "2025-10-04 19:54:20", "175236", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2820", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-04 20:54:20", "2025-10-04 20:54:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759611260;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759611260;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-04 21:29:23", "2025-10-04 21:29:23", "175238", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2821", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-04 20:54:20", "2025-10-04 20:54:20", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759611260;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759611260;}", "12", "1", "2025-10-04 21:29:23", "2025-10-04 21:29:23", "175238", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2822", "woocommerce_refresh_order_count_cache", "complete", "2025-10-05 07:54:20", "2025-10-05 07:54:20", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759650860;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759650860;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-10-05 08:59:33", "2025-10-05 08:59:33", "175246", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2823", "woocommerce_cleanup_sessions", "complete", "2025-10-05 07:54:20", "2025-10-05 07:54:20", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759650860;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759650860;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-10-05 08:59:33", "2025-10-05 08:59:33", "175246", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2824", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-04 22:29:23", "2025-10-04 22:29:23", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759616963;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759616963;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-05 02:48:47", "2025-10-05 02:48:47", "175240", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2825", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-04 22:29:23", "2025-10-04 22:29:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759616963;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759616963;}", "12", "1", "2025-10-05 02:48:47", "2025-10-05 02:48:47", "175240", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2826", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-05 03:48:47", "2025-10-05 03:48:47", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759636127;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759636127;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-05 07:49:36", "2025-10-05 07:49:36", "175242", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2827", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-05 03:48:47", "2025-10-05 03:48:47", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759636127;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759636127;}", "12", "1", "2025-10-05 07:49:36", "2025-10-05 07:49:36", "175242", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2828", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-05 08:49:36", "2025-10-05 08:49:36", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759654176;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759654176;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-05 08:59:33", "2025-10-05 08:59:33", "175246", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2829", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-05 08:49:36", "2025-10-05 08:49:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759654176;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759654176;}", "12", "1", "2025-10-05 08:59:33", "2025-10-05 08:59:33", "175246", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2830", "woocommerce_cleanup_draft_orders", "complete", "2025-10-06 07:49:36", "2025-10-06 07:49:36", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759736976;s:18:\"\0*\0first_timestamp\";i:1668840681;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759736976;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-10-06 11:30:23", "2025-10-06 11:30:23", "175260", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2831", "woocommerce_scheduled_sales", "complete", "2025-10-06 07:49:36", "2025-10-06 07:49:36", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759736976;s:18:\"\0*\0first_timestamp\";i:1755820800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759736976;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-06 11:30:23", "2025-10-06 11:30:23", "175260", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2832", "wc_admin_daily_wrapper", "complete", "2025-10-06 07:49:38", "2025-10-06 07:49:38", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759736978;s:18:\"\0*\0first_timestamp\";i:1755758222;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759736978;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-06 11:30:25", "2025-10-06 11:30:25", "175260", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2833", "woocommerce_cleanup_personal_data", "complete", "2025-10-06 07:49:39", "2025-10-06 07:49:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759736979;s:18:\"\0*\0first_timestamp\";i:1755758231;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759736979;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-06 11:30:26", "2025-10-06 11:30:26", "175260", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2834", "woocommerce_cleanup_logs", "complete", "2025-10-06 07:49:39", "2025-10-06 07:49:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759736979;s:18:\"\0*\0first_timestamp\";i:1755769021;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759736979;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-06 11:30:26", "2025-10-06 11:30:26", "175260", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2835", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-10-06 07:49:39", "2025-10-06 07:49:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759736979;s:18:\"\0*\0first_timestamp\";i:1755769022;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759736979;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-06 11:30:26", "2025-10-06 11:30:26", "175260", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2836", "generate_category_lookup_table_wrapper", "complete", "2025-10-05 07:49:49", "2025-10-05 07:49:49", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759650589;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759650589;}", "12", "1", "2025-10-05 07:51:37", "2025-10-05 07:51:37", "175244", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2837", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-06 07:49:39", "2025-10-06 07:49:39", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759736979;s:18:\"\0*\0first_timestamp\";i:1755758209;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759736979;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-10-06 11:30:26", "2025-10-06 11:30:26", "175260", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("2838", "wc-admin_import_orders", "complete", "2025-10-05 07:55:17", "2025-10-05 07:55:17", "[5466]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759650917;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759650917;}", "3", "1", "2025-10-05 08:59:33", "2025-10-05 08:59:33", "175246", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2839", "woocommerce_refresh_order_count_cache", "complete", "2025-10-05 20:59:33", "2025-10-05 20:59:33", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759697973;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759697973;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-10-05 21:35:59", "2025-10-05 21:35:59", "175254", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2840", "woocommerce_cleanup_sessions", "complete", "2025-10-05 20:59:33", "2025-10-05 20:59:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759697973;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759697973;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-10-05 21:35:59", "2025-10-05 21:35:59", "175254", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2841", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-05 09:59:33", "2025-10-05 09:59:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759658373;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759658373;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-05 14:47:44", "2025-10-05 14:47:44", "175248", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2842", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-05 09:59:33", "2025-10-05 09:59:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759658373;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759658373;}", "12", "1", "2025-10-05 14:47:44", "2025-10-05 14:47:44", "175248", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2843", "woocommerce_geoip_updater", "pending", "2025-10-20 14:47:44", "2025-10-20 14:47:44", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760971664;s:18:\"\0*\0first_timestamp\";i:1755758282;s:13:\"\0*\0recurrence\";i:1296000;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760971664;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:1296000;}", "12", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2844", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-05 15:47:44", "2025-10-05 15:47:44", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759679264;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759679264;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-05 16:25:42", "2025-10-05 16:25:42", "175250", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2845", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-05 15:47:44", "2025-10-05 15:47:44", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759679264;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759679264;}", "12", "1", "2025-10-05 16:25:42", "2025-10-05 16:25:42", "175250", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2846", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-05 17:25:42", "2025-10-05 17:25:42", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759685142;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759685142;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-05 19:13:33", "2025-10-05 19:13:33", "175252", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2847", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-05 17:25:42", "2025-10-05 17:25:42", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759685142;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759685142;}", "12", "1", "2025-10-05 19:13:33", "2025-10-05 19:13:33", "175252", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2848", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-05 20:13:33", "2025-10-05 20:13:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759695213;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759695213;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-05 21:35:59", "2025-10-05 21:35:59", "175254", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2849", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-05 20:13:33", "2025-10-05 20:13:33", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759695213;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759695213;}", "12", "1", "2025-10-05 21:35:59", "2025-10-05 21:35:59", "175254", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2850", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-05 22:35:59", "2025-10-05 22:35:59", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759703759;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759703759;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-06 02:31:28", "2025-10-06 02:31:28", "175256", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2851", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-05 22:35:59", "2025-10-05 22:35:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759703759;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759703759;}", "12", "1", "2025-10-06 02:31:28", "2025-10-06 02:31:28", "175256", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2852", "woocommerce_refresh_order_count_cache", "complete", "2025-10-06 09:35:59", "2025-10-06 09:35:59", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759743359;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759743359;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-10-06 11:30:26", "2025-10-06 11:30:26", "175260", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2853", "woocommerce_cleanup_sessions", "complete", "2025-10-06 09:35:59", "2025-10-06 09:35:59", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759743359;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759743359;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-10-06 11:30:26", "2025-10-06 11:30:26", "175260", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2854", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-06 03:31:28", "2025-10-06 03:31:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759721488;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759721488;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-06 06:43:27", "2025-10-06 06:43:27", "175258", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2855", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-06 03:31:28", "2025-10-06 03:31:28", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759721488;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759721488;}", "12", "1", "2025-10-06 06:43:27", "2025-10-06 06:43:27", "175258", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2856", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-06 07:43:27", "2025-10-06 07:43:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759736607;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759736607;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-06 11:30:23", "2025-10-06 11:30:23", "175260", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2857", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-06 07:43:27", "2025-10-06 07:43:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759736607;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759736607;}", "12", "1", "2025-10-06 11:30:23", "2025-10-06 11:30:23", "175260", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2858", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-06 12:30:23", "2025-10-06 12:30:23", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759753823;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759753823;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-06 13:13:04", "2025-10-06 13:13:04", "175264", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2859", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-06 12:30:23", "2025-10-06 12:30:23", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759753823;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759753823;}", "12", "1", "2025-10-06 13:13:04", "2025-10-06 13:13:04", "175264", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2860", "woocommerce_cleanup_draft_orders", "complete", "2025-10-07 11:30:23", "2025-10-07 11:30:23", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759836623;s:18:\"\0*\0first_timestamp\";i:1668840681;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759836623;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-10-07 12:17:30", "2025-10-07 12:17:30", "175270", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2861", "woocommerce_scheduled_sales", "complete", "2025-10-07 11:30:23", "2025-10-07 11:30:23", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759836623;s:18:\"\0*\0first_timestamp\";i:1755820800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759836623;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-07 12:17:30", "2025-10-07 12:17:30", "175270", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2862", "wc_admin_daily_wrapper", "complete", "2025-10-07 11:30:25", "2025-10-07 11:30:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759836625;s:18:\"\0*\0first_timestamp\";i:1755758222;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759836625;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-07 12:17:32", "2025-10-07 12:17:32", "175270", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2863", "woocommerce_cleanup_personal_data", "complete", "2025-10-07 11:30:26", "2025-10-07 11:30:26", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759836626;s:18:\"\0*\0first_timestamp\";i:1755758231;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759836626;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-07 12:17:33", "2025-10-07 12:17:33", "175270", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2864", "woocommerce_cleanup_logs", "complete", "2025-10-07 11:30:26", "2025-10-07 11:30:26", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759836626;s:18:\"\0*\0first_timestamp\";i:1755769021;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759836626;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-07 12:17:33", "2025-10-07 12:17:33", "175270", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2865", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-10-07 11:30:26", "2025-10-07 11:30:26", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759836626;s:18:\"\0*\0first_timestamp\";i:1755769022;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759836626;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-07 12:17:33", "2025-10-07 12:17:33", "175270", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2866", "woocommerce_refresh_order_count_cache", "complete", "2025-10-06 23:30:26", "2025-10-06 23:30:26", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759793426;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759793426;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-10-07 09:26:02", "2025-10-07 09:26:02", "175268", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2867", "woocommerce_cleanup_sessions", "complete", "2025-10-06 23:30:26", "2025-10-06 23:30:26", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759793426;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759793426;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-10-07 09:26:02", "2025-10-07 09:26:02", "175268", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2868", "generate_category_lookup_table_wrapper", "complete", "2025-10-06 11:30:36", "2025-10-06 11:30:36", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759750236;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759750236;}", "12", "1", "2025-10-06 11:45:58", "2025-10-06 11:45:58", "175262", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2869", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-07 11:30:26", "2025-10-07 11:30:26", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759836626;s:18:\"\0*\0first_timestamp\";i:1755758209;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759836626;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-10-07 12:17:33", "2025-10-07 12:17:33", "175270", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("2870", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-06 14:13:04", "2025-10-06 14:13:04", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759759984;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759759984;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-06 14:41:12", "2025-10-06 14:41:12", "175266", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2871", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-06 14:13:04", "2025-10-06 14:13:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759759984;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759759984;}", "12", "1", "2025-10-06 14:41:12", "2025-10-06 14:41:12", "175266", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2872", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-06 15:41:12", "2025-10-06 15:41:12", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759765272;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759765272;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-07 09:26:02", "2025-10-07 09:26:02", "175268", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2873", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-06 15:41:12", "2025-10-06 15:41:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759765272;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759765272;}", "12", "1", "2025-10-07 09:26:02", "2025-10-07 09:26:02", "175268", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2874", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-07 10:26:02", "2025-10-07 10:26:02", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759832762;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759832762;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-07 12:17:30", "2025-10-07 12:17:30", "175270", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2875", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-07 10:26:02", "2025-10-07 10:26:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759832762;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759832762;}", "12", "1", "2025-10-07 12:17:30", "2025-10-07 12:17:30", "175270", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2876", "woocommerce_refresh_order_count_cache", "complete", "2025-10-07 21:26:02", "2025-10-07 21:26:02", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759872362;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759872362;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-10-08 07:41:22", "2025-10-08 07:41:22", "175276", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2877", "woocommerce_cleanup_sessions", "complete", "2025-10-07 21:26:02", "2025-10-07 21:26:02", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759872362;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759872362;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-10-08 07:41:22", "2025-10-08 07:41:22", "175276", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2878", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-07 13:17:30", "2025-10-07 13:17:30", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759843050;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759843050;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-07 16:45:34", "2025-10-07 16:45:34", "175272", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2879", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-07 13:17:30", "2025-10-07 13:17:30", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759843050;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759843050;}", "12", "1", "2025-10-07 16:45:34", "2025-10-07 16:45:34", "175272", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2880", "woocommerce_cleanup_draft_orders", "complete", "2025-10-08 12:17:30", "2025-10-08 12:17:30", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759925850;s:18:\"\0*\0first_timestamp\";i:1668840681;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759925850;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-10-09 07:43:59", "2025-10-09 07:43:59", "175278", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2881", "woocommerce_scheduled_sales", "complete", "2025-10-08 12:17:30", "2025-10-08 12:17:30", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759925850;s:18:\"\0*\0first_timestamp\";i:1755820800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759925850;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-09 07:43:59", "2025-10-09 07:43:59", "175278", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2882", "wc_admin_daily_wrapper", "complete", "2025-10-08 12:17:32", "2025-10-08 12:17:32", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759925852;s:18:\"\0*\0first_timestamp\";i:1755758222;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759925852;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-09 07:44:01", "2025-10-09 07:44:01", "175278", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2883", "woocommerce_cleanup_personal_data", "complete", "2025-10-08 12:17:33", "2025-10-08 12:17:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759925853;s:18:\"\0*\0first_timestamp\";i:1755758231;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759925853;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-09 07:44:02", "2025-10-09 07:44:02", "175278", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2884", "woocommerce_cleanup_logs", "complete", "2025-10-08 12:17:33", "2025-10-08 12:17:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759925853;s:18:\"\0*\0first_timestamp\";i:1755769021;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759925853;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-09 07:44:02", "2025-10-09 07:44:02", "175278", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2885", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-10-08 12:17:33", "2025-10-08 12:17:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759925853;s:18:\"\0*\0first_timestamp\";i:1755769022;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759925853;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-09 07:44:02", "2025-10-09 07:44:02", "175278", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2886", "generate_category_lookup_table_wrapper", "complete", "2025-10-07 12:17:43", "2025-10-07 12:17:43", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759839463;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759839463;}", "12", "1", "2025-10-07 16:45:34", "2025-10-07 16:45:34", "175272", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2887", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-08 12:17:33", "2025-10-08 12:17:33", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759925853;s:18:\"\0*\0first_timestamp\";i:1755758209;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759925853;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-10-09 07:44:02", "2025-10-09 07:44:02", "175278", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("2888", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-07 17:45:34", "2025-10-07 17:45:34", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759859134;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759859134;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-07 20:27:04", "2025-10-07 20:27:04", "175274", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2889", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-07 17:45:34", "2025-10-07 17:45:34", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759859134;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759859134;}", "12", "1", "2025-10-07 20:27:04", "2025-10-07 20:27:04", "175274", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2890", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-07 21:27:04", "2025-10-07 21:27:04", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759872424;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759872424;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-08 07:41:22", "2025-10-08 07:41:22", "175276", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2891", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-07 21:27:04", "2025-10-07 21:27:04", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759872424;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759872424;}", "12", "1", "2025-10-08 07:41:22", "2025-10-08 07:41:22", "175276", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2892", "woocommerce_refresh_order_count_cache", "complete", "2025-10-08 19:41:22", "2025-10-08 19:41:22", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759952482;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759952482;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-10-09 07:44:02", "2025-10-09 07:44:02", "175278", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2893", "woocommerce_cleanup_sessions", "complete", "2025-10-08 19:41:22", "2025-10-08 19:41:22", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759952482;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759952482;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-10-09 07:44:02", "2025-10-09 07:44:02", "175278", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2894", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-08 08:41:22", "2025-10-08 08:41:22", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759912882;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759912882;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-09 07:43:59", "2025-10-09 07:43:59", "175278", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2895", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-08 08:41:22", "2025-10-08 08:41:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759912882;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759912882;}", "12", "1", "2025-10-09 07:43:59", "2025-10-09 07:43:59", "175278", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2896", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-09 08:43:59", "2025-10-09 08:43:59", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1759999439;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1759999439;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-09 08:45:21", "2025-10-09 08:45:21", "175280", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2897", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-09 08:43:59", "2025-10-09 08:43:59", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759999439;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759999439;}", "12", "1", "2025-10-09 08:45:21", "2025-10-09 08:45:21", "175280", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2898", "woocommerce_cleanup_draft_orders", "complete", "2025-10-10 07:43:59", "2025-10-10 07:43:59", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760082239;s:18:\"\0*\0first_timestamp\";i:1668840681;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760082239;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-10-10 16:38:38", "2025-10-10 16:38:38", "175288", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2899", "woocommerce_scheduled_sales", "complete", "2025-10-10 07:43:59", "2025-10-10 07:43:59", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760082239;s:18:\"\0*\0first_timestamp\";i:1755820800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760082239;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-10 16:38:38", "2025-10-10 16:38:38", "175288", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2900", "wc_admin_daily_wrapper", "complete", "2025-10-10 07:44:01", "2025-10-10 07:44:01", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760082241;s:18:\"\0*\0first_timestamp\";i:1755758222;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760082241;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-10 16:38:40", "2025-10-10 16:38:40", "175288", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2901", "woocommerce_cleanup_personal_data", "complete", "2025-10-10 07:44:02", "2025-10-10 07:44:02", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760082242;s:18:\"\0*\0first_timestamp\";i:1755758231;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760082242;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-10 16:38:41", "2025-10-10 16:38:41", "175288", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2902", "woocommerce_cleanup_logs", "complete", "2025-10-10 07:44:02", "2025-10-10 07:44:02", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760082242;s:18:\"\0*\0first_timestamp\";i:1755769021;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760082242;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-10 16:38:41", "2025-10-10 16:38:41", "175288", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2903", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-10-10 07:44:02", "2025-10-10 07:44:02", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760082242;s:18:\"\0*\0first_timestamp\";i:1755769022;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760082242;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-10 16:38:41", "2025-10-10 16:38:41", "175288", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2904", "woocommerce_refresh_order_count_cache", "complete", "2025-10-09 19:44:02", "2025-10-09 19:44:02", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760039042;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760039042;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-10-09 23:30:08", "2025-10-09 23:30:08", "175282", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2905", "woocommerce_cleanup_sessions", "complete", "2025-10-09 19:44:02", "2025-10-09 19:44:02", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760039042;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760039042;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-10-09 23:30:08", "2025-10-09 23:30:08", "175282", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2906", "generate_category_lookup_table_wrapper", "complete", "2025-10-09 07:44:12", "2025-10-09 07:44:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1759995852;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1759995852;}", "12", "1", "2025-10-09 08:45:21", "2025-10-09 08:45:21", "175280", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2907", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-10 07:44:02", "2025-10-10 07:44:02", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760082242;s:18:\"\0*\0first_timestamp\";i:1755758209;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760082242;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-10-10 16:38:41", "2025-10-10 16:38:41", "175288", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("2908", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-09 09:45:21", "2025-10-09 09:45:21", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760003121;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760003121;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-09 23:30:08", "2025-10-09 23:30:08", "175282", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2909", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-09 09:45:21", "2025-10-09 09:45:21", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760003121;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760003121;}", "12", "1", "2025-10-09 23:30:08", "2025-10-09 23:30:08", "175282", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2910", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-10 00:30:08", "2025-10-10 00:30:08", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760056208;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760056208;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-10 04:20:29", "2025-10-10 04:20:29", "175284", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2911", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-10 00:30:08", "2025-10-10 00:30:08", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760056208;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760056208;}", "12", "1", "2025-10-10 04:20:29", "2025-10-10 04:20:29", "175284", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2912", "woocommerce_refresh_order_count_cache", "complete", "2025-10-10 11:30:08", "2025-10-10 11:30:08", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760095808;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760095808;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-10-10 16:38:41", "2025-10-10 16:38:41", "175288", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2913", "woocommerce_cleanup_sessions", "complete", "2025-10-10 11:30:08", "2025-10-10 11:30:08", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760095808;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760095808;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-10-10 16:38:41", "2025-10-10 16:38:41", "175288", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2914", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-10 05:20:29", "2025-10-10 05:20:29", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760073629;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760073629;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-10 07:29:56", "2025-10-10 07:29:56", "175286", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2915", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-10 05:20:29", "2025-10-10 05:20:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760073629;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760073629;}", "12", "1", "2025-10-10 07:29:56", "2025-10-10 07:29:56", "175286", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2916", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-10 08:29:56", "2025-10-10 08:29:56", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760084996;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760084996;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-10 16:38:41", "2025-10-10 16:38:41", "175288", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2917", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-10 08:29:56", "2025-10-10 08:29:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760084996;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760084996;}", "12", "1", "2025-10-10 16:38:41", "2025-10-10 16:38:41", "175288", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2918", "woocommerce_cleanup_draft_orders", "complete", "2025-10-11 16:38:38", "2025-10-11 16:38:38", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760200718;s:18:\"\0*\0first_timestamp\";i:1668840681;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760200718;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "1", "2025-10-12 04:43:58", "2025-10-12 04:43:58", "175298", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2919", "woocommerce_scheduled_sales", "complete", "2025-10-11 16:38:38", "2025-10-11 16:38:38", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760200718;s:18:\"\0*\0first_timestamp\";i:1755820800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760200718;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-12 04:43:58", "2025-10-12 04:43:58", "175298", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2920", "wc_admin_daily_wrapper", "complete", "2025-10-11 16:38:40", "2025-10-11 16:38:40", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760200720;s:18:\"\0*\0first_timestamp\";i:1755758222;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760200720;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-12 04:44:00", "2025-10-12 04:44:00", "175298", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2921", "woocommerce_cleanup_personal_data", "complete", "2025-10-11 16:38:41", "2025-10-11 16:38:41", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760200721;s:18:\"\0*\0first_timestamp\";i:1755758231;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760200721;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-12 04:44:01", "2025-10-12 04:44:01", "175298", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2922", "woocommerce_cleanup_logs", "complete", "2025-10-11 16:38:41", "2025-10-11 16:38:41", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760200721;s:18:\"\0*\0first_timestamp\";i:1755769021;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760200721;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-12 04:44:01", "2025-10-12 04:44:01", "175298", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2923", "woocommerce_cleanup_rate_limits_wrapper", "complete", "2025-10-11 16:38:41", "2025-10-11 16:38:41", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760200721;s:18:\"\0*\0first_timestamp\";i:1755769022;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760200721;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "1", "2025-10-12 04:44:01", "2025-10-12 04:44:01", "175298", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2924", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-10 17:38:41", "2025-10-10 17:38:41", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760117921;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760117921;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-10 21:03:54", "2025-10-10 21:03:54", "175292", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2925", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-10 17:38:41", "2025-10-10 17:38:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760117921;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760117921;}", "12", "1", "2025-10-10 21:03:54", "2025-10-10 21:03:54", "175292", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2926", "woocommerce_refresh_order_count_cache", "complete", "2025-10-11 04:38:41", "2025-10-11 04:38:41", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760157521;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760157521;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-10-11 10:11:27", "2025-10-11 10:11:27", "175294", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2927", "woocommerce_cleanup_sessions", "complete", "2025-10-11 04:38:41", "2025-10-11 04:38:41", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760157521;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760157521;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-10-11 10:11:27", "2025-10-11 10:11:27", "175294", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2928", "generate_category_lookup_table_wrapper", "complete", "2025-10-10 16:38:51", "2025-10-10 16:38:51", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760114331;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760114331;}", "12", "1", "2025-10-10 16:59:19", "2025-10-10 16:59:19", "175290", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2929", "action_scheduler_run_recurring_actions_schedule_hook", "complete", "2025-10-11 16:38:41", "2025-10-11 16:38:41", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760200721;s:18:\"\0*\0first_timestamp\";i:1755758209;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760200721;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "1", "2025-10-12 04:44:01", "2025-10-12 04:44:01", "175298", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("2930", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-10 22:03:54", "2025-10-10 22:03:54", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760133834;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760133834;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-11 10:11:27", "2025-10-11 10:11:27", "175294", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2931", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-10 22:03:54", "2025-10-10 22:03:54", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760133834;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760133834;}", "12", "1", "2025-10-11 10:11:27", "2025-10-11 10:11:27", "175294", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2932", "wc-admin_import_orders", "complete", "2025-10-11 08:28:20", "2025-10-11 08:28:20", "[5467]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760171300;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760171300;}", "3", "1", "2025-10-11 10:11:27", "2025-10-11 10:11:27", "175294", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2933", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-11 11:11:27", "2025-10-11 11:11:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760181087;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760181087;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-11 12:23:45", "2025-10-11 12:23:45", "175296", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2934", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-11 11:11:27", "2025-10-11 11:11:27", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760181087;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760181087;}", "12", "1", "2025-10-11 12:23:45", "2025-10-11 12:23:45", "175296", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2935", "woocommerce_refresh_order_count_cache", "complete", "2025-10-11 22:11:27", "2025-10-11 22:11:27", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760220687;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760220687;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "1", "2025-10-12 04:44:01", "2025-10-12 04:44:01", "175298", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2936", "woocommerce_cleanup_sessions", "complete", "2025-10-11 22:11:27", "2025-10-11 22:11:27", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760220687;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760220687;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "1", "2025-10-12 04:44:01", "2025-10-12 04:44:01", "175298", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2937", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-11 13:23:45", "2025-10-11 13:23:45", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760189025;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760189025;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-12 04:43:58", "2025-10-12 04:43:58", "175298", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2938", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-11 13:23:45", "2025-10-11 13:23:45", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760189025;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760189025;}", "12", "1", "2025-10-12 04:43:58", "2025-10-12 04:43:58", "175298", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2939", "woocommerce_custom_orders_table_background_sync", "complete", "2025-10-12 05:43:58", "2025-10-12 05:43:58", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760247838;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760247838;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "1", "2025-10-12 05:44:02", "2025-10-12 05:44:02", "175306", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2940", "woocommerce_cancel_unpaid_orders", "complete", "2025-10-12 05:43:58", "2025-10-12 05:43:58", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760247838;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760247838;}", "12", "1", "2025-10-12 05:44:02", "2025-10-12 05:44:02", "175306", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2941", "woocommerce_cleanup_draft_orders", "pending", "2025-10-13 04:43:58", "2025-10-13 04:43:58", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760330638;s:18:\"\0*\0first_timestamp\";i:1668840681;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760330638;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "5", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2942", "woocommerce_scheduled_sales", "pending", "2025-10-13 04:43:58", "2025-10-13 04:43:58", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760330638;s:18:\"\0*\0first_timestamp\";i:1755820800;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760330638;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2943", "wc_admin_daily_wrapper", "pending", "2025-10-13 04:44:00", "2025-10-13 04:44:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760330640;s:18:\"\0*\0first_timestamp\";i:1755758222;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760330640;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2944", "woocommerce_cleanup_personal_data", "pending", "2025-10-13 04:44:01", "2025-10-13 04:44:01", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760330641;s:18:\"\0*\0first_timestamp\";i:1755758231;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760330641;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2945", "woocommerce_cleanup_logs", "pending", "2025-10-13 04:44:01", "2025-10-13 04:44:01", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760330641;s:18:\"\0*\0first_timestamp\";i:1755769021;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760330641;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2946", "woocommerce_cleanup_rate_limits_wrapper", "pending", "2025-10-13 04:44:01", "2025-10-13 04:44:01", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760330641;s:18:\"\0*\0first_timestamp\";i:1755769022;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760330641;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "12", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2947", "woocommerce_refresh_order_count_cache", "pending", "2025-10-12 16:44:01", "2025-10-12 16:44:01", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760287441;s:18:\"\0*\0first_timestamp\";i:1749612286;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760287441;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "9", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2948", "woocommerce_cleanup_sessions", "pending", "2025-10-12 16:44:01", "2025-10-12 16:44:01", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760287441;s:18:\"\0*\0first_timestamp\";i:1755779822;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760287441;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "12", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2949", "generate_category_lookup_table_wrapper", "complete", "2025-10-12 04:44:11", "2025-10-12 04:44:11", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760244251;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760244251;}", "12", "1", "2025-10-12 04:46:10", "2025-10-12 04:46:10", "175300", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2950", "action_scheduler_run_recurring_actions_schedule_hook", "pending", "2025-10-13 04:44:01", "2025-10-13 04:44:01", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760330641;s:18:\"\0*\0first_timestamp\";i:1755758209;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760330641;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "11", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "20");
INSERT INTO `wp_actionscheduler_actions` VALUES("2951", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-10-12 05:13:07", "2025-10-12 05:13:07", "[3507,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760245987;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760245987;}", "2", "1", "2025-10-12 05:13:33", "2025-10-12 05:13:33", "175302", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2952", "action_scheduler/migration_hook", "complete", "2025-10-12 05:17:41", "2025-10-12 05:17:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760246261;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760246261;}", "1", "1", "2025-10-12 05:17:44", "2025-10-12 05:17:44", "175304", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2953", "action_scheduler/migration_hook", "canceled", "2025-10-12 05:17:41", "2025-10-12 05:17:41", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760246261;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760246261;}", "1", "0", "2025-10-12 05:17:44", "2025-10-12 05:17:44", "175304", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2954", "woocommerce_custom_orders_table_background_sync", "pending", "2025-10-12 06:44:02", "2025-10-12 06:44:02", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1760251442;s:18:\"\0*\0first_timestamp\";i:1754733345;s:13:\"\0*\0recurrence\";i:3600;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1760251442;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:3600;}", "5", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2955", "woocommerce_cancel_unpaid_orders", "pending", "2025-10-12 06:44:02", "2025-10-12 06:44:02", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760251442;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760251442;}", "12", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2956", "fetch_patterns", "complete", "2025-10-12 06:14:12", "2025-10-12 06:14:12", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760249652;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760249652;}", "5", "1", "2025-10-12 06:14:40", "2025-10-12 06:14:40", "175308", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2957", "woocommerce_run_on_woocommerce_admin_updated", "complete", "2025-10-12 06:14:19", "2025-10-12 06:14:19", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760249659;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760249659;}", "4", "1", "2025-10-12 06:14:40", "2025-10-12 06:14:40", "175308", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("2958", "action_scheduler/migration_hook", "complete", "2025-10-12 06:20:05", "2025-10-12 06:20:05", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1760250005;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1760250005;}", "1", "1", "2025-10-12 06:20:55", "2025-10-12 06:20:55", "175310", NULL, "10");

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "woocommerce-db-updates");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "wc-admin-data");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "woocommerce-remote-inbox-engine");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "");
INSERT INTO `wp_actionscheduler_groups` VALUES("6", "rocket-preload");
INSERT INTO `wp_actionscheduler_groups` VALUES("7", "wc_update_product_default_cat");
INSERT INTO `wp_actionscheduler_groups` VALUES("8", "wc_delete_related_product_transients_group");
INSERT INTO `wp_actionscheduler_groups` VALUES("9", "count");
INSERT INTO `wp_actionscheduler_groups` VALUES("10", "wc_batch_processes");
INSERT INTO `wp_actionscheduler_groups` VALUES("11", "ActionScheduler");
INSERT INTO `wp_actionscheduler_groups` VALUES("12", "woocommerce");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("953", "325", "ایجاد فعالیت", "2023-02-24 23:55:34", "2023-02-24 22:55:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("954", "325", "عملیات توسط WP Cron شروع شد", "2023-02-24 23:55:37", "2023-02-24 22:55:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("955", "325", "اقدام از طریق WP Cron انجام نشد: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.", "2023-02-24 23:55:37", "2023-02-24 22:55:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1079", "367", "ایجاد فعالیت", "2023-03-15 04:52:22", "2023-03-15 03:52:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1080", "367", "عملیات توسط WP Cron شروع شد", "2023-03-15 04:52:23", "2023-03-15 03:52:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1081", "367", "اقدام از طریق WP Cron انجام نشد: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.", "2023-03-15 04:52:23", "2023-03-15 03:52:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1088", "370", "ایجاد فعالیت", "2023-03-15 05:23:56", "2023-03-15 04:23:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1089", "370", "عملیات توسط WP Cron شروع شد", "2023-03-15 05:25:10", "2023-03-15 04:25:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1090", "370", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-03-15 05:25:10", "2023-03-15 04:25:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1352", "458", "ایجاد فعالیت", "2023-04-28 23:53:00", "2023-04-28 23:53:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("1353", "458", "عملیات توسط WP Cron شروع شد", "2023-04-28 23:53:02", "2023-04-28 23:53:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1354", "458", "اقدام از طریق WP Cron انجام نشد: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.", "2023-04-28 23:53:02", "2023-04-28 23:53:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1382", "468", "ایجاد فعالیت", "2023-04-30 16:43:55", "2023-04-30 16:43:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1383", "469", "ایجاد فعالیت", "2023-04-30 16:43:55", "2023-04-30 16:43:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1384", "468", "عملیات توسط Async Request شروع شد", "2023-04-30 16:45:00", "2023-04-30 16:45:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("1385", "468", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-04-30 16:45:00", "2023-04-30 16:45:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("1386", "469", "عملیات توسط Async Request شروع شد", "2023-04-30 16:45:00", "2023-04-30 16:45:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("1387", "469", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-04-30 16:45:00", "2023-04-30 16:45:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("1427", "483", "ایجاد فعالیت", "2023-05-13 12:03:00", "2023-05-13 12:03:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("1428", "483", "عملیات توسط WP Cron شروع شد", "2023-05-13 12:03:03", "2023-05-13 12:03:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1429", "483", "اقدام از طریق WP Cron انجام نشد: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.", "2023-05-13 12:03:03", "2023-05-13 12:03:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1430", "484", "ایجاد فعالیت", "2023-05-13 12:03:04", "2023-05-13 12:03:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("1431", "484", "عملیات توسط WP Cron شروع شد", "2023-05-13 12:03:06", "2023-05-13 12:03:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1432", "484", "اقدام از طریق WP Cron انجام نشد: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.", "2023-05-13 12:03:06", "2023-05-13 12:03:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1460", "494", "ایجاد فعالیت", "2023-05-27 01:38:57", "2023-05-27 01:38:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("1461", "494", "عملیات توسط WP Cron شروع شد", "2023-05-27 01:40:59", "2023-05-27 01:40:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1462", "494", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-05-27 01:40:59", "2023-05-27 01:40:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1487", "503", "ایجاد فعالیت", "2023-06-02 14:15:29", "2023-06-02 14:15:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1488", "503", "عملیات توسط Async Request شروع شد", "2023-06-02 14:16:41", "2023-06-02 14:16:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("1489", "503", "اقدام از طریق Async Request انجام نشد: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.", "2023-06-02 14:16:41", "2023-06-02 14:16:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("1715", "579", "ایجاد فعالیت", "2023-08-30 19:04:26", "2023-08-30 19:04:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1716", "579", "عملیات توسط Async Request شروع شد", "2023-08-30 19:05:27", "2023-08-30 19:05:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1717", "579", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-08-30 19:05:27", "2023-08-30 19:05:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1805", "609", "ایجاد فعالیت", "2023-09-11 07:49:23", "2023-09-11 07:49:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("1806", "609", "عملیات توسط Async Request شروع شد", "2023-09-11 07:52:52", "2023-09-11 07:52:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1807", "609", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-09-11 07:52:52", "2023-09-11 07:52:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("2536", "853", "ایجاد فعالیت", "2023-09-23 03:16:32", "2023-09-23 03:16:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2539", "853", "عملیات توسط Async Request شروع شد", "2023-09-23 03:17:47", "2023-09-23 03:17:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("2540", "853", "اقدام از طریق Async Request انجام نشد: Scheduled action for rocket_preload_job_check_finished will not be executed as no callbacks are registered.", "2023-09-23 03:17:47", "2023-09-23 03:17:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("3113", "1045", "ایجاد فعالیت", "2024-01-22 07:22:12", "2024-01-22 06:22:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("3114", "1045", "عملیات توسط Async Request شروع شد", "2024-01-22 07:23:40", "2024-01-22 06:23:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("3115", "1045", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-01-22 07:23:40", "2024-01-22 06:23:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("3119", "1047", "ایجاد فعالیت", "2024-01-22 11:33:20", "2024-01-22 10:33:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("3120", "1047", "عملیات توسط Async Request شروع شد", "2024-01-22 11:34:24", "2024-01-22 10:34:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("3121", "1047", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-01-22 11:34:24", "2024-01-22 10:34:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("3912", "1312", "ایجاد فعالیت", "2024-07-01 14:32:10", "2024-07-01 14:32:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("3913", "1312", "عملیات توسط Async Request شروع شد", "2024-07-01 14:33:34", "2024-07-01 14:33:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("3914", "1312", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-07-01 14:33:34", "2024-07-01 14:33:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("4558", "1527", "ایجاد فعالیت", "2024-11-19 07:26:51", "2024-11-19 06:26:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("4559", "1527", "عملیات توسط Async Request شروع شد", "2024-11-19 07:27:56", "2024-11-19 06:27:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4560", "1527", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-11-19 07:27:56", "2024-11-19 06:27:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("4624", "1549", "ایجاد فعالیت", "2024-12-01 13:54:09", "2024-12-01 12:54:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("4625", "1549", "عملیات توسط Async Request شروع شد", "2024-12-01 13:55:10", "2024-12-01 12:55:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("4626", "1549", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-12-01 13:55:10", "2024-12-01 12:55:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("5122", "1715", "ایجاد فعالیت", "2025-03-05 03:12:15", "2025-03-05 02:12:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("5123", "1715", "عملیات توسط Async Request شروع شد", "2025-03-05 03:13:28", "2025-03-05 02:13:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("5124", "1715", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2025-03-05 03:13:28", "2025-03-05 02:13:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("6859", "2300", "ایجاد فعالیت", "2025-09-05 07:31:38", "2025-09-05 07:31:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7084", "2375", "ایجاد فعالیت", "2025-09-10 18:10:33", "2025-09-10 18:10:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("7087", "2376", "ایجاد فعالیت", "2025-09-10 18:10:33", "2025-09-10 18:10:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("7090", "2377", "ایجاد فعالیت", "2025-09-10 18:10:35", "2025-09-10 18:10:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("7093", "2378", "ایجاد فعالیت", "2025-09-10 18:10:36", "2025-09-10 18:10:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7096", "2379", "ایجاد فعالیت", "2025-09-10 18:10:36", "2025-09-10 18:10:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7099", "2380", "ایجاد فعالیت", "2025-09-10 18:10:36", "2025-09-10 18:10:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7104", "2383", "ایجاد فعالیت", "2025-09-10 18:10:36", "2025-09-10 18:10:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7114", "2385", "ایجاد فعالیت", "2025-09-10 20:07:47", "2025-09-10 20:07:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("7117", "2386", "ایجاد فعالیت", "2025-09-10 20:07:47", "2025-09-10 20:07:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("7123", "2388", "ایجاد فعالیت", "2025-09-11 04:21:47", "2025-09-11 04:21:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("7124", "2388", "عملیات توسط Async Request شروع شد", "2025-09-11 17:17:18", "2025-09-11 17:17:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("7125", "2388", "عملیات توسط Async Request کامل شد", "2025-09-11 17:17:18", "2025-09-11 17:17:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("7126", "2389", "ایجاد فعالیت", "2025-09-11 17:17:18", "2025-09-11 17:17:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("7127", "2385", "عملیات توسط Async Request شروع شد", "2025-09-11 17:17:18", "2025-09-11 17:17:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("7128", "2385", "عملیات توسط Async Request کامل شد", "2025-09-11 17:17:18", "2025-09-11 17:17:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("7129", "2390", "ایجاد فعالیت", "2025-09-11 17:17:18", "2025-09-11 17:17:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("7130", "2386", "عملیات توسط Async Request شروع شد", "2025-09-11 17:17:18", "2025-09-11 17:17:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("7131", "2386", "عملیات توسط Async Request کامل شد", "2025-09-11 17:17:18", "2025-09-11 17:17:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("7132", "2391", "ایجاد فعالیت", "2025-09-11 17:17:18", "2025-09-11 17:17:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("7133", "2375", "عملیات توسط Async Request شروع شد", "2025-09-11 19:23:04", "2025-09-11 19:23:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7134", "2375", "عملیات توسط Async Request کامل شد", "2025-09-11 19:23:04", "2025-09-11 19:23:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7135", "2392", "ایجاد فعالیت", "2025-09-11 19:23:04", "2025-09-11 19:23:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7136", "2376", "عملیات توسط Async Request شروع شد", "2025-09-11 19:23:04", "2025-09-11 19:23:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7137", "2376", "عملیات توسط Async Request کامل شد", "2025-09-11 19:23:04", "2025-09-11 19:23:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7138", "2393", "ایجاد فعالیت", "2025-09-11 19:23:04", "2025-09-11 19:23:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7139", "2377", "عملیات توسط Async Request شروع شد", "2025-09-11 19:23:04", "2025-09-11 19:23:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7140", "2377", "عملیات توسط Async Request کامل شد", "2025-09-11 19:23:06", "2025-09-11 19:23:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7141", "2394", "ایجاد فعالیت", "2025-09-11 19:23:06", "2025-09-11 19:23:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7142", "2378", "عملیات توسط Async Request شروع شد", "2025-09-11 19:23:06", "2025-09-11 19:23:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7143", "2378", "عملیات توسط Async Request کامل شد", "2025-09-11 19:23:07", "2025-09-11 19:23:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("7144", "2395", "ایجاد فعالیت", "2025-09-11 19:23:07", "2025-09-11 19:23:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("7145", "2379", "عملیات توسط Async Request شروع شد", "2025-09-11 19:23:07", "2025-09-11 19:23:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("7146", "2379", "عملیات توسط Async Request کامل شد", "2025-09-11 19:23:08", "2025-09-11 19:23:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("7147", "2396", "ایجاد فعالیت", "2025-09-11 19:23:08", "2025-09-11 19:23:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("7148", "2380", "عملیات توسط Async Request شروع شد", "2025-09-11 19:23:08", "2025-09-11 19:23:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("7149", "2380", "عملیات توسط Async Request کامل شد", "2025-09-11 19:23:08", "2025-09-11 19:23:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("7150", "2397", "ایجاد فعالیت", "2025-09-11 19:23:08", "2025-09-11 19:23:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("7151", "2389", "عملیات توسط Async Request شروع شد", "2025-09-11 19:23:08", "2025-09-11 19:23:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("7152", "2389", "عملیات توسط Async Request کامل شد", "2025-09-11 19:23:08", "2025-09-11 19:23:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("7153", "2398", "ایجاد فعالیت", "2025-09-11 19:23:08", "2025-09-11 19:23:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("7154", "2383", "عملیات توسط Async Request شروع شد", "2025-09-11 19:23:08", "2025-09-11 19:23:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("7155", "2399", "ایجاد فعالیت", "2025-09-11 19:23:08", "2025-09-11 19:23:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("7156", "2400", "ایجاد فعالیت", "2025-09-11 19:23:08", "2025-09-11 19:23:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("7157", "2383", "عملیات توسط Async Request کامل شد", "2025-09-11 19:23:08", "2025-09-11 19:23:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("7158", "2401", "ایجاد فعالیت", "2025-09-11 19:23:08", "2025-09-11 19:23:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("7159", "2400", "عملیات توسط Async Request شروع شد", "2025-09-11 19:29:19", "2025-09-11 19:29:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("7160", "2400", "عملیات توسط Async Request کامل شد", "2025-09-11 19:29:19", "2025-09-11 19:29:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("7161", "2398", "عملیات توسط Async Request شروع شد", "2025-09-12 06:49:47", "2025-09-12 06:49:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("7162", "2398", "عملیات توسط Async Request کامل شد", "2025-09-12 06:49:47", "2025-09-12 06:49:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("7163", "2402", "ایجاد فعالیت", "2025-09-12 06:49:47", "2025-09-12 06:49:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("7164", "2399", "عملیات توسط Async Request شروع شد", "2025-09-12 06:49:47", "2025-09-12 06:49:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("7165", "2399", "عملیات توسط Async Request کامل شد", "2025-09-12 06:49:47", "2025-09-12 06:49:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("7166", "2390", "عملیات توسط Async Request شروع شد", "2025-09-12 06:49:47", "2025-09-12 06:49:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("7167", "2390", "عملیات توسط Async Request کامل شد", "2025-09-12 06:49:47", "2025-09-12 06:49:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("7168", "2403", "ایجاد فعالیت", "2025-09-12 06:49:47", "2025-09-12 06:49:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("7169", "2391", "عملیات توسط Async Request شروع شد", "2025-09-12 06:49:47", "2025-09-12 06:49:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("7170", "2391", "عملیات توسط Async Request کامل شد", "2025-09-12 06:49:47", "2025-09-12 06:49:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("7171", "2404", "ایجاد فعالیت", "2025-09-12 06:49:47", "2025-09-12 06:49:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("7172", "2402", "عملیات توسط Async Request شروع شد", "2025-09-12 09:38:38", "2025-09-12 09:38:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7173", "2402", "عملیات توسط Async Request کامل شد", "2025-09-12 09:38:38", "2025-09-12 09:38:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7174", "2405", "ایجاد فعالیت", "2025-09-12 09:38:38", "2025-09-12 09:38:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7175", "2405", "عملیات توسط Async Request شروع شد", "2025-09-12 11:48:52", "2025-09-12 11:48:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("7176", "2405", "عملیات توسط Async Request کامل شد", "2025-09-12 11:48:52", "2025-09-12 11:48:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("7177", "2406", "ایجاد فعالیت", "2025-09-12 11:48:52", "2025-09-12 11:48:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("7178", "2406", "عملیات توسط Async Request شروع شد", "2025-09-12 12:57:24", "2025-09-12 12:57:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7179", "2406", "عملیات توسط Async Request کامل شد", "2025-09-12 12:57:24", "2025-09-12 12:57:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7180", "2407", "ایجاد فعالیت", "2025-09-12 12:57:24", "2025-09-12 12:57:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7181", "2407", "عملیات توسط Async Request شروع شد", "2025-09-12 16:33:32", "2025-09-12 16:33:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("7182", "2407", "عملیات توسط Async Request کامل شد", "2025-09-12 16:33:32", "2025-09-12 16:33:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("7183", "2408", "ایجاد فعالیت", "2025-09-12 16:33:32", "2025-09-12 16:33:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("7184", "2408", "عملیات توسط Async Request شروع شد", "2025-09-12 18:13:25", "2025-09-12 18:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("7185", "2408", "عملیات توسط Async Request کامل شد", "2025-09-12 18:13:25", "2025-09-12 18:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("7186", "2409", "ایجاد فعالیت", "2025-09-12 18:13:25", "2025-09-12 18:13:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("7187", "2403", "عملیات توسط Async Request شروع شد", "2025-09-13 06:27:36", "2025-09-13 06:27:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7188", "2403", "عملیات توسط Async Request کامل شد", "2025-09-13 06:27:36", "2025-09-13 06:27:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7189", "2410", "ایجاد فعالیت", "2025-09-13 06:27:36", "2025-09-13 06:27:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7190", "2404", "عملیات توسط Async Request شروع شد", "2025-09-13 06:27:36", "2025-09-13 06:27:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7191", "2404", "عملیات توسط Async Request کامل شد", "2025-09-13 06:27:36", "2025-09-13 06:27:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7192", "2411", "ایجاد فعالیت", "2025-09-13 06:27:36", "2025-09-13 06:27:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7193", "2409", "عملیات توسط Async Request شروع شد", "2025-09-13 06:27:36", "2025-09-13 06:27:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7194", "2409", "عملیات توسط Async Request کامل شد", "2025-09-13 06:27:36", "2025-09-13 06:27:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7195", "2412", "ایجاد فعالیت", "2025-09-13 06:27:36", "2025-09-13 06:27:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7196", "2392", "عملیات توسط Async Request شروع شد", "2025-09-13 06:27:36", "2025-09-13 06:27:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7197", "2392", "عملیات توسط Async Request کامل شد", "2025-09-13 06:27:36", "2025-09-13 06:27:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7198", "2413", "ایجاد فعالیت", "2025-09-13 06:27:36", "2025-09-13 06:27:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7199", "2393", "عملیات توسط Async Request شروع شد", "2025-09-13 06:27:36", "2025-09-13 06:27:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7200", "2393", "عملیات توسط Async Request کامل شد", "2025-09-13 06:27:36", "2025-09-13 06:27:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7201", "2414", "ایجاد فعالیت", "2025-09-13 06:27:36", "2025-09-13 06:27:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7202", "2394", "عملیات توسط Async Request شروع شد", "2025-09-13 06:27:36", "2025-09-13 06:27:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7203", "2394", "عملیات توسط Async Request کامل شد", "2025-09-13 06:27:39", "2025-09-13 06:27:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("7204", "2415", "ایجاد فعالیت", "2025-09-13 06:27:39", "2025-09-13 06:27:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("7205", "2395", "عملیات توسط Async Request شروع شد", "2025-09-13 06:27:39", "2025-09-13 06:27:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("7206", "2395", "عملیات توسط Async Request کامل شد", "2025-09-13 06:27:40", "2025-09-13 06:27:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7207", "2416", "ایجاد فعالیت", "2025-09-13 06:27:40", "2025-09-13 06:27:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7208", "2396", "عملیات توسط Async Request شروع شد", "2025-09-13 06:27:40", "2025-09-13 06:27:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7209", "2396", "عملیات توسط Async Request کامل شد", "2025-09-13 06:27:40", "2025-09-13 06:27:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7210", "2417", "ایجاد فعالیت", "2025-09-13 06:27:40", "2025-09-13 06:27:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7211", "2397", "عملیات توسط Async Request شروع شد", "2025-09-13 06:27:40", "2025-09-13 06:27:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7212", "2397", "عملیات توسط Async Request کامل شد", "2025-09-13 06:27:40", "2025-09-13 06:27:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7213", "2418", "ایجاد فعالیت", "2025-09-13 06:27:40", "2025-09-13 06:27:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7214", "2401", "عملیات توسط Async Request شروع شد", "2025-09-13 06:27:40", "2025-09-13 06:27:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7215", "2419", "ایجاد فعالیت", "2025-09-13 06:27:40", "2025-09-13 06:27:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7216", "2420", "ایجاد فعالیت", "2025-09-13 06:27:40", "2025-09-13 06:27:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7217", "2401", "عملیات توسط Async Request کامل شد", "2025-09-13 06:27:40", "2025-09-13 06:27:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7218", "2421", "ایجاد فعالیت", "2025-09-13 06:27:40", "2025-09-13 06:27:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7219", "2420", "عملیات توسط Async Request شروع شد", "2025-09-13 07:21:12", "2025-09-13 07:21:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("7220", "2420", "عملیات توسط Async Request کامل شد", "2025-09-13 07:21:12", "2025-09-13 07:21:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("7221", "2412", "عملیات توسط Async Request شروع شد", "2025-09-13 18:56:37", "2025-09-13 18:56:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7222", "2412", "عملیات توسط Async Request کامل شد", "2025-09-13 18:56:37", "2025-09-13 18:56:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7223", "2422", "ایجاد فعالیت", "2025-09-13 18:56:37", "2025-09-13 18:56:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7224", "2419", "عملیات توسط Async Request شروع شد", "2025-09-13 18:56:37", "2025-09-13 18:56:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7225", "2419", "عملیات توسط Async Request کامل شد", "2025-09-13 18:56:37", "2025-09-13 18:56:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7226", "2410", "عملیات توسط Async Request شروع شد", "2025-09-13 18:56:37", "2025-09-13 18:56:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7227", "2410", "عملیات توسط Async Request کامل شد", "2025-09-13 18:56:37", "2025-09-13 18:56:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7228", "2423", "ایجاد فعالیت", "2025-09-13 18:56:37", "2025-09-13 18:56:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7229", "2411", "عملیات توسط Async Request شروع شد", "2025-09-13 18:56:37", "2025-09-13 18:56:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7230", "2411", "عملیات توسط Async Request کامل شد", "2025-09-13 18:56:37", "2025-09-13 18:56:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7231", "2424", "ایجاد فعالیت", "2025-09-13 18:56:37", "2025-09-13 18:56:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7232", "2422", "عملیات توسط Async Request شروع شد", "2025-09-14 08:58:13", "2025-09-14 08:58:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("7233", "2422", "عملیات توسط Async Request کامل شد", "2025-09-14 08:58:13", "2025-09-14 08:58:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("7234", "2425", "ایجاد فعالیت", "2025-09-14 08:58:13", "2025-09-14 08:58:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("7235", "2413", "عملیات توسط Async Request شروع شد", "2025-09-14 08:58:13", "2025-09-14 08:58:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("7236", "2413", "عملیات توسط Async Request کامل شد", "2025-09-14 08:58:13", "2025-09-14 08:58:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("7237", "2426", "ایجاد فعالیت", "2025-09-14 08:58:13", "2025-09-14 08:58:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("7238", "2414", "عملیات توسط Async Request شروع شد", "2025-09-14 08:58:13", "2025-09-14 08:58:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("7239", "2414", "عملیات توسط Async Request کامل شد", "2025-09-14 08:58:13", "2025-09-14 08:58:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("7240", "2427", "ایجاد فعالیت", "2025-09-14 08:58:13", "2025-09-14 08:58:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("7241", "2415", "عملیات توسط Async Request شروع شد", "2025-09-14 08:58:13", "2025-09-14 08:58:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("7242", "2415", "عملیات توسط Async Request کامل شد", "2025-09-14 08:58:15", "2025-09-14 08:58:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("7243", "2428", "ایجاد فعالیت", "2025-09-14 08:58:15", "2025-09-14 08:58:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("7244", "2416", "عملیات توسط Async Request شروع شد", "2025-09-14 08:58:15", "2025-09-14 08:58:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("7245", "2416", "عملیات توسط Async Request کامل شد", "2025-09-14 08:58:16", "2025-09-14 08:58:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7246", "2429", "ایجاد فعالیت", "2025-09-14 08:58:16", "2025-09-14 08:58:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7247", "2417", "عملیات توسط Async Request شروع شد", "2025-09-14 08:58:16", "2025-09-14 08:58:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7248", "2417", "عملیات توسط Async Request کامل شد", "2025-09-14 08:58:16", "2025-09-14 08:58:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7249", "2430", "ایجاد فعالیت", "2025-09-14 08:58:16", "2025-09-14 08:58:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7250", "2418", "عملیات توسط Async Request شروع شد", "2025-09-14 08:58:16", "2025-09-14 08:58:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7251", "2418", "عملیات توسط Async Request کامل شد", "2025-09-14 08:58:16", "2025-09-14 08:58:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7252", "2431", "ایجاد فعالیت", "2025-09-14 08:58:16", "2025-09-14 08:58:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7253", "2423", "عملیات توسط Async Request شروع شد", "2025-09-14 08:58:16", "2025-09-14 08:58:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7254", "2423", "عملیات توسط Async Request کامل شد", "2025-09-14 08:58:16", "2025-09-14 08:58:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7255", "2432", "ایجاد فعالیت", "2025-09-14 08:58:16", "2025-09-14 08:58:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7256", "2424", "عملیات توسط Async Request شروع شد", "2025-09-14 08:58:16", "2025-09-14 08:58:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7257", "2424", "عملیات توسط Async Request کامل شد", "2025-09-14 08:58:16", "2025-09-14 08:58:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7258", "2433", "ایجاد فعالیت", "2025-09-14 08:58:16", "2025-09-14 08:58:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7259", "2421", "عملیات توسط Async Request شروع شد", "2025-09-14 08:58:16", "2025-09-14 08:58:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7260", "2434", "ایجاد فعالیت", "2025-09-14 08:58:16", "2025-09-14 08:58:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7261", "2435", "ایجاد فعالیت", "2025-09-14 08:58:16", "2025-09-14 08:58:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7262", "2421", "عملیات توسط Async Request کامل شد", "2025-09-14 08:58:16", "2025-09-14 08:58:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7263", "2436", "ایجاد فعالیت", "2025-09-14 08:58:16", "2025-09-14 08:58:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7264", "2435", "عملیات توسط Async Request شروع شد", "2025-09-14 08:59:20", "2025-09-14 08:59:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7265", "2435", "عملیات توسط Async Request کامل شد", "2025-09-14 08:59:20", "2025-09-14 08:59:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7266", "2425", "عملیات توسط Async Request شروع شد", "2025-09-14 14:12:07", "2025-09-14 14:12:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("7267", "2425", "عملیات توسط Async Request کامل شد", "2025-09-14 14:12:07", "2025-09-14 14:12:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("7268", "2437", "ایجاد فعالیت", "2025-09-14 14:12:07", "2025-09-14 14:12:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("7269", "2434", "عملیات توسط Async Request شروع شد", "2025-09-14 14:12:07", "2025-09-14 14:12:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("7270", "2434", "عملیات توسط Async Request کامل شد", "2025-09-14 14:12:07", "2025-09-14 14:12:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("7271", "2437", "عملیات توسط Async Request شروع شد", "2025-09-14 18:37:58", "2025-09-14 18:37:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7272", "2437", "عملیات توسط Async Request کامل شد", "2025-09-14 18:37:58", "2025-09-14 18:37:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7273", "2438", "ایجاد فعالیت", "2025-09-14 18:37:58", "2025-09-14 18:37:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7274", "2438", "عملیات توسط Async Request شروع شد", "2025-09-15 07:15:33", "2025-09-15 07:15:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("7275", "2438", "عملیات توسط Async Request کامل شد", "2025-09-15 07:15:33", "2025-09-15 07:15:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("7276", "2439", "ایجاد فعالیت", "2025-09-15 07:15:33", "2025-09-15 07:15:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("7277", "2432", "عملیات توسط Async Request شروع شد", "2025-09-15 07:15:33", "2025-09-15 07:15:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("7278", "2432", "عملیات توسط Async Request کامل شد", "2025-09-15 07:15:33", "2025-09-15 07:15:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("7279", "2440", "ایجاد فعالیت", "2025-09-15 07:15:33", "2025-09-15 07:15:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("7280", "2433", "عملیات توسط Async Request شروع شد", "2025-09-15 07:15:33", "2025-09-15 07:15:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("7281", "2433", "عملیات توسط Async Request کامل شد", "2025-09-15 07:15:33", "2025-09-15 07:15:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("7282", "2441", "ایجاد فعالیت", "2025-09-15 07:15:33", "2025-09-15 07:15:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("7283", "2439", "عملیات توسط Async Request شروع شد", "2025-09-15 08:21:25", "2025-09-15 08:21:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("7284", "2439", "عملیات توسط Async Request کامل شد", "2025-09-15 08:21:25", "2025-09-15 08:21:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("7285", "2442", "ایجاد فعالیت", "2025-09-15 08:21:25", "2025-09-15 08:21:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("7286", "2426", "عملیات توسط Async Request شروع شد", "2025-09-15 14:33:01", "2025-09-15 14:33:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7287", "2426", "عملیات توسط Async Request کامل شد", "2025-09-15 14:33:01", "2025-09-15 14:33:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7288", "2443", "ایجاد فعالیت", "2025-09-15 14:33:01", "2025-09-15 14:33:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7289", "2427", "عملیات توسط Async Request شروع شد", "2025-09-15 14:33:01", "2025-09-15 14:33:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7290", "2427", "عملیات توسط Async Request کامل شد", "2025-09-15 14:33:01", "2025-09-15 14:33:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7291", "2444", "ایجاد فعالیت", "2025-09-15 14:33:01", "2025-09-15 14:33:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7292", "2428", "عملیات توسط Async Request شروع شد", "2025-09-15 14:33:01", "2025-09-15 14:33:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7293", "2428", "عملیات توسط Async Request کامل شد", "2025-09-15 14:33:03", "2025-09-15 14:33:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("7294", "2445", "ایجاد فعالیت", "2025-09-15 14:33:03", "2025-09-15 14:33:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("7295", "2429", "عملیات توسط Async Request شروع شد", "2025-09-15 14:33:03", "2025-09-15 14:33:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("7296", "2429", "عملیات توسط Async Request کامل شد", "2025-09-15 14:33:04", "2025-09-15 14:33:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7297", "2446", "ایجاد فعالیت", "2025-09-15 14:33:05", "2025-09-15 14:33:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7298", "2430", "عملیات توسط Async Request شروع شد", "2025-09-15 14:33:05", "2025-09-15 14:33:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7299", "2430", "عملیات توسط Async Request کامل شد", "2025-09-15 14:33:05", "2025-09-15 14:33:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7300", "2447", "ایجاد فعالیت", "2025-09-15 14:33:05", "2025-09-15 14:33:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7301", "2431", "عملیات توسط Async Request شروع شد", "2025-09-15 14:33:05", "2025-09-15 14:33:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7302", "2431", "عملیات توسط Async Request کامل شد", "2025-09-15 14:33:05", "2025-09-15 14:33:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7303", "2448", "ایجاد فعالیت", "2025-09-15 14:33:05", "2025-09-15 14:33:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7304", "2442", "عملیات توسط Async Request شروع شد", "2025-09-15 14:33:05", "2025-09-15 14:33:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7305", "2442", "عملیات توسط Async Request کامل شد", "2025-09-15 14:33:05", "2025-09-15 14:33:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7306", "2449", "ایجاد فعالیت", "2025-09-15 14:33:05", "2025-09-15 14:33:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7307", "2436", "عملیات توسط Async Request شروع شد", "2025-09-15 14:33:05", "2025-09-15 14:33:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7308", "2450", "ایجاد فعالیت", "2025-09-15 14:33:05", "2025-09-15 14:33:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7309", "2451", "ایجاد فعالیت", "2025-09-15 14:33:05", "2025-09-15 14:33:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7310", "2436", "عملیات توسط Async Request کامل شد", "2025-09-15 14:33:05", "2025-09-15 14:33:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7311", "2452", "ایجاد فعالیت", "2025-09-15 14:33:05", "2025-09-15 14:33:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7312", "2451", "عملیات توسط Async Request شروع شد", "2025-09-15 16:13:35", "2025-09-15 16:13:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("7313", "2451", "عملیات توسط Async Request کامل شد", "2025-09-15 16:13:35", "2025-09-15 16:13:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("7314", "2449", "عملیات توسط Async Request شروع شد", "2025-09-15 16:13:35", "2025-09-15 16:13:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("7315", "2449", "عملیات توسط Async Request کامل شد", "2025-09-15 16:13:35", "2025-09-15 16:13:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("7316", "2453", "ایجاد فعالیت", "2025-09-15 16:13:35", "2025-09-15 16:13:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("7317", "2450", "عملیات توسط Async Request شروع شد", "2025-09-15 16:13:35", "2025-09-15 16:13:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("7318", "2450", "عملیات توسط Async Request کامل شد", "2025-09-15 16:13:35", "2025-09-15 16:13:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("7319", "2453", "عملیات توسط Async Request شروع شد", "2025-09-15 22:03:10", "2025-09-15 22:03:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7320", "2453", "عملیات توسط Async Request کامل شد", "2025-09-15 22:03:10", "2025-09-15 22:03:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7321", "2454", "ایجاد فعالیت", "2025-09-15 22:03:10", "2025-09-15 22:03:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7322", "2440", "عملیات توسط Async Request شروع شد", "2025-09-15 22:03:10", "2025-09-15 22:03:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7323", "2440", "عملیات توسط Async Request کامل شد", "2025-09-15 22:03:10", "2025-09-15 22:03:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7324", "2455", "ایجاد فعالیت", "2025-09-15 22:03:10", "2025-09-15 22:03:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7325", "2441", "عملیات توسط Async Request شروع شد", "2025-09-15 22:03:10", "2025-09-15 22:03:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7326", "2441", "عملیات توسط Async Request کامل شد", "2025-09-15 22:03:10", "2025-09-15 22:03:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7327", "2456", "ایجاد فعالیت", "2025-09-15 22:03:10", "2025-09-15 22:03:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7328", "2454", "عملیات توسط Async Request شروع شد", "2025-09-16 03:22:09", "2025-09-16 03:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("7329", "2454", "عملیات توسط Async Request کامل شد", "2025-09-16 03:22:09", "2025-09-16 03:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("7330", "2457", "ایجاد فعالیت", "2025-09-16 03:22:09", "2025-09-16 03:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("7331", "2457", "عملیات توسط Async Request شروع شد", "2025-09-16 09:29:15", "2025-09-16 09:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("7332", "2457", "عملیات توسط Async Request کامل شد", "2025-09-16 09:29:15", "2025-09-16 09:29:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("7333", "2458", "ایجاد فعالیت", "2025-09-16 09:29:16", "2025-09-16 09:29:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7334", "2455", "عملیات توسط Async Request شروع شد", "2025-09-16 20:42:49", "2025-09-16 20:42:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("7335", "2455", "عملیات توسط Async Request کامل شد", "2025-09-16 20:42:49", "2025-09-16 20:42:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("7336", "2459", "ایجاد فعالیت", "2025-09-16 20:42:49", "2025-09-16 20:42:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("7337", "2456", "عملیات توسط Async Request شروع شد", "2025-09-16 20:42:49", "2025-09-16 20:42:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("7338", "2456", "عملیات توسط Async Request کامل شد", "2025-09-16 20:42:49", "2025-09-16 20:42:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("7339", "2460", "ایجاد فعالیت", "2025-09-16 20:42:49", "2025-09-16 20:42:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("7340", "2458", "عملیات توسط Async Request شروع شد", "2025-09-16 20:42:49", "2025-09-16 20:42:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("7341", "2458", "عملیات توسط Async Request کامل شد", "2025-09-16 20:42:49", "2025-09-16 20:42:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("7342", "2461", "ایجاد فعالیت", "2025-09-16 20:42:49", "2025-09-16 20:42:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("7343", "2443", "عملیات توسط Async Request شروع شد", "2025-09-16 20:42:49", "2025-09-16 20:42:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("7344", "2443", "عملیات توسط Async Request کامل شد", "2025-09-16 20:42:49", "2025-09-16 20:42:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("7345", "2462", "ایجاد فعالیت", "2025-09-16 20:42:49", "2025-09-16 20:42:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("7346", "2444", "عملیات توسط Async Request شروع شد", "2025-09-16 20:42:49", "2025-09-16 20:42:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("7347", "2444", "عملیات توسط Async Request کامل شد", "2025-09-16 20:42:49", "2025-09-16 20:42:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("7348", "2463", "ایجاد فعالیت", "2025-09-16 20:42:49", "2025-09-16 20:42:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("7349", "2445", "عملیات توسط Async Request شروع شد", "2025-09-16 20:42:49", "2025-09-16 20:42:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("7350", "2445", "عملیات توسط Async Request کامل شد", "2025-09-16 20:42:52", "2025-09-16 20:42:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("7351", "2464", "ایجاد فعالیت", "2025-09-16 20:42:52", "2025-09-16 20:42:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("7352", "2446", "عملیات توسط Async Request شروع شد", "2025-09-16 20:42:52", "2025-09-16 20:42:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("7353", "2446", "عملیات توسط Async Request کامل شد", "2025-09-16 20:42:53", "2025-09-16 20:42:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7354", "2465", "ایجاد فعالیت", "2025-09-16 20:42:53", "2025-09-16 20:42:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7355", "2447", "عملیات توسط Async Request شروع شد", "2025-09-16 20:42:53", "2025-09-16 20:42:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7356", "2447", "عملیات توسط Async Request کامل شد", "2025-09-16 20:42:53", "2025-09-16 20:42:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7357", "2466", "ایجاد فعالیت", "2025-09-16 20:42:53", "2025-09-16 20:42:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7358", "2448", "عملیات توسط Async Request شروع شد", "2025-09-16 20:42:53", "2025-09-16 20:42:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7359", "2448", "عملیات توسط Async Request کامل شد", "2025-09-16 20:42:53", "2025-09-16 20:42:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7360", "2467", "ایجاد فعالیت", "2025-09-16 20:42:53", "2025-09-16 20:42:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7361", "2452", "عملیات توسط Async Request شروع شد", "2025-09-16 20:42:53", "2025-09-16 20:42:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7362", "2468", "ایجاد فعالیت", "2025-09-16 20:42:53", "2025-09-16 20:42:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7363", "2469", "ایجاد فعالیت", "2025-09-16 20:42:53", "2025-09-16 20:42:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7364", "2452", "عملیات توسط Async Request کامل شد", "2025-09-16 20:42:53", "2025-09-16 20:42:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7365", "2470", "ایجاد فعالیت", "2025-09-16 20:42:53", "2025-09-16 20:42:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7366", "2469", "عملیات توسط Async Request شروع شد", "2025-09-17 01:15:27", "2025-09-17 01:15:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7367", "2469", "عملیات توسط Async Request کامل شد", "2025-09-17 01:15:27", "2025-09-17 01:15:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7368", "2461", "عملیات توسط Async Request شروع شد", "2025-09-17 01:15:27", "2025-09-17 01:15:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7369", "2461", "عملیات توسط Async Request کامل شد", "2025-09-17 01:15:27", "2025-09-17 01:15:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7370", "2471", "ایجاد فعالیت", "2025-09-17 01:15:27", "2025-09-17 01:15:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7371", "2468", "عملیات توسط Async Request شروع شد", "2025-09-17 01:15:27", "2025-09-17 01:15:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7372", "2468", "عملیات توسط Async Request کامل شد", "2025-09-17 01:15:27", "2025-09-17 01:15:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7373", "2471", "عملیات توسط Async Request شروع شد", "2025-09-17 02:15:38", "2025-09-17 02:15:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7374", "2471", "عملیات توسط Async Request کامل شد", "2025-09-17 02:15:38", "2025-09-17 02:15:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7375", "2472", "ایجاد فعالیت", "2025-09-17 02:15:38", "2025-09-17 02:15:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7376", "2472", "عملیات توسط Async Request شروع شد", "2025-09-17 03:20:29", "2025-09-17 03:20:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("7377", "2472", "عملیات توسط Async Request کامل شد", "2025-09-17 03:20:29", "2025-09-17 03:20:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("7378", "2473", "ایجاد فعالیت", "2025-09-17 03:20:29", "2025-09-17 03:20:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("7379", "2473", "عملیات توسط Async Request شروع شد", "2025-09-17 04:45:10", "2025-09-17 04:45:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7380", "2473", "عملیات توسط Async Request کامل شد", "2025-09-17 04:45:10", "2025-09-17 04:45:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7381", "2474", "ایجاد فعالیت", "2025-09-17 04:45:10", "2025-09-17 04:45:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7382", "2474", "عملیات توسط Async Request شروع شد", "2025-09-17 10:55:13", "2025-09-17 10:55:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("7383", "2474", "عملیات توسط Async Request کامل شد", "2025-09-17 10:55:13", "2025-09-17 10:55:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("7384", "2475", "ایجاد فعالیت", "2025-09-17 10:55:13", "2025-09-17 10:55:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("7385", "2459", "عملیات توسط Async Request شروع شد", "2025-09-17 10:55:13", "2025-09-17 10:55:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("7386", "2459", "عملیات توسط Async Request کامل شد", "2025-09-17 10:55:13", "2025-09-17 10:55:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("7387", "2476", "ایجاد فعالیت", "2025-09-17 10:55:13", "2025-09-17 10:55:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("7388", "2460", "عملیات توسط Async Request شروع شد", "2025-09-17 10:55:13", "2025-09-17 10:55:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("7389", "2460", "عملیات توسط Async Request کامل شد", "2025-09-17 10:55:13", "2025-09-17 10:55:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("7390", "2477", "ایجاد فعالیت", "2025-09-17 10:55:13", "2025-09-17 10:55:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("7391", "2478", "ایجاد فعالیت", "2025-09-17 11:06:19", "2025-09-17 11:06:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("7392", "2479", "ایجاد فعالیت", "2025-09-17 11:06:29", "2025-09-17 11:06:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("7393", "2478", "عملیات توسط Async Request شروع شد", "2025-09-17 11:06:52", "2025-09-17 11:06:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("7394", "2478", "عملیات توسط Async Request کامل شد", "2025-09-17 11:06:52", "2025-09-17 11:06:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("7395", "2479", "عملیات توسط Async Request شروع شد", "2025-09-17 11:06:52", "2025-09-17 11:06:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("7396", "2479", "عملیات توسط Async Request کامل شد", "2025-09-17 11:06:53", "2025-09-17 11:06:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7397", "2480", "ایجاد فعالیت", "2025-09-17 11:12:24", "2025-09-17 11:12:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7398", "2480", "عملیات توسط Async Request شروع شد", "2025-09-17 11:13:43", "2025-09-17 11:13:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("7399", "2480", "عملیات توسط Async Request کامل شد", "2025-09-17 11:13:43", "2025-09-17 11:13:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("7400", "2481", "ایجاد فعالیت", "2025-09-17 11:13:43", "2025-09-17 11:13:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("7401", "2481", "عملیات توسط Async Request شروع شد", "2025-09-17 11:14:49", "2025-09-17 11:14:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("7402", "2481", "اقدام از طریق Async Request انجام نشد: اقدام زمان‌بندی‌شده برای action_scheduler/migration_hook اجرا نخواهد شد زیرا هیچ فراخوانی برگشتی ثبت نشده است.", "2025-09-17 11:14:49", "2025-09-17 11:14:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("7403", "2475", "عملیات توسط Async Request شروع شد", "2025-09-17 11:56:24", "2025-09-17 11:56:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7404", "2475", "عملیات توسط Async Request کامل شد", "2025-09-17 11:56:24", "2025-09-17 11:56:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7405", "2482", "ایجاد فعالیت", "2025-09-17 11:56:24", "2025-09-17 11:56:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7406", "2482", "عملیات توسط Async Request شروع شد", "2025-09-17 13:19:39", "2025-09-17 13:19:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("7407", "2482", "عملیات توسط Async Request کامل شد", "2025-09-17 13:19:39", "2025-09-17 13:19:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("7408", "2483", "ایجاد فعالیت", "2025-09-17 13:19:39", "2025-09-17 13:19:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("7409", "2483", "عملیات توسط Async Request شروع شد", "2025-09-17 14:47:11", "2025-09-17 14:47:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("7410", "2483", "عملیات توسط Async Request کامل شد", "2025-09-17 14:47:11", "2025-09-17 14:47:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("7411", "2484", "ایجاد فعالیت", "2025-09-17 14:47:11", "2025-09-17 14:47:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("7412", "2484", "عملیات توسط Async Request شروع شد", "2025-09-17 18:34:52", "2025-09-17 18:34:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("7413", "2484", "عملیات توسط Async Request کامل شد", "2025-09-17 18:34:52", "2025-09-17 18:34:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("7414", "2485", "ایجاد فعالیت", "2025-09-17 18:34:52", "2025-09-17 18:34:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("7415", "2485", "عملیات توسط Async Request شروع شد", "2025-09-18 07:42:36", "2025-09-18 07:42:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7416", "2485", "عملیات توسط Async Request کامل شد", "2025-09-18 07:42:36", "2025-09-18 07:42:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7417", "2486", "ایجاد فعالیت", "2025-09-18 07:42:36", "2025-09-18 07:42:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7418", "2462", "عملیات توسط Async Request شروع شد", "2025-09-18 07:42:36", "2025-09-18 07:42:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7419", "2462", "عملیات توسط Async Request کامل شد", "2025-09-18 07:42:36", "2025-09-18 07:42:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7420", "2487", "ایجاد فعالیت", "2025-09-18 07:42:36", "2025-09-18 07:42:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7421", "2463", "عملیات توسط Async Request شروع شد", "2025-09-18 07:42:36", "2025-09-18 07:42:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7422", "2463", "عملیات توسط Async Request کامل شد", "2025-09-18 07:42:36", "2025-09-18 07:42:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7423", "2488", "ایجاد فعالیت", "2025-09-18 07:42:36", "2025-09-18 07:42:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7424", "2464", "عملیات توسط Async Request شروع شد", "2025-09-18 07:42:36", "2025-09-18 07:42:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7425", "2464", "عملیات توسط Async Request کامل شد", "2025-09-18 07:42:38", "2025-09-18 07:42:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7426", "2489", "ایجاد فعالیت", "2025-09-18 07:42:38", "2025-09-18 07:42:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7427", "2465", "عملیات توسط Async Request شروع شد", "2025-09-18 07:42:38", "2025-09-18 07:42:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7428", "2465", "عملیات توسط Async Request کامل شد", "2025-09-18 07:42:39", "2025-09-18 07:42:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("7429", "2490", "ایجاد فعالیت", "2025-09-18 07:42:39", "2025-09-18 07:42:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("7430", "2466", "عملیات توسط Async Request شروع شد", "2025-09-18 07:42:39", "2025-09-18 07:42:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("7431", "2466", "عملیات توسط Async Request کامل شد", "2025-09-18 07:42:40", "2025-09-18 07:42:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7432", "2491", "ایجاد فعالیت", "2025-09-18 07:42:40", "2025-09-18 07:42:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7433", "2467", "عملیات توسط Async Request شروع شد", "2025-09-18 07:42:40", "2025-09-18 07:42:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7434", "2467", "عملیات توسط Async Request کامل شد", "2025-09-18 07:42:40", "2025-09-18 07:42:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7435", "2492", "ایجاد فعالیت", "2025-09-18 07:42:40", "2025-09-18 07:42:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7436", "2476", "عملیات توسط Async Request شروع شد", "2025-09-18 07:42:40", "2025-09-18 07:42:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7437", "2476", "عملیات توسط Async Request کامل شد", "2025-09-18 07:42:40", "2025-09-18 07:42:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7438", "2493", "ایجاد فعالیت", "2025-09-18 07:42:40", "2025-09-18 07:42:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7439", "2477", "عملیات توسط Async Request شروع شد", "2025-09-18 07:42:40", "2025-09-18 07:42:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7440", "2477", "عملیات توسط Async Request کامل شد", "2025-09-18 07:42:40", "2025-09-18 07:42:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7441", "2494", "ایجاد فعالیت", "2025-09-18 07:42:40", "2025-09-18 07:42:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7442", "2470", "عملیات توسط Async Request شروع شد", "2025-09-18 07:42:40", "2025-09-18 07:42:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7443", "2495", "ایجاد فعالیت", "2025-09-18 07:42:40", "2025-09-18 07:42:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7444", "2496", "ایجاد فعالیت", "2025-09-18 07:42:40", "2025-09-18 07:42:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7445", "2470", "عملیات توسط Async Request کامل شد", "2025-09-18 07:42:40", "2025-09-18 07:42:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7446", "2497", "ایجاد فعالیت", "2025-09-18 07:42:40", "2025-09-18 07:42:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("7447", "2496", "عملیات توسط Async Request شروع شد", "2025-09-18 07:44:05", "2025-09-18 07:44:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7448", "2496", "عملیات توسط Async Request کامل شد", "2025-09-18 07:44:05", "2025-09-18 07:44:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7449", "2486", "عملیات توسط Async Request شروع شد", "2025-09-18 11:15:21", "2025-09-18 11:15:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7450", "2486", "عملیات توسط Async Request کامل شد", "2025-09-18 11:15:21", "2025-09-18 11:15:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7451", "2498", "ایجاد فعالیت", "2025-09-18 11:15:21", "2025-09-18 11:15:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7452", "2495", "عملیات توسط Async Request شروع شد", "2025-09-18 11:15:21", "2025-09-18 11:15:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7453", "2499", "ایجاد فعالیت", "2025-09-18 11:15:21", "2025-09-18 11:15:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7454", "2495", "عملیات توسط Async Request کامل شد", "2025-09-18 11:15:21", "2025-09-18 11:15:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7455", "2498", "عملیات توسط Async Request شروع شد", "2025-09-18 13:10:14", "2025-09-18 13:10:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7456", "2498", "عملیات توسط Async Request کامل شد", "2025-09-18 13:10:14", "2025-09-18 13:10:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7457", "2500", "ایجاد فعالیت", "2025-09-18 13:10:14", "2025-09-18 13:10:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7458", "2499", "عملیات توسط Async Request شروع شد", "2025-09-18 13:10:14", "2025-09-18 13:10:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7459", "2501", "ایجاد فعالیت", "2025-09-18 13:10:14", "2025-09-18 13:10:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7460", "2499", "عملیات توسط Async Request کامل شد", "2025-09-18 13:10:14", "2025-09-18 13:10:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7461", "2500", "عملیات توسط Async Request شروع شد", "2025-09-18 15:11:06", "2025-09-18 15:11:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7462", "2500", "عملیات توسط Async Request کامل شد", "2025-09-18 15:11:06", "2025-09-18 15:11:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7463", "2502", "ایجاد فعالیت", "2025-09-18 15:11:06", "2025-09-18 15:11:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7464", "2501", "عملیات توسط Async Request شروع شد", "2025-09-18 15:11:06", "2025-09-18 15:11:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7465", "2503", "ایجاد فعالیت", "2025-09-18 15:11:06", "2025-09-18 15:11:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7466", "2501", "عملیات توسط Async Request کامل شد", "2025-09-18 15:11:06", "2025-09-18 15:11:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7467", "2502", "عملیات توسط Async Request شروع شد", "2025-09-18 17:00:53", "2025-09-18 17:00:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7468", "2502", "عملیات توسط Async Request کامل شد", "2025-09-18 17:00:53", "2025-09-18 17:00:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7469", "2504", "ایجاد فعالیت", "2025-09-18 17:00:53", "2025-09-18 17:00:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7470", "2503", "عملیات توسط Async Request شروع شد", "2025-09-18 17:00:53", "2025-09-18 17:00:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7471", "2505", "ایجاد فعالیت", "2025-09-18 17:00:53", "2025-09-18 17:00:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7472", "2503", "عملیات توسط Async Request کامل شد", "2025-09-18 17:00:53", "2025-09-18 17:00:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7473", "2504", "عملیات توسط Async Request شروع شد", "2025-09-18 19:22:30", "2025-09-18 19:22:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("7474", "2504", "عملیات توسط Async Request کامل شد", "2025-09-18 19:22:30", "2025-09-18 19:22:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("7475", "2506", "ایجاد فعالیت", "2025-09-18 19:22:30", "2025-09-18 19:22:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("7476", "2505", "عملیات توسط Async Request شروع شد", "2025-09-18 19:22:30", "2025-09-18 19:22:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("7477", "2507", "ایجاد فعالیت", "2025-09-18 19:22:30", "2025-09-18 19:22:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("7478", "2505", "عملیات توسط Async Request کامل شد", "2025-09-18 19:22:30", "2025-09-18 19:22:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("7479", "2493", "عملیات توسط Async Request شروع شد", "2025-09-18 19:51:43", "2025-09-18 19:51:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("7480", "2493", "عملیات توسط Async Request کامل شد", "2025-09-18 19:51:43", "2025-09-18 19:51:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("7481", "2508", "ایجاد فعالیت", "2025-09-18 19:51:43", "2025-09-18 19:51:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("7482", "2494", "عملیات توسط Async Request شروع شد", "2025-09-18 19:51:43", "2025-09-18 19:51:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("7483", "2494", "عملیات توسط Async Request کامل شد", "2025-09-18 19:51:43", "2025-09-18 19:51:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("7484", "2509", "ایجاد فعالیت", "2025-09-18 19:51:43", "2025-09-18 19:51:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("7485", "2510", "ایجاد فعالیت", "2025-09-18 19:59:19", "2025-09-18 19:59:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("7486", "2510", "عملیات توسط Async Request شروع شد", "2025-09-19 01:17:10", "2025-09-19 01:17:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7487", "2510", "عملیات توسط Async Request کامل شد", "2025-09-19 01:17:10", "2025-09-19 01:17:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7488", "2506", "عملیات توسط Async Request شروع شد", "2025-09-19 01:17:10", "2025-09-19 01:17:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7489", "2506", "عملیات توسط Async Request کامل شد", "2025-09-19 01:17:10", "2025-09-19 01:17:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7490", "2511", "ایجاد فعالیت", "2025-09-19 01:17:10", "2025-09-19 01:17:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7491", "2507", "عملیات توسط Async Request شروع شد", "2025-09-19 01:17:10", "2025-09-19 01:17:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7492", "2512", "ایجاد فعالیت", "2025-09-19 01:17:10", "2025-09-19 01:17:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7493", "2507", "عملیات توسط Async Request کامل شد", "2025-09-19 01:17:10", "2025-09-19 01:17:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7494", "2511", "عملیات توسط Async Request شروع شد", "2025-09-19 05:08:18", "2025-09-19 05:08:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("7495", "2511", "عملیات توسط Async Request کامل شد", "2025-09-19 05:08:18", "2025-09-19 05:08:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("7496", "2513", "ایجاد فعالیت", "2025-09-19 05:08:18", "2025-09-19 05:08:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("7497", "2512", "عملیات توسط Async Request شروع شد", "2025-09-19 05:08:18", "2025-09-19 05:08:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("7498", "2514", "ایجاد فعالیت", "2025-09-19 05:08:18", "2025-09-19 05:08:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("7499", "2512", "عملیات توسط Async Request کامل شد", "2025-09-19 05:08:18", "2025-09-19 05:08:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("7500", "2513", "عملیات توسط Async Request شروع شد", "2025-09-19 06:26:24", "2025-09-19 06:26:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7501", "2513", "عملیات توسط Async Request کامل شد", "2025-09-19 06:26:24", "2025-09-19 06:26:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7502", "2515", "ایجاد فعالیت", "2025-09-19 06:26:24", "2025-09-19 06:26:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7503", "2514", "عملیات توسط Async Request شروع شد", "2025-09-19 06:26:24", "2025-09-19 06:26:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7504", "2516", "ایجاد فعالیت", "2025-09-19 06:26:24", "2025-09-19 06:26:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7505", "2514", "عملیات توسط Async Request کامل شد", "2025-09-19 06:26:24", "2025-09-19 06:26:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7506", "2515", "عملیات توسط Async Request شروع شد", "2025-09-19 19:30:56", "2025-09-19 19:30:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("7507", "2515", "عملیات توسط Async Request کامل شد", "2025-09-19 19:30:56", "2025-09-19 19:30:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("7508", "2517", "ایجاد فعالیت", "2025-09-19 19:30:56", "2025-09-19 19:30:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("7509", "2516", "عملیات توسط Async Request شروع شد", "2025-09-19 19:30:56", "2025-09-19 19:30:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("7510", "2518", "ایجاد فعالیت", "2025-09-19 19:30:56", "2025-09-19 19:30:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("7511", "2516", "عملیات توسط Async Request کامل شد", "2025-09-19 19:30:56", "2025-09-19 19:30:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("7512", "2487", "عملیات توسط Async Request شروع شد", "2025-09-19 19:30:56", "2025-09-19 19:30:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("7513", "2487", "عملیات توسط Async Request کامل شد", "2025-09-19 19:30:56", "2025-09-19 19:30:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("7514", "2519", "ایجاد فعالیت", "2025-09-19 19:30:56", "2025-09-19 19:30:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("7515", "2488", "عملیات توسط Async Request شروع شد", "2025-09-19 19:30:56", "2025-09-19 19:30:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("7516", "2488", "عملیات توسط Async Request کامل شد", "2025-09-19 19:30:56", "2025-09-19 19:30:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("7517", "2520", "ایجاد فعالیت", "2025-09-19 19:30:56", "2025-09-19 19:30:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("7518", "2489", "عملیات توسط Async Request شروع شد", "2025-09-19 19:30:56", "2025-09-19 19:30:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("7519", "2489", "عملیات توسط Async Request کامل شد", "2025-09-19 19:30:58", "2025-09-19 19:30:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7520", "2521", "ایجاد فعالیت", "2025-09-19 19:30:58", "2025-09-19 19:30:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7521", "2490", "عملیات توسط Async Request شروع شد", "2025-09-19 19:30:58", "2025-09-19 19:30:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7522", "2490", "عملیات توسط Async Request کامل شد", "2025-09-19 19:30:59", "2025-09-19 19:30:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7523", "2522", "ایجاد فعالیت", "2025-09-19 19:30:59", "2025-09-19 19:30:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7524", "2491", "عملیات توسط Async Request شروع شد", "2025-09-19 19:30:59", "2025-09-19 19:30:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7525", "2491", "عملیات توسط Async Request کامل شد", "2025-09-19 19:30:59", "2025-09-19 19:30:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7526", "2523", "ایجاد فعالیت", "2025-09-19 19:30:59", "2025-09-19 19:30:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7527", "2492", "عملیات توسط Async Request شروع شد", "2025-09-19 19:30:59", "2025-09-19 19:30:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7528", "2492", "عملیات توسط Async Request کامل شد", "2025-09-19 19:30:59", "2025-09-19 19:30:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7529", "2524", "ایجاد فعالیت", "2025-09-19 19:30:59", "2025-09-19 19:30:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7530", "2508", "عملیات توسط Async Request شروع شد", "2025-09-19 19:30:59", "2025-09-19 19:30:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7531", "2508", "عملیات توسط Async Request کامل شد", "2025-09-19 19:30:59", "2025-09-19 19:30:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7532", "2525", "ایجاد فعالیت", "2025-09-19 19:30:59", "2025-09-19 19:30:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7533", "2509", "عملیات توسط Async Request شروع شد", "2025-09-19 19:30:59", "2025-09-19 19:30:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7534", "2509", "عملیات توسط Async Request کامل شد", "2025-09-19 19:30:59", "2025-09-19 19:30:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7535", "2526", "ایجاد فعالیت", "2025-09-19 19:30:59", "2025-09-19 19:30:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7536", "2497", "عملیات توسط Async Request شروع شد", "2025-09-19 19:30:59", "2025-09-19 19:30:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7537", "2527", "ایجاد فعالیت", "2025-09-19 19:30:59", "2025-09-19 19:30:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7538", "2497", "عملیات توسط Async Request کامل شد", "2025-09-19 19:30:59", "2025-09-19 19:30:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7539", "2528", "ایجاد فعالیت", "2025-09-19 19:30:59", "2025-09-19 19:30:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7540", "2527", "عملیات توسط Async Request شروع شد", "2025-09-19 19:40:39", "2025-09-19 19:40:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("7541", "2527", "عملیات توسط Async Request کامل شد", "2025-09-19 19:40:39", "2025-09-19 19:40:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("7542", "2517", "عملیات توسط Async Request شروع شد", "2025-09-19 22:26:42", "2025-09-19 22:26:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("7543", "2517", "عملیات توسط Async Request کامل شد", "2025-09-19 22:26:42", "2025-09-19 22:26:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("7544", "2529", "ایجاد فعالیت", "2025-09-19 22:26:42", "2025-09-19 22:26:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("7545", "2518", "عملیات توسط Async Request شروع شد", "2025-09-19 22:26:42", "2025-09-19 22:26:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("7546", "2530", "ایجاد فعالیت", "2025-09-19 22:26:42", "2025-09-19 22:26:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("7547", "2518", "عملیات توسط Async Request کامل شد", "2025-09-19 22:26:42", "2025-09-19 22:26:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("7548", "2529", "عملیات توسط Async Request شروع شد", "2025-09-20 00:13:11", "2025-09-20 00:13:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("7549", "2529", "عملیات توسط Async Request کامل شد", "2025-09-20 00:13:11", "2025-09-20 00:13:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("7550", "2531", "ایجاد فعالیت", "2025-09-20 00:13:11", "2025-09-20 00:13:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("7551", "2530", "عملیات توسط Async Request شروع شد", "2025-09-20 00:13:11", "2025-09-20 00:13:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("7552", "2532", "ایجاد فعالیت", "2025-09-20 00:13:11", "2025-09-20 00:13:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("7553", "2530", "عملیات توسط Async Request کامل شد", "2025-09-20 00:13:11", "2025-09-20 00:13:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("7554", "2531", "عملیات توسط Async Request شروع شد", "2025-09-20 04:30:38", "2025-09-20 04:30:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7555", "2531", "عملیات توسط Async Request کامل شد", "2025-09-20 04:30:38", "2025-09-20 04:30:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7556", "2533", "ایجاد فعالیت", "2025-09-20 04:30:38", "2025-09-20 04:30:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7557", "2532", "عملیات توسط Async Request شروع شد", "2025-09-20 04:30:38", "2025-09-20 04:30:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7558", "2534", "ایجاد فعالیت", "2025-09-20 04:30:38", "2025-09-20 04:30:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7559", "2532", "عملیات توسط Async Request کامل شد", "2025-09-20 04:30:38", "2025-09-20 04:30:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7560", "2533", "عملیات توسط Async Request شروع شد", "2025-09-20 07:10:32", "2025-09-20 07:10:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("7561", "2533", "عملیات توسط Async Request کامل شد", "2025-09-20 07:10:33", "2025-09-20 07:10:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("7562", "2535", "ایجاد فعالیت", "2025-09-20 07:10:33", "2025-09-20 07:10:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("7563", "2534", "عملیات توسط Async Request شروع شد", "2025-09-20 07:10:33", "2025-09-20 07:10:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("7564", "2536", "ایجاد فعالیت", "2025-09-20 07:10:33", "2025-09-20 07:10:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("7565", "2534", "عملیات توسط Async Request کامل شد", "2025-09-20 07:10:33", "2025-09-20 07:10:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("7566", "2525", "عملیات توسط Async Request شروع شد", "2025-09-20 09:46:14", "2025-09-20 09:46:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7567", "2525", "عملیات توسط Async Request کامل شد", "2025-09-20 09:46:14", "2025-09-20 09:46:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7568", "2537", "ایجاد فعالیت", "2025-09-20 09:46:14", "2025-09-20 09:46:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7569", "2526", "عملیات توسط Async Request شروع شد", "2025-09-20 09:46:14", "2025-09-20 09:46:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7570", "2526", "عملیات توسط Async Request کامل شد", "2025-09-20 09:46:14", "2025-09-20 09:46:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7571", "2538", "ایجاد فعالیت", "2025-09-20 09:46:14", "2025-09-20 09:46:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7572", "2300", "عملیات توسط Async Request شروع شد", "2025-09-20 09:46:14", "2025-09-20 09:46:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7573", "2300", "عملیات توسط Async Request کامل شد", "2025-09-20 09:46:14", "2025-09-20 09:46:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7574", "2539", "ایجاد فعالیت", "2025-09-20 09:46:14", "2025-09-20 09:46:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7575", "2535", "عملیات توسط Async Request شروع شد", "2025-09-20 09:46:14", "2025-09-20 09:46:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7576", "2535", "عملیات توسط Async Request کامل شد", "2025-09-20 09:46:14", "2025-09-20 09:46:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7577", "2540", "ایجاد فعالیت", "2025-09-20 09:46:14", "2025-09-20 09:46:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7578", "2536", "عملیات توسط Async Request شروع شد", "2025-09-20 09:46:14", "2025-09-20 09:46:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7579", "2541", "ایجاد فعالیت", "2025-09-20 09:46:14", "2025-09-20 09:46:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7580", "2536", "عملیات توسط Async Request کامل شد", "2025-09-20 09:46:14", "2025-09-20 09:46:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7581", "2540", "عملیات توسط Async Request شروع شد", "2025-09-20 16:13:37", "2025-09-20 16:13:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7582", "2540", "عملیات توسط Async Request کامل شد", "2025-09-20 16:13:37", "2025-09-20 16:13:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7583", "2542", "ایجاد فعالیت", "2025-09-20 16:13:37", "2025-09-20 16:13:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7584", "2541", "عملیات توسط Async Request شروع شد", "2025-09-20 16:13:37", "2025-09-20 16:13:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7585", "2543", "ایجاد فعالیت", "2025-09-20 16:13:37", "2025-09-20 16:13:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7586", "2541", "عملیات توسط Async Request کامل شد", "2025-09-20 16:13:37", "2025-09-20 16:13:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7587", "2542", "عملیات توسط Async Request شروع شد", "2025-09-20 18:07:38", "2025-09-20 18:07:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7588", "2542", "عملیات توسط Async Request کامل شد", "2025-09-20 18:07:38", "2025-09-20 18:07:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7589", "2544", "ایجاد فعالیت", "2025-09-20 18:07:38", "2025-09-20 18:07:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7590", "2543", "عملیات توسط Async Request شروع شد", "2025-09-20 18:07:38", "2025-09-20 18:07:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7591", "2545", "ایجاد فعالیت", "2025-09-20 18:07:38", "2025-09-20 18:07:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7592", "2543", "عملیات توسط Async Request کامل شد", "2025-09-20 18:07:38", "2025-09-20 18:07:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("7593", "2544", "عملیات توسط Async Request شروع شد", "2025-09-21 03:28:20", "2025-09-21 03:28:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7594", "2544", "عملیات توسط Async Request کامل شد", "2025-09-21 03:28:20", "2025-09-21 03:28:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7595", "2546", "ایجاد فعالیت", "2025-09-21 03:28:20", "2025-09-21 03:28:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7596", "2545", "عملیات توسط Async Request شروع شد", "2025-09-21 03:28:20", "2025-09-21 03:28:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7597", "2547", "ایجاد فعالیت", "2025-09-21 03:28:20", "2025-09-21 03:28:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7598", "2545", "عملیات توسط Async Request کامل شد", "2025-09-21 03:28:20", "2025-09-21 03:28:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7599", "2519", "عملیات توسط Async Request شروع شد", "2025-09-21 03:28:20", "2025-09-21 03:28:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7600", "2519", "عملیات توسط Async Request کامل شد", "2025-09-21 03:28:20", "2025-09-21 03:28:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7601", "2548", "ایجاد فعالیت", "2025-09-21 03:28:20", "2025-09-21 03:28:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7602", "2520", "عملیات توسط Async Request شروع شد", "2025-09-21 03:28:20", "2025-09-21 03:28:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7603", "2520", "عملیات توسط Async Request کامل شد", "2025-09-21 03:28:20", "2025-09-21 03:28:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7604", "2549", "ایجاد فعالیت", "2025-09-21 03:28:20", "2025-09-21 03:28:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7605", "2521", "عملیات توسط Async Request شروع شد", "2025-09-21 03:28:20", "2025-09-21 03:28:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7606", "2521", "عملیات توسط Async Request کامل شد", "2025-09-21 03:28:22", "2025-09-21 03:28:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7607", "2550", "ایجاد فعالیت", "2025-09-21 03:28:22", "2025-09-21 03:28:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7608", "2522", "عملیات توسط Async Request شروع شد", "2025-09-21 03:28:22", "2025-09-21 03:28:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7609", "2522", "عملیات توسط Async Request کامل شد", "2025-09-21 03:28:23", "2025-09-21 03:28:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("7610", "2551", "ایجاد فعالیت", "2025-09-21 03:28:23", "2025-09-21 03:28:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("7611", "2523", "عملیات توسط Async Request شروع شد", "2025-09-21 03:28:23", "2025-09-21 03:28:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("7612", "2523", "عملیات توسط Async Request کامل شد", "2025-09-21 03:28:24", "2025-09-21 03:28:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7613", "2552", "ایجاد فعالیت", "2025-09-21 03:28:24", "2025-09-21 03:28:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7614", "2524", "عملیات توسط Async Request شروع شد", "2025-09-21 03:28:24", "2025-09-21 03:28:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7615", "2524", "عملیات توسط Async Request کامل شد", "2025-09-21 03:28:24", "2025-09-21 03:28:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7616", "2553", "ایجاد فعالیت", "2025-09-21 03:28:24", "2025-09-21 03:28:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7617", "2537", "عملیات توسط Async Request شروع شد", "2025-09-21 03:28:24", "2025-09-21 03:28:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7618", "2537", "عملیات توسط Async Request کامل شد", "2025-09-21 03:28:24", "2025-09-21 03:28:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7619", "2554", "ایجاد فعالیت", "2025-09-21 03:28:24", "2025-09-21 03:28:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7620", "2538", "عملیات توسط Async Request شروع شد", "2025-09-21 03:28:24", "2025-09-21 03:28:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7621", "2538", "عملیات توسط Async Request کامل شد", "2025-09-21 03:28:24", "2025-09-21 03:28:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7622", "2555", "ایجاد فعالیت", "2025-09-21 03:28:24", "2025-09-21 03:28:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7623", "2528", "عملیات توسط Async Request شروع شد", "2025-09-21 03:28:24", "2025-09-21 03:28:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7624", "2556", "ایجاد فعالیت", "2025-09-21 03:28:24", "2025-09-21 03:28:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7625", "2528", "عملیات توسط Async Request کامل شد", "2025-09-21 03:28:24", "2025-09-21 03:28:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7626", "2557", "ایجاد فعالیت", "2025-09-21 03:28:24", "2025-09-21 03:28:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7627", "2556", "عملیات توسط Async Request شروع شد", "2025-09-21 06:11:55", "2025-09-21 06:11:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("7628", "2556", "عملیات توسط Async Request کامل شد", "2025-09-21 06:11:55", "2025-09-21 06:11:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("7629", "2546", "عملیات توسط Async Request شروع شد", "2025-09-21 06:11:55", "2025-09-21 06:11:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("7630", "2546", "عملیات توسط Async Request کامل شد", "2025-09-21 06:11:55", "2025-09-21 06:11:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("7631", "2558", "ایجاد فعالیت", "2025-09-21 06:11:55", "2025-09-21 06:11:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("7632", "2547", "عملیات توسط Async Request شروع شد", "2025-09-21 06:11:55", "2025-09-21 06:11:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("7633", "2559", "ایجاد فعالیت", "2025-09-21 06:11:55", "2025-09-21 06:11:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("7634", "2547", "عملیات توسط Async Request کامل شد", "2025-09-21 06:11:55", "2025-09-21 06:11:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("7635", "2558", "عملیات توسط Async Request شروع شد", "2025-09-21 08:02:48", "2025-09-21 08:02:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("7636", "2558", "عملیات توسط Async Request کامل شد", "2025-09-21 08:02:48", "2025-09-21 08:02:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("7637", "2560", "ایجاد فعالیت", "2025-09-21 08:02:48", "2025-09-21 08:02:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("7638", "2559", "عملیات توسط Async Request شروع شد", "2025-09-21 08:02:48", "2025-09-21 08:02:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("7639", "2561", "ایجاد فعالیت", "2025-09-21 08:02:48", "2025-09-21 08:02:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("7640", "2559", "عملیات توسط Async Request کامل شد", "2025-09-21 08:02:48", "2025-09-21 08:02:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("7641", "2560", "عملیات توسط Async Request شروع شد", "2025-09-21 10:36:58", "2025-09-21 10:36:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7642", "2560", "عملیات توسط Async Request کامل شد", "2025-09-21 10:36:58", "2025-09-21 10:36:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7643", "2562", "ایجاد فعالیت", "2025-09-21 10:36:58", "2025-09-21 10:36:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7644", "2561", "عملیات توسط Async Request شروع شد", "2025-09-21 10:36:58", "2025-09-21 10:36:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7645", "2563", "ایجاد فعالیت", "2025-09-21 10:36:58", "2025-09-21 10:36:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7646", "2561", "عملیات توسط Async Request کامل شد", "2025-09-21 10:36:58", "2025-09-21 10:36:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7647", "2562", "عملیات توسط Async Request شروع شد", "2025-09-21 11:39:21", "2025-09-21 11:39:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7648", "2562", "عملیات توسط Async Request کامل شد", "2025-09-21 11:39:21", "2025-09-21 11:39:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7649", "2564", "ایجاد فعالیت", "2025-09-21 11:39:21", "2025-09-21 11:39:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7650", "2563", "عملیات توسط Async Request شروع شد", "2025-09-21 11:39:21", "2025-09-21 11:39:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7651", "2565", "ایجاد فعالیت", "2025-09-21 11:39:21", "2025-09-21 11:39:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7652", "2563", "عملیات توسط Async Request کامل شد", "2025-09-21 11:39:21", "2025-09-21 11:39:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("7653", "2564", "عملیات توسط Async Request شروع شد", "2025-09-21 13:39:05", "2025-09-21 13:39:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7654", "2564", "عملیات توسط Async Request کامل شد", "2025-09-21 13:39:05", "2025-09-21 13:39:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7655", "2566", "ایجاد فعالیت", "2025-09-21 13:39:05", "2025-09-21 13:39:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7656", "2565", "عملیات توسط Async Request شروع شد", "2025-09-21 13:39:05", "2025-09-21 13:39:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7657", "2567", "ایجاد فعالیت", "2025-09-21 13:39:05", "2025-09-21 13:39:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7658", "2565", "عملیات توسط Async Request کامل شد", "2025-09-21 13:39:05", "2025-09-21 13:39:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7659", "2566", "عملیات توسط Async Request شروع شد", "2025-09-21 17:51:16", "2025-09-21 17:51:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7660", "2566", "عملیات توسط Async Request کامل شد", "2025-09-21 17:51:16", "2025-09-21 17:51:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7661", "2568", "ایجاد فعالیت", "2025-09-21 17:51:16", "2025-09-21 17:51:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7662", "2567", "عملیات توسط Async Request شروع شد", "2025-09-21 17:51:16", "2025-09-21 17:51:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7663", "2569", "ایجاد فعالیت", "2025-09-21 17:51:16", "2025-09-21 17:51:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7664", "2567", "عملیات توسط Async Request کامل شد", "2025-09-21 17:51:16", "2025-09-21 17:51:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7665", "2554", "عملیات توسط Async Request شروع شد", "2025-09-21 17:51:16", "2025-09-21 17:51:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7666", "2554", "عملیات توسط Async Request کامل شد", "2025-09-21 17:51:16", "2025-09-21 17:51:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7667", "2570", "ایجاد فعالیت", "2025-09-21 17:51:16", "2025-09-21 17:51:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7668", "2555", "عملیات توسط Async Request شروع شد", "2025-09-21 17:51:16", "2025-09-21 17:51:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7669", "2555", "عملیات توسط Async Request کامل شد", "2025-09-21 17:51:16", "2025-09-21 17:51:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7670", "2571", "ایجاد فعالیت", "2025-09-21 17:51:16", "2025-09-21 17:51:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("7671", "2568", "عملیات توسط Async Request شروع شد", "2025-09-21 20:03:33", "2025-09-21 20:03:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("7672", "2568", "عملیات توسط Async Request کامل شد", "2025-09-21 20:03:33", "2025-09-21 20:03:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("7673", "2572", "ایجاد فعالیت", "2025-09-21 20:03:33", "2025-09-21 20:03:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("7674", "2569", "عملیات توسط Async Request شروع شد", "2025-09-21 20:03:33", "2025-09-21 20:03:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("7675", "2573", "ایجاد فعالیت", "2025-09-21 20:03:33", "2025-09-21 20:03:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("7676", "2569", "عملیات توسط Async Request کامل شد", "2025-09-21 20:03:33", "2025-09-21 20:03:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("7677", "2572", "عملیات توسط Async Request شروع شد", "2025-09-22 05:08:41", "2025-09-22 05:08:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("7678", "2572", "عملیات توسط Async Request کامل شد", "2025-09-22 05:08:41", "2025-09-22 05:08:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("7679", "2574", "ایجاد فعالیت", "2025-09-22 05:08:41", "2025-09-22 05:08:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("7680", "2573", "عملیات توسط Async Request شروع شد", "2025-09-22 05:08:41", "2025-09-22 05:08:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("7681", "2575", "ایجاد فعالیت", "2025-09-22 05:08:41", "2025-09-22 05:08:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("7682", "2573", "عملیات توسط Async Request کامل شد", "2025-09-22 05:08:41", "2025-09-22 05:08:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("7683", "2548", "عملیات توسط Async Request شروع شد", "2025-09-22 05:08:41", "2025-09-22 05:08:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("7684", "2548", "عملیات توسط Async Request کامل شد", "2025-09-22 05:08:41", "2025-09-22 05:08:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("7685", "2576", "ایجاد فعالیت", "2025-09-22 05:08:41", "2025-09-22 05:08:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("7686", "2549", "عملیات توسط Async Request شروع شد", "2025-09-22 05:08:41", "2025-09-22 05:08:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("7687", "2549", "عملیات توسط Async Request کامل شد", "2025-09-22 05:08:41", "2025-09-22 05:08:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("7688", "2577", "ایجاد فعالیت", "2025-09-22 05:08:41", "2025-09-22 05:08:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("7689", "2550", "عملیات توسط Async Request شروع شد", "2025-09-22 05:08:41", "2025-09-22 05:08:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("7690", "2550", "عملیات توسط Async Request کامل شد", "2025-09-22 05:08:43", "2025-09-22 05:08:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("7691", "2578", "ایجاد فعالیت", "2025-09-22 05:08:43", "2025-09-22 05:08:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("7692", "2551", "عملیات توسط Async Request شروع شد", "2025-09-22 05:08:43", "2025-09-22 05:08:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("7693", "2551", "عملیات توسط Async Request کامل شد", "2025-09-22 05:08:44", "2025-09-22 05:08:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("7694", "2579", "ایجاد فعالیت", "2025-09-22 05:08:44", "2025-09-22 05:08:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("7695", "2552", "عملیات توسط Async Request شروع شد", "2025-09-22 05:08:44", "2025-09-22 05:08:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("7696", "2552", "عملیات توسط Async Request کامل شد", "2025-09-22 05:08:44", "2025-09-22 05:08:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("7697", "2580", "ایجاد فعالیت", "2025-09-22 05:08:44", "2025-09-22 05:08:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("7698", "2553", "عملیات توسط Async Request شروع شد", "2025-09-22 05:08:44", "2025-09-22 05:08:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("7699", "2553", "عملیات توسط Async Request کامل شد", "2025-09-22 05:08:44", "2025-09-22 05:08:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("7700", "2581", "ایجاد فعالیت", "2025-09-22 05:08:44", "2025-09-22 05:08:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("7701", "2557", "عملیات توسط Async Request شروع شد", "2025-09-22 05:08:44", "2025-09-22 05:08:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("7702", "2582", "ایجاد فعالیت", "2025-09-22 05:08:44", "2025-09-22 05:08:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("7703", "2557", "عملیات توسط Async Request کامل شد", "2025-09-22 05:08:44", "2025-09-22 05:08:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("7704", "2583", "ایجاد فعالیت", "2025-09-22 05:08:44", "2025-09-22 05:08:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("7705", "2582", "عملیات توسط Async Request شروع شد", "2025-09-22 08:14:10", "2025-09-22 08:14:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7706", "2582", "عملیات توسط Async Request کامل شد", "2025-09-22 08:14:10", "2025-09-22 08:14:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7707", "2570", "عملیات توسط Async Request شروع شد", "2025-09-22 08:14:10", "2025-09-22 08:14:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7708", "2570", "عملیات توسط Async Request کامل شد", "2025-09-22 08:14:10", "2025-09-22 08:14:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7709", "2584", "ایجاد فعالیت", "2025-09-22 08:14:10", "2025-09-22 08:14:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7710", "2571", "عملیات توسط Async Request شروع شد", "2025-09-22 08:14:10", "2025-09-22 08:14:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7711", "2571", "عملیات توسط Async Request کامل شد", "2025-09-22 08:14:10", "2025-09-22 08:14:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7712", "2585", "ایجاد فعالیت", "2025-09-22 08:14:10", "2025-09-22 08:14:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7713", "2574", "عملیات توسط Async Request شروع شد", "2025-09-22 08:14:10", "2025-09-22 08:14:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7714", "2574", "عملیات توسط Async Request کامل شد", "2025-09-22 08:14:10", "2025-09-22 08:14:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7715", "2586", "ایجاد فعالیت", "2025-09-22 08:14:10", "2025-09-22 08:14:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7716", "2575", "عملیات توسط Async Request شروع شد", "2025-09-22 08:14:10", "2025-09-22 08:14:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7717", "2587", "ایجاد فعالیت", "2025-09-22 08:14:10", "2025-09-22 08:14:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7718", "2575", "عملیات توسط Async Request کامل شد", "2025-09-22 08:14:10", "2025-09-22 08:14:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("7719", "2586", "عملیات توسط Async Request شروع شد", "2025-09-22 09:59:14", "2025-09-22 09:59:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7720", "2586", "عملیات توسط Async Request کامل شد", "2025-09-22 09:59:14", "2025-09-22 09:59:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7721", "2588", "ایجاد فعالیت", "2025-09-22 09:59:14", "2025-09-22 09:59:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7722", "2587", "عملیات توسط Async Request شروع شد", "2025-09-22 09:59:14", "2025-09-22 09:59:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7723", "2589", "ایجاد فعالیت", "2025-09-22 09:59:14", "2025-09-22 09:59:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7724", "2587", "عملیات توسط Async Request کامل شد", "2025-09-22 09:59:14", "2025-09-22 09:59:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7725", "2588", "عملیات توسط Async Request شروع شد", "2025-09-22 11:22:23", "2025-09-22 11:22:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("7726", "2588", "عملیات توسط Async Request کامل شد", "2025-09-22 11:22:23", "2025-09-22 11:22:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("7727", "2590", "ایجاد فعالیت", "2025-09-22 11:22:23", "2025-09-22 11:22:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("7728", "2589", "عملیات توسط Async Request شروع شد", "2025-09-22 11:22:23", "2025-09-22 11:22:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("7729", "2591", "ایجاد فعالیت", "2025-09-22 11:22:23", "2025-09-22 11:22:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("7730", "2589", "عملیات توسط Async Request کامل شد", "2025-09-22 11:22:23", "2025-09-22 11:22:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("7731", "2590", "عملیات توسط Async Request شروع شد", "2025-09-22 12:54:47", "2025-09-22 12:54:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("7732", "2590", "عملیات توسط Async Request کامل شد", "2025-09-22 12:54:47", "2025-09-22 12:54:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("7733", "2592", "ایجاد فعالیت", "2025-09-22 12:54:47", "2025-09-22 12:54:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("7734", "2591", "عملیات توسط Async Request شروع شد", "2025-09-22 12:54:47", "2025-09-22 12:54:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("7735", "2593", "ایجاد فعالیت", "2025-09-22 12:54:47", "2025-09-22 12:54:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("7736", "2591", "عملیات توسط Async Request کامل شد", "2025-09-22 12:54:47", "2025-09-22 12:54:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("7737", "2592", "عملیات توسط Async Request شروع شد", "2025-09-22 14:21:14", "2025-09-22 14:21:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7738", "2592", "عملیات توسط Async Request کامل شد", "2025-09-22 14:21:14", "2025-09-22 14:21:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7739", "2594", "ایجاد فعالیت", "2025-09-22 14:21:14", "2025-09-22 14:21:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7740", "2593", "عملیات توسط Async Request شروع شد", "2025-09-22 14:21:14", "2025-09-22 14:21:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7741", "2595", "ایجاد فعالیت", "2025-09-22 14:21:14", "2025-09-22 14:21:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7742", "2593", "عملیات توسط Async Request کامل شد", "2025-09-22 14:21:14", "2025-09-22 14:21:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("7743", "2594", "عملیات توسط Async Request شروع شد", "2025-09-22 15:23:46", "2025-09-22 15:23:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("7744", "2594", "عملیات توسط Async Request کامل شد", "2025-09-22 15:23:46", "2025-09-22 15:23:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("7745", "2596", "ایجاد فعالیت", "2025-09-22 15:23:46", "2025-09-22 15:23:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("7746", "2595", "عملیات توسط Async Request شروع شد", "2025-09-22 15:23:46", "2025-09-22 15:23:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("7747", "2597", "ایجاد فعالیت", "2025-09-22 15:23:46", "2025-09-22 15:23:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("7748", "2595", "عملیات توسط Async Request کامل شد", "2025-09-22 15:23:46", "2025-09-22 15:23:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("7749", "2596", "عملیات توسط Async Request شروع شد", "2025-09-22 17:56:04", "2025-09-22 17:56:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7750", "2596", "عملیات توسط Async Request کامل شد", "2025-09-22 17:56:04", "2025-09-22 17:56:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7751", "2598", "ایجاد فعالیت", "2025-09-22 17:56:04", "2025-09-22 17:56:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7752", "2597", "عملیات توسط Async Request شروع شد", "2025-09-22 17:56:04", "2025-09-22 17:56:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7753", "2599", "ایجاد فعالیت", "2025-09-22 17:56:04", "2025-09-22 17:56:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7754", "2597", "عملیات توسط Async Request کامل شد", "2025-09-22 17:56:04", "2025-09-22 17:56:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7755", "2598", "عملیات توسط Async Request شروع شد", "2025-09-22 19:22:57", "2025-09-22 19:22:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("7756", "2598", "عملیات توسط Async Request کامل شد", "2025-09-22 19:22:57", "2025-09-22 19:22:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("7757", "2600", "ایجاد فعالیت", "2025-09-22 19:22:57", "2025-09-22 19:22:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("7758", "2599", "عملیات توسط Async Request شروع شد", "2025-09-22 19:22:57", "2025-09-22 19:22:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("7759", "2601", "ایجاد فعالیت", "2025-09-22 19:22:57", "2025-09-22 19:22:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("7760", "2599", "عملیات توسط Async Request کامل شد", "2025-09-22 19:22:57", "2025-09-22 19:22:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("7761", "2584", "عملیات توسط Async Request شروع شد", "2025-09-22 21:19:06", "2025-09-22 21:19:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7762", "2584", "عملیات توسط Async Request کامل شد", "2025-09-22 21:19:06", "2025-09-22 21:19:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7763", "2602", "ایجاد فعالیت", "2025-09-22 21:19:06", "2025-09-22 21:19:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7764", "2585", "عملیات توسط Async Request شروع شد", "2025-09-22 21:19:06", "2025-09-22 21:19:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7765", "2585", "عملیات توسط Async Request کامل شد", "2025-09-22 21:19:06", "2025-09-22 21:19:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7766", "2603", "ایجاد فعالیت", "2025-09-22 21:19:06", "2025-09-22 21:19:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7767", "2600", "عملیات توسط Async Request شروع شد", "2025-09-22 21:19:06", "2025-09-22 21:19:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7768", "2600", "عملیات توسط Async Request کامل شد", "2025-09-22 21:19:06", "2025-09-22 21:19:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7769", "2604", "ایجاد فعالیت", "2025-09-22 21:19:06", "2025-09-22 21:19:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7770", "2601", "عملیات توسط Async Request شروع شد", "2025-09-22 21:19:06", "2025-09-22 21:19:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7771", "2605", "ایجاد فعالیت", "2025-09-22 21:19:06", "2025-09-22 21:19:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7772", "2601", "عملیات توسط Async Request کامل شد", "2025-09-22 21:19:06", "2025-09-22 21:19:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7773", "2604", "عملیات توسط Async Request شروع شد", "2025-09-22 23:31:01", "2025-09-22 23:31:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7774", "2604", "عملیات توسط Async Request کامل شد", "2025-09-22 23:31:01", "2025-09-22 23:31:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7775", "2606", "ایجاد فعالیت", "2025-09-22 23:31:01", "2025-09-22 23:31:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7776", "2605", "عملیات توسط Async Request شروع شد", "2025-09-22 23:31:01", "2025-09-22 23:31:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7777", "2607", "ایجاد فعالیت", "2025-09-22 23:31:01", "2025-09-22 23:31:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7778", "2605", "عملیات توسط Async Request کامل شد", "2025-09-22 23:31:01", "2025-09-22 23:31:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7779", "2606", "عملیات توسط Async Request شروع شد", "2025-09-23 09:13:20", "2025-09-23 09:13:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7780", "2606", "عملیات توسط Async Request کامل شد", "2025-09-23 09:13:20", "2025-09-23 09:13:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7781", "2608", "ایجاد فعالیت", "2025-09-23 09:13:20", "2025-09-23 09:13:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7782", "2607", "عملیات توسط Async Request شروع شد", "2025-09-23 09:13:20", "2025-09-23 09:13:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7783", "2609", "ایجاد فعالیت", "2025-09-23 09:13:20", "2025-09-23 09:13:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7784", "2607", "عملیات توسط Async Request کامل شد", "2025-09-23 09:13:20", "2025-09-23 09:13:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7785", "2576", "عملیات توسط Async Request شروع شد", "2025-09-23 09:13:20", "2025-09-23 09:13:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7786", "2576", "عملیات توسط Async Request کامل شد", "2025-09-23 09:13:20", "2025-09-23 09:13:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7787", "2610", "ایجاد فعالیت", "2025-09-23 09:13:20", "2025-09-23 09:13:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7788", "2577", "عملیات توسط Async Request شروع شد", "2025-09-23 09:13:20", "2025-09-23 09:13:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7789", "2577", "عملیات توسط Async Request کامل شد", "2025-09-23 09:13:20", "2025-09-23 09:13:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7790", "2611", "ایجاد فعالیت", "2025-09-23 09:13:20", "2025-09-23 09:13:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7791", "2578", "عملیات توسط Async Request شروع شد", "2025-09-23 09:13:20", "2025-09-23 09:13:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7792", "2578", "عملیات توسط Async Request کامل شد", "2025-09-23 09:13:23", "2025-09-23 09:13:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("7793", "2612", "ایجاد فعالیت", "2025-09-23 09:13:23", "2025-09-23 09:13:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("7794", "2579", "عملیات توسط Async Request شروع شد", "2025-09-23 09:13:23", "2025-09-23 09:13:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("7795", "2579", "عملیات توسط Async Request کامل شد", "2025-09-23 09:13:24", "2025-09-23 09:13:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7796", "2613", "ایجاد فعالیت", "2025-09-23 09:13:24", "2025-09-23 09:13:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7797", "2580", "عملیات توسط Async Request شروع شد", "2025-09-23 09:13:24", "2025-09-23 09:13:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7798", "2580", "عملیات توسط Async Request کامل شد", "2025-09-23 09:13:24", "2025-09-23 09:13:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7799", "2614", "ایجاد فعالیت", "2025-09-23 09:13:24", "2025-09-23 09:13:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7800", "2581", "عملیات توسط Async Request شروع شد", "2025-09-23 09:13:24", "2025-09-23 09:13:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7801", "2581", "عملیات توسط Async Request کامل شد", "2025-09-23 09:13:24", "2025-09-23 09:13:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7802", "2615", "ایجاد فعالیت", "2025-09-23 09:13:24", "2025-09-23 09:13:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7803", "2583", "عملیات توسط Async Request شروع شد", "2025-09-23 09:13:24", "2025-09-23 09:13:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7804", "2616", "ایجاد فعالیت", "2025-09-23 09:13:24", "2025-09-23 09:13:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7805", "2583", "عملیات توسط Async Request کامل شد", "2025-09-23 09:13:24", "2025-09-23 09:13:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7806", "2617", "ایجاد فعالیت", "2025-09-23 09:13:24", "2025-09-23 09:13:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("7807", "2616", "عملیات توسط Async Request شروع شد", "2025-09-24 03:43:59", "2025-09-24 03:43:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7808", "2616", "عملیات توسط Async Request کامل شد", "2025-09-24 03:43:59", "2025-09-24 03:43:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7809", "2602", "عملیات توسط Async Request شروع شد", "2025-09-24 03:43:59", "2025-09-24 03:43:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7810", "2602", "عملیات توسط Async Request کامل شد", "2025-09-24 03:43:59", "2025-09-24 03:43:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7811", "2618", "ایجاد فعالیت", "2025-09-24 03:43:59", "2025-09-24 03:43:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7812", "2603", "عملیات توسط Async Request شروع شد", "2025-09-24 03:43:59", "2025-09-24 03:43:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7813", "2603", "عملیات توسط Async Request کامل شد", "2025-09-24 03:43:59", "2025-09-24 03:43:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7814", "2619", "ایجاد فعالیت", "2025-09-24 03:43:59", "2025-09-24 03:43:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7815", "2608", "عملیات توسط Async Request شروع شد", "2025-09-24 03:43:59", "2025-09-24 03:43:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7816", "2608", "عملیات توسط Async Request کامل شد", "2025-09-24 03:43:59", "2025-09-24 03:43:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7817", "2620", "ایجاد فعالیت", "2025-09-24 03:43:59", "2025-09-24 03:43:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7818", "2609", "عملیات توسط Async Request شروع شد", "2025-09-24 03:43:59", "2025-09-24 03:43:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7819", "2621", "ایجاد فعالیت", "2025-09-24 03:43:59", "2025-09-24 03:43:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7820", "2609", "عملیات توسط Async Request کامل شد", "2025-09-24 03:43:59", "2025-09-24 03:43:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("7821", "2622", "ایجاد فعالیت", "2025-09-24 03:45:48", "2025-09-24 03:45:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("7822", "2623", "ایجاد فعالیت", "2025-09-24 03:45:54", "2025-09-24 03:45:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("7823", "2624", "ایجاد فعالیت", "2025-09-24 03:45:54", "2025-09-24 03:45:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("7824", "2625", "ایجاد فعالیت", "2025-09-24 03:45:54", "2025-09-24 03:45:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("7825", "2622", "عملیات توسط Async Request شروع شد", "2025-09-24 03:46:05", "2025-09-24 03:46:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7826", "2622", "عملیات توسط Async Request کامل شد", "2025-09-24 03:46:05", "2025-09-24 03:46:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7827", "2623", "عملیات توسط Async Request شروع شد", "2025-09-24 03:46:05", "2025-09-24 03:46:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7828", "2623", "عملیات توسط Async Request کامل شد", "2025-09-24 03:46:05", "2025-09-24 03:46:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7829", "2625", "عملیات توسط Async Request شروع شد", "2025-09-24 03:46:05", "2025-09-24 03:46:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7830", "2625", "عملیات توسط Async Request کامل شد", "2025-09-24 03:46:05", "2025-09-24 03:46:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7831", "2624", "عملیات توسط Async Request شروع شد", "2025-09-24 03:46:05", "2025-09-24 03:46:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7832", "2624", "عملیات توسط Async Request کامل شد", "2025-09-24 03:46:05", "2025-09-24 03:46:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7833", "2620", "عملیات توسط Async Request شروع شد", "2025-09-24 11:27:53", "2025-09-24 11:27:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7834", "2620", "عملیات توسط Async Request کامل شد", "2025-09-24 11:27:53", "2025-09-24 11:27:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7835", "2626", "ایجاد فعالیت", "2025-09-24 11:27:53", "2025-09-24 11:27:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7836", "2621", "عملیات توسط Async Request شروع شد", "2025-09-24 11:27:53", "2025-09-24 11:27:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7837", "2627", "ایجاد فعالیت", "2025-09-24 11:27:53", "2025-09-24 11:27:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7838", "2621", "عملیات توسط Async Request کامل شد", "2025-09-24 11:27:53", "2025-09-24 11:27:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7839", "2610", "عملیات توسط Async Request شروع شد", "2025-09-24 11:27:53", "2025-09-24 11:27:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7840", "2610", "عملیات توسط Async Request کامل شد", "2025-09-24 11:27:53", "2025-09-24 11:27:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7841", "2628", "ایجاد فعالیت", "2025-09-24 11:27:53", "2025-09-24 11:27:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7842", "2611", "عملیات توسط Async Request شروع شد", "2025-09-24 11:27:53", "2025-09-24 11:27:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7843", "2611", "عملیات توسط Async Request کامل شد", "2025-09-24 11:27:53", "2025-09-24 11:27:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7844", "2629", "ایجاد فعالیت", "2025-09-24 11:27:53", "2025-09-24 11:27:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7845", "2612", "عملیات توسط Async Request شروع شد", "2025-09-24 11:27:53", "2025-09-24 11:27:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("7846", "2612", "عملیات توسط Async Request کامل شد", "2025-09-24 11:27:55", "2025-09-24 11:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("7847", "2630", "ایجاد فعالیت", "2025-09-24 11:27:55", "2025-09-24 11:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("7848", "2613", "عملیات توسط Async Request شروع شد", "2025-09-24 11:27:55", "2025-09-24 11:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("7849", "2613", "عملیات توسط Async Request کامل شد", "2025-09-24 11:27:56", "2025-09-24 11:27:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("7850", "2631", "ایجاد فعالیت", "2025-09-24 11:27:56", "2025-09-24 11:27:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("7851", "2614", "عملیات توسط Async Request شروع شد", "2025-09-24 11:27:56", "2025-09-24 11:27:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("7852", "2614", "عملیات توسط Async Request کامل شد", "2025-09-24 11:27:56", "2025-09-24 11:27:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("7853", "2632", "ایجاد فعالیت", "2025-09-24 11:27:56", "2025-09-24 11:27:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("7854", "2615", "عملیات توسط Async Request شروع شد", "2025-09-24 11:27:56", "2025-09-24 11:27:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("7855", "2615", "عملیات توسط Async Request کامل شد", "2025-09-24 11:27:56", "2025-09-24 11:27:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("7856", "2633", "ایجاد فعالیت", "2025-09-24 11:27:56", "2025-09-24 11:27:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("7857", "2617", "عملیات توسط Async Request شروع شد", "2025-09-24 11:27:56", "2025-09-24 11:27:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("7858", "2634", "ایجاد فعالیت", "2025-09-24 11:27:56", "2025-09-24 11:27:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("7859", "2617", "عملیات توسط Async Request کامل شد", "2025-09-24 11:27:56", "2025-09-24 11:27:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("7860", "2635", "ایجاد فعالیت", "2025-09-24 11:27:56", "2025-09-24 11:27:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("7861", "2634", "عملیات توسط Async Request شروع شد", "2025-09-24 11:28:58", "2025-09-24 11:28:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7862", "2634", "عملیات توسط Async Request کامل شد", "2025-09-24 11:28:58", "2025-09-24 11:28:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("7863", "2626", "عملیات توسط Async Request شروع شد", "2025-09-24 12:33:37", "2025-09-24 12:33:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7864", "2626", "عملیات توسط Async Request کامل شد", "2025-09-24 12:33:37", "2025-09-24 12:33:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7865", "2636", "ایجاد فعالیت", "2025-09-24 12:33:37", "2025-09-24 12:33:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7866", "2627", "عملیات توسط Async Request شروع شد", "2025-09-24 12:33:37", "2025-09-24 12:33:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7867", "2637", "ایجاد فعالیت", "2025-09-24 12:33:37", "2025-09-24 12:33:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7868", "2627", "عملیات توسط Async Request کامل شد", "2025-09-24 12:33:37", "2025-09-24 12:33:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7869", "2636", "عملیات توسط Async Request شروع شد", "2025-09-24 18:01:12", "2025-09-24 18:01:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("7870", "2636", "عملیات توسط Async Request کامل شد", "2025-09-24 18:01:12", "2025-09-24 18:01:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("7871", "2638", "ایجاد فعالیت", "2025-09-24 18:01:12", "2025-09-24 18:01:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("7872", "2637", "عملیات توسط Async Request شروع شد", "2025-09-24 18:01:12", "2025-09-24 18:01:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("7873", "2639", "ایجاد فعالیت", "2025-09-24 18:01:12", "2025-09-24 18:01:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("7874", "2637", "عملیات توسط Async Request کامل شد", "2025-09-24 18:01:12", "2025-09-24 18:01:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("7875", "2618", "عملیات توسط Async Request شروع شد", "2025-09-24 18:01:12", "2025-09-24 18:01:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("7876", "2618", "عملیات توسط Async Request کامل شد", "2025-09-24 18:01:12", "2025-09-24 18:01:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("7877", "2640", "ایجاد فعالیت", "2025-09-24 18:01:12", "2025-09-24 18:01:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("7878", "2619", "عملیات توسط Async Request شروع شد", "2025-09-24 18:01:12", "2025-09-24 18:01:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("7879", "2619", "عملیات توسط Async Request کامل شد", "2025-09-24 18:01:12", "2025-09-24 18:01:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("7880", "2641", "ایجاد فعالیت", "2025-09-24 18:01:12", "2025-09-24 18:01:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("7881", "2638", "عملیات توسط Async Request شروع شد", "2025-09-25 01:15:37", "2025-09-25 01:15:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7882", "2638", "عملیات توسط Async Request کامل شد", "2025-09-25 01:15:37", "2025-09-25 01:15:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7883", "2642", "ایجاد فعالیت", "2025-09-25 01:15:37", "2025-09-25 01:15:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7884", "2639", "عملیات توسط Async Request شروع شد", "2025-09-25 01:15:37", "2025-09-25 01:15:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7885", "2643", "ایجاد فعالیت", "2025-09-25 01:15:37", "2025-09-25 01:15:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7886", "2639", "عملیات توسط Async Request کامل شد", "2025-09-25 01:15:37", "2025-09-25 01:15:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("7887", "2642", "عملیات توسط Async Request شروع شد", "2025-09-25 02:47:05", "2025-09-25 02:47:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7888", "2642", "عملیات توسط Async Request کامل شد", "2025-09-25 02:47:05", "2025-09-25 02:47:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7889", "2644", "ایجاد فعالیت", "2025-09-25 02:47:05", "2025-09-25 02:47:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7890", "2643", "عملیات توسط Async Request شروع شد", "2025-09-25 02:47:05", "2025-09-25 02:47:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7891", "2645", "ایجاد فعالیت", "2025-09-25 02:47:05", "2025-09-25 02:47:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7892", "2643", "عملیات توسط Async Request کامل شد", "2025-09-25 02:47:05", "2025-09-25 02:47:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("7893", "2644", "عملیات توسط Async Request شروع شد", "2025-09-25 11:47:01", "2025-09-25 11:47:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7894", "2644", "عملیات توسط Async Request کامل شد", "2025-09-25 11:47:01", "2025-09-25 11:47:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7895", "2646", "ایجاد فعالیت", "2025-09-25 11:47:01", "2025-09-25 11:47:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7896", "2645", "عملیات توسط Async Request شروع شد", "2025-09-25 11:47:01", "2025-09-25 11:47:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7897", "2647", "ایجاد فعالیت", "2025-09-25 11:47:01", "2025-09-25 11:47:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7898", "2645", "عملیات توسط Async Request کامل شد", "2025-09-25 11:47:01", "2025-09-25 11:47:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7899", "2640", "عملیات توسط Async Request شروع شد", "2025-09-25 11:47:01", "2025-09-25 11:47:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7900", "2640", "عملیات توسط Async Request کامل شد", "2025-09-25 11:47:01", "2025-09-25 11:47:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7901", "2648", "ایجاد فعالیت", "2025-09-25 11:47:01", "2025-09-25 11:47:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7902", "2641", "عملیات توسط Async Request شروع شد", "2025-09-25 11:47:01", "2025-09-25 11:47:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7903", "2641", "عملیات توسط Async Request کامل شد", "2025-09-25 11:47:01", "2025-09-25 11:47:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7904", "2649", "ایجاد فعالیت", "2025-09-25 11:47:01", "2025-09-25 11:47:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7905", "2628", "عملیات توسط Async Request شروع شد", "2025-09-25 11:47:01", "2025-09-25 11:47:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7906", "2628", "عملیات توسط Async Request کامل شد", "2025-09-25 11:47:01", "2025-09-25 11:47:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7907", "2650", "ایجاد فعالیت", "2025-09-25 11:47:01", "2025-09-25 11:47:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7908", "2629", "عملیات توسط Async Request شروع شد", "2025-09-25 11:47:01", "2025-09-25 11:47:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7909", "2629", "عملیات توسط Async Request کامل شد", "2025-09-25 11:47:01", "2025-09-25 11:47:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7910", "2651", "ایجاد فعالیت", "2025-09-25 11:47:01", "2025-09-25 11:47:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7911", "2630", "عملیات توسط Async Request شروع شد", "2025-09-25 11:47:01", "2025-09-25 11:47:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("7912", "2630", "عملیات توسط Async Request کامل شد", "2025-09-25 11:47:03", "2025-09-25 11:47:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("7913", "2652", "ایجاد فعالیت", "2025-09-25 11:47:03", "2025-09-25 11:47:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("7914", "2631", "عملیات توسط Async Request شروع شد", "2025-09-25 11:47:03", "2025-09-25 11:47:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("7915", "2631", "عملیات توسط Async Request کامل شد", "2025-09-25 11:47:04", "2025-09-25 11:47:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7916", "2653", "ایجاد فعالیت", "2025-09-25 11:47:04", "2025-09-25 11:47:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7917", "2632", "عملیات توسط Async Request شروع شد", "2025-09-25 11:47:04", "2025-09-25 11:47:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7918", "2632", "عملیات توسط Async Request کامل شد", "2025-09-25 11:47:04", "2025-09-25 11:47:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7919", "2654", "ایجاد فعالیت", "2025-09-25 11:47:04", "2025-09-25 11:47:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7920", "2633", "عملیات توسط Async Request شروع شد", "2025-09-25 11:47:04", "2025-09-25 11:47:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7921", "2633", "عملیات توسط Async Request کامل شد", "2025-09-25 11:47:04", "2025-09-25 11:47:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7922", "2655", "ایجاد فعالیت", "2025-09-25 11:47:04", "2025-09-25 11:47:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7923", "2635", "عملیات توسط Async Request شروع شد", "2025-09-25 11:47:04", "2025-09-25 11:47:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7924", "2656", "ایجاد فعالیت", "2025-09-25 11:47:04", "2025-09-25 11:47:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7925", "2635", "عملیات توسط Async Request کامل شد", "2025-09-25 11:47:04", "2025-09-25 11:47:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7926", "2657", "ایجاد فعالیت", "2025-09-25 11:47:04", "2025-09-25 11:47:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7927", "2656", "عملیات توسط Async Request شروع شد", "2025-09-25 11:48:12", "2025-09-25 11:48:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("7928", "2656", "عملیات توسط Async Request کامل شد", "2025-09-25 11:48:12", "2025-09-25 11:48:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("7929", "2646", "عملیات توسط Async Request شروع شد", "2025-09-25 13:18:20", "2025-09-25 13:18:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7930", "2646", "عملیات توسط Async Request کامل شد", "2025-09-25 13:18:20", "2025-09-25 13:18:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7931", "2658", "ایجاد فعالیت", "2025-09-25 13:18:20", "2025-09-25 13:18:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7932", "2647", "عملیات توسط Async Request شروع شد", "2025-09-25 13:18:20", "2025-09-25 13:18:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7933", "2659", "ایجاد فعالیت", "2025-09-25 13:18:20", "2025-09-25 13:18:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7934", "2647", "عملیات توسط Async Request کامل شد", "2025-09-25 13:18:20", "2025-09-25 13:18:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("7935", "2658", "عملیات توسط Async Request شروع شد", "2025-09-25 17:40:27", "2025-09-25 17:40:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7936", "2658", "عملیات توسط Async Request کامل شد", "2025-09-25 17:40:27", "2025-09-25 17:40:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7937", "2660", "ایجاد فعالیت", "2025-09-25 17:40:27", "2025-09-25 17:40:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7938", "2659", "عملیات توسط Async Request شروع شد", "2025-09-25 17:40:27", "2025-09-25 17:40:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7939", "2661", "ایجاد فعالیت", "2025-09-25 17:40:27", "2025-09-25 17:40:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7940", "2659", "عملیات توسط Async Request کامل شد", "2025-09-25 17:40:27", "2025-09-25 17:40:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7941", "2660", "عملیات توسط Async Request شروع شد", "2025-09-25 21:48:36", "2025-09-25 21:48:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7942", "2660", "عملیات توسط Async Request کامل شد", "2025-09-25 21:48:36", "2025-09-25 21:48:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7943", "2662", "ایجاد فعالیت", "2025-09-25 21:48:36", "2025-09-25 21:48:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7944", "2661", "عملیات توسط Async Request شروع شد", "2025-09-25 21:48:36", "2025-09-25 21:48:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7945", "2663", "ایجاد فعالیت", "2025-09-25 21:48:36", "2025-09-25 21:48:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7946", "2661", "عملیات توسط Async Request کامل شد", "2025-09-25 21:48:36", "2025-09-25 21:48:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("7947", "2662", "عملیات توسط Async Request شروع شد", "2025-09-26 06:55:27", "2025-09-26 06:55:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7948", "2662", "عملیات توسط Async Request کامل شد", "2025-09-26 06:55:27", "2025-09-26 06:55:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7949", "2664", "ایجاد فعالیت", "2025-09-26 06:55:27", "2025-09-26 06:55:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7950", "2663", "عملیات توسط Async Request شروع شد", "2025-09-26 06:55:27", "2025-09-26 06:55:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7951", "2665", "ایجاد فعالیت", "2025-09-26 06:55:27", "2025-09-26 06:55:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7952", "2663", "عملیات توسط Async Request کامل شد", "2025-09-26 06:55:27", "2025-09-26 06:55:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7953", "2648", "عملیات توسط Async Request شروع شد", "2025-09-26 06:55:27", "2025-09-26 06:55:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7954", "2648", "عملیات توسط Async Request کامل شد", "2025-09-26 06:55:27", "2025-09-26 06:55:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7955", "2666", "ایجاد فعالیت", "2025-09-26 06:55:27", "2025-09-26 06:55:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7956", "2649", "عملیات توسط Async Request شروع شد", "2025-09-26 06:55:27", "2025-09-26 06:55:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7957", "2649", "عملیات توسط Async Request کامل شد", "2025-09-26 06:55:27", "2025-09-26 06:55:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7958", "2667", "ایجاد فعالیت", "2025-09-26 06:55:27", "2025-09-26 06:55:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("7959", "2664", "عملیات توسط Async Request شروع شد", "2025-09-26 18:11:00", "2025-09-26 18:11:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7960", "2664", "عملیات توسط Async Request کامل شد", "2025-09-26 18:11:00", "2025-09-26 18:11:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7961", "2668", "ایجاد فعالیت", "2025-09-26 18:11:00", "2025-09-26 18:11:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7962", "2665", "عملیات توسط Async Request شروع شد", "2025-09-26 18:11:00", "2025-09-26 18:11:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7963", "2669", "ایجاد فعالیت", "2025-09-26 18:11:00", "2025-09-26 18:11:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7964", "2665", "عملیات توسط Async Request کامل شد", "2025-09-26 18:11:00", "2025-09-26 18:11:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7965", "2650", "عملیات توسط Async Request شروع شد", "2025-09-26 18:11:00", "2025-09-26 18:11:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7966", "2650", "عملیات توسط Async Request کامل شد", "2025-09-26 18:11:00", "2025-09-26 18:11:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7967", "2670", "ایجاد فعالیت", "2025-09-26 18:11:00", "2025-09-26 18:11:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7968", "2651", "عملیات توسط Async Request شروع شد", "2025-09-26 18:11:00", "2025-09-26 18:11:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7969", "2651", "عملیات توسط Async Request کامل شد", "2025-09-26 18:11:00", "2025-09-26 18:11:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7970", "2671", "ایجاد فعالیت", "2025-09-26 18:11:00", "2025-09-26 18:11:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7971", "2652", "عملیات توسط Async Request شروع شد", "2025-09-26 18:11:00", "2025-09-26 18:11:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("7972", "2652", "عملیات توسط Async Request کامل شد", "2025-09-26 18:11:02", "2025-09-26 18:11:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("7973", "2672", "ایجاد فعالیت", "2025-09-26 18:11:02", "2025-09-26 18:11:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("7974", "2653", "عملیات توسط Async Request شروع شد", "2025-09-26 18:11:02", "2025-09-26 18:11:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("7975", "2653", "عملیات توسط Async Request کامل شد", "2025-09-26 18:11:03", "2025-09-26 18:11:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("7976", "2673", "ایجاد فعالیت", "2025-09-26 18:11:03", "2025-09-26 18:11:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("7977", "2654", "عملیات توسط Async Request شروع شد", "2025-09-26 18:11:03", "2025-09-26 18:11:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("7978", "2654", "عملیات توسط Async Request کامل شد", "2025-09-26 18:11:04", "2025-09-26 18:11:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7979", "2674", "ایجاد فعالیت", "2025-09-26 18:11:04", "2025-09-26 18:11:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7980", "2655", "عملیات توسط Async Request شروع شد", "2025-09-26 18:11:04", "2025-09-26 18:11:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7981", "2655", "عملیات توسط Async Request کامل شد", "2025-09-26 18:11:04", "2025-09-26 18:11:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7982", "2675", "ایجاد فعالیت", "2025-09-26 18:11:04", "2025-09-26 18:11:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7983", "2657", "عملیات توسط Async Request شروع شد", "2025-09-26 18:11:04", "2025-09-26 18:11:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7984", "2676", "ایجاد فعالیت", "2025-09-26 18:11:04", "2025-09-26 18:11:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7985", "2657", "عملیات توسط Async Request کامل شد", "2025-09-26 18:11:04", "2025-09-26 18:11:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7986", "2677", "ایجاد فعالیت", "2025-09-26 18:11:04", "2025-09-26 18:11:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("7987", "2676", "عملیات توسط Async Request شروع شد", "2025-09-26 19:08:22", "2025-09-26 19:08:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7988", "2676", "عملیات توسط Async Request کامل شد", "2025-09-26 19:08:22", "2025-09-26 19:08:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7989", "2666", "عملیات توسط Async Request شروع شد", "2025-09-26 19:08:22", "2025-09-26 19:08:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7990", "2666", "عملیات توسط Async Request کامل شد", "2025-09-26 19:08:22", "2025-09-26 19:08:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7991", "2678", "ایجاد فعالیت", "2025-09-26 19:08:22", "2025-09-26 19:08:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7992", "2667", "عملیات توسط Async Request شروع شد", "2025-09-26 19:08:22", "2025-09-26 19:08:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7993", "2667", "عملیات توسط Async Request کامل شد", "2025-09-26 19:08:22", "2025-09-26 19:08:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7994", "2679", "ایجاد فعالیت", "2025-09-26 19:08:22", "2025-09-26 19:08:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("7995", "2668", "عملیات توسط Async Request شروع شد", "2025-09-26 20:59:06", "2025-09-26 20:59:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7996", "2668", "عملیات توسط Async Request کامل شد", "2025-09-26 20:59:06", "2025-09-26 20:59:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7997", "2680", "ایجاد فعالیت", "2025-09-26 20:59:06", "2025-09-26 20:59:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7998", "2669", "عملیات توسط Async Request شروع شد", "2025-09-26 20:59:06", "2025-09-26 20:59:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("7999", "2681", "ایجاد فعالیت", "2025-09-26 20:59:06", "2025-09-26 20:59:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("8000", "2669", "عملیات توسط Async Request کامل شد", "2025-09-26 20:59:06", "2025-09-26 20:59:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("8001", "2680", "عملیات توسط Async Request شروع شد", "2025-09-26 22:05:59", "2025-09-26 22:05:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8002", "2680", "عملیات توسط Async Request کامل شد", "2025-09-26 22:05:59", "2025-09-26 22:05:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8003", "2682", "ایجاد فعالیت", "2025-09-26 22:05:59", "2025-09-26 22:05:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8004", "2681", "عملیات توسط Async Request شروع شد", "2025-09-26 22:05:59", "2025-09-26 22:05:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8005", "2683", "ایجاد فعالیت", "2025-09-26 22:05:59", "2025-09-26 22:05:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8006", "2681", "عملیات توسط Async Request کامل شد", "2025-09-26 22:05:59", "2025-09-26 22:05:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8007", "2682", "عملیات توسط Async Request شروع شد", "2025-09-27 06:44:59", "2025-09-27 06:44:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8008", "2682", "عملیات توسط Async Request کامل شد", "2025-09-27 06:44:59", "2025-09-27 06:44:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8009", "2684", "ایجاد فعالیت", "2025-09-27 06:44:59", "2025-09-27 06:44:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8010", "2683", "عملیات توسط Async Request شروع شد", "2025-09-27 06:44:59", "2025-09-27 06:44:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8011", "2685", "ایجاد فعالیت", "2025-09-27 06:44:59", "2025-09-27 06:44:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8012", "2683", "عملیات توسط Async Request کامل شد", "2025-09-27 06:44:59", "2025-09-27 06:44:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8013", "2686", "ایجاد فعالیت", "2025-09-27 06:54:52", "2025-09-27 06:54:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("8014", "2686", "عملیات توسط Async Request شروع شد", "2025-09-27 07:28:31", "2025-09-27 07:28:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("8015", "2686", "عملیات توسط Async Request کامل شد", "2025-09-27 07:28:31", "2025-09-27 07:28:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("8016", "2678", "عملیات توسط Async Request شروع شد", "2025-09-27 07:28:31", "2025-09-27 07:28:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("8017", "2678", "عملیات توسط Async Request کامل شد", "2025-09-27 07:28:31", "2025-09-27 07:28:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("8018", "2687", "ایجاد فعالیت", "2025-09-27 07:28:31", "2025-09-27 07:28:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("8019", "2679", "عملیات توسط Async Request شروع شد", "2025-09-27 07:28:31", "2025-09-27 07:28:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("8020", "2679", "عملیات توسط Async Request کامل شد", "2025-09-27 07:28:31", "2025-09-27 07:28:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("8021", "2688", "ایجاد فعالیت", "2025-09-27 07:28:31", "2025-09-27 07:28:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("8022", "2684", "عملیات توسط Async Request شروع شد", "2025-09-27 16:52:24", "2025-09-27 16:52:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8023", "2684", "عملیات توسط Async Request کامل شد", "2025-09-27 16:52:24", "2025-09-27 16:52:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8024", "2689", "ایجاد فعالیت", "2025-09-27 16:52:24", "2025-09-27 16:52:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8025", "2685", "عملیات توسط Async Request شروع شد", "2025-09-27 16:52:24", "2025-09-27 16:52:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8026", "2690", "ایجاد فعالیت", "2025-09-27 16:52:24", "2025-09-27 16:52:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8027", "2685", "عملیات توسط Async Request کامل شد", "2025-09-27 16:52:24", "2025-09-27 16:52:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8028", "2689", "عملیات توسط Async Request شروع شد", "2025-09-27 21:41:24", "2025-09-27 21:41:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8029", "2689", "عملیات توسط Async Request کامل شد", "2025-09-27 21:41:24", "2025-09-27 21:41:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8030", "2691", "ایجاد فعالیت", "2025-09-27 21:41:24", "2025-09-27 21:41:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8031", "2690", "عملیات توسط Async Request شروع شد", "2025-09-27 21:41:24", "2025-09-27 21:41:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8032", "2692", "ایجاد فعالیت", "2025-09-27 21:41:24", "2025-09-27 21:41:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8033", "2690", "عملیات توسط Async Request کامل شد", "2025-09-27 21:41:24", "2025-09-27 21:41:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8034", "2670", "عملیات توسط Async Request شروع شد", "2025-09-27 21:41:24", "2025-09-27 21:41:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8035", "2670", "عملیات توسط Async Request کامل شد", "2025-09-27 21:41:24", "2025-09-27 21:41:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8036", "2693", "ایجاد فعالیت", "2025-09-27 21:41:24", "2025-09-27 21:41:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8037", "2671", "عملیات توسط Async Request شروع شد", "2025-09-27 21:41:24", "2025-09-27 21:41:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8038", "2671", "عملیات توسط Async Request کامل شد", "2025-09-27 21:41:24", "2025-09-27 21:41:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8039", "2694", "ایجاد فعالیت", "2025-09-27 21:41:24", "2025-09-27 21:41:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8040", "2672", "عملیات توسط Async Request شروع شد", "2025-09-27 21:41:24", "2025-09-27 21:41:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8041", "2672", "عملیات توسط Async Request کامل شد", "2025-09-27 21:41:26", "2025-09-27 21:41:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("8042", "2695", "ایجاد فعالیت", "2025-09-27 21:41:26", "2025-09-27 21:41:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("8043", "2673", "عملیات توسط Async Request شروع شد", "2025-09-27 21:41:26", "2025-09-27 21:41:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("8044", "2673", "عملیات توسط Async Request کامل شد", "2025-09-27 21:41:27", "2025-09-27 21:41:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8045", "2696", "ایجاد فعالیت", "2025-09-27 21:41:27", "2025-09-27 21:41:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8046", "2674", "عملیات توسط Async Request شروع شد", "2025-09-27 21:41:27", "2025-09-27 21:41:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8047", "2674", "عملیات توسط Async Request کامل شد", "2025-09-27 21:41:27", "2025-09-27 21:41:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8048", "2697", "ایجاد فعالیت", "2025-09-27 21:41:27", "2025-09-27 21:41:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8049", "2675", "عملیات توسط Async Request شروع شد", "2025-09-27 21:41:27", "2025-09-27 21:41:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8050", "2675", "عملیات توسط Async Request کامل شد", "2025-09-27 21:41:27", "2025-09-27 21:41:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8051", "2698", "ایجاد فعالیت", "2025-09-27 21:41:27", "2025-09-27 21:41:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8052", "2687", "عملیات توسط Async Request شروع شد", "2025-09-27 21:41:27", "2025-09-27 21:41:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8053", "2687", "عملیات توسط Async Request کامل شد", "2025-09-27 21:41:27", "2025-09-27 21:41:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8054", "2699", "ایجاد فعالیت", "2025-09-27 21:41:27", "2025-09-27 21:41:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8055", "2688", "عملیات توسط Async Request شروع شد", "2025-09-27 21:41:27", "2025-09-27 21:41:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8056", "2688", "عملیات توسط Async Request کامل شد", "2025-09-27 21:41:27", "2025-09-27 21:41:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8057", "2700", "ایجاد فعالیت", "2025-09-27 21:41:27", "2025-09-27 21:41:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8058", "2677", "عملیات توسط Async Request شروع شد", "2025-09-27 21:41:27", "2025-09-27 21:41:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8059", "2701", "ایجاد فعالیت", "2025-09-27 21:41:27", "2025-09-27 21:41:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8060", "2677", "عملیات توسط Async Request کامل شد", "2025-09-27 21:41:27", "2025-09-27 21:41:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8061", "2702", "ایجاد فعالیت", "2025-09-27 21:41:27", "2025-09-27 21:41:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8062", "2701", "عملیات توسط Async Request شروع شد", "2025-09-28 02:29:48", "2025-09-28 02:29:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("8063", "2701", "عملیات توسط Async Request کامل شد", "2025-09-28 02:29:48", "2025-09-28 02:29:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("8064", "2691", "عملیات توسط Async Request شروع شد", "2025-09-28 02:29:48", "2025-09-28 02:29:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("8065", "2691", "عملیات توسط Async Request کامل شد", "2025-09-28 02:29:48", "2025-09-28 02:29:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("8066", "2703", "ایجاد فعالیت", "2025-09-28 02:29:48", "2025-09-28 02:29:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("8067", "2692", "عملیات توسط Async Request شروع شد", "2025-09-28 02:29:48", "2025-09-28 02:29:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("8068", "2704", "ایجاد فعالیت", "2025-09-28 02:29:48", "2025-09-28 02:29:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("8069", "2692", "عملیات توسط Async Request کامل شد", "2025-09-28 02:29:48", "2025-09-28 02:29:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("8070", "2703", "عملیات توسط Async Request شروع شد", "2025-09-28 13:38:43", "2025-09-28 13:38:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("8071", "2703", "عملیات توسط Async Request کامل شد", "2025-09-28 13:38:43", "2025-09-28 13:38:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("8072", "2705", "ایجاد فعالیت", "2025-09-28 13:38:43", "2025-09-28 13:38:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("8073", "2704", "عملیات توسط Async Request شروع شد", "2025-09-28 13:38:43", "2025-09-28 13:38:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("8074", "2706", "ایجاد فعالیت", "2025-09-28 13:38:43", "2025-09-28 13:38:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("8075", "2704", "عملیات توسط Async Request کامل شد", "2025-09-28 13:38:43", "2025-09-28 13:38:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("8076", "2699", "عملیات توسط Async Request شروع شد", "2025-09-28 13:38:43", "2025-09-28 13:38:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("8077", "2699", "عملیات توسط Async Request کامل شد", "2025-09-28 13:38:43", "2025-09-28 13:38:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("8078", "2707", "ایجاد فعالیت", "2025-09-28 13:38:43", "2025-09-28 13:38:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("8079", "2700", "عملیات توسط Async Request شروع شد", "2025-09-28 13:38:43", "2025-09-28 13:38:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("8080", "2700", "عملیات توسط Async Request کامل شد", "2025-09-28 13:38:43", "2025-09-28 13:38:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("8081", "2708", "ایجاد فعالیت", "2025-09-28 13:38:43", "2025-09-28 13:38:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("8082", "2705", "عملیات توسط Async Request شروع شد", "2025-09-28 14:51:07", "2025-09-28 14:51:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("8083", "2705", "عملیات توسط Async Request کامل شد", "2025-09-28 14:51:07", "2025-09-28 14:51:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("8084", "2709", "ایجاد فعالیت", "2025-09-28 14:51:07", "2025-09-28 14:51:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("8085", "2706", "عملیات توسط Async Request شروع شد", "2025-09-28 14:51:07", "2025-09-28 14:51:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("8086", "2710", "ایجاد فعالیت", "2025-09-28 14:51:07", "2025-09-28 14:51:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("8087", "2706", "عملیات توسط Async Request کامل شد", "2025-09-28 14:51:07", "2025-09-28 14:51:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("8088", "2709", "عملیات توسط Async Request شروع شد", "2025-09-28 17:18:39", "2025-09-28 17:18:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("8089", "2709", "عملیات توسط Async Request کامل شد", "2025-09-28 17:18:39", "2025-09-28 17:18:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("8090", "2711", "ایجاد فعالیت", "2025-09-28 17:18:39", "2025-09-28 17:18:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("8091", "2710", "عملیات توسط Async Request شروع شد", "2025-09-28 17:18:39", "2025-09-28 17:18:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("8092", "2712", "ایجاد فعالیت", "2025-09-28 17:18:39", "2025-09-28 17:18:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("8093", "2710", "عملیات توسط Async Request کامل شد", "2025-09-28 17:18:39", "2025-09-28 17:18:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("8094", "2711", "عملیات توسط Async Request شروع شد", "2025-09-29 07:30:22", "2025-09-29 07:30:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("8095", "2711", "عملیات توسط Async Request کامل شد", "2025-09-29 07:30:22", "2025-09-29 07:30:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("8096", "2713", "ایجاد فعالیت", "2025-09-29 07:30:22", "2025-09-29 07:30:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("8097", "2712", "عملیات توسط Async Request شروع شد", "2025-09-29 07:30:22", "2025-09-29 07:30:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("8098", "2714", "ایجاد فعالیت", "2025-09-29 07:30:22", "2025-09-29 07:30:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("8099", "2712", "عملیات توسط Async Request کامل شد", "2025-09-29 07:30:22", "2025-09-29 07:30:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("8100", "2693", "عملیات توسط Async Request شروع شد", "2025-09-29 07:30:22", "2025-09-29 07:30:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("8101", "2693", "عملیات توسط Async Request کامل شد", "2025-09-29 07:30:22", "2025-09-29 07:30:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("8102", "2715", "ایجاد فعالیت", "2025-09-29 07:30:22", "2025-09-29 07:30:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("8103", "2694", "عملیات توسط Async Request شروع شد", "2025-09-29 07:30:22", "2025-09-29 07:30:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("8104", "2694", "عملیات توسط Async Request کامل شد", "2025-09-29 07:30:22", "2025-09-29 07:30:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("8105", "2716", "ایجاد فعالیت", "2025-09-29 07:30:22", "2025-09-29 07:30:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("8106", "2695", "عملیات توسط Async Request شروع شد", "2025-09-29 07:30:22", "2025-09-29 07:30:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("8107", "2695", "عملیات توسط Async Request کامل شد", "2025-09-29 07:30:24", "2025-09-29 07:30:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8108", "2717", "ایجاد فعالیت", "2025-09-29 07:30:24", "2025-09-29 07:30:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8109", "2696", "عملیات توسط Async Request شروع شد", "2025-09-29 07:30:24", "2025-09-29 07:30:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8110", "2696", "عملیات توسط Async Request کامل شد", "2025-09-29 07:30:25", "2025-09-29 07:30:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("8111", "2718", "ایجاد فعالیت", "2025-09-29 07:30:25", "2025-09-29 07:30:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("8112", "2697", "عملیات توسط Async Request شروع شد", "2025-09-29 07:30:25", "2025-09-29 07:30:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("8113", "2697", "عملیات توسط Async Request کامل شد", "2025-09-29 07:30:25", "2025-09-29 07:30:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("8114", "2719", "ایجاد فعالیت", "2025-09-29 07:30:25", "2025-09-29 07:30:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("8115", "2698", "عملیات توسط Async Request شروع شد", "2025-09-29 07:30:25", "2025-09-29 07:30:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("8116", "2698", "عملیات توسط Async Request کامل شد", "2025-09-29 07:30:25", "2025-09-29 07:30:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("8117", "2720", "ایجاد فعالیت", "2025-09-29 07:30:25", "2025-09-29 07:30:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("8118", "2707", "عملیات توسط Async Request شروع شد", "2025-09-29 07:30:25", "2025-09-29 07:30:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("8119", "2707", "عملیات توسط Async Request کامل شد", "2025-09-29 07:30:25", "2025-09-29 07:30:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("8120", "2721", "ایجاد فعالیت", "2025-09-29 07:30:25", "2025-09-29 07:30:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("8121", "2708", "عملیات توسط Async Request شروع شد", "2025-09-29 07:30:25", "2025-09-29 07:30:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("8122", "2708", "عملیات توسط Async Request کامل شد", "2025-09-29 07:30:25", "2025-09-29 07:30:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("8123", "2722", "ایجاد فعالیت", "2025-09-29 07:30:25", "2025-09-29 07:30:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("8124", "2702", "عملیات توسط Async Request شروع شد", "2025-09-29 07:30:25", "2025-09-29 07:30:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("8125", "2723", "ایجاد فعالیت", "2025-09-29 07:30:25", "2025-09-29 07:30:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("8126", "2702", "عملیات توسط Async Request کامل شد", "2025-09-29 07:30:25", "2025-09-29 07:30:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("8127", "2724", "ایجاد فعالیت", "2025-09-29 07:30:25", "2025-09-29 07:30:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("8128", "2725", "ایجاد فعالیت", "2025-09-29 07:31:23", "2025-09-29 07:31:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("8129", "2723", "عملیات توسط Async Request شروع شد", "2025-09-29 09:06:50", "2025-09-29 09:06:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("8130", "2723", "عملیات توسط Async Request کامل شد", "2025-09-29 09:06:50", "2025-09-29 09:06:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("8131", "2725", "عملیات توسط Async Request شروع شد", "2025-09-29 09:06:50", "2025-09-29 09:06:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("8132", "2725", "عملیات توسط Async Request کامل شد", "2025-09-29 09:06:51", "2025-09-29 09:06:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("8133", "2713", "عملیات توسط Async Request شروع شد", "2025-09-29 09:06:51", "2025-09-29 09:06:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("8134", "2713", "عملیات توسط Async Request کامل شد", "2025-09-29 09:06:51", "2025-09-29 09:06:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("8135", "2726", "ایجاد فعالیت", "2025-09-29 09:06:51", "2025-09-29 09:06:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("8136", "2714", "عملیات توسط Async Request شروع شد", "2025-09-29 09:06:51", "2025-09-29 09:06:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("8137", "2727", "ایجاد فعالیت", "2025-09-29 09:06:51", "2025-09-29 09:06:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("8138", "2714", "عملیات توسط Async Request کامل شد", "2025-09-29 09:06:51", "2025-09-29 09:06:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("8139", "2726", "عملیات توسط Async Request شروع شد", "2025-09-29 10:59:13", "2025-09-29 10:59:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("8140", "2726", "عملیات توسط Async Request کامل شد", "2025-09-29 10:59:13", "2025-09-29 10:59:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("8141", "2728", "ایجاد فعالیت", "2025-09-29 10:59:13", "2025-09-29 10:59:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("8142", "2727", "عملیات توسط Async Request شروع شد", "2025-09-29 10:59:13", "2025-09-29 10:59:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("8143", "2729", "ایجاد فعالیت", "2025-09-29 10:59:13", "2025-09-29 10:59:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("8144", "2727", "عملیات توسط Async Request کامل شد", "2025-09-29 10:59:13", "2025-09-29 10:59:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("8145", "2728", "عملیات توسط Async Request شروع شد", "2025-09-29 13:38:27", "2025-09-29 13:38:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8146", "2728", "عملیات توسط Async Request کامل شد", "2025-09-29 13:38:27", "2025-09-29 13:38:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8147", "2730", "ایجاد فعالیت", "2025-09-29 13:38:27", "2025-09-29 13:38:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8148", "2729", "عملیات توسط Async Request شروع شد", "2025-09-29 13:38:27", "2025-09-29 13:38:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8149", "2731", "ایجاد فعالیت", "2025-09-29 13:38:27", "2025-09-29 13:38:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8150", "2729", "عملیات توسط Async Request کامل شد", "2025-09-29 13:38:27", "2025-09-29 13:38:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8151", "2730", "عملیات توسط Async Request شروع شد", "2025-09-29 15:29:20", "2025-09-29 15:29:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("8152", "2730", "عملیات توسط Async Request کامل شد", "2025-09-29 15:29:20", "2025-09-29 15:29:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("8153", "2732", "ایجاد فعالیت", "2025-09-29 15:29:20", "2025-09-29 15:29:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("8154", "2731", "عملیات توسط Async Request شروع شد", "2025-09-29 15:29:20", "2025-09-29 15:29:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("8155", "2733", "ایجاد فعالیت", "2025-09-29 15:29:20", "2025-09-29 15:29:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("8156", "2731", "عملیات توسط Async Request کامل شد", "2025-09-29 15:29:20", "2025-09-29 15:29:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("8157", "2732", "عملیات توسط Async Request شروع شد", "2025-09-29 16:29:56", "2025-09-29 16:29:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("8158", "2732", "عملیات توسط Async Request کامل شد", "2025-09-29 16:29:56", "2025-09-29 16:29:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("8159", "2734", "ایجاد فعالیت", "2025-09-29 16:29:56", "2025-09-29 16:29:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("8160", "2733", "عملیات توسط Async Request شروع شد", "2025-09-29 16:29:56", "2025-09-29 16:29:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("8161", "2735", "ایجاد فعالیت", "2025-09-29 16:29:56", "2025-09-29 16:29:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("8162", "2733", "عملیات توسط Async Request کامل شد", "2025-09-29 16:29:56", "2025-09-29 16:29:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("8163", "2734", "عملیات توسط Async Request شروع شد", "2025-09-29 19:45:55", "2025-09-29 19:45:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("8164", "2734", "عملیات توسط Async Request کامل شد", "2025-09-29 19:45:55", "2025-09-29 19:45:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("8165", "2736", "ایجاد فعالیت", "2025-09-29 19:45:55", "2025-09-29 19:45:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("8166", "2735", "عملیات توسط Async Request شروع شد", "2025-09-29 19:45:55", "2025-09-29 19:45:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("8167", "2737", "ایجاد فعالیت", "2025-09-29 19:45:55", "2025-09-29 19:45:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("8168", "2735", "عملیات توسط Async Request کامل شد", "2025-09-29 19:45:55", "2025-09-29 19:45:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("8169", "2721", "عملیات توسط Async Request شروع شد", "2025-09-29 19:45:55", "2025-09-29 19:45:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("8170", "2721", "عملیات توسط Async Request کامل شد", "2025-09-29 19:45:55", "2025-09-29 19:45:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("8171", "2738", "ایجاد فعالیت", "2025-09-29 19:45:55", "2025-09-29 19:45:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("8172", "2722", "عملیات توسط Async Request شروع شد", "2025-09-29 19:45:55", "2025-09-29 19:45:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("8173", "2722", "عملیات توسط Async Request کامل شد", "2025-09-29 19:45:55", "2025-09-29 19:45:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("8174", "2739", "ایجاد فعالیت", "2025-09-29 19:45:55", "2025-09-29 19:45:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("8175", "2736", "عملیات توسط Async Request شروع شد", "2025-09-30 02:49:49", "2025-09-30 02:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("8176", "2736", "عملیات توسط Async Request کامل شد", "2025-09-30 02:49:49", "2025-09-30 02:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("8177", "2740", "ایجاد فعالیت", "2025-09-30 02:49:49", "2025-09-30 02:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("8178", "2737", "عملیات توسط Async Request شروع شد", "2025-09-30 02:49:49", "2025-09-30 02:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("8179", "2741", "ایجاد فعالیت", "2025-09-30 02:49:49", "2025-09-30 02:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("8180", "2737", "عملیات توسط Async Request کامل شد", "2025-09-30 02:49:49", "2025-09-30 02:49:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("8181", "2740", "عملیات توسط Async Request شروع شد", "2025-09-30 07:46:08", "2025-09-30 07:46:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("8182", "2740", "عملیات توسط Async Request کامل شد", "2025-09-30 07:46:08", "2025-09-30 07:46:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("8183", "2742", "ایجاد فعالیت", "2025-09-30 07:46:08", "2025-09-30 07:46:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("8184", "2741", "عملیات توسط Async Request شروع شد", "2025-09-30 07:46:08", "2025-09-30 07:46:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("8185", "2743", "ایجاد فعالیت", "2025-09-30 07:46:08", "2025-09-30 07:46:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("8186", "2741", "عملیات توسط Async Request کامل شد", "2025-09-30 07:46:08", "2025-09-30 07:46:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("8187", "2715", "عملیات توسط Async Request شروع شد", "2025-09-30 07:46:08", "2025-09-30 07:46:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("8188", "2715", "عملیات توسط Async Request کامل شد", "2025-09-30 07:46:08", "2025-09-30 07:46:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("8189", "2744", "ایجاد فعالیت", "2025-09-30 07:46:08", "2025-09-30 07:46:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("8190", "2716", "عملیات توسط Async Request شروع شد", "2025-09-30 07:46:08", "2025-09-30 07:46:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("8191", "2716", "عملیات توسط Async Request کامل شد", "2025-09-30 07:46:08", "2025-09-30 07:46:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("8192", "2745", "ایجاد فعالیت", "2025-09-30 07:46:08", "2025-09-30 07:46:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("8193", "2717", "عملیات توسط Async Request شروع شد", "2025-09-30 07:46:08", "2025-09-30 07:46:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("8194", "2717", "عملیات توسط Async Request کامل شد", "2025-09-30 07:46:10", "2025-09-30 07:46:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("8195", "2746", "ایجاد فعالیت", "2025-09-30 07:46:10", "2025-09-30 07:46:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("8196", "2718", "عملیات توسط Async Request شروع شد", "2025-09-30 07:46:10", "2025-09-30 07:46:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("8197", "2718", "عملیات توسط Async Request کامل شد", "2025-09-30 07:46:11", "2025-09-30 07:46:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("8198", "2747", "ایجاد فعالیت", "2025-09-30 07:46:11", "2025-09-30 07:46:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("8199", "2719", "عملیات توسط Async Request شروع شد", "2025-09-30 07:46:11", "2025-09-30 07:46:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("8200", "2719", "عملیات توسط Async Request کامل شد", "2025-09-30 07:46:11", "2025-09-30 07:46:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("8201", "2748", "ایجاد فعالیت", "2025-09-30 07:46:11", "2025-09-30 07:46:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("8202", "2720", "عملیات توسط Async Request شروع شد", "2025-09-30 07:46:11", "2025-09-30 07:46:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("8203", "2720", "عملیات توسط Async Request کامل شد", "2025-09-30 07:46:11", "2025-09-30 07:46:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("8204", "2749", "ایجاد فعالیت", "2025-09-30 07:46:11", "2025-09-30 07:46:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("8205", "2738", "عملیات توسط Async Request شروع شد", "2025-09-30 07:46:11", "2025-09-30 07:46:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("8206", "2738", "عملیات توسط Async Request کامل شد", "2025-09-30 07:46:11", "2025-09-30 07:46:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("8207", "2750", "ایجاد فعالیت", "2025-09-30 07:46:11", "2025-09-30 07:46:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("8208", "2739", "عملیات توسط Async Request شروع شد", "2025-09-30 07:46:11", "2025-09-30 07:46:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("8209", "2739", "عملیات توسط Async Request کامل شد", "2025-09-30 07:46:11", "2025-09-30 07:46:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("8210", "2751", "ایجاد فعالیت", "2025-09-30 07:46:11", "2025-09-30 07:46:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("8211", "2724", "عملیات توسط Async Request شروع شد", "2025-09-30 07:46:11", "2025-09-30 07:46:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("8212", "2752", "ایجاد فعالیت", "2025-09-30 07:46:11", "2025-09-30 07:46:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("8213", "2724", "عملیات توسط Async Request کامل شد", "2025-09-30 07:46:11", "2025-09-30 07:46:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("8214", "2753", "ایجاد فعالیت", "2025-09-30 07:46:11", "2025-09-30 07:46:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("8215", "2752", "عملیات توسط Async Request شروع شد", "2025-09-30 08:23:11", "2025-09-30 08:23:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("8216", "2752", "عملیات توسط Async Request کامل شد", "2025-09-30 08:23:11", "2025-09-30 08:23:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("8217", "2742", "عملیات توسط Async Request شروع شد", "2025-09-30 09:27:58", "2025-09-30 09:27:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("8218", "2742", "عملیات توسط Async Request کامل شد", "2025-09-30 09:27:58", "2025-09-30 09:27:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("8219", "2754", "ایجاد فعالیت", "2025-09-30 09:27:58", "2025-09-30 09:27:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("8220", "2743", "عملیات توسط Async Request شروع شد", "2025-09-30 09:27:58", "2025-09-30 09:27:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("8221", "2755", "ایجاد فعالیت", "2025-09-30 09:27:58", "2025-09-30 09:27:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("8222", "2743", "عملیات توسط Async Request کامل شد", "2025-09-30 09:27:58", "2025-09-30 09:27:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("8223", "2754", "عملیات توسط Async Request شروع شد", "2025-09-30 10:37:42", "2025-09-30 10:37:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("8224", "2754", "عملیات توسط Async Request کامل شد", "2025-09-30 10:37:42", "2025-09-30 10:37:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("8225", "2756", "ایجاد فعالیت", "2025-09-30 10:37:42", "2025-09-30 10:37:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("8226", "2755", "عملیات توسط Async Request شروع شد", "2025-09-30 10:37:42", "2025-09-30 10:37:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("8227", "2757", "ایجاد فعالیت", "2025-09-30 10:37:42", "2025-09-30 10:37:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("8228", "2755", "عملیات توسط Async Request کامل شد", "2025-09-30 10:37:42", "2025-09-30 10:37:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("8229", "2756", "عملیات توسط Async Request شروع شد", "2025-09-30 11:39:31", "2025-09-30 11:39:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("8230", "2756", "عملیات توسط Async Request کامل شد", "2025-09-30 11:39:31", "2025-09-30 11:39:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("8231", "2758", "ایجاد فعالیت", "2025-09-30 11:39:31", "2025-09-30 11:39:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("8232", "2757", "عملیات توسط Async Request شروع شد", "2025-09-30 11:39:31", "2025-09-30 11:39:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("8233", "2759", "ایجاد فعالیت", "2025-09-30 11:39:31", "2025-09-30 11:39:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("8234", "2757", "عملیات توسط Async Request کامل شد", "2025-09-30 11:39:31", "2025-09-30 11:39:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("8235", "2758", "عملیات توسط Async Request شروع شد", "2025-09-30 14:12:01", "2025-09-30 14:12:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("8236", "2758", "عملیات توسط Async Request کامل شد", "2025-09-30 14:12:01", "2025-09-30 14:12:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("8237", "2760", "ایجاد فعالیت", "2025-09-30 14:12:01", "2025-09-30 14:12:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("8238", "2759", "عملیات توسط Async Request شروع شد", "2025-09-30 14:12:01", "2025-09-30 14:12:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("8239", "2761", "ایجاد فعالیت", "2025-09-30 14:12:01", "2025-09-30 14:12:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("8240", "2759", "عملیات توسط Async Request کامل شد", "2025-09-30 14:12:01", "2025-09-30 14:12:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("8241", "2760", "عملیات توسط Async Request شروع شد", "2025-09-30 17:30:24", "2025-09-30 17:30:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8242", "2760", "عملیات توسط Async Request کامل شد", "2025-09-30 17:30:24", "2025-09-30 17:30:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8243", "2762", "ایجاد فعالیت", "2025-09-30 17:30:24", "2025-09-30 17:30:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8244", "2761", "عملیات توسط Async Request شروع شد", "2025-09-30 17:30:24", "2025-09-30 17:30:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8245", "2763", "ایجاد فعالیت", "2025-09-30 17:30:24", "2025-09-30 17:30:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8246", "2761", "عملیات توسط Async Request کامل شد", "2025-09-30 17:30:24", "2025-09-30 17:30:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8247", "2762", "عملیات توسط Async Request شروع شد", "2025-10-01 08:26:21", "2025-10-01 08:26:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("8248", "2762", "عملیات توسط Async Request کامل شد", "2025-10-01 08:26:21", "2025-10-01 08:26:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("8249", "2764", "ایجاد فعالیت", "2025-10-01 08:26:21", "2025-10-01 08:26:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("8250", "2763", "عملیات توسط Async Request شروع شد", "2025-10-01 08:26:21", "2025-10-01 08:26:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("8251", "2765", "ایجاد فعالیت", "2025-10-01 08:26:21", "2025-10-01 08:26:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("8252", "2763", "عملیات توسط Async Request کامل شد", "2025-10-01 08:26:21", "2025-10-01 08:26:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("8253", "2750", "عملیات توسط Async Request شروع شد", "2025-10-01 08:26:21", "2025-10-01 08:26:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("8254", "2750", "عملیات توسط Async Request کامل شد", "2025-10-01 08:26:21", "2025-10-01 08:26:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("8255", "2766", "ایجاد فعالیت", "2025-10-01 08:26:21", "2025-10-01 08:26:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("8256", "2751", "عملیات توسط Async Request شروع شد", "2025-10-01 08:26:21", "2025-10-01 08:26:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("8257", "2751", "عملیات توسط Async Request کامل شد", "2025-10-01 08:26:21", "2025-10-01 08:26:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("8258", "2767", "ایجاد فعالیت", "2025-10-01 08:26:21", "2025-10-01 08:26:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("8259", "2744", "عملیات توسط Async Request شروع شد", "2025-10-01 08:26:21", "2025-10-01 08:26:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("8260", "2744", "عملیات توسط Async Request کامل شد", "2025-10-01 08:26:21", "2025-10-01 08:26:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("8261", "2768", "ایجاد فعالیت", "2025-10-01 08:26:21", "2025-10-01 08:26:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("8262", "2745", "عملیات توسط Async Request شروع شد", "2025-10-01 08:26:21", "2025-10-01 08:26:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("8263", "2745", "عملیات توسط Async Request کامل شد", "2025-10-01 08:26:21", "2025-10-01 08:26:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("8264", "2769", "ایجاد فعالیت", "2025-10-01 08:26:21", "2025-10-01 08:26:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("8265", "2746", "عملیات توسط Async Request شروع شد", "2025-10-01 08:26:21", "2025-10-01 08:26:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("8266", "2746", "عملیات توسط Async Request کامل شد", "2025-10-01 08:26:23", "2025-10-01 08:26:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("8267", "2770", "ایجاد فعالیت", "2025-10-01 08:26:23", "2025-10-01 08:26:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("8268", "2747", "عملیات توسط Async Request شروع شد", "2025-10-01 08:26:23", "2025-10-01 08:26:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("8269", "2747", "عملیات توسط Async Request کامل شد", "2025-10-01 08:26:24", "2025-10-01 08:26:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8270", "2771", "ایجاد فعالیت", "2025-10-01 08:26:24", "2025-10-01 08:26:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8271", "2748", "عملیات توسط Async Request شروع شد", "2025-10-01 08:26:24", "2025-10-01 08:26:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8272", "2748", "عملیات توسط Async Request کامل شد", "2025-10-01 08:26:24", "2025-10-01 08:26:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8273", "2772", "ایجاد فعالیت", "2025-10-01 08:26:24", "2025-10-01 08:26:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8274", "2749", "عملیات توسط Async Request شروع شد", "2025-10-01 08:26:24", "2025-10-01 08:26:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8275", "2749", "عملیات توسط Async Request کامل شد", "2025-10-01 08:26:24", "2025-10-01 08:26:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8276", "2773", "ایجاد فعالیت", "2025-10-01 08:26:24", "2025-10-01 08:26:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8277", "2753", "عملیات توسط Async Request شروع شد", "2025-10-01 08:26:24", "2025-10-01 08:26:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8278", "2774", "ایجاد فعالیت", "2025-10-01 08:26:24", "2025-10-01 08:26:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8279", "2753", "عملیات توسط Async Request کامل شد", "2025-10-01 08:26:24", "2025-10-01 08:26:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8280", "2775", "ایجاد فعالیت", "2025-10-01 08:26:24", "2025-10-01 08:26:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("8281", "2774", "عملیات توسط Async Request شروع شد", "2025-10-01 08:27:36", "2025-10-01 08:27:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("8282", "2774", "عملیات توسط Async Request کامل شد", "2025-10-01 08:27:36", "2025-10-01 08:27:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("8283", "2764", "عملیات توسط Async Request شروع شد", "2025-10-02 00:27:56", "2025-10-02 00:27:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("8284", "2764", "عملیات توسط Async Request کامل شد", "2025-10-02 00:27:56", "2025-10-02 00:27:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("8285", "2776", "ایجاد فعالیت", "2025-10-02 00:27:56", "2025-10-02 00:27:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("8286", "2765", "عملیات توسط Async Request شروع شد", "2025-10-02 00:27:56", "2025-10-02 00:27:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("8287", "2777", "ایجاد فعالیت", "2025-10-02 00:27:56", "2025-10-02 00:27:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("8288", "2765", "عملیات توسط Async Request کامل شد", "2025-10-02 00:27:56", "2025-10-02 00:27:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("8289", "2766", "عملیات توسط Async Request شروع شد", "2025-10-02 00:27:56", "2025-10-02 00:27:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("8290", "2766", "عملیات توسط Async Request کامل شد", "2025-10-02 00:27:56", "2025-10-02 00:27:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("8291", "2778", "ایجاد فعالیت", "2025-10-02 00:27:56", "2025-10-02 00:27:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("8292", "2767", "عملیات توسط Async Request شروع شد", "2025-10-02 00:27:56", "2025-10-02 00:27:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("8293", "2767", "عملیات توسط Async Request کامل شد", "2025-10-02 00:27:56", "2025-10-02 00:27:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("8294", "2779", "ایجاد فعالیت", "2025-10-02 00:27:56", "2025-10-02 00:27:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("8295", "2776", "عملیات توسط Async Request شروع شد", "2025-10-02 06:19:20", "2025-10-02 06:19:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("8296", "2776", "عملیات توسط Async Request کامل شد", "2025-10-02 06:19:20", "2025-10-02 06:19:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("8297", "2780", "ایجاد فعالیت", "2025-10-02 06:19:20", "2025-10-02 06:19:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("8298", "2777", "عملیات توسط Async Request شروع شد", "2025-10-02 06:19:20", "2025-10-02 06:19:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("8299", "2781", "ایجاد فعالیت", "2025-10-02 06:19:20", "2025-10-02 06:19:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("8300", "2777", "عملیات توسط Async Request کامل شد", "2025-10-02 06:19:20", "2025-10-02 06:19:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("8301", "2780", "عملیات توسط Async Request شروع شد", "2025-10-02 07:48:16", "2025-10-02 07:48:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("8302", "2780", "عملیات توسط Async Request کامل شد", "2025-10-02 07:48:16", "2025-10-02 07:48:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("8303", "2782", "ایجاد فعالیت", "2025-10-02 07:48:16", "2025-10-02 07:48:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("8304", "2781", "عملیات توسط Async Request شروع شد", "2025-10-02 07:48:16", "2025-10-02 07:48:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("8305", "2783", "ایجاد فعالیت", "2025-10-02 07:48:16", "2025-10-02 07:48:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("8306", "2781", "عملیات توسط Async Request کامل شد", "2025-10-02 07:48:16", "2025-10-02 07:48:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("8307", "2768", "عملیات توسط Async Request شروع شد", "2025-10-02 12:31:12", "2025-10-02 12:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("8308", "2768", "عملیات توسط Async Request کامل شد", "2025-10-02 12:31:12", "2025-10-02 12:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("8309", "2784", "ایجاد فعالیت", "2025-10-02 12:31:12", "2025-10-02 12:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("8310", "2769", "عملیات توسط Async Request شروع شد", "2025-10-02 12:31:12", "2025-10-02 12:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("8311", "2769", "عملیات توسط Async Request کامل شد", "2025-10-02 12:31:12", "2025-10-02 12:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("8312", "2785", "ایجاد فعالیت", "2025-10-02 12:31:12", "2025-10-02 12:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("8313", "2770", "عملیات توسط Async Request شروع شد", "2025-10-02 12:31:12", "2025-10-02 12:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("8314", "2770", "عملیات توسط Async Request کامل شد", "2025-10-02 12:31:14", "2025-10-02 12:31:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("8315", "2786", "ایجاد فعالیت", "2025-10-02 12:31:14", "2025-10-02 12:31:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("8316", "2771", "عملیات توسط Async Request شروع شد", "2025-10-02 12:31:14", "2025-10-02 12:31:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("8317", "2771", "عملیات توسط Async Request کامل شد", "2025-10-02 12:31:16", "2025-10-02 12:31:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("8318", "2787", "ایجاد فعالیت", "2025-10-02 12:31:16", "2025-10-02 12:31:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("8319", "2772", "عملیات توسط Async Request شروع شد", "2025-10-02 12:31:16", "2025-10-02 12:31:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("8320", "2772", "عملیات توسط Async Request کامل شد", "2025-10-02 12:31:16", "2025-10-02 12:31:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("8321", "2788", "ایجاد فعالیت", "2025-10-02 12:31:16", "2025-10-02 12:31:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("8322", "2773", "عملیات توسط Async Request شروع شد", "2025-10-02 12:31:16", "2025-10-02 12:31:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("8323", "2773", "عملیات توسط Async Request کامل شد", "2025-10-02 12:31:16", "2025-10-02 12:31:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("8324", "2789", "ایجاد فعالیت", "2025-10-02 12:31:16", "2025-10-02 12:31:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("8325", "2782", "عملیات توسط Async Request شروع شد", "2025-10-02 12:31:16", "2025-10-02 12:31:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("8326", "2782", "عملیات توسط Async Request کامل شد", "2025-10-02 12:31:16", "2025-10-02 12:31:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("8327", "2790", "ایجاد فعالیت", "2025-10-02 12:31:16", "2025-10-02 12:31:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("8328", "2783", "عملیات توسط Async Request شروع شد", "2025-10-02 12:31:16", "2025-10-02 12:31:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("8329", "2791", "ایجاد فعالیت", "2025-10-02 12:31:16", "2025-10-02 12:31:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("8330", "2783", "عملیات توسط Async Request کامل شد", "2025-10-02 12:31:16", "2025-10-02 12:31:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("8331", "2778", "عملیات توسط Async Request شروع شد", "2025-10-02 12:31:16", "2025-10-02 12:31:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("8332", "2778", "عملیات توسط Async Request کامل شد", "2025-10-02 12:31:16", "2025-10-02 12:31:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("8333", "2792", "ایجاد فعالیت", "2025-10-02 12:31:16", "2025-10-02 12:31:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("8334", "2779", "عملیات توسط Async Request شروع شد", "2025-10-02 12:31:16", "2025-10-02 12:31:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("8335", "2779", "عملیات توسط Async Request کامل شد", "2025-10-02 12:31:16", "2025-10-02 12:31:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("8336", "2793", "ایجاد فعالیت", "2025-10-02 12:31:16", "2025-10-02 12:31:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("8337", "2775", "عملیات توسط Async Request شروع شد", "2025-10-02 12:31:16", "2025-10-02 12:31:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("8338", "2794", "ایجاد فعالیت", "2025-10-02 12:31:16", "2025-10-02 12:31:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("8339", "2775", "عملیات توسط Async Request کامل شد", "2025-10-02 12:31:16", "2025-10-02 12:31:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("8340", "2795", "ایجاد فعالیت", "2025-10-02 12:31:16", "2025-10-02 12:31:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("8341", "2794", "عملیات توسط Async Request شروع شد", "2025-10-02 13:44:33", "2025-10-02 13:44:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8342", "2794", "عملیات توسط Async Request کامل شد", "2025-10-02 13:44:33", "2025-10-02 13:44:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8343", "2790", "عملیات توسط Async Request شروع شد", "2025-10-02 13:44:33", "2025-10-02 13:44:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8344", "2790", "عملیات توسط Async Request کامل شد", "2025-10-02 13:44:33", "2025-10-02 13:44:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8345", "2796", "ایجاد فعالیت", "2025-10-02 13:44:33", "2025-10-02 13:44:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8346", "2791", "عملیات توسط Async Request شروع شد", "2025-10-02 13:44:33", "2025-10-02 13:44:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8347", "2797", "ایجاد فعالیت", "2025-10-02 13:44:33", "2025-10-02 13:44:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8348", "2791", "عملیات توسط Async Request کامل شد", "2025-10-02 13:44:33", "2025-10-02 13:44:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8349", "2796", "عملیات توسط Async Request شروع شد", "2025-10-04 06:43:14", "2025-10-04 06:43:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("8350", "2796", "عملیات توسط Async Request کامل شد", "2025-10-04 06:43:14", "2025-10-04 06:43:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("8351", "2798", "ایجاد فعالیت", "2025-10-04 06:43:14", "2025-10-04 06:43:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("8352", "2797", "عملیات توسط Async Request شروع شد", "2025-10-04 06:43:14", "2025-10-04 06:43:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("8353", "2799", "ایجاد فعالیت", "2025-10-04 06:43:14", "2025-10-04 06:43:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("8354", "2797", "عملیات توسط Async Request کامل شد", "2025-10-04 06:43:14", "2025-10-04 06:43:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("8355", "2792", "عملیات توسط Async Request شروع شد", "2025-10-04 06:43:14", "2025-10-04 06:43:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("8356", "2792", "عملیات توسط Async Request کامل شد", "2025-10-04 06:43:14", "2025-10-04 06:43:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("8357", "2800", "ایجاد فعالیت", "2025-10-04 06:43:14", "2025-10-04 06:43:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("8358", "2793", "عملیات توسط Async Request شروع شد", "2025-10-04 06:43:14", "2025-10-04 06:43:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("8359", "2793", "عملیات توسط Async Request کامل شد", "2025-10-04 06:43:14", "2025-10-04 06:43:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("8360", "2801", "ایجاد فعالیت", "2025-10-04 06:43:14", "2025-10-04 06:43:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("8361", "2784", "عملیات توسط Async Request شروع شد", "2025-10-04 06:43:14", "2025-10-04 06:43:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("8362", "2784", "عملیات توسط Async Request کامل شد", "2025-10-04 06:43:14", "2025-10-04 06:43:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("8363", "2802", "ایجاد فعالیت", "2025-10-04 06:43:14", "2025-10-04 06:43:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("8364", "2785", "عملیات توسط Async Request شروع شد", "2025-10-04 06:43:14", "2025-10-04 06:43:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("8365", "2785", "عملیات توسط Async Request کامل شد", "2025-10-04 06:43:14", "2025-10-04 06:43:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("8366", "2803", "ایجاد فعالیت", "2025-10-04 06:43:14", "2025-10-04 06:43:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("8367", "2786", "عملیات توسط Async Request شروع شد", "2025-10-04 06:43:14", "2025-10-04 06:43:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("8368", "2786", "عملیات توسط Async Request کامل شد", "2025-10-04 06:43:16", "2025-10-04 06:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("8369", "2804", "ایجاد فعالیت", "2025-10-04 06:43:16", "2025-10-04 06:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("8370", "2787", "عملیات توسط Async Request شروع شد", "2025-10-04 06:43:16", "2025-10-04 06:43:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("8371", "2787", "عملیات توسط Async Request کامل شد", "2025-10-04 06:43:17", "2025-10-04 06:43:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("8372", "2805", "ایجاد فعالیت", "2025-10-04 06:43:17", "2025-10-04 06:43:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("8373", "2788", "عملیات توسط Async Request شروع شد", "2025-10-04 06:43:17", "2025-10-04 06:43:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("8374", "2788", "عملیات توسط Async Request کامل شد", "2025-10-04 06:43:17", "2025-10-04 06:43:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("8375", "2806", "ایجاد فعالیت", "2025-10-04 06:43:17", "2025-10-04 06:43:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("8376", "2789", "عملیات توسط Async Request شروع شد", "2025-10-04 06:43:17", "2025-10-04 06:43:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("8377", "2789", "عملیات توسط Async Request کامل شد", "2025-10-04 06:43:17", "2025-10-04 06:43:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("8378", "2807", "ایجاد فعالیت", "2025-10-04 06:43:17", "2025-10-04 06:43:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("8379", "2795", "عملیات توسط Async Request شروع شد", "2025-10-04 06:43:17", "2025-10-04 06:43:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("8380", "2808", "ایجاد فعالیت", "2025-10-04 06:43:17", "2025-10-04 06:43:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("8381", "2795", "عملیات توسط Async Request کامل شد", "2025-10-04 06:43:17", "2025-10-04 06:43:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("8382", "2809", "ایجاد فعالیت", "2025-10-04 06:43:17", "2025-10-04 06:43:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("8383", "2808", "عملیات توسط Async Request شروع شد", "2025-10-04 06:47:20", "2025-10-04 06:47:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("8384", "2808", "عملیات توسط Async Request کامل شد", "2025-10-04 06:47:20", "2025-10-04 06:47:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("8385", "2798", "عملیات توسط Async Request شروع شد", "2025-10-04 08:51:59", "2025-10-04 08:51:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8386", "2798", "عملیات توسط Async Request کامل شد", "2025-10-04 08:51:59", "2025-10-04 08:51:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8387", "2810", "ایجاد فعالیت", "2025-10-04 08:51:59", "2025-10-04 08:51:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8388", "2799", "عملیات توسط Async Request شروع شد", "2025-10-04 08:51:59", "2025-10-04 08:51:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8389", "2811", "ایجاد فعالیت", "2025-10-04 08:51:59", "2025-10-04 08:51:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8390", "2799", "عملیات توسط Async Request کامل شد", "2025-10-04 08:51:59", "2025-10-04 08:51:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8391", "2810", "عملیات توسط Async Request شروع شد", "2025-10-04 10:38:57", "2025-10-04 10:38:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("8392", "2810", "عملیات توسط Async Request کامل شد", "2025-10-04 10:38:57", "2025-10-04 10:38:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("8393", "2812", "ایجاد فعالیت", "2025-10-04 10:38:57", "2025-10-04 10:38:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("8394", "2811", "عملیات توسط Async Request شروع شد", "2025-10-04 10:38:57", "2025-10-04 10:38:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("8395", "2813", "ایجاد فعالیت", "2025-10-04 10:38:57", "2025-10-04 10:38:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("8396", "2811", "عملیات توسط Async Request کامل شد", "2025-10-04 10:38:57", "2025-10-04 10:38:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("8397", "2812", "عملیات توسط Async Request شروع شد", "2025-10-04 11:53:09", "2025-10-04 11:53:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("8398", "2812", "عملیات توسط Async Request کامل شد", "2025-10-04 11:53:09", "2025-10-04 11:53:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("8399", "2814", "ایجاد فعالیت", "2025-10-04 11:53:09", "2025-10-04 11:53:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("8400", "2813", "عملیات توسط Async Request شروع شد", "2025-10-04 11:53:09", "2025-10-04 11:53:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("8401", "2815", "ایجاد فعالیت", "2025-10-04 11:53:09", "2025-10-04 11:53:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("8402", "2813", "عملیات توسط Async Request کامل شد", "2025-10-04 11:53:09", "2025-10-04 11:53:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("8403", "2814", "عملیات توسط Async Request شروع شد", "2025-10-04 14:33:39", "2025-10-04 14:33:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("8404", "2814", "عملیات توسط Async Request کامل شد", "2025-10-04 14:33:39", "2025-10-04 14:33:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("8405", "2816", "ایجاد فعالیت", "2025-10-04 14:33:39", "2025-10-04 14:33:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("8406", "2815", "عملیات توسط Async Request شروع شد", "2025-10-04 14:33:39", "2025-10-04 14:33:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("8407", "2817", "ایجاد فعالیت", "2025-10-04 14:33:39", "2025-10-04 14:33:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("8408", "2815", "عملیات توسط Async Request کامل شد", "2025-10-04 14:33:39", "2025-10-04 14:33:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("8409", "2816", "عملیات توسط Async Request شروع شد", "2025-10-04 15:35:10", "2025-10-04 15:35:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("8410", "2816", "عملیات توسط Async Request کامل شد", "2025-10-04 15:35:10", "2025-10-04 15:35:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("8411", "2818", "ایجاد فعالیت", "2025-10-04 15:35:10", "2025-10-04 15:35:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("8412", "2817", "عملیات توسط Async Request شروع شد", "2025-10-04 15:35:10", "2025-10-04 15:35:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("8413", "2819", "ایجاد فعالیت", "2025-10-04 15:35:10", "2025-10-04 15:35:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("8414", "2817", "عملیات توسط Async Request کامل شد", "2025-10-04 15:35:10", "2025-10-04 15:35:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("8415", "2818", "عملیات توسط Async Request شروع شد", "2025-10-04 19:54:20", "2025-10-04 19:54:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("8416", "2818", "عملیات توسط Async Request کامل شد", "2025-10-04 19:54:20", "2025-10-04 19:54:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("8417", "2820", "ایجاد فعالیت", "2025-10-04 19:54:20", "2025-10-04 19:54:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("8418", "2819", "عملیات توسط Async Request شروع شد", "2025-10-04 19:54:20", "2025-10-04 19:54:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("8419", "2821", "ایجاد فعالیت", "2025-10-04 19:54:20", "2025-10-04 19:54:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("8420", "2819", "عملیات توسط Async Request کامل شد", "2025-10-04 19:54:20", "2025-10-04 19:54:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("8421", "2800", "عملیات توسط Async Request شروع شد", "2025-10-04 19:54:20", "2025-10-04 19:54:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("8422", "2800", "عملیات توسط Async Request کامل شد", "2025-10-04 19:54:20", "2025-10-04 19:54:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("8423", "2822", "ایجاد فعالیت", "2025-10-04 19:54:20", "2025-10-04 19:54:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("8424", "2801", "عملیات توسط Async Request شروع شد", "2025-10-04 19:54:20", "2025-10-04 19:54:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("8425", "2801", "عملیات توسط Async Request کامل شد", "2025-10-04 19:54:20", "2025-10-04 19:54:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("8426", "2823", "ایجاد فعالیت", "2025-10-04 19:54:20", "2025-10-04 19:54:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("8427", "2820", "عملیات توسط Async Request شروع شد", "2025-10-04 21:29:23", "2025-10-04 21:29:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("8428", "2820", "عملیات توسط Async Request کامل شد", "2025-10-04 21:29:23", "2025-10-04 21:29:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("8429", "2824", "ایجاد فعالیت", "2025-10-04 21:29:23", "2025-10-04 21:29:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("8430", "2821", "عملیات توسط Async Request شروع شد", "2025-10-04 21:29:23", "2025-10-04 21:29:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("8431", "2825", "ایجاد فعالیت", "2025-10-04 21:29:23", "2025-10-04 21:29:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("8432", "2821", "عملیات توسط Async Request کامل شد", "2025-10-04 21:29:23", "2025-10-04 21:29:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("8433", "2824", "عملیات توسط Async Request شروع شد", "2025-10-05 02:48:47", "2025-10-05 02:48:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("8434", "2824", "عملیات توسط Async Request کامل شد", "2025-10-05 02:48:47", "2025-10-05 02:48:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("8435", "2826", "ایجاد فعالیت", "2025-10-05 02:48:47", "2025-10-05 02:48:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("8436", "2825", "عملیات توسط Async Request شروع شد", "2025-10-05 02:48:47", "2025-10-05 02:48:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("8437", "2827", "ایجاد فعالیت", "2025-10-05 02:48:47", "2025-10-05 02:48:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("8438", "2825", "عملیات توسط Async Request کامل شد", "2025-10-05 02:48:47", "2025-10-05 02:48:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("8439", "2826", "عملیات توسط Async Request شروع شد", "2025-10-05 07:49:36", "2025-10-05 07:49:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("8440", "2826", "عملیات توسط Async Request کامل شد", "2025-10-05 07:49:36", "2025-10-05 07:49:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("8441", "2828", "ایجاد فعالیت", "2025-10-05 07:49:36", "2025-10-05 07:49:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("8442", "2827", "عملیات توسط Async Request شروع شد", "2025-10-05 07:49:36", "2025-10-05 07:49:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("8443", "2829", "ایجاد فعالیت", "2025-10-05 07:49:36", "2025-10-05 07:49:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("8444", "2827", "عملیات توسط Async Request کامل شد", "2025-10-05 07:49:36", "2025-10-05 07:49:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("8445", "2802", "عملیات توسط Async Request شروع شد", "2025-10-05 07:49:36", "2025-10-05 07:49:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("8446", "2802", "عملیات توسط Async Request کامل شد", "2025-10-05 07:49:36", "2025-10-05 07:49:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("8447", "2830", "ایجاد فعالیت", "2025-10-05 07:49:36", "2025-10-05 07:49:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("8448", "2803", "عملیات توسط Async Request شروع شد", "2025-10-05 07:49:36", "2025-10-05 07:49:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("8449", "2803", "عملیات توسط Async Request کامل شد", "2025-10-05 07:49:36", "2025-10-05 07:49:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("8450", "2831", "ایجاد فعالیت", "2025-10-05 07:49:36", "2025-10-05 07:49:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("8451", "2804", "عملیات توسط Async Request شروع شد", "2025-10-05 07:49:36", "2025-10-05 07:49:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("8452", "2804", "عملیات توسط Async Request کامل شد", "2025-10-05 07:49:38", "2025-10-05 07:49:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("8453", "2832", "ایجاد فعالیت", "2025-10-05 07:49:38", "2025-10-05 07:49:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("8454", "2805", "عملیات توسط Async Request شروع شد", "2025-10-05 07:49:38", "2025-10-05 07:49:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("8455", "2805", "عملیات توسط Async Request کامل شد", "2025-10-05 07:49:39", "2025-10-05 07:49:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("8456", "2833", "ایجاد فعالیت", "2025-10-05 07:49:39", "2025-10-05 07:49:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("8457", "2806", "عملیات توسط Async Request شروع شد", "2025-10-05 07:49:39", "2025-10-05 07:49:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("8458", "2806", "عملیات توسط Async Request کامل شد", "2025-10-05 07:49:39", "2025-10-05 07:49:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("8459", "2834", "ایجاد فعالیت", "2025-10-05 07:49:39", "2025-10-05 07:49:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("8460", "2807", "عملیات توسط Async Request شروع شد", "2025-10-05 07:49:39", "2025-10-05 07:49:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("8461", "2807", "عملیات توسط Async Request کامل شد", "2025-10-05 07:49:39", "2025-10-05 07:49:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("8462", "2835", "ایجاد فعالیت", "2025-10-05 07:49:39", "2025-10-05 07:49:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("8463", "2809", "عملیات توسط Async Request شروع شد", "2025-10-05 07:49:39", "2025-10-05 07:49:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("8464", "2836", "ایجاد فعالیت", "2025-10-05 07:49:39", "2025-10-05 07:49:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("8465", "2809", "عملیات توسط Async Request کامل شد", "2025-10-05 07:49:39", "2025-10-05 07:49:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("8466", "2837", "ایجاد فعالیت", "2025-10-05 07:49:39", "2025-10-05 07:49:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("8467", "2836", "عملیات توسط Async Request شروع شد", "2025-10-05 07:51:37", "2025-10-05 07:51:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("8468", "2836", "عملیات توسط Async Request کامل شد", "2025-10-05 07:51:37", "2025-10-05 07:51:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("8469", "2838", "ایجاد فعالیت", "2025-10-05 07:55:12", "2025-10-05 07:55:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("8470", "2822", "عملیات توسط Async Request شروع شد", "2025-10-05 08:59:33", "2025-10-05 08:59:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8471", "2822", "عملیات توسط Async Request کامل شد", "2025-10-05 08:59:33", "2025-10-05 08:59:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8472", "2839", "ایجاد فعالیت", "2025-10-05 08:59:33", "2025-10-05 08:59:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8473", "2823", "عملیات توسط Async Request شروع شد", "2025-10-05 08:59:33", "2025-10-05 08:59:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8474", "2823", "عملیات توسط Async Request کامل شد", "2025-10-05 08:59:33", "2025-10-05 08:59:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8475", "2840", "ایجاد فعالیت", "2025-10-05 08:59:33", "2025-10-05 08:59:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8476", "2838", "عملیات توسط Async Request شروع شد", "2025-10-05 08:59:33", "2025-10-05 08:59:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8477", "2838", "عملیات توسط Async Request کامل شد", "2025-10-05 08:59:33", "2025-10-05 08:59:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8478", "2828", "عملیات توسط Async Request شروع شد", "2025-10-05 08:59:33", "2025-10-05 08:59:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8479", "2828", "عملیات توسط Async Request کامل شد", "2025-10-05 08:59:33", "2025-10-05 08:59:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8480", "2841", "ایجاد فعالیت", "2025-10-05 08:59:33", "2025-10-05 08:59:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8481", "2829", "عملیات توسط Async Request شروع شد", "2025-10-05 08:59:33", "2025-10-05 08:59:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8482", "2842", "ایجاد فعالیت", "2025-10-05 08:59:33", "2025-10-05 08:59:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8483", "2829", "عملیات توسط Async Request کامل شد", "2025-10-05 08:59:33", "2025-10-05 08:59:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8484", "2539", "عملیات توسط Async Request شروع شد", "2025-10-05 14:47:44", "2025-10-05 14:47:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("8485", "2539", "عملیات توسط Async Request کامل شد", "2025-10-05 14:47:44", "2025-10-05 14:47:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("8486", "2843", "ایجاد فعالیت", "2025-10-05 14:47:44", "2025-10-05 14:47:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("8487", "2841", "عملیات توسط Async Request شروع شد", "2025-10-05 14:47:44", "2025-10-05 14:47:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("8488", "2841", "عملیات توسط Async Request کامل شد", "2025-10-05 14:47:44", "2025-10-05 14:47:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("8489", "2844", "ایجاد فعالیت", "2025-10-05 14:47:44", "2025-10-05 14:47:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("8490", "2842", "عملیات توسط Async Request شروع شد", "2025-10-05 14:47:44", "2025-10-05 14:47:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("8491", "2845", "ایجاد فعالیت", "2025-10-05 14:47:44", "2025-10-05 14:47:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("8492", "2842", "عملیات توسط Async Request کامل شد", "2025-10-05 14:47:44", "2025-10-05 14:47:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("8493", "2844", "عملیات توسط Async Request شروع شد", "2025-10-05 16:25:42", "2025-10-05 16:25:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("8494", "2844", "عملیات توسط Async Request کامل شد", "2025-10-05 16:25:42", "2025-10-05 16:25:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("8495", "2846", "ایجاد فعالیت", "2025-10-05 16:25:42", "2025-10-05 16:25:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("8496", "2845", "عملیات توسط Async Request شروع شد", "2025-10-05 16:25:42", "2025-10-05 16:25:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("8497", "2847", "ایجاد فعالیت", "2025-10-05 16:25:42", "2025-10-05 16:25:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("8498", "2845", "عملیات توسط Async Request کامل شد", "2025-10-05 16:25:42", "2025-10-05 16:25:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("8499", "2846", "عملیات توسط Async Request شروع شد", "2025-10-05 19:13:33", "2025-10-05 19:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8500", "2846", "عملیات توسط Async Request کامل شد", "2025-10-05 19:13:33", "2025-10-05 19:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8501", "2848", "ایجاد فعالیت", "2025-10-05 19:13:33", "2025-10-05 19:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8502", "2847", "عملیات توسط Async Request شروع شد", "2025-10-05 19:13:33", "2025-10-05 19:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8503", "2849", "ایجاد فعالیت", "2025-10-05 19:13:33", "2025-10-05 19:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8504", "2847", "عملیات توسط Async Request کامل شد", "2025-10-05 19:13:33", "2025-10-05 19:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8505", "2848", "عملیات توسط Async Request شروع شد", "2025-10-05 21:35:59", "2025-10-05 21:35:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8506", "2848", "عملیات توسط Async Request کامل شد", "2025-10-05 21:35:59", "2025-10-05 21:35:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8507", "2850", "ایجاد فعالیت", "2025-10-05 21:35:59", "2025-10-05 21:35:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8508", "2849", "عملیات توسط Async Request شروع شد", "2025-10-05 21:35:59", "2025-10-05 21:35:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8509", "2851", "ایجاد فعالیت", "2025-10-05 21:35:59", "2025-10-05 21:35:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8510", "2849", "عملیات توسط Async Request کامل شد", "2025-10-05 21:35:59", "2025-10-05 21:35:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8511", "2839", "عملیات توسط Async Request شروع شد", "2025-10-05 21:35:59", "2025-10-05 21:35:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8512", "2839", "عملیات توسط Async Request کامل شد", "2025-10-05 21:35:59", "2025-10-05 21:35:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8513", "2852", "ایجاد فعالیت", "2025-10-05 21:35:59", "2025-10-05 21:35:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8514", "2840", "عملیات توسط Async Request شروع شد", "2025-10-05 21:35:59", "2025-10-05 21:35:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8515", "2840", "عملیات توسط Async Request کامل شد", "2025-10-05 21:35:59", "2025-10-05 21:35:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8516", "2853", "ایجاد فعالیت", "2025-10-05 21:35:59", "2025-10-05 21:35:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8517", "2850", "عملیات توسط Async Request شروع شد", "2025-10-06 02:31:28", "2025-10-06 02:31:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("8518", "2850", "عملیات توسط Async Request کامل شد", "2025-10-06 02:31:28", "2025-10-06 02:31:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("8519", "2854", "ایجاد فعالیت", "2025-10-06 02:31:28", "2025-10-06 02:31:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("8520", "2851", "عملیات توسط Async Request شروع شد", "2025-10-06 02:31:28", "2025-10-06 02:31:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("8521", "2855", "ایجاد فعالیت", "2025-10-06 02:31:28", "2025-10-06 02:31:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("8522", "2851", "عملیات توسط Async Request کامل شد", "2025-10-06 02:31:28", "2025-10-06 02:31:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("8523", "2854", "عملیات توسط Async Request شروع شد", "2025-10-06 06:43:27", "2025-10-06 06:43:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8524", "2854", "عملیات توسط Async Request کامل شد", "2025-10-06 06:43:27", "2025-10-06 06:43:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8525", "2856", "ایجاد فعالیت", "2025-10-06 06:43:27", "2025-10-06 06:43:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8526", "2855", "عملیات توسط Async Request شروع شد", "2025-10-06 06:43:27", "2025-10-06 06:43:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8527", "2857", "ایجاد فعالیت", "2025-10-06 06:43:27", "2025-10-06 06:43:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8528", "2855", "عملیات توسط Async Request کامل شد", "2025-10-06 06:43:27", "2025-10-06 06:43:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8529", "2856", "عملیات توسط Async Request شروع شد", "2025-10-06 11:30:23", "2025-10-06 11:30:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("8530", "2856", "عملیات توسط Async Request کامل شد", "2025-10-06 11:30:23", "2025-10-06 11:30:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("8531", "2858", "ایجاد فعالیت", "2025-10-06 11:30:23", "2025-10-06 11:30:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("8532", "2857", "عملیات توسط Async Request شروع شد", "2025-10-06 11:30:23", "2025-10-06 11:30:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("8533", "2859", "ایجاد فعالیت", "2025-10-06 11:30:23", "2025-10-06 11:30:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("8534", "2857", "عملیات توسط Async Request کامل شد", "2025-10-06 11:30:23", "2025-10-06 11:30:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("8535", "2830", "عملیات توسط Async Request شروع شد", "2025-10-06 11:30:23", "2025-10-06 11:30:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("8536", "2830", "عملیات توسط Async Request کامل شد", "2025-10-06 11:30:23", "2025-10-06 11:30:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("8537", "2860", "ایجاد فعالیت", "2025-10-06 11:30:23", "2025-10-06 11:30:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("8538", "2831", "عملیات توسط Async Request شروع شد", "2025-10-06 11:30:23", "2025-10-06 11:30:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("8539", "2831", "عملیات توسط Async Request کامل شد", "2025-10-06 11:30:23", "2025-10-06 11:30:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("8540", "2861", "ایجاد فعالیت", "2025-10-06 11:30:23", "2025-10-06 11:30:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("8541", "2832", "عملیات توسط Async Request شروع شد", "2025-10-06 11:30:23", "2025-10-06 11:30:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("8542", "2832", "عملیات توسط Async Request کامل شد", "2025-10-06 11:30:25", "2025-10-06 11:30:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("8543", "2862", "ایجاد فعالیت", "2025-10-06 11:30:25", "2025-10-06 11:30:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("8544", "2833", "عملیات توسط Async Request شروع شد", "2025-10-06 11:30:25", "2025-10-06 11:30:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("8545", "2833", "عملیات توسط Async Request کامل شد", "2025-10-06 11:30:26", "2025-10-06 11:30:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("8546", "2863", "ایجاد فعالیت", "2025-10-06 11:30:26", "2025-10-06 11:30:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("8547", "2834", "عملیات توسط Async Request شروع شد", "2025-10-06 11:30:26", "2025-10-06 11:30:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("8548", "2834", "عملیات توسط Async Request کامل شد", "2025-10-06 11:30:26", "2025-10-06 11:30:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("8549", "2864", "ایجاد فعالیت", "2025-10-06 11:30:26", "2025-10-06 11:30:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("8550", "2835", "عملیات توسط Async Request شروع شد", "2025-10-06 11:30:26", "2025-10-06 11:30:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("8551", "2835", "عملیات توسط Async Request کامل شد", "2025-10-06 11:30:26", "2025-10-06 11:30:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("8552", "2865", "ایجاد فعالیت", "2025-10-06 11:30:26", "2025-10-06 11:30:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("8553", "2852", "عملیات توسط Async Request شروع شد", "2025-10-06 11:30:26", "2025-10-06 11:30:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("8554", "2852", "عملیات توسط Async Request کامل شد", "2025-10-06 11:30:26", "2025-10-06 11:30:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("8555", "2866", "ایجاد فعالیت", "2025-10-06 11:30:26", "2025-10-06 11:30:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("8556", "2853", "عملیات توسط Async Request شروع شد", "2025-10-06 11:30:26", "2025-10-06 11:30:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("8557", "2853", "عملیات توسط Async Request کامل شد", "2025-10-06 11:30:26", "2025-10-06 11:30:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("8558", "2867", "ایجاد فعالیت", "2025-10-06 11:30:26", "2025-10-06 11:30:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("8559", "2837", "عملیات توسط Async Request شروع شد", "2025-10-06 11:30:26", "2025-10-06 11:30:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("8560", "2868", "ایجاد فعالیت", "2025-10-06 11:30:26", "2025-10-06 11:30:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("8561", "2837", "عملیات توسط Async Request کامل شد", "2025-10-06 11:30:26", "2025-10-06 11:30:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("8562", "2869", "ایجاد فعالیت", "2025-10-06 11:30:26", "2025-10-06 11:30:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("8563", "2868", "عملیات توسط Async Request شروع شد", "2025-10-06 11:45:58", "2025-10-06 11:45:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("8564", "2868", "عملیات توسط Async Request کامل شد", "2025-10-06 11:45:58", "2025-10-06 11:45:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("8565", "2858", "عملیات توسط Async Request شروع شد", "2025-10-06 13:13:04", "2025-10-06 13:13:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("8566", "2858", "عملیات توسط Async Request کامل شد", "2025-10-06 13:13:04", "2025-10-06 13:13:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("8567", "2870", "ایجاد فعالیت", "2025-10-06 13:13:04", "2025-10-06 13:13:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("8568", "2859", "عملیات توسط Async Request شروع شد", "2025-10-06 13:13:04", "2025-10-06 13:13:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("8569", "2871", "ایجاد فعالیت", "2025-10-06 13:13:04", "2025-10-06 13:13:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("8570", "2859", "عملیات توسط Async Request کامل شد", "2025-10-06 13:13:04", "2025-10-06 13:13:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("8571", "2870", "عملیات توسط Async Request شروع شد", "2025-10-06 14:41:12", "2025-10-06 14:41:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("8572", "2870", "عملیات توسط Async Request کامل شد", "2025-10-06 14:41:12", "2025-10-06 14:41:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("8573", "2872", "ایجاد فعالیت", "2025-10-06 14:41:12", "2025-10-06 14:41:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("8574", "2871", "عملیات توسط Async Request شروع شد", "2025-10-06 14:41:12", "2025-10-06 14:41:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("8575", "2873", "ایجاد فعالیت", "2025-10-06 14:41:12", "2025-10-06 14:41:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("8576", "2871", "عملیات توسط Async Request کامل شد", "2025-10-06 14:41:12", "2025-10-06 14:41:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("8577", "2872", "عملیات توسط Async Request شروع شد", "2025-10-07 09:26:02", "2025-10-07 09:26:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8578", "2872", "عملیات توسط Async Request کامل شد", "2025-10-07 09:26:02", "2025-10-07 09:26:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8579", "2874", "ایجاد فعالیت", "2025-10-07 09:26:02", "2025-10-07 09:26:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8580", "2873", "عملیات توسط Async Request شروع شد", "2025-10-07 09:26:02", "2025-10-07 09:26:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8581", "2875", "ایجاد فعالیت", "2025-10-07 09:26:02", "2025-10-07 09:26:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8582", "2873", "عملیات توسط Async Request کامل شد", "2025-10-07 09:26:02", "2025-10-07 09:26:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8583", "2866", "عملیات توسط Async Request شروع شد", "2025-10-07 09:26:02", "2025-10-07 09:26:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8584", "2866", "عملیات توسط Async Request کامل شد", "2025-10-07 09:26:02", "2025-10-07 09:26:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8585", "2876", "ایجاد فعالیت", "2025-10-07 09:26:02", "2025-10-07 09:26:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8586", "2867", "عملیات توسط Async Request شروع شد", "2025-10-07 09:26:02", "2025-10-07 09:26:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8587", "2867", "عملیات توسط Async Request کامل شد", "2025-10-07 09:26:02", "2025-10-07 09:26:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8588", "2877", "ایجاد فعالیت", "2025-10-07 09:26:02", "2025-10-07 09:26:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8589", "2874", "عملیات توسط Async Request شروع شد", "2025-10-07 12:17:30", "2025-10-07 12:17:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("8590", "2874", "عملیات توسط Async Request کامل شد", "2025-10-07 12:17:30", "2025-10-07 12:17:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("8591", "2878", "ایجاد فعالیت", "2025-10-07 12:17:30", "2025-10-07 12:17:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("8592", "2875", "عملیات توسط Async Request شروع شد", "2025-10-07 12:17:30", "2025-10-07 12:17:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("8593", "2879", "ایجاد فعالیت", "2025-10-07 12:17:30", "2025-10-07 12:17:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("8594", "2875", "عملیات توسط Async Request کامل شد", "2025-10-07 12:17:30", "2025-10-07 12:17:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("8595", "2860", "عملیات توسط Async Request شروع شد", "2025-10-07 12:17:30", "2025-10-07 12:17:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("8596", "2860", "عملیات توسط Async Request کامل شد", "2025-10-07 12:17:30", "2025-10-07 12:17:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("8597", "2880", "ایجاد فعالیت", "2025-10-07 12:17:30", "2025-10-07 12:17:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("8598", "2861", "عملیات توسط Async Request شروع شد", "2025-10-07 12:17:30", "2025-10-07 12:17:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("8599", "2861", "عملیات توسط Async Request کامل شد", "2025-10-07 12:17:30", "2025-10-07 12:17:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("8600", "2881", "ایجاد فعالیت", "2025-10-07 12:17:30", "2025-10-07 12:17:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("8601", "2862", "عملیات توسط Async Request شروع شد", "2025-10-07 12:17:30", "2025-10-07 12:17:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("8602", "2862", "عملیات توسط Async Request کامل شد", "2025-10-07 12:17:32", "2025-10-07 12:17:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("8603", "2882", "ایجاد فعالیت", "2025-10-07 12:17:32", "2025-10-07 12:17:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("8604", "2863", "عملیات توسط Async Request شروع شد", "2025-10-07 12:17:32", "2025-10-07 12:17:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("8605", "2863", "عملیات توسط Async Request کامل شد", "2025-10-07 12:17:33", "2025-10-07 12:17:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8606", "2883", "ایجاد فعالیت", "2025-10-07 12:17:33", "2025-10-07 12:17:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8607", "2864", "عملیات توسط Async Request شروع شد", "2025-10-07 12:17:33", "2025-10-07 12:17:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8608", "2864", "عملیات توسط Async Request کامل شد", "2025-10-07 12:17:33", "2025-10-07 12:17:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8609", "2884", "ایجاد فعالیت", "2025-10-07 12:17:33", "2025-10-07 12:17:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8610", "2865", "عملیات توسط Async Request شروع شد", "2025-10-07 12:17:33", "2025-10-07 12:17:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8611", "2865", "عملیات توسط Async Request کامل شد", "2025-10-07 12:17:33", "2025-10-07 12:17:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8612", "2885", "ایجاد فعالیت", "2025-10-07 12:17:33", "2025-10-07 12:17:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8613", "2869", "عملیات توسط Async Request شروع شد", "2025-10-07 12:17:33", "2025-10-07 12:17:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8614", "2886", "ایجاد فعالیت", "2025-10-07 12:17:33", "2025-10-07 12:17:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8615", "2869", "عملیات توسط Async Request کامل شد", "2025-10-07 12:17:33", "2025-10-07 12:17:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8616", "2887", "ایجاد فعالیت", "2025-10-07 12:17:33", "2025-10-07 12:17:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8617", "2886", "عملیات توسط Async Request شروع شد", "2025-10-07 16:45:34", "2025-10-07 16:45:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("8618", "2886", "عملیات توسط Async Request کامل شد", "2025-10-07 16:45:34", "2025-10-07 16:45:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("8619", "2878", "عملیات توسط Async Request شروع شد", "2025-10-07 16:45:34", "2025-10-07 16:45:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("8620", "2878", "عملیات توسط Async Request کامل شد", "2025-10-07 16:45:34", "2025-10-07 16:45:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("8621", "2888", "ایجاد فعالیت", "2025-10-07 16:45:34", "2025-10-07 16:45:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("8622", "2879", "عملیات توسط Async Request شروع شد", "2025-10-07 16:45:34", "2025-10-07 16:45:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("8623", "2889", "ایجاد فعالیت", "2025-10-07 16:45:34", "2025-10-07 16:45:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("8624", "2879", "عملیات توسط Async Request کامل شد", "2025-10-07 16:45:34", "2025-10-07 16:45:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("8625", "2888", "عملیات توسط Async Request شروع شد", "2025-10-07 20:27:04", "2025-10-07 20:27:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("8626", "2888", "عملیات توسط Async Request کامل شد", "2025-10-07 20:27:04", "2025-10-07 20:27:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("8627", "2890", "ایجاد فعالیت", "2025-10-07 20:27:04", "2025-10-07 20:27:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("8628", "2889", "عملیات توسط Async Request شروع شد", "2025-10-07 20:27:04", "2025-10-07 20:27:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("8629", "2891", "ایجاد فعالیت", "2025-10-07 20:27:04", "2025-10-07 20:27:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("8630", "2889", "عملیات توسط Async Request کامل شد", "2025-10-07 20:27:04", "2025-10-07 20:27:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("8631", "2876", "عملیات توسط Async Request شروع شد", "2025-10-08 07:41:22", "2025-10-08 07:41:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("8632", "2876", "عملیات توسط Async Request کامل شد", "2025-10-08 07:41:22", "2025-10-08 07:41:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("8633", "2892", "ایجاد فعالیت", "2025-10-08 07:41:22", "2025-10-08 07:41:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("8634", "2877", "عملیات توسط Async Request شروع شد", "2025-10-08 07:41:22", "2025-10-08 07:41:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("8635", "2877", "عملیات توسط Async Request کامل شد", "2025-10-08 07:41:22", "2025-10-08 07:41:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("8636", "2893", "ایجاد فعالیت", "2025-10-08 07:41:22", "2025-10-08 07:41:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("8637", "2890", "عملیات توسط Async Request شروع شد", "2025-10-08 07:41:22", "2025-10-08 07:41:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("8638", "2890", "عملیات توسط Async Request کامل شد", "2025-10-08 07:41:22", "2025-10-08 07:41:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("8639", "2894", "ایجاد فعالیت", "2025-10-08 07:41:22", "2025-10-08 07:41:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("8640", "2891", "عملیات توسط Async Request شروع شد", "2025-10-08 07:41:22", "2025-10-08 07:41:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("8641", "2895", "ایجاد فعالیت", "2025-10-08 07:41:22", "2025-10-08 07:41:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("8642", "2891", "عملیات توسط Async Request کامل شد", "2025-10-08 07:41:22", "2025-10-08 07:41:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("8643", "2894", "عملیات توسط Async Request شروع شد", "2025-10-09 07:43:59", "2025-10-09 07:43:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8644", "2894", "عملیات توسط Async Request کامل شد", "2025-10-09 07:43:59", "2025-10-09 07:43:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8645", "2896", "ایجاد فعالیت", "2025-10-09 07:43:59", "2025-10-09 07:43:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8646", "2895", "عملیات توسط Async Request شروع شد", "2025-10-09 07:43:59", "2025-10-09 07:43:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8647", "2897", "ایجاد فعالیت", "2025-10-09 07:43:59", "2025-10-09 07:43:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8648", "2895", "عملیات توسط Async Request کامل شد", "2025-10-09 07:43:59", "2025-10-09 07:43:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8649", "2880", "عملیات توسط Async Request شروع شد", "2025-10-09 07:43:59", "2025-10-09 07:43:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8650", "2880", "عملیات توسط Async Request کامل شد", "2025-10-09 07:43:59", "2025-10-09 07:43:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8651", "2898", "ایجاد فعالیت", "2025-10-09 07:43:59", "2025-10-09 07:43:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8652", "2881", "عملیات توسط Async Request شروع شد", "2025-10-09 07:43:59", "2025-10-09 07:43:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8653", "2881", "عملیات توسط Async Request کامل شد", "2025-10-09 07:43:59", "2025-10-09 07:43:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8654", "2899", "ایجاد فعالیت", "2025-10-09 07:43:59", "2025-10-09 07:43:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8655", "2882", "عملیات توسط Async Request شروع شد", "2025-10-09 07:43:59", "2025-10-09 07:43:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("8656", "2882", "عملیات توسط Async Request کامل شد", "2025-10-09 07:44:01", "2025-10-09 07:44:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("8657", "2900", "ایجاد فعالیت", "2025-10-09 07:44:01", "2025-10-09 07:44:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("8658", "2883", "عملیات توسط Async Request شروع شد", "2025-10-09 07:44:01", "2025-10-09 07:44:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("8659", "2883", "عملیات توسط Async Request کامل شد", "2025-10-09 07:44:02", "2025-10-09 07:44:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8660", "2901", "ایجاد فعالیت", "2025-10-09 07:44:02", "2025-10-09 07:44:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8661", "2884", "عملیات توسط Async Request شروع شد", "2025-10-09 07:44:02", "2025-10-09 07:44:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8662", "2884", "عملیات توسط Async Request کامل شد", "2025-10-09 07:44:02", "2025-10-09 07:44:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8663", "2902", "ایجاد فعالیت", "2025-10-09 07:44:02", "2025-10-09 07:44:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8664", "2885", "عملیات توسط Async Request شروع شد", "2025-10-09 07:44:02", "2025-10-09 07:44:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8665", "2885", "عملیات توسط Async Request کامل شد", "2025-10-09 07:44:02", "2025-10-09 07:44:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8666", "2903", "ایجاد فعالیت", "2025-10-09 07:44:02", "2025-10-09 07:44:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8667", "2892", "عملیات توسط Async Request شروع شد", "2025-10-09 07:44:02", "2025-10-09 07:44:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8668", "2892", "عملیات توسط Async Request کامل شد", "2025-10-09 07:44:02", "2025-10-09 07:44:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8669", "2904", "ایجاد فعالیت", "2025-10-09 07:44:02", "2025-10-09 07:44:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8670", "2893", "عملیات توسط Async Request شروع شد", "2025-10-09 07:44:02", "2025-10-09 07:44:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8671", "2893", "عملیات توسط Async Request کامل شد", "2025-10-09 07:44:02", "2025-10-09 07:44:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8672", "2905", "ایجاد فعالیت", "2025-10-09 07:44:02", "2025-10-09 07:44:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8673", "2887", "عملیات توسط Async Request شروع شد", "2025-10-09 07:44:02", "2025-10-09 07:44:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8674", "2906", "ایجاد فعالیت", "2025-10-09 07:44:02", "2025-10-09 07:44:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8675", "2887", "عملیات توسط Async Request کامل شد", "2025-10-09 07:44:02", "2025-10-09 07:44:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8676", "2907", "ایجاد فعالیت", "2025-10-09 07:44:02", "2025-10-09 07:44:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8677", "2906", "عملیات توسط Async Request شروع شد", "2025-10-09 08:45:21", "2025-10-09 08:45:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("8678", "2906", "عملیات توسط Async Request کامل شد", "2025-10-09 08:45:21", "2025-10-09 08:45:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("8679", "2896", "عملیات توسط Async Request شروع شد", "2025-10-09 08:45:21", "2025-10-09 08:45:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("8680", "2896", "عملیات توسط Async Request کامل شد", "2025-10-09 08:45:21", "2025-10-09 08:45:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("8681", "2908", "ایجاد فعالیت", "2025-10-09 08:45:21", "2025-10-09 08:45:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("8682", "2897", "عملیات توسط Async Request شروع شد", "2025-10-09 08:45:21", "2025-10-09 08:45:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("8683", "2909", "ایجاد فعالیت", "2025-10-09 08:45:21", "2025-10-09 08:45:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("8684", "2897", "عملیات توسط Async Request کامل شد", "2025-10-09 08:45:21", "2025-10-09 08:45:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("8685", "2908", "عملیات توسط Async Request شروع شد", "2025-10-09 23:30:08", "2025-10-09 23:30:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("8686", "2908", "عملیات توسط Async Request کامل شد", "2025-10-09 23:30:08", "2025-10-09 23:30:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("8687", "2910", "ایجاد فعالیت", "2025-10-09 23:30:08", "2025-10-09 23:30:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("8688", "2909", "عملیات توسط Async Request شروع شد", "2025-10-09 23:30:08", "2025-10-09 23:30:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("8689", "2911", "ایجاد فعالیت", "2025-10-09 23:30:08", "2025-10-09 23:30:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("8690", "2909", "عملیات توسط Async Request کامل شد", "2025-10-09 23:30:08", "2025-10-09 23:30:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("8691", "2904", "عملیات توسط Async Request شروع شد", "2025-10-09 23:30:08", "2025-10-09 23:30:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("8692", "2904", "عملیات توسط Async Request کامل شد", "2025-10-09 23:30:08", "2025-10-09 23:30:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("8693", "2912", "ایجاد فعالیت", "2025-10-09 23:30:08", "2025-10-09 23:30:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("8694", "2905", "عملیات توسط Async Request شروع شد", "2025-10-09 23:30:08", "2025-10-09 23:30:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("8695", "2905", "عملیات توسط Async Request کامل شد", "2025-10-09 23:30:08", "2025-10-09 23:30:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("8696", "2913", "ایجاد فعالیت", "2025-10-09 23:30:08", "2025-10-09 23:30:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("8697", "2910", "عملیات توسط Async Request شروع شد", "2025-10-10 04:20:29", "2025-10-10 04:20:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("8698", "2910", "عملیات توسط Async Request کامل شد", "2025-10-10 04:20:29", "2025-10-10 04:20:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("8699", "2914", "ایجاد فعالیت", "2025-10-10 04:20:29", "2025-10-10 04:20:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("8700", "2911", "عملیات توسط Async Request شروع شد", "2025-10-10 04:20:29", "2025-10-10 04:20:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("8701", "2915", "ایجاد فعالیت", "2025-10-10 04:20:29", "2025-10-10 04:20:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("8702", "2911", "عملیات توسط Async Request کامل شد", "2025-10-10 04:20:29", "2025-10-10 04:20:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("8703", "2914", "عملیات توسط Async Request شروع شد", "2025-10-10 07:29:56", "2025-10-10 07:29:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("8704", "2914", "عملیات توسط Async Request کامل شد", "2025-10-10 07:29:56", "2025-10-10 07:29:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("8705", "2916", "ایجاد فعالیت", "2025-10-10 07:29:56", "2025-10-10 07:29:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("8706", "2915", "عملیات توسط Async Request شروع شد", "2025-10-10 07:29:56", "2025-10-10 07:29:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("8707", "2917", "ایجاد فعالیت", "2025-10-10 07:29:56", "2025-10-10 07:29:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("8708", "2915", "عملیات توسط Async Request کامل شد", "2025-10-10 07:29:56", "2025-10-10 07:29:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("8709", "2898", "عملیات توسط Async Request شروع شد", "2025-10-10 16:38:38", "2025-10-10 16:38:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("8710", "2898", "عملیات توسط Async Request کامل شد", "2025-10-10 16:38:38", "2025-10-10 16:38:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("8711", "2918", "ایجاد فعالیت", "2025-10-10 16:38:38", "2025-10-10 16:38:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("8712", "2899", "عملیات توسط Async Request شروع شد", "2025-10-10 16:38:38", "2025-10-10 16:38:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("8713", "2899", "عملیات توسط Async Request کامل شد", "2025-10-10 16:38:38", "2025-10-10 16:38:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("8714", "2919", "ایجاد فعالیت", "2025-10-10 16:38:38", "2025-10-10 16:38:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("8715", "2900", "عملیات توسط Async Request شروع شد", "2025-10-10 16:38:38", "2025-10-10 16:38:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("8716", "2900", "عملیات توسط Async Request کامل شد", "2025-10-10 16:38:40", "2025-10-10 16:38:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("8717", "2920", "ایجاد فعالیت", "2025-10-10 16:38:40", "2025-10-10 16:38:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("8718", "2901", "عملیات توسط Async Request شروع شد", "2025-10-10 16:38:40", "2025-10-10 16:38:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("8719", "2901", "عملیات توسط Async Request کامل شد", "2025-10-10 16:38:41", "2025-10-10 16:38:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("8720", "2921", "ایجاد فعالیت", "2025-10-10 16:38:41", "2025-10-10 16:38:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("8721", "2902", "عملیات توسط Async Request شروع شد", "2025-10-10 16:38:41", "2025-10-10 16:38:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("8722", "2902", "عملیات توسط Async Request کامل شد", "2025-10-10 16:38:41", "2025-10-10 16:38:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("8723", "2922", "ایجاد فعالیت", "2025-10-10 16:38:41", "2025-10-10 16:38:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("8724", "2903", "عملیات توسط Async Request شروع شد", "2025-10-10 16:38:41", "2025-10-10 16:38:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("8725", "2903", "عملیات توسط Async Request کامل شد", "2025-10-10 16:38:41", "2025-10-10 16:38:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("8726", "2923", "ایجاد فعالیت", "2025-10-10 16:38:41", "2025-10-10 16:38:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("8727", "2916", "عملیات توسط Async Request شروع شد", "2025-10-10 16:38:41", "2025-10-10 16:38:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("8728", "2916", "عملیات توسط Async Request کامل شد", "2025-10-10 16:38:41", "2025-10-10 16:38:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("8729", "2924", "ایجاد فعالیت", "2025-10-10 16:38:41", "2025-10-10 16:38:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("8730", "2917", "عملیات توسط Async Request شروع شد", "2025-10-10 16:38:41", "2025-10-10 16:38:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("8731", "2925", "ایجاد فعالیت", "2025-10-10 16:38:41", "2025-10-10 16:38:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("8732", "2917", "عملیات توسط Async Request کامل شد", "2025-10-10 16:38:41", "2025-10-10 16:38:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("8733", "2912", "عملیات توسط Async Request شروع شد", "2025-10-10 16:38:41", "2025-10-10 16:38:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("8734", "2912", "عملیات توسط Async Request کامل شد", "2025-10-10 16:38:41", "2025-10-10 16:38:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("8735", "2926", "ایجاد فعالیت", "2025-10-10 16:38:41", "2025-10-10 16:38:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("8736", "2913", "عملیات توسط Async Request شروع شد", "2025-10-10 16:38:41", "2025-10-10 16:38:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("8737", "2913", "عملیات توسط Async Request کامل شد", "2025-10-10 16:38:41", "2025-10-10 16:38:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("8738", "2927", "ایجاد فعالیت", "2025-10-10 16:38:41", "2025-10-10 16:38:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("8739", "2907", "عملیات توسط Async Request شروع شد", "2025-10-10 16:38:41", "2025-10-10 16:38:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("8740", "2928", "ایجاد فعالیت", "2025-10-10 16:38:41", "2025-10-10 16:38:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("8741", "2907", "عملیات توسط Async Request کامل شد", "2025-10-10 16:38:41", "2025-10-10 16:38:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("8742", "2929", "ایجاد فعالیت", "2025-10-10 16:38:41", "2025-10-10 16:38:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("8743", "2928", "عملیات توسط Async Request شروع شد", "2025-10-10 16:59:19", "2025-10-10 16:59:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("8744", "2928", "عملیات توسط Async Request کامل شد", "2025-10-10 16:59:19", "2025-10-10 16:59:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("8745", "2924", "عملیات توسط Async Request شروع شد", "2025-10-10 21:03:54", "2025-10-10 21:03:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("8746", "2924", "عملیات توسط Async Request کامل شد", "2025-10-10 21:03:54", "2025-10-10 21:03:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("8747", "2930", "ایجاد فعالیت", "2025-10-10 21:03:54", "2025-10-10 21:03:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("8748", "2925", "عملیات توسط Async Request شروع شد", "2025-10-10 21:03:54", "2025-10-10 21:03:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("8749", "2931", "ایجاد فعالیت", "2025-10-10 21:03:54", "2025-10-10 21:03:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("8750", "2925", "عملیات توسط Async Request کامل شد", "2025-10-10 21:03:54", "2025-10-10 21:03:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("8751", "2932", "ایجاد فعالیت", "2025-10-11 08:28:15", "2025-10-11 08:28:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("8752", "2930", "عملیات توسط Async Request شروع شد", "2025-10-11 10:11:27", "2025-10-11 10:11:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8753", "2930", "عملیات توسط Async Request کامل شد", "2025-10-11 10:11:27", "2025-10-11 10:11:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8754", "2933", "ایجاد فعالیت", "2025-10-11 10:11:27", "2025-10-11 10:11:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8755", "2931", "عملیات توسط Async Request شروع شد", "2025-10-11 10:11:27", "2025-10-11 10:11:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8756", "2934", "ایجاد فعالیت", "2025-10-11 10:11:27", "2025-10-11 10:11:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8757", "2931", "عملیات توسط Async Request کامل شد", "2025-10-11 10:11:27", "2025-10-11 10:11:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8758", "2926", "عملیات توسط Async Request شروع شد", "2025-10-11 10:11:27", "2025-10-11 10:11:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8759", "2926", "عملیات توسط Async Request کامل شد", "2025-10-11 10:11:27", "2025-10-11 10:11:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8760", "2935", "ایجاد فعالیت", "2025-10-11 10:11:27", "2025-10-11 10:11:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8761", "2927", "عملیات توسط Async Request شروع شد", "2025-10-11 10:11:27", "2025-10-11 10:11:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8762", "2927", "عملیات توسط Async Request کامل شد", "2025-10-11 10:11:27", "2025-10-11 10:11:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8763", "2936", "ایجاد فعالیت", "2025-10-11 10:11:27", "2025-10-11 10:11:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8764", "2932", "عملیات توسط Async Request شروع شد", "2025-10-11 10:11:27", "2025-10-11 10:11:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8765", "2932", "عملیات توسط Async Request کامل شد", "2025-10-11 10:11:27", "2025-10-11 10:11:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("8766", "2933", "عملیات توسط Async Request شروع شد", "2025-10-11 12:23:45", "2025-10-11 12:23:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("8767", "2933", "عملیات توسط Async Request کامل شد", "2025-10-11 12:23:45", "2025-10-11 12:23:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("8768", "2937", "ایجاد فعالیت", "2025-10-11 12:23:45", "2025-10-11 12:23:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("8769", "2934", "عملیات توسط Async Request شروع شد", "2025-10-11 12:23:45", "2025-10-11 12:23:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("8770", "2938", "ایجاد فعالیت", "2025-10-11 12:23:45", "2025-10-11 12:23:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("8771", "2934", "عملیات توسط Async Request کامل شد", "2025-10-11 12:23:45", "2025-10-11 12:23:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("8772", "2937", "عملیات توسط Async Request شروع شد", "2025-10-12 04:43:58", "2025-10-12 04:43:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("8773", "2937", "عملیات توسط Async Request کامل شد", "2025-10-12 04:43:58", "2025-10-12 04:43:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("8774", "2939", "ایجاد فعالیت", "2025-10-12 04:43:58", "2025-10-12 04:43:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("8775", "2938", "عملیات توسط Async Request شروع شد", "2025-10-12 04:43:58", "2025-10-12 04:43:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("8776", "2940", "ایجاد فعالیت", "2025-10-12 04:43:58", "2025-10-12 04:43:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("8777", "2938", "عملیات توسط Async Request کامل شد", "2025-10-12 04:43:58", "2025-10-12 04:43:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("8778", "2918", "عملیات توسط Async Request شروع شد", "2025-10-12 04:43:58", "2025-10-12 04:43:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("8779", "2918", "عملیات توسط Async Request کامل شد", "2025-10-12 04:43:58", "2025-10-12 04:43:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("8780", "2941", "ایجاد فعالیت", "2025-10-12 04:43:58", "2025-10-12 04:43:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("8781", "2919", "عملیات توسط Async Request شروع شد", "2025-10-12 04:43:58", "2025-10-12 04:43:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("8782", "2919", "عملیات توسط Async Request کامل شد", "2025-10-12 04:43:58", "2025-10-12 04:43:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("8783", "2942", "ایجاد فعالیت", "2025-10-12 04:43:58", "2025-10-12 04:43:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("8784", "2920", "عملیات توسط Async Request شروع شد", "2025-10-12 04:43:58", "2025-10-12 04:43:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("8785", "2920", "عملیات توسط Async Request کامل شد", "2025-10-12 04:44:00", "2025-10-12 04:44:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("8786", "2943", "ایجاد فعالیت", "2025-10-12 04:44:00", "2025-10-12 04:44:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("8787", "2921", "عملیات توسط Async Request شروع شد", "2025-10-12 04:44:00", "2025-10-12 04:44:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("8788", "2921", "عملیات توسط Async Request کامل شد", "2025-10-12 04:44:01", "2025-10-12 04:44:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("8789", "2944", "ایجاد فعالیت", "2025-10-12 04:44:01", "2025-10-12 04:44:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("8790", "2922", "عملیات توسط Async Request شروع شد", "2025-10-12 04:44:01", "2025-10-12 04:44:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("8791", "2922", "عملیات توسط Async Request کامل شد", "2025-10-12 04:44:01", "2025-10-12 04:44:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("8792", "2945", "ایجاد فعالیت", "2025-10-12 04:44:01", "2025-10-12 04:44:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("8793", "2923", "عملیات توسط Async Request شروع شد", "2025-10-12 04:44:01", "2025-10-12 04:44:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("8794", "2923", "عملیات توسط Async Request کامل شد", "2025-10-12 04:44:01", "2025-10-12 04:44:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("8795", "2946", "ایجاد فعالیت", "2025-10-12 04:44:01", "2025-10-12 04:44:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("8796", "2935", "عملیات توسط Async Request شروع شد", "2025-10-12 04:44:01", "2025-10-12 04:44:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("8797", "2935", "عملیات توسط Async Request کامل شد", "2025-10-12 04:44:01", "2025-10-12 04:44:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("8798", "2947", "ایجاد فعالیت", "2025-10-12 04:44:01", "2025-10-12 04:44:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("8799", "2936", "عملیات توسط Async Request شروع شد", "2025-10-12 04:44:01", "2025-10-12 04:44:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("8800", "2936", "عملیات توسط Async Request کامل شد", "2025-10-12 04:44:01", "2025-10-12 04:44:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("8801", "2948", "ایجاد فعالیت", "2025-10-12 04:44:01", "2025-10-12 04:44:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("8802", "2929", "عملیات توسط Async Request شروع شد", "2025-10-12 04:44:01", "2025-10-12 04:44:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("8803", "2949", "ایجاد فعالیت", "2025-10-12 04:44:01", "2025-10-12 04:44:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("8804", "2929", "عملیات توسط Async Request کامل شد", "2025-10-12 04:44:01", "2025-10-12 04:44:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("8805", "2950", "ایجاد فعالیت", "2025-10-12 04:44:01", "2025-10-12 04:44:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("8806", "2949", "عملیات توسط Async Request شروع شد", "2025-10-12 04:46:10", "2025-10-12 04:46:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("8807", "2949", "عملیات توسط Async Request کامل شد", "2025-10-12 04:46:10", "2025-10-12 04:46:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("8808", "2951", "ایجاد فعالیت", "2025-10-12 05:13:06", "2025-10-12 05:13:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("8809", "2951", "عملیات توسط Async Request شروع شد", "2025-10-12 05:13:33", "2025-10-12 05:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8810", "2951", "عملیات توسط Async Request کامل شد", "2025-10-12 05:13:33", "2025-10-12 05:13:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("8811", "2952", "ایجاد فعالیت", "2025-10-12 05:16:41", "2025-10-12 05:16:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("8812", "2953", "ایجاد فعالیت", "2025-10-12 05:16:41", "2025-10-12 05:16:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("8813", "2952", "عملیات توسط Async Request شروع شد", "2025-10-12 05:17:44", "2025-10-12 05:17:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("8814", "2953", "لغو فعالیت", "2025-10-12 05:17:44", "2025-10-12 05:17:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("8815", "2952", "عملیات توسط Async Request کامل شد", "2025-10-12 05:17:44", "2025-10-12 05:17:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("8816", "2953", "عملیات از طریق Async Request نادیده گرفته شد", "2025-10-12 05:17:44", "2025-10-12 05:17:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("8817", "2939", "عملیات توسط Async Request شروع شد", "2025-10-12 05:44:02", "2025-10-12 05:44:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8818", "2939", "عملیات توسط Async Request کامل شد", "2025-10-12 05:44:02", "2025-10-12 05:44:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8819", "2954", "ایجاد فعالیت", "2025-10-12 05:44:02", "2025-10-12 05:44:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8820", "2940", "عملیات توسط Async Request شروع شد", "2025-10-12 05:44:02", "2025-10-12 05:44:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8821", "2955", "ایجاد فعالیت", "2025-10-12 05:44:02", "2025-10-12 05:44:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8822", "2940", "عملیات توسط Async Request کامل شد", "2025-10-12 05:44:02", "2025-10-12 05:44:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("8823", "2956", "ایجاد فعالیت", "2025-10-12 06:14:12", "2025-10-12 06:14:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("8824", "2957", "ایجاد فعالیت", "2025-10-12 06:14:19", "2025-10-12 06:14:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("8825", "2956", "عملیات توسط Async Request شروع شد", "2025-10-12 06:14:40", "2025-10-12 06:14:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("8826", "2956", "عملیات توسط Async Request کامل شد", "2025-10-12 06:14:40", "2025-10-12 06:14:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("8827", "2957", "عملیات توسط Async Request شروع شد", "2025-10-12 06:14:40", "2025-10-12 06:14:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("8828", "2957", "عملیات توسط Async Request کامل شد", "2025-10-12 06:14:40", "2025-10-12 06:14:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("8829", "2958", "ایجاد فعالیت", "2025-10-12 06:19:05", "2025-10-12 06:19:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("8830", "2958", "عملیات توسط Async Request شروع شد", "2025-10-12 06:20:55", "2025-10-12 06:20:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("8831", "2958", "عملیات توسط Async Request کامل شد", "2025-10-12 06:20:55", "2025-10-12 06:20:55");

/* INSERT TABLE DATA: wp_appwoodart_woo_api_geo_fencing */
INSERT INTO `wp_appwoodart_woo_api_geo_fencing` VALUES("1", "111", "d12b7bd59a496881a526391f4db711e1ebc078da", "0", "0", "0");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("3", "3528", "ووکامرس", "", "", "", "2022-12-05 09:04:05", "2022-12-05 05:34:05", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("4", "3528", "ووکامرس", "", "", "", "2022-12-05 11:00:50", "2022-12-05 07:30:50", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("5", "3532", "ووکامرس", "", "", "", "2022-12-06 20:51:54", "2022-12-06 17:21:54", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("6", "3532", "ووکامرس", "", "", "", "2022-12-06 20:52:00", "2022-12-06 17:22:00", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("7", "3532", "ووکامرس", "", "", "", "2022-12-06 22:31:30", "2022-12-06 19:01:30", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("8", "3533", "ووکامرس", "", "", "", "2022-12-08 11:57:54", "2022-12-08 08:27:54", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("9", "3533", "ووکامرس", "", "", "", "2022-12-08 11:57:55", "2022-12-08 08:27:55", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("10", "3533", "ووکامرس", "", "", "", "2022-12-08 11:58:00", "2022-12-08 08:28:00", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("11", "3533", "ووکامرس", "", "", "", "2022-12-08 13:11:46", "2022-12-08 09:41:46", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("12", "3535", "ووکامرس", "", "", "", "2022-12-10 10:45:39", "2022-12-10 11:45:39", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("13", "3535", "ووکامرس", "", "", "", "2022-12-10 12:19:55", "2022-12-10 13:19:55", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("15", "3671", "ووکامرس", "", "", "", "2022-12-26 21:06:45", "2022-12-26 22:06:45", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("16", "3671", "ووکامرس", "", "", "", "2022-12-26 22:28:38", "2022-12-26 23:28:38", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("17", "3696", "ووکامرس", "", "", "", "2023-01-01 11:16:32", "2023-01-01 12:16:32", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("18", "3696", "ووکامرس", "", "", "", "2023-01-01 13:07:42", "2023-01-01 14:07:42", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("20", "3744", "ووکامرس", "", "", "", "2023-01-27 10:36:16", "2023-01-27 11:36:16", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("21", "3744", "ووکامرس", "", "", "", "2023-01-27 10:36:26", "2023-01-27 11:36:26", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("22", "3744", "ووکامرس", "", "", "", "2023-01-27 10:36:33", "2023-01-27 11:36:33", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("23", "3744", "ووکامرس", "", "", "", "2023-01-27 12:18:45", "2023-01-27 13:18:45", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("24", "3746", "ووکامرس", "", "", "", "2023-01-30 09:35:06", "2023-01-30 10:35:06", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("25", "3746", "ووکامرس", "", "", "", "2023-01-30 09:36:16", "2023-01-30 10:36:16", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("26", "3746", "ووکامرس", "", "", "", "2023-01-30 10:58:37", "2023-01-30 11:58:37", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("27", "3752", "ووکامرس", "", "", "", "2023-02-03 07:13:49", "2023-02-03 08:13:49", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("28", "3752", "ووکامرس", "", "", "", "2023-02-03 07:13:54", "2023-02-03 08:13:54", "در هنگام اتصال به درگاه Pay.ir خطای زیر رخ داده است.<br>API Key ارسال نمی شود", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("29", "3752", "ووکامرس", "", "", "", "2023-02-03 08:27:59", "2023-02-03 09:27:59", "سفارش پرداخت نشده لغو شد - حد زمانی پایان یافت وضعیت سفارش از در انتظار پرداخت به لغو شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("36", "4214", "ووکامرس", "", "", "", "2024-01-08 05:58:28", "2024-01-08 06:58:28", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل شیائومی مدل POCO F3 5G (#3516) &times; 4<br>- ساعت هوشمند ش43 (#3474) &times; 1<br>- گوشی موبایل شیائومی مدل POCO F3 5G - قرمز, نوکیا (#4142)<span class=\"description\"></span> &times; 1<br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("37", "4214", "ووکامرس", "", "", "", "2024-01-08 05:58:29", "2024-01-08 06:58:29", "سطح موجودی کاهش یافت: گوشی موبایل شیائومی مدل POCO F3 5G (#3516) 9&rarr;5, ساعت هوشمند ش43 (#3474) 12&rarr;11, گوشی موبایل شیائومی مدل POCO F3 5G - قرمز, نوکیا (#4142)<span class=\"description\"></span> 8&rarr;7, گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 10&rarr;9", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("38", "4214", "ووکامرس", "", "", "", "2024-01-08 05:58:29", "2024-01-08 06:58:29", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("39", "4220", "ووکامرس", "", "", "", "2024-01-08 13:59:55", "2024-01-08 14:59:55", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("40", "4220", "ووکامرس", "", "", "", "2024-01-08 13:59:55", "2024-01-08 14:59:55", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 9&rarr;8", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("41", "4220", "ووکامرس", "", "", "", "2024-01-08 13:59:55", "2024-01-08 14:59:55", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("42", "4224", "ووکامرس", "", "", "", "2024-01-09 12:39:36", "2024-01-09 13:39:36", "نگهداری سهام 60 دقیقه روی <br>- ساعت هوشمند سامسونگ (#3484) &times; 2 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("43", "4224", "ووکامرس", "", "", "", "2024-01-09 12:39:36", "2024-01-09 13:39:36", "سطح موجودی کاهش یافت: ساعت هوشمند سامسونگ (#3484) 10&rarr;8", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("44", "4224", "ووکامرس", "", "", "", "2024-01-09 12:39:36", "2024-01-09 13:39:36", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("45", "4228", "ووکامرس", "", "", "", "2024-01-09 16:03:01", "2024-01-09 17:03:01", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("46", "4232", "ووکامرس", "", "", "", "2024-01-12 20:04:25", "2024-01-12 21:04:25", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("47", "4232", "ووکامرس", "", "", "", "2024-01-12 20:04:26", "2024-01-12 21:04:26", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 8&rarr;7", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("48", "4232", "ووکامرس", "", "", "", "2024-01-12 20:04:26", "2024-01-12 21:04:26", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("49", "4236", "ووکامرس", "", "", "", "2024-01-15 12:44:03", "2024-01-15 13:44:03", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل شیائومی مدل POCO F3 5G - آبی, نوکیا (#4134)<span class=\"description\"></span> &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("50", "4236", "ووکامرس", "", "", "", "2024-01-15 12:44:03", "2024-01-15 13:44:03", "سطح موجودی کاهش یافت: گوشی موبایل شیائومی مدل POCO F3 5G - آبی, نوکیا (#4134)<span class=\"description\"></span> 7&rarr;6", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("51", "4236", "ووکامرس", "", "", "", "2024-01-15 12:44:03", "2024-01-15 13:44:03", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("52", "4237", "ووکامرس", "", "", "", "2024-01-15 21:31:18", "2024-01-15 22:31:18", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل شیائومی مدل POCO F3 5G - قرمز, نوکیا (#4142)<span class=\"description\"></span> &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("53", "4237", "ووکامرس", "", "", "", "2024-01-15 21:31:18", "2024-01-15 22:31:18", "سطح موجودی کاهش یافت: گوشی موبایل شیائومی مدل POCO F3 5G - قرمز, نوکیا (#4142)<span class=\"description\"></span> 6&rarr;5", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("54", "4237", "ووکامرس", "", "", "", "2024-01-15 21:31:18", "2024-01-15 22:31:18", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("55", "4240", "ووکامرس", "", "", "", "2024-01-17 10:44:55", "2024-01-17 11:44:55", "نگهداری سهام 60 دقیقه روی <br>- ساعت هوشمند سامسونگ (#3484) &times; 2 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("56", "4240", "ووکامرس", "", "", "", "2024-01-17 10:44:55", "2024-01-17 11:44:55", "سطح موجودی کاهش یافت: ساعت هوشمند سامسونگ (#3484) 8&rarr;6", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("57", "4240", "ووکامرس", "", "", "", "2024-01-17 10:44:55", "2024-01-17 11:44:55", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("58", "4258", "ووکامرس", "", "", "", "2024-01-20 09:17:17", "2024-01-20 10:17:17", "نگهداری سهام 60 دقیقه روی <br>- ساعت هوشمند ش43 (#3474) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("59", "4258", "ووکامرس", "", "", "", "2024-01-20 09:17:17", "2024-01-20 10:17:17", "سطح موجودی کاهش یافت: ساعت هوشمند ش43 (#3474) 11&rarr;10", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("60", "4258", "ووکامرس", "", "", "", "2024-01-20 09:17:17", "2024-01-20 10:17:17", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("61", "4262", "ووکامرس", "", "", "", "2024-01-21 21:04:14", "2024-01-21 22:04:14", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل شیائومی مدل POCO F3 5G (#3516) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("62", "4262", "ووکامرس", "", "", "", "2024-01-21 21:04:14", "2024-01-21 22:04:14", "سطح موجودی کاهش یافت: گوشی موبایل شیائومی مدل POCO F3 5G (#3516) 5&rarr;4", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("63", "4262", "ووکامرس", "", "", "", "2024-01-21 21:04:14", "2024-01-21 22:04:14", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("64", "4263", "ووکامرس", "", "", "", "2024-01-21 23:09:07", "2024-01-22 00:09:07", "نگهداری سهام 60 دقیقه روی <br>- ساعت هوشمند سامسونگ (#3484) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("65", "4263", "ووکامرس", "", "", "", "2024-01-21 23:09:07", "2024-01-22 00:09:07", "سطح موجودی کاهش یافت: ساعت هوشمند سامسونگ (#3484) 6&rarr;5", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("66", "4263", "ووکامرس", "", "", "", "2024-01-21 23:09:07", "2024-01-22 00:09:07", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("67", "4269", "ووکامرس", "", "", "", "2024-01-22 15:08:31", "2024-01-22 16:08:31", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("68", "4269", "ووکامرس", "", "", "", "2024-01-22 15:08:31", "2024-01-22 16:08:31", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 7&rarr;6", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("69", "4269", "ووکامرس", "", "", "", "2024-01-22 15:08:31", "2024-01-22 16:08:31", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("70", "4285", "ووکامرس", "", "", "", "2024-01-29 11:09:38", "2024-01-29 12:09:38", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل شیائومی مدل POCO F3 5G - آبی, نوکیا (#4134)<span class=\"description\"></span> &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("71", "4285", "ووکامرس", "", "", "", "2024-01-29 11:09:39", "2024-01-29 12:09:39", "سطح موجودی کاهش یافت: گوشی موبایل شیائومی مدل POCO F3 5G - آبی, نوکیا (#4134)<span class=\"description\"></span> 5&rarr;4", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("72", "4285", "ووکامرس", "", "", "", "2024-01-29 11:09:39", "2024-01-29 12:09:39", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("73", "4287", "ووکامرس", "", "", "", "2024-01-31 17:48:51", "2024-01-31 18:48:51", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("74", "4287", "ووکامرس", "", "", "", "2024-01-31 17:48:51", "2024-01-31 18:48:51", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 6&rarr;5", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("75", "4287", "ووکامرس", "", "", "", "2024-01-31 17:48:51", "2024-01-31 18:48:51", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("76", "4288", "ووکامرس", "", "", "", "2024-02-05 08:44:50", "2024-02-05 09:44:50", "نگهداری سهام 60 دقیقه روی <br>- ساعت هوشمند هاوایی (#3486) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("77", "4288", "ووکامرس", "", "", "", "2024-02-05 08:44:51", "2024-02-05 09:44:51", "سطح موجودی کاهش یافت: ساعت هوشمند هاوایی (#3486) 10&rarr;9", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("78", "4288", "ووکامرس", "", "", "", "2024-02-05 08:44:51", "2024-02-05 09:44:51", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("79", "4301", "ووکامرس", "", "", "", "2024-02-10 12:25:44", "2024-02-10 13:25:44", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) &times; 2 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("80", "4301", "ووکامرس", "", "", "", "2024-02-10 12:25:44", "2024-02-10 13:25:44", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 5&rarr;3", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("81", "4301", "ووکامرس", "", "", "", "2024-02-10 12:25:44", "2024-02-10 13:25:44", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("82", "4305", "ووکامرس", "", "", "", "2024-02-21 07:57:18", "2024-02-21 08:57:18", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) &times; 1<br>- ساعت هوشمند ش43 (#3474) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("83", "4305", "ووکامرس", "", "", "", "2024-02-21 07:57:18", "2024-02-21 08:57:18", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 3&rarr;2, ساعت هوشمند ش43 (#3474) 10&rarr;9", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("84", "4305", "ووکامرس", "", "", "", "2024-02-21 07:57:18", "2024-02-21 08:57:18", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("85", "4311", "ووکامرس", "", "", "", "2024-02-24 11:15:18", "2024-02-24 12:15:18", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("86", "4311", "ووکامرس", "", "", "", "2024-02-24 11:15:18", "2024-02-24 12:15:18", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 2&rarr;1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("87", "4311", "ووکامرس", "", "", "", "2024-02-24 11:15:18", "2024-02-24 12:15:18", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("88", "4312", "ووکامرس", "", "", "", "2024-02-24 20:35:41", "2024-02-24 21:35:41", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("89", "4312", "ووکامرس", "", "", "", "2024-02-24 20:35:42", "2024-02-24 21:35:42", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 1&rarr;0", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("90", "4312", "ووکامرس", "", "", "", "2024-02-24 20:35:42", "2024-02-24 21:35:42", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("91", "4313", "ووکامرس", "", "", "", "2024-02-25 20:54:09", "2024-02-25 21:54:09", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل شیائومی مدل POCO F3 5G - آبی, شیائومی (#4133)<span class=\"description\"></span> &times; 1<br>- ساعت هوشمند سامسونگ (#3484) &times; 2 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("92", "4313", "ووکامرس", "", "", "", "2024-02-25 20:54:09", "2024-02-25 21:54:09", "سطح موجودی کاهش یافت: گوشی موبایل شیائومی مدل POCO F3 5G - آبی, شیائومی (#4133)<span class=\"description\"></span> 4&rarr;3, ساعت هوشمند سامسونگ (#3484) 5&rarr;3", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("93", "4313", "ووکامرس", "", "", "", "2024-02-25 20:54:09", "2024-02-25 21:54:09", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("94", "4317", "ووکامرس", "", "", "", "2024-02-26 04:51:21", "2024-02-26 05:51:21", "نگهداری سهام 60 دقیقه روی <br>- ساعت هوشمند هاوایی (#3486) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("95", "4317", "ووکامرس", "", "", "", "2024-02-26 04:51:21", "2024-02-26 05:51:21", "سطح موجودی کاهش یافت: ساعت هوشمند هاوایی (#3486) 9&rarr;8", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("96", "4317", "ووکامرس", "", "", "", "2024-02-26 04:51:21", "2024-02-26 05:51:21", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("97", "4318", "ووکامرس", "", "", "", "2024-02-26 14:24:02", "2024-02-26 15:24:02", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("98", "4327", "ووکامرس", "", "", "", "2024-03-15 22:49:17", "2024-03-15 23:49:17", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل شیائومی مدل POCO F3 5G (#3516) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("99", "4327", "ووکامرس", "", "", "", "2024-03-15 22:49:17", "2024-03-15 23:49:17", "سطح موجودی کاهش یافت: گوشی موبایل شیائومی مدل POCO F3 5G (#3516) 4&rarr;3", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("100", "4327", "ووکامرس", "", "", "", "2024-03-15 22:49:17", "2024-03-15 23:49:17", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("101", "4332", "ووکامرس", "", "", "", "2024-03-30 22:57:49", "2024-03-30 23:57:49", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("102", "4332", "ووکامرس", "", "", "", "2024-03-30 22:57:49", "2024-03-30 23:57:49", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 30&rarr;29", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("103", "4332", "ووکامرس", "", "", "", "2024-03-30 22:57:49", "2024-03-30 23:57:49", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("104", "4333", "ووکامرس", "", "", "", "2024-04-02 11:49:38", "2024-04-02 11:49:38", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل شیائومی مدل POCO F3 5G (#3516) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("105", "4333", "ووکامرس", "", "", "", "2024-04-02 11:49:38", "2024-04-02 11:49:38", "سطح موجودی کاهش یافت: گوشی موبایل شیائومی مدل POCO F3 5G (#3516) 3&rarr;2", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("106", "4333", "ووکامرس", "", "", "", "2024-04-02 11:49:38", "2024-04-02 11:49:38", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("107", "4338", "ووکامرس", "", "", "", "2024-04-06 13:17:34", "2024-04-06 13:17:34", "نگهداری سهام 60 دقیقه روی <br>- ساعت هوشمند سامسونگ (#3484) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("108", "4338", "ووکامرس", "", "", "", "2024-04-06 13:17:35", "2024-04-06 13:17:35", "سطح موجودی کاهش یافت: ساعت هوشمند سامسونگ (#3484) 3&rarr;2", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("109", "4338", "ووکامرس", "", "", "", "2024-04-06 13:17:35", "2024-04-06 13:17:35", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("110", "4339", "ووکامرس", "", "", "", "2024-04-07 00:39:11", "2024-04-07 00:39:11", "نگهداری سهام 60 دقیقه روی <br>- ساعت هوشمند ش43 (#3474) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("111", "4339", "ووکامرس", "", "", "", "2024-04-07 00:39:11", "2024-04-07 00:39:11", "سطح موجودی کاهش یافت: ساعت هوشمند ش43 (#3474) 9&rarr;8", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("112", "4339", "ووکامرس", "", "", "", "2024-04-07 00:39:11", "2024-04-07 00:39:11", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("113", "4340", "ووکامرس", "", "", "", "2024-04-13 13:53:54", "2024-04-13 13:53:54", "نگهداری سهام 60 دقیقه روی <br>- ساعت هوشمند سامسونگ (#3484) &times; 2<br>- ساعت هوشمند ش43 (#3474) &times; 4 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("114", "4340", "ووکامرس", "", "", "", "2024-04-13 13:53:54", "2024-04-13 13:53:54", "سطح موجودی کاهش یافت: ساعت هوشمند سامسونگ (#3484) 2&rarr;0, ساعت هوشمند ش43 (#3474) 8&rarr;4", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("115", "4340", "ووکامرس", "", "", "", "2024-04-13 13:53:54", "2024-04-13 13:53:54", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("116", "4341", "ووکامرس", "", "", "", "2024-04-18 20:23:17", "2024-04-18 20:23:17", "نگهداری سهام 60 دقیقه روی <br>- ساعت هوشمند هاوایی (#3486) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("117", "4341", "ووکامرس", "", "", "", "2024-04-18 20:23:17", "2024-04-18 20:23:17", "سطح موجودی کاهش یافت: ساعت هوشمند هاوایی (#3486) 8&rarr;7", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("118", "4341", "ووکامرس", "", "", "", "2024-04-18 20:23:17", "2024-04-18 20:23:17", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("119", "4343", "ووکامرس", "", "", "", "2024-04-22 06:24:52", "2024-04-22 06:24:52", "نگهداری سهام 60 دقیقه روی <br>- ساعت هوشمند ش43 (#3474) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("120", "4343", "ووکامرس", "", "", "", "2024-04-22 06:24:52", "2024-04-22 06:24:52", "سطح موجودی کاهش یافت: ساعت هوشمند ش43 (#3474) 4&rarr;3", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("121", "4343", "ووکامرس", "", "", "", "2024-04-22 06:24:52", "2024-04-22 06:24:52", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("122", "4353", "ووکامرس", "", "", "", "2024-04-23 08:49:38", "2024-04-23 08:49:38", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("123", "4360", "ووکامرس", "", "", "", "2024-04-28 21:40:00", "2024-04-28 21:40:00", "نگهداری سهام 60 دقیقه روی <br>- ساعت هوشمند هاوایی (#3486) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("124", "4360", "ووکامرس", "", "", "", "2024-04-28 21:40:00", "2024-04-28 21:40:00", "سطح موجودی کاهش یافت: ساعت هوشمند هاوایی (#3486) 7&rarr;6", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("125", "4360", "ووکامرس", "", "", "", "2024-04-28 21:40:00", "2024-04-28 21:40:00", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("126", "4413", "ووکامرس", "", "", "", "2024-04-30 14:11:42", "2024-04-30 14:11:42", "نگهداری سهام 60 دقیقه روی <br>- ساعت هوشمند ش43 (#3474) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("127", "4413", "ووکامرس", "", "", "", "2024-04-30 14:11:43", "2024-04-30 14:11:43", "سطح موجودی کاهش یافت: ساعت هوشمند ش43 (#3474) 3&rarr;2", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("128", "4413", "ووکامرس", "", "", "", "2024-04-30 14:11:43", "2024-04-30 14:11:43", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("129", "4417", "ووکامرس", "", "", "", "2024-05-12 09:34:33", "2024-05-12 09:34:33", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل شیائومی مدل POCO F3 5G (#3516) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("130", "4417", "ووکامرس", "", "", "", "2024-05-12 09:34:33", "2024-05-12 09:34:33", "سطح موجودی کاهش یافت: گوشی موبایل شیائومی مدل POCO F3 5G (#3516) 2&rarr;1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("131", "4417", "ووکامرس", "", "", "", "2024-05-12 09:34:33", "2024-05-12 09:34:33", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("132", "4418", "ووکامرس", "", "", "", "2024-05-16 08:37:36", "2024-05-16 08:37:36", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل شیائومی مدل POCO F3 5G (#3516) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("133", "4418", "ووکامرس", "", "", "", "2024-05-16 08:37:36", "2024-05-16 08:37:36", "سطح موجودی کاهش یافت: گوشی موبایل شیائومی مدل POCO F3 5G (#3516) 1&rarr;0", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("134", "4418", "ووکامرس", "", "", "", "2024-05-16 08:37:36", "2024-05-16 08:37:36", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("135", "4419", "ووکامرس", "", "", "", "2024-06-02 10:02:33", "2024-06-02 10:02:33", "نگهداری سهام 60 دقیقه روی <br>- ساعت هوشمند ش43 (#3474) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("136", "4419", "ووکامرس", "", "", "", "2024-06-02 10:02:34", "2024-06-02 10:02:34", "سطح موجودی کاهش یافت: ساعت هوشمند ش43 (#3474) 2&rarr;1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("137", "4419", "ووکامرس", "", "", "", "2024-06-02 10:02:34", "2024-06-02 10:02:34", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("138", "4420", "ووکامرس", "", "", "", "2024-06-02 20:54:08", "2024-06-02 20:54:08", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("142", "4426", "ووکامرس", "", "", "", "2024-06-10 07:24:05", "2024-06-10 07:24:05", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) &times; 5 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("143", "4426", "ووکامرس", "", "", "", "2024-06-10 07:24:05", "2024-06-10 07:24:05", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 29&rarr;24", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("144", "4426", "ووکامرس", "", "", "", "2024-06-10 07:24:05", "2024-06-10 07:24:05", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("145", "4427", "ووکامرس", "", "", "", "2024-06-13 07:46:29", "2024-06-13 07:46:29", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) &times; 1<br>- گوشی موبایل سامسونگ a12 -56A (#3507) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("146", "4427", "ووکامرس", "", "", "", "2024-06-13 07:46:29", "2024-06-13 07:46:29", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 24&rarr;23, گوشی موبایل سامسونگ a12 -56A (#3507) 14&rarr;13", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("147", "4427", "ووکامرس", "", "", "", "2024-06-13 07:46:29", "2024-06-13 07:46:29", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("152", "4435", "ووکامرس", "", "", "", "2024-07-08 13:30:59", "2024-07-08 13:30:59", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("153", "4435", "ووکامرس", "", "", "", "2024-07-08 13:30:59", "2024-07-08 13:30:59", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 23&rarr;22", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("154", "4435", "ووکامرس", "", "", "", "2024-07-08 13:30:59", "2024-07-08 13:30:59", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("155", "4436", "ووکامرس", "", "", "", "2024-07-10 07:35:36", "2024-07-10 07:35:36", "نگهداری سهام 60 دقیقه روی <br>- ساعت هوشمند ش43 (#3474) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("156", "4436", "ووکامرس", "", "", "", "2024-07-10 07:35:37", "2024-07-10 07:35:37", "سطح موجودی کاهش یافت: ساعت هوشمند ش43 (#3474) 1&rarr;0", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("157", "4436", "ووکامرس", "", "", "", "2024-07-10 07:35:37", "2024-07-10 07:35:37", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("158", "4438", "ووکامرس", "", "", "", "2024-07-18 13:30:37", "2024-07-18 13:30:37", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل سامسونگ a12 -56A (#3507) &times; 1<br>- ساعت هوشمند هاوایی (#3486) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("159", "4438", "ووکامرس", "", "", "", "2024-07-18 13:30:37", "2024-07-18 13:30:37", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ a12 -56A (#3507) 13&rarr;12, ساعت هوشمند هاوایی (#3486) 6&rarr;5", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("160", "4438", "ووکامرس", "", "", "", "2024-07-18 13:30:37", "2024-07-18 13:30:37", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("161", "4451", "ووکامرس", "", "", "", "2024-07-20 14:09:50", "2024-07-20 14:09:50", "نگهداری سهام 60 دقیقه روی <br>- ساعت هوشمند هاوایی (#3486) &times; 1<br>- گوشی موبایل سامسونگ a12 -56A (#3507) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("162", "4451", "ووکامرس", "", "", "", "2024-07-20 14:09:50", "2024-07-20 14:09:50", "سطح موجودی کاهش یافت: ساعت هوشمند هاوایی (#3486) 5&rarr;4, گوشی موبایل سامسونگ a12 -56A (#3507) 12&rarr;11", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("163", "4451", "ووکامرس", "", "", "", "2024-07-20 14:09:50", "2024-07-20 14:09:50", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("164", "4452", "ووکامرس", "", "", "", "2024-07-20 14:11:16", "2024-07-20 14:11:16", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("165", "4452", "ووکامرس", "", "", "", "2024-07-20 14:11:16", "2024-07-20 14:11:16", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 22&rarr;21", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("166", "4452", "ووکامرس", "", "", "", "2024-07-20 14:11:16", "2024-07-20 14:11:16", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("167", "4457", "ووکامرس", "", "", "", "2024-07-27 06:01:49", "2024-07-27 06:01:49", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل شیائومی مدل POCO F3 5G - آبی, هواوی (#4135)<span class=\"description\"></span> &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("168", "4457", "ووکامرس", "", "", "", "2024-07-27 06:01:50", "2024-07-27 06:01:50", "سطح موجودی کاهش یافت: گوشی موبایل شیائومی مدل POCO F3 5G - آبی, هواوی (#4135)<span class=\"description\"></span> 3&rarr;2", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("169", "4457", "ووکامرس", "", "", "", "2024-07-27 06:01:50", "2024-07-27 06:01:50", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("170", "4460", "ووکامرس", "", "", "", "2024-07-28 12:51:53", "2024-07-28 12:51:53", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("171", "4461", "ووکامرس", "", "", "", "2024-07-29 07:44:25", "2024-07-29 07:44:25", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("172", "4461", "ووکامرس", "", "", "", "2024-07-29 07:44:25", "2024-07-29 07:44:25", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 21&rarr;20", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("173", "4461", "ووکامرس", "", "", "", "2024-07-29 07:44:25", "2024-07-29 07:44:25", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("174", "4462", "ووکامرس", "", "", "", "2024-07-29 08:15:09", "2024-07-29 08:15:09", "نگهداری سهام 60 دقیقه روی <br>- ساعت هوشمند هاوایی (#3486) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("175", "4462", "ووکامرس", "", "", "", "2024-07-29 08:15:09", "2024-07-29 08:15:09", "سطح موجودی کاهش یافت: ساعت هوشمند هاوایی (#3486) 4&rarr;3", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("176", "4462", "ووکامرس", "", "", "", "2024-07-29 08:15:09", "2024-07-29 08:15:09", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("177", "4463", "ووکامرس", "", "", "", "2024-07-29 10:32:43", "2024-07-29 10:32:43", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل سامسونگ a12 -56A (#3507) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("178", "4463", "ووکامرس", "", "", "", "2024-07-29 10:32:43", "2024-07-29 10:32:43", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ a12 -56A (#3507) 11&rarr;10", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("179", "4463", "ووکامرس", "", "", "", "2024-07-29 10:32:43", "2024-07-29 10:32:43", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("180", "4464", "ووکامرس", "", "", "", "2024-07-29 10:36:25", "2024-07-29 10:36:25", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل شیائومی مدل POCO F3 5G - قرمز, نوکیا (#4142)<span class=\"description\"></span> &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("181", "4464", "ووکامرس", "", "", "", "2024-07-29 10:36:25", "2024-07-29 10:36:25", "سطح موجودی کاهش یافت: گوشی موبایل شیائومی مدل POCO F3 5G - قرمز, نوکیا (#4142)<span class=\"description\"></span> 2&rarr;1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("182", "4464", "ووکامرس", "", "", "", "2024-07-29 10:36:25", "2024-07-29 10:36:25", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("183", "4465", "ووکامرس", "", "", "", "2024-07-30 15:00:26", "2024-07-30 15:00:26", "نگهداری سهام 60 دقیقه روی <br>- ساعت هوشمند هاوایی (#3486) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("184", "4465", "ووکامرس", "", "", "", "2024-07-30 15:00:26", "2024-07-30 15:00:26", "سطح موجودی کاهش یافت: ساعت هوشمند هاوایی (#3486) 3&rarr;2", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("185", "4465", "ووکامرس", "", "", "", "2024-07-30 15:00:26", "2024-07-30 15:00:26", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("186", "4466", "ووکامرس", "", "", "", "2024-07-30 16:52:12", "2024-07-30 16:52:12", "نگهداری سهام 60 دقیقه روی <br>- ساعت هوشمند هاوایی (#3486) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("187", "4466", "ووکامرس", "", "", "", "2024-07-30 16:52:12", "2024-07-30 16:52:12", "سطح موجودی کاهش یافت: ساعت هوشمند هاوایی (#3486) 2&rarr;1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("188", "4466", "ووکامرس", "", "", "", "2024-07-30 16:52:12", "2024-07-30 16:52:12", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("189", "4488", "ووکامرس", "", "", "", "2024-08-16 16:50:38", "2024-08-16 16:50:38", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) &times; 2<br>- گوشی موبایل سامسونگ a12 -56A (#3507) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("190", "4488", "ووکامرس", "", "", "", "2024-08-16 16:50:38", "2024-08-16 16:50:38", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 20&rarr;18, گوشی موبایل سامسونگ a12 -56A (#3507) 10&rarr;9", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("191", "4488", "ووکامرس", "", "", "", "2024-08-16 16:50:38", "2024-08-16 16:50:38", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("192", "4489", "ووکامرس", "", "", "", "2024-08-21 09:14:29", "2024-08-21 09:14:29", "نگهداری سهام 60 دقیقه روی <br>- ساعت هوشمند هاوایی (#3486) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("193", "4489", "ووکامرس", "", "", "", "2024-08-21 09:14:29", "2024-08-21 09:14:29", "سطح موجودی کاهش یافت: ساعت هوشمند هاوایی (#3486) 1&rarr;0", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("194", "4489", "ووکامرس", "", "", "", "2024-08-21 09:14:29", "2024-08-21 09:14:29", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("195", "4490", "ووکامرس", "", "", "", "2024-08-27 21:00:18", "2024-08-27 21:00:18", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("196", "4491", "ووکامرس", "", "", "", "2024-08-29 11:31:34", "2024-08-29 11:31:34", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("197", "4491", "ووکامرس", "", "", "", "2024-08-29 11:31:34", "2024-08-29 11:31:34", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 18&rarr;17", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("198", "4491", "ووکامرس", "", "", "", "2024-08-29 11:31:34", "2024-08-29 11:31:34", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("200", "4493", "ووکامرس", "", "", "", "2024-09-01 09:48:09", "2024-09-01 09:48:09", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل سامسونگ a12 -56A (#3507) &times; 2 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("201", "4493", "ووکامرس", "", "", "", "2024-09-01 09:48:09", "2024-09-01 09:48:09", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ a12 -56A (#3507) 9&rarr;7", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("202", "4493", "ووکامرس", "", "", "", "2024-09-01 09:48:09", "2024-09-01 09:48:09", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("203", "4496", "ووکامرس", "", "", "", "2024-09-07 12:26:47", "2024-09-07 12:26:47", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("204", "4497", "ووکامرس", "", "", "", "2024-09-10 15:00:08", "2024-09-10 15:00:08", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("205", "4497", "ووکامرس", "", "", "", "2024-09-10 15:00:09", "2024-09-10 15:00:09", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 17&rarr;16", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("206", "4497", "ووکامرس", "", "", "", "2024-09-10 15:00:09", "2024-09-10 15:00:09", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("207", "4506", "ووکامرس", "", "", "", "2024-10-06 17:16:55", "2024-10-06 17:16:55", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل شیائومی مدل POCO F3 5G - آبی, شیائومی (#4133)<span class=\"description\"></span> &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("208", "4506", "ووکامرس", "", "", "", "2024-10-06 17:16:56", "2024-10-06 17:16:56", "سطح موجودی کاهش یافت: گوشی موبایل شیائومی مدل POCO F3 5G - آبی, شیائومی (#4133)<span class=\"description\"></span> 1&rarr;0", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("209", "4506", "ووکامرس", "", "", "", "2024-10-06 17:16:56", "2024-10-06 17:16:56", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("210", "4513", "ووکامرس", "", "", "", "2024-10-28 02:01:57", "2024-10-28 03:01:57", "نگهداری سهام 60 دقیقه روی <br>- ساعت هوشمند هاوایی (#3486) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("211", "4513", "ووکامرس", "", "", "", "2024-10-28 02:01:57", "2024-10-28 03:01:57", "سطح موجودی کاهش یافت: ساعت هوشمند هاوایی (#3486) 15&rarr;14", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("212", "4513", "ووکامرس", "", "", "", "2024-10-28 02:01:57", "2024-10-28 03:01:57", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("213", "4531", "ووکامرس", "", "", "", "2024-11-06 14:09:26", "2024-11-06 15:09:26", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل شیائومی مدل POCO F3 5G (#3516) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("214", "4531", "ووکامرس", "", "", "", "2024-11-06 14:09:26", "2024-11-06 15:09:26", "سطح موجودی کاهش یافت: گوشی موبایل شیائومی مدل POCO F3 5G (#3516) 10&rarr;9", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("215", "4531", "ووکامرس", "", "", "", "2024-11-06 14:09:26", "2024-11-06 15:09:26", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("216", "4551", "ووکامرس", "", "", "", "2024-11-16 07:56:36", "2024-11-16 08:56:36", "نگهداری سهام 60 دقیقه روی <br>- ساعت هوشمند سامسونگ (#3484) &times; 1<br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("217", "4551", "ووکامرس", "", "", "", "2024-11-16 07:56:36", "2024-11-16 08:56:36", "سطح موجودی کاهش یافت: ساعت هوشمند سامسونگ (#3484) 10&rarr;9, گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 16&rarr;15", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("218", "4551", "ووکامرس", "", "", "", "2024-11-16 07:56:36", "2024-11-16 08:56:36", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("219", "4552", "ووکامرس", "", "", "", "2024-11-17 06:18:59", "2024-11-17 07:18:59", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل سامسونگ a12 -56A (#3507) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("220", "4552", "ووکامرس", "", "", "", "2024-11-17 06:18:59", "2024-11-17 07:18:59", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ a12 -56A (#3507) 7&rarr;6", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("221", "4552", "ووکامرس", "", "", "", "2024-11-17 06:18:59", "2024-11-17 07:18:59", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("222", "4553", "ووکامرس", "", "", "", "2024-11-18 13:46:06", "2024-11-18 14:46:06", "نگهداری سهام 60 دقیقه روی <br>- گوشی موبایل شیائومی مدل POCO F3 5G (#3516) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("223", "4553", "ووکامرس", "", "", "", "2024-11-18 13:46:06", "2024-11-18 14:46:06", "سطح موجودی کاهش یافت: گوشی موبایل شیائومی مدل POCO F3 5G (#3516) 9&rarr;8", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("224", "4553", "ووکامرس", "", "", "", "2024-11-18 13:46:06", "2024-11-18 14:46:06", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("225", "4554", "ووکامرس", "", "", "", "2024-11-18 15:42:45", "2024-11-18 16:42:45", "نگهداری سهام 60 دقیقه روی <br>- ساعت هوشمند سامسونگ (#3484) &times; 1 اعمال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("226", "4554", "ووکامرس", "", "", "", "2024-11-18 15:42:45", "2024-11-18 16:42:45", "سطح موجودی کاهش یافت: ساعت هوشمند سامسونگ (#3484) 9&rarr;8", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("227", "4554", "ووکامرس", "", "", "", "2024-11-18 15:42:45", "2024-11-18 16:42:45", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("228", "4573", "ووکامرس", "", "", "", "2024-11-29 11:38:00", "2024-11-29 12:38:00", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- گوشی موبایل شیائومی مدل POCO F3 5G (#3516) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("229", "4573", "ووکامرس", "", "", "", "2024-11-29 11:38:00", "2024-11-29 12:38:00", "سطح موجودی کاهش یافت: گوشی موبایل شیائومی مدل POCO F3 5G (#3516) 8&rarr;7", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("230", "4573", "ووکامرس", "", "", "", "2024-11-29 11:38:00", "2024-11-29 12:38:00", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("231", "4778", "ووکامرس", "", "", "", "2024-12-08 13:42:10", "2024-12-08 14:42:10", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("232", "4778", "ووکامرس", "", "", "", "2024-12-08 13:42:11", "2024-12-08 14:42:11", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 15&rarr;14", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("233", "4778", "ووکامرس", "", "", "", "2024-12-08 13:42:11", "2024-12-08 14:42:11", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("234", "4889", "ووکامرس", "", "", "", "2024-12-11 15:47:57", "2024-12-11 16:47:57", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- گوشی موبایل سامسونگ a12 -56A (#3507) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("235", "4889", "ووکامرس", "", "", "", "2024-12-11 15:47:57", "2024-12-11 16:47:57", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ a12 -56A (#3507) 6&rarr;5", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("236", "4889", "ووکامرس", "", "", "", "2024-12-11 15:47:57", "2024-12-11 16:47:57", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("237", "5087", "admina", "info@dev-wp.ir", "", "", "2025-01-02 20:06:55", "2025-01-02 21:06:55", "موارد اضافه شده: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510), ساعت هوشمندa21 جدید (#3455), گوشی مدل POCO F3 5G - قرمز, شیائومی (#4141)<span class=\"description\"></span>", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("238", "5088", "ووکامرس", "", "", "", "2025-01-03 18:38:12", "2025-01-03 19:38:12", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- گوشی موبایل شیائومی مدل POCO F3 5G (#3516) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("239", "5088", "ووکامرس", "", "", "", "2025-01-03 18:38:12", "2025-01-03 19:38:12", "سطح موجودی کاهش یافت: گوشی موبایل شیائومی مدل POCO F3 5G (#3516) 7&rarr;6", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("240", "5088", "ووکامرس", "", "", "", "2025-01-03 18:38:12", "2025-01-03 19:38:12", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("241", "5090", "ووکامرس", "", "", "", "2025-01-04 09:59:06", "2025-01-04 10:59:06", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- گوشی موبایل سامسونگ a12 -56A (#3507) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("242", "5090", "ووکامرس", "", "", "", "2025-01-04 09:59:07", "2025-01-04 10:59:07", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ a12 -56A (#3507) 5&rarr;4", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("243", "5090", "ووکامرس", "", "", "", "2025-01-04 09:59:07", "2025-01-04 10:59:07", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("244", "5100", "ووکامرس", "", "", "", "2025-01-16 20:43:11", "2025-01-16 21:43:11", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- ساعت هوشمند هاوایی (#3486) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("245", "5100", "ووکامرس", "", "", "", "2025-01-16 20:43:11", "2025-01-16 21:43:11", "سطح موجودی کاهش یافت: ساعت هوشمند هاوایی (#3486) 14&rarr;13", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("246", "5100", "ووکامرس", "", "", "", "2025-01-16 20:43:11", "2025-01-16 21:43:11", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("249", "5101", "ووکامرس", "", "", "", "2025-02-02 08:57:34", "2025-02-02 09:57:34", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- گوشی مدل POCO F3 5G (#3519) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("250", "5101", "ووکامرس", "", "", "", "2025-02-02 08:57:34", "2025-02-02 09:57:34", "سطح موجودی کاهش یافت: گوشی مدل POCO F3 5G (#3519) 14&rarr;13", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("251", "5101", "ووکامرس", "", "", "", "2025-02-02 08:57:34", "2025-02-02 09:57:34", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("252", "5102", "ووکامرس", "", "", "", "2025-02-02 09:04:17", "2025-02-02 10:04:17", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- گوشی موبایل سامسونگ a12 -56A (#3507) &times; 4<br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) &times; 14<br>- گوشی موبایل شیائومی مدل POCO F3 5G (#3516) &times; 6", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("253", "5102", "ووکامرس", "", "", "", "2025-02-02 09:04:18", "2025-02-02 10:04:18", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ a12 -56A (#3507) 4&rarr;0, گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 14&rarr;0, گوشی موبایل شیائومی مدل POCO F3 5G (#3516) 6&rarr;0", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("254", "5102", "ووکامرس", "", "", "", "2025-02-02 09:04:18", "2025-02-02 10:04:18", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("255", "5109", "ووکامرس", "", "", "", "2025-02-10 15:07:26", "2025-02-10 16:07:26", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- ساعت هوشمند هاوایی (#3486) &times; 1<br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("256", "5109", "ووکامرس", "", "", "", "2025-02-10 15:07:26", "2025-02-10 16:07:26", "سطح موجودی کاهش یافت: ساعت هوشمند هاوایی (#3486) 13&rarr;12, گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 15&rarr;14", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("257", "5109", "ووکامرس", "", "", "", "2025-02-10 15:07:26", "2025-02-10 16:07:26", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("258", "5110", "ووکامرس", "", "", "", "2025-02-10 15:07:40", "2025-02-10 16:07:40", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- ساعت هوشمند هاوایی (#3486) &times; 1<br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("259", "5110", "ووکامرس", "", "", "", "2025-02-10 15:07:40", "2025-02-10 16:07:40", "سطح موجودی کاهش یافت: ساعت هوشمند هاوایی (#3486) 12&rarr;11, گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 14&rarr;13", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("260", "5110", "ووکامرس", "", "", "", "2025-02-10 15:07:40", "2025-02-10 16:07:40", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("261", "5111", "ووکامرس", "", "", "", "2025-02-10 15:07:46", "2025-02-10 16:07:46", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- ساعت هوشمند هاوایی (#3486) &times; 1<br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("262", "5111", "ووکامرس", "", "", "", "2025-02-10 15:07:46", "2025-02-10 16:07:46", "سطح موجودی کاهش یافت: ساعت هوشمند هاوایی (#3486) 11&rarr;10, گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 13&rarr;12", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("263", "5111", "ووکامرس", "", "", "", "2025-02-10 15:07:46", "2025-02-10 16:07:46", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("264", "5115", "ووکامرس", "", "", "", "2025-02-16 20:56:59", "2025-02-16 21:56:59", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- گوشی مدل POCO F3 5G (#3519) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("265", "5115", "ووکامرس", "", "", "", "2025-02-16 20:56:59", "2025-02-16 21:56:59", "سطح موجودی کاهش یافت: گوشی مدل POCO F3 5G (#3519) 13&rarr;12", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("266", "5115", "ووکامرس", "", "", "", "2025-02-16 20:56:59", "2025-02-16 21:56:59", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("267", "5116", "ووکامرس", "", "", "", "2025-02-16 20:59:26", "2025-02-16 21:59:26", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- گوشی مدل POCO F3 5G (#3519) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("268", "5116", "ووکامرس", "", "", "", "2025-02-16 20:59:26", "2025-02-16 21:59:26", "سطح موجودی کاهش یافت: گوشی مدل POCO F3 5G (#3519) 12&rarr;11", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("269", "5116", "ووکامرس", "", "", "", "2025-02-16 20:59:26", "2025-02-16 21:59:26", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("270", "5117", "ووکامرس", "", "", "", "2025-02-22 06:03:53", "2025-02-22 07:03:53", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- گوشی موبایل شیائومی مدل POCO F3 5G (#3516) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("271", "5117", "ووکامرس", "", "", "", "2025-02-22 06:03:53", "2025-02-22 07:03:53", "سطح موجودی کاهش یافت: گوشی موبایل شیائومی مدل POCO F3 5G (#3516) 16&rarr;15", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("272", "5117", "ووکامرس", "", "", "", "2025-02-22 06:03:53", "2025-02-22 07:03:53", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("273", "5118", "ووکامرس", "", "", "", "2025-02-22 06:04:05", "2025-02-22 07:04:05", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- گوشی موبایل شیائومی مدل POCO F3 5G (#3516) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("274", "5118", "ووکامرس", "", "", "", "2025-02-22 06:04:05", "2025-02-22 07:04:05", "سطح موجودی کاهش یافت: گوشی موبایل شیائومی مدل POCO F3 5G (#3516) 15&rarr;14", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("275", "5118", "ووکامرس", "", "", "", "2025-02-22 06:04:05", "2025-02-22 07:04:05", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("276", "5119", "ووکامرس", "", "", "", "2025-02-26 14:02:10", "2025-02-26 15:02:10", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("277", "5119", "ووکامرس", "", "", "", "2025-02-26 14:02:10", "2025-02-26 15:02:10", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 12&rarr;11", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("278", "5119", "ووکامرس", "", "", "", "2025-02-26 14:02:10", "2025-02-26 15:02:10", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("279", "5120", "ووکامرس", "", "", "", "2025-02-26 14:02:28", "2025-02-26 15:02:28", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("280", "5120", "ووکامرس", "", "", "", "2025-02-26 14:02:28", "2025-02-26 15:02:28", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 11&rarr;10", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("281", "5120", "ووکامرس", "", "", "", "2025-02-26 14:02:28", "2025-02-26 15:02:28", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("282", "5122", "ووکامرس", "", "", "", "2025-03-05 01:31:32", "2025-03-05 02:31:32", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) &times; 2<br>- گوشی موبایل شیائومی مدل POCO F3 5G (#3516) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("283", "5122", "ووکامرس", "", "", "", "2025-03-05 01:31:32", "2025-03-05 02:31:32", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 10&rarr;8, گوشی موبایل شیائومی مدل POCO F3 5G (#3516) 14&rarr;13", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("284", "5122", "ووکامرس", "", "", "", "2025-03-05 01:31:32", "2025-03-05 02:31:32", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("285", "5123", "ووکامرس", "", "", "", "2025-03-05 01:33:20", "2025-03-05 02:33:20", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- ساعت هوشمند سامسونگ (#3484) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("286", "5123", "ووکامرس", "", "", "", "2025-03-05 01:33:20", "2025-03-05 02:33:20", "سطح موجودی کاهش یافت: ساعت هوشمند سامسونگ (#3484) 8&rarr;7", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("287", "5123", "ووکامرس", "", "", "", "2025-03-05 01:33:20", "2025-03-05 02:33:20", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("288", "5124", "ووکامرس", "", "", "", "2025-03-05 01:33:26", "2025-03-05 02:33:26", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- ساعت هوشمند سامسونگ (#3484) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("289", "5124", "ووکامرس", "", "", "", "2025-03-05 01:33:26", "2025-03-05 02:33:26", "سطح موجودی کاهش یافت: ساعت هوشمند سامسونگ (#3484) 7&rarr;6", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("290", "5124", "ووکامرس", "", "", "", "2025-03-05 01:33:26", "2025-03-05 02:33:26", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("291", "5126", "ووکامرس", "", "", "", "2025-03-05 01:35:52", "2025-03-05 02:35:52", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("292", "5126", "ووکامرس", "", "", "", "2025-03-05 01:35:52", "2025-03-05 02:35:52", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 8&rarr;7", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("293", "5126", "ووکامرس", "", "", "", "2025-03-05 01:35:52", "2025-03-05 02:35:52", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("294", "5127", "ووکامرس", "", "", "", "2025-03-05 01:37:50", "2025-03-05 02:37:50", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- ساعت هوشمند سامسونگ (#3484) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("295", "5127", "ووکامرس", "", "", "", "2025-03-05 01:37:50", "2025-03-05 02:37:50", "سطح موجودی کاهش یافت: ساعت هوشمند سامسونگ (#3484) 6&rarr;5", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("296", "5127", "ووکامرس", "", "", "", "2025-03-05 01:37:50", "2025-03-05 02:37:50", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("297", "5128", "ووکامرس", "", "", "", "2025-03-05 01:47:09", "2025-03-05 02:47:09", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- گوشی موبایل شیائومی مدل POCO F3 5G (#3516) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("298", "5128", "ووکامرس", "", "", "", "2025-03-05 01:47:09", "2025-03-05 02:47:09", "سطح موجودی کاهش یافت: گوشی موبایل شیائومی مدل POCO F3 5G (#3516) 13&rarr;12", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("299", "5128", "ووکامرس", "", "", "", "2025-03-05 01:47:09", "2025-03-05 02:47:09", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("300", "5129", "ووکامرس", "", "", "", "2025-03-05 01:54:40", "2025-03-05 02:54:40", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- ساعت هوشمند سامسونگ (#3484) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("301", "5129", "ووکامرس", "", "", "", "2025-03-05 01:54:40", "2025-03-05 02:54:40", "سطح موجودی کاهش یافت: ساعت هوشمند سامسونگ (#3484) 5&rarr;4", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("302", "5129", "ووکامرس", "", "", "", "2025-03-05 01:54:40", "2025-03-05 02:54:40", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("303", "5130", "ووکامرس", "", "", "", "2025-03-05 01:56:03", "2025-03-05 02:56:03", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- ساعت هوشمند سامسونگ (#3484) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("304", "5130", "ووکامرس", "", "", "", "2025-03-05 01:56:03", "2025-03-05 02:56:03", "سطح موجودی کاهش یافت: ساعت هوشمند سامسونگ (#3484) 4&rarr;3", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("305", "5130", "ووکامرس", "", "", "", "2025-03-05 01:56:03", "2025-03-05 02:56:03", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("306", "5131", "ووکامرس", "", "", "", "2025-03-05 01:59:42", "2025-03-05 02:59:42", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- ساعت هوشمند سامسونگ (#3484) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("307", "5131", "ووکامرس", "", "", "", "2025-03-05 01:59:43", "2025-03-05 02:59:43", "سطح موجودی کاهش یافت: ساعت هوشمند سامسونگ (#3484) 3&rarr;2", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("308", "5131", "ووکامرس", "", "", "", "2025-03-05 01:59:43", "2025-03-05 02:59:43", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("309", "5132", "ووکامرس", "", "", "", "2025-03-05 02:00:30", "2025-03-05 03:00:30", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- ساعت هوشمند سامسونگ (#3484) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("310", "5132", "ووکامرس", "", "", "", "2025-03-05 02:00:30", "2025-03-05 03:00:30", "سطح موجودی کاهش یافت: ساعت هوشمند سامسونگ (#3484) 2&rarr;1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("311", "5132", "ووکامرس", "", "", "", "2025-03-05 02:00:30", "2025-03-05 03:00:30", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("312", "5147", "ووکامرس", "", "", "", "2025-03-05 02:18:37", "2025-03-05 03:18:37", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("313", "5147", "ووکامرس", "", "", "", "2025-03-05 02:18:37", "2025-03-05 03:18:37", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 7&rarr;6", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("314", "5147", "ووکامرس", "", "", "", "2025-03-05 02:18:37", "2025-03-05 03:18:37", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("315", "5148", "ووکامرس", "", "", "", "2025-03-05 02:19:56", "2025-03-05 03:19:56", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("316", "5148", "ووکامرس", "", "", "", "2025-03-05 02:19:56", "2025-03-05 03:19:56", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 6&rarr;5", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("317", "5148", "ووکامرس", "", "", "", "2025-03-05 02:19:56", "2025-03-05 03:19:56", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("318", "5149", "ووکامرس", "", "", "", "2025-03-05 02:20:55", "2025-03-05 03:20:55", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("319", "5149", "ووکامرس", "", "", "", "2025-03-05 02:20:55", "2025-03-05 03:20:55", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 5&rarr;4", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("320", "5149", "ووکامرس", "", "", "", "2025-03-05 02:20:55", "2025-03-05 03:20:55", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("321", "5151", "ووکامرس", "", "", "", "2025-03-05 02:27:50", "2025-03-05 03:27:50", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("322", "5151", "ووکامرس", "", "", "", "2025-03-05 02:27:51", "2025-03-05 03:27:51", "پیامک با موفقیت برای مدیر با شماره () ارسال شد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("323", "5151", "admina", "info@dev-wp.ir", "", "", "2025-03-05 02:39:03", "2025-03-05 03:39:03", "وضعیت سفارش از در حال انجام به تکمیل شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("324", "5132", "admina", "info@dev-wp.ir", "", "", "2025-03-05 02:40:20", "2025-03-05 03:40:20", "وضعیت سفارش از در انتظار بررسی به تکمیل شده تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("325", "5152", "ووکامرس", "", "", "", "2025-03-05 03:40:51", "2025-03-05 04:40:51", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- گوشی موبایل شیائومی مدل POCO F3 5G (#3516) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("326", "5152", "ووکامرس", "", "", "", "2025-03-05 03:40:51", "2025-03-05 04:40:51", "سطح موجودی کاهش یافت: گوشی موبایل شیائومی مدل POCO F3 5G (#3516) 12&rarr;11", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("327", "5152", "ووکامرس", "", "", "", "2025-03-05 03:40:51", "2025-03-05 04:40:51", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("328", "5153", "ووکامرس", "", "", "", "2025-03-05 05:22:02", "2025-03-05 06:22:02", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) &times; 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("329", "5153", "ووکامرس", "", "", "", "2025-03-05 05:22:02", "2025-03-05 06:22:02", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 4&rarr;3", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("330", "5153", "ووکامرس", "", "", "", "2025-03-05 05:22:02", "2025-03-05 06:22:02", "پرداخت پس از تحویل وضعیت سفارش از در انتظار پرداخت به در حال انجام تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("331", "5153", "ووکامرس", "", "", "", "2025-03-05 05:22:04", "2025-03-05 06:22:04", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("332", "5158", "ووکامرس", "", "", "", "2025-03-08 02:37:51", "2025-03-08 03:37:51", "Stock hold of 60 minutes applied to: <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) × 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("333", "5158", "ووکامرس", "", "", "", "2025-03-08 02:37:52", "2025-03-08 03:37:52", "میزان موجودی کاهش یافته: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 3&rarr;2", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("334", "5158", "ووکامرس", "", "", "", "2025-03-08 02:37:52", "2025-03-08 03:37:52", "در حال انتظار بررسی پرداخت وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("335", "5158", "ووکامرس", "", "", "", "2025-03-08 02:37:52", "2025-03-08 03:37:52", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("336", "5158", "ووکامرس", "", "", "", "2025-03-08 02:37:52", "2025-03-08 03:37:52", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("337", "5159", "ووکامرس", "", "", "", "2025-03-09 15:40:56", "2025-03-09 16:40:56", "Stock hold of 60 minutes applied to: <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) × 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("338", "5159", "ووکامرس", "", "", "", "2025-03-09 15:40:56", "2025-03-09 16:40:56", "میزان موجودی کاهش یافته: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 2&rarr;1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("339", "5159", "ووکامرس", "", "", "", "2025-03-09 15:40:56", "2025-03-09 16:40:56", "در حال انتظار بررسی پرداخت وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("340", "5159", "ووکامرس", "", "", "", "2025-03-09 15:40:56", "2025-03-09 16:40:56", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("341", "5159", "ووکامرس", "", "", "", "2025-03-09 15:40:56", "2025-03-09 16:40:56", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("342", "5171", "ووکامرس", "", "", "", "2025-03-23 10:12:17", "2025-03-23 11:12:17", "Stock hold of 60 minutes applied to: <br>- گوشی موبایل سامسونگ a12 -56A (#3507) × 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("343", "5171", "ووکامرس", "", "", "", "2025-03-23 10:12:18", "2025-03-23 11:12:18", "میزان موجودی کاهش یافته: گوشی موبایل سامسونگ a12 -56A (#3507) 10&rarr;9", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("344", "5171", "ووکامرس", "", "", "", "2025-03-23 10:12:18", "2025-03-23 11:12:18", "در حال انتظار بررسی پرداخت وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("345", "5171", "ووکامرس", "", "", "", "2025-03-23 10:12:18", "2025-03-23 11:12:18", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("346", "5171", "ووکامرس", "", "", "", "2025-03-23 10:12:18", "2025-03-23 11:12:18", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("347", "5176", "ووکامرس", "", "", "", "2025-03-29 07:06:52", "2025-03-29 08:06:52", "Stock hold of 60 minutes applied to: <br>- گوشی موبایل شیائومی مدل POCO F3 5G (#3516) × 1<br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) × 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("348", "5176", "ووکامرس", "", "", "", "2025-03-29 07:06:53", "2025-03-29 08:06:53", "میزان موجودی کاهش یافته: گوشی موبایل شیائومی مدل POCO F3 5G (#3516) 11&rarr;10, گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 1&rarr;0", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("349", "5176", "ووکامرس", "", "", "", "2025-03-29 07:06:53", "2025-03-29 08:06:53", "در حال انتظار بررسی پرداخت وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("350", "5176", "ووکامرس", "", "", "", "2025-03-29 07:06:53", "2025-03-29 08:06:53", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("351", "5176", "ووکامرس", "", "", "", "2025-03-29 07:06:53", "2025-03-29 08:06:53", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("352", "5177", "ووکامرس", "", "", "", "2025-04-05 14:39:04", "2025-04-05 14:39:04", "Stock hold of 60 minutes applied to: <br>- ساعت هوشمند سامسونگ (#3484) × 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("353", "5177", "ووکامرس", "", "", "", "2025-04-05 14:39:05", "2025-04-05 14:39:05", "میزان موجودی کاهش یافته: ساعت هوشمند سامسونگ (#3484) 1&rarr;0", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("354", "5177", "ووکامرس", "", "", "", "2025-04-05 14:39:05", "2025-04-05 14:39:05", "در حال انتظار بررسی پرداخت وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("355", "5177", "ووکامرس", "", "", "", "2025-04-05 14:39:05", "2025-04-05 14:39:05", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("356", "5177", "ووکامرس", "", "", "", "2025-04-05 14:39:05", "2025-04-05 14:39:05", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("357", "5178", "ووکامرس", "", "", "", "2025-04-08 04:39:49", "2025-04-08 04:39:49", "Stock hold of 60 minutes applied to: <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) × 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("358", "5178", "ووکامرس", "", "", "", "2025-04-08 04:39:49", "2025-04-08 04:39:49", "میزان موجودی کاهش یافته: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 10&rarr;9", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("359", "5178", "ووکامرس", "", "", "", "2025-04-08 04:39:49", "2025-04-08 04:39:49", "در حال انتظار بررسی پرداخت وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("360", "5178", "ووکامرس", "", "", "", "2025-04-08 04:39:49", "2025-04-08 04:39:49", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("361", "5178", "ووکامرس", "", "", "", "2025-04-08 04:39:49", "2025-04-08 04:39:49", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("362", "5219", "ووکامرس", "", "", "", "2025-04-09 08:38:35", "2025-04-09 08:38:35", "Stock hold of 60 minutes applied to: <br>- گوشی موبایل سامسونگ a12 -56A (#3507) × 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("363", "5219", "ووکامرس", "", "", "", "2025-04-09 08:38:35", "2025-04-09 08:38:35", "میزان موجودی کاهش یافته: گوشی موبایل سامسونگ a12 -56A (#3507) 9&rarr;8", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("364", "5219", "ووکامرس", "", "", "", "2025-04-09 08:38:35", "2025-04-09 08:38:35", "در حال انتظار بررسی پرداخت وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("365", "5219", "ووکامرس", "", "", "", "2025-04-09 08:38:35", "2025-04-09 08:38:35", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("366", "5219", "ووکامرس", "", "", "", "2025-04-09 08:38:35", "2025-04-09 08:38:35", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("367", "5220", "ووکامرس", "", "", "", "2025-04-13 11:28:29", "2025-04-13 11:28:29", "Stock hold of 60 minutes applied to: <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) × 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("368", "5220", "ووکامرس", "", "", "", "2025-04-13 11:28:29", "2025-04-13 11:28:29", "میزان موجودی کاهش یافته: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 9&rarr;8", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("369", "5220", "ووکامرس", "", "", "", "2025-04-13 11:28:29", "2025-04-13 11:28:29", "در حال انتظار بررسی پرداخت وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("370", "5227", "ووکامرس", "", "", "", "2025-04-20 14:10:17", "2025-04-20 14:10:17", "Stock hold of 60 minutes applied to: <br>- گوشی موبایل شیائومی مدل POCO F3 5G (#3516) × 1<br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) × 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("371", "5227", "ووکامرس", "", "", "", "2025-04-20 14:10:17", "2025-04-20 14:10:17", "میزان موجودی کاهش یافته: گوشی موبایل شیائومی مدل POCO F3 5G (#3516) 10&rarr;9, گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 8&rarr;7", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("372", "5227", "ووکامرس", "", "", "", "2025-04-20 14:10:17", "2025-04-20 14:10:17", "در حال انتظار بررسی پرداخت وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("373", "5229", "ووکامرس", "", "", "", "2025-04-29 15:24:00", "2025-04-29 15:24:00", "Stock hold of 60 minutes applied to: <br>- ساعت هوشمند سامسونگ (#3484) × 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("374", "5229", "ووکامرس", "", "", "", "2025-04-29 15:24:00", "2025-04-29 15:24:00", "میزان موجودی کاهش یافته: ساعت هوشمند سامسونگ (#3484) 55&rarr;54", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("375", "5229", "ووکامرس", "", "", "", "2025-04-29 15:24:00", "2025-04-29 15:24:00", "در حال انتظار بررسی پرداخت وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("376", "5229", "ووکامرس", "", "", "", "2025-04-29 15:24:00", "2025-04-29 15:24:00", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("377", "5229", "ووکامرس", "", "", "", "2025-04-29 15:24:00", "2025-04-29 15:24:00", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("378", "5230", "ووکامرس", "", "", "", "2025-05-03 08:26:19", "2025-05-03 08:26:19", "Stock hold of 60 minutes applied to: <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) × 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("379", "5230", "ووکامرس", "", "", "", "2025-05-03 08:26:19", "2025-05-03 08:26:19", "میزان موجودی کاهش یافته: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 7&rarr;6", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("380", "5230", "ووکامرس", "", "", "", "2025-05-03 08:26:19", "2025-05-03 08:26:19", "در حال انتظار بررسی پرداخت وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("381", "5230", "ووکامرس", "", "", "", "2025-05-03 08:26:19", "2025-05-03 08:26:19", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("382", "5230", "ووکامرس", "", "", "", "2025-05-03 08:26:19", "2025-05-03 08:26:19", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("383", "5231", "ووکامرس", "", "", "", "2025-05-03 09:50:40", "2025-05-03 09:50:40", "Stock hold of 60 minutes applied to: <br>- گوشی موبایل شیائومی مدل POCO F3 5G (#3516) × 9<br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) × 3<br>- ساعت هوشمند هاوایی (#3486) × 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("384", "5231", "ووکامرس", "", "", "", "2025-05-03 09:50:41", "2025-05-03 09:50:41", "میزان موجودی کاهش یافته: گوشی موبایل شیائومی مدل POCO F3 5G (#3516) 9&rarr;0, گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 6&rarr;3, ساعت هوشمند هاوایی (#3486) 10&rarr;9", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("385", "5231", "ووکامرس", "", "", "", "2025-05-03 09:50:41", "2025-05-03 09:50:41", "در حال انتظار بررسی پرداخت وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("386", "5231", "ووکامرس", "", "", "", "2025-05-03 09:50:41", "2025-05-03 09:50:41", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("387", "5231", "ووکامرس", "", "", "", "2025-05-03 09:50:41", "2025-05-03 09:50:41", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("388", "5232", "ووکامرس", "", "", "", "2025-05-05 07:39:11", "2025-05-05 07:39:11", "Stock hold of 60 minutes applied to: <br>- گوشی موبایل سامسونگ a12 -56A (#3507) × 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("389", "5232", "ووکامرس", "", "", "", "2025-05-05 07:39:11", "2025-05-05 07:39:11", "میزان موجودی کاهش یافته: گوشی موبایل سامسونگ a12 -56A (#3507) 8&rarr;7", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("390", "5232", "ووکامرس", "", "", "", "2025-05-05 07:39:11", "2025-05-05 07:39:11", "در حال انتظار بررسی پرداخت وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("391", "5232", "ووکامرس", "", "", "", "2025-05-05 07:39:11", "2025-05-05 07:39:11", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("392", "5232", "ووکامرس", "", "", "", "2025-05-05 07:39:11", "2025-05-05 07:39:11", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("393", "5233", "ووکامرس", "", "", "", "2025-05-07 17:33:49", "2025-05-07 17:33:49", "Stock hold of 60 minutes applied to: <br>- ساعت هوشمند هاوایی (#3486) × 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("394", "5233", "ووکامرس", "", "", "", "2025-05-07 17:33:49", "2025-05-07 17:33:49", "میزان موجودی کاهش یافته: ساعت هوشمند هاوایی (#3486) 9&rarr;8", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("395", "5233", "ووکامرس", "", "", "", "2025-05-07 17:33:49", "2025-05-07 17:33:49", "در حال انتظار بررسی پرداخت وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("396", "5233", "ووکامرس", "", "", "", "2025-05-07 17:33:49", "2025-05-07 17:33:49", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("397", "5233", "ووکامرس", "", "", "", "2025-05-07 17:33:49", "2025-05-07 17:33:49", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("398", "5260", "ووکامرس", "", "", "", "2025-05-31 10:46:52", "2025-05-31 10:46:52", "Stock hold of 60 minutes applied to: <br>- ساعت هوشمند هاوایی (#3486) × 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("399", "5260", "ووکامرس", "", "", "", "2025-05-31 10:46:52", "2025-05-31 10:46:52", "میزان موجودی کاهش یافته: ساعت هوشمند هاوایی (#3486) 8&rarr;7", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("400", "5260", "ووکامرس", "", "", "", "2025-05-31 10:46:52", "2025-05-31 10:46:52", "در حال انتظار بررسی پرداخت وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("401", "5260", "ووکامرس", "", "", "", "2025-05-31 10:46:52", "2025-05-31 10:46:52", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("402", "5260", "ووکامرس", "", "", "", "2025-05-31 10:46:52", "2025-05-31 10:46:52", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("403", "5278", "ووکامرس", "", "", "", "2025-06-10 20:11:35", "2025-06-10 20:11:35", "Stock hold of 60 minutes applied to: <br>- گوشی مدل POCO F3 5G (#3519) × 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("404", "5278", "ووکامرس", "", "", "", "2025-06-10 20:11:36", "2025-06-10 20:11:36", "میزان موجودی کاهش یافته: گوشی مدل POCO F3 5G (#3519) 11&rarr;10", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("405", "5278", "ووکامرس", "", "", "", "2025-06-10 20:11:36", "2025-06-10 20:11:36", "در حال انتظار بررسی پرداخت وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("406", "5278", "ووکامرس", "", "", "", "2025-06-10 20:11:36", "2025-06-10 20:11:36", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("407", "5278", "ووکامرس", "", "", "", "2025-06-10 20:11:36", "2025-06-10 20:11:36", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("408", "5279", "ووکامرس", "", "", "", "2025-06-25 08:51:24", "2025-06-25 08:51:24", "Stock hold of 60 minutes applied to: <br>- ساعت هوشمند سامسونگ (#3484) × 54", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("409", "5279", "ووکامرس", "", "", "", "2025-06-25 08:51:25", "2025-06-25 08:51:25", "میزان موجودی کاهش یافته: ساعت هوشمند سامسونگ (#3484) 54&rarr;0", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("410", "5279", "ووکامرس", "", "", "", "2025-06-25 08:51:25", "2025-06-25 08:51:25", "در حال انتظار بررسی پرداخت وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("411", "5279", "ووکامرس", "", "", "", "2025-06-25 08:51:25", "2025-06-25 08:51:25", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("412", "5279", "ووکامرس", "", "", "", "2025-06-25 08:51:25", "2025-06-25 08:51:25", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("413", "5314", "ووکامرس", "", "", "", "2025-07-15 18:30:37", "2025-07-15 18:30:37", "Stock hold of 60 minutes applied to: <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) × 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("414", "5314", "ووکامرس", "", "", "", "2025-07-15 18:30:38", "2025-07-15 18:30:38", "میزان موجودی کاهش یافته: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 3&rarr;2", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("415", "5314", "ووکامرس", "", "", "", "2025-07-15 18:30:38", "2025-07-15 18:30:38", "در حال انتظار بررسی پرداخت وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("416", "5314", "ووکامرس", "", "", "", "2025-07-15 18:30:38", "2025-07-15 18:30:38", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("417", "5314", "ووکامرس", "", "", "", "2025-07-15 18:30:38", "2025-07-15 18:30:38", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("418", "5327", "ووکامرس", "", "", "", "2025-07-26 13:04:28", "2025-07-26 13:04:28", "Stock hold of 60 minutes applied to: <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) × 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("419", "5327", "ووکامرس", "", "", "", "2025-07-26 13:04:29", "2025-07-26 13:04:29", "میزان موجودی کاهش یافته: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 2&rarr;1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("420", "5327", "ووکامرس", "", "", "", "2025-07-26 13:04:29", "2025-07-26 13:04:29", "در حال انتظار بررسی پرداخت وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("421", "5327", "ووکامرس", "", "", "", "2025-07-26 13:04:29", "2025-07-26 13:04:29", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("422", "5327", "ووکامرس", "", "", "", "2025-07-26 13:04:29", "2025-07-26 13:04:29", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("423", "5328", "ووکامرس", "", "", "", "2025-07-26 20:25:04", "2025-07-26 20:25:04", "Stock hold of 60 minutes applied to: <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) × 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("424", "5328", "ووکامرس", "", "", "", "2025-07-26 20:25:05", "2025-07-26 20:25:05", "میزان موجودی کاهش یافته: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 1&rarr;0", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("425", "5328", "ووکامرس", "", "", "", "2025-07-26 20:25:05", "2025-07-26 20:25:05", "در حال انتظار بررسی پرداخت وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("426", "5328", "ووکامرس", "", "", "", "2025-07-26 20:25:05", "2025-07-26 20:25:05", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("427", "5328", "ووکامرس", "", "", "", "2025-07-26 20:25:05", "2025-07-26 20:25:05", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("429", "5329", "ووکامرس", "", "", "", "2025-08-02 12:19:04", "2025-08-02 12:19:04", "Stock hold of 60 minutes applied to: <br>- گوشی موبایل شیائومی مدل POCO F3 5G (#3516) × 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("430", "5329", "ووکامرس", "", "", "", "2025-08-02 12:19:04", "2025-08-02 12:19:04", "میزان موجودی کاهش یافته: گوشی موبایل شیائومی مدل POCO F3 5G (#3516) 25&rarr;24", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("431", "5329", "ووکامرس", "", "", "", "2025-08-02 12:19:04", "2025-08-02 12:19:04", "در حال انتظار بررسی پرداخت وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("432", "5329", "ووکامرس", "", "", "", "2025-08-02 12:19:04", "2025-08-02 12:19:04", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("433", "5329", "ووکامرس", "", "", "", "2025-08-02 12:19:04", "2025-08-02 12:19:04", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("434", "5330", "ووکامرس", "", "", "", "2025-08-04 06:35:18", "2025-08-04 06:35:18", "Stock hold of 60 minutes applied to: <br>- ساعت هوشمند هاوایی (#3486) × 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("435", "5330", "ووکامرس", "", "", "", "2025-08-04 06:35:18", "2025-08-04 06:35:18", "میزان موجودی کاهش یافته: ساعت هوشمند هاوایی (#3486) 7&rarr;6", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("436", "5330", "ووکامرس", "", "", "", "2025-08-04 06:35:18", "2025-08-04 06:35:18", "در حال انتظار بررسی پرداخت وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("437", "5330", "ووکامرس", "", "", "", "2025-08-04 06:35:18", "2025-08-04 06:35:18", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("438", "5330", "ووکامرس", "", "", "", "2025-08-04 06:35:18", "2025-08-04 06:35:18", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("439", "5333", "ووکامرس", "", "", "", "2025-08-08 13:54:23", "2025-08-08 13:54:23", "Stock hold of 60 minutes applied to: <br>- گوشی موبایل سامسونگ a12 -56A (#3507) × 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("440", "5333", "ووکامرس", "", "", "", "2025-08-08 13:54:23", "2025-08-08 13:54:23", "میزان موجودی کاهش یافته: گوشی موبایل سامسونگ a12 -56A (#3507) 7&rarr;6", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("441", "5333", "ووکامرس", "", "", "", "2025-08-08 13:54:23", "2025-08-08 13:54:23", "در حال انتظار بررسی پرداخت وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("442", "5333", "ووکامرس", "", "", "", "2025-08-08 13:54:23", "2025-08-08 13:54:23", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("443", "5333", "ووکامرس", "", "", "", "2025-08-08 13:54:23", "2025-08-08 13:54:23", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("444", "5334", "ووکامرس", "", "", "", "2025-08-08 13:55:23", "2025-08-08 13:55:23", "Stock hold of 60 minutes applied to: <br>- گوشی موبایل سامسونگ a12 -56A (#3507) × 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("445", "5334", "ووکامرس", "", "", "", "2025-08-08 13:55:23", "2025-08-08 13:55:23", "میزان موجودی کاهش یافته: گوشی موبایل سامسونگ a12 -56A (#3507) 6&rarr;5", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("446", "5334", "ووکامرس", "", "", "", "2025-08-08 13:55:23", "2025-08-08 13:55:23", "در حال انتظار بررسی پرداخت وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("447", "5334", "ووکامرس", "", "", "", "2025-08-08 13:55:23", "2025-08-08 13:55:23", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("448", "5334", "ووکامرس", "", "", "", "2025-08-08 13:55:23", "2025-08-08 13:55:23", "فایل اپراتور مورد نظر پیدا نشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("449", "5338", "ووکامرس", "", "", "", "2025-08-10 09:39:54", "2025-08-10 09:39:54", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- گوشی مدل POCO F3 5G (#3519) اقلام 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("450", "5338", "ووکامرس", "", "", "", "2025-08-10 09:39:54", "2025-08-10 09:39:54", "سطح موجودی کاهش یافت: گوشی مدل POCO F3 5G (#3519) 10&rarr;9", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("451", "5338", "ووکامرس", "", "", "", "2025-08-10 09:39:54", "2025-08-10 09:39:54", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("452", "5338", "ووکامرس", "", "", "", "2025-08-10 09:39:56", "2025-08-10 09:39:56", "مشکلی پیش آمده", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("453", "5338", "ووکامرس", "", "", "", "2025-08-10 09:39:56", "2025-08-10 09:39:56", "شماره موبایل ادمین ثبت نشده", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("454", "5361", "ووکامرس", "", "", "", "2025-08-25 13:46:22", "2025-08-25 13:46:22", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- ساعت هوشمند سامسونگ (#3484) اقلام 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("455", "5361", "ووکامرس", "", "", "", "2025-08-25 13:46:22", "2025-08-25 13:46:22", "سطح موجودی کاهش یافت: ساعت هوشمند سامسونگ (#3484) 10&rarr;9", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("456", "5361", "ووکامرس", "", "", "", "2025-08-25 13:46:22", "2025-08-25 13:46:22", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("457", "5361", "ووکامرس", "", "", "", "2025-08-25 13:46:23", "2025-08-25 13:46:23", "نام کاربری یا رمزعبور پنل اشتباه میباشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("458", "5361", "ووکامرس", "", "", "", "2025-08-25 13:46:23", "2025-08-25 13:46:23", "شماره موبایل ادمین ثبت نشده", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("460", "5362", "ووکامرس", "", "", "", "2025-09-06 03:26:32", "2025-09-06 03:26:32", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- گوشی موبایل سامسونگ a12 -56A (#3507) اقلام 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("461", "5362", "ووکامرس", "", "", "", "2025-09-06 03:26:32", "2025-09-06 03:26:32", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ a12 -56A (#3507) 5&rarr;4", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("462", "5362", "ووکامرس", "", "", "", "2025-09-06 03:26:32", "2025-09-06 03:26:32", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("463", "5362", "ووکامرس", "", "", "", "2025-09-06 03:26:33", "2025-09-06 03:26:33", "نام کاربری یا رمزعبور پنل اشتباه میباشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("464", "5362", "ووکامرس", "", "", "", "2025-09-06 03:26:33", "2025-09-06 03:26:33", "شماره موبایل ادمین ثبت نشده", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("465", "5363", "ووکامرس", "", "", "", "2025-09-08 18:35:13", "2025-09-08 18:35:13", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- ساعت هوشمند ش43 (#3474) اقلام 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("466", "5363", "ووکامرس", "", "", "", "2025-09-08 18:35:13", "2025-09-08 18:35:13", "سطح موجودی کاهش یافت: ساعت هوشمند ش43 (#3474) 10&rarr;9", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("467", "5363", "ووکامرس", "", "", "", "2025-09-08 18:35:13", "2025-09-08 18:35:13", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("468", "5363", "ووکامرس", "", "", "", "2025-09-08 18:35:17", "2025-09-08 18:35:17", "نام کاربری یا رمزعبور پنل اشتباه میباشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("469", "5363", "ووکامرس", "", "", "", "2025-09-08 18:35:17", "2025-09-08 18:35:17", "شماره موبایل ادمین ثبت نشده", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("470", "5364", "ووکامرس", "", "", "", "2025-09-08 20:41:22", "2025-09-08 20:41:22", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) اقلام 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("471", "5364", "ووکامرس", "", "", "", "2025-09-08 20:41:22", "2025-09-08 20:41:22", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 10&rarr;9", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("472", "5364", "ووکامرس", "", "", "", "2025-09-08 20:41:22", "2025-09-08 20:41:22", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("473", "5364", "ووکامرس", "", "", "", "2025-09-08 20:41:31", "2025-09-08 20:41:31", "نام کاربری یا رمزعبور پنل اشتباه میباشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("474", "5364", "ووکامرس", "", "", "", "2025-09-08 20:41:31", "2025-09-08 20:41:31", "شماره موبایل ادمین ثبت نشده", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("475", "5365", "ووکامرس", "", "", "", "2025-09-10 10:53:59", "2025-09-10 10:53:59", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- گوشی موبایل شیائومی مدل POCO F3 5G (#3516) اقلام 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("476", "5365", "ووکامرس", "", "", "", "2025-09-10 10:53:59", "2025-09-10 10:53:59", "سطح موجودی کاهش یافت: گوشی موبایل شیائومی مدل POCO F3 5G (#3516) 24&rarr;23", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("477", "5365", "ووکامرس", "", "", "", "2025-09-10 10:53:59", "2025-09-10 10:53:59", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("478", "5365", "ووکامرس", "", "", "", "2025-09-10 10:54:02", "2025-09-10 10:54:02", "نام کاربری یا رمزعبور پنل اشتباه میباشد", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("479", "5365", "ووکامرس", "", "", "", "2025-09-10 10:54:02", "2025-09-10 10:54:02", "شماره موبایل ادمین ثبت نشده", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("480", "5411", "ووکامرس", "", "", "", "2025-09-18 19:59:19", "2025-09-18 19:59:19", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- ساعت هوشمند سامسونگ (#3484) اقلام 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("481", "5411", "ووکامرس", "", "", "", "2025-09-18 19:59:19", "2025-09-18 19:59:19", "سطح موجودی کاهش یافت: ساعت هوشمند سامسونگ (#3484) 9&rarr;8", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("482", "5411", "ووکامرس", "", "", "", "2025-09-18 19:59:19", "2025-09-18 19:59:19", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("483", "5414", "ووکامرس", "", "", "", "2025-09-27 06:54:52", "2025-09-27 06:54:52", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) اقلام 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("484", "5414", "ووکامرس", "", "", "", "2025-09-27 06:54:52", "2025-09-27 06:54:52", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 9&rarr;8", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("485", "5414", "ووکامرس", "", "", "", "2025-09-27 06:54:52", "2025-09-27 06:54:52", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("486", "5415", "ووکامرس", "", "", "", "2025-09-29 07:31:23", "2025-09-29 07:31:23", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- گوشی موبایل شیائومی مدل POCO F3 5G (#3516) اقلام 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("487", "5415", "ووکامرس", "", "", "", "2025-09-29 07:31:24", "2025-09-29 07:31:24", "سطح موجودی کاهش یافت: گوشی موبایل شیائومی مدل POCO F3 5G (#3516) 23&rarr;22", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("488", "5415", "ووکامرس", "", "", "", "2025-09-29 07:31:24", "2025-09-29 07:31:24", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("489", "5466", "ووکامرس", "", "", "", "2025-10-05 07:55:12", "2025-10-05 07:55:12", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) اقلام 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("490", "5466", "ووکامرس", "", "", "", "2025-10-05 07:55:12", "2025-10-05 07:55:12", "سطح موجودی کاهش یافت: گوشی موبایل سامسونگ مدل Galaxy A32 (#3510) 8&rarr;7", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("491", "5466", "ووکامرس", "", "", "", "2025-10-05 07:55:12", "2025-10-05 07:55:12", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("492", "5467", "ووکامرس", "", "", "", "2025-10-11 08:28:15", "2025-10-11 08:28:15", "نگهداری موجودی 60 دقیقه اعمال شد روی: <br>- گوشی مدل POCO F3 5G (#3519) اقلام 1<br>- گوشی موبایل شیائومی مدل POCO F3 5G (#3516) اقلام 1", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("493", "5467", "ووکامرس", "", "", "", "2025-10-11 08:28:15", "2025-10-11 08:28:15", "سطح موجودی کاهش یافت: گوشی مدل POCO F3 5G (#3519) 9&rarr;8, گوشی موبایل شیائومی مدل POCO F3 5G (#3516) 22&rarr;21", "0", "1", "WooCommerce", "order_note", "0", "0");
INSERT INTO `wp_comments` VALUES("494", "5467", "ووکامرس", "", "", "", "2025-10-11 08:28:15", "2025-10-11 08:28:15", "در انتظار پرداخت چک وضعیت سفارش از در انتظار پرداخت به در انتظار بررسی تغییر کرد.", "0", "1", "WooCommerce", "order_note", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("28", "20250303_d988d988d8afd985d8a7d8b1d8aad9", "9bfc59602a2406b57159_20251012063753", "21", "2025-10-12 06:38:16", "admina", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-10-12 06:37:53\";s:7:\"Version\";s:8:\"1.5.13.3\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:7:\"10.6.19\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:28;s:4:\"Name\";s:39:\"20250303_d988d988d8afd985d8a7d8b1d8aad9\";s:4:\"Hash\";s:35:\"9bfc59602a2406b57159_20251012063753\";s:8:\"NameHash\";s:75:\"20250303_d988d988d8afd985d8a7d8b1d8aad9_9bfc59602a2406b57159_20251012063753\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:85:\"20250303_d988d988d8afd985d8a7d8b1d8aad9_9bfc59602a2406b57159_20251012063753_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.0\";s:6:\"WPUser\";s:6:\"admina\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:87:\"20250303_d988d988d8afd985d8a7d8b1d8aad9_9bfc59602a2406b57159_20251012063753_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:69:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/woodmartpluss3\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:3383;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:22181;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-10-12 06:37:53\";s:7:\"Version\";s:8:\"1.5.13.3\";s:9:\"VersionWP\";s:5:\"6.8.3\";s:9:\"VersionDB\";s:7:\"10.6.19\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:39:\"20250303_d988d988d8afd985d8a7d8b1d8aad9\";s:4:\"Hash\";s:35:\"9bfc59602a2406b57159_20251012063753\";s:8:\"NameHash\";s:75:\"20250303_d988d988d8afd985d8a7d8b1d8aad9_9bfc59602a2406b57159_20251012063753\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:93:\"20250303_d988d988d8afd985d8a7d8b1d8aad9_9bfc59602a2406b57159_20251012063753_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:83:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/woodmartpluss3/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:88:\"20250303_d988d988d8afd985d8a7d8b1d8aad9_9bfc59602a2406b57159_20251012063753_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:190:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/woodmartpluss3/wp-content/backups-dup-lite/tmp/20250303_d988d988d8afd985d8a7d8b1d8aad9_9bfc59602a2406b57159_20251012063753_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:78:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/woodmartpluss3/wp-admin\";i:1;s:81:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/woodmartpluss3/wp-includes\";i:2;s:90:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/woodmartpluss3/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:69:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/woodmartpluss3\";i:1;s:69:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/woodmartpluss3\";i:2;s:80:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/woodmartpluss3/wp-content\";i:3;s:88:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/woodmartpluss3/wp-content/uploads\";i:4;s:88:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/woodmartpluss3/wp-content/plugins\";i:5;s:91:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/woodmartpluss3/wp-content/mu-plugins\";i:6;s:87:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/woodmartpluss3/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:101:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/woodmartpluss3/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_litespeed_img_optming */
INSERT INTO `wp_litespeed_img_optming` VALUES("1", "3863", "1", "2023/04/Layer-1222-2-min-1.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("2", "3863", "1", "2023/04/Layer-1222-2-min-1-109x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("3", "3863", "1", "2023/04/Layer-1222-2-min-1-373x1024.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("4", "3863", "1", "2023/04/Layer-1222-2-min-1-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("5", "3863", "1", "2023/04/Layer-1222-2-min-1-768x2111.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("6", "3863", "1", "2023/04/Layer-1222-2-min-1-559x1536.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("7", "3863", "1", "2023/04/Layer-1222-2-min-1-745x2048.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("8", "3863", "1", "2023/04/Layer-1222-2-min-1-600x600.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("9", "3863", "1", "2023/04/Layer-1222-2-min-1-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("10", "3863", "1", "2023/04/Layer-1222-2-min-1-600x1649.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("11", "3863", "1", "2023/04/Layer-1222-2-min-1-150x412.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("12", "3867", "1", "2023/04/newbanner-min-1.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("13", "3867", "1", "2023/04/newbanner-min-1-300x84.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("14", "3867", "1", "2023/04/newbanner-min-1-1024x288.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("15", "3867", "1", "2023/04/newbanner-min-1-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("16", "3867", "1", "2023/04/newbanner-min-1-768x216.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("17", "3867", "1", "2023/04/newbanner-min-1-600x378.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("18", "3867", "1", "2023/04/newbanner-min-1-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("19", "3867", "1", "2023/04/newbanner-min-1-600x169.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("20", "3867", "1", "2023/04/newbanner-min-1-150x42.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("21", "3871", "1", "2023/04/Untitled-7-copy-min-1.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("22", "3871", "1", "2023/04/Untitled-7-copy-min-1-300x34.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("23", "3871", "1", "2023/04/Untitled-7-copy-min-1-1024x117.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("24", "3871", "1", "2023/04/Untitled-7-copy-min-1-150x125.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("25", "3871", "1", "2023/04/Untitled-7-copy-min-1-768x88.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("26", "3871", "1", "2023/04/Untitled-7-copy-min-1-600x125.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("27", "3871", "1", "2023/04/Untitled-7-copy-min-1-300x125.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("28", "3871", "1", "2023/04/Untitled-7-copy-min-1-600x68.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("29", "3871", "1", "2023/04/Untitled-7-copy-min-1-150x17.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("30", "3875", "1", "2023/04/Untitled-12-copy-min-1.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("31", "3875", "1", "2023/04/Untitled-12-copy-min-1-300x200.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("32", "3875", "1", "2023/04/Untitled-12-copy-min-1-1024x683.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("33", "3875", "1", "2023/04/Untitled-12-copy-min-1-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("34", "3875", "1", "2023/04/Untitled-12-copy-min-1-768x512.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("35", "3875", "1", "2023/04/Untitled-12-copy-min-1-600x600.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("36", "3875", "1", "2023/04/Untitled-12-copy-min-1-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("37", "3875", "1", "2023/04/Untitled-12-copy-min-1-600x400.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("38", "3875", "1", "2023/04/Untitled-12-copy-min-1-150x100.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("39", "3881", "1", "2023/04/7.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("40", "3881", "1", "2023/04/7-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("41", "3881", "1", "2023/04/7-150x125.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("42", "3882", "1", "2023/04/1.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("43", "3882", "1", "2023/04/1-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("44", "3882", "1", "2023/04/1-150x125.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("45", "3883", "1", "2023/04/6.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("46", "3883", "1", "2023/04/6-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("47", "3883", "1", "2023/04/6-150x125.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("48", "3884", "1", "2023/04/5.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("49", "3884", "1", "2023/04/5-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("50", "3884", "1", "2023/04/5-150x125.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("51", "3885", "1", "2023/04/4.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("52", "3885", "1", "2023/04/4-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("53", "3885", "1", "2023/04/4-150x125.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("54", "3886", "1", "2023/04/3.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("55", "3886", "1", "2023/04/3-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("56", "3886", "1", "2023/04/3-150x125.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("57", "3887", "1", "2023/04/8.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("58", "3887", "1", "2023/04/8-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("59", "3887", "1", "2023/04/8-150x125.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("60", "3888", "1", "2023/04/9.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("61", "3888", "1", "2023/04/9-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("62", "3888", "1", "2023/04/9-150x125.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("63", "3889", "1", "2023/04/2.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("64", "3889", "1", "2023/04/2-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("65", "3889", "1", "2023/04/2-150x125.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("66", "3968", "1", "2022/12/3-4-1.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("67", "3968", "1", "2022/12/3-4-1-324x324.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("68", "3968", "1", "2022/12/3-4-1-100x100.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("69", "3968", "1", "2022/12/3-4-1-416x422.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("70", "3968", "1", "2022/12/3-4-1-296x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("71", "3968", "1", "2022/12/3-4-1-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("72", "3968", "1", "2022/12/3-4-1-768x779.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("73", "3968", "1", "2022/12/3-4-1-600x600.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("74", "3964", "1", "2023/07/Untitled-12-copy-min-1-1.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("75", "3964", "1", "2023/07/Untitled-12-copy-min-1-1-324x324.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("76", "3964", "1", "2023/07/Untitled-12-copy-min-1-1-100x100.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("77", "3964", "1", "2023/07/Untitled-12-copy-min-1-1-416x278.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("78", "3964", "1", "2023/07/Untitled-12-copy-min-1-1-300x200.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("79", "3964", "1", "2023/07/Untitled-12-copy-min-1-1-1024x683.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("80", "3964", "1", "2023/07/Untitled-12-copy-min-1-1-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("81", "3964", "1", "2023/07/Untitled-12-copy-min-1-1-768x512.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("82", "3964", "1", "2023/07/Untitled-12-copy-min-1-1-600x600.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("83", "3963", "1", "2023/07/Rounded-Rectangle-5-6-1-1.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("84", "3963", "1", "2023/07/Rounded-Rectangle-5-6-1-1-324x305.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("85", "3963", "1", "2023/07/Rounded-Rectangle-5-6-1-1-100x100.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("86", "3963", "1", "2023/07/Rounded-Rectangle-5-6-1-1-416x95.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("87", "3963", "1", "2023/07/Rounded-Rectangle-5-6-1-1-300x68.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("88", "3963", "1", "2023/07/Rounded-Rectangle-5-6-1-1-1024x233.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("89", "3963", "1", "2023/07/Rounded-Rectangle-5-6-1-1-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("90", "3963", "1", "2023/07/Rounded-Rectangle-5-6-1-1-768x175.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("91", "3963", "1", "2023/07/Rounded-Rectangle-5-6-1-1-600x305.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("92", "3962", "1", "2023/07/Rounded-Rectangle-5-6-1.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("93", "3962", "1", "2023/07/Rounded-Rectangle-5-6-1-324x305.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("94", "3962", "1", "2023/07/Rounded-Rectangle-5-6-1-100x100.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("95", "3962", "1", "2023/07/Rounded-Rectangle-5-6-1-416x95.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("96", "3962", "1", "2023/07/Rounded-Rectangle-5-6-1-300x68.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("97", "3962", "1", "2023/07/Rounded-Rectangle-5-6-1-1024x233.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("98", "3962", "1", "2023/07/Rounded-Rectangle-5-6-1-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("99", "3962", "1", "2023/07/Rounded-Rectangle-5-6-1-768x175.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("100", "3962", "1", "2023/07/Rounded-Rectangle-5-6-1-600x305.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("101", "3958", "1", "2023/07/newbanner-min-1-2.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("102", "3958", "1", "2023/07/newbanner-min-1-2-324x324.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("103", "3958", "1", "2023/07/newbanner-min-1-2-100x100.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("104", "3958", "1", "2023/07/newbanner-min-1-2-416x117.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("105", "3958", "1", "2023/07/newbanner-min-1-2-300x84.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("106", "3958", "1", "2023/07/newbanner-min-1-2-1024x288.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("107", "3958", "1", "2023/07/newbanner-min-1-2-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("108", "3958", "1", "2023/07/newbanner-min-1-2-768x216.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("109", "3958", "1", "2023/07/newbanner-min-1-2-600x378.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("110", "3954", "1", "2023/07/Layer-1222-2-min-1-1.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("111", "3954", "1", "2023/07/Layer-1222-2-min-1-1-324x324.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("112", "3954", "1", "2023/07/Layer-1222-2-min-1-1-100x100.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("113", "3954", "1", "2023/07/Layer-1222-2-min-1-1-416x557.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("114", "3954", "1", "2023/07/Layer-1222-2-min-1-1-224x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("115", "3954", "1", "2023/07/Layer-1222-2-min-1-1-764x1024.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("116", "3954", "1", "2023/07/Layer-1222-2-min-1-1-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("117", "3954", "1", "2023/07/Layer-1222-2-min-1-1-768x1029.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("118", "3954", "1", "2023/07/Layer-1222-2-min-1-1-1147x1536.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("119", "3954", "1", "2023/07/Layer-1222-2-min-1-1-1529x2048.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("120", "3954", "1", "2023/07/Layer-1222-2-min-1-1-600x600.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("121", "3951", "1", "2022/11/04-min-1-1.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("122", "3951", "1", "2022/11/04-min-1-1-324x324.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("123", "3951", "1", "2022/11/04-min-1-1-100x100.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("124", "3951", "1", "2022/11/04-min-1-1-416x416.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("125", "3951", "1", "2022/11/04-min-1-1-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("126", "3951", "1", "2022/11/04-min-1-1-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("127", "3951", "1", "2022/11/04-min-1-1-600x600.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("128", "3950", "1", "2022/11/watchsite-1.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("129", "3950", "1", "2022/11/watchsite-1-324x324.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("130", "3950", "1", "2022/11/watchsite-1-100x100.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("131", "3950", "1", "2022/11/watchsite-1-416x416.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("132", "3950", "1", "2022/11/watchsite-1-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("133", "3950", "1", "2022/11/watchsite-1-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("134", "3950", "1", "2022/11/watchsite-1-600x600.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("135", "3949", "1", "2022/11/01-min.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("136", "3949", "1", "2022/11/01-min-324x324.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("137", "3949", "1", "2022/11/01-min-100x100.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("138", "3949", "1", "2022/11/01-min-416x416.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("139", "3949", "1", "2022/11/01-min-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("140", "3949", "1", "2022/11/01-min-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("141", "3949", "1", "2022/11/01-min-600x600.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("142", "3948", "1", "2022/11/watchsite.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("143", "3948", "1", "2022/11/watchsite-324x324.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("144", "3948", "1", "2022/11/watchsite-100x100.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("145", "3948", "1", "2022/11/watchsite-416x416.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("146", "3948", "1", "2022/11/watchsite-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("147", "3948", "1", "2022/11/watchsite-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("148", "3948", "1", "2022/11/watchsite-600x600.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("149", "3947", "1", "2022/11/watchsite-1.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("150", "3947", "1", "2022/11/watchsite-1-324x324.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("151", "3947", "1", "2022/11/watchsite-1-100x100.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("152", "3947", "1", "2022/11/watchsite-1-416x416.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("153", "3947", "1", "2022/11/watchsite-1-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("154", "3947", "1", "2022/11/watchsite-1-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("155", "3947", "1", "2022/11/watchsite-1-600x600.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("156", "3946", "1", "2022/11/02-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("157", "3946", "1", "2022/11/02-min-324x324.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("158", "3946", "1", "2022/11/02-min-100x100.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("159", "3946", "1", "2022/11/02-min-416x416.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("160", "3946", "1", "2022/11/02-min-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("161", "3946", "1", "2022/11/02-min-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("162", "3946", "1", "2022/11/02-min-600x600.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("163", "3945", "1", "2022/12/3-4-1.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("164", "3945", "1", "2022/12/3-4-1-324x324.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("165", "3945", "1", "2022/12/3-4-1-100x100.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("166", "3945", "1", "2022/12/3-4-1-416x422.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("167", "3945", "1", "2022/12/3-4-1-296x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("168", "3945", "1", "2022/12/3-4-1-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("169", "3945", "1", "2022/12/3-4-1-768x779.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("170", "3945", "1", "2022/12/3-4-1-600x600.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("171", "3944", "1", "2022/12/6-300x300-1-1.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("172", "3944", "1", "2022/12/6-300x300-1-1-100x100.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("173", "3944", "1", "2022/12/6-300x300-1-1-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("174", "3942", "1", "2022/12/44-min-1-1.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("175", "3942", "1", "2022/12/44-min-1-1-324x324.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("176", "3942", "1", "2022/12/44-min-1-1-100x100.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("177", "3942", "1", "2022/12/44-min-1-1-416x416.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("178", "3942", "1", "2022/12/44-min-1-1-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("179", "3942", "1", "2022/12/44-min-1-1-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("180", "3942", "1", "2022/12/44-min-1-1-768x768.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("181", "3942", "1", "2022/12/44-min-1-1-600x600.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("182", "3938", "1", "2023/07/1-1-min-1.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("183", "3938", "1", "2023/07/1-1-min-1-324x324.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("184", "3938", "1", "2023/07/1-1-min-1-100x100.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("185", "3938", "1", "2023/07/1-1-min-1-416x364.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("186", "3938", "1", "2023/07/1-1-min-1-300x263.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("187", "3938", "1", "2023/07/1-1-min-1-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("188", "3937", "1", "2023/07/1-1-min-1.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("189", "3937", "1", "2023/07/1-1-min-1-324x324.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("190", "3937", "1", "2023/07/1-1-min-1-100x100.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("191", "3937", "1", "2023/07/1-1-min-1-416x364.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("192", "3937", "1", "2023/07/1-1-min-1-300x263.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("193", "3937", "1", "2023/07/1-1-min-1-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("194", "3933", "1", "2023/07/Untitled-12-copy-min-1-1.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("195", "3933", "1", "2023/07/Untitled-12-copy-min-1-1-324x324.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("196", "3933", "1", "2023/07/Untitled-12-copy-min-1-1-100x100.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("197", "3933", "1", "2023/07/Untitled-12-copy-min-1-1-416x278.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("198", "3933", "1", "2023/07/Untitled-12-copy-min-1-1-300x200.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("199", "3933", "1", "2023/07/Untitled-12-copy-min-1-1-1024x683.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("200", "3933", "1", "2023/07/Untitled-12-copy-min-1-1-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("201", "3933", "1", "2023/07/Untitled-12-copy-min-1-1-768x512.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("202", "3933", "1", "2023/07/Untitled-12-copy-min-1-1-600x600.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("203", "3932", "1", "2023/07/Layer-1222-1-2-1-1.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("204", "3932", "1", "2023/07/Layer-1222-1-2-1-1-324x324.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("205", "3932", "1", "2023/07/Layer-1222-1-2-1-1-100x100.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("206", "3932", "1", "2023/07/Layer-1222-1-2-1-1-416x317.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("207", "3932", "1", "2023/07/Layer-1222-1-2-1-1-300x228.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("208", "3932", "1", "2023/07/Layer-1222-1-2-1-1-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("209", "3931", "1", "2023/07/Rounded-Rectangle-5-4-1.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("210", "3931", "1", "2023/07/Rounded-Rectangle-5-4-1-324x324.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("211", "3931", "1", "2023/07/Rounded-Rectangle-5-4-1-100x100.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("212", "3931", "1", "2023/07/Rounded-Rectangle-5-4-1-416x108.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("213", "3931", "1", "2023/07/Rounded-Rectangle-5-4-1-300x78.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("214", "3931", "1", "2023/07/Rounded-Rectangle-5-4-1-1024x266.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("215", "3931", "1", "2023/07/Rounded-Rectangle-5-4-1-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("216", "3931", "1", "2023/07/Rounded-Rectangle-5-4-1-768x199.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("217", "3931", "1", "2023/07/Rounded-Rectangle-5-4-1-600x364.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("218", "3930", "1", "2023/07/Layer-1222-1-2-1.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("219", "3930", "1", "2023/07/Layer-1222-1-2-1-324x324.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("220", "3930", "1", "2023/07/Layer-1222-1-2-1-100x100.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("221", "3930", "1", "2023/07/Layer-1222-1-2-1-416x317.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("222", "3930", "1", "2023/07/Layer-1222-1-2-1-300x228.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("223", "3930", "1", "2023/07/Layer-1222-1-2-1-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("224", "3929", "1", "2023/07/919ca9f551c967d9631e9a99fe5c115e66a03f68_1610546441-1.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("225", "3929", "1", "2023/07/919ca9f551c967d9631e9a99fe5c115e66a03f68_1610546441-1-324x324.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("226", "3929", "1", "2023/07/919ca9f551c967d9631e9a99fe5c115e66a03f68_1610546441-1-100x100.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("227", "3929", "1", "2023/07/919ca9f551c967d9631e9a99fe5c115e66a03f68_1610546441-1-244x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("228", "3929", "1", "2023/07/919ca9f551c967d9631e9a99fe5c115e66a03f68_1610546441-1-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("229", "3968", "1", "2022/12/3-4-1-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("230", "3968", "1", "2022/12/3-4-1-150x152.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("231", "3968", "1", "2022/12/3-4-1-600x608.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("232", "3964", "1", "2023/07/Untitled-12-copy-min-1-1-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("233", "3964", "1", "2023/07/Untitled-12-copy-min-1-1-150x100.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("234", "3964", "1", "2023/07/Untitled-12-copy-min-1-1-600x400.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("235", "3963", "1", "2023/07/Rounded-Rectangle-5-6-1-1-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("236", "3963", "1", "2023/07/Rounded-Rectangle-5-6-1-1-150x34.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("237", "3963", "1", "2023/07/Rounded-Rectangle-5-6-1-1-600x136.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("238", "3962", "1", "2023/07/Rounded-Rectangle-5-6-1-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("239", "3962", "1", "2023/07/Rounded-Rectangle-5-6-1-150x34.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("240", "3962", "1", "2023/07/Rounded-Rectangle-5-6-1-600x136.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("241", "3958", "1", "2023/07/newbanner-min-1-2-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("242", "3958", "1", "2023/07/newbanner-min-1-2-150x42.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("243", "3958", "1", "2023/07/newbanner-min-1-2-600x169.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("244", "3954", "1", "2023/07/Layer-1222-2-min-1-1-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("245", "3954", "1", "2023/07/Layer-1222-2-min-1-1-150x201.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("246", "3954", "1", "2023/07/Layer-1222-2-min-1-1-600x804.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("247", "3945", "1", "2022/12/3-4-1-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("248", "3945", "1", "2022/12/3-4-1-150x152.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("249", "3945", "1", "2022/12/3-4-1-600x608.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("250", "3938", "1", "2023/07/1-1-min-1-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("251", "3938", "1", "2023/07/1-1-min-1-150x131.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("252", "3937", "1", "2023/07/1-1-min-1-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("253", "3937", "1", "2023/07/1-1-min-1-150x131.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("254", "3933", "1", "2023/07/Untitled-12-copy-min-1-1-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("255", "3933", "1", "2023/07/Untitled-12-copy-min-1-1-150x100.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("256", "3933", "1", "2023/07/Untitled-12-copy-min-1-1-600x400.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("257", "3932", "1", "2023/07/Layer-1222-1-2-1-1-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("258", "3932", "1", "2023/07/Layer-1222-1-2-1-1-150x114.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("259", "3931", "1", "2023/07/Rounded-Rectangle-5-4-1-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("260", "3931", "1", "2023/07/Rounded-Rectangle-5-4-1-150x39.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("261", "3931", "1", "2023/07/Rounded-Rectangle-5-4-1-600x156.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("262", "3930", "1", "2023/07/Layer-1222-1-2-1-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("263", "3930", "1", "2023/07/Layer-1222-1-2-1-150x114.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("264", "3929", "1", "2023/07/919ca9f551c967d9631e9a99fe5c115e66a03f68_1610546441-1-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("265", "3929", "1", "2023/07/919ca9f551c967d9631e9a99fe5c115e66a03f68_1610546441-1-150x185.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("266", "3928", "1", "2023/07/Rounded-Rectangle-5-6-1.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("267", "3928", "1", "2023/07/Rounded-Rectangle-5-6-1-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("268", "3928", "1", "2023/07/Rounded-Rectangle-5-6-1-150x39.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("269", "3928", "1", "2023/07/Rounded-Rectangle-5-6-1-600x156.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("270", "3928", "1", "2023/07/Rounded-Rectangle-5-6-1-300x78.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("271", "3928", "1", "2023/07/Rounded-Rectangle-5-6-1-1024x266.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("272", "3928", "1", "2023/07/Rounded-Rectangle-5-6-1-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("273", "3928", "1", "2023/07/Rounded-Rectangle-5-6-1-768x199.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("274", "3928", "1", "2023/07/Rounded-Rectangle-5-6-1-600x364.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("275", "3915", "1", "2023/05/2.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("276", "3915", "1", "2023/05/2-150x125.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("277", "3915", "1", "2023/05/2-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("278", "3914", "1", "2023/05/9.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("279", "3914", "1", "2023/05/9-150x125.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("280", "3914", "1", "2023/05/9-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("281", "3913", "1", "2023/05/8.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("282", "3913", "1", "2023/05/8-150x125.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("283", "3913", "1", "2023/05/8-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("284", "3912", "1", "2023/05/3.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("285", "3912", "1", "2023/05/3-150x125.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("286", "3912", "1", "2023/05/3-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("287", "3911", "1", "2023/05/4.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("288", "3911", "1", "2023/05/4-150x125.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("289", "3911", "1", "2023/05/4-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("290", "3910", "1", "2023/05/5.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("291", "3910", "1", "2023/05/5-150x125.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("292", "3910", "1", "2023/05/5-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("293", "3909", "1", "2023/05/goldunt-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("294", "3909", "1", "2023/05/goldunt-min-150x125.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("295", "3909", "1", "2023/05/goldunt-min-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("296", "3908", "1", "2023/05/6.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("297", "3908", "1", "2023/05/6-150x125.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("298", "3908", "1", "2023/05/6-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("299", "3907", "1", "2023/05/1.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("300", "3907", "1", "2023/05/1-150x125.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("301", "3907", "1", "2023/05/1-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("302", "3906", "1", "2023/05/7.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("303", "3906", "1", "2023/05/7-150x125.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("304", "3906", "1", "2023/05/7-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("305", "3902", "1", "2022/12/q20.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("306", "3902", "1", "2022/12/q20-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("307", "3902", "1", "2022/12/q20-150x79.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("308", "3902", "1", "2022/12/q20-600x315.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("309", "3902", "1", "2022/12/q20-300x157.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("310", "3902", "1", "2022/12/q20-1024x537.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("311", "3902", "1", "2022/12/q20-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("312", "3902", "1", "2022/12/q20-768x403.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("313", "3902", "1", "2022/12/q20-600x600.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("314", "3857", "1", "2023/04/placeholder-5.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("315", "3857", "1", "2023/04/placeholder-5-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("316", "3857", "1", "2023/04/placeholder-5-150x100.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("317", "3857", "1", "2023/04/placeholder-5-600x400.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("318", "3857", "1", "2023/04/placeholder-5-300x200.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("319", "3857", "1", "2023/04/placeholder-5-1024x683.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("320", "3857", "1", "2023/04/placeholder-5-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("321", "3857", "1", "2023/04/placeholder-5-768x512.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("322", "3857", "1", "2023/04/placeholder-5-600x600.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("323", "3856", "1", "2023/04/placeholder-4.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("324", "3856", "1", "2023/04/placeholder-4-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("325", "3856", "1", "2023/04/placeholder-4-150x100.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("326", "3856", "1", "2023/04/placeholder-4-600x400.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("327", "3856", "1", "2023/04/placeholder-4-300x200.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("328", "3856", "1", "2023/04/placeholder-4-1024x683.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("329", "3856", "1", "2023/04/placeholder-4-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("330", "3856", "1", "2023/04/placeholder-4-768x512.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("331", "3856", "1", "2023/04/placeholder-4-600x600.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("332", "3855", "1", "2023/04/placeholder-3.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("333", "3855", "1", "2023/04/placeholder-3-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("334", "3855", "1", "2023/04/placeholder-3-150x100.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("335", "3855", "1", "2023/04/placeholder-3-600x400.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("336", "3855", "1", "2023/04/placeholder-3-300x200.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("337", "3855", "1", "2023/04/placeholder-3-1024x683.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("338", "3855", "1", "2023/04/placeholder-3-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("339", "3855", "1", "2023/04/placeholder-3-768x512.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("340", "3855", "1", "2023/04/placeholder-3-600x600.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("341", "3854", "1", "2023/04/placeholder-2.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("342", "3854", "1", "2023/04/placeholder-2-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("343", "3854", "1", "2023/04/placeholder-2-150x100.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("344", "3854", "1", "2023/04/placeholder-2-600x400.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("345", "3854", "1", "2023/04/placeholder-2-300x200.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("346", "3854", "1", "2023/04/placeholder-2-1024x683.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("347", "3854", "1", "2023/04/placeholder-2-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("348", "3854", "1", "2023/04/placeholder-2-768x512.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("349", "3854", "1", "2023/04/placeholder-2-600x600.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("350", "3853", "1", "2023/04/placeholder-1.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("351", "3853", "1", "2023/04/placeholder-1-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("352", "3853", "1", "2023/04/placeholder-1-150x100.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("353", "3853", "1", "2023/04/placeholder-1-600x400.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("354", "3853", "1", "2023/04/placeholder-1-300x200.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("355", "3853", "1", "2023/04/placeholder-1-1024x683.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("356", "3853", "1", "2023/04/placeholder-1-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("357", "3853", "1", "2023/04/placeholder-1-768x512.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("358", "3853", "1", "2023/04/placeholder-1-600x600.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("359", "3852", "1", "2023/04/ezgif.com-gif-maker-7.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("360", "3852", "1", "2023/04/ezgif.com-gif-maker-7-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("361", "3852", "1", "2023/04/ezgif.com-gif-maker-7-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("362", "3852", "1", "2023/04/ezgif.com-gif-maker-7-600x600.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("363", "3852", "1", "2023/04/ezgif.com-gif-maker-7-768x768.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("364", "3851", "1", "2023/04/ezgif.com-gif-maker-8.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("365", "3851", "1", "2023/04/ezgif.com-gif-maker-8-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("366", "3851", "1", "2023/04/ezgif.com-gif-maker-8-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("367", "3851", "1", "2023/04/ezgif.com-gif-maker-8-600x600.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("368", "3851", "1", "2023/04/ezgif.com-gif-maker-8-768x768.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("369", "3850", "1", "2023/04/ezgif.com-gif-maker-9.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("370", "3850", "1", "2023/04/ezgif.com-gif-maker-9-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("371", "3850", "1", "2023/04/ezgif.com-gif-maker-9-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("372", "3850", "1", "2023/04/ezgif.com-gif-maker-9-600x600.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("373", "3850", "1", "2023/04/ezgif.com-gif-maker-9-768x768.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("374", "3849", "1", "2023/04/ezgif.com-gif-maker-10.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("375", "3849", "1", "2023/04/ezgif.com-gif-maker-10-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("376", "3849", "1", "2023/04/ezgif.com-gif-maker-10-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("377", "3849", "1", "2023/04/ezgif.com-gif-maker-10-600x600.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("378", "3849", "1", "2023/04/ezgif.com-gif-maker-10-768x768.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("379", "3848", "1", "2023/04/ezgif.com-gif-maker-11.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("380", "3848", "1", "2023/04/ezgif.com-gif-maker-11-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("381", "3848", "1", "2023/04/ezgif.com-gif-maker-11-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("382", "3848", "1", "2023/04/ezgif.com-gif-maker-11-600x600.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("383", "3848", "1", "2023/04/ezgif.com-gif-maker-11-768x768.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("384", "3847", "1", "2023/04/ezgif.com-gif-maker-12.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("385", "3847", "1", "2023/04/ezgif.com-gif-maker-12-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("386", "3847", "1", "2023/04/ezgif.com-gif-maker-12-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("387", "3847", "1", "2023/04/ezgif.com-gif-maker-12-600x600.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("388", "3847", "1", "2023/04/ezgif.com-gif-maker-12-768x768.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("389", "3831", "1", "2023/04/Untitled-2.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("390", "3831", "1", "2023/04/Untitled-2-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("391", "3831", "1", "2023/04/Untitled-2-150x64.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("392", "3831", "1", "2023/04/Untitled-2-600x256.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("393", "3831", "1", "2023/04/Untitled-2-300x128.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("394", "3831", "1", "2023/04/Untitled-2-1024x436.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("395", "3831", "1", "2023/04/Untitled-2-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("396", "3831", "1", "2023/04/Untitled-2-768x327.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("397", "3831", "1", "2023/04/Untitled-2-1536x655.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("398", "3831", "1", "2023/04/Untitled-2-600x600.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("399", "3813", "1", "2023/04/Asset-8-1-3.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("400", "3813", "1", "2023/04/Asset-8-1-3-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("401", "3813", "1", "2023/04/Asset-8-1-3-150x67.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("402", "3813", "1", "2023/04/Asset-8-1-3-600x270.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("403", "3813", "1", "2023/04/Asset-8-1-3-300x135.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("404", "3813", "1", "2023/04/Asset-8-1-3-1024x460.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("405", "3813", "1", "2023/04/Asset-8-1-3-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("406", "3813", "1", "2023/04/Asset-8-1-3-768x345.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("407", "3813", "1", "2023/04/Asset-8-1-3-600x544.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("408", "3805", "1", "2023/04/placeholder.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("409", "3805", "1", "2023/04/placeholder-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("410", "3805", "1", "2023/04/placeholder-150x100.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("411", "3805", "1", "2023/04/placeholder-600x400.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("412", "3805", "1", "2023/04/placeholder-300x200.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("413", "3805", "1", "2023/04/placeholder-1024x683.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("414", "3805", "1", "2023/04/placeholder-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("415", "3805", "1", "2023/04/placeholder-768x512.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("416", "3805", "1", "2023/04/placeholder-600x600.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("417", "3804", "1", "2023/04/page-title-shop.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("418", "3804", "1", "2023/04/page-title-shop-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("419", "3804", "1", "2023/04/page-title-shop-150x50.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("420", "3804", "1", "2023/04/page-title-shop-600x200.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("421", "3804", "1", "2023/04/page-title-shop-300x100.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("422", "3804", "1", "2023/04/page-title-shop-1024x342.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("423", "3804", "1", "2023/04/page-title-shop-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("424", "3804", "1", "2023/04/page-title-shop-768x256.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("425", "3804", "1", "2023/04/page-title-shop-1536x513.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("426", "3804", "1", "2023/04/page-title-shop-600x600.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("427", "3796", "1", "2023/03/3-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("428", "3795", "1", "2023/03/2-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("429", "3794", "1", "2023/03/1-3.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("430", "3761", "1", "2023/02/4-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("431", "3760", "1", "2023/02/3-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("432", "3759", "1", "2023/02/2-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("433", "3758", "1", "2023/02/1.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("434", "3668", "1", "2022/12/4-1-min-1-1.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("435", "3668", "1", "2022/12/4-1-min-1-1-300x178.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("436", "3668", "1", "2022/12/4-1-min-1-1-150x65.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("437", "3668", "1", "2022/12/4-1-min-1-1-300x131.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("438", "3668", "1", "2022/12/4-1-min-1-1-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("439", "3663", "1", "2022/12/5-1-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("440", "3663", "1", "2022/12/5-1-min-300x178.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("441", "3663", "1", "2022/12/5-1-min-150x65.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("442", "3663", "1", "2022/12/5-1-min-300x131.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("443", "3663", "1", "2022/12/5-1-min-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("444", "3652", "1", "2022/12/feature-1.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("445", "3646", "1", "2022/12/1-1.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("446", "3616", "1", "2022/12/f18a182f7c300af9ce3eb8f47201ef340fc87eb3_1670930133.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("447", "3616", "1", "2022/12/f18a182f7c300af9ce3eb8f47201ef340fc87eb3_1670930133-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("448", "3616", "1", "2022/12/f18a182f7c300af9ce3eb8f47201ef340fc87eb3_1670930133-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("449", "3615", "1", "2022/12/967cbaa25713ca4d0e58cb5aaf0e486ab986d460_1648898393.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("450", "3614", "1", "2022/12/28a6ef720244892accbcf8da7b9ebb7262d3172b_1670930099.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("451", "3614", "1", "2022/12/28a6ef720244892accbcf8da7b9ebb7262d3172b_1670930099-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("452", "3614", "1", "2022/12/28a6ef720244892accbcf8da7b9ebb7262d3172b_1670930099-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("453", "3613", "1", "2022/12/17bb6daa07ae2ec11867fb7320ed6f79b26f1f4b_1666724993.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("454", "3613", "1", "2022/12/17bb6daa07ae2ec11867fb7320ed6f79b26f1f4b_1666724993-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("455", "3612", "1", "2022/12/5ad4b771667ebbd37ac6df87aff1f8129351cbb1_1668943323.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("456", "3612", "1", "2022/12/5ad4b771667ebbd37ac6df87aff1f8129351cbb1_1668943323-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("457", "3612", "1", "2022/12/5ad4b771667ebbd37ac6df87aff1f8129351cbb1_1668943323-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("458", "3596", "1", "2022/12/b5.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("459", "3596", "1", "2022/12/b5-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("460", "3596", "1", "2022/12/b5-150x60.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("461", "3596", "1", "2022/12/b5-600x240.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("462", "3596", "1", "2022/12/b5-300x120.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("463", "3596", "1", "2022/12/b5-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("464", "3596", "1", "2022/12/b5-768x307.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("465", "3596", "1", "2022/12/b5-600x328.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("466", "3591", "1", "2022/12/box.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("467", "3591", "1", "2022/12/box-150x136.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("468", "3591", "1", "2022/12/box-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("469", "3590", "1", "2022/12/amazing-typo.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("470", "3584", "1", "2022/12/b4.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("471", "3584", "1", "2022/12/b4-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("472", "3584", "1", "2022/12/b4-150x113.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("473", "3584", "1", "2022/12/b4-300x225.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("474", "3584", "1", "2022/12/b4-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("475", "3583", "1", "2022/12/b3.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("476", "3583", "1", "2022/12/b3-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("477", "3583", "1", "2022/12/b3-150x113.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("478", "3583", "1", "2022/12/b3-300x225.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("479", "3583", "1", "2022/12/b3-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("480", "3582", "1", "2022/12/b2.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("481", "3582", "1", "2022/12/b2-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("482", "3582", "1", "2022/12/b2-150x113.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("483", "3582", "1", "2022/12/b2-300x225.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("484", "3582", "1", "2022/12/b2-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("485", "3581", "1", "2022/12/b1.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("486", "3581", "1", "2022/12/b1-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("487", "3581", "1", "2022/12/b1-150x113.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("488", "3581", "1", "2022/12/b1-300x225.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("489", "3581", "1", "2022/12/b1-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("490", "3574", "1", "2022/12/s3.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("491", "3574", "1", "2022/12/s3-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("492", "3574", "1", "2022/12/s3-150x113.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("493", "3574", "1", "2022/12/s3-600x450.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("494", "3574", "1", "2022/12/s3-300x225.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("495", "3574", "1", "2022/12/s3-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("496", "3574", "1", "2022/12/s3-600x480.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("497", "3573", "1", "2022/12/s2.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("498", "3573", "1", "2022/12/s2-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("499", "3573", "1", "2022/12/s2-150x113.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("500", "3573", "1", "2022/12/s2-600x450.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("501", "3573", "1", "2022/12/s2-300x225.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("502", "3573", "1", "2022/12/s2-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("503", "3573", "1", "2022/12/s2-600x480.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("504", "3572", "1", "2022/12/s1.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("505", "3572", "1", "2022/12/s1-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("506", "3572", "1", "2022/12/s1-150x113.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("507", "3572", "1", "2022/12/s1-600x450.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("508", "3572", "1", "2022/12/s1-300x225.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("509", "3572", "1", "2022/12/s1-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("510", "3572", "1", "2022/12/s1-600x480.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("511", "3571", "1", "2022/12/2.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("512", "3571", "1", "2022/12/2-300x50.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("513", "3571", "1", "2022/12/2-150x5.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("514", "3571", "1", "2022/12/2-600x21.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("515", "3571", "1", "2022/12/2-300x11.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("516", "3571", "1", "2022/12/2-1024x37.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("517", "3571", "1", "2022/12/2-150x50.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("518", "3571", "1", "2022/12/2-768x27.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("519", "3571", "1", "2022/12/2-600x50.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("520", "3542", "1", "2022/12/2-1-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("521", "3542", "1", "2022/12/2-1-min-150x90.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("522", "3542", "1", "2022/12/2-1-min-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("523", "3541", "1", "2022/12/4-1-min-1.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("524", "3541", "1", "2022/12/4-1-min-1-300x178.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("525", "3541", "1", "2022/12/4-1-min-1-150x65.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("526", "3541", "1", "2022/12/4-1-min-1-300x131.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("527", "3541", "1", "2022/12/4-1-min-1-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("528", "3539", "1", "2022/12/4-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("529", "3538", "1", "2022/12/3-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("530", "3537", "1", "2022/12/2-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("531", "3536", "1", "2022/12/1.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("532", "3527", "1", "2022/11/watchsite.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("533", "3527", "1", "2022/11/watchsite-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("534", "3527", "1", "2022/11/watchsite-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("535", "3527", "1", "2022/11/watchsite-600x600.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("536", "3520", "1", "2022/12/44-min-1-300x300-1-1.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("537", "3520", "1", "2022/12/44-min-1-300x300-1-1-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("538", "3517", "1", "2022/12/44-min-1-300x300-1.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("539", "3517", "1", "2022/12/44-min-1-300x300-1-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("540", "3514", "1", "2022/12/22-1-300x300-1.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("541", "3514", "1", "2022/12/22-1-300x300-1-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("542", "3511", "1", "2022/12/6-300x300-1.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("543", "3511", "1", "2022/12/6-300x300-1-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("544", "3508", "1", "2022/12/3.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("545", "3508", "1", "2022/12/3-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("546", "3508", "1", "2022/12/3-150x152.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("547", "3508", "1", "2022/12/3-600x608.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("548", "3508", "1", "2022/12/3-296x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("549", "3508", "1", "2022/12/3-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("550", "3508", "1", "2022/12/3-768x779.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("551", "3508", "1", "2022/12/3-600x600.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("552", "3503", "1", "2022/12/cover-app-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("553", "3503", "1", "2022/12/cover-app-min-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("554", "3503", "1", "2022/12/cover-app-min-150x104.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("555", "3503", "1", "2022/12/cover-app-min-300x208.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("556", "3503", "1", "2022/12/cover-app-min-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("557", "3502", "1", "2022/12/samandehi-1-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("558", "3498", "1", "2022/12/count_out-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("559", "3498", "1", "2022/12/count_out-min-150x104.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("560", "3498", "1", "2022/12/count_out-min-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("561", "3494", "1", "2022/12/FF-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("562", "3491", "1", "2022/11/logo-min-2.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("563", "3491", "1", "2022/11/logo-min-2-150x32.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("564", "3491", "1", "2022/11/logo-min-2-150x36.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("565", "3456", "1", "2021/12/4K-Monitors-41-min.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("566", "3456", "1", "2021/12/4K-Monitors-41-min-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("567", "3456", "1", "2021/12/4K-Monitors-41-min-150x101.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("568", "3456", "1", "2021/12/4K-Monitors-41-min-600x406.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("569", "3456", "1", "2021/12/4K-Monitors-41-min-300x203.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("570", "3456", "1", "2021/12/4K-Monitors-41-min-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("571", "3456", "1", "2021/12/4K-Monitors-41-min-768x519.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("572", "3456", "1", "2021/12/4K-Monitors-41-min-600x588.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("573", "3452", "1", "2021/12/1-single-default-min.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("574", "3452", "1", "2021/12/1-single-default-min-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("575", "3452", "1", "2021/12/1-single-default-min-150x101.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("576", "3452", "1", "2021/12/1-single-default-min-600x406.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("577", "3452", "1", "2021/12/1-single-default-min-300x203.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("578", "3452", "1", "2021/12/1-single-default-min-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("579", "3452", "1", "2021/12/1-single-default-min-768x519.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("580", "3452", "1", "2021/12/1-single-default-min-600x588.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("581", "3449", "1", "2021/12/2-single-default-min-1.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("582", "3449", "1", "2021/12/2-single-default-min-1-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("583", "3449", "1", "2021/12/2-single-default-min-1-150x101.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("584", "3449", "1", "2021/12/2-single-default-min-1-600x406.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("585", "3449", "1", "2021/12/2-single-default-min-1-300x203.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("586", "3449", "1", "2021/12/2-single-default-min-1-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("587", "3449", "1", "2021/12/2-single-default-min-1-768x519.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("588", "3449", "1", "2021/12/2-single-default-min-1-600x588.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("589", "3444", "1", "2021/12/4444.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("590", "3444", "1", "2021/12/4444-300x300.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("591", "3444", "1", "2021/12/4444-150x95.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("592", "3444", "1", "2021/12/4444-600x381.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("593", "3444", "1", "2021/12/4444-300x191.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("594", "3444", "1", "2021/12/4444-150x150.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("595", "3444", "1", "2021/12/4444-768x488.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("596", "3444", "1", "2021/12/4444-600x588.jpg", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("597", "3425", "1", "2022/11/harajestoon-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("598", "3424", "1", "2021/10/2222-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("599", "3424", "1", "2021/10/2222-min-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("600", "3424", "1", "2021/10/2222-min-150x152.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("601", "3424", "1", "2021/10/2222-min-600x608.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("602", "3424", "1", "2021/10/2222-min-296x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("603", "3424", "1", "2021/10/2222-min-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("604", "3424", "1", "2021/10/2222-min-768x779.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("605", "3424", "1", "2021/10/2222-min-600x600.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("606", "3421", "1", "2021/10/44-min-1.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("607", "3421", "1", "2021/10/44-min-1-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("608", "3421", "1", "2021/10/44-min-1-150x152.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("609", "3421", "1", "2021/10/44-min-1-600x608.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("610", "3421", "1", "2021/10/44-min-1-296x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("611", "3421", "1", "2021/10/44-min-1-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("612", "3421", "1", "2021/10/44-min-1-768x779.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("613", "3421", "1", "2021/10/44-min-1-600x600.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("614", "3408", "1", "2021/10/6.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("615", "3408", "1", "2021/10/6-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("616", "3408", "1", "2021/10/6-150x152.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("617", "3408", "1", "2021/10/6-600x608.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("618", "3408", "1", "2021/10/6-296x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("619", "3408", "1", "2021/10/6-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("620", "3408", "1", "2021/10/6-768x779.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("621", "3408", "1", "2021/10/6-600x600.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("622", "3406", "1", "2021/10/3.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("623", "3406", "1", "2021/10/3-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("624", "3406", "1", "2021/10/3-150x152.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("625", "3406", "1", "2021/10/3-600x608.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("626", "3406", "1", "2021/10/3-296x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("627", "3406", "1", "2021/10/3-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("628", "3406", "1", "2021/10/3-768x779.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("629", "3406", "1", "2021/10/3-600x600.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("630", "3401", "1", "2021/12/01-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("631", "3401", "1", "2021/12/01-min-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("632", "3401", "1", "2021/12/01-min-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("633", "3401", "1", "2021/12/01-min-600x600.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("634", "3399", "1", "2021/11/logo-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("635", "3399", "1", "2021/11/logo-min-150x32.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("636", "3399", "1", "2021/11/logo-min-150x36.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("637", "3398", "1", "2021/12/02-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("638", "3398", "1", "2021/12/02-min-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("639", "3398", "1", "2021/12/02-min-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("640", "3398", "1", "2021/12/02-min-600x600.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("641", "3397", "1", "2021/11/footerbg-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("642", "3397", "1", "2021/11/footerbg-min-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("643", "3397", "1", "2021/11/footerbg-min-150x48.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("644", "3397", "1", "2021/11/footerbg-min-600x193.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("645", "3397", "1", "2021/11/footerbg-min-300x97.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("646", "3397", "1", "2021/11/footerbg-min-1024x330.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("647", "3397", "1", "2021/11/footerbg-min-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("648", "3397", "1", "2021/11/footerbg-min-768x247.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("649", "3397", "1", "2021/11/footerbg-min-1536x494.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("650", "3397", "1", "2021/11/footerbg-min-600x600.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("651", "3395", "1", "2021/12/04-min-1.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("652", "3395", "1", "2021/12/04-min-1-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("653", "3395", "1", "2021/12/04-min-1-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("654", "3395", "1", "2021/12/04-min-1-600x600.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("655", "3393", "1", "2021/12/02-min-1.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("656", "3393", "1", "2021/12/02-min-1-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("657", "3393", "1", "2021/12/02-min-1-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("658", "3393", "1", "2021/12/02-min-1-600x600.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("659", "3388", "1", "2022/11/Untitled-14-copy-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("660", "3388", "1", "2022/11/Untitled-14-copy-min-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("661", "3388", "1", "2022/11/Untitled-14-copy-min-150x137.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("662", "3388", "1", "2022/11/Untitled-14-copy-min-300x274.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("663", "3388", "1", "2022/11/Untitled-14-copy-min-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("664", "3387", "1", "2022/11/nokia-150x26-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("665", "3383", "1", "2022/11/honor-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("666", "3382", "1", "2022/11/huawei-150x35-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("667", "3381", "1", "2022/11/samsung-1-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("668", "3376", "1", "2022/11/lg-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("669", "3375", "1", "2022/11/Untitled-12-copy-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("670", "3375", "1", "2022/11/Untitled-12-copy-min-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("671", "3375", "1", "2022/11/Untitled-12-copy-min-150x100.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("672", "3375", "1", "2022/11/Untitled-12-copy-min-600x400.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("673", "3375", "1", "2022/11/Untitled-12-copy-min-300x200.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("674", "3375", "1", "2022/11/Untitled-12-copy-min-1024x683.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("675", "3375", "1", "2022/11/Untitled-12-copy-min-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("676", "3375", "1", "2022/11/Untitled-12-copy-min-768x512.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("677", "3375", "1", "2022/11/Untitled-12-copy-min-600x600.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("678", "3374", "1", "2022/11/Untitled-7-copy-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("679", "3374", "1", "2022/11/Untitled-7-copy-min-300x125.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("680", "3374", "1", "2022/11/Untitled-7-copy-min-150x17.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("681", "3374", "1", "2022/11/Untitled-7-copy-min-600x68.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("682", "3374", "1", "2022/11/Untitled-7-copy-min-300x34.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("683", "3374", "1", "2022/11/Untitled-7-copy-min-1024x117.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("684", "3374", "1", "2022/11/Untitled-7-copy-min-150x125.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("685", "3374", "1", "2022/11/Untitled-7-copy-min-768x88.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("686", "3374", "1", "2022/11/Untitled-7-copy-min-600x125.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("687", "3373", "1", "2022/11/Untitled-8-copy-1-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("688", "3373", "1", "2022/11/Untitled-8-copy-1-min-300x66.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("689", "3373", "1", "2022/11/Untitled-8-copy-1-min-150x16.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("690", "3373", "1", "2022/11/Untitled-8-copy-1-min-600x65.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("691", "3373", "1", "2022/11/Untitled-8-copy-1-min-300x33.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("692", "3373", "1", "2022/11/Untitled-8-copy-1-min-150x66.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("693", "3373", "1", "2022/11/Untitled-8-copy-1-min-600x66.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("694", "3372", "1", "2022/11/rec-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("695", "3371", "1", "2022/11/1-1-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("696", "3371", "1", "2022/11/1-1-min-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("697", "3371", "1", "2022/11/1-1-min-150x131.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("698", "3371", "1", "2022/11/1-1-min-300x263.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("699", "3371", "1", "2022/11/1-1-min-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("700", "3370", "1", "2022/11/5-1-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("701", "3370", "1", "2022/11/5-1-min-300x178.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("702", "3370", "1", "2022/11/5-1-min-150x65.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("703", "3370", "1", "2022/11/5-1-min-300x131.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("704", "3370", "1", "2022/11/5-1-min-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("705", "3369", "1", "2022/11/2-1-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("706", "3369", "1", "2022/11/2-1-min-150x90.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("707", "3369", "1", "2022/11/2-1-min-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("708", "3368", "1", "2022/11/3-1-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("709", "3368", "1", "2022/11/3-1-min-300x180.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("710", "3368", "1", "2022/11/3-1-min-150x52.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("711", "3368", "1", "2022/11/3-1-min-300x103.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("712", "3368", "1", "2022/11/3-1-min-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("713", "3367", "1", "2022/11/4-1-min-1.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("714", "3367", "1", "2022/11/4-1-min-1-300x178.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("715", "3367", "1", "2022/11/4-1-min-1-150x65.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("716", "3367", "1", "2022/11/4-1-min-1-300x131.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("717", "3367", "1", "2022/11/4-1-min-1-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("718", "3365", "1", "2022/11/harajeston-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("719", "3365", "1", "2022/11/harajeston-min-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("720", "3365", "1", "2022/11/harajeston-min-150x48.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("721", "3365", "1", "2022/11/harajeston-min-600x193.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("722", "3365", "1", "2022/11/harajeston-min-300x97.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("723", "3365", "1", "2022/11/harajeston-min-1024x330.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("724", "3365", "1", "2022/11/harajeston-min-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("725", "3365", "1", "2022/11/harajeston-min-768x247.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("726", "3365", "1", "2022/11/harajeston-min-600x460.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("727", "3361", "1", "2022/11/4-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("728", "3360", "1", "2022/11/3-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("729", "3359", "1", "2022/11/2-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("730", "3358", "1", "2022/11/1.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("731", "3353", "1", "2022/11/newbanner-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("732", "3353", "1", "2022/11/newbanner-min-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("733", "3353", "1", "2022/11/newbanner-min-150x42.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("734", "3353", "1", "2022/11/newbanner-min-600x169.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("735", "3353", "1", "2022/11/newbanner-min-300x84.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("736", "3353", "1", "2022/11/newbanner-min-1024x288.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("737", "3353", "1", "2022/11/newbanner-min-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("738", "3353", "1", "2022/11/newbanner-min-768x216.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("739", "3353", "1", "2022/11/newbanner-min-600x378.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("740", "3349", "1", "2022/11/Layer-1222-2-min.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("741", "3349", "1", "2022/11/Layer-1222-2-min-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("742", "3349", "1", "2022/11/Layer-1222-2-min-150x412.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("743", "3349", "1", "2022/11/Layer-1222-2-min-600x1649.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("744", "3349", "1", "2022/11/Layer-1222-2-min-109x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("745", "3349", "1", "2022/11/Layer-1222-2-min-373x1024.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("746", "3349", "1", "2022/11/Layer-1222-2-min-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("747", "3349", "1", "2022/11/Layer-1222-2-min-768x2111.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("748", "3349", "1", "2022/11/Layer-1222-2-min-559x1536.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("749", "3349", "1", "2022/11/Layer-1222-2-min-745x2048.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("750", "3349", "1", "2022/11/Layer-1222-2-min-600x600.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("751", "3341", "1", "revslider/slider-111/Layer-1222-1.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("752", "3341", "1", "revslider/slider-111/Layer-1222-1-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("753", "3341", "1", "revslider/slider-111/Layer-1222-1-150x114.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("754", "3341", "1", "revslider/slider-111/Layer-1222-1-300x228.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("755", "3341", "1", "revslider/slider-111/Layer-1222-1-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("756", "3340", "1", "revslider/slider-111/apple-black-logo.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("757", "3340", "1", "revslider/slider-111/apple-black-logo-139x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("758", "3339", "1", "revslider/slider-111/Rounded-Rectangle-5-4.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("759", "3339", "1", "revslider/slider-111/Rounded-Rectangle-5-4-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("760", "3339", "1", "revslider/slider-111/Rounded-Rectangle-5-4-150x39.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("761", "3339", "1", "revslider/slider-111/Rounded-Rectangle-5-4-600x156.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("762", "3339", "1", "revslider/slider-111/Rounded-Rectangle-5-4-300x78.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("763", "3339", "1", "revslider/slider-111/Rounded-Rectangle-5-4-1024x266.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("764", "3339", "1", "revslider/slider-111/Rounded-Rectangle-5-4-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("765", "3339", "1", "revslider/slider-111/Rounded-Rectangle-5-4-768x199.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("766", "3339", "1", "revslider/slider-111/Rounded-Rectangle-5-4-600x364.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("767", "3338", "1", "revslider/slider-111/Ellipse-2.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("768", "3338", "1", "revslider/slider-111/Ellipse-2-300x42.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("769", "3338", "1", "revslider/slider-111/Ellipse-2-150x10.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("770", "3338", "1", "revslider/slider-111/Ellipse-2-600x39.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("771", "3338", "1", "revslider/slider-111/Ellipse-2-300x20.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("772", "3338", "1", "revslider/slider-111/Ellipse-2-150x42.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("773", "3338", "1", "revslider/slider-111/Ellipse-2-600x42.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("774", "3337", "1", "revslider/slider-111/919ca9f551c967d9631e9a99fe5c115e66a03f68_1610546441.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("775", "3337", "1", "revslider/slider-111/919ca9f551c967d9631e9a99fe5c115e66a03f68_1610546441-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("776", "3337", "1", "revslider/slider-111/919ca9f551c967d9631e9a99fe5c115e66a03f68_1610546441-150x185.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("777", "3337", "1", "revslider/slider-111/919ca9f551c967d9631e9a99fe5c115e66a03f68_1610546441-244x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("778", "3337", "1", "revslider/slider-111/919ca9f551c967d9631e9a99fe5c115e66a03f68_1610546441-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("779", "3336", "1", "revslider/slider-111/Rounded-Rectangle-5-6.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("780", "3336", "1", "revslider/slider-111/Rounded-Rectangle-5-6-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("781", "3336", "1", "revslider/slider-111/Rounded-Rectangle-5-6-150x39.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("782", "3336", "1", "revslider/slider-111/Rounded-Rectangle-5-6-600x156.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("783", "3336", "1", "revslider/slider-111/Rounded-Rectangle-5-6-300x78.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("784", "3336", "1", "revslider/slider-111/Rounded-Rectangle-5-6-1024x266.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("785", "3336", "1", "revslider/slider-111/Rounded-Rectangle-5-6-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("786", "3336", "1", "revslider/slider-111/Rounded-Rectangle-5-6-768x199.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("787", "3336", "1", "revslider/slider-111/Rounded-Rectangle-5-6-600x364.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("788", "6", "1", "woocommerce-placeholder.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("789", "6", "1", "./woocommerce-placeholder-300x300.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("790", "6", "1", "./woocommerce-placeholder-150x150.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("791", "6", "1", "./woocommerce-placeholder-600x600.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("792", "6", "1", "./woocommerce-placeholder-1024x1024.png", "");
INSERT INTO `wp_litespeed_img_optming` VALUES("793", "6", "1", "./woocommerce-placeholder-768x768.png", "");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "siteurl", "http://demoes.aramis-co.ir/woodmartpluss3", "yes");
INSERT INTO `wp_options` VALUES("2", "home", "http://demoes.aramis-co.ir/woodmartpluss3", "yes");
INSERT INTO `wp_options` VALUES("3", "blogname", "وودمارت پلاس 3", "yes");
INSERT INTO `wp_options` VALUES("4", "blogdescription", "", "yes");
INSERT INTO `wp_options` VALUES("5", "users_can_register", "1", "yes");
INSERT INTO `wp_options` VALUES("6", "admin_email", "info@dev-wp.ir", "yes");
INSERT INTO `wp_options` VALUES("7", "start_of_week", "6", "yes");
INSERT INTO `wp_options` VALUES("8", "use_balanceTags", "0", "yes");
INSERT INTO `wp_options` VALUES("9", "use_smilies", "1", "yes");
INSERT INTO `wp_options` VALUES("10", "require_name_email", "1", "yes");
INSERT INTO `wp_options` VALUES("11", "comments_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("12", "posts_per_rss", "10", "yes");
INSERT INTO `wp_options` VALUES("13", "rss_use_excerpt", "0", "yes");
INSERT INTO `wp_options` VALUES("14", "mailserver_url", "mail.example.com", "yes");
INSERT INTO `wp_options` VALUES("15", "mailserver_login", "login@example.com", "yes");
INSERT INTO `wp_options` VALUES("16", "mailserver_pass", "password", "yes");
INSERT INTO `wp_options` VALUES("17", "mailserver_port", "110", "yes");
INSERT INTO `wp_options` VALUES("18", "default_category", "1", "yes");
INSERT INTO `wp_options` VALUES("19", "default_comment_status", "open", "yes");
INSERT INTO `wp_options` VALUES("20", "default_ping_status", "open", "yes");
INSERT INTO `wp_options` VALUES("21", "default_pingback_flag", "1", "yes");
INSERT INTO `wp_options` VALUES("22", "posts_per_page", "10", "yes");
INSERT INTO `wp_options` VALUES("23", "date_format", "F j, Y", "yes");
INSERT INTO `wp_options` VALUES("24", "time_format", "g:i a", "yes");
INSERT INTO `wp_options` VALUES("25", "links_updated_date_format", "F j, Y g:i a", "yes");
INSERT INTO `wp_options` VALUES("26", "comment_moderation", "0", "yes");
INSERT INTO `wp_options` VALUES("27", "moderation_notify", "1", "yes");
INSERT INTO `wp_options` VALUES("28", "permalink_structure", "/%postname%/", "yes");
INSERT INTO `wp_options` VALUES("29", "rewrite_rules", "a:463:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:21:\"^wc/file/transient/?$\";s:33:\"index.php?wc-transient-file-name=\";s:24:\"^wc/file/transient/(.+)$\";s:44:\"index.php?wc-transient-file-name=$matches[1]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:12:\"portfolio/?$\";s:29:\"index.php?post_type=portfolio\";s:42:\"portfolio/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:37:\"portfolio/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:29:\"portfolio/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=portfolio&paged=$matches[1]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:15:\"^checkout-link$\";s:28:\"index.php?checkout-link=true\";s:31:\"^wishlist/([^/]*)/page/([^/]*)?\";s:64:\"index.php?page_id=3334&wishlist_id=$matches[1]&paged=$matches[2]\";s:23:\"^wishlist/page/([^/]*)?\";s:40:\"index.php?page_id=3334&paged=$matches[1]\";s:19:\"^wishlist/([^/]*)/?\";s:46:\"index.php?page_id=3334&wishlist_id=$matches[1]\";s:20:\"dashboard_builder/?$\";s:37:\"index.php?post_type=dashboard_builder\";s:50:\"dashboard_builder/feed/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?post_type=dashboard_builder&feed=$matches[1]\";s:45:\"dashboard_builder/(feed|rdf|rss|rss2|atom)/?$\";s:54:\"index.php?post_type=dashboard_builder&feed=$matches[1]\";s:37:\"dashboard_builder/page/([0-9]{1,})/?$\";s:55:\"index.php?post_type=dashboard_builder&paged=$matches[1]\";s:15:\"wplus_ticket/?$\";s:32:\"index.php?post_type=wplus_ticket\";s:45:\"wplus_ticket/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=wplus_ticket&feed=$matches[1]\";s:40:\"wplus_ticket/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?post_type=wplus_ticket&feed=$matches[1]\";s:32:\"wplus_ticket/page/([0-9]{1,})/?$\";s:50:\"index.php?post_type=wplus_ticket&paged=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:43:\"category/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?category_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:40:\"tag/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?tag=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:46:\"e-floating-buttons/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:56:\"e-floating-buttons/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:76:\"e-floating-buttons/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:71:\"e-floating-buttons/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:52:\"e-floating-buttons/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:35:\"e-floating-buttons/([^/]+)/embed/?$\";s:51:\"index.php?e-floating-buttons=$matches[1]&embed=true\";s:39:\"e-floating-buttons/([^/]+)/trackback/?$\";s:45:\"index.php?e-floating-buttons=$matches[1]&tb=1\";s:47:\"e-floating-buttons/([^/]+)/page/?([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&paged=$matches[2]\";s:54:\"e-floating-buttons/([^/]+)/comment-page-([0-9]{1,})/?$\";s:58:\"index.php?e-floating-buttons=$matches[1]&cpage=$matches[2]\";s:55:\"e-floating-buttons/([^/]+)/wc/file/transient(/(.*))?/?$\";s:70:\"index.php?e-floating-buttons=$matches[1]&wc/file/transient=$matches[3]\";s:44:\"e-floating-buttons/([^/]+)/wc-api(/(.*))?/?$\";s:59:\"index.php?e-floating-buttons=$matches[1]&wc-api=$matches[3]\";s:61:\"e-floating-buttons/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:72:\"e-floating-buttons/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:50:\"e-floating-buttons/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:61:\"e-floating-buttons/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:43:\"e-floating-buttons/([^/]+)(?:/([0-9]+))?/?$\";s:57:\"index.php?e-floating-buttons=$matches[1]&page=$matches[2]\";s:35:\"e-floating-buttons/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"e-floating-buttons/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"e-floating-buttons/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"e-floating-buttons/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"e-floating-buttons/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:43:\"woodmart_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"woodmart_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"woodmart_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"woodmart_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"woodmart_layout/([^/]+)/embed/?$\";s:48:\"index.php?woodmart_layout=$matches[1]&embed=true\";s:36:\"woodmart_layout/([^/]+)/trackback/?$\";s:42:\"index.php?woodmart_layout=$matches[1]&tb=1\";s:44:\"woodmart_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?woodmart_layout=$matches[1]&paged=$matches[2]\";s:51:\"woodmart_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?woodmart_layout=$matches[1]&cpage=$matches[2]\";s:52:\"woodmart_layout/([^/]+)/wc/file/transient(/(.*))?/?$\";s:67:\"index.php?woodmart_layout=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"woodmart_layout/([^/]+)/wc-api(/(.*))?/?$\";s:56:\"index.php?woodmart_layout=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_layout/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:69:\"woodmart_layout/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:47:\"woodmart_layout/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_layout/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:40:\"woodmart_layout/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?woodmart_layout=$matches[1]&page=$matches[2]\";s:32:\"woodmart_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"woodmart_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"woodmart_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"woodmart_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:43:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"woodmart_woo_lv/([^/]+)/embed/?$\";s:48:\"index.php?woodmart_woo_lv=$matches[1]&embed=true\";s:36:\"woodmart_woo_lv/([^/]+)/trackback/?$\";s:42:\"index.php?woodmart_woo_lv=$matches[1]&tb=1\";s:44:\"woodmart_woo_lv/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?woodmart_woo_lv=$matches[1]&paged=$matches[2]\";s:51:\"woodmart_woo_lv/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?woodmart_woo_lv=$matches[1]&cpage=$matches[2]\";s:52:\"woodmart_woo_lv/([^/]+)/wc/file/transient(/(.*))?/?$\";s:67:\"index.php?woodmart_woo_lv=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"woodmart_woo_lv/([^/]+)/wc-api(/(.*))?/?$\";s:56:\"index.php?woodmart_woo_lv=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_woo_lv/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:69:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:47:\"woodmart_woo_lv/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:40:\"woodmart_woo_lv/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?woodmart_woo_lv=$matches[1]&page=$matches[2]\";s:32:\"woodmart_woo_lv/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"woodmart_woo_lv/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"woodmart_woo_lv/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_woo_lv/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_woo_lv/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"woodmart_woo_lv/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"woodmart_woo_fbt/([^/]+)/embed/?$\";s:49:\"index.php?woodmart_woo_fbt=$matches[1]&embed=true\";s:37:\"woodmart_woo_fbt/([^/]+)/trackback/?$\";s:43:\"index.php?woodmart_woo_fbt=$matches[1]&tb=1\";s:45:\"woodmart_woo_fbt/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?woodmart_woo_fbt=$matches[1]&paged=$matches[2]\";s:52:\"woodmart_woo_fbt/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?woodmart_woo_fbt=$matches[1]&cpage=$matches[2]\";s:53:\"woodmart_woo_fbt/([^/]+)/wc/file/transient(/(.*))?/?$\";s:68:\"index.php?woodmart_woo_fbt=$matches[1]&wc/file/transient=$matches[3]\";s:42:\"woodmart_woo_fbt/([^/]+)/wc-api(/(.*))?/?$\";s:57:\"index.php?woodmart_woo_fbt=$matches[1]&wc-api=$matches[3]\";s:59:\"woodmart_woo_fbt/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:70:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:48:\"woodmart_woo_fbt/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:59:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:41:\"woodmart_woo_fbt/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?woodmart_woo_fbt=$matches[1]&page=$matches[2]\";s:33:\"woodmart_woo_fbt/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"woodmart_woo_fbt/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"woodmart_woo_fbt/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"woodmart_woo_fbt/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"woodmart_woo_fbt/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"woodmart_woo_fbt/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:53:\"wd_popup_cat/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?wd_popup_cat=$matches[1]&feed=$matches[2]\";s:48:\"wd_popup_cat/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?wd_popup_cat=$matches[1]&feed=$matches[2]\";s:29:\"wd_popup_cat/([^/]+)/embed/?$\";s:45:\"index.php?wd_popup_cat=$matches[1]&embed=true\";s:41:\"wd_popup_cat/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?wd_popup_cat=$matches[1]&paged=$matches[2]\";s:23:\"wd_popup_cat/([^/]+)/?$\";s:34:\"index.php?wd_popup_cat=$matches[1]\";s:62:\"wd_floating_block_cat/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:60:\"index.php?wd_floating_block_cat=$matches[1]&feed=$matches[2]\";s:57:\"wd_floating_block_cat/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:60:\"index.php?wd_floating_block_cat=$matches[1]&feed=$matches[2]\";s:38:\"wd_floating_block_cat/([^/]+)/embed/?$\";s:54:\"index.php?wd_floating_block_cat=$matches[1]&embed=true\";s:50:\"wd_floating_block_cat/([^/]+)/page/?([0-9]{1,})/?$\";s:61:\"index.php?wd_floating_block_cat=$matches[1]&paged=$matches[2]\";s:32:\"wd_floating_block_cat/([^/]+)/?$\";s:43:\"index.php?wd_floating_block_cat=$matches[1]\";s:54:\"cms_block_cat/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?cms_block_cat=$matches[1]&feed=$matches[2]\";s:49:\"cms_block_cat/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?cms_block_cat=$matches[1]&feed=$matches[2]\";s:30:\"cms_block_cat/([^/]+)/embed/?$\";s:46:\"index.php?cms_block_cat=$matches[1]&embed=true\";s:42:\"cms_block_cat/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?cms_block_cat=$matches[1]&paged=$matches[2]\";s:24:\"cms_block_cat/([^/]+)/?$\";s:35:\"index.php?cms_block_cat=$matches[1]\";s:42:\"woodmart_slide/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"woodmart_slide/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"woodmart_slide/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"woodmart_slide/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"woodmart_slide/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"woodmart_slide/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"woodmart_slide/([^/]+)/embed/?$\";s:47:\"index.php?woodmart_slide=$matches[1]&embed=true\";s:35:\"woodmart_slide/([^/]+)/trackback/?$\";s:41:\"index.php?woodmart_slide=$matches[1]&tb=1\";s:43:\"woodmart_slide/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?woodmart_slide=$matches[1]&paged=$matches[2]\";s:50:\"woodmart_slide/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?woodmart_slide=$matches[1]&cpage=$matches[2]\";s:51:\"woodmart_slide/([^/]+)/wc/file/transient(/(.*))?/?$\";s:66:\"index.php?woodmart_slide=$matches[1]&wc/file/transient=$matches[3]\";s:40:\"woodmart_slide/([^/]+)/wc-api(/(.*))?/?$\";s:55:\"index.php?woodmart_slide=$matches[1]&wc-api=$matches[3]\";s:57:\"woodmart_slide/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:68:\"woodmart_slide/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:46:\"woodmart_slide/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:57:\"woodmart_slide/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:39:\"woodmart_slide/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?woodmart_slide=$matches[1]&page=$matches[2]\";s:31:\"woodmart_slide/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"woodmart_slide/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"woodmart_slide/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"woodmart_slide/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"woodmart_slide/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"woodmart_slide/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:56:\"woodmart_slider/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:68:\"index.php?taxonomy=woodmart_slider&term=$matches[1]&feed=$matches[2]\";s:51:\"woodmart_slider/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:68:\"index.php?taxonomy=woodmart_slider&term=$matches[1]&feed=$matches[2]\";s:32:\"woodmart_slider/([^/]+)/embed/?$\";s:62:\"index.php?taxonomy=woodmart_slider&term=$matches[1]&embed=true\";s:44:\"woodmart_slider/([^/]+)/page/?([0-9]{1,})/?$\";s:69:\"index.php?taxonomy=woodmart_slider&term=$matches[1]&paged=$matches[2]\";s:26:\"woodmart_slider/([^/]+)/?$\";s:51:\"index.php?taxonomy=woodmart_slider&term=$matches[1]\";s:37:\"portfolio/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"portfolio/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:30:\"portfolio/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:50:\"portfolio/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:45:\"portfolio/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:38:\"portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:45:\"portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:46:\"portfolio/([^/]+)/wc/file/transient(/(.*))?/?$\";s:61:\"index.php?portfolio=$matches[1]&wc/file/transient=$matches[3]\";s:35:\"portfolio/([^/]+)/wc-api(/(.*))?/?$\";s:50:\"index.php?portfolio=$matches[1]&wc-api=$matches[3]\";s:52:\"portfolio/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:63:\"portfolio/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"portfolio/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:52:\"portfolio/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:34:\"portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:26:\"portfolio/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"portfolio/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"portfolio/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:50:\"project-cat/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project-cat=$matches[1]&feed=$matches[2]\";s:45:\"project-cat/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project-cat=$matches[1]&feed=$matches[2]\";s:26:\"project-cat/(.+?)/embed/?$\";s:44:\"index.php?project-cat=$matches[1]&embed=true\";s:38:\"project-cat/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?project-cat=$matches[1]&paged=$matches[2]\";s:20:\"project-cat/(.+?)/?$\";s:33:\"index.php?project-cat=$matches[1]\";s:47:\"برند/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:42:\"برند/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:23:\"برند/(.+?)/embed/?$\";s:46:\"index.php?product_brand=$matches[1]&embed=true\";s:35:\"برند/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?product_brand=$matches[1]&paged=$matches[2]\";s:17:\"برند/(.+?)/?$\";s:35:\"index.php?product_brand=$matches[1]\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:35:\"product/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:45:\"product/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:65:\"product/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:60:\"product/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:41:\"product/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:24:\"product/([^/]+)/embed/?$\";s:40:\"index.php?product=$matches[1]&embed=true\";s:28:\"product/([^/]+)/trackback/?$\";s:34:\"index.php?product=$matches[1]&tb=1\";s:48:\"product/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:43:\"product/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?product=$matches[1]&feed=$matches[2]\";s:36:\"product/([^/]+)/page/?([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&paged=$matches[2]\";s:43:\"product/([^/]+)/comment-page-([0-9]{1,})/?$\";s:47:\"index.php?product=$matches[1]&cpage=$matches[2]\";s:44:\"product/([^/]+)/wc/file/transient(/(.*))?/?$\";s:59:\"index.php?product=$matches[1]&wc/file/transient=$matches[3]\";s:33:\"product/([^/]+)/wc-api(/(.*))?/?$\";s:48:\"index.php?product=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:61:\"product/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:39:\"product/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:50:\"product/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:32:\"product/([^/]+)(?:/([0-9]+))?/?$\";s:46:\"index.php?product=$matches[1]&page=$matches[2]\";s:24:\"product/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:34:\"product/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:54:\"product/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:49:\"product/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:30:\"product/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:58:\"priorities_ticket/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?priorities_ticket=$matches[1]&feed=$matches[2]\";s:53:\"priorities_ticket/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?priorities_ticket=$matches[1]&feed=$matches[2]\";s:34:\"priorities_ticket/([^/]+)/embed/?$\";s:50:\"index.php?priorities_ticket=$matches[1]&embed=true\";s:46:\"priorities_ticket/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?priorities_ticket=$matches[1]&paged=$matches[2]\";s:28:\"priorities_ticket/([^/]+)/?$\";s:39:\"index.php?priorities_ticket=$matches[1]\";s:57:\"departman_ticket/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?departman_ticket=$matches[1]&feed=$matches[2]\";s:52:\"departman_ticket/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?departman_ticket=$matches[1]&feed=$matches[2]\";s:33:\"departman_ticket/([^/]+)/embed/?$\";s:49:\"index.php?departman_ticket=$matches[1]&embed=true\";s:45:\"departman_ticket/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?departman_ticket=$matches[1]&paged=$matches[2]\";s:27:\"departman_ticket/([^/]+)/?$\";s:38:\"index.php?departman_ticket=$matches[1]\";s:45:\"dashboard_builder/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:55:\"dashboard_builder/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:75:\"dashboard_builder/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"dashboard_builder/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:70:\"dashboard_builder/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:51:\"dashboard_builder/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:34:\"dashboard_builder/([^/]+)/embed/?$\";s:50:\"index.php?dashboard_builder=$matches[1]&embed=true\";s:38:\"dashboard_builder/([^/]+)/trackback/?$\";s:44:\"index.php?dashboard_builder=$matches[1]&tb=1\";s:58:\"dashboard_builder/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?dashboard_builder=$matches[1]&feed=$matches[2]\";s:53:\"dashboard_builder/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:56:\"index.php?dashboard_builder=$matches[1]&feed=$matches[2]\";s:46:\"dashboard_builder/([^/]+)/page/?([0-9]{1,})/?$\";s:57:\"index.php?dashboard_builder=$matches[1]&paged=$matches[2]\";s:53:\"dashboard_builder/([^/]+)/comment-page-([0-9]{1,})/?$\";s:57:\"index.php?dashboard_builder=$matches[1]&cpage=$matches[2]\";s:54:\"dashboard_builder/([^/]+)/wc/file/transient(/(.*))?/?$\";s:69:\"index.php?dashboard_builder=$matches[1]&wc/file/transient=$matches[3]\";s:43:\"dashboard_builder/([^/]+)/wc-api(/(.*))?/?$\";s:58:\"index.php?dashboard_builder=$matches[1]&wc-api=$matches[3]\";s:60:\"dashboard_builder/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:71:\"dashboard_builder/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:49:\"dashboard_builder/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:60:\"dashboard_builder/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"dashboard_builder/([^/]+)(?:/([0-9]+))?/?$\";s:56:\"index.php?dashboard_builder=$matches[1]&page=$matches[2]\";s:34:\"dashboard_builder/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:44:\"dashboard_builder/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:64:\"dashboard_builder/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"dashboard_builder/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:59:\"dashboard_builder/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:40:\"dashboard_builder/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:40:\"wplus_ticket/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:50:\"wplus_ticket/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:70:\"wplus_ticket/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"wplus_ticket/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:65:\"wplus_ticket/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:46:\"wplus_ticket/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:29:\"wplus_ticket/([^/]+)/embed/?$\";s:45:\"index.php?wplus_ticket=$matches[1]&embed=true\";s:33:\"wplus_ticket/([^/]+)/trackback/?$\";s:39:\"index.php?wplus_ticket=$matches[1]&tb=1\";s:53:\"wplus_ticket/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?wplus_ticket=$matches[1]&feed=$matches[2]\";s:48:\"wplus_ticket/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:51:\"index.php?wplus_ticket=$matches[1]&feed=$matches[2]\";s:41:\"wplus_ticket/([^/]+)/page/?([0-9]{1,})/?$\";s:52:\"index.php?wplus_ticket=$matches[1]&paged=$matches[2]\";s:48:\"wplus_ticket/([^/]+)/comment-page-([0-9]{1,})/?$\";s:52:\"index.php?wplus_ticket=$matches[1]&cpage=$matches[2]\";s:49:\"wplus_ticket/([^/]+)/wc/file/transient(/(.*))?/?$\";s:64:\"index.php?wplus_ticket=$matches[1]&wc/file/transient=$matches[3]\";s:38:\"wplus_ticket/([^/]+)/wc-api(/(.*))?/?$\";s:53:\"index.php?wplus_ticket=$matches[1]&wc-api=$matches[3]\";s:55:\"wplus_ticket/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:66:\"wplus_ticket/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:44:\"wplus_ticket/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:55:\"wplus_ticket/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:37:\"wplus_ticket/([^/]+)(?:/([0-9]+))?/?$\";s:51:\"index.php?wplus_ticket=$matches[1]&page=$matches[2]\";s:29:\"wplus_ticket/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:39:\"wplus_ticket/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:59:\"wplus_ticket/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"wplus_ticket/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:54:\"wplus_ticket/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:35:\"wplus_ticket/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\"wplus_ticket_message/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:58:\"wplus_ticket_message/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:78:\"wplus_ticket_message/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:73:\"wplus_ticket_message/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:73:\"wplus_ticket_message/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:54:\"wplus_ticket_message/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:37:\"wplus_ticket_message/([^/]+)/embed/?$\";s:53:\"index.php?wplus_ticket_message=$matches[1]&embed=true\";s:41:\"wplus_ticket_message/([^/]+)/trackback/?$\";s:47:\"index.php?wplus_ticket_message=$matches[1]&tb=1\";s:49:\"wplus_ticket_message/([^/]+)/page/?([0-9]{1,})/?$\";s:60:\"index.php?wplus_ticket_message=$matches[1]&paged=$matches[2]\";s:56:\"wplus_ticket_message/([^/]+)/comment-page-([0-9]{1,})/?$\";s:60:\"index.php?wplus_ticket_message=$matches[1]&cpage=$matches[2]\";s:57:\"wplus_ticket_message/([^/]+)/wc/file/transient(/(.*))?/?$\";s:72:\"index.php?wplus_ticket_message=$matches[1]&wc/file/transient=$matches[3]\";s:46:\"wplus_ticket_message/([^/]+)/wc-api(/(.*))?/?$\";s:61:\"index.php?wplus_ticket_message=$matches[1]&wc-api=$matches[3]\";s:63:\"wplus_ticket_message/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:74:\"wplus_ticket_message/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:52:\"wplus_ticket_message/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:63:\"wplus_ticket_message/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:45:\"wplus_ticket_message/([^/]+)(?:/([0-9]+))?/?$\";s:59:\"index.php?wplus_ticket_message=$matches[1]&page=$matches[2]\";s:37:\"wplus_ticket_message/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"wplus_ticket_message/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"wplus_ticket_message/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"wplus_ticket_message/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"wplus_ticket_message/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"wplus_ticket_message/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:57:\"shipping_company/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?shipping_company=$matches[1]&feed=$matches[2]\";s:52:\"shipping_company/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:55:\"index.php?shipping_company=$matches[1]&feed=$matches[2]\";s:33:\"shipping_company/([^/]+)/embed/?$\";s:49:\"index.php?shipping_company=$matches[1]&embed=true\";s:45:\"shipping_company/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?shipping_company=$matches[1]&paged=$matches[2]\";s:27:\"shipping_company/([^/]+)/?$\";s:38:\"index.php?shipping_company=$matches[1]\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:39:\"index.php?&page_id=57&cpage=$matches[1]\";s:28:\"wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:20:\"wc-wallet(/(.*))?/?$\";s:32:\"index.php?&wc-wallet=$matches[2]\";s:18:\"tickets(/(.*))?/?$\";s:30:\"index.php?&tickets=$matches[2]\";s:17:\"offers(/(.*))?/?$\";s:29:\"index.php?&offers=$matches[2]\";s:24:\"notifications(/(.*))?/?$\";s:36:\"index.php?&notifications=$matches[2]\";s:25:\"wplus_feedback(/(.*))?/?$\";s:37:\"index.php?&wplus_feedback=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:37:\"comments/wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:40:\"search/(.+)/wc/file/transient(/(.*))?/?$\";s:53:\"index.php?s=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:43:\"author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?author_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc/file/transient=$matches[5]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:52:\"([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:77:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc/file/transient=$matches[4]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:39:\"([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?year=$matches[1]&wc/file/transient=$matches[3]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:36:\"(.?.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?pagename=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:28:\"(.?.+?)/wc-wallet(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&wc-wallet=$matches[3]\";s:26:\"(.?.+?)/tickets(/(.*))?/?$\";s:50:\"index.php?pagename=$matches[1]&tickets=$matches[3]\";s:25:\"(.?.+?)/offers(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&offers=$matches[3]\";s:32:\"(.?.+?)/notifications(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&notifications=$matches[3]\";s:33:\"(.?.+?)/wplus_feedback(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&wplus_feedback=$matches[3]\";s:42:\".?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\".?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:36:\"([^/]+)/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?name=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\"[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "yes");
INSERT INTO `wp_options` VALUES("30", "hack_file", "0", "yes");
INSERT INTO `wp_options` VALUES("31", "blog_charset", "UTF-8", "yes");
INSERT INTO `wp_options` VALUES("32", "moderation_keys", "", "no");
INSERT INTO `wp_options` VALUES("33", "active_plugins", "a:9:{i:0;s:29:\"RTL-CareUnit/RTL-CareUnit.php\";i:1;s:33:\"classic-editor/classic-editor.php\";i:2;s:35:\"classic-widgets/classic-widgets.php\";i:3;s:25:\"duplicator/duplicator.php\";i:4;s:23:\"elementor/elementor.php\";i:5;s:23:\"revslider/revslider.php\";i:6;s:27:\"woocommerce/woocommerce.php\";i:7;s:31:\"woodmart-core/woodmart-core.php\";i:8;s:31:\"woodmart-plus/woodmart-plus.php\";}", "yes");
INSERT INTO `wp_options` VALUES("34", "category_base", "", "yes");
INSERT INTO `wp_options` VALUES("35", "ping_sites", "https://rpc.pingomatic.com/", "yes");
INSERT INTO `wp_options` VALUES("36", "comment_max_links", "2", "yes");
INSERT INTO `wp_options` VALUES("37", "gmt_offset", "", "yes");
INSERT INTO `wp_options` VALUES("38", "default_email_category", "1", "yes");
INSERT INTO `wp_options` VALUES("39", "recently_edited", "a:5:{i:0;s:106:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/woodmartpluss3/wp-content/themes/woodmart/style.css\";i:1;s:110:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/woodmartpluss3/wp-content/themes/woodmart/functions.php\";i:3;s:114:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/woodmartpluss3/wp-content/plugins/duplicator/duplicator.php\";i:4;s:127:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/woodmartpluss3/wp-content/themes/woodmart/inc/admin/assets/js/builder.js\";i:5;s:136:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/woodmartpluss3/wp-content/plugins/woodmart-plus/inc/elementor/builder/builder.php\";}", "no");
INSERT INTO `wp_options` VALUES("40", "template", "woodmart", "yes");
INSERT INTO `wp_options` VALUES("41", "stylesheet", "woodmart", "yes");
INSERT INTO `wp_options` VALUES("42", "comment_registration", "0", "yes");
INSERT INTO `wp_options` VALUES("43", "html_type", "text/html", "yes");
INSERT INTO `wp_options` VALUES("44", "use_trackback", "0", "yes");
INSERT INTO `wp_options` VALUES("45", "default_role", "subscriber", "yes");
INSERT INTO `wp_options` VALUES("46", "db_version", "60421", "yes");
INSERT INTO `wp_options` VALUES("47", "uploads_use_yearmonth_folders", "1", "yes");
INSERT INTO `wp_options` VALUES("48", "upload_path", "", "yes");
INSERT INTO `wp_options` VALUES("49", "blog_public", "1", "yes");
INSERT INTO `wp_options` VALUES("50", "default_link_category", "2", "yes");
INSERT INTO `wp_options` VALUES("51", "show_on_front", "page", "yes");
INSERT INTO `wp_options` VALUES("52", "tag_base", "", "yes");
INSERT INTO `wp_options` VALUES("53", "show_avatars", "1", "yes");
INSERT INTO `wp_options` VALUES("54", "avatar_rating", "G", "yes");
INSERT INTO `wp_options` VALUES("55", "upload_url_path", "", "yes");
INSERT INTO `wp_options` VALUES("56", "thumbnail_size_w", "150", "yes");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_h", "150", "yes");
INSERT INTO `wp_options` VALUES("58", "thumbnail_crop", "1", "yes");
INSERT INTO `wp_options` VALUES("59", "medium_size_w", "300", "yes");
INSERT INTO `wp_options` VALUES("60", "medium_size_h", "300", "yes");
INSERT INTO `wp_options` VALUES("61", "avatar_default", "mystery", "yes");
INSERT INTO `wp_options` VALUES("62", "large_size_w", "1024", "yes");
INSERT INTO `wp_options` VALUES("63", "large_size_h", "1024", "yes");
INSERT INTO `wp_options` VALUES("64", "image_default_link_type", "none", "yes");
INSERT INTO `wp_options` VALUES("65", "image_default_size", "", "yes");
INSERT INTO `wp_options` VALUES("66", "image_default_align", "", "yes");
INSERT INTO `wp_options` VALUES("67", "close_comments_for_old_posts", "0", "yes");
INSERT INTO `wp_options` VALUES("68", "close_comments_days_old", "14", "yes");
INSERT INTO `wp_options` VALUES("69", "thread_comments", "1", "yes");
INSERT INTO `wp_options` VALUES("70", "thread_comments_depth", "5", "yes");
INSERT INTO `wp_options` VALUES("71", "page_comments", "0", "yes");
INSERT INTO `wp_options` VALUES("72", "comments_per_page", "50", "yes");
INSERT INTO `wp_options` VALUES("73", "default_comments_page", "newest", "yes");
INSERT INTO `wp_options` VALUES("74", "comment_order", "asc", "yes");
INSERT INTO `wp_options` VALUES("75", "sticky_posts", "a:0:{}", "yes");
INSERT INTO `wp_options` VALUES("76", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("77", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("78", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("79", "uninstall_plugins", "a:5:{s:24:\"elementor2/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:27:\"wp-optimize/wp-optimize.php\";a:2:{i:0;s:13:\"WPO_Uninstall\";i:1;s:7:\"actions\";}s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}s:35:\"litespeed-cache/litespeed-cache.php\";s:47:\"LiteSpeed\\Activation::uninstall_litespeed_cache\";s:49:\"advanced-database-cleaner/advanced-db-cleaner.php\";a:2:{i:0;s:24:\"ADBC_Advanced_DB_Cleaner\";i:1;s:14:\"aDBc_uninstall\";}}", "no");
INSERT INTO `wp_options` VALUES("80", "timezone_string", "Atlantic/Azores", "yes");
INSERT INTO `wp_options` VALUES("81", "page_for_posts", "3248", "yes");
INSERT INTO `wp_options` VALUES("82", "page_on_front", "57", "yes");
INSERT INTO `wp_options` VALUES("83", "default_post_format", "0", "yes");
INSERT INTO `wp_options` VALUES("84", "link_manager_enabled", "0", "yes");
INSERT INTO `wp_options` VALUES("85", "finished_splitting_shared_terms", "1", "yes");
INSERT INTO `wp_options` VALUES("86", "site_icon", "4163", "yes");
INSERT INTO `wp_options` VALUES("87", "medium_large_size_w", "768", "yes");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_h", "0", "yes");
INSERT INTO `wp_options` VALUES("89", "wp_page_for_privacy_policy", "3", "yes");
INSERT INTO `wp_options` VALUES("90", "show_comments_cookies_opt_in", "1", "yes");
INSERT INTO `wp_options` VALUES("91", "admin_email_lifespan", "1765534543", "yes");
INSERT INTO `wp_options` VALUES("92", "disallowed_keys", "", "no");
INSERT INTO `wp_options` VALUES("93", "comment_previously_approved", "1", "yes");
INSERT INTO `wp_options` VALUES("94", "auto_plugin_theme_update_emails", "a:0:{}", "no");
INSERT INTO `wp_options` VALUES("95", "auto_update_core_dev", "enabled", "yes");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_minor", "enabled", "yes");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_major", "enabled", "yes");
INSERT INTO `wp_options` VALUES("98", "wp_force_deactivated_plugins", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("99", "initial_db_version", "53496", "yes");
INSERT INTO `wp_options` VALUES("100", "wp_user_roles", "a:8:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:130:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:15:\"manage_security\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:23:\"wf2fa_activate_2fa_self\";b:1;s:25:\"wf2fa_activate_2fa_others\";b:1;s:21:\"wf2fa_manage_settings\";b:1;s:21:\"rocket_manage_options\";b:1;s:18:\"rocket_purge_cache\";b:1;s:18:\"rocket_purge_posts\";b:1;s:18:\"rocket_purge_terms\";b:1;s:18:\"rocket_purge_users\";b:1;s:29:\"rocket_purge_cloudflare_cache\";b:1;s:25:\"rocket_purge_sucuri_cache\";b:1;s:20:\"rocket_preload_cache\";b:1;s:30:\"rocket_regenerate_critical_css\";b:1;s:24:\"rocket_remove_unused_css\";b:1;s:10:\"loco_admin\";b:1;s:16:\"create_customers\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:3:{s:4:\"read\";b:1;s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:93:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:16:\"create_customers\";b:1;}}s:10:\"translator\";a:2:{s:4:\"name\";s:10:\"Translator\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:10:\"loco_admin\";b:1;}}}", "on");
INSERT INTO `wp_options` VALUES("101", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("102", "WPLANG", "fa_IR", "yes");
INSERT INTO `wp_options` VALUES("103", "user_count", "1", "off");
INSERT INTO `wp_options` VALUES("104", "widget_block", "a:2:{i:6;a:1:{s:7:\"content\";s:155:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>دسته‌ها</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("105", "sidebars_widgets", "a:11:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:23:\"woodmart-recent-posts-2\";i:1;s:30:\"woodmart-woocommerce-sort-by-2\";}s:9:\"sidebar-1\";a:2:{i:0;s:23:\"woodmart-recent-posts-3\";i:1;s:7:\"block-6\";}s:22:\"portfolio-widgets-area\";a:0:{}s:12:\"sidebar-shop\";a:5:{i:0;s:24:\"wd-widget-stock-status-2\";i:1;s:26:\"woocommerce_price_filter-3\";i:2;s:34:\"woodmart-woocommerce-layered-nav-2\";i:3;s:34:\"woodmart-woocommerce-layered-nav-3\";i:4;s:27:\"woocommerce_rating_filter-2\";}s:12:\"filters-area\";a:3:{i:0;s:33:\"woocommerce_layered_nav_filters-2\";i:1;s:25:\"woocommerce_layered_nav-2\";i:2;s:33:\"woocommerce_layered_nav_filters-3\";}s:22:\"sidebar-product-single\";a:1:{i:0;s:13:\"custom_html-2\";}s:18:\"sidebar-my-account\";a:0:{}s:24:\"sidebar-full-screen-menu\";a:0:{}s:19:\"mobile-menu-widgets\";a:0:{}s:8:\"footer-1\";a:0:{}s:13:\"array_version\";i:3;}", "yes");
INSERT INTO `wp_options` VALUES("106", "cron", "a:79:{i:1685962372;a:1:{s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1685963093;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1685964667;a:1:{s:40:\"woodmart_wishlist_send_promotional_email\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1685965751;a:1:{s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1685968506;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1685978628;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1685990809;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1685990851;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1685990868;a:1:{s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1686034033;a:1:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1686034068;a:2:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1686034272;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1686466009;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1689513080;a:1:{s:30:\"generate_category_lookup_table\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1691492640;a:2:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1691613074;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1694282839;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"bd4267ddeeb93986799c4a2f75f8b861\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4015;}}}}i:1694868890;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"b87a5479b0e8e51d227310cd21347f15\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4039;}}}}i:1697648615;a:1:{s:31:\"woocommerce_flush_rewrite_rules\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1701256814;a:1:{s:21:\"wpo_weekly_cron_tasks\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1701260413;a:1:{s:29:\"wpo_smush_clear_backup_images\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1701303611;a:1:{s:26:\"wpo_minify_purge_old_cache\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1701346814;a:1:{s:19:\"wpo_purge_old_cache\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:19:\"wpo_purge_old_cache\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1705687570;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"f7dc32c29c9bc163b66e5801462db812\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4244;}}}}i:1705687725;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"87790d7da50e07591d1e56d75a23b369\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4245;}}}}i:1705737931;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"8bd89b3fc255d4546b001cdb30e9d823\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4247;}}}}i:1708525356;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"c67102b9397a9270fc086d343b75841c\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4309;}}}}i:1714761655;a:1:{s:23:\"wordfence_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1714761662;a:1:{s:21:\"wordfence_ls_ntp_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1714761667;a:2:{s:20:\"wordfence_daily_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"wordfence_hourly_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1715011200;a:1:{s:31:\"wordfence_email_activity_report\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1716662386;a:1:{s:27:\"wordfence_processAttackData\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1718367243;a:1:{s:35:\"wordfence_batchReportFailedAttempts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1721836757;a:1:{s:40:\"wordfence_completeCoreUpdateNotification\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1722435814;a:1:{s:27:\"rocket_update_dynamic_lists\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1722436414;a:1:{s:36:\"rocket_preload_clean_rows_time_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1722746442;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"7cb242fea07c5619ca2eea8c1a21351b\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4467;}}}}i:1722746504;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"60a8db783e93832480300a113b2d4cff\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4468;}}}}i:1722746672;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"2c30c707cebadf99fbd13bb0274e4da7\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4469;}}}}i:1722746744;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"8dad5b2fc4482da03dc589f6feb40f0c\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4470;}}}}i:1722746832;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"1c7e221311c132a3cd2b792abedd66e4\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4471;}}}}i:1722746909;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"a4c0bedce1a430b50bbff94fa4cb3d70\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4472;}}}}i:1722746974;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"6a87a06c01a1e64dadbdcd58b4004bcd\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4473;}}}}i:1722747163;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"6fe6e939d3c5ab8e0b44276413acb4e0\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4474;}}}}i:1726495657;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"b822bb939b9fb7dca515f72393b2f1f6\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4498;}}}}i:1728398920;a:1:{s:37:\"puc_cron_check_updates-woodapp-wc-api\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1728416268;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"ae7622b91af0cd26386e47bfca76afef\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4509;}}}}i:1728416529;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"1d51cf9350d4ebccc6ad695200d06101\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4510;}}}}i:1728416944;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"1c18a4ae63e648832d147a3ad3addfdf\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4511;}}}}i:1730652853;a:1:{s:26:\"importer_scheduled_cleanup\";a:1:{s:32:\"69c18bfacca3afc05bd04d34df3ddec2\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4522;}}}}i:1730652876;a:1:{s:26:\"importer_scheduled_cleanup\";a:1:{s:32:\"53264d448ed203a132588de5782d1e13\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4523;}}}}i:1730652895;a:1:{s:26:\"importer_scheduled_cleanup\";a:1:{s:32:\"873524cb5ae7cdd68348b04f9c6304c5\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4524;}}}}i:1732001085;a:1:{s:13:\"rsmAutoUpdate\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1732003935;a:1:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1732003937;a:1:{s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1732008197;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"2d08fe1e1190ba453a86b51edda9f9e5\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4556;}}}}i:1732111362;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"af8e8a15396fd6b7bd45651f8de4ef74\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4558;}}}}i:1732111994;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"1576e633a6db0c8e715a4828e4362171\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4559;}}}}i:1732694020;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"54b2bdc98ada019461c8ad0ffb3d5539\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4564;}}}}i:1733910639;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"ab7d26b4d4181112345d4c455806f888\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4885;}}}}i:1733910836;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"1a18e06a82a3bb75defabc67e981f722\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4886;}}}}i:1733911744;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"4fd8a1a2962742fa45874d39d400d889\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4887;}}}}i:1733913111;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"3ac45318dc1d58bb7ca9cea90019aa2c\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:4888;}}}}i:1734951586;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"baed96308cb74f97ce9c95ec410340bf\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:5068;}}}}i:1734955824;a:1:{s:45:\"woocommerce_marketplace_cron_fetch_promotions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1734963079;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"19554a877ff4b2cafcde21b988fd118f\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:5070;}}}}i:1740997554;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"c1f5d3a8cea24ebf9ae1224d4c5721eb\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:5121;}}}}i:1741145621;a:1:{s:32:\"connect_hook_send_notif_feedback\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:17:\"every_two_minutes\";s:4:\"args\";a:0:{}s:8:\"interval\";i:120;}}}i:1741388140;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"fca3d084f72583102a94608f2acf0209\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:5154;}}}}i:1741657084;a:1:{s:36:\"puc_cron_check_updates-woodmart-plus\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1745231892;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"14906e3311365debf05a072e6bf59cb9\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:5228;}}}}i:1755548974;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1758075752;a:1:{s:43:\"connect_hook_send_notif_product_leave_cart1\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"every_hour\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1758549600;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1758635662;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1759226428;a:1:{s:24:\"remove_cashback_time_use\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1759233615;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"b1b4a313d6ffadf2ea37c48eda92f058\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:5465;}}}}i:1760256971;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"1fe8bc9621d26370a681488e77977698\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:5468;}}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("107", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("108", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("109", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("110", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("111", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("112", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("113", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("114", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("115", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("116", "nonce_key", "Eqmt^7bLTMEE6[Fk>C+ee 7=;&,wDpZaSQ.UM!GIC:g3IJ}#8glq3b!OyTFWFyN{", "no");
INSERT INTO `wp_options` VALUES("117", "nonce_salt", "F04tV$%G&=M|En7m)kUsVuJ{-UW`L),+>>vByZ[S?u2IZ7F87gW5y5Et)-C]4nrm", "no");
INSERT INTO `wp_options` VALUES("118", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("119", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("120", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("121", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("122", "widget_custom_html", "a:2:{i:2;a:2:{s:5:\"title\";s:0:\"\";s:7:\"content\";s:460:\"<div  class=\"listproduct\">\r\n<h4>ویژگی&zwnj;های محصول</h4>\r\n<ul>\r\n<li>حاوی 70 درصد الکل خالص</li>\r\n<li>آنتی باکتریال و ضدعفونی کننده</li>\r\n<li>بدون نیاز به آبکشی</li>\r\n<li>قابل حمل</li>\r\n	<li>حاوی 70 درصد الکل خالص</li>\r\n<li>آنتی باکتریال و ضدعفونی کننده</li>\r\n<li>بدون نیاز به آبکشی</li>\r\n<li>قابل حمل</li>\r\n</ul>\r\n</div>\";}s:12:\"_multiwidget\";i:1;}", "yes");
INSERT INTO `wp_options` VALUES("126", "theme_mods_twentytwentythree", "a:3:{s:18:\"custom_css_post_id\";i:-1;s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1668840474;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}s:18:\"nav_menu_locations\";a:0:{}}", "no");
INSERT INTO `wp_options` VALUES("129", "recovery_keys", "a:25:{s:22:\"uOiePp4Hs7ah4T3us8ilyh\";a:2:{s:10:\"hashed_key\";s:34:\"$P$B9vV..cw.0yOXvVxPVlGJ1P2iC6F7l1\";s:10:\"created_at\";i:1689513465;}s:22:\"hUcnMTwJhg8e4qARqjFjHp\";a:2:{s:10:\"hashed_key\";s:34:\"$P$BXSXurNbKLtoUnIV2NQi6TMuUYNdXK0\";s:10:\"created_at\";i:1691854817;}s:22:\"ShnbqSLeZzNLhmEymDoygr\";a:2:{s:10:\"hashed_key\";s:34:\"$P$BBigwGopnVu1QVgvT1smO.OpDdj8o2/\";s:10:\"created_at\";i:1694427123;}s:22:\"L0i7eMa1yRchEh22ezxn80\";a:2:{s:10:\"hashed_key\";s:34:\"$P$B0musojLeJEm9U0drK2dKjeqUcbueE.\";s:10:\"created_at\";i:1701088242;}s:22:\"qfbTqNYjjsMsYhMcokXhPJ\";a:2:{s:10:\"hashed_key\";s:34:\"$P$BqlGbA9q1wT0ejeaaIOME5IB1ujIxs0\";s:10:\"created_at\";i:1705127488;}s:22:\"GWiiiRI8vMSmDGunosFId8\";a:2:{s:10:\"hashed_key\";s:34:\"$P$B6ZgeRYFkWlcvO7xbkXb9he1VNHvoi.\";s:10:\"created_at\";i:1705752271;}s:22:\"0gTaeENqNfH31jSlSVjJ7o\";a:2:{s:10:\"hashed_key\";s:34:\"$P$BU0EXQQqbCKpdS.4tofETmjD678KN./\";s:10:\"created_at\";i:1705869820;}s:22:\"bIpvkFHSP4Kl5c18lF3K3p\";a:2:{s:10:\"hashed_key\";s:34:\"$P$BCB5ahD.PJcT.roEkJZ2csDWqMl9zx.\";s:10:\"created_at\";i:1706342240;}s:22:\"EjXHayfugRFUo0M7SDdCDo\";a:2:{s:10:\"hashed_key\";s:34:\"$P$BeJSJZZj0.QRXUcvNA/cxkxndKzEof0\";s:10:\"created_at\";i:1706527957;}s:22:\"FZKINrGo6s8UjcuZhfVlkT\";a:2:{s:10:\"hashed_key\";s:34:\"$P$BJKAPajCN0hI0aTfE6Yho3yrFiw9sn.\";s:10:\"created_at\";i:1708519683;}s:22:\"HtPV3QPlX4liMuokb72bUp\";a:2:{s:10:\"hashed_key\";s:34:\"$P$BDqWs45BpwioWlVsCrWGTcobA6s1F5/\";s:10:\"created_at\";i:1716454714;}s:22:\"0Uf93O83H4A0HJNLwmHJJN\";a:2:{s:10:\"hashed_key\";s:34:\"$P$B2zYEFj7ac10N.DPZ0Vhb//Lujz3PL0\";s:10:\"created_at\";i:1721662340;}s:22:\"MmL2VIDJdcw6Y355uHYmR4\";a:2:{s:10:\"hashed_key\";s:34:\"$P$By.JQKjz3v74OBYQoVGYZ0Rry/qrWp1\";s:10:\"created_at\";i:1721833021;}s:22:\"HsQE7sLw7JmIMGLDbIeX2q\";a:2:{s:10:\"hashed_key\";s:34:\"$P$BTNReYLITZoecdTOnbRLaRNCuUNgUp1\";s:10:\"created_at\";i:1722739786;}s:22:\"H9jpsLjE5Mtcbq1eNfa3Zn\";a:2:{s:10:\"hashed_key\";s:34:\"$P$BWWOTOSxBbUzUVHemTu5sK1NMsJ.LX1\";s:10:\"created_at\";i:1725077406;}s:22:\"3mCSXc0EiL43JP3BAAJuAN\";a:2:{s:10:\"hashed_key\";s:34:\"$P$BHD8lCXW.h.aLp8l5uZjNe7Wp8LtvY0\";s:10:\"created_at\";i:1728409110;}s:22:\"xSCvXBIyzRK1YjMg6t6iIt\";a:2:{s:10:\"hashed_key\";s:34:\"$P$BozwmJ1wQfBqbEi/MDZTx0ht/UpIkE.\";s:10:\"created_at\";i:1731321954;}s:22:\"WU5PLHBfWGUWCAQRJ4fSGP\";a:2:{s:10:\"hashed_key\";s:34:\"$P$BGXjaLwr/hHSXsVgEu54KN/7b4vDRg0\";s:10:\"created_at\";i:1732737824;}s:22:\"kqGYgvHmNsbirDIVraifXc\";a:2:{s:10:\"hashed_key\";s:34:\"$P$BdLA2Gm7LQXQThYguB0jx68qjkVS88/\";s:10:\"created_at\";i:1733134596;}s:22:\"eLG9VUh2u7zVJg0Vqddi9c\";a:2:{s:10:\"hashed_key\";s:34:\"$P$Bo1B7oRpLzBvHviFm9wyf0hKe8WUCW.\";s:10:\"created_at\";i:1733232003;}s:22:\"udjuBT3o8kZ5HHu7TfwZnA\";a:2:{s:10:\"hashed_key\";s:34:\"$P$BarzQTvus1dj8aE5xxh.zsswAd5oq5/\";s:10:\"created_at\";i:1733899164;}s:22:\"lGI2wtGGWu6YcS6Iq98Yiq\";a:2:{s:10:\"hashed_key\";s:34:\"$P$BxnNaFGn4dV21igVWdGan74GEIfa7V.\";s:10:\"created_at\";i:1734945398;}s:22:\"6HcA02dp4LTXNZtI4vnQbV\";a:2:{s:10:\"hashed_key\";s:34:\"$P$B9LWbQPvXVxC4yCSJVzcXdnzaAhVmi.\";s:10:\"created_at\";i:1741246804;}s:22:\"xDgdgIpc0JhTJFwTYLfZiR\";a:2:{s:10:\"hashed_key\";s:49:\"$generic$y5vOKpHgfLMFrMSIGDM01YY7j8M6dXCg0rWRbanA\";s:10:\"created_at\";i:1754731170;}s:22:\"PRGFNy55BHXMKLnPQrQHW2\";a:2:{s:10:\"hashed_key\";s:49:\"$generic$0qjCa5NAy0UfG6uAq6J-RjM0LotG_aJNUbyNnGuX\";s:10:\"created_at\";i:1758107644;}}", "off");
INSERT INTO `wp_options` VALUES("130", "https_detection_errors", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("139", "secure_auth_key", "||m5%.]XD1~=;p9e$D9aa{DpH]yc<P{oS*;aFY}~~e>WNW}]uOXxk6/}$ E!XoDW", "no");
INSERT INTO `wp_options` VALUES("140", "secure_auth_salt", "/x**OTb(~xH&/%(Uo;{g%%o:;n.KjtCr/U&C.U<v/YiiNG}9G7[#<@J=CbvkRH*&", "no");
INSERT INTO `wp_options` VALUES("141", "logged_in_key", "eW*.`sTf@_o$;i|BC:nv^^{8.pydpRNd64XkBhF,lO?szR->CD#6lJz-`,FYB1uo", "no");
INSERT INTO `wp_options` VALUES("142", "logged_in_salt", "5k%BsyRt;]*u1QcB`hKDBSMQkB/] /%%Q/DBaa83,{L&8bXhHmu#`k&%#vuei?U)", "no");
INSERT INTO `wp_options` VALUES("160", "current_theme", "Woodmart", "yes");
INSERT INTO `wp_options` VALUES("161", "theme_mods_woodmart", "a:4:{i:0;b:0;s:18:\"custom_css_post_id\";i:3970;s:18:\"nav_menu_locations\";a:2:{s:9:\"main-menu\";i:33;s:11:\"mobile-menu\";i:35;}s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1744514021;s:4:\"data\";a:10:{s:19:\"wp_inactive_widgets\";a:2:{i:0;s:23:\"woodmart-recent-posts-2\";i:1;s:30:\"woodmart-woocommerce-sort-by-2\";}s:9:\"sidebar-1\";a:4:{i:0;s:22:\"woocommerce_products-2\";i:1;s:7:\"block-5\";i:2;s:7:\"block-6\";i:3;s:26:\"woocommerce_price_filter-2\";}s:22:\"portfolio-widgets-area\";a:0:{}s:12:\"sidebar-shop\";a:5:{i:0;s:24:\"wd-widget-stock-status-2\";i:1;s:26:\"woocommerce_price_filter-3\";i:2;s:34:\"woodmart-woocommerce-layered-nav-2\";i:3;s:34:\"woodmart-woocommerce-layered-nav-3\";i:4;s:27:\"woocommerce_rating_filter-2\";}s:12:\"filters-area\";a:3:{i:0;s:33:\"woocommerce_layered_nav_filters-2\";i:1;s:25:\"woocommerce_layered_nav-2\";i:2;s:33:\"woocommerce_layered_nav_filters-3\";}s:22:\"sidebar-product-single\";a:1:{i:0;s:13:\"custom_html-2\";}s:18:\"sidebar-my-account\";a:0:{}s:24:\"sidebar-full-screen-menu\";a:0:{}s:19:\"mobile-menu-widgets\";a:0:{}s:8:\"footer-1\";a:0:{}}}}", "on");
INSERT INTO `wp_options` VALUES("162", "theme_switched", "", "yes");
INSERT INTO `wp_options` VALUES("163", "woodmart-generated-wpbcss-file", "", "yes");
INSERT INTO `wp_options` VALUES("164", "woodmart_is_activated", "", "yes");
INSERT INTO `wp_options` VALUES("166", "xts-options-presets", "", "yes");
INSERT INTO `wp_options` VALUES("167", "xts-woodmart-options", "a:849:{s:12:\"last_message\";s:6:\"import\";s:14:\"default_header\";s:13:\"header_705276\";s:14:\"sticky_toolbar\";s:1:\"1\";s:20:\"sticky_toolbar_label\";s:1:\"1\";s:21:\"sticky_toolbar_fields\";a:4:{i:0;s:8:\"wishlist\";i:1;s:4:\"cart\";i:2;s:7:\"account\";i:3;s:6:\"link_1\";}s:10:\"link_1_url\";s:47:\"https://demoes.aramis-co.ir/woodmartpluss3/shop\";s:11:\"link_1_text\";s:13:\"دسته ها\";s:11:\"link_1_icon\";a:2:{s:3:\"url\";s:81:\"https://demoes.aramis-co.ir/woodmartpluss3/wp-content/uploads/2022/12/Heart-b.svg\";s:2:\"id\";s:4:\"3630\";}s:10:\"link_2_url\";s:0:\"\";s:11:\"link_2_text\";s:0:\"\";s:11:\"link_2_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_3_url\";s:0:\"\";s:11:\"link_3_text\";s:0:\"\";s:11:\"link_3_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_4_url\";s:0:\"\";s:11:\"link_4_text\";s:0:\"\";s:11:\"link_4_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_5_url\";s:0:\"\";s:11:\"link_5_text\";s:0:\"\";s:11:\"link_5_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"age_verify\";s:1:\"0\";s:15:\"age_verify_text\";s:264:\"<h4 style=\"text-align: center\">آیا شما 18 سالتان هست ؟</h4>\r\n<p style=\"text-align: center\">برای مشاهده صفحه باید 18 سال به بالا داشته باشید. لطفاً سن خود را برای ورود تأیید کنید.</p>\";s:21:\"age_verify_text_error\";s:162:\"<h4 style=\"text-align: center\">عدم دسترسی</h4>\r\n<p style=\"text-align: center\">دسترسی شما به دلیل سن شما محدود شده است.</p>\";s:21:\"age_verify_background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:23:\"age_verify_color_scheme\";s:4:\"dark\";s:16:\"age_verify_width\";s:3:\"500\";s:11:\"promo_popup\";s:1:\"0\";s:24:\"promo_popup_content_type\";s:10:\"html_block\";s:10:\"popup_text\";s:0:\"\";s:16:\"popup_html_block\";s:4:\"4289\";s:16:\"popup-background\";a:7:{s:5:\"color\";s:19:\"rgba(255,255,255,0)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:7:\"contain\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:11:\"left center\";}s:18:\"popup_color_scheme\";s:4:\"dark\";s:11:\"popup_width\";s:4:\"1000\";s:13:\"popup_padding\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:23:\"promo_popup_hide_mobile\";s:1:\"1\";s:11:\"popup_event\";s:4:\"time\";s:12:\"popup_scroll\";s:4:\"1000\";s:13:\"promo_timeout\";s:4:\"2000\";s:11:\"popup_pages\";s:1:\"0\";s:13:\"promo_version\";s:1:\"1\";s:12:\"cookies_info\";s:1:\"1\";s:12:\"cookies_text\";s:292:\"قالب وودمارت پلاس دارای اپلیکیشن اندروید اختصاصی ( حرفه ای فروشگاهی ) میباشد ، دموی این اپلیکیشن را میتوانید<a href=\"http://dev-wp.ir/woodmart/apk/woodmart.apk\"> ازینجا دانلود نمایید</a>\";s:19:\"cookies_policy_page\";s:0:\"\";s:15:\"cookies_version\";s:1:\"1\";s:13:\"header_banner\";s:1:\"1\";s:18:\"header_banner_link\";s:1:\"#\";s:26:\"header_banner_content_type\";s:4:\"text\";s:24:\"header_banner_html_block\";s:0:\"\";s:23:\"header_banner_shortcode\";s:172:\"<img class=\"alignnone size-full wp-image-2755\" src=\"https://demoes.aramis-co.ir/dgkala//wp-content/uploads/2021/12/banner-header-min.png\" alt=\"\" width=\"1790\" height=\"80\" />\";s:16:\"header_banner_bg\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:5:\"cover\";s:10:\"attachment\";s:7:\"inherit\";s:8:\"position\";s:10:\"center top\";}s:19:\"header_banner_color\";s:5:\"light\";s:20:\"header_banner_height\";s:2:\"40\";s:27:\"header_banner_mobile_height\";s:2:\"40\";s:16:\"header_close_btn\";s:1:\"1\";s:21:\"header_banner_version\";s:0:\"\";s:13:\"search_by_sku\";s:1:\"1\";s:28:\"search_by_product_categories\";s:1:\"0\";s:21:\"search_by_product_tag\";s:1:\"0\";s:28:\"search_by_product_attributes\";s:1:\"0\";s:24:\"search_by_product_brands\";s:1:\"0\";s:21:\"enqueue_posts_results\";s:1:\"0\";s:27:\"search_posts_results_column\";s:1:\"2\";s:16:\"popular_requests\";s:0:\"\";s:15:\"search_synonyms\";s:0:\"\";s:24:\"full_search_content_type\";s:7:\"content\";s:24:\"full_search_content_text\";s:0:\"\";s:30:\"full_search_content_html_block\";s:0:\"\";s:17:\"relevanssi_search\";s:1:\"0\";s:10:\"site_width\";s:6:\"custom\";s:17:\"site_custom_width\";s:4:\"1350\";s:11:\"main_layout\";s:13:\"sidebar-right\";s:13:\"sidebar_width\";s:1:\"3\";s:17:\"hide_main_sidebar\";s:1:\"0\";s:24:\"hide_main_sidebar_tablet\";s:1:\"1\";s:24:\"hide_main_sidebar_mobile\";s:1:\"1\";s:11:\"insta_token\";s:0:\"\";s:28:\"insta_delete_outdated_images\";s:1:\"0\";s:18:\"google_map_api_key\";s:0:\"\";s:9:\"fb_app_id\";s:0:\"\";s:13:\"fb_app_secret\";s:0:\"\";s:9:\"fb_notice\";s:0:\"\";s:10:\"goo_app_id\";s:0:\"\";s:14:\"goo_app_secret\";s:0:\"\";s:10:\"goo_notice\";s:0:\"\";s:9:\"vk_app_id\";s:0:\"\";s:13:\"vk_app_secret\";s:0:\"\";s:9:\"vk_notice\";s:0:\"\";s:15:\"alt_auth_method\";s:1:\"0\";s:9:\"ajax_shop\";s:1:\"1\";s:11:\"ajax_scroll\";s:1:\"1\";s:21:\"shop_page_breadcrumbs\";s:1:\"1\";s:17:\"cat_desc_position\";s:6:\"before\";s:14:\"products_hover\";s:4:\"base\";s:23:\"base_hover_mobile_click\";s:1:\"0\";s:21:\"products_color_scheme\";s:7:\"default\";s:22:\"products_bordered_grid\";s:1:\"1\";s:28:\"products_bordered_grid_style\";s:7:\"outside\";s:24:\"products_with_background\";s:1:\"0\";s:19:\"products_background\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"products_shadow\";s:1:\"0\";s:23:\"stretch_product_desktop\";s:1:\"0\";s:22:\"stretch_product_tablet\";s:1:\"0\";s:22:\"stretch_product_mobile\";s:1:\"0\";s:25:\"product_title_lines_limit\";s:3:\"one\";s:22:\"show_empty_star_rating\";s:1:\"0\";s:11:\"hover_image\";s:1:\"1\";s:12:\"grid_gallery\";s:1:\"0\";s:20:\"grid_gallery_control\";s:5:\"hover\";s:26:\"grid_gallery_enable_arrows\";s:4:\"none\";s:16:\"product_quantity\";s:1:\"0\";s:18:\"base_hover_content\";s:7:\"excerpt\";s:21:\"stock_status_position\";s:9:\"thumbnail\";s:27:\"show_stock_quantity_on_grid\";s:1:\"0\";s:23:\"grid_stock_progress_bar\";s:1:\"0\";s:14:\"shop_countdown\";s:1:\"0\";s:22:\"categories_under_title\";s:1:\"0\";s:18:\"brands_under_title\";s:1:\"0\";s:15:\"sku_under_title\";s:1:\"0\";s:18:\"show_reviews_count\";s:1:\"0\";s:17:\"categories_design\";s:7:\"default\";s:19:\"categories_rounding\";s:0:\"\";s:31:\"custom_categories_rounding_size\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:23:\"categories_color_scheme\";s:7:\"default\";s:22:\"categories_with_shadow\";s:6:\"enable\";s:29:\"hide_categories_subcategories\";s:1:\"0\";s:29:\"hide_categories_product_count\";s:1:\"0\";s:11:\"shop_layout\";s:12:\"sidebar-left\";s:18:\"shop_sidebar_width\";s:1:\"3\";s:25:\"shop_hide_sidebar_desktop\";s:1:\"0\";s:24:\"shop_hide_sidebar_tablet\";s:1:\"1\";s:17:\"shop_hide_sidebar\";s:1:\"1\";s:20:\"sticky_filter_button\";s:1:\"0\";s:10:\"shop_title\";s:1:\"0\";s:15:\"shop_categories\";s:1:\"0\";s:25:\"shop_categories_ancestors\";s:1:\"0\";s:25:\"show_categories_neighbors\";s:1:\"0\";s:19:\"shop_products_count\";s:1:\"1\";s:37:\"shop_page_title_hide_empty_categories\";s:1:\"0\";s:34:\"shop_page_title_categories_exclude\";s:0:\"\";s:24:\"mobile_categories_layout\";s:9:\"accordion\";s:29:\"mobile_categories_menu_layout\";s:8:\"dropdown\";s:37:\"mobile_categories_drilldown_animation\";s:5:\"slide\";s:40:\"mobile_categories_submenu_opening_action\";s:10:\"only_arrow\";s:26:\"mobile_categories_position\";s:4:\"left\";s:30:\"mobile_categories_color_scheme\";s:7:\"default\";s:27:\"mobile_categories_close_btn\";s:1:\"0\";s:9:\"shop_view\";s:4:\"grid\";s:16:\"products_columns\";s:1:\"4\";s:23:\"products_columns_tablet\";s:4:\"auto\";s:23:\"products_columns_mobile\";s:1:\"1\";s:16:\"products_spacing\";s:2:\"10\";s:23:\"products_spacing_tablet\";s:0:\"\";s:23:\"products_spacing_mobile\";s:0:\"\";s:24:\"per_row_columns_selector\";s:1:\"1\";s:27:\"products_columns_variations\";a:3:{i:0;s:1:\"2\";i:1;s:1:\"3\";i:2;s:1:\"4\";}s:16:\"products_masonry\";s:1:\"0\";s:24:\"products_different_sizes\";s:1:\"0\";s:13:\"shop_per_page\";s:2:\"12\";s:14:\"per_page_links\";s:1:\"1\";s:16:\"per_page_options\";s:7:\"9,24,36\";s:15:\"shop_pagination\";s:10:\"pagination\";s:25:\"load_more_button_page_url\";s:1:\"1\";s:17:\"categories_toggle\";s:1:\"1\";s:14:\"widgets_scroll\";s:1:\"1\";s:14:\"widget_heights\";s:3:\"280\";s:21:\"shop_widgets_collapse\";s:7:\"disable\";s:12:\"shop_filters\";s:1:\"0\";s:17:\"shop_filters_type\";s:7:\"widgets\";s:20:\"shop_filters_columns\";s:0:\"\";s:27:\"shop_filters_columns_tablet\";s:4:\"auto\";s:27:\"shop_filters_columns_mobile\";s:4:\"auto\";s:20:\"shop_filters_spacing\";s:2:\"30\";s:27:\"shop_filters_spacing_tablet\";s:0:\"\";s:27:\"shop_filters_spacing_mobile\";s:0:\"\";s:12:\"hide_sort_by\";s:1:\"0\";s:17:\"hide_price_filter\";s:1:\"0\";s:20:\"shop_filters_content\";s:0:\"\";s:24:\"shop_filters_always_open\";s:1:\"0\";s:18:\"shop_filters_close\";s:1:\"0\";s:17:\"page-title-design\";s:8:\"centered\";s:15:\"page-title-size\";s:7:\"default\";s:16:\"title-background\";a:7:{s:5:\"color\";s:7:\"#0a0a0a\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:5:\"cover\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:13:\"center center\";}s:16:\"page-title-color\";s:5:\"light\";s:14:\"page_title_tag\";s:7:\"default\";s:11:\"breadcrumbs\";s:1:\"1\";s:22:\"yoast_shop_breadcrumbs\";s:1:\"0\";s:23:\"yoast_pages_breadcrumbs\";s:1:\"0\";s:14:\"disable_footer\";s:1:\"1\";s:19:\"footer_content_type\";s:10:\"html_block\";s:13:\"footer-layout\";s:1:\"1\";s:17:\"footer_html_block\";s:3:\"261\";s:13:\"footer-bar-bg\";a:7:{s:5:\"color\";s:16:\"rgb(255,255,255)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:12:\"footer-style\";s:4:\"dark\";s:13:\"sticky_footer\";s:1:\"0\";s:23:\"collapse_footer_widgets\";s:1:\"0\";s:14:\"scroll_top_btn\";s:1:\"1\";s:18:\"disable_copyrights\";s:1:\"0\";s:17:\"copyrights-layout\";s:11:\"two-columns\";s:10:\"copyrights\";s:0:\"\";s:11:\"copyrights2\";s:0:\"\";s:22:\"prefooter_content_type\";s:4:\"text\";s:14:\"prefooter_area\";s:0:\"\";s:20:\"prefooter_html_block\";s:0:\"\";s:9:\"text-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"IRANSansXFaNum\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:9:\"font-size\";s:2:\"14\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:13:\"rgb(58,58,58)\";}}s:12:\"primary-font\";a:1:{i:0;a:7:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"IRANSansXFaNum\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#242424\";}}s:16:\"post-titles-font\";a:1:{i:0;a:8:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"IRANSansXFaNum\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:16:\"rgb(119,119,119)\";s:5:\"hover\";a:1:{s:5:\"color\";s:19:\"rgb(51 51 51 / 65%)\";}}}s:14:\"secondary-font\";a:1:{i:0;a:5:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"IRANSansXFaNum\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";}}s:18:\"widget-titles-font\";a:1:{i:0;a:10:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"IRANSansXFaNum\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"16\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:16:\"rgb(119,119,119)\";}}s:15:\"navigation-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"IRANSansXFaNum\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:9:\"uppercase\";s:9:\"font-size\";s:2:\"15\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}}}s:17:\"typography_notice\";s:0:\"\";s:19:\"advanced_typography\";a:1:{i:0;a:15:{s:6:\"custom\";s:0:\"\";s:8:\"selector\";a:2:{i:0;s:25:\"product_title_single_page\";i:1;s:10:\"blog_title\";}s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"IRANSansXFaNum\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:2:\"18\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}}s:26:\"advanced_typography_notice\";s:0:\"\";s:25:\"multi_custom_fonts_notice\";s:0:\"\";s:18:\"multi_custom_fonts\";a:3:{i:0;a:4:{s:9:\"font-name\";s:18:\"IRANSansXFaNumSite\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}i:1;a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}s:9:\"{{index}}\";a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}}s:9:\"icon_font\";a:2:{s:4:\"font\";s:1:\"2\";s:6:\"weight\";s:3:\"700\";}s:14:\"typekit_notice\";s:0:\"\";s:10:\"typekit_id\";s:0:\"\";s:13:\"typekit_fonts\";s:0:\"\";s:13:\"rounding_size\";s:6:\"custom\";s:20:\"custom_rounding_size\";s:68:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidW5pdCI6InB4IiwidmFsdWUiOiIyMCJ9fX0=\";s:12:\"dark_version\";s:1:\"0\";s:27:\"accessibility_outline_style\";s:6:\"dotted\";s:27:\"accessibility_outline_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOjIsInVuaXQiOiJweCJ9fX0=\";s:27:\"accessibility_outline_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:13:\"primary-color\";a:1:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";}s:15:\"secondary-color\";a:1:{s:4:\"idle\";s:13:\"rgb(183,5,64)\";}s:25:\"android_browser_bar_color\";a:1:{s:4:\"idle\";s:13:\"rgb(181,0,60)\";}s:15:\"body-background\";a:7:{s:5:\"color\";s:16:\"rgb(246,246,246)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:16:\"pages-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"shop-background\";a:7:{s:5:\"color\";s:16:\"rgb(243,243,243)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"product-background\";a:7:{s:5:\"color\";s:16:\"rgb(243,243,243)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"blog-background\";a:7:{s:5:\"color\";s:16:\"rgb(243,243,243)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"blog-post-background\";a:7:{s:5:\"color\";s:16:\"rgb(243,243,243)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"portfolio-background\";a:7:{s:5:\"color\";s:16:\"rgb(243,243,243)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:28:\"portfolio-project-background\";a:7:{s:5:\"color\";s:16:\"rgb(243,243,243)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"btns_default_style\";s:7:\"rounded\";s:23:\"btns_default_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";}}s:15:\"btns_default_bg\";a:1:{s:4:\"idle\";s:7:\"#c1113d\";}s:21:\"btns_default_bg_hover\";a:1:{s:4:\"idle\";s:7:\"#b63c56\";}s:25:\"btns_default_color_scheme\";s:5:\"light\";s:31:\"btns_default_color_scheme_hover\";s:5:\"light\";s:32:\"btns_default_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"btns_default_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"btns_shop_style\";s:7:\"rounded\";s:20:\"btns_shop_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";}}s:12:\"btns_shop_bg\";a:1:{s:4:\"idle\";s:7:\"#c1113d\";}s:18:\"btns_shop_bg_hover\";a:1:{s:4:\"idle\";s:7:\"#c10537\";}s:22:\"btns_shop_color_scheme\";s:5:\"light\";s:28:\"btns_shop_color_scheme_hover\";s:5:\"light\";s:29:\"btns_shop_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:35:\"btns_shop_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"advanced_typography_button\";a:2:{i:0;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}}s:17:\"form_fields_style\";s:12:\"semi-rounded\";s:17:\"form_border_width\";s:1:\"2\";s:10:\"form_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"form_placeholder_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:14:\"form_brd_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"form_brd_color_focus\";a:1:{s:4:\"idle\";s:0:\"\";}s:7:\"form_bg\";a:1:{s:4:\"idle\";s:0:\"\";}s:23:\"success_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#459647\";}s:25:\"success_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:23:\"warning_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#E0B252\";}s:25:\"warning_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:10:\"link-color\";a:2:{s:4:\"idle\";s:13:\"rgb(214,6,68)\";s:5:\"hover\";s:13:\"rgb(181,0,60)\";}s:20:\"link_underline_style\";s:0:\"\";s:26:\"link_hover_underline_style\";s:0:\"\";s:20:\"link_underline_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"link_underline_hover_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:24:\"carousel_arrows_position\";s:3:\"sep\";s:25:\"carousel_arrows_icon_type\";s:1:\"1\";s:27:\"carousel_arrows_hover_style\";s:1:\"1\";s:24:\"carousel_arrows_sep_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:29:\"carousel_arrows_sep_icon_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:28:\"carousel_arrows_sep_offset_h\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:28:\"carousel_arrows_sep_offset_v\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:25:\"carousel_arrows_sep_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:31:\"carousel_arrows_sep_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:29:\"carousel_arrows_sep_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:28:\"carousel_arrows_sep_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:34:\"carousel_arrows_sep_bg_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:32:\"carousel_arrows_sep_bg_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:33:\"carousel_arrows_sep_border_radius\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:32:\"carousel_arrows_sep_border_style\";s:0:\"\";s:32:\"carousel_arrows_sep_border_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:32:\"carousel_arrows_sep_border_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"carousel_arrows_sep_border_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:36:\"carousel_arrows_sep_border_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:36:\"carousel_arrows_sep_box_shadow_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:39:\"carousel_arrows_sep_box_shadow_offset_x\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:39:\"carousel_arrows_sep_box_shadow_offset_y\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:35:\"carousel_arrows_sep_box_shadow_blur\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:37:\"carousel_arrows_sep_box_shadow_spread\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:28:\"carousel_arrows_together_gap\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:29:\"carousel_arrows_together_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:34:\"carousel_arrows_together_icon_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:33:\"carousel_arrows_together_offset_h\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:33:\"carousel_arrows_together_offset_v\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:30:\"carousel_arrows_together_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:36:\"carousel_arrows_together_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:34:\"carousel_arrows_together_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:33:\"carousel_arrows_together_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:39:\"carousel_arrows_together_bg_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:37:\"carousel_arrows_together_bg_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"carousel_arrows_together_border_radius\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:37:\"carousel_arrows_together_border_style\";s:0:\"\";s:37:\"carousel_arrows_together_border_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:37:\"carousel_arrows_together_border_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:43:\"carousel_arrows_together_border_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:41:\"carousel_arrows_together_border_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:41:\"carousel_arrows_together_box_shadow_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:44:\"carousel_arrows_together_box_shadow_offset_x\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:44:\"carousel_arrows_together_box_shadow_offset_y\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:40:\"carousel_arrows_together_box_shadow_blur\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:42:\"carousel_arrows_together_box_shadow_spread\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:19:\"carousel_pagin_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:23:\"carousel_pagin_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:29:\"carousel_pagin_bg_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:30:\"carousel_pagin_bg_color_active\";a:1:{s:4:\"idle\";s:0:\"\";}s:28:\"carousel_pagin_border_radius\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:27:\"carousel_pagin_border_style\";s:0:\"\";s:27:\"carousel_pagin_border_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:27:\"carousel_pagin_border_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:33:\"carousel_pagin_border_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:34:\"carousel_pagin_border_color_active\";a:1:{s:4:\"idle\";s:0:\"\";}s:25:\"carousel_scrollbar_height\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:24:\"carousel_scrollbar_width\";s:152:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoiJSJ9LCJ0YWJsZXQiOnsidmFsdWUiOiIiLCJ1bml0IjoiJSJ9LCJtb2JpbGUiOnsidmFsdWUiOiIiLCJ1bml0IjoiJSJ9fX0=\";s:27:\"carousel_scrollbar_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:32:\"carousel_scrollbar_drag_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"carousel_scrollbar_drag_bg_hover_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:11:\"blog_design\";s:7:\"masonry\";s:15:\"blog_image_size\";s:5:\"large\";s:12:\"blog_masonry\";b:0;s:10:\"blog_style\";s:6:\"shadow\";s:16:\"blog_with_shadow\";s:1:\"1\";s:12:\"blog_columns\";s:1:\"3\";s:19:\"blog_columns_tablet\";s:4:\"auto\";s:19:\"blog_columns_mobile\";s:4:\"auto\";s:12:\"blog_spacing\";s:2:\"30\";s:19:\"blog_spacing_tablet\";s:0:\"\";s:19:\"blog_spacing_mobile\";s:0:\"\";s:15:\"blog_pagination\";s:9:\"load_more\";s:19:\"blog_archive_layout\";s:13:\"sidebar-right\";s:26:\"blog_archive_sidebar_width\";s:1:\"3\";s:25:\"blog_archive_hide_sidebar\";s:1:\"0\";s:32:\"blog_archive_hide_sidebar_tablet\";s:1:\"1\";s:32:\"blog_archive_hide_sidebar_mobile\";s:1:\"1\";s:12:\"blog_excerpt\";s:7:\"excerpt\";s:21:\"blog_words_or_letters\";s:6:\"letter\";s:19:\"blog_excerpt_length\";s:3:\"100\";s:11:\"parts_title\";s:1:\"1\";s:10:\"parts_meta\";s:1:\"1\";s:10:\"parts_text\";s:1:\"1\";s:9:\"parts_btn\";s:1:\"1\";s:20:\"parts_published_date\";s:1:\"1\";s:18:\"single_post_design\";s:7:\"default\";s:18:\"single_post_header\";s:4:\"none\";s:11:\"blog_layout\";s:13:\"sidebar-right\";s:18:\"blog_sidebar_width\";s:1:\"3\";s:17:\"blog_hide_sidebar\";s:1:\"0\";s:24:\"blog_hide_sidebar_tablet\";s:1:\"1\";s:24:\"blog_hide_sidebar_mobile\";s:1:\"1\";s:10:\"blog_share\";s:1:\"1\";s:15:\"blog_navigation\";s:1:\"1\";s:15:\"blog_author_bio\";s:1:\"1\";s:18:\"blog_related_posts\";s:1:\"1\";s:19:\"blog_published_date\";s:1:\"1\";s:29:\"single_post_justified_gallery\";s:1:\"0\";s:29:\"single_post_builder_post_data\";s:0:\"\";s:9:\"portfolio\";s:1:\"1\";s:14:\"portfolio_page\";s:0:\"\";s:19:\"portfolio_item_slug\";s:0:\"\";s:18:\"portfolio_cat_slug\";s:0:\"\";s:20:\"portfolio_full_width\";s:1:\"0\";s:16:\"projects_columns\";s:1:\"4\";s:23:\"projects_columns_tablet\";s:4:\"auto\";s:23:\"projects_columns_mobile\";s:4:\"auto\";s:17:\"portfolio_spacing\";s:2:\"30\";s:24:\"portfolio_spacing_tablet\";s:0:\"\";s:24:\"portfolio_spacing_mobile\";s:0:\"\";s:18:\"portoflio_per_page\";s:2:\"12\";s:20:\"portfolio_pagination\";s:10:\"pagination\";s:17:\"portoflio_orderby\";s:4:\"date\";s:15:\"portoflio_order\";s:4:\"DESC\";s:24:\"portfolio_archive_layout\";s:13:\"sidebar-right\";s:31:\"portfolio_archive_sidebar_width\";s:1:\"3\";s:30:\"portfolio_archive_hide_sidebar\";s:1:\"0\";s:37:\"portfolio_archive_hide_sidebar_tablet\";s:1:\"1\";s:37:\"portfolio_archive_hide_sidebar_mobile\";s:1:\"1\";s:15:\"portoflio_style\";s:5:\"hover\";s:20:\"portoflio_image_size\";s:5:\"large\";s:17:\"portoflio_filters\";s:1:\"1\";s:22:\"portfolio_filters_type\";s:5:\"links\";s:14:\"ajax_portfolio\";s:1:\"1\";s:23:\"single_portfolio_header\";s:4:\"none\";s:36:\"single_portfolio_title_in_page_title\";s:1:\"0\";s:23:\"single_portfolio_layout\";s:13:\"sidebar-right\";s:30:\"single_portfolio_sidebar_width\";s:1:\"3\";s:29:\"single_portfolio_hide_sidebar\";s:1:\"0\";s:36:\"single_portfolio_hide_sidebar_tablet\";s:1:\"1\";s:36:\"single_portfolio_hide_sidebar_mobile\";s:1:\"1\";s:20:\"portfolio_navigation\";s:1:\"1\";s:17:\"portfolio_related\";s:1:\"1\";s:32:\"single_project_builder_post_data\";s:0:\"\";s:18:\"add_to_cart_action\";s:6:\"widget\";s:26:\"add_to_cart_action_timeout\";s:1:\"0\";s:33:\"add_to_cart_action_timeout_number\";s:1:\"3\";s:18:\"mini_cart_quantity\";s:1:\"1\";s:21:\"show_sku_in_mini_cart\";s:1:\"0\";s:16:\"show_sku_in_cart\";s:1:\"0\";s:25:\"show_sku_in_checkout_page\";s:1:\"0\";s:26:\"show_sku_in_thank_you_page\";s:1:\"0\";s:23:\"show_sku_in_email_order\";s:1:\"0\";s:16:\"show_sku_on_ajax\";s:1:\"1\";s:12:\"catalog_mode\";s:1:\"0\";s:11:\"size_guides\";s:1:\"1\";s:12:\"login_prices\";s:1:\"0\";s:19:\"quick_shop_variable\";s:1:\"1\";s:24:\"quick_shop_variable_type\";s:14:\"select_options\";s:23:\"quick_shop_clear_action\";s:4:\"none\";s:23:\"grid_swatches_attribute\";s:0:\"\";s:14:\"swatches_limit\";s:1:\"1\";s:20:\"swatches_limit_count\";s:1:\"5\";s:29:\"single_product_swatches_limit\";s:1:\"0\";s:35:\"single_product_swatches_limit_count\";s:2:\"10\";s:29:\"swatches_use_variation_images\";s:1:\"1\";s:20:\"swatches_labels_name\";s:1:\"1\";s:27:\"swatches_scroll_top_desktop\";s:1:\"0\";s:26:\"swatches_scroll_top_mobile\";s:1:\"0\";s:17:\"variation_gallery\";s:1:\"0\";s:32:\"variation_gallery_storage_method\";s:3:\"old\";s:24:\"ajax_variation_threshold\";s:2:\"30\";s:29:\"show_filtered_variation_image\";s:1:\"0\";s:17:\"hide_larger_price\";s:1:\"0\";s:31:\"single_product_variations_price\";s:1:\"0\";s:11:\"label_shape\";s:10:\"rounded-sm\";s:16:\"percentage_label\";s:1:\"0\";s:19:\"sale_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:21:\"sale_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"new_label\";s:1:\"1\";s:27:\"new_label_days_after_create\";s:1:\"0\";s:18:\"new_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"new_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"hot_label\";s:1:\"1\";s:18:\"hot_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"hot_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"stock_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"stock_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:24:\"attribute_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"attribute_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:16:\"brands_attribute\";s:0:\"\";s:18:\"product_page_brand\";s:1:\"1\";s:22:\"product_brand_location\";s:11:\"about_title\";s:9:\"brand_tab\";s:1:\"1\";s:18:\"brand_tab_priority\";s:0:\"\";s:14:\"brand_tab_name\";s:1:\"1\";s:10:\"quick_view\";s:1:\"1\";s:17:\"quick_view_layout\";s:10:\"horizontal\";s:15:\"quickview_width\";s:3:\"920\";s:19:\"quick_view_variable\";s:1:\"1\";s:7:\"compare\";s:1:\"1\";s:12:\"compare_page\";s:4:\"3332\";s:14:\"fields_compare\";a:3:{i:0;s:11:\"description\";i:1;s:3:\"sku\";i:2;s:12:\"availability\";}s:18:\"empty_compare_text\";s:277:\"هیچ محصولی در لیست مقایسه اضافه نشده است. برای مقایسه آنها باید برخی از محصولات را اضافه کنید. <br> محصولات جالب بسیاری در صفحه \"فروشگاه\" ما پیدا خواهید کرد.\";s:15:\"compare_on_grid\";s:1:\"1\";s:25:\"compare_save_button_state\";s:1:\"0\";s:19:\"compare_by_category\";s:1:\"0\";s:22:\"show_more_products_btn\";s:1:\"1\";s:18:\"cart_totals_layout\";s:8:\"layout-1\";s:27:\"update_cart_quantity_change\";s:1:\"0\";s:15:\"empty_cart_text\";s:223:\"قبل از شروع تسویه حساب، باید چند محصول را به سبد خرید خود اضافه کنید.<br> در صفحه \"فروشگاه\" ما، محصولات جالب زیادی خواهید یافت.\";s:27:\"thank_you_page_content_type\";s:4:\"text\";s:28:\"thank_you_page_extra_content\";s:255:\"<p style=\"text-align: center\">از انتخاب شما بسیار سپاسگذاریم ...</p>\r\n<p style=\"text-align: center\">ان شاءالله بتوانیم ، همواره بهترین همکاری را با یکدیگر داشته باشیم ...</p>\";s:25:\"thank_you_page_html_block\";s:0:\"\";s:30:\"thank_you_page_default_content\";s:1:\"1\";s:21:\"single_product_layout\";s:13:\"sidebar-right\";s:19:\"full_height_sidebar\";s:1:\"0\";s:20:\"single_sidebar_width\";s:1:\"3\";s:27:\"single_product_hide_sidebar\";s:1:\"0\";s:34:\"single_product_hide_sidebar_tablet\";s:1:\"1\";s:34:\"single_product_hide_sidebar_mobile\";s:1:\"1\";s:20:\"single_product_style\";s:1:\"2\";s:14:\"product_design\";s:7:\"default\";s:14:\"product_sticky\";s:1:\"0\";s:22:\"product_summary_shadow\";s:1:\"0\";s:17:\"single_full_width\";s:1:\"0\";s:21:\"single_product_header\";s:4:\"none\";s:32:\"single_product_builder_post_data\";s:0:\"\";s:12:\"image_action\";s:5:\"popup\";s:15:\"photoswipe_icon\";s:1:\"1\";s:26:\"product_slider_auto_height\";s:1:\"0\";s:23:\"pagination_main_gallery\";s:1:\"0\";s:23:\"product_images_captions\";s:1:\"0\";s:14:\"thums_position\";s:4:\"left\";s:31:\"single_product_grid_columns_gap\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:34:\"single_product_grid_column_desktop\";s:0:\"\";s:33:\"single_product_grid_column_tablet\";s:0:\"\";s:33:\"single_product_grid_column_mobile\";s:0:\"\";s:37:\"single_product_gallery_column_desktop\";s:1:\"1\";s:36:\"single_product_gallery_column_tablet\";s:0:\"\";s:36:\"single_product_gallery_column_mobile\";s:0:\"\";s:40:\"single_product_thumbnails_vertical_items\";s:1:\"3\";s:39:\"single_product_thumbnails_items_desktop\";s:1:\"4\";s:38:\"single_product_thumbnails_items_tablet\";s:1:\"4\";s:38:\"single_product_thumbnails_items_mobile\";s:1:\"3\";s:22:\"main_gallery_on_tablet\";s:1:\"1\";s:22:\"main_gallery_on_mobile\";s:1:\"1\";s:24:\"main_gallery_center_mode\";s:1:\"0\";s:48:\"single_product_thumbnails_wrap_in_mobile_devices\";s:1:\"1\";s:39:\"single_product_thumbnails_gallery_width\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:40:\"single_product_thumbnails_gallery_height\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:45:\"single_product_thumbnails_gallery_image_width\";s:3:\"150\";s:23:\"single_ajax_add_to_cart\";s:1:\"1\";s:25:\"single_sticky_add_to_cart\";s:1:\"1\";s:32:\"mobile_single_sticky_add_to_cart\";s:1:\"1\";s:33:\"sticky_add_to_cart_height_desktop\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_tablet\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_mobile\";s:2:\"42\";s:31:\"before_add_to_cart_content_type\";s:4:\"text\";s:26:\"content_before_add_to_cart\";s:0:\"\";s:29:\"before_add_to_cart_html_block\";s:0:\"\";s:30:\"after_add_to_cart_content_type\";s:4:\"text\";s:25:\"content_after_add_to_cart\";s:0:\"\";s:28:\"after_add_to_cart_html_block\";s:0:\"\";s:27:\"single_breadcrumbs_position\";s:12:\"below_header\";s:24:\"product_page_breadcrumbs\";s:1:\"1\";s:12:\"products_nav\";s:1:\"0\";s:25:\"product_short_description\";s:1:\"1\";s:21:\"attr_after_short_desc\";s:1:\"0\";s:19:\"stock_status_design\";s:7:\"default\";s:25:\"single_stock_progress_bar\";s:1:\"1\";s:17:\"product_countdown\";s:1:\"1\";s:23:\"sale_countdown_variable\";s:1:\"1\";s:17:\"product_show_meta\";s:11:\"add_to_cart\";s:18:\"show_product_brand\";s:1:\"0\";s:13:\"product_share\";s:1:\"1\";s:18:\"product_share_type\";s:6:\"follow\";s:16:\"related_products\";s:1:\"1\";s:16:\"upsells_position\";s:8:\"standard\";s:20:\"related_product_view\";s:4:\"grid\";s:23:\"related_product_columns\";s:1:\"5\";s:30:\"related_product_columns_tablet\";s:4:\"auto\";s:30:\"related_product_columns_mobile\";s:4:\"auto\";s:21:\"related_product_count\";s:1:\"5\";s:19:\"product_tabs_layout\";s:4:\"tabs\";s:21:\"product_tabs_location\";s:8:\"standard\";s:23:\"product_accordion_state\";s:5:\"first\";s:16:\"hide_tabs_titles\";s:1:\"1\";s:22:\"enable_description_tab\";s:1:\"1\";s:24:\"description_tab_priority\";s:0:\"\";s:26:\"enable_additional_info_tab\";s:1:\"1\";s:28:\"additional_info_tab_priority\";s:0:\"\";s:18:\"enable_reviews_tab\";s:1:\"1\";s:20:\"reviews_tab_priority\";s:0:\"\";s:27:\"legacy_product_tabs_enabled\";s:1:\"0\";s:20:\"additional_tab_title\";s:25:\"حمل و نقل کالا\";s:23:\"additional_tab_priority\";s:3:\"100\";s:27:\"additional_tab_content_type\";s:4:\"text\";s:19:\"additional_tab_text\";s:25:\"حمل و نقل کالا\";s:25:\"additional_tab_html_block\";s:0:\"\";s:22:\"additional_tab_2_title\";s:0:\"\";s:25:\"additional_tab_2_priority\";s:0:\"\";s:29:\"additional_tab_2_content_type\";s:4:\"text\";s:21:\"additional_tab_2_text\";s:0:\"\";s:27:\"additional_tab_2_html_block\";s:0:\"\";s:22:\"additional_tab_3_title\";s:0:\"\";s:25:\"additional_tab_3_priority\";s:0:\"\";s:29:\"additional_tab_3_content_type\";s:4:\"text\";s:21:\"additional_tab_3_text\";s:0:\"\";s:27:\"additional_tab_3_html_block\";s:0:\"\";s:10:\"login_tabs\";s:1:\"1\";s:9:\"reg_title\";s:13:\"ثبت نام\";s:8:\"reg_text\";s:461:\"ثبت نام در این سایت به شما امکان می دهد به وضعیت سفارش و سابقه خود دسترسی پیدا کنید. کافی است فیلدهای زیر را پر کنید ، و ما سریعا یک حساب جدید برای شما راه اندازی می کنیم. ما فقط اطلاعات لازم را برای سریعتر و آسان تر شدن روند خرید را از شما دریافت خواهیم نمود .\";s:11:\"login_title\";s:8:\"ورود\";s:10:\"login_text\";s:0:\"\";s:16:\"my_account_links\";s:1:\"1\";s:10:\"custom_css\";s:0:\"\";s:11:\"css_desktop\";s:215:\".blog-design-list .wd-post-excerpt\r\n{\r\ndisplay: block !important;\r\n    overflow: hidden !important;\r\n    text-overflow: ellipsis !important;\r\n    white-space: normal !important;\r\n    max-height: 3em !important;\r\n}\r\n\";s:10:\"css_tablet\";s:111:\".tp-bullets{\r\n	display:none !important;\r\n}\r\n\r\nrs-arrow.hesperiden.tparrows:before{\r\ndisplay:none !important;\r\n}\";s:15:\"css_wide_mobile\";s:356:\".shop_table_responsive :is(tbody,tfoot,tr)\r\n{\r\n	    padding-left: 10px;\r\n}\r\n\r\n\r\n.tp-bullets{\r\n	display:none !important;\r\n}\r\n\r\nrs-arrow.hesperiden.tparrows:before{\r\ndisplay:none !important;\r\n}\r\n\r\n.wd-hover-base .wd-product-countdown>span, .wd-hover-fw-button .wd-product-countdown>span, .wd-hover-tiled .wd-product-countdown>span\r\n{\r\n	font-size:10px;\r\n}\r\n\r\n\";s:10:\"css_mobile\";s:721:\".shop_table_responsive :is(tbody,tfoot,tr)\r\n{\r\n	    padding-left: 10px;\r\n}\r\n.tp-bullets{\r\n	display:none !important;\r\n}\r\n.wd-hover-base .wd-product-countdown>span, .wd-hover-fw-button .wd-product-countdown>span, .wd-hover-tiled .wd-product-countdown>span\r\n{\r\n	font-size:10px;\r\n}\r\nrs-arrow.hesperiden.tparrows:before{\r\ndisplay:none !important;\r\n}\r\n\r\nrs-arrow.hesperiden .tparrows{\r\ndisplay:none !important;\r\n}\r\ndiv[class*=wd-carousel-spacing] .owl-nav>div[class*=prev]\r\n{\r\n	margin-right:40px !important; \r\n}\r\ndiv[class*=wd-carousel-spacing] .owl-nav>div[class*=next]\r\n{\r\n	margin-left:40px !important;\r\n}\r\n\r\n#rev_slider_2_1_wrapper .hesperiden.tparrows {\r\n    cursor: pointer;\r\n    background: rgb(0 0 0 / 0%) !important;\r\n}\";s:11:\"css_backend\";s:0:\"\";s:9:\"custom_js\";s:0:\"\";s:8:\"js_ready\";s:0:\"\";s:13:\"sticky_social\";s:1:\"1\";s:18:\"sticky_social_type\";s:5:\"share\";s:22:\"sticky_social_position\";s:4:\"left\";s:20:\"social_follow_notice\";s:0:\"\";s:7:\"fb_link\";s:1:\"#\";s:12:\"twitter_link\";s:1:\"#\";s:12:\"bluesky_link\";s:0:\"\";s:14:\"isntagram_link\";s:1:\"#\";s:12:\"threads_link\";s:0:\"\";s:14:\"pinterest_link\";s:1:\"#\";s:12:\"youtube_link\";s:1:\"#\";s:11:\"tumblr_link\";s:0:\"\";s:13:\"linkedin_link\";s:0:\"\";s:10:\"vimeo_link\";s:0:\"\";s:11:\"flickr_link\";s:0:\"\";s:11:\"github_link\";s:0:\"\";s:13:\"dribbble_link\";s:0:\"\";s:12:\"behance_link\";s:0:\"\";s:15:\"soundcloud_link\";s:0:\"\";s:12:\"spotify_link\";s:0:\"\";s:13:\"whatsapp_link\";s:0:\"\";s:13:\"snapchat_link\";s:0:\"\";s:7:\"tg_link\";s:0:\"\";s:10:\"viber_link\";s:0:\"\";s:11:\"tiktok_link\";s:0:\"\";s:12:\"discord_link\";s:0:\"\";s:9:\"yelp_link\";s:0:\"\";s:7:\"vk_link\";s:0:\"\";s:7:\"ok_link\";s:0:\"\";s:18:\"social_email_links\";s:1:\"0\";s:19:\"social_share_notice\";s:0:\"\";s:8:\"share_fb\";s:1:\"1\";s:13:\"share_twitter\";s:1:\"1\";s:15:\"share_pinterest\";s:1:\"1\";s:14:\"share_linkedin\";s:1:\"1\";s:14:\"share_whatsapp\";s:1:\"0\";s:8:\"share_tg\";s:1:\"1\";s:11:\"share_viber\";s:1:\"0\";s:8:\"share_vk\";s:1:\"0\";s:8:\"share_ok\";s:1:\"0\";s:11:\"share_email\";s:1:\"0\";s:19:\"mobile_optimization\";s:1:\"0\";s:16:\"load_text_domain\";s:1:\"1\";s:21:\"disable_gutenberg_css\";s:1:\"1\";s:19:\"inline_critical_css\";b:0;s:19:\"advanced_css_notice\";s:0:\"\";s:17:\"styles_always_use\";s:0:\"\";s:14:\"styles_not_use\";s:0:\"\";s:26:\"disable_owl_mobile_devices\";s:1:\"0\";s:21:\"remove_jquery_migrate\";s:1:\"0\";s:18:\"advanced_js_notice\";s:0:\"\";s:11:\"advanced_js\";s:1:\"1\";s:20:\"autocomplete_library\";s:8:\"required\";s:14:\"cookie_library\";s:8:\"required\";s:24:\"countdown-bundle_library\";s:8:\"required\";s:14:\"device_library\";s:8:\"required\";s:22:\"isotope-bundle_library\";s:8:\"required\";s:17:\"justified_library\";s:8:\"required\";s:16:\"magnific_library\";s:8:\"required\";s:28:\"panr-parallax-bundle_library\";s:8:\"required\";s:16:\"parallax_library\";s:8:\"required\";s:30:\"parallax-scroll-bundle_library\";s:8:\"required\";s:25:\"photoswipe-bundle_library\";s:8:\"required\";s:12:\"pjax_library\";s:8:\"required\";s:18:\"sticky-kit_library\";s:8:\"required\";s:17:\"wd_swiper_library\";s:8:\"required\";s:18:\"threesixty_library\";s:8:\"required\";s:16:\"tooltips_library\";s:8:\"required\";s:13:\"vivus_library\";s:8:\"required\";s:17:\"waypoints_library\";s:8:\"required\";s:15:\"leaflet_library\";s:8:\"required\";s:20:\"vimeo_player_library\";s:8:\"required\";s:18:\"scripts_always_use\";s:0:\"\";s:15:\"scripts_not_use\";s:0:\"\";s:15:\"dequeue_scripts\";s:0:\"\";s:12:\"lazy_loading\";s:1:\"0\";s:22:\"lazy_loading_bg_images\";s:1:\"0\";s:19:\"lazy_loading_offset\";s:1:\"0\";s:11:\"lazy_effect\";s:4:\"fade\";s:23:\"lazy_custom_placeholder\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:30:\"disable_wordpress_lazy_loading\";s:1:\"1\";s:26:\"rocket_delay_js_exclusions\";s:1:\"1\";s:6:\"cf7_js\";s:1:\"1\";s:19:\"google_font_display\";s:7:\"disable\";s:18:\"icons_font_display\";s:7:\"disable\";s:16:\"font_awesome_css\";s:6:\"always\";s:23:\"font_icon_woff2_preload\";s:1:\"1\";s:9:\"preloader\";s:1:\"0\";s:15:\"preloader_image\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"preloader_background_color\";a:1:{s:4:\"idle\";s:7:\"#ffffff\";}s:22:\"preloader_color_scheme\";s:4:\"dark\";s:17:\"preload_lcp_image\";b:0;s:15:\"current_builder\";s:8:\"external\";s:16:\"gutenberg_blocks\";s:1:\"0\";s:29:\"enable_gutenberg_for_products\";s:1:\"0\";s:12:\"negative_gap\";s:7:\"enabled\";s:20:\"sticky_notifications\";s:1:\"1\";s:13:\"page_comments\";s:1:\"1\";s:15:\"custom_404_page\";s:0:\"\";s:16:\"widget_title_tag\";s:2:\"h5\";s:15:\"woodmart_slider\";s:1:\"1\";s:16:\"allow_upload_svg\";s:1:\"1\";s:29:\"rev_slider_inherit_theme_font\";s:1:\"1\";s:13:\"site_viewport\";s:12:\"not_scalable\";s:16:\"maintenance_mode\";s:1:\"0\";s:22:\"maintenance_access_key\";s:0:\"\";s:11:\"white_label\";s:1:\"0\";s:22:\"white_label_theme_name\";s:0:\"\";s:12:\"dummy_import\";s:1:\"1\";s:29:\"white_label_theme_license_tab\";s:1:\"1\";s:25:\"white_label_changelog_tab\";s:1:\"1\";s:20:\"theme_admin_bar_menu\";s:1:\"1\";s:23:\"white_label_theme_hints\";s:1:\"1\";s:29:\"white_label_sidebar_icon_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"white_label_dashboard_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:33:\"white_label_appearance_screenshot\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:27:\"white_label_dashboard_title\";s:0:\"\";s:26:\"white_label_dashboard_text\";s:0:\"\";s:5:\"reset\";s:0:\"\";s:12:\"reset_notice\";s:0:\"\";s:8:\"wishlist\";s:1:\"1\";s:13:\"wishlist_page\";s:4:\"3334\";s:15:\"wishlist_logged\";s:1:\"0\";s:20:\"wishlist_bulk_action\";s:1:\"1\";s:19:\"wishlist_empty_text\";s:201:\"شما هنوز هیچ کالایی در لیست علاقه مندی ها ندارید. <br> محصولات جالب بسیاری را در صفحه \"فروشگاه\" ما پیدا خواهید کرد.\";s:17:\"wishlist_expanded\";s:1:\"0\";s:19:\"wishlist_show_popup\";s:6:\"enable\";s:21:\"product_loop_wishlist\";s:1:\"1\";s:26:\"wishlist_save_button_state\";s:1:\"0\";s:27:\"checkout_show_product_image\";s:1:\"0\";s:25:\"checkout_product_quantity\";s:1:\"0\";s:22:\"checkout_remove_button\";s:1:\"0\";s:24:\"checkout_link_to_product\";s:1:\"0\";s:16:\"reviews_location\";s:4:\"tabs\";s:23:\"reviews_section_columns\";s:10:\"two-column\";s:21:\"reviews_form_location\";s:5:\"after\";s:13:\"reviews_style\";s:7:\"style-1\";s:15:\"reviews_columns\";s:1:\"2\";s:22:\"reviews_columns_tablet\";s:1:\"1\";s:22:\"reviews_columns_mobile\";s:1:\"1\";s:24:\"reviews_enable_pros_cons\";s:1:\"1\";s:20:\"reviews_enable_likes\";s:1:\"1\";s:32:\"show_reviews_purchased_indicator\";s:1:\"1\";s:15:\"reviews_sorting\";s:1:\"1\";s:29:\"single_product_comment_images\";s:1:\"1\";s:35:\"single_product_comment_images_count\";s:1:\"3\";s:41:\"single_product_comment_images_upload_size\";s:1:\"3\";s:38:\"single_product_comment_images_required\";s:1:\"0\";s:30:\"show_reviews_only_image_filter\";s:1:\"0\";s:22:\"reviews_rating_summary\";s:1:\"1\";s:30:\"reviews_rating_summary_content\";s:6:\"rating\";s:29:\"reviews_rating_summary_filter\";s:1:\"1\";s:26:\"reviews_rating_by_criteria\";s:1:\"1\";s:32:\"reviews_criteria_rating_required\";s:1:\"0\";s:38:\"reviews_rating_summary_criteria_1_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_1\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_2_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_2\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_3_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_3\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_4_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_4\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_5_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_5\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_6_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_6\";s:0:\"\";s:24:\"sticky_navigation_notice\";s:0:\"\";s:22:\"sticky_navigation_menu\";s:0:\"\";s:23:\"sticky_navigation_title\";s:0:\"\";s:30:\"sticky_navigation_content_type\";s:4:\"text\";s:22:\"sticky_navigation_area\";s:0:\"\";s:28:\"sticky_navigation_html_block\";s:0:\"\";s:33:\"single_product_main_gallery_video\";s:1:\"1\";s:23:\"checkout_fields_enabled\";s:1:\"1\";s:29:\"shipping_progress_bar_enabled\";s:1:\"0\";s:33:\"shipping_progress_bar_calculation\";s:6:\"custom\";s:28:\"shipping_progress_bar_amount\";s:3:\"100\";s:36:\"shipping_progress_bar_include_coupon\";s:7:\"exclude\";s:40:\"shipping_progress_bar_location_card_page\";s:1:\"1\";s:40:\"shipping_progress_bar_location_mini_cart\";s:1:\"1\";s:39:\"shipping_progress_bar_location_checkout\";s:1:\"0\";s:45:\"shipping_progress_bar_location_single_product\";s:1:\"0\";s:37:\"shipping_progress_bar_message_initial\";s:107:\"[remainder] را به سبد خرید اضافه کنید و ارسال رایگان دریافت کنید!\";s:37:\"shipping_progress_bar_message_success\";s:69:\"سفارش شما واجد شرایط ارسال رایگان است!\";s:15:\"buy_now_enabled\";s:1:\"0\";s:16:\"buy_now_redirect\";s:8:\"checkout\";s:23:\"counter_visitor_enabled\";s:1:\"1\";s:27:\"counter_visitor_data_source\";s:9:\"fake_data\";s:38:\"counter_visitor_data_source_min_number\";s:2:\"10\";s:38:\"counter_visitor_data_source_max_number\";s:2:\"20\";s:25:\"counter_visitor_live_mode\";s:1:\"0\";s:27:\"counter_visitor_ajax_update\";s:1:\"0\";s:29:\"counter_visitor_live_duration\";s:2:\"10\";s:17:\"linked_variations\";s:1:\"1\";s:21:\"show_single_variation\";s:1:\"0\";s:21:\"hide_variation_parent\";s:1:\"0\";s:23:\"bought_together_enabled\";s:1:\"1\";s:22:\"bought_together_column\";s:1:\"4\";s:29:\"bought_together_column_tablet\";s:4:\"auto\";s:29:\"bought_together_column_mobile\";s:4:\"auto\";s:26:\"bought_together_form_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:20:\"sold_counter_enabled\";s:1:\"0\";s:23:\"sold_counter_sales_type\";s:9:\"real_data\";s:24:\"sold_counter_shown_after\";s:1:\"0\";s:22:\"sold_counter_min_count\";s:2:\"10\";s:22:\"sold_counter_max_count\";s:2:\"20\";s:31:\"sold_counter_hide_on_outofstock\";s:1:\"0\";s:22:\"sold_counter_timeframe\";s:1:\"3\";s:29:\"sold_counter_timeframe_period\";s:7:\"minutes\";s:28:\"sold_counter_transient_hours\";s:2:\"37\";s:17:\"discounts_enabled\";s:1:\"0\";s:20:\"show_discounts_table\";s:1:\"0\";s:18:\"free_gifts_enabled\";s:1:\"0\";s:16:\"free_gifts_limit\";s:1:\"5\";s:41:\"free_gifts_allow_multiple_identical_gifts\";s:1:\"0\";s:23:\"free_gifts_price_format\";s:4:\"text\";s:17:\"free_gift_on_cart\";s:1:\"1\";s:25:\"free_gifts_table_location\";s:28:\"woocommerce_after_cart_table\";s:21:\"free_gift_on_checkout\";s:1:\"0\";s:28:\"show_out_of_stock_at_the_end\";s:1:\"0\";s:16:\"waitlist_enabled\";s:1:\"0\";s:21:\"waitlist_for_loggined\";s:1:\"0\";s:19:\"waitlist_form_state\";s:13:\"current_state\";s:25:\"waitlist_fragments_enable\";s:1:\"0\";s:22:\"waitlist_wait_interval\";s:4:\"3600\";s:32:\"waitlist_enable_privacy_checkbox\";s:1:\"1\";s:30:\"waitlist_privacy_checkbox_text\";s:84:\"من <strong>[privacy_policy]</strong> را خوانده‌ام و می‌پذیرم\";s:25:\"estimate_delivery_enabled\";s:1:\"0\";s:40:\"estimate_delivery_show_on_single_product\";s:1:\"1\";s:35:\"estimate_delivery_show_on_mini_cart\";s:1:\"0\";s:35:\"estimate_delivery_show_on_cart_page\";s:1:\"1\";s:39:\"estimate_delivery_show_on_checkout_page\";s:1:\"1\";s:39:\"estimate_delivery_show_on_order_details\";s:1:\"1\";s:37:\"estimate_delivery_show_on_email_order\";s:1:\"1\";s:30:\"estimate_delivery_show_overall\";s:1:\"0\";s:29:\"estimate_delivery_date_format\";s:7:\"default\";s:34:\"estimate_delivery_fragments_enable\";s:1:\"0\";s:27:\"custom_product_tabs_enabled\";s:1:\"1\";s:21:\"cart_recovery_enabled\";s:1:\"0\";s:26:\"recover_guest_cart_enabled\";s:1:\"0\";s:42:\"recover_guest_cart_enable_privacy_checkbox\";s:1:\"0\";s:40:\"recover_guest_cart_privacy_checkbox_text\";s:447:\"اگر این کادر را علامت بزنید، به ما اجازه می دهید تا برخی از جزئیات خود را در لیست مخاطبین ذخیره کنیم. ممکن است پیام های ایمیلی حاوی اطلاعات تجاری یا تبلیغاتی در مورد این فروشگاه دریافت کنید.\r\nاطلاعات شخصی جمع آوری شده: آدرس ایمیل، نام و نام خانوادگی.\";s:24:\"abandoned_cart_timeframe\";s:1:\"2\";s:31:\"abandoned_cart_timeframe_period\";s:5:\"86400\";s:31:\"abandoned_cart_delete_timeframe\";s:2:\"30\";s:38:\"abandoned_cart_delete_timeframe_period\";s:5:\"86400\";s:29:\"abandoned_cart_coupon_enabled\";s:1:\"0\";s:28:\"abandoned_cart_coupon_prefix\";s:2:\"WD\";s:28:\"abandoned_cart_coupon_amount\";s:2:\"10\";s:35:\"abandoned_cart_coupon_discount_type\";s:7:\"percent\";s:34:\"abandoned_cart_delete_used_coupons\";s:1:\"1\";s:37:\"abandoned_cart_delete_expired_coupons\";s:1:\"1\";s:31:\"abandoned_cart_coupon_timeframe\";s:1:\"1\";s:38:\"abandoned_cart_coupon_timeframe_period\";s:5:\"86400\";s:23:\"review_reminder_enabled\";s:1:\"0\";s:33:\"review_reminder_sending_timeframe\";s:1:\"7\";s:40:\"review_reminder_sending_timeframe_period\";s:5:\"86400\";s:21:\"price_tracker_enabled\";s:1:\"0\";s:26:\"price_tracker_for_loggined\";s:1:\"0\";s:32:\"price_tracker_use_loggedin_email\";s:1:\"0\";s:27:\"price_tracker_desired_price\";s:1:\"0\";s:37:\"price_tracker_enable_privacy_checkbox\";s:1:\"1\";s:30:\"price_tracker_fragments_enable\";s:1:\"0\";s:31:\"email_marketing_consent_enabled\";s:1:\"0\";s:37:\"email_subscription_individual_control\";s:1:\"0\";s:8:\"last_tab\";s:13:\"import_export\";}", "yes");
INSERT INTO `wp_options` VALUES("168", "woodmart_setup_status", "", "yes");
INSERT INTO `wp_options` VALUES("169", "wd_import_theme_version", "", "yes");
INSERT INTO `wp_options` VALUES("170", "woodmart-plugins-update-time", "1760114313", "yes");
INSERT INTO `wp_options` VALUES("171", "woodmart_js_composer_version", "8.6.1", "yes");
INSERT INTO `wp_options` VALUES("172", "woodmart_revslider_version", "6.7.38", "yes");
INSERT INTO `wp_options` VALUES("173", "RTL-CareUnit-PIL", "q1bKSS1LzVGyUnJMLsksSyzJzM9T0lEqLkksKS0GigaXJienFhcDhVJSi5OLMgvACqyUlGoB", "no");
INSERT INTO `wp_options` VALUES("175", "rcuPluginLastHealthyServerIndex", "1", "off");
INSERT INTO `wp_options` VALUES("178", "8_K0CHZzr_QxKvcO9vTzy6-oSgpMd7S1BQA", "DdBJgmtAAADQA1lQbV78RVBmCYoYdqWEmNoUgtP_PsDbPBWH_W5gIHu6vfW_yiEd8_WxEEXQU5v38usS152URCvOepBNcO3HbLXDIf8IxpU-6AMViTXbIabh4GfelTnevKLbBoD1SQPoLXfwje2H36oQxfi2KDR3Z1i3nv3B7Odw1CuVTY7vKS0NeW48SBcqOvdgEszkUcn4YyCR7V_cvYbAwrqKyaOZvDKiad910NPdHpw96GJMbowIkJPWsyL2b9UdyHQcETWNf6SMOyth_AsQo0cj5bxdWBngiW7cl6mijCHct9kNrTgY06ZefnfGOMDTJzVnqTy5MVKo4mfhTebNC3KzJqcQsr7p2Cn-7CsM8MsoZprGSLri-sW5cVT54oKmrKvIKwATm9P4zBc_yuAVLPtIhnTQP4TrdhzBLuAWoah2nqMVdiUEtWvN7ppJzdsB4HVps1-lVJH8iGVPtuJb6MjcrFaiI12QfJiQkKqaQNHoqC2Nb2cS_nexTWmFuNjOV59Z5y2M-dCIj020eWJqbBpyTLyO5h2nGFk6vB2DULsrNYDaQUfmF_FWi46jtDaaYWtfceOrSiiLsJ2MUUjZ_Oj4KrQjdZndA3WlL7fkOc7P_C3sjLE7vZL3UEi65Nk8eV3KwDVInX8Q8mZ5-SylCjcqo02_Ol1OoWjfx4K3rZd4h560sm2khHkyGNHbPod7bn9kRLMuny6R7EFUgRtIpe3MxU9ZP7Aw0PialM0PGBrw3P53DfZ5v7RwFeD3J81fpWy2ZMFJkFQZCrx__wE", "no");
INSERT INTO `wp_options` VALUES("179", "27e1a3911a89e7542f6ac9a6cd21e0804fa05df4", "def50200d6b3bffa278314c37712d8e4ee1dccdf3f06d757cb04d7fe7ae30469b47983da984620d58573edaa05d4031063101a2c920570cdc06c63c4cf2468316a245358d69b374fa2155e7ab35c5a338b1fde8c423768b7f2eca078b294cb6db35dff58f79ef63581da0f45601bdc6899fe760d8c043bd0599cdad4b1a4207ef0da8204ebabc21bb2562b8f750a168d2df8121a18f596ed7d3ae4d8c56419307a1be170f3ab7fe8b919a1433bae9ab66fbc58c8054c521b3fbd442a943945ff11a29461e9d3cd", "no");
INSERT INTO `wp_options` VALUES("180", "RTL-CareUnit-FPA", "1", "yes");
INSERT INTO `wp_options` VALUES("181", "xts-theme_settings_default-css-data", "@font-face {\n	font-weight: normal;\n	font-style: normal;\n	font-family: \"woodmart-font\";\n	src: url(\"//demoes.aramis-co.ir/woodmartpluss3/wp-content/themes/woodmart/fonts/woodmart-font-2-700.woff2?v=8.3.3\") format(\"woff2\");\n}\n\n:root {\n	--wd-header-banner-h: 40px;\n	--wd-text-font: IRANSansXFaNum;\n	--wd-text-font-weight: 400;\n	--wd-text-color: rgb(58,58,58);\n	--wd-text-font-size: 14px;\n	--wd-title-font: IRANSansXFaNum;\n	--wd-title-font-weight: 500;\n	--wd-title-color: #242424;\n	--wd-entities-title-font: IRANSansXFaNum;\n	--wd-entities-title-font-weight: 400;\n	--wd-entities-title-color: rgb(119,119,119);\n	--wd-entities-title-color-hover: rgb(51 51 51 / 65%);\n	--wd-alternative-font: IRANSansXFaNum;\n	--wd-widget-title-font: IRANSansXFaNum;\n	--wd-widget-title-font-weight: 500;\n	--wd-widget-title-transform: uppercase;\n	--wd-widget-title-color: rgb(119,119,119);\n	--wd-widget-title-font-size: 16px;\n	--wd-header-el-font: IRANSansXFaNum;\n	--wd-header-el-font-weight: 400;\n	--wd-header-el-transform: uppercase;\n	--wd-header-el-font-size: 15px;\n	--wd-brd-radius: 20px;\n	--wd-otl-style: dotted;\n	--wd-otl-width: 2px;\n	--wd-primary-color: rgb(214,6,68);\n	--wd-alternative-color: rgb(183,5,64);\n	--btn-default-bgcolor: #c1113d;\n	--btn-default-bgcolor-hover: #b63c56;\n	--btn-accented-bgcolor: #c1113d;\n	--btn-accented-bgcolor-hover: #c10537;\n	--wd-form-brd-width: 2px;\n	--notices-success-bg: #459647;\n	--notices-success-color: #fff;\n	--notices-warning-bg: #E0B252;\n	--notices-warning-color: #fff;\n	--wd-link-color: rgb(214,6,68);\n	--wd-link-color-hover: rgb(181,0,60);\n	--wd-sticky-btn-height: 95px;\n}\n.wd-age-verify-wrap {\n	--wd-popup-width: 500px;\n}\n.wd-popup.wd-promo-popup {\n	background-color: rgba(255,255,255,0);\n	background-image: none;\n	background-repeat: no-repeat;\n	background-size: contain;\n	background-position: left center;\n}\n.wd-promo-popup-wrap {\n	--wd-popup-width: 1000px;\n}\n.header-banner {\n	background-image: none;\n	background-repeat: no-repeat;\n	background-size: cover;\n	background-attachment: inherit;\n	background-position: center top;\n}\n:is(.woodmart-woocommerce-layered-nav, .wd-product-category-filter) .wd-scroll-content {\n	max-height: 280px;\n}\n.wd-page-title .wd-page-title-bg img {\n	object-fit: cover;\n	object-position: center center;\n}\n.wd-footer {\n	background-color: rgb(255,255,255);\n	background-image: none;\n}\nhtml .product-image-summary-wrap .product_title, html .wd-single-title .product_title, html .post.wd-post:not(.blog-design-small) .wd-entities-title {\n	font-family: IRANSansXFaNum;	font-size: 18px;\n}\n.woodmart-archive-shop:not(.single-product) .wd-page-content {\n	background-color: rgb(243,243,243);\n	background-image: none;\n}\n.single-product .wd-page-content {\n	background-color: rgb(243,243,243);\n	background-image: none;\n}\n.woodmart-archive-blog .wd-page-content {\n	background-color: rgb(243,243,243);\n	background-image: none;\n}\n.single-post .wd-page-content {\n	background-color: rgb(243,243,243);\n	background-image: none;\n}\n.woodmart-archive-portfolio .wd-page-content {\n	background-color: rgb(243,243,243);\n	background-image: none;\n}\n.single-portfolio .wd-page-content {\n	background-color: rgb(243,243,243);\n	background-image: none;\n}\n.mfp-wrap.wd-popup-quick-view-wrap {\n	--wd-popup-width: 920px;\n}\n\n@media (max-width: 1024px) {\n	:root {\n		--wd-header-banner-h: 40px;\n	--wd-sticky-btn-height: 95px;\n	}\n\n}\n\n@media (max-width: 768.98px) {\n	:root {\n		--wd-sticky-btn-height: 42px;\n	}\n\n}\n:root{\n--wd-container-w: 1350px;\n--wd-form-brd-radius: 5px;\n--btn-default-color: #fff;\n--btn-default-color-hover: #fff;\n--btn-accented-color: #fff;\n--btn-accented-color-hover: #fff;\n--btn-default-brd-radius: 35px;\n--btn-default-box-shadow: none;\n--btn-default-box-shadow-hover: none;\n--btn-accented-brd-radius: 35px;\n--btn-accented-box-shadow: none;\n--btn-accented-box-shadow-hover: none;\n}\n\n@media (min-width: 1350px) {\nsection.elementor-section.wd-section-stretch > .elementor-container {\nmargin-left: auto;\nmargin-right: auto;\n}\n}\n\nrs-slides :is([data-type=text],[data-type=button]) {\nfont-family: IRANSansXFaNum !important;\n}\nrs-slides :is(h1,h2,h3,h4,h5,h6)[data-type=text] {\nfont-family: IRANSansXFaNum !important;\n}\n\n.wd-page-title {\nbackground-color: #0a0a0a;\n}\n\n@font-face {\n	font-family: \"IRANSansXFaNumSite\";\n	font-weight: 400;\n	font-style: normal;\n}\n\n@media (min-width: 1025px) {\n	.blog-design-list .wd-post-excerpt\r\n{\r\ndisplay: block !important;\r\n    overflow: hidden !important;\r\n    text-overflow: ellipsis !important;\r\n    white-space: normal !important;\r\n    max-height: 3em !important;\r\n}\r\n\n}\n\n@media (min-width: 768px) and (max-width: 1024px) {\n	.tp-bullets{\r\n	display:none !important;\r\n}\r\n\r\nrs-arrow.hesperiden.tparrows:before{\r\ndisplay:none !important;\r\n}\n}\n\n@media (min-width: 577px) and (max-width: 767px) {\n	.shop_table_responsive :is(tbody,tfoot,tr)\r\n{\r\n	    padding-left: 10px;\r\n}\r\n\r\n\r\n.tp-bullets{\r\n	display:none !important;\r\n}\r\n\r\nrs-arrow.hesperiden.tparrows:before{\r\ndisplay:none !important;\r\n}\r\n\r\n.wd-hover-base .wd-product-countdown>span, .wd-hover-fw-button .wd-product-countdown>span, .wd-hover-tiled .wd-product-countdown>span\r\n{\r\n	font-size:10px;\r\n}\r\n\r\n\n}\n\n@media (max-width: 576px) {\n	.shop_table_responsive :is(tbody,tfoot,tr)\r\n{\r\n	    padding-left: 10px;\r\n}\r\n.tp-bullets{\r\n	display:none !important;\r\n}\r\n.wd-hover-base .wd-product-countdown>span, .wd-hover-fw-button .wd-product-countdown>span, .wd-hover-tiled .wd-product-countdown>span\r\n{\r\n	font-size:10px;\r\n}\r\nrs-arrow.hesperiden.tparrows:before{\r\ndisplay:none !important;\r\n}\r\n\r\nrs-arrow.hesperiden .tparrows{\r\ndisplay:none !important;\r\n}\r\ndiv[class*=wd-carousel-spacing] .owl-nav>div[class*=prev]\r\n{\r\n	margin-right:40px !important; \r\n}\r\ndiv[class*=wd-carousel-spacing] .owl-nav>div[class*=next]\r\n{\r\n	margin-left:40px !important;\r\n}\r\n\r\n#rev_slider_2_1_wrapper .hesperiden.tparrows {\r\n    cursor: pointer;\r\n    background: rgb(0 0 0 / 0%) !important;\r\n}\n}\n\n", "on");
INSERT INTO `wp_options` VALUES("183", "xts-theme_settings_default-version", "8.3.3", "on");
INSERT INTO `wp_options` VALUES("184", "xts-theme_settings_default-site-url", "6f329401eeafa2f2f2036d23c728ee0a", "on");
INSERT INTO `wp_options` VALUES("188", "RTL-CareUnit-PCS", "K_VP8s0q8PALCTJ3NSk2MDXWDio0drYwMDM3K3RxdfXMMQ9yLSvP848wNjFJCwh3zPX3NatIrMpKz3H08PcwNKwq0HctS3OL9LcMDIv09UlzSvJxccktywnysfBKz8ozMCh2C8v0NMoKz8y2BQA", "off");
INSERT INTO `wp_options` VALUES("190", "finished_updating_comment_type", "1", "yes");
INSERT INTO `wp_options` VALUES("193", "auto_update_plugins", "a:2:{i:0;s:29:\"RTL-CareUnit/RTL-CareUnit.php\";i:1;s:25:\"duplicator/duplicator.php\";}", "off");
INSERT INTO `wp_options` VALUES("194", "xts-default_header-css-data", ".whb-top-bar .wd-dropdown {\r\n	margin-top: 1px;\r\n}\r\n\r\n.whb-top-bar .wd-dropdown:after {\r\n	height: 11px;\r\n}\r\n\r\n\r\n.whb-header-bottom .wd-dropdown {\r\n	margin-top: 5px;\r\n}\r\n\r\n.whb-header-bottom .wd-dropdown:after {\r\n	height: 15px;\r\n}\r\n\r\n\r\n.whb-header .whb-header-bottom .wd-header-cats {\r\n	margin-top: -1px;\r\n	margin-bottom: -0px;\r\n	height: calc(100% + 1px);\r\n}\r\n\r\n\r\n@media (min-width: 1025px) {\r\n		.whb-top-bar-inner {\r\n		height: 42px;\r\n		max-height: 42px;\r\n	}\r\n\r\n		.whb-sticked .whb-top-bar-inner {\r\n		height: 40px;\r\n		max-height: 40px;\r\n	}\r\n		\r\n		.whb-general-header-inner {\r\n		height: 104px;\r\n		max-height: 104px;\r\n	}\r\n\r\n		.whb-sticked .whb-general-header-inner {\r\n		height: 60px;\r\n		max-height: 60px;\r\n	}\r\n		\r\n		.whb-header-bottom-inner {\r\n		height: 50px;\r\n		max-height: 50px;\r\n	}\r\n\r\n		.whb-sticked .whb-header-bottom-inner {\r\n		height: 50px;\r\n		max-height: 50px;\r\n	}\r\n		\r\n	\r\n	}\r\n\r\n@media (max-width: 1024px) {\r\n		.whb-top-bar-inner {\r\n		height: 40px;\r\n		max-height: 40px;\r\n	}\r\n	\r\n		.whb-general-header-inner {\r\n		height: 60px;\r\n		max-height: 60px;\r\n	}\r\n	\r\n	\r\n	\r\n	}\r\n		\r\n.whb-top-bar {\r\n	background-color: rgba(130, 183, 53, 1);\r\n}\r\n\r\n.whb-general-header {\r\n	border-color: rgba(129, 129, 129, 0.2);border-bottom-width: 1px;border-bottom-style: solid;\r\n}", "yes");
INSERT INTO `wp_options` VALUES("195", "xts-default_header-status", "valid", "yes");
INSERT INTO `wp_options` VALUES("196", "xts-default_header-version", "7.0.4", "yes");
INSERT INTO `wp_options` VALUES("197", "xts-default_header-site-url", "88ae533b1e9b7f3d9699c34b01d04477", "yes");
INSERT INTO `wp_options` VALUES("201", "recently_activated", "a:1:{s:49:\"advanced-database-cleaner/advanced-db-cleaner.php\";i:1760249943;}", "off");
INSERT INTO `wp_options` VALUES("204", "elementor_active_kit", "5", "yes");
INSERT INTO `wp_options` VALUES("205", "elementor_font_display", "swap", "yes");
INSERT INTO `wp_options` VALUES("208", "litespeed.conf.__activation", "", "yes");
INSERT INTO `wp_options` VALUES("209", "litespeed.purge.queue", "", "yes");
INSERT INTO `wp_options` VALUES("210", "litespeed.purge.queue2", "", "yes");
INSERT INTO `wp_options` VALUES("211", "rsssl_show_onboarding", "1", "no");
INSERT INTO `wp_options` VALUES("214", "revslider_servers", "a:3:{i:0;s:22:\"themepunch-ext-a.tools\";i:1;s:22:\"themepunch-ext-b.tools\";i:2;s:22:\"themepunch-ext-c.tools\";}", "yes");
INSERT INTO `wp_options` VALUES("215", "revslider_server_refresh", "1760102212", "yes");
INSERT INTO `wp_options` VALUES("216", "revslider-update-check-short", "1760114312", "yes");
INSERT INTO `wp_options` VALUES("217", "revslider-connection", "1", "yes");
INSERT INTO `wp_options` VALUES("218", "revslider-update-hash", "acebddb2347205df780dac0474b5ac58", "yes");
INSERT INTO `wp_options` VALUES("219", "revslider-latest-version", "6.7.38", "yes");
INSERT INTO `wp_options` VALUES("220", "revslider-stable-version", "4.2.0", "yes");
INSERT INTO `wp_options` VALUES("221", "revslider-notices", "a:5:{i:0;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:952:\"<div style=\"display: block; background: #1b0e41;text-align: center; height:300px;\"><noscript><img src=\"//updates.themepunch-ext-a.tools//banners/rs60/cyberweek.jpg\" usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\"></noscript><img usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\" src=\"//updates.themepunch-ext-a.tools//banners/rs60/cyberweek.jpg\"></div>\n<map name=\"srbannermap\">\n    <area target=\"_blank\" alt=\"Slider Revolution\" title=\"Slider Revolution\" href=\"https://www.sliderrevolution.com/black-friday-and-cyber-monday-sale/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=cyberweeks22\" coords=\"569,135,890,196\" shape=\"rect\">\n    <area target=\"_blank\" alt=\"Essential Grid\" title=\"Essential Grid\" href=\"https://www.essential-grid.com/?utm_source=admin&utm_medium=banner&utm_campaign=esgusers&utm_content=cyberweeks22\" coords=\"570,200,889,260\" shape=\"rect\">\n</map>\";s:4:\"code\";s:9:\"TPSRCW111\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:1;O:8:\"stdClass\":9:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:956:\"<div style=\"display: block; background: #1c0950;text-align: center; height:300px;\"><noscript><img src=\"//updates.themepunch-ext-a.tools//banners/blackfriday2024-admin2.jpg\" usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\"></noscript><img usemap=\"#srbannermap\" style=\"min-width:920px;height:300px;display: inline-block;\" src=\"//updates.themepunch-ext-a.tools//banners/blackfriday2024-admin2.jpg\"></div><map name=\"srbannermap\"><area target=\"_blank\" alt=\"Slider Revolution\" title=\"Slider Revolution\" href=\"https://www.sliderrevolution.com/black-friday-and-cyber-monday-sale/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=cyberweeks24\" coords=\"569,135,890,196\" shape=\"rect\"><area target=\"_blank\" alt=\"Essential Grid\" title=\"Essential Grid\" href=\"https://www.essential-grid.com/?utm_source=admin&utm_medium=banner&utm_campaign=esgusers&utm_content=cyberweeks24\" coords=\"570,200,889,260\" shape=\"rect\"></map>\";s:4:\"code\";s:8:\"TPSRBF24\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:2;O:8:\"stdClass\":10:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:527:\"<div style=\"display: block; background: #0d0d0e;text-align: center; height: 504px;\"><a href=\"https://account.sliderrevolution.com/portal/pricing/?utm_source=admin&utm_medium=banner&utm_campaign=srusers&utm_content=getpremium3\" target=\"_blank\" rel=\"noopener\"><video style=\"object-fit: cover; background-size: cover; opacity: 1; width: 900px; height: 504px; display: inline-block;\" muted loop autoplay preload=\"auto\"><source src=\"//updates.themepunch-ext-a.tools//banners/rs60/buypremium3.mp4\" type=\"video/mp4\"></video></a></div>\";s:4:\"code\";s:11:\"TPSNOTR3011\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:3;O:8:\"stdClass\":10:{s:7:\"version\";s:5:\"0.9.9\";s:4:\"text\";s:302:\"<div style=\"display: block; background: #0d0d0e;text-align: center; height: 250px;\"><a href=\"https://forms.gle/jrzzrpu34VvrFDsMA\" target=\"_blank\" rel=\"noopener\">\n<img style=\"min-width:920px;height:250px;display: inline-block;\" src=\"//updates.themepunch-ext-a.tools//banners/SR2024survey.jpg\"></a></div>\";s:4:\"code\";s:12:\"TPSURVEY2024\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:1;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:10:\"additional\";a:0:{}}i:4;O:8:\"stdClass\":11:{s:7:\"version\";s:5:\"9.9.9\";s:4:\"text\";s:324:\"<style type=\"text/css\">#rs_ads_1 .rs_close_advert { display: none; } #rs_ads_1 { box-shadow: none !important; }</style>\n<iframe id=\"sr-notice-ad-iframe-wrapper\" \n        src=\"//updates.themepunch-ext-a.tools//banners/ads/ads.php\"\n        style=\"text-align: center; height:360px;width: 100%;\"\n        scrolling=\"no\"\n</iframe>\";s:4:\"code\";s:10:\"TPAD1_2025\";s:5:\"color\";s:5:\"green\";s:7:\"disable\";b:0;s:10:\"registered\";b:0;s:9:\"is_global\";b:0;s:4:\"type\";s:1:\"3\";s:10:\"show_until\";s:19:\"0000-00-00 00:00:00\";s:2:\"id\";s:8:\"rs_ads_1\";s:10:\"additional\";a:0:{}}}", "yes");
INSERT INTO `wp_options` VALUES("222", "revslider-additions", "O:8:\"stdClass\":2:{s:9:\"templates\";O:8:\"stdClass\":3:{s:9:\"tutorials\";a:3:{i:0;O:8:\"stdClass\":2:{s:5:\"title\";s:19:\"Rapid Fire Overview\";s:3:\"url\";s:49:\"https://www.youtube.com/watch?v=LRNTFu-MFgw&t=25s\";}i:1;O:8:\"stdClass\":2:{s:5:\"title\";s:34:\"Responsiveness in Edited Templates\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=hP4oV8SWgKY\";}i:2;O:8:\"stdClass\":2:{s:5:\"title\";s:16:\"Animation Basics\";s:3:\"url\";s:43:\"https://www.youtube.com/watch?v=nn3azizwpbs\";}}s:5:\"guide\";O:8:\"stdClass\":3:{s:5:\"title\";s:78:\"Require Expert Technical Advice?<br />Submit a Ticket for Dedicated 1on1 Help.\";s:3:\"url\";s:36:\"https://support.sliderrevolution.com\";s:3:\"img\";s:67:\"//updates.themepunch-ext-a.tools/banners/default_template_guide.jpg\";}s:6:\"bottom\";O:8:\"stdClass\":2:{s:5:\"title\";s:32:\"Load A Template From The Library\";s:3:\"img\";s:61:\"//updates.themepunch-ext-a.tools/banners/guide_mod_banner.png\";}}s:7:\"selling\";b:1;}", "yes");
INSERT INTO `wp_options` VALUES("223", "rs-addons-counter", "1", "yes");
INSERT INTO `wp_options` VALUES("224", "revslider-addons", "O:8:\"stdClass\":36:{s:28:\"revslider-particlewave-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"559\";s:9:\"releaseid\";s:2:\"29\";s:4:\"slug\";s:28:\"revslider-particlewave-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:13:\"Particle Wave\";s:6:\"line_1\";s:36:\"Create 3D particle and polygon grids\";s:6:\"line_2\";s:40:\"with lots of style and animation options\";s:9:\"available\";s:5:\"6.7.7\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:1:\"9\";s:11:\"last_update\";s:10:\"2025-09-30\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:79:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_particlewave.jpg\";s:8:\"img_file\";s:46:\"revslider/addons/images/addon_particlewave.jpg\";s:7:\"img_md5\";s:32:\"623bec30f175f4cc541048f1d6d5fd07\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PW\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-particles-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"558\";s:9:\"releaseid\";s:1:\"7\";s:4:\"slug\";s:25:\"revslider-particles-addon\";s:12:\"version_from\";s:5:\"6.7.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:16:\"Particle Effects\";s:6:\"line_1\";s:17:\"Let\'s Parti(cle)!\";s:6:\"line_2\";s:51:\"Add interactive particle animations to your sliders\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:11:\"How to use?\";s:4:\"sort\";s:2:\"10\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_particles.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_particles.jpg\";s:7:\"img_md5\";s:32:\"b668a4015ddc6a532b43bb558967a062\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-bubblemorph-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"405\";s:9:\"releaseid\";s:2:\"20\";s:4:\"slug\";s:27:\"revslider-bubblemorph-addon\";s:12:\"version_from\";s:5:\"6.5.1\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"BubbleMorph\";s:6:\"line_1\";s:26:\"Include BubbleMorph Layers\";s:6:\"line_2\";s:33:\"for a decorative lava lamp effect\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"20\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_bubblemorph.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_bubblemorph.jpg\";s:7:\"img_md5\";s:32:\"22d03d5de3034069c6db1fdeafd467cd\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BM\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-thecluster-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"567\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:26:\"revslider-thecluster-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:11:\"The Cluster\";s:6:\"line_1\";s:24:\"Cluster Particle Effects\";s:6:\"line_2\";s:27:\"with millions of Variations\";s:9:\"available\";s:5:\"6.7.3\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"22\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:74:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_cluster.jpg\";s:8:\"img_file\";s:41:\"revslider/addons/images/addon_cluster.jpg\";s:7:\"img_md5\";s:32:\"7ada93a9f08a3bcfddc078699674d755\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TC\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:29:\"revslider-fluiddynamics-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"551\";s:9:\"releaseid\";s:2:\"31\";s:4:\"slug\";s:29:\"revslider-fluiddynamics-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Fluid Dynamics\";s:6:\"line_1\";s:46:\"Creating breathtaking Dynamic Fluid animations\";s:6:\"line_2\";s:25:\"as layer or as background\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"27\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:72:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_fluid.png\";s:8:\"img_file\";s:39:\"revslider/addons/images/addon_fluid.png\";s:7:\"img_md5\";s:32:\"4e52333540d80bcb2a41b8ed5961e088\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"FD\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:30:\"revslider-transitionpack-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:4:\"1471\";s:9:\"releaseid\";s:2:\"28\";s:4:\"slug\";s:30:\"revslider-transitionpack-addon\";s:12:\"version_from\";s:6:\"6.7.32\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:20:\"Advanced Transitions\";s:6:\"line_1\";s:43:\"Add never-before-seen slide transitions to \";s:6:\"line_2\";s:42:\"Slider Revolution with the power of WEBGL.\";s:9:\"available\";s:5:\"6.7.9\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"30\";s:11:\"last_update\";s:10:\"2025-07-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_transition.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_transition.jpg\";s:7:\"img_md5\";s:32:\"fe0f1c539053620039a0ad96c4ac27e6\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"AT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:27:\"revslider-beforeafter-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"545\";s:9:\"releaseid\";s:2:\"15\";s:4:\"slug\";s:27:\"revslider-beforeafter-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:14:\"Before & After\";s:6:\"line_1\";s:35:\"Compare two slides before and after\";s:6:\"line_2\";s:33:\"use it vertically or horizontally\";s:9:\"available\";s:5:\"6.7.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\"\";s:4:\"sort\";s:2:\"40\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:78:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_beforeafter.jpg\";s:8:\"img_file\";s:45:\"revslider/addons/images/addon_beforeafter.jpg\";s:7:\"img_md5\";s:32:\"5a34f20417a7874e1b95693ef37a0758\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"BA\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-typewriter-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"569\";s:9:\"releaseid\";s:1:\"3\";s:4:\"slug\";s:26:\"revslider-typewriter-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:17:\"Typewriter Effect\";s:6:\"line_1\";s:27:\"Enhance your slider\'s text \";s:6:\"line_2\";s:24:\"with typewriter effects \";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:9:\"Configure\";s:4:\"sort\";s:2:\"50\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_typewriter.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_typewriter.jpg\";s:7:\"img_md5\";s:32:\"727b604f6fd3fc55894ba50eb566efed\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"TW\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:25:\"revslider-mousetrap-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"555\";s:9:\"releaseid\";s:2:\"24\";s:4:\"slug\";s:25:\"revslider-mousetrap-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:9:\"Mousetrap\";s:6:\"line_1\";s:31:\"Create all kinds of interesting\";s:6:\"line_2\";s:19:\" mouse interactions\";s:9:\"available\";s:5:\"6.7.6\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"60\";s:11:\"last_update\";s:10:\"2024-11-04\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:76:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_mousetrap.jpg\";s:8:\"img_file\";s:43:\"revslider/addons/images/addon_mousetrap.jpg\";s:7:\"img_md5\";s:32:\"2329053c3b1d19bdaee131c3dc258d3a\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"MT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:28:\"revslider-liquideffect-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"552\";s:9:\"releaseid\";s:2:\"21\";s:4:\"slug\";s:28:\"revslider-liquideffect-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Distortion\";s:6:\"line_1\";s:22:\"Add Distortion Effects\";s:6:\"line_2\";s:30:\"to your slides and transitions\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"70\";s:11:\"last_update\";s:10:\"2025-09-30\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_distortion.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_distortion.jpg\";s:7:\"img_md5\";s:32:\"c26c52a563008b7dc907a288c1e4bb8e\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LE\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-lottie-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"553\";s:9:\"releaseid\";s:2:\"25\";s:4:\"slug\";s:22:\"revslider-lottie-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Lottie\";s:6:\"line_1\";s:53:\"Adds support for the popular Lottie Animation format,\";s:6:\"line_2\";s:70:\" including animation control, style customization and a local library.\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"80\";s:11:\"last_update\";s:10:\"2025-09-30\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:73:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_lottie.jpg\";s:8:\"img_file\";s:40:\"revslider/addons/images/addon_lottie.jpg\";s:7:\"img_md5\";s:32:\"4aa677a45bb13732e4f10bcb632afcce\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"LT\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:26:\"revslider-paintbrush-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"556\";s:9:\"releaseid\";s:2:\"23\";s:4:\"slug\";s:26:\"revslider-paintbrush-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:10:\"Paintbrush\";s:6:\"line_1\";s:14:\"Paint or Erase\";s:6:\"line_2\";s:22:\"your background images\";s:9:\"available\";s:5:\"6.7.4\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:6:\"How To\";s:4:\"sort\";s:2:\"90\";s:11:\"last_update\";s:10:\"2025-01-15\";s:6:\"global\";b:0;s:7:\"premium\";s:7:\"premium\";s:4:\"logo\";O:8:\"stdClass\":5:{s:3:\"img\";s:77:\"//updates.themepunch-ext-a.tools/revslider/addons/images/addon_paintbrush.jpg\";s:8:\"img_file\";s:44:\"revslider/addons/images/addon_paintbrush.jpg\";s:7:\"img_md5\";s:32:\"308a56289b9a29d1916c2acfc141b699\";s:5:\"color\";s:0:\"\";s:4:\"text\";s:2:\"PB\";}s:6:\"banner\";s:0:\"\";s:11:\"banner_file\";s:0:\"\";s:10:\"banner_md5\";s:0:\"\";s:4:\"tags\";a:0:{}}s:22:\"revslider-charts-addon\";O:8:\"stdClass\":22:{s:2:\"id\";s:3:\"547\";s:9:\"releaseid\";s:2:\"27\";s:4:\"slug\";s:22:\"revslider-charts-addon\";s:12:\"version_from\";s:5:\"6.7.0\";s:10:\"version_to\";s:5:\"9.9.9\";s:5:\"title\";s:6:\"Charts\";s:6:\"line_1\";s:93:\"The Charts addon allows you to create visually impressive line or bar graphs from .csv data, \";s:6:\"line_2\";s:56:\"with tons of options to take full control of the design.\";s:9:\"available\";s:5:\"6.7.5\";s:10:\"background\";s:0:\"\";s:15:\"background_file\";s:0:\"\";s:14:\"background_md5\";s:0:\"\";s:6:\"button\";s:0:\