/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2025-06-10 15:31:25 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `hook_status_scheduled_date_gmt` (`hook`(163),`status`,`scheduled_date_gmt`),
  KEY `status_scheduled_date_gmt` (`status`,`scheduled_date_gmt`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=885 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=422 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=MyISAM AUTO_INCREMENT=2625 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=MyISAM AUTO_INCREMENT=6338 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=8372 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=MyISAM AUTO_INCREMENT=977 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_rtl_rsm_logs` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `section` varchar(255) NOT NULL,
  `result` mediumtext NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=MyISAM AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=362 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=MyISAM AUTO_INCREMENT=36 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=MyISAM AUTO_INCREMENT=82 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=1234 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  PRIMARY KEY (`note_id`)
) ENGINE=MyISAM AUTO_INCREMENT=63 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_product_date` (`customer_id`,`product_id`,`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_method_title` text DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `global_unique_id` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=MyISAM AUTO_INCREMENT=50 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `zone_id` (`zone_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_woodmart_wishlist_products` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` varchar(255) NOT NULL,
  `wishlist_id` int(11) DEFAULT NULL,
  `date_added` timestamp NOT NULL DEFAULT current_timestamp(),
  `on_sale` tinyint(1) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `product_id` (`product_id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

CREATE TABLE `wp_woodmart_wishlists` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `wishlist_group` varchar(255) NOT NULL DEFAULT 'لیست علاقمندی های من',
  `date_created` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`ID`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3 COLLATE=utf8mb3_general_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("859", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-05-20 15:12:06", "2025-05-20 15:12:06", "10", "[942,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747753926;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747753926;}", "4", "1", "2025-05-20 15:12:08", "2025-05-20 18:42:08", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("858", "wc_delete_related_product_transients_async", "complete", "2025-05-20 15:12:05", "2025-05-20 15:12:05", "10", "{\"post_id\":942}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747753925;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747753925;}", "5", "1", "2025-05-20 15:12:08", "2025-05-20 18:42:08", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("857", "woocommerce_cleanup_draft_orders", "complete", "2025-05-21 15:03:46", "2025-05-21 15:03:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747839826;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747839826;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-05-22 20:32:10", "2025-05-23 00:02:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("860", "woocommerce_cleanup_draft_orders", "complete", "2025-05-23 20:32:10", "2025-05-23 20:32:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748032330;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748032330;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-05-24 10:43:33", "2025-05-24 14:13:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("861", "woocommerce_cleanup_draft_orders", "complete", "2025-05-25 10:43:33", "2025-05-25 10:43:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748169813;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748169813;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-05-25 12:45:14", "2025-05-25 16:15:14", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("862", "woocommerce_cleanup_draft_orders", "complete", "2025-05-26 12:45:14", "2025-05-26 12:45:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748263514;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748263514;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-05-26 14:03:46", "2025-05-26 17:33:46", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("863", "woocommerce_cleanup_draft_orders", "complete", "2025-05-27 14:03:46", "2025-05-27 14:03:46", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748354626;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748354626;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-05-27 14:28:10", "2025-05-27 17:58:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("864", "woocommerce_cleanup_draft_orders", "complete", "2025-05-28 14:28:10", "2025-05-28 14:28:10", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748442490;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748442490;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-05-28 16:02:51", "2025-05-28 19:32:51", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("113", "woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications", "failed", "2025-04-19 20:55:48", "2025-04-19 20:55:48", "10", "[]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "2", "1", "2025-04-19 20:55:50", "2025-04-20 00:25:50", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("865", "woocommerce_cleanup_draft_orders", "complete", "2025-05-29 16:02:51", "2025-05-29 16:02:51", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748534571;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748534571;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-05-29 16:04:25", "2025-05-29 19:34:25", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("866", "woocommerce_cleanup_draft_orders", "complete", "2025-05-30 16:04:25", "2025-05-30 16:04:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748621065;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748621065;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-05-30 21:47:37", "2025-05-31 01:17:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("867", "woocommerce_cleanup_draft_orders", "complete", "2025-05-31 21:47:37", "2025-05-31 21:47:37", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748728057;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748728057;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-06-01 10:23:17", "2025-06-01 13:53:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("868", "woocommerce_cleanup_draft_orders", "complete", "2025-06-02 10:23:17", "2025-06-02 10:23:17", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1748859797;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1748859797;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-06-03 06:25:24", "2025-06-03 09:55:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("869", "wc_delete_related_product_transients_async", "complete", "2025-06-01 11:24:19", "2025-06-01 11:24:19", "10", "{\"post_id\":253}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1748777059;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1748777059;}", "5", "1", "2025-06-02 08:01:31", "2025-06-02 11:31:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("870", "woocommerce_cleanup_draft_orders", "complete", "2025-06-04 06:25:24", "2025-06-04 06:25:24", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749018324;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749018324;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-06-04 10:49:14", "2025-06-04 14:19:14", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("871", "woocommerce_cleanup_draft_orders", "complete", "2025-06-05 10:49:14", "2025-06-05 10:49:14", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749120554;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749120554;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-06-07 08:47:06", "2025-06-07 12:17:06", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("872", "woocommerce_cleanup_draft_orders", "complete", "2025-06-08 08:47:06", "2025-06-08 08:47:06", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749372426;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749372426;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-06-08 11:03:40", "2025-06-08 14:33:40", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("873", "woocommerce_cleanup_draft_orders", "complete", "2025-06-09 11:03:40", "2025-06-09 11:03:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749467020;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749467020;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-06-09 14:30:35", "2025-06-09 18:00:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("874", "woocommerce_cleanup_draft_orders", "complete", "2025-06-10 14:30:35", "2025-06-10 14:30:35", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749565835;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749565835;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-06-10 14:50:12", "2025-06-10 18:20:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("875", "woocommerce_cleanup_draft_orders", "pending", "2025-06-11 14:50:12", "2025-06-11 14:50:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749653412;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749653412;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("876", "fetch_patterns", "complete", "2025-06-10 15:27:22", "2025-06-10 15:27:22", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749569242;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749569242;}", "2", "1", "2025-06-10 15:27:28", "2025-06-10 18:57:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("877", "woocommerce_run_update_callback", "complete", "2025-06-10 15:27:26", "2025-06-10 15:27:26", "10", "{\"update_callback\":\"wc_update_985_enable_new_payments_settings_page_feature\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749569246;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749569246;}", "4", "1", "2025-06-10 15:27:28", "2025-06-10 18:57:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("878", "woocommerce_run_update_callback", "complete", "2025-06-10 15:27:27", "2025-06-10 15:27:27", "10", "{\"update_callback\":\"wc_update_990_remove_wc_count_comments_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749569247;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749569247;}", "4", "1", "2025-06-10 15:27:28", "2025-06-10 18:57:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("879", "woocommerce_run_update_callback", "complete", "2025-06-10 15:27:28", "2025-06-10 15:27:28", "10", "{\"update_callback\":\"wc_update_990_remove_email_notes\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749569248;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749569248;}", "4", "1", "2025-06-10 15:27:28", "2025-06-10 18:57:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("880", "woocommerce_update_db_to_current_version", "complete", "2025-06-10 15:27:29", "2025-06-10 15:27:29", "10", "{\"version\":\"9.9.3\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749569249;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749569249;}", "4", "1", "2025-06-10 15:27:35", "2025-06-10 18:57:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("881", "woocommerce_run_update_callback", "complete", "2025-06-10 15:27:27", "2025-06-10 15:27:27", "10", "{\"update_callback\":\"wc_update_985_enable_new_payments_settings_page_feature\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749569247;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749569247;}", "4", "1", "2025-06-10 15:27:28", "2025-06-10 18:57:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("882", "woocommerce_run_update_callback", "complete", "2025-06-10 15:27:28", "2025-06-10 15:27:28", "10", "{\"update_callback\":\"wc_update_990_remove_wc_count_comments_transient\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749569248;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749569248;}", "4", "1", "2025-06-10 15:27:28", "2025-06-10 18:57:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("883", "woocommerce_run_update_callback", "complete", "2025-06-10 15:27:29", "2025-06-10 15:27:29", "10", "{\"update_callback\":\"wc_update_990_remove_email_notes\"}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1749569249;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1749569249;}", "4", "1", "2025-06-10 15:27:35", "2025-06-10 18:57:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("345", "woocommerce_cleanup_draft_orders", "complete", "2025-04-21 15:12:48", "2025-04-21 15:12:48", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1745248368;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1745248368;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-04-21 15:48:55", "2025-04-21 19:18:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("386", "wc_delete_related_product_transients_async", "complete", "2025-04-20 15:29:58", "2025-04-20 15:29:58", "10", "{\"post_id\":242}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745162998;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745162998;}", "5", "1", "2025-04-20 15:31:12", "2025-04-20 19:01:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("387", "wc_delete_related_product_transients_async", "complete", "2025-04-20 15:29:58", "2025-04-20 15:29:58", "10", "{\"post_id\":241}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745162998;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745162998;}", "5", "1", "2025-04-20 15:31:12", "2025-04-20 19:01:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("388", "wc_delete_related_product_transients_async", "complete", "2025-04-20 15:29:58", "2025-04-20 15:29:58", "10", "{\"post_id\":243}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745162998;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745162998;}", "5", "1", "2025-04-20 15:31:12", "2025-04-20 19:01:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("389", "wc_delete_related_product_transients_async", "complete", "2025-04-20 15:29:58", "2025-04-20 15:29:58", "10", "{\"post_id\":241}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745162998;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745162998;}", "5", "1", "2025-04-20 15:31:12", "2025-04-20 19:01:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("390", "wc_delete_related_product_transients_async", "complete", "2025-04-20 15:29:58", "2025-04-20 15:29:58", "10", "{\"post_id\":244}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745162998;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745162998;}", "5", "1", "2025-04-20 15:31:12", "2025-04-20 19:01:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("391", "wc_delete_related_product_transients_async", "complete", "2025-04-20 15:29:58", "2025-04-20 15:29:58", "10", "{\"post_id\":241}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745162998;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745162998;}", "5", "1", "2025-04-20 15:31:12", "2025-04-20 19:01:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("392", "wc_delete_related_product_transients_async", "complete", "2025-04-20 15:29:58", "2025-04-20 15:29:58", "10", "{\"post_id\":245}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745162998;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745162998;}", "5", "1", "2025-04-20 15:31:12", "2025-04-20 19:01:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("393", "wc_delete_related_product_transients_async", "complete", "2025-04-20 15:29:58", "2025-04-20 15:29:58", "10", "{\"post_id\":241}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745162998;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745162998;}", "5", "1", "2025-04-20 15:31:12", "2025-04-20 19:01:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("394", "wc_delete_related_product_transients_async", "complete", "2025-04-20 15:29:58", "2025-04-20 15:29:58", "10", "{\"post_id\":246}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745162998;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745162998;}", "5", "1", "2025-04-20 15:31:12", "2025-04-20 19:01:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("395", "wc_delete_related_product_transients_async", "complete", "2025-04-20 15:29:58", "2025-04-20 15:29:58", "10", "{\"post_id\":241}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745162998;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745162998;}", "5", "1", "2025-04-20 15:31:12", "2025-04-20 19:01:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("396", "wc_delete_related_product_transients_async", "complete", "2025-04-20 15:29:58", "2025-04-20 15:29:58", "10", "{\"post_id\":241}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745162998;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745162998;}", "5", "1", "2025-04-20 15:31:12", "2025-04-20 19:01:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("397", "wc_delete_related_product_transients_async", "complete", "2025-04-20 15:29:58", "2025-04-20 15:29:58", "10", "{\"post_id\":241}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745162998;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745162998;}", "5", "1", "2025-04-20 15:31:12", "2025-04-20 19:01:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("398", "wc_delete_related_product_transients_async", "complete", "2025-04-20 15:29:58", "2025-04-20 15:29:58", "10", "{\"post_id\":241}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745162998;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745162998;}", "5", "1", "2025-04-20 15:31:12", "2025-04-20 19:01:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("399", "wc_delete_related_product_transients_async", "complete", "2025-04-20 15:30:13", "2025-04-20 15:30:13", "10", "{\"post_id\":242}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745163013;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745163013;}", "5", "1", "2025-04-20 15:31:12", "2025-04-20 19:01:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("400", "wc_delete_related_product_transients_async", "complete", "2025-04-20 15:30:13", "2025-04-20 15:30:13", "10", "{\"post_id\":241}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745163013;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745163013;}", "5", "1", "2025-04-20 15:31:12", "2025-04-20 19:01:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("401", "wc_delete_related_product_transients_async", "complete", "2025-04-20 15:30:13", "2025-04-20 15:30:13", "10", "{\"post_id\":243}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745163013;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745163013;}", "5", "1", "2025-04-20 15:31:12", "2025-04-20 19:01:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("402", "wc_delete_related_product_transients_async", "complete", "2025-04-20 15:30:13", "2025-04-20 15:30:13", "10", "{\"post_id\":241}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745163013;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745163013;}", "5", "1", "2025-04-20 15:31:12", "2025-04-20 19:01:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("403", "wc_delete_related_product_transients_async", "complete", "2025-04-20 15:30:13", "2025-04-20 15:30:13", "10", "{\"post_id\":244}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745163013;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745163013;}", "5", "1", "2025-04-20 15:31:12", "2025-04-20 19:01:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("404", "wc_delete_related_product_transients_async", "complete", "2025-04-20 15:30:13", "2025-04-20 15:30:13", "10", "{\"post_id\":241}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745163013;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745163013;}", "5", "1", "2025-04-20 15:31:12", "2025-04-20 19:01:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("405", "wc_delete_related_product_transients_async", "complete", "2025-04-20 15:30:13", "2025-04-20 15:30:13", "10", "{\"post_id\":245}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745163013;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745163013;}", "5", "1", "2025-04-20 15:31:12", "2025-04-20 19:01:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("406", "wc_delete_related_product_transients_async", "complete", "2025-04-20 15:30:13", "2025-04-20 15:30:13", "10", "{\"post_id\":241}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745163013;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745163013;}", "5", "1", "2025-04-20 15:31:12", "2025-04-20 19:01:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("407", "wc_delete_related_product_transients_async", "complete", "2025-04-20 15:30:13", "2025-04-20 15:30:13", "10", "{\"post_id\":246}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745163013;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745163013;}", "5", "1", "2025-04-20 15:31:12", "2025-04-20 19:01:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("408", "wc_delete_related_product_transients_async", "complete", "2025-04-20 15:30:13", "2025-04-20 15:30:13", "10", "{\"post_id\":241}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745163013;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745163013;}", "5", "1", "2025-04-20 15:31:12", "2025-04-20 19:01:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("409", "wc_delete_related_product_transients_async", "complete", "2025-04-20 15:30:13", "2025-04-20 15:30:13", "10", "{\"post_id\":241}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745163013;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745163013;}", "5", "1", "2025-04-20 15:31:12", "2025-04-20 19:01:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("410", "wc_delete_related_product_transients_async", "complete", "2025-04-20 15:30:13", "2025-04-20 15:30:13", "10", "{\"post_id\":241}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745163013;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745163013;}", "5", "1", "2025-04-20 15:31:12", "2025-04-20 19:01:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("411", "wc_delete_related_product_transients_async", "complete", "2025-04-20 15:30:13", "2025-04-20 15:30:13", "10", "{\"post_id\":241}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745163013;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745163013;}", "5", "1", "2025-04-20 15:31:12", "2025-04-20 19:01:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("412", "wc_delete_related_product_transients_async", "complete", "2025-04-20 15:31:18", "2025-04-20 15:31:18", "10", "{\"post_id\":241}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745163078;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745163078;}", "5", "1", "2025-04-20 15:32:38", "2025-04-20 19:02:38", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("413", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 15:31:19", "2025-04-20 15:31:19", "10", "[241,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745163079;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745163079;}", "4", "1", "2025-04-20 15:32:38", "2025-04-20 19:02:38", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("414", "wc_delete_related_product_transients_async", "complete", "2025-04-20 15:31:18", "2025-04-20 15:31:18", "10", "{\"post_id\":241}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745163078;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745163078;}", "5", "1", "2025-04-20 15:32:38", "2025-04-20 19:02:38", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("415", "fetch_patterns", "complete", "2025-04-20 16:22:49", "2025-04-20 16:22:49", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166169;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166169;}", "2", "1", "2025-04-20 16:23:00", "2025-04-20 19:53:00", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("416", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:23:46", "2025-04-20 16:23:46", "10", "{\"post_id\":248}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166226;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166226;}", "5", "1", "2025-04-20 16:24:18", "2025-04-20 19:54:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("417", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:23:46", "2025-04-20 16:23:46", "10", "{\"post_id\":247}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166226;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166226;}", "5", "1", "2025-04-20 16:24:18", "2025-04-20 19:54:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("418", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:23:46", "2025-04-20 16:23:46", "10", "{\"post_id\":249}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166226;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166226;}", "5", "1", "2025-04-20 16:24:18", "2025-04-20 19:54:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("419", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:23:46", "2025-04-20 16:23:46", "10", "{\"post_id\":247}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166226;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166226;}", "5", "1", "2025-04-20 16:24:18", "2025-04-20 19:54:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("420", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:23:46", "2025-04-20 16:23:46", "10", "{\"post_id\":250}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166226;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166226;}", "5", "1", "2025-04-20 16:24:18", "2025-04-20 19:54:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("421", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:23:46", "2025-04-20 16:23:46", "10", "{\"post_id\":247}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166226;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166226;}", "5", "1", "2025-04-20 16:24:18", "2025-04-20 19:54:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("422", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:23:46", "2025-04-20 16:23:46", "10", "{\"post_id\":251}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166226;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166226;}", "5", "1", "2025-04-20 16:24:18", "2025-04-20 19:54:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("423", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:23:46", "2025-04-20 16:23:46", "10", "{\"post_id\":247}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166226;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166226;}", "5", "1", "2025-04-20 16:24:18", "2025-04-20 19:54:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("424", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:23:46", "2025-04-20 16:23:46", "10", "{\"post_id\":252}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166226;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166226;}", "5", "1", "2025-04-20 16:24:18", "2025-04-20 19:54:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("425", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:23:46", "2025-04-20 16:23:46", "10", "{\"post_id\":247}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166226;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166226;}", "5", "1", "2025-04-20 16:24:18", "2025-04-20 19:54:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("426", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:23:46", "2025-04-20 16:23:46", "10", "{\"post_id\":247}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166226;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166226;}", "5", "1", "2025-04-20 16:24:18", "2025-04-20 19:54:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("427", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:23:46", "2025-04-20 16:23:46", "10", "{\"post_id\":247}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166226;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166226;}", "5", "1", "2025-04-20 16:24:18", "2025-04-20 19:54:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("428", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:23:46", "2025-04-20 16:23:46", "10", "{\"post_id\":247}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166226;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166226;}", "5", "1", "2025-04-20 16:24:18", "2025-04-20 19:54:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("429", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:24:18", "2025-04-20 16:24:18", "10", "{\"post_id\":248}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166258;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166258;}", "5", "1", "2025-04-20 16:24:18", "2025-04-20 19:54:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("430", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:24:18", "2025-04-20 16:24:18", "10", "{\"post_id\":247}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166258;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166258;}", "5", "1", "2025-04-20 16:24:18", "2025-04-20 19:54:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("431", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:24:18", "2025-04-20 16:24:18", "10", "{\"post_id\":249}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166258;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166258;}", "5", "1", "2025-04-20 16:24:18", "2025-04-20 19:54:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("432", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:24:18", "2025-04-20 16:24:18", "10", "{\"post_id\":247}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166258;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166258;}", "5", "1", "2025-04-20 16:24:18", "2025-04-20 19:54:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("433", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:24:18", "2025-04-20 16:24:18", "10", "{\"post_id\":250}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166258;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166258;}", "5", "1", "2025-04-20 16:24:18", "2025-04-20 19:54:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("434", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:24:18", "2025-04-20 16:24:18", "10", "{\"post_id\":247}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166258;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166258;}", "5", "1", "2025-04-20 16:24:18", "2025-04-20 19:54:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("435", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:24:18", "2025-04-20 16:24:18", "10", "{\"post_id\":251}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166258;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166258;}", "5", "1", "2025-04-20 16:24:18", "2025-04-20 19:54:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("436", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:24:18", "2025-04-20 16:24:18", "10", "{\"post_id\":247}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166258;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166258;}", "5", "1", "2025-04-20 16:24:18", "2025-04-20 19:54:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("437", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:24:18", "2025-04-20 16:24:18", "10", "{\"post_id\":252}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166258;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166258;}", "5", "1", "2025-04-20 16:24:18", "2025-04-20 19:54:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("438", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:24:18", "2025-04-20 16:24:18", "10", "{\"post_id\":247}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166258;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166258;}", "5", "1", "2025-04-20 16:24:18", "2025-04-20 19:54:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("439", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:24:18", "2025-04-20 16:24:18", "10", "{\"post_id\":247}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166258;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166258;}", "5", "1", "2025-04-20 16:24:18", "2025-04-20 19:54:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("440", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:24:18", "2025-04-20 16:24:18", "10", "{\"post_id\":247}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166258;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166258;}", "5", "1", "2025-04-20 16:24:18", "2025-04-20 19:54:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("441", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:24:18", "2025-04-20 16:24:18", "10", "{\"post_id\":247}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166258;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166258;}", "5", "1", "2025-04-20 16:24:18", "2025-04-20 19:54:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("442", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:24:31", "2025-04-20 16:24:31", "10", "{\"post_id\":248}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166271;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166271;}", "5", "1", "2025-04-20 16:25:43", "2025-04-20 19:55:43", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("443", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:24:31", "2025-04-20 16:24:31", "10", "{\"post_id\":247}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166271;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166271;}", "5", "1", "2025-04-20 16:25:44", "2025-04-20 19:55:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("444", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:24:31", "2025-04-20 16:24:31", "10", "{\"post_id\":249}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166271;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166271;}", "5", "1", "2025-04-20 16:25:44", "2025-04-20 19:55:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("445", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:24:31", "2025-04-20 16:24:31", "10", "{\"post_id\":247}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166271;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166271;}", "5", "1", "2025-04-20 16:25:44", "2025-04-20 19:55:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("446", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:24:31", "2025-04-20 16:24:31", "10", "{\"post_id\":250}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166271;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166271;}", "5", "1", "2025-04-20 16:25:44", "2025-04-20 19:55:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("447", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:24:31", "2025-04-20 16:24:31", "10", "{\"post_id\":247}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166271;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166271;}", "5", "1", "2025-04-20 16:25:44", "2025-04-20 19:55:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("448", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:24:31", "2025-04-20 16:24:31", "10", "{\"post_id\":251}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166271;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166271;}", "5", "1", "2025-04-20 16:25:44", "2025-04-20 19:55:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("449", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:24:31", "2025-04-20 16:24:31", "10", "{\"post_id\":247}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166271;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166271;}", "5", "1", "2025-04-20 16:25:44", "2025-04-20 19:55:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("450", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:24:31", "2025-04-20 16:24:31", "10", "{\"post_id\":252}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166271;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166271;}", "5", "1", "2025-04-20 16:25:44", "2025-04-20 19:55:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("451", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:24:31", "2025-04-20 16:24:31", "10", "{\"post_id\":247}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166271;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166271;}", "5", "1", "2025-04-20 16:25:44", "2025-04-20 19:55:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("452", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:24:31", "2025-04-20 16:24:31", "10", "{\"post_id\":247}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166271;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166271;}", "5", "1", "2025-04-20 16:25:44", "2025-04-20 19:55:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("453", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:24:31", "2025-04-20 16:24:31", "10", "{\"post_id\":247}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166271;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166271;}", "5", "1", "2025-04-20 16:25:44", "2025-04-20 19:55:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("454", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:24:31", "2025-04-20 16:24:31", "10", "{\"post_id\":247}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166271;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166271;}", "5", "1", "2025-04-20 16:25:44", "2025-04-20 19:55:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("455", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:24:48", "2025-04-20 16:24:48", "10", "{\"post_id\":247}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166288;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166288;}", "5", "1", "2025-04-20 16:25:44", "2025-04-20 19:55:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("456", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 16:24:49", "2025-04-20 16:24:49", "10", "[247,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166289;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166289;}", "4", "1", "2025-04-20 16:25:44", "2025-04-20 19:55:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("457", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:24:48", "2025-04-20 16:24:48", "10", "{\"post_id\":247}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166288;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166288;}", "5", "1", "2025-04-20 16:25:44", "2025-04-20 19:55:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("458", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:26:10", "2025-04-20 16:26:10", "10", "{\"post_id\":254}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166370;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166370;}", "5", "1", "2025-04-20 16:26:44", "2025-04-20 19:56:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("459", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:26:10", "2025-04-20 16:26:10", "10", "{\"post_id\":253}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166370;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166370;}", "5", "1", "2025-04-20 16:26:44", "2025-04-20 19:56:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("460", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:26:10", "2025-04-20 16:26:10", "10", "{\"post_id\":255}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166370;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166370;}", "5", "1", "2025-04-20 16:26:44", "2025-04-20 19:56:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("461", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:26:10", "2025-04-20 16:26:10", "10", "{\"post_id\":253}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166370;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166370;}", "5", "1", "2025-04-20 16:26:44", "2025-04-20 19:56:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("462", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:26:10", "2025-04-20 16:26:10", "10", "{\"post_id\":256}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166370;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166370;}", "5", "1", "2025-04-20 16:26:44", "2025-04-20 19:56:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("463", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:26:10", "2025-04-20 16:26:10", "10", "{\"post_id\":253}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166370;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166370;}", "5", "1", "2025-04-20 16:26:44", "2025-04-20 19:56:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("464", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:26:10", "2025-04-20 16:26:10", "10", "{\"post_id\":257}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166370;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166370;}", "5", "1", "2025-04-20 16:26:44", "2025-04-20 19:56:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("465", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:26:10", "2025-04-20 16:26:10", "10", "{\"post_id\":253}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166370;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166370;}", "5", "1", "2025-04-20 16:26:44", "2025-04-20 19:56:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("466", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:26:10", "2025-04-20 16:26:10", "10", "{\"post_id\":258}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166370;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166370;}", "5", "1", "2025-04-20 16:26:44", "2025-04-20 19:56:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("467", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:26:10", "2025-04-20 16:26:10", "10", "{\"post_id\":253}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166370;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166370;}", "5", "1", "2025-04-20 16:26:44", "2025-04-20 19:56:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("468", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:26:10", "2025-04-20 16:26:10", "10", "{\"post_id\":253}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166370;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166370;}", "5", "1", "2025-04-20 16:26:44", "2025-04-20 19:56:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("469", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:26:10", "2025-04-20 16:26:10", "10", "{\"post_id\":253}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166370;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166370;}", "5", "1", "2025-04-20 16:26:44", "2025-04-20 19:56:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("470", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:26:10", "2025-04-20 16:26:10", "10", "{\"post_id\":253}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166370;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166370;}", "5", "1", "2025-04-20 16:26:44", "2025-04-20 19:56:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("471", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:26:30", "2025-04-20 16:26:30", "10", "{\"post_id\":254}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166390;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166390;}", "5", "1", "2025-04-20 16:26:44", "2025-04-20 19:56:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("472", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:26:30", "2025-04-20 16:26:30", "10", "{\"post_id\":253}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166390;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166390;}", "5", "1", "2025-04-20 16:26:44", "2025-04-20 19:56:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("473", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:26:30", "2025-04-20 16:26:30", "10", "{\"post_id\":255}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166390;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166390;}", "5", "1", "2025-04-20 16:26:44", "2025-04-20 19:56:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("474", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:26:30", "2025-04-20 16:26:30", "10", "{\"post_id\":253}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166390;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166390;}", "5", "1", "2025-04-20 16:26:44", "2025-04-20 19:56:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("475", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:26:30", "2025-04-20 16:26:30", "10", "{\"post_id\":256}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166390;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166390;}", "5", "1", "2025-04-20 16:26:44", "2025-04-20 19:56:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("476", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:26:30", "2025-04-20 16:26:30", "10", "{\"post_id\":253}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166390;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166390;}", "5", "1", "2025-04-20 16:26:44", "2025-04-20 19:56:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("477", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:26:30", "2025-04-20 16:26:30", "10", "{\"post_id\":257}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166390;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166390;}", "5", "1", "2025-04-20 16:26:44", "2025-04-20 19:56:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("478", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:26:30", "2025-04-20 16:26:30", "10", "{\"post_id\":253}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166390;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166390;}", "5", "1", "2025-04-20 16:26:44", "2025-04-20 19:56:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("479", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:26:30", "2025-04-20 16:26:30", "10", "{\"post_id\":258}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166390;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166390;}", "5", "1", "2025-04-20 16:26:44", "2025-04-20 19:56:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("480", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:26:30", "2025-04-20 16:26:30", "10", "{\"post_id\":253}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166390;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166390;}", "5", "1", "2025-04-20 16:26:44", "2025-04-20 19:56:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("481", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:26:30", "2025-04-20 16:26:30", "10", "{\"post_id\":253}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166390;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166390;}", "5", "1", "2025-04-20 16:26:44", "2025-04-20 19:56:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("482", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:26:30", "2025-04-20 16:26:30", "10", "{\"post_id\":253}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166390;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166390;}", "5", "1", "2025-04-20 16:26:44", "2025-04-20 19:56:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("483", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:26:30", "2025-04-20 16:26:30", "10", "{\"post_id\":253}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166390;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166390;}", "5", "1", "2025-04-20 16:26:44", "2025-04-20 19:56:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("484", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:26:38", "2025-04-20 16:26:38", "10", "{\"post_id\":253}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166398;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166398;}", "5", "1", "2025-04-20 16:26:44", "2025-04-20 19:56:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("485", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 16:26:39", "2025-04-20 16:26:39", "10", "[253,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166399;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166399;}", "4", "1", "2025-04-20 16:26:44", "2025-04-20 19:56:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("486", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:26:38", "2025-04-20 16:26:38", "10", "{\"post_id\":253}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166398;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166398;}", "5", "1", "2025-04-20 16:26:44", "2025-04-20 19:56:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("487", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:27:26", "2025-04-20 16:27:26", "10", "{\"post_id\":260}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166446;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166446;}", "5", "1", "2025-04-20 16:27:55", "2025-04-20 19:57:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("488", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:27:26", "2025-04-20 16:27:26", "10", "{\"post_id\":259}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166446;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166446;}", "5", "1", "2025-04-20 16:27:55", "2025-04-20 19:57:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("489", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:27:26", "2025-04-20 16:27:26", "10", "{\"post_id\":261}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166446;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166446;}", "5", "1", "2025-04-20 16:27:55", "2025-04-20 19:57:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("490", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:27:26", "2025-04-20 16:27:26", "10", "{\"post_id\":259}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166446;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166446;}", "5", "1", "2025-04-20 16:27:55", "2025-04-20 19:57:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("491", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:27:26", "2025-04-20 16:27:26", "10", "{\"post_id\":262}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166446;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166446;}", "5", "1", "2025-04-20 16:27:55", "2025-04-20 19:57:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("492", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:27:26", "2025-04-20 16:27:26", "10", "{\"post_id\":259}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166446;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166446;}", "5", "1", "2025-04-20 16:27:55", "2025-04-20 19:57:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("493", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:27:26", "2025-04-20 16:27:26", "10", "{\"post_id\":263}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166446;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166446;}", "5", "1", "2025-04-20 16:27:55", "2025-04-20 19:57:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("494", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:27:26", "2025-04-20 16:27:26", "10", "{\"post_id\":259}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166446;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166446;}", "5", "1", "2025-04-20 16:27:55", "2025-04-20 19:57:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("495", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:27:26", "2025-04-20 16:27:26", "10", "{\"post_id\":264}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166446;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166446;}", "5", "1", "2025-04-20 16:27:55", "2025-04-20 19:57:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("496", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:27:26", "2025-04-20 16:27:26", "10", "{\"post_id\":259}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166446;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166446;}", "5", "1", "2025-04-20 16:27:55", "2025-04-20 19:57:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("497", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:27:27", "2025-04-20 16:27:27", "10", "{\"post_id\":259}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166447;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166447;}", "5", "1", "2025-04-20 16:27:55", "2025-04-20 19:57:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("498", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:27:27", "2025-04-20 16:27:27", "10", "{\"post_id\":259}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166447;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166447;}", "5", "1", "2025-04-20 16:27:55", "2025-04-20 19:57:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("499", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:27:27", "2025-04-20 16:27:27", "10", "{\"post_id\":259}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166447;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166447;}", "5", "1", "2025-04-20 16:27:55", "2025-04-20 19:57:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("500", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:27:53", "2025-04-20 16:27:53", "10", "{\"post_id\":260}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166473;}", "5", "1", "2025-04-20 16:27:55", "2025-04-20 19:57:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("501", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:27:53", "2025-04-20 16:27:53", "10", "{\"post_id\":259}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166473;}", "5", "1", "2025-04-20 16:27:55", "2025-04-20 19:57:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("502", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:27:53", "2025-04-20 16:27:53", "10", "{\"post_id\":261}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166473;}", "5", "1", "2025-04-20 16:27:55", "2025-04-20 19:57:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("503", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:27:53", "2025-04-20 16:27:53", "10", "{\"post_id\":259}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166473;}", "5", "1", "2025-04-20 16:27:55", "2025-04-20 19:57:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("504", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:27:53", "2025-04-20 16:27:53", "10", "{\"post_id\":262}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166473;}", "5", "1", "2025-04-20 16:27:55", "2025-04-20 19:57:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("505", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:27:53", "2025-04-20 16:27:53", "10", "{\"post_id\":259}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166473;}", "5", "1", "2025-04-20 16:27:55", "2025-04-20 19:57:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("506", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:27:53", "2025-04-20 16:27:53", "10", "{\"post_id\":263}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166473;}", "5", "1", "2025-04-20 16:27:55", "2025-04-20 19:57:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("507", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:27:53", "2025-04-20 16:27:53", "10", "{\"post_id\":259}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166473;}", "5", "1", "2025-04-20 16:27:55", "2025-04-20 19:57:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("508", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:27:53", "2025-04-20 16:27:53", "10", "{\"post_id\":264}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166473;}", "5", "1", "2025-04-20 16:27:55", "2025-04-20 19:57:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("509", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:27:53", "2025-04-20 16:27:53", "10", "{\"post_id\":259}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166473;}", "5", "1", "2025-04-20 16:27:55", "2025-04-20 19:57:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("510", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:27:53", "2025-04-20 16:27:53", "10", "{\"post_id\":259}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166473;}", "5", "1", "2025-04-20 16:27:55", "2025-04-20 19:57:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("511", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:27:53", "2025-04-20 16:27:53", "10", "{\"post_id\":259}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166473;}", "5", "1", "2025-04-20 16:27:55", "2025-04-20 19:57:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("512", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:27:53", "2025-04-20 16:27:53", "10", "{\"post_id\":259}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166473;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166473;}", "5", "1", "2025-04-20 16:27:55", "2025-04-20 19:57:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("513", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:28:53", "2025-04-20 16:28:53", "10", "{\"post_id\":259}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166533;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166533;}", "5", "1", "2025-04-20 16:28:56", "2025-04-20 19:58:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("514", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 16:28:54", "2025-04-20 16:28:54", "10", "[259,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166534;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166534;}", "4", "1", "2025-04-20 16:28:56", "2025-04-20 19:58:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("515", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:28:53", "2025-04-20 16:28:53", "10", "{\"post_id\":259}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166533;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166533;}", "5", "1", "2025-04-20 16:28:56", "2025-04-20 19:58:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("516", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:29:37", "2025-04-20 16:29:37", "10", "{\"post_id\":266}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166577;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166577;}", "5", "1", "2025-04-20 16:30:01", "2025-04-20 20:00:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("517", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:29:37", "2025-04-20 16:29:37", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166577;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166577;}", "5", "1", "2025-04-20 16:30:01", "2025-04-20 20:00:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("518", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:29:37", "2025-04-20 16:29:37", "10", "{\"post_id\":267}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166577;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166577;}", "5", "1", "2025-04-20 16:30:01", "2025-04-20 20:00:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("519", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:29:37", "2025-04-20 16:29:37", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166577;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166577;}", "5", "1", "2025-04-20 16:30:01", "2025-04-20 20:00:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("520", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:29:37", "2025-04-20 16:29:37", "10", "{\"post_id\":268}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166577;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166577;}", "5", "1", "2025-04-20 16:30:01", "2025-04-20 20:00:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("521", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:29:37", "2025-04-20 16:29:37", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166577;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166577;}", "5", "1", "2025-04-20 16:30:01", "2025-04-20 20:00:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("522", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:29:37", "2025-04-20 16:29:37", "10", "{\"post_id\":269}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166577;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166577;}", "5", "1", "2025-04-20 16:30:01", "2025-04-20 20:00:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("523", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:29:37", "2025-04-20 16:29:37", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166577;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166577;}", "5", "1", "2025-04-20 16:30:01", "2025-04-20 20:00:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("524", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:29:37", "2025-04-20 16:29:37", "10", "{\"post_id\":270}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166577;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166577;}", "5", "1", "2025-04-20 16:30:01", "2025-04-20 20:00:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("525", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:29:37", "2025-04-20 16:29:37", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166577;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166577;}", "5", "1", "2025-04-20 16:30:01", "2025-04-20 20:00:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("526", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:29:37", "2025-04-20 16:29:37", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166577;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166577;}", "5", "1", "2025-04-20 16:30:01", "2025-04-20 20:00:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("527", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:29:37", "2025-04-20 16:29:37", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166577;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166577;}", "5", "1", "2025-04-20 16:30:01", "2025-04-20 20:00:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("528", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:29:37", "2025-04-20 16:29:37", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166577;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166577;}", "5", "1", "2025-04-20 16:30:01", "2025-04-20 20:00:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("529", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:29:59", "2025-04-20 16:29:59", "10", "{\"post_id\":266}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166599;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166599;}", "5", "1", "2025-04-20 16:30:01", "2025-04-20 20:00:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("530", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:29:59", "2025-04-20 16:29:59", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166599;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166599;}", "5", "1", "2025-04-20 16:30:01", "2025-04-20 20:00:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("531", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:29:59", "2025-04-20 16:29:59", "10", "{\"post_id\":267}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166599;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166599;}", "5", "1", "2025-04-20 16:30:01", "2025-04-20 20:00:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("532", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:29:59", "2025-04-20 16:29:59", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166599;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166599;}", "5", "1", "2025-04-20 16:30:01", "2025-04-20 20:00:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("533", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:29:59", "2025-04-20 16:29:59", "10", "{\"post_id\":268}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166599;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166599;}", "5", "1", "2025-04-20 16:30:01", "2025-04-20 20:00:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("534", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:29:59", "2025-04-20 16:29:59", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166599;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166599;}", "5", "1", "2025-04-20 16:30:01", "2025-04-20 20:00:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("535", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:29:59", "2025-04-20 16:29:59", "10", "{\"post_id\":269}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166599;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166599;}", "5", "1", "2025-04-20 16:30:01", "2025-04-20 20:00:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("536", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:29:59", "2025-04-20 16:29:59", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166599;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166599;}", "5", "1", "2025-04-20 16:30:01", "2025-04-20 20:00:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("537", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:29:59", "2025-04-20 16:29:59", "10", "{\"post_id\":270}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166599;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166599;}", "5", "1", "2025-04-20 16:30:01", "2025-04-20 20:00:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("538", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:29:59", "2025-04-20 16:29:59", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166599;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166599;}", "5", "1", "2025-04-20 16:30:01", "2025-04-20 20:00:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("539", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:29:59", "2025-04-20 16:29:59", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166599;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166599;}", "5", "1", "2025-04-20 16:30:01", "2025-04-20 20:00:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("540", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:29:59", "2025-04-20 16:29:59", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166599;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166599;}", "5", "1", "2025-04-20 16:30:01", "2025-04-20 20:00:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("541", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:29:59", "2025-04-20 16:29:59", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166599;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166599;}", "5", "1", "2025-04-20 16:30:01", "2025-04-20 20:00:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("542", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:30:15", "2025-04-20 16:30:15", "10", "{\"post_id\":266}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166615;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166615;}", "5", "1", "2025-04-20 16:31:06", "2025-04-20 20:01:06", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("543", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:30:15", "2025-04-20 16:30:15", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166615;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166615;}", "5", "1", "2025-04-20 16:31:06", "2025-04-20 20:01:06", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("544", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:30:15", "2025-04-20 16:30:15", "10", "{\"post_id\":267}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166615;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166615;}", "5", "1", "2025-04-20 16:31:06", "2025-04-20 20:01:06", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("545", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:30:15", "2025-04-20 16:30:15", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166615;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166615;}", "5", "1", "2025-04-20 16:31:06", "2025-04-20 20:01:06", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("546", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:30:15", "2025-04-20 16:30:15", "10", "{\"post_id\":268}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166615;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166615;}", "5", "1", "2025-04-20 16:31:06", "2025-04-20 20:01:06", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("547", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:30:15", "2025-04-20 16:30:15", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166615;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166615;}", "5", "1", "2025-04-20 16:31:06", "2025-04-20 20:01:06", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("548", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:30:15", "2025-04-20 16:30:15", "10", "{\"post_id\":269}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166615;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166615;}", "5", "1", "2025-04-20 16:31:06", "2025-04-20 20:01:06", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("549", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:30:15", "2025-04-20 16:30:15", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166615;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166615;}", "5", "1", "2025-04-20 16:31:06", "2025-04-20 20:01:06", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("550", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:30:15", "2025-04-20 16:30:15", "10", "{\"post_id\":270}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166615;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166615;}", "5", "1", "2025-04-20 16:31:06", "2025-04-20 20:01:06", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("551", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:30:15", "2025-04-20 16:30:15", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166615;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166615;}", "5", "1", "2025-04-20 16:31:06", "2025-04-20 20:01:06", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("552", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:30:15", "2025-04-20 16:30:15", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166615;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166615;}", "5", "1", "2025-04-20 16:31:06", "2025-04-20 20:01:06", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("553", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:30:15", "2025-04-20 16:30:15", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166615;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166615;}", "5", "1", "2025-04-20 16:31:06", "2025-04-20 20:01:06", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("554", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:30:15", "2025-04-20 16:30:15", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166615;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166615;}", "5", "1", "2025-04-20 16:31:06", "2025-04-20 20:01:06", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("555", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:30:25", "2025-04-20 16:30:25", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166625;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166625;}", "5", "1", "2025-04-20 16:31:06", "2025-04-20 20:01:06", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("556", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 16:30:26", "2025-04-20 16:30:26", "10", "[265,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166626;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166626;}", "4", "1", "2025-04-20 16:31:06", "2025-04-20 20:01:06", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("557", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:30:25", "2025-04-20 16:30:25", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166625;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166625;}", "5", "1", "2025-04-20 16:31:06", "2025-04-20 20:01:06", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("558", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:31:45", "2025-04-20 16:31:45", "10", "{\"post_id\":276}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166705;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166705;}", "5", "1", "2025-04-20 16:32:17", "2025-04-20 20:02:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("559", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:31:45", "2025-04-20 16:31:45", "10", "{\"post_id\":271}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166705;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166705;}", "5", "1", "2025-04-20 16:32:17", "2025-04-20 20:02:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("560", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:31:45", "2025-04-20 16:31:45", "10", "{\"post_id\":272}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166705;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166705;}", "5", "1", "2025-04-20 16:32:17", "2025-04-20 20:02:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("561", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:31:45", "2025-04-20 16:31:45", "10", "{\"post_id\":271}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166705;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166705;}", "5", "1", "2025-04-20 16:32:17", "2025-04-20 20:02:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("562", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:31:45", "2025-04-20 16:31:45", "10", "{\"post_id\":273}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166705;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166705;}", "5", "1", "2025-04-20 16:32:17", "2025-04-20 20:02:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("563", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:31:45", "2025-04-20 16:31:45", "10", "{\"post_id\":271}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166705;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166705;}", "5", "1", "2025-04-20 16:32:17", "2025-04-20 20:02:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("564", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:31:45", "2025-04-20 16:31:45", "10", "{\"post_id\":274}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166705;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166705;}", "5", "1", "2025-04-20 16:32:17", "2025-04-20 20:02:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("565", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:31:45", "2025-04-20 16:31:45", "10", "{\"post_id\":271}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166705;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166705;}", "5", "1", "2025-04-20 16:32:17", "2025-04-20 20:02:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("566", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:31:45", "2025-04-20 16:31:45", "10", "{\"post_id\":275}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166705;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166705;}", "5", "1", "2025-04-20 16:32:17", "2025-04-20 20:02:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("567", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:31:45", "2025-04-20 16:31:45", "10", "{\"post_id\":271}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166705;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166705;}", "5", "1", "2025-04-20 16:32:17", "2025-04-20 20:02:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("568", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:31:45", "2025-04-20 16:31:45", "10", "{\"post_id\":271}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166705;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166705;}", "5", "1", "2025-04-20 16:32:17", "2025-04-20 20:02:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("569", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:31:45", "2025-04-20 16:31:45", "10", "{\"post_id\":271}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166705;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166705;}", "5", "1", "2025-04-20 16:32:17", "2025-04-20 20:02:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("570", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:31:45", "2025-04-20 16:31:45", "10", "{\"post_id\":271}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166705;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166705;}", "5", "1", "2025-04-20 16:32:17", "2025-04-20 20:02:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("571", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:32:34", "2025-04-20 16:32:34", "10", "{\"post_id\":276}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166754;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166754;}", "5", "1", "2025-04-20 16:33:22", "2025-04-20 20:03:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("572", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:32:34", "2025-04-20 16:32:34", "10", "{\"post_id\":271}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166754;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166754;}", "5", "1", "2025-04-20 16:33:22", "2025-04-20 20:03:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("573", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:32:34", "2025-04-20 16:32:34", "10", "{\"post_id\":272}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166754;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166754;}", "5", "1", "2025-04-20 16:33:22", "2025-04-20 20:03:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("574", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:32:34", "2025-04-20 16:32:34", "10", "{\"post_id\":271}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166754;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166754;}", "5", "1", "2025-04-20 16:33:22", "2025-04-20 20:03:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("575", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:32:34", "2025-04-20 16:32:34", "10", "{\"post_id\":273}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166754;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166754;}", "5", "1", "2025-04-20 16:33:22", "2025-04-20 20:03:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("576", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:32:34", "2025-04-20 16:32:34", "10", "{\"post_id\":271}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166754;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166754;}", "5", "1", "2025-04-20 16:33:22", "2025-04-20 20:03:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("577", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:32:34", "2025-04-20 16:32:34", "10", "{\"post_id\":274}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166754;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166754;}", "5", "1", "2025-04-20 16:33:22", "2025-04-20 20:03:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("578", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:32:34", "2025-04-20 16:32:34", "10", "{\"post_id\":271}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166754;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166754;}", "5", "1", "2025-04-20 16:33:22", "2025-04-20 20:03:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("579", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:32:35", "2025-04-20 16:32:35", "10", "{\"post_id\":275}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166755;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166755;}", "5", "1", "2025-04-20 16:33:22", "2025-04-20 20:03:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("580", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:32:35", "2025-04-20 16:32:35", "10", "{\"post_id\":271}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166755;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166755;}", "5", "1", "2025-04-20 16:33:22", "2025-04-20 20:03:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("581", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:32:35", "2025-04-20 16:32:35", "10", "{\"post_id\":271}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166755;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166755;}", "5", "1", "2025-04-20 16:33:22", "2025-04-20 20:03:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("582", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:32:35", "2025-04-20 16:32:35", "10", "{\"post_id\":271}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166755;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166755;}", "5", "1", "2025-04-20 16:33:22", "2025-04-20 20:03:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("583", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:32:35", "2025-04-20 16:32:35", "10", "{\"post_id\":271}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166755;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166755;}", "5", "1", "2025-04-20 16:33:22", "2025-04-20 20:03:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("584", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:32:39", "2025-04-20 16:32:39", "10", "{\"post_id\":271}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166759;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166759;}", "5", "1", "2025-04-20 16:33:22", "2025-04-20 20:03:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("585", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 16:32:40", "2025-04-20 16:32:40", "10", "[271,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166760;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166760;}", "4", "1", "2025-04-20 16:33:22", "2025-04-20 20:03:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("586", "wc_delete_related_product_transients_async", "complete", "2025-04-20 16:32:39", "2025-04-20 16:32:39", "10", "{\"post_id\":271}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745166759;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745166759;}", "5", "1", "2025-04-20 16:33:22", "2025-04-20 20:03:22", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("587", "fetch_patterns", "complete", "2025-04-20 17:24:31", "2025-04-20 17:24:31", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745169871;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745169871;}", "2", "1", "2025-04-20 17:24:32", "2025-04-20 20:54:32", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("588", "wc_delete_related_product_transients_async", "complete", "2025-04-20 17:50:27", "2025-04-20 17:50:27", "10", "{\"post_id\":229}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745171427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745171427;}", "5", "1", "2025-04-20 17:50:28", "2025-04-20 21:20:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("589", "wc_delete_related_product_transients_async", "complete", "2025-04-20 17:50:27", "2025-04-20 17:50:27", "10", "{\"post_id\":230}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745171427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745171427;}", "5", "1", "2025-04-20 17:50:28", "2025-04-20 21:20:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("590", "wc_delete_related_product_transients_async", "complete", "2025-04-20 17:50:27", "2025-04-20 17:50:27", "10", "{\"post_id\":229}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745171427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745171427;}", "5", "1", "2025-04-20 17:50:28", "2025-04-20 21:20:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("591", "wc_delete_related_product_transients_async", "complete", "2025-04-20 17:50:27", "2025-04-20 17:50:27", "10", "{\"post_id\":231}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745171427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745171427;}", "5", "1", "2025-04-20 17:50:28", "2025-04-20 21:20:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("592", "wc_delete_related_product_transients_async", "complete", "2025-04-20 17:50:27", "2025-04-20 17:50:27", "10", "{\"post_id\":229}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745171427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745171427;}", "5", "1", "2025-04-20 17:50:28", "2025-04-20 21:20:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("593", "wc_delete_related_product_transients_async", "complete", "2025-04-20 17:50:27", "2025-04-20 17:50:27", "10", "{\"post_id\":232}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745171427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745171427;}", "5", "1", "2025-04-20 17:50:28", "2025-04-20 21:20:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("594", "wc_delete_related_product_transients_async", "complete", "2025-04-20 17:50:27", "2025-04-20 17:50:27", "10", "{\"post_id\":229}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745171427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745171427;}", "5", "1", "2025-04-20 17:50:28", "2025-04-20 21:20:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("595", "wc_delete_related_product_transients_async", "complete", "2025-04-20 17:50:27", "2025-04-20 17:50:27", "10", "{\"post_id\":233}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745171427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745171427;}", "5", "1", "2025-04-20 17:50:28", "2025-04-20 21:20:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("596", "wc_delete_related_product_transients_async", "complete", "2025-04-20 17:50:27", "2025-04-20 17:50:27", "10", "{\"post_id\":229}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745171427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745171427;}", "5", "1", "2025-04-20 17:50:28", "2025-04-20 21:20:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("597", "wc_delete_related_product_transients_async", "complete", "2025-04-20 17:50:27", "2025-04-20 17:50:27", "10", "{\"post_id\":234}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745171427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745171427;}", "5", "1", "2025-04-20 17:50:28", "2025-04-20 21:20:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("598", "wc_delete_related_product_transients_async", "complete", "2025-04-20 17:50:27", "2025-04-20 17:50:27", "10", "{\"post_id\":229}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745171427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745171427;}", "5", "1", "2025-04-20 17:50:28", "2025-04-20 21:20:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("599", "wc_delete_related_product_transients_async", "complete", "2025-04-20 17:50:27", "2025-04-20 17:50:27", "10", "{\"post_id\":229}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745171427;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745171427;}", "5", "1", "2025-04-20 17:50:28", "2025-04-20 21:20:28", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("600", "wc_delete_related_product_transients_async", "complete", "2025-04-20 17:50:30", "2025-04-20 17:50:30", "10", "{\"post_id\":229}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745171430;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745171430;}", "5", "1", "2025-04-20 17:50:35", "2025-04-20 21:20:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("601", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 17:50:31", "2025-04-20 17:50:31", "10", "[230,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745171431;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745171431;}", "4", "1", "2025-04-20 17:50:35", "2025-04-20 21:20:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("602", "wc_delete_related_product_transients_async", "complete", "2025-04-20 17:50:30", "2025-04-20 17:50:30", "10", "{\"post_id\":229}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745171430;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745171430;}", "5", "1", "2025-04-20 17:50:35", "2025-04-20 21:20:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("603", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 17:50:31", "2025-04-20 17:50:31", "10", "[231,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745171431;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745171431;}", "4", "1", "2025-04-20 17:50:35", "2025-04-20 21:20:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("604", "wc_delete_related_product_transients_async", "complete", "2025-04-20 17:50:30", "2025-04-20 17:50:30", "10", "{\"post_id\":229}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745171430;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745171430;}", "5", "1", "2025-04-20 17:50:35", "2025-04-20 21:20:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("605", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 17:50:31", "2025-04-20 17:50:31", "10", "[232,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745171431;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745171431;}", "4", "1", "2025-04-20 17:50:35", "2025-04-20 21:20:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("606", "wc_delete_related_product_transients_async", "complete", "2025-04-20 17:50:30", "2025-04-20 17:50:30", "10", "{\"post_id\":229}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745171430;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745171430;}", "5", "1", "2025-04-20 17:50:35", "2025-04-20 21:20:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("607", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 17:50:31", "2025-04-20 17:50:31", "10", "[233,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745171431;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745171431;}", "4", "1", "2025-04-20 17:50:35", "2025-04-20 21:20:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("608", "wc_delete_related_product_transients_async", "complete", "2025-04-20 17:50:30", "2025-04-20 17:50:30", "10", "{\"post_id\":229}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745171430;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745171430;}", "5", "1", "2025-04-20 17:50:35", "2025-04-20 21:20:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("609", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 17:50:31", "2025-04-20 17:50:31", "10", "[234,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745171431;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745171431;}", "4", "1", "2025-04-20 17:50:35", "2025-04-20 21:20:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("610", "wc_delete_related_product_transients_async", "complete", "2025-04-20 17:50:30", "2025-04-20 17:50:30", "10", "{\"post_id\":229}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745171430;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745171430;}", "5", "1", "2025-04-20 17:50:35", "2025-04-20 21:20:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("611", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 17:50:31", "2025-04-20 17:50:31", "10", "[229,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745171431;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745171431;}", "4", "1", "2025-04-20 17:50:35", "2025-04-20 21:20:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("612", "wc_delete_related_product_transients_async", "complete", "2025-04-20 17:50:30", "2025-04-20 17:50:30", "10", "{\"post_id\":229}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745171430;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745171430;}", "5", "1", "2025-04-20 17:50:35", "2025-04-20 21:20:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("613", "wc_delete_related_product_transients_async", "complete", "2025-04-20 17:51:29", "2025-04-20 17:51:29", "10", "{\"post_id\":229}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745171489;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745171489;}", "5", "1", "2025-04-20 17:51:31", "2025-04-20 21:21:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("614", "wc_delete_related_product_transients_async", "complete", "2025-04-20 17:51:29", "2025-04-20 17:51:29", "10", "{\"post_id\":229}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745171489;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745171489;}", "5", "1", "2025-04-20 17:51:31", "2025-04-20 21:21:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("615", "fetch_patterns", "complete", "2025-04-20 18:36:01", "2025-04-20 18:36:01", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745174161;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745174161;}", "2", "1", "2025-04-20 18:36:03", "2025-04-20 22:06:03", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("616", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:30:55", "2025-04-20 19:30:55", "10", "{\"post_id\":235}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177455;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177455;}", "5", "1", "2025-04-20 19:31:26", "2025-04-20 23:01:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("617", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:30:56", "2025-04-20 19:30:56", "10", "[239,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177456;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177456;}", "4", "1", "2025-04-20 19:31:26", "2025-04-20 23:01:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("618", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:30:55", "2025-04-20 19:30:55", "10", "{\"post_id\":235}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177455;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177455;}", "5", "1", "2025-04-20 19:31:26", "2025-04-20 23:01:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("619", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:30:56", "2025-04-20 19:30:56", "10", "[240,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177456;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177456;}", "4", "1", "2025-04-20 19:31:26", "2025-04-20 23:01:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("620", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:30:55", "2025-04-20 19:30:55", "10", "{\"post_id\":235}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177455;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177455;}", "5", "1", "2025-04-20 19:31:26", "2025-04-20 23:01:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("621", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:30:56", "2025-04-20 19:30:56", "10", "[236,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177456;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177456;}", "4", "1", "2025-04-20 19:31:26", "2025-04-20 23:01:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("622", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:30:55", "2025-04-20 19:30:55", "10", "{\"post_id\":235}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177455;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177455;}", "5", "1", "2025-04-20 19:31:26", "2025-04-20 23:01:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("623", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:30:56", "2025-04-20 19:30:56", "10", "[237,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177456;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177456;}", "4", "1", "2025-04-20 19:31:26", "2025-04-20 23:01:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("624", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:30:55", "2025-04-20 19:30:55", "10", "{\"post_id\":235}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177455;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177455;}", "5", "1", "2025-04-20 19:31:26", "2025-04-20 23:01:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("625", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:30:56", "2025-04-20 19:30:56", "10", "[238,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177456;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177456;}", "4", "1", "2025-04-20 19:31:26", "2025-04-20 23:01:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("626", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:30:55", "2025-04-20 19:30:55", "10", "{\"post_id\":235}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177455;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177455;}", "5", "1", "2025-04-20 19:31:26", "2025-04-20 23:01:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("627", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:30:56", "2025-04-20 19:30:56", "10", "[235,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177456;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177456;}", "4", "1", "2025-04-20 19:31:26", "2025-04-20 23:01:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("628", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:30:55", "2025-04-20 19:30:55", "10", "{\"post_id\":235}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177455;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177455;}", "5", "1", "2025-04-20 19:31:26", "2025-04-20 23:01:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("629", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:32:40", "2025-04-20 19:32:40", "10", "{\"post_id\":241}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177560;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177560;}", "5", "1", "2025-04-20 19:34:02", "2025-04-20 23:04:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("630", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:32:41", "2025-04-20 19:32:41", "10", "[242,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177561;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177561;}", "4", "1", "2025-04-20 19:34:02", "2025-04-20 23:04:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("631", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:32:40", "2025-04-20 19:32:40", "10", "{\"post_id\":241}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177560;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177560;}", "5", "1", "2025-04-20 19:34:02", "2025-04-20 23:04:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("632", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:32:41", "2025-04-20 19:32:41", "10", "[243,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177561;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177561;}", "4", "1", "2025-04-20 19:34:02", "2025-04-20 23:04:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("633", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:32:40", "2025-04-20 19:32:40", "10", "{\"post_id\":241}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177560;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177560;}", "5", "1", "2025-04-20 19:34:02", "2025-04-20 23:04:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("634", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:32:41", "2025-04-20 19:32:41", "10", "[244,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177561;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177561;}", "4", "1", "2025-04-20 19:34:02", "2025-04-20 23:04:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("635", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:32:40", "2025-04-20 19:32:40", "10", "{\"post_id\":241}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177560;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177560;}", "5", "1", "2025-04-20 19:34:02", "2025-04-20 23:04:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("636", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:32:41", "2025-04-20 19:32:41", "10", "[245,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177561;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177561;}", "4", "1", "2025-04-20 19:34:02", "2025-04-20 23:04:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("637", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:32:40", "2025-04-20 19:32:40", "10", "{\"post_id\":241}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177560;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177560;}", "5", "1", "2025-04-20 19:34:02", "2025-04-20 23:04:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("638", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:32:41", "2025-04-20 19:32:41", "10", "[246,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177561;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177561;}", "4", "1", "2025-04-20 19:34:02", "2025-04-20 23:04:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("639", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:32:40", "2025-04-20 19:32:40", "10", "{\"post_id\":241}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177560;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177560;}", "5", "1", "2025-04-20 19:34:02", "2025-04-20 23:04:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("640", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:32:41", "2025-04-20 19:32:41", "10", "[241,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177561;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177561;}", "4", "1", "2025-04-20 19:34:02", "2025-04-20 23:04:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("641", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:32:40", "2025-04-20 19:32:40", "10", "{\"post_id\":241}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177560;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177560;}", "5", "1", "2025-04-20 19:34:02", "2025-04-20 23:04:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("642", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:34:01", "2025-04-20 19:34:01", "10", "{\"post_id\":247}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177641;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177641;}", "5", "1", "2025-04-20 19:34:02", "2025-04-20 23:04:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("643", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:34:02", "2025-04-20 19:34:02", "10", "[247,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177642;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177642;}", "4", "1", "2025-04-20 19:34:02", "2025-04-20 23:04:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("644", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:34:01", "2025-04-20 19:34:01", "10", "{\"post_id\":247}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177641;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177641;}", "5", "1", "2025-04-20 19:34:02", "2025-04-20 23:04:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("645", "fetch_patterns", "complete", "2025-04-20 19:36:07", "2025-04-20 19:36:07", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177767;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177767;}", "2", "1", "2025-04-20 19:37:09", "2025-04-20 23:07:09", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("646", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:39:10", "2025-04-20 19:39:10", "10", "{\"post_id\":271}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177950;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177950;}", "5", "1", "2025-04-20 19:39:12", "2025-04-20 23:09:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("647", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:39:11", "2025-04-20 19:39:11", "10", "[276,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177951;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177951;}", "4", "1", "2025-04-20 19:39:12", "2025-04-20 23:09:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("648", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:39:10", "2025-04-20 19:39:10", "10", "{\"post_id\":271}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177950;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177950;}", "5", "1", "2025-04-20 19:39:12", "2025-04-20 23:09:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("649", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:39:11", "2025-04-20 19:39:11", "10", "[272,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177951;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177951;}", "4", "1", "2025-04-20 19:39:12", "2025-04-20 23:09:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("650", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:39:10", "2025-04-20 19:39:10", "10", "{\"post_id\":271}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177950;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177950;}", "5", "1", "2025-04-20 19:39:12", "2025-04-20 23:09:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("651", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:39:11", "2025-04-20 19:39:11", "10", "[273,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177951;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177951;}", "4", "1", "2025-04-20 19:39:12", "2025-04-20 23:09:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("652", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:39:10", "2025-04-20 19:39:10", "10", "{\"post_id\":271}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177950;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177950;}", "5", "1", "2025-04-20 19:39:12", "2025-04-20 23:09:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("653", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:39:11", "2025-04-20 19:39:11", "10", "[274,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177951;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177951;}", "4", "1", "2025-04-20 19:39:12", "2025-04-20 23:09:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("654", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:39:10", "2025-04-20 19:39:10", "10", "{\"post_id\":271}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177950;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177950;}", "5", "1", "2025-04-20 19:39:12", "2025-04-20 23:09:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("655", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:39:11", "2025-04-20 19:39:11", "10", "[275,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177951;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177951;}", "4", "1", "2025-04-20 19:39:12", "2025-04-20 23:09:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("656", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:39:10", "2025-04-20 19:39:10", "10", "{\"post_id\":271}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177950;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177950;}", "5", "1", "2025-04-20 19:39:12", "2025-04-20 23:09:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("657", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:39:11", "2025-04-20 19:39:11", "10", "[271,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177951;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177951;}", "4", "1", "2025-04-20 19:39:12", "2025-04-20 23:09:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("658", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:39:10", "2025-04-20 19:39:10", "10", "{\"post_id\":271}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745177950;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745177950;}", "5", "1", "2025-04-20 19:39:12", "2025-04-20 23:09:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("659", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:46:52", "2025-04-20 19:46:52", "10", "{\"post_id\":259}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745178412;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745178412;}", "5", "1", "2025-04-20 19:46:53", "2025-04-20 23:16:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("660", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:46:53", "2025-04-20 19:46:53", "10", "[260,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745178413;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745178413;}", "4", "1", "2025-04-20 19:46:53", "2025-04-20 23:16:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("661", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:46:52", "2025-04-20 19:46:52", "10", "{\"post_id\":259}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745178412;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745178412;}", "5", "1", "2025-04-20 19:46:53", "2025-04-20 23:16:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("662", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:46:53", "2025-04-20 19:46:53", "10", "[261,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745178413;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745178413;}", "4", "1", "2025-04-20 19:46:53", "2025-04-20 23:16:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("663", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:46:52", "2025-04-20 19:46:52", "10", "{\"post_id\":259}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745178412;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745178412;}", "5", "1", "2025-04-20 19:46:53", "2025-04-20 23:16:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("664", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:46:53", "2025-04-20 19:46:53", "10", "[262,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745178413;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745178413;}", "4", "1", "2025-04-20 19:46:53", "2025-04-20 23:16:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("665", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:46:52", "2025-04-20 19:46:52", "10", "{\"post_id\":259}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745178412;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745178412;}", "5", "1", "2025-04-20 19:46:53", "2025-04-20 23:16:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("666", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:46:53", "2025-04-20 19:46:53", "10", "[263,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745178413;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745178413;}", "4", "1", "2025-04-20 19:46:53", "2025-04-20 23:16:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("667", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:46:52", "2025-04-20 19:46:52", "10", "{\"post_id\":259}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745178412;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745178412;}", "5", "1", "2025-04-20 19:46:53", "2025-04-20 23:16:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("668", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:46:53", "2025-04-20 19:46:53", "10", "[264,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745178413;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745178413;}", "4", "1", "2025-04-20 19:46:53", "2025-04-20 23:16:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("669", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:46:52", "2025-04-20 19:46:52", "10", "{\"post_id\":259}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745178412;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745178412;}", "5", "1", "2025-04-20 19:46:53", "2025-04-20 23:16:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("670", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:46:53", "2025-04-20 19:46:53", "10", "[259,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745178413;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745178413;}", "4", "1", "2025-04-20 19:46:53", "2025-04-20 23:16:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("671", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:46:52", "2025-04-20 19:46:52", "10", "{\"post_id\":259}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745178412;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745178412;}", "5", "1", "2025-04-20 19:46:53", "2025-04-20 23:16:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("672", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:48:52", "2025-04-20 19:48:52", "10", "{\"post_id\":253}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745178532;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745178532;}", "5", "1", "2025-04-20 19:50:04", "2025-04-20 23:20:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("673", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:48:53", "2025-04-20 19:48:53", "10", "[254,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745178533;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745178533;}", "4", "1", "2025-04-20 19:50:04", "2025-04-20 23:20:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("674", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:48:52", "2025-04-20 19:48:52", "10", "{\"post_id\":253}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745178532;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745178532;}", "5", "1", "2025-04-20 19:50:04", "2025-04-20 23:20:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("675", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:48:53", "2025-04-20 19:48:53", "10", "[255,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745178533;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745178533;}", "4", "1", "2025-04-20 19:50:04", "2025-04-20 23:20:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("676", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:48:52", "2025-04-20 19:48:52", "10", "{\"post_id\":253}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745178532;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745178532;}", "5", "1", "2025-04-20 19:50:04", "2025-04-20 23:20:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("677", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:48:53", "2025-04-20 19:48:53", "10", "[256,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745178533;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745178533;}", "4", "1", "2025-04-20 19:50:04", "2025-04-20 23:20:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("678", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:48:52", "2025-04-20 19:48:52", "10", "{\"post_id\":253}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745178532;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745178532;}", "5", "1", "2025-04-20 19:50:04", "2025-04-20 23:20:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("679", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:48:53", "2025-04-20 19:48:53", "10", "[257,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745178533;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745178533;}", "4", "1", "2025-04-20 19:50:04", "2025-04-20 23:20:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("680", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:48:52", "2025-04-20 19:48:52", "10", "{\"post_id\":253}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745178532;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745178532;}", "5", "1", "2025-04-20 19:50:04", "2025-04-20 23:20:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("681", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:48:53", "2025-04-20 19:48:53", "10", "[258,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745178533;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745178533;}", "4", "1", "2025-04-20 19:50:04", "2025-04-20 23:20:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("682", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:48:52", "2025-04-20 19:48:52", "10", "{\"post_id\":253}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745178532;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745178532;}", "5", "1", "2025-04-20 19:50:04", "2025-04-20 23:20:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("683", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:48:53", "2025-04-20 19:48:53", "10", "[253,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745178533;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745178533;}", "4", "1", "2025-04-20 19:50:04", "2025-04-20 23:20:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("684", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:48:52", "2025-04-20 19:48:52", "10", "{\"post_id\":253}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745178532;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745178532;}", "5", "1", "2025-04-20 19:50:04", "2025-04-20 23:20:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("685", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:52:28", "2025-04-20 19:52:28", "10", "{\"post_id\":253}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745178748;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745178748;}", "5", "1", "2025-04-20 19:53:26", "2025-04-20 23:23:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("686", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:52:29", "2025-04-20 19:52:29", "10", "[253,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745178749;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745178749;}", "4", "1", "2025-04-20 19:53:26", "2025-04-20 23:23:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("687", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:52:28", "2025-04-20 19:52:28", "10", "{\"post_id\":253}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745178748;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745178748;}", "5", "1", "2025-04-20 19:53:26", "2025-04-20 23:23:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("688", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:54:14", "2025-04-20 19:54:14", "10", "{\"post_id\":259}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745178854;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745178854;}", "5", "1", "2025-04-20 19:55:08", "2025-04-20 23:25:08", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("689", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:54:15", "2025-04-20 19:54:15", "10", "[259,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745178855;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745178855;}", "4", "1", "2025-04-20 19:55:08", "2025-04-20 23:25:08", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("690", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:54:14", "2025-04-20 19:54:14", "10", "{\"post_id\":259}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745178854;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745178854;}", "5", "1", "2025-04-20 19:55:08", "2025-04-20 23:25:08", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("691", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:57:36", "2025-04-20 19:57:36", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745179056;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745179056;}", "5", "1", "2025-04-20 19:57:56", "2025-04-20 23:27:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("692", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:57:37", "2025-04-20 19:57:37", "10", "[266,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745179057;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745179057;}", "4", "1", "2025-04-20 19:57:56", "2025-04-20 23:27:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("693", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:57:36", "2025-04-20 19:57:36", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745179056;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745179056;}", "5", "1", "2025-04-20 19:57:56", "2025-04-20 23:27:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("694", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:57:37", "2025-04-20 19:57:37", "10", "[267,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745179057;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745179057;}", "4", "1", "2025-04-20 19:57:56", "2025-04-20 23:27:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("695", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:57:36", "2025-04-20 19:57:36", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745179056;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745179056;}", "5", "1", "2025-04-20 19:57:56", "2025-04-20 23:27:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("696", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:57:37", "2025-04-20 19:57:37", "10", "[268,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745179057;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745179057;}", "4", "1", "2025-04-20 19:57:56", "2025-04-20 23:27:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("697", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:57:36", "2025-04-20 19:57:36", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745179056;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745179056;}", "5", "1", "2025-04-20 19:57:56", "2025-04-20 23:27:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("698", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:57:37", "2025-04-20 19:57:37", "10", "[269,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745179057;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745179057;}", "4", "1", "2025-04-20 19:57:56", "2025-04-20 23:27:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("699", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:57:36", "2025-04-20 19:57:36", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745179056;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745179056;}", "5", "1", "2025-04-20 19:57:56", "2025-04-20 23:27:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("700", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:57:37", "2025-04-20 19:57:37", "10", "[270,3]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745179057;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745179057;}", "4", "1", "2025-04-20 19:57:56", "2025-04-20 23:27:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("701", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:57:36", "2025-04-20 19:57:36", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745179056;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745179056;}", "5", "1", "2025-04-20 19:57:56", "2025-04-20 23:27:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("702", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-20 19:57:37", "2025-04-20 19:57:37", "10", "[265,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745179057;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745179057;}", "4", "1", "2025-04-20 19:57:56", "2025-04-20 23:27:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("703", "wc_delete_related_product_transients_async", "complete", "2025-04-20 19:57:36", "2025-04-20 19:57:36", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745179056;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745179056;}", "5", "1", "2025-04-20 19:57:56", "2025-04-20 23:27:56", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("704", "fetch_patterns", "complete", "2025-04-20 20:36:15", "2025-04-20 20:36:15", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745181375;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745181375;}", "2", "1", "2025-04-20 20:36:31", "2025-04-21 00:06:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("705", "fetch_patterns", "complete", "2025-04-20 21:37:11", "2025-04-20 21:37:11", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745185031;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745185031;}", "2", "1", "2025-04-20 21:37:13", "2025-04-21 01:07:13", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("706", "fetch_patterns", "complete", "2025-04-21 04:55:04", "2025-04-21 04:55:04", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745211304;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745211304;}", "2", "1", "2025-04-21 13:40:43", "2025-04-21 17:10:43", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("707", "fetch_patterns", "complete", "2025-04-21 13:40:44", "2025-04-21 13:40:44", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745242844;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745242844;}", "2", "1", "2025-04-21 13:40:50", "2025-04-21 17:10:50", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("708", "fetch_patterns", "complete", "2025-04-21 14:47:22", "2025-04-21 14:47:22", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745246842;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745246842;}", "2", "1", "2025-04-21 14:47:24", "2025-04-21 18:17:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("709", "fetch_patterns", "complete", "2025-04-21 15:48:53", "2025-04-21 15:48:53", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745250533;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745250533;}", "2", "1", "2025-04-21 15:48:55", "2025-04-21 19:18:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("710", "woocommerce_cleanup_draft_orders", "complete", "2025-04-22 15:48:55", "2025-04-22 15:48:55", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1745336935;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1745336935;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-04-22 15:49:03", "2025-04-22 19:19:03", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("711", "fetch_patterns", "complete", "2025-04-21 16:48:55", "2025-04-21 16:48:55", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745254135;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745254135;}", "2", "1", "2025-04-21 16:48:57", "2025-04-21 20:18:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("712", "fetch_patterns", "complete", "2025-04-21 17:49:06", "2025-04-21 17:49:06", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745257746;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745257746;}", "2", "1", "2025-04-21 17:49:08", "2025-04-21 21:19:08", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("713", "fetch_patterns", "complete", "2025-04-21 18:49:11", "2025-04-21 18:49:11", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745261351;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745261351;}", "2", "1", "2025-04-21 18:49:58", "2025-04-21 22:19:58", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("714", "fetch_patterns", "complete", "2025-04-21 19:49:22", "2025-04-21 19:49:22", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745264962;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745264962;}", "2", "1", "2025-04-21 19:49:23", "2025-04-21 23:19:23", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("715", "fetch_patterns", "complete", "2025-04-21 20:49:23", "2025-04-21 20:49:23", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745268563;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745268563;}", "2", "1", "2025-04-21 20:49:55", "2025-04-22 00:19:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("716", "fetch_patterns", "complete", "2025-04-22 05:33:45", "2025-04-22 05:33:45", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745300025;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745300025;}", "2", "1", "2025-04-22 05:34:09", "2025-04-22 09:04:09", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("717", "fetch_patterns", "complete", "2025-04-22 08:52:41", "2025-04-22 08:52:41", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745311961;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745311961;}", "2", "1", "2025-04-22 08:52:43", "2025-04-22 12:22:43", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("718", "fetch_patterns", "complete", "2025-04-22 13:39:25", "2025-04-22 13:39:25", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745329165;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745329165;}", "2", "1", "2025-04-22 13:39:27", "2025-04-22 17:09:27", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("719", "fetch_patterns", "complete", "2025-04-22 14:39:37", "2025-04-22 14:39:37", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745332777;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745332777;}", "2", "1", "2025-04-22 14:39:53", "2025-04-22 18:09:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("720", "fetch_patterns", "complete", "2025-04-22 15:45:52", "2025-04-22 15:45:52", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745336752;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745336752;}", "2", "1", "2025-04-22 15:45:54", "2025-04-22 19:15:54", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("721", "fetch_patterns", "complete", "2025-04-22 15:45:52", "2025-04-22 15:45:52", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745336752;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745336752;}", "2", "1", "2025-04-22 15:45:54", "2025-04-22 19:15:54", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("722", "woocommerce_cleanup_draft_orders", "complete", "2025-04-23 15:49:03", "2025-04-23 15:49:03", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1745423343;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1745423343;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-04-23 15:49:58", "2025-04-23 19:19:58", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("723", "fetch_patterns", "complete", "2025-04-22 16:47:43", "2025-04-22 16:47:43", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745340463;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745340463;}", "2", "1", "2025-04-22 16:47:44", "2025-04-22 20:17:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("724", "fetch_patterns", "complete", "2025-04-22 17:47:55", "2025-04-22 17:47:55", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745344075;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745344075;}", "2", "1", "2025-04-22 17:48:41", "2025-04-22 21:18:41", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("725", "fetch_patterns", "complete", "2025-04-22 18:48:45", "2025-04-22 18:48:45", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745347725;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745347725;}", "2", "1", "2025-04-22 18:48:47", "2025-04-22 22:18:47", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("726", "fetch_patterns", "complete", "2025-04-22 19:48:47", "2025-04-22 19:48:47", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745351327;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745351327;}", "2", "1", "2025-04-22 19:49:04", "2025-04-22 23:19:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("727", "fetch_patterns", "complete", "2025-04-23 09:00:15", "2025-04-23 09:00:15", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745398815;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745398815;}", "2", "1", "2025-04-23 09:00:25", "2025-04-23 12:30:25", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("728", "fetch_patterns", "complete", "2025-04-23 10:19:41", "2025-04-23 10:19:41", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745403581;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745403581;}", "2", "1", "2025-04-23 10:23:32", "2025-04-23 13:53:32", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("729", "fetch_patterns", "complete", "2025-04-23 11:19:57", "2025-04-23 11:19:57", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745407197;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745407197;}", "2", "1", "2025-04-23 11:20:32", "2025-04-23 14:50:32", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("730", "fetch_patterns", "complete", "2025-04-23 13:04:01", "2025-04-23 13:04:01", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745413441;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745413441;}", "2", "1", "2025-04-23 13:48:02", "2025-04-23 17:18:02", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("731", "fetch_patterns", "complete", "2025-04-23 14:31:39", "2025-04-23 14:31:39", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745418699;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745418699;}", "2", "1", "2025-04-23 14:33:53", "2025-04-23 18:03:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("732", "fetch_patterns", "complete", "2025-04-23 15:31:47", "2025-04-23 15:31:47", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745422307;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745422307;}", "2", "1", "2025-04-23 15:32:37", "2025-04-23 19:02:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("733", "woocommerce_cleanup_draft_orders", "complete", "2025-04-24 15:49:58", "2025-04-24 15:49:58", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1745509798;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1745509798;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-04-26 06:31:40", "2025-04-26 10:01:40", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("734", "fetch_patterns", "complete", "2025-04-23 16:32:01", "2025-04-23 16:32:01", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745425921;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745425921;}", "2", "1", "2025-04-23 16:33:03", "2025-04-23 20:03:03", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("735", "wc_delete_related_product_transients_async", "complete", "2025-04-23 17:16:28", "2025-04-23 17:16:28", "10", "{\"post_id\":271}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745428588;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745428588;}", "5", "1", "2025-04-23 17:16:30", "2025-04-23 20:46:30", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("736", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-23 17:16:29", "2025-04-23 17:16:29", "10", "[271,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745428589;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745428589;}", "4", "1", "2025-04-23 17:16:30", "2025-04-23 20:46:30", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("737", "wc_delete_related_product_transients_async", "complete", "2025-04-23 17:16:28", "2025-04-23 17:16:28", "10", "{\"post_id\":271}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745428588;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745428588;}", "5", "1", "2025-04-23 17:16:30", "2025-04-23 20:46:30", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("738", "wc_delete_related_product_transients_async", "complete", "2025-04-23 17:22:09", "2025-04-23 17:22:09", "10", "{\"post_id\":271}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745428929;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745428929;}", "5", "1", "2025-04-23 17:22:10", "2025-04-23 20:52:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("739", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-23 17:22:10", "2025-04-23 17:22:10", "10", "[271,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745428930;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745428930;}", "4", "1", "2025-04-23 17:22:10", "2025-04-23 20:52:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("740", "wc_delete_related_product_transients_async", "complete", "2025-04-23 17:22:09", "2025-04-23 17:22:09", "10", "{\"post_id\":271}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745428929;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745428929;}", "5", "1", "2025-04-23 17:22:10", "2025-04-23 20:52:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("741", "wc_delete_related_product_transients_async", "complete", "2025-04-23 17:28:33", "2025-04-23 17:28:33", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745429313;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745429313;}", "5", "1", "2025-04-23 17:29:08", "2025-04-23 20:59:08", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("742", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-23 17:28:34", "2025-04-23 17:28:34", "10", "[265,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745429314;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745429314;}", "4", "1", "2025-04-23 17:29:08", "2025-04-23 20:59:08", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("743", "wc_delete_related_product_transients_async", "complete", "2025-04-23 17:28:33", "2025-04-23 17:28:33", "10", "{\"post_id\":265}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745429313;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745429313;}", "5", "1", "2025-04-23 17:29:08", "2025-04-23 20:59:08", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("744", "fetch_patterns", "complete", "2025-04-23 17:38:07", "2025-04-23 17:38:07", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745429887;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745429887;}", "2", "1", "2025-04-23 17:38:09", "2025-04-23 21:08:09", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("745", "fetch_patterns", "complete", "2025-04-25 12:27:38", "2025-04-25 12:27:38", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745584058;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745584058;}", "2", "1", "2025-04-26 06:31:40", "2025-04-26 10:01:40", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("746", "woocommerce_cleanup_draft_orders", "complete", "2025-04-27 06:31:40", "2025-04-27 06:31:40", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1745735500;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1745735500;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-04-27 19:57:33", "2025-04-27 23:27:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("747", "fetch_patterns", "complete", "2025-04-26 06:31:49", "2025-04-26 06:31:49", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745649109;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745649109;}", "2", "1", "2025-04-26 06:32:43", "2025-04-26 10:02:43", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("748", "fetch_patterns", "complete", "2025-04-26 16:46:40", "2025-04-26 16:46:40", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745686000;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745686000;}", "2", "1", "2025-04-26 17:12:51", "2025-04-26 20:42:51", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("749", "wc_delete_related_product_transients_async", "complete", "2025-04-26 17:17:03", "2025-04-26 17:17:03", "10", "{\"post_id\":259}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745687823;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745687823;}", "5", "1", "2025-04-26 17:18:10", "2025-04-26 20:48:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("750", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-26 17:17:04", "2025-04-26 17:17:04", "10", "[259,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745687824;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745687824;}", "4", "1", "2025-04-26 17:18:10", "2025-04-26 20:48:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("751", "wc_delete_related_product_transients_async", "complete", "2025-04-26 17:17:03", "2025-04-26 17:17:03", "10", "{\"post_id\":259}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745687823;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745687823;}", "5", "1", "2025-04-26 17:18:10", "2025-04-26 20:48:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("752", "wc_delete_related_product_transients_async", "complete", "2025-04-26 17:22:04", "2025-04-26 17:22:04", "10", "{\"post_id\":253}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745688124;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745688124;}", "5", "1", "2025-04-26 17:22:32", "2025-04-26 20:52:32", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("753", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-26 17:22:05", "2025-04-26 17:22:05", "10", "[253,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745688125;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745688125;}", "4", "1", "2025-04-26 17:22:32", "2025-04-26 20:52:32", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("754", "wc_delete_related_product_transients_async", "complete", "2025-04-26 17:22:04", "2025-04-26 17:22:04", "10", "{\"post_id\":253}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745688124;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745688124;}", "5", "1", "2025-04-26 17:22:32", "2025-04-26 20:52:32", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("755", "wc_delete_related_product_transients_async", "complete", "2025-04-26 17:31:38", "2025-04-26 17:31:38", "10", "{\"post_id\":247}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745688698;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745688698;}", "5", "1", "2025-04-26 17:31:46", "2025-04-26 21:01:46", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("756", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-26 17:31:39", "2025-04-26 17:31:39", "10", "[247,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745688699;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745688699;}", "4", "1", "2025-04-26 17:31:46", "2025-04-26 21:01:46", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("757", "wc_delete_related_product_transients_async", "complete", "2025-04-26 17:31:38", "2025-04-26 17:31:38", "10", "{\"post_id\":247}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745688698;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745688698;}", "5", "1", "2025-04-26 17:31:46", "2025-04-26 21:01:46", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("758", "wc_delete_related_product_transients_async", "complete", "2025-04-26 17:42:55", "2025-04-26 17:42:55", "10", "{\"post_id\":241}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745689375;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745689375;}", "5", "1", "2025-04-26 17:43:34", "2025-04-26 21:13:34", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("759", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2025-04-26 17:42:56", "2025-04-26 17:42:56", "10", "[241,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745689376;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745689376;}", "4", "1", "2025-04-26 17:43:34", "2025-04-26 21:13:34", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("760", "wc_delete_related_product_transients_async", "complete", "2025-04-26 17:42:55", "2025-04-26 17:42:55", "10", "{\"post_id\":241}", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745689375;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745689375;}", "5", "1", "2025-04-26 17:43:34", "2025-04-26 21:13:34", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("761", "fetch_patterns", "complete", "2025-04-26 17:46:46", "2025-04-26 17:46:46", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745689606;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745689606;}", "2", "1", "2025-04-26 17:46:49", "2025-04-26 21:16:49", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("762", "fetch_patterns", "complete", "2025-04-26 18:46:48", "2025-04-26 18:46:48", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745693208;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745693208;}", "2", "1", "2025-04-26 18:46:50", "2025-04-26 22:16:50", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("763", "fetch_patterns", "complete", "2025-04-26 19:47:33", "2025-04-26 19:47:33", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745696853;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745696853;}", "2", "1", "2025-04-26 19:47:34", "2025-04-26 23:17:34", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("764", "fetch_patterns", "complete", "2025-04-26 20:47:55", "2025-04-26 20:47:55", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745700475;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745700475;}", "2", "1", "2025-04-26 20:47:57", "2025-04-27 00:17:57", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("765", "fetch_patterns", "complete", "2025-04-26 21:48:09", "2025-04-26 21:48:09", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745704089;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745704089;}", "2", "1", "2025-04-26 21:48:13", "2025-04-27 01:18:13", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("766", "fetch_patterns", "complete", "2025-04-27 19:56:54", "2025-04-27 19:56:54", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745783814;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745783814;}", "2", "1", "2025-04-27 19:57:33", "2025-04-27 23:27:33", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("767", "woocommerce_cleanup_draft_orders", "complete", "2025-04-28 19:57:33", "2025-04-28 19:57:33", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1745870253;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1745870253;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-04-29 07:22:15", "2025-04-29 10:52:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("768", "fetch_patterns", "complete", "2025-04-27 20:57:11", "2025-04-27 20:57:11", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745787431;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745787431;}", "2", "1", "2025-04-28 04:19:26", "2025-04-28 07:49:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("769", "fetch_patterns", "complete", "2025-04-28 04:19:37", "2025-04-28 04:19:37", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745813977;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745813977;}", "2", "1", "2025-04-28 14:55:31", "2025-04-28 18:25:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("770", "fetch_patterns", "complete", "2025-04-28 14:55:42", "2025-04-28 14:55:42", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745852142;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745852142;}", "2", "1", "2025-04-29 07:22:15", "2025-04-29 10:52:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("772", "fetch_patterns", "complete", "2025-04-29 07:39:42", "2025-04-29 07:39:42", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745912382;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745912382;}", "2", "1", "2025-04-29 08:16:18", "2025-04-29 11:46:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("771", "woocommerce_cleanup_draft_orders", "complete", "2025-04-30 07:22:15", "2025-04-30 07:22:15", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1745997735;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1745997735;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-04-30 08:04:53", "2025-04-30 11:34:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("773", "fetch_patterns", "complete", "2025-04-29 08:59:15", "2025-04-29 08:59:15", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745917155;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745917155;}", "2", "1", "2025-04-29 10:12:10", "2025-04-29 13:42:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("774", "fetch_patterns", "complete", "2025-04-29 10:13:45", "2025-04-29 10:13:45", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745921625;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745921625;}", "2", "1", "2025-04-29 11:39:16", "2025-04-29 15:09:16", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("775", "fetch_patterns", "complete", "2025-04-29 12:30:01", "2025-04-29 12:30:01", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745929801;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745929801;}", "2", "1", "2025-04-29 19:59:53", "2025-04-29 23:29:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("776", "fetch_patterns", "complete", "2025-04-29 20:47:14", "2025-04-29 20:47:14", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1745959634;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1745959634;}", "2", "1", "2025-04-30 08:04:53", "2025-04-30 11:34:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("778", "fetch_patterns", "complete", "2025-04-30 08:36:22", "2025-04-30 08:36:22", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746002182;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746002182;}", "2", "1", "2025-04-30 13:59:09", "2025-04-30 17:29:09", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("777", "woocommerce_cleanup_draft_orders", "complete", "2025-05-01 08:04:53", "2025-05-01 08:04:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746086693;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746086693;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-05-02 15:19:53", "2025-05-02 18:49:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("779", "fetch_patterns", "complete", "2025-04-30 13:59:11", "2025-04-30 13:59:11", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746021551;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746021551;}", "2", "1", "2025-04-30 13:59:15", "2025-04-30 17:29:15", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("780", "fetch_patterns", "complete", "2025-04-30 15:09:59", "2025-04-30 15:09:59", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746025799;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746025799;}", "2", "1", "2025-04-30 15:33:04", "2025-04-30 19:03:04", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("781", "fetch_patterns", "complete", "2025-04-30 16:16:37", "2025-04-30 16:16:37", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746029797;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746029797;}", "2", "1", "2025-04-30 20:01:20", "2025-04-30 23:31:20", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("782", "fetch_patterns", "complete", "2025-04-30 20:01:23", "2025-04-30 20:01:23", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746043283;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746043283;}", "2", "1", "2025-04-30 20:01:27", "2025-04-30 23:31:27", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("783", "fetch_patterns", "complete", "2025-04-30 21:43:10", "2025-04-30 21:43:10", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746049390;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746049390;}", "2", "1", "2025-05-02 15:19:53", "2025-05-02 18:49:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("785", "fetch_patterns", "complete", "2025-05-02 15:25:36", "2025-05-02 15:25:36", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746199536;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746199536;}", "2", "1", "2025-05-03 06:25:10", "2025-05-03 09:55:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("784", "woocommerce_cleanup_draft_orders", "complete", "2025-05-03 15:19:53", "2025-05-03 15:19:53", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746285593;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746285593;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-05-03 19:14:05", "2025-05-03 22:44:05", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("786", "fetch_patterns", "complete", "2025-05-03 06:25:14", "2025-05-03 06:25:14", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746253514;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746253514;}", "2", "1", "2025-05-03 06:25:17", "2025-05-03 09:55:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("787", "fetch_patterns", "complete", "2025-05-03 07:25:55", "2025-05-03 07:25:55", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746257155;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746257155;}", "2", "1", "2025-05-03 08:20:44", "2025-05-03 11:50:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("788", "fetch_patterns", "complete", "2025-05-03 08:44:34", "2025-05-03 08:44:34", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746261874;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746261874;}", "2", "1", "2025-05-03 10:04:43", "2025-05-03 13:34:43", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("789", "fetch_patterns", "complete", "2025-05-03 10:04:49", "2025-05-03 10:04:49", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746266689;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746266689;}", "2", "1", "2025-05-03 10:05:50", "2025-05-03 13:35:50", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("790", "fetch_patterns", "complete", "2025-05-03 11:13:01", "2025-05-03 11:13:01", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746270781;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746270781;}", "2", "1", "2025-05-03 12:08:03", "2025-05-03 15:38:03", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("791", "fetch_patterns", "complete", "2025-05-03 12:18:01", "2025-05-03 12:18:01", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746274681;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746274681;}", "2", "1", "2025-05-03 12:18:41", "2025-05-03 15:48:41", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("792", "fetch_patterns", "complete", "2025-05-03 13:20:56", "2025-05-03 13:20:56", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746278456;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746278456;}", "2", "1", "2025-05-03 19:14:05", "2025-05-03 22:44:05", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("794", "fetch_patterns", "complete", "2025-05-03 19:14:19", "2025-05-03 19:14:19", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746299659;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746299659;}", "2", "1", "2025-05-04 10:45:37", "2025-05-04 14:15:37", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("793", "woocommerce_cleanup_draft_orders", "complete", "2025-05-04 19:14:05", "2025-05-04 19:14:05", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746386045;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746386045;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-05-04 20:19:41", "2025-05-04 23:49:41", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("795", "fetch_patterns", "complete", "2025-05-04 10:45:37", "2025-05-04 10:45:37", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746355537;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746355537;}", "2", "1", "2025-05-04 10:45:43", "2025-05-04 14:15:43", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("796", "fetch_patterns", "complete", "2025-05-04 11:51:58", "2025-05-04 11:51:58", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746359518;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746359518;}", "2", "1", "2025-05-04 12:50:59", "2025-05-04 16:20:59", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("797", "fetch_patterns", "complete", "2025-05-04 13:03:21", "2025-05-04 13:03:21", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746363801;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746363801;}", "2", "1", "2025-05-04 13:03:24", "2025-05-04 16:33:24", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("798", "fetch_patterns", "complete", "2025-05-04 14:35:02", "2025-05-04 14:35:02", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746369302;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746369302;}", "2", "1", "2025-05-04 17:58:09", "2025-05-04 21:28:09", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("799", "fetch_patterns", "complete", "2025-05-04 17:58:12", "2025-05-04 17:58:12", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746381492;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746381492;}", "2", "1", "2025-05-04 17:58:16", "2025-05-04 21:28:16", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("800", "fetch_patterns", "complete", "2025-05-04 18:58:47", "2025-05-04 18:58:47", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746385127;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746385127;}", "2", "1", "2025-05-04 18:59:55", "2025-05-04 22:29:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("801", "fetch_patterns", "complete", "2025-05-04 20:19:39", "2025-05-04 20:19:39", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746389979;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746389979;}", "2", "1", "2025-05-04 20:19:41", "2025-05-04 23:49:41", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("802", "woocommerce_cleanup_draft_orders", "complete", "2025-05-05 20:19:41", "2025-05-05 20:19:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746476381;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746476381;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-05-06 02:10:25", "2025-05-06 05:40:25", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("803", "fetch_patterns", "complete", "2025-05-04 21:21:48", "2025-05-04 21:21:48", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746393708;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746393708;}", "2", "1", "2025-05-06 02:10:25", "2025-05-06 05:40:25", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("805", "fetch_patterns", "complete", "2025-05-06 02:11:29", "2025-05-06 02:11:29", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746497489;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746497489;}", "2", "1", "2025-05-06 18:49:47", "2025-05-06 22:19:47", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("804", "woocommerce_cleanup_draft_orders", "complete", "2025-05-07 02:10:25", "2025-05-07 02:10:25", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746583825;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746583825;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-05-07 11:24:12", "2025-05-07 14:54:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("806", "fetch_patterns", "complete", "2025-05-06 18:50:02", "2025-05-06 18:50:02", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746557402;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746557402;}", "2", "1", "2025-05-07 11:24:12", "2025-05-07 14:54:12", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("808", "fetch_patterns", "complete", "2025-05-07 11:24:14", "2025-05-07 11:24:14", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746617054;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746617054;}", "2", "1", "2025-05-07 11:24:18", "2025-05-07 14:54:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("807", "woocommerce_cleanup_draft_orders", "complete", "2025-05-08 11:24:12", "2025-05-08 11:24:12", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746703452;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746703452;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-05-09 11:16:21", "2025-05-09 14:46:21", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("809", "fetch_patterns", "complete", "2025-05-07 12:53:50", "2025-05-07 12:53:50", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746622430;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746622430;}", "2", "1", "2025-05-07 15:59:31", "2025-05-07 19:29:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("810", "fetch_patterns", "complete", "2025-05-07 15:59:34", "2025-05-07 15:59:34", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746633574;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746633574;}", "2", "1", "2025-05-07 15:59:38", "2025-05-07 19:29:38", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("811", "fetch_patterns", "complete", "2025-05-07 17:18:25", "2025-05-07 17:18:25", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746638305;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746638305;}", "2", "1", "2025-05-07 19:13:45", "2025-05-07 22:43:45", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("812", "fetch_patterns", "complete", "2025-05-07 19:13:46", "2025-05-07 19:13:46", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746645226;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746645226;}", "2", "1", "2025-05-07 19:13:52", "2025-05-07 22:43:52", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("813", "woocommerce_run_on_woocommerce_admin_updated", "complete", "2025-05-07 19:17:18", "2025-05-07 19:17:18", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746645438;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746645438;}", "3", "1", "2025-05-07 19:17:21", "2025-05-07 22:47:21", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("814", "woocommerce_run_on_woocommerce_admin_updated", "complete", "2025-05-07 19:17:18", "2025-05-07 19:17:18", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746645438;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746645438;}", "3", "1", "2025-05-07 19:17:21", "2025-05-07 22:47:21", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("815", "fetch_patterns", "complete", "2025-05-07 20:48:38", "2025-05-07 20:48:38", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746650918;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746650918;}", "2", "1", "2025-05-08 09:10:19", "2025-05-08 12:40:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("816", "fetch_patterns", "complete", "2025-05-08 09:10:22", "2025-05-08 09:10:22", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746695422;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746695422;}", "2", "1", "2025-05-08 09:10:26", "2025-05-08 12:40:26", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("817", "fetch_patterns", "complete", "2025-05-08 10:24:49", "2025-05-08 10:24:49", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746699889;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746699889;}", "2", "1", "2025-05-09 11:16:21", "2025-05-09 14:46:21", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("819", "fetch_patterns", "complete", "2025-05-09 11:52:08", "2025-05-09 11:52:08", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746791528;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746791528;}", "2", "1", "2025-05-09 17:26:05", "2025-05-09 20:56:05", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("818", "woocommerce_cleanup_draft_orders", "complete", "2025-05-10 11:16:21", "2025-05-10 11:16:21", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746875781;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746875781;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-05-10 19:14:44", "2025-05-10 22:44:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("820", "fetch_patterns", "complete", "2025-05-09 17:26:22", "2025-05-09 17:26:22", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746811582;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746811582;}", "2", "1", "2025-05-09 18:01:27", "2025-05-09 21:31:27", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("821", "fetch_patterns", "complete", "2025-05-09 18:29:02", "2025-05-09 18:29:02", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746815342;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746815342;}", "2", "1", "2025-05-09 21:06:49", "2025-05-10 00:36:49", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("822", "fetch_patterns", "complete", "2025-05-09 21:07:03", "2025-05-09 21:07:03", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746824823;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746824823;}", "2", "1", "2025-05-10 02:21:34", "2025-05-10 05:51:34", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("823", "fetch_patterns", "complete", "2025-05-10 02:21:36", "2025-05-10 02:21:36", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746843696;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746843696;}", "2", "1", "2025-05-10 02:21:41", "2025-05-10 05:51:41", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("824", "fetch_patterns", "complete", "2025-05-10 04:16:32", "2025-05-10 04:16:32", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746850592;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746850592;}", "2", "1", "2025-05-10 06:18:14", "2025-05-10 09:48:14", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("825", "fetch_patterns", "complete", "2025-05-10 06:30:05", "2025-05-10 06:30:05", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746858605;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746858605;}", "2", "1", "2025-05-10 19:14:44", "2025-05-10 22:44:44", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("827", "fetch_patterns", "complete", "2025-05-10 19:14:45", "2025-05-10 19:14:45", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746904485;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746904485;}", "2", "1", "2025-05-10 19:14:50", "2025-05-10 22:44:50", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("826", "woocommerce_cleanup_draft_orders", "complete", "2025-05-11 19:14:44", "2025-05-11 19:14:44", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1746990884;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1746990884;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-05-12 04:50:41", "2025-05-12 08:20:41", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("828", "fetch_patterns", "complete", "2025-05-10 20:43:36", "2025-05-10 20:43:36", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746909816;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746909816;}", "2", "1", "2025-05-10 20:47:38", "2025-05-11 00:17:38", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("829", "fetch_patterns", "complete", "2025-05-10 22:04:17", "2025-05-10 22:04:17", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746914657;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746914657;}", "2", "1", "2025-05-10 22:04:19", "2025-05-11 01:34:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("830", "fetch_patterns", "complete", "2025-05-11 04:11:18", "2025-05-11 04:11:18", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746936678;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746936678;}", "2", "1", "2025-05-11 07:17:29", "2025-05-11 10:47:29", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("831", "fetch_patterns", "complete", "2025-05-11 07:17:30", "2025-05-11 07:17:30", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746947850;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746947850;}", "2", "1", "2025-05-11 07:17:35", "2025-05-11 10:47:35", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("832", "fetch_patterns", "complete", "2025-05-11 08:19:44", "2025-05-11 08:19:44", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746951584;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746951584;}", "2", "1", "2025-05-11 09:48:46", "2025-05-11 13:18:46", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("833", "fetch_patterns", "complete", "2025-05-11 09:48:47", "2025-05-11 09:48:47", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746956927;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746956927;}", "2", "1", "2025-05-11 09:48:53", "2025-05-11 13:18:53", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("834", "fetch_patterns", "complete", "2025-05-11 11:17:36", "2025-05-11 11:17:36", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746962256;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746962256;}", "2", "1", "2025-05-11 12:20:31", "2025-05-11 15:50:31", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("835", "fetch_patterns", "complete", "2025-05-11 12:20:32", "2025-05-11 12:20:32", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746966032;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746966032;}", "2", "1", "2025-05-11 12:20:38", "2025-05-11 15:50:38", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("836", "fetch_patterns", "complete", "2025-05-11 13:23:36", "2025-05-11 13:23:36", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746969816;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746969816;}", "2", "1", "2025-05-11 13:24:55", "2025-05-11 16:54:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("837", "fetch_patterns", "complete", "2025-05-11 14:24:03", "2025-05-11 14:24:03", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746973443;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746973443;}", "2", "1", "2025-05-11 15:23:55", "2025-05-11 18:53:55", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("838", "fetch_patterns", "complete", "2025-05-11 15:24:06", "2025-05-11 15:24:06", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746977046;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746977046;}", "2", "1", "2025-05-11 18:49:07", "2025-05-11 22:19:07", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("839", "fetch_patterns", "complete", "2025-05-11 18:49:09", "2025-05-11 18:49:09", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746989349;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746989349;}", "2", "1", "2025-05-11 18:49:13", "2025-05-11 22:19:13", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("840", "fetch_patterns", "complete", "2025-05-11 20:13:32", "2025-05-11 20:13:32", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1746994412;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1746994412;}", "2", "1", "2025-05-12 04:50:41", "2025-05-12 08:20:41", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("841", "woocommerce_cleanup_draft_orders", "complete", "2025-05-13 04:50:41", "2025-05-13 04:50:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747111841;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747111841;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-05-13 04:57:19", "2025-05-13 08:27:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("842", "fetch_patterns", "complete", "2025-05-12 04:51:39", "2025-05-12 04:51:39", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747025499;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747025499;}", "2", "1", "2025-05-12 04:52:40", "2025-05-12 08:22:40", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("843", "fetch_patterns", "complete", "2025-05-12 06:55:26", "2025-05-12 06:55:26", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747032926;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747032926;}", "2", "1", "2025-05-12 08:26:18", "2025-05-12 11:56:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("844", "fetch_patterns", "complete", "2025-05-12 08:26:23", "2025-05-12 08:26:23", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747038383;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747038383;}", "2", "1", "2025-05-12 08:26:25", "2025-05-12 11:56:25", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("845", "fetch_patterns", "complete", "2025-05-12 09:36:19", "2025-05-12 09:36:19", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747042579;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747042579;}", "2", "1", "2025-05-12 11:26:10", "2025-05-12 14:56:10", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("846", "fetch_patterns", "complete", "2025-05-12 11:26:11", "2025-05-12 11:26:11", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747049171;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747049171;}", "2", "1", "2025-05-12 11:26:17", "2025-05-12 14:56:17", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("847", "fetch_patterns", "complete", "2025-05-12 12:39:01", "2025-05-12 12:39:01", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747053541;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747053541;}", "2", "1", "2025-05-13 04:57:19", "2025-05-13 08:27:19", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("849", "fetch_patterns", "complete", "2025-05-13 04:58:10", "2025-05-13 04:58:10", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747112290;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747112290;}", "2", "1", "2025-05-13 05:47:18", "2025-05-13 09:17:18", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("848", "woocommerce_cleanup_draft_orders", "complete", "2025-05-14 04:57:19", "2025-05-14 04:57:19", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747198639;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747198639;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-05-14 04:58:07", "2025-05-14 08:28:07", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("850", "fetch_patterns", "complete", "2025-05-13 06:21:25", "2025-05-13 06:21:25", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747117285;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747117285;}", "2", "1", "2025-05-13 06:21:34", "2025-05-13 09:51:34", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("851", "fetch_patterns", "complete", "2025-05-13 07:59:56", "2025-05-13 07:59:56", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747123196;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747123196;}", "2", "1", "2025-05-13 08:35:23", "2025-05-13 12:05:23", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("852", "action_scheduler/migration_hook", "complete", "2025-05-13 08:41:50", "2025-05-13 08:41:50", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747125710;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747125710;}", "1", "1", "2025-05-13 08:42:42", "2025-05-13 12:12:42", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("853", "action_scheduler/migration_hook", "failed", "2025-05-13 08:43:43", "2025-05-13 08:43:43", "10", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1747125823;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1747125823;}", "1", "1", "2025-05-13 08:43:45", "2025-05-13 12:13:45", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("854", "woocommerce_cleanup_draft_orders", "complete", "2025-05-15 04:58:07", "2025-05-15 04:58:07", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747285087;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747285087;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-05-15 06:54:41", "2025-05-15 10:24:41", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("855", "woocommerce_cleanup_draft_orders", "complete", "2025-05-16 06:54:41", "2025-05-16 06:54:41", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747378481;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747378481;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-05-16 21:07:01", "2025-05-17 00:37:01", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("856", "woocommerce_cleanup_draft_orders", "complete", "2025-05-17 21:07:01", "2025-05-17 21:07:01", "10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1747516021;s:18:\"\0*\0first_timestamp\";i:1744891499;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1747516021;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "2", "1", "2025-05-20 15:03:46", "2025-05-20 18:33:46", "0", NULL);
INSERT INTO `wp_actionscheduler_actions` VALUES("884", "woocommerce_refresh_order_count_cache", "pending", "2025-06-11 03:27:28", "2025-06-11 03:27:28", "10", "[\"shop_order\"]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1749612448;s:18:\"\0*\0first_timestamp\";i:1749612448;s:13:\"\0*\0recurrence\";i:43200;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1749612448;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:43200;}", "6", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL);

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "woocommerce-remote-inbox-engine");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "woocommerce-db-updates");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "wc_delete_related_product_transients_group");
INSERT INTO `wp_actionscheduler_groups` VALUES("6", "count");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("2551", "859", "عملیات توسط Async Request کامل شد", "2025-05-20 15:12:08", "2025-05-20 15:12:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2550", "859", "عملیات توسط Async Request شروع شد", "2025-05-20 15:12:08", "2025-05-20 15:12:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2549", "858", "عملیات توسط Async Request کامل شد", "2025-05-20 15:12:08", "2025-05-20 15:12:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2546", "858", "ایجاد فعالیت", "2025-05-20 15:12:05", "2025-05-20 15:12:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("2547", "859", "ایجاد فعالیت", "2025-05-20 15:12:05", "2025-05-20 15:12:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("2548", "858", "عملیات توسط Async Request شروع شد", "2025-05-20 15:12:08", "2025-05-20 15:12:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2599", "875", "ایجاد فعالیت", "2025-06-10 14:50:12", "2025-06-10 14:50:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2545", "857", "ایجاد فعالیت", "2025-05-20 15:03:46", "2025-05-20 15:03:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("2544", "856", "عملیات توسط Async Request کامل شد", "2025-05-20 15:03:46", "2025-05-20 15:03:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("2543", "856", "عملیات توسط Async Request شروع شد", "2025-05-20 15:03:46", "2025-05-20 15:03:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("2554", "860", "action created", "2025-05-22 20:32:10", "2025-05-22 20:32:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2553", "857", "action complete via Async Request", "2025-05-22 20:32:10", "2025-05-22 20:32:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2552", "857", "action started via Async Request", "2025-05-22 20:32:10", "2025-05-22 20:32:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2557", "861", "ایجاد فعالیت", "2025-05-24 10:43:33", "2025-05-24 10:43:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("2556", "860", "عملیات توسط Async Request کامل شد", "2025-05-24 10:43:33", "2025-05-24 10:43:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("2555", "860", "عملیات توسط Async Request شروع شد", "2025-05-24 10:43:33", "2025-05-24 10:43:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("2560", "862", "ایجاد فعالیت", "2025-05-25 12:45:14", "2025-05-25 12:45:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2563", "863", "ایجاد فعالیت", "2025-05-26 14:03:46", "2025-05-26 14:03:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("247", "113", "ایجاد فعالیت", "2025-04-19 20:55:48", "2025-04-19 20:55:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("2559", "861", "عملیات توسط Async Request کامل شد", "2025-05-25 12:45:14", "2025-05-25 12:45:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2558", "861", "عملیات توسط Async Request شروع شد", "2025-05-25 12:45:14", "2025-05-25 12:45:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2562", "862", "عملیات توسط Async Request کامل شد", "2025-05-26 14:03:46", "2025-05-26 14:03:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("2561", "862", "عملیات توسط Async Request شروع شد", "2025-05-26 14:03:46", "2025-05-26 14:03:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("315", "113", "عملیات توسط Async Request شروع شد", "2025-04-19 20:55:50", "2025-04-19 20:55:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("316", "113", "اقدام از طریق Async Request انجام نشد: Scheduled action for woocommerce_admin/stored_state_setup_for_products/async/run_remote_notifications will not be executed as no callbacks are registered.", "2025-04-19 20:55:50", "2025-04-19 20:55:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("2566", "864", "ایجاد فعالیت", "2025-05-27 14:28:10", "2025-05-27 14:28:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2565", "863", "عملیات توسط Async Request کامل شد", "2025-05-27 14:28:10", "2025-05-27 14:28:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2564", "863", "عملیات توسط Async Request شروع شد", "2025-05-27 14:28:10", "2025-05-27 14:28:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2569", "865", "ایجاد فعالیت", "2025-05-28 16:02:51", "2025-05-28 16:02:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("2568", "864", "عملیات توسط Async Request کامل شد", "2025-05-28 16:02:51", "2025-05-28 16:02:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("2567", "864", "عملیات توسط Async Request شروع شد", "2025-05-28 16:02:51", "2025-05-28 16:02:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("2572", "866", "ایجاد فعالیت", "2025-05-29 16:04:25", "2025-05-29 16:04:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2571", "865", "عملیات توسط Async Request کامل شد", "2025-05-29 16:04:25", "2025-05-29 16:04:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2570", "865", "عملیات توسط Async Request شروع شد", "2025-05-29 16:04:25", "2025-05-29 16:04:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2575", "867", "ایجاد فعالیت", "2025-05-30 21:47:37", "2025-05-30 21:47:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2574", "866", "عملیات توسط Async Request کامل شد", "2025-05-30 21:47:37", "2025-05-30 21:47:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2573", "866", "عملیات توسط Async Request شروع شد", "2025-05-30 21:47:37", "2025-05-30 21:47:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2578", "868", "ایجاد فعالیت", "2025-06-01 10:23:17", "2025-06-01 10:23:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2579", "869", "ایجاد فعالیت", "2025-06-01 11:24:19", "2025-06-01 11:24:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("2577", "867", "عملیات توسط Async Request کامل شد", "2025-06-01 10:23:17", "2025-06-01 10:23:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2576", "867", "عملیات توسط Async Request شروع شد", "2025-06-01 10:23:17", "2025-06-01 10:23:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2581", "869", "عملیات توسط Async Request کامل شد", "2025-06-02 08:01:31", "2025-06-02 08:01:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2580", "869", "عملیات توسط Async Request شروع شد", "2025-06-02 08:01:31", "2025-06-02 08:01:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2584", "870", "ایجاد فعالیت", "2025-06-03 06:25:24", "2025-06-03 06:25:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("2583", "868", "عملیات توسط Async Request کامل شد", "2025-06-03 06:25:24", "2025-06-03 06:25:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("2582", "868", "عملیات توسط Async Request شروع شد", "2025-06-03 06:25:24", "2025-06-03 06:25:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("2587", "871", "ایجاد فعالیت", "2025-06-04 10:49:14", "2025-06-04 10:49:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2590", "872", "ایجاد فعالیت", "2025-06-07 08:47:06", "2025-06-07 08:47:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("2586", "870", "عملیات توسط Async Request کامل شد", "2025-06-04 10:49:14", "2025-06-04 10:49:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2585", "870", "عملیات توسط Async Request شروع شد", "2025-06-04 10:49:13", "2025-06-04 10:49:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("2589", "871", "عملیات توسط Async Request کامل شد", "2025-06-07 08:47:06", "2025-06-07 08:47:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("2588", "871", "عملیات توسط Async Request شروع شد", "2025-06-07 08:47:06", "2025-06-07 08:47:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("2593", "873", "ایجاد فعالیت", "2025-06-08 11:03:40", "2025-06-08 11:03:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2592", "872", "عملیات توسط Async Request کامل شد", "2025-06-08 11:03:40", "2025-06-08 11:03:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2591", "872", "عملیات توسط Async Request شروع شد", "2025-06-08 11:03:40", "2025-06-08 11:03:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2596", "874", "ایجاد فعالیت", "2025-06-09 14:30:35", "2025-06-09 14:30:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2595", "873", "عملیات توسط Async Request کامل شد", "2025-06-09 14:30:35", "2025-06-09 14:30:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2594", "873", "عملیات توسط Async Request شروع شد", "2025-06-09 14:30:35", "2025-06-09 14:30:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2605", "881", "ایجاد فعالیت", "2025-06-10 15:27:27", "2025-06-10 15:27:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("2606", "882", "ایجاد فعالیت", "2025-06-10 15:27:27", "2025-06-10 15:27:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("2607", "883", "ایجاد فعالیت", "2025-06-10 15:27:27", "2025-06-10 15:27:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("2608", "884", "ایجاد فعالیت", "2025-06-10 15:27:28", "2025-06-10 15:27:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2604", "880", "ایجاد فعالیت", "2025-06-10 15:27:26", "2025-06-10 15:27:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2603", "879", "ایجاد فعالیت", "2025-06-10 15:27:26", "2025-06-10 15:27:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2602", "878", "ایجاد فعالیت", "2025-06-10 15:27:26", "2025-06-10 15:27:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2601", "877", "ایجاد فعالیت", "2025-06-10 15:27:26", "2025-06-10 15:27:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2600", "876", "ایجاد فعالیت", "2025-06-10 15:27:22", "2025-06-10 15:27:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("2598", "874", "عملیات توسط Async Request کامل شد", "2025-06-10 14:50:12", "2025-06-10 14:50:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2597", "874", "عملیات توسط Async Request شروع شد", "2025-06-10 14:50:12", "2025-06-10 14:50:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1009", "345", "ایجاد فعالیت", "2025-04-20 15:12:48", "2025-04-20 15:12:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("2620", "882", "عملیات توسط Async Request کامل شد", "2025-06-10 15:27:28", "2025-06-10 15:27:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2618", "879", "عملیات توسط Async Request کامل شد", "2025-06-10 15:27:28", "2025-06-10 15:27:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2616", "881", "عملیات توسط Async Request کامل شد", "2025-06-10 15:27:28", "2025-06-10 15:27:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2611", "877", "عملیات توسط Async Request شروع شد", "2025-06-10 15:27:28", "2025-06-10 15:27:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2612", "877", "عملیات توسط Async Request کامل شد", "2025-06-10 15:27:28", "2025-06-10 15:27:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2613", "878", "عملیات توسط Async Request شروع شد", "2025-06-10 15:27:28", "2025-06-10 15:27:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2619", "882", "عملیات توسط Async Request شروع شد", "2025-06-10 15:27:28", "2025-06-10 15:27:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2617", "879", "عملیات توسط Async Request شروع شد", "2025-06-10 15:27:28", "2025-06-10 15:27:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2615", "881", "عملیات توسط Async Request شروع شد", "2025-06-10 15:27:28", "2025-06-10 15:27:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2614", "878", "عملیات توسط Async Request کامل شد", "2025-06-10 15:27:28", "2025-06-10 15:27:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2610", "876", "عملیات توسط Async Request کامل شد", "2025-06-10 15:27:28", "2025-06-10 15:27:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2609", "876", "عملیات توسط Async Request شروع شد", "2025-06-10 15:27:28", "2025-06-10 15:27:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2624", "883", "عملیات توسط Async Request کامل شد", "2025-06-10 15:27:35", "2025-06-10 15:27:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2621", "880", "عملیات توسط Async Request شروع شد", "2025-06-10 15:27:35", "2025-06-10 15:27:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2622", "880", "عملیات توسط Async Request کامل شد", "2025-06-10 15:27:35", "2025-06-10 15:27:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2623", "883", "عملیات توسط Async Request شروع شد", "2025-06-10 15:27:35", "2025-06-10 15:27:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1130", "386", "ایجاد فعالیت", "2025-04-20 15:29:58", "2025-04-20 15:29:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1131", "387", "ایجاد فعالیت", "2025-04-20 15:29:58", "2025-04-20 15:29:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1132", "388", "ایجاد فعالیت", "2025-04-20 15:29:58", "2025-04-20 15:29:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1133", "389", "ایجاد فعالیت", "2025-04-20 15:29:58", "2025-04-20 15:29:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1134", "390", "ایجاد فعالیت", "2025-04-20 15:29:58", "2025-04-20 15:29:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1135", "391", "ایجاد فعالیت", "2025-04-20 15:29:58", "2025-04-20 15:29:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1136", "392", "ایجاد فعالیت", "2025-04-20 15:29:58", "2025-04-20 15:29:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1137", "393", "ایجاد فعالیت", "2025-04-20 15:29:58", "2025-04-20 15:29:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1138", "394", "ایجاد فعالیت", "2025-04-20 15:29:58", "2025-04-20 15:29:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1139", "395", "ایجاد فعالیت", "2025-04-20 15:29:58", "2025-04-20 15:29:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1140", "396", "ایجاد فعالیت", "2025-04-20 15:29:58", "2025-04-20 15:29:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1141", "397", "ایجاد فعالیت", "2025-04-20 15:29:58", "2025-04-20 15:29:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1142", "398", "ایجاد فعالیت", "2025-04-20 15:29:58", "2025-04-20 15:29:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("1143", "399", "ایجاد فعالیت", "2025-04-20 15:30:13", "2025-04-20 15:30:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("1144", "400", "ایجاد فعالیت", "2025-04-20 15:30:13", "2025-04-20 15:30:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("1145", "401", "ایجاد فعالیت", "2025-04-20 15:30:13", "2025-04-20 15:30:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("1146", "402", "ایجاد فعالیت", "2025-04-20 15:30:13", "2025-04-20 15:30:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("1147", "403", "ایجاد فعالیت", "2025-04-20 15:30:13", "2025-04-20 15:30:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("1148", "404", "ایجاد فعالیت", "2025-04-20 15:30:13", "2025-04-20 15:30:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("1149", "405", "ایجاد فعالیت", "2025-04-20 15:30:13", "2025-04-20 15:30:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("1150", "406", "ایجاد فعالیت", "2025-04-20 15:30:13", "2025-04-20 15:30:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("1151", "407", "ایجاد فعالیت", "2025-04-20 15:30:13", "2025-04-20 15:30:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("1152", "408", "ایجاد فعالیت", "2025-04-20 15:30:13", "2025-04-20 15:30:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("1153", "409", "ایجاد فعالیت", "2025-04-20 15:30:13", "2025-04-20 15:30:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("1154", "410", "ایجاد فعالیت", "2025-04-20 15:30:13", "2025-04-20 15:30:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("1155", "411", "ایجاد فعالیت", "2025-04-20 15:30:13", "2025-04-20 15:30:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("1156", "386", "عملیات توسط Async Request شروع شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1157", "386", "عملیات توسط Async Request کامل شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1158", "387", "عملیات توسط Async Request شروع شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1159", "387", "عملیات توسط Async Request کامل شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1160", "388", "عملیات توسط Async Request شروع شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1161", "388", "عملیات توسط Async Request کامل شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1162", "389", "عملیات توسط Async Request شروع شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1163", "389", "عملیات توسط Async Request کامل شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1164", "390", "عملیات توسط Async Request شروع شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1165", "390", "عملیات توسط Async Request کامل شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1166", "391", "عملیات توسط Async Request شروع شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1167", "391", "عملیات توسط Async Request کامل شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1168", "392", "عملیات توسط Async Request شروع شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1169", "392", "عملیات توسط Async Request کامل شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1170", "393", "عملیات توسط Async Request شروع شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1171", "393", "عملیات توسط Async Request کامل شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1172", "394", "عملیات توسط Async Request شروع شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1173", "394", "عملیات توسط Async Request کامل شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1174", "395", "عملیات توسط Async Request شروع شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1175", "395", "عملیات توسط Async Request کامل شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1176", "396", "عملیات توسط Async Request شروع شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1177", "396", "عملیات توسط Async Request کامل شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1178", "397", "عملیات توسط Async Request شروع شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1179", "397", "عملیات توسط Async Request کامل شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1180", "398", "عملیات توسط Async Request شروع شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1181", "398", "عملیات توسط Async Request کامل شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1182", "399", "عملیات توسط Async Request شروع شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1183", "399", "عملیات توسط Async Request کامل شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1184", "400", "عملیات توسط Async Request شروع شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1185", "400", "عملیات توسط Async Request کامل شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1186", "401", "عملیات توسط Async Request شروع شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1187", "401", "عملیات توسط Async Request کامل شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1188", "402", "عملیات توسط Async Request شروع شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1189", "402", "عملیات توسط Async Request کامل شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1190", "403", "عملیات توسط Async Request شروع شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1191", "403", "عملیات توسط Async Request کامل شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1192", "404", "عملیات توسط Async Request شروع شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1193", "404", "عملیات توسط Async Request کامل شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1194", "405", "عملیات توسط Async Request شروع شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1195", "405", "عملیات توسط Async Request کامل شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1196", "406", "عملیات توسط Async Request شروع شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1197", "406", "عملیات توسط Async Request کامل شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1198", "407", "عملیات توسط Async Request شروع شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1199", "407", "عملیات توسط Async Request کامل شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1200", "408", "عملیات توسط Async Request شروع شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1201", "408", "عملیات توسط Async Request کامل شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1202", "409", "عملیات توسط Async Request شروع شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1203", "409", "عملیات توسط Async Request کامل شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1204", "410", "عملیات توسط Async Request شروع شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1205", "410", "عملیات توسط Async Request کامل شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1206", "411", "عملیات توسط Async Request شروع شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1207", "411", "عملیات توسط Async Request کامل شد", "2025-04-20 15:31:12", "2025-04-20 15:31:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1208", "412", "ایجاد فعالیت", "2025-04-20 15:31:18", "2025-04-20 15:31:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1209", "413", "ایجاد فعالیت", "2025-04-20 15:31:18", "2025-04-20 15:31:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1210", "414", "ایجاد فعالیت", "2025-04-20 15:31:18", "2025-04-20 15:31:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1211", "412", "عملیات توسط Async Request شروع شد", "2025-04-20 15:32:38", "2025-04-20 15:32:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("1212", "412", "عملیات توسط Async Request کامل شد", "2025-04-20 15:32:38", "2025-04-20 15:32:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("1213", "414", "عملیات توسط Async Request شروع شد", "2025-04-20 15:32:38", "2025-04-20 15:32:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("1214", "414", "عملیات توسط Async Request کامل شد", "2025-04-20 15:32:38", "2025-04-20 15:32:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("1215", "413", "عملیات توسط Async Request شروع شد", "2025-04-20 15:32:38", "2025-04-20 15:32:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("1216", "413", "عملیات توسط Async Request کامل شد", "2025-04-20 15:32:38", "2025-04-20 15:32:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("1217", "415", "ایجاد فعالیت", "2025-04-20 16:22:49", "2025-04-20 16:22:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("1218", "415", "عملیات توسط Async Request شروع شد", "2025-04-20 16:23:00", "2025-04-20 16:23:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("1219", "415", "عملیات توسط Async Request کامل شد", "2025-04-20 16:23:00", "2025-04-20 16:23:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("1220", "416", "ایجاد فعالیت", "2025-04-20 16:23:46", "2025-04-20 16:23:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1221", "417", "ایجاد فعالیت", "2025-04-20 16:23:46", "2025-04-20 16:23:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1222", "418", "ایجاد فعالیت", "2025-04-20 16:23:46", "2025-04-20 16:23:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1223", "419", "ایجاد فعالیت", "2025-04-20 16:23:46", "2025-04-20 16:23:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1224", "420", "ایجاد فعالیت", "2025-04-20 16:23:46", "2025-04-20 16:23:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1225", "421", "ایجاد فعالیت", "2025-04-20 16:23:46", "2025-04-20 16:23:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1226", "422", "ایجاد فعالیت", "2025-04-20 16:23:46", "2025-04-20 16:23:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1227", "423", "ایجاد فعالیت", "2025-04-20 16:23:46", "2025-04-20 16:23:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1228", "424", "ایجاد فعالیت", "2025-04-20 16:23:46", "2025-04-20 16:23:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1229", "425", "ایجاد فعالیت", "2025-04-20 16:23:46", "2025-04-20 16:23:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1230", "426", "ایجاد فعالیت", "2025-04-20 16:23:46", "2025-04-20 16:23:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1231", "427", "ایجاد فعالیت", "2025-04-20 16:23:46", "2025-04-20 16:23:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1232", "428", "ایجاد فعالیت", "2025-04-20 16:23:46", "2025-04-20 16:23:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("1233", "429", "ایجاد فعالیت", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1234", "430", "ایجاد فعالیت", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1235", "431", "ایجاد فعالیت", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1236", "432", "ایجاد فعالیت", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1237", "433", "ایجاد فعالیت", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1238", "434", "ایجاد فعالیت", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1239", "435", "ایجاد فعالیت", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1240", "436", "ایجاد فعالیت", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1241", "437", "ایجاد فعالیت", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1242", "438", "ایجاد فعالیت", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1243", "416", "عملیات توسط Async Request شروع شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1244", "416", "عملیات توسط Async Request کامل شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1245", "417", "عملیات توسط Async Request شروع شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1246", "439", "ایجاد فعالیت", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1247", "417", "عملیات توسط Async Request کامل شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1248", "418", "عملیات توسط Async Request شروع شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1249", "418", "عملیات توسط Async Request کامل شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1250", "419", "عملیات توسط Async Request شروع شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1251", "440", "ایجاد فعالیت", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1252", "419", "عملیات توسط Async Request کامل شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1253", "420", "عملیات توسط Async Request شروع شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1254", "420", "عملیات توسط Async Request کامل شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1255", "421", "عملیات توسط Async Request شروع شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1256", "421", "عملیات توسط Async Request کامل شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1257", "422", "عملیات توسط Async Request شروع شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1258", "422", "عملیات توسط Async Request کامل شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1259", "423", "عملیات توسط Async Request شروع شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1260", "441", "ایجاد فعالیت", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1261", "423", "عملیات توسط Async Request کامل شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1262", "424", "عملیات توسط Async Request شروع شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1263", "424", "عملیات توسط Async Request کامل شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1264", "425", "عملیات توسط Async Request شروع شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1265", "425", "عملیات توسط Async Request کامل شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1266", "426", "عملیات توسط Async Request شروع شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1267", "426", "عملیات توسط Async Request کامل شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1268", "427", "عملیات توسط Async Request شروع شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1269", "427", "عملیات توسط Async Request کامل شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1270", "428", "عملیات توسط Async Request شروع شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1271", "428", "عملیات توسط Async Request کامل شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1272", "429", "عملیات توسط Async Request شروع شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1273", "429", "عملیات توسط Async Request کامل شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1274", "430", "عملیات توسط Async Request شروع شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1275", "430", "عملیات توسط Async Request کامل شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1276", "431", "عملیات توسط Async Request شروع شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1277", "431", "عملیات توسط Async Request کامل شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1278", "432", "عملیات توسط Async Request شروع شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1279", "432", "عملیات توسط Async Request کامل شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1280", "433", "عملیات توسط Async Request شروع شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1281", "433", "عملیات توسط Async Request کامل شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1282", "434", "عملیات توسط Async Request شروع شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1283", "434", "عملیات توسط Async Request کامل شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1284", "435", "عملیات توسط Async Request شروع شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1285", "435", "عملیات توسط Async Request کامل شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1286", "436", "عملیات توسط Async Request شروع شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1287", "436", "عملیات توسط Async Request کامل شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1288", "437", "عملیات توسط Async Request شروع شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1289", "437", "عملیات توسط Async Request کامل شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1290", "438", "عملیات توسط Async Request شروع شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1291", "438", "عملیات توسط Async Request کامل شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1292", "439", "عملیات توسط Async Request شروع شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1293", "439", "عملیات توسط Async Request کامل شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1294", "440", "عملیات توسط Async Request شروع شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1295", "440", "عملیات توسط Async Request کامل شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1296", "441", "عملیات توسط Async Request شروع شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1297", "441", "عملیات توسط Async Request کامل شد", "2025-04-20 16:24:18", "2025-04-20 16:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("1298", "442", "ایجاد فعالیت", "2025-04-20 16:24:31", "2025-04-20 16:24:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1299", "443", "ایجاد فعالیت", "2025-04-20 16:24:31", "2025-04-20 16:24:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1300", "444", "ایجاد فعالیت", "2025-04-20 16:24:31", "2025-04-20 16:24:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1301", "445", "ایجاد فعالیت", "2025-04-20 16:24:31", "2025-04-20 16:24:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1302", "446", "ایجاد فعالیت", "2025-04-20 16:24:31", "2025-04-20 16:24:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1303", "447", "ایجاد فعالیت", "2025-04-20 16:24:31", "2025-04-20 16:24:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1304", "448", "ایجاد فعالیت", "2025-04-20 16:24:31", "2025-04-20 16:24:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1305", "449", "ایجاد فعالیت", "2025-04-20 16:24:31", "2025-04-20 16:24:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1306", "450", "ایجاد فعالیت", "2025-04-20 16:24:31", "2025-04-20 16:24:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1307", "451", "ایجاد فعالیت", "2025-04-20 16:24:31", "2025-04-20 16:24:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1308", "452", "ایجاد فعالیت", "2025-04-20 16:24:31", "2025-04-20 16:24:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1309", "453", "ایجاد فعالیت", "2025-04-20 16:24:31", "2025-04-20 16:24:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1310", "454", "ایجاد فعالیت", "2025-04-20 16:24:31", "2025-04-20 16:24:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1311", "455", "ایجاد فعالیت", "2025-04-20 16:24:48", "2025-04-20 16:24:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("1312", "456", "ایجاد فعالیت", "2025-04-20 16:24:48", "2025-04-20 16:24:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("1313", "457", "ایجاد فعالیت", "2025-04-20 16:24:48", "2025-04-20 16:24:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("1314", "442", "عملیات توسط Async Request شروع شد", "2025-04-20 16:25:43", "2025-04-20 16:25:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("1315", "442", "عملیات توسط Async Request کامل شد", "2025-04-20 16:25:43", "2025-04-20 16:25:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("1316", "443", "عملیات توسط Async Request شروع شد", "2025-04-20 16:25:43", "2025-04-20 16:25:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("1317", "443", "عملیات توسط Async Request کامل شد", "2025-04-20 16:25:44", "2025-04-20 16:25:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1318", "444", "عملیات توسط Async Request شروع شد", "2025-04-20 16:25:44", "2025-04-20 16:25:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1319", "444", "عملیات توسط Async Request کامل شد", "2025-04-20 16:25:44", "2025-04-20 16:25:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1320", "445", "عملیات توسط Async Request شروع شد", "2025-04-20 16:25:44", "2025-04-20 16:25:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1321", "445", "عملیات توسط Async Request کامل شد", "2025-04-20 16:25:44", "2025-04-20 16:25:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1322", "446", "عملیات توسط Async Request شروع شد", "2025-04-20 16:25:44", "2025-04-20 16:25:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1323", "446", "عملیات توسط Async Request کامل شد", "2025-04-20 16:25:44", "2025-04-20 16:25:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1324", "447", "عملیات توسط Async Request شروع شد", "2025-04-20 16:25:44", "2025-04-20 16:25:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1325", "447", "عملیات توسط Async Request کامل شد", "2025-04-20 16:25:44", "2025-04-20 16:25:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1326", "448", "عملیات توسط Async Request شروع شد", "2025-04-20 16:25:44", "2025-04-20 16:25:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1327", "448", "عملیات توسط Async Request کامل شد", "2025-04-20 16:25:44", "2025-04-20 16:25:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1328", "449", "عملیات توسط Async Request شروع شد", "2025-04-20 16:25:44", "2025-04-20 16:25:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1329", "449", "عملیات توسط Async Request کامل شد", "2025-04-20 16:25:44", "2025-04-20 16:25:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1330", "450", "عملیات توسط Async Request شروع شد", "2025-04-20 16:25:44", "2025-04-20 16:25:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1331", "450", "عملیات توسط Async Request کامل شد", "2025-04-20 16:25:44", "2025-04-20 16:25:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1332", "451", "عملیات توسط Async Request شروع شد", "2025-04-20 16:25:44", "2025-04-20 16:25:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1333", "451", "عملیات توسط Async Request کامل شد", "2025-04-20 16:25:44", "2025-04-20 16:25:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1334", "452", "عملیات توسط Async Request شروع شد", "2025-04-20 16:25:44", "2025-04-20 16:25:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1335", "452", "عملیات توسط Async Request کامل شد", "2025-04-20 16:25:44", "2025-04-20 16:25:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1336", "453", "عملیات توسط Async Request شروع شد", "2025-04-20 16:25:44", "2025-04-20 16:25:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1337", "453", "عملیات توسط Async Request کامل شد", "2025-04-20 16:25:44", "2025-04-20 16:25:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1338", "454", "عملیات توسط Async Request شروع شد", "2025-04-20 16:25:44", "2025-04-20 16:25:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1339", "454", "عملیات توسط Async Request کامل شد", "2025-04-20 16:25:44", "2025-04-20 16:25:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1340", "455", "عملیات توسط Async Request شروع شد", "2025-04-20 16:25:44", "2025-04-20 16:25:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1341", "455", "عملیات توسط Async Request کامل شد", "2025-04-20 16:25:44", "2025-04-20 16:25:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1342", "457", "عملیات توسط Async Request شروع شد", "2025-04-20 16:25:44", "2025-04-20 16:25:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1343", "457", "عملیات توسط Async Request کامل شد", "2025-04-20 16:25:44", "2025-04-20 16:25:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1344", "456", "عملیات توسط Async Request شروع شد", "2025-04-20 16:25:44", "2025-04-20 16:25:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1345", "456", "عملیات توسط Async Request کامل شد", "2025-04-20 16:25:44", "2025-04-20 16:25:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1346", "458", "ایجاد فعالیت", "2025-04-20 16:26:10", "2025-04-20 16:26:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1347", "459", "ایجاد فعالیت", "2025-04-20 16:26:10", "2025-04-20 16:26:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1348", "460", "ایجاد فعالیت", "2025-04-20 16:26:10", "2025-04-20 16:26:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1349", "461", "ایجاد فعالیت", "2025-04-20 16:26:10", "2025-04-20 16:26:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1350", "462", "ایجاد فعالیت", "2025-04-20 16:26:10", "2025-04-20 16:26:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1351", "463", "ایجاد فعالیت", "2025-04-20 16:26:10", "2025-04-20 16:26:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1352", "464", "ایجاد فعالیت", "2025-04-20 16:26:10", "2025-04-20 16:26:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1353", "465", "ایجاد فعالیت", "2025-04-20 16:26:10", "2025-04-20 16:26:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1354", "466", "ایجاد فعالیت", "2025-04-20 16:26:10", "2025-04-20 16:26:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1355", "467", "ایجاد فعالیت", "2025-04-20 16:26:10", "2025-04-20 16:26:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1356", "468", "ایجاد فعالیت", "2025-04-20 16:26:10", "2025-04-20 16:26:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1357", "469", "ایجاد فعالیت", "2025-04-20 16:26:10", "2025-04-20 16:26:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1358", "470", "ایجاد فعالیت", "2025-04-20 16:26:10", "2025-04-20 16:26:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1359", "471", "ایجاد فعالیت", "2025-04-20 16:26:30", "2025-04-20 16:26:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1360", "472", "ایجاد فعالیت", "2025-04-20 16:26:30", "2025-04-20 16:26:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1361", "473", "ایجاد فعالیت", "2025-04-20 16:26:30", "2025-04-20 16:26:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1362", "474", "ایجاد فعالیت", "2025-04-20 16:26:30", "2025-04-20 16:26:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1363", "475", "ایجاد فعالیت", "2025-04-20 16:26:30", "2025-04-20 16:26:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1364", "476", "ایجاد فعالیت", "2025-04-20 16:26:30", "2025-04-20 16:26:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1365", "477", "ایجاد فعالیت", "2025-04-20 16:26:30", "2025-04-20 16:26:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1366", "478", "ایجاد فعالیت", "2025-04-20 16:26:30", "2025-04-20 16:26:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1367", "479", "ایجاد فعالیت", "2025-04-20 16:26:30", "2025-04-20 16:26:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1368", "480", "ایجاد فعالیت", "2025-04-20 16:26:30", "2025-04-20 16:26:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1369", "481", "ایجاد فعالیت", "2025-04-20 16:26:30", "2025-04-20 16:26:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1370", "482", "ایجاد فعالیت", "2025-04-20 16:26:30", "2025-04-20 16:26:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1371", "483", "ایجاد فعالیت", "2025-04-20 16:26:30", "2025-04-20 16:26:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1372", "484", "ایجاد فعالیت", "2025-04-20 16:26:38", "2025-04-20 16:26:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("1373", "485", "ایجاد فعالیت", "2025-04-20 16:26:38", "2025-04-20 16:26:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("1374", "486", "ایجاد فعالیت", "2025-04-20 16:26:38", "2025-04-20 16:26:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("1375", "458", "عملیات توسط Async Request شروع شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1376", "458", "عملیات توسط Async Request کامل شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1377", "459", "عملیات توسط Async Request شروع شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1378", "459", "عملیات توسط Async Request کامل شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1379", "460", "عملیات توسط Async Request شروع شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1380", "460", "عملیات توسط Async Request کامل شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1381", "461", "عملیات توسط Async Request شروع شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1382", "461", "عملیات توسط Async Request کامل شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1383", "462", "عملیات توسط Async Request شروع شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1384", "462", "عملیات توسط Async Request کامل شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1385", "463", "عملیات توسط Async Request شروع شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1386", "463", "عملیات توسط Async Request کامل شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1387", "464", "عملیات توسط Async Request شروع شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1388", "464", "عملیات توسط Async Request کامل شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1389", "465", "عملیات توسط Async Request شروع شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1390", "465", "عملیات توسط Async Request کامل شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1391", "466", "عملیات توسط Async Request شروع شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1392", "466", "عملیات توسط Async Request کامل شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1393", "467", "عملیات توسط Async Request شروع شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1394", "467", "عملیات توسط Async Request کامل شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1395", "468", "عملیات توسط Async Request شروع شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1396", "468", "عملیات توسط Async Request کامل شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1397", "469", "عملیات توسط Async Request شروع شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1398", "469", "عملیات توسط Async Request کامل شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1399", "470", "عملیات توسط Async Request شروع شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1400", "470", "عملیات توسط Async Request کامل شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1401", "471", "عملیات توسط Async Request شروع شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1402", "471", "عملیات توسط Async Request کامل شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1403", "472", "عملیات توسط Async Request شروع شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1404", "472", "عملیات توسط Async Request کامل شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1405", "473", "عملیات توسط Async Request شروع شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1406", "473", "عملیات توسط Async Request کامل شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1407", "474", "عملیات توسط Async Request شروع شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1408", "474", "عملیات توسط Async Request کامل شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1409", "475", "عملیات توسط Async Request شروع شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1410", "475", "عملیات توسط Async Request کامل شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1411", "476", "عملیات توسط Async Request شروع شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1412", "476", "عملیات توسط Async Request کامل شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1413", "477", "عملیات توسط Async Request شروع شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1414", "477", "عملیات توسط Async Request کامل شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1415", "478", "عملیات توسط Async Request شروع شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1416", "478", "عملیات توسط Async Request کامل شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1417", "479", "عملیات توسط Async Request شروع شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1418", "479", "عملیات توسط Async Request کامل شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1419", "480", "عملیات توسط Async Request شروع شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1420", "480", "عملیات توسط Async Request کامل شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1421", "481", "عملیات توسط Async Request شروع شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1422", "481", "عملیات توسط Async Request کامل شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1423", "482", "عملیات توسط Async Request شروع شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1424", "482", "عملیات توسط Async Request کامل شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1425", "483", "عملیات توسط Async Request شروع شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1426", "483", "عملیات توسط Async Request کامل شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1427", "484", "عملیات توسط Async Request شروع شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1428", "484", "عملیات توسط Async Request کامل شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1429", "486", "عملیات توسط Async Request شروع شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1430", "486", "عملیات توسط Async Request کامل شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1431", "485", "عملیات توسط Async Request شروع شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1432", "485", "عملیات توسط Async Request کامل شد", "2025-04-20 16:26:44", "2025-04-20 16:26:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("1433", "487", "ایجاد فعالیت", "2025-04-20 16:27:26", "2025-04-20 16:27:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1434", "488", "ایجاد فعالیت", "2025-04-20 16:27:26", "2025-04-20 16:27:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1435", "489", "ایجاد فعالیت", "2025-04-20 16:27:26", "2025-04-20 16:27:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1436", "490", "ایجاد فعالیت", "2025-04-20 16:27:26", "2025-04-20 16:27:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1437", "491", "ایجاد فعالیت", "2025-04-20 16:27:26", "2025-04-20 16:27:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1438", "492", "ایجاد فعالیت", "2025-04-20 16:27:26", "2025-04-20 16:27:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1439", "493", "ایجاد فعالیت", "2025-04-20 16:27:26", "2025-04-20 16:27:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1440", "494", "ایجاد فعالیت", "2025-04-20 16:27:26", "2025-04-20 16:27:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1441", "495", "ایجاد فعالیت", "2025-04-20 16:27:26", "2025-04-20 16:27:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1442", "496", "ایجاد فعالیت", "2025-04-20 16:27:26", "2025-04-20 16:27:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1443", "497", "ایجاد فعالیت", "2025-04-20 16:27:27", "2025-04-20 16:27:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1444", "498", "ایجاد فعالیت", "2025-04-20 16:27:27", "2025-04-20 16:27:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1445", "499", "ایجاد فعالیت", "2025-04-20 16:27:27", "2025-04-20 16:27:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1446", "500", "ایجاد فعالیت", "2025-04-20 16:27:53", "2025-04-20 16:27:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1447", "501", "ایجاد فعالیت", "2025-04-20 16:27:53", "2025-04-20 16:27:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1448", "502", "ایجاد فعالیت", "2025-04-20 16:27:53", "2025-04-20 16:27:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1449", "503", "ایجاد فعالیت", "2025-04-20 16:27:53", "2025-04-20 16:27:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1450", "504", "ایجاد فعالیت", "2025-04-20 16:27:53", "2025-04-20 16:27:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1451", "505", "ایجاد فعالیت", "2025-04-20 16:27:53", "2025-04-20 16:27:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1452", "506", "ایجاد فعالیت", "2025-04-20 16:27:53", "2025-04-20 16:27:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1453", "507", "ایجاد فعالیت", "2025-04-20 16:27:53", "2025-04-20 16:27:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1454", "508", "ایجاد فعالیت", "2025-04-20 16:27:53", "2025-04-20 16:27:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1455", "509", "ایجاد فعالیت", "2025-04-20 16:27:53", "2025-04-20 16:27:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1456", "510", "ایجاد فعالیت", "2025-04-20 16:27:53", "2025-04-20 16:27:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1457", "511", "ایجاد فعالیت", "2025-04-20 16:27:53", "2025-04-20 16:27:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1458", "512", "ایجاد فعالیت", "2025-04-20 16:27:53", "2025-04-20 16:27:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1459", "487", "عملیات توسط Async Request شروع شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1460", "487", "عملیات توسط Async Request کامل شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1461", "488", "عملیات توسط Async Request شروع شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1462", "488", "عملیات توسط Async Request کامل شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1463", "489", "عملیات توسط Async Request شروع شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1464", "489", "عملیات توسط Async Request کامل شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1465", "490", "عملیات توسط Async Request شروع شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1466", "490", "عملیات توسط Async Request کامل شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1467", "491", "عملیات توسط Async Request شروع شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1468", "491", "عملیات توسط Async Request کامل شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1469", "492", "عملیات توسط Async Request شروع شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1470", "492", "عملیات توسط Async Request کامل شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1471", "493", "عملیات توسط Async Request شروع شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1472", "493", "عملیات توسط Async Request کامل شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1473", "494", "عملیات توسط Async Request شروع شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1474", "494", "عملیات توسط Async Request کامل شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1475", "495", "عملیات توسط Async Request شروع شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1476", "495", "عملیات توسط Async Request کامل شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1477", "496", "عملیات توسط Async Request شروع شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1478", "496", "عملیات توسط Async Request کامل شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1479", "497", "عملیات توسط Async Request شروع شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1480", "497", "عملیات توسط Async Request کامل شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1481", "498", "عملیات توسط Async Request شروع شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1482", "498", "عملیات توسط Async Request کامل شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1483", "499", "عملیات توسط Async Request شروع شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1484", "499", "عملیات توسط Async Request کامل شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1485", "500", "عملیات توسط Async Request شروع شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1486", "500", "عملیات توسط Async Request کامل شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1487", "501", "عملیات توسط Async Request شروع شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1488", "501", "عملیات توسط Async Request کامل شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1489", "502", "عملیات توسط Async Request شروع شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1490", "502", "عملیات توسط Async Request کامل شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1491", "503", "عملیات توسط Async Request شروع شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1492", "503", "عملیات توسط Async Request کامل شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1493", "504", "عملیات توسط Async Request شروع شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1494", "504", "عملیات توسط Async Request کامل شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1495", "505", "عملیات توسط Async Request شروع شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1496", "505", "عملیات توسط Async Request کامل شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1497", "506", "عملیات توسط Async Request شروع شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1498", "506", "عملیات توسط Async Request کامل شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1499", "507", "عملیات توسط Async Request شروع شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1500", "507", "عملیات توسط Async Request کامل شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1501", "508", "عملیات توسط Async Request شروع شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1502", "508", "عملیات توسط Async Request کامل شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1503", "509", "عملیات توسط Async Request شروع شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1504", "509", "عملیات توسط Async Request کامل شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1505", "510", "عملیات توسط Async Request شروع شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1506", "510", "عملیات توسط Async Request کامل شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1507", "511", "عملیات توسط Async Request شروع شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1508", "511", "عملیات توسط Async Request کامل شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1509", "512", "عملیات توسط Async Request شروع شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1510", "512", "عملیات توسط Async Request کامل شد", "2025-04-20 16:27:55", "2025-04-20 16:27:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1511", "513", "ایجاد فعالیت", "2025-04-20 16:28:53", "2025-04-20 16:28:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1512", "514", "ایجاد فعالیت", "2025-04-20 16:28:53", "2025-04-20 16:28:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1513", "515", "ایجاد فعالیت", "2025-04-20 16:28:53", "2025-04-20 16:28:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1514", "513", "عملیات توسط Async Request شروع شد", "2025-04-20 16:28:56", "2025-04-20 16:28:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1515", "513", "عملیات توسط Async Request کامل شد", "2025-04-20 16:28:56", "2025-04-20 16:28:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1516", "515", "عملیات توسط Async Request شروع شد", "2025-04-20 16:28:56", "2025-04-20 16:28:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1517", "515", "عملیات توسط Async Request کامل شد", "2025-04-20 16:28:56", "2025-04-20 16:28:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1518", "514", "عملیات توسط Async Request شروع شد", "2025-04-20 16:28:56", "2025-04-20 16:28:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1519", "514", "عملیات توسط Async Request کامل شد", "2025-04-20 16:28:56", "2025-04-20 16:28:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("1520", "516", "ایجاد فعالیت", "2025-04-20 16:29:37", "2025-04-20 16:29:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1521", "517", "ایجاد فعالیت", "2025-04-20 16:29:37", "2025-04-20 16:29:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1522", "518", "ایجاد فعالیت", "2025-04-20 16:29:37", "2025-04-20 16:29:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1523", "519", "ایجاد فعالیت", "2025-04-20 16:29:37", "2025-04-20 16:29:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1524", "520", "ایجاد فعالیت", "2025-04-20 16:29:37", "2025-04-20 16:29:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1525", "521", "ایجاد فعالیت", "2025-04-20 16:29:37", "2025-04-20 16:29:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1526", "522", "ایجاد فعالیت", "2025-04-20 16:29:37", "2025-04-20 16:29:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1527", "523", "ایجاد فعالیت", "2025-04-20 16:29:37", "2025-04-20 16:29:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1528", "524", "ایجاد فعالیت", "2025-04-20 16:29:37", "2025-04-20 16:29:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1529", "525", "ایجاد فعالیت", "2025-04-20 16:29:37", "2025-04-20 16:29:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1530", "526", "ایجاد فعالیت", "2025-04-20 16:29:37", "2025-04-20 16:29:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1531", "527", "ایجاد فعالیت", "2025-04-20 16:29:37", "2025-04-20 16:29:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1532", "528", "ایجاد فعالیت", "2025-04-20 16:29:37", "2025-04-20 16:29:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("1533", "529", "ایجاد فعالیت", "2025-04-20 16:29:59", "2025-04-20 16:29:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1534", "530", "ایجاد فعالیت", "2025-04-20 16:29:59", "2025-04-20 16:29:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1535", "531", "ایجاد فعالیت", "2025-04-20 16:29:59", "2025-04-20 16:29:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1536", "532", "ایجاد فعالیت", "2025-04-20 16:29:59", "2025-04-20 16:29:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1537", "533", "ایجاد فعالیت", "2025-04-20 16:29:59", "2025-04-20 16:29:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1538", "534", "ایجاد فعالیت", "2025-04-20 16:29:59", "2025-04-20 16:29:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1539", "535", "ایجاد فعالیت", "2025-04-20 16:29:59", "2025-04-20 16:29:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1540", "536", "ایجاد فعالیت", "2025-04-20 16:29:59", "2025-04-20 16:29:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1541", "537", "ایجاد فعالیت", "2025-04-20 16:29:59", "2025-04-20 16:29:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1542", "538", "ایجاد فعالیت", "2025-04-20 16:29:59", "2025-04-20 16:29:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1543", "539", "ایجاد فعالیت", "2025-04-20 16:29:59", "2025-04-20 16:29:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1544", "540", "ایجاد فعالیت", "2025-04-20 16:29:59", "2025-04-20 16:29:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1545", "541", "ایجاد فعالیت", "2025-04-20 16:29:59", "2025-04-20 16:29:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("1546", "516", "عملیات توسط Async Request شروع شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1547", "516", "عملیات توسط Async Request کامل شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1548", "517", "عملیات توسط Async Request شروع شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1549", "517", "عملیات توسط Async Request کامل شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1550", "518", "عملیات توسط Async Request شروع شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1551", "518", "عملیات توسط Async Request کامل شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1552", "519", "عملیات توسط Async Request شروع شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1553", "519", "عملیات توسط Async Request کامل شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1554", "520", "عملیات توسط Async Request شروع شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1555", "520", "عملیات توسط Async Request کامل شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1556", "521", "عملیات توسط Async Request شروع شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1557", "521", "عملیات توسط Async Request کامل شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1558", "522", "عملیات توسط Async Request شروع شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1559", "522", "عملیات توسط Async Request کامل شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1560", "523", "عملیات توسط Async Request شروع شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1561", "523", "عملیات توسط Async Request کامل شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1562", "524", "عملیات توسط Async Request شروع شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1563", "524", "عملیات توسط Async Request کامل شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1564", "525", "عملیات توسط Async Request شروع شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1565", "525", "عملیات توسط Async Request کامل شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1566", "526", "عملیات توسط Async Request شروع شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1567", "526", "عملیات توسط Async Request کامل شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1568", "527", "عملیات توسط Async Request شروع شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1569", "527", "عملیات توسط Async Request کامل شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1570", "528", "عملیات توسط Async Request شروع شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1571", "528", "عملیات توسط Async Request کامل شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1572", "529", "عملیات توسط Async Request شروع شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1573", "529", "عملیات توسط Async Request کامل شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1574", "530", "عملیات توسط Async Request شروع شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1575", "530", "عملیات توسط Async Request کامل شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1576", "531", "عملیات توسط Async Request شروع شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1577", "531", "عملیات توسط Async Request کامل شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1578", "532", "عملیات توسط Async Request شروع شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1579", "532", "عملیات توسط Async Request کامل شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1580", "533", "عملیات توسط Async Request شروع شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1581", "533", "عملیات توسط Async Request کامل شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1582", "534", "عملیات توسط Async Request شروع شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1583", "534", "عملیات توسط Async Request کامل شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1584", "535", "عملیات توسط Async Request شروع شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1585", "535", "عملیات توسط Async Request کامل شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1586", "536", "عملیات توسط Async Request شروع شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1587", "536", "عملیات توسط Async Request کامل شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1588", "537", "عملیات توسط Async Request شروع شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1589", "537", "عملیات توسط Async Request کامل شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1590", "538", "عملیات توسط Async Request شروع شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1591", "538", "عملیات توسط Async Request کامل شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1592", "539", "عملیات توسط Async Request شروع شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1593", "539", "عملیات توسط Async Request کامل شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1594", "540", "عملیات توسط Async Request شروع شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1595", "540", "عملیات توسط Async Request کامل شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1596", "541", "عملیات توسط Async Request شروع شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1597", "541", "عملیات توسط Async Request کامل شد", "2025-04-20 16:30:01", "2025-04-20 16:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1598", "542", "ایجاد فعالیت", "2025-04-20 16:30:15", "2025-04-20 16:30:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("1599", "543", "ایجاد فعالیت", "2025-04-20 16:30:15", "2025-04-20 16:30:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("1600", "544", "ایجاد فعالیت", "2025-04-20 16:30:15", "2025-04-20 16:30:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("1601", "545", "ایجاد فعالیت", "2025-04-20 16:30:15", "2025-04-20 16:30:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("1602", "546", "ایجاد فعالیت", "2025-04-20 16:30:15", "2025-04-20 16:30:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("1603", "547", "ایجاد فعالیت", "2025-04-20 16:30:15", "2025-04-20 16:30:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("1604", "548", "ایجاد فعالیت", "2025-04-20 16:30:15", "2025-04-20 16:30:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("1605", "549", "ایجاد فعالیت", "2025-04-20 16:30:15", "2025-04-20 16:30:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("1606", "550", "ایجاد فعالیت", "2025-04-20 16:30:15", "2025-04-20 16:30:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("1607", "551", "ایجاد فعالیت", "2025-04-20 16:30:15", "2025-04-20 16:30:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("1608", "552", "ایجاد فعالیت", "2025-04-20 16:30:15", "2025-04-20 16:30:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("1609", "553", "ایجاد فعالیت", "2025-04-20 16:30:15", "2025-04-20 16:30:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("1610", "554", "ایجاد فعالیت", "2025-04-20 16:30:15", "2025-04-20 16:30:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("1611", "555", "ایجاد فعالیت", "2025-04-20 16:30:25", "2025-04-20 16:30:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1612", "556", "ایجاد فعالیت", "2025-04-20 16:30:25", "2025-04-20 16:30:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1613", "557", "ایجاد فعالیت", "2025-04-20 16:30:25", "2025-04-20 16:30:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("1614", "542", "عملیات توسط Async Request شروع شد", "2025-04-20 16:31:06", "2025-04-20 16:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1615", "542", "عملیات توسط Async Request کامل شد", "2025-04-20 16:31:06", "2025-04-20 16:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1616", "543", "عملیات توسط Async Request شروع شد", "2025-04-20 16:31:06", "2025-04-20 16:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1617", "543", "عملیات توسط Async Request کامل شد", "2025-04-20 16:31:06", "2025-04-20 16:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1618", "544", "عملیات توسط Async Request شروع شد", "2025-04-20 16:31:06", "2025-04-20 16:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1619", "544", "عملیات توسط Async Request کامل شد", "2025-04-20 16:31:06", "2025-04-20 16:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1620", "545", "عملیات توسط Async Request شروع شد", "2025-04-20 16:31:06", "2025-04-20 16:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1621", "545", "عملیات توسط Async Request کامل شد", "2025-04-20 16:31:06", "2025-04-20 16:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1622", "546", "عملیات توسط Async Request شروع شد", "2025-04-20 16:31:06", "2025-04-20 16:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1623", "546", "عملیات توسط Async Request کامل شد", "2025-04-20 16:31:06", "2025-04-20 16:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1624", "547", "عملیات توسط Async Request شروع شد", "2025-04-20 16:31:06", "2025-04-20 16:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1625", "547", "عملیات توسط Async Request کامل شد", "2025-04-20 16:31:06", "2025-04-20 16:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1626", "548", "عملیات توسط Async Request شروع شد", "2025-04-20 16:31:06", "2025-04-20 16:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1627", "548", "عملیات توسط Async Request کامل شد", "2025-04-20 16:31:06", "2025-04-20 16:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1628", "549", "عملیات توسط Async Request شروع شد", "2025-04-20 16:31:06", "2025-04-20 16:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1629", "549", "عملیات توسط Async Request کامل شد", "2025-04-20 16:31:06", "2025-04-20 16:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1630", "550", "عملیات توسط Async Request شروع شد", "2025-04-20 16:31:06", "2025-04-20 16:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1631", "550", "عملیات توسط Async Request کامل شد", "2025-04-20 16:31:06", "2025-04-20 16:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1632", "551", "عملیات توسط Async Request شروع شد", "2025-04-20 16:31:06", "2025-04-20 16:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1633", "551", "عملیات توسط Async Request کامل شد", "2025-04-20 16:31:06", "2025-04-20 16:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1634", "552", "عملیات توسط Async Request شروع شد", "2025-04-20 16:31:06", "2025-04-20 16:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1635", "552", "عملیات توسط Async Request کامل شد", "2025-04-20 16:31:06", "2025-04-20 16:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1636", "553", "عملیات توسط Async Request شروع شد", "2025-04-20 16:31:06", "2025-04-20 16:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1637", "553", "عملیات توسط Async Request کامل شد", "2025-04-20 16:31:06", "2025-04-20 16:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1638", "554", "عملیات توسط Async Request شروع شد", "2025-04-20 16:31:06", "2025-04-20 16:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1639", "554", "عملیات توسط Async Request کامل شد", "2025-04-20 16:31:06", "2025-04-20 16:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1640", "555", "عملیات توسط Async Request شروع شد", "2025-04-20 16:31:06", "2025-04-20 16:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1641", "555", "عملیات توسط Async Request کامل شد", "2025-04-20 16:31:06", "2025-04-20 16:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1642", "557", "عملیات توسط Async Request شروع شد", "2025-04-20 16:31:06", "2025-04-20 16:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1643", "557", "عملیات توسط Async Request کامل شد", "2025-04-20 16:31:06", "2025-04-20 16:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1644", "556", "عملیات توسط Async Request شروع شد", "2025-04-20 16:31:06", "2025-04-20 16:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1645", "556", "عملیات توسط Async Request کامل شد", "2025-04-20 16:31:06", "2025-04-20 16:31:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("1646", "558", "ایجاد فعالیت", "2025-04-20 16:31:45", "2025-04-20 16:31:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1647", "559", "ایجاد فعالیت", "2025-04-20 16:31:45", "2025-04-20 16:31:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1648", "560", "ایجاد فعالیت", "2025-04-20 16:31:45", "2025-04-20 16:31:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1649", "561", "ایجاد فعالیت", "2025-04-20 16:31:45", "2025-04-20 16:31:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1650", "562", "ایجاد فعالیت", "2025-04-20 16:31:45", "2025-04-20 16:31:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1651", "563", "ایجاد فعالیت", "2025-04-20 16:31:45", "2025-04-20 16:31:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1652", "564", "ایجاد فعالیت", "2025-04-20 16:31:45", "2025-04-20 16:31:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1653", "565", "ایجاد فعالیت", "2025-04-20 16:31:45", "2025-04-20 16:31:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1654", "566", "ایجاد فعالیت", "2025-04-20 16:31:45", "2025-04-20 16:31:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1655", "567", "ایجاد فعالیت", "2025-04-20 16:31:45", "2025-04-20 16:31:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1656", "568", "ایجاد فعالیت", "2025-04-20 16:31:45", "2025-04-20 16:31:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1657", "569", "ایجاد فعالیت", "2025-04-20 16:31:45", "2025-04-20 16:31:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1658", "570", "ایجاد فعالیت", "2025-04-20 16:31:45", "2025-04-20 16:31:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("1659", "558", "عملیات توسط Async Request شروع شد", "2025-04-20 16:32:17", "2025-04-20 16:32:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1660", "558", "عملیات توسط Async Request کامل شد", "2025-04-20 16:32:17", "2025-04-20 16:32:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1661", "559", "عملیات توسط Async Request شروع شد", "2025-04-20 16:32:17", "2025-04-20 16:32:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1662", "559", "عملیات توسط Async Request کامل شد", "2025-04-20 16:32:17", "2025-04-20 16:32:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1663", "560", "عملیات توسط Async Request شروع شد", "2025-04-20 16:32:17", "2025-04-20 16:32:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1664", "560", "عملیات توسط Async Request کامل شد", "2025-04-20 16:32:17", "2025-04-20 16:32:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1665", "561", "عملیات توسط Async Request شروع شد", "2025-04-20 16:32:17", "2025-04-20 16:32:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1666", "561", "عملیات توسط Async Request کامل شد", "2025-04-20 16:32:17", "2025-04-20 16:32:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1667", "562", "عملیات توسط Async Request شروع شد", "2025-04-20 16:32:17", "2025-04-20 16:32:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1668", "562", "عملیات توسط Async Request کامل شد", "2025-04-20 16:32:17", "2025-04-20 16:32:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1669", "563", "عملیات توسط Async Request شروع شد", "2025-04-20 16:32:17", "2025-04-20 16:32:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1670", "563", "عملیات توسط Async Request کامل شد", "2025-04-20 16:32:17", "2025-04-20 16:32:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1671", "564", "عملیات توسط Async Request شروع شد", "2025-04-20 16:32:17", "2025-04-20 16:32:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1672", "564", "عملیات توسط Async Request کامل شد", "2025-04-20 16:32:17", "2025-04-20 16:32:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1673", "565", "عملیات توسط Async Request شروع شد", "2025-04-20 16:32:17", "2025-04-20 16:32:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1674", "565", "عملیات توسط Async Request کامل شد", "2025-04-20 16:32:17", "2025-04-20 16:32:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1675", "566", "عملیات توسط Async Request شروع شد", "2025-04-20 16:32:17", "2025-04-20 16:32:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1676", "566", "عملیات توسط Async Request کامل شد", "2025-04-20 16:32:17", "2025-04-20 16:32:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1677", "567", "عملیات توسط Async Request شروع شد", "2025-04-20 16:32:17", "2025-04-20 16:32:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1678", "567", "عملیات توسط Async Request کامل شد", "2025-04-20 16:32:17", "2025-04-20 16:32:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1679", "568", "عملیات توسط Async Request شروع شد", "2025-04-20 16:32:17", "2025-04-20 16:32:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1680", "568", "عملیات توسط Async Request کامل شد", "2025-04-20 16:32:17", "2025-04-20 16:32:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1681", "569", "عملیات توسط Async Request شروع شد", "2025-04-20 16:32:17", "2025-04-20 16:32:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1682", "569", "عملیات توسط Async Request کامل شد", "2025-04-20 16:32:17", "2025-04-20 16:32:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1683", "570", "عملیات توسط Async Request شروع شد", "2025-04-20 16:32:17", "2025-04-20 16:32:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1684", "570", "عملیات توسط Async Request کامل شد", "2025-04-20 16:32:17", "2025-04-20 16:32:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("1685", "571", "ایجاد فعالیت", "2025-04-20 16:32:34", "2025-04-20 16:32:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("1686", "572", "ایجاد فعالیت", "2025-04-20 16:32:34", "2025-04-20 16:32:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("1687", "573", "ایجاد فعالیت", "2025-04-20 16:32:34", "2025-04-20 16:32:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("1688", "574", "ایجاد فعالیت", "2025-04-20 16:32:34", "2025-04-20 16:32:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("1689", "575", "ایجاد فعالیت", "2025-04-20 16:32:34", "2025-04-20 16:32:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("1690", "576", "ایجاد فعالیت", "2025-04-20 16:32:34", "2025-04-20 16:32:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("1691", "577", "ایجاد فعالیت", "2025-04-20 16:32:34", "2025-04-20 16:32:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("1692", "578", "ایجاد فعالیت", "2025-04-20 16:32:34", "2025-04-20 16:32:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("1693", "579", "ایجاد فعالیت", "2025-04-20 16:32:35", "2025-04-20 16:32:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1694", "580", "ایجاد فعالیت", "2025-04-20 16:32:35", "2025-04-20 16:32:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1695", "581", "ایجاد فعالیت", "2025-04-20 16:32:35", "2025-04-20 16:32:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1696", "582", "ایجاد فعالیت", "2025-04-20 16:32:35", "2025-04-20 16:32:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1697", "583", "ایجاد فعالیت", "2025-04-20 16:32:35", "2025-04-20 16:32:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1698", "584", "ایجاد فعالیت", "2025-04-20 16:32:39", "2025-04-20 16:32:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("1699", "585", "ایجاد فعالیت", "2025-04-20 16:32:39", "2025-04-20 16:32:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("1700", "586", "ایجاد فعالیت", "2025-04-20 16:32:39", "2025-04-20 16:32:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("1701", "571", "عملیات توسط Async Request شروع شد", "2025-04-20 16:33:22", "2025-04-20 16:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1702", "571", "عملیات توسط Async Request کامل شد", "2025-04-20 16:33:22", "2025-04-20 16:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1703", "572", "عملیات توسط Async Request شروع شد", "2025-04-20 16:33:22", "2025-04-20 16:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1704", "572", "عملیات توسط Async Request کامل شد", "2025-04-20 16:33:22", "2025-04-20 16:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1705", "573", "عملیات توسط Async Request شروع شد", "2025-04-20 16:33:22", "2025-04-20 16:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1706", "573", "عملیات توسط Async Request کامل شد", "2025-04-20 16:33:22", "2025-04-20 16:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1707", "574", "عملیات توسط Async Request شروع شد", "2025-04-20 16:33:22", "2025-04-20 16:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1708", "574", "عملیات توسط Async Request کامل شد", "2025-04-20 16:33:22", "2025-04-20 16:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1709", "575", "عملیات توسط Async Request شروع شد", "2025-04-20 16:33:22", "2025-04-20 16:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1710", "575", "عملیات توسط Async Request کامل شد", "2025-04-20 16:33:22", "2025-04-20 16:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1711", "576", "عملیات توسط Async Request شروع شد", "2025-04-20 16:33:22", "2025-04-20 16:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1712", "576", "عملیات توسط Async Request کامل شد", "2025-04-20 16:33:22", "2025-04-20 16:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1713", "577", "عملیات توسط Async Request شروع شد", "2025-04-20 16:33:22", "2025-04-20 16:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1714", "577", "عملیات توسط Async Request کامل شد", "2025-04-20 16:33:22", "2025-04-20 16:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1715", "578", "عملیات توسط Async Request شروع شد", "2025-04-20 16:33:22", "2025-04-20 16:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1716", "578", "عملیات توسط Async Request کامل شد", "2025-04-20 16:33:22", "2025-04-20 16:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1717", "579", "عملیات توسط Async Request شروع شد", "2025-04-20 16:33:22", "2025-04-20 16:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1718", "579", "عملیات توسط Async Request کامل شد", "2025-04-20 16:33:22", "2025-04-20 16:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1719", "580", "عملیات توسط Async Request شروع شد", "2025-04-20 16:33:22", "2025-04-20 16:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1720", "580", "عملیات توسط Async Request کامل شد", "2025-04-20 16:33:22", "2025-04-20 16:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1721", "581", "عملیات توسط Async Request شروع شد", "2025-04-20 16:33:22", "2025-04-20 16:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1722", "581", "عملیات توسط Async Request کامل شد", "2025-04-20 16:33:22", "2025-04-20 16:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1723", "582", "عملیات توسط Async Request شروع شد", "2025-04-20 16:33:22", "2025-04-20 16:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1724", "582", "عملیات توسط Async Request کامل شد", "2025-04-20 16:33:22", "2025-04-20 16:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1725", "583", "عملیات توسط Async Request شروع شد", "2025-04-20 16:33:22", "2025-04-20 16:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1726", "583", "عملیات توسط Async Request کامل شد", "2025-04-20 16:33:22", "2025-04-20 16:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1727", "584", "عملیات توسط Async Request شروع شد", "2025-04-20 16:33:22", "2025-04-20 16:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1728", "584", "عملیات توسط Async Request کامل شد", "2025-04-20 16:33:22", "2025-04-20 16:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1729", "586", "عملیات توسط Async Request شروع شد", "2025-04-20 16:33:22", "2025-04-20 16:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1730", "586", "عملیات توسط Async Request کامل شد", "2025-04-20 16:33:22", "2025-04-20 16:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1731", "585", "عملیات توسط Async Request شروع شد", "2025-04-20 16:33:22", "2025-04-20 16:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1732", "585", "عملیات توسط Async Request کامل شد", "2025-04-20 16:33:22", "2025-04-20 16:33:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("1733", "587", "ایجاد فعالیت", "2025-04-20 17:24:31", "2025-04-20 17:24:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1734", "587", "عملیات توسط Async Request شروع شد", "2025-04-20 17:24:32", "2025-04-20 17:24:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1735", "587", "عملیات توسط Async Request کامل شد", "2025-04-20 17:24:32", "2025-04-20 17:24:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("1736", "588", "ایجاد فعالیت", "2025-04-20 17:50:27", "2025-04-20 17:50:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1737", "589", "ایجاد فعالیت", "2025-04-20 17:50:27", "2025-04-20 17:50:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1738", "590", "ایجاد فعالیت", "2025-04-20 17:50:27", "2025-04-20 17:50:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1739", "591", "ایجاد فعالیت", "2025-04-20 17:50:27", "2025-04-20 17:50:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1740", "592", "ایجاد فعالیت", "2025-04-20 17:50:27", "2025-04-20 17:50:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1741", "593", "ایجاد فعالیت", "2025-04-20 17:50:27", "2025-04-20 17:50:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1742", "594", "ایجاد فعالیت", "2025-04-20 17:50:27", "2025-04-20 17:50:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1743", "595", "ایجاد فعالیت", "2025-04-20 17:50:27", "2025-04-20 17:50:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1744", "596", "ایجاد فعالیت", "2025-04-20 17:50:27", "2025-04-20 17:50:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1745", "597", "ایجاد فعالیت", "2025-04-20 17:50:27", "2025-04-20 17:50:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1746", "598", "ایجاد فعالیت", "2025-04-20 17:50:27", "2025-04-20 17:50:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1747", "599", "ایجاد فعالیت", "2025-04-20 17:50:27", "2025-04-20 17:50:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("1748", "588", "عملیات توسط Async Request شروع شد", "2025-04-20 17:50:28", "2025-04-20 17:50:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1749", "588", "عملیات توسط Async Request کامل شد", "2025-04-20 17:50:28", "2025-04-20 17:50:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1750", "589", "عملیات توسط Async Request شروع شد", "2025-04-20 17:50:28", "2025-04-20 17:50:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1751", "589", "عملیات توسط Async Request کامل شد", "2025-04-20 17:50:28", "2025-04-20 17:50:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1752", "590", "عملیات توسط Async Request شروع شد", "2025-04-20 17:50:28", "2025-04-20 17:50:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1753", "590", "عملیات توسط Async Request کامل شد", "2025-04-20 17:50:28", "2025-04-20 17:50:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1754", "591", "عملیات توسط Async Request شروع شد", "2025-04-20 17:50:28", "2025-04-20 17:50:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1755", "591", "عملیات توسط Async Request کامل شد", "2025-04-20 17:50:28", "2025-04-20 17:50:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1756", "592", "عملیات توسط Async Request شروع شد", "2025-04-20 17:50:28", "2025-04-20 17:50:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1757", "592", "عملیات توسط Async Request کامل شد", "2025-04-20 17:50:28", "2025-04-20 17:50:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1758", "593", "عملیات توسط Async Request شروع شد", "2025-04-20 17:50:28", "2025-04-20 17:50:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1759", "593", "عملیات توسط Async Request کامل شد", "2025-04-20 17:50:28", "2025-04-20 17:50:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1760", "594", "عملیات توسط Async Request شروع شد", "2025-04-20 17:50:28", "2025-04-20 17:50:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1761", "594", "عملیات توسط Async Request کامل شد", "2025-04-20 17:50:28", "2025-04-20 17:50:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1762", "595", "عملیات توسط Async Request شروع شد", "2025-04-20 17:50:28", "2025-04-20 17:50:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1763", "595", "عملیات توسط Async Request کامل شد", "2025-04-20 17:50:28", "2025-04-20 17:50:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1764", "596", "عملیات توسط Async Request شروع شد", "2025-04-20 17:50:28", "2025-04-20 17:50:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1765", "596", "عملیات توسط Async Request کامل شد", "2025-04-20 17:50:28", "2025-04-20 17:50:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1766", "597", "عملیات توسط Async Request شروع شد", "2025-04-20 17:50:28", "2025-04-20 17:50:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1767", "597", "عملیات توسط Async Request کامل شد", "2025-04-20 17:50:28", "2025-04-20 17:50:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1768", "598", "عملیات توسط Async Request شروع شد", "2025-04-20 17:50:28", "2025-04-20 17:50:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1769", "598", "عملیات توسط Async Request کامل شد", "2025-04-20 17:50:28", "2025-04-20 17:50:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1770", "599", "عملیات توسط Async Request شروع شد", "2025-04-20 17:50:28", "2025-04-20 17:50:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1771", "599", "عملیات توسط Async Request کامل شد", "2025-04-20 17:50:28", "2025-04-20 17:50:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("1772", "600", "ایجاد فعالیت", "2025-04-20 17:50:30", "2025-04-20 17:50:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1773", "601", "ایجاد فعالیت", "2025-04-20 17:50:30", "2025-04-20 17:50:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1774", "602", "ایجاد فعالیت", "2025-04-20 17:50:30", "2025-04-20 17:50:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1775", "603", "ایجاد فعالیت", "2025-04-20 17:50:30", "2025-04-20 17:50:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1776", "604", "ایجاد فعالیت", "2025-04-20 17:50:30", "2025-04-20 17:50:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1777", "605", "ایجاد فعالیت", "2025-04-20 17:50:30", "2025-04-20 17:50:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1778", "606", "ایجاد فعالیت", "2025-04-20 17:50:30", "2025-04-20 17:50:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1779", "607", "ایجاد فعالیت", "2025-04-20 17:50:30", "2025-04-20 17:50:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1780", "608", "ایجاد فعالیت", "2025-04-20 17:50:30", "2025-04-20 17:50:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1781", "609", "ایجاد فعالیت", "2025-04-20 17:50:30", "2025-04-20 17:50:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1782", "610", "ایجاد فعالیت", "2025-04-20 17:50:30", "2025-04-20 17:50:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1783", "611", "ایجاد فعالیت", "2025-04-20 17:50:30", "2025-04-20 17:50:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1784", "612", "ایجاد فعالیت", "2025-04-20 17:50:30", "2025-04-20 17:50:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("1785", "600", "عملیات توسط Async Request شروع شد", "2025-04-20 17:50:35", "2025-04-20 17:50:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1786", "600", "عملیات توسط Async Request کامل شد", "2025-04-20 17:50:35", "2025-04-20 17:50:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1787", "602", "عملیات توسط Async Request شروع شد", "2025-04-20 17:50:35", "2025-04-20 17:50:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1788", "602", "عملیات توسط Async Request کامل شد", "2025-04-20 17:50:35", "2025-04-20 17:50:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1789", "604", "عملیات توسط Async Request شروع شد", "2025-04-20 17:50:35", "2025-04-20 17:50:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1790", "604", "عملیات توسط Async Request کامل شد", "2025-04-20 17:50:35", "2025-04-20 17:50:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1791", "606", "عملیات توسط Async Request شروع شد", "2025-04-20 17:50:35", "2025-04-20 17:50:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1792", "606", "عملیات توسط Async Request کامل شد", "2025-04-20 17:50:35", "2025-04-20 17:50:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1793", "608", "عملیات توسط Async Request شروع شد", "2025-04-20 17:50:35", "2025-04-20 17:50:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1794", "608", "عملیات توسط Async Request کامل شد", "2025-04-20 17:50:35", "2025-04-20 17:50:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1795", "610", "عملیات توسط Async Request شروع شد", "2025-04-20 17:50:35", "2025-04-20 17:50:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1796", "610", "عملیات توسط Async Request کامل شد", "2025-04-20 17:50:35", "2025-04-20 17:50:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1797", "612", "عملیات توسط Async Request شروع شد", "2025-04-20 17:50:35", "2025-04-20 17:50:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1798", "612", "عملیات توسط Async Request کامل شد", "2025-04-20 17:50:35", "2025-04-20 17:50:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1799", "601", "عملیات توسط Async Request شروع شد", "2025-04-20 17:50:35", "2025-04-20 17:50:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1800", "601", "عملیات توسط Async Request کامل شد", "2025-04-20 17:50:35", "2025-04-20 17:50:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1801", "603", "عملیات توسط Async Request شروع شد", "2025-04-20 17:50:35", "2025-04-20 17:50:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1802", "603", "عملیات توسط Async Request کامل شد", "2025-04-20 17:50:35", "2025-04-20 17:50:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1803", "605", "عملیات توسط Async Request شروع شد", "2025-04-20 17:50:35", "2025-04-20 17:50:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1804", "605", "عملیات توسط Async Request کامل شد", "2025-04-20 17:50:35", "2025-04-20 17:50:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1805", "607", "عملیات توسط Async Request شروع شد", "2025-04-20 17:50:35", "2025-04-20 17:50:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1806", "607", "عملیات توسط Async Request کامل شد", "2025-04-20 17:50:35", "2025-04-20 17:50:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1807", "609", "عملیات توسط Async Request شروع شد", "2025-04-20 17:50:35", "2025-04-20 17:50:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1808", "609", "عملیات توسط Async Request کامل شد", "2025-04-20 17:50:35", "2025-04-20 17:50:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1809", "611", "عملیات توسط Async Request شروع شد", "2025-04-20 17:50:35", "2025-04-20 17:50:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1810", "611", "عملیات توسط Async Request کامل شد", "2025-04-20 17:50:35", "2025-04-20 17:50:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("1811", "613", "ایجاد فعالیت", "2025-04-20 17:51:29", "2025-04-20 17:51:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1812", "614", "ایجاد فعالیت", "2025-04-20 17:51:29", "2025-04-20 17:51:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("1813", "613", "عملیات توسط Async Request شروع شد", "2025-04-20 17:51:31", "2025-04-20 17:51:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1814", "613", "عملیات توسط Async Request کامل شد", "2025-04-20 17:51:31", "2025-04-20 17:51:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1815", "614", "عملیات توسط Async Request شروع شد", "2025-04-20 17:51:31", "2025-04-20 17:51:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1816", "614", "عملیات توسط Async Request کامل شد", "2025-04-20 17:51:31", "2025-04-20 17:51:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("1817", "615", "ایجاد فعالیت", "2025-04-20 18:36:01", "2025-04-20 18:36:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1818", "615", "عملیات توسط Async Request شروع شد", "2025-04-20 18:36:03", "2025-04-20 18:36:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1819", "615", "عملیات توسط Async Request کامل شد", "2025-04-20 18:36:03", "2025-04-20 18:36:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("1820", "616", "ایجاد فعالیت", "2025-04-20 19:30:55", "2025-04-20 19:30:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1821", "617", "ایجاد فعالیت", "2025-04-20 19:30:55", "2025-04-20 19:30:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1822", "618", "ایجاد فعالیت", "2025-04-20 19:30:55", "2025-04-20 19:30:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1823", "619", "ایجاد فعالیت", "2025-04-20 19:30:55", "2025-04-20 19:30:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1824", "620", "ایجاد فعالیت", "2025-04-20 19:30:55", "2025-04-20 19:30:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1825", "621", "ایجاد فعالیت", "2025-04-20 19:30:55", "2025-04-20 19:30:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1826", "622", "ایجاد فعالیت", "2025-04-20 19:30:55", "2025-04-20 19:30:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1827", "623", "ایجاد فعالیت", "2025-04-20 19:30:55", "2025-04-20 19:30:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1828", "624", "ایجاد فعالیت", "2025-04-20 19:30:55", "2025-04-20 19:30:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1829", "625", "ایجاد فعالیت", "2025-04-20 19:30:55", "2025-04-20 19:30:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1830", "626", "ایجاد فعالیت", "2025-04-20 19:30:55", "2025-04-20 19:30:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1831", "627", "ایجاد فعالیت", "2025-04-20 19:30:55", "2025-04-20 19:30:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1832", "628", "ایجاد فعالیت", "2025-04-20 19:30:55", "2025-04-20 19:30:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("1833", "616", "عملیات توسط Async Request شروع شد", "2025-04-20 19:31:26", "2025-04-20 19:31:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1834", "616", "عملیات توسط Async Request کامل شد", "2025-04-20 19:31:26", "2025-04-20 19:31:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1835", "618", "عملیات توسط Async Request شروع شد", "2025-04-20 19:31:26", "2025-04-20 19:31:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1836", "618", "عملیات توسط Async Request کامل شد", "2025-04-20 19:31:26", "2025-04-20 19:31:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1837", "620", "عملیات توسط Async Request شروع شد", "2025-04-20 19:31:26", "2025-04-20 19:31:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1838", "620", "عملیات توسط Async Request کامل شد", "2025-04-20 19:31:26", "2025-04-20 19:31:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1839", "622", "عملیات توسط Async Request شروع شد", "2025-04-20 19:31:26", "2025-04-20 19:31:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1840", "622", "عملیات توسط Async Request کامل شد", "2025-04-20 19:31:26", "2025-04-20 19:31:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1841", "624", "عملیات توسط Async Request شروع شد", "2025-04-20 19:31:26", "2025-04-20 19:31:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1842", "624", "عملیات توسط Async Request کامل شد", "2025-04-20 19:31:26", "2025-04-20 19:31:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1843", "626", "عملیات توسط Async Request شروع شد", "2025-04-20 19:31:26", "2025-04-20 19:31:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1844", "626", "عملیات توسط Async Request کامل شد", "2025-04-20 19:31:26", "2025-04-20 19:31:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1845", "628", "عملیات توسط Async Request شروع شد", "2025-04-20 19:31:26", "2025-04-20 19:31:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1846", "628", "عملیات توسط Async Request کامل شد", "2025-04-20 19:31:26", "2025-04-20 19:31:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1847", "617", "عملیات توسط Async Request شروع شد", "2025-04-20 19:31:26", "2025-04-20 19:31:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1848", "617", "عملیات توسط Async Request کامل شد", "2025-04-20 19:31:26", "2025-04-20 19:31:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1849", "619", "عملیات توسط Async Request شروع شد", "2025-04-20 19:31:26", "2025-04-20 19:31:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1850", "619", "عملیات توسط Async Request کامل شد", "2025-04-20 19:31:26", "2025-04-20 19:31:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1851", "621", "عملیات توسط Async Request شروع شد", "2025-04-20 19:31:26", "2025-04-20 19:31:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1852", "621", "عملیات توسط Async Request کامل شد", "2025-04-20 19:31:26", "2025-04-20 19:31:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1853", "623", "عملیات توسط Async Request شروع شد", "2025-04-20 19:31:26", "2025-04-20 19:31:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1854", "623", "عملیات توسط Async Request کامل شد", "2025-04-20 19:31:26", "2025-04-20 19:31:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1855", "625", "عملیات توسط Async Request شروع شد", "2025-04-20 19:31:26", "2025-04-20 19:31:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1856", "625", "عملیات توسط Async Request کامل شد", "2025-04-20 19:31:26", "2025-04-20 19:31:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1857", "627", "عملیات توسط Async Request شروع شد", "2025-04-20 19:31:26", "2025-04-20 19:31:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1858", "627", "عملیات توسط Async Request کامل شد", "2025-04-20 19:31:26", "2025-04-20 19:31:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("1859", "629", "ایجاد فعالیت", "2025-04-20 19:32:40", "2025-04-20 19:32:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1860", "630", "ایجاد فعالیت", "2025-04-20 19:32:40", "2025-04-20 19:32:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1861", "631", "ایجاد فعالیت", "2025-04-20 19:32:40", "2025-04-20 19:32:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1862", "632", "ایجاد فعالیت", "2025-04-20 19:32:40", "2025-04-20 19:32:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1863", "633", "ایجاد فعالیت", "2025-04-20 19:32:40", "2025-04-20 19:32:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1864", "634", "ایجاد فعالیت", "2025-04-20 19:32:40", "2025-04-20 19:32:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1865", "635", "ایجاد فعالیت", "2025-04-20 19:32:40", "2025-04-20 19:32:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1866", "636", "ایجاد فعالیت", "2025-04-20 19:32:40", "2025-04-20 19:32:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1867", "637", "ایجاد فعالیت", "2025-04-20 19:32:40", "2025-04-20 19:32:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1868", "638", "ایجاد فعالیت", "2025-04-20 19:32:40", "2025-04-20 19:32:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1869", "639", "ایجاد فعالیت", "2025-04-20 19:32:40", "2025-04-20 19:32:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1870", "640", "ایجاد فعالیت", "2025-04-20 19:32:40", "2025-04-20 19:32:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1871", "641", "ایجاد فعالیت", "2025-04-20 19:32:40", "2025-04-20 19:32:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("1872", "642", "ایجاد فعالیت", "2025-04-20 19:34:01", "2025-04-20 19:34:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1873", "643", "ایجاد فعالیت", "2025-04-20 19:34:01", "2025-04-20 19:34:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1874", "644", "ایجاد فعالیت", "2025-04-20 19:34:01", "2025-04-20 19:34:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("1875", "629", "عملیات توسط Async Request شروع شد", "2025-04-20 19:34:02", "2025-04-20 19:34:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1876", "629", "عملیات توسط Async Request کامل شد", "2025-04-20 19:34:02", "2025-04-20 19:34:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1877", "631", "عملیات توسط Async Request شروع شد", "2025-04-20 19:34:02", "2025-04-20 19:34:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1878", "631", "عملیات توسط Async Request کامل شد", "2025-04-20 19:34:02", "2025-04-20 19:34:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1879", "633", "عملیات توسط Async Request شروع شد", "2025-04-20 19:34:02", "2025-04-20 19:34:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1880", "633", "عملیات توسط Async Request کامل شد", "2025-04-20 19:34:02", "2025-04-20 19:34:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1881", "635", "عملیات توسط Async Request شروع شد", "2025-04-20 19:34:02", "2025-04-20 19:34:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1882", "635", "عملیات توسط Async Request کامل شد", "2025-04-20 19:34:02", "2025-04-20 19:34:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1883", "637", "عملیات توسط Async Request شروع شد", "2025-04-20 19:34:02", "2025-04-20 19:34:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1884", "637", "عملیات توسط Async Request کامل شد", "2025-04-20 19:34:02", "2025-04-20 19:34:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1885", "639", "عملیات توسط Async Request شروع شد", "2025-04-20 19:34:02", "2025-04-20 19:34:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1886", "639", "عملیات توسط Async Request کامل شد", "2025-04-20 19:34:02", "2025-04-20 19:34:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1887", "641", "عملیات توسط Async Request شروع شد", "2025-04-20 19:34:02", "2025-04-20 19:34:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1888", "641", "عملیات توسط Async Request کامل شد", "2025-04-20 19:34:02", "2025-04-20 19:34:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1889", "630", "عملیات توسط Async Request شروع شد", "2025-04-20 19:34:02", "2025-04-20 19:34:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1890", "630", "عملیات توسط Async Request کامل شد", "2025-04-20 19:34:02", "2025-04-20 19:34:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1891", "632", "عملیات توسط Async Request شروع شد", "2025-04-20 19:34:02", "2025-04-20 19:34:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1892", "632", "عملیات توسط Async Request کامل شد", "2025-04-20 19:34:02", "2025-04-20 19:34:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1893", "634", "عملیات توسط Async Request شروع شد", "2025-04-20 19:34:02", "2025-04-20 19:34:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1894", "634", "عملیات توسط Async Request کامل شد", "2025-04-20 19:34:02", "2025-04-20 19:34:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1895", "636", "عملیات توسط Async Request شروع شد", "2025-04-20 19:34:02", "2025-04-20 19:34:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1896", "636", "عملیات توسط Async Request کامل شد", "2025-04-20 19:34:02", "2025-04-20 19:34:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1897", "638", "عملیات توسط Async Request شروع شد", "2025-04-20 19:34:02", "2025-04-20 19:34:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1898", "638", "عملیات توسط Async Request کامل شد", "2025-04-20 19:34:02", "2025-04-20 19:34:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1899", "640", "عملیات توسط Async Request شروع شد", "2025-04-20 19:34:02", "2025-04-20 19:34:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1900", "640", "عملیات توسط Async Request کامل شد", "2025-04-20 19:34:02", "2025-04-20 19:34:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1901", "642", "عملیات توسط Async Request شروع شد", "2025-04-20 19:34:02", "2025-04-20 19:34:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1902", "642", "عملیات توسط Async Request کامل شد", "2025-04-20 19:34:02", "2025-04-20 19:34:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1903", "644", "عملیات توسط Async Request شروع شد", "2025-04-20 19:34:02", "2025-04-20 19:34:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1904", "644", "عملیات توسط Async Request کامل شد", "2025-04-20 19:34:02", "2025-04-20 19:34:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1905", "643", "عملیات توسط Async Request شروع شد", "2025-04-20 19:34:02", "2025-04-20 19:34:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1906", "643", "عملیات توسط Async Request کامل شد", "2025-04-20 19:34:02", "2025-04-20 19:34:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("1907", "645", "ایجاد فعالیت", "2025-04-20 19:36:07", "2025-04-20 19:36:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("1908", "645", "عملیات توسط Async Request شروع شد", "2025-04-20 19:37:09", "2025-04-20 19:37:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1909", "645", "عملیات توسط Async Request کامل شد", "2025-04-20 19:37:09", "2025-04-20 19:37:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("1910", "646", "ایجاد فعالیت", "2025-04-20 19:39:10", "2025-04-20 19:39:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1911", "647", "ایجاد فعالیت", "2025-04-20 19:39:10", "2025-04-20 19:39:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1912", "648", "ایجاد فعالیت", "2025-04-20 19:39:10", "2025-04-20 19:39:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1913", "649", "ایجاد فعالیت", "2025-04-20 19:39:10", "2025-04-20 19:39:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1914", "650", "ایجاد فعالیت", "2025-04-20 19:39:10", "2025-04-20 19:39:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1915", "651", "ایجاد فعالیت", "2025-04-20 19:39:10", "2025-04-20 19:39:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1916", "652", "ایجاد فعالیت", "2025-04-20 19:39:10", "2025-04-20 19:39:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1917", "653", "ایجاد فعالیت", "2025-04-20 19:39:10", "2025-04-20 19:39:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1918", "654", "ایجاد فعالیت", "2025-04-20 19:39:10", "2025-04-20 19:39:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1919", "655", "ایجاد فعالیت", "2025-04-20 19:39:10", "2025-04-20 19:39:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1920", "656", "ایجاد فعالیت", "2025-04-20 19:39:10", "2025-04-20 19:39:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1921", "657", "ایجاد فعالیت", "2025-04-20 19:39:10", "2025-04-20 19:39:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1922", "658", "ایجاد فعالیت", "2025-04-20 19:39:10", "2025-04-20 19:39:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("1923", "646", "عملیات توسط Async Request شروع شد", "2025-04-20 19:39:12", "2025-04-20 19:39:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1924", "646", "عملیات توسط Async Request کامل شد", "2025-04-20 19:39:12", "2025-04-20 19:39:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1925", "648", "عملیات توسط Async Request شروع شد", "2025-04-20 19:39:12", "2025-04-20 19:39:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1926", "648", "عملیات توسط Async Request کامل شد", "2025-04-20 19:39:12", "2025-04-20 19:39:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1927", "650", "عملیات توسط Async Request شروع شد", "2025-04-20 19:39:12", "2025-04-20 19:39:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1928", "650", "عملیات توسط Async Request کامل شد", "2025-04-20 19:39:12", "2025-04-20 19:39:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1929", "652", "عملیات توسط Async Request شروع شد", "2025-04-20 19:39:12", "2025-04-20 19:39:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1930", "652", "عملیات توسط Async Request کامل شد", "2025-04-20 19:39:12", "2025-04-20 19:39:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1931", "654", "عملیات توسط Async Request شروع شد", "2025-04-20 19:39:12", "2025-04-20 19:39:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1932", "654", "عملیات توسط Async Request کامل شد", "2025-04-20 19:39:12", "2025-04-20 19:39:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1933", "656", "عملیات توسط Async Request شروع شد", "2025-04-20 19:39:12", "2025-04-20 19:39:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1934", "656", "عملیات توسط Async Request کامل شد", "2025-04-20 19:39:12", "2025-04-20 19:39:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1935", "658", "عملیات توسط Async Request شروع شد", "2025-04-20 19:39:12", "2025-04-20 19:39:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1936", "658", "عملیات توسط Async Request کامل شد", "2025-04-20 19:39:12", "2025-04-20 19:39:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1937", "647", "عملیات توسط Async Request شروع شد", "2025-04-20 19:39:12", "2025-04-20 19:39:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1938", "647", "عملیات توسط Async Request کامل شد", "2025-04-20 19:39:12", "2025-04-20 19:39:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1939", "649", "عملیات توسط Async Request شروع شد", "2025-04-20 19:39:12", "2025-04-20 19:39:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1940", "649", "عملیات توسط Async Request کامل شد", "2025-04-20 19:39:12", "2025-04-20 19:39:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1941", "651", "عملیات توسط Async Request شروع شد", "2025-04-20 19:39:12", "2025-04-20 19:39:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1942", "651", "عملیات توسط Async Request کامل شد", "2025-04-20 19:39:12", "2025-04-20 19:39:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1943", "653", "عملیات توسط Async Request شروع شد", "2025-04-20 19:39:12", "2025-04-20 19:39:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1944", "653", "عملیات توسط Async Request کامل شد", "2025-04-20 19:39:12", "2025-04-20 19:39:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1945", "655", "عملیات توسط Async Request شروع شد", "2025-04-20 19:39:12", "2025-04-20 19:39:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1946", "655", "عملیات توسط Async Request کامل شد", "2025-04-20 19:39:12", "2025-04-20 19:39:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1947", "657", "عملیات توسط Async Request شروع شد", "2025-04-20 19:39:12", "2025-04-20 19:39:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1948", "657", "عملیات توسط Async Request کامل شد", "2025-04-20 19:39:12", "2025-04-20 19:39:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("1949", "659", "ایجاد فعالیت", "2025-04-20 19:46:52", "2025-04-20 19:46:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1950", "660", "ایجاد فعالیت", "2025-04-20 19:46:52", "2025-04-20 19:46:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1951", "661", "ایجاد فعالیت", "2025-04-20 19:46:52", "2025-04-20 19:46:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1952", "662", "ایجاد فعالیت", "2025-04-20 19:46:52", "2025-04-20 19:46:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1953", "663", "ایجاد فعالیت", "2025-04-20 19:46:52", "2025-04-20 19:46:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1954", "664", "ایجاد فعالیت", "2025-04-20 19:46:52", "2025-04-20 19:46:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1955", "665", "ایجاد فعالیت", "2025-04-20 19:46:52", "2025-04-20 19:46:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1956", "666", "ایجاد فعالیت", "2025-04-20 19:46:52", "2025-04-20 19:46:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1957", "667", "ایجاد فعالیت", "2025-04-20 19:46:52", "2025-04-20 19:46:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1958", "668", "ایجاد فعالیت", "2025-04-20 19:46:52", "2025-04-20 19:46:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1959", "669", "ایجاد فعالیت", "2025-04-20 19:46:52", "2025-04-20 19:46:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1960", "670", "ایجاد فعالیت", "2025-04-20 19:46:52", "2025-04-20 19:46:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1961", "671", "ایجاد فعالیت", "2025-04-20 19:46:52", "2025-04-20 19:46:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1962", "659", "عملیات توسط Async Request شروع شد", "2025-04-20 19:46:53", "2025-04-20 19:46:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1963", "659", "عملیات توسط Async Request کامل شد", "2025-04-20 19:46:53", "2025-04-20 19:46:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1964", "661", "عملیات توسط Async Request شروع شد", "2025-04-20 19:46:53", "2025-04-20 19:46:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1965", "661", "عملیات توسط Async Request کامل شد", "2025-04-20 19:46:53", "2025-04-20 19:46:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1966", "663", "عملیات توسط Async Request شروع شد", "2025-04-20 19:46:53", "2025-04-20 19:46:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1967", "663", "عملیات توسط Async Request کامل شد", "2025-04-20 19:46:53", "2025-04-20 19:46:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1968", "665", "عملیات توسط Async Request شروع شد", "2025-04-20 19:46:53", "2025-04-20 19:46:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1969", "665", "عملیات توسط Async Request کامل شد", "2025-04-20 19:46:53", "2025-04-20 19:46:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1970", "667", "عملیات توسط Async Request شروع شد", "2025-04-20 19:46:53", "2025-04-20 19:46:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1971", "667", "عملیات توسط Async Request کامل شد", "2025-04-20 19:46:53", "2025-04-20 19:46:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1972", "669", "عملیات توسط Async Request شروع شد", "2025-04-20 19:46:53", "2025-04-20 19:46:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1973", "669", "عملیات توسط Async Request کامل شد", "2025-04-20 19:46:53", "2025-04-20 19:46:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1974", "671", "عملیات توسط Async Request شروع شد", "2025-04-20 19:46:53", "2025-04-20 19:46:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1975", "671", "عملیات توسط Async Request کامل شد", "2025-04-20 19:46:53", "2025-04-20 19:46:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1976", "660", "عملیات توسط Async Request شروع شد", "2025-04-20 19:46:53", "2025-04-20 19:46:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1977", "660", "عملیات توسط Async Request کامل شد", "2025-04-20 19:46:53", "2025-04-20 19:46:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1978", "662", "عملیات توسط Async Request شروع شد", "2025-04-20 19:46:53", "2025-04-20 19:46:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1979", "662", "عملیات توسط Async Request کامل شد", "2025-04-20 19:46:53", "2025-04-20 19:46:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1980", "664", "عملیات توسط Async Request شروع شد", "2025-04-20 19:46:53", "2025-04-20 19:46:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1981", "664", "عملیات توسط Async Request کامل شد", "2025-04-20 19:46:53", "2025-04-20 19:46:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1982", "666", "عملیات توسط Async Request شروع شد", "2025-04-20 19:46:53", "2025-04-20 19:46:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1983", "666", "عملیات توسط Async Request کامل شد", "2025-04-20 19:46:53", "2025-04-20 19:46:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1984", "668", "عملیات توسط Async Request شروع شد", "2025-04-20 19:46:53", "2025-04-20 19:46:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1985", "668", "عملیات توسط Async Request کامل شد", "2025-04-20 19:46:53", "2025-04-20 19:46:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1986", "670", "عملیات توسط Async Request شروع شد", "2025-04-20 19:46:53", "2025-04-20 19:46:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1987", "670", "عملیات توسط Async Request کامل شد", "2025-04-20 19:46:53", "2025-04-20 19:46:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("1988", "672", "ایجاد فعالیت", "2025-04-20 19:48:52", "2025-04-20 19:48:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1989", "673", "ایجاد فعالیت", "2025-04-20 19:48:52", "2025-04-20 19:48:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1990", "674", "ایجاد فعالیت", "2025-04-20 19:48:52", "2025-04-20 19:48:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1991", "675", "ایجاد فعالیت", "2025-04-20 19:48:52", "2025-04-20 19:48:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1992", "676", "ایجاد فعالیت", "2025-04-20 19:48:52", "2025-04-20 19:48:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1993", "677", "ایجاد فعالیت", "2025-04-20 19:48:52", "2025-04-20 19:48:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1994", "678", "ایجاد فعالیت", "2025-04-20 19:48:52", "2025-04-20 19:48:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1995", "679", "ایجاد فعالیت", "2025-04-20 19:48:52", "2025-04-20 19:48:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1996", "680", "ایجاد فعالیت", "2025-04-20 19:48:52", "2025-04-20 19:48:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1997", "681", "ایجاد فعالیت", "2025-04-20 19:48:52", "2025-04-20 19:48:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1998", "682", "ایجاد فعالیت", "2025-04-20 19:48:52", "2025-04-20 19:48:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("1999", "683", "ایجاد فعالیت", "2025-04-20 19:48:52", "2025-04-20 19:48:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("2000", "684", "ایجاد فعالیت", "2025-04-20 19:48:52", "2025-04-20 19:48:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("2001", "672", "عملیات توسط Async Request شروع شد", "2025-04-20 19:50:04", "2025-04-20 19:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2002", "672", "عملیات توسط Async Request کامل شد", "2025-04-20 19:50:04", "2025-04-20 19:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2003", "674", "عملیات توسط Async Request شروع شد", "2025-04-20 19:50:04", "2025-04-20 19:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2004", "674", "عملیات توسط Async Request کامل شد", "2025-04-20 19:50:04", "2025-04-20 19:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2005", "676", "عملیات توسط Async Request شروع شد", "2025-04-20 19:50:04", "2025-04-20 19:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2006", "676", "عملیات توسط Async Request کامل شد", "2025-04-20 19:50:04", "2025-04-20 19:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2007", "678", "عملیات توسط Async Request شروع شد", "2025-04-20 19:50:04", "2025-04-20 19:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2008", "678", "عملیات توسط Async Request کامل شد", "2025-04-20 19:50:04", "2025-04-20 19:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2009", "680", "عملیات توسط Async Request شروع شد", "2025-04-20 19:50:04", "2025-04-20 19:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2010", "680", "عملیات توسط Async Request کامل شد", "2025-04-20 19:50:04", "2025-04-20 19:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2011", "682", "عملیات توسط Async Request شروع شد", "2025-04-20 19:50:04", "2025-04-20 19:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2012", "682", "عملیات توسط Async Request کامل شد", "2025-04-20 19:50:04", "2025-04-20 19:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2013", "684", "عملیات توسط Async Request شروع شد", "2025-04-20 19:50:04", "2025-04-20 19:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2014", "684", "عملیات توسط Async Request کامل شد", "2025-04-20 19:50:04", "2025-04-20 19:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2015", "673", "عملیات توسط Async Request شروع شد", "2025-04-20 19:50:04", "2025-04-20 19:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2016", "673", "عملیات توسط Async Request کامل شد", "2025-04-20 19:50:04", "2025-04-20 19:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2017", "675", "عملیات توسط Async Request شروع شد", "2025-04-20 19:50:04", "2025-04-20 19:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2018", "675", "عملیات توسط Async Request کامل شد", "2025-04-20 19:50:04", "2025-04-20 19:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2019", "677", "عملیات توسط Async Request شروع شد", "2025-04-20 19:50:04", "2025-04-20 19:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2020", "677", "عملیات توسط Async Request کامل شد", "2025-04-20 19:50:04", "2025-04-20 19:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2021", "679", "عملیات توسط Async Request شروع شد", "2025-04-20 19:50:04", "2025-04-20 19:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2022", "679", "عملیات توسط Async Request کامل شد", "2025-04-20 19:50:04", "2025-04-20 19:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2023", "681", "عملیات توسط Async Request شروع شد", "2025-04-20 19:50:04", "2025-04-20 19:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2024", "681", "عملیات توسط Async Request کامل شد", "2025-04-20 19:50:04", "2025-04-20 19:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2025", "683", "عملیات توسط Async Request شروع شد", "2025-04-20 19:50:04", "2025-04-20 19:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2026", "683", "عملیات توسط Async Request کامل شد", "2025-04-20 19:50:04", "2025-04-20 19:50:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2027", "685", "ایجاد فعالیت", "2025-04-20 19:52:28", "2025-04-20 19:52:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2028", "686", "ایجاد فعالیت", "2025-04-20 19:52:28", "2025-04-20 19:52:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2029", "687", "ایجاد فعالیت", "2025-04-20 19:52:28", "2025-04-20 19:52:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2030", "685", "عملیات توسط Async Request شروع شد", "2025-04-20 19:53:26", "2025-04-20 19:53:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2031", "685", "عملیات توسط Async Request کامل شد", "2025-04-20 19:53:26", "2025-04-20 19:53:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2032", "687", "عملیات توسط Async Request شروع شد", "2025-04-20 19:53:26", "2025-04-20 19:53:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2033", "687", "عملیات توسط Async Request کامل شد", "2025-04-20 19:53:26", "2025-04-20 19:53:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2034", "686", "عملیات توسط Async Request شروع شد", "2025-04-20 19:53:26", "2025-04-20 19:53:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2035", "686", "عملیات توسط Async Request کامل شد", "2025-04-20 19:53:26", "2025-04-20 19:53:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2036", "688", "ایجاد فعالیت", "2025-04-20 19:54:14", "2025-04-20 19:54:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2037", "689", "ایجاد فعالیت", "2025-04-20 19:54:14", "2025-04-20 19:54:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2038", "690", "ایجاد فعالیت", "2025-04-20 19:54:14", "2025-04-20 19:54:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2039", "688", "عملیات توسط Async Request شروع شد", "2025-04-20 19:55:08", "2025-04-20 19:55:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2040", "688", "عملیات توسط Async Request کامل شد", "2025-04-20 19:55:08", "2025-04-20 19:55:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2041", "690", "عملیات توسط Async Request شروع شد", "2025-04-20 19:55:08", "2025-04-20 19:55:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2042", "690", "عملیات توسط Async Request کامل شد", "2025-04-20 19:55:08", "2025-04-20 19:55:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2043", "689", "عملیات توسط Async Request شروع شد", "2025-04-20 19:55:08", "2025-04-20 19:55:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2044", "689", "عملیات توسط Async Request کامل شد", "2025-04-20 19:55:08", "2025-04-20 19:55:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2045", "691", "ایجاد فعالیت", "2025-04-20 19:57:36", "2025-04-20 19:57:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2046", "692", "ایجاد فعالیت", "2025-04-20 19:57:36", "2025-04-20 19:57:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2047", "693", "ایجاد فعالیت", "2025-04-20 19:57:36", "2025-04-20 19:57:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2048", "694", "ایجاد فعالیت", "2025-04-20 19:57:36", "2025-04-20 19:57:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2049", "695", "ایجاد فعالیت", "2025-04-20 19:57:36", "2025-04-20 19:57:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2050", "696", "ایجاد فعالیت", "2025-04-20 19:57:36", "2025-04-20 19:57:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2051", "697", "ایجاد فعالیت", "2025-04-20 19:57:36", "2025-04-20 19:57:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2052", "698", "ایجاد فعالیت", "2025-04-20 19:57:36", "2025-04-20 19:57:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2053", "699", "ایجاد فعالیت", "2025-04-20 19:57:36", "2025-04-20 19:57:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2054", "700", "ایجاد فعالیت", "2025-04-20 19:57:36", "2025-04-20 19:57:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2055", "701", "ایجاد فعالیت", "2025-04-20 19:57:36", "2025-04-20 19:57:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2056", "702", "ایجاد فعالیت", "2025-04-20 19:57:36", "2025-04-20 19:57:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2057", "703", "ایجاد فعالیت", "2025-04-20 19:57:36", "2025-04-20 19:57:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2058", "691", "عملیات توسط Async Request شروع شد", "2025-04-20 19:57:56", "2025-04-20 19:57:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2059", "691", "عملیات توسط Async Request کامل شد", "2025-04-20 19:57:56", "2025-04-20 19:57:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2060", "693", "عملیات توسط Async Request شروع شد", "2025-04-20 19:57:56", "2025-04-20 19:57:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2061", "693", "عملیات توسط Async Request کامل شد", "2025-04-20 19:57:56", "2025-04-20 19:57:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2062", "695", "عملیات توسط Async Request شروع شد", "2025-04-20 19:57:56", "2025-04-20 19:57:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2063", "695", "عملیات توسط Async Request کامل شد", "2025-04-20 19:57:56", "2025-04-20 19:57:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2064", "697", "عملیات توسط Async Request شروع شد", "2025-04-20 19:57:56", "2025-04-20 19:57:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2065", "697", "عملیات توسط Async Request کامل شد", "2025-04-20 19:57:56", "2025-04-20 19:57:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2066", "699", "عملیات توسط Async Request شروع شد", "2025-04-20 19:57:56", "2025-04-20 19:57:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2067", "699", "عملیات توسط Async Request کامل شد", "2025-04-20 19:57:56", "2025-04-20 19:57:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2068", "701", "عملیات توسط Async Request شروع شد", "2025-04-20 19:57:56", "2025-04-20 19:57:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2069", "701", "عملیات توسط Async Request کامل شد", "2025-04-20 19:57:56", "2025-04-20 19:57:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2070", "703", "عملیات توسط Async Request شروع شد", "2025-04-20 19:57:56", "2025-04-20 19:57:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2071", "703", "عملیات توسط Async Request کامل شد", "2025-04-20 19:57:56", "2025-04-20 19:57:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2072", "692", "عملیات توسط Async Request شروع شد", "2025-04-20 19:57:56", "2025-04-20 19:57:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2073", "692", "عملیات توسط Async Request کامل شد", "2025-04-20 19:57:56", "2025-04-20 19:57:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2074", "694", "عملیات توسط Async Request شروع شد", "2025-04-20 19:57:56", "2025-04-20 19:57:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2075", "694", "عملیات توسط Async Request کامل شد", "2025-04-20 19:57:56", "2025-04-20 19:57:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2076", "696", "عملیات توسط Async Request شروع شد", "2025-04-20 19:57:56", "2025-04-20 19:57:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2077", "696", "عملیات توسط Async Request کامل شد", "2025-04-20 19:57:56", "2025-04-20 19:57:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2078", "698", "عملیات توسط Async Request شروع شد", "2025-04-20 19:57:56", "2025-04-20 19:57:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2079", "698", "عملیات توسط Async Request کامل شد", "2025-04-20 19:57:56", "2025-04-20 19:57:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2080", "700", "عملیات توسط Async Request شروع شد", "2025-04-20 19:57:56", "2025-04-20 19:57:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2081", "700", "عملیات توسط Async Request کامل شد", "2025-04-20 19:57:56", "2025-04-20 19:57:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2082", "702", "عملیات توسط Async Request شروع شد", "2025-04-20 19:57:56", "2025-04-20 19:57:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2083", "702", "عملیات توسط Async Request کامل شد", "2025-04-20 19:57:56", "2025-04-20 19:57:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2084", "704", "ایجاد فعالیت", "2025-04-20 20:36:15", "2025-04-20 20:36:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("2085", "704", "عملیات توسط Async Request شروع شد", "2025-04-20 20:36:31", "2025-04-20 20:36:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2086", "704", "عملیات توسط Async Request کامل شد", "2025-04-20 20:36:31", "2025-04-20 20:36:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2087", "705", "ایجاد فعالیت", "2025-04-20 21:37:11", "2025-04-20 21:37:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2088", "705", "عملیات توسط Async Request شروع شد", "2025-04-20 21:37:13", "2025-04-20 21:37:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("2089", "705", "عملیات توسط Async Request کامل شد", "2025-04-20 21:37:13", "2025-04-20 21:37:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("2090", "706", "ایجاد فعالیت", "2025-04-21 04:55:04", "2025-04-21 04:55:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2091", "706", "عملیات توسط Async Request شروع شد", "2025-04-21 13:40:43", "2025-04-21 13:40:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("2092", "706", "عملیات توسط Async Request کامل شد", "2025-04-21 13:40:43", "2025-04-21 13:40:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("2093", "707", "ایجاد فعالیت", "2025-04-21 13:40:44", "2025-04-21 13:40:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("2094", "707", "عملیات توسط Async Request شروع شد", "2025-04-21 13:40:50", "2025-04-21 13:40:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("2095", "707", "عملیات توسط Async Request کامل شد", "2025-04-21 13:40:50", "2025-04-21 13:40:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("2096", "708", "ایجاد فعالیت", "2025-04-21 14:47:22", "2025-04-21 14:47:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("2097", "708", "عملیات توسط Async Request شروع شد", "2025-04-21 14:47:24", "2025-04-21 14:47:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("2098", "708", "عملیات توسط Async Request کامل شد", "2025-04-21 14:47:24", "2025-04-21 14:47:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("2099", "709", "ایجاد فعالیت", "2025-04-21 15:48:53", "2025-04-21 15:48:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2100", "345", "عملیات توسط Async Request شروع شد", "2025-04-21 15:48:55", "2025-04-21 15:48:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2101", "345", "عملیات توسط Async Request کامل شد", "2025-04-21 15:48:55", "2025-04-21 15:48:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2102", "710", "ایجاد فعالیت", "2025-04-21 15:48:55", "2025-04-21 15:48:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2103", "709", "عملیات توسط Async Request شروع شد", "2025-04-21 15:48:55", "2025-04-21 15:48:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2104", "709", "عملیات توسط Async Request کامل شد", "2025-04-21 15:48:55", "2025-04-21 15:48:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2105", "711", "ایجاد فعالیت", "2025-04-21 16:48:55", "2025-04-21 16:48:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2106", "711", "عملیات توسط Async Request شروع شد", "2025-04-21 16:48:57", "2025-04-21 16:48:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("2107", "711", "عملیات توسط Async Request کامل شد", "2025-04-21 16:48:57", "2025-04-21 16:48:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("2108", "712", "ایجاد فعالیت", "2025-04-21 17:49:06", "2025-04-21 17:49:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("2109", "712", "عملیات توسط Async Request شروع شد", "2025-04-21 17:49:08", "2025-04-21 17:49:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2110", "712", "عملیات توسط Async Request کامل شد", "2025-04-21 17:49:08", "2025-04-21 17:49:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2111", "713", "ایجاد فعالیت", "2025-04-21 18:49:11", "2025-04-21 18:49:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2112", "713", "عملیات توسط Async Request شروع شد", "2025-04-21 18:49:58", "2025-04-21 18:49:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("2113", "713", "عملیات توسط Async Request کامل شد", "2025-04-21 18:49:58", "2025-04-21 18:49:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("2114", "714", "ایجاد فعالیت", "2025-04-21 19:49:22", "2025-04-21 19:49:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("2115", "714", "عملیات توسط Async Request شروع شد", "2025-04-21 19:49:23", "2025-04-21 19:49:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("2116", "714", "عملیات توسط Async Request کامل شد", "2025-04-21 19:49:23", "2025-04-21 19:49:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("2117", "715", "ایجاد فعالیت", "2025-04-21 20:49:23", "2025-04-21 20:49:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("2118", "715", "عملیات توسط Async Request شروع شد", "2025-04-21 20:49:55", "2025-04-21 20:49:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2119", "715", "عملیات توسط Async Request کامل شد", "2025-04-21 20:49:55", "2025-04-21 20:49:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2120", "716", "ایجاد فعالیت", "2025-04-22 05:33:45", "2025-04-22 05:33:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("2121", "716", "عملیات توسط Async Request شروع شد", "2025-04-22 05:34:09", "2025-04-22 05:34:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("2122", "716", "عملیات توسط Async Request کامل شد", "2025-04-22 05:34:09", "2025-04-22 05:34:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("2123", "717", "ایجاد فعالیت", "2025-04-22 08:52:41", "2025-04-22 08:52:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2124", "717", "عملیات توسط Async Request شروع شد", "2025-04-22 08:52:43", "2025-04-22 08:52:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("2125", "717", "عملیات توسط Async Request کامل شد", "2025-04-22 08:52:43", "2025-04-22 08:52:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("2126", "718", "ایجاد فعالیت", "2025-04-22 13:39:25", "2025-04-22 13:39:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2127", "718", "عملیات توسط Async Request شروع شد", "2025-04-22 13:39:27", "2025-04-22 13:39:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("2128", "718", "عملیات توسط Async Request کامل شد", "2025-04-22 13:39:27", "2025-04-22 13:39:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("2129", "719", "ایجاد فعالیت", "2025-04-22 14:39:37", "2025-04-22 14:39:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2130", "719", "عملیات توسط Async Request شروع شد", "2025-04-22 14:39:53", "2025-04-22 14:39:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2131", "719", "عملیات توسط Async Request کامل شد", "2025-04-22 14:39:53", "2025-04-22 14:39:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2132", "720", "ایجاد فعالیت", "2025-04-22 15:45:52", "2025-04-22 15:45:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("2133", "721", "ایجاد فعالیت", "2025-04-22 15:45:52", "2025-04-22 15:45:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("2134", "720", "عملیات توسط Async Request شروع شد", "2025-04-22 15:45:54", "2025-04-22 15:45:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("2135", "720", "عملیات توسط Async Request کامل شد", "2025-04-22 15:45:54", "2025-04-22 15:45:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("2136", "721", "عملیات توسط Async Request شروع شد", "2025-04-22 15:45:54", "2025-04-22 15:45:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("2137", "721", "عملیات توسط Async Request کامل شد", "2025-04-22 15:45:54", "2025-04-22 15:45:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("2138", "710", "عملیات توسط Async Request شروع شد", "2025-04-22 15:49:03", "2025-04-22 15:49:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("2139", "710", "عملیات توسط Async Request کامل شد", "2025-04-22 15:49:03", "2025-04-22 15:49:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("2140", "722", "ایجاد فعالیت", "2025-04-22 15:49:03", "2025-04-22 15:49:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("2141", "723", "ایجاد فعالیت", "2025-04-22 16:47:43", "2025-04-22 16:47:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("2142", "723", "عملیات توسط Async Request شروع شد", "2025-04-22 16:47:44", "2025-04-22 16:47:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("2143", "723", "عملیات توسط Async Request کامل شد", "2025-04-22 16:47:44", "2025-04-22 16:47:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("2144", "724", "ایجاد فعالیت", "2025-04-22 17:47:55", "2025-04-22 17:47:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2145", "724", "عملیات توسط Async Request شروع شد", "2025-04-22 17:48:41", "2025-04-22 17:48:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2146", "724", "عملیات توسط Async Request کامل شد", "2025-04-22 17:48:41", "2025-04-22 17:48:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2147", "725", "ایجاد فعالیت", "2025-04-22 18:48:45", "2025-04-22 18:48:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("2148", "725", "عملیات توسط Async Request شروع شد", "2025-04-22 18:48:47", "2025-04-22 18:48:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("2149", "725", "عملیات توسط Async Request کامل شد", "2025-04-22 18:48:47", "2025-04-22 18:48:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("2150", "726", "ایجاد فعالیت", "2025-04-22 19:48:47", "2025-04-22 19:48:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("2151", "726", "عملیات توسط Async Request شروع شد", "2025-04-22 19:49:04", "2025-04-22 19:49:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2152", "726", "عملیات توسط Async Request کامل شد", "2025-04-22 19:49:04", "2025-04-22 19:49:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2153", "727", "ایجاد فعالیت", "2025-04-23 09:00:15", "2025-04-23 09:00:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("2154", "727", "عملیات توسط Async Request شروع شد", "2025-04-23 09:00:25", "2025-04-23 09:00:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2155", "727", "عملیات توسط Async Request کامل شد", "2025-04-23 09:00:25", "2025-04-23 09:00:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2156", "728", "ایجاد فعالیت", "2025-04-23 10:19:41", "2025-04-23 10:19:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2157", "728", "عملیات توسط Async Request شروع شد", "2025-04-23 10:23:32", "2025-04-23 10:23:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2158", "728", "عملیات توسط Async Request کامل شد", "2025-04-23 10:23:32", "2025-04-23 10:23:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2159", "729", "ایجاد فعالیت", "2025-04-23 11:19:57", "2025-04-23 11:19:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("2160", "729", "عملیات توسط Async Request شروع شد", "2025-04-23 11:20:32", "2025-04-23 11:20:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2161", "729", "عملیات توسط Async Request کامل شد", "2025-04-23 11:20:32", "2025-04-23 11:20:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2162", "730", "ایجاد فعالیت", "2025-04-23 13:04:01", "2025-04-23 13:04:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2163", "730", "عملیات توسط Async Request شروع شد", "2025-04-23 13:48:02", "2025-04-23 13:48:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("2164", "730", "عملیات توسط Async Request کامل شد", "2025-04-23 13:48:02", "2025-04-23 13:48:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("2165", "731", "ایجاد فعالیت", "2025-04-23 14:31:39", "2025-04-23 14:31:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("2166", "731", "عملیات توسط Async Request شروع شد", "2025-04-23 14:33:52", "2025-04-23 14:33:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("2167", "731", "عملیات توسط Async Request کامل شد", "2025-04-23 14:33:53", "2025-04-23 14:33:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2168", "732", "ایجاد فعالیت", "2025-04-23 15:31:47", "2025-04-23 15:31:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("2169", "732", "عملیات توسط Async Request شروع شد", "2025-04-23 15:32:37", "2025-04-23 15:32:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2170", "732", "عملیات توسط Async Request کامل شد", "2025-04-23 15:32:37", "2025-04-23 15:32:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2171", "722", "عملیات توسط Async Request شروع شد", "2025-04-23 15:49:58", "2025-04-23 15:49:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("2172", "722", "عملیات توسط Async Request کامل شد", "2025-04-23 15:49:58", "2025-04-23 15:49:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("2173", "733", "ایجاد فعالیت", "2025-04-23 15:49:58", "2025-04-23 15:49:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("2174", "734", "ایجاد فعالیت", "2025-04-23 16:32:01", "2025-04-23 16:32:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2175", "734", "عملیات توسط Async Request شروع شد", "2025-04-23 16:33:03", "2025-04-23 16:33:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("2176", "734", "عملیات توسط Async Request کامل شد", "2025-04-23 16:33:03", "2025-04-23 16:33:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("2177", "735", "ایجاد فعالیت", "2025-04-23 17:16:28", "2025-04-23 17:16:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2178", "736", "ایجاد فعالیت", "2025-04-23 17:16:28", "2025-04-23 17:16:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2179", "737", "ایجاد فعالیت", "2025-04-23 17:16:28", "2025-04-23 17:16:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("2180", "735", "عملیات توسط Async Request شروع شد", "2025-04-23 17:16:30", "2025-04-23 17:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("2181", "735", "عملیات توسط Async Request کامل شد", "2025-04-23 17:16:30", "2025-04-23 17:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("2182", "737", "عملیات توسط Async Request شروع شد", "2025-04-23 17:16:30", "2025-04-23 17:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("2183", "737", "عملیات توسط Async Request کامل شد", "2025-04-23 17:16:30", "2025-04-23 17:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("2184", "736", "عملیات توسط Async Request شروع شد", "2025-04-23 17:16:30", "2025-04-23 17:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("2185", "736", "عملیات توسط Async Request کامل شد", "2025-04-23 17:16:30", "2025-04-23 17:16:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("2186", "738", "ایجاد فعالیت", "2025-04-23 17:22:09", "2025-04-23 17:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("2187", "739", "ایجاد فعالیت", "2025-04-23 17:22:09", "2025-04-23 17:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("2188", "740", "ایجاد فعالیت", "2025-04-23 17:22:09", "2025-04-23 17:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("2189", "738", "عملیات توسط Async Request شروع شد", "2025-04-23 17:22:10", "2025-04-23 17:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2190", "738", "عملیات توسط Async Request کامل شد", "2025-04-23 17:22:10", "2025-04-23 17:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2191", "740", "عملیات توسط Async Request شروع شد", "2025-04-23 17:22:10", "2025-04-23 17:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2192", "740", "عملیات توسط Async Request کامل شد", "2025-04-23 17:22:10", "2025-04-23 17:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2193", "739", "عملیات توسط Async Request شروع شد", "2025-04-23 17:22:10", "2025-04-23 17:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2194", "739", "عملیات توسط Async Request کامل شد", "2025-04-23 17:22:10", "2025-04-23 17:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2195", "741", "ایجاد فعالیت", "2025-04-23 17:28:33", "2025-04-23 17:28:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("2196", "742", "ایجاد فعالیت", "2025-04-23 17:28:33", "2025-04-23 17:28:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("2197", "743", "ایجاد فعالیت", "2025-04-23 17:28:33", "2025-04-23 17:28:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("2198", "741", "عملیات توسط Async Request شروع شد", "2025-04-23 17:29:08", "2025-04-23 17:29:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2199", "741", "عملیات توسط Async Request کامل شد", "2025-04-23 17:29:08", "2025-04-23 17:29:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2200", "743", "عملیات توسط Async Request شروع شد", "2025-04-23 17:29:08", "2025-04-23 17:29:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2201", "743", "عملیات توسط Async Request کامل شد", "2025-04-23 17:29:08", "2025-04-23 17:29:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2202", "742", "عملیات توسط Async Request شروع شد", "2025-04-23 17:29:08", "2025-04-23 17:29:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2203", "742", "عملیات توسط Async Request کامل شد", "2025-04-23 17:29:08", "2025-04-23 17:29:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2204", "744", "ایجاد فعالیت", "2025-04-23 17:38:07", "2025-04-23 17:38:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("2205", "744", "عملیات توسط Async Request شروع شد", "2025-04-23 17:38:09", "2025-04-23 17:38:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("2206", "744", "عملیات توسط Async Request کامل شد", "2025-04-23 17:38:09", "2025-04-23 17:38:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("2207", "745", "ایجاد فعالیت", "2025-04-25 12:27:38", "2025-04-25 12:27:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("2208", "733", "عملیات توسط Async Request شروع شد", "2025-04-26 06:31:40", "2025-04-26 06:31:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2209", "733", "عملیات توسط Async Request کامل شد", "2025-04-26 06:31:40", "2025-04-26 06:31:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2210", "746", "ایجاد فعالیت", "2025-04-26 06:31:40", "2025-04-26 06:31:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2211", "745", "عملیات توسط Async Request شروع شد", "2025-04-26 06:31:40", "2025-04-26 06:31:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2212", "745", "عملیات توسط Async Request کامل شد", "2025-04-26 06:31:40", "2025-04-26 06:31:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2213", "747", "ایجاد فعالیت", "2025-04-26 06:31:49", "2025-04-26 06:31:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("2214", "747", "عملیات توسط Async Request شروع شد", "2025-04-26 06:32:43", "2025-04-26 06:32:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("2215", "747", "عملیات توسط Async Request کامل شد", "2025-04-26 06:32:43", "2025-04-26 06:32:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("2216", "748", "ایجاد فعالیت", "2025-04-26 16:46:40", "2025-04-26 16:46:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2217", "748", "عملیات توسط Async Request شروع شد", "2025-04-26 17:12:51", "2025-04-26 17:12:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("2218", "748", "عملیات توسط Async Request کامل شد", "2025-04-26 17:12:51", "2025-04-26 17:12:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("2219", "749", "ایجاد فعالیت", "2025-04-26 17:17:03", "2025-04-26 17:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("2220", "750", "ایجاد فعالیت", "2025-04-26 17:17:03", "2025-04-26 17:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("2221", "751", "ایجاد فعالیت", "2025-04-26 17:17:03", "2025-04-26 17:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("2222", "749", "عملیات توسط Async Request شروع شد", "2025-04-26 17:18:10", "2025-04-26 17:18:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2223", "749", "عملیات توسط Async Request کامل شد", "2025-04-26 17:18:10", "2025-04-26 17:18:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2224", "751", "عملیات توسط Async Request شروع شد", "2025-04-26 17:18:10", "2025-04-26 17:18:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2225", "751", "عملیات توسط Async Request کامل شد", "2025-04-26 17:18:10", "2025-04-26 17:18:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2226", "750", "عملیات توسط Async Request شروع شد", "2025-04-26 17:18:10", "2025-04-26 17:18:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2227", "750", "عملیات توسط Async Request کامل شد", "2025-04-26 17:18:10", "2025-04-26 17:18:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2228", "752", "ایجاد فعالیت", "2025-04-26 17:22:04", "2025-04-26 17:22:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2229", "753", "ایجاد فعالیت", "2025-04-26 17:22:04", "2025-04-26 17:22:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2230", "754", "ایجاد فعالیت", "2025-04-26 17:22:04", "2025-04-26 17:22:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2231", "752", "عملیات توسط Async Request شروع شد", "2025-04-26 17:22:32", "2025-04-26 17:22:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2232", "752", "عملیات توسط Async Request کامل شد", "2025-04-26 17:22:32", "2025-04-26 17:22:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2233", "754", "عملیات توسط Async Request شروع شد", "2025-04-26 17:22:32", "2025-04-26 17:22:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2234", "754", "عملیات توسط Async Request کامل شد", "2025-04-26 17:22:32", "2025-04-26 17:22:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2235", "753", "عملیات توسط Async Request شروع شد", "2025-04-26 17:22:32", "2025-04-26 17:22:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2236", "753", "عملیات توسط Async Request کامل شد", "2025-04-26 17:22:32", "2025-04-26 17:22:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2237", "755", "ایجاد فعالیت", "2025-04-26 17:31:38", "2025-04-26 17:31:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("2238", "756", "ایجاد فعالیت", "2025-04-26 17:31:38", "2025-04-26 17:31:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("2239", "757", "ایجاد فعالیت", "2025-04-26 17:31:38", "2025-04-26 17:31:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("2240", "755", "عملیات توسط Async Request شروع شد", "2025-04-26 17:31:46", "2025-04-26 17:31:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("2241", "755", "عملیات توسط Async Request کامل شد", "2025-04-26 17:31:46", "2025-04-26 17:31:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("2242", "757", "عملیات توسط Async Request شروع شد", "2025-04-26 17:31:46", "2025-04-26 17:31:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("2243", "757", "عملیات توسط Async Request کامل شد", "2025-04-26 17:31:46", "2025-04-26 17:31:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("2244", "756", "عملیات توسط Async Request شروع شد", "2025-04-26 17:31:46", "2025-04-26 17:31:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("2245", "756", "عملیات توسط Async Request کامل شد", "2025-04-26 17:31:46", "2025-04-26 17:31:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("2246", "758", "ایجاد فعالیت", "2025-04-26 17:42:55", "2025-04-26 17:42:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2247", "759", "ایجاد فعالیت", "2025-04-26 17:42:55", "2025-04-26 17:42:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2248", "760", "ایجاد فعالیت", "2025-04-26 17:42:55", "2025-04-26 17:42:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2249", "758", "عملیات توسط Async Request شروع شد", "2025-04-26 17:43:34", "2025-04-26 17:43:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2250", "758", "عملیات توسط Async Request کامل شد", "2025-04-26 17:43:34", "2025-04-26 17:43:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2251", "760", "عملیات توسط Async Request شروع شد", "2025-04-26 17:43:34", "2025-04-26 17:43:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2252", "760", "عملیات توسط Async Request کامل شد", "2025-04-26 17:43:34", "2025-04-26 17:43:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2253", "759", "عملیات توسط Async Request شروع شد", "2025-04-26 17:43:34", "2025-04-26 17:43:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2254", "759", "عملیات توسط Async Request کامل شد", "2025-04-26 17:43:34", "2025-04-26 17:43:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2255", "761", "ایجاد فعالیت", "2025-04-26 17:46:46", "2025-04-26 17:46:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("2256", "761", "عملیات توسط Async Request شروع شد", "2025-04-26 17:46:49", "2025-04-26 17:46:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("2257", "761", "عملیات توسط Async Request کامل شد", "2025-04-26 17:46:49", "2025-04-26 17:46:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("2258", "762", "ایجاد فعالیت", "2025-04-26 18:46:48", "2025-04-26 18:46:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("2259", "762", "عملیات توسط Async Request شروع شد", "2025-04-26 18:46:50", "2025-04-26 18:46:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("2260", "762", "عملیات توسط Async Request کامل شد", "2025-04-26 18:46:50", "2025-04-26 18:46:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("2261", "763", "ایجاد فعالیت", "2025-04-26 19:47:33", "2025-04-26 19:47:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("2262", "763", "عملیات توسط Async Request شروع شد", "2025-04-26 19:47:34", "2025-04-26 19:47:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2263", "763", "عملیات توسط Async Request کامل شد", "2025-04-26 19:47:34", "2025-04-26 19:47:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2264", "764", "ایجاد فعالیت", "2025-04-26 20:47:55", "2025-04-26 20:47:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2265", "764", "عملیات توسط Async Request شروع شد", "2025-04-26 20:47:57", "2025-04-26 20:47:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("2266", "764", "عملیات توسط Async Request کامل شد", "2025-04-26 20:47:57", "2025-04-26 20:47:57");
INSERT INTO `wp_actionscheduler_logs` VALUES("2267", "765", "ایجاد فعالیت", "2025-04-26 21:48:09", "2025-04-26 21:48:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("2268", "765", "عملیات توسط Async Request شروع شد", "2025-04-26 21:48:13", "2025-04-26 21:48:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("2269", "765", "عملیات توسط Async Request کامل شد", "2025-04-26 21:48:13", "2025-04-26 21:48:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("2270", "766", "ایجاد فعالیت", "2025-04-27 19:56:54", "2025-04-27 19:56:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("2271", "746", "عملیات توسط Async Request شروع شد", "2025-04-27 19:57:33", "2025-04-27 19:57:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("2272", "746", "عملیات توسط Async Request کامل شد", "2025-04-27 19:57:33", "2025-04-27 19:57:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("2273", "767", "ایجاد فعالیت", "2025-04-27 19:57:33", "2025-04-27 19:57:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("2274", "766", "عملیات توسط Async Request شروع شد", "2025-04-27 19:57:33", "2025-04-27 19:57:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("2275", "766", "عملیات توسط Async Request کامل شد", "2025-04-27 19:57:33", "2025-04-27 19:57:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("2276", "768", "ایجاد فعالیت", "2025-04-27 20:57:11", "2025-04-27 20:57:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2277", "768", "عملیات توسط Async Request شروع شد", "2025-04-28 04:19:26", "2025-04-28 04:19:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2278", "768", "عملیات توسط Async Request کامل شد", "2025-04-28 04:19:26", "2025-04-28 04:19:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2279", "769", "ایجاد فعالیت", "2025-04-28 04:19:37", "2025-04-28 04:19:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2280", "769", "عملیات توسط Async Request شروع شد", "2025-04-28 14:55:31", "2025-04-28 14:55:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2281", "769", "عملیات توسط Async Request کامل شد", "2025-04-28 14:55:31", "2025-04-28 14:55:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2282", "770", "ایجاد فعالیت", "2025-04-28 14:55:42", "2025-04-28 14:55:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("2283", "770", "عملیات توسط Async Request شروع شد", "2025-04-29 07:22:15", "2025-04-29 07:22:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("2284", "770", "عملیات توسط Async Request کامل شد", "2025-04-29 07:22:15", "2025-04-29 07:22:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("2285", "767", "عملیات توسط Async Request شروع شد", "2025-04-29 07:22:15", "2025-04-29 07:22:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("2286", "767", "عملیات توسط Async Request کامل شد", "2025-04-29 07:22:15", "2025-04-29 07:22:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("2287", "771", "ایجاد فعالیت", "2025-04-29 07:22:15", "2025-04-29 07:22:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("2288", "772", "ایجاد فعالیت", "2025-04-29 07:39:42", "2025-04-29 07:39:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("2289", "772", "عملیات توسط Async Request شروع شد", "2025-04-29 08:16:18", "2025-04-29 08:16:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("2290", "772", "عملیات توسط Async Request کامل شد", "2025-04-29 08:16:18", "2025-04-29 08:16:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("2291", "773", "ایجاد فعالیت", "2025-04-29 08:59:15", "2025-04-29 08:59:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("2292", "773", "عملیات توسط Async Request شروع شد", "2025-04-29 10:12:10", "2025-04-29 10:12:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2293", "773", "عملیات توسط Async Request کامل شد", "2025-04-29 10:12:10", "2025-04-29 10:12:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2294", "774", "ایجاد فعالیت", "2025-04-29 10:13:45", "2025-04-29 10:13:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("2295", "774", "عملیات توسط Async Request شروع شد", "2025-04-29 11:39:16", "2025-04-29 11:39:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("2296", "774", "عملیات توسط Async Request کامل شد", "2025-04-29 11:39:16", "2025-04-29 11:39:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("2297", "775", "ایجاد فعالیت", "2025-04-29 12:30:01", "2025-04-29 12:30:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2298", "775", "عملیات توسط Async Request شروع شد", "2025-04-29 19:59:53", "2025-04-29 19:59:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2299", "775", "عملیات توسط Async Request کامل شد", "2025-04-29 19:59:53", "2025-04-29 19:59:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2300", "776", "ایجاد فعالیت", "2025-04-29 20:47:14", "2025-04-29 20:47:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2301", "776", "عملیات توسط Async Request شروع شد", "2025-04-30 08:04:53", "2025-04-30 08:04:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2302", "776", "عملیات توسط Async Request کامل شد", "2025-04-30 08:04:53", "2025-04-30 08:04:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2303", "771", "عملیات توسط Async Request شروع شد", "2025-04-30 08:04:53", "2025-04-30 08:04:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2304", "771", "عملیات توسط Async Request کامل شد", "2025-04-30 08:04:53", "2025-04-30 08:04:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2305", "777", "ایجاد فعالیت", "2025-04-30 08:04:53", "2025-04-30 08:04:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2306", "778", "ایجاد فعالیت", "2025-04-30 08:36:22", "2025-04-30 08:36:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("2307", "778", "عملیات توسط Async Request شروع شد", "2025-04-30 13:59:09", "2025-04-30 13:59:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("2308", "778", "عملیات توسط Async Request کامل شد", "2025-04-30 13:59:09", "2025-04-30 13:59:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("2309", "779", "ایجاد فعالیت", "2025-04-30 13:59:11", "2025-04-30 13:59:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2310", "779", "عملیات توسط Async Request شروع شد", "2025-04-30 13:59:15", "2025-04-30 13:59:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("2311", "779", "عملیات توسط Async Request کامل شد", "2025-04-30 13:59:15", "2025-04-30 13:59:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("2312", "780", "ایجاد فعالیت", "2025-04-30 15:09:59", "2025-04-30 15:09:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2313", "780", "عملیات توسط Async Request شروع شد", "2025-04-30 15:33:04", "2025-04-30 15:33:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2314", "780", "عملیات توسط Async Request کامل شد", "2025-04-30 15:33:04", "2025-04-30 15:33:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("2315", "781", "ایجاد فعالیت", "2025-04-30 16:16:37", "2025-04-30 16:16:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2316", "781", "عملیات توسط Async Request شروع شد", "2025-04-30 20:01:20", "2025-04-30 20:01:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2317", "781", "عملیات توسط Async Request کامل شد", "2025-04-30 20:01:20", "2025-04-30 20:01:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2318", "782", "ایجاد فعالیت", "2025-04-30 20:01:23", "2025-04-30 20:01:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("2319", "782", "عملیات توسط Async Request شروع شد", "2025-04-30 20:01:27", "2025-04-30 20:01:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("2320", "782", "عملیات توسط Async Request کامل شد", "2025-04-30 20:01:27", "2025-04-30 20:01:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("2321", "783", "ایجاد فعالیت", "2025-04-30 21:43:10", "2025-04-30 21:43:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2322", "783", "عملیات توسط Async Request شروع شد", "2025-05-02 15:19:53", "2025-05-02 15:19:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2323", "783", "عملیات توسط Async Request کامل شد", "2025-05-02 15:19:53", "2025-05-02 15:19:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2324", "777", "عملیات توسط Async Request شروع شد", "2025-05-02 15:19:53", "2025-05-02 15:19:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2325", "777", "عملیات توسط Async Request کامل شد", "2025-05-02 15:19:53", "2025-05-02 15:19:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2326", "784", "ایجاد فعالیت", "2025-05-02 15:19:53", "2025-05-02 15:19:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2327", "785", "ایجاد فعالیت", "2025-05-02 15:25:36", "2025-05-02 15:25:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2328", "785", "عملیات توسط Async Request شروع شد", "2025-05-03 06:25:10", "2025-05-03 06:25:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2329", "785", "عملیات توسط Async Request کامل شد", "2025-05-03 06:25:10", "2025-05-03 06:25:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2330", "786", "ایجاد فعالیت", "2025-05-03 06:25:14", "2025-05-03 06:25:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2331", "786", "عملیات توسط Async Request شروع شد", "2025-05-03 06:25:17", "2025-05-03 06:25:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2332", "786", "عملیات توسط Async Request کامل شد", "2025-05-03 06:25:17", "2025-05-03 06:25:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2333", "787", "ایجاد فعالیت", "2025-05-03 07:25:55", "2025-05-03 07:25:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2334", "787", "عملیات توسط Async Request شروع شد", "2025-05-03 08:20:44", "2025-05-03 08:20:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("2335", "787", "عملیات توسط Async Request کامل شد", "2025-05-03 08:20:44", "2025-05-03 08:20:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("2336", "788", "ایجاد فعالیت", "2025-05-03 08:44:34", "2025-05-03 08:44:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2337", "788", "عملیات توسط Async Request شروع شد", "2025-05-03 10:04:43", "2025-05-03 10:04:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("2338", "788", "عملیات توسط Async Request کامل شد", "2025-05-03 10:04:43", "2025-05-03 10:04:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("2339", "789", "ایجاد فعالیت", "2025-05-03 10:04:49", "2025-05-03 10:04:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("2340", "789", "عملیات توسط Async Request شروع شد", "2025-05-03 10:05:50", "2025-05-03 10:05:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("2341", "789", "عملیات توسط Async Request کامل شد", "2025-05-03 10:05:50", "2025-05-03 10:05:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("2342", "790", "ایجاد فعالیت", "2025-05-03 11:13:01", "2025-05-03 11:13:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2343", "790", "عملیات توسط Async Request شروع شد", "2025-05-03 12:08:03", "2025-05-03 12:08:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("2344", "790", "عملیات توسط Async Request کامل شد", "2025-05-03 12:08:03", "2025-05-03 12:08:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("2345", "791", "ایجاد فعالیت", "2025-05-03 12:18:01", "2025-05-03 12:18:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2346", "791", "عملیات توسط Async Request شروع شد", "2025-05-03 12:18:41", "2025-05-03 12:18:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2347", "791", "عملیات توسط Async Request کامل شد", "2025-05-03 12:18:41", "2025-05-03 12:18:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2348", "792", "ایجاد فعالیت", "2025-05-03 13:20:56", "2025-05-03 13:20:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2349", "792", "عملیات توسط Async Request شروع شد", "2025-05-03 19:14:05", "2025-05-03 19:14:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("2350", "792", "عملیات توسط Async Request کامل شد", "2025-05-03 19:14:05", "2025-05-03 19:14:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("2351", "784", "عملیات توسط Async Request شروع شد", "2025-05-03 19:14:05", "2025-05-03 19:14:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("2352", "784", "عملیات توسط Async Request کامل شد", "2025-05-03 19:14:05", "2025-05-03 19:14:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("2353", "793", "ایجاد فعالیت", "2025-05-03 19:14:05", "2025-05-03 19:14:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("2354", "794", "ایجاد فعالیت", "2025-05-03 19:14:19", "2025-05-03 19:14:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("2355", "794", "عملیات توسط Async Request شروع شد", "2025-05-04 10:45:37", "2025-05-04 10:45:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2356", "794", "عملیات توسط Async Request کامل شد", "2025-05-04 10:45:37", "2025-05-04 10:45:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2357", "795", "ایجاد فعالیت", "2025-05-04 10:45:37", "2025-05-04 10:45:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2358", "795", "عملیات توسط Async Request شروع شد", "2025-05-04 10:45:43", "2025-05-04 10:45:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("2359", "795", "عملیات توسط Async Request کامل شد", "2025-05-04 10:45:43", "2025-05-04 10:45:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("2360", "796", "ایجاد فعالیت", "2025-05-04 11:51:58", "2025-05-04 11:51:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("2361", "796", "عملیات توسط Async Request شروع شد", "2025-05-04 12:50:59", "2025-05-04 12:50:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2362", "796", "عملیات توسط Async Request کامل شد", "2025-05-04 12:50:59", "2025-05-04 12:50:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("2363", "797", "ایجاد فعالیت", "2025-05-04 13:03:21", "2025-05-04 13:03:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("2364", "797", "عملیات توسط Async Request شروع شد", "2025-05-04 13:03:24", "2025-05-04 13:03:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("2365", "797", "عملیات توسط Async Request کامل شد", "2025-05-04 13:03:24", "2025-05-04 13:03:24");
INSERT INTO `wp_actionscheduler_logs` VALUES("2366", "798", "ایجاد فعالیت", "2025-05-04 14:35:02", "2025-05-04 14:35:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("2367", "798", "عملیات توسط Async Request شروع شد", "2025-05-04 17:58:09", "2025-05-04 17:58:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("2368", "798", "عملیات توسط Async Request کامل شد", "2025-05-04 17:58:09", "2025-05-04 17:58:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("2369", "799", "ایجاد فعالیت", "2025-05-04 17:58:12", "2025-05-04 17:58:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2370", "799", "عملیات توسط Async Request شروع شد", "2025-05-04 17:58:16", "2025-05-04 17:58:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("2371", "799", "عملیات توسط Async Request کامل شد", "2025-05-04 17:58:16", "2025-05-04 17:58:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("2372", "800", "ایجاد فعالیت", "2025-05-04 18:58:47", "2025-05-04 18:58:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("2373", "800", "عملیات توسط Async Request شروع شد", "2025-05-04 18:59:55", "2025-05-04 18:59:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2374", "800", "عملیات توسط Async Request کامل شد", "2025-05-04 18:59:55", "2025-05-04 18:59:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2375", "801", "ایجاد فعالیت", "2025-05-04 20:19:39", "2025-05-04 20:19:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("2376", "793", "عملیات توسط Async Request شروع شد", "2025-05-04 20:19:41", "2025-05-04 20:19:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2377", "793", "عملیات توسط Async Request کامل شد", "2025-05-04 20:19:41", "2025-05-04 20:19:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2378", "802", "ایجاد فعالیت", "2025-05-04 20:19:41", "2025-05-04 20:19:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2379", "801", "عملیات توسط Async Request شروع شد", "2025-05-04 20:19:41", "2025-05-04 20:19:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2380", "801", "عملیات توسط Async Request کامل شد", "2025-05-04 20:19:41", "2025-05-04 20:19:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2381", "803", "ایجاد فعالیت", "2025-05-04 21:21:48", "2025-05-04 21:21:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("2382", "803", "عملیات توسط Async Request شروع شد", "2025-05-06 02:10:25", "2025-05-06 02:10:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2383", "803", "عملیات توسط Async Request کامل شد", "2025-05-06 02:10:25", "2025-05-06 02:10:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2384", "802", "عملیات توسط Async Request شروع شد", "2025-05-06 02:10:25", "2025-05-06 02:10:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2385", "802", "عملیات توسط Async Request کامل شد", "2025-05-06 02:10:25", "2025-05-06 02:10:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2386", "804", "ایجاد فعالیت", "2025-05-06 02:10:25", "2025-05-06 02:10:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2387", "805", "ایجاد فعالیت", "2025-05-06 02:11:29", "2025-05-06 02:11:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("2388", "805", "عملیات توسط Async Request شروع شد", "2025-05-06 18:49:47", "2025-05-06 18:49:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("2389", "805", "عملیات توسط Async Request کامل شد", "2025-05-06 18:49:47", "2025-05-06 18:49:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("2390", "806", "ایجاد فعالیت", "2025-05-06 18:50:02", "2025-05-06 18:50:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("2391", "806", "عملیات توسط Async Request شروع شد", "2025-05-07 11:24:12", "2025-05-07 11:24:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2392", "806", "عملیات توسط Async Request کامل شد", "2025-05-07 11:24:12", "2025-05-07 11:24:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2393", "804", "عملیات توسط Async Request شروع شد", "2025-05-07 11:24:12", "2025-05-07 11:24:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2394", "804", "عملیات توسط Async Request کامل شد", "2025-05-07 11:24:12", "2025-05-07 11:24:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2395", "807", "ایجاد فعالیت", "2025-05-07 11:24:12", "2025-05-07 11:24:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("2396", "808", "ایجاد فعالیت", "2025-05-07 11:24:14", "2025-05-07 11:24:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2397", "808", "عملیات توسط Async Request شروع شد", "2025-05-07 11:24:18", "2025-05-07 11:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("2398", "808", "عملیات توسط Async Request کامل شد", "2025-05-07 11:24:18", "2025-05-07 11:24:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("2399", "809", "ایجاد فعالیت", "2025-05-07 12:53:50", "2025-05-07 12:53:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("2400", "809", "عملیات توسط Async Request شروع شد", "2025-05-07 15:59:31", "2025-05-07 15:59:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2401", "809", "عملیات توسط Async Request کامل شد", "2025-05-07 15:59:31", "2025-05-07 15:59:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2402", "810", "ایجاد فعالیت", "2025-05-07 15:59:34", "2025-05-07 15:59:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2403", "810", "عملیات توسط Async Request شروع شد", "2025-05-07 15:59:38", "2025-05-07 15:59:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("2404", "810", "عملیات توسط Async Request کامل شد", "2025-05-07 15:59:38", "2025-05-07 15:59:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("2405", "811", "ایجاد فعالیت", "2025-05-07 17:18:25", "2025-05-07 17:18:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2406", "811", "عملیات توسط Async Request شروع شد", "2025-05-07 19:13:45", "2025-05-07 19:13:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("2407", "811", "عملیات توسط Async Request کامل شد", "2025-05-07 19:13:45", "2025-05-07 19:13:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("2408", "812", "ایجاد فعالیت", "2025-05-07 19:13:46", "2025-05-07 19:13:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("2409", "812", "عملیات توسط Async Request شروع شد", "2025-05-07 19:13:52", "2025-05-07 19:13:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("2410", "812", "عملیات توسط Async Request کامل شد", "2025-05-07 19:13:52", "2025-05-07 19:13:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("2411", "813", "ایجاد فعالیت", "2025-05-07 19:17:18", "2025-05-07 19:17:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("2412", "814", "ایجاد فعالیت", "2025-05-07 19:17:18", "2025-05-07 19:17:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("2413", "813", "عملیات توسط Async Request شروع شد", "2025-05-07 19:17:20", "2025-05-07 19:17:20");
INSERT INTO `wp_actionscheduler_logs` VALUES("2414", "813", "عملیات توسط Async Request کامل شد", "2025-05-07 19:17:21", "2025-05-07 19:17:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("2415", "814", "عملیات توسط Async Request شروع شد", "2025-05-07 19:17:21", "2025-05-07 19:17:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("2416", "814", "عملیات توسط Async Request کامل شد", "2025-05-07 19:17:21", "2025-05-07 19:17:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("2417", "815", "ایجاد فعالیت", "2025-05-07 20:48:38", "2025-05-07 20:48:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("2418", "815", "عملیات توسط Async Request شروع شد", "2025-05-08 09:10:19", "2025-05-08 09:10:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("2419", "815", "عملیات توسط Async Request کامل شد", "2025-05-08 09:10:19", "2025-05-08 09:10:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("2420", "816", "ایجاد فعالیت", "2025-05-08 09:10:22", "2025-05-08 09:10:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("2421", "816", "عملیات توسط Async Request شروع شد", "2025-05-08 09:10:26", "2025-05-08 09:10:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2422", "816", "عملیات توسط Async Request کامل شد", "2025-05-08 09:10:26", "2025-05-08 09:10:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2423", "817", "ایجاد فعالیت", "2025-05-08 10:24:49", "2025-05-08 10:24:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("2424", "817", "عملیات توسط Async Request شروع شد", "2025-05-09 11:16:21", "2025-05-09 11:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("2425", "817", "عملیات توسط Async Request کامل شد", "2025-05-09 11:16:21", "2025-05-09 11:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("2426", "807", "عملیات توسط Async Request شروع شد", "2025-05-09 11:16:21", "2025-05-09 11:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("2427", "807", "عملیات توسط Async Request کامل شد", "2025-05-09 11:16:21", "2025-05-09 11:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("2428", "818", "ایجاد فعالیت", "2025-05-09 11:16:21", "2025-05-09 11:16:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("2429", "819", "ایجاد فعالیت", "2025-05-09 11:52:08", "2025-05-09 11:52:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("2430", "819", "عملیات توسط Async Request شروع شد", "2025-05-09 17:26:05", "2025-05-09 17:26:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("2431", "819", "عملیات توسط Async Request کامل شد", "2025-05-09 17:26:05", "2025-05-09 17:26:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("2432", "820", "ایجاد فعالیت", "2025-05-09 17:26:22", "2025-05-09 17:26:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("2433", "820", "عملیات توسط Async Request شروع شد", "2025-05-09 18:01:27", "2025-05-09 18:01:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("2434", "820", "عملیات توسط Async Request کامل شد", "2025-05-09 18:01:27", "2025-05-09 18:01:27");
INSERT INTO `wp_actionscheduler_logs` VALUES("2435", "821", "ایجاد فعالیت", "2025-05-09 18:29:02", "2025-05-09 18:29:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("2436", "821", "عملیات توسط Async Request شروع شد", "2025-05-09 21:06:49", "2025-05-09 21:06:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("2437", "821", "عملیات توسط Async Request کامل شد", "2025-05-09 21:06:49", "2025-05-09 21:06:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("2438", "822", "ایجاد فعالیت", "2025-05-09 21:07:03", "2025-05-09 21:07:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("2439", "822", "عملیات توسط Async Request شروع شد", "2025-05-10 02:21:34", "2025-05-10 02:21:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2440", "822", "عملیات توسط Async Request کامل شد", "2025-05-10 02:21:34", "2025-05-10 02:21:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2441", "823", "ایجاد فعالیت", "2025-05-10 02:21:36", "2025-05-10 02:21:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2442", "823", "عملیات توسط Async Request شروع شد", "2025-05-10 02:21:41", "2025-05-10 02:21:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2443", "823", "عملیات توسط Async Request کامل شد", "2025-05-10 02:21:41", "2025-05-10 02:21:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2444", "824", "ایجاد فعالیت", "2025-05-10 04:16:32", "2025-05-10 04:16:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2445", "824", "عملیات توسط Async Request شروع شد", "2025-05-10 06:18:14", "2025-05-10 06:18:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2446", "824", "عملیات توسط Async Request کامل شد", "2025-05-10 06:18:14", "2025-05-10 06:18:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("2447", "825", "ایجاد فعالیت", "2025-05-10 06:30:05", "2025-05-10 06:30:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("2448", "825", "عملیات توسط Async Request شروع شد", "2025-05-10 19:14:44", "2025-05-10 19:14:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("2449", "825", "عملیات توسط Async Request کامل شد", "2025-05-10 19:14:44", "2025-05-10 19:14:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("2450", "818", "عملیات توسط Async Request شروع شد", "2025-05-10 19:14:44", "2025-05-10 19:14:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("2451", "818", "عملیات توسط Async Request کامل شد", "2025-05-10 19:14:44", "2025-05-10 19:14:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("2452", "826", "ایجاد فعالیت", "2025-05-10 19:14:44", "2025-05-10 19:14:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("2453", "827", "ایجاد فعالیت", "2025-05-10 19:14:45", "2025-05-10 19:14:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("2454", "827", "عملیات توسط Async Request شروع شد", "2025-05-10 19:14:50", "2025-05-10 19:14:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("2455", "827", "عملیات توسط Async Request کامل شد", "2025-05-10 19:14:50", "2025-05-10 19:14:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("2456", "828", "ایجاد فعالیت", "2025-05-10 20:43:36", "2025-05-10 20:43:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2457", "828", "عملیات توسط Async Request شروع شد", "2025-05-10 20:47:38", "2025-05-10 20:47:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("2458", "828", "عملیات توسط Async Request کامل شد", "2025-05-10 20:47:38", "2025-05-10 20:47:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("2459", "829", "ایجاد فعالیت", "2025-05-10 22:04:17", "2025-05-10 22:04:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2460", "829", "عملیات توسط Async Request شروع شد", "2025-05-10 22:04:19", "2025-05-10 22:04:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("2461", "829", "عملیات توسط Async Request کامل شد", "2025-05-10 22:04:19", "2025-05-10 22:04:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("2462", "830", "ایجاد فعالیت", "2025-05-11 04:11:18", "2025-05-11 04:11:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("2463", "830", "عملیات توسط Async Request شروع شد", "2025-05-11 07:17:29", "2025-05-11 07:17:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("2464", "830", "عملیات توسط Async Request کامل شد", "2025-05-11 07:17:29", "2025-05-11 07:17:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("2465", "831", "ایجاد فعالیت", "2025-05-11 07:17:30", "2025-05-11 07:17:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("2466", "831", "عملیات توسط Async Request شروع شد", "2025-05-11 07:17:35", "2025-05-11 07:17:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2467", "831", "عملیات توسط Async Request کامل شد", "2025-05-11 07:17:35", "2025-05-11 07:17:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2468", "832", "ایجاد فعالیت", "2025-05-11 08:19:44", "2025-05-11 08:19:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("2469", "832", "عملیات توسط Async Request شروع شد", "2025-05-11 09:48:46", "2025-05-11 09:48:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("2470", "832", "عملیات توسط Async Request کامل شد", "2025-05-11 09:48:46", "2025-05-11 09:48:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("2471", "833", "ایجاد فعالیت", "2025-05-11 09:48:47", "2025-05-11 09:48:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("2472", "833", "عملیات توسط Async Request شروع شد", "2025-05-11 09:48:53", "2025-05-11 09:48:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2473", "833", "عملیات توسط Async Request کامل شد", "2025-05-11 09:48:53", "2025-05-11 09:48:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2474", "834", "ایجاد فعالیت", "2025-05-11 11:17:36", "2025-05-11 11:17:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2475", "834", "عملیات توسط Async Request شروع شد", "2025-05-11 12:20:31", "2025-05-11 12:20:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2476", "834", "عملیات توسط Async Request کامل شد", "2025-05-11 12:20:31", "2025-05-11 12:20:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2477", "835", "ایجاد فعالیت", "2025-05-11 12:20:32", "2025-05-11 12:20:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2478", "835", "عملیات توسط Async Request شروع شد", "2025-05-11 12:20:38", "2025-05-11 12:20:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("2479", "835", "عملیات توسط Async Request کامل شد", "2025-05-11 12:20:38", "2025-05-11 12:20:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("2480", "836", "ایجاد فعالیت", "2025-05-11 13:23:36", "2025-05-11 13:23:36");
INSERT INTO `wp_actionscheduler_logs` VALUES("2481", "836", "عملیات توسط Async Request شروع شد", "2025-05-11 13:24:55", "2025-05-11 13:24:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2482", "836", "عملیات توسط Async Request کامل شد", "2025-05-11 13:24:55", "2025-05-11 13:24:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2483", "837", "ایجاد فعالیت", "2025-05-11 14:24:03", "2025-05-11 14:24:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("2484", "837", "عملیات توسط Async Request شروع شد", "2025-05-11 15:23:55", "2025-05-11 15:23:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2485", "837", "عملیات توسط Async Request کامل شد", "2025-05-11 15:23:55", "2025-05-11 15:23:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("2486", "838", "ایجاد فعالیت", "2025-05-11 15:24:06", "2025-05-11 15:24:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("2487", "838", "عملیات توسط Async Request شروع شد", "2025-05-11 18:49:07", "2025-05-11 18:49:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("2488", "838", "عملیات توسط Async Request کامل شد", "2025-05-11 18:49:07", "2025-05-11 18:49:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("2489", "839", "ایجاد فعالیت", "2025-05-11 18:49:09", "2025-05-11 18:49:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("2490", "839", "عملیات توسط Async Request شروع شد", "2025-05-11 18:49:13", "2025-05-11 18:49:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("2491", "839", "عملیات توسط Async Request کامل شد", "2025-05-11 18:49:13", "2025-05-11 18:49:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("2492", "840", "ایجاد فعالیت", "2025-05-11 20:13:32", "2025-05-11 20:13:32");
INSERT INTO `wp_actionscheduler_logs` VALUES("2493", "826", "عملیات توسط Async Request شروع شد", "2025-05-12 04:50:41", "2025-05-12 04:50:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2494", "826", "عملیات توسط Async Request کامل شد", "2025-05-12 04:50:41", "2025-05-12 04:50:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2495", "841", "ایجاد فعالیت", "2025-05-12 04:50:41", "2025-05-12 04:50:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2496", "840", "عملیات توسط Async Request شروع شد", "2025-05-12 04:50:41", "2025-05-12 04:50:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2497", "840", "عملیات توسط Async Request کامل شد", "2025-05-12 04:50:41", "2025-05-12 04:50:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2498", "842", "ایجاد فعالیت", "2025-05-12 04:51:39", "2025-05-12 04:51:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("2499", "842", "عملیات توسط Async Request شروع شد", "2025-05-12 04:52:40", "2025-05-12 04:52:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2500", "842", "عملیات توسط Async Request کامل شد", "2025-05-12 04:52:40", "2025-05-12 04:52:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("2501", "843", "ایجاد فعالیت", "2025-05-12 06:55:26", "2025-05-12 06:55:26");
INSERT INTO `wp_actionscheduler_logs` VALUES("2502", "843", "عملیات توسط Async Request شروع شد", "2025-05-12 08:26:18", "2025-05-12 08:26:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("2503", "843", "عملیات توسط Async Request کامل شد", "2025-05-12 08:26:18", "2025-05-12 08:26:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("2504", "844", "ایجاد فعالیت", "2025-05-12 08:26:23", "2025-05-12 08:26:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("2505", "844", "عملیات توسط Async Request شروع شد", "2025-05-12 08:26:25", "2025-05-12 08:26:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2506", "844", "عملیات توسط Async Request کامل شد", "2025-05-12 08:26:25", "2025-05-12 08:26:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2507", "845", "ایجاد فعالیت", "2025-05-12 09:36:19", "2025-05-12 09:36:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("2508", "845", "عملیات توسط Async Request شروع شد", "2025-05-12 11:26:10", "2025-05-12 11:26:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2509", "845", "عملیات توسط Async Request کامل شد", "2025-05-12 11:26:10", "2025-05-12 11:26:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2510", "846", "ایجاد فعالیت", "2025-05-12 11:26:11", "2025-05-12 11:26:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("2511", "846", "عملیات توسط Async Request شروع شد", "2025-05-12 11:26:17", "2025-05-12 11:26:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2512", "846", "عملیات توسط Async Request کامل شد", "2025-05-12 11:26:17", "2025-05-12 11:26:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("2513", "847", "ایجاد فعالیت", "2025-05-12 12:39:01", "2025-05-12 12:39:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2514", "847", "عملیات توسط Async Request شروع شد", "2025-05-13 04:57:19", "2025-05-13 04:57:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("2515", "847", "عملیات توسط Async Request کامل شد", "2025-05-13 04:57:19", "2025-05-13 04:57:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("2516", "841", "عملیات توسط Async Request شروع شد", "2025-05-13 04:57:19", "2025-05-13 04:57:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("2517", "841", "عملیات توسط Async Request کامل شد", "2025-05-13 04:57:19", "2025-05-13 04:57:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("2518", "848", "ایجاد فعالیت", "2025-05-13 04:57:19", "2025-05-13 04:57:19");
INSERT INTO `wp_actionscheduler_logs` VALUES("2519", "849", "ایجاد فعالیت", "2025-05-13 04:58:10", "2025-05-13 04:58:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("2520", "849", "عملیات توسط Async Request شروع شد", "2025-05-13 05:47:18", "2025-05-13 05:47:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("2521", "849", "عملیات توسط Async Request کامل شد", "2025-05-13 05:47:18", "2025-05-13 05:47:18");
INSERT INTO `wp_actionscheduler_logs` VALUES("2522", "850", "ایجاد فعالیت", "2025-05-13 06:21:25", "2025-05-13 06:21:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("2523", "850", "عملیات توسط Async Request شروع شد", "2025-05-13 06:21:34", "2025-05-13 06:21:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2524", "850", "عملیات توسط Async Request کامل شد", "2025-05-13 06:21:34", "2025-05-13 06:21:34");
INSERT INTO `wp_actionscheduler_logs` VALUES("2525", "851", "ایجاد فعالیت", "2025-05-13 07:59:56", "2025-05-13 07:59:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("2526", "851", "عملیات توسط Async Request شروع شد", "2025-05-13 08:35:23", "2025-05-13 08:35:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("2527", "851", "عملیات توسط Async Request کامل شد", "2025-05-13 08:35:23", "2025-05-13 08:35:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("2528", "852", "ایجاد فعالیت", "2025-05-13 08:40:50", "2025-05-13 08:40:50");
INSERT INTO `wp_actionscheduler_logs` VALUES("2529", "852", "عملیات توسط Async Request شروع شد", "2025-05-13 08:42:42", "2025-05-13 08:42:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("2530", "852", "عملیات توسط Async Request کامل شد", "2025-05-13 08:42:42", "2025-05-13 08:42:42");
INSERT INTO `wp_actionscheduler_logs` VALUES("2531", "853", "ایجاد فعالیت", "2025-05-13 08:42:43", "2025-05-13 08:42:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("2532", "853", "عملیات توسط Async Request شروع شد", "2025-05-13 08:43:45", "2025-05-13 08:43:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("2533", "853", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2025-05-13 08:43:45", "2025-05-13 08:43:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("2534", "848", "عملیات توسط Async Request شروع شد", "2025-05-14 04:58:07", "2025-05-14 04:58:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("2535", "848", "عملیات توسط Async Request کامل شد", "2025-05-14 04:58:07", "2025-05-14 04:58:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("2536", "854", "ایجاد فعالیت", "2025-05-14 04:58:07", "2025-05-14 04:58:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("2537", "854", "عملیات توسط Async Request شروع شد", "2025-05-15 06:54:41", "2025-05-15 06:54:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2538", "854", "عملیات توسط Async Request کامل شد", "2025-05-15 06:54:41", "2025-05-15 06:54:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2539", "855", "ایجاد فعالیت", "2025-05-15 06:54:41", "2025-05-15 06:54:41");
INSERT INTO `wp_actionscheduler_logs` VALUES("2540", "855", "عملیات توسط Async Request شروع شد", "2025-05-16 21:07:01", "2025-05-16 21:07:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2541", "855", "عملیات توسط Async Request کامل شد", "2025-05-16 21:07:01", "2025-05-16 21:07:01");
INSERT INTO `wp_actionscheduler_logs` VALUES("2542", "856", "ایجاد فعالیت", "2025-05-16 21:07:01", "2025-05-16 21:07:01");

/* INSERT TABLE DATA: wp_commentmeta */
INSERT INTO `wp_commentmeta` VALUES("1", "2", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("2", "2", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("3", "2", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("4", "2", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("5", "2", "wd_total_vote", "0");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "یک نویسنده دیدگاه وردپرس", "wapuu@wordpress.example", "https://fa.wordpress.org/", "", "2025-04-17 15:33:09", "2025-04-17 12:03:09", "سلام، این یک دیدگاه است.\nبرای شروع مدیریت، ویرایش و پاک کردن دیدگاه‌ها، لطفا بخش دیدگاه‌ها در پیشخوان را ببینید.\nتصاویر نویسندگان دیدگاه از <a href=\"https://gravatar.com/\">Gravatar</a> گرفته می‌شود.", "0", "post-trashed", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("2", "253", "شهرر", "farazpayamak@gmail.com", "", "37.63.129.109", "2025-06-01 14:54:19", "2025-06-01 11:24:19", "عالیه", "0", "0", "Mozilla/5.0 (Linux; Android 10; K) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Mobile Safari/537.36", "review", "0", "0");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("6", "20250429_d8afd985d988d984d8a8d8a7d8b3d", "89da19f53523b39d9432_20250610152840", "21", "2025-06-10 15:31:25", "admina", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-06-10 15:28:40\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.8.1\";s:9:\"VersionDB\";s:7:\"10.6.19\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:6;s:4:\"Name\";s:38:\"20250429_d8afd985d988d984d8a8d8a7d8b3d\";s:4:\"Hash\";s:35:\"89da19f53523b39d9432_20250610152840\";s:8:\"NameHash\";s:74:\"20250429_d8afd985d988d984d8a8d8a7d8b3d_89da19f53523b39d9432_20250610152840\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:84:\"20250429_d8afd985d988d984d8a8d8a7d8b3d_89da19f53523b39d9432_20250610152840_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.1\";s:6:\"WPUser\";s:6:\"admina\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:86:\"20250429_d8afd985d988d984d8a8d8a7d8b3d_89da19f53523b39d9432_20250610152840_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:64:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/Underwear\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:5869;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:36414;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2025-06-10 15:28:40\";s:7:\"Version\";s:6:\"1.5.12\";s:9:\"VersionWP\";s:5:\"6.8.1\";s:9:\"VersionDB\";s:7:\"10.6.19\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:38:\"20250429_d8afd985d988d984d8a8d8a7d8b3d\";s:4:\"Hash\";s:35:\"89da19f53523b39d9432_20250610152840\";s:8:\"NameHash\";s:74:\"20250429_d8afd985d988d984d8a8d8a7d8b3d_89da19f53523b39d9432_20250610152840\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:92:\"20250429_d8afd985d988d984d8a8d8a7d8b3d_89da19f53523b39d9432_20250610152840_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:78:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/Underwear/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:87:\"20250429_d8afd985d988d984d8a8d8a7d8b3d_89da19f53523b39d9432_20250610152840_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:184:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/Underwear/wp-content/backups-dup-lite/tmp/20250429_d8afd985d988d984d8a8d8a7d8b3d_89da19f53523b39d9432_20250610152840_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:73:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/Underwear/wp-admin\";i:1;s:76:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/Underwear/wp-includes\";i:2;s:85:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/Underwear/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:64:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/Underwear\";i:1;s:64:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/Underwear\";i:2;s:75:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/Underwear/wp-content\";i:3;s:83:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/Underwear/wp-content/uploads\";i:4;s:83:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/Underwear/wp-content/plugins\";i:5;s:86:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/Underwear/wp-content/mu-plugins\";i:6;s:82:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/Underwear/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:96:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/Underwear/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_options */
INSERT INTO `wp_options` VALUES("1", "cron", "a:31:{i:1744891389;a:2:{s:32:\"recovery_mode_clean_expired_keys\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:34:\"wp_privacy_delete_old_export_files\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1744891398;a:3:{s:19:\"wp_scheduled_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:25:\"delete_expired_transients\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:21:\"wp_update_user_counts\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1744891401;a:1:{s:30:\"wp_scheduled_auto_draft_delete\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1744891409;a:1:{s:30:\"wp_delete_temp_updater_backups\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1744891458;a:1:{s:28:\"wp_update_comment_type_batch\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1744891485;a:2:{s:28:\"elementor/tracker/send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:26:\"action_scheduler_run_queue\";a:1:{s:32:\"0d04ed39571b55704c122d726248bbac\";a:3:{s:8:\"schedule\";s:12:\"every_minute\";s:4:\"args\";a:1:{i:0;s:7:\"WP Cron\";}s:8:\"interval\";i:60;}}}i:1744891486;a:1:{s:14:\"wc_admin_daily\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1744891496;a:1:{s:30:\"generate_category_lookup_table\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1744891497;a:4:{s:20:\"jetpack_clean_nonces\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}s:20:\"jetpack_v2_heartbeat\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:40:\"woodmart_wishlist_send_promotional_email\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}s:33:\"wc_admin_process_orders_milestone\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1744891498;a:1:{s:45:\"woocommerce_marketplace_cron_fetch_promotions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1744891504;a:1:{s:29:\"wc_admin_unsnooze_admin_notes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"hourly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1744894989;a:1:{s:16:\"wp_version_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1744896789;a:1:{s:17:\"wp_update_plugins\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1744898589;a:1:{s:16:\"wp_update_themes\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1744977789;a:1:{s:30:\"wp_site_health_scheduled_check\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:6:\"weekly\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1745095384;a:1:{s:31:\"woocommerce_flush_rewrite_rules\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1745348325;a:1:{s:8:\"do_pings\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1746441000;a:1:{s:29:\"duplicator_email_summary_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1746531697;a:1:{s:30:\"duplicator_usage_tracking_cron\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:22:\"duplicator_weekly_cron\";s:4:\"args\";a:0:{}s:8:\"interval\";i:604800;}}}i:1747145941;a:1:{s:26:\"upgrader_scheduled_cleanup\";a:1:{s:32:\"c0249a0f94c49b843a8a15416be9eac4\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:907;}}}}i:1747753926;a:1:{s:42:\"connect_hook_send_notif_product_leave_cart\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"every_hour\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1748525081;a:1:{s:32:\"connect_hook_send_notif_feedback\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:20:\"every_hours_feedback\";s:4:\"args\";a:0:{}s:8:\"interval\";i:3600;}}}i:1749569257;a:2:{s:33:\"woocommerce_cleanup_personal_data\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:30:\"woocommerce_tracker_send_event\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1749569307;a:1:{s:25:\"woocommerce_geoip_updater\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:11:\"fifteendays\";s:4:\"args\";a:0:{}s:8:\"interval\";i:1296000;}}}i:1749569458;a:1:{s:13:\"rsmAutoUpdate\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:1749572847;a:1:{s:32:\"woocommerce_cancel_unpaid_orders\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:0:{}}}}i:1749580047;a:2:{s:24:\"woocommerce_cleanup_logs\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}s:31:\"woocommerce_cleanup_rate_limits\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1749589200;a:1:{s:27:\"woocommerce_scheduled_sales\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:5:\"daily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:86400;}}}i:1749590847;a:1:{s:28:\"woocommerce_cleanup_sessions\";a:1:{s:32:\"40cd750bba9870f18aada2478b24840a\";a:3:{s:8:\"schedule\";s:10:\"twicedaily\";s:4:\"args\";a:0:{}s:8:\"interval\";i:43200;}}}i:21351280137;a:1:{s:19:\"publish_future_post\";a:10:{s:32:\"b4267a67df0cfb11e30d6396f858b5c9\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:40;}}s:32:\"9e2c6a3cf641939384d0c93c4db17413\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:919;}}s:32:\"982af21b0685091f8b52b16d5acc3594\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:44;}}s:32:\"dc622b39f4fcf2098b230d8d5d60bb4b\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:923;}}s:32:\"8cfeda15b954f98f30c7781983db2a82\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:920;}}s:32:\"2f39f82b6c5c6c7599fc22a165eada38\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:41;}}s:32:\"2b4d3a663c341cc7ba21989259f765c6\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:921;}}s:32:\"9faa5555021560fb2a78d8c9f3513bc5\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:42;}}s:32:\"928fa530db4ff795828e97ec47d69f10\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:922;}}s:32:\"90769b99ac5e069f750a77f27934e890\";a:2:{s:8:\"schedule\";b:0;s:4:\"args\";a:1:{i:0;i:43;}}}}s:7:\"version\";i:2;}", "on");
INSERT INTO `wp_options` VALUES("2", "siteurl", "https://demoes.aramis-co.ir/Underwear", "on");
INSERT INTO `wp_options` VALUES("3", "home", "https://demoes.aramis-co.ir/Underwear", "on");
INSERT INTO `wp_options` VALUES("4", "blogname", "دمو لباس زیر وودمارت پلاس", "on");
INSERT INTO `wp_options` VALUES("5", "blogdescription", "", "on");
INSERT INTO `wp_options` VALUES("6", "users_can_register", "0", "on");
INSERT INTO `wp_options` VALUES("7", "admin_email", "devwp98@gmail.com", "on");
INSERT INTO `wp_options` VALUES("8", "start_of_week", "6", "on");
INSERT INTO `wp_options` VALUES("9", "use_balanceTags", "0", "on");
INSERT INTO `wp_options` VALUES("10", "use_smilies", "1", "on");
INSERT INTO `wp_options` VALUES("11", "require_name_email", "1", "on");
INSERT INTO `wp_options` VALUES("12", "comments_notify", "1", "on");
INSERT INTO `wp_options` VALUES("13", "posts_per_rss", "10", "on");
INSERT INTO `wp_options` VALUES("14", "rss_use_excerpt", "0", "on");
INSERT INTO `wp_options` VALUES("15", "mailserver_url", "mail.example.com", "on");
INSERT INTO `wp_options` VALUES("16", "mailserver_login", "login@example.com", "on");
INSERT INTO `wp_options` VALUES("17", "mailserver_pass", "", "on");
INSERT INTO `wp_options` VALUES("18", "mailserver_port", "110", "on");
INSERT INTO `wp_options` VALUES("19", "default_category", "1", "on");
INSERT INTO `wp_options` VALUES("20", "default_comment_status", "open", "on");
INSERT INTO `wp_options` VALUES("21", "default_ping_status", "open", "on");
INSERT INTO `wp_options` VALUES("22", "default_pingback_flag", "1", "on");
INSERT INTO `wp_options` VALUES("23", "posts_per_page", "10", "on");
INSERT INTO `wp_options` VALUES("24", "date_format", "F j, Y", "on");
INSERT INTO `wp_options` VALUES("25", "time_format", "g:i a", "on");
INSERT INTO `wp_options` VALUES("26", "links_updated_date_format", "F j, Y g:i a", "on");
INSERT INTO `wp_options` VALUES("27", "comment_moderation", "0", "on");
INSERT INTO `wp_options` VALUES("28", "moderation_notify", "1", "on");
INSERT INTO `wp_options` VALUES("29", "permalink_structure", "/%postname%/", "on");
INSERT INTO `wp_options` VALUES("30", "rewrite_rules", "a:347:{s:24:\"^wc-auth/v([1]{1})/(.*)?\";s:63:\"index.php?wc-auth-version=$matches[1]&wc-auth-route=$matches[2]\";s:21:\"^wc/file/transient/?$\";s:33:\"index.php?wc-transient-file-name=\";s:24:\"^wc/file/transient/(.+)$\";s:44:\"index.php?wc-transient-file-name=$matches[1]\";s:22:\"^wc-api/v([1-3]{1})/?$\";s:51:\"index.php?wc-api-version=$matches[1]&wc-api-route=/\";s:24:\"^wc-api/v([1-3]{1})(.*)?\";s:61:\"index.php?wc-api-version=$matches[1]&wc-api-route=$matches[2]\";s:12:\"portfolio/?$\";s:29:\"index.php?post_type=portfolio\";s:42:\"portfolio/feed/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:37:\"portfolio/(feed|rdf|rss|rss2|atom)/?$\";s:46:\"index.php?post_type=portfolio&feed=$matches[1]\";s:29:\"portfolio/page/([0-9]{1,})/?$\";s:47:\"index.php?post_type=portfolio&paged=$matches[1]\";s:7:\"shop/?$\";s:27:\"index.php?post_type=product\";s:37:\"shop/feed/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:32:\"shop/(feed|rdf|rss|rss2|atom)/?$\";s:44:\"index.php?post_type=product&feed=$matches[1]\";s:24:\"shop/page/([0-9]{1,})/?$\";s:45:\"index.php?post_type=product&paged=$matches[1]\";s:11:\"^wp-json/?$\";s:22:\"index.php?rest_route=/\";s:14:\"^wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:21:\"^index.php/wp-json/?$\";s:22:\"index.php?rest_route=/\";s:24:\"^index.php/wp-json/(.*)?\";s:33:\"index.php?rest_route=/$matches[1]\";s:17:\"^wp-sitemap\\.xml$\";s:23:\"index.php?sitemap=index\";s:17:\"^wp-sitemap\\.xsl$\";s:36:\"index.php?sitemap-stylesheet=sitemap\";s:23:\"^wp-sitemap-index\\.xsl$\";s:34:\"index.php?sitemap-stylesheet=index\";s:48:\"^wp-sitemap-([a-z]+?)-([a-z\\d_-]+?)-(\\d+?)\\.xml$\";s:75:\"index.php?sitemap=$matches[1]&sitemap-subtype=$matches[2]&paged=$matches[3]\";s:34:\"^wp-sitemap-([a-z]+?)-(\\d+?)\\.xml$\";s:47:\"index.php?sitemap=$matches[1]&paged=$matches[2]\";s:91:\"^%d8%b9%d9%84%d8%a7%d9%82%d9%87-%d9%85%d9%86%d8%af%db%8c-%d9%87%d8%a7/([^/]*)/page/([^/]*)?\";s:63:\"index.php?page_id=870&wishlist_id=$matches[1]&paged=$matches[2]\";s:83:\"^%d8%b9%d9%84%d8%a7%d9%82%d9%87-%d9%85%d9%86%d8%af%db%8c-%d9%87%d8%a7/page/([^/]*)?\";s:39:\"index.php?page_id=870&paged=$matches[1]\";s:79:\"^%d8%b9%d9%84%d8%a7%d9%82%d9%87-%d9%85%d9%86%d8%af%db%8c-%d9%87%d8%a7/([^/]*)/?\";s:45:\"index.php?page_id=870&wishlist_id=$matches[1]\";s:47:\"category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:42:\"category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?category_name=$matches[1]&feed=$matches[2]\";s:23:\"category/(.+?)/embed/?$\";s:46:\"index.php?category_name=$matches[1]&embed=true\";s:35:\"category/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?category_name=$matches[1]&paged=$matches[2]\";s:43:\"category/(.+?)/wc/file/transient(/(.*))?/?$\";s:65:\"index.php?category_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"category/(.+?)/wc-api(/(.*))?/?$\";s:54:\"index.php?category_name=$matches[1]&wc-api=$matches[3]\";s:17:\"category/(.+?)/?$\";s:35:\"index.php?category_name=$matches[1]\";s:44:\"tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:39:\"tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?tag=$matches[1]&feed=$matches[2]\";s:20:\"tag/([^/]+)/embed/?$\";s:36:\"index.php?tag=$matches[1]&embed=true\";s:32:\"tag/([^/]+)/page/?([0-9]{1,})/?$\";s:43:\"index.php?tag=$matches[1]&paged=$matches[2]\";s:40:\"tag/([^/]+)/wc/file/transient(/(.*))?/?$\";s:55:\"index.php?tag=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"tag/([^/]+)/wc-api(/(.*))?/?$\";s:44:\"index.php?tag=$matches[1]&wc-api=$matches[3]\";s:14:\"tag/([^/]+)/?$\";s:25:\"index.php?tag=$matches[1]\";s:45:\"type/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:40:\"type/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?post_format=$matches[1]&feed=$matches[2]\";s:21:\"type/([^/]+)/embed/?$\";s:44:\"index.php?post_format=$matches[1]&embed=true\";s:33:\"type/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?post_format=$matches[1]&paged=$matches[2]\";s:15:\"type/([^/]+)/?$\";s:33:\"index.php?post_format=$matches[1]\";s:43:\"woodmart_layout/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"woodmart_layout/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"woodmart_layout/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_layout/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_layout/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"woodmart_layout/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"woodmart_layout/([^/]+)/embed/?$\";s:48:\"index.php?woodmart_layout=$matches[1]&embed=true\";s:36:\"woodmart_layout/([^/]+)/trackback/?$\";s:42:\"index.php?woodmart_layout=$matches[1]&tb=1\";s:44:\"woodmart_layout/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?woodmart_layout=$matches[1]&paged=$matches[2]\";s:51:\"woodmart_layout/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?woodmart_layout=$matches[1]&cpage=$matches[2]\";s:52:\"woodmart_layout/([^/]+)/wc/file/transient(/(.*))?/?$\";s:67:\"index.php?woodmart_layout=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"woodmart_layout/([^/]+)/wc-api(/(.*))?/?$\";s:56:\"index.php?woodmart_layout=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_layout/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:69:\"woodmart_layout/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:47:\"woodmart_layout/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_layout/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:40:\"woodmart_layout/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?woodmart_layout=$matches[1]&page=$matches[2]\";s:32:\"woodmart_layout/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"woodmart_layout/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"woodmart_layout/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_layout/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_layout/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"woodmart_layout/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:43:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:53:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:73:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:68:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:49:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:32:\"woodmart_woo_lv/([^/]+)/embed/?$\";s:48:\"index.php?woodmart_woo_lv=$matches[1]&embed=true\";s:36:\"woodmart_woo_lv/([^/]+)/trackback/?$\";s:42:\"index.php?woodmart_woo_lv=$matches[1]&tb=1\";s:44:\"woodmart_woo_lv/([^/]+)/page/?([0-9]{1,})/?$\";s:55:\"index.php?woodmart_woo_lv=$matches[1]&paged=$matches[2]\";s:51:\"woodmart_woo_lv/([^/]+)/comment-page-([0-9]{1,})/?$\";s:55:\"index.php?woodmart_woo_lv=$matches[1]&cpage=$matches[2]\";s:52:\"woodmart_woo_lv/([^/]+)/wc/file/transient(/(.*))?/?$\";s:67:\"index.php?woodmart_woo_lv=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"woodmart_woo_lv/([^/]+)/wc-api(/(.*))?/?$\";s:56:\"index.php?woodmart_woo_lv=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_woo_lv/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:69:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:47:\"woodmart_woo_lv/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:58:\"woodmart_woo_lv/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:40:\"woodmart_woo_lv/([^/]+)(?:/([0-9]+))?/?$\";s:54:\"index.php?woodmart_woo_lv=$matches[1]&page=$matches[2]\";s:32:\"woodmart_woo_lv/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:42:\"woodmart_woo_lv/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:62:\"woodmart_woo_lv/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_woo_lv/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:57:\"woodmart_woo_lv/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:38:\"woodmart_woo_lv/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:44:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:54:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:74:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:69:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:50:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:33:\"woodmart_woo_fbt/([^/]+)/embed/?$\";s:49:\"index.php?woodmart_woo_fbt=$matches[1]&embed=true\";s:37:\"woodmart_woo_fbt/([^/]+)/trackback/?$\";s:43:\"index.php?woodmart_woo_fbt=$matches[1]&tb=1\";s:45:\"woodmart_woo_fbt/([^/]+)/page/?([0-9]{1,})/?$\";s:56:\"index.php?woodmart_woo_fbt=$matches[1]&paged=$matches[2]\";s:52:\"woodmart_woo_fbt/([^/]+)/comment-page-([0-9]{1,})/?$\";s:56:\"index.php?woodmart_woo_fbt=$matches[1]&cpage=$matches[2]\";s:53:\"woodmart_woo_fbt/([^/]+)/wc/file/transient(/(.*))?/?$\";s:68:\"index.php?woodmart_woo_fbt=$matches[1]&wc/file/transient=$matches[3]\";s:42:\"woodmart_woo_fbt/([^/]+)/wc-api(/(.*))?/?$\";s:57:\"index.php?woodmart_woo_fbt=$matches[1]&wc-api=$matches[3]\";s:59:\"woodmart_woo_fbt/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:70:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:48:\"woodmart_woo_fbt/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:59:\"woodmart_woo_fbt/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:41:\"woodmart_woo_fbt/([^/]+)(?:/([0-9]+))?/?$\";s:55:\"index.php?woodmart_woo_fbt=$matches[1]&page=$matches[2]\";s:33:\"woodmart_woo_fbt/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:43:\"woodmart_woo_fbt/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:63:\"woodmart_woo_fbt/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"woodmart_woo_fbt/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:58:\"woodmart_woo_fbt/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:39:\"woodmart_woo_fbt/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:54:\"cms_block_cat/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?cms_block_cat=$matches[1]&feed=$matches[2]\";s:49:\"cms_block_cat/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?cms_block_cat=$matches[1]&feed=$matches[2]\";s:30:\"cms_block_cat/([^/]+)/embed/?$\";s:46:\"index.php?cms_block_cat=$matches[1]&embed=true\";s:42:\"cms_block_cat/([^/]+)/page/?([0-9]{1,})/?$\";s:53:\"index.php?cms_block_cat=$matches[1]&paged=$matches[2]\";s:24:\"cms_block_cat/([^/]+)/?$\";s:35:\"index.php?cms_block_cat=$matches[1]\";s:42:\"woodmart_slide/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:52:\"woodmart_slide/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:72:\"woodmart_slide/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"woodmart_slide/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:67:\"woodmart_slide/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:48:\"woodmart_slide/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:31:\"woodmart_slide/([^/]+)/embed/?$\";s:47:\"index.php?woodmart_slide=$matches[1]&embed=true\";s:35:\"woodmart_slide/([^/]+)/trackback/?$\";s:41:\"index.php?woodmart_slide=$matches[1]&tb=1\";s:43:\"woodmart_slide/([^/]+)/page/?([0-9]{1,})/?$\";s:54:\"index.php?woodmart_slide=$matches[1]&paged=$matches[2]\";s:50:\"woodmart_slide/([^/]+)/comment-page-([0-9]{1,})/?$\";s:54:\"index.php?woodmart_slide=$matches[1]&cpage=$matches[2]\";s:51:\"woodmart_slide/([^/]+)/wc/file/transient(/(.*))?/?$\";s:66:\"index.php?woodmart_slide=$matches[1]&wc/file/transient=$matches[3]\";s:40:\"woodmart_slide/([^/]+)/wc-api(/(.*))?/?$\";s:55:\"index.php?woodmart_slide=$matches[1]&wc-api=$matches[3]\";s:57:\"woodmart_slide/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:68:\"woodmart_slide/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:46:\"woodmart_slide/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:57:\"woodmart_slide/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:39:\"woodmart_slide/([^/]+)(?:/([0-9]+))?/?$\";s:53:\"index.php?woodmart_slide=$matches[1]&page=$matches[2]\";s:31:\"woodmart_slide/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:41:\"woodmart_slide/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:61:\"woodmart_slide/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"woodmart_slide/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:56:\"woodmart_slide/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:37:\"woodmart_slide/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:56:\"woodmart_slider/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:68:\"index.php?taxonomy=woodmart_slider&term=$matches[1]&feed=$matches[2]\";s:51:\"woodmart_slider/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:68:\"index.php?taxonomy=woodmart_slider&term=$matches[1]&feed=$matches[2]\";s:32:\"woodmart_slider/([^/]+)/embed/?$\";s:62:\"index.php?taxonomy=woodmart_slider&term=$matches[1]&embed=true\";s:44:\"woodmart_slider/([^/]+)/page/?([0-9]{1,})/?$\";s:69:\"index.php?taxonomy=woodmart_slider&term=$matches[1]&paged=$matches[2]\";s:26:\"woodmart_slider/([^/]+)/?$\";s:51:\"index.php?taxonomy=woodmart_slider&term=$matches[1]\";s:37:\"portfolio/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:47:\"portfolio/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:67:\"portfolio/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:62:\"portfolio/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:43:\"portfolio/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:26:\"portfolio/([^/]+)/embed/?$\";s:42:\"index.php?portfolio=$matches[1]&embed=true\";s:30:\"portfolio/([^/]+)/trackback/?$\";s:36:\"index.php?portfolio=$matches[1]&tb=1\";s:50:\"portfolio/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:45:\"portfolio/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:48:\"index.php?portfolio=$matches[1]&feed=$matches[2]\";s:38:\"portfolio/([^/]+)/page/?([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&paged=$matches[2]\";s:45:\"portfolio/([^/]+)/comment-page-([0-9]{1,})/?$\";s:49:\"index.php?portfolio=$matches[1]&cpage=$matches[2]\";s:46:\"portfolio/([^/]+)/wc/file/transient(/(.*))?/?$\";s:61:\"index.php?portfolio=$matches[1]&wc/file/transient=$matches[3]\";s:35:\"portfolio/([^/]+)/wc-api(/(.*))?/?$\";s:50:\"index.php?portfolio=$matches[1]&wc-api=$matches[3]\";s:52:\"portfolio/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:63:\"portfolio/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:41:\"portfolio/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:52:\"portfolio/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:34:\"portfolio/([^/]+)(?:/([0-9]+))?/?$\";s:48:\"index.php?portfolio=$matches[1]&page=$matches[2]\";s:26:\"portfolio/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:36:\"portfolio/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:56:\"portfolio/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:51:\"portfolio/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:32:\"portfolio/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:50:\"project-cat/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project-cat=$matches[1]&feed=$matches[2]\";s:45:\"project-cat/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?project-cat=$matches[1]&feed=$matches[2]\";s:26:\"project-cat/(.+?)/embed/?$\";s:44:\"index.php?project-cat=$matches[1]&embed=true\";s:38:\"project-cat/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?project-cat=$matches[1]&paged=$matches[2]\";s:20:\"project-cat/(.+?)/?$\";s:33:\"index.php?project-cat=$matches[1]\";s:47:\"برند/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:42:\"برند/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:52:\"index.php?product_brand=$matches[1]&feed=$matches[2]\";s:23:\"برند/(.+?)/embed/?$\";s:46:\"index.php?product_brand=$matches[1]&embed=true\";s:35:\"برند/(.+?)/page/?([0-9]{1,})/?$\";s:53:\"index.php?product_brand=$matches[1]&paged=$matches[2]\";s:17:\"برند/(.+?)/?$\";s:35:\"index.php?product_brand=$matches[1]\";s:55:\"product-category/(.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:50:\"product-category/(.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_cat=$matches[1]&feed=$matches[2]\";s:31:\"product-category/(.+?)/embed/?$\";s:44:\"index.php?product_cat=$matches[1]&embed=true\";s:43:\"product-category/(.+?)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_cat=$matches[1]&paged=$matches[2]\";s:25:\"product-category/(.+?)/?$\";s:33:\"index.php?product_cat=$matches[1]\";s:52:\"product-tag/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:47:\"product-tag/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?product_tag=$matches[1]&feed=$matches[2]\";s:28:\"product-tag/([^/]+)/embed/?$\";s:44:\"index.php?product_tag=$matches[1]&embed=true\";s:40:\"product-tag/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?product_tag=$matches[1]&paged=$matches[2]\";s:22:\"product-tag/([^/]+)/?$\";s:33:\"index.php?product_tag=$matches[1]\";s:36:\"shop/.+?/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"shop/.+?/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"shop/.+?/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"shop/.+?/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"shop/.+?/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"shop/.+?/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:27:\"shop/(.+?)/([^/]+)/embed/?$\";s:64:\"index.php?product_cat=$matches[1]&product=$matches[2]&embed=true\";s:31:\"shop/(.+?)/([^/]+)/trackback/?$\";s:58:\"index.php?product_cat=$matches[1]&product=$matches[2]&tb=1\";s:51:\"shop/(.+?)/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:70:\"index.php?product_cat=$matches[1]&product=$matches[2]&feed=$matches[3]\";s:46:\"shop/(.+?)/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:70:\"index.php?product_cat=$matches[1]&product=$matches[2]&feed=$matches[3]\";s:39:\"shop/(.+?)/([^/]+)/page/?([0-9]{1,})/?$\";s:71:\"index.php?product_cat=$matches[1]&product=$matches[2]&paged=$matches[3]\";s:46:\"shop/(.+?)/([^/]+)/comment-page-([0-9]{1,})/?$\";s:71:\"index.php?product_cat=$matches[1]&product=$matches[2]&cpage=$matches[3]\";s:47:\"shop/(.+?)/([^/]+)/wc/file/transient(/(.*))?/?$\";s:83:\"index.php?product_cat=$matches[1]&product=$matches[2]&wc/file/transient=$matches[4]\";s:36:\"shop/(.+?)/([^/]+)/wc-api(/(.*))?/?$\";s:72:\"index.php?product_cat=$matches[1]&product=$matches[2]&wc-api=$matches[4]\";s:51:\"shop/.+?/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:62:\"shop/.+?/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:40:\"shop/.+?/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:51:\"shop/.+?/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:35:\"shop/(.+?)/([^/]+)(?:/([0-9]+))?/?$\";s:70:\"index.php?product_cat=$matches[1]&product=$matches[2]&page=$matches[3]\";s:25:\"shop/.+?/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:35:\"shop/.+?/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:55:\"shop/.+?/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"shop/.+?/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"shop/.+?/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"shop/.+?/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:36:\"wp-story/[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:46:\"wp-story/[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:66:\"wp-story/[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"wp-story/[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:61:\"wp-story/[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:42:\"wp-story/[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:25:\"wp-story/([^/]+)/embed/?$\";s:41:\"index.php?wp-story=$matches[1]&embed=true\";s:29:\"wp-story/([^/]+)/trackback/?$\";s:35:\"index.php?wp-story=$matches[1]&tb=1\";s:37:\"wp-story/([^/]+)/page/?([0-9]{1,})/?$\";s:48:\"index.php?wp-story=$matches[1]&paged=$matches[2]\";s:44:\"wp-story/([^/]+)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?wp-story=$matches[1]&cpage=$matches[2]\";s:45:\"wp-story/([^/]+)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?wp-story=$matches[1]&wc/file/transient=$matches[3]\";s:34:\"wp-story/([^/]+)/wc-api(/(.*))?/?$\";s:49:\"index.php?wp-story=$matches[1]&wc-api=$matches[3]\";s:51:\"wp-story/[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:62:\"wp-story/[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:40:\"wp-story/[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:51:\"wp-story/[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:33:\"wp-story/([^/]+)(?:/([0-9]+))?/?$\";s:47:\"index.php?wp-story=$matches[1]&page=$matches[2]\";s:25:\"wp-story/[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:35:\"wp-story/[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:55:\"wp-story/[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"wp-story/[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:50:\"wp-story/[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:31:\"wp-story/[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:48:\".*wp-(atom|rdf|rss|rss2|feed|commentsrss2)\\.php$\";s:18:\"index.php?feed=old\";s:20:\".*wp-app\\.php(/.*)?$\";s:19:\"index.php?error=403\";s:18:\".*wp-register.php$\";s:23:\"index.php?register=true\";s:32:\"feed/(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:27:\"(feed|rdf|rss|rss2|atom)/?$\";s:27:\"index.php?&feed=$matches[1]\";s:8:\"embed/?$\";s:21:\"index.php?&embed=true\";s:20:\"page/?([0-9]{1,})/?$\";s:28:\"index.php?&paged=$matches[1]\";s:27:\"comment-page-([0-9]{1,})/?$\";s:38:\"index.php?&page_id=2&cpage=$matches[1]\";s:28:\"wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:17:\"wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:41:\"comments/feed/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:36:\"comments/(feed|rdf|rss|rss2|atom)/?$\";s:42:\"index.php?&feed=$matches[1]&withcomments=1\";s:17:\"comments/embed/?$\";s:21:\"index.php?&embed=true\";s:37:\"comments/wc/file/transient(/(.*))?/?$\";s:40:\"index.php?&wc/file/transient=$matches[2]\";s:26:\"comments/wc-api(/(.*))?/?$\";s:29:\"index.php?&wc-api=$matches[2]\";s:44:\"search/(.+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:39:\"search/(.+)/(feed|rdf|rss|rss2|atom)/?$\";s:40:\"index.php?s=$matches[1]&feed=$matches[2]\";s:20:\"search/(.+)/embed/?$\";s:34:\"index.php?s=$matches[1]&embed=true\";s:32:\"search/(.+)/page/?([0-9]{1,})/?$\";s:41:\"index.php?s=$matches[1]&paged=$matches[2]\";s:40:\"search/(.+)/wc/file/transient(/(.*))?/?$\";s:53:\"index.php?s=$matches[1]&wc/file/transient=$matches[3]\";s:29:\"search/(.+)/wc-api(/(.*))?/?$\";s:42:\"index.php?s=$matches[1]&wc-api=$matches[3]\";s:14:\"search/(.+)/?$\";s:23:\"index.php?s=$matches[1]\";s:47:\"author/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:42:\"author/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:50:\"index.php?author_name=$matches[1]&feed=$matches[2]\";s:23:\"author/([^/]+)/embed/?$\";s:44:\"index.php?author_name=$matches[1]&embed=true\";s:35:\"author/([^/]+)/page/?([0-9]{1,})/?$\";s:51:\"index.php?author_name=$matches[1]&paged=$matches[2]\";s:43:\"author/([^/]+)/wc/file/transient(/(.*))?/?$\";s:63:\"index.php?author_name=$matches[1]&wc/file/transient=$matches[3]\";s:32:\"author/([^/]+)/wc-api(/(.*))?/?$\";s:52:\"index.php?author_name=$matches[1]&wc-api=$matches[3]\";s:17:\"author/([^/]+)/?$\";s:33:\"index.php?author_name=$matches[1]\";s:69:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:64:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:80:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&feed=$matches[4]\";s:45:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/embed/?$\";s:74:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&embed=true\";s:57:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:81:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&paged=$matches[4]\";s:65:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:93:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc/file/transient=$matches[5]\";s:54:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:82:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]&wc-api=$matches[5]\";s:39:\"([0-9]{4})/([0-9]{1,2})/([0-9]{1,2})/?$\";s:63:\"index.php?year=$matches[1]&monthnum=$matches[2]&day=$matches[3]\";s:56:\"([0-9]{4})/([0-9]{1,2})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:51:\"([0-9]{4})/([0-9]{1,2})/(feed|rdf|rss|rss2|atom)/?$\";s:64:\"index.php?year=$matches[1]&monthnum=$matches[2]&feed=$matches[3]\";s:32:\"([0-9]{4})/([0-9]{1,2})/embed/?$\";s:58:\"index.php?year=$matches[1]&monthnum=$matches[2]&embed=true\";s:44:\"([0-9]{4})/([0-9]{1,2})/page/?([0-9]{1,})/?$\";s:65:\"index.php?year=$matches[1]&monthnum=$matches[2]&paged=$matches[3]\";s:52:\"([0-9]{4})/([0-9]{1,2})/wc/file/transient(/(.*))?/?$\";s:77:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc/file/transient=$matches[4]\";s:41:\"([0-9]{4})/([0-9]{1,2})/wc-api(/(.*))?/?$\";s:66:\"index.php?year=$matches[1]&monthnum=$matches[2]&wc-api=$matches[4]\";s:26:\"([0-9]{4})/([0-9]{1,2})/?$\";s:47:\"index.php?year=$matches[1]&monthnum=$matches[2]\";s:43:\"([0-9]{4})/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:38:\"([0-9]{4})/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?year=$matches[1]&feed=$matches[2]\";s:19:\"([0-9]{4})/embed/?$\";s:37:\"index.php?year=$matches[1]&embed=true\";s:31:\"([0-9]{4})/page/?([0-9]{1,})/?$\";s:44:\"index.php?year=$matches[1]&paged=$matches[2]\";s:39:\"([0-9]{4})/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?year=$matches[1]&wc/file/transient=$matches[3]\";s:28:\"([0-9]{4})/wc-api(/(.*))?/?$\";s:45:\"index.php?year=$matches[1]&wc-api=$matches[3]\";s:13:\"([0-9]{4})/?$\";s:26:\"index.php?year=$matches[1]\";s:27:\".?.+?/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\".?.+?/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\".?.+?/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\".?.+?/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\".?.+?/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"(.?.+?)/embed/?$\";s:41:\"index.php?pagename=$matches[1]&embed=true\";s:20:\"(.?.+?)/trackback/?$\";s:35:\"index.php?pagename=$matches[1]&tb=1\";s:40:\"(.?.+?)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:35:\"(.?.+?)/(feed|rdf|rss|rss2|atom)/?$\";s:47:\"index.php?pagename=$matches[1]&feed=$matches[2]\";s:28:\"(.?.+?)/page/?([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&paged=$matches[2]\";s:35:\"(.?.+?)/comment-page-([0-9]{1,})/?$\";s:48:\"index.php?pagename=$matches[1]&cpage=$matches[2]\";s:36:\"(.?.+?)/wc/file/transient(/(.*))?/?$\";s:60:\"index.php?pagename=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"(.?.+?)/wc-api(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&wc-api=$matches[3]\";s:28:\"(.?.+?)/order-pay(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&order-pay=$matches[3]\";s:33:\"(.?.+?)/order-received(/(.*))?/?$\";s:57:\"index.php?pagename=$matches[1]&order-received=$matches[3]\";s:25:\"(.?.+?)/orders(/(.*))?/?$\";s:49:\"index.php?pagename=$matches[1]&orders=$matches[3]\";s:29:\"(.?.+?)/view-order(/(.*))?/?$\";s:53:\"index.php?pagename=$matches[1]&view-order=$matches[3]\";s:28:\"(.?.+?)/downloads(/(.*))?/?$\";s:52:\"index.php?pagename=$matches[1]&downloads=$matches[3]\";s:31:\"(.?.+?)/edit-account(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-account=$matches[3]\";s:31:\"(.?.+?)/edit-address(/(.*))?/?$\";s:55:\"index.php?pagename=$matches[1]&edit-address=$matches[3]\";s:34:\"(.?.+?)/payment-methods(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&payment-methods=$matches[3]\";s:32:\"(.?.+?)/lost-password(/(.*))?/?$\";s:56:\"index.php?pagename=$matches[1]&lost-password=$matches[3]\";s:34:\"(.?.+?)/customer-logout(/(.*))?/?$\";s:58:\"index.php?pagename=$matches[1]&customer-logout=$matches[3]\";s:37:\"(.?.+?)/add-payment-method(/(.*))?/?$\";s:61:\"index.php?pagename=$matches[1]&add-payment-method=$matches[3]\";s:40:\"(.?.+?)/delete-payment-method(/(.*))?/?$\";s:64:\"index.php?pagename=$matches[1]&delete-payment-method=$matches[3]\";s:45:\"(.?.+?)/set-default-payment-method(/(.*))?/?$\";s:69:\"index.php?pagename=$matches[1]&set-default-payment-method=$matches[3]\";s:27:\"(.?.+?)/waitlist(/(.*))?/?$\";s:51:\"index.php?pagename=$matches[1]&waitlist=$matches[3]\";s:42:\".?.+?/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\".?.+?/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\".?.+?/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\".?.+?/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"(.?.+?)(?:/([0-9]+))?/?$\";s:47:\"index.php?pagename=$matches[1]&page=$matches[2]\";s:27:\"[^/]+/attachment/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:37:\"[^/]+/attachment/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:57:\"[^/]+/attachment/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:52:\"[^/]+/attachment/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:33:\"[^/]+/attachment/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";s:16:\"([^/]+)/embed/?$\";s:37:\"index.php?name=$matches[1]&embed=true\";s:20:\"([^/]+)/trackback/?$\";s:31:\"index.php?name=$matches[1]&tb=1\";s:40:\"([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:35:\"([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:43:\"index.php?name=$matches[1]&feed=$matches[2]\";s:28:\"([^/]+)/page/?([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&paged=$matches[2]\";s:35:\"([^/]+)/comment-page-([0-9]{1,})/?$\";s:44:\"index.php?name=$matches[1]&cpage=$matches[2]\";s:36:\"([^/]+)/wc/file/transient(/(.*))?/?$\";s:56:\"index.php?name=$matches[1]&wc/file/transient=$matches[3]\";s:25:\"([^/]+)/wc-api(/(.*))?/?$\";s:45:\"index.php?name=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:53:\"[^/]+/attachment/([^/]+)/wc/file/transient(/(.*))?/?$\";s:62:\"index.php?attachment=$matches[1]&wc/file/transient=$matches[3]\";s:31:\"[^/]+/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:42:\"[^/]+/attachment/([^/]+)/wc-api(/(.*))?/?$\";s:51:\"index.php?attachment=$matches[1]&wc-api=$matches[3]\";s:24:\"([^/]+)(?:/([0-9]+))?/?$\";s:43:\"index.php?name=$matches[1]&page=$matches[2]\";s:16:\"[^/]+/([^/]+)/?$\";s:32:\"index.php?attachment=$matches[1]\";s:26:\"[^/]+/([^/]+)/trackback/?$\";s:37:\"index.php?attachment=$matches[1]&tb=1\";s:46:\"[^/]+/([^/]+)/feed/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/(feed|rdf|rss|rss2|atom)/?$\";s:49:\"index.php?attachment=$matches[1]&feed=$matches[2]\";s:41:\"[^/]+/([^/]+)/comment-page-([0-9]{1,})/?$\";s:50:\"index.php?attachment=$matches[1]&cpage=$matches[2]\";s:22:\"[^/]+/([^/]+)/embed/?$\";s:43:\"index.php?attachment=$matches[1]&embed=true\";}", "on");
INSERT INTO `wp_options` VALUES("6303", "_transient_timeout_wc_block_product_filter_attribute_default_attribute", "1749655646", "off");
INSERT INTO `wp_options` VALUES("6304", "_transient_wc_block_product_filter_attribute_default_attribute", "O:8:\"stdClass\":6:{s:12:\"attribute_id\";s:1:\"1\";s:14:\"attribute_name\";s:5:\"color\";s:15:\"attribute_label\";s:6:\"رنگ\";s:14:\"attribute_type\";s:6:\"select\";s:17:\"attribute_orderby\";s:10:\"menu_order\";s:16:\"attribute_public\";i:0;}", "off");
INSERT INTO `wp_options` VALUES("5779", "_transient_orders-transient-version", "1748777060", "on");
INSERT INTO `wp_options` VALUES("5780", "_transient_timeout_wc_customer_bought_product_ab065ab03af0371d6f284ae0ba2016f3", "1751369060", "off");
INSERT INTO `wp_options` VALUES("5781", "_transient_wc_customer_bought_product_ab065ab03af0371d6f284ae0ba2016f3", "a:2:{s:7:\"version\";s:10:\"1748777060\";s:5:\"value\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("6280", "_transient_timeout_last_fetch_patterns_request", "1749572842", "off");
INSERT INTO `wp_options` VALUES("6281", "_transient_last_fetch_patterns_request", "1749569242", "off");
INSERT INTO `wp_options` VALUES("31", "hack_file", "0", "on");
INSERT INTO `wp_options` VALUES("32", "blog_charset", "UTF-8", "on");
INSERT INTO `wp_options` VALUES("33", "moderation_keys", "", "off");
INSERT INTO `wp_options` VALUES("34", "active_plugins", "a:8:{i:0;s:29:\"RTL-CareUnit/RTL-CareUnit.php\";i:1;s:35:\"classic-widgets/classic-widgets.php\";i:2;s:36:\"contact-form-7/wp-contact-form-7.php\";i:3;s:25:\"duplicator/duplicator.php\";i:4;s:23:\"elementor/elementor.php\";i:5;s:27:\"woocommerce/woocommerce.php\";i:6;s:31:\"woodmart-core/woodmart-core.php\";i:7;s:21:\"wp-story/wp-story.php\";}", "on");
INSERT INTO `wp_options` VALUES("35", "category_base", "", "on");
INSERT INTO `wp_options` VALUES("36", "ping_sites", "http://rpc.pingomatic.com/", "on");
INSERT INTO `wp_options` VALUES("37", "comment_max_links", "2", "on");
INSERT INTO `wp_options` VALUES("38", "gmt_offset", "3.5", "on");
INSERT INTO `wp_options` VALUES("39", "default_email_category", "1", "on");
INSERT INTO `wp_options` VALUES("40", "recently_edited", "", "off");
INSERT INTO `wp_options` VALUES("41", "template", "woodmart", "on");
INSERT INTO `wp_options` VALUES("42", "stylesheet", "woodmart", "on");
INSERT INTO `wp_options` VALUES("43", "comment_registration", "0", "on");
INSERT INTO `wp_options` VALUES("44", "html_type", "text/html", "on");
INSERT INTO `wp_options` VALUES("45", "use_trackback", "0", "on");
INSERT INTO `wp_options` VALUES("46", "default_role", "subscriber", "on");
INSERT INTO `wp_options` VALUES("47", "db_version", "58975", "on");
INSERT INTO `wp_options` VALUES("48", "uploads_use_yearmonth_folders", "1", "on");
INSERT INTO `wp_options` VALUES("49", "upload_path", "", "on");
INSERT INTO `wp_options` VALUES("50", "blog_public", "1", "on");
INSERT INTO `wp_options` VALUES("51", "default_link_category", "2", "on");
INSERT INTO `wp_options` VALUES("52", "show_on_front", "page", "on");
INSERT INTO `wp_options` VALUES("53", "tag_base", "", "on");
INSERT INTO `wp_options` VALUES("54", "show_avatars", "1", "on");
INSERT INTO `wp_options` VALUES("55", "avatar_rating", "G", "on");
INSERT INTO `wp_options` VALUES("56", "upload_url_path", "", "on");
INSERT INTO `wp_options` VALUES("57", "thumbnail_size_w", "150", "on");
INSERT INTO `wp_options` VALUES("58", "thumbnail_size_h", "150", "on");
INSERT INTO `wp_options` VALUES("59", "thumbnail_crop", "1", "on");
INSERT INTO `wp_options` VALUES("60", "medium_size_w", "300", "on");
INSERT INTO `wp_options` VALUES("61", "medium_size_h", "300", "on");
INSERT INTO `wp_options` VALUES("62", "avatar_default", "mystery", "on");
INSERT INTO `wp_options` VALUES("63", "large_size_w", "1024", "on");
INSERT INTO `wp_options` VALUES("64", "large_size_h", "1024", "on");
INSERT INTO `wp_options` VALUES("65", "image_default_link_type", "none", "on");
INSERT INTO `wp_options` VALUES("66", "image_default_size", "", "on");
INSERT INTO `wp_options` VALUES("67", "image_default_align", "", "on");
INSERT INTO `wp_options` VALUES("68", "close_comments_for_old_posts", "0", "on");
INSERT INTO `wp_options` VALUES("69", "close_comments_days_old", "14", "on");
INSERT INTO `wp_options` VALUES("70", "thread_comments", "1", "on");
INSERT INTO `wp_options` VALUES("71", "thread_comments_depth", "5", "on");
INSERT INTO `wp_options` VALUES("72", "page_comments", "0", "on");
INSERT INTO `wp_options` VALUES("73", "comments_per_page", "50", "on");
INSERT INTO `wp_options` VALUES("74", "default_comments_page", "newest", "on");
INSERT INTO `wp_options` VALUES("75", "comment_order", "asc", "on");
INSERT INTO `wp_options` VALUES("76", "sticky_posts", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("77", "widget_categories", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("78", "widget_text", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("79", "widget_rss", "a:2:{i:1;a:0:{}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("80", "uninstall_plugins", "a:1:{s:23:\"elementor/elementor.php\";a:2:{i:0;s:21:\"Elementor\\Maintenance\";i:1;s:9:\"uninstall\";}}", "off");
INSERT INTO `wp_options` VALUES("81", "timezone_string", "", "on");
INSERT INTO `wp_options` VALUES("82", "page_for_posts", "37", "on");
INSERT INTO `wp_options` VALUES("83", "page_on_front", "2", "on");
INSERT INTO `wp_options` VALUES("84", "default_post_format", "0", "on");
INSERT INTO `wp_options` VALUES("85", "link_manager_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("86", "finished_splitting_shared_terms", "1", "on");
INSERT INTO `wp_options` VALUES("87", "site_icon", "765", "on");
INSERT INTO `wp_options` VALUES("88", "medium_large_size_w", "768", "on");
INSERT INTO `wp_options` VALUES("89", "medium_large_size_h", "0", "on");
INSERT INTO `wp_options` VALUES("90", "wp_page_for_privacy_policy", "3", "on");
INSERT INTO `wp_options` VALUES("91", "show_comments_cookies_opt_in", "1", "on");
INSERT INTO `wp_options` VALUES("92", "admin_email_lifespan", "1760443389", "on");
INSERT INTO `wp_options` VALUES("93", "disallowed_keys", "", "off");
INSERT INTO `wp_options` VALUES("94", "comment_previously_approved", "1", "on");
INSERT INTO `wp_options` VALUES("95", "auto_plugin_theme_update_emails", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("96", "auto_update_core_dev", "enabled", "on");
INSERT INTO `wp_options` VALUES("97", "auto_update_core_minor", "enabled", "on");
INSERT INTO `wp_options` VALUES("98", "auto_update_core_major", "enabled", "on");
INSERT INTO `wp_options` VALUES("99", "wp_force_deactivated_plugins", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("100", "wp_attachment_pages_enabled", "0", "on");
INSERT INTO `wp_options` VALUES("101", "initial_db_version", "58975", "on");
INSERT INTO `wp_options` VALUES("102", "wp_user_roles", "a:7:{s:13:\"administrator\";a:2:{s:4:\"name\";s:13:\"Administrator\";s:12:\"capabilities\";a:115:{s:13:\"switch_themes\";b:1;s:11:\"edit_themes\";b:1;s:16:\"activate_plugins\";b:1;s:12:\"edit_plugins\";b:1;s:10:\"edit_users\";b:1;s:10:\"edit_files\";b:1;s:14:\"manage_options\";b:1;s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:6:\"import\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:8:\"level_10\";b:1;s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;s:12:\"delete_users\";b:1;s:12:\"create_users\";b:1;s:17:\"unfiltered_upload\";b:1;s:14:\"edit_dashboard\";b:1;s:14:\"update_plugins\";b:1;s:14:\"delete_plugins\";b:1;s:15:\"install_plugins\";b:1;s:13:\"update_themes\";b:1;s:14:\"install_themes\";b:1;s:11:\"update_core\";b:1;s:10:\"list_users\";b:1;s:12:\"remove_users\";b:1;s:13:\"promote_users\";b:1;s:18:\"edit_theme_options\";b:1;s:13:\"delete_themes\";b:1;s:6:\"export\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:16:\"create_customers\";b:1;}}s:6:\"editor\";a:2:{s:4:\"name\";s:6:\"Editor\";s:12:\"capabilities\";a:34:{s:17:\"moderate_comments\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:12:\"upload_files\";b:1;s:15:\"unfiltered_html\";b:1;s:10:\"edit_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:10:\"edit_pages\";b:1;s:4:\"read\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:17:\"edit_others_pages\";b:1;s:20:\"edit_published_pages\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_pages\";b:1;s:19:\"delete_others_pages\";b:1;s:22:\"delete_published_pages\";b:1;s:12:\"delete_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:22:\"delete_published_posts\";b:1;s:20:\"delete_private_posts\";b:1;s:18:\"edit_private_posts\";b:1;s:18:\"read_private_posts\";b:1;s:20:\"delete_private_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"read_private_pages\";b:1;}}s:6:\"author\";a:2:{s:4:\"name\";s:6:\"Author\";s:12:\"capabilities\";a:10:{s:12:\"upload_files\";b:1;s:10:\"edit_posts\";b:1;s:20:\"edit_published_posts\";b:1;s:13:\"publish_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;s:22:\"delete_published_posts\";b:1;}}s:11:\"contributor\";a:2:{s:4:\"name\";s:11:\"Contributor\";s:12:\"capabilities\";a:5:{s:10:\"edit_posts\";b:1;s:4:\"read\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:12:\"delete_posts\";b:1;}}s:10:\"subscriber\";a:2:{s:4:\"name\";s:10:\"Subscriber\";s:12:\"capabilities\";a:2:{s:4:\"read\";b:1;s:7:\"level_0\";b:1;}}s:8:\"customer\";a:2:{s:4:\"name\";s:8:\"Customer\";s:12:\"capabilities\";a:1:{s:4:\"read\";b:1;}}s:12:\"shop_manager\";a:2:{s:4:\"name\";s:12:\"Shop manager\";s:12:\"capabilities\";a:93:{s:7:\"level_9\";b:1;s:7:\"level_8\";b:1;s:7:\"level_7\";b:1;s:7:\"level_6\";b:1;s:7:\"level_5\";b:1;s:7:\"level_4\";b:1;s:7:\"level_3\";b:1;s:7:\"level_2\";b:1;s:7:\"level_1\";b:1;s:7:\"level_0\";b:1;s:4:\"read\";b:1;s:18:\"read_private_pages\";b:1;s:18:\"read_private_posts\";b:1;s:10:\"edit_posts\";b:1;s:10:\"edit_pages\";b:1;s:20:\"edit_published_posts\";b:1;s:20:\"edit_published_pages\";b:1;s:18:\"edit_private_pages\";b:1;s:18:\"edit_private_posts\";b:1;s:17:\"edit_others_posts\";b:1;s:17:\"edit_others_pages\";b:1;s:13:\"publish_posts\";b:1;s:13:\"publish_pages\";b:1;s:12:\"delete_posts\";b:1;s:12:\"delete_pages\";b:1;s:20:\"delete_private_pages\";b:1;s:20:\"delete_private_posts\";b:1;s:22:\"delete_published_pages\";b:1;s:22:\"delete_published_posts\";b:1;s:19:\"delete_others_posts\";b:1;s:19:\"delete_others_pages\";b:1;s:17:\"manage_categories\";b:1;s:12:\"manage_links\";b:1;s:17:\"moderate_comments\";b:1;s:12:\"upload_files\";b:1;s:6:\"export\";b:1;s:6:\"import\";b:1;s:10:\"list_users\";b:1;s:18:\"edit_theme_options\";b:1;s:18:\"manage_woocommerce\";b:1;s:24:\"view_woocommerce_reports\";b:1;s:12:\"edit_product\";b:1;s:12:\"read_product\";b:1;s:14:\"delete_product\";b:1;s:13:\"edit_products\";b:1;s:20:\"edit_others_products\";b:1;s:16:\"publish_products\";b:1;s:21:\"read_private_products\";b:1;s:15:\"delete_products\";b:1;s:23:\"delete_private_products\";b:1;s:25:\"delete_published_products\";b:1;s:22:\"delete_others_products\";b:1;s:21:\"edit_private_products\";b:1;s:23:\"edit_published_products\";b:1;s:20:\"manage_product_terms\";b:1;s:18:\"edit_product_terms\";b:1;s:20:\"delete_product_terms\";b:1;s:20:\"assign_product_terms\";b:1;s:15:\"edit_shop_order\";b:1;s:15:\"read_shop_order\";b:1;s:17:\"delete_shop_order\";b:1;s:16:\"edit_shop_orders\";b:1;s:23:\"edit_others_shop_orders\";b:1;s:19:\"publish_shop_orders\";b:1;s:24:\"read_private_shop_orders\";b:1;s:18:\"delete_shop_orders\";b:1;s:26:\"delete_private_shop_orders\";b:1;s:28:\"delete_published_shop_orders\";b:1;s:25:\"delete_others_shop_orders\";b:1;s:24:\"edit_private_shop_orders\";b:1;s:26:\"edit_published_shop_orders\";b:1;s:23:\"manage_shop_order_terms\";b:1;s:21:\"edit_shop_order_terms\";b:1;s:23:\"delete_shop_order_terms\";b:1;s:23:\"assign_shop_order_terms\";b:1;s:16:\"edit_shop_coupon\";b:1;s:16:\"read_shop_coupon\";b:1;s:18:\"delete_shop_coupon\";b:1;s:17:\"edit_shop_coupons\";b:1;s:24:\"edit_others_shop_coupons\";b:1;s:20:\"publish_shop_coupons\";b:1;s:25:\"read_private_shop_coupons\";b:1;s:19:\"delete_shop_coupons\";b:1;s:27:\"delete_private_shop_coupons\";b:1;s:29:\"delete_published_shop_coupons\";b:1;s:26:\"delete_others_shop_coupons\";b:1;s:25:\"edit_private_shop_coupons\";b:1;s:27:\"edit_published_shop_coupons\";b:1;s:24:\"manage_shop_coupon_terms\";b:1;s:22:\"edit_shop_coupon_terms\";b:1;s:24:\"delete_shop_coupon_terms\";b:1;s:24:\"assign_shop_coupon_terms\";b:1;s:16:\"create_customers\";b:1;}}}", "on");
INSERT INTO `wp_options` VALUES("103", "fresh_site", "0", "off");
INSERT INTO `wp_options` VALUES("104", "WPLANG", "fa_IR", "auto");
INSERT INTO `wp_options` VALUES("105", "user_count", "1", "off");
INSERT INTO `wp_options` VALUES("106", "widget_block", "a:6:{i:2;a:1:{s:7:\"content\";s:19:\"<!-- wp:search /-->\";}i:3;a:1:{s:7:\"content\";s:170:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>نوشته‌های تازه</h2><!-- /wp:heading --><!-- wp:latest-posts /--></div><!-- /wp:group -->\";}i:4;a:1:{s:7:\"content\";s:242:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>آخرین دیدگاه‌ها</h2><!-- /wp:heading --><!-- wp:latest-comments {\"displayAvatar\":false,\"displayDate\":false,\"displayExcerpt\":false} /--></div><!-- /wp:group -->\";}i:5;a:1:{s:7:\"content\";s:159:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>بایگانی‌ها</h2><!-- /wp:heading --><!-- wp:archives /--></div><!-- /wp:group -->\";}i:6;a:1:{s:7:\"content\";s:155:\"<!-- wp:group --><div class=\"wp-block-group\"><!-- wp:heading --><h2>دسته‌ها</h2><!-- /wp:heading --><!-- wp:categories /--></div><!-- /wp:group -->\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("107", "sidebars_widgets", "a:15:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:5:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";i:3;s:7:\"block-5\";i:4;s:7:\"block-6\";}s:22:\"portfolio-widgets-area\";a:0:{}s:12:\"sidebar-shop\";a:4:{i:0;s:24:\"wd-widget-stock-status-2\";i:1;s:32:\"woocommerce_product_categories-2\";i:2;s:34:\"woodmart-woocommerce-layered-nav-2\";i:3;s:26:\"woocommerce_price_filter-2\";}s:12:\"filters-area\";a:0:{}s:22:\"sidebar-product-single\";a:0:{}s:18:\"sidebar-my-account\";a:0:{}s:24:\"sidebar-full-screen-menu\";a:0:{}s:19:\"mobile-menu-widgets\";a:0:{}s:8:\"footer-1\";a:0:{}s:8:\"footer-2\";a:0:{}s:8:\"footer-3\";a:0:{}s:8:\"footer-4\";a:0:{}s:8:\"footer-5\";a:0:{}s:13:\"array_version\";i:3;}", "auto");
INSERT INTO `wp_options` VALUES("108", "widget_pages", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("109", "widget_calendar", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("110", "widget_archives", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("111", "widget_media_audio", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("112", "widget_media_image", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("113", "widget_media_gallery", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("114", "widget_media_video", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("115", "widget_meta", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("116", "widget_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("117", "widget_recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("118", "widget_recent-comments", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("119", "widget_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("120", "widget_nav_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("121", "widget_custom_html", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("155", "woodmart-generated-wpbcss-file", "", "auto");
INSERT INTO `wp_options` VALUES("156", "woodmart_is_activated", "", "auto");
INSERT INTO `wp_options` VALUES("158", "xts-options-presets", "", "auto");
INSERT INTO `wp_options` VALUES("3549", "woocommerce_tracker_ua", "a:2:{i:0;s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/136.0.0.0 Safari/537.36\";i:1;s:111:\"Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/135.0.0.0 Safari/537.36\";}", "off");
INSERT INTO `wp_options` VALUES("6265", "_transient_timeout_wc_tracks_blog_details", "1749655448", "off");
INSERT INTO `wp_options` VALUES("6266", "_transient_wc_tracks_blog_details", "a:6:{s:3:\"url\";s:37:\"https://demoes.aramis-co.ir/Underwear\";s:9:\"blog_lang\";s:5:\"fa_IR\";s:7:\"blog_id\";b:0;s:8:\"store_id\";s:36:\"5d57d75c-8337-4c12-b5b3-8ffcee3193c1\";s:14:\"products_count\";s:1:\"8\";s:10:\"wc_version\";s:5:\"9.8.4\";}", "off");
INSERT INTO `wp_options` VALUES("428", "_transient_timeout_woocommerce_blocks_asset_api_script_data_ssl", "1752161290", "off");
INSERT INTO `wp_options` VALUES("429", "_transient_woocommerce_blocks_asset_api_script_data_ssl", "{\"script_data\":{\"assets\\/client\\/blocks\\/wc-settings.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-settings.js\",\"version\":\"f90cafcdd4c1f0e3651b\",\"dependencies\":[\"wp-hooks\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-types.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-types.js\",\"version\":\"99f253ed9c4c6493f0d5\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-middleware.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-middleware.js\",\"version\":\"d79dedade2f2e4dc9df4\",\"dependencies\":[\"wp-api-fetch\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/wc-blocks-data.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-data.js\",\"version\":\"6266eadfa1c6657e6835\",\"dependencies\":[\"wc-blocks-checkout-events\",\"wc-blocks-registry\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-data\",\"wp-data-controls\",\"wp-deprecated\",\"wp-dom\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-notices\",\"wp-polyfill\",\"wp-url\"]},\"assets\\/client\\/blocks\\/wc-blocks-vendors.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-vendors.js\",\"version\":\"75d3533c33b46049ee88\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-registry.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-registry.js\",\"version\":\"96479001b0fbd0c70f36\",\"dependencies\":[\"react-jsx-runtime\",\"wc-settings\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-hooks\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks.js\",\"version\":\"0db759a8a6e010732c50\",\"dependencies\":[\"react-jsx-runtime\",\"wp-blocks\",\"wp-compose\",\"wp-element\",\"wp-hooks\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-shared-context.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-shared-context.js\",\"version\":\"1d9ff4f03584490ad390\",\"dependencies\":[\"react-jsx-runtime\",\"wp-element\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-shared-hocs.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-shared-hocs.js\",\"version\":\"99a2a0de38bfa707fc7b\",\"dependencies\":[\"react-jsx-runtime\",\"wc-blocks-data-store\",\"wc-blocks-shared-context\",\"wc-types\",\"wp-data\",\"wp-element\",\"wp-is-shallow-equal\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/price-format.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/price-format.js\",\"version\":\"5f0dedeb373c5bb189ff\",\"dependencies\":[\"wc-settings\",\"wp-html-entities\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-blocks-frontend-vendors-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-blocks-frontend-vendors-frontend.js\",\"version\":\"2a67f05c7f92833d4e15\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-cart-checkout-vendors-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-cart-checkout-vendors-frontend.js\",\"version\":\"d8b1ce115c3935c88bec\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/wc-cart-checkout-base-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-cart-checkout-base-frontend.js\",\"version\":\"8ef63f9f37dcac4d2fb0\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/blocks-checkout.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-checkout.js\",\"version\":\"831c209cc1dd2f820fc4\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"react-dom\",\"react-jsx-runtime\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\",\"wp-warning\"]},\"assets\\/client\\/blocks\\/blocks-checkout-events.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-checkout-events.js\",\"version\":\"2d0fd4590f6cc663947c\",\"dependencies\":[\"wc-types\",\"wp-polyfill\"]},\"assets\\/client\\/blocks\\/blocks-components.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/blocks-components.js\",\"version\":\"150bd47634d08fcc2dfc\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"react-dom\",\"react-jsx-runtime\",\"wc-blocks-data-store\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-html-entities\",\"wp-i18n\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\"]},\"assets\\/client\\/blocks\\/wc-schema-parser.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-schema-parser.js\",\"version\":\"f762078aeb4207fe9c3d\",\"dependencies\":[\"wp-polyfill\"]},\"assets\\/client\\/admin\\/customer-effort-score\\/index.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/admin\\/customer-effort-score\\/index.js\",\"version\":\"02f7a2e1496459cb9229\",\"dependencies\":[\"react\",\"wc-experimental\",\"wc-navigation\",\"wc-store-data\",\"wc-tracks\",\"wp-api-fetch\",\"wp-components\",\"wp-compose\",\"wp-data\",\"wp-data-controls\",\"wp-element\",\"wp-i18n\"]},\"assets\\/client\\/blocks\\/mini-cart-component-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-component-frontend.js\",\"version\":\"2578b29b4939339ab9a4\",\"dependencies\":[\"wc-cart-checkout-base\",\"wc-cart-checkout-vendors\",\"react\",\"react-jsx-runtime\",\"wc-blocks-checkout\",\"wc-blocks-components\",\"wc-blocks-data-store\",\"wc-blocks-registry\",\"wc-price-format\",\"wc-settings\",\"wc-types\",\"wp-a11y\",\"wp-autop\",\"wp-compose\",\"wp-data\",\"wp-deprecated\",\"wp-element\",\"wp-hooks\",\"wp-html-entities\",\"wp-i18n\",\"wp-is-shallow-equal\",\"wp-keycodes\",\"wp-polyfill\",\"wp-primitives\",\"wp-style-engine\",\"wp-url\",\"wp-wordcount\"]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-frontend.js\",\"version\":\"wc-9.9.3\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-frontend.js\",\"version\":\"wc-9.9.3\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/filled-cart-style.js\",\"version\":\"wc-9.9.3\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-frontend.js\",\"version\":\"wc-9.9.3\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-items-counter-style.js\",\"version\":\"wc-9.9.3\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-frontend.js\",\"version\":\"wc-9.9.3\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-style.js\",\"version\":\"wc-9.9.3\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/shopping-button-style.js\",\"version\":\"wc-9.9.3\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-style.js\",\"version\":\"wc-9.9.3\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/items-frontend.js\",\"version\":\"wc-9.9.3\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-style.js\",\"version\":\"wc-9.9.3\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-frontend.js\",\"version\":\"wc-9.9.3\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-label-style.js\",\"version\":\"wc-9.9.3\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-frontend.js\",\"version\":\"wc-9.9.3\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/footer-style.js\",\"version\":\"wc-9.9.3\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/title-style.js\",\"version\":\"wc-9.9.3\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-frontend.js\",\"version\":\"wc-9.9.3\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/empty-cart-frontend.js\",\"version\":\"wc-9.9.3\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/cart-button-frontend.js\",\"version\":\"wc-9.9.3\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/products-table-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/products-table-frontend.js\",\"version\":\"wc-9.9.3\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-style.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/mini-cart-contents-block\\/checkout-button-style.js\",\"version\":\"wc-9.9.3\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/cart-blocks\\/cart-line-items--mini-cart-contents-block\\/products-table-frontend.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/cart-blocks\\/cart-line-items--mini-cart-contents-block\\/products-table-frontend.js\",\"version\":\"wc-9.9.3\",\"dependencies\":[]},\"assets\\/client\\/blocks\\/wc-shipping-method-pickup-location.js\":{\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/Underwear\\/wp-content\\/plugins\\/woocommerce\\/assets\\/client\\/blocks\\/wc-shipping-method-pickup-location.js\",\"version\":\"0446a66f2604add5f739\",\"dependencies\":[\"react\",\"react-dom\",\"react-jsx-runtime\",\"wc-settings\",\"wc-types\",\"wp-api-fetch\",\"wp-components\",\"wp-data\",\"wp-element\",\"wp-i18n\",\"wp-notices\",\"wp-polyfill\",\"wp-primitives\",\"wp-url\"]}},\"version\":\"wc-9.9.3\",\"hash\":\"c3454139a1293f620d9765360e3cef44\"}", "off");
INSERT INTO `wp_options` VALUES("6313", "_elementor_element_cache_unique_id", "e50cb2a9fb1f49f2858e4ca47181a2e6", "auto");
INSERT INTO `wp_options` VALUES("6314", "_elementor_assets_data", "a:1:{s:3:\"svg\";a:1:{s:9:\"font-icon\";a:16:{s:9:\"fas-phone\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"path\";s:281:\"M493.4 24.6l-104-24c-11.3-2.6-22.9 3.3-27.5 13.9l-48 112c-4.2 9.8-1.4 21.3 6.9 28l60.6 49.6c-36 76.7-98.9 140.5-177.2 177.2l-49.6-60.6c-6.8-8.3-18.2-11.1-28-6.9l-112 48C3.9 366.5-2 378.1.6 389.4l24 104C27.1 504.2 36.7 512 48 512c256.1 0 464-207.5 464-464 0-11.2-7.7-20.9-18.6-23.4z\";s:3:\"key\";s:9:\"fas-phone\";}s:7:\"version\";s:6:\"5.15.3\";}s:19:\"fas-shopping-basket\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:576;s:6:\"height\";i:512;s:4:\"path\";s:762:\"M576 216v16c0 13.255-10.745 24-24 24h-8l-26.113 182.788C514.509 462.435 494.257 480 470.37 480H105.63c-23.887 0-44.139-17.565-47.518-41.212L32 256h-8c-13.255 0-24-10.745-24-24v-16c0-13.255 10.745-24 24-24h67.341l106.78-146.821c10.395-14.292 30.407-17.453 44.701-7.058 14.293 10.395 17.453 30.408 7.058 44.701L170.477 192h235.046L326.12 82.821c-10.395-14.292-7.234-34.306 7.059-44.701 14.291-10.395 34.306-7.235 44.701 7.058L484.659 192H552c13.255 0 24 10.745 24 24zM312 392V280c0-13.255-10.745-24-24-24s-24 10.745-24 24v112c0 13.255 10.745 24 24 24s24-10.745 24-24zm112 0V280c0-13.255-10.745-24-24-24s-24 10.745-24 24v112c0 13.255 10.745 24 24 24s24-10.745 24-24zm-224 0V280c0-13.255-10.745-24-24-24s-24 10.745-24 24v112c0 13.255 10.745 24 24 24s24-10.745 24-24z\";s:3:\"key\";s:19:\"fas-shopping-basket\";}s:7:\"version\";s:6:\"5.15.3\";}s:14:\"fas-dot-circle\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"path\";s:171:\"M256 8C119.033 8 8 119.033 8 256s111.033 248 248 248 248-111.033 248-248S392.967 8 256 8zm80 248c0 44.112-35.888 80-80 80s-80-35.888-80-80 35.888-80 80-80 80 35.888 80 80z\";s:3:\"key\";s:14:\"fas-dot-circle\";}s:7:\"version\";s:6:\"5.15.3\";}s:14:\"fas-angle-left\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:256;s:6:\"height\";i:512;s:4:\"path\";s:188:\"M31.7 239l136-136c9.4-9.4 24.6-9.4 33.9 0l22.6 22.6c9.4 9.4 9.4 24.6 0 33.9L127.9 256l96.4 96.4c9.4 9.4 9.4 24.6 0 33.9L201.7 409c-9.4 9.4-24.6 9.4-33.9 0l-136-136c-9.5-9.4-9.5-24.6-.1-34z\";s:3:\"key\";s:14:\"fas-angle-left\";}s:7:\"version\";s:6:\"5.15.3\";}s:9:\"fas-minus\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:448;s:6:\"height\";i:512;s:4:\"path\";s:116:\"M416 208H32c-17.67 0-32 14.33-32 32v32c0 17.67 14.33 32 32 32h384c17.67 0 32-14.33 32-32v-32c0-17.67-14.33-32-32-32z\";s:3:\"key\";s:9:\"fas-minus\";}s:7:\"version\";s:6:\"5.15.3\";}s:18:\"far-money-bill-alt\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:640;s:6:\"height\";i:512;s:4:\"path\";s:585:\"M320 144c-53.02 0-96 50.14-96 112 0 61.85 42.98 112 96 112 53 0 96-50.13 96-112 0-61.86-42.98-112-96-112zm40 168c0 4.42-3.58 8-8 8h-64c-4.42 0-8-3.58-8-8v-16c0-4.42 3.58-8 8-8h16v-55.44l-.47.31a7.992 7.992 0 0 1-11.09-2.22l-8.88-13.31a7.992 7.992 0 0 1 2.22-11.09l15.33-10.22a23.99 23.99 0 0 1 13.31-4.03H328c4.42 0 8 3.58 8 8v88h16c4.42 0 8 3.58 8 8v16zM608 64H32C14.33 64 0 78.33 0 96v320c0 17.67 14.33 32 32 32h576c17.67 0 32-14.33 32-32V96c0-17.67-14.33-32-32-32zm-16 272c-35.35 0-64 28.65-64 64H112c0-35.35-28.65-64-64-64V176c35.35 0 64-28.65 64-64h416c0 35.35 28.65 64 64 64v160z\";s:3:\"key\";s:18:\"far-money-bill-alt\";}s:7:\"version\";s:6:\"5.15.3\";}s:12:\"fab-whatsapp\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:448;s:6:\"height\";i:512;s:4:\"path\";s:886:\"M380.9 97.1C339 55.1 283.2 32 223.9 32c-122.4 0-222 99.6-222 222 0 39.1 10.2 77.3 29.6 111L0 480l117.7-30.9c32.4 17.7 68.9 27 106.1 27h.1c122.3 0 224.1-99.6 224.1-222 0-59.3-25.2-115-67.1-157zm-157 341.6c-33.2 0-65.7-8.9-94-25.7l-6.7-4-69.8 18.3L72 359.2l-4.4-7c-18.5-29.4-28.2-63.3-28.2-98.2 0-101.7 82.8-184.5 184.6-184.5 49.3 0 95.6 19.2 130.4 54.1 34.8 34.9 56.2 81.2 56.1 130.5 0 101.8-84.9 184.6-186.6 184.6zm101.2-138.2c-5.5-2.8-32.8-16.2-37.9-18-5.1-1.9-8.8-2.8-12.5 2.8-3.7 5.6-14.3 18-17.6 21.8-3.2 3.7-6.5 4.2-12 1.4-32.6-16.3-54-29.1-75.5-66-5.7-9.8 5.7-9.1 16.3-30.3 1.8-3.7.9-6.9-.5-9.7-1.4-2.8-12.5-30.1-17.1-41.2-4.5-10.8-9.1-9.3-12.5-9.5-3.2-.2-6.9-.2-10.6-.2-3.7 0-9.7 1.4-14.8 6.9-5.1 5.6-19.4 19-19.4 46.3 0 27.3 19.9 53.7 22.6 57.4 2.8 3.7 39.1 59.7 94.8 83.8 35.2 15.2 49 16.5 66.6 13.9 10.7-1.6 32.8-13.4 37.4-26.4 4.6-13 4.6-24.1 3.2-26.4-1.3-2.5-5-3.9-10.5-6.6z\";s:3:\"key\";s:12:\"fab-whatsapp\";}s:7:\"version\";s:6:\"5.15.3\";}s:18:\"fab-telegram-plane\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:448;s:6:\"height\";i:512;s:4:\"path\";s:240:\"M446.7 98.6l-67.6 318.8c-5.1 22.5-18.4 28.1-37.3 17.5l-103-75.9-49.7 47.8c-5.5 5.5-10.1 10.1-20.7 10.1l7.4-104.9 190.9-172.5c8.3-7.4-1.8-11.5-12.9-4.1L117.8 284 16.2 252.2c-22.1-6.9-22.5-22.1 4.6-32.7L418.2 66.4c18.4-6.9 34.5 4.1 28.5 32.2z\";s:3:\"key\";s:18:\"fab-telegram-plane\";}s:7:\"version\";s:6:\"5.15.3\";}s:8:\"fas-info\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:192;s:6:\"height\";i:512;s:4:\"path\";s:308:\"M20 424.229h20V279.771H20c-11.046 0-20-8.954-20-20V212c0-11.046 8.954-20 20-20h112c11.046 0 20 8.954 20 20v212.229h20c11.046 0 20 8.954 20 20V492c0 11.046-8.954 20-20 20H20c-11.046 0-20-8.954-20-20v-47.771c0-11.046 8.954-20 20-20zM96 0C56.235 0 24 32.235 24 72s32.235 72 72 72 72-32.235 72-72S135.764 0 96 0z\";s:3:\"key\";s:8:\"fas-info\";}s:7:\"version\";s:6:\"5.15.3\";}s:16:\"far-comment-dots\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"path\";s:653:\"M144 208c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zm112 0c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zm112 0c-17.7 0-32 14.3-32 32s14.3 32 32 32 32-14.3 32-32-14.3-32-32-32zM256 32C114.6 32 0 125.1 0 240c0 47.6 19.9 91.2 52.9 126.3C38 405.7 7 439.1 6.5 439.5c-6.6 7-8.4 17.2-4.6 26S14.4 480 24 480c61.5 0 110-25.7 139.1-46.3C192 442.8 223.2 448 256 448c141.4 0 256-93.1 256-208S397.4 32 256 32zm0 368c-26.7 0-53.1-4.1-78.4-12.1l-22.7-7.2-19.5 13.8c-14.3 10.1-33.9 21.4-57.5 29 7.3-12.1 14.4-25.7 19.9-40.2l10.6-28.1-20.6-21.8C69.7 314.1 48 282.2 48 240c0-88.2 93.3-160 208-160s208 71.8 208 160-93.3 160-208 160z\";s:3:\"key\";s:16:\"far-comment-dots\";}s:7:\"version\";s:6:\"5.15.3\";}s:12:\"far-list-alt\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"path\";s:778:\"M464 32H48C21.49 32 0 53.49 0 80v352c0 26.51 21.49 48 48 48h416c26.51 0 48-21.49 48-48V80c0-26.51-21.49-48-48-48zm-6 400H54a6 6 0 0 1-6-6V86a6 6 0 0 1 6-6h404a6 6 0 0 1 6 6v340a6 6 0 0 1-6 6zm-42-92v24c0 6.627-5.373 12-12 12H204c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h200c6.627 0 12 5.373 12 12zm0-96v24c0 6.627-5.373 12-12 12H204c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h200c6.627 0 12 5.373 12 12zm0-96v24c0 6.627-5.373 12-12 12H204c-6.627 0-12-5.373-12-12v-24c0-6.627 5.373-12 12-12h200c6.627 0 12 5.373 12 12zm-252 12c0 19.882-16.118 36-36 36s-36-16.118-36-36 16.118-36 36-36 36 16.118 36 36zm0 96c0 19.882-16.118 36-36 36s-36-16.118-36-36 16.118-36 36-36 36 16.118 36 36zm0 96c0 19.882-16.118 36-36 36s-36-16.118-36-36 16.118-36 36-36 36 16.118 36 36z\";s:3:\"key\";s:12:\"far-list-alt\";}s:7:\"version\";s:6:\"5.15.3\";}s:17:\"fas-shopping-cart\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:576;s:6:\"height\";i:512;s:4:\"path\";s:536:\"M528.12 301.319l47.273-208C578.806 78.301 567.391 64 551.99 64H159.208l-9.166-44.81C147.758 8.021 137.93 0 126.529 0H24C10.745 0 0 10.745 0 24v16c0 13.255 10.745 24 24 24h69.883l70.248 343.435C147.325 417.1 136 435.222 136 456c0 30.928 25.072 56 56 56s56-25.072 56-56c0-15.674-6.447-29.835-16.824-40h209.647C430.447 426.165 424 440.326 424 456c0 30.928 25.072 56 56 56s56-25.072 56-56c0-22.172-12.888-41.332-31.579-50.405l5.517-24.276c3.413-15.018-8.002-29.319-23.403-29.319H218.117l-6.545-32h293.145c11.206 0 20.92-7.754 23.403-18.681z\";s:3:\"key\";s:17:\"fas-shopping-cart\";}s:7:\"version\";s:6:\"5.15.3\";}s:23:\"fas-long-arrow-alt-left\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:448;s:6:\"height\";i:512;s:4:\"path\";s:227:\"M134.059 296H436c6.627 0 12-5.373 12-12v-56c0-6.627-5.373-12-12-12H134.059v-46.059c0-21.382-25.851-32.09-40.971-16.971L7.029 239.029c-9.373 9.373-9.373 24.569 0 33.941l86.059 86.059c15.119 15.119 40.971 4.411 40.971-16.971V296z\";s:3:\"key\";s:23:\"fas-long-arrow-alt-left\";}s:7:\"version\";s:6:\"5.15.3\";}s:18:\"fas-money-bill-alt\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:640;s:6:\"height\";i:512;s:4:\"path\";s:611:\"M352 288h-16v-88c0-4.42-3.58-8-8-8h-13.58c-4.74 0-9.37 1.4-13.31 4.03l-15.33 10.22a7.994 7.994 0 0 0-2.22 11.09l8.88 13.31a7.994 7.994 0 0 0 11.09 2.22l.47-.31V288h-16c-4.42 0-8 3.58-8 8v16c0 4.42 3.58 8 8 8h64c4.42 0 8-3.58 8-8v-16c0-4.42-3.58-8-8-8zM608 64H32C14.33 64 0 78.33 0 96v320c0 17.67 14.33 32 32 32h576c17.67 0 32-14.33 32-32V96c0-17.67-14.33-32-32-32zM48 400v-64c35.35 0 64 28.65 64 64H48zm0-224v-64h64c0 35.35-28.65 64-64 64zm272 192c-53.02 0-96-50.15-96-112 0-61.86 42.98-112 96-112s96 50.14 96 112c0 61.87-43 112-96 112zm272 32h-64c0-35.35 28.65-64 64-64v64zm0-224c-35.35 0-64-28.65-64-64h64v64z\";s:3:\"key\";s:18:\"fas-money-bill-alt\";}s:7:\"version\";s:6:\"5.15.3\";}s:16:\"fas-check-circle\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"path\";s:356:\"M504 256c0 136.967-111.033 248-248 248S8 392.967 8 256 119.033 8 256 8s248 111.033 248 248zM227.314 387.314l184-184c6.248-6.248 6.248-16.379 0-22.627l-22.627-22.627c-6.248-6.249-16.379-6.249-22.628 0L216 308.118l-70.059-70.059c-6.248-6.248-16.379-6.248-22.628 0l-22.627 22.627c-6.248 6.248-6.248 16.379 0 22.627l104 104c6.249 6.249 16.379 6.249 22.628.001z\";s:3:\"key\";s:16:\"fas-check-circle\";}s:7:\"version\";s:6:\"5.15.3\";}s:10:\"fas-filter\";a:2:{s:7:\"content\";a:4:{s:5:\"width\";i:512;s:6:\"height\";i:512;s:4:\"path\";s:205:\"M487.976 0H24.028C2.71 0-8.047 25.866 7.058 40.971L192 225.941V432c0 7.831 3.821 15.17 10.237 19.662l80 55.98C298.02 518.69 320 507.493 320 487.98V225.941l184.947-184.97C520.021 25.896 509.338 0 487.976 0z\";s:3:\"key\";s:10:\"fas-filter\";}s:7:\"version\";s:6:\"5.15.3\";}}}}", "auto");
INSERT INTO `wp_options` VALUES("6315", "_transient_timeout_woocommerce_admin_settings_payments_has_providers_with_incentive", "1749572888", "off");
INSERT INTO `wp_options` VALUES("6316", "_transient_woocommerce_admin_settings_payments_has_providers_with_incentive", "no", "off");
INSERT INTO `wp_options` VALUES("6317", "_site_transient_update_core", "O:8:\"stdClass\":4:{s:7:\"updates\";a:1:{i:0;O:8:\"stdClass\":10:{s:8:\"response\";s:6:\"latest\";s:8:\"download\";s:65:\"https://downloads.wordpress.org/release/fa_IR/wordpress-6.8.1.zip\";s:6:\"locale\";s:5:\"fa_IR\";s:8:\"packages\";O:8:\"stdClass\":5:{s:4:\"full\";s:65:\"https://downloads.wordpress.org/release/fa_IR/wordpress-6.8.1.zip\";s:10:\"no_content\";s:0:\"\";s:11:\"new_bundled\";s:0:\"\";s:7:\"partial\";s:0:\"\";s:8:\"rollback\";s:0:\"\";}s:7:\"current\";s:5:\"6.8.1\";s:7:\"version\";s:5:\"6.8.1\";s:11:\"php_version\";s:6:\"7.2.24\";s:13:\"mysql_version\";s:5:\"5.5.5\";s:11:\"new_bundled\";s:3:\"6.7\";s:15:\"partial_version\";s:0:\"\";}}s:12:\"last_checked\";i:1749569289;s:15:\"version_checked\";s:5:\"6.8.1\";s:12:\"translations\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("6323", "rtl_rsm_pluginsUpdate", "a:2:{s:4:\"list\";a:0:{}s:9:\"lastCheck\";i:1749655850;}", "off");
INSERT INTO `wp_options` VALUES("6324", "rtl_rsm_themesUpdate", "a:2:{s:4:\"list\";a:0:{}s:9:\"lastCheck\";i:1749655850;}", "off");
INSERT INTO `wp_options` VALUES("6325", "rtl_rsm_autoUpdate", "a:2:{s:7:\"plugins\";a:0:{}s:6:\"themes\";a:0:{}}", "off");
INSERT INTO `wp_options` VALUES("6326", "rtl_rsm_server", "a:3:{s:18:\"firstHandShakeTime\";i:1749570351;s:11:\"lastChecked\";s:1:\"1\";s:14:\"firstHandShake\";b:1;}", "off");
INSERT INTO `wp_options` VALUES("6328", "rtl_rsm_healthyServer", "1", "off");
INSERT INTO `wp_options` VALUES("6332", "b33cb6ea242edc722e64c83795f16da29c40c555", "def502000a09c077da65f52eae14e9b4db5a1283ac98fffa5eebb18bfb8bd0221d3a7926737616c6e27278709e71e240a632b05c2700cb9905a22687f8929e6f2596feb7c056e7bace8fafc2a0bc01eda8a3c450de6a7c677a1bf66204f7c175c4e1c338e9bd8ba02359ae923edcd437e0a6a7d1ec8c5ab7f6e4d49e95bc4bf2f62be288a9392672dad1c74604214aab90275ac2", "off");
INSERT INTO `wp_options` VALUES("6333", "_site_transient_update_plugins", "O:8:\"stdClass\":5:{s:12:\"last_checked\";i:1749569465;s:8:\"response\";a:0:{}s:12:\"translations\";a:0:{}s:9:\"no_update\";a:6:{s:35:\"classic-widgets/classic-widgets.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:29:\"w.org/plugins/classic-widgets\";s:4:\"slug\";s:15:\"classic-widgets\";s:6:\"plugin\";s:35:\"classic-widgets/classic-widgets.php\";s:11:\"new_version\";s:3:\"0.3\";s:3:\"url\";s:46:\"https://wordpress.org/plugins/classic-widgets/\";s:7:\"package\";s:62:\"https://downloads.wordpress.org/plugin/classic-widgets.0.3.zip\";s:5:\"icons\";a:1:{s:7:\"default\";s:59:\"https://s.w.org/plugins/geopattern-icon/classic-widgets.svg\";}s:7:\"banners\";a:0:{}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"4.9\";}s:36:\"contact-form-7/wp-contact-form-7.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:28:\"w.org/plugins/contact-form-7\";s:4:\"slug\";s:14:\"contact-form-7\";s:6:\"plugin\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:11:\"new_version\";s:5:\"6.0.6\";s:3:\"url\";s:45:\"https://wordpress.org/plugins/contact-form-7/\";s:7:\"package\";s:63:\"https://downloads.wordpress.org/plugin/contact-form-7.6.0.6.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";s:3:\"svg\";s:59:\"https://ps.w.org/contact-form-7/assets/icon.svg?rev=2339255\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:69:\"https://ps.w.org/contact-form-7/assets/banner-1544x500.png?rev=860901\";s:2:\"1x\";s:68:\"https://ps.w.org/contact-form-7/assets/banner-772x250.png?rev=880427\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.6\";}s:25:\"duplicator/duplicator.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:24:\"w.org/plugins/duplicator\";s:4:\"slug\";s:10:\"duplicator\";s:6:\"plugin\";s:25:\"duplicator/duplicator.php\";s:11:\"new_version\";s:6:\"1.5.12\";s:3:\"url\";s:41:\"https://wordpress.org/plugins/duplicator/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/duplicator.1.5.12.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:63:\"https://ps.w.org/duplicator/assets/icon-256x256.png?rev=2906985\";s:2:\"1x\";s:63:\"https://ps.w.org/duplicator/assets/icon-128x128.png?rev=2906985\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:66:\"https://ps.w.org/duplicator/assets/banner-1544x500.png?rev=2906985\";s:2:\"1x\";s:65:\"https://ps.w.org/duplicator/assets/banner-772x250.png?rev=2906985\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"5.3\";}s:23:\"elementor/elementor.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:6:\"3.29.2\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:7:\"package\";s:59:\"https://downloads.wordpress.org/plugin/elementor.3.29.2.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.gif?rev=3111597\";s:2:\"1x\";s:62:\"https://ps.w.org/elementor/assets/icon-128x128.gif?rev=3111597\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=3164133\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=3164133\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.5\";}s:27:\"woocommerce/woocommerce.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:25:\"w.org/plugins/woocommerce\";s:4:\"slug\";s:11:\"woocommerce\";s:6:\"plugin\";s:27:\"woocommerce/woocommerce.php\";s:11:\"new_version\";s:5:\"9.9.3\";s:3:\"url\";s:42:\"https://wordpress.org/plugins/woocommerce/\";s:7:\"package\";s:60:\"https://downloads.wordpress.org/plugin/woocommerce.9.9.3.zip\";s:5:\"icons\";a:2:{s:2:\"1x\";s:56:\"https://ps.w.org/woocommerce/assets/icon.svg?rev=3234504\";s:3:\"svg\";s:56:\"https://ps.w.org/woocommerce/assets/icon.svg?rev=3234504\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:67:\"https://ps.w.org/woocommerce/assets/banner-1544x500.png?rev=3234504\";s:2:\"1x\";s:66:\"https://ps.w.org/woocommerce/assets/banner-772x250.png?rev=3234504\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:3:\"6.7\";}s:21:\"wp-story/wp-story.php\";O:8:\"stdClass\":10:{s:2:\"id\";s:22:\"w.org/plugins/wp-story\";s:4:\"slug\";s:8:\"wp-story\";s:6:\"plugin\";s:21:\"wp-story/wp-story.php\";s:11:\"new_version\";s:5:\"2.1.2\";s:3:\"url\";s:39:\"https://wordpress.org/plugins/wp-story/\";s:7:\"package\";s:51:\"https://downloads.wordpress.org/plugin/wp-story.zip\";s:5:\"icons\";a:2:{s:2:\"2x\";s:61:\"https://ps.w.org/wp-story/assets/icon-256x256.png?rev=2334686\";s:2:\"1x\";s:61:\"https://ps.w.org/wp-story/assets/icon-128x128.png?rev=2334686\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:64:\"https://ps.w.org/wp-story/assets/banner-1544x500.jpg?rev=2334676\";s:2:\"1x\";s:63:\"https://ps.w.org/wp-story/assets/banner-772x250.jpg?rev=2334676\";}s:11:\"banners_rtl\";a:0:{}s:8:\"requires\";s:5:\"5.0.0\";}}s:7:\"checked\";a:8:{s:35:\"classic-widgets/classic-widgets.php\";s:3:\"0.3\";s:36:\"contact-form-7/wp-contact-form-7.php\";s:5:\"6.0.6\";s:25:\"duplicator/duplicator.php\";s:6:\"1.5.12\";s:23:\"elementor/elementor.php\";s:6:\"3.29.2\";s:27:\"woocommerce/woocommerce.php\";s:5:\"9.9.3\";s:31:\"woodmart-core/woodmart-core.php\";s:5:\"1.1.2\";s:21:\"wp-story/wp-story.php\";s:5:\"2.1.2\";s:29:\"RTL-CareUnit/RTL-CareUnit.php\";s:5:\"2.5.3\";}}", "off");
INSERT INTO `wp_options` VALUES("6319", "auto_update_themes", "a:0:{}", "off");
INSERT INTO `wp_options` VALUES("6320", "rtl_rsm_delayTime", "a:5:{s:10:\"selfUpdate\";i:1749655850;s:18:\"deleteDownloadFile\";i:0;s:8:\"wpLoaded\";i:1749569495;s:7:\"runPing\";i:1749573082;s:14:\"runDebugServer\";i:1749655882;}", "off");
INSERT INTO `wp_options` VALUES("6321", "_transient_timeout_RTL-CareUnit-Updates", "1749655850", "off");
INSERT INTO `wp_options` VALUES("6322", "_transient_RTL-CareUnit-Updates", "O:8:\"stdClass\":16:{s:4:\"name\";s:41:\"مدیریت لایسنس راست چین\";s:4:\"slug\";s:12:\"RTL-CareUnit\";s:7:\"version\";s:5:\"2.6.3\";s:6:\"author\";s:14:\"راستچین\";s:14:\"author_profile\";s:26:\"https://www.rtl-theme.com/\";s:8:\"requires\";s:3:\"5.0\";s:6:\"tested\";s:3:\"6.7\";s:12:\"requires_php\";s:3:\"7.4\";s:12:\"last_updated\";s:19:\"2025-03-31 10:12:00\";s:8:\"homepage\";s:26:\"https://www.rtl-theme.com/\";s:8:\"sections\";a:5:{s:11:\"description\";s:126:\"افزونه ای جهت فعالسازی، بروزرسانی و مراقبت از محصولات وردپرس راستچین\";s:12:\"installation\";s:0:\"\";s:3:\"faq\";s:0:\"\";s:9:\"changelog\";s:0:\"\";s:11:\"screenshots\";s:0:\"\";}s:13:\"download_link\";s:53:\"https://files.rtl-theme.com/plugins/rtlRsm/rtlRsm.zip\";s:11:\"screenshots\";a:0:{}s:4:\"tags\";a:0:{}s:8:\"versions\";a:0:{}s:7:\"banners\";a:2:{s:3:\"low\";s:61:\"https://files.rtl-theme.com/plugins/rtlRsm/banner-772x250.jpg\";s:4:\"high\";s:62:\"https://files.rtl-theme.com/plugins/rtlRsm/banner-1544x500.jpg\";}}", "off");
INSERT INTO `wp_options` VALUES("6289", "woocommerce_shipping_hide_rates_when_free", "no", "off");
INSERT INTO `wp_options` VALUES("6290", "woocommerce_email_header_image_width", "120", "on");
INSERT INTO `wp_options` VALUES("6291", "woocommerce_email_header_alignment", "left", "on");
INSERT INTO `wp_options` VALUES("6292", "woocommerce_email_font_family", "Helvetica", "on");
INSERT INTO `wp_options` VALUES("151", "theme_mods_twentytwentyfive", "a:1:{s:16:\"sidebars_widgets\";a:2:{s:4:\"time\";i:1744891445;s:4:\"data\";a:3:{s:19:\"wp_inactive_widgets\";a:0:{}s:9:\"sidebar-1\";a:3:{i:0;s:7:\"block-2\";i:1;s:7:\"block-3\";i:2;s:7:\"block-4\";}s:9:\"sidebar-2\";a:2:{i:0;s:7:\"block-5\";i:1;s:7:\"block-6\";}}}}", "off");
INSERT INTO `wp_options` VALUES("152", "current_theme", "Woodmart", "auto");
INSERT INTO `wp_options` VALUES("153", "theme_mods_woodmart", "a:3:{i:0;b:0;s:18:\"nav_menu_locations\";a:1:{s:9:\"main-menu\";i:35;}s:18:\"custom_css_post_id\";i:150;}", "on");
INSERT INTO `wp_options` VALUES("154", "theme_switched", "", "auto");
INSERT INTO `wp_options` VALUES("159", "xts-woodmart-options", "a:799:{s:12:\"last_message\";s:4:\"save\";s:14:\"default_header\";s:13:\"header_771984\";s:14:\"sticky_toolbar\";s:1:\"1\";s:20:\"sticky_toolbar_label\";s:1:\"1\";s:21:\"sticky_toolbar_fields\";a:5:{i:0;s:4:\"shop\";i:1;s:7:\"sidebar\";i:2;s:8:\"wishlist\";i:3;s:4:\"cart\";i:4;s:7:\"account\";}s:10:\"link_1_url\";s:0:\"\";s:11:\"link_1_text\";s:0:\"\";s:11:\"link_1_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_2_url\";s:0:\"\";s:11:\"link_2_text\";s:0:\"\";s:11:\"link_2_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_3_url\";s:0:\"\";s:11:\"link_3_text\";s:0:\"\";s:11:\"link_3_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_4_url\";s:0:\"\";s:11:\"link_4_text\";s:0:\"\";s:11:\"link_4_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"link_5_url\";s:0:\"\";s:11:\"link_5_text\";s:0:\"\";s:11:\"link_5_icon\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"age_verify\";s:1:\"0\";s:15:\"age_verify_text\";s:157:\"<h4 class=\"text-center\">Are you over 18?</h4>\r\n<p class=\"text-center\">You must be 18 years of age or older to view page. Please verify your age to enter.</p>\";s:21:\"age_verify_text_error\";s:120:\"<h4 class=\"text-center\">Access forbidden</h4>\r\n<p class=\"text-center\">Your access is restricted because of your age.</p>\";s:21:\"age_verify_background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:23:\"age_verify_color_scheme\";s:4:\"dark\";s:16:\"age_verify_width\";s:3:\"500\";s:11:\"promo_popup\";s:1:\"0\";s:24:\"promo_popup_content_type\";s:10:\"html_block\";s:10:\"popup_text\";s:0:\"\";s:16:\"popup_html_block\";s:0:\"\";s:12:\"popup_scroll\";s:4:\"1000\";s:16:\"popup-background\";a:7:{s:5:\"color\";s:7:\"#111111\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:7:\"contain\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:11:\"left center\";}s:18:\"popup_color_scheme\";s:4:\"dark\";s:11:\"popup_width\";s:3:\"800\";s:13:\"popup_padding\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:23:\"promo_popup_hide_mobile\";s:1:\"1\";s:11:\"popup_event\";s:4:\"time\";s:13:\"promo_timeout\";s:4:\"2000\";s:11:\"popup_pages\";s:1:\"0\";s:13:\"promo_version\";s:1:\"1\";s:12:\"cookies_info\";s:1:\"0\";s:12:\"cookies_text\";s:224:\"ما از کوکی ها برای بهبود کارکردن شما با سایت استفاده می کنیم. با استفاده از این سایت شما استفاده ما از کوکی ها را پذیرفته اید.\";s:19:\"cookies_policy_page\";s:0:\"\";s:15:\"cookies_version\";s:1:\"1\";s:13:\"header_banner\";s:1:\"1\";s:18:\"header_banner_link\";s:0:\"\";s:26:\"header_banner_content_type\";s:4:\"text\";s:24:\"header_banner_html_block\";s:0:\"\";s:23:\"header_banner_shortcode\";s:0:\"\";s:16:\"header_banner_bg\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:89:\"https://demoes.aramis-co.ir/Underwear/wp-content/uploads/2025/04/Frame-303-min-scaled.jpg\";s:2:\"id\";s:3:\"139\";s:6:\"repeat\";s:9:\"no-repeat\";s:4:\"size\";s:5:\"cover\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:13:\"center center\";}s:19:\"header_banner_color\";s:5:\"light\";s:20:\"header_banner_height\";s:2:\"40\";s:27:\"header_banner_mobile_height\";s:2:\"40\";s:16:\"header_close_btn\";s:1:\"1\";s:21:\"header_banner_version\";s:1:\"1\";s:21:\"enqueue_posts_results\";s:1:\"0\";s:27:\"search_posts_results_column\";s:1:\"2\";s:13:\"search_by_sku\";s:1:\"1\";s:17:\"relevanssi_search\";s:1:\"0\";s:16:\"popular_requests\";s:0:\"\";s:24:\"full_search_content_type\";s:7:\"content\";s:24:\"full_search_content_text\";s:0:\"\";s:30:\"full_search_content_html_block\";s:0:\"\";s:23:\"ajax_fullscreen_content\";s:1:\"1\";s:10:\"site_width\";s:10:\"full-width\";s:17:\"site_custom_width\";s:4:\"1222\";s:11:\"main_layout\";s:13:\"sidebar-right\";s:13:\"sidebar_width\";s:1:\"3\";s:17:\"hide_main_sidebar\";s:1:\"0\";s:24:\"hide_main_sidebar_tablet\";s:1:\"1\";s:24:\"hide_main_sidebar_mobile\";s:1:\"1\";s:11:\"insta_token\";s:0:\"\";s:28:\"insta_delete_outdated_images\";s:1:\"0\";s:18:\"google_map_api_key\";s:0:\"\";s:9:\"fb_app_id\";s:0:\"\";s:13:\"fb_app_secret\";s:0:\"\";s:9:\"fb_notice\";s:0:\"\";s:10:\"goo_app_id\";s:0:\"\";s:14:\"goo_app_secret\";s:0:\"\";s:10:\"goo_notice\";s:0:\"\";s:9:\"vk_app_id\";s:0:\"\";s:13:\"vk_app_secret\";s:0:\"\";s:9:\"vk_notice\";s:0:\"\";s:15:\"alt_auth_method\";s:1:\"0\";s:9:\"ajax_shop\";s:1:\"1\";s:11:\"ajax_scroll\";s:1:\"1\";s:21:\"shop_page_breadcrumbs\";s:1:\"1\";s:17:\"cat_desc_position\";s:6:\"before\";s:14:\"products_hover\";s:4:\"base\";s:23:\"base_hover_mobile_click\";s:1:\"0\";s:21:\"products_color_scheme\";s:7:\"default\";s:22:\"products_bordered_grid\";s:1:\"0\";s:28:\"products_bordered_grid_style\";s:7:\"outside\";s:24:\"products_with_background\";s:1:\"1\";s:19:\"products_background\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"products_shadow\";s:1:\"1\";s:23:\"stretch_product_desktop\";s:1:\"1\";s:22:\"stretch_product_tablet\";s:1:\"1\";s:22:\"stretch_product_mobile\";s:1:\"1\";s:25:\"product_title_lines_limit\";s:3:\"one\";s:22:\"show_empty_star_rating\";s:1:\"0\";s:11:\"hover_image\";s:1:\"1\";s:12:\"grid_gallery\";s:1:\"0\";s:20:\"grid_gallery_control\";s:5:\"hover\";s:26:\"grid_gallery_enable_arrows\";s:4:\"none\";s:16:\"product_quantity\";s:1:\"0\";s:18:\"base_hover_content\";s:7:\"excerpt\";s:21:\"stock_status_position\";s:9:\"thumbnail\";s:27:\"show_stock_quantity_on_grid\";s:1:\"0\";s:23:\"grid_stock_progress_bar\";s:1:\"0\";s:14:\"shop_countdown\";s:1:\"0\";s:22:\"categories_under_title\";s:1:\"0\";s:18:\"brands_under_title\";s:1:\"0\";s:15:\"sku_under_title\";s:1:\"0\";s:18:\"show_reviews_count\";s:1:\"0\";s:17:\"categories_design\";s:7:\"default\";s:19:\"categories_rounding\";s:0:\"\";s:31:\"custom_categories_rounding_size\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:23:\"categories_color_scheme\";s:7:\"default\";s:22:\"categories_with_shadow\";s:6:\"enable\";s:29:\"hide_categories_subcategories\";s:1:\"0\";s:29:\"hide_categories_product_count\";s:1:\"0\";s:11:\"shop_layout\";s:12:\"sidebar-left\";s:18:\"shop_sidebar_width\";s:1:\"3\";s:25:\"shop_hide_sidebar_desktop\";s:1:\"0\";s:24:\"shop_hide_sidebar_tablet\";s:1:\"1\";s:17:\"shop_hide_sidebar\";s:1:\"1\";s:20:\"sticky_filter_button\";s:1:\"0\";s:10:\"shop_title\";s:1:\"1\";s:15:\"shop_categories\";s:1:\"1\";s:25:\"shop_categories_ancestors\";s:1:\"0\";s:25:\"show_categories_neighbors\";s:1:\"0\";s:19:\"shop_products_count\";s:1:\"1\";s:37:\"shop_page_title_hide_empty_categories\";s:1:\"0\";s:34:\"shop_page_title_categories_exclude\";s:0:\"\";s:24:\"mobile_categories_layout\";s:9:\"accordion\";s:29:\"mobile_categories_menu_layout\";s:8:\"dropdown\";s:37:\"mobile_categories_drilldown_animation\";s:5:\"slide\";s:40:\"mobile_categories_submenu_opening_action\";s:10:\"only_arrow\";s:26:\"mobile_categories_position\";s:4:\"left\";s:30:\"mobile_categories_color_scheme\";s:7:\"default\";s:27:\"mobile_categories_close_btn\";s:1:\"0\";s:9:\"shop_view\";s:4:\"grid\";s:16:\"products_columns\";s:1:\"3\";s:23:\"products_columns_tablet\";s:4:\"auto\";s:23:\"products_columns_mobile\";s:1:\"2\";s:16:\"products_spacing\";s:2:\"20\";s:23:\"products_spacing_tablet\";s:0:\"\";s:23:\"products_spacing_mobile\";s:0:\"\";s:24:\"per_row_columns_selector\";s:1:\"1\";s:27:\"products_columns_variations\";a:3:{i:0;s:1:\"2\";i:1;s:1:\"3\";i:2;s:1:\"4\";}s:16:\"products_masonry\";s:1:\"0\";s:24:\"products_different_sizes\";s:1:\"0\";s:13:\"shop_per_page\";s:2:\"12\";s:14:\"per_page_links\";s:1:\"1\";s:16:\"per_page_options\";s:10:\"9,12,18,24\";s:15:\"shop_pagination\";s:10:\"pagination\";s:25:\"load_more_button_page_url\";s:1:\"1\";s:17:\"categories_toggle\";s:1:\"1\";s:14:\"widgets_scroll\";s:1:\"1\";s:14:\"widget_heights\";s:3:\"223\";s:21:\"shop_widgets_collapse\";s:7:\"disable\";s:12:\"shop_filters\";s:1:\"0\";s:17:\"shop_filters_type\";s:7:\"widgets\";s:20:\"shop_filters_columns\";s:0:\"\";s:27:\"shop_filters_columns_tablet\";s:4:\"auto\";s:27:\"shop_filters_columns_mobile\";s:4:\"auto\";s:20:\"shop_filters_spacing\";s:2:\"30\";s:27:\"shop_filters_spacing_tablet\";s:0:\"\";s:27:\"shop_filters_spacing_mobile\";s:0:\"\";s:12:\"hide_sort_by\";s:1:\"0\";s:17:\"hide_price_filter\";s:1:\"0\";s:20:\"shop_filters_content\";s:0:\"\";s:24:\"shop_filters_always_open\";s:1:\"0\";s:18:\"shop_filters_close\";s:1:\"0\";s:17:\"page-title-design\";s:7:\"disable\";s:15:\"page-title-size\";s:7:\"default\";s:16:\"title-background\";a:7:{s:5:\"color\";s:7:\"#0a0a0a\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:5:\"cover\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:13:\"center center\";}s:16:\"page-title-color\";s:5:\"light\";s:14:\"page_title_tag\";s:7:\"default\";s:11:\"breadcrumbs\";s:1:\"1\";s:22:\"yoast_shop_breadcrumbs\";s:1:\"0\";s:23:\"yoast_pages_breadcrumbs\";s:1:\"0\";s:14:\"disable_footer\";s:1:\"1\";s:19:\"footer_content_type\";s:10:\"html_block\";s:13:\"footer-layout\";s:2:\"13\";s:17:\"footer_html_block\";s:3:\"607\";s:13:\"footer-bar-bg\";a:7:{s:5:\"color\";s:16:\"rgb(244,243,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:12:\"footer-style\";s:0:\"\";s:13:\"sticky_footer\";s:1:\"0\";s:23:\"collapse_footer_widgets\";s:1:\"1\";s:14:\"scroll_top_btn\";s:1:\"1\";s:18:\"disable_copyrights\";s:1:\"0\";s:17:\"copyrights-layout\";s:11:\"two-columns\";s:10:\"copyrights\";s:243:\"Based on <a href=\"http://woodmart.xtemos.com\"><strong>WoodMart</strong></a> theme<i class=\"fa fa-copyright\"></i> 2025 <a href=\"https://themeforest.net/item/woodmart-woocommerce-wordpress-theme/20264492\"><strong>WooCommerce Themes</strong></a>.\";s:11:\"copyrights2\";s:111:\"<img src=\"https://demoes.aramis-co.ir/Underwear/wp-content/themes/woodmart/images/payments.png\" alt=\"payments\">\";s:22:\"prefooter_content_type\";s:4:\"text\";s:14:\"prefooter_area\";s:0:\"\";s:20:\"prefooter_html_block\";s:0:\"\";s:9:\"text-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:9:\"font-size\";s:2:\"14\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:7:\"#767676\";}}s:12:\"primary-font\";a:1:{i:0;a:7:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:9:\"iranyekan\";s:11:\"font-weight\";s:3:\"600\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#242424\";}}s:16:\"post-titles-font\";a:1:{i:0;a:8:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:5:\"color\";s:7:\"#333333\";s:5:\"hover\";a:1:{s:5:\"color\";s:19:\"rgb(51 51 51 / 65%)\";}}}s:14:\"secondary-font\";a:1:{i:0;a:5:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:9:\"iranyekan\";s:11:\"font-weight\";s:3:\"400\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";}}s:18:\"widget-titles-font\";a:1:{i:0;a:10:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"600\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:4:\"none\";s:9:\"font-size\";s:2:\"16\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:4:\"#333\";}}s:15:\"navigation-font\";a:1:{i:0;a:9:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:9:\"iranyekan\";s:11:\"font-weight\";s:3:\"500\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:7:\"inherit\";s:9:\"font-size\";s:2:\"14\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}}}s:17:\"typography_notice\";s:0:\"\";s:19:\"advanced_typography\";a:2:{i:0;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:6:\"mobile\";a:2:{s:9:\"font-size\";s:0:\"\";s:11:\"line-height\";s:0:\"\";}s:11:\"line-height\";s:0:\"\";s:5:\"color\";s:0:\"\";s:5:\"hover\";a:1:{s:5:\"color\";s:0:\"\";}}}s:26:\"advanced_typography_notice\";s:0:\"\";s:25:\"multi_custom_fonts_notice\";s:0:\"\";s:18:\"multi_custom_fonts\";a:2:{i:0;a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}s:9:\"{{index}}\";a:4:{s:9:\"font-name\";s:0:\"\";s:11:\"font-weight\";s:3:\"400\";s:9:\"font-woff\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:10:\"font-woff2\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}}}s:9:\"icon_font\";a:2:{s:4:\"font\";s:1:\"2\";s:6:\"weight\";s:3:\"700\";}s:14:\"typekit_notice\";s:0:\"\";s:10:\"typekit_id\";s:0:\"\";s:13:\"typekit_fonts\";s:0:\"\";s:13:\"rounding_size\";s:2:\"12\";s:20:\"custom_rounding_size\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:12:\"dark_version\";s:1:\"0\";s:13:\"primary-color\";a:1:{s:4:\"idle\";s:14:\"rgb(74,36,157)\";}s:15:\"secondary-color\";a:1:{s:4:\"idle\";s:16:\"rgb(249,225,178)\";}s:10:\"link-color\";a:2:{s:4:\"idle\";s:7:\"#333333\";s:5:\"hover\";s:13:\"rgb(22,22,22)\";}s:25:\"android_browser_bar_color\";a:1:{s:4:\"idle\";s:14:\"rgb(74,36,157)\";}s:15:\"body-background\";a:7:{s:5:\"color\";s:0:\"\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:16:\"pages-background\";a:7:{s:5:\"color\";s:16:\"rgb(244,243,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"shop-background\";a:7:{s:5:\"color\";s:16:\"rgb(244,243,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"product-background\";a:7:{s:5:\"color\";s:16:\"rgb(244,243,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:15:\"blog-background\";a:7:{s:5:\"color\";s:16:\"rgb(244,243,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"blog-post-background\";a:7:{s:5:\"color\";s:16:\"rgb(244,243,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:20:\"portfolio-background\";a:7:{s:5:\"color\";s:16:\"rgb(244,243,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:28:\"portfolio-project-background\";a:7:{s:5:\"color\";s:16:\"rgb(244,243,245)\";s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";s:6:\"repeat\";s:0:\"\";s:4:\"size\";s:0:\"\";s:10:\"attachment\";s:0:\"\";s:8:\"position\";s:0:\"\";}s:18:\"btns_default_style\";s:7:\"rounded\";s:23:\"btns_default_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:14:\"YekanBakhFaNum\";s:11:\"font-weight\";s:3:\"300\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";}}s:15:\"btns_default_bg\";a:1:{s:4:\"idle\";s:14:\"rgb(74,36,157)\";}s:21:\"btns_default_bg_hover\";a:1:{s:4:\"idle\";s:14:\"rgb(98,33,145)\";}s:25:\"btns_default_color_scheme\";s:5:\"light\";s:31:\"btns_default_color_scheme_hover\";s:5:\"light\";s:32:\"btns_default_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"btns_default_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:15:\"btns_shop_style\";s:7:\"rounded\";s:20:\"btns_shop_typography\";a:1:{i:0;a:6:{s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";}}s:12:\"btns_shop_bg\";a:1:{s:4:\"idle\";s:14:\"rgb(74,36,157)\";}s:18:\"btns_shop_bg_hover\";a:1:{s:4:\"idle\";s:14:\"rgb(98,33,145)\";}s:22:\"btns_shop_color_scheme\";s:5:\"light\";s:28:\"btns_shop_color_scheme_hover\";s:5:\"light\";s:29:\"btns_shop_color_scheme_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:35:\"btns_shop_color_scheme_hover_custom\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"advanced_typography_button\";a:2:{i:0;a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}s:9:\"{{index}}\";a:14:{s:6:\"custom\";s:0:\"\";s:15:\"custom-selector\";s:0:\"\";s:6:\"google\";s:1:\"0\";s:11:\"font-family\";s:0:\"\";s:11:\"font-weight\";s:0:\"\";s:10:\"font-style\";s:0:\"\";s:11:\"font-subset\";s:0:\"\";s:14:\"text-transform\";s:0:\"\";s:9:\"font-size\";s:0:\"\";s:6:\"tablet\";a:1:{s:9:\"font-size\";s:0:\"\";}s:6:\"mobile\";a:1:{s:9:\"font-size\";s:0:\"\";}s:5:\"color\";s:0:\"\";s:5:\"hover\";a:2:{s:5:\"color\";s:0:\"\";s:10:\"background\";s:0:\"\";}s:10:\"background\";s:0:\"\";}}s:17:\"form_fields_style\";s:6:\"square\";s:17:\"form_border_width\";s:1:\"2\";s:10:\"form_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:22:\"form_placeholder_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:14:\"form_brd_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"form_brd_color_focus\";a:1:{s:4:\"idle\";s:0:\"\";}s:7:\"form_bg\";a:1:{s:4:\"idle\";s:0:\"\";}s:23:\"success_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#459647\";}s:25:\"success_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:23:\"warning_notice_bg_color\";a:1:{s:4:\"idle\";s:7:\"#E0B252\";}s:25:\"warning_notice_test_color\";a:1:{s:4:\"idle\";s:4:\"#fff\";}s:24:\"carousel_arrows_position\";s:3:\"sep\";s:25:\"carousel_arrows_icon_type\";s:1:\"1\";s:27:\"carousel_arrows_hover_style\";s:1:\"1\";s:24:\"carousel_arrows_sep_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:29:\"carousel_arrows_sep_icon_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:28:\"carousel_arrows_sep_offset_h\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:28:\"carousel_arrows_sep_offset_v\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:25:\"carousel_arrows_sep_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:31:\"carousel_arrows_sep_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:29:\"carousel_arrows_sep_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:28:\"carousel_arrows_sep_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:34:\"carousel_arrows_sep_bg_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:32:\"carousel_arrows_sep_bg_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:33:\"carousel_arrows_sep_border_radius\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:32:\"carousel_arrows_sep_border_style\";s:0:\"\";s:32:\"carousel_arrows_sep_border_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:32:\"carousel_arrows_sep_border_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"carousel_arrows_sep_border_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:36:\"carousel_arrows_sep_border_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:36:\"carousel_arrows_sep_box_shadow_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:39:\"carousel_arrows_sep_box_shadow_offset_x\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:39:\"carousel_arrows_sep_box_shadow_offset_y\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:35:\"carousel_arrows_sep_box_shadow_blur\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:37:\"carousel_arrows_sep_box_shadow_spread\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:28:\"carousel_arrows_together_gap\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:29:\"carousel_arrows_together_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:34:\"carousel_arrows_together_icon_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:33:\"carousel_arrows_together_offset_h\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:33:\"carousel_arrows_together_offset_v\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:30:\"carousel_arrows_together_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:36:\"carousel_arrows_together_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:34:\"carousel_arrows_together_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:33:\"carousel_arrows_together_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:39:\"carousel_arrows_together_bg_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:37:\"carousel_arrows_together_bg_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"carousel_arrows_together_border_radius\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:37:\"carousel_arrows_together_border_style\";s:0:\"\";s:37:\"carousel_arrows_together_border_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:37:\"carousel_arrows_together_border_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:43:\"carousel_arrows_together_border_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:41:\"carousel_arrows_together_border_color_dis\";a:1:{s:4:\"idle\";s:0:\"\";}s:41:\"carousel_arrows_together_box_shadow_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:44:\"carousel_arrows_together_box_shadow_offset_x\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:44:\"carousel_arrows_together_box_shadow_offset_y\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:40:\"carousel_arrows_together_box_shadow_blur\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:42:\"carousel_arrows_together_box_shadow_spread\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:19:\"carousel_pagin_size\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:23:\"carousel_pagin_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:29:\"carousel_pagin_bg_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:30:\"carousel_pagin_bg_color_active\";a:1:{s:4:\"idle\";s:0:\"\";}s:28:\"carousel_pagin_border_radius\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:27:\"carousel_pagin_border_style\";s:0:\"\";s:27:\"carousel_pagin_border_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:27:\"carousel_pagin_border_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:33:\"carousel_pagin_border_color_hover\";a:1:{s:4:\"idle\";s:0:\"\";}s:34:\"carousel_pagin_border_color_active\";a:1:{s:4:\"idle\";s:0:\"\";}s:25:\"carousel_scrollbar_height\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:24:\"carousel_scrollbar_width\";s:152:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoiJSJ9LCJ0YWJsZXQiOnsidmFsdWUiOiIiLCJ1bml0IjoiJSJ9LCJtb2JpbGUiOnsidmFsdWUiOiIiLCJ1bml0IjoiJSJ9fX0=\";s:27:\"carousel_scrollbar_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:32:\"carousel_scrollbar_drag_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:38:\"carousel_scrollbar_drag_bg_hover_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:11:\"blog_layout\";s:10:\"full-width\";s:18:\"blog_sidebar_width\";s:1:\"3\";s:17:\"blog_hide_sidebar\";s:1:\"1\";s:24:\"blog_hide_sidebar_tablet\";s:1:\"1\";s:24:\"blog_hide_sidebar_mobile\";s:1:\"1\";s:29:\"single_post_justified_gallery\";s:1:\"1\";s:11:\"blog_design\";s:4:\"mask\";s:10:\"blog_style\";s:4:\"flat\";s:16:\"blog_with_shadow\";s:1:\"1\";s:12:\"blog_columns\";s:1:\"4\";s:19:\"blog_columns_tablet\";s:4:\"auto\";s:19:\"blog_columns_mobile\";s:4:\"auto\";s:12:\"blog_spacing\";s:2:\"20\";s:19:\"blog_spacing_tablet\";s:0:\"\";s:19:\"blog_spacing_mobile\";s:0:\"\";s:15:\"blog_pagination\";s:10:\"pagination\";s:12:\"blog_excerpt\";s:7:\"excerpt\";s:21:\"blog_words_or_letters\";s:6:\"letter\";s:19:\"blog_excerpt_length\";s:3:\"135\";s:11:\"parts_title\";s:1:\"1\";s:10:\"parts_meta\";s:1:\"1\";s:10:\"parts_text\";s:1:\"1\";s:9:\"parts_btn\";s:1:\"1\";s:20:\"parts_published_date\";s:1:\"1\";s:18:\"single_post_design\";s:7:\"default\";s:18:\"single_post_header\";s:4:\"none\";s:10:\"blog_share\";s:1:\"1\";s:15:\"blog_navigation\";s:1:\"1\";s:15:\"blog_author_bio\";s:1:\"1\";s:18:\"blog_related_posts\";s:1:\"1\";s:19:\"blog_published_date\";s:1:\"1\";s:9:\"portfolio\";s:1:\"1\";s:14:\"portfolio_page\";s:0:\"\";s:19:\"portfolio_item_slug\";s:0:\"\";s:18:\"portfolio_cat_slug\";s:0:\"\";s:20:\"portfolio_full_width\";s:1:\"0\";s:16:\"projects_columns\";s:1:\"3\";s:23:\"projects_columns_tablet\";s:4:\"auto\";s:23:\"projects_columns_mobile\";s:4:\"auto\";s:17:\"portfolio_spacing\";s:1:\"0\";s:24:\"portfolio_spacing_tablet\";s:0:\"\";s:24:\"portfolio_spacing_mobile\";s:0:\"\";s:18:\"portoflio_per_page\";s:1:\"6\";s:20:\"portfolio_pagination\";s:9:\"load_more\";s:17:\"portoflio_orderby\";s:4:\"date\";s:15:\"portoflio_order\";s:4:\"DESC\";s:15:\"portoflio_style\";s:5:\"hover\";s:20:\"portoflio_image_size\";s:5:\"large\";s:17:\"portoflio_filters\";s:1:\"1\";s:22:\"portfolio_filters_type\";s:5:\"links\";s:14:\"ajax_portfolio\";s:1:\"1\";s:23:\"single_portfolio_header\";s:4:\"none\";s:36:\"single_portfolio_title_in_page_title\";s:1:\"0\";s:20:\"portfolio_navigation\";s:1:\"1\";s:17:\"portfolio_related\";s:1:\"1\";s:18:\"add_to_cart_action\";s:6:\"widget\";s:26:\"add_to_cart_action_timeout\";s:1:\"0\";s:33:\"add_to_cart_action_timeout_number\";s:1:\"3\";s:18:\"mini_cart_quantity\";s:1:\"0\";s:21:\"show_sku_in_mini_cart\";s:1:\"0\";s:16:\"show_sku_in_cart\";s:1:\"0\";s:25:\"show_sku_in_checkout_page\";s:1:\"0\";s:26:\"show_sku_in_thank_you_page\";s:1:\"0\";s:23:\"show_sku_in_email_order\";s:1:\"0\";s:16:\"show_sku_on_ajax\";s:1:\"0\";s:12:\"catalog_mode\";s:1:\"0\";s:11:\"size_guides\";s:1:\"1\";s:12:\"login_prices\";s:1:\"0\";s:19:\"quick_shop_variable\";s:1:\"1\";s:24:\"quick_shop_variable_type\";s:14:\"select_options\";s:23:\"quick_shop_clear_action\";s:4:\"none\";s:23:\"grid_swatches_attribute\";s:0:\"\";s:14:\"swatches_limit\";s:1:\"0\";s:20:\"swatches_limit_count\";s:1:\"5\";s:29:\"single_product_swatches_limit\";s:1:\"0\";s:35:\"single_product_swatches_limit_count\";s:2:\"10\";s:29:\"swatches_use_variation_images\";s:1:\"0\";s:20:\"swatches_labels_name\";s:1:\"0\";s:27:\"swatches_scroll_top_desktop\";s:1:\"0\";s:26:\"swatches_scroll_top_mobile\";s:1:\"0\";s:17:\"variation_gallery\";s:1:\"1\";s:32:\"variation_gallery_storage_method\";s:3:\"old\";s:24:\"ajax_variation_threshold\";s:2:\"30\";s:29:\"show_filtered_variation_image\";s:1:\"0\";s:17:\"hide_larger_price\";s:1:\"0\";s:31:\"single_product_variations_price\";s:1:\"0\";s:11:\"label_shape\";s:10:\"rounded-sm\";s:16:\"percentage_label\";s:1:\"1\";s:19:\"sale_label_bg_color\";a:1:{s:4:\"idle\";s:16:\"rgb(229,199,142)\";}s:21:\"sale_label_text_color\";a:1:{s:4:\"idle\";s:15:\"rgb(178,135,48)\";}s:9:\"new_label\";s:1:\"1\";s:27:\"new_label_days_after_create\";s:1:\"0\";s:18:\"new_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"new_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:9:\"hot_label\";s:1:\"1\";s:18:\"hot_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"hot_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:20:\"stock_label_bg_color\";a:1:{s:4:\"idle\";s:14:\"rgb(221,51,51)\";}s:22:\"stock_label_text_color\";a:1:{s:4:\"idle\";s:16:\"rgb(255,255,255)\";}s:24:\"attribute_label_bg_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:26:\"attribute_label_text_color\";a:1:{s:4:\"idle\";s:0:\"\";}s:16:\"brands_attribute\";s:0:\"\";s:18:\"product_page_brand\";s:1:\"1\";s:22:\"product_brand_location\";s:11:\"about_title\";s:9:\"brand_tab\";s:1:\"1\";s:14:\"brand_tab_name\";s:1:\"0\";s:10:\"quick_view\";s:1:\"1\";s:17:\"quick_view_layout\";s:10:\"horizontal\";s:15:\"quickview_width\";s:3:\"920\";s:19:\"quick_view_variable\";s:1:\"1\";s:7:\"compare\";s:1:\"1\";s:12:\"compare_page\";s:0:\"\";s:14:\"fields_compare\";a:3:{i:0;s:11:\"description\";i:1;s:3:\"sku\";i:2;s:12:\"availability\";}s:18:\"empty_compare_text\";s:243:\"هیچ محصولی به لیست مقایسه اضافه نشده است. برای مقایسه باید چند محصول اضافه کنید. محصولات جالب زیادی را در صفحه \"فروشگاه\" ما خواهید یافت.\";s:15:\"compare_on_grid\";s:1:\"1\";s:25:\"compare_save_button_state\";s:1:\"0\";s:19:\"compare_by_category\";s:1:\"0\";s:22:\"show_more_products_btn\";s:1:\"1\";s:18:\"cart_totals_layout\";s:8:\"layout-1\";s:27:\"update_cart_quantity_change\";s:1:\"0\";s:15:\"empty_cart_text\";s:140:\"Before proceed to checkout you must add some products to your shopping cart. You will find a lot of interesting products on our \"Shop\" page.\";s:27:\"thank_you_page_content_type\";s:4:\"text\";s:28:\"thank_you_page_extra_content\";s:0:\"\";s:25:\"thank_you_page_html_block\";s:0:\"\";s:30:\"thank_you_page_default_content\";s:1:\"1\";s:21:\"single_product_layout\";s:10:\"full-width\";s:19:\"full_height_sidebar\";s:1:\"0\";s:20:\"single_sidebar_width\";s:1:\"3\";s:27:\"single_product_hide_sidebar\";s:1:\"0\";s:34:\"single_product_hide_sidebar_tablet\";s:1:\"1\";s:34:\"single_product_hide_sidebar_mobile\";s:1:\"1\";s:20:\"single_product_style\";s:1:\"2\";s:14:\"product_design\";s:7:\"default\";s:14:\"product_sticky\";s:1:\"0\";s:22:\"product_summary_shadow\";s:1:\"0\";s:17:\"single_full_width\";s:1:\"0\";s:21:\"single_product_header\";s:4:\"none\";s:32:\"single_product_builder_post_data\";s:0:\"\";s:12:\"image_action\";s:4:\"zoom\";s:15:\"photoswipe_icon\";s:1:\"1\";s:26:\"product_slider_auto_height\";s:1:\"0\";s:23:\"pagination_main_gallery\";s:1:\"0\";s:23:\"product_images_captions\";s:1:\"0\";s:14:\"thums_position\";s:4:\"left\";s:31:\"single_product_grid_columns_gap\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:34:\"single_product_grid_column_desktop\";s:0:\"\";s:33:\"single_product_grid_column_tablet\";s:0:\"\";s:33:\"single_product_grid_column_mobile\";s:0:\"\";s:37:\"single_product_gallery_column_desktop\";s:1:\"1\";s:36:\"single_product_gallery_column_tablet\";s:0:\"\";s:36:\"single_product_gallery_column_mobile\";s:0:\"\";s:40:\"single_product_thumbnails_vertical_items\";s:1:\"3\";s:39:\"single_product_thumbnails_items_desktop\";s:1:\"4\";s:38:\"single_product_thumbnails_items_tablet\";s:1:\"4\";s:38:\"single_product_thumbnails_items_mobile\";s:1:\"3\";s:22:\"main_gallery_on_tablet\";s:1:\"1\";s:22:\"main_gallery_on_mobile\";s:1:\"1\";s:24:\"main_gallery_center_mode\";s:1:\"0\";s:48:\"single_product_thumbnails_wrap_in_mobile_devices\";s:1:\"1\";s:39:\"single_product_thumbnails_gallery_width\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:40:\"single_product_thumbnails_gallery_height\";s:156:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifSwidGFibGV0Ijp7InZhbHVlIjoiIiwidW5pdCI6InB4In0sIm1vYmlsZSI6eyJ2YWx1ZSI6IiIsInVuaXQiOiJweCJ9fX0=\";s:45:\"single_product_thumbnails_gallery_image_width\";s:3:\"150\";s:23:\"single_ajax_add_to_cart\";s:1:\"1\";s:25:\"single_sticky_add_to_cart\";s:1:\"0\";s:32:\"mobile_single_sticky_add_to_cart\";s:1:\"0\";s:33:\"sticky_add_to_cart_height_desktop\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_tablet\";s:2:\"95\";s:32:\"sticky_add_to_cart_height_mobile\";s:2:\"42\";s:31:\"before_add_to_cart_content_type\";s:4:\"text\";s:26:\"content_before_add_to_cart\";s:0:\"\";s:29:\"before_add_to_cart_html_block\";s:0:\"\";s:30:\"after_add_to_cart_content_type\";s:4:\"text\";s:25:\"content_after_add_to_cart\";s:0:\"\";s:28:\"after_add_to_cart_html_block\";s:0:\"\";s:27:\"single_breadcrumbs_position\";s:7:\"default\";s:24:\"product_page_breadcrumbs\";s:1:\"1\";s:12:\"products_nav\";s:1:\"1\";s:25:\"product_short_description\";s:1:\"1\";s:21:\"attr_after_short_desc\";s:1:\"0\";s:19:\"stock_status_design\";s:7:\"default\";s:25:\"single_stock_progress_bar\";s:1:\"0\";s:17:\"product_countdown\";s:1:\"0\";s:23:\"sale_countdown_variable\";s:1:\"0\";s:17:\"product_show_meta\";s:11:\"add_to_cart\";s:18:\"show_product_brand\";s:1:\"0\";s:13:\"product_share\";s:1:\"1\";s:18:\"product_share_type\";s:5:\"share\";s:16:\"related_products\";s:1:\"1\";s:16:\"upsells_position\";s:8:\"standard\";s:20:\"related_product_view\";s:6:\"slider\";s:23:\"related_product_columns\";s:1:\"4\";s:30:\"related_product_columns_tablet\";s:4:\"auto\";s:30:\"related_product_columns_mobile\";s:4:\"auto\";s:21:\"related_product_count\";s:1:\"8\";s:19:\"product_tabs_layout\";s:4:\"tabs\";s:21:\"product_tabs_location\";s:8:\"standard\";s:23:\"product_accordion_state\";s:5:\"first\";s:16:\"hide_tabs_titles\";s:1:\"1\";s:20:\"additional_tab_title\";s:19:\"Shipping & Delivery\";s:27:\"additional_tab_content_type\";s:4:\"text\";s:19:\"additional_tab_text\";s:0:\"\";s:25:\"additional_tab_html_block\";s:0:\"\";s:22:\"additional_tab_2_title\";s:0:\"\";s:29:\"additional_tab_2_content_type\";s:4:\"text\";s:21:\"additional_tab_2_text\";s:0:\"\";s:27:\"additional_tab_2_html_block\";s:0:\"\";s:22:\"additional_tab_3_title\";s:0:\"\";s:29:\"additional_tab_3_content_type\";s:4:\"text\";s:21:\"additional_tab_3_text\";s:0:\"\";s:27:\"additional_tab_3_html_block\";s:0:\"\";s:10:\"login_tabs\";s:1:\"1\";s:9:\"reg_title\";s:8:\"Register\";s:8:\"reg_text\";s:258:\"Registering for this site allows you to access your order status and history. Just fill in the fields below, and we\'ll get a new account set up for you in no time. We will only ask you for information necessary to make the purchase process faster and easier.\";s:11:\"login_title\";s:5:\"Login\";s:10:\"login_text\";s:0:\"\";s:16:\"my_account_links\";s:1:\"1\";s:10:\"custom_css\";s:2149:\".whb-flex-row.whb-general-header-inner{\r\n	padding-right:24px;\r\n	padding-left:24px;\r\n	background:white;\r\n	border-radius:20px;\r\n	box-shadow: 0px 0px 40px rgba(74, 36, 157, 0.1);}\r\n.whb-flex-row.whb-header-bottom-inner{\r\n  background:white;\r\n	padding-right:24px;\r\n	padding-left:24px;\r\n	border-bottom-left-radius:20px;\r\nborder-bottom-right-radius:20px;\r\nmargin-left:30px;\r\nmargin-right:30px;\r\n	box-shadow: 0px 0px 40px rgba(74, 36, 157, 0.1)}\r\n.whb-flex-row.whb-top-bar-inner{\r\n		padding-right:24px;\r\n	padding-left:24px;\r\n	background:white;\r\n	box-shadow: 0px 0px 40px rgba(74, 36, 157, 0.1);\r\nmargin-left:30px;\r\nmargin-right:30px;\r\nborder-top-left-radius:20px;\r\nborder-top-right-radius:20px;\r\n}\r\n.stories.carousel\r\n{\r\n	text-align:center;\r\n}\r\n\r\n\r\n\r\n.stories.snapgram .story.seen,.stories.carousel .story\r\n{\r\n	margin:10px 30px 4px 30px !important;\r\n}\r\n.stories.carousel .story>.item-link>.info .name\r\n{\r\n	font-weight:600 ;\r\n}\r\n.stories.snapgram .story>.item-link>.item-preview{\r\n	border-radius:20px\r\n}\r\n.stories.snapgram .story>.item-link>.item-preview img{\r\n	border-radius:18px\r\n}\r\n.timerscale{\r\n	scale:0.8\r\n}\r\n.offcaro .wd-timer-value{\r\n	font-size:14px\r\n}\r\n.offcaro .wd-timer-text{\r\n	font-size:10px\r\n}\r\n.offcaro .wd-timer{\r\n	gap:3px\r\n}\r\n.offcaro .total-sold{\r\n	font-size:11px\r\n}\r\n\r\n.offcaro .current-stock{\r\n	font-size:11px\r\n}\r\n.offcaro .digikala .wd-product-countdown, .product-grid-item .wd-stock-progress-bar{\r\n	padding-top:10px\r\n}\r\n.offcaro .wd-timer-sec .wd-timer-value{\r\n	color:var(--wd-primary-color)\r\n}\r\n.offcaro .wd-timer-sec{\r\n	 background: rgba(74, 36, 157, 0.05);\r\n}\r\n.smallpro img{\r\n	width:70px\r\n}\r\n.blogcard a{\r\n	font-size:16px\r\n}\r\n#timer-product .elementor-widget-container{\r\n	display:flex;\r\n	align-items: center;\r\n}\r\n#timer-product .title.element-title{\r\n	margin-bottom:0px;\r\n}\r\n.wd-post .article-inner\r\n{\r\nbackground-color:white;\r\n	padding:20px;\r\n	padding-top:25px\r\n}\r\n.wd-post .article-inner:before{\r\n	content: \" \";\r\n    position: absolute;\r\n    width: 150px;\r\n    top: 0px;\r\n    transform: translate(-50%, 0%);\r\n    left: 50%;\r\n    border-radius: 0px 0px 10px 10px;\r\n    height: 8px;\r\n    background-color: var(--wd-primary-color);\r\n}\";s:11:\"css_desktop\";s:0:\"\";s:10:\"css_tablet\";s:0:\"\";s:15:\"css_wide_mobile\";s:0:\"\";s:10:\"css_mobile\";s:0:\"\";s:11:\"css_backend\";s:0:\"\";s:9:\"custom_js\";s:0:\"\";s:8:\"js_ready\";s:0:\"\";s:13:\"sticky_social\";s:1:\"0\";s:18:\"sticky_social_type\";s:6:\"follow\";s:22:\"sticky_social_position\";s:5:\"right\";s:20:\"social_follow_notice\";s:0:\"\";s:7:\"fb_link\";s:1:\"#\";s:12:\"twitter_link\";s:1:\"#\";s:12:\"bluesky_link\";s:0:\"\";s:14:\"isntagram_link\";s:1:\"#\";s:12:\"threads_link\";s:0:\"\";s:14:\"pinterest_link\";s:1:\"#\";s:12:\"youtube_link\";s:1:\"#\";s:11:\"tumblr_link\";s:0:\"\";s:13:\"linkedin_link\";s:0:\"\";s:10:\"vimeo_link\";s:0:\"\";s:11:\"flickr_link\";s:0:\"\";s:11:\"github_link\";s:0:\"\";s:13:\"dribbble_link\";s:0:\"\";s:12:\"behance_link\";s:0:\"\";s:15:\"soundcloud_link\";s:0:\"\";s:12:\"spotify_link\";s:0:\"\";s:10:\"skype_link\";s:0:\"\";s:13:\"whatsapp_link\";s:0:\"\";s:13:\"snapchat_link\";s:0:\"\";s:7:\"tg_link\";s:0:\"\";s:10:\"viber_link\";s:0:\"\";s:11:\"tiktok_link\";s:0:\"\";s:12:\"discord_link\";s:0:\"\";s:9:\"yelp_link\";s:0:\"\";s:7:\"vk_link\";s:0:\"\";s:7:\"ok_link\";s:0:\"\";s:18:\"social_email_links\";s:1:\"0\";s:19:\"social_share_notice\";s:0:\"\";s:8:\"share_fb\";s:1:\"1\";s:13:\"share_twitter\";s:1:\"1\";s:15:\"share_pinterest\";s:1:\"1\";s:14:\"share_linkedin\";s:1:\"1\";s:14:\"share_whatsapp\";s:1:\"0\";s:8:\"share_tg\";s:1:\"1\";s:11:\"share_viber\";s:1:\"0\";s:8:\"share_vk\";s:1:\"0\";s:8:\"share_ok\";s:1:\"0\";s:11:\"share_email\";s:1:\"0\";s:19:\"mobile_optimization\";s:1:\"0\";s:16:\"load_text_domain\";s:1:\"1\";s:21:\"disable_gutenberg_css\";s:1:\"0\";s:17:\"styles_always_use\";s:0:\"\";s:14:\"styles_not_use\";s:0:\"\";s:26:\"disable_owl_mobile_devices\";s:1:\"0\";s:21:\"remove_jquery_migrate\";s:1:\"0\";s:18:\"advanced_js_notice\";s:0:\"\";s:11:\"advanced_js\";s:1:\"0\";s:20:\"autocomplete_library\";s:8:\"required\";s:14:\"cookie_library\";s:8:\"required\";s:24:\"countdown-bundle_library\";s:8:\"required\";s:14:\"device_library\";s:7:\"not_use\";s:22:\"isotope-bundle_library\";s:8:\"required\";s:17:\"justified_library\";s:8:\"required\";s:16:\"magnific_library\";s:8:\"required\";s:28:\"panr-parallax-bundle_library\";s:8:\"required\";s:16:\"parallax_library\";s:8:\"required\";s:30:\"parallax-scroll-bundle_library\";s:8:\"required\";s:25:\"photoswipe-bundle_library\";s:8:\"required\";s:12:\"pjax_library\";s:8:\"required\";s:18:\"sticky-kit_library\";s:8:\"required\";s:17:\"wd_swiper_library\";s:8:\"required\";s:18:\"threesixty_library\";s:8:\"required\";s:16:\"tooltips_library\";s:8:\"required\";s:13:\"vivus_library\";s:8:\"required\";s:17:\"waypoints_library\";s:8:\"required\";s:15:\"leaflet_library\";s:8:\"required\";s:20:\"vimeo_player_library\";s:8:\"required\";s:18:\"scripts_always_use\";s:0:\"\";s:15:\"scripts_not_use\";s:0:\"\";s:15:\"dequeue_scripts\";s:0:\"\";s:12:\"lazy_loading\";s:1:\"0\";s:22:\"lazy_loading_bg_images\";s:1:\"0\";s:19:\"lazy_loading_offset\";s:1:\"0\";s:11:\"lazy_effect\";s:4:\"none\";s:23:\"lazy_custom_placeholder\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:30:\"disable_wordpress_lazy_loading\";s:1:\"0\";s:26:\"rocket_delay_js_exclusions\";s:1:\"0\";s:6:\"cf7_js\";s:1:\"1\";s:20:\"elementor_animations\";s:1:\"1\";s:15:\"elementor_icons\";s:1:\"1\";s:24:\"elementor_dialog_library\";s:1:\"1\";s:18:\"elementor_frontend\";s:1:\"1\";s:14:\"swiper_library\";s:6:\"always\";s:19:\"google_font_display\";s:7:\"disable\";s:18:\"icons_font_display\";s:7:\"disable\";s:16:\"font_awesome_css\";s:7:\"not_use\";s:23:\"font_icon_woff2_preload\";s:1:\"0\";s:9:\"preloader\";s:1:\"1\";s:15:\"preloader_image\";a:2:{s:3:\"url\";s:98:\"https://demoes.aramis-co.ir/Underwear/wp-content/uploads/2025/04/Frame314_1-ezgif.com-resize-1.gif\";s:2:\"id\";s:3:\"729\";}s:26:\"preloader_background_color\";a:1:{s:4:\"idle\";s:7:\"#ffffff\";}s:22:\"preloader_color_scheme\";s:4:\"dark\";s:15:\"current_builder\";s:8:\"external\";s:16:\"gutenberg_blocks\";s:1:\"0\";s:29:\"enable_gutenberg_for_products\";s:1:\"0\";s:12:\"negative_gap\";s:7:\"enabled\";s:20:\"sticky_notifications\";s:1:\"0\";s:13:\"page_comments\";s:1:\"1\";s:15:\"custom_404_page\";s:0:\"\";s:16:\"widget_title_tag\";s:2:\"h5\";s:15:\"woodmart_slider\";s:1:\"1\";s:16:\"allow_upload_svg\";s:1:\"1\";s:29:\"rev_slider_inherit_theme_font\";s:1:\"0\";s:13:\"site_viewport\";s:12:\"not_scalable\";s:16:\"maintenance_mode\";s:1:\"0\";s:22:\"maintenance_access_key\";s:0:\"\";s:11:\"white_label\";s:1:\"0\";s:22:\"white_label_theme_name\";s:0:\"\";s:12:\"dummy_import\";s:1:\"1\";s:29:\"white_label_theme_license_tab\";s:1:\"1\";s:25:\"white_label_changelog_tab\";s:1:\"1\";s:20:\"theme_admin_bar_menu\";s:1:\"1\";s:23:\"white_label_theme_hints\";s:1:\"1\";s:29:\"white_label_sidebar_icon_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:26:\"white_label_dashboard_logo\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:33:\"white_label_appearance_screenshot\";a:2:{s:3:\"url\";s:0:\"\";s:2:\"id\";s:0:\"\";}s:27:\"white_label_dashboard_title\";s:0:\"\";s:26:\"white_label_dashboard_text\";s:0:\"\";s:5:\"reset\";s:0:\"\";s:12:\"reset_notice\";s:0:\"\";s:8:\"wishlist\";s:1:\"1\";s:13:\"wishlist_page\";s:3:\"870\";s:15:\"wishlist_logged\";s:1:\"0\";s:20:\"wishlist_bulk_action\";s:1:\"1\";s:19:\"wishlist_empty_text\";s:112:\"You don\'t have any products in the wishlist yet. You will find a lot of interesting products on our \"Shop\" page.\";s:17:\"wishlist_expanded\";s:1:\"0\";s:19:\"wishlist_show_popup\";s:6:\"enable\";s:21:\"product_loop_wishlist\";s:1:\"1\";s:26:\"wishlist_save_button_state\";s:1:\"0\";s:27:\"checkout_show_product_image\";s:1:\"0\";s:25:\"checkout_product_quantity\";s:1:\"0\";s:22:\"checkout_remove_button\";s:1:\"0\";s:24:\"checkout_link_to_product\";s:1:\"0\";s:16:\"reviews_location\";s:4:\"tabs\";s:23:\"reviews_section_columns\";s:10:\"two-column\";s:21:\"reviews_form_location\";s:5:\"after\";s:13:\"reviews_style\";s:7:\"style-1\";s:15:\"reviews_columns\";s:1:\"1\";s:22:\"reviews_columns_tablet\";s:1:\"1\";s:22:\"reviews_columns_mobile\";s:1:\"1\";s:24:\"reviews_enable_pros_cons\";s:1:\"0\";s:20:\"reviews_enable_likes\";s:1:\"0\";s:32:\"show_reviews_purchased_indicator\";s:1:\"0\";s:15:\"reviews_sorting\";s:1:\"0\";s:29:\"single_product_comment_images\";s:1:\"0\";s:35:\"single_product_comment_images_count\";s:1:\"3\";s:41:\"single_product_comment_images_upload_size\";s:1:\"1\";s:38:\"single_product_comment_images_required\";s:1:\"0\";s:30:\"show_reviews_only_image_filter\";s:1:\"0\";s:22:\"reviews_rating_summary\";s:1:\"0\";s:30:\"reviews_rating_summary_content\";s:6:\"rating\";s:29:\"reviews_rating_summary_filter\";s:1:\"0\";s:26:\"reviews_rating_by_criteria\";s:1:\"0\";s:32:\"reviews_criteria_rating_required\";s:1:\"0\";s:38:\"reviews_rating_summary_criteria_1_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_1\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_2_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_2\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_3_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_3\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_4_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_4\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_5_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_5\";s:0:\"\";s:38:\"reviews_rating_summary_criteria_6_slug\";s:0:\"\";s:33:\"reviews_rating_summary_criteria_6\";s:0:\"\";s:24:\"sticky_navigation_notice\";s:0:\"\";s:22:\"sticky_navigation_menu\";s:13:\"category-menu\";s:23:\"sticky_navigation_title\";s:32:\"دسته بندی محصولات\";s:30:\"sticky_navigation_content_type\";s:10:\"html_block\";s:22:\"sticky_navigation_area\";s:0:\"\";s:28:\"sticky_navigation_html_block\";s:3:\"140\";s:33:\"single_product_main_gallery_video\";s:1:\"1\";s:23:\"checkout_fields_enabled\";s:1:\"0\";s:29:\"shipping_progress_bar_enabled\";s:1:\"0\";s:33:\"shipping_progress_bar_calculation\";s:6:\"custom\";s:28:\"shipping_progress_bar_amount\";s:3:\"100\";s:36:\"shipping_progress_bar_include_coupon\";s:7:\"exclude\";s:40:\"shipping_progress_bar_location_card_page\";s:1:\"1\";s:40:\"shipping_progress_bar_location_mini_cart\";s:1:\"1\";s:39:\"shipping_progress_bar_location_checkout\";s:1:\"0\";s:45:\"shipping_progress_bar_location_single_product\";s:1:\"0\";s:37:\"shipping_progress_bar_message_initial\";s:46:\"Add [remainder] to cart and get free shipping!\";s:37:\"shipping_progress_bar_message_success\";s:39:\"Your order qualifies for free shipping!\";s:15:\"buy_now_enabled\";s:1:\"0\";s:16:\"buy_now_redirect\";s:8:\"checkout\";s:23:\"counter_visitor_enabled\";s:1:\"0\";s:27:\"counter_visitor_data_source\";s:9:\"live_data\";s:38:\"counter_visitor_data_source_min_number\";s:2:\"10\";s:38:\"counter_visitor_data_source_max_number\";s:2:\"20\";s:25:\"counter_visitor_live_mode\";s:1:\"0\";s:27:\"counter_visitor_ajax_update\";s:1:\"0\";s:29:\"counter_visitor_live_duration\";s:2:\"10\";s:17:\"linked_variations\";s:1:\"1\";s:21:\"show_single_variation\";s:1:\"0\";s:21:\"hide_variation_parent\";s:1:\"0\";s:23:\"bought_together_enabled\";s:1:\"1\";s:22:\"bought_together_column\";s:1:\"3\";s:29:\"bought_together_column_tablet\";s:4:\"auto\";s:29:\"bought_together_column_mobile\";s:4:\"auto\";s:26:\"bought_together_form_width\";s:64:\"eyJkZXZpY2VzIjp7ImRlc2t0b3AiOnsidmFsdWUiOiIiLCJ1bml0IjoicHgifX19\";s:20:\"sold_counter_enabled\";s:1:\"0\";s:23:\"sold_counter_sales_type\";s:9:\"real_data\";s:24:\"sold_counter_shown_after\";s:1:\"0\";s:22:\"sold_counter_min_count\";s:2:\"10\";s:22:\"sold_counter_max_count\";s:2:\"20\";s:31:\"sold_counter_hide_on_outofstock\";s:1:\"0\";s:22:\"sold_counter_timeframe\";s:1:\"3\";s:29:\"sold_counter_timeframe_period\";s:7:\"minutes\";s:28:\"sold_counter_transient_hours\";s:2:\"24\";s:17:\"discounts_enabled\";s:1:\"0\";s:20:\"show_discounts_table\";s:1:\"0\";s:18:\"free_gifts_enabled\";s:1:\"0\";s:16:\"free_gifts_limit\";s:1:\"5\";s:41:\"free_gifts_allow_multiple_identical_gifts\";s:1:\"0\";s:23:\"free_gifts_price_format\";s:4:\"text\";s:17:\"free_gift_on_cart\";s:1:\"1\";s:25:\"free_gifts_table_location\";s:28:\"woocommerce_after_cart_table\";s:21:\"free_gift_on_checkout\";s:1:\"0\";s:28:\"show_out_of_stock_at_the_end\";s:1:\"0\";s:16:\"waitlist_enabled\";s:1:\"0\";s:21:\"waitlist_for_loggined\";s:1:\"0\";s:19:\"waitlist_form_state\";s:13:\"current_state\";s:25:\"waitlist_fragments_enable\";s:1:\"0\";s:22:\"waitlist_wait_interval\";s:4:\"3600\";s:32:\"waitlist_enable_privacy_checkbox\";s:1:\"1\";s:30:\"waitlist_privacy_checkbox_text\";s:85:\"من <strong>[privacy_policy]</strong> را خوانده‌ام و می‌پذیرم.\";s:25:\"estimate_delivery_enabled\";s:1:\"0\";s:40:\"estimate_delivery_show_on_single_product\";s:1:\"1\";s:35:\"estimate_delivery_show_on_mini_cart\";s:1:\"0\";s:35:\"estimate_delivery_show_on_cart_page\";s:1:\"1\";s:39:\"estimate_delivery_show_on_checkout_page\";s:1:\"1\";s:39:\"estimate_delivery_show_on_order_details\";s:1:\"1\";s:37:\"estimate_delivery_show_on_email_order\";s:1:\"1\";s:30:\"estimate_delivery_show_overall\";s:1:\"0\";s:29:\"estimate_delivery_date_format\";s:7:\"default\";s:34:\"estimate_delivery_fragments_enable\";s:1:\"0\";s:21:\"cart_recovery_enabled\";s:1:\"0\";s:26:\"recover_guest_cart_enabled\";s:1:\"0\";s:42:\"recover_guest_cart_enable_privacy_checkbox\";s:1:\"0\";s:40:\"recover_guest_cart_privacy_checkbox_text\";s:447:\"اگر این کادر را علامت بزنید، به ما اجازه می دهید تا برخی از جزئیات خود را در لیست مخاطبین ذخیره کنیم. ممکن است پیام های ایمیلی حاوی اطلاعات تجاری یا تبلیغاتی در مورد این فروشگاه دریافت کنید.\r\nاطلاعات شخصی جمع آوری شده: آدرس ایمیل، نام و نام خانوادگی.\";s:24:\"abandoned_cart_timeframe\";s:1:\"2\";s:31:\"abandoned_cart_timeframe_period\";s:5:\"86400\";s:31:\"abandoned_cart_delete_timeframe\";s:2:\"30\";s:38:\"abandoned_cart_delete_timeframe_period\";s:5:\"86400\";s:29:\"abandoned_cart_coupon_enabled\";s:1:\"0\";s:28:\"abandoned_cart_coupon_prefix\";s:2:\"WD\";s:28:\"abandoned_cart_coupon_amount\";s:2:\"10\";s:35:\"abandoned_cart_coupon_discount_type\";s:7:\"percent\";s:34:\"abandoned_cart_delete_used_coupons\";s:1:\"1\";s:37:\"abandoned_cart_delete_expired_coupons\";s:1:\"1\";s:31:\"abandoned_cart_coupon_timeframe\";s:1:\"1\";s:38:\"abandoned_cart_coupon_timeframe_period\";s:5:\"86400\";s:8:\"last_tab\";s:10:\"custom_css\";}", "auto");
INSERT INTO `wp_options` VALUES("160", "woodmart_setup_status", "", "auto");
INSERT INTO `wp_options` VALUES("161", "wd_import_theme_version", "", "auto");
INSERT INTO `wp_options` VALUES("162", "woodmart-plugins-update-time", "1749479431", "auto");
INSERT INTO `wp_options` VALUES("163", "woodmart_js_composer_version", "8.4.1", "auto");
INSERT INTO `wp_options` VALUES("164", "woodmart_revslider_version", "6.7.34", "auto");
INSERT INTO `wp_options` VALUES("165", "RTL-CareUnit-PIL", "q1bKSS1LzVGyUnJMLsksSyzJzM9T0lEqLkksKS0GigaXJienFhcDhVJSi5OLMgvACqyUlGoB", "off");
INSERT INTO `wp_options` VALUES("166", "rcuPluginHealthyServerIndex", "1", "off");
INSERT INTO `wp_options` VALUES("167", "rcuPluginLastHealthyServerIndex", "1", "off");
INSERT INTO `wp_options` VALUES("172", "RTL-CareUnit-FPA", "1", "auto");
INSERT INTO `wp_options` VALUES("430", "elementor_checklist", "{\"last_opened_timestamp\":null,\"first_closed_checklist_in_editor\":false,\"is_popup_minimized\":false,\"steps\":{\"add_logo\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"set_fonts_and_colors\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"create_pages\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"setup_header\":{\"is_marked_completed\":false,\"is_immutable_completed\":false},\"assign_homepage\":{\"is_marked_completed\":false,\"is_immutable_completed\":false}},\"should_open_in_editor\":false}", "auto");
INSERT INTO `wp_options` VALUES("453", "wc_remote_inbox_notifications_wca_updated", "", "off");
INSERT INTO `wp_options` VALUES("432", "elementor_log", "a:22:{s:32:\"d9b476e8ba59b6eb02548b2315a4f0f2\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-17 15:35:43\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.1\";s:2:\"to\";s:6:\"3.28.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-17 15:35:43\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.1\";s:2:\"to\";s:6:\"3.28.3\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"f81253b95a3f32d2236a06877b50f6ad\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-17 15:35:44\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-17 15:35:44\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"88360a45d4db41970189a1aad8fcc77f\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-17 15:35:44\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-17 15:35:44\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"6fc4c1e3f23368c37bbc99c168f72794\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-17 15:35:44\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-17 15:35:44\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"e4d6b164664fc911e8f94c97d4749bbd\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-04-17 15:35:44\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.1\";s:2:\"to\";s:6:\"3.28.3\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-17 15:35:44\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.1\";s:2:\"to\";s:6:\"3.28.3\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"f99eb5ed417492ef28b6b3000203a316\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:6:\"797868\";s:7:\"\0*\0file\";s:101:\"https://demoes.aramis-co.ir/Underwear/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.28.3\";s:7:\"\0*\0line\";s:1:\"3\";s:7:\"\0*\0date\";s:19:\"2025-04-17 17:32:21\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:61:\"Cannot read properties of undefined (reading &#039;get&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-04-17 17:32:21\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1744911141\";s:7:\"message\";s:51:\"Cannot read properties of undefined (reading \'get\')\";s:3:\"url\";s:101:\"https://demoes.aramis-co.ir/Underwear/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.28.3\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:6:\"797868\";}}s:32:\"1a48d9e9962fdab7a00bd435a4e1ad19\";O:31:\"Elementor\\Core\\Logger\\Items\\PHP\":9:{s:7:\"\0*\0file\";s:121:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/Underwear/wp-content/plugins/elementor/includes/managers/image.php\";s:7:\"\0*\0line\";i:113;s:7:\"\0*\0date\";s:19:\"2025-04-17 22:42:00\";s:7:\"\0*\0type\";s:6:\"notice\";s:10:\"\0*\0message\";s:51:\"Trying to access array offset on value of type bool\";s:7:\"\0*\0meta\";a:1:{s:5:\"trace\";a:1:{i:0;a:3:{s:8:\"function\";s:8:\"shutdown\";s:5:\"class\";s:29:\"Elementor\\Core\\Logger\\Manager\";s:4:\"type\";s:2:\"->\";}}}s:8:\"\0*\0times\";i:7;s:14:\"\0*\0times_dates\";a:7:{i:0;s:19:\"2025-04-17 22:42:00\";i:1;s:19:\"2025-04-19 20:32:09\";i:2;s:19:\"2025-05-20 18:47:02\";i:3;s:19:\"2025-05-20 18:50:49\";i:4;s:19:\"2025-05-26 21:23:27\";i:5;s:19:\"2025-05-26 22:32:31\";i:6;s:19:\"2025-05-26 22:33:29\";}s:7:\"\0*\0args\";a:5:{s:4:\"type\";s:6:\"notice\";s:7:\"message\";s:51:\"Trying to access array offset on value of type bool\";s:4:\"file\";s:121:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/Underwear/wp-content/plugins/elementor/includes/managers/image.php\";s:4:\"line\";i:113;s:5:\"trace\";b:1;}}s:32:\"9a265cd7ec074eda7c026c6297c590e1\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:6:\"818582\";s:7:\"\0*\0file\";s:101:\"https://demoes.aramis-co.ir/Underwear/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.28.3\";s:7:\"\0*\0line\";s:1:\"3\";s:7:\"\0*\0date\";s:19:\"2025-04-19 17:44:00\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:69:\"Cannot read properties of undefined (reading &#039;toLowerCase&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:3;s:14:\"\0*\0times_dates\";a:3:{i:0;s:19:\"2025-04-19 17:44:00\";i:1;s:19:\"2025-04-19 17:44:07\";i:2;s:19:\"2025-04-22 14:38:19\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1745084640\";s:7:\"message\";s:59:\"Cannot read properties of undefined (reading \'toLowerCase\')\";s:3:\"url\";s:101:\"https://demoes.aramis-co.ir/Underwear/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.28.3\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:6:\"818582\";}}s:32:\"7eba2ec85cd008299e3ea5c46e82492f\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:6:\"819089\";s:7:\"\0*\0file\";s:101:\"https://demoes.aramis-co.ir/Underwear/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.28.3\";s:7:\"\0*\0line\";s:1:\"3\";s:7:\"\0*\0date\";s:19:\"2025-04-19 17:44:10\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:67:\"Cannot read properties of undefined (reading &#039;localized&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:52;s:14:\"\0*\0times_dates\";a:42:{i:0;s:19:\"2025-04-19 17:44:11\";i:1;s:19:\"2025-04-19 17:44:12\";i:2;s:19:\"2025-04-19 17:44:12\";i:3;s:19:\"2025-04-19 17:44:12\";i:4;s:19:\"2025-04-19 17:44:12\";i:5;s:19:\"2025-04-19 17:44:12\";i:6;s:19:\"2025-04-19 17:44:12\";i:7;s:19:\"2025-04-19 17:44:25\";i:8;s:19:\"2025-04-19 17:44:25\";i:9;s:19:\"2025-04-19 17:44:25\";i:10;s:19:\"2025-04-19 17:44:25\";i:11;s:19:\"2025-04-19 17:44:26\";i:12;s:19:\"2025-04-19 17:44:26\";i:13;s:19:\"2025-04-19 17:44:26\";i:14;s:19:\"2025-04-19 17:44:26\";i:15;s:19:\"2025-04-19 17:44:26\";i:16;s:19:\"2025-04-21 16:06:16\";i:17;s:19:\"2025-04-21 16:06:16\";i:18;s:19:\"2025-04-21 20:01:57\";i:19;s:19:\"2025-04-21 20:01:57\";i:20;s:19:\"2025-04-21 21:11:33\";i:21;s:19:\"2025-04-21 21:11:33\";i:22;s:19:\"2025-04-22 14:38:22\";i:23;s:19:\"2025-04-22 14:38:22\";i:24;s:19:\"2025-04-22 14:38:22\";i:25;s:19:\"2025-04-22 17:06:28\";i:26;s:19:\"2025-04-22 17:06:29\";i:27;s:19:\"2025-04-22 20:16:24\";i:28;s:19:\"2025-04-22 20:16:24\";i:29;s:19:\"2025-04-23 11:14:05\";i:30;s:19:\"2025-04-23 11:14:06\";i:31;s:19:\"2025-04-23 17:12:17\";i:32;s:19:\"2025-04-23 17:12:17\";i:33;s:19:\"2025-04-26 17:22:41\";i:34;s:19:\"2025-04-26 17:22:42\";i:35;s:19:\"2025-04-26 17:22:42\";i:36;s:19:\"2025-04-26 17:22:42\";i:37;s:19:\"2025-04-26 17:22:42\";i:38;s:19:\"2025-04-26 17:22:42\";i:39;s:19:\"2025-04-26 17:45:37\";i:40;s:19:\"2025-04-26 17:45:37\";i:41;s:19:\"2025-05-29 13:27:27\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1745084650\";s:7:\"message\";s:57:\"Cannot read properties of undefined (reading \'localized\')\";s:3:\"url\";s:101:\"https://demoes.aramis-co.ir/Underwear/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.28.3\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:6:\"819089\";}}s:32:\"780d24dc506bdce3ada8389b622f6a11\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:7:\"1330037\";s:7:\"\0*\0file\";s:101:\"https://demoes.aramis-co.ir/Underwear/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.28.3\";s:7:\"\0*\0line\";s:1:\"3\";s:7:\"\0*\0date\";s:19:\"2025-04-21 13:42:55\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:74:\"Cannot read properties of null (reading &#039;getBoundingClientRect&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:6;s:14:\"\0*\0times_dates\";a:6:{i:0;s:19:\"2025-04-21 13:42:55\";i:1;s:19:\"2025-04-21 13:42:55\";i:2;s:19:\"2025-04-21 15:55:26\";i:3;s:19:\"2025-04-21 15:55:26\";i:4;s:19:\"2025-04-21 18:41:49\";i:5;s:19:\"2025-04-22 18:40:18\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1745242975\";s:7:\"message\";s:64:\"Cannot read properties of null (reading \'getBoundingClientRect\')\";s:3:\"url\";s:101:\"https://demoes.aramis-co.ir/Underwear/wp-content/plugins/elementor/assets/js/editor.min.js?ver=3.28.3\";s:4:\"line\";s:1:\"3\";s:6:\"column\";s:7:\"1330037\";}}s:32:\"20176940ae701dbf14a5ea3ef67073e8\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:5:\"14799\";s:7:\"\0*\0file\";s:106:\"https://demoes.aramis-co.ir/Underwear/wp-content/plugins/elementor/assets/lib/pickr/pickr.min.js?ver=1.8.2\";s:7:\"\0*\0line\";s:1:\"2\";s:7:\"\0*\0date\";s:19:\"2025-04-22 14:40:59\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:58:\"Cannot read properties of null (reading &#039;clone&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1762;s:14:\"\0*\0times_dates\";a:42:{i:0;s:19:\"2025-04-22 15:47:00\";i:1;s:19:\"2025-04-22 15:47:00\";i:2;s:19:\"2025-04-22 15:47:00\";i:3;s:19:\"2025-04-22 15:47:00\";i:4;s:19:\"2025-04-22 15:47:00\";i:5;s:19:\"2025-04-22 15:47:07\";i:6;s:19:\"2025-04-22 15:47:54\";i:7;s:19:\"2025-04-22 15:47:54\";i:8;s:19:\"2025-04-22 15:48:25\";i:9;s:19:\"2025-04-22 15:48:25\";i:10;s:19:\"2025-04-22 15:48:25\";i:11;s:19:\"2025-04-22 15:48:25\";i:12;s:19:\"2025-04-22 15:48:25\";i:13;s:19:\"2025-04-22 15:48:25\";i:14;s:19:\"2025-04-22 15:48:25\";i:15;s:19:\"2025-04-22 19:42:59\";i:16;s:19:\"2025-04-22 19:42:59\";i:17;s:19:\"2025-04-22 19:42:59\";i:18;s:19:\"2025-04-22 19:42:59\";i:19;s:19:\"2025-04-22 19:42:59\";i:20;s:19:\"2025-04-22 19:42:59\";i:21;s:19:\"2025-04-22 19:42:59\";i:22;s:19:\"2025-04-22 19:43:00\";i:23;s:19:\"2025-04-22 19:43:00\";i:24;s:19:\"2025-04-22 19:43:00\";i:25;s:19:\"2025-04-22 19:43:00\";i:26;s:19:\"2025-04-22 19:43:00\";i:27;s:19:\"2025-04-22 19:43:00\";i:28;s:19:\"2025-04-22 19:43:00\";i:29;s:19:\"2025-04-22 19:43:00\";i:30;s:19:\"2025-04-22 19:43:00\";i:31;s:19:\"2025-04-22 19:43:00\";i:32;s:19:\"2025-04-22 19:43:00\";i:33;s:19:\"2025-04-22 19:43:00\";i:34;s:19:\"2025-04-22 19:43:00\";i:35;s:19:\"2025-04-22 19:43:00\";i:36;s:19:\"2025-04-22 19:43:00\";i:37;s:19:\"2025-04-22 19:43:00\";i:38;s:19:\"2025-04-22 19:43:00\";i:39;s:19:\"2025-04-22 19:43:00\";i:40;s:19:\"2025-04-22 19:43:00\";i:41;s:19:\"2025-04-22 19:43:00\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1745332859\";s:7:\"message\";s:48:\"Cannot read properties of null (reading \'clone\')\";s:3:\"url\";s:106:\"https://demoes.aramis-co.ir/Underwear/wp-content/plugins/elementor/assets/lib/pickr/pickr.min.js?ver=1.8.2\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"14799\";}}s:32:\"0a997826a2fbc91e2cea3d61324d249d\";O:30:\"Elementor\\Core\\Logger\\Items\\JS\":10:{s:9:\"\0*\0column\";s:5:\"19552\";s:7:\"\0*\0file\";s:106:\"https://demoes.aramis-co.ir/Underwear/wp-content/plugins/elementor/assets/lib/pickr/pickr.min.js?ver=1.8.2\";s:7:\"\0*\0line\";s:1:\"2\";s:7:\"\0*\0date\";s:19:\"2025-04-22 14:41:00\";s:7:\"\0*\0type\";s:5:\"error\";s:10:\"\0*\0message\";s:63:\"Cannot read properties of null (reading &#039;changestop&#039;)\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:57;s:14:\"\0*\0times_dates\";a:42:{i:0;s:19:\"2025-04-22 14:41:52\";i:1;s:19:\"2025-04-22 14:41:53\";i:2;s:19:\"2025-04-22 14:42:40\";i:3;s:19:\"2025-04-22 14:42:40\";i:4;s:19:\"2025-04-22 14:42:47\";i:5;s:19:\"2025-04-22 14:42:49\";i:6;s:19:\"2025-04-22 14:42:50\";i:7;s:19:\"2025-04-22 14:42:53\";i:8;s:19:\"2025-04-22 14:43:43\";i:9;s:19:\"2025-04-22 14:43:50\";i:10;s:19:\"2025-04-22 14:43:51\";i:11;s:19:\"2025-04-22 14:43:52\";i:12;s:19:\"2025-04-22 14:43:53\";i:13;s:19:\"2025-04-22 14:47:27\";i:14;s:19:\"2025-04-22 14:47:30\";i:15;s:19:\"2025-04-22 14:47:30\";i:16;s:19:\"2025-04-22 14:47:32\";i:17;s:19:\"2025-04-22 14:47:40\";i:18;s:19:\"2025-04-22 14:47:41\";i:19;s:19:\"2025-04-22 14:47:42\";i:20;s:19:\"2025-04-22 14:47:43\";i:21;s:19:\"2025-04-22 14:47:43\";i:22;s:19:\"2025-04-22 14:47:51\";i:23;s:19:\"2025-04-22 14:47:53\";i:24;s:19:\"2025-04-22 14:47:57\";i:25;s:19:\"2025-04-22 14:47:59\";i:26;s:19:\"2025-04-22 14:48:02\";i:27;s:19:\"2025-04-22 14:48:03\";i:28;s:19:\"2025-04-22 14:48:03\";i:29;s:19:\"2025-04-22 14:48:09\";i:30;s:19:\"2025-04-22 14:49:59\";i:31;s:19:\"2025-04-22 14:50:04\";i:32;s:19:\"2025-04-22 14:50:12\";i:33;s:19:\"2025-04-22 14:50:16\";i:34;s:19:\"2025-04-22 14:50:21\";i:35;s:19:\"2025-04-22 14:50:23\";i:36;s:19:\"2025-04-22 14:50:24\";i:37;s:19:\"2025-04-22 14:50:29\";i:38;s:19:\"2025-04-22 14:50:32\";i:39;s:19:\"2025-04-22 15:46:20\";i:40;s:19:\"2025-04-22 15:47:01\";i:41;s:19:\"2025-04-22 19:43:00\";}s:7:\"\0*\0args\";a:6:{s:4:\"type\";s:5:\"error\";s:9:\"timestamp\";s:10:\"1745332860\";s:7:\"message\";s:53:\"Cannot read properties of null (reading \'changestop\')\";s:3:\"url\";s:106:\"https://demoes.aramis-co.ir/Underwear/wp-content/plugins/elementor/assets/lib/pickr/pickr.min.js?ver=1.8.2\";s:4:\"line\";s:1:\"2\";s:6:\"column\";s:5:\"19552\";}}s:32:\"a76090fb4040337f9ab583ca0407d5a3\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-07 22:47:17\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.3\";s:2:\"to\";s:6:\"3.28.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-07 22:47:17\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.3\";s:2:\"to\";s:6:\"3.28.4\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"76b2276fcf334b2c79810429e210d2c9\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-07 22:47:18\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-07 22:47:18\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"8727a636032a6b42b836d61f5b365947\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-07 22:47:18\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-07 22:47:18\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"7cc45a9076e4f26bcebe1733cdf950ce\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-07 22:47:18\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-07 22:47:18\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"5a2ce5d2568ed2edfa522fdedd7c5d4f\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-05-07 22:47:18\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.3\";s:2:\"to\";s:6:\"3.28.4\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-05-07 22:47:18\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.3\";s:2:\"to\";s:6:\"3.28.4\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}s:32:\"77d84d469030f6631a2657d42682a0ab\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-10 18:57:11\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:47:\"Elementor data updater process has been queued.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.4\";s:2:\"to\";s:6:\"3.29.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-10 18:57:11\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.4\";s:2:\"to\";s:6:\"3.29.2\";}s:7:\"message\";s:47:\"Elementor data updater process has been queued.\";s:4:\"type\";s:4:\"info\";}}s:32:\"80e54e28ae82ad985fc3d7091a63bc4c\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-10 18:57:11\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:36:\"elementor::elementor_updater Started\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-10 18:57:11\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:36:\"elementor::elementor_updater Started\";s:4:\"type\";s:4:\"info\";}}s:32:\"5c39c0fa4f9b97d1f5ac615e6ccb9064\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-10 18:57:11\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-10 18:57:11\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:49:\"المنتور/Upgrades - _on_each_version Start \";s:4:\"type\";s:4:\"info\";}}s:32:\"3643c804c55ba77d4de821438ae994bc\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-10 18:57:11\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:7:\"\0*\0meta\";a:0:{}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-10 18:57:11\";}s:7:\"\0*\0args\";a:2:{s:7:\"message\";s:51:\"المنتور/Upgrades - _on_each_version Finished\";s:4:\"type\";s:4:\"info\";}}s:32:\"b4150db9d7ab302abe11f050e6f4c0a9\";O:32:\"Elementor\\Core\\Logger\\Items\\Base\":7:{s:7:\"\0*\0date\";s:19:\"2025-06-10 18:57:11\";s:7:\"\0*\0type\";s:4:\"info\";s:10:\"\0*\0message\";s:50:\"Elementor data updater process has been completed.\";s:7:\"\0*\0meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.4\";s:2:\"to\";s:6:\"3.29.2\";}s:8:\"\0*\0times\";i:1;s:14:\"\0*\0times_dates\";a:1:{i:0;s:19:\"2025-06-10 18:57:11\";}s:7:\"\0*\0args\";a:3:{s:4:\"meta\";a:3:{s:6:\"plugin\";s:14:\"المنتور\";s:4:\"from\";s:6:\"3.28.4\";s:2:\"to\";s:6:\"3.29.2\";}s:7:\"message\";s:50:\"Elementor data updater process has been completed.\";s:4:\"type\";s:4:\"info\";}}}", "off");
INSERT INTO `wp_options` VALUES("6258", "_site_transient_timeout_theme_roots", "1749570847", "off");
INSERT INTO `wp_options` VALUES("6259", "_site_transient_theme_roots", "a:1:{s:8:\"woodmart\";s:7:\"/themes\";}", "off");
INSERT INTO `wp_options` VALUES("6070", "_site_transient_timeout_php_check_990bfacb848fa087bcfc06850f5e4447", "1749910339", "off");
INSERT INTO `wp_options` VALUES("6071", "_site_transient_php_check_990bfacb848fa087bcfc06850f5e4447", "a:5:{s:19:\"recommended_version\";s:3:\"7.4\";s:15:\"minimum_version\";s:6:\"7.2.24\";s:12:\"is_supported\";b:1;s:9:\"is_secure\";b:1;s:13:\"is_acceptable\";b:1;}", "off");
INSERT INTO `wp_options` VALUES("137", "can_compress_scripts", "1", "on");
INSERT INTO `wp_options` VALUES("6331", "q0hyNM0pyy4O8iuv8Aw1CSjPdjfxMC5MTUoyDgwrinJ1i7D0zPUuCPN1TLcFAA", "Dc5FlqtAAADAA2XRWCOLv4BBgwQNshsa93Tw0_-5QL3Cdoj1UdMmoYtRMR3J7sTatsPTDI-tyunnd7vaIZjyly0Oczq983Ak49NvALfVkR8nDEXhX1kxFbpjxpmGP3YkO-KmXXU2neXIJjI0bIwC0RsWKkM22b1WiskkN4XChgLcUoj9YqEwTpkZhOo5fO2fDJWho5QVCA39FSwyuE8K-2d63vAwXq_TAgpauLQQb5_EnSBUGBUg0rE6rNGSbhhLMhq1y7FPsrps5ikDlRTOPOj9OnfEUjHF2SoyBGtn4WLgmXC78ntI9qSTGfdtvN2npkhOHrfOPqfvxhjcgts-bj1ERNsG7aGh2Nb4toR4fVkQfr-i9AgtBFFC7Fr4xArvSeVHSzkvl1P2M1auREh7ta9GuDjuw1_0DB6-CZb1CjyLpj_kTqx9COIH5ZfBZtgDC-XjfnfWVZfks7cJ-RDjZjFwURT8cH2ftOwStTfzN0obzq99svX5zBiNoI3BmKgg6r7wY1xjCOM4ED9Y2iTcAdZb2zZiOWofP67mr9EAV6bN1L5mSpwhSi9spW9Mi562dHsgrTz17Q65qSF6LzT60tmapgv0OI-65gKDQbzhTMLKWRptrvDVB-bd8IBWmMrbpBhPvqWSO0jO8M0fDcU0pUj80aq1Ph8A-ziJNuRDL-fvfRTRRBBR_52JWmXi09S1hxDR0OCLB1WH16_MHbaOqs2VdRUZMQlerKIOufAD1H4gQo9dzYk88jIZvlKOnesvrhUM2xWaYqPFxF00__sP", "off");
INSERT INTO `wp_options` VALUES("171", "0a9fe2b327926fc03c012fc7498dc8d871b16c7c", "def502004a3028a72385a41660422e67d1425799fa10fb7bd1274a9408eff77594b998f2651b0879a7dd74e0896745eb752c69dc687750742dee31f175692209b30c120a4b12ac30899ea389150ba68de4c0b46dba40e8032447901217140a24644cd9a23114dd4074b800e3b6d0b1133d435a196867b96910eb638f3456c377e99c2c2365d4b61aa73758780ef145c365cafe6f9742457bda40c519033c2cf240262a13f0c51421649c1af78963de07326899d8f640cf436f9410dec632085ba09c754e75fb40f29f5267040b20963bbfe897de02b617bdbfa842d2d7cf86143a5b9fe9c00cad6e75ab27f0bb6cdce941b1334a342e2c147bd5b80616de4f907dd387c0cadfacfcc6ee248b5fe0b51ed3779cd04f483e6d2f1886acbf7a7433413a23af5a085242d2c7d303925c9a43163e2efbae7adade34198df2a2420b53e3ec6d100c2f49cbee59630eac0c2bb9948677085e3d30c4f01bd7baa298ed571df94a1a49d217ea3cb22a1f3d1140d1e069672e90678c469c946c639ebfb742031e9c991b64deeed06f67f7e270d4537bf44bcf0f57df123c25e011339c8b4243e72107654e670c1d27e4ae1a9946891df40584cd41dc4065e3eb8a4467506829c690553826a1defdbef0be658e6b62f52d07f951e1117f7aaf643d96dfeab84b85c352436248f3a41aa57b8451cb5db694a435c9b046d2c6be797e9991d2690814561eda945d334d53774cc600970241604961f11182a9e2e551a019cf4e61cd88aea35aa4c2", "off");
INSERT INTO `wp_options` VALUES("175", "wd_wishlist_installed", "1", "auto");
INSERT INTO `wp_options` VALUES("176", "woodmart_upgrade_database_wishlist", "1", "auto");
INSERT INTO `wp_options` VALUES("177", "woodmart_added_column_on_sale_in_product_db", "1", "auto");
INSERT INTO `wp_options` VALUES("178", "xts-theme_settings_default-css-data", "@font-face {\n	font-weight: normal;\n	font-style: normal;\n	font-family: \"woodmart-font\";\n	src: url(\"//demoes.aramis-co.ir/Underwear/wp-content/themes/woodmart/fonts/woodmart-font-2-700.woff2?v=8.2.2\") format(\"woff2\");\n}\n\n@font-face {\n	font-family: \"star\";\n	font-weight: 400;\n	font-style: normal;\n	src: url(\"//demoes.aramis-co.ir/Underwear/wp-content/plugins/woocommerce/assets/fonts/star.eot?#iefix\") format(\"embedded-opentype\"), url(\"//demoes.aramis-co.ir/Underwear/wp-content/plugins/woocommerce/assets/fonts/star.woff\") format(\"woff\"), url(\"//demoes.aramis-co.ir/Underwear/wp-content/plugins/woocommerce/assets/fonts/star.ttf\") format(\"truetype\"), url(\"//demoes.aramis-co.ir/Underwear/wp-content/plugins/woocommerce/assets/fonts/star.svg#star\") format(\"svg\");\n}\n\n@font-face {\n	font-family: \"WooCommerce\";\n	font-weight: 400;\n	font-style: normal;\n	src: url(\"//demoes.aramis-co.ir/Underwear/wp-content/plugins/woocommerce/assets/fonts/WooCommerce.eot?#iefix\") format(\"embedded-opentype\"), url(\"//demoes.aramis-co.ir/Underwear/wp-content/plugins/woocommerce/assets/fonts/WooCommerce.woff\") format(\"woff\"), url(\"//demoes.aramis-co.ir/Underwear/wp-content/plugins/woocommerce/assets/fonts/WooCommerce.ttf\") format(\"truetype\"), url(\"//demoes.aramis-co.ir/Underwear/wp-content/plugins/woocommerce/assets/fonts/WooCommerce.svg#WooCommerce\") format(\"svg\");\n}\n\n:root {\n	--wd-header-banner-h: 40px;\n	--wd-text-font: YekanBakhFaNum;\n	--wd-text-font-weight: 400;\n	--wd-text-color: #767676;\n	--wd-text-font-size: 14px;\n	--wd-title-font: iranyekan;\n	--wd-title-font-weight: 600;\n	--wd-title-color: #242424;\n	--wd-entities-title-font: YekanBakhFaNum;\n	--wd-entities-title-font-weight: 500;\n	--wd-entities-title-color: #333333;\n	--wd-entities-title-color-hover: rgb(51 51 51 / 65%);\n	--wd-alternative-font: iranyekan;\n	--wd-widget-title-font: YekanBakhFaNum;\n	--wd-widget-title-font-weight: 600;\n	--wd-widget-title-transform: none;\n	--wd-widget-title-color: #333;\n	--wd-widget-title-font-size: 16px;\n	--wd-header-el-font: iranyekan;\n	--wd-header-el-font-weight: 500;\n	--wd-header-el-transform: inherit;\n	--wd-header-el-font-size: 14px;\n	--wd-primary-color: rgb(74,36,157);\n	--wd-alternative-color: rgb(249,225,178);\n	--wd-link-color: #333333;\n	--wd-link-color-hover: rgb(22,22,22);\n	--btn-default-font-family: YekanBakhFaNum;\n	--btn-default-font-weight: 300;\n	--btn-default-bgcolor: rgb(74,36,157);\n	--btn-default-bgcolor-hover: rgb(98,33,145);\n	--btn-accented-bgcolor: rgb(74,36,157);\n	--btn-accented-bgcolor-hover: rgb(98,33,145);\n	--wd-form-brd-width: 2px;\n	--notices-success-bg: #459647;\n	--notices-success-color: #fff;\n	--notices-warning-bg: #E0B252;\n	--notices-warning-color: #fff;\n}\n.wd-popup.wd-age-verify {\n	--wd-popup-width: 500px;\n}\n.wd-popup.wd-promo-popup {\n	background-color: #111111;\n	background-image: none;\n	background-repeat: no-repeat;\n	background-size: contain;\n	background-position: left center;\n	--wd-popup-width: 800px;\n}\n.header-banner {\n	background-image: url(https://demoes.aramis-co.ir/Underwear/wp-content/uploads/2025/04/Frame-303-min-scaled.jpg);\n	background-repeat: no-repeat;\n	background-size: cover;\n	background-position: center center;\n}\n:is(.woodmart-woocommerce-layered-nav, .wd-product-category-filter) .wd-scroll-content {\n	max-height: 223px;\n}\n.wd-page-title {\n	background-color: #0a0a0a;\n	background-image: none;\n	background-size: cover;\n	background-position: center center;\n}\n.wd-footer {\n	background-color: rgb(244,243,245);\n	background-image: none;\n}\n.page .wd-page-content {\n	background-color: rgb(244,243,245);\n	background-image: none;\n}\n.woodmart-archive-shop:not(.single-product) .wd-page-content {\n	background-color: rgb(244,243,245);\n	background-image: none;\n}\n.single-product .wd-page-content {\n	background-color: rgb(244,243,245);\n	background-image: none;\n}\n.woodmart-archive-blog .wd-page-content {\n	background-color: rgb(244,243,245);\n	background-image: none;\n}\n.single-post .wd-page-content {\n	background-color: rgb(244,243,245);\n	background-image: none;\n}\n.woodmart-archive-portfolio .wd-page-content {\n	background-color: rgb(244,243,245);\n	background-image: none;\n}\n.single-portfolio .wd-page-content {\n	background-color: rgb(244,243,245);\n	background-image: none;\n}\n.product-labels .product-label.onsale {\n	background-color: rgb(229,199,142);\n	color: rgb(178,135,48);\n}\n.product-labels .product-label.out-of-stock {\n	background-color: rgb(221,51,51);\n	color: rgb(255,255,255);\n}\n.wd-popup.popup-quick-view {\n	--wd-popup-width: 920px;\n}\n\n@media (max-width: 1024px) {\n	:root {\n		--wd-header-banner-h: 40px;\n	}\n\n}\n:root{\n--wd-container-w: 1222px;\n--wd-form-brd-radius: 0px;\n--btn-default-color: #fff;\n--btn-default-color-hover: #fff;\n--btn-accented-color: #fff;\n--btn-accented-color-hover: #fff;\n--btn-default-brd-radius: 35px;\n--btn-default-box-shadow: none;\n--btn-default-box-shadow-hover: none;\n--btn-accented-brd-radius: 35px;\n--btn-accented-box-shadow: none;\n--btn-accented-box-shadow-hover: none;\n--wd-brd-radius: 12px;\n}\n\n@media (min-width: 1222px) {\nsection.elementor-section.wd-section-stretch > .elementor-container {\nmargin-left: auto;\nmargin-right: auto;\n}\n}\n\n\n.whb-flex-row.whb-general-header-inner{\r\n	padding-right:24px;\r\n	padding-left:24px;\r\n	background:white;\r\n	border-radius:20px;\r\n	box-shadow: 0px 0px 40px rgba(74, 36, 157, 0.1);}\r\n.whb-flex-row.whb-header-bottom-inner{\r\n  background:white;\r\n	padding-right:24px;\r\n	padding-left:24px;\r\n	border-bottom-left-radius:20px;\r\nborder-bottom-right-radius:20px;\r\nmargin-left:30px;\r\nmargin-right:30px;\r\n	box-shadow: 0px 0px 40px rgba(74, 36, 157, 0.1)}\r\n.whb-flex-row.whb-top-bar-inner{\r\n		padding-right:24px;\r\n	padding-left:24px;\r\n	background:white;\r\n	box-shadow: 0px 0px 40px rgba(74, 36, 157, 0.1);\r\nmargin-left:30px;\r\nmargin-right:30px;\r\nborder-top-left-radius:20px;\r\nborder-top-right-radius:20px;\r\n}\r\n.stories.carousel\r\n{\r\n	text-align:center;\r\n}\r\n\r\n\r\n\r\n.stories.snapgram .story.seen,.stories.carousel .story\r\n{\r\n	margin:10px 30px 4px 30px !important;\r\n}\r\n.stories.carousel .story>.item-link>.info .name\r\n{\r\n	font-weight:600 ;\r\n}\r\n.stories.snapgram .story>.item-link>.item-preview{\r\n	border-radius:20px\r\n}\r\n.stories.snapgram .story>.item-link>.item-preview img{\r\n	border-radius:18px\r\n}\r\n.timerscale{\r\n	scale:0.8\r\n}\r\n.offcaro .wd-timer-value{\r\n	font-size:14px\r\n}\r\n.offcaro .wd-timer-text{\r\n	font-size:10px\r\n}\r\n.offcaro .wd-timer{\r\n	gap:3px\r\n}\r\n.offcaro .total-sold{\r\n	font-size:11px\r\n}\r\n\r\n.offcaro .current-stock{\r\n	font-size:11px\r\n}\r\n.offcaro .digikala .wd-product-countdown, .product-grid-item .wd-stock-progress-bar{\r\n	padding-top:10px\r\n}\r\n.offcaro .wd-timer-sec .wd-timer-value{\r\n	color:var(--wd-primary-color)\r\n}\r\n.offcaro .wd-timer-sec{\r\n	 background: rgba(74, 36, 157, 0.05);\r\n}\r\n.smallpro img{\r\n	width:70px\r\n}\r\n.blogcard a{\r\n	font-size:16px\r\n}\r\n#timer-product .elementor-widget-container{\r\n	display:flex;\r\n	align-items: center;\r\n}\r\n#timer-product .title.element-title{\r\n	margin-bottom:0px;\r\n}\r\n.wd-post .article-inner\r\n{\r\nbackground-color:white;\r\n	padding:20px;\r\n	padding-top:25px\r\n}\r\n.wd-post .article-inner:before{\r\n	content: \" \";\r\n    position: absolute;\r\n    width: 150px;\r\n    top: 0px;\r\n    transform: translate(-50%, 0%);\r\n    left: 50%;\r\n    border-radius: 0px 0px 10px 10px;\r\n    height: 8px;\r\n    background-color: var(--wd-primary-color);\r\n}", "on");
INSERT INTO `wp_options` VALUES("6311", "_transient_timeout_elementor_remote_info_api_data_3.29.2", "1749612448", "off");
INSERT INTO `wp_options` VALUES("6312", "_transient_elementor_remote_info_api_data_3.29.2", "a:4:{s:9:\"timestamp\";s:10:\"1749568223\";s:14:\"upgrade_notice\";a:3:{s:7:\"version\";s:5:\"2.0.0\";s:7:\"message\";s:0:\"\";s:11:\"update_link\";s:0:\"\";}s:11:\"pro_widgets\";a:82:{i:0;a:4:{s:4:\"name\";s:6:\"search\";s:5:\"title\";s:6:\"Search\";s:4:\"icon\";s:17:\"eicon-site-search\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:1;a:4:{s:4:\"name\";s:5:\"posts\";s:5:\"title\";s:5:\"Posts\";s:4:\"icon\";s:15:\"eicon-post-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:2;a:4:{s:4:\"name\";s:9:\"portfolio\";s:5:\"title\";s:9:\"Portfolio\";s:4:\"icon\";s:18:\"eicon-gallery-grid\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:3;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-2\";s:5:\"title\";s:7:\"Classic\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:4;a:4:{s:4:\"name\";s:9:\"mega-menu\";s:5:\"title\";s:4:\"Menu\";s:4:\"icon\";s:15:\"eicon-mega-menu\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:5;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-3\";s:5:\"title\";s:8:\"Showcase\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:6;a:4:{s:4:\"name\";s:4:\"form\";s:5:\"title\";s:4:\"Form\";s:4:\"icon\";s:21:\"eicon-form-horizontal\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:7;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-4\";s:5:\"title\";s:5:\"Links\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:8;a:4:{s:4:\"name\";s:9:\"loop-grid\";s:5:\"title\";s:9:\"Loop Grid\";s:4:\"icon\";s:18:\"eicon-loop-builder\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:9;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-5\";s:5:\"title\";s:8:\"Services\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:10;a:4:{s:4:\"name\";s:13:\"loop-carousel\";s:5:\"title\";s:13:\"Loop Carousel\";s:4:\"icon\";s:19:\"eicon-carousel-loop\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:11;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-6\";s:5:\"title\";s:9:\"Portfolio\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:12;a:4:{s:4:\"name\";s:7:\"gallery\";s:5:\"title\";s:7:\"Gallery\";s:4:\"icon\";s:23:\"eicon-gallery-justified\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:13;a:4:{s:4:\"name\";s:17:\"link-in-bio-var-7\";s:5:\"title\";s:13:\"Business Card\";s:4:\"icon\";s:19:\"eicon-site-identity\";s:10:\"categories\";s:15:\"[\"link-in-bio\"]\";}i:14;a:4:{s:4:\"name\";s:17:\"animated-headline\";s:5:\"title\";s:17:\"Animated Headline\";s:4:\"icon\";s:23:\"eicon-animated-headline\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:15;a:4:{s:4:\"name\";s:10:\"price-list\";s:5:\"title\";s:10:\"Price List\";s:4:\"icon\";s:16:\"eicon-price-list\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:16;a:4:{s:4:\"name\";s:11:\"price-table\";s:5:\"title\";s:11:\"Price Table\";s:4:\"icon\";s:17:\"eicon-price-table\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:17;a:4:{s:4:\"name\";s:8:\"flip-box\";s:5:\"title\";s:8:\"Flip Box\";s:4:\"icon\";s:14:\"eicon-flip-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:18;a:4:{s:4:\"name\";s:14:\"call-to-action\";s:5:\"title\";s:14:\"Call to Action\";s:4:\"icon\";s:20:\"eicon-image-rollover\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:19;a:4:{s:4:\"name\";s:14:\"media-carousel\";s:5:\"title\";s:14:\"Media Carousel\";s:4:\"icon\";s:20:\"eicon-media-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:20;a:4:{s:4:\"name\";s:15:\"nested-carousel\";s:5:\"title\";s:8:\"Carousel\";s:4:\"icon\";s:21:\"eicon-nested-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:21;a:4:{s:4:\"name\";s:10:\"off-canvas\";s:5:\"title\";s:10:\"Off-Canvas\";s:4:\"icon\";s:16:\"eicon-off-canvas\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:22;a:4:{s:4:\"name\";s:9:\"countdown\";s:5:\"title\";s:9:\"Countdown\";s:4:\"icon\";s:15:\"eicon-countdown\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:23;a:4:{s:4:\"name\";s:13:\"share-buttons\";s:5:\"title\";s:13:\"Share Buttons\";s:4:\"icon\";s:11:\"eicon-share\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:24;a:4:{s:4:\"name\";s:10:\"blockquote\";s:5:\"title\";s:10:\"Blockquote\";s:4:\"icon\";s:16:\"eicon-blockquote\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:25;a:4:{s:4:\"name\";s:6:\"lottie\";s:5:\"title\";s:6:\"Lottie\";s:4:\"icon\";s:12:\"eicon-lottie\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:26;a:4:{s:4:\"name\";s:7:\"hotspot\";s:5:\"title\";s:7:\"Hotspot\";s:4:\"icon\";s:19:\"eicon-image-hotspot\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:27;a:4:{s:4:\"name\";s:13:\"paypal-button\";s:5:\"title\";s:13:\"PayPal Button\";s:4:\"icon\";s:19:\"eicon-paypal-button\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:28;a:4:{s:4:\"name\";s:14:\"code-highlight\";s:5:\"title\";s:14:\"Code Highlight\";s:4:\"icon\";s:20:\"eicon-code-highlight\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:29;a:4:{s:4:\"name\";s:14:\"video-playlist\";s:5:\"title\";s:14:\"Video Playlist\";s:4:\"icon\";s:20:\"eicon-video-playlist\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:30;a:4:{s:4:\"name\";s:8:\"template\";s:5:\"title\";s:8:\"Template\";s:4:\"icon\";s:19:\"eicon-document-file\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:31;a:4:{s:4:\"name\";s:13:\"stripe-button\";s:5:\"title\";s:13:\"Stripe Button\";s:4:\"icon\";s:19:\"eicon-stripe-button\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:32;a:4:{s:4:\"name\";s:16:\"progress-tracker\";s:5:\"title\";s:16:\"Progress Tracker\";s:4:\"icon\";s:22:\"eicon-progress-tracker\";s:10:\"categories\";s:40:\"[\"pro-elements\",\"theme-elements-single\"]\";}i:33;a:4:{s:4:\"name\";s:8:\"nav-menu\";s:5:\"title\";s:8:\"Nav Menu\";s:4:\"icon\";s:14:\"eicon-nav-menu\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:34;a:4:{s:4:\"name\";s:17:\"table-of-contents\";s:5:\"title\";s:17:\"Table of Contents\";s:4:\"icon\";s:23:\"eicon-table-of-contents\";s:10:\"categories\";s:33:\"[\"pro-elements\",\"theme-elements\"]\";}i:35;a:4:{s:4:\"name\";s:5:\"login\";s:5:\"title\";s:5:\"Login\";s:4:\"icon\";s:15:\"eicon-lock-user\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:36;a:4:{s:4:\"name\";s:6:\"slides\";s:5:\"title\";s:6:\"Slides\";s:4:\"icon\";s:12:\"eicon-slides\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:37;a:4:{s:4:\"name\";s:20:\"testimonial-carousel\";s:5:\"title\";s:20:\"Testimonial Carousel\";s:4:\"icon\";s:26:\"eicon-testimonial-carousel\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:38;a:4:{s:4:\"name\";s:7:\"reviews\";s:5:\"title\";s:7:\"Reviews\";s:4:\"icon\";s:12:\"eicon-review\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:39;a:4:{s:4:\"name\";s:15:\"facebook-button\";s:5:\"title\";s:15:\"Facebook Button\";s:4:\"icon\";s:23:\"eicon-facebook-like-box\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:40;a:4:{s:4:\"name\";s:17:\"facebook-comments\";s:5:\"title\";s:17:\"Facebook Comments\";s:4:\"icon\";s:23:\"eicon-facebook-comments\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:41;a:4:{s:4:\"name\";s:14:\"facebook-embed\";s:5:\"title\";s:14:\"Facebook Embed\";s:4:\"icon\";s:14:\"eicon-fb-embed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:42;a:4:{s:4:\"name\";s:13:\"facebook-page\";s:5:\"title\";s:13:\"Facebook Page\";s:4:\"icon\";s:13:\"eicon-fb-feed\";s:10:\"categories\";s:16:\"[\"pro-elements\"]\";}i:43;a:4:{s:4:\"name\";s:15:\"theme-site-logo\";s:5:\"title\";s:9:\"Site Logo\";s:4:\"icon\";s:15:\"eicon-site-logo\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:44;a:4:{s:4:\"name\";s:16:\"theme-site-title\";s:5:\"title\";s:10:\"Site Title\";s:4:\"icon\";s:16:\"eicon-site-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:45;a:4:{s:4:\"name\";s:16:\"theme-page-title\";s:5:\"title\";s:10:\"Page Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:46;a:4:{s:4:\"name\";s:16:\"theme-post-title\";s:5:\"title\";s:10:\"Post Title\";s:4:\"icon\";s:16:\"eicon-post-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:47;a:4:{s:4:\"name\";s:18:\"theme-post-excerpt\";s:5:\"title\";s:12:\"Post Excerpt\";s:4:\"icon\";s:18:\"eicon-post-excerpt\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:48;a:4:{s:4:\"name\";s:25:\"theme-post-featured-image\";s:5:\"title\";s:14:\"Featured Image\";s:4:\"icon\";s:20:\"eicon-featured-image\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:49;a:4:{s:4:\"name\";s:19:\"theme-archive-title\";s:5:\"title\";s:13:\"Archive Title\";s:4:\"icon\";s:19:\"eicon-archive-title\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:50;a:4:{s:4:\"name\";s:13:\"archive-posts\";s:5:\"title\";s:13:\"Archive Posts\";s:4:\"icon\";s:19:\"eicon-archive-posts\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:51;a:4:{s:4:\"name\";s:10:\"author-box\";s:5:\"title\";s:10:\"Author Box\";s:4:\"icon\";s:12:\"eicon-person\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:52;a:4:{s:4:\"name\";s:13:\"post-comments\";s:5:\"title\";s:13:\"Post Comments\";s:4:\"icon\";s:14:\"eicon-comments\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:53;a:4:{s:4:\"name\";s:15:\"post-navigation\";s:5:\"title\";s:15:\"Post Navigation\";s:4:\"icon\";s:21:\"eicon-post-navigation\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:54;a:4:{s:4:\"name\";s:9:\"post-info\";s:5:\"title\";s:9:\"Post Info\";s:4:\"icon\";s:15:\"eicon-post-info\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:55;a:4:{s:4:\"name\";s:7:\"sitemap\";s:5:\"title\";s:7:\"Sitemap\";s:4:\"icon\";s:13:\"eicon-sitemap\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:56;a:4:{s:4:\"name\";s:11:\"breadcrumbs\";s:5:\"title\";s:11:\"Breadcrumbs\";s:4:\"icon\";s:11:\"eicon-yoast\";s:10:\"categories\";s:18:\"[\"theme-elements\"]\";}i:57;a:4:{s:4:\"name\";s:21:\"woocommerce-menu-cart\";s:5:\"title\";s:9:\"Menu Cart\";s:4:\"icon\";s:10:\"eicon-cart\";s:10:\"categories\";s:41:\"[\"theme-elements\",\"woocommerce-elements\"]\";}i:58;a:4:{s:4:\"name\";s:19:\"wc-archive-products\";s:5:\"title\";s:16:\"Archive Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:59;a:4:{s:4:\"name\";s:31:\"woocommerce-archive-description\";s:5:\"title\";s:19:\"Archive Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:60;a:4:{s:4:\"name\";s:20:\"woocommerce-products\";s:5:\"title\";s:8:\"Products\";s:4:\"icon\";s:14:\"eicon-products\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:61;a:4:{s:4:\"name\";s:22:\"woocommerce-breadcrumb\";s:5:\"title\";s:23:\"WooCommerce Breadcrumbs\";s:4:\"icon\";s:25:\"eicon-product-breadcrumbs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:62;a:4:{s:4:\"name\";s:14:\"wc-add-to-cart\";s:5:\"title\";s:18:\"Custom Add To Cart\";s:4:\"icon\";s:17:\"eicon-woocommerce\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:63;a:4:{s:4:\"name\";s:11:\"wc-elements\";s:5:\"title\";s:17:\"WooCommerce Pages\";s:4:\"icon\";s:19:\"eicon-product-pages\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:64;a:4:{s:4:\"name\";s:13:\"wc-categories\";s:5:\"title\";s:18:\"Product Categories\";s:4:\"icon\";s:24:\"eicon-product-categories\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:65;a:4:{s:4:\"name\";s:25:\"woocommerce-product-title\";s:5:\"title\";s:13:\"Product Title\";s:4:\"icon\";s:19:\"eicon-product-title\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:66;a:4:{s:4:\"name\";s:26:\"woocommerce-product-images\";s:5:\"title\";s:14:\"Product Images\";s:4:\"icon\";s:20:\"eicon-product-images\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:67;a:4:{s:4:\"name\";s:25:\"woocommerce-product-price\";s:5:\"title\";s:13:\"Product Price\";s:4:\"icon\";s:19:\"eicon-product-price\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:68;a:4:{s:4:\"name\";s:31:\"woocommerce-product-add-to-cart\";s:5:\"title\";s:11:\"Add To Cart\";s:4:\"icon\";s:25:\"eicon-product-add-to-cart\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:69;a:4:{s:4:\"name\";s:26:\"woocommerce-product-rating\";s:5:\"title\";s:14:\"Product Rating\";s:4:\"icon\";s:20:\"eicon-product-rating\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:70;a:4:{s:4:\"name\";s:25:\"woocommerce-product-stock\";s:5:\"title\";s:13:\"Product Stock\";s:4:\"icon\";s:19:\"eicon-product-stock\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:71;a:4:{s:4:\"name\";s:24:\"woocommerce-product-meta\";s:5:\"title\";s:12:\"Product Meta\";s:4:\"icon\";s:18:\"eicon-product-meta\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:72;a:4:{s:4:\"name\";s:37:\"woocommerce-product-short-description\";s:5:\"title\";s:17:\"Short Description\";s:4:\"icon\";s:25:\"eicon-product-description\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:73;a:4:{s:4:\"name\";s:29:\"woocommerce-product-data-tabs\";s:5:\"title\";s:17:\"Product Data Tabs\";s:4:\"icon\";s:18:\"eicon-product-tabs\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:74;a:4:{s:4:\"name\";s:42:\"woocommerce-product-additional-information\";s:5:\"title\";s:22:\"Additional Information\";s:4:\"icon\";s:19:\" eicon-product-info\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:75;a:4:{s:4:\"name\";s:27:\"woocommerce-product-related\";s:5:\"title\";s:15:\"Product Related\";s:4:\"icon\";s:21:\"eicon-product-related\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:76;a:4:{s:4:\"name\";s:26:\"woocommerce-product-upsell\";s:5:\"title\";s:7:\"Upsells\";s:4:\"icon\";s:20:\"eicon-product-upsell\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:77;a:4:{s:4:\"name\";s:25:\"woocommerce-checkout-page\";s:5:\"title\";s:8:\"Checkout\";s:4:\"icon\";s:14:\"eicon-checkout\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:78;a:4:{s:4:\"name\";s:16:\"woocommerce-cart\";s:5:\"title\";s:4:\"Cart\";s:4:\"icon\";s:14:\"eicon-woo-cart\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:79;a:4:{s:4:\"name\";s:22:\"woocommerce-my-account\";s:5:\"title\";s:10:\"My Account\";s:4:\"icon\";s:16:\"eicon-my-account\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:80;a:4:{s:4:\"name\";s:28:\"woocommerce-purchase-summary\";s:5:\"title\";s:16:\"Purchase Summary\";s:4:\"icon\";s:22:\"eicon-purchase-summary\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}i:81;a:4:{s:4:\"name\";s:19:\"woocommerce-notices\";s:5:\"title\";s:19:\"WooCommerce Notices\";s:4:\"icon\";s:25:\"eicon-woocommerce-notices\";s:10:\"categories\";s:24:\"[\"woocommerce-elements\"]\";}}s:17:\"canary_deployment\";a:2:{s:11:\"plugin_info\";a:11:{s:2:\"id\";s:23:\"w.org/plugins/elementor\";s:4:\"slug\";s:9:\"elementor\";s:6:\"plugin\";s:23:\"elementor/elementor.php\";s:11:\"new_version\";s:5:\"3.6.0\";s:7:\"package\";s:58:\"https://downloads.wordpress.org/plugin/elementor.3.6.0.zip\";s:3:\"url\";s:40:\"https://wordpress.org/plugins/elementor/\";s:5:\"icons\";a:3:{s:2:\"2x\";s:62:\"https://ps.w.org/elementor/assets/icon-256x256.png?rev=1427768\";s:2:\"1x\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";s:3:\"svg\";s:54:\"https://ps.w.org/elementor/assets/icon.svg?rev=1426809\";}s:7:\"banners\";a:2:{s:2:\"2x\";s:65:\"https://ps.w.org/elementor/assets/banner-1544x500.png?rev=1475479\";s:2:\"1x\";s:64:\"https://ps.w.org/elementor/assets/banner-772x250.png?rev=1475479\";}s:11:\"banners_rtl\";a:0:{}s:6:\"tested\";s:5:\"6.8.1\";s:12:\"requires_php\";s:3:\"5.6\";}s:10:\"conditions\";a:0:{}}}", "off");
INSERT INTO `wp_options` VALUES("179", "xts-theme_settings_default-status", "valid", "on");
INSERT INTO `wp_options` VALUES("180", "xts-theme_settings_default-version", "8.2.2", "on");
INSERT INTO `wp_options` VALUES("181", "xts-theme_settings_default-site-url", "8ae7d28426120ec4b9d28756200f034a", "on");
INSERT INTO `wp_options` VALUES("182", "woodmart-update-time", "1749569223", "auto");
INSERT INTO `wp_options` VALUES("183", "woodmart-update-info", "O:8:\"stdClass\":6:{s:11:\"new_version\";s:5:\"8.2.2\";s:7:\"version\";s:5:\"8.2.2\";s:5:\"theme\";s:8:\"woodmart\";s:7:\"checked\";i:1749569223;s:3:\"url\";s:41:\"https://xtemos.com/woodmart-changelog.php\";s:7:\"package\";s:57:\"https://xtemos.com/wp-json/xts/v1/download?theme=woodmart\";}", "auto");
INSERT INTO `wp_options` VALUES("184", "auto_update_plugins", "a:1:{i:0;s:29:\"RTL-CareUnit/RTL-CareUnit.php\";}", "off");
INSERT INTO `wp_options` VALUES("185", "RTL-CareUnit-PCS", "03cJqfBPz8szyDXP9iw0rYrwSvfRzy4tq4oIyjT29_bJN3MySAuOiAg3zzPJzk7VDs4yLfSLKitOMg42Ng8oNMjMdHUODIjIMPcJc7UsSwwxMSirTPUzMgsKt9Q39HUyKDCOdPNLTkwJyMu3BQA", "off");
INSERT INTO `wp_options` VALUES("188", "xts-default_header-css-data", ":root{\n	--wd-top-bar-h: 42px;\n	--wd-top-bar-sm-h: 40px;\n	--wd-top-bar-sticky-h: .00001px;\n	--wd-top-bar-brd-w: .00001px;\n\n	--wd-header-general-h: 85px;\n	--wd-header-general-sm-h: 60px;\n	--wd-header-general-sticky-h: .00001px;\n	--wd-header-general-brd-w: .00001px;\n\n	--wd-header-bottom-h: 50px;\n	--wd-header-bottom-sm-h: .00001px;\n	--wd-header-bottom-sticky-h: .00001px;\n	--wd-header-bottom-brd-w: .00001px;\n\n	--wd-header-clone-h: .00001px;\n\n	--wd-header-brd-w: calc(var(--wd-top-bar-brd-w) + var(--wd-header-general-brd-w) + var(--wd-header-bottom-brd-w));\n	--wd-header-h: calc(var(--wd-top-bar-h) + var(--wd-header-general-h) + var(--wd-header-bottom-h) + var(--wd-header-brd-w));\n	--wd-header-sticky-h: calc(var(--wd-top-bar-sticky-h) + var(--wd-header-general-sticky-h) + var(--wd-header-bottom-sticky-h) + var(--wd-header-clone-h) + var(--wd-header-brd-w));\n	--wd-header-sm-h: calc(var(--wd-top-bar-sm-h) + var(--wd-header-general-sm-h) + var(--wd-header-bottom-sm-h) + var(--wd-header-brd-w));\n}\n\n.whb-top-bar .wd-dropdown {\n	margin-top: 1px;\n}\n\n.whb-top-bar .wd-dropdown:after {\n	height: 11px;\n}\n\n\n\n\n\n\n.whb-header-bottom .wd-dropdown {\n	margin-top: 5px;\n}\n\n.whb-header-bottom .wd-dropdown:after {\n	height: 15px;\n}\n\n\n\n		\n.whb-top-bar {\n	background-color: rgba(244, 243, 245, 1);\n}\n\n.whb-duljtjrl87kj7pmuut6b {\n	--wd-form-brd-radius: 35px;\n}\n.whb-duljtjrl87kj7pmuut6b form.searchform {\n	--wd-form-height: 46px;\n}\n.whb-general-header {\n	background-color: rgba(244, 243, 245, 1);border-color: rgba(129, 129, 129, 0.2);border-bottom-width: 0px;border-bottom-style: solid;\n}\n\n.whb-row .whb-ua32op9c46gmthwd1fds.wd-tools-element .wd-tools-inner, .whb-row .whb-ua32op9c46gmthwd1fds.wd-tools-element > a > .wd-tools-icon {\n	color: rgba(74, 36, 157, 1);\n	background-color: rgba(74, 36, 157, 0.12);\n}\n.whb-row .whb-ua32op9c46gmthwd1fds.wd-tools-element:hover .wd-tools-inner, .whb-row .whb-ua32op9c46gmthwd1fds.wd-tools-element:hover > a > .wd-tools-icon {\n	color: rgba(74, 36, 157, 1);\n	background-color: rgba(74, 36, 157, 0.12);\n}\n.whb-ua32op9c46gmthwd1fds {\n	--wd-tools-icon-width: 20px;\n}\n.whb-kgr1lv2eq5nsb3cydv5v a:is(.btn-style-default, .btn-style-3d) {\n	background-color: rgba(208, 2, 27, 0.19);\n}\n.whb-kgr1lv2eq5nsb3cydv5v a:is(.btn-style-bordered, .btn-style-link) {\n	border-color: rgba(208, 2, 27, 0.19);\n}\n.whb-kgr1lv2eq5nsb3cydv5v.wd-button-wrapper a {\n	color: rgba(208, 2, 27, 1);\n}\n.whb-header-bottom {\n	background-color: rgba(244, 243, 245, 1);\n}\n", "off");
INSERT INTO `wp_options` VALUES("189", "xts-default_header-status", "valid", "off");
INSERT INTO `wp_options` VALUES("190", "xts-default_header-version", "8.2.2", "off");
INSERT INTO `wp_options` VALUES("191", "xts-default_header-site-url", "8ae7d28426120ec4b9d28756200f034a", "off");
INSERT INTO `wp_options` VALUES("192", "_transient_wp_styles_for_blocks", "a:2:{s:4:\"hash\";s:32:\"a699696af3c334db4f89ccd1b7cc3f56\";s:6:\"blocks\";a:5:{s:11:\"core/button\";s:0:\"\";s:14:\"core/site-logo\";s:0:\"\";s:18:\"core/post-template\";s:120:\":where(.wp-block-post-template.is-layout-flex){gap: 1.25em;}:where(.wp-block-post-template.is-layout-grid){gap: 1.25em;}\";s:12:\"core/columns\";s:102:\":where(.wp-block-columns.is-layout-flex){gap: 2em;}:where(.wp-block-columns.is-layout-grid){gap: 2em;}\";s:14:\"core/pullquote\";s:69:\":root :where(.wp-block-pullquote){font-size: 1.5em;line-height: 1.6;}\";}}", "on");
INSERT INTO `wp_options` VALUES("547", "_transient_product_query-transient-version", "1748777059", "on");
INSERT INTO `wp_options` VALUES("194", "wd_page_css_files_theme_version", "8.2.2", "auto");
INSERT INTO `wp_options` VALUES("195", "wpcf7", "a:2:{s:7:\"version\";s:5:\"6.0.6\";s:13:\"bulk_validate\";a:4:{s:9:\"timestamp\";i:1744891485;s:7:\"version\";s:5:\"6.0.5\";s:11:\"count_valid\";i:1;s:13:\"count_invalid\";i:0;}}", "auto");
INSERT INTO `wp_options` VALUES("196", "elementor_active_kit", "7", "auto");
INSERT INTO `wp_options` VALUES("197", "elementor_font_display", "swap", "auto");
INSERT INTO `wp_options` VALUES("406", "woocommerce_coming_soon", "no", "auto");
INSERT INTO `wp_options` VALUES("407", "woocommerce_store_pages_only", "yes", "auto");
INSERT INTO `wp_options` VALUES("200", "action_scheduler_hybrid_store_demarkation", "8", "auto");
INSERT INTO `wp_options` VALUES("201", "schema-ActionScheduler_StoreSchema", "7.0.1744891485", "auto");
INSERT INTO `wp_options` VALUES("202", "schema-ActionScheduler_LoggerSchema", "3.0.1744891485", "auto");
INSERT INTO `wp_options` VALUES("345", "woocommerce_admin_install_timestamp", "1744891487", "auto");
INSERT INTO `wp_options` VALUES("205", "woocommerce_newly_installed", "no", "auto");
INSERT INTO `wp_options` VALUES("206", "woocommerce_schema_version", "920", "auto");
INSERT INTO `wp_options` VALUES("207", "woocommerce_store_address", "", "on");
INSERT INTO `wp_options` VALUES("208", "woocommerce_store_address_2", "", "on");
INSERT INTO `wp_options` VALUES("209", "woocommerce_store_city", "", "on");
INSERT INTO `wp_options` VALUES("210", "woocommerce_default_country", "IR:THR", "on");
INSERT INTO `wp_options` VALUES("211", "woocommerce_store_postcode", "", "on");
INSERT INTO `wp_options` VALUES("212", "woocommerce_allowed_countries", "all", "on");
INSERT INTO `wp_options` VALUES("213", "woocommerce_all_except_countries", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("214", "woocommerce_specific_allowed_countries", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("215", "woocommerce_ship_to_countries", "", "on");
INSERT INTO `wp_options` VALUES("216", "woocommerce_specific_ship_to_countries", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("217", "woocommerce_default_customer_address", "base", "on");
INSERT INTO `wp_options` VALUES("218", "woocommerce_calc_taxes", "no", "on");
INSERT INTO `wp_options` VALUES("219", "woocommerce_enable_coupons", "yes", "on");
INSERT INTO `wp_options` VALUES("220", "woocommerce_calc_discounts_sequentially", "no", "off");
INSERT INTO `wp_options` VALUES("221", "woocommerce_currency", "IRT", "on");
INSERT INTO `wp_options` VALUES("222", "woocommerce_currency_pos", "right_space", "on");
INSERT INTO `wp_options` VALUES("223", "woocommerce_price_thousand_sep", ".", "on");
INSERT INTO `wp_options` VALUES("224", "woocommerce_price_decimal_sep", ",", "on");
INSERT INTO `wp_options` VALUES("225", "woocommerce_price_num_decimals", "0", "on");
INSERT INTO `wp_options` VALUES("226", "woocommerce_shop_page_id", "9", "on");
INSERT INTO `wp_options` VALUES("227", "woocommerce_cart_redirect_after_add", "no", "on");
INSERT INTO `wp_options` VALUES("228", "woocommerce_enable_ajax_add_to_cart", "yes", "on");
INSERT INTO `wp_options` VALUES("229", "woocommerce_placeholder_image", "8", "on");
INSERT INTO `wp_options` VALUES("230", "woocommerce_weight_unit", "g", "on");
INSERT INTO `wp_options` VALUES("231", "woocommerce_dimension_unit", "cm", "on");
INSERT INTO `wp_options` VALUES("232", "woocommerce_enable_reviews", "yes", "on");
INSERT INTO `wp_options` VALUES("233", "woocommerce_review_rating_verification_label", "yes", "off");
INSERT INTO `wp_options` VALUES("234", "woocommerce_review_rating_verification_required", "no", "off");
INSERT INTO `wp_options` VALUES("235", "woocommerce_enable_review_rating", "yes", "on");
INSERT INTO `wp_options` VALUES("236", "woocommerce_review_rating_required", "yes", "off");
INSERT INTO `wp_options` VALUES("237", "woocommerce_manage_stock", "yes", "on");
INSERT INTO `wp_options` VALUES("238", "woocommerce_hold_stock_minutes", "60", "off");
INSERT INTO `wp_options` VALUES("239", "woocommerce_notify_low_stock", "yes", "off");
INSERT INTO `wp_options` VALUES("240", "woocommerce_notify_no_stock", "yes", "off");
INSERT INTO `wp_options` VALUES("241", "woocommerce_stock_email_recipient", "devwp98@gmail.com", "off");
INSERT INTO `wp_options` VALUES("242", "woocommerce_notify_low_stock_amount", "2", "off");
INSERT INTO `wp_options` VALUES("243", "woocommerce_notify_no_stock_amount", "0", "on");
INSERT INTO `wp_options` VALUES("244", "woocommerce_hide_out_of_stock_items", "no", "on");
INSERT INTO `wp_options` VALUES("245", "woocommerce_stock_format", "", "on");
INSERT INTO `wp_options` VALUES("246", "woocommerce_file_download_method", "force", "off");
INSERT INTO `wp_options` VALUES("247", "woocommerce_downloads_redirect_fallback_allowed", "no", "off");
INSERT INTO `wp_options` VALUES("248", "woocommerce_downloads_require_login", "no", "off");
INSERT INTO `wp_options` VALUES("249", "woocommerce_downloads_grant_access_after_payment", "yes", "off");
INSERT INTO `wp_options` VALUES("250", "woocommerce_downloads_deliver_inline", "", "off");
INSERT INTO `wp_options` VALUES("251", "woocommerce_downloads_add_hash_to_filename", "yes", "on");
INSERT INTO `wp_options` VALUES("252", "woocommerce_downloads_count_partial", "yes", "on");
INSERT INTO `wp_options` VALUES("6307", "woocommerce_attribute_lookup_enabled", "no", "auto");
INSERT INTO `wp_options` VALUES("254", "woocommerce_attribute_lookup_direct_updates", "no", "on");
INSERT INTO `wp_options` VALUES("255", "woocommerce_attribute_lookup_optimized_updates", "no", "on");
INSERT INTO `wp_options` VALUES("256", "woocommerce_product_match_featured_image_by_sku", "no", "on");
INSERT INTO `wp_options` VALUES("257", "woocommerce_prices_include_tax", "no", "on");
INSERT INTO `wp_options` VALUES("258", "woocommerce_tax_based_on", "shipping", "on");
INSERT INTO `wp_options` VALUES("259", "woocommerce_shipping_tax_class", "inherit", "on");
INSERT INTO `wp_options` VALUES("260", "woocommerce_tax_round_at_subtotal", "no", "on");
INSERT INTO `wp_options` VALUES("261", "woocommerce_tax_classes", "", "on");
INSERT INTO `wp_options` VALUES("262", "woocommerce_tax_display_shop", "excl", "on");
INSERT INTO `wp_options` VALUES("263", "woocommerce_tax_display_cart", "excl", "on");
INSERT INTO `wp_options` VALUES("264", "woocommerce_price_display_suffix", "", "on");
INSERT INTO `wp_options` VALUES("265", "woocommerce_tax_total_display", "itemized", "off");
INSERT INTO `wp_options` VALUES("266", "woocommerce_enable_shipping_calc", "yes", "off");
INSERT INTO `wp_options` VALUES("267", "woocommerce_shipping_cost_requires_address", "no", "on");
INSERT INTO `wp_options` VALUES("268", "woocommerce_ship_to_destination", "billing", "off");
INSERT INTO `wp_options` VALUES("269", "woocommerce_shipping_debug_mode", "no", "on");
INSERT INTO `wp_options` VALUES("270", "woocommerce_enable_guest_checkout", "yes", "off");
INSERT INTO `wp_options` VALUES("271", "woocommerce_enable_checkout_login_reminder", "no", "off");
INSERT INTO `wp_options` VALUES("272", "woocommerce_enable_signup_and_login_from_checkout", "no", "off");
INSERT INTO `wp_options` VALUES("273", "woocommerce_enable_myaccount_registration", "no", "off");
INSERT INTO `wp_options` VALUES("274", "woocommerce_registration_generate_password", "yes", "off");
INSERT INTO `wp_options` VALUES("275", "woocommerce_registration_generate_username", "yes", "off");
INSERT INTO `wp_options` VALUES("276", "woocommerce_erasure_request_removes_order_data", "no", "off");
INSERT INTO `wp_options` VALUES("277", "woocommerce_erasure_request_removes_download_data", "no", "off");
INSERT INTO `wp_options` VALUES("278", "woocommerce_allow_bulk_remove_personal_data", "no", "off");
INSERT INTO `wp_options` VALUES("279", "woocommerce_registration_privacy_policy_text", "اطلاعات شخصی شما برای پردازش سفارش شما استفاده می‌شود، و پشتیبانی از تجربه شما در این وبسایت، و برای اهداف دیگری که در [privacy_policy] توضیح داده شده است.", "on");
INSERT INTO `wp_options` VALUES("280", "woocommerce_checkout_privacy_policy_text", "اطلاعات شخصی شما برای پردازش سفارش شما، پشتیبانی از تجربه شما در سراسر این وب سایت و برای اهدافی که در [privacy_policy] ذکر شده است استفاده می شود.", "on");
INSERT INTO `wp_options` VALUES("281", "woocommerce_delete_inactive_accounts", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "off");
INSERT INTO `wp_options` VALUES("282", "woocommerce_trash_pending_orders", "", "off");
INSERT INTO `wp_options` VALUES("283", "woocommerce_trash_failed_orders", "", "off");
INSERT INTO `wp_options` VALUES("284", "woocommerce_trash_cancelled_orders", "", "off");
INSERT INTO `wp_options` VALUES("285", "woocommerce_anonymize_completed_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "off");
INSERT INTO `wp_options` VALUES("286", "woocommerce_email_from_name", "دمو لباس زیر وودمارت پلاس", "off");
INSERT INTO `wp_options` VALUES("287", "woocommerce_email_from_address", "devwp98@gmail.com", "off");
INSERT INTO `wp_options` VALUES("288", "woocommerce_email_header_image", "", "off");
INSERT INTO `wp_options` VALUES("289", "woocommerce_email_base_color", "#720eec", "off");
INSERT INTO `wp_options` VALUES("290", "woocommerce_email_background_color", "#f7f7f7", "off");
INSERT INTO `wp_options` VALUES("291", "woocommerce_email_body_background_color", "#ffffff", "off");
INSERT INTO `wp_options` VALUES("292", "woocommerce_email_text_color", "#3c3c3c", "off");
INSERT INTO `wp_options` VALUES("293", "woocommerce_email_footer_text", "{site_title} &mdash; Built with {WooCommerce}", "off");
INSERT INTO `wp_options` VALUES("294", "woocommerce_email_footer_text_color", "#3c3c3c", "off");
INSERT INTO `wp_options` VALUES("295", "woocommerce_merchant_email_notifications", "no", "off");
INSERT INTO `wp_options` VALUES("296", "woocommerce_cart_page_id", "10", "off");
INSERT INTO `wp_options` VALUES("297", "woocommerce_checkout_page_id", "11", "off");
INSERT INTO `wp_options` VALUES("298", "woocommerce_myaccount_page_id", "12", "off");
INSERT INTO `wp_options` VALUES("299", "woocommerce_terms_page_id", "", "off");
INSERT INTO `wp_options` VALUES("300", "woocommerce_checkout_pay_endpoint", "order-pay", "on");
INSERT INTO `wp_options` VALUES("301", "woocommerce_checkout_order_received_endpoint", "order-received", "on");
INSERT INTO `wp_options` VALUES("302", "woocommerce_myaccount_add_payment_method_endpoint", "add-payment-method", "on");
INSERT INTO `wp_options` VALUES("303", "woocommerce_myaccount_delete_payment_method_endpoint", "delete-payment-method", "on");
INSERT INTO `wp_options` VALUES("304", "woocommerce_myaccount_set_default_payment_method_endpoint", "set-default-payment-method", "on");
INSERT INTO `wp_options` VALUES("305", "woocommerce_myaccount_orders_endpoint", "orders", "on");
INSERT INTO `wp_options` VALUES("306", "woocommerce_myaccount_view_order_endpoint", "view-order", "on");
INSERT INTO `wp_options` VALUES("307", "woocommerce_myaccount_downloads_endpoint", "downloads", "on");
INSERT INTO `wp_options` VALUES("308", "woocommerce_myaccount_edit_account_endpoint", "edit-account", "on");
INSERT INTO `wp_options` VALUES("309", "woocommerce_myaccount_edit_address_endpoint", "edit-address", "on");
INSERT INTO `wp_options` VALUES("310", "woocommerce_myaccount_payment_methods_endpoint", "payment-methods", "on");
INSERT INTO `wp_options` VALUES("311", "woocommerce_myaccount_lost_password_endpoint", "lost-password", "on");
INSERT INTO `wp_options` VALUES("312", "woocommerce_logout_endpoint", "customer-logout", "on");
INSERT INTO `wp_options` VALUES("313", "woocommerce_api_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("314", "woocommerce_allow_tracking", "no", "on");
INSERT INTO `wp_options` VALUES("315", "woocommerce_show_marketplace_suggestions", "no", "off");
INSERT INTO `wp_options` VALUES("316", "woocommerce_custom_orders_table_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("317", "woocommerce_analytics_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("318", "woocommerce_feature_rate_limit_checkout_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("319", "woocommerce_feature_order_attribution_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("320", "woocommerce_feature_site_visibility_badge_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("321", "woocommerce_feature_remote_logging_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("322", "woocommerce_feature_product_block_editor_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("323", "woocommerce_hpos_fts_index_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("324", "woocommerce_feature_email_improvements_enabled", "yes", "on");
INSERT INTO `wp_options` VALUES("325", "woocommerce_feature_cost_of_goods_sold_enabled", "no", "on");
INSERT INTO `wp_options` VALUES("326", "woocommerce_single_image_width", "600", "on");
INSERT INTO `wp_options` VALUES("327", "woocommerce_thumbnail_image_width", "300", "on");
INSERT INTO `wp_options` VALUES("328", "woocommerce_checkout_highlight_required_fields", "yes", "on");
INSERT INTO `wp_options` VALUES("329", "woocommerce_demo_store", "no", "off");
INSERT INTO `wp_options` VALUES("330", "wc_downloads_approved_directories_mode", "enabled", "auto");
INSERT INTO `wp_options` VALUES("331", "woocommerce_permalinks", "a:5:{s:12:\"product_base\";s:19:\"/shop/%product_cat%\";s:13:\"category_base\";s:16:\"product-category\";s:8:\"tag_base\";s:11:\"product-tag\";s:14:\"attribute_base\";s:0:\"\";s:22:\"use_verbose_page_rules\";b:1;}", "auto");
INSERT INTO `wp_options` VALUES("332", "current_theme_supports_woocommerce", "yes", "auto");
INSERT INTO `wp_options` VALUES("333", "woocommerce_queue_flush_rewrite_rules", "no", "auto");
INSERT INTO `wp_options` VALUES("436", "woocommerce_anonymize_refunded_orders", "a:2:{s:6:\"number\";s:0:\"\";s:4:\"unit\";s:6:\"months\";}", "off");
INSERT INTO `wp_options` VALUES("594", "product_cat_children", "a:0:{}", "auto");
INSERT INTO `wp_options` VALUES("336", "default_product_cat", "16", "auto");
INSERT INTO `wp_options` VALUES("405", "woocommerce_custom_orders_table_created", "yes", "auto");
INSERT INTO `wp_options` VALUES("338", "woocommerce_refund_returns_page_id", "13", "auto");
INSERT INTO `wp_options` VALUES("341", "woocommerce_paypal_settings", "a:23:{s:7:\"enabled\";s:2:\"no\";s:5:\"title\";s:13:\"پی‌پال\";s:11:\"description\";s:168:\"پرداخت از راه پی‌پال، اگر حساب کاربری پی‌پال ندارید، می توانید با کارت اعتباری پرداخت کنید.\";s:5:\"email\";s:17:\"devwp98@gmail.com\";s:8:\"advanced\";s:0:\"\";s:8:\"testmode\";s:2:\"no\";s:5:\"debug\";s:2:\"no\";s:16:\"ipn_notification\";s:3:\"yes\";s:14:\"receiver_email\";s:17:\"devwp98@gmail.com\";s:14:\"identity_token\";s:0:\"\";s:14:\"invoice_prefix\";s:3:\"WC-\";s:13:\"send_shipping\";s:3:\"yes\";s:16:\"address_override\";s:2:\"no\";s:13:\"paymentaction\";s:4:\"sale\";s:9:\"image_url\";s:0:\"\";s:11:\"api_details\";s:0:\"\";s:12:\"api_username\";s:0:\"\";s:12:\"api_password\";s:0:\"\";s:13:\"api_signature\";s:0:\"\";s:20:\"sandbox_api_username\";s:0:\"\";s:20:\"sandbox_api_password\";s:0:\"\";s:21:\"sandbox_api_signature\";s:0:\"\";s:12:\"_should_load\";s:2:\"no\";}", "on");
INSERT INTO `wp_options` VALUES("342", "woocommerce_version", "9.9.3", "auto");
INSERT INTO `wp_options` VALUES("343", "woocommerce_db_version", "9.9.3", "auto");
INSERT INTO `wp_options` VALUES("344", "woocommerce_store_id", "5d57d75c-8337-4c12-b5b3-8ffcee3193c1", "auto");
INSERT INTO `wp_options` VALUES("346", "woocommerce_inbox_variant_assignment", "8", "auto");
INSERT INTO `wp_options` VALUES("347", "woocommerce_remote_variant_assignment", "80", "auto");
INSERT INTO `wp_options` VALUES("352", "_transient_jetpack_autoloader_plugin_paths", "a:1:{i:0;s:29:\"{{WP_PLUGIN_DIR}}/woocommerce\";}", "on");
INSERT INTO `wp_options` VALUES("353", "action_scheduler_lock_async-request-runner", "68484fa44d5e35.57056106|1749569504", "no");
INSERT INTO `wp_options` VALUES("354", "woocommerce_admin_notices", "a:1:{i:0;s:14:\"template_files\";}", "auto");
INSERT INTO `wp_options` VALUES("355", "wc_blocks_version", "11.8.0-dev", "auto");
INSERT INTO `wp_options` VALUES("356", "elementor_landing_pages_activation", "0", "auto");
INSERT INTO `wp_options` VALUES("357", "elementor_version", "3.29.2", "auto");
INSERT INTO `wp_options` VALUES("358", "elementor_install_history", "a:4:{s:6:\"3.28.1\";i:1744891497;s:6:\"3.28.3\";i:1744891544;s:6:\"3.28.4\";i:1746645438;s:6:\"3.29.2\";i:1749569231;}", "auto");
INSERT INTO `wp_options` VALUES("359", "elementor_events_db_version", "1.0.0", "off");
INSERT INTO `wp_options` VALUES("360", "woocommerce_maxmind_geolocation_settings", "a:1:{s:15:\"database_prefix\";s:32:\"rYjcvvekgBOH9QVaGgb9KSpiMqgucdNK\";}", "on");
INSERT INTO `wp_options` VALUES("361", "_transient_woocommerce_webhook_ids_status_active", "a:0:{}", "on");
INSERT INTO `wp_options` VALUES("362", "widget_woocommerce_widget_cart", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("363", "widget_woocommerce_layered_nav_filters", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("364", "widget_woocommerce_layered_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("365", "widget_woocommerce_price_filter", "a:2:{i:2;a:1:{s:5:\"title\";s:33:\"فیلتر بر اساس قیمت\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("366", "widget_woocommerce_product_categories", "a:2:{i:2;a:8:{s:5:\"title\";s:32:\"دسته بندی محصولات\";s:7:\"orderby\";s:4:\"name\";s:8:\"dropdown\";i:0;s:5:\"count\";i:0;s:12:\"hierarchical\";i:1;s:18:\"show_children_only\";i:0;s:10:\"hide_empty\";i:0;s:9:\"max_depth\";s:0:\"\";}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("367", "widget_woocommerce_product_search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("368", "widget_woocommerce_product_tag_cloud", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("369", "widget_woocommerce_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("370", "widget_woocommerce_recently_viewed_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("371", "widget_woocommerce_top_rated_products", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("372", "widget_woocommerce_recent_reviews", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("373", "widget_woocommerce_rating_filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("374", "widget_nav_mega_menu", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("375", "widget_woodmart-banner", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("376", "widget_woodmart-author-information", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("377", "widget_woodmart-instagram", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("378", "widget_woodmart-html-block", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("379", "widget_woodmart-recent-posts", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("380", "widget_woodmart-twitter", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("381", "widget_wd-mailchimp-widget", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("382", "widget_woodmart-user-panel", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("383", "widget_woodmart-woocommerce-layered-nav", "a:2:{i:2;a:12:{s:5:\"title\";s:24:\"فیلتر بر اساس\";s:9:\"attribute\";s:5:\"color\";s:8:\"category\";a:1:{i:0;s:3:\"all\";}s:10:\"query_type\";s:3:\"and\";s:7:\"display\";s:4:\"list\";s:4:\"size\";s:6:\"normal\";s:5:\"style\";s:7:\"inherit\";s:5:\"shape\";s:7:\"inherit\";s:6:\"labels\";s:2:\"on\";s:8:\"tooltips\";s:2:\"on\";s:10:\"checkboxes\";s:3:\"off\";s:17:\"search_by_filters\";b:0;}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("384", "widget_woodmart-woocommerce-sort-by", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("385", "widget_woodmart-price-filter", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("386", "widget_woodmart-ajax-search", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("387", "widget_wd-widget-stock-status", "a:2:{i:2;a:4:{s:5:\"title\";s:35:\"فیلتر بر اساس وضعیت\";s:7:\"instock\";s:1:\"1\";s:6:\"onsale\";s:1:\"1\";s:11:\"onbackorder\";b:0;}s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("388", "widget_wc_brands_brand_description", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("389", "widget_woocommerce_brand_nav", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("390", "widget_wc_brands_brand_thumbnails", "a:1:{s:12:\"_multiwidget\";i:1;}", "auto");
INSERT INTO `wp_options` VALUES("6026", "_site_transient_timeout_woocommerce_blocks_patterns", "1752161246", "off");
INSERT INTO `wp_options` VALUES("6027", "_site_transient_woocommerce_blocks_patterns", "a:2:{s:7:\"version\";s:5:\"9.9.3\";s:8:\"patterns\";a:41:{i:0;a:11:{s:5:\"title\";s:6:\"Banner\";s:4:\"slug\";s:25:\"woocommerce-blocks/banner\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:10:\"banner.php\";}i:1;a:11:{s:5:\"title\";s:23:\"Coming Soon Entire Site\";s:4:\"slug\";s:35:\"woocommerce/coming-soon-entire-site\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:17:\"launch-your-store\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:27:\"coming-soon-entire-site.php\";}i:2;a:11:{s:5:\"title\";s:22:\"Coming Soon Store Only\";s:4:\"slug\";s:34:\"woocommerce/coming-soon-store-only\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:17:\"launch-your-store\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:26:\"coming-soon-store-only.php\";}i:3;a:11:{s:5:\"title\";s:11:\"Coming Soon\";s:4:\"slug\";s:23:\"woocommerce/coming-soon\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:17:\"launch-your-store\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:15:\"coming-soon.php\";}i:4;a:11:{s:5:\"title\";s:29:\"Content right with image left\";s:4:\"slug\";s:48:\"woocommerce-blocks/content-right-with-image-left\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, About\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:28:\"content-right-image-left.php\";}i:5;a:11:{s:5:\"title\";s:29:\"Featured Category Cover Image\";s:4:\"slug\";s:48:\"woocommerce-blocks/featured-category-cover-image\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:33:\"featured-category-cover-image.php\";}i:6;a:11:{s:5:\"title\";s:24:\"Featured Category Triple\";s:4:\"slug\";s:43:\"woocommerce-blocks/featured-category-triple\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:28:\"featured-category-triple.php\";}i:7;a:11:{s:5:\"title\";s:12:\"Large Footer\";s:4:\"slug\";s:31:\"woocommerce-blocks/footer-large\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/footer\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:16:\"footer-large.php\";}i:8;a:11:{s:5:\"title\";s:23:\"Footer with Simple Menu\";s:4:\"slug\";s:37:\"woocommerce-blocks/footer-simple-menu\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/footer\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:22:\"footer-simple-menu.php\";}i:9;a:11:{s:5:\"title\";s:17:\"Footer with menus\";s:4:\"slug\";s:38:\"woocommerce-blocks/footer-with-3-menus\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/footer\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:23:\"footer-with-3-menus.php\";}i:10;a:11:{s:5:\"title\";s:28:\"Four Image Grid Content Left\";s:4:\"slug\";s:47:\"woocommerce-blocks/form-image-grid-content-left\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, About\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:32:\"four-image-grid-content-left.php\";}i:11;a:11:{s:5:\"title\";s:20:\"Centered Header Menu\";s:4:\"slug\";s:39:\"woocommerce-blocks/header-centered-menu\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:27:\"header-centered-pattern.php\";}i:12;a:11:{s:5:\"title\";s:23:\"Distraction Free Header\";s:4:\"slug\";s:42:\"woocommerce-blocks/header-distraction-free\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:27:\"header-distraction-free.php\";}i:13;a:11:{s:5:\"title\";s:16:\"Essential Header\";s:4:\"slug\";s:35:\"woocommerce-blocks/header-essential\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:20:\"header-essential.php\";}i:14;a:11:{s:5:\"title\";s:12:\"Large Header\";s:4:\"slug\";s:31:\"woocommerce-blocks/header-large\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:16:\"header-large.php\";}i:15;a:11:{s:5:\"title\";s:14:\"Minimal Header\";s:4:\"slug\";s:33:\"woocommerce-blocks/header-minimal\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:25:\"core/template-part/header\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:18:\"header-minimal.php\";}i:16;a:11:{s:5:\"title\";s:47:\"Heading with three columns of content with link\";s:4:\"slug\";s:66:\"woocommerce-blocks/heading-with-three-columns-of-content-with-link\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:21:\"WooCommerce, Services\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:51:\"heading-with-three-columns-of-content-with-link.php\";}i:17;a:11:{s:5:\"title\";s:20:\"Hero Product 3 Split\";s:4:\"slug\";s:39:\"woocommerce-blocks/hero-product-3-split\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:24:\"hero-product-3-split.php\";}i:18;a:11:{s:5:\"title\";s:23:\"Hero Product Chessboard\";s:4:\"slug\";s:42:\"woocommerce-blocks/hero-product-chessboard\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:27:\"hero-product-chessboard.php\";}i:19;a:11:{s:5:\"title\";s:18:\"Hero Product Split\";s:4:\"slug\";s:37:\"woocommerce-blocks/hero-product-split\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:22:\"hero-product-split.php\";}i:20;a:11:{s:5:\"title\";s:33:\"Centered content with image below\";s:4:\"slug\";s:52:\"woocommerce-blocks/centered-content-with-image-below\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:43:\"intro-centered-content-with-image-below.php\";}i:21;a:11:{s:5:\"title\";s:22:\"Just Arrived Full Hero\";s:4:\"slug\";s:41:\"woocommerce-blocks/just-arrived-full-hero\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:18:\"WooCommerce, Intro\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:26:\"just-arrived-full-hero.php\";}i:22;a:11:{s:5:\"title\";s:33:\"No Products Found - Clear Filters\";s:4:\"slug\";s:43:\"woocommerce/no-products-found-clear-filters\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:2:\"no\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:29:\"no-products-found-filters.php\";}i:23;a:11:{s:5:\"title\";s:17:\"No Products Found\";s:4:\"slug\";s:29:\"woocommerce/no-products-found\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:2:\"no\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:21:\"no-products-found.php\";}i:24;a:11:{s:5:\"title\";s:19:\"Default Coming Soon\";s:4:\"slug\";s:36:\"woocommerce/page-coming-soon-default\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:28:\"page-coming-soon-default.php\";}i:25;a:11:{s:5:\"title\";s:25:\"Coming Soon Image Gallery\";s:4:\"slug\";s:42:\"woocommerce/page-coming-soon-image-gallery\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:34:\"page-coming-soon-image-gallery.php\";}i:26;a:11:{s:5:\"title\";s:30:\"Coming Soon Minimal Left Image\";s:4:\"slug\";s:47:\"woocommerce/page-coming-soon-minimal-left-image\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:39:\"page-coming-soon-minimal-left-image.php\";}i:27;a:11:{s:5:\"title\";s:24:\"Coming Soon Modern Black\";s:4:\"slug\";s:41:\"woocommerce/page-coming-soon-modern-black\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:33:\"page-coming-soon-modern-black.php\";}i:28;a:11:{s:5:\"title\";s:29:\"Coming Soon Split Right Image\";s:4:\"slug\";s:46:\"woocommerce/page-coming-soon-split-right-image\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:38:\"page-coming-soon-split-right-image.php\";}i:29;a:11:{s:5:\"title\";s:34:\"Coming Soon With Header and Footer\";s:4:\"slug\";s:47:\"woocommerce/page-coming-soon-with-header-footer\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:11:\"coming-soon\";s:6:\"source\";s:39:\"page-coming-soon-with-header-footer.php\";}i:30;a:11:{s:5:\"title\";s:28:\"Product Collection 3 Columns\";s:4:\"slug\";s:47:\"woocommerce-blocks/product-collection-3-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:32:\"product-collection-3-columns.php\";}i:31;a:11:{s:5:\"title\";s:28:\"Product Collection 4 Columns\";s:4:\"slug\";s:47:\"woocommerce-blocks/product-collection-4-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:32:\"product-collection-4-columns.php\";}i:32;a:11:{s:5:\"title\";s:28:\"Product Collection 5 Columns\";s:4:\"slug\";s:47:\"woocommerce-blocks/product-collection-5-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:32:\"product-collection-5-columns.php\";}i:33;a:11:{s:5:\"title\";s:47:\"Product Collection: Featured Products 5 Columns\";s:4:\"slug\";s:65:\"woocommerce-blocks/product-collection-featured-products-5-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:50:\"product-collection-featured-products-5-columns.php\";}i:34;a:11:{s:5:\"title\";s:15:\"Product Gallery\";s:4:\"slug\";s:48:\"woocommerce-blocks/product-query-product-gallery\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:29:\"WooCommerce, featured-selling\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:36:\"core/query/woocommerce/product-query\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:33:\"product-query-product-gallery.php\";}i:35;a:11:{s:5:\"title\";s:14:\"Product Search\";s:4:\"slug\";s:31:\"woocommerce/product-search-form\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:2:\"no\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:23:\"product-search-form.php\";}i:36;a:11:{s:5:\"title\";s:16:\"Related Products\";s:4:\"slug\";s:35:\"woocommerce-blocks/related-products\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:11:\"WooCommerce\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:5:\"false\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:20:\"related-products.php\";}i:37;a:11:{s:5:\"title\";s:33:\"Social: Follow us on social media\";s:4:\"slug\";s:51:\"woocommerce-blocks/social-follow-us-in-social-media\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:25:\"WooCommerce, social-media\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:36:\"social-follow-us-in-social-media.php\";}i:38;a:11:{s:5:\"title\";s:22:\"Testimonials 3 Columns\";s:4:\"slug\";s:41:\"woocommerce-blocks/testimonials-3-columns\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:20:\"WooCommerce, Reviews\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:26:\"testimonials-3-columns.php\";}i:39;a:11:{s:5:\"title\";s:19:\"Testimonials Single\";s:4:\"slug\";s:38:\"woocommerce-blocks/testimonials-single\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:20:\"WooCommerce, Reviews\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:23:\"testimonials-single.php\";}i:40;a:11:{s:5:\"title\";s:37:\"Three columns with images and content\";s:4:\"slug\";s:56:\"woocommerce-blocks/three-columns-with-images-and-content\";s:11:\"description\";s:0:\"\";s:13:\"viewportWidth\";s:0:\"\";s:10:\"categories\";s:21:\"WooCommerce, Services\";s:8:\"keywords\";s:0:\"\";s:10:\"blockTypes\";s:0:\"\";s:8:\"inserter\";s:0:\"\";s:11:\"featureFlag\";s:0:\"\";s:13:\"templateTypes\";s:0:\"\";s:6:\"source\";s:41:\"three-columns-with-images-and-content.php\";}}}", "off");
INSERT INTO `wp_options` VALUES("6252", "_transient_timeout_wishlist_current_user_1", "1749576125", "off");
INSERT INTO `wp_options` VALUES("6253", "_transient_wishlist_current_user_1", "1", "off");
INSERT INTO `wp_options` VALUES("402", "woocommerce_admin_pes_incentive_woopayments_store_had_woopayments", "no", "auto");
INSERT INTO `wp_options` VALUES("563", "woocommerce_task_list_tracked_completed_tasks", "a:4:{i:0;s:15:\"customize-store\";i:1;s:8:\"products\";i:2;s:17:\"launch-your-store\";i:3;s:8:\"payments\";}", "auto");
INSERT INTO `wp_options` VALUES("408", "woocommerce_initial_installed_version", "9.7.1", "off");
INSERT INTO `wp_options` VALUES("409", "wc_blocks_db_schema_version", "260", "auto");
INSERT INTO `wp_options` VALUES("410", "wc_remote_inbox_notifications_stored_state", "O:8:\"stdClass\":2:{s:22:\"there_were_no_products\";b:1;s:22:\"there_are_now_products\";b:1;}", "off");
INSERT INTO `wp_options` VALUES("413", "_elementor_installed_time", "1744891499", "auto");
INSERT INTO `wp_options` VALUES("414", "elementor_connect_site_key", "328003e34c625bd766dccc078f727ccb", "auto");
INSERT INTO `wp_options` VALUES("415", "elementor_remote_info_library", "a:3:{s:10:\"types_data\";a:4:{s:5:\"block\";a:2:{s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:4:\"sets\";a:5:{i:0;s:11:\"Boxing Club\";i:1;s:19:\"Business Consultant\";i:2;s:16:\"Marketing Agency\";i:3;s:9:\"Wireframe\";i:4;s:15:\"Workshop Center\";}}s:5:\"popup\";a:1:{s:10:\"categories\";a:6:{i:0;s:10:\"bottom bar\";i:1;s:7:\"classic\";i:2;s:6:\"fly-in\";i:3;s:11:\"full screen\";i:4;s:9:\"hello bar\";i:5;s:8:\"slide-in\";}}s:2:\"lp\";a:1:{s:10:\"categories\";a:15:{i:0;s:8:\"Business\";i:1;s:16:\"Coming Soon Page\";i:2;s:9:\"eCommerce\";i:3;s:9:\"Education\";i:4;s:6:\"Events\";i:5;s:18:\"Health and Fitness\";i:6;s:3:\"NFT\";i:7;s:14:\"Online Service\";i:8;s:7:\"Product\";i:9;s:11:\"Real Estate\";i:10;s:18:\"Social Involvement\";i:11;s:14:\"Thank You Page\";i:12;s:6:\"Travel\";i:13;s:18:\"Under Construction\";i:14;s:9:\"Wireframe\";}}s:2:\"lb\";a:1:{s:10:\"categories\";a:2:{i:0;s:4:\"post\";i:1;s:7:\"product\";}}}s:10:\"categories\";a:30:{i:0;s:8:\"404 page\";i:1;s:5:\"about\";i:2;s:7:\"archive\";i:3;s:8:\"Benefits\";i:4;s:14:\"call to action\";i:5;s:7:\"clients\";i:6;s:7:\"contact\";i:7;s:4:\"Data\";i:8;s:10:\"ehp-footer\";i:9;s:10:\"ehp-header\";i:10;s:3:\"faq\";i:11;s:8:\"features\";i:12;s:6:\"footer\";i:13;s:7:\"Gallery\";i:14;s:6:\"header\";i:15;s:4:\"hero\";i:16;s:11:\"Link in Bio\";i:17;s:9:\"portfolio\";i:18;s:7:\"pricing\";i:19;s:15:\"product archive\";i:20;s:5:\"Quote\";i:21;s:15:\"Service Details\";i:22;s:8:\"services\";i:23;s:11:\"single page\";i:24;s:11:\"single post\";i:25;s:14:\"single product\";i:26;s:5:\"stats\";i:27;s:9:\"subscribe\";i:28;s:4:\"team\";i:29;s:12:\"testimonials\";}s:9:\"templates\";a:823:{i:0;a:20:{s:4:\"tmpl\";i:1280;s:2:\"id\";i:22403;s:5:\"title\";s:40:\"Hello Bar | Subscribe | Aesthetic Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/aesthetic-clinic-19.jpg\";s:12:\"tmpl_created\";i:1647354307;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/hello-bar-subscribe-aesthetic-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:48:\"[\"Barbershop\",\"Business\",\"Discount\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:1;a:20:{s:4:\"tmpl\";i:1281;s:2:\"id\";i:22410;s:5:\"title\";s:32:\"Fly-In | Discount | Hair Stylist\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/hair-stylist-20.jpg\";s:12:\"tmpl_created\";i:1647354614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-discount-hair-stylist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Barbershop\",\"Discount\",\"Hair\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:2;a:20:{s:4:\"tmpl\";i:1285;s:2:\"id\";i:22440;s:5:\"title\";s:32:\"Classic | Subscribe | Shoe Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/shoes-store-21.jpg\";s:12:\"tmpl_created\";i:1647418620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-subscribe-shoe-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:37:\"[\"Ecommerce\",\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:3;a:20:{s:4:\"tmpl\";i:1286;s:2:\"id\";i:22446;s:5:\"title\";s:37:\"Full Screen | Subscribe | Denim Store\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/denim-store-22.jpg\";s:12:\"tmpl_created\";i:1647419614;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/full-screen-subscribe-denim-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:4;a:20:{s:4:\"tmpl\";i:1287;s:2:\"id\";i:22452;s:5:\"title\";s:37:\"Fly-In | Subscribe | Pizza Restaurant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/pizza-restaurant-23.jpg\";s:12:\"tmpl_created\";i:1647420733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-subscribe-pizza-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:19:\"[\"Business\",\"Food\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:5;a:20:{s:4:\"tmpl\";i:1288;s:2:\"id\";i:22458;s:5:\"title\";s:38:\"Full Screen | Subscribe | Fashion Shop\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-shop-24.jpg\";s:12:\"tmpl_created\";i:1647426379;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-subscribe-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Ecommerce\",\"Fashion\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:6;a:20:{s:4:\"tmpl\";i:1289;s:2:\"id\";i:22464;s:5:\"title\";s:32:\"Fly-In | Contact | Makeup Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/makeup-studio-25.jpg\";s:12:\"tmpl_created\";i:1647427026;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-makeup-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:7;a:20:{s:4:\"tmpl\";i:1290;s:2:\"id\";i:22470;s:5:\"title\";s:32:\"Fly-In | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-26.jpg\";s:12:\"tmpl_created\";i:1647428250;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-contact-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:8;a:20:{s:4:\"tmpl\";i:1291;s:2:\"id\";i:22480;s:5:\"title\";s:27:\"Classic | CTA | MasterClass\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/master-class-27.jpg\";s:12:\"tmpl_created\";i:1647428474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-masterclass/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"cta\",\"Magazine\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:9;a:20:{s:4:\"tmpl\";i:1292;s:2:\"id\";i:22489;s:5:\"title\";s:29:\"Classic | CTA | Music Concert\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/music-concert-29.jpg\";s:12:\"tmpl_created\";i:1647429738;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-music-concert/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"cta\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:10;a:20:{s:4:\"tmpl\";i:1293;s:2:\"id\";i:22495;s:5:\"title\";s:27:\"Classic | CTA | Music Album\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/music-album-30.jpg\";s:12:\"tmpl_created\";i:1647430056;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-music-album/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Ba\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:11;a:20:{s:4:\"tmpl\";i:1294;s:2:\"id\";i:22501;s:5:\"title\";s:37:\"Fly-In | CTA | Photography Exhibition\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/photography-exhibition-31.jpg\";s:12:\"tmpl_created\";i:1647430512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-photography-exhibition/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:12;a:20:{s:4:\"tmpl\";i:1295;s:2:\"id\";i:22507;s:5:\"title\";s:34:\"Classic | CTA | Clothing Shop Sale\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/clothing-shop-sale-32.jpg\";s:12:\"tmpl_created\";i:1647430774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-cta-clothing-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Ecommerce\",\"Fashion\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:13;a:20:{s:4:\"tmpl\";i:1296;s:2:\"id\";i:22486;s:5:\"title\";s:30:\"Classic | CTA | Shop Promotion\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/shop-promotion-28.jpg\";s:12:\"tmpl_created\";i:1647430951;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-shop-promotion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"cta\",\"Magazine\",\"Photography\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:14;a:20:{s:4:\"tmpl\";i:1297;s:2:\"id\";i:22516;s:5:\"title\";s:32:\"Fly-In | CTA | Glasses Shop Sale\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/glasses-shop-sale-33.jpg\";s:12:\"tmpl_created\";i:1647431136;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-cta-glasses-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:30:\"[\"Business\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:15;a:20:{s:4:\"tmpl\";i:1298;s:2:\"id\";i:22522;s:5:\"title\";s:30:\"Fly-In | Discount | Skate Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/50-skate-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647434058;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-skate-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:16;a:20:{s:4:\"tmpl\";i:1299;s:2:\"id\";i:22532;s:5:\"title\";s:43:\"Classic | Subscription | Basketball Academy\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/21-basketball-academy-Subscription.jpg\";s:12:\"tmpl_created\";i:1647434608;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/classic-subscription-basketball-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Education\",\"Marketing\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:17;a:20:{s:4:\"tmpl\";i:1300;s:2:\"id\";i:22543;s:5:\"title\";s:38:\"Classic | Discount | Veterinary Clinic\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/veterinery-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647435581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-discount-veterinary-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Discount\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:18;a:20:{s:4:\"tmpl\";i:1301;s:2:\"id\";i:22553;s:5:\"title\";s:39:\"Classic | Contact | Business Consulting\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/27-business-consulting-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647439935;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/classic-contact-business-consulting/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Business\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:19;a:20:{s:4:\"tmpl\";i:1302;s:2:\"id\";i:22562;s:5:\"title\";s:28:\"Classic | Contact | Handyman\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/handyman-small.jpg\";s:12:\"tmpl_created\";i:1647440333;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-contact-handyman/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:20;a:20:{s:4:\"tmpl\";i:1303;s:2:\"id\";i:22573;s:5:\"title\";s:40:\"Classic | Discount | Online Fashion Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/31-online-fashion-shop-Discount.jpg\";s:12:\"tmpl_created\";i:1647462549;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-online-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Discount\",\"Ecommerce\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:21;a:20:{s:4:\"tmpl\";i:1304;s:2:\"id\";i:22583;s:5:\"title\";s:36:\"Fly-In | Discount | Personal Trainer\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/personal-trainer-small.jpg\";s:12:\"tmpl_created\";i:1647503781;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-personal-trainer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:22;a:20:{s:4:\"tmpl\";i:1305;s:2:\"id\";i:22592;s:5:\"title\";s:41:\"Classic | Contact | Illustrator Portfolio\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/illustrator-protfolio-small.jpg\";s:12:\"tmpl_created\";i:1647504218;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-contact-illustrator-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:49:\"[\"Contact\",\"Creative Portfolio\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:23;a:20:{s:4:\"tmpl\";i:1306;s:2:\"id\";i:22602;s:5:\"title\";s:46:\"Bottom Bar | Discount | Handmade Ceramics Shop\";s:9:\"thumbnail\";s:91:\"https://library.elementor.com/wp-content/uploads/2022/03/handmade-ceramic-shop-36-small.jpg\";s:12:\"tmpl_created\";i:1647507007;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-ceramics-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:48:\"[\"Business\",\"cta\",\"Ecommerce\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:24;a:20:{s:4:\"tmpl\";i:1307;s:2:\"id\";i:22612;s:5:\"title\";s:51:\"Classic | Contact | Classic Car Restoration Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/restoration-car-shop-37-small.jpg\";s:12:\"tmpl_created\";i:1647507310;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/classic-contact-classic-car-restoration-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:25;a:20:{s:4:\"tmpl\";i:1308;s:2:\"id\";i:22621;s:5:\"title\";s:30:\"Classic | Booking | Life Coach\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/38-life-coach-Booking.jpg\";s:12:\"tmpl_created\";i:1647508596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-booking-life-coach/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:33:\"[\"Booking\",\"Business\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:26;a:20:{s:4:\"tmpl\";i:1309;s:2:\"id\";i:22632;s:5:\"title\";s:42:\"Classic |  Subscription | Merchandise Shop\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/Merchandise-Shop-39-small.jpg\";s:12:\"tmpl_created\";i:1647509196;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-subscription-merchandise-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Ecommerce\",\"Marketing\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:27;a:20:{s:4:\"tmpl\";i:1310;s:2:\"id\";i:22643;s:5:\"title\";s:48:\"Fly-In | Contact | Non-Governmental Organization\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/NGO-41-small.jpg\";s:12:\"tmpl_created\";i:1647509528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:150:\"https://library.elementor.com/popups/fly-in-contact-non-governmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:28;a:20:{s:4:\"tmpl\";i:1311;s:2:\"id\";i:22654;s:5:\"title\";s:35:\"Hello Bar | Contact | Family Doctor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/family-doctor-44-small.jpg\";s:12:\"tmpl_created\";i:1647509732;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/hello-bar-contact-family-doctor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Contact\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:29;a:20:{s:4:\"tmpl\";i:1312;s:2:\"id\";i:22663;s:5:\"title\";s:36:\"Classic | Subscription | Sports Blog\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/45-sport-blog-Subscription.jpg\";s:12:\"tmpl_created\";i:1647509908;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-sports-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Sport\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:30;a:20:{s:4:\"tmpl\";i:1313;s:2:\"id\";i:22673;s:5:\"title\";s:30:\"Hello Bar | Booking | Event DJ\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/DJ-service-46-small.jpg\";s:12:\"tmpl_created\";i:1647510160;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/hello-bar-booking-event-dj/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:31:\"[\"Booking\",\"Events\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:31;a:20:{s:4:\"tmpl\";i:1314;s:2:\"id\";i:22684;s:5:\"title\";s:36:\"Fly-In | Discount | Cleaning Company\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/51-cleaning-company-Discount.jpg\";s:12:\"tmpl_created\";i:1647510546;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-discount-cleaning-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Discount\",\"Offer\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:32;a:20:{s:4:\"tmpl\";i:1315;s:2:\"id\";i:22693;s:5:\"title\";s:28:\"Fly-In | Contact | Carpenter\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/carpenter-53-small.jpg\";s:12:\"tmpl_created\";i:1647511972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-carpenter/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:33;a:20:{s:4:\"tmpl\";i:1316;s:2:\"id\";i:22703;s:5:\"title\";s:31:\"Classic | Booking | Yoga Studio\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/55-yoga-studio-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647512209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-booking-yoga-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Booking\",\"Contact\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:34;a:20:{s:4:\"tmpl\";i:1317;s:2:\"id\";i:22714;s:5:\"title\";s:37:\"Classic | Discount | Pet Care Company\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/56-Pet-Care-Discount.jpg\";s:12:\"tmpl_created\";i:1647513031;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-pet-care-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:35;a:20:{s:4:\"tmpl\";i:1318;s:2:\"id\";i:22725;s:5:\"title\";s:38:\"Fly-In | Discount | Online Coffee Shop\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/online-coffee-shop-57-small.jpg\";s:12:\"tmpl_created\";i:1647513325;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-discount-online-coffee-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Food\",\"Offer\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:36;a:20:{s:4:\"tmpl\";i:1319;s:2:\"id\";i:22737;s:5:\"title\";s:44:\"Fly-In | CTA | Moving &#038; Storage Company\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/moving-company-59-small.jpg\";s:12:\"tmpl_created\";i:1647520956;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/fly-in-cta-moving-storage-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:12:\"[\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:37;a:20:{s:4:\"tmpl\";i:1320;s:2:\"id\";i:22749;s:5:\"title\";s:47:\"Classic | Contact | Industrial Design Portfolio\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/60-industrial-design-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647528116;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/classic-contact-industrial-design-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:40:\"[\"Contact\",\"Interior Design\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:38;a:20:{s:4:\"tmpl\";i:1321;s:2:\"id\";i:22759;s:5:\"title\";s:25:\"Classic | Contact | Drone\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/drone-61-small.jpg\";s:12:\"tmpl_created\";i:1647528899;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/classic-contact-drone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:39;a:20:{s:4:\"tmpl\";i:1322;s:2:\"id\";i:22768;s:5:\"title\";s:46:\"Full Screen | Menu | Fashion Stylist Portfolio\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/62-Fashion-Stylist-Menu.jpg\";s:12:\"tmpl_created\";i:1647529434;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/full-screen-menu-fashion-stylist-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:31:\"[\"Fashion\",\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:40;a:20:{s:4:\"tmpl\";i:1323;s:2:\"id\";i:22780;s:5:\"title\";s:31:\"Fly-In | CTA | Landscape Design\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/64-Landscape-Design-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647530337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-landscape-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:41;a:20:{s:4:\"tmpl\";i:1324;s:2:\"id\";i:22790;s:5:\"title\";s:48:\"Bottom Bar  | Contact | Architecture Photography\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/architecture-photography-65-small.jpg\";s:12:\"tmpl_created\";i:1647532358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/bottom-bar-contact-architecture-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:17:\"essential-oct2023\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:26:\"[\"Architecture\",\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:42;a:20:{s:4:\"tmpl\";i:1325;s:2:\"id\";i:22800;s:5:\"title\";s:41:\"Fly-In  | CTA | Speech-Language Therapist\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/66-Speech-Language-Therapist-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647532720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/fly-in-cta-speech-language-therapist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:25:\"[\"cta\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:43;a:20:{s:4:\"tmpl\";i:1326;s:2:\"id\";i:22812;s:5:\"title\";s:35:\"Full Screen | Verification | Winery\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/67-Winery-Verification.jpg\";s:12:\"tmpl_created\";i:1647761384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/full-screen-verification-winery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:24:\"[\"Alert\",\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:44;a:20:{s:4:\"tmpl\";i:1327;s:2:\"id\";i:22822;s:5:\"title\";s:36:\"Fly-In | Subscription | Nutritionist\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/nutritionist-69-small.jpg\";s:12:\"tmpl_created\";i:1647762620;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-subscription-nutritionist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Food\",\"Health\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:45;a:20:{s:4:\"tmpl\";i:1328;s:2:\"id\";i:22833;s:5:\"title\";s:40:\"Classic | Subscription | App &#038; SaaS\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/app-70-small.jpg\";s:12:\"tmpl_created\";i:1647762955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-subscription-app-saas/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:14:\"[\"App\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:46;a:20:{s:4:\"tmpl\";i:1329;s:2:\"id\";i:22844;s:5:\"title\";s:41:\"Bottom Bar | Discount | Handmade Cupcakes\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/72-Handmade-Cupcakes-Discount.jpg\";s:12:\"tmpl_created\";i:1647763350;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/bottom-bar-discount-handmade-cupcakes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:21:\"[\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:47;a:20:{s:4:\"tmpl\";i:1330;s:2:\"id\";i:22855;s:5:\"title\";s:40:\"Bottom Bar | Subscription | Fashion Blog\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fashion-blog-75-small.jpg\";s:12:\"tmpl_created\";i:1647763907;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/bottom-bar-subscription-fashion-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:30:\"[\"Blog\",\"Fashion\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:48;a:20:{s:4:\"tmpl\";i:1331;s:2:\"id\";i:22866;s:5:\"title\";s:28:\"Fly-In | CTA | Private Tutor\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-77-small.jpg\";s:12:\"tmpl_created\";i:1647764062;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-cta-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:49;a:20:{s:4:\"tmpl\";i:1332;s:2:\"id\";i:22876;s:5:\"title\";s:30:\"Classic | CTA | Tennis Academy\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/78-Tennis-Academy-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765192;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-tennis-academy/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:50;a:20:{s:4:\"tmpl\";i:1333;s:2:\"id\";i:22887;s:5:\"title\";s:31:\"Fly-In | CTA | Shared Workspace\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/shared-workspace-79-small.jpg\";s:12:\"tmpl_created\";i:1647765419;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-cta-shared-workspace/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Business\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:51;a:20:{s:4:\"tmpl\";i:1334;s:2:\"id\";i:22899;s:5:\"title\";s:30:\"Bottom Bar | CTA | Art Gallery\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/80-Art-Gallery-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647765652;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/bottom-bar-cta-art-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:13:\"[\"Art\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:52;a:20:{s:4:\"tmpl\";i:1335;s:2:\"id\";i:22910;s:5:\"title\";s:44:\"Fly-In | Subscription | Hiking Tours Company\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/hiking-tours-company-81-small.jpg\";s:12:\"tmpl_created\";i:1647765835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscription-hiking-tours-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:29:\"[\"Subscribe\",\"Travel\",\"Trip\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:53;a:20:{s:4:\"tmpl\";i:1336;s:2:\"id\";i:22921;s:5:\"title\";s:26:\"Classic | CTA | Music Band\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/music-band-82-small.jpg\";s:12:\"tmpl_created\";i:1647769462;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/classic-cta-music-band/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Marketing\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:54;a:20:{s:4:\"tmpl\";i:1337;s:2:\"id\";i:22935;s:5:\"title\";s:35:\"Classic | CTA | Computer Technician\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/comuter-technician-83-small.jpg\";s:12:\"tmpl_created\";i:1647769843;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-computer-technician/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"cta\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:55;a:20:{s:4:\"tmpl\";i:1338;s:2:\"id\";i:22945;s:5:\"title\";s:37:\"Classic | Discount | Delivery Company\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/delivery-company-88-small.jpg\";s:12:\"tmpl_created\";i:1647770834;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-discount-delivery-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Discount\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:56;a:20:{s:4:\"tmpl\";i:1339;s:2:\"id\";i:22959;s:5:\"title\";s:29:\"Classic | Discount | Eco Shop\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/echo-shop-89-small.jpg\";s:12:\"tmpl_created\";i:1647771211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-discount-eco-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Discount\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:57;a:20:{s:4:\"tmpl\";i:1340;s:2:\"id\";i:22972;s:5:\"title\";s:54:\"Fly-In | Subscription | Health &#038; Mindfulness Blog\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small.jpg\";s:12:\"tmpl_created\";i:1647771461;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/fly-in-subscription-health-mindfulness-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:21:\"[\"Health\",\"Magazine\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:58;a:20:{s:4:\"tmpl\";i:1341;s:2:\"id\";i:22982;s:5:\"title\";s:31:\"Full Screen | Menu | Art Museum\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/art-museum-112-small.jpg\";s:12:\"tmpl_created\";i:1647771938;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/full-screen-menu-art-museum/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:59;a:20:{s:4:\"tmpl\";i:1342;s:2:\"id\";i:22992;s:5:\"title\";s:40:\"Classic | Discount | Urban Clothing Shop\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/health-blog-91-small-1.jpg\";s:12:\"tmpl_created\";i:1647773067;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-urban-clothing-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Discount\",\"Ecommerce\",\"Fashion\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:60;a:20:{s:4:\"tmpl\";i:1343;s:2:\"id\";i:23004;s:5:\"title\";s:60:\"Full Screen | Menu | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small-1.jpg\";s:12:\"tmpl_created\";i:1647773366;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:155:\"https://library.elementor.com/popups/full-screen-menu-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:61;a:20:{s:4:\"tmpl\";i:1344;s:2:\"id\";i:23015;s:5:\"title\";s:62:\"Bottom Bar | Contact | Digital &#038; Technology Design School\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-design-tech-school-small.jpg\";s:12:\"tmpl_created\";i:1647773492;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/popups/bottom-bar-contact-digital-technology-design-school/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:23:\"[\"Contact\",\"Portfolio\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:62;a:20:{s:4:\"tmpl\";i:1345;s:2:\"id\";i:23025;s:5:\"title\";s:32:\"Full Screen | Menu | Flower Shop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small.jpg\";s:12:\"tmpl_created\";i:1647773820;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/full-screen-menu-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:63;a:20:{s:4:\"tmpl\";i:1346;s:2:\"id\";i:23037;s:5:\"title\";s:36:\"Classic | Subscription | Flower Shop\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/flower-shop-small-1.jpg\";s:12:\"tmpl_created\";i:1647773949;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-flower-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Discount\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:64;a:20:{s:4:\"tmpl\";i:1347;s:2:\"id\";i:23056;s:5:\"title\";s:48:\"Classic | Discount | Health &#038; Fitness eBook\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small-1.jpg\";s:12:\"tmpl_created\";i:1647774468;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/classic-discount-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:65;a:20:{s:4:\"tmpl\";i:1348;s:2:\"id\";i:23067;s:5:\"title\";s:37:\"Fly-In | Menu | Baby Sleep Consultant\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small-1.jpg\";s:12:\"tmpl_created\";i:1647778954;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/popups/baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:66;a:20:{s:4:\"tmpl\";i:1349;s:2:\"id\";i:23077;s:5:\"title\";s:46:\"Classic | Subscription | Baby Sleep Consultant\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/baby-sleep-consultant-small.jpg\";s:12:\"tmpl_created\";i:1647779074;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/classic-subscription-baby-sleep-consultant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:12:\"[\"Discount\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:67;a:20:{s:4:\"tmpl\";i:1350;s:2:\"id\";i:23090;s:5:\"title\";s:33:\"Full Screen | Menu | Luxury Hotel\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small.jpg\";s:12:\"tmpl_created\";i:1647779390;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/full-screen-menu-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:68;a:20:{s:4:\"tmpl\";i:1351;s:2:\"id\";i:23100;s:5:\"title\";s:31:\"Fly-In | Booking | Luxury Hotel\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/luxury-hotel-small-1.jpg\";s:12:\"tmpl_created\";i:1647779500;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-booking-luxury-hotel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Booking\",\"Travel\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:69;a:20:{s:4:\"tmpl\";i:1352;s:2:\"id\";i:23109;s:5:\"title\";s:38:\"Full Screen | Menu | Design Conference\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small.jpg\";s:12:\"tmpl_created\";i:1647779675;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-menu-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:70;a:20:{s:4:\"tmpl\";i:1353;s:2:\"id\";i:23120;s:5:\"title\";s:41:\"Full Screen | Booking | Design Conference\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/design-conference-35-small-1.jpg\";s:12:\"tmpl_created\";i:1647779793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:143:\"https://library.elementor.com/popups/full-screen-booking-design-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:35:\"[\"Booking\",\"Conference\",\"Creative\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:71;a:20:{s:4:\"tmpl\";i:1354;s:2:\"id\";i:23129;s:5:\"title\";s:29:\"Slide-In | Menu | VR Headsets\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small.jpg\";s:12:\"tmpl_created\";i:1647781211;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/slide-in-menu-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:72;a:20:{s:4:\"tmpl\";i:1355;s:2:\"id\";i:23139;s:5:\"title\";s:31:\"Classic | Contact | VR Headsets\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/VR-headset-small-1.jpg\";s:12:\"tmpl_created\";i:1647781384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-contact-vr-headsets/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:73;a:20:{s:4:\"tmpl\";i:1356;s:2:\"id\";i:23149;s:5:\"title\";s:38:\"Slide-In | Menu | Portrait Photography\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Menu.jpg\";s:12:\"tmpl_created\";i:1647782336;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/slide-in-menu-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:74;a:20:{s:4:\"tmpl\";i:1357;s:2:\"id\";i:23159;s:5:\"title\";s:47:\"Hello Bar | Subscription | Portrait Photography\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2022/03/48-portrair-photography-Subscription.jpg\";s:12:\"tmpl_created\";i:1647782478;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:149:\"https://library.elementor.com/popups/hello-bar-subscription-portrait-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Blog\",\"Photography\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:75;a:20:{s:4:\"tmpl\";i:1358;s:2:\"id\";i:23169;s:5:\"title\";s:32:\"Full Screen | Menu | English Pub\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Menu.jpg\";s:12:\"tmpl_created\";i:1647782664;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/full-screen-menu-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:76;a:20:{s:4:\"tmpl\";i:1359;s:2:\"id\";i:23179;s:5:\"title\";s:32:\"Classic | Discount | English Pub\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/49-englisg-pub-Discount.jpg\";s:12:\"tmpl_created\";i:1647782796;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-discount-english-pub/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:20:\"[\"Discount\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:77;a:20:{s:4:\"tmpl\";i:1360;s:2:\"id\";i:23189;s:5:\"title\";s:27:\"Full Screen | Menu | Singer\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Menu.jpg\";s:12:\"tmpl_created\";i:1647783070;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/full-screen-menu-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:29:\"[\"Fullscreen\",\"menu\",\"Music\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:78;a:20:{s:4:\"tmpl\";i:1361;s:2:\"id\";i:23200;s:5:\"title\";s:31:\"Classic | Subscription | Singer\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2022/03/58-Music-Artist-Subscription.jpg\";s:12:\"tmpl_created\";i:1647783249;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-subscription-singer/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Music\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:79;a:20:{s:4:\"tmpl\";i:1362;s:2:\"id\";i:23210;s:5:\"title\";s:38:\"Full Screen | Menu | Virtual Assistant\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistnt-73-small.jpg\";s:12:\"tmpl_created\";i:1647784292;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-menu-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:80;a:20:{s:4:\"tmpl\";i:1363;s:2:\"id\";i:23223;s:5:\"title\";s:39:\"Hello Bar | Contact | Virtual Assistant\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/73-Virtual-Assistant-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647784616;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-contact-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:37:\"[\"Contact\",\"Psychologist\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:81;a:20:{s:4:\"tmpl\";i:1364;s:2:\"id\";i:23234;s:5:\"title\";s:32:\"Slide-In  | Menu | Personal Chef\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Menu.jpg\";s:12:\"tmpl_created\";i:1647798194;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/slide-in-menu-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:8:\"[\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:82;a:20:{s:4:\"tmpl\";i:1365;s:2:\"id\";i:23244;s:5:\"title\";s:29:\"Classic | CTA | Personal Chef\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/74-Personal-Chef-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647798297;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-personal-chef/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:24:\"[\"Booking\",\"Chef\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:83;a:20:{s:4:\"tmpl\";i:1366;s:2:\"id\";i:23254;s:5:\"title\";s:31:\"Full Screen | Menu | Food Truck\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small-1.jpg\";s:12:\"tmpl_created\";i:1647798447;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/full-screen-menu-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:84;a:20:{s:4:\"tmpl\";i:1367;s:2:\"id\";i:23265;s:5:\"title\";s:30:\"Fly-In | Discount | Food Truck\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/food-truck-76-small.jpg\";s:12:\"tmpl_created\";i:1647798657;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-discount-food-truck/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Discount\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:85;a:20:{s:4:\"tmpl\";i:1369;s:2:\"id\";i:23323;s:5:\"title\";s:28:\"Classic | CTA | Black Friday\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-6-Small.jpg\";s:12:\"tmpl_created\";i:1647855505;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:86;a:20:{s:4:\"tmpl\";i:1370;s:2:\"id\";i:23329;s:5:\"title\";s:29:\"Slide-In | CTA | Black Friday\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-5-Small.jpg\";s:12:\"tmpl_created\";i:1647855865;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/slide-in-cta-black-friday/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:87;a:20:{s:4:\"tmpl\";i:1371;s:2:\"id\";i:23335;s:5:\"title\";s:31:\"Slide-In | CTA | Black Friday 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-1-Small.jpg\";s:12:\"tmpl_created\";i:1647856357;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/slide-in-cta-black-friday-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:88;a:20:{s:4:\"tmpl\";i:1372;s:2:\"id\";i:23341;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-3-Small.jpg\";s:12:\"tmpl_created\";i:1647856493;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:89;a:20:{s:4:\"tmpl\";i:1373;s:2:\"id\";i:23347;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-2-Small.jpg\";s:12:\"tmpl_created\";i:1647856891;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:90;a:20:{s:4:\"tmpl\";i:1374;s:2:\"id\";i:23354;s:5:\"title\";s:30:\"Classic | CTA | Black Friday 4\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/Black-Friday-4-Small.jpg\";s:12:\"tmpl_created\";i:1647856996;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-black-friday-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Black Friday\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:91;a:20:{s:4:\"tmpl\";i:1375;s:2:\"id\";i:23394;s:5:\"title\";s:27:\"Classic | CTA | Halloween 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-3-Small.jpg\";s:12:\"tmpl_created\";i:1647857351;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/classic-cta-halloween-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:31:\"[\"cta\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:92;a:20:{s:4:\"tmpl\";i:1376;s:2:\"id\";i:23401;s:5:\"title\";s:33:\"Slide-In | Discount | Halloween 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-2-Small.jpg\";s:12:\"tmpl_created\";i:1647857567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-halloween-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:36:\"[\"Discount\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:93;a:20:{s:4:\"tmpl\";i:1377;s:2:\"id\";i:23407;s:5:\"title\";s:33:\"Slide-In | Discount | Halloween 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-1-Small.jpg\";s:12:\"tmpl_created\";i:1647857814;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-halloween-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:36:\"[\"Discount\",\"Ecommerce\",\"Halloween\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:94;a:20:{s:4:\"tmpl\";i:1378;s:2:\"id\";i:23416;s:5:\"title\";s:31:\"Fly-In | Discount | Halloween 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-5-Small.jpg\";s:12:\"tmpl_created\";i:1647858024;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-discount-halloween-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:44:\"[\"Discount\",\"Ecommerce\",\"Halloween\",\"Offer\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:95;a:20:{s:4:\"tmpl\";i:1379;s:2:\"id\";i:23422;s:5:\"title\";s:36:\"Classic | Subscription | Halloween 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Halloween-4-Small.jpg\";s:12:\"tmpl_created\";i:1647858246;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-subscription-halloween-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:48:\"[\"Discount\",\"Ecommerce\",\"Halloween\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:96;a:20:{s:4:\"tmpl\";i:1380;s:2:\"id\";i:23471;s:5:\"title\";s:28:\"Slide-In | CTA | Christmas 1\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-2-Small.jpg\";s:12:\"tmpl_created\";i:1647859193;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-cta-christmas-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Christmas\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:97;a:20:{s:4:\"tmpl\";i:1381;s:2:\"id\";i:23477;s:5:\"title\";s:28:\"Slide-In | CTA | Christmas 2\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-4-Small.jpg\";s:12:\"tmpl_created\";i:1647859838;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/slide-in-cta-christmas-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Christmas\",\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:98;a:20:{s:4:\"tmpl\";i:1382;s:2:\"id\";i:23483;s:5:\"title\";s:26:\"Fly-In | CTA | Christmas 3\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-1-Small.jpg\";s:12:\"tmpl_created\";i:1647860157;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/popups/fly-in-cta-christmas-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:31:\"[\"Christmas\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:99;a:20:{s:4:\"tmpl\";i:1383;s:2:\"id\";i:23489;s:5:\"title\";s:33:\"Slide-In | Discount | Christmas 4\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-5-Small.jpg\";s:12:\"tmpl_created\";i:1647860302;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-discount-christmas-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:31:\"[\"Christmas\",\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:100;a:20:{s:4:\"tmpl\";i:1384;s:2:\"id\";i:23496;s:5:\"title\";s:32:\"Classic | Discount | Christmas 5\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/Christmas-3-Small.jpg\";s:12:\"tmpl_created\";i:1647860454;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-discount-christmas-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Christmas\",\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:101;a:20:{s:4:\"tmpl\";i:1385;s:2:\"id\";i:23523;s:5:\"title\";s:30:\"Classic | CTA | Valentines Day\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-2-Small.jpg\";s:12:\"tmpl_created\";i:1647860912;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-cta-valentines-day/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"cta\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:102;a:20:{s:4:\"tmpl\";i:1386;s:2:\"id\";i:23529;s:5:\"title\";s:39:\"Hello Bar | Discount | Valentines Day 2\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-1-Small.jpg\";s:12:\"tmpl_created\";i:1647861064;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-discount-valentines-day-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:30:\"[\"Discount\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:103;a:20:{s:4:\"tmpl\";i:1387;s:2:\"id\";i:23536;s:5:\"title\";s:32:\"Classic | CTA | Valentines Day 3\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/03/Valentines-Day-3-Small.jpg\";s:12:\"tmpl_created\";i:1647861536;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-cta-valentines-day-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"cta\",\"Valentine\'s Day\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:104;a:20:{s:4:\"tmpl\";i:1388;s:2:\"id\";i:23586;s:5:\"title\";s:51:\"Fly-In | Subscribe | Health &#038; Wellness Company\";s:9:\"thumbnail\";s:103:\"https://library.elementor.com/wp-content/uploads/2022/03/35-Subscribe-Health-Wellness-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647862008;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/fly-in-subscribe-health-wellness-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:24:\"[\"Business\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:105;a:20:{s:4:\"tmpl\";i:1389;s:2:\"id\";i:23592;s:5:\"title\";s:34:\"Classic | Subscribe | Tech Company\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/36-Subscribe-Tech-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647866706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-subscribe-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"Marketing\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:106;a:20:{s:4:\"tmpl\";i:1390;s:2:\"id\";i:23598;s:5:\"title\";s:36:\"Classic | Contact Us | Fight Classes\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2022/03/37-Contact-Us-Fight-Classes-Small.jpg\";s:12:\"tmpl_created\";i:1647866869;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-contact-us-fight-classes/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:107;a:20:{s:4:\"tmpl\";i:1391;s:2:\"id\";i:23611;s:5:\"title\";s:31:\"Classic | CTA | Mochi Shop Sale\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2022/03/39-Click-Through-Mochi-Shop-Sale-Small.jpg\";s:12:\"tmpl_created\";i:1647867750;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-cta-mochi-shop-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:23:\"[\"cta\",\"Offer\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:108;a:20:{s:4:\"tmpl\";i:1392;s:2:\"id\";i:23618;s:5:\"title\";s:28:\"Classic | CTA | Fashion Shop\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2022/03/40-Click-Through-Fashion-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1647868251;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-cta-fashion-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"cta\",\"Ecommerce\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:109;a:20:{s:4:\"tmpl\";i:1393;s:2:\"id\";i:23624;s:5:\"title\";s:29:\"Fly-In | Login | Tech Company\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/41-Login-Tech-Company-Small.jpg\";s:12:\"tmpl_created\";i:1647868704;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/fly-in-login-tech-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:9:\"[\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:110;a:20:{s:4:\"tmpl\";i:1394;s:2:\"id\";i:23630;s:5:\"title\";s:36:\"Fly-In | Verification | Liquor Store\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/42-Verification-Liquor-Store-Small.jpg\";s:12:\"tmpl_created\";i:1647870308;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/fly-in-verification-liquor-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:16:\"[\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:111;a:20:{s:4:\"tmpl\";i:1395;s:2:\"id\";i:23636;s:5:\"title\";s:39:\"Hello Bar | Subscribe | Online Magazine\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2022/03/44-Subscribe-Online-Magazine-Small.jpg\";s:12:\"tmpl_created\";i:1647870465;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/hello-bar-subscribe-online-magazine/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:20:\"[\"Blog\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:112;a:20:{s:4:\"tmpl\";i:1396;s:2:\"id\";i:23642;s:5:\"title\";s:27:\"Fly-In | Login | Health Spa\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/03/43-Login-Health-Spa-Small.jpg\";s:12:\"tmpl_created\";i:1647872427;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/fly-in-login-health-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:20:\"[\"Login\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:113;a:20:{s:4:\"tmpl\";i:1397;s:2:\"id\";i:23648;s:5:\"title\";s:33:\"Fly-In | Verification | Wine Shop\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/03/45-Verification-Wine-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1647872627;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/fly-in-verification-wine-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:16:\"[\"Verification\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:114;a:20:{s:4:\"tmpl\";i:1421;s:2:\"id\";i:24235;s:5:\"title\";s:24:\"Ladydog Club &#8211; NFT\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/05/Ladydog_Club.jpg\";s:12:\"tmpl_created\";i:1651525072;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/ladydog-club-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:115;a:20:{s:4:\"tmpl\";i:1422;s:2:\"id\";i:24166;s:5:\"title\";s:15:\"Dot &#8211; NFT\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2022/05/Dot-250_280.jpg\";s:12:\"tmpl_created\";i:1651525117;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:109:\"https://library.elementor.com/lp/dot-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:116;a:20:{s:4:\"tmpl\";i:1423;s:2:\"id\";i:24191;s:5:\"title\";s:28:\"Cosmic Neighbors &#8211; NFT\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Cosmic_Neighbors-250_280.jpg\";s:12:\"tmpl_created\";i:1651525124;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/cosmic-neighbors-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:117;a:20:{s:4:\"tmpl\";i:1424;s:2:\"id\";i:24255;s:5:\"title\";s:30:\"Happy Food Friends &#8211; NFT\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/05/Featured_Image.jpg\";s:12:\"tmpl_created\";i:1651525475;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/happy-food-friends-nft/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:3:\"NFT\";s:4:\"tags\";s:100:\"[\"Art\",\"Author\",\"Business\",\"Creative\",\"Design\",\"Gallery\",\"Landing Pages\",\"NFT\",\"Products\",\"Virtual\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:118;a:20:{s:4:\"tmpl\";i:1443;s:2:\"id\";i:24599;s:5:\"title\";s:27:\"Wireframe &#8211; Courses 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Courses-1.jpg\";s:12:\"tmpl_created\";i:1653989626;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/wireframe-courses-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:180:\"[\"About\",\"Academy\",\"Booking\",\"Business\",\"Course Online\",\"Features\",\"Footer\",\"Landing Pages\",\"Online Service\",\"Professional\",\"School\",\"Services\",\"Subscribe\",\"Teacher\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:119;a:20:{s:4:\"tmpl\";i:1444;s:2:\"id\";i:24614;s:5:\"title\";s:28:\"Wireframe &#8211; Services 1\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1-2.jpg\";s:12:\"tmpl_created\";i:1653990084;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:139:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Form\",\"Header\",\"Landing Pages\",\"Online Service\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:120;a:20:{s:4:\"tmpl\";i:1445;s:2:\"id\";i:24629;s:5:\"title\";s:28:\"Wireframe &#8211; Services 2\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-2-2.jpg\";s:12:\"tmpl_created\";i:1653990132;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:123:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Form\",\"Gallery\",\"Landing Pages\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:121;a:20:{s:4:\"tmpl\";i:1446;s:2:\"id\";i:24644;s:5:\"title\";s:27:\"Wireframe &#8211; Webinar 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Webinar-1.jpg\";s:12:\"tmpl_created\";i:1653990164;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/wireframe-webinar-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:177:\"[\"About\",\"Academy\",\"Booking\",\"Conference\",\"Course Online\",\"Education\",\"Features\",\"Footer\",\"Form\",\"Landing Pages\",\"Online Event\",\"Online Service\",\"Subscribe\",\"Virtual\",\"Webinar\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:122;a:20:{s:4:\"tmpl\";i:1447;s:2:\"id\";i:24655;s:5:\"title\";s:28:\"Wireframe &#8211; Services 3\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-3-2.jpg\";s:12:\"tmpl_created\";i:1653990198;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:143:\"[\"About\",\"Agency\",\"Business\",\"Contact\",\"Footer\",\"Form\",\"Gallery\",\"Landing Pages\",\"Portfolio\",\"Professional\",\"Project\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:123;a:20:{s:4:\"tmpl\";i:1448;s:2:\"id\";i:24677;s:5:\"title\";s:28:\"Wireframe &#8211; Services 4\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-4.jpg\";s:12:\"tmpl_created\";i:1653990233;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:102:\"[\"About\",\"Business\",\"Contact\",\"Footer\",\"Form\",\"Landing Pages\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:124;a:20:{s:4:\"tmpl\";i:1449;s:2:\"id\";i:24687;s:5:\"title\";s:28:\"Wireframe &#8211; Products 1\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Products-1.jpg\";s:12:\"tmpl_created\";i:1653990273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-products-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:128:\"[\"About\",\"Booking\",\"Business\",\"Clients\",\"Ecommerce\",\"Features\",\"Footer\",\"Landing Pages\",\"Products\",\"Sales\",\"Shop\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:125;a:20:{s:4:\"tmpl\";i:1450;s:2:\"id\";i:24706;s:5:\"title\";s:28:\"Wireframe &#8211; Services 5\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-5.jpg\";s:12:\"tmpl_created\";i:1653990322;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/wireframe-services-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Wireframe\";s:4:\"tags\";s:149:\"[\"About\",\"Booking\",\"Consulting\",\"Contact\",\"Doctor\",\"Footer\",\"Form\",\"Header\",\"Landing Pages\",\"Online Service\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:126;a:20:{s:4:\"tmpl\";i:1451;s:2:\"id\";i:23604;s:5:\"title\";s:38:\"Classic | Subscribe | Nail Polish Shop\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2022/03/38-Subscribe-Nail-Polish-Shop-Small.jpg\";s:12:\"tmpl_created\";i:1660205114;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/classic-subscribe-nail-polish-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:20:\"[\"Blog\",\"Subscribe\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:127;a:20:{s:4:\"tmpl\";i:1452;s:2:\"id\";i:23047;s:5:\"title\";s:46:\"Fly-In | Contact | Health &#038; Fitness eBook\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/fitness-ebook-small.jpg\";s:12:\"tmpl_created\";i:1660205149;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/fly-in-contact-health-fitness-ebook/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Contact\",\"Ebook\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:128;a:20:{s:4:\"tmpl\";i:1199;s:2:\"id\";i:18839;s:5:\"title\";s:27:\"Hello Bar | CTA | eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/05/350x250.png\";s:12:\"tmpl_created\";i:1621870603;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/popups/hello-bar-cta-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:41:\"[\"Ecommerce\",\"Online Shop\",\"Sale\",\"Shop\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:129;a:20:{s:4:\"tmpl\";i:1247;s:2:\"id\";i:21907;s:5:\"title\";s:50:\"Fly-In | Team Details  | Electronic Music Festival\";s:9:\"thumbnail\";s:104:\"https://library.elementor.com/wp-content/uploads/2022/03/Kit-8-electronic-music-festival-CTA-image-1.jpg\";s:12:\"tmpl_created\";i:1646660881;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:157:\"https://library.elementor.com/popups/fly-in-team-details-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:8:\"[\"Team\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:130;a:20:{s:4:\"tmpl\";i:1253;s:2:\"id\";i:22162;s:5:\"title\";s:46:\"Full Screen | Menu | Electronic Music Festival\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/03/8-music-festival-Team-Details.jpg\";s:12:\"tmpl_created\";i:1647272934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:154:\"https://library.elementor.com/popups/full-screen-menu-popup-electronic-music-festival/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:21:\"[\"Fullscreen\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:131;a:20:{s:4:\"tmpl\";i:1254;s:2:\"id\";i:22172;s:5:\"title\";s:45:\"Classic | Discount | Health &#038; Beauty Spa\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/health-beauty-spa-small.jpg\";s:12:\"tmpl_created\";i:1647273547;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/classic-discount-popup-health-beauty-spa/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:36:\"[\"Hair\",\"Health\",\"Sales\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:132;a:20:{s:4:\"tmpl\";i:1255;s:2:\"id\";i:22183;s:5:\"title\";s:44:\"Hello Bar | CTA | Environmental Organization\";s:9:\"thumbnail\";s:104:\"https://library.elementor.com/wp-content/uploads/2022/03/11-Environmental-Organization-Click-Through.jpg\";s:12:\"tmpl_created\";i:1647274384;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:152:\"https://library.elementor.com/popups/hello-bar-cta-popup-environmental-organization/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:7:\"[\"cta\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:133;a:20:{s:4:\"tmpl\";i:1256;s:2:\"id\";i:22195;s:5:\"title\";s:39:\"Classic | Discount | Italian Restaurant\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/restaurant-small.jpg\";s:12:\"tmpl_created\";i:1647329432;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:147:\"https://library.elementor.com/popups/classic-discount-popup-italian-restaurant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:22:\"[\"Restaurant\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:134;a:20:{s:4:\"tmpl\";i:1257;s:2:\"id\";i:22210;s:5:\"title\";s:45:\"Bottom Bar | Discount | Technology Conference\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/tech-conference-small.jpg\";s:12:\"tmpl_created\";i:1647330423;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:153:\"https://library.elementor.com/popups/bottom-bar-discount-popup-technology-conference/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:38:\"[\"Conference\",\"Sales\",\"Save the Date\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:135;a:20:{s:4:\"tmpl\";i:1258;s:2:\"id\";i:22221;s:5:\"title\";s:32:\"Hello Bar | Menu | Tattoo Studio\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small-1.jpg\";s:12:\"tmpl_created\";i:1647330705;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/hello-bar-menu-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:17:\"[\"Header\",\"menu\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:136;a:20:{s:4:\"tmpl\";i:1259;s:2:\"id\";i:22231;s:5:\"title\";s:37:\"Full Screen | Booking | Tattoo Studio\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/tattoo-studio-small.jpg\";s:12:\"tmpl_created\";i:1647331823;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-booking-popup-tattoo-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:32:\"[\"Booking\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:137;a:20:{s:4:\"tmpl\";i:1260;s:2:\"id\";i:22251;s:5:\"title\";s:34:\"Classic | Discount | Dental Clinic\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/dental-clinic-small.jpg\";s:12:\"tmpl_created\";i:1647332171;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-discount-popup-dental-clinic/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:30:\"[\"Health\",\"Marketing\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:138;a:20:{s:4:\"tmpl\";i:1261;s:2:\"id\";i:22261;s:5:\"title\";s:34:\"Slide-In | Contact | Makeup Artist\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/03/20-Makeup-Artist-Contact-Us.jpg\";s:12:\"tmpl_created\";i:1647333946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/slide-in-contact-popup-makeup-artist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:139;a:20:{s:4:\"tmpl\";i:1262;s:2:\"id\";i:22271;s:5:\"title\";s:24:\"Fly-In | CTA | Headphone\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/03/headphones-1-small.jpg\";s:12:\"tmpl_created\";i:1647334784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/fly-in-cta-popup-headphone/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:41:\"[\"cta\",\"Ecommerce\",\"Marketing\",\"Product\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:140;a:20:{s:4:\"tmpl\";i:1263;s:2:\"id\";i:22277;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/online-course-2.jpg\";s:12:\"tmpl_created\";i:1647337110;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/classic-cta-popup-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:35:\"[\"Course Online\",\"cta\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:141;a:20:{s:4:\"tmpl\";i:1264;s:2:\"id\";i:22283;s:5:\"title\";s:40:\"Bottom Bar | Contact | Virtual Assistant\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/03/virtual-assistant-3.jpg\";s:12:\"tmpl_created\";i:1647337517;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:148:\"https://library.elementor.com/popups/bottom-bar-contact-popup-virtual-assistant/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:10:\"bottom bar\";s:4:\"tags\";s:33:\"[\"Business\",\"Contact\",\"Services\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:142;a:20:{s:4:\"tmpl\";i:1265;s:2:\"id\";i:22289;s:5:\"title\";s:32:\"Fly-In | Contact | Private Tutor\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/private-tutor-4.jpg\";s:12:\"tmpl_created\";i:1647337676;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/fly-in-contact-popup-private-tutor/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:27:\"[\"Contact\",\"Course Online\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:143;a:20:{s:4:\"tmpl\";i:1266;s:2:\"id\";i:22295;s:5:\"title\";s:31:\"Classic |  Login | Login Travel\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/login-travel-6.jpg\";s:12:\"tmpl_created\";i:1647339467;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-login-popup-login-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:9:\"[\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:144;a:20:{s:4:\"tmpl\";i:1267;s:2:\"id\";i:22301;s:5:\"title\";s:36:\"Full Screen | Login | Login Business\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/login-business-7.jpg\";s:12:\"tmpl_created\";i:1647339782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/full-screen-login-popup-login-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:16:\"[\"Login\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:145;a:20:{s:4:\"tmpl\";i:1268;s:2:\"id\";i:22307;s:5:\"title\";s:28:\"Classic | Login | Login Blog\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2022/03/login-blog-8.jpg\";s:12:\"tmpl_created\";i:1647339986;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/classic-login-popup-login-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Blog\",\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:146;a:20:{s:4:\"tmpl\";i:1269;s:2:\"id\";i:22313;s:5:\"title\";s:31:\"Classic | Login | Login Fashion\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2022/03/login-fashion-9.jpg\";s:12:\"tmpl_created\";i:1647340204;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/classic-login-popup-login-fashion/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Fashion\",\"Login\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:147;a:20:{s:4:\"tmpl\";i:1270;s:2:\"id\";i:22319;s:5:\"title\";s:40:\"Classic |  Login | Login Design Platform\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/03/login-design-platform-10.jpg\";s:12:\"tmpl_created\";i:1647340531;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:147:\"https://library.elementor.com/popups/classic-login-popup-login-design-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:25:\"[\"Design\",\"Login\",\"SaaS\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:148;a:20:{s:4:\"tmpl\";i:1271;s:2:\"id\";i:22325;s:5:\"title\";s:36:\"Fly-In | Contact | Digital Marketing\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/03/digital-marketing-11.jpg\";s:12:\"tmpl_created\";i:1647340770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/fly-in-contact-popup-digital-marketing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:51:\"[\"Business\",\"Contact\",\"Digital Agency\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:149;a:20:{s:4:\"tmpl\";i:1272;s:2:\"id\";i:22331;s:5:\"title\";s:36:\"Fly-In | CTA | Dog Cat Food Delivery\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/dog-cat-food-delivery-5.jpg\";s:12:\"tmpl_created\";i:1647341069;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:144:\"https://library.elementor.com/popups/fly-in-cta-popup-dog-cat-food-delivery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:33:\"[\"cta\",\"Delivery Service\",\"Pets\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:150;a:20:{s:4:\"tmpl\";i:1273;s:2:\"id\";i:22337;s:5:\"title\";s:37:\"Full Screen | Contact | Design Studio\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/03/design-studio-12.jpg\";s:12:\"tmpl_created\";i:1647341370;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-contact-popup-design-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:39:\"[\"Business\",\"Contact\",\"Digital Agency\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:151;a:20:{s:4:\"tmpl\";i:1274;s:2:\"id\";i:22343;s:5:\"title\";s:44:\"Classic | Contact | Support Product Platform\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2022/03/support-13.jpg\";s:12:\"tmpl_created\";i:1647341972;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/popups/classic-contact-support-product-platform/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:21:\"[\"Contact\",\"Support\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:152;a:20:{s:4:\"tmpl\";i:1275;s:2:\"id\";i:22371;s:5:\"title\";s:38:\"Full Screen | Contact | Small Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/03/small-business-14.jpg\";s:12:\"tmpl_created\";i:1647342508;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:140:\"https://library.elementor.com/popups/full-screen-contact-small-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:40:\"[\"Business\",\"Contact\",\"Interior Design\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:153;a:20:{s:4:\"tmpl\";i:1276;s:2:\"id\";i:22377;s:5:\"title\";s:31:\"Classic | Contact | Online Shop\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2022/03/online-shop-15.jpg\";s:12:\"tmpl_created\";i:1647352786;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/classic-contact-online-shop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:11:\"[\"Contact\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:154;a:20:{s:4:\"tmpl\";i:1277;s:2:\"id\";i:22383;s:5:\"title\";s:40:\"Classic | Booking | Children Optometrist\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/03/children-optometrist-16.jpg\";s:12:\"tmpl_created\";i:1647352963;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:142:\"https://library.elementor.com/popups/classic-booking-children-optometrist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:53:\"[\"Booking\",\"Business\",\"Contact\",\"Education\",\"Health\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:155;a:20:{s:4:\"tmpl\";i:1278;s:2:\"id\";i:22389;s:5:\"title\";s:28:\"Fly-In | Contact | Open Week\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2022/03/open-week17.jpg\";s:12:\"tmpl_created\";i:1647353281;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/fly-in-contact-open-week/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:34:\"[\"Business\",\"Contact\",\"Marketing\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:156;a:20:{s:4:\"tmpl\";i:1279;s:2:\"id\";i:22397;s:5:\"title\";s:43:\"Full Screen | CTA | Plant Pots Online Store\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2022/03/plant-pots-online-store-18.jpg\";s:12:\"tmpl_created\";i:1647353429;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/popups/full-screen-cta-plant-pots-online-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:33:\"[\"Ecommerce\",\"Marketing\",\"Sales\"]\";s:10:\"menu_order\";i:0;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:157;a:20:{s:4:\"tmpl\";i:1054;s:2:\"id\";i:15414;s:5:\"title\";s:32:\"Classic | Contact | Dance Studio\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/10/PopUp.jpg\";s:12:\"tmpl_created\";i:1603180596;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-contact-dance-studio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:16:\"[\"Dance Studio\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:762;s:11:\"trend_index\";i:650;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:158;a:20:{s:4:\"tmpl\";i:1398;s:2:\"id\";i:23687;s:5:\"title\";s:32:\"Pizza Promotion &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/48-Pizza-Promotion.jpg\";s:12:\"tmpl_created\";i:1649670575;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/pizza-promotion-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:92:\"[\"Business\",\"Cooking\",\"Delivery\",\"Discount\",\"Fast Food\",\"Food\",\"Landing Pages\",\"Restaurant\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:159;a:20:{s:4:\"tmpl\";i:1400;s:2:\"id\";i:23751;s:5:\"title\";s:33:\"Baby Sleep Webinar &#8211; Events\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/63-Baby-Sleep-Webinar.jpg\";s:12:\"tmpl_created\";i:1649676065;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/baby-sleep-webinar-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:227:\"[\"Baby\",\"Booking\",\"Business\",\"Children\",\"Course Online\",\"Education\",\"Events\",\"Health\",\"Landing Pages\",\"Life Coach\",\"Lifestyle\",\"Online Event\",\"Online Service\",\"Parenting\",\"Professional\",\"Remote\",\"Services\",\"Training\",\"Webinar\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:160;a:20:{s:4:\"tmpl\";i:1401;s:2:\"id\";i:23776;s:5:\"title\";s:34:\"Ski Hotel Promotion &#8211; Travel\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2022/04/64-Ski-Hotel-Promotion.jpg\";s:12:\"tmpl_created\";i:1649691720;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/ski-hotel-promotion-travel/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Travel\";s:4:\"tags\";s:118:\"[\"Accommodation\",\"Booking\",\"Discount. Landing Pages\",\"Lifestyle\",\"Luxury\",\"Services\",\"Spa\",\"Travel\",\"Trip\",\"Vacation\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:161;a:20:{s:4:\"tmpl\";i:1402;s:2:\"id\";i:23804;s:5:\"title\";s:30:\"Cake Delivery &#8211; Business\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2022/04/67-Cake-Delivery.jpg\";s:12:\"tmpl_created\";i:1649692909;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/cake-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:101:\"[\"Bakery\",\"Business\",\"Cake\",\"Cooking\",\"Delivery\",\"Discount\",\"Food\",\"Landing Pages\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:162;a:20:{s:4:\"tmpl\";i:1403;s:2:\"id\";i:23832;s:5:\"title\";s:32:\"Furniture Store &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/87-Furniture-Store.jpg\";s:12:\"tmpl_created\";i:1649694812;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/furniture-store-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:232:\"[\"Architecture\",\"Art\",\"Business\",\"Construction\",\"Coupon\",\"Creative\",\"Decor\",\"Designer\",\"Discount\",\"Fashion\",\"Furniture Design\",\"Home\",\"House\",\"Interior Design\",\"Landing Pages\",\"Lifestyle\",\"Products\",\"Professional\",\"Services\",\"Shop\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:163;a:20:{s:4:\"tmpl\";i:1404;s:2:\"id\";i:23746;s:5:\"title\";s:22:\"Nails &#8211; Business\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2022/04/62-Nails-1.jpg\";s:12:\"tmpl_created\";i:1649704635;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/nails-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:173:\"[\"Art\",\"Beauty\",\"Business\",\"Colorful\",\"Cosmetics\",\"Creative\",\"Design\",\"Discount\",\"Fashion\",\"Girly\",\"Landing Pages\",\"Lifestyle\",\"Manicure\",\"Modern\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:164;a:20:{s:4:\"tmpl\";i:1405;s:2:\"id\";i:23846;s:5:\"title\";s:29:\"Music Festival &#8211; Events\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2022/04/88-Music-Festival.jpg\";s:12:\"tmpl_created\";i:1649707763;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/music-festival-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:128:\"[\"Author\",\"Booking\",\"Business\",\"Creative\",\"Discount\",\"Events\",\"Landing Pages\",\"Music\",\"Online\",\"Online Event\",\"Party\",\"Virtual\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:165;a:20:{s:4:\"tmpl\";i:1406;s:2:\"id\";i:23872;s:5:\"title\";s:40:\"Fashion Styling Course &#8211; Education\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/89-Fashion-Styling-Course.jpg\";s:12:\"tmpl_created\";i:1649708569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/fashion-styling-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:173:\"[\"Aesthetic\",\"Art\",\"Beauty\",\"Business\",\"Course Online\",\"Creative\",\"Discount\",\"Education\",\"Fashion\",\"Landing Pages\",\"Lifestyle\",\"Online\",\"Online Service\",\"Stylist\",\"Virtual\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:166;a:20:{s:4:\"tmpl\";i:1407;s:2:\"id\";i:23897;s:5:\"title\";s:33:\"Bags Online Shop &#8211; Business\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2022/04/90-Bags-Online-Shop.jpg\";s:12:\"tmpl_created\";i:1649709513;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/bags-online-shop-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:170:\"[\"Art\",\"Bag\",\"Business\",\"Creative\",\"Design\",\"Discount\",\"Fashion\",\"Landing Pages\",\"Lifestyle\",\"Luxury\",\"Modern\",\"Online\",\"Online Shop\",\"Products\",\"Sales\",\"Shop\",\"Stylist\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:167;a:20:{s:4:\"tmpl\";i:1408;s:2:\"id\";i:23932;s:5:\"title\";s:32:\"Cooking Academy &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2022/04/91-Cooking-Academy.jpg\";s:12:\"tmpl_created\";i:1649710216;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/cooking-academy-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:145:\"[\"Academy\",\"Booking\",\"Business\",\"Chef\",\"Cooking\",\"Education\",\"Food\",\"Free Trial\",\"Landing Pages\",\"Professional\",\"School\",\"Teacher\",\"Testimonial\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:168;a:20:{s:4:\"tmpl\";i:1409;s:2:\"id\";i:23970;s:5:\"title\";s:45:\"Ophthalmology Medical Clinic &#8211; Business\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2022/04/92-Ophthalmology-Medical-Clinic.jpg\";s:12:\"tmpl_created\";i:1649711096;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/ophthalmology-medical-clinic-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:165:\"[\"About\",\"Business\",\"Care\",\"Consulting\",\"Eye\",\"Free Trial\",\"Glasses\",\"Health\",\"Landing Pages\",\"Lifestyle\",\"Medical\",\"Modern\",\"Optometrist\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:169;a:20:{s:4:\"tmpl\";i:1425;s:2:\"id\";i:24331;s:5:\"title\";s:24:\"Wireframe &#8211; Home 1\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-1.jpg\";s:12:\"tmpl_created\";i:1653988363;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:170;a:20:{s:4:\"tmpl\";i:1218;s:2:\"id\";i:20792;s:5:\"title\";s:26:\"Luxury Car &#8211; Product\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/11/250x280-1.jpg\";s:12:\"tmpl_created\";i:1636903770;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/lp/luxury-car-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:54:\"[\"car\",\"Ecommerce\",\"Landing Pages\",\"Luxury\",\"Product\"]\";s:10:\"menu_order\";i:1;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:171;a:20:{s:4:\"tmpl\";i:1428;s:2:\"id\";i:24398;s:5:\"title\";s:25:\"Wireframe &#8211; About 1\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-1.jpg\";s:12:\"tmpl_created\";i:1653988534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:83:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Professional\",\"Services\",\"Team\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:172;a:20:{s:4:\"tmpl\";i:991;s:2:\"id\";i:13413;s:5:\"title\";s:33:\"Classic | Contact | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Help.jpg\";s:12:\"tmpl_created\";i:1587474761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-contact-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:2;s:16:\"popularity_index\";i:530;s:11:\"trend_index\";i:369;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:173;a:20:{s:4:\"tmpl\";i:1053;s:2:\"id\";i:15272;s:5:\"title\";s:32:\"Classic | Contact | Psychologist\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/09/PopUp.png\";s:12:\"tmpl_created\";i:1600170487;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/classic-contact-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:578;s:11:\"trend_index\";i:312;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:174;a:20:{s:4:\"tmpl\";i:899;s:2:\"id\";i:11839;s:5:\"title\";s:9:\"Portfolio\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/09/Header_small.png\";s:12:\"tmpl_created\";i:1569430015;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:108:\"https://library.elementor.com/blocks/portfolio-9/?utm_source=library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"header\";s:4:\"tags\";s:43:\"[\"creative portfolio\",\"header\",\"portfolio\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:189;s:11:\"trend_index\";i:20;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:175;a:20:{s:4:\"tmpl\";i:1433;s:2:\"id\";i:24477;s:5:\"title\";s:27:\"Wireframe &#8211; Gallery 2\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Gallery-2.jpg\";s:12:\"tmpl_created\";i:1653988835;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-gallery-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:82:\"[\"Business\",\"Contact\",\"Design\",\"Footer\",\"Gallery\",\"Header\",\"Portfolio\",\"Services\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:176;a:20:{s:4:\"tmpl\";i:1205;s:2:\"id\";i:20233;s:5:\"title\";s:32:\"Art Magazine &#8211; Coming Soon\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Art-Magazine-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633881371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/art-magazine-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:48:\"[\"Art\",\"Coming Soon\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:3;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:177;a:20:{s:4:\"tmpl\";i:1214;s:2:\"id\";i:20539;s:5:\"title\";s:31:\"Design Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022706;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/design-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:47:\"[\"Blog\",\"Coming Soon\",\"Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:178;a:20:{s:4:\"tmpl\";i:1224;s:2:\"id\";i:21013;s:5:\"title\";s:24:\"Restaurant &#8211; About\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/12/7-About-Restaurant.jpg\";s:12:\"tmpl_created\";i:1638795588;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/restaurant-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:36:\"[\"About\",\"Chef\",\"Food\",\"Restaurant\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:179;a:20:{s:4:\"tmpl\";i:992;s:2:\"id\";i:13402;s:5:\"title\";s:29:\"Classic | CTA | Online Course\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2020/04/Popup-Course-Completed.jpg\";s:12:\"tmpl_created\";i:1587474772;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/popups/classic-cta-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:4;s:16:\"popularity_index\";i:619;s:11:\"trend_index\";i:582;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:180;a:20:{s:4:\"tmpl\";i:1206;s:2:\"id\";i:20254;s:5:\"title\";s:41:\"Digital Marketing Agency &#8211; Business\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Digital-Marketing-Agency-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633882427;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/lp/digital-marketing-agency-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:65:\"[\"Agency\",\"Business\",\"Digital Agency\",\"Landing Pages\",\"Services\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:181;a:20:{s:4:\"tmpl\";i:1235;s:2:\"id\";i:21281;s:5:\"title\";s:25:\"Law Firm &#8211; Services\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/12/16-Services-Law-firm.jpg\";s:12:\"tmpl_created\";i:1638819128;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/law-firm-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Consulting\",\"Law\",\"Law Firm\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:182;a:20:{s:4:\"tmpl\";i:1017;s:2:\"id\";i:14111;s:5:\"title\";s:36:\"Classic | Japanese restaurant | Sale\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1592300400;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-japanese-restaurant-sale/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:5;s:16:\"popularity_index\";i:717;s:11:\"trend_index\";i:697;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:183;a:20:{s:4:\"tmpl\";i:1213;s:2:\"id\";i:20509;s:5:\"title\";s:40:\"Dogs Adoption &#8211; Social Involvement\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/10/Dog-Adoption-250x280-1.jpg\";s:12:\"tmpl_created\";i:1634022353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/dogs-adoption-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:49:\"[\"Adoption\",\"Involvement\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:184;a:20:{s:4:\"tmpl\";i:1233;s:2:\"id\";i:21205;s:5:\"title\";s:29:\"Photographer &#8211; Projects\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/25-Projects-Photographer.jpg\";s:12:\"tmpl_created\";i:1638818372;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/photographer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:43:\"[\"Black and white\",\"Photography\",\"Project\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:185;a:20:{s:4:\"tmpl\";i:993;s:2:\"id\";i:13422;s:5:\"title\";s:30:\"Classic | Menu | Online Course\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1587474782;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/classic-menu-online-course/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:29:\"[\"Course Online\",\"Education\"]\";s:10:\"menu_order\";i:6;s:16:\"popularity_index\";i:516;s:11:\"trend_index\";i:432;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:186;a:20:{s:4:\"tmpl\";i:925;s:2:\"id\";i:12540;s:5:\"title\";s:33:\"Classic | Menu | Travel and tours\";s:9:\"thumbnail\";s:73:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_Menu_s.png\";s:12:\"tmpl_created\";i:1575960267;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-menu-travel-and-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:690;s:11:\"trend_index\";i:714;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:187;a:20:{s:4:\"tmpl\";i:1208;s:2:\"id\";i:20361;s:5:\"title\";s:51:\"Exercise &#038; Fitness Equipment &#8211; eCommerce\";s:9:\"thumbnail\";s:97:\"https://library.elementor.com/wp-content/uploads/2021/10/Exercise-Fitness-Equipment-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633883766;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/lp/exercise-fitness-equipment-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:50:\"[\"Fitness\",\"Health\",\"Landing Pages\",\"Online Shop\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:188;a:20:{s:4:\"tmpl\";i:1239;s:2:\"id\";i:21373;s:5:\"title\";s:28:\"Photographer &#8211; Gallery\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/18-Gallery-Photographer.jpg\";s:12:\"tmpl_created\";i:1638821177;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/photographer-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Gallery\",\"Photography\",\"Portfolio\",\"Project\",\"Travel\"]\";s:10:\"menu_order\";i:7;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:189;a:20:{s:4:\"tmpl\";i:1426;s:2:\"id\";i:24348;s:5:\"title\";s:24:\"Wireframe &#8211; Home 2\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-2.jpg\";s:12:\"tmpl_created\";i:1653988444;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:190;a:20:{s:4:\"tmpl\";i:958;s:2:\"id\";i:13129;s:5:\"title\";s:28:\"Classic | Menu | Photography\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/02/PopUp_s.png\";s:12:\"tmpl_created\";i:1582092645;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/popups/classic-menu-photography/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:27:\"[\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:8;s:16:\"popularity_index\";i:646;s:11:\"trend_index\";i:521;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:191;a:20:{s:4:\"tmpl\";i:1427;s:2:\"id\";i:24366;s:5:\"title\";s:24:\"Wireframe &#8211; Home 3\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Home-3.jpg\";s:12:\"tmpl_created\";i:1653988491;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:115:\"https://library.elementor.com/wireframe-home-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:102:\"[\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Homepage\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:192;a:20:{s:4:\"tmpl\";i:1207;s:2:\"id\";i:20299;s:5:\"title\";s:51:\"Interior Design Consultation &#8211; Online Service\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2021/10/Interior-Design-Consultation-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633882989;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:145:\"https://library.elementor.com/lp/interior-design-consultation-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:65:\"[\"Consulting\",\"Interior Design\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:193;a:20:{s:4:\"tmpl\";i:952;s:2:\"id\";i:12726;s:5:\"title\";s:52:\"Classic | Newsletter | Subscribe | Magazine and Blog\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_Newsletter_s.png\";s:12:\"tmpl_created\";i:1579061019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:152:\"https://library.elementor.com/popups/classic-newsletter-subscribe-magazine-and-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:9;s:16:\"popularity_index\";i:357;s:11:\"trend_index\";i:281;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:194;a:20:{s:4:\"tmpl\";i:883;s:2:\"id\";i:11468;s:5:\"title\";s:20:\"Classic | Sale | Gym\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/08/PopUp_Small.png\";s:12:\"tmpl_created\";i:1567393182;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/popups/classic-sale-gym/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:696;s:11:\"trend_index\";i:740;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:195;a:20:{s:4:\"tmpl\";i:1216;s:2:\"id\";i:20623;s:5:\"title\";s:57:\"Luxurious Camping Accommodation For Events &#8211; Events\";s:9:\"thumbnail\";s:113:\"https://library.elementor.com/wp-content/uploads/2021/10/Luxurious-Camping-Accommodation-For-Events-250x280-2.jpg\";s:12:\"tmpl_created\";i:1634041681;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:151:\"https://library.elementor.com/lp/luxurious-camping-accommodation-for-events-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:43:\"[\"Event\",\"Events\",\"Landing Pages\",\"Travel\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:196;a:20:{s:4:\"tmpl\";i:1219;s:2:\"id\";i:20886;s:5:\"title\";s:28:\"Online Training &#8211; Home\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/12/2-Home-Online-Training.jpg\";s:12:\"tmpl_created\";i:1638784769;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/online-training-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:39:\"[\"Fitness\",\"Online\",\"Sport\",\"Training\"]\";s:10:\"menu_order\";i:10;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:197;a:20:{s:4:\"tmpl\";i:1065;s:2:\"id\";i:15570;s:5:\"title\";s:33:\"Classic | Subscribe | Travel Blog\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp.jpg\";s:12:\"tmpl_created\";i:1606215555;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/classic-subscribe-travel-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:709;s:11:\"trend_index\";i:459;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:198;a:20:{s:4:\"tmpl\";i:1431;s:2:\"id\";i:24437;s:5:\"title\";s:25:\"Wireframe &#8211; About 4\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-4.jpg\";s:12:\"tmpl_created\";i:1653988733;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:74:\"[\"About\",\"Business\",\"Contact\",\"Features\",\"Footer\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:199;a:20:{s:4:\"tmpl\";i:1210;s:2:\"id\";i:20414;s:5:\"title\";s:45:\"Online English Courses &#8211; Online Service\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2021/10/Online-English-Courses-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633884482;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/lp/online-english-courses-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:50:\"[\"Course Online\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:11;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:200;a:20:{s:4:\"tmpl\";i:1132;s:2:\"id\";i:16553;s:5:\"title\";s:31:\"Fly-In | Contact | Beauty Salon\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/12/PopUp.jpg\";s:12:\"tmpl_created\";i:1608622602;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fly-in-contact-beauty-salon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:23:\"[\"Beauty Salon\",\"Hair\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:691;s:11:\"trend_index\";i:428;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:201;a:20:{s:4:\"tmpl\";i:1441;s:2:\"id\";i:24574;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 5\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-5.jpg\";s:12:\"tmpl_created\";i:1653989135;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-5/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:88:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Google Maps\",\"Header\",\"Professional\",\"Subscribe\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:202;a:20:{s:4:\"tmpl\";i:1217;s:2:\"id\";i:20333;s:5:\"title\";s:40:\"Plant Pots Online Shop &#8211; eCommerce\";s:9:\"thumbnail\";s:93:\"https://library.elementor.com/wp-content/uploads/2021/10/Plant-Pots-Online-Shop-250x280-2.jpg\";s:12:\"tmpl_created\";i:1634042184;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/plant-pots-online-shop-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:50:\"[\"Ecommerce\",\"Landing Pages\",\"Online Shop\",\"Shop\"]\";s:10:\"menu_order\";i:12;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:203;a:20:{s:4:\"tmpl\";i:1211;s:2:\"id\";i:20447;s:5:\"title\";s:33:\"Shared Workspace &#8211; Business\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Shared-Workspace.jpg\";s:12:\"tmpl_created\";i:1633884934;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/shared-workspace-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:28:\"[\"Business\",\"Landing Pages\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:204;a:20:{s:4:\"tmpl\";i:1237;s:2:\"id\";i:21313;s:5:\"title\";s:34:\"Spa &#038; Beauty &#8211; Services\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/12/Spa-Beauty-Treatments-page-1.jpg\";s:12:\"tmpl_created\";i:1638819709;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/spa-beauty-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:55:\"[\"Beauty\",\"Hair\",\"Health\",\"Services\",\"Spa\",\"Treatment\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:205;a:20:{s:4:\"tmpl\";i:1004;s:2:\"id\";i:13538;s:5:\"title\";s:32:\"Fly-In | Newsletter | Barbershop\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/05/Pop-Up-Page-Small.jpg\";s:12:\"tmpl_created\";i:1589893364;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/popups/fly-in-newsletter-barbershop/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:28:\"[\"Barber Shop\",\"Barbershop\"]\";s:10:\"menu_order\";i:13;s:16:\"popularity_index\";i:710;s:11:\"trend_index\";i:667;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:206;a:20:{s:4:\"tmpl\";i:924;s:2:\"id\";i:12550;s:5:\"title\";s:32:\"Fly-in | Sale | Travel and Tours\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2019/12/PopUp_s.png\";s:12:\"tmpl_created\";i:1575960263;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/flyin-sale-travel-and-tours/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:18:\"[\"Tours\",\"Travel\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:754;s:11:\"trend_index\";i:791;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:207;a:20:{s:4:\"tmpl\";i:1212;s:2:\"id\";i:20479;s:5:\"title\";s:49:\"Teeth Straightening &#8211; Health &#038; Fitness\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/10/250x280-Teeth-Whitening.jpg\";s:12:\"tmpl_created\";i:1633886115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/teeth-straightening-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:46:\"[\"Business\",\"Dental\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:208;a:20:{s:4:\"tmpl\";i:1234;s:2:\"id\";i:21234;s:5:\"title\";s:34:\"Insurance Company &#8211; Services\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/12/15-Services-Insurance-Company.jpg\";s:12:\"tmpl_created\";i:1638818688;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/insurance-company-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"Faq\",\"Form\",\"Insurance\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:14;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:209;a:20:{s:4:\"tmpl\";i:1035;s:2:\"id\";i:15062;s:5:\"title\";s:35:\"Fly-In | Sign up | Flooring Company\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp.png\";s:12:\"tmpl_created\";i:1597739629;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:137:\"https://library.elementor.com/popups/fly-in-sign-up-flooring-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"fly-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:625;s:11:\"trend_index\";i:309;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:210;a:20:{s:4:\"tmpl\";i:1209;s:2:\"id\";i:20394;s:5:\"title\";s:30:\"Time Management &#8211; Events\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/10/Time-Management-250x280-1.jpg\";s:12:\"tmpl_created\";i:1633884077;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/time-management-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:17:\"[\"Landing Pages\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:211;a:20:{s:4:\"tmpl\";i:1229;s:2:\"id\";i:21118;s:5:\"title\";s:28:\"Contact &#8211; Plants Store\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/12-Contact-Plants-Store.jpg\";s:12:\"tmpl_created\";i:1638802472;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/contact-plants-store/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:40:\"[\"Contact\",\"Info\",\"Plant\",\"Testimonial\"]\";s:10:\"menu_order\";i:15;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:212;a:20:{s:4:\"tmpl\";i:893;s:2:\"id\";i:11822;s:5:\"title\";s:30:\"Full Screen | Menu | Portfolio\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/09/PopUp_small.png\";s:12:\"tmpl_created\";i:1569429896;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/popups/full-screen-menu-portfolio/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:654;s:11:\"trend_index\";i:626;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:213;a:20:{s:4:\"tmpl\";i:1203;s:2:\"id\";i:18591;s:5:\"title\";s:28:\"Coffee Sale &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/04/250x280-7.png\";s:12:\"tmpl_created\";i:1633877319;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/lp/coffee-sale-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:33:\"[\"Coffee\",\"Landing Pages\",\"Sale\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:214;a:20:{s:4:\"tmpl\";i:1231;s:2:\"id\";i:21184;s:5:\"title\";s:28:\"Dental Care &#8211; Services\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/14-Services-Dental-Care.jpg\";s:12:\"tmpl_created\";i:1638807148;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/dental-care-services/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:45:\"[\"Dental\",\"Medical\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:16;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:215;a:20:{s:4:\"tmpl\";i:1064;s:2:\"id\";i:15580;s:5:\"title\";s:31:\"Fullscreen | Menu | Travel Blog\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/11/PopUp-Menu.jpg\";s:12:\"tmpl_created\";i:1606215358;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/fullscreen-menu-travel-blog/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"full screen\";s:4:\"tags\";s:17:\"[\"Blog\",\"Travel\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:673;s:11:\"trend_index\";i:348;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:216;a:20:{s:4:\"tmpl\";i:1133;s:2:\"id\";i:16645;s:5:\"title\";s:28:\"Headphones &#8211; eCommerce\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_headphones.png\";s:12:\"tmpl_created\";i:1609944115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/commerce-headphones/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:39:\"[\"Ecommerce\",\"Landing Pages\",\"Product\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:633;s:11:\"trend_index\";i:87;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:217;a:20:{s:4:\"tmpl\";i:1442;s:2:\"id\";i:24584;s:5:\"title\";s:27:\"Wireframe &#8211; Pricing 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Pricing-1.jpg\";s:12:\"tmpl_created\";i:1653989152;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-pricing-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:146:\"[\"Booking\",\"Business\",\"Clients\",\"Contact\",\"Faq\",\"Features\",\"Footer\",\"Online Service\",\"Pricing\",\"Products\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:17;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:218;a:20:{s:4:\"tmpl\";i:1138;s:2:\"id\";i:16762;s:5:\"title\";s:25:\"Conference &#8211; Events\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Conference.png\";s:12:\"tmpl_created\";i:1610455119;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/conference-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:60:\"[\"Conference\",\"Convention\",\"Event\",\"Events\",\"Landing Pages\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:705;s:11:\"trend_index\";i:216;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:219;a:20:{s:4:\"tmpl\";i:1438;s:2:\"id\";i:24539;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 2\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-2.jpg\";s:12:\"tmpl_created\";i:1653989019;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:69:\"[\"Business\",\"Contact\",\"Footer\",\"Google Maps\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:220;a:20:{s:4:\"tmpl\";i:981;s:2:\"id\";i:13281;s:5:\"title\";s:37:\"Hello Bar | Contact | Interior Design\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/04/PopUp.png\";s:12:\"tmpl_created\";i:1586148801;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/hello-bar-contact-interior-design/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:19:\"[\"Interior Design\"]\";s:10:\"menu_order\";i:18;s:16:\"popularity_index\";i:763;s:11:\"trend_index\";i:679;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:221;a:20:{s:4:\"tmpl\";i:1052;s:2:\"id\";i:15259;s:5:\"title\";s:31:\"Hello Bar | Menu | Psychologist\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2020/09/Menu-PopUp.png\";s:12:\"tmpl_created\";i:1600170209;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/popups/hello-bar-menu-psychologist/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"hello bar\";s:4:\"tags\";s:34:\"[\"Psychologist\",\"Psychotherapist\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:739;s:11:\"trend_index\";i:583;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:222;a:20:{s:4:\"tmpl\";i:1434;s:2:\"id\";i:24494;s:5:\"title\";s:28:\"Wireframe &#8211; Services 1\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-1.jpg\";s:12:\"tmpl_created\";i:1653988874;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:53:\"[\"Business\",\"Faq\",\"Footer\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:223;a:20:{s:4:\"tmpl\";i:1194;s:2:\"id\";i:18701;s:5:\"title\";s:32:\"Digital Course &#8211; eCommerce\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/04/250x280.jpg\";s:12:\"tmpl_created\";i:1618995134;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/digital-course-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:57:\"[\"Course Online\",\"Ecommerce\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:19;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:224;a:20:{s:4:\"tmpl\";i:1192;s:2:\"id\";i:18612;s:5:\"title\";s:34:\"Bag Product Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Bag-Product.jpeg\";s:12:\"tmpl_created\";i:1618395406;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/bag-product-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:61:\"[\"Bag\",\"Ecommerce\",\"Landing Pages\",\"Product\",\"Sale\",\"Travel\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:875;s:11:\"trend_index\";i:605;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:225;a:20:{s:4:\"tmpl\";i:1227;s:2:\"id\";i:21083;s:5:\"title\";s:26:\"Conference &#8211; Contact\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/10-Contact-Conference.jpg\";s:12:\"tmpl_created\";i:1638799208;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/conference-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:44:\"[\"Conference\",\"Contact\",\"Form\",\"Info\",\"Map\"]\";s:10:\"menu_order\";i:20;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:226;a:20:{s:4:\"tmpl\";i:1193;s:2:\"id\";i:18644;s:5:\"title\";s:37:\"Camera Product Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/camera_sale_featured-img.jpg\";s:12:\"tmpl_created\";i:1618396388;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/lp/camera-product-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:59:\"[\"Camera\",\"Ecommerce\",\"Landing Pages\",\"Photography\",\"Sale\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:873;s:11:\"trend_index\";i:535;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:227;a:20:{s:4:\"tmpl\";i:951;s:2:\"id\";i:12736;s:5:\"title\";s:41:\"Slide In | Contact Us | Magazine and Blog\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2020/01/PopUp_contact_s.png\";s:12:\"tmpl_created\";i:1579060978;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/popups/slide-in-contact-us/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:19:\"[\"Blog\",\"Magazine\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:734;s:11:\"trend_index\";i:686;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:228;a:20:{s:4:\"tmpl\";i:1222;s:2:\"id\";i:20960;s:5:\"title\";s:26:\"Travel Agency &#8211; Home\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/12/5-Home-Travel-Agency.jpg\";s:12:\"tmpl_created\";i:1638788432;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/travel-agency-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:53:\"[\"Adventures\",\"Experience\",\"Explore\",\"Travel\",\"Trip\"]\";s:10:\"menu_order\";i:21;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:229;a:20:{s:4:\"tmpl\";i:1196;s:2:\"id\";i:18815;s:5:\"title\";s:25:\"Car Wash &#8211; Business\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Car-Wash.png\";s:12:\"tmpl_created\";i:1621336431;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/lp/car-wash-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:45:\"[\"Business\",\"car\",\"Discount\",\"Landing Pages\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:230;a:20:{s:4:\"tmpl\";i:1242;s:2:\"id\";i:21473;s:5:\"title\";s:40:\"Architecture Photography &#8211; Gallery\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2021/12/20-Gallery-Architecture-Photography.jpg\";s:12:\"tmpl_created\";i:1638822115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/architecture-photography-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:52:\"[\"Architecture\",\"Gallery\",\"Photography\",\"Portfolio\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:231;a:20:{s:4:\"tmpl\";i:1015;s:2:\"id\";i:14067;s:5:\"title\";s:37:\"Slide In | Japanese restaurant | Menu\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2020/06/Menu-Pop-Up-Small.jpg\";s:12:\"tmpl_created\";i:1592290352;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:139:\"https://library.elementor.com/popups/slide-in-japanese-restaurant-menu/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:32:\"[\"Food\",\"Japanese\",\"Restaurant\"]\";s:10:\"menu_order\";i:22;s:16:\"popularity_index\";i:650;s:11:\"trend_index\";i:565;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:232;a:20:{s:4:\"tmpl\";i:923;s:2:\"id\";i:12229;s:5:\"title\";s:33:\"Slide In | Law Firm | Information\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2019/11/popup.png\";s:12:\"tmpl_created\";i:1572847842;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/popups/slide-in-law-firm-information/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:18:\"[\"Law\",\"Law Firm\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:547;s:11:\"trend_index\";i:413;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:233;a:20:{s:4:\"tmpl\";i:1198;s:2:\"id\";i:18824;s:5:\"title\";s:33:\"Design School &#8211; Coming Soon\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/05/250x280-1.png\";s:12:\"tmpl_created\";i:1621336756;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/design-school-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:49:\"[\"Coming Soon\",\"Design\",\"Landing Pages\",\"School\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:234;a:20:{s:4:\"tmpl\";i:1236;s:2:\"id\";i:21259;s:5:\"title\";s:28:\"3D Designer &#8211; Projects\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/24-Projects-3D-Designer.jpg\";s:12:\"tmpl_created\";i:1638819185;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/3d-designer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:69:\"[\"3D\",\"Creative Portfolio\",\"Design\",\"Designer\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:23;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:235;a:20:{s:4:\"tmpl\";i:1028;s:2:\"id\";i:14827;s:5:\"title\";s:39:\"Slide-In | Contact | Luxury Real Estate\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2020/07/PopUp.png\";s:12:\"tmpl_created\";i:1595323523;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:141:\"https://library.elementor.com/popups/slide-in-contact-luxury-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:28:\"[\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:559;s:11:\"trend_index\";i:284;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:236;a:20:{s:4:\"tmpl\";i:1197;s:2:\"id\";i:18819;s:5:\"title\";s:27:\"Dog Walker &#8211; Business\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Dog-Walker.png\";s:12:\"tmpl_created\";i:1621336601;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/lp/dog-walker-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:41:\"[\"Business\",\"Dog\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:237;a:20:{s:4:\"tmpl\";i:1238;s:2:\"id\";i:21349;s:5:\"title\";s:29:\"Architecture &#8211; Projects\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/23-Projects-Architecture.jpg\";s:12:\"tmpl_created\";i:1638820870;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/architecture-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:70:\"[\"Architecture\",\"Creative\",\"Creative Portfolio\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:24;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:238;a:20:{s:4:\"tmpl\";i:1034;s:2:\"id\";i:15075;s:5:\"title\";s:34:\"Slide-In | Menu | Flooring Company\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2020/08/PopUp-1.png\";s:12:\"tmpl_created\";i:1597739605;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/popups/slide-in-menu-flooring-company/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"slide-in\";s:4:\"tags\";s:39:\"[\"Flooring company\",\"Flooring website\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:383;s:11:\"trend_index\";i:162;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:239;a:20:{s:4:\"tmpl\";i:1414;s:2:\"id\";i:24079;s:5:\"title\";s:32:\"Fashion Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Fashion-Shop.jpg\";s:12:\"tmpl_created\";i:1650988089;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/fashion-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:88:\"[\"Aesthetic\",\"Business\",\"Coming Soon\",\"Ecommerce\",\"Girly\",\"Lifestyle\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:240;a:20:{s:4:\"tmpl\";i:1195;s:2:\"id\";i:18761;s:5:\"title\";s:33:\"Fashion Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Fashion-Store.png\";s:12:\"tmpl_created\";i:1621336146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/fashion-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:56:\"[\"Coming Soon\",\"Fashion\",\"Landing Pages\",\"Shop\",\"store\"]\";s:10:\"menu_order\";i:25;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:241;a:20:{s:4:\"tmpl\";i:1153;s:2:\"id\";i:17060;s:5:\"title\";s:36:\"Private Tutor &#8211; Online Service\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Tutor-2.png\";s:12:\"tmpl_created\";i:1610631042;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/private-tutor-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:64:\"[\"Education\",\"Landing Pages\",\"Online Service\",\"Teacher\",\"Tutor\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:780;s:11:\"trend_index\";i:628;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:242;a:20:{s:4:\"tmpl\";i:1430;s:2:\"id\";i:24434;s:5:\"title\";s:25:\"Wireframe &#8211; About 3\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-3.jpg\";s:12:\"tmpl_created\";i:1653988697;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:76:\"[\"About\",\"Business\",\"Contact\",\"Faq\",\"Footer\",\"Header\",\"Professional\",\"Team\"]\";s:10:\"menu_order\";i:26;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:243;a:20:{s:4:\"tmpl\";i:1158;s:2:\"id\";i:17232;s:5:\"title\";s:33:\"Life Coach &#8211; Online Service\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Life-Coach.png\";s:12:\"tmpl_created\";i:1610902793;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/life-coach-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:38:\"[\"Coach\",\"Landing Pages\",\"Life Coach\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:787;s:11:\"trend_index\";i:751;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:244;a:20:{s:4:\"tmpl\";i:1436;s:2:\"id\";i:24515;s:5:\"title\";s:28:\"Wireframe &#8211; Services 3\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-3.jpg\";s:12:\"tmpl_created\";i:1653988946;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:66:\"[\"Business\",\"Contact\",\"Footer\",\"Header\",\"Professional\",\"Services\"]\";s:10:\"menu_order\";i:27;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:245;a:20:{s:4:\"tmpl\";i:875;s:2:\"id\";i:11241;s:5:\"title\";s:36:\"Classic | Digital Agency | Marketing\";s:9:\"thumbnail\";s:72:\"https://library.elementor.com/wp-content/uploads/2019/07/PopUp_small.jpg\";s:12:\"tmpl_created\";i:1564643043;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/popups/classic-digital-agency-marketing/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"popup\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:7:\"classic\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:362;s:11:\"trend_index\";i:315;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:246;a:20:{s:4:\"tmpl\";i:1146;s:2:\"id\";i:16932;s:5:\"title\";s:35:\"Finance Consulting &#8211; Business\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/01/Finance-Consulting.png\";s:12:\"tmpl_created\";i:1610532170;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:129:\"https://library.elementor.com/lp/finance-consulting-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:80:\"[\"Advisor\",\"Business\",\"Consulting\",\"Finance\",\"Investment\",\"Landing Pages\",\"Tax\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:790;s:11:\"trend_index\";i:630;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:247;a:20:{s:4:\"tmpl\";i:1429;s:2:\"id\";i:24421;s:5:\"title\";s:25:\"Wireframe &#8211; About 2\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-About-2.jpg\";s:12:\"tmpl_created\";i:1653988579;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/wireframe-about-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:87:\"[\"About\",\"Business\",\"Contact\",\"Faq\",\"Features\",\"Footer\",\"Header\",\"Professional\",\"Team\"]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:248;a:20:{s:4:\"tmpl\";i:674;s:2:\"id\";i:8505;s:5:\"title\";s:11:\"404 page 01\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/001.jpg\";s:12:\"tmpl_created\";i:1526415501;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-01/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:28;s:16:\"popularity_index\";i:533;s:11:\"trend_index\";i:222;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:249;a:20:{s:4:\"tmpl\";i:1136;s:2:\"id\";i:16721;s:5:\"title\";s:35:\"Dental &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2021/01/Dental.jpg\";s:12:\"tmpl_created\";i:1610448567;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/dental-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:44:\"[\"Dental\",\"Doctor\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:801;s:11:\"trend_index\";i:655;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:250;a:20:{s:4:\"tmpl\";i:1417;s:2:\"id\";i:24116;s:5:\"title\";s:32:\"Tech Company &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Tech-Company.jpg\";s:12:\"tmpl_created\";i:1650989265;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/tech-company-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:87:\"[\"Business\",\"Coding\",\"Coming Soon\",\"Computer\",\"Developer\",\"IT\",\"Services\",\"Technology\"]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:251;a:20:{s:4:\"tmpl\";i:675;s:2:\"id\";i:8511;s:5:\"title\";s:11:\"404 page 02\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/002.jpg\";s:12:\"tmpl_created\";i:1526415528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-02/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:29;s:16:\"popularity_index\";i:347;s:11:\"trend_index\";i:155;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:252;a:20:{s:4:\"tmpl\";i:1161;s:2:\"id\";i:17269;s:5:\"title\";s:34:\"Electronics Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Electronic-Products.png\";s:12:\"tmpl_created\";i:1610903298;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/electronics-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:29:\"[\"Ecommerce\",\"Landing Pages\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:800;s:11:\"trend_index\";i:556;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:253;a:20:{s:4:\"tmpl\";i:1220;s:2:\"id\";i:20908;s:5:\"title\";s:42:\"Packing &#038; Moving Company &#8211; Home\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/12/3-Home-Packing-Moving-Company.jpg\";s:12:\"tmpl_created\";i:1638786127;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/packing-moving-company-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:28:\"[\"Movers\",\"Moving\",\"Storge\"]\";s:10:\"menu_order\";i:30;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:254;a:20:{s:4:\"tmpl\";i:1152;s:2:\"id\";i:17032;s:5:\"title\";s:42:\"Donate Computer &#8211; Social Involvement\";s:9:\"thumbnail\";s:71:\"https://library.elementor.com/wp-content/uploads/2021/01/Donation-2.png\";s:12:\"tmpl_created\";i:1610630585;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/donate-computer-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:67:\"[\"Computer\",\"Donate\",\"Donation\",\"Kids\",\"Landing Pages\",\"Nonprofit\"]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:718;s:11:\"trend_index\";i:278;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:255;a:20:{s:4:\"tmpl\";i:672;s:2:\"id\";i:8512;s:5:\"title\";s:11:\"404 page 03\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/003.jpg\";s:12:\"tmpl_created\";i:1526415449;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-03/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:450;s:11:\"trend_index\";i:375;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:256;a:20:{s:4:\"tmpl\";i:1245;s:2:\"id\";i:21546;s:5:\"title\";s:28:\"Interior Design &#8211; Home\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/12/1-Home-Interior-Design-1.jpg\";s:12:\"tmpl_created\";i:1639046269;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/interior-design-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:68:\"[\"Design\",\"Form\",\"Furniture Design\",\"Interior Design\",\"Testimonial\"]\";s:10:\"menu_order\";i:31;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:257;a:20:{s:4:\"tmpl\";i:1135;s:2:\"id\";i:16684;s:5:\"title\";s:34:\"SaaS HR Management &#8211; Product\";s:9:\"thumbnail\";s:66:\"https://library.elementor.com/wp-content/uploads/2021/01/lp_hr.png\";s:12:\"tmpl_created\";i:1609945486;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/saas-hr-management-product/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:7:\"Product\";s:4:\"tags\";s:39:\"[\"HR\",\"Landing Pages\",\"Product\",\"SaaS\"]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:708;s:11:\"trend_index\";i:292;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:258;a:20:{s:4:\"tmpl\";i:671;s:2:\"id\";i:8513;s:5:\"title\";s:11:\"404 page 04\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/004.jpg\";s:12:\"tmpl_created\";i:1526415417;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-04/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:420;s:11:\"trend_index\";i:176;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:259;a:20:{s:4:\"tmpl\";i:1249;s:2:\"id\";i:22137;s:5:\"title\";s:31:\"Design Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:94:\"https://library.elementor.com/wp-content/uploads/2021/10/Design-Blog-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1647177194;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:122:\"https://library.elementor.com/design-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:47:\"[\"Blog\",\"Coming Soon\",\"Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:32;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:260;a:20:{s:4:\"tmpl\";i:1134;s:2:\"id\";i:16660;s:5:\"title\";s:37:\"Medical center &#8211; Online service\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-medical-cosultation-250_280.png\";s:12:\"tmpl_created\";i:1609945122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/lp/medical-center-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:44:\"[\"Landing Pages\",\"Medical\",\"Online Service\"]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:750;s:11:\"trend_index\";i:332;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:261;a:20:{s:4:\"tmpl\";i:1226;s:2:\"id\";i:21069;s:5:\"title\";s:21:\"Hotel &#8211; Contact\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/12/9-Contact-Hotel.jpg\";s:12:\"tmpl_created\";i:1638798545;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:112:\"https://library.elementor.com/hotel-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:36:\"[\"Contact\",\"from\",\"Info\",\"Vacation\"]\";s:10:\"menu_order\";i:33;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:262;a:20:{s:4:\"tmpl\";i:1150;s:2:\"id\";i:17001;s:5:\"title\";s:36:\"Parental Counseling &#8211; Business\";s:9:\"thumbnail\";s:78:\"https://library.elementor.com/wp-content/uploads/2021/01/Parenting-Coach-2.png\";s:12:\"tmpl_created\";i:1610534999;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/parental-counseling-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:99:\"[\"Advisor\",\"Business\",\"Coach\",\"Counseling\",\"Landing Pages\",\"Online Service\",\"Parental\",\"Parenting\"]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:817;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:263;a:20:{s:4:\"tmpl\";i:1432;s:2:\"id\";i:24461;s:5:\"title\";s:27:\"Wireframe &#8211; Gallery 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Gallery-1.jpg\";s:12:\"tmpl_created\";i:1653988784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-gallery-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:82:\"[\"Business\",\"Contact\",\"Design\",\"Footer\",\"Gallery\",\"Header\",\"Portfolio\",\"Services\"]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:264;a:20:{s:4:\"tmpl\";i:676;s:2:\"id\";i:8514;s:5:\"title\";s:11:\"404 Page 05\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/005.jpg\";s:12:\"tmpl_created\";i:1526415558;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-05/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:34;s:16:\"popularity_index\";i:419;s:11:\"trend_index\";i:220;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:265;a:20:{s:4:\"tmpl\";i:1137;s:2:\"id\";i:16742;s:5:\"title\";s:31:\"Online Course &#8211; Education\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Course.png\";s:12:\"tmpl_created\";i:1610454122;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/online-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:55:\"[\"Academy\",\"Course Online\",\"Education\",\"Landing Pages\"]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:777;s:11:\"trend_index\";i:776;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:266;a:20:{s:4:\"tmpl\";i:668;s:2:\"id\";i:8523;s:5:\"title\";s:11:\"404 page 06\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/006.jpg\";s:12:\"tmpl_created\";i:1526415291;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-06/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:298;s:11:\"trend_index\";i:268;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:267;a:20:{s:4:\"tmpl\";i:1440;s:2:\"id\";i:24563;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 4\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-4.jpg\";s:12:\"tmpl_created\";i:1653989095;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-4/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:84:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Gallery\",\"Header\",\"Professional\",\"Subscribe\"]\";s:10:\"menu_order\";i:35;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:268;a:20:{s:4:\"tmpl\";i:1162;s:2:\"id\";i:17284;s:5:\"title\";s:38:\"Dietitian &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/01/Dietitian.png\";s:12:\"tmpl_created\";i:1610903484;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/dietitian-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:39:\"[\"Fitness\",\"Health\",\"landscape design\"]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:814;s:11:\"trend_index\";i:800;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:269;a:20:{s:4:\"tmpl\";i:1439;s:2:\"id\";i:24553;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 3\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-3.jpg\";s:12:\"tmpl_created\";i:1653989057;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-3/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:67:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Professional\",\"Testimonial\"]\";s:10:\"menu_order\";i:36;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:270;a:20:{s:4:\"tmpl\";i:1144;s:2:\"id\";i:16897;s:5:\"title\";s:30:\"Personal Chef &#8211; Business\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2021/01/Personal-Chef.png\";s:12:\"tmpl_created\";i:1610466247;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/personal-chef-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:53:\"[\"Business\",\"Chef\",\"Food\",\"Landing Pages\",\"Services\"]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:795;s:11:\"trend_index\";i:617;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:271;a:20:{s:4:\"tmpl\";i:1435;s:2:\"id\";i:24504;s:5:\"title\";s:28:\"Wireframe &#8211; Services 2\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Services-2.jpg\";s:12:\"tmpl_created\";i:1653988910;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/wireframe-services-2/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:80:\"[\"Business\",\"Contact\",\"Footer\",\"Header\",\"Professional\",\"Services\",\"Testimonial\"]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:272;a:20:{s:4:\"tmpl\";i:669;s:2:\"id\";i:8524;s:5:\"title\";s:11:\"404 page 07\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/007.jpg\";s:12:\"tmpl_created\";i:1526415337;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-07/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:37;s:16:\"popularity_index\";i:303;s:11:\"trend_index\";i:171;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:273;a:20:{s:4:\"tmpl\";i:1147;s:2:\"id\";i:16946;s:5:\"title\";s:52:\"Online Full-Stack Developer Course &#8211; Education\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/01/Online-Full-Stack-Developer-Course.png\";s:12:\"tmpl_created\";i:1610532778;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/lp/online-full-stack-developer-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:76:\"[\"Academy\",\"Coding\",\"Course Online\",\"Developer\",\"Education\",\"Landing Pages\"]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:805;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:274;a:20:{s:4:\"tmpl\";i:1437;s:2:\"id\";i:24528;s:5:\"title\";s:27:\"Wireframe &#8211; Contact 1\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2022/05/Wireframe-—-Contact-1.jpg\";s:12:\"tmpl_created\";i:1653988981;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/wireframe-contact-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:76:\"[\"Business\",\"Contact\",\"Footer\",\"Form\",\"Google Maps\",\"Header\",\"Professional\"]\";s:10:\"menu_order\";i:38;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:275;a:20:{s:4:\"tmpl\";i:1143;s:2:\"id\";i:16868;s:5:\"title\";s:40:\"Virtual Assistant &#8211; Online Service\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2021/01/Virtual-Assistant-250x280-1.png\";s:12:\"tmpl_created\";i:1610465656;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/virtual-assistant-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:46:\"[\"Assistant\",\"Landing Pages\",\"Online Service\"]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:793;s:11:\"trend_index\";i:757;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:276;a:20:{s:4:\"tmpl\";i:673;s:2:\"id\";i:8526;s:5:\"title\";s:11:\"404 page 09\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/009.jpg\";s:12:\"tmpl_created\";i:1526415474;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-09/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:477;s:11:\"trend_index\";i:285;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:277;a:20:{s:4:\"tmpl\";i:1228;s:2:\"id\";i:21104;s:5:\"title\";s:26:\"Restaurant &#8211; Contact\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/11-Contact-Restaurant.jpg\";s:12:\"tmpl_created\";i:1638800146;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/restaurant-contact/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:60:\"[\"Contact\",\"Food\",\"Form\",\"Google Maps\",\"Info\",\"Testimonial\"]\";s:10:\"menu_order\";i:39;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:278;a:20:{s:4:\"tmpl\";i:1140;s:2:\"id\";i:16812;s:5:\"title\";s:40:\"Construction Project &#8211; Real Estate\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2021/01/Construction-Project.png\";s:12:\"tmpl_created\";i:1610463582;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/construction-project-real-estate/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:11:\"Real Estate\";s:4:\"tags\";s:59:\"[\"Construction\",\"Landing Pages\",\"Real estate\",\"Realestate\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:796;s:11:\"trend_index\";i:724;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:279;a:20:{s:4:\"tmpl\";i:1244;s:2:\"id\";i:21393;s:5:\"title\";s:34:\"Interior Designer &#8211; Projects\";s:9:\"thumbnail\";s:99:\"https://library.elementor.com/wp-content/uploads/2021/12/big-22-Projects-Interior-Designer-New.jpeg\";s:12:\"tmpl_created\";i:1638823945;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/interior-designer-projects/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:93:\"[\"Creative\",\"Creative Portfolio\",\"Design\",\"Designer\",\"Interior Design\",\"Portfolio\",\"Project\"]\";s:10:\"menu_order\";i:40;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:280;a:20:{s:4:\"tmpl\";i:1148;s:2:\"id\";i:16960;s:5:\"title\";s:44:\"Dog &amp; Cat Food Delivery &#8211; Business\";s:9:\"thumbnail\";s:69:\"https://library.elementor.com/wp-content/uploads/2021/01/Dog-Food.png\";s:12:\"tmpl_created\";i:1610533581;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/lp/dog-cat-food-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:71:\"[\"Business\",\"Cat\",\"Delivery\",\"Dog\",\"Food\",\"Landing Pages\",\"Pet\",\"Pets\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:782;s:11:\"trend_index\";i:510;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:281;a:20:{s:4:\"tmpl\";i:670;s:2:\"id\";i:8525;s:5:\"title\";s:11:\"404 page 08\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2018/05/008.jpg\";s:12:\"tmpl_created\";i:1526415374;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/blocks/404-page-08/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"404 page\";s:4:\"tags\";s:2:\"[]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:510;s:11:\"trend_index\";i:575;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:282;a:20:{s:4:\"tmpl\";i:1251;s:2:\"id\";i:22143;s:5:\"title\";s:33:\"Fashion Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/05/Library-Pic-Fashion-Store.png\";s:12:\"tmpl_created\";i:1647177389;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/fashion-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:56:\"[\"Coming Soon\",\"Fashion\",\"Landing Pages\",\"Shop\",\"store\"]\";s:10:\"menu_order\";i:41;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:283;a:20:{s:4:\"tmpl\";i:1155;s:2:\"id\";i:17095;s:5:\"title\";s:36:\"Mobile Pet Grooming &#8211; Business\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Mobile-Pet-Grooming.png\";s:12:\"tmpl_created\";i:1610632115;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/mobile-pet-grooming-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:38:\"[\"Dog\",\"Groom\",\"Landing Pages\",\"Pets\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:786;s:11:\"trend_index\";i:731;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:284;a:20:{s:4:\"tmpl\";i:1241;s:2:\"id\";i:21451;s:5:\"title\";s:26:\"Exhibition &#8211; Gallery\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/12/21-Gallery-Exhibition.jpg\";s:12:\"tmpl_created\";i:1638821855;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:117:\"https://library.elementor.com/exhibition-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:74:\"[\"Art\",\"Creative\",\"Creative Portfolio\",\"Exhibition\",\"Gallery\",\"Portfolio\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:285;a:20:{s:4:\"tmpl\";i:502;s:2:\"id\";i:5438;s:5:\"title\";s:7:\"About 1\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_4.png\";s:12:\"tmpl_created\";i:1520443512;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:113:\"https://library.elementor.com/blocks/about-1/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:42;s:16:\"popularity_index\";i:147;s:11:\"trend_index\";i:9;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:286;a:20:{s:4:\"tmpl\";i:1159;s:2:\"id\";i:17245;s:5:\"title\";s:34:\"Marketing Course &#8211; Education\";s:9:\"thumbnail\";s:64:\"https://library.elementor.com/wp-content/uploads/2021/01/PPC.png\";s:12:\"tmpl_created\";i:1610902958;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/marketing-course-education/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:9:\"Education\";s:4:\"tags\";s:45:\"[\"Course Online\",\"Landing Pages\",\"Marketing\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:770;s:11:\"trend_index\";i:430;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:287;a:20:{s:4:\"tmpl\";i:1240;s:2:\"id\";i:21430;s:5:\"title\";s:30:\"Travel Blogger &#8211; Gallery\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2021/12/19-Gallery-Travel-Blogger.jpg\";s:12:\"tmpl_created\";i:1638821592;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:121:\"https://library.elementor.com/travel-blogger-gallery/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:43:\"[\"Gallery\",\"Photography\",\"Slider\",\"Travel\"]\";s:10:\"menu_order\";i:43;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:288;a:20:{s:4:\"tmpl\";i:1149;s:2:\"id\";i:16983;s:5:\"title\";s:41:\"Pilates Instructor &#8211; Online Service\";s:9:\"thumbnail\";s:79:\"https://library.elementor.com/wp-content/uploads/2021/01/Pilates-Instructor.png\";s:12:\"tmpl_created\";i:1610534138;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:135:\"https://library.elementor.com/lp/pilates-instructor-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:70:\"[\"Free Trial\",\"Instructor\",\"Landing Pages\",\"Online Service\",\"Pilates\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:778;s:11:\"trend_index\";i:412;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:289;a:20:{s:4:\"tmpl\";i:1416;s:2:\"id\";i:24104;s:5:\"title\";s:33:\"Ceramics Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Ceramics-Shop.jpg\";s:12:\"tmpl_created\";i:1650988949;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/ceramics-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:115:\"[\"Art\",\"Business\",\"Coming Soon\",\"Creative\",\"Decor\",\"Design\",\"Furniture Design\",\"Interior Design\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:44;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:290;a:20:{s:4:\"tmpl\";i:557;s:2:\"id\";i:6135;s:5:\"title\";s:8:\"About 10\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_2.png\";s:12:\"tmpl_created\";i:1520443663;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-10/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:77;s:11:\"trend_index\";i:47;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:291;a:20:{s:4:\"tmpl\";i:1412;s:2:\"id\";i:24033;s:5:\"title\";s:37:\"Dance Studio &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Dance-Studio.jpg\";s:12:\"tmpl_created\";i:1649881344;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/dance-studio-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:113:\"[\"Academy\",\"Business\",\"Dance Studio\",\"Form\",\"Pilates\",\"School\",\"Sport\",\"Teacher\",\"Training\",\"Under Construction\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:292;a:20:{s:4:\"tmpl\";i:1190;s:2:\"id\";i:18568;s:5:\"title\";s:32:\"Flower Delivery &#8211; Business\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/04/Flower-Delivery.png\";s:12:\"tmpl_created\";i:1617546716;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/lp/flower-delivery-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:37:\"[\"Delivery\",\"Flower\",\"Landing Pages\"]\";s:10:\"menu_order\";i:45;s:16:\"popularity_index\";i:874;s:11:\"trend_index\";i:763;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:293;a:20:{s:4:\"tmpl\";i:1145;s:2:\"id\";i:16917;s:5:\"title\";s:22:\"Webinar &#8211; Events\";s:9:\"thumbnail\";s:80:\"https://library.elementor.com/wp-content/uploads/2021/01/Webinar-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610466822;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:116:\"https://library.elementor.com/lp/webinar-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:36:\"[\"Events\",\"Landing Pages\",\"Webinar\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:821;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:294;a:20:{s:4:\"tmpl\";i:1413;s:2:\"id\";i:24049;s:5:\"title\";s:33:\"ECO Shop &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-ECO-Shop.jpg\";s:12:\"tmpl_created\";i:1649882053;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/eco-shop-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:110:\"[\"Aesthetic\",\"Business\",\"Creative\",\"Decor\",\"Health\",\"Help\",\"Lifestyle\",\"Products\",\"Shop\",\"Under Construction\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:295;a:20:{s:4:\"tmpl\";i:497;s:2:\"id\";i:5397;s:5:\"title\";s:8:\"About 11\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_1.png\";s:12:\"tmpl_created\";i:1520443503;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-11/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:46;s:16:\"popularity_index\";i:148;s:11:\"trend_index\";i:43;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:296;a:20:{s:4:\"tmpl\";i:1154;s:2:\"id\";i:17079;s:5:\"title\";s:42:\"Calls Volunteer &#8211; Social Involvement\";s:9:\"thumbnail\";s:76:\"https://library.elementor.com/wp-content/uploads/2021/01/Calls-Volunteer.png\";s:12:\"tmpl_created\";i:1610631774;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:136:\"https://library.elementor.com/lp/calls-volunteer-social-involvement/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Social Involvement\";s:4:\"tags\";s:68:\"[\"Care\",\"Covid-19\",\"Help\",\"Involvement\",\"Landing Pages\",\"Volunteer\"]\";s:10:\"menu_order\";i:47;s:16:\"popularity_index\";i:854;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:297;a:20:{s:4:\"tmpl\";i:1419;s:2:\"id\";i:24136;s:5:\"title\";s:29:\"Food Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Food-Blog.jpg\";s:12:\"tmpl_created\";i:1650990034;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/food-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:62:\"[\"Blog\",\"Business\",\"Coming Soon\",\"Cooking\",\"Education\",\"Food\"]\";s:10:\"menu_order\";i:47;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:298;a:20:{s:4:\"tmpl\";i:1142;s:2:\"id\";i:16836;s:5:\"title\";s:33:\"Marketing Agency &#8211; Business\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/01/Marketing-Agency-Library-Pic.jpg\";s:12:\"tmpl_created\";i:1610464490;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/marketing-agency-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:74:\"[\"Agency\",\"Business\",\"Landing Pages\",\"Marketing\",\"Marketing Landing Page\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:816;s:11:\"trend_index\";i:787;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:299;a:20:{s:4:\"tmpl\";i:1411;s:2:\"id\";i:24020;s:5:\"title\";s:35:\"Mobile App &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Mobile-App.jpg\";s:12:\"tmpl_created\";i:1649880955;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:126:\"https://library.elementor.com/mobile-app-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:77:\"[\"App\",\"Business\",\"Coding\",\"Computer\",\"Launch\",\"Mobile\",\"Under Construction\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:300;a:20:{s:4:\"tmpl\";i:498;s:2:\"id\";i:5405;s:5:\"title\";s:8:\"About 12\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_1.png\";s:12:\"tmpl_created\";i:1520443505;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-12/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:48;s:16:\"popularity_index\";i:216;s:11:\"trend_index\";i:50;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:301;a:20:{s:4:\"tmpl\";i:1139;s:2:\"id\";i:16785;s:5:\"title\";s:42:\"Gym Promotion &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:67:\"https://library.elementor.com/wp-content/uploads/2021/01/Gym-LP.jpg\";s:12:\"tmpl_created\";i:1610455496;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/gym-promotion-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:42:\"[\"Fitness\",\"Gym\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:49;s:16:\"popularity_index\";i:820;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:302;a:20:{s:4:\"tmpl\";i:1420;s:2:\"id\";i:24152;s:5:\"title\";s:32:\"Perfume Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Perfume-Shop.jpg\";s:12:\"tmpl_created\";i:1650990353;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/perfume-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:68:\"[\"Business\",\"Coming Soon\",\"Cosmetics\",\"Lifestyle\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:49;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:303;a:20:{s:4:\"tmpl\";i:1185;s:2:\"id\";i:18492;s:5:\"title\";s:34:\"Bicycle Pre-Sale &#8211; eCommerce\";s:9:\"thumbnail\";s:90:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Bike-Landing-Page.png\";s:12:\"tmpl_created\";i:1617535552;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/lp/bicycle-pre-sale-ecommerce/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:9:\"eCommerce\";s:4:\"tags\";s:34:\"[\"Bicycle\",\"Landing Pages\",\"Sale\"]\";s:10:\"menu_order\";i:50;s:16:\"popularity_index\";i:871;s:11:\"trend_index\";i:826;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:304;a:20:{s:4:\"tmpl\";i:1418;s:2:\"id\";i:24126;s:5:\"title\";s:28:\"Skincare &#8211; Coming Soon\";s:9:\"thumbnail\";s:81:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Skincare.jpg\";s:12:\"tmpl_created\";i:1650989585;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/skincare-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:128:\"[\"Aesthetic\",\"Beauty\",\"Beauty Salon\",\"Business\",\"Coming Soon\",\"Cosmetics\",\"Girly\",\"Lifestyle\",\"Services\",\"Skincare\",\"Treatment\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:305;a:20:{s:4:\"tmpl\";i:1181;s:2:\"id\";i:18349;s:5:\"title\";s:39:\"Virtual try-on glasses &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-8.png\";s:12:\"tmpl_created\";i:1614772569;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/lp/virtual-try-on-glasses-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:64:\"[\"Fashion\",\"Glasses\",\"Landing Pages\",\"Online Service\",\"Virtual\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:848;s:11:\"trend_index\";i:803;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:306;a:20:{s:4:\"tmpl\";i:500;s:2:\"id\";i:5421;s:5:\"title\";s:8:\"About 13\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_3.png\";s:12:\"tmpl_created\";i:1520443509;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-13/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:51;s:16:\"popularity_index\";i:215;s:11:\"trend_index\";i:77;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:307;a:20:{s:4:\"tmpl\";i:513;s:2:\"id\";i:5533;s:5:\"title\";s:8:\"About 15\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_10.png\";s:12:\"tmpl_created\";i:1520443534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-15/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:21;s:11:\"trend_index\";i:57;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:308;a:20:{s:4:\"tmpl\";i:1410;s:2:\"id\";i:24004;s:5:\"title\";s:33:\"Skincare &#8211; Maintenance Mode\";s:9:\"thumbnail\";s:86:\"https://library.elementor.com/wp-content/uploads/2022/04/Maintenance-Mode-Skincare.jpg\";s:12:\"tmpl_created\";i:1649880534;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/skincare-maintenance-mode/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:144:\"[\"Aesthetic\",\"Beauty\",\"Beauty Salon\",\"Business\",\"Cosmetics\",\"Girly\",\"Lifestyle\",\"Makeup\",\"Services\",\"Skincare\",\"Treatment\",\"Under Construction\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:309;a:20:{s:4:\"tmpl\";i:1172;s:2:\"id\";i:17458;s:5:\"title\";s:31:\"Moving Company &#8211; Business\";s:9:\"thumbnail\";s:87:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-Moving-Company.png\";s:12:\"tmpl_created\";i:1612727025;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:125:\"https://library.elementor.com/lp/moving-company-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:46:\"[\"Business\",\"Landing Pages\",\"Movers\",\"Moving\"]\";s:10:\"menu_order\";i:52;s:16:\"popularity_index\";i:826;s:11:\"trend_index\";i:767;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:310;a:20:{s:4:\"tmpl\";i:1415;s:2:\"id\";i:24092;s:5:\"title\";s:29:\"Vase Shop &#8211; Coming Soon\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2022/04/Coming-Soon-Vase-Shop.jpg\";s:12:\"tmpl_created\";i:1650988613;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:120:\"https://library.elementor.com/vase-shop-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:115:\"[\"Art\",\"Business\",\"Coming Soon\",\"Creative\",\"Decor\",\"Design\",\"Furniture Design\",\"Interior Design\",\"Products\",\"Shop\"]\";s:10:\"menu_order\";i:53;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:311;a:20:{s:4:\"tmpl\";i:1186;s:2:\"id\";i:18517;s:5:\"title\";s:29:\"Food Blog &#8211; Coming Soon\";s:9:\"thumbnail\";s:82:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Food-Blog.png\";s:12:\"tmpl_created\";i:1617539897;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/food-blog-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:45:\"[\"Blog\",\"Coming Soon\",\"Food\",\"Landing Pages\"]\";s:10:\"menu_order\";i:53;s:16:\"popularity_index\";i:844;s:11:\"trend_index\";i:672;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:312;a:20:{s:4:\"tmpl\";i:1167;s:2:\"id\";i:17379;s:5:\"title\";s:33:\"IT Service &#8211; Online Service\";s:9:\"thumbnail\";s:83:\"https://library.elementor.com/wp-content/uploads/2021/02/Library-Pic-IT-Service.png\";s:12:\"tmpl_created\";i:1612713022;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:127:\"https://library.elementor.com/lp/it-service-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:41:\"[\"IT\",\"Landing Pages\",\"Remote\",\"Support\"]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:806;s:11:\"trend_index\";i:634;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:313;a:20:{s:4:\"tmpl\";i:1248;s:2:\"id\";i:22134;s:5:\"title\";s:32:\"Art Magazine &#8211; Coming Soon\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/10/Art-Magazine-Coming-Soon-250x280-1.jpg\";s:12:\"tmpl_created\";i:1647176713;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/art-magazine-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:48:\"[\"Art\",\"Coming Soon\",\"Landing Pages\",\"Magazine\"]\";s:10:\"menu_order\";i:54;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:314;a:20:{s:4:\"tmpl\";i:512;s:2:\"id\";i:5525;s:5:\"title\";s:8:\"About 14\";s:9:\"thumbnail\";s:75:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_10.png\";s:12:\"tmpl_created\";i:1520443532;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-14/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:9;s:11:\"trend_index\";i:29;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:315;a:20:{s:4:\"tmpl\";i:1189;s:2:\"id\";i:18560;s:5:\"title\";s:52:\"Finance Learning Platform &#8211; Under Construction\";s:9:\"thumbnail\";s:89:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Finance-Platform.png\";s:12:\"tmpl_created\";i:1617542761;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:146:\"https://library.elementor.com/lp/finance-learning-platform-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:27:\"[\"Finance\",\"Landing Pages\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:843;s:11:\"trend_index\";i:561;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:316;a:20:{s:4:\"tmpl\";i:1225;s:2:\"id\";i:21041;s:5:\"title\";s:41:\"Business Consulting Company &#8211; About\";s:9:\"thumbnail\";s:96:\"https://library.elementor.com/wp-content/uploads/2021/12/8-About-Business-Consulting-Company.jpg\";s:12:\"tmpl_created\";i:1638797560;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:132:\"https://library.elementor.com/business-consulting-company-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"Coach\",\"Collaboration\",\"Consulting\",\"Life Coach\"]\";s:10:\"menu_order\";i:55;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:317;a:20:{s:4:\"tmpl\";i:1187;s:2:\"id\";i:18528;s:5:\"title\";s:36:\"Home Decor Store &#8211; Coming Soon\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Home-Decore.png\";s:12:\"tmpl_created\";i:1617541784;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:130:\"https://library.elementor.com/lp/home-decor-store-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:16:\"Coming Soon Page\";s:4:\"tags\";s:57:\"[\"Coming Soon\",\"Decor\",\"Interior Design\",\"Landing Pages\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:872;s:11:\"trend_index\";i:819;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:318;a:20:{s:4:\"tmpl\";i:1243;s:2:\"id\";i:21135;s:5:\"title\";s:28:\"Construction &#8211; Service\";s:9:\"thumbnail\";s:84:\"https://library.elementor.com/wp-content/uploads/2021/12/13-Service-Construction.jpg\";s:12:\"tmpl_created\";i:1638823202;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:119:\"https://library.elementor.com/construction-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:48:\"[\"Architecture\",\"Construction\",\"Faq\",\"Services\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:319;a:20:{s:4:\"tmpl\";i:501;s:2:\"id\";i:5429;s:5:\"title\";s:8:\"About 16\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_4.png\";s:12:\"tmpl_created\";i:1520443510;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-16/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:56;s:16:\"popularity_index\";i:59;s:11:\"trend_index\";i:8;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:320;a:20:{s:4:\"tmpl\";i:1174;s:2:\"id\";i:17504;s:5:\"title\";s:29:\"Hair Stylist &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-3.png\";s:12:\"tmpl_created\";i:1612883014;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:123:\"https://library.elementor.com/lp/hair-stylist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:59:\"[\"Business\",\"Hair\",\"hairdresser\",\"Landing Pages\",\"Stylist\"]\";s:10:\"menu_order\";i:57;s:16:\"popularity_index\";i:840;s:11:\"trend_index\";i:806;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:321;a:20:{s:4:\"tmpl\";i:1223;s:2:\"id\";i:20981;s:5:\"title\";s:37:\"Creative Digital Agency &#8211; About\";s:9:\"thumbnail\";s:92:\"https://library.elementor.com/wp-content/uploads/2021/12/6-About-Creative-Digital-Agency.jpg\";s:12:\"tmpl_created\";i:1638789303;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:128:\"https://library.elementor.com/creative-digital-agency-about/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:51:\"[\"About\",\"Advisor\",\"Creative\",\"Creative Portfolio\"]\";s:10:\"menu_order\";i:57;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:322;a:20:{s:4:\"tmpl\";i:1184;s:2:\"id\";i:18449;s:5:\"title\";s:45:\"Aesthetic Clinic &#8211; Health &amp; Fitness\";s:9:\"thumbnail\";s:77:\"https://library.elementor.com/wp-content/uploads/2021/03/Aesthetic-Clinic.png\";s:12:\"tmpl_created\";i:1616682181;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/lp/aesthetic-clinic-health-fitness/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Health and Fitness\";s:4:\"tags\";s:57:\"[\"Aesthetic\",\"Beauty\",\"Fitness\",\"Health\",\"Landing Pages\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:859;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:323;a:20:{s:4:\"tmpl\";i:1221;s:2:\"id\";i:20926;s:5:\"title\";s:33:\"Doctors Online Consultation -Home\";s:9:\"thumbnail\";s:95:\"https://library.elementor.com/wp-content/uploads/2021/12/4-Home-Doctors-Online-Consultation.jpg\";s:12:\"tmpl_created\";i:1638787371;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:131:\"https://library.elementor.com/doctors-online-consultation-home/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:35:\"[\"App\",\"Health\",\"Medical\",\"Online\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:324;a:20:{s:4:\"tmpl\";i:505;s:2:\"id\";i:5464;s:5:\"title\";s:8:\"About 17\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_6.png\";s:12:\"tmpl_created\";i:1520443518;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-17/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:58;s:16:\"popularity_index\";i:220;s:11:\"trend_index\";i:142;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:325;a:20:{s:4:\"tmpl\";i:1165;s:2:\"id\";i:17353;s:5:\"title\";s:44:\"Online Cooking Course &#8211; Online Service\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/02/250x280-2.png\";s:12:\"tmpl_created\";i:1612705144;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:138:\"https://library.elementor.com/lp/online-cooking-course-online-service/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:14:\"Online Service\";s:4:\"tags\";s:50:\"[\"Cooking\",\"Course Online\",\"Food\",\"Landing Pages\"]\";s:10:\"menu_order\";i:59;s:16:\"popularity_index\";i:845;s:11:\"trend_index\";i:0;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:326;a:20:{s:4:\"tmpl\";i:1188;s:2:\"id\";i:18550;s:5:\"title\";s:39:\"Online Store &#8211; Under Construction\";s:9:\"thumbnail\";s:85:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Online-Store.png\";s:12:\"tmpl_created\";i:1617542506;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:133:\"https://library.elementor.com/lp/online-store-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:59:\"[\"Landing Pages\",\"Online Shop\",\"Shop\",\"Under Construction\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:832;s:11:\"trend_index\";i:600;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:327;a:20:{s:4:\"tmpl\";i:1250;s:2:\"id\";i:22140;s:5:\"title\";s:33:\"Design School &#8211; Coming Soon\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/05/250x280-1.png\";s:12:\"tmpl_created\";i:1647177317;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/design-school-coming-soon/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:4:\"page\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:4:\"page\";s:4:\"tags\";s:49:\"[\"Coming Soon\",\"Design\",\"Landing Pages\",\"School\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:-1;s:11:\"trend_index\";i:-1;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:328;a:20:{s:4:\"tmpl\";i:510;s:2:\"id\";i:5504;s:5:\"title\";s:8:\"About 18\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_white_9.png\";s:12:\"tmpl_created\";i:1520443528;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-18/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:5:\"block\";s:11:\"access_tier\";s:4:\"free\";s:7:\"subtype\";s:5:\"about\";s:4:\"tags\";s:9:\"[\"About\"]\";s:10:\"menu_order\";i:60;s:16:\"popularity_index\";i:104;s:11:\"trend_index\";i:46;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"0\";s:6:\"is_pro\";s:1:\"0\";s:12:\"access_level\";i:0;}i:329;a:20:{s:4:\"tmpl\";i:1191;s:2:\"id\";i:18539;s:5:\"title\";s:40:\"Travel Agency &#8211; Under Construction\";s:9:\"thumbnail\";s:88:\"https://library.elementor.com/wp-content/uploads/2021/04/Library-Pic-Travel-Agency-1.png\";s:12:\"tmpl_created\";i:1617610273;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:134:\"https://library.elementor.com/lp/travel-agency-under-construction/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:18:\"Under Construction\";s:4:\"tags\";s:56:\"[\"Agency\",\"Landing Pages\",\"Travel\",\"Under Construction\"]\";s:10:\"menu_order\";i:61;s:16:\"popularity_index\";i:876;s:11:\"trend_index\";i:652;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:330;a:20:{s:4:\"tmpl\";i:1175;s:2:\"id\";i:18270;s:5:\"title\";s:24:\"Open week &#8211; Events\";s:9:\"thumbnail\";s:68:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280.png\";s:12:\"tmpl_created\";i:1614767186;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:118:\"https://library.elementor.com/lp/open-week-events/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:6:\"Events\";s:4:\"tags\";s:59:\"[\"Education\",\"Event\",\"Events\",\"Landing Pages\",\"University\"]\";s:10:\"menu_order\";i:62;s:16:\"popularity_index\";i:831;s:11:\"trend_index\";i:673;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:331;a:20:{s:4:\"tmpl\";i:1177;s:2:\"id\";i:18300;s:5:\"title\";s:30:\"Makeup Artist &#8211; Business\";s:9:\"thumbnail\";s:70:\"https://library.elementor.com/wp-content/uploads/2021/03/250x280-2.png\";s:12:\"tmpl_created\";i:1614768608;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:124:\"https://library.elementor.com/lp/makeup-artist-business/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s:2:\"lp\";s:11:\"access_tier\";s:9:\"essential\";s:7:\"subtype\";s:8:\"Business\";s:4:\"tags\";s:79:\"[\"Beauty\",\"Business\",\"Course Online\",\"Landing Pages\",\"Makeup\",\"Online Service\"]\";s:10:\"menu_order\";i:63;s:16:\"popularity_index\";i:861;s:11:\"trend_index\";i:783;s:18:\"editor_layout_type\";s:0:\"\";s:15:\"minimum_version\";s:5:\"0.0.0\";s:8:\"products\";s:7:\"regular\";s:17:\"has_page_settings\";s:1:\"1\";s:6:\"is_pro\";s:1:\"1\";s:12:\"access_level\";i:1;}i:332;a:20:{s:4:\"tmpl\";i:511;s:2:\"id\";i:5515;s:5:\"title\";s:8:\"About 19\";s:9:\"thumbnail\";s:74:\"https://library.elementor.com/wp-content/uploads/2018/03/about_black_9.png\";s:12:\"tmpl_created\";i:1520443530;s:6:\"author\";s:9:\"Elementor\";s:3:\"url\";s:114:\"https://library.elementor.com/blocks/about-19/?utm_source=template-library&utm_medium=wp-dash&utm_campaign=preview\";s:4:\"type\";s