/* DUPLICATOR-LITE (PHP BUILD MODE) MYSQL SCRIPT CREATED ON : 2024-12-26 13:22:43 */

/*!40101 SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='NO_AUTO_VALUE_ON_ZERO' */;

SET FOREIGN_KEY_CHECKS = 0;

CREATE TABLE `wp_actionscheduler_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `hook` varchar(191) NOT NULL,
  `status` varchar(20) NOT NULL,
  `scheduled_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `scheduled_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  `args` varchar(191) DEFAULT NULL,
  `schedule` longtext DEFAULT NULL,
  `group_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `attempts` int(11) NOT NULL DEFAULT 0,
  `last_attempt_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `last_attempt_local` datetime DEFAULT '0000-00-00 00:00:00',
  `claim_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `extended_args` varchar(8000) DEFAULT NULL,
  `priority` tinyint(3) unsigned NOT NULL DEFAULT 10,
  PRIMARY KEY (`action_id`),
  KEY `hook` (`hook`),
  KEY `status` (`status`),
  KEY `scheduled_date_gmt` (`scheduled_date_gmt`),
  KEY `args` (`args`),
  KEY `group_id` (`group_id`),
  KEY `last_attempt_gmt` (`last_attempt_gmt`),
  KEY `claim_id` (`claim_id`),
  KEY `claim_id_status_scheduled_date_gmt` (`claim_id`,`status`,`scheduled_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=4307 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_claims` (
  `claim_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `date_created_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`claim_id`),
  KEY `date_created_gmt` (`date_created_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=143821 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_groups` (
  `group_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `slug` varchar(255) NOT NULL,
  PRIMARY KEY (`group_id`),
  KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_actionscheduler_logs` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `action_id` bigint(20) unsigned NOT NULL,
  `message` text NOT NULL,
  `log_date_gmt` datetime DEFAULT '0000-00-00 00:00:00',
  `log_date_local` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`log_id`),
  KEY `action_id` (`action_id`),
  KEY `log_date_gmt` (`log_date_gmt`)
) ENGINE=InnoDB AUTO_INCREMENT=12901 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_appwoodart_woo_api_geo_fencing` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `post_id` int(11) NOT NULL,
  `radius` text NOT NULL,
  `lat` double NOT NULL,
  `lng` double NOT NULL,
  `zoom` int(4) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_appwoodart_woo_api_notifications` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `device_token` text NOT NULL,
  `device_type` tinyint(4) NOT NULL,
  `status` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_appwoodart_woo_api_notifications_meta` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `msg` text NOT NULL,
  `custom_msg` text NOT NULL,
  `not_code` tinyint(4) NOT NULL,
  `created` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_appwoodart_woo_api_notifications_relationships` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `not_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `push_meta_id` bigint(20) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `push_meta_id` (`push_meta_id`),
  CONSTRAINT `wp_appwoodart_woo_api_notifications_relationships_ibfk_2` FOREIGN KEY (`push_meta_id`) REFERENCES `wp_appwoodart_woo_api_notifications_meta` (`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_appwoodart_woo_api_scratch_coupons` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `coupon_id` int(10) unsigned NOT NULL,
  `user_id` int(10) unsigned NOT NULL,
  `device_token` text NOT NULL,
  `is_coupon_scratched` varchar(5) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_commentmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `comment_id` (`comment_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_comments` (
  `comment_ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `comment_post_ID` bigint(20) unsigned NOT NULL DEFAULT 0,
  `comment_author` tinytext NOT NULL,
  `comment_author_email` varchar(100) NOT NULL DEFAULT '',
  `comment_author_url` varchar(200) NOT NULL DEFAULT '',
  `comment_author_IP` varchar(100) NOT NULL DEFAULT '',
  `comment_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `comment_content` text NOT NULL,
  `comment_karma` int(11) NOT NULL DEFAULT 0,
  `comment_approved` varchar(20) NOT NULL DEFAULT '1',
  `comment_agent` varchar(255) NOT NULL DEFAULT '',
  `comment_type` varchar(20) NOT NULL DEFAULT 'comment',
  `comment_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`comment_ID`),
  KEY `comment_post_ID` (`comment_post_ID`),
  KEY `comment_approved_date_gmt` (`comment_approved`,`comment_date_gmt`),
  KEY `comment_date_gmt` (`comment_date_gmt`),
  KEY `comment_parent` (`comment_parent`),
  KEY `comment_author_email` (`comment_author_email`(10)),
  KEY `woo_idx_comment_type` (`comment_type`)
) ENGINE=InnoDB AUTO_INCREMENT=60 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_dokan_announcement` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `post_id` bigint(11) NOT NULL,
  `status` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_dokan_orders` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) DEFAULT NULL,
  `seller_id` bigint(20) DEFAULT NULL,
  `order_total` decimal(19,4) DEFAULT NULL,
  `net_amount` decimal(19,4) DEFAULT NULL,
  `order_status` varchar(30) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`),
  KEY `seller_id` (`seller_id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_dokan_refund` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `seller_id` bigint(20) NOT NULL,
  `refund_amount` decimal(19,4) NOT NULL,
  `refund_reason` text DEFAULT NULL,
  `item_qtys` varchar(200) DEFAULT NULL,
  `item_totals` text DEFAULT NULL,
  `item_tax_totals` text DEFAULT NULL,
  `restock_items` varchar(10) DEFAULT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `status` int(1) NOT NULL,
  `method` varchar(30) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_dokan_reverse_withdrawal` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `trn_id` bigint(20) unsigned NOT NULL,
  `trn_type` varchar(200) NOT NULL DEFAULT 'order_commission',
  `vendor_id` bigint(20) unsigned NOT NULL,
  `note` mediumtext DEFAULT NULL,
  `debit` decimal(19,4) NOT NULL DEFAULT 0.0000,
  `credit` decimal(19,4) NOT NULL DEFAULT 0.0000,
  `trn_date` int(11) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `trn_date` (`trn_date`),
  KEY `vendor_id_trn_date` (`vendor_id`,`trn_date`),
  KEY `vendor_id` (`vendor_id`),
  KEY `trn_id_type` (`trn_id`,`trn_type`(191)),
  KEY `vendor_id_trn_date_type` (`vendor_id`,`trn_date`,`trn_type`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_dokan_vendor_balance` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `vendor_id` bigint(20) unsigned NOT NULL,
  `trn_id` bigint(20) unsigned NOT NULL,
  `trn_type` varchar(30) NOT NULL,
  `perticulars` text NOT NULL,
  `debit` decimal(19,4) NOT NULL,
  `credit` decimal(19,4) NOT NULL,
  `status` varchar(30) DEFAULT NULL,
  `trn_date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `balance_date` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_dokan_withdraw` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `amount` decimal(19,4) NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `status` int(1) NOT NULL,
  `method` varchar(30) NOT NULL,
  `note` text NOT NULL,
  `details` longtext DEFAULT NULL,
  `ip` varchar(50) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_duplicator_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_duplicator_pro_entities` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) DEFAULT NULL,
  `data` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type_idx` (`type`)
) ENGINE=InnoDB AUTO_INCREMENT=6 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_duplicator_pro_packages` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(250) NOT NULL,
  `hash` varchar(50) NOT NULL,
  `status` int(11) NOT NULL,
  `created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `owner` varchar(60) NOT NULL,
  `package` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_e_events` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `event_data` text DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `created_at_index` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gla_budget_recommendations` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `currency` varchar(3) NOT NULL,
  `country` varchar(2) NOT NULL,
  `daily_budget_low` int(11) NOT NULL,
  `daily_budget_high` int(11) NOT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `country_currency` (`country`,`currency`)
) ENGINE=InnoDB AUTO_INCREMENT=4231 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gla_merchant_issues` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `product_id` bigint(20) NOT NULL,
  `issue` varchar(200) NOT NULL,
  `code` varchar(100) NOT NULL,
  `severity` varchar(20) NOT NULL DEFAULT 'warning',
  `product` varchar(100) NOT NULL,
  `action` varchar(100) NOT NULL,
  `action_url` varchar(1024) NOT NULL,
  `applicable_countries` text NOT NULL,
  `source` varchar(10) NOT NULL DEFAULT 'mc',
  `type` varchar(10) NOT NULL DEFAULT 'product',
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gla_shipping_rates` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `country` varchar(2) NOT NULL,
  `currency` varchar(3) NOT NULL,
  `rate` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `country` (`country`),
  KEY `currency` (`currency`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_gla_shipping_times` (
  `id` bigint(20) NOT NULL AUTO_INCREMENT,
  `country` varchar(2) NOT NULL,
  `time` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `country` (`country`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_links` (
  `link_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `link_url` varchar(255) NOT NULL DEFAULT '',
  `link_name` varchar(255) NOT NULL DEFAULT '',
  `link_image` varchar(255) NOT NULL DEFAULT '',
  `link_target` varchar(25) NOT NULL DEFAULT '',
  `link_description` varchar(255) NOT NULL DEFAULT '',
  `link_visible` varchar(20) NOT NULL DEFAULT 'Y',
  `link_owner` bigint(20) unsigned NOT NULL DEFAULT 1,
  `link_rating` int(11) NOT NULL DEFAULT 0,
  `link_updated` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `link_rel` varchar(255) NOT NULL DEFAULT '',
  `link_notes` mediumtext NOT NULL,
  `link_rss` varchar(255) NOT NULL DEFAULT '',
  PRIMARY KEY (`link_id`),
  KEY `link_visible` (`link_visible`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_custom_fields` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) NOT NULL,
  `type` varchar(90) NOT NULL,
  `params` longtext NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_dynamic_segment_filters` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `segment_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `filter_data` longblob DEFAULT NULL,
  `filter_type` varchar(255) DEFAULT NULL,
  `action` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `segment_id` (`segment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_feature_flags` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(100) NOT NULL,
  `value` tinyint(1) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_forms` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) NOT NULL,
  `status` varchar(20) NOT NULL DEFAULT 'enabled',
  `body` longtext DEFAULT NULL,
  `settings` longtext DEFAULT NULL,
  `styles` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_log` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `level` int(11) DEFAULT NULL,
  `message` longtext DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_mapping_to_external_entities` (
  `old_id` int(11) unsigned NOT NULL,
  `type` varchar(50) NOT NULL,
  `new_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`old_id`,`type`),
  KEY `new_id` (`new_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_newsletter_links` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `url` varchar(2083) NOT NULL,
  `hash` varchar(20) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `newsletter_id` (`newsletter_id`),
  KEY `queue_id` (`queue_id`),
  KEY `url` (`url`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_newsletter_option` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `option_field_id` int(11) unsigned NOT NULL,
  `value` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `newsletter_id_option_field_id` (`newsletter_id`,`option_field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_newsletter_option_fields` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) NOT NULL,
  `newsletter_type` varchar(90) NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `name_newsletter_type` (`newsletter_type`,`name`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_newsletter_posts` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `post_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `newsletter_id` (`newsletter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_newsletter_segment` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `segment_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `newsletter_segment` (`newsletter_id`,`segment_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_newsletter_templates` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) DEFAULT 0,
  `name` varchar(250) NOT NULL,
  `categories` varchar(250) NOT NULL DEFAULT '[]',
  `description` varchar(255) NOT NULL DEFAULT '',
  `body` longtext DEFAULT NULL,
  `thumbnail` longtext DEFAULT NULL,
  `thumbnail_data` longtext DEFAULT NULL,
  `readonly` tinyint(1) DEFAULT 0,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=77 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_newsletters` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `hash` varchar(150) DEFAULT NULL,
  `parent_id` int(11) unsigned DEFAULT NULL,
  `subject` varchar(250) NOT NULL DEFAULT '',
  `type` varchar(20) NOT NULL DEFAULT 'standard',
  `sender_address` varchar(150) NOT NULL DEFAULT '',
  `sender_name` varchar(150) NOT NULL DEFAULT '',
  `status` varchar(20) NOT NULL DEFAULT 'draft',
  `reply_to_address` varchar(150) NOT NULL DEFAULT '',
  `reply_to_name` varchar(150) NOT NULL DEFAULT '',
  `preheader` varchar(250) NOT NULL DEFAULT '',
  `body` longtext DEFAULT NULL,
  `sent_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  `unsubscribe_token` char(15) DEFAULT NULL,
  `ga_campaign` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  UNIQUE KEY `unsubscribe_token` (`unsubscribe_token`),
  KEY `type_status` (`type`,`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_scheduled_task_subscribers` (
  `task_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `processed` int(1) NOT NULL,
  `failed` smallint(1) NOT NULL DEFAULT 0,
  `error` text DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`task_id`,`subscriber_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_scheduled_tasks` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `type` varchar(90) DEFAULT NULL,
  `status` varchar(12) DEFAULT NULL,
  `priority` mediumint(9) NOT NULL DEFAULT 0,
  `scheduled_at` timestamp NULL DEFAULT NULL,
  `processed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  `in_progress` int(1) DEFAULT NULL,
  `reschedule_count` int(11) NOT NULL DEFAULT 0,
  `meta` longtext DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `type` (`type`),
  KEY `status` (`status`)
) ENGINE=InnoDB AUTO_INCREMENT=361 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_segments` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(90) NOT NULL,
  `type` varchar(90) NOT NULL DEFAULT 'default',
  `description` varchar(250) NOT NULL DEFAULT '',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  `average_engagement_score` float unsigned DEFAULT NULL,
  `average_engagement_score_updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`),
  KEY `average_engagement_score_updated_at` (`average_engagement_score_updated_at`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_sending_queues` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `task_id` int(11) unsigned NOT NULL,
  `newsletter_id` int(11) unsigned NOT NULL,
  `newsletter_rendered_body` longtext DEFAULT NULL,
  `newsletter_rendered_subject` varchar(250) DEFAULT NULL,
  `subscribers` longtext DEFAULT NULL,
  `count_total` int(11) unsigned NOT NULL DEFAULT 0,
  `count_processed` int(11) unsigned NOT NULL DEFAULT 0,
  `count_to_process` int(11) unsigned NOT NULL DEFAULT 0,
  `meta` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `task_id` (`task_id`),
  KEY `newsletter_id` (`newsletter_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_settings` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(50) NOT NULL,
  `value` longtext DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `name` (`name`)
) ENGINE=InnoDB AUTO_INCREMENT=103963 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_statistics_bounces` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_statistics_clicks` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `link_id` int(11) unsigned NOT NULL,
  `user_agent_id` int(11) unsigned DEFAULT NULL,
  `user_agent_type` tinyint(1) NOT NULL DEFAULT 0,
  `count` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `newsletter_id_subscriber_id_user_agent_type` (`newsletter_id`,`subscriber_id`,`user_agent_type`),
  KEY `queue_id` (`queue_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_statistics_forms` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `form_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `form_subscriber` (`form_id`,`subscriber_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_statistics_newsletters` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `sent_at` timestamp NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `newsletter_id` (`newsletter_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_statistics_opens` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `user_agent_id` int(11) unsigned DEFAULT NULL,
  `user_agent_type` tinyint(1) NOT NULL DEFAULT 0,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`),
  KEY `newsletter_id_subscriber_id_user_agent_type` (`newsletter_id`,`subscriber_id`,`user_agent_type`),
  KEY `queue_id` (`queue_id`),
  KEY `subscriber_id` (`subscriber_id`),
  KEY `created_at` (`created_at`),
  KEY `subscriber_id_created_at` (`subscriber_id`,`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_statistics_unsubscribes` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned DEFAULT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned DEFAULT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  `source` varchar(255) DEFAULT 'unknown',
  `meta` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `newsletter_id_subscriber_id` (`newsletter_id`,`subscriber_id`),
  KEY `queue_id` (`queue_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_statistics_woocommerce_purchases` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `subscriber_id` int(11) unsigned NOT NULL,
  `queue_id` int(11) unsigned NOT NULL,
  `click_id` int(11) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `order_currency` char(3) NOT NULL,
  `order_price_total` float NOT NULL COMMENT 'With shipping and taxes in order_currency',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `click_id_order_id` (`click_id`,`order_id`),
  KEY `newsletter_id` (`newsletter_id`),
  KEY `queue_id` (`queue_id`),
  KEY `subscriber_id` (`subscriber_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_stats_notifications` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `newsletter_id` int(11) unsigned NOT NULL,
  `task_id` int(11) unsigned NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `newsletter_id_task_id` (`newsletter_id`,`task_id`),
  KEY `task_id` (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_subscriber_custom_field` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `subscriber_id` int(11) unsigned NOT NULL,
  `custom_field_id` int(11) unsigned NOT NULL,
  `value` text NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `subscriber_id_custom_field_id` (`subscriber_id`,`custom_field_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_subscriber_ips` (
  `ip` varchar(45) NOT NULL,
  `created_at` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`created_at`,`ip`),
  KEY `ip` (`ip`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_subscriber_segment` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `subscriber_id` int(11) unsigned NOT NULL,
  `segment_id` int(11) unsigned NOT NULL,
  `status` varchar(12) NOT NULL DEFAULT 'subscribed',
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `subscriber_segment` (`subscriber_id`,`segment_id`),
  KEY `segment_id` (`segment_id`)
) ENGINE=InnoDB AUTO_INCREMENT=80 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_subscribers` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `wp_user_id` bigint(20) DEFAULT NULL,
  `is_woocommerce_user` int(1) NOT NULL DEFAULT 0,
  `first_name` varchar(255) NOT NULL DEFAULT '',
  `last_name` varchar(255) NOT NULL DEFAULT '',
  `email` varchar(150) NOT NULL,
  `status` varchar(12) NOT NULL DEFAULT 'unconfirmed',
  `subscribed_ip` varchar(45) DEFAULT NULL,
  `confirmed_ip` varchar(45) DEFAULT NULL,
  `confirmed_at` timestamp NULL DEFAULT NULL,
  `last_subscribed_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  `deleted_at` timestamp NULL DEFAULT NULL,
  `unconfirmed_data` longtext DEFAULT NULL,
  `source` enum('form','imported','administrator','api','wordpress_user','woocommerce_user','woocommerce_checkout','unknown') DEFAULT 'unknown',
  `count_confirmations` int(11) unsigned NOT NULL DEFAULT 0,
  `unsubscribe_token` char(15) DEFAULT NULL,
  `link_token` char(32) DEFAULT NULL,
  `engagement_score` float unsigned DEFAULT NULL,
  `engagement_score_updated_at` timestamp NULL DEFAULT NULL,
  `last_engagement_at` timestamp NULL DEFAULT NULL,
  `woocommerce_synced_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `email` (`email`),
  UNIQUE KEY `unsubscribe_token` (`unsubscribe_token`),
  KEY `wp_user_id` (`wp_user_id`),
  KEY `updated_at` (`updated_at`),
  KEY `status_deleted_at` (`status`,`deleted_at`),
  KEY `last_subscribed_at` (`last_subscribed_at`),
  KEY `engagement_score_updated_at` (`engagement_score_updated_at`),
  KEY `link_token` (`link_token`)
) ENGINE=InnoDB AUTO_INCREMENT=61 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_user_agents` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `hash` varchar(32) NOT NULL,
  `user_agent` text NOT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `hash` (`hash`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_mailpoet_user_flags` (
  `id` int(11) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `name` varchar(50) NOT NULL,
  `value` varchar(255) DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NOT NULL DEFAULT current_timestamp() ON UPDATE current_timestamp(),
  PRIMARY KEY (`id`),
  UNIQUE KEY `user_id_name` (`user_id`,`name`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_options` (
  `option_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `option_name` varchar(191) NOT NULL DEFAULT '',
  `option_value` longtext NOT NULL,
  `autoload` varchar(20) NOT NULL DEFAULT 'yes',
  PRIMARY KEY (`option_id`),
  UNIQUE KEY `option_name` (`option_name`),
  KEY `autoload` (`autoload`)
) ENGINE=InnoDB AUTO_INCREMENT=237760 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_postmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `post_id` (`post_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=15009 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_posts` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `post_author` bigint(20) unsigned NOT NULL DEFAULT 0,
  `post_date` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_date_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content` longtext NOT NULL,
  `post_title` text NOT NULL,
  `post_excerpt` text NOT NULL,
  `post_status` varchar(20) NOT NULL DEFAULT 'publish',
  `comment_status` varchar(20) NOT NULL DEFAULT 'open',
  `ping_status` varchar(20) NOT NULL DEFAULT 'open',
  `post_password` varchar(255) NOT NULL DEFAULT '',
  `post_name` varchar(200) NOT NULL DEFAULT '',
  `to_ping` text NOT NULL,
  `pinged` text NOT NULL,
  `post_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `post_content_filtered` longtext NOT NULL,
  `post_parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `guid` varchar(255) NOT NULL DEFAULT '',
  `menu_order` int(11) NOT NULL DEFAULT 0,
  `post_type` varchar(20) NOT NULL DEFAULT 'post',
  `post_mime_type` varchar(100) NOT NULL DEFAULT '',
  `comment_count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`ID`),
  KEY `post_name` (`post_name`(191)),
  KEY `type_status_date` (`post_type`,`post_status`,`post_date`,`ID`),
  KEY `post_parent` (`post_parent`),
  KEY `post_author` (`post_author`)
) ENGINE=InnoDB AUTO_INCREMENT=4181 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_revslider_css` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=InnoDB AUTO_INCREMENT=110 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_css_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `settings` longtext DEFAULT NULL,
  `hover` longtext DEFAULT NULL,
  `advanced` longtext DEFAULT NULL,
  `params` longtext NOT NULL,
  PRIMARY KEY (`id`),
  KEY `handle_index` (`handle`(64))
) ENGINE=InnoDB AUTO_INCREMENT=48 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_layer_animations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_layer_animations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `handle` text NOT NULL,
  `params` text NOT NULL,
  `settings` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_navigations` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_navigations_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `name` varchar(191) NOT NULL,
  `handle` varchar(191) NOT NULL,
  `type` varchar(191) NOT NULL,
  `css` longtext NOT NULL,
  `markup` longtext NOT NULL,
  `settings` longtext DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_sliders` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_sliders7` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_sliders_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `title` tinytext NOT NULL,
  `alias` tinytext DEFAULT NULL,
  `params` longtext NOT NULL,
  `settings` text DEFAULT NULL,
  `type` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `type_index` (`type`(8))
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_slides7` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(11) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  `static` varchar(191) NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_revslider_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `slide_order` int(11) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_static_slides` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_revslider_static_slides_bkp` (
  `id` int(9) NOT NULL AUTO_INCREMENT,
  `slider_id` int(9) NOT NULL,
  `params` longtext NOT NULL,
  `layers` longtext NOT NULL,
  `settings` text NOT NULL,
  PRIMARY KEY (`id`),
  KEY `slider_id_index` (`slider_id`)
) ENGINE=InnoDB DEFAULT CHARSET=latin1 COLLATE=latin1_swedish_ci;

CREATE TABLE `wp_rtl_rsm_logs` (
  `id` int(10) NOT NULL AUTO_INCREMENT,
  `type` varchar(255) NOT NULL,
  `section` varchar(255) NOT NULL,
  `result` mediumtext NOT NULL,
  `date` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=10 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_term_relationships` (
  `object_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_taxonomy_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `term_order` int(11) NOT NULL DEFAULT 0,
  PRIMARY KEY (`object_id`,`term_taxonomy_id`),
  KEY `term_taxonomy_id` (`term_taxonomy_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_term_taxonomy` (
  `term_taxonomy_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `taxonomy` varchar(32) NOT NULL DEFAULT '',
  `description` longtext NOT NULL,
  `parent` bigint(20) unsigned NOT NULL DEFAULT 0,
  `count` bigint(20) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_taxonomy_id`),
  UNIQUE KEY `term_id_taxonomy` (`term_id`,`taxonomy`),
  KEY `taxonomy` (`taxonomy`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_termmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `term_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `term_id` (`term_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=794 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_terms` (
  `term_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  `term_group` bigint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`term_id`),
  KEY `slug` (`slug`(191)),
  KEY `name` (`name`(191))
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_tm_taskmeta` (
  `meta_id` bigint(20) NOT NULL AUTO_INCREMENT,
  `task_id` bigint(20) NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `meta_key` (`meta_key`(191)),
  KEY `task_id` (`task_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_tm_tasks` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) NOT NULL,
  `type` varchar(300) NOT NULL,
  `class_identifier` varchar(300) DEFAULT '0',
  `attempts` int(11) DEFAULT 0,
  `description` varchar(300) DEFAULT NULL,
  `time_created` timestamp NOT NULL DEFAULT current_timestamp(),
  `last_locked_at` bigint(20) DEFAULT 0,
  `status` varchar(300) DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_usermeta` (
  `umeta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`umeta_id`),
  KEY `user_id` (`user_id`),
  KEY `meta_key` (`meta_key`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3280 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_users` (
  `ID` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_login` varchar(60) NOT NULL DEFAULT '',
  `user_pass` varchar(255) NOT NULL DEFAULT '',
  `user_nicename` varchar(50) NOT NULL DEFAULT '',
  `user_email` varchar(100) NOT NULL DEFAULT '',
  `user_url` varchar(100) NOT NULL DEFAULT '',
  `user_registered` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `user_activation_key` varchar(255) NOT NULL DEFAULT '',
  `user_status` int(11) NOT NULL DEFAULT 0,
  `display_name` varchar(250) NOT NULL DEFAULT '',
  PRIMARY KEY (`ID`),
  KEY `user_login_key` (`user_login`),
  KEY `user_nicename` (`user_nicename`),
  KEY `user_email` (`user_email`)
) ENGINE=InnoDB AUTO_INCREMENT=152 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_admin_note_actions` (
  `action_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `note_id` bigint(20) unsigned NOT NULL,
  `name` varchar(255) NOT NULL,
  `label` varchar(255) NOT NULL,
  `query` longtext NOT NULL,
  `status` varchar(255) NOT NULL,
  `actioned_text` varchar(255) NOT NULL,
  `nonce_action` varchar(255) DEFAULT NULL,
  `nonce_name` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`action_id`),
  KEY `note_id` (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=77721 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_admin_notes` (
  `note_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `type` varchar(20) NOT NULL,
  `locale` varchar(20) NOT NULL,
  `title` longtext NOT NULL,
  `content` longtext NOT NULL,
  `content_data` longtext DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `source` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_reminder` datetime DEFAULT NULL,
  `is_snoozable` tinyint(1) NOT NULL DEFAULT 0,
  `layout` varchar(20) NOT NULL DEFAULT '',
  `image` varchar(200) DEFAULT NULL,
  `is_deleted` tinyint(1) NOT NULL DEFAULT 0,
  `icon` varchar(200) NOT NULL DEFAULT 'info',
  `is_read` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`note_id`)
) ENGINE=InnoDB AUTO_INCREMENT=193 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_category_lookup` (
  `category_tree_id` bigint(20) unsigned NOT NULL,
  `category_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`category_tree_id`,`category_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_customer_lookup` (
  `customer_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `username` varchar(60) NOT NULL DEFAULT '',
  `first_name` varchar(255) NOT NULL,
  `last_name` varchar(255) NOT NULL,
  `email` varchar(100) DEFAULT NULL,
  `date_last_active` timestamp NULL DEFAULT NULL,
  `date_registered` timestamp NULL DEFAULT NULL,
  `country` char(2) NOT NULL DEFAULT '',
  `postcode` varchar(20) NOT NULL DEFAULT '',
  `city` varchar(100) NOT NULL DEFAULT '',
  `state` varchar(100) NOT NULL DEFAULT '',
  PRIMARY KEY (`customer_id`),
  UNIQUE KEY `user_id` (`user_id`),
  KEY `email` (`email`)
) ENGINE=InnoDB AUTO_INCREMENT=109 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_download_log` (
  `download_log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `permission_id` bigint(20) unsigned NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `user_ip_address` varchar(100) DEFAULT '',
  PRIMARY KEY (`download_log_id`),
  KEY `permission_id` (`permission_id`),
  KEY `timestamp` (`timestamp`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_addresses` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned NOT NULL,
  `address_type` varchar(20) DEFAULT NULL,
  `first_name` text DEFAULT NULL,
  `last_name` text DEFAULT NULL,
  `company` text DEFAULT NULL,
  `address_1` text DEFAULT NULL,
  `address_2` text DEFAULT NULL,
  `city` text DEFAULT NULL,
  `state` text DEFAULT NULL,
  `postcode` text DEFAULT NULL,
  `country` text DEFAULT NULL,
  `email` varchar(320) DEFAULT NULL,
  `phone` varchar(100) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `address_type_order_id` (`address_type`,`order_id`),
  KEY `order_id` (`order_id`),
  KEY `email` (`email`(191)),
  KEY `phone` (`phone`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_coupon_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `coupon_id` bigint(20) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `discount_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`coupon_id`),
  KEY `coupon_id` (`coupon_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_operational_data` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `created_via` varchar(100) DEFAULT NULL,
  `woocommerce_version` varchar(20) DEFAULT NULL,
  `prices_include_tax` tinyint(1) DEFAULT NULL,
  `coupon_usages_are_counted` tinyint(1) DEFAULT NULL,
  `download_permission_granted` tinyint(1) DEFAULT NULL,
  `cart_hash` varchar(100) DEFAULT NULL,
  `new_order_email_sent` tinyint(1) DEFAULT NULL,
  `order_key` varchar(100) DEFAULT NULL,
  `order_stock_reduced` tinyint(1) DEFAULT NULL,
  `date_paid_gmt` datetime DEFAULT NULL,
  `date_completed_gmt` datetime DEFAULT NULL,
  `shipping_tax_amount` decimal(26,8) DEFAULT NULL,
  `shipping_total_amount` decimal(26,8) DEFAULT NULL,
  `discount_tax_amount` decimal(26,8) DEFAULT NULL,
  `discount_total_amount` decimal(26,8) DEFAULT NULL,
  `recorded_sales` tinyint(1) DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `order_id` (`order_id`),
  KEY `order_key` (`order_key`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_order_product_lookup` (
  `order_item_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `variation_id` bigint(20) unsigned NOT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `product_qty` int(11) NOT NULL,
  `product_net_revenue` double NOT NULL DEFAULT 0,
  `product_gross_revenue` double NOT NULL DEFAULT 0,
  `coupon_amount` double NOT NULL DEFAULT 0,
  `tax_amount` double NOT NULL DEFAULT 0,
  `shipping_amount` double NOT NULL DEFAULT 0,
  `shipping_tax_amount` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`),
  KEY `product_id` (`product_id`),
  KEY `customer_id` (`customer_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_stats` (
  `order_id` bigint(20) unsigned NOT NULL,
  `parent_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `num_items_sold` int(11) NOT NULL DEFAULT 0,
  `total_sales` double NOT NULL DEFAULT 0,
  `tax_total` double NOT NULL DEFAULT 0,
  `shipping_total` double NOT NULL DEFAULT 0,
  `net_total` double NOT NULL DEFAULT 0,
  `returning_customer` tinyint(1) DEFAULT NULL,
  `status` varchar(200) NOT NULL,
  `customer_id` bigint(20) unsigned NOT NULL,
  `date_paid` datetime DEFAULT '0000-00-00 00:00:00',
  `date_completed` datetime DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`),
  KEY `date_created` (`date_created`),
  KEY `customer_id` (`customer_id`),
  KEY `status` (`status`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_order_tax_lookup` (
  `order_id` bigint(20) unsigned NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `shipping_tax` double NOT NULL DEFAULT 0,
  `order_tax` double NOT NULL DEFAULT 0,
  `total_tax` double NOT NULL DEFAULT 0,
  PRIMARY KEY (`order_id`,`tax_rate_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `date_created` (`date_created`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_orders` (
  `id` bigint(20) unsigned NOT NULL,
  `status` varchar(20) DEFAULT NULL,
  `currency` varchar(10) DEFAULT NULL,
  `type` varchar(20) DEFAULT NULL,
  `tax_amount` decimal(26,8) DEFAULT NULL,
  `total_amount` decimal(26,8) DEFAULT NULL,
  `customer_id` bigint(20) unsigned DEFAULT NULL,
  `billing_email` varchar(320) DEFAULT NULL,
  `date_created_gmt` datetime DEFAULT NULL,
  `date_updated_gmt` datetime DEFAULT NULL,
  `parent_order_id` bigint(20) unsigned DEFAULT NULL,
  `payment_method` varchar(100) DEFAULT NULL,
  `payment_method_title` text DEFAULT NULL,
  `transaction_id` varchar(100) DEFAULT NULL,
  `ip_address` varchar(100) DEFAULT NULL,
  `user_agent` text DEFAULT NULL,
  `customer_note` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `status` (`status`),
  KEY `date_created` (`date_created_gmt`),
  KEY `customer_id_billing_email` (`customer_id`,`billing_email`(171)),
  KEY `billing_email` (`billing_email`(191)),
  KEY `type_status_date` (`type`,`status`,`date_created_gmt`),
  KEY `parent_order_id` (`parent_order_id`),
  KEY `date_updated` (`date_updated_gmt`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_orders_meta` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_id` bigint(20) unsigned DEFAULT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` text DEFAULT NULL,
  PRIMARY KEY (`id`),
  KEY `meta_key_value` (`meta_key`(100),`meta_value`(82)),
  KEY `order_id_meta_key_meta_value` (`order_id`,`meta_key`(100),`meta_value`(82))
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wc_product_attributes_lookup` (
  `product_id` bigint(20) NOT NULL,
  `product_or_parent_id` bigint(20) NOT NULL,
  `taxonomy` varchar(32) NOT NULL,
  `term_id` bigint(20) NOT NULL,
  `is_variation_attribute` tinyint(1) NOT NULL,
  `in_stock` tinyint(1) NOT NULL,
  PRIMARY KEY (`product_or_parent_id`,`term_id`,`product_id`,`taxonomy`),
  KEY `is_variation_attribute_term_id` (`is_variation_attribute`,`term_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_product_download_directories` (
  `url_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(256) NOT NULL,
  `enabled` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`url_id`),
  KEY `url` (`url`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_product_meta_lookup` (
  `product_id` bigint(20) NOT NULL,
  `sku` varchar(100) DEFAULT '',
  `virtual` tinyint(1) DEFAULT 0,
  `downloadable` tinyint(1) DEFAULT 0,
  `min_price` decimal(19,4) DEFAULT NULL,
  `max_price` decimal(19,4) DEFAULT NULL,
  `onsale` tinyint(1) DEFAULT 0,
  `stock_quantity` double DEFAULT NULL,
  `stock_status` varchar(100) DEFAULT 'instock',
  `rating_count` bigint(20) DEFAULT 0,
  `average_rating` decimal(3,2) DEFAULT 0.00,
  `total_sales` bigint(20) DEFAULT 0,
  `tax_status` varchar(100) DEFAULT 'taxable',
  `tax_class` varchar(100) DEFAULT '',
  `global_unique_id` varchar(100) DEFAULT '',
  PRIMARY KEY (`product_id`),
  KEY `virtual` (`virtual`),
  KEY `downloadable` (`downloadable`),
  KEY `stock_status` (`stock_status`),
  KEY `stock_quantity` (`stock_quantity`),
  KEY `onsale` (`onsale`),
  KEY `min_max_price` (`min_price`,`max_price`),
  KEY `sku` (`sku`(50))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_rate_limits` (
  `rate_limit_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `rate_limit_key` varchar(200) NOT NULL,
  `rate_limit_expiry` bigint(20) unsigned NOT NULL,
  `rate_limit_remaining` smallint(10) NOT NULL DEFAULT 0,
  PRIMARY KEY (`rate_limit_id`),
  UNIQUE KEY `rate_limit_key` (`rate_limit_key`(191))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_reserved_stock` (
  `order_id` bigint(20) NOT NULL,
  `product_id` bigint(20) NOT NULL,
  `stock_quantity` double NOT NULL DEFAULT 0,
  `timestamp` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`order_id`,`product_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_tax_rate_classes` (
  `tax_rate_class_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `name` varchar(200) NOT NULL DEFAULT '',
  `slug` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_class_id`),
  UNIQUE KEY `slug` (`slug`(191))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_wc_webhooks` (
  `webhook_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `status` varchar(200) NOT NULL,
  `name` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL,
  `delivery_url` text NOT NULL,
  `secret` text NOT NULL,
  `topic` varchar(200) NOT NULL,
  `date_created` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_created_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `date_modified_gmt` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `api_version` smallint(4) NOT NULL,
  `failure_count` smallint(10) NOT NULL DEFAULT 0,
  `pending_delivery` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`webhook_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_api_keys` (
  `key_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `user_id` bigint(20) unsigned NOT NULL,
  `description` varchar(200) DEFAULT NULL,
  `permissions` varchar(10) NOT NULL,
  `consumer_key` char(64) NOT NULL,
  `consumer_secret` char(43) NOT NULL,
  `nonces` longtext DEFAULT NULL,
  `truncated_key` char(7) NOT NULL,
  `last_access` datetime DEFAULT NULL,
  PRIMARY KEY (`key_id`),
  KEY `consumer_key` (`consumer_key`),
  KEY `consumer_secret` (`consumer_secret`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_attribute_taxonomies` (
  `attribute_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `attribute_name` varchar(200) NOT NULL,
  `attribute_label` varchar(200) DEFAULT NULL,
  `attribute_type` varchar(20) NOT NULL,
  `attribute_orderby` varchar(20) NOT NULL,
  `attribute_public` int(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`attribute_id`),
  KEY `attribute_name` (`attribute_name`(20))
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_downloadable_product_permissions` (
  `permission_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `download_id` varchar(36) NOT NULL,
  `product_id` bigint(20) unsigned NOT NULL,
  `order_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `order_key` varchar(200) NOT NULL,
  `user_email` varchar(200) NOT NULL,
  `user_id` bigint(20) unsigned DEFAULT NULL,
  `downloads_remaining` varchar(9) DEFAULT NULL,
  `access_granted` datetime NOT NULL DEFAULT '0000-00-00 00:00:00',
  `access_expires` datetime DEFAULT NULL,
  `download_count` bigint(20) unsigned NOT NULL DEFAULT 0,
  PRIMARY KEY (`permission_id`),
  KEY `download_order_key_product` (`product_id`,`order_id`,`order_key`(16),`download_id`),
  KEY `download_order_product` (`download_id`,`order_id`,`product_id`),
  KEY `order_id` (`order_id`),
  KEY `user_order_remaining_expires` (`user_id`,`order_id`,`downloads_remaining`,`access_expires`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_ir` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `text1` text NOT NULL,
  `text2` text DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_woocommerce_log` (
  `log_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `timestamp` datetime NOT NULL,
  `level` smallint(4) NOT NULL,
  `source` varchar(200) NOT NULL,
  `message` longtext NOT NULL,
  `context` longtext DEFAULT NULL,
  PRIMARY KEY (`log_id`),
  KEY `level` (`level`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_order_itemmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `order_item_id` (`order_item_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB AUTO_INCREMENT=304 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_order_items` (
  `order_item_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `order_item_name` text NOT NULL,
  `order_item_type` varchar(200) NOT NULL DEFAULT '',
  `order_id` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`order_item_id`),
  KEY `order_id` (`order_id`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_payment_tokenmeta` (
  `meta_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `payment_token_id` bigint(20) unsigned NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext DEFAULT NULL,
  PRIMARY KEY (`meta_id`),
  KEY `payment_token_id` (`payment_token_id`),
  KEY `meta_key` (`meta_key`(32))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_payment_tokens` (
  `token_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `gateway_id` varchar(200) NOT NULL,
  `token` text NOT NULL,
  `user_id` bigint(20) unsigned NOT NULL DEFAULT 0,
  `type` varchar(200) NOT NULL,
  `is_default` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`token_id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_sessions` (
  `session_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `session_key` char(32) NOT NULL,
  `session_value` longtext NOT NULL,
  `session_expiry` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`session_id`),
  UNIQUE KEY `session_key` (`session_key`)
) ENGINE=InnoDB AUTO_INCREMENT=5526 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_id` bigint(20) unsigned NOT NULL,
  `location_code` varchar(200) NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `location_id` (`location_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20)),
  KEY `zone_id` (`zone_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zone_methods` (
  `zone_id` bigint(20) unsigned NOT NULL,
  `instance_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `method_id` varchar(200) NOT NULL,
  `method_order` bigint(20) unsigned NOT NULL,
  `is_enabled` tinyint(1) NOT NULL DEFAULT 1,
  PRIMARY KEY (`instance_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_shipping_zones` (
  `zone_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `zone_name` varchar(200) NOT NULL,
  `zone_order` bigint(20) unsigned NOT NULL,
  PRIMARY KEY (`zone_id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_tax_rate_locations` (
  `location_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `location_code` varchar(200) NOT NULL,
  `tax_rate_id` bigint(20) unsigned NOT NULL,
  `location_type` varchar(40) NOT NULL,
  PRIMARY KEY (`location_id`),
  KEY `tax_rate_id` (`tax_rate_id`),
  KEY `location_type_code` (`location_type`(10),`location_code`(20))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woocommerce_tax_rates` (
  `tax_rate_id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `tax_rate_country` varchar(2) NOT NULL DEFAULT '',
  `tax_rate_state` varchar(200) NOT NULL DEFAULT '',
  `tax_rate` varchar(8) NOT NULL DEFAULT '',
  `tax_rate_name` varchar(200) NOT NULL DEFAULT '',
  `tax_rate_priority` bigint(20) unsigned NOT NULL,
  `tax_rate_compound` int(1) NOT NULL DEFAULT 0,
  `tax_rate_shipping` int(1) NOT NULL DEFAULT 1,
  `tax_rate_order` bigint(20) unsigned NOT NULL,
  `tax_rate_class` varchar(200) NOT NULL DEFAULT '',
  PRIMARY KEY (`tax_rate_id`),
  KEY `tax_rate_country` (`tax_rate_country`),
  KEY `tax_rate_state` (`tax_rate_state`(2)),
  KEY `tax_rate_class` (`tax_rate_class`(10)),
  KEY `tax_rate_priority` (`tax_rate_priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

CREATE TABLE `wp_woodmart_wishlist_products` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `product_id` varchar(255) NOT NULL,
  `wishlist_id` int(11) DEFAULT NULL,
  `date_added` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`ID`),
  KEY `product_id` (`product_id`)
) ENGINE=InnoDB AUTO_INCREMENT=15 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_woodmart_wishlists` (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `user_id` int(11) NOT NULL,
  `date_created` timestamp NOT NULL DEFAULT current_timestamp(),
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=151 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_general_ci;

CREATE TABLE `wp_wpr_rocket_cache` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `status` varchar(255) NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `is_locked` tinyint(1) NOT NULL DEFAULT 0,
  PRIMARY KEY (`id`),
  KEY `url` (`url`(191)),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`)
) ENGINE=MyISAM AUTO_INCREMENT=84 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

CREATE TABLE `wp_wpr_rucss_used_css` (
  `id` bigint(20) unsigned NOT NULL AUTO_INCREMENT,
  `url` varchar(2000) NOT NULL DEFAULT '',
  `css` longtext DEFAULT NULL,
  `hash` varchar(32) DEFAULT '',
  `error_code` varchar(32) DEFAULT NULL,
  `error_message` longtext DEFAULT NULL,
  `unprocessedcss` longtext DEFAULT NULL,
  `retries` tinyint(1) NOT NULL DEFAULT 1,
  `is_mobile` tinyint(1) NOT NULL DEFAULT 0,
  `job_id` varchar(255) NOT NULL DEFAULT '',
  `queue_name` varchar(255) NOT NULL DEFAULT '',
  `status` varchar(255) NOT NULL DEFAULT '',
  `modified` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `last_accessed` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  PRIMARY KEY (`id`),
  KEY `url` (`url`(150),`is_mobile`),
  KEY `modified` (`modified`),
  KEY `last_accessed` (`last_accessed`),
  KEY `status_index` (`status`(191)),
  KEY `error_code_index` (`error_code`),
  KEY `hash` (`hash`)
) ENGINE=MyISAM AUTO_INCREMENT=90 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;

/***** TABLE CREATION END *****/


/* INSERT TABLE DATA: wp_actionscheduler_actions */
INSERT INTO `wp_actionscheduler_actions` VALUES("778", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2023-02-24 23:40:48", "2023-02-24 22:40:48", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1677282048;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1677282048;}", "5", "1", "2023-02-24 23:40:51", "2023-02-24 22:40:51", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("873", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2023-05-03 12:22:51", "2023-05-03 12:22:51", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1683116571;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1683116571;}", "5", "1", "2023-05-03 12:22:53", "2023-05-03 12:22:53", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("910", "action_scheduler/migration_hook", "failed", "2023-05-03 12:54:31", "2023-05-03 12:54:31", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1683118471;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1683118471;}", "1", "1", "2023-05-03 12:54:37", "2023-05-03 12:54:37", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("931", "woocommerce_run_on_woocommerce_admin_updated", "failed", "2023-05-27 02:04:53", "2023-05-27 02:04:53", "[\"Automattic\\\\WooCommerce\\\\Admin\\\\RemoteInboxNotifications\\\\RemoteInboxNotificationsEngine\",\"run_on_woocommerce_admin_updated\"]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1685153093;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1685153093;}", "5", "1", "2023-05-27 02:05:16", "2023-05-27 02:05:16", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("933", "action_scheduler/migration_hook", "failed", "2023-05-27 02:07:35", "2023-05-27 02:07:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1685153255;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1685153255;}", "1", "1", "2023-05-27 02:08:38", "2023-05-27 02:08:38", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1044", "action_scheduler/migration_hook", "failed", "2023-09-16 12:49:22", "2023-09-16 12:49:22", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1694868562;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1694868562;}", "1", "1", "2023-09-16 12:49:29", "2023-09-16 12:49:29", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1460", "action_scheduler/migration_hook", "failed", "2023-09-17 13:42:38", "2023-09-17 13:42:38", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1694958158;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1694958158;}", "1", "1", "2023-09-17 13:43:04", "2023-09-17 13:43:04", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("1461", "rocket_preload_job_check_finished", "failed", "2023-09-17 13:44:04", "2023-09-17 13:44:04", "[1694958184]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1694958244;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1694958244;}", "6", "1", "2023-09-17 13:44:28", "2023-09-17 13:44:28", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3738", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:12:03", "2024-02-05 20:12:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/smart-watch\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3739", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:12:03", "2024-02-05 20:12:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/laptop\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3740", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:12:03", "2024-02-05 20:12:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/console\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3741", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:12:03", "2024-02-05 20:12:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/phone-cover\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3742", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:12:03", "2024-02-05 20:12:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/mobile\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3743", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:12:03", "2024-02-05 20:12:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/handsfree\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3744", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:12:03", "2024-02-05 20:12:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3745", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:12:03", "2024-02-05 20:12:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/woodmart_layout\\/cart-layout\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3746", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:12:03", "2024-02-05 20:12:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/woodmart_layout\\/single-product-layout\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3747", "rocket_preload_job_check_finished", "failed", "2024-02-05 20:14:15", "2024-02-05 19:14:15", "[1707163995]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1707164055;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1707164055;}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3748", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%B3%D9%84%D8%A7%D9%85-%D8%AF%D9%86%DB%8C%D8%A7\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3749", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%AE%D8%B1%DB%8C%D8%AF-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84-%D9%88-%D9%84%D9%BE-%D8%AA%D8%A7%D9%BE\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3750", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%A2%D9%85%D9%88%D8%B2%D8%B4-%D8%AA%D8%B9%D9%85%DB%8C%D8%B1%D8%A7%D8%AA-%D8%B3%D8%A7%D8%B9%D8%AA\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3751", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%A2%D9%85%D9%88%D8%B2%D8%B4-%D8%AA%D8%B9%D9%85%DB%8C%D8%B1-%D8%B3%DB%8C%D8%B3%D8%AA%D9%85\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3752", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%B1%D9%88%D8%B4-%D8%A7%D8%B3%D8%AA%D9%81%D8%A7%D8%AF%D9%87-%D8%A7%D8%B2-%D8%A7%DB%8C%D8%B1%D9%BE%D8%A7%D8%AF\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3753", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%A2%D9%85%D9%88%D8%B2%D8%B4-%D8%AA%D8%A8%D9%84%DB%8C%D8%BA%D8%A7%D8%AA-%D9%88-%D8%A8%D8%B1%D9%86%D8%AF\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3754", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%A7%D9%86%D8%AA%D8%AE%D8%A7%D8%A8-%D8%B3%DB%8C%D8%B3%D8%AA%D9%85-%D8%B9%D8%A7%D9%85%D9%84-%DA%AF%D9%88%D8%B4%DB%8C\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3755", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D9%81%D9%84%D8%B4-%D9%85%D9%85%D9%88%D8%B1%DB%8C-%D8%AE%D9%88%D8%A8\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3756", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/shop\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3757", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/blog\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3758", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/store-listing\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3759", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%AA%D9%85%D8%A7%D8%B3-%D8%A8%D8%A7-%D9%85%D8%A7\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3760", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%AF%D8%B1%D8%A8%D8%A7%D8%B1%D9%87-%D9%85%D8%A7\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3761", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%DA%AF%D9%88%D8%B4%DB%8C-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84-%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF-%D9%85%D8%AF%D9%84-galaxy-a32-5g\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3762", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%DA%AF%D9%88%D8%B4%DB%8C-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84-%D8%B4%DB%8C%D8%A7%D8%A6%D9%88%D9%85%DB%8C-%D9%85%D8%AF%D9%84-poco-f3-5g\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3763", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "b02b77e2b684cdd605d4ef259c43c567", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%DA%AF%D9%88%D8%B4%DB%8C-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84-%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF-%D9%85%D8%AF%D9%84-galaxy-a32-21g\"]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3764", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%DA%AF%D9%88%D8%B4%DB%8C-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84-%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF-%D9%85%D8%AF%D9%84-galaxy-a32\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3765", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%DA%AF%D9%88%D8%B4%DB%8C-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84-%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF-a12-56a\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3766", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D8%B3%D8%A7%D8%B9%D8%AA-%D9%87%D9%88%D8%B4%D9%85%D9%86%D8%AF-%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3767", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D8%B3%D8%A7%D8%B9%D8%AA-%D9%87%D9%88%D8%B4%D9%85%D9%86%D8%AF-%D9%87%D8%A7%D9%88%D8%A7%DB%8C%DB%8C\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3768", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D8%B3%D8%A7%D8%B9%D8%AA-%D9%87%D9%88%D8%B4%D9%85%D9%86%D8%AFa21\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3769", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D8%B3%D8%A7%D8%B9%D8%AA-%D9%87%D9%88%D8%B4%D9%85%D9%86%D8%AF-%D8%B443\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3770", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D8%B3%D8%A7%D8%B9%D8%AA-%D9%87%D9%88%D8%B4%D9%85%D9%86%D8%AF-%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF-a1\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3771", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "29ce27c2fea004ca0e5b88ac9f0471a2", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D8%B3%D8%A7%D8%B9%D8%AA-%D9%87%D9%88%D8%B4%D9%85%D9%86%D8%AF-%D8%A7%D9%BE%D9%84-%D9%88%D8%A7%DA%86-%D8%B3%D8%B1%DB%8C-%DB%B8-%D8%B3%D8%A7%DB%8C%D8%B2-%DB%B4%DB%B5-%D9%85%DB%8C%D9%84%DB%8C\"]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3772", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "d9ec298e034d30889af3b7618067dd41", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%DA%A9%DB%8C%D8%B3-%DA%A9%D8%A7%D9%85%D9%BE%DB%8C%D9%88%D8%AA%D8%B1-%DA%A9%D9%88%D9%84%D8%B1%D9%85%D8%B3%D8%AA%D8%B1-%D9%85%D8%AF%D9%84-maste\"]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3773", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "b96704a6ac55ddffa9f9a2cb8d385b8c", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D9%85%D8%A7%D9%86%DB%8C%D8%AA%D9%88%D8%B1-%DB%B2%DB%B0-%D8%A7%DB%8C%D9%86%DA%86%DB%8C-%D8%A7%DB%8C%DA%A9%D8%B3-%D9%88%DB%8C%DA%98%D9%86-%D9%85%D8%AF%D9%84-xvision-xk2030h\"]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3774", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "ef1ff590d88f0b79fd2eed24cbd9d74c", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D9%86%D9%88%D8%AA%D8%A8%D9%88%DA%A9-%DB%B1%DB%B5-%D8%A7%DB%8C%D9%86%DA%86-%D9%84%D9%86%D9%88%D9%88-%D9%85%D8%AF%D9%84-lenovo-legion-5-i7-11800h-32gb-1tb-ssd-8gb-3070\"]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3775", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D9%86%D9%88%D8%AA%D8%A8%D9%88%DA%A9-%D9%84%D9%86%D9%88%D9%88-%D9%85%D8%AF%D9%84-lenovo-ideapa\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3776", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/category\\/tecnology\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3777", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/woodmart_slider\\/tikakala_slider-2\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3778", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/tablet\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3779", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-tag\\/%D8%AE%D8%B1%DB%8C%D8%AF-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3780", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-tag\\/%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3781", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-tag\\/%DA%AF%D9%88%D8%B4%DB%8C-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3782", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/author\\/admina\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3783", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/author\\/tespt\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3784", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/smart-watch\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3785", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/laptop\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3786", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/console\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3787", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/phone-cover\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3788", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/mobile\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3789", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/handsfree\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3790", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3791", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/woodmart_layout\\/cart-layout\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3792", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:14:02", "2024-02-05 20:14:02", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/woodmart_layout\\/single-product-layout\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3793", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%B3%D9%84%D8%A7%D9%85-%D8%AF%D9%86%DB%8C%D8%A7\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3794", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%AE%D8%B1%DB%8C%D8%AF-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84-%D9%88-%D9%84%D9%BE-%D8%AA%D8%A7%D9%BE\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3795", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%A2%D9%85%D9%88%D8%B2%D8%B4-%D8%AA%D8%B9%D9%85%DB%8C%D8%B1%D8%A7%D8%AA-%D8%B3%D8%A7%D8%B9%D8%AA\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3796", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%A2%D9%85%D9%88%D8%B2%D8%B4-%D8%AA%D8%B9%D9%85%DB%8C%D8%B1-%D8%B3%DB%8C%D8%B3%D8%AA%D9%85\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3797", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%B1%D9%88%D8%B4-%D8%A7%D8%B3%D8%AA%D9%81%D8%A7%D8%AF%D9%87-%D8%A7%D8%B2-%D8%A7%DB%8C%D8%B1%D9%BE%D8%A7%D8%AF\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3798", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%A2%D9%85%D9%88%D8%B2%D8%B4-%D8%AA%D8%A8%D9%84%DB%8C%D8%BA%D8%A7%D8%AA-%D9%88-%D8%A8%D8%B1%D9%86%D8%AF\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3799", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%A7%D9%86%D8%AA%D8%AE%D8%A7%D8%A8-%D8%B3%DB%8C%D8%B3%D8%AA%D9%85-%D8%B9%D8%A7%D9%85%D9%84-%DA%AF%D9%88%D8%B4%DB%8C\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3800", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D9%81%D9%84%D8%B4-%D9%85%D9%85%D9%88%D8%B1%DB%8C-%D8%AE%D9%88%D8%A8\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3801", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/shop\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3802", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/blog\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3803", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/store-listing\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3804", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%AA%D9%85%D8%A7%D8%B3-%D8%A8%D8%A7-%D9%85%D8%A7\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3805", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%AF%D8%B1%D8%A8%D8%A7%D8%B1%D9%87-%D9%85%D8%A7\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3806", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%DA%AF%D9%88%D8%B4%DB%8C-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84-%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF-%D9%85%D8%AF%D9%84-galaxy-a32-5g\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:09", "2024-02-05 19:22:09", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3807", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%DA%AF%D9%88%D8%B4%DB%8C-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84-%D8%B4%DB%8C%D8%A7%D8%A6%D9%88%D9%85%DB%8C-%D9%85%D8%AF%D9%84-poco-f3-5g\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3808", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "b02b77e2b684cdd605d4ef259c43c567", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%DA%AF%D9%88%D8%B4%DB%8C-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84-%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF-%D9%85%D8%AF%D9%84-galaxy-a32-21g\"]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3809", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%DA%AF%D9%88%D8%B4%DB%8C-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84-%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF-%D9%85%D8%AF%D9%84-galaxy-a32\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3810", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%DA%AF%D9%88%D8%B4%DB%8C-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84-%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF-a12-56a\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3811", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D8%B3%D8%A7%D8%B9%D8%AA-%D9%87%D9%88%D8%B4%D9%85%D9%86%D8%AF-%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3812", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D8%B3%D8%A7%D8%B9%D8%AA-%D9%87%D9%88%D8%B4%D9%85%D9%86%D8%AF-%D9%87%D8%A7%D9%88%D8%A7%DB%8C%DB%8C\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3813", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D8%B3%D8%A7%D8%B9%D8%AA-%D9%87%D9%88%D8%B4%D9%85%D9%86%D8%AFa21\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3814", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D8%B3%D8%A7%D8%B9%D8%AA-%D9%87%D9%88%D8%B4%D9%85%D9%86%D8%AF-%D8%B443\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3815", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D8%B3%D8%A7%D8%B9%D8%AA-%D9%87%D9%88%D8%B4%D9%85%D9%86%D8%AF-%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF-a1\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3816", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "29ce27c2fea004ca0e5b88ac9f0471a2", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D8%B3%D8%A7%D8%B9%D8%AA-%D9%87%D9%88%D8%B4%D9%85%D9%86%D8%AF-%D8%A7%D9%BE%D9%84-%D9%88%D8%A7%DA%86-%D8%B3%D8%B1%DB%8C-%DB%B8-%D8%B3%D8%A7%DB%8C%D8%B2-%DB%B4%DB%B5-%D9%85%DB%8C%D9%84%DB%8C\"]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3817", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "d9ec298e034d30889af3b7618067dd41", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%DA%A9%DB%8C%D8%B3-%DA%A9%D8%A7%D9%85%D9%BE%DB%8C%D9%88%D8%AA%D8%B1-%DA%A9%D9%88%D9%84%D8%B1%D9%85%D8%B3%D8%AA%D8%B1-%D9%85%D8%AF%D9%84-maste\"]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3818", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "b96704a6ac55ddffa9f9a2cb8d385b8c", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D9%85%D8%A7%D9%86%DB%8C%D8%AA%D9%88%D8%B1-%DB%B2%DB%B0-%D8%A7%DB%8C%D9%86%DA%86%DB%8C-%D8%A7%DB%8C%DA%A9%D8%B3-%D9%88%DB%8C%DA%98%D9%86-%D9%85%D8%AF%D9%84-xvision-xk2030h\"]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3819", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "ef1ff590d88f0b79fd2eed24cbd9d74c", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D9%86%D9%88%D8%AA%D8%A8%D9%88%DA%A9-%DB%B1%DB%B5-%D8%A7%DB%8C%D9%86%DA%86-%D9%84%D9%86%D9%88%D9%88-%D9%85%D8%AF%D9%84-lenovo-legion-5-i7-11800h-32gb-1tb-ssd-8gb-3070\"]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3820", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D9%86%D9%88%D8%AA%D8%A8%D9%88%DA%A9-%D9%84%D9%86%D9%88%D9%88-%D9%85%D8%AF%D9%84-lenovo-ideapa\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3821", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/category\\/tecnology\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3822", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/woodmart_slider\\/tikakala_slider-2\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3823", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/tablet\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3824", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-tag\\/%D8%AE%D8%B1%DB%8C%D8%AF-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3825", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-tag\\/%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3826", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-tag\\/%DA%AF%D9%88%D8%B4%DB%8C-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3827", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/author\\/admina\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3828", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/author\\/tespt\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3829", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/smart-watch\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3830", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/laptop\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3831", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/console\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3832", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/phone-cover\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3833", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/mobile\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3834", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/handsfree\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3835", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3836", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/woodmart_layout\\/cart-layout\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3837", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:15:12", "2024-02-05 20:15:12", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/woodmart_layout\\/single-product-layout\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3838", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%B3%D9%84%D8%A7%D9%85-%D8%AF%D9%86%DB%8C%D8%A7\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3839", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%AE%D8%B1%DB%8C%D8%AF-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84-%D9%88-%D9%84%D9%BE-%D8%AA%D8%A7%D9%BE\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3840", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%A2%D9%85%D9%88%D8%B2%D8%B4-%D8%AA%D8%B9%D9%85%DB%8C%D8%B1%D8%A7%D8%AA-%D8%B3%D8%A7%D8%B9%D8%AA\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3841", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%A2%D9%85%D9%88%D8%B2%D8%B4-%D8%AA%D8%B9%D9%85%DB%8C%D8%B1-%D8%B3%DB%8C%D8%B3%D8%AA%D9%85\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3842", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%B1%D9%88%D8%B4-%D8%A7%D8%B3%D8%AA%D9%81%D8%A7%D8%AF%D9%87-%D8%A7%D8%B2-%D8%A7%DB%8C%D8%B1%D9%BE%D8%A7%D8%AF\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3843", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%A2%D9%85%D9%88%D8%B2%D8%B4-%D8%AA%D8%A8%D9%84%DB%8C%D8%BA%D8%A7%D8%AA-%D9%88-%D8%A8%D8%B1%D9%86%D8%AF\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3844", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%A7%D9%86%D8%AA%D8%AE%D8%A7%D8%A8-%D8%B3%DB%8C%D8%B3%D8%AA%D9%85-%D8%B9%D8%A7%D9%85%D9%84-%DA%AF%D9%88%D8%B4%DB%8C\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3845", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D9%81%D9%84%D8%B4-%D9%85%D9%85%D9%88%D8%B1%DB%8C-%D8%AE%D9%88%D8%A8\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3846", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/shop\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3847", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/blog\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3848", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/store-listing\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3849", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%AA%D9%85%D8%A7%D8%B3-%D8%A8%D8%A7-%D9%85%D8%A7\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3850", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%AF%D8%B1%D8%A8%D8%A7%D8%B1%D9%87-%D9%85%D8%A7\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3851", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%DA%AF%D9%88%D8%B4%DB%8C-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84-%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF-%D9%85%D8%AF%D9%84-galaxy-a32-5g\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3852", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%DA%AF%D9%88%D8%B4%DB%8C-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84-%D8%B4%DB%8C%D8%A7%D8%A6%D9%88%D9%85%DB%8C-%D9%85%D8%AF%D9%84-poco-f3-5g\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3853", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "b02b77e2b684cdd605d4ef259c43c567", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%DA%AF%D9%88%D8%B4%DB%8C-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84-%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF-%D9%85%D8%AF%D9%84-galaxy-a32-21g\"]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3854", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%DA%AF%D9%88%D8%B4%DB%8C-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84-%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF-%D9%85%D8%AF%D9%84-galaxy-a32\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3855", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%DA%AF%D9%88%D8%B4%DB%8C-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84-%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF-a12-56a\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3856", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D8%B3%D8%A7%D8%B9%D8%AA-%D9%87%D9%88%D8%B4%D9%85%D9%86%D8%AF-%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3857", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D8%B3%D8%A7%D8%B9%D8%AA-%D9%87%D9%88%D8%B4%D9%85%D9%86%D8%AF-%D9%87%D8%A7%D9%88%D8%A7%DB%8C%DB%8C\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3858", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D8%B3%D8%A7%D8%B9%D8%AA-%D9%87%D9%88%D8%B4%D9%85%D9%86%D8%AFa21\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3859", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D8%B3%D8%A7%D8%B9%D8%AA-%D9%87%D9%88%D8%B4%D9%85%D9%86%D8%AF-%D8%B443\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3860", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D8%B3%D8%A7%D8%B9%D8%AA-%D9%87%D9%88%D8%B4%D9%85%D9%86%D8%AF-%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF-a1\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3861", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "29ce27c2fea004ca0e5b88ac9f0471a2", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D8%B3%D8%A7%D8%B9%D8%AA-%D9%87%D9%88%D8%B4%D9%85%D9%86%D8%AF-%D8%A7%D9%BE%D9%84-%D9%88%D8%A7%DA%86-%D8%B3%D8%B1%DB%8C-%DB%B8-%D8%B3%D8%A7%DB%8C%D8%B2-%DB%B4%DB%B5-%D9%85%DB%8C%D9%84%DB%8C\"]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3862", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "d9ec298e034d30889af3b7618067dd41", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%DA%A9%DB%8C%D8%B3-%DA%A9%D8%A7%D9%85%D9%BE%DB%8C%D9%88%D8%AA%D8%B1-%DA%A9%D9%88%D9%84%D8%B1%D9%85%D8%B3%D8%AA%D8%B1-%D9%85%D8%AF%D9%84-maste\"]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3863", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "b96704a6ac55ddffa9f9a2cb8d385b8c", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D9%85%D8%A7%D9%86%DB%8C%D8%AA%D9%88%D8%B1-%DB%B2%DB%B0-%D8%A7%DB%8C%D9%86%DA%86%DB%8C-%D8%A7%DB%8C%DA%A9%D8%B3-%D9%88%DB%8C%DA%98%D9%86-%D9%85%D8%AF%D9%84-xvision-xk2030h\"]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3864", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "ef1ff590d88f0b79fd2eed24cbd9d74c", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D9%86%D9%88%D8%AA%D8%A8%D9%88%DA%A9-%DB%B1%DB%B5-%D8%A7%DB%8C%D9%86%DA%86-%D9%84%D9%86%D9%88%D9%88-%D9%85%D8%AF%D9%84-lenovo-legion-5-i7-11800h-32gb-1tb-ssd-8gb-3070\"]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3865", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D9%86%D9%88%D8%AA%D8%A8%D9%88%DA%A9-%D9%84%D9%86%D9%88%D9%88-%D9%85%D8%AF%D9%84-lenovo-ideapa\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3866", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/category\\/tecnology\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3867", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/woodmart_slider\\/tikakala_slider-2\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3868", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/tablet\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3869", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-tag\\/%D8%AE%D8%B1%DB%8C%D8%AF-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3870", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-tag\\/%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3871", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-tag\\/%DA%AF%D9%88%D8%B4%DB%8C-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3872", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/author\\/admina\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3873", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/author\\/tespt\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3874", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/smart-watch\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3875", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/laptop\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3876", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/console\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3877", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/phone-cover\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3878", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/mobile\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3879", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/handsfree\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3880", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3881", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/woodmart_layout\\/cart-layout\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3882", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:16:04", "2024-02-05 20:16:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/woodmart_layout\\/single-product-layout\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3883", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%B3%D9%84%D8%A7%D9%85-%D8%AF%D9%86%DB%8C%D8%A7\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3884", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%AE%D8%B1%DB%8C%D8%AF-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84-%D9%88-%D9%84%D9%BE-%D8%AA%D8%A7%D9%BE\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3885", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%A2%D9%85%D9%88%D8%B2%D8%B4-%D8%AA%D8%B9%D9%85%DB%8C%D8%B1%D8%A7%D8%AA-%D8%B3%D8%A7%D8%B9%D8%AA\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3886", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%A2%D9%85%D9%88%D8%B2%D8%B4-%D8%AA%D8%B9%D9%85%DB%8C%D8%B1-%D8%B3%DB%8C%D8%B3%D8%AA%D9%85\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3887", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%B1%D9%88%D8%B4-%D8%A7%D8%B3%D8%AA%D9%81%D8%A7%D8%AF%D9%87-%D8%A7%D8%B2-%D8%A7%DB%8C%D8%B1%D9%BE%D8%A7%D8%AF\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3888", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%A2%D9%85%D9%88%D8%B2%D8%B4-%D8%AA%D8%A8%D9%84%DB%8C%D8%BA%D8%A7%D8%AA-%D9%88-%D8%A8%D8%B1%D9%86%D8%AF\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3889", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%A7%D9%86%D8%AA%D8%AE%D8%A7%D8%A8-%D8%B3%DB%8C%D8%B3%D8%AA%D9%85-%D8%B9%D8%A7%D9%85%D9%84-%DA%AF%D9%88%D8%B4%DB%8C\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3890", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D9%81%D9%84%D8%B4-%D9%85%D9%85%D9%88%D8%B1%DB%8C-%D8%AE%D9%88%D8%A8\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3891", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/shop\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3892", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/blog\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3893", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/store-listing\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3894", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%AA%D9%85%D8%A7%D8%B3-%D8%A8%D8%A7-%D9%85%D8%A7\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3895", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%AF%D8%B1%D8%A8%D8%A7%D8%B1%D9%87-%D9%85%D8%A7\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3896", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%DA%AF%D9%88%D8%B4%DB%8C-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84-%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF-%D9%85%D8%AF%D9%84-galaxy-a32-5g\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3897", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%DA%AF%D9%88%D8%B4%DB%8C-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84-%D8%B4%DB%8C%D8%A7%D8%A6%D9%88%D9%85%DB%8C-%D9%85%D8%AF%D9%84-poco-f3-5g\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3898", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "b02b77e2b684cdd605d4ef259c43c567", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%DA%AF%D9%88%D8%B4%DB%8C-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84-%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF-%D9%85%D8%AF%D9%84-galaxy-a32-21g\"]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3899", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%DA%AF%D9%88%D8%B4%DB%8C-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84-%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF-%D9%85%D8%AF%D9%84-galaxy-a32\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3900", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%DA%AF%D9%88%D8%B4%DB%8C-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84-%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF-a12-56a\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3901", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D8%B3%D8%A7%D8%B9%D8%AA-%D9%87%D9%88%D8%B4%D9%85%D9%86%D8%AF-%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3902", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D8%B3%D8%A7%D8%B9%D8%AA-%D9%87%D9%88%D8%B4%D9%85%D9%86%D8%AF-%D9%87%D8%A7%D9%88%D8%A7%DB%8C%DB%8C\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3903", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D8%B3%D8%A7%D8%B9%D8%AA-%D9%87%D9%88%D8%B4%D9%85%D9%86%D8%AFa21\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3904", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D8%B3%D8%A7%D8%B9%D8%AA-%D9%87%D9%88%D8%B4%D9%85%D9%86%D8%AF-%D8%B443\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3905", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D8%B3%D8%A7%D8%B9%D8%AA-%D9%87%D9%88%D8%B4%D9%85%D9%86%D8%AF-%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF-a1\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3906", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "29ce27c2fea004ca0e5b88ac9f0471a2", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D8%B3%D8%A7%D8%B9%D8%AA-%D9%87%D9%88%D8%B4%D9%85%D9%86%D8%AF-%D8%A7%D9%BE%D9%84-%D9%88%D8%A7%DA%86-%D8%B3%D8%B1%DB%8C-%DB%B8-%D8%B3%D8%A7%DB%8C%D8%B2-%DB%B4%DB%B5-%D9%85%DB%8C%D9%84%DB%8C\"]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3907", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "d9ec298e034d30889af3b7618067dd41", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%DA%A9%DB%8C%D8%B3-%DA%A9%D8%A7%D9%85%D9%BE%DB%8C%D9%88%D8%AA%D8%B1-%DA%A9%D9%88%D9%84%D8%B1%D9%85%D8%B3%D8%AA%D8%B1-%D9%85%D8%AF%D9%84-maste\"]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3908", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "b96704a6ac55ddffa9f9a2cb8d385b8c", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D9%85%D8%A7%D9%86%DB%8C%D8%AA%D9%88%D8%B1-%DB%B2%DB%B0-%D8%A7%DB%8C%D9%86%DA%86%DB%8C-%D8%A7%DB%8C%DA%A9%D8%B3-%D9%88%DB%8C%DA%98%D9%86-%D9%85%D8%AF%D9%84-xvision-xk2030h\"]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3909", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "ef1ff590d88f0b79fd2eed24cbd9d74c", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D9%86%D9%88%D8%AA%D8%A8%D9%88%DA%A9-%DB%B1%DB%B5-%D8%A7%DB%8C%D9%86%DA%86-%D9%84%D9%86%D9%88%D9%88-%D9%85%D8%AF%D9%84-lenovo-legion-5-i7-11800h-32gb-1tb-ssd-8gb-3070\"]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3910", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D9%86%D9%88%D8%AA%D8%A8%D9%88%DA%A9-%D9%84%D9%86%D9%88%D9%88-%D9%85%D8%AF%D9%84-lenovo-ideapa\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3911", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/category\\/tecnology\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3912", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/woodmart_slider\\/tikakala_slider-2\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3913", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/tablet\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3914", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-tag\\/%D8%AE%D8%B1%DB%8C%D8%AF-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3915", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-tag\\/%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3916", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-tag\\/%DA%AF%D9%88%D8%B4%DB%8C-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3917", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/author\\/admina\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3918", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/author\\/tespt\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3919", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/smart-watch\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3920", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/laptop\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3921", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/console\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3922", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/phone-cover\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3923", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/mobile\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3924", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/handsfree\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3925", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3926", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/woodmart_layout\\/cart-layout\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3927", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:17:03", "2024-02-05 20:17:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/woodmart_layout\\/single-product-layout\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3928", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%B3%D9%84%D8%A7%D9%85-%D8%AF%D9%86%DB%8C%D8%A7\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3929", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%AE%D8%B1%DB%8C%D8%AF-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84-%D9%88-%D9%84%D9%BE-%D8%AA%D8%A7%D9%BE\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3930", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%A2%D9%85%D9%88%D8%B2%D8%B4-%D8%AA%D8%B9%D9%85%DB%8C%D8%B1%D8%A7%D8%AA-%D8%B3%D8%A7%D8%B9%D8%AA\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3931", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%A2%D9%85%D9%88%D8%B2%D8%B4-%D8%AA%D8%B9%D9%85%DB%8C%D8%B1-%D8%B3%DB%8C%D8%B3%D8%AA%D9%85\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3932", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%B1%D9%88%D8%B4-%D8%A7%D8%B3%D8%AA%D9%81%D8%A7%D8%AF%D9%87-%D8%A7%D8%B2-%D8%A7%DB%8C%D8%B1%D9%BE%D8%A7%D8%AF\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3933", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%A2%D9%85%D9%88%D8%B2%D8%B4-%D8%AA%D8%A8%D9%84%DB%8C%D8%BA%D8%A7%D8%AA-%D9%88-%D8%A8%D8%B1%D9%86%D8%AF\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3934", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%A7%D9%86%D8%AA%D8%AE%D8%A7%D8%A8-%D8%B3%DB%8C%D8%B3%D8%AA%D9%85-%D8%B9%D8%A7%D9%85%D9%84-%DA%AF%D9%88%D8%B4%DB%8C\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3935", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D9%81%D9%84%D8%B4-%D9%85%D9%85%D9%88%D8%B1%DB%8C-%D8%AE%D9%88%D8%A8\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3936", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/shop\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3937", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/blog\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3938", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/store-listing\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3939", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%AA%D9%85%D8%A7%D8%B3-%D8%A8%D8%A7-%D9%85%D8%A7\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3940", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/%D8%AF%D8%B1%D8%A8%D8%A7%D8%B1%D9%87-%D9%85%D8%A7\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3941", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%DA%AF%D9%88%D8%B4%DB%8C-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84-%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF-%D9%85%D8%AF%D9%84-galaxy-a32-5g\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3942", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%DA%AF%D9%88%D8%B4%DB%8C-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84-%D8%B4%DB%8C%D8%A7%D8%A6%D9%88%D9%85%DB%8C-%D9%85%D8%AF%D9%84-poco-f3-5g\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3943", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "b02b77e2b684cdd605d4ef259c43c567", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%DA%AF%D9%88%D8%B4%DB%8C-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84-%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF-%D9%85%D8%AF%D9%84-galaxy-a32-21g\"]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3944", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%DA%AF%D9%88%D8%B4%DB%8C-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84-%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF-%D9%85%D8%AF%D9%84-galaxy-a32\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3945", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%DA%AF%D9%88%D8%B4%DB%8C-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84-%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF-a12-56a\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3946", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D8%B3%D8%A7%D8%B9%D8%AA-%D9%87%D9%88%D8%B4%D9%85%D9%86%D8%AF-%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3947", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D8%B3%D8%A7%D8%B9%D8%AA-%D9%87%D9%88%D8%B4%D9%85%D9%86%D8%AF-%D9%87%D8%A7%D9%88%D8%A7%DB%8C%DB%8C\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3948", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D8%B3%D8%A7%D8%B9%D8%AA-%D9%87%D9%88%D8%B4%D9%85%D9%86%D8%AFa21\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3949", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D8%B3%D8%A7%D8%B9%D8%AA-%D9%87%D9%88%D8%B4%D9%85%D9%86%D8%AF-%D8%B443\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3950", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D8%B3%D8%A7%D8%B9%D8%AA-%D9%87%D9%88%D8%B4%D9%85%D9%86%D8%AF-%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF-a1\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3951", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "29ce27c2fea004ca0e5b88ac9f0471a2", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D8%B3%D8%A7%D8%B9%D8%AA-%D9%87%D9%88%D8%B4%D9%85%D9%86%D8%AF-%D8%A7%D9%BE%D9%84-%D9%88%D8%A7%DA%86-%D8%B3%D8%B1%DB%8C-%DB%B8-%D8%B3%D8%A7%DB%8C%D8%B2-%DB%B4%DB%B5-%D9%85%DB%8C%D9%84%DB%8C\"]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3952", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "d9ec298e034d30889af3b7618067dd41", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%DA%A9%DB%8C%D8%B3-%DA%A9%D8%A7%D9%85%D9%BE%DB%8C%D9%88%D8%AA%D8%B1-%DA%A9%D9%88%D9%84%D8%B1%D9%85%D8%B3%D8%AA%D8%B1-%D9%85%D8%AF%D9%84-maste\"]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3953", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "b96704a6ac55ddffa9f9a2cb8d385b8c", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D9%85%D8%A7%D9%86%DB%8C%D8%AA%D9%88%D8%B1-%DB%B2%DB%B0-%D8%A7%DB%8C%D9%86%DA%86%DB%8C-%D8%A7%DB%8C%DA%A9%D8%B3-%D9%88%DB%8C%DA%98%D9%86-%D9%85%D8%AF%D9%84-xvision-xk2030h\"]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3954", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "ef1ff590d88f0b79fd2eed24cbd9d74c", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D9%86%D9%88%D8%AA%D8%A8%D9%88%DA%A9-%DB%B1%DB%B5-%D8%A7%DB%8C%D9%86%DA%86-%D9%84%D9%86%D9%88%D9%88-%D9%85%D8%AF%D9%84-lenovo-legion-5-i7-11800h-32gb-1tb-ssd-8gb-3070\"]", "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3955", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product\\/%D9%86%D9%88%D8%AA%D8%A8%D9%88%DA%A9-%D9%84%D9%86%D9%88%D9%88-%D9%85%D8%AF%D9%84-lenovo-ideapa\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3956", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/category\\/tecnology\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3957", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/woodmart_slider\\/tikakala_slider-2\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3958", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/tablet\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3959", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-tag\\/%D8%AE%D8%B1%DB%8C%D8%AF-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3960", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-tag\\/%D8%B3%D8%A7%D9%85%D8%B3%D9%88%D9%86%DA%AF\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3961", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-tag\\/%DA%AF%D9%88%D8%B4%DB%8C-%D9%85%D9%88%D8%A8%D8%A7%DB%8C%D9%84\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3962", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/author\\/admina\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3963", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/author\\/tespt\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3964", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/smart-watch\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3965", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/laptop\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3966", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/console\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3967", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/phone-cover\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3968", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:03", "2024-02-05 20:18:03", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/mobile\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3969", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:04", "2024-02-05 20:18:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/product-category\\/handsfree\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3970", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:04", "2024-02-05 20:18:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("3971", "rocket_preload_job_preload_url", "failed", "2024-02-05 20:18:04", "2024-02-05 20:18:04", "[\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/woodmart_layout\\/cart-layout\"]", "O:28:\"ActionScheduler_NullSchedule\":0:{}", "6", "1", "2024-02-05 20:22:10", "2024-02-05 19:22:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4260", "action_scheduler/migration_hook", "failed", "2024-11-19 10:40:29", "2024-11-19 09:40:29", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732012829;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732012829;}", "1", "1", "2024-11-19 10:40:33", "2024-11-19 09:40:33", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4266", "woocommerce_cleanup_draft_orders", "complete", "2024-11-26 09:29:13", "2024-11-26 08:29:13", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732613353;s:18:\"\0*\0first_timestamp\";i:1657350623;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732613353;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2024-11-26 09:53:37", "2024-11-26 08:53:37", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4267", "woocommerce_cleanup_draft_orders", "complete", "2024-11-27 09:53:37", "2024-11-27 08:53:37", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732701217;s:18:\"\0*\0first_timestamp\";i:1657350623;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732701217;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2024-11-27 11:30:14", "2024-11-27 10:30:14", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4268", "woocommerce_cleanup_draft_orders", "complete", "2024-11-28 11:30:14", "2024-11-28 10:30:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732793414;s:18:\"\0*\0first_timestamp\";i:1657350623;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732793414;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2024-11-28 11:33:17", "2024-11-28 10:33:17", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4269", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-27 18:38:53", "2024-11-27 17:38:53", "[3594,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732732733;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732732733;}", "4", "1", "2024-11-27 18:39:22", "2024-11-27 17:39:22", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4270", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-27 18:39:34", "2024-11-27 17:39:34", "[3585,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732732774;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732732774;}", "4", "1", "2024-11-27 18:39:43", "2024-11-27 17:39:43", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4271", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-27 18:40:24", "2024-11-27 17:40:24", "[108,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732732824;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732732824;}", "4", "1", "2024-11-27 18:40:49", "2024-11-27 17:40:49", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4272", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-27 18:40:40", "2024-11-27 17:40:40", "[101,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732732840;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732732840;}", "4", "1", "2024-11-27 18:40:49", "2024-11-27 17:40:49", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4273", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-27 18:40:52", "2024-11-27 17:40:52", "[100,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732732852;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732732852;}", "4", "1", "2024-11-27 18:40:55", "2024-11-27 17:40:55", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4274", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-27 18:41:00", "2024-11-27 17:41:00", "[98,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732732860;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732732860;}", "4", "1", "2024-11-27 18:41:02", "2024-11-27 17:41:02", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4275", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-27 18:41:06", "2024-11-27 17:41:06", "[97,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732732866;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732732866;}", "4", "1", "2024-11-27 18:41:08", "2024-11-27 17:41:08", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4276", "woocommerce_run_product_attribute_lookup_update_callback", "complete", "2024-11-27 18:41:14", "2024-11-27 17:41:14", "[90,1]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1732732874;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1732732874;}", "4", "1", "2024-11-27 18:41:21", "2024-11-27 17:41:21", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4277", "woocommerce_cleanup_draft_orders", "complete", "2024-11-29 11:33:17", "2024-11-29 10:33:17", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732879997;s:18:\"\0*\0first_timestamp\";i:1657350623;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732879997;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2024-11-29 12:03:00", "2024-11-29 11:03:00", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4278", "woocommerce_cleanup_draft_orders", "complete", "2024-11-30 12:03:00", "2024-11-30 11:03:00", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1732968180;s:18:\"\0*\0first_timestamp\";i:1657350623;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1732968180;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2024-11-30 12:03:22", "2024-11-30 11:03:22", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4279", "woocommerce_cleanup_draft_orders", "complete", "2024-12-01 12:03:22", "2024-12-01 11:03:22", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733054602;s:18:\"\0*\0first_timestamp\";i:1657350623;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733054602;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2024-12-01 12:03:46", "2024-12-01 11:03:46", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4280", "woocommerce_cleanup_draft_orders", "complete", "2024-12-02 12:03:47", "2024-12-02 11:03:47", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733141027;s:18:\"\0*\0first_timestamp\";i:1657350623;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733141027;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2024-12-02 12:04:05", "2024-12-02 11:04:05", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4281", "woocommerce_cleanup_draft_orders", "complete", "2024-12-03 12:04:05", "2024-12-03 11:04:05", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733227445;s:18:\"\0*\0first_timestamp\";i:1657350623;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733227445;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2024-12-03 12:04:28", "2024-12-03 11:04:28", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4282", "woocommerce_cleanup_draft_orders", "complete", "2024-12-04 12:04:28", "2024-12-04 11:04:28", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733313868;s:18:\"\0*\0first_timestamp\";i:1657350623;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733313868;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2024-12-04 12:07:54", "2024-12-04 11:07:54", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4283", "woocommerce_cleanup_draft_orders", "complete", "2024-12-05 12:07:54", "2024-12-05 11:07:54", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733400474;s:18:\"\0*\0first_timestamp\";i:1657350623;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733400474;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2024-12-05 12:11:52", "2024-12-05 11:11:52", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4284", "woocommerce_cleanup_draft_orders", "complete", "2024-12-06 12:11:52", "2024-12-06 11:11:52", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733487112;s:18:\"\0*\0first_timestamp\";i:1657350623;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733487112;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2024-12-06 12:15:11", "2024-12-06 11:15:11", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4285", "woocommerce_cleanup_draft_orders", "complete", "2024-12-07 12:15:11", "2024-12-07 11:15:11", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733573711;s:18:\"\0*\0first_timestamp\";i:1657350623;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733573711;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2024-12-07 12:22:51", "2024-12-07 11:22:51", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4286", "woocommerce_cleanup_draft_orders", "complete", "2024-12-08 12:22:51", "2024-12-08 11:22:51", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733660571;s:18:\"\0*\0first_timestamp\";i:1657350623;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733660571;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2024-12-08 13:40:30", "2024-12-08 12:40:30", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4287", "woocommerce_cleanup_draft_orders", "complete", "2024-12-09 13:40:30", "2024-12-09 12:40:30", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733751630;s:18:\"\0*\0first_timestamp\";i:1657350623;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733751630;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2024-12-09 13:56:07", "2024-12-09 12:56:07", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4288", "woocommerce_cleanup_draft_orders", "complete", "2024-12-10 13:56:07", "2024-12-10 12:56:07", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733838967;s:18:\"\0*\0first_timestamp\";i:1657350623;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733838967;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2024-12-10 14:27:38", "2024-12-10 13:27:38", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4289", "woocommerce_cleanup_draft_orders", "complete", "2024-12-11 14:27:38", "2024-12-11 13:27:38", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1733927258;s:18:\"\0*\0first_timestamp\";i:1657350623;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1733927258;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2024-12-11 14:35:44", "2024-12-11 13:35:44", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4290", "woocommerce_cleanup_draft_orders", "complete", "2024-12-12 14:35:44", "2024-12-12 13:35:44", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734014144;s:18:\"\0*\0first_timestamp\";i:1657350623;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734014144;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2024-12-12 15:07:25", "2024-12-12 14:07:25", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4291", "woocommerce_cleanup_draft_orders", "complete", "2024-12-13 15:07:25", "2024-12-13 14:07:25", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734102445;s:18:\"\0*\0first_timestamp\";i:1657350623;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734102445;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2024-12-13 15:07:49", "2024-12-13 14:07:49", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4292", "woocommerce_cleanup_draft_orders", "complete", "2024-12-14 15:07:49", "2024-12-14 14:07:49", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734188869;s:18:\"\0*\0first_timestamp\";i:1657350623;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734188869;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2024-12-14 15:08:10", "2024-12-14 14:08:10", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4293", "woocommerce_cleanup_draft_orders", "complete", "2024-12-15 15:08:10", "2024-12-15 14:08:10", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734275290;s:18:\"\0*\0first_timestamp\";i:1657350623;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734275290;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2024-12-15 15:08:30", "2024-12-15 14:08:30", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4294", "woocommerce_cleanup_draft_orders", "complete", "2024-12-16 15:08:30", "2024-12-16 14:08:30", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734361710;s:18:\"\0*\0first_timestamp\";i:1657350623;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734361710;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2024-12-16 15:08:55", "2024-12-16 14:08:55", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4295", "woocommerce_cleanup_draft_orders", "complete", "2024-12-17 15:08:55", "2024-12-17 14:08:55", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734448135;s:18:\"\0*\0first_timestamp\";i:1657350623;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734448135;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2024-12-17 15:35:40", "2024-12-17 14:35:40", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4296", "woocommerce_cleanup_draft_orders", "complete", "2024-12-18 15:35:40", "2024-12-18 14:35:40", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734536140;s:18:\"\0*\0first_timestamp\";i:1657350623;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734536140;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2024-12-18 15:54:45", "2024-12-18 14:54:45", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4297", "woocommerce_cleanup_draft_orders", "complete", "2024-12-19 15:54:45", "2024-12-19 14:54:45", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734623685;s:18:\"\0*\0first_timestamp\";i:1657350623;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734623685;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2024-12-19 17:25:49", "2024-12-19 16:25:49", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4298", "woocommerce_cleanup_draft_orders", "complete", "2024-12-20 17:25:49", "2024-12-20 16:25:49", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734715549;s:18:\"\0*\0first_timestamp\";i:1657350623;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734715549;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2024-12-20 17:39:43", "2024-12-20 16:39:43", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4299", "woocommerce_cleanup_draft_orders", "complete", "2024-12-21 17:39:43", "2024-12-21 16:39:43", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734802783;s:18:\"\0*\0first_timestamp\";i:1657350623;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734802783;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2024-12-21 17:51:51", "2024-12-21 16:51:51", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4300", "woocommerce_cleanup_draft_orders", "complete", "2024-12-22 17:51:51", "2024-12-22 16:51:51", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734889911;s:18:\"\0*\0first_timestamp\";i:1657350623;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734889911;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2024-12-22 18:11:14", "2024-12-22 17:11:14", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4301", "woocommerce_cleanup_draft_orders", "complete", "2024-12-23 18:11:14", "2024-12-23 17:11:14", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1734977474;s:18:\"\0*\0first_timestamp\";i:1657350623;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1734977474;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2024-12-23 18:11:30", "2024-12-23 17:11:30", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4302", "woocommerce_cleanup_draft_orders", "complete", "2024-12-24 18:11:30", "2024-12-24 17:11:30", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1735063890;s:18:\"\0*\0first_timestamp\";i:1657350623;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1735063890;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2024-12-24 18:11:47", "2024-12-24 17:11:47", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4303", "fetch_patterns", "complete", "2024-12-24 10:12:35", "2024-12-24 09:12:35", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735035155;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735035155;}", "8", "1", "2024-12-24 10:12:58", "2024-12-24 09:12:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4304", "woocommerce_run_on_woocommerce_admin_updated", "complete", "2024-12-24 10:12:56", "2024-12-24 09:12:56", "[]", "O:30:\"ActionScheduler_SimpleSchedule\":2:{s:22:\"\0*\0scheduled_timestamp\";i:1735035176;s:41:\"\0ActionScheduler_SimpleSchedule\0timestamp\";i:1735035176;}", "5", "1", "2024-12-24 10:12:58", "2024-12-24 09:12:58", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4305", "woocommerce_cleanup_draft_orders", "complete", "2024-12-25 18:11:47", "2024-12-25 17:11:47", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1735150307;s:18:\"\0*\0first_timestamp\";i:1657350623;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1735150307;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "1", "2024-12-25 18:12:06", "2024-12-25 17:12:06", "0", NULL, "10");
INSERT INTO `wp_actionscheduler_actions` VALUES("4306", "woocommerce_cleanup_draft_orders", "pending", "2024-12-26 18:12:06", "2024-12-26 17:12:06", "[]", "O:32:\"ActionScheduler_IntervalSchedule\":5:{s:22:\"\0*\0scheduled_timestamp\";i:1735236726;s:18:\"\0*\0first_timestamp\";i:1657350623;s:13:\"\0*\0recurrence\";i:86400;s:49:\"\0ActionScheduler_IntervalSchedule\0start_timestamp\";i:1735236726;s:53:\"\0ActionScheduler_IntervalSchedule\0interval_in_seconds\";i:86400;}", "8", "0", "0000-00-00 00:00:00", "0000-00-00 00:00:00", "0", NULL, "10");

/* INSERT TABLE DATA: wp_actionscheduler_claims */
INSERT INTO `wp_actionscheduler_claims` VALUES("115464", "2023-09-16 17:40:18");

/* INSERT TABLE DATA: wp_actionscheduler_groups */
INSERT INTO `wp_actionscheduler_groups` VALUES("1", "action-scheduler-migration");
INSERT INTO `wp_actionscheduler_groups` VALUES("2", "wc-admin-data");
INSERT INTO `wp_actionscheduler_groups` VALUES("3", "gla");
INSERT INTO `wp_actionscheduler_groups` VALUES("4", "woocommerce-db-updates");
INSERT INTO `wp_actionscheduler_groups` VALUES("5", "woocommerce-remote-inbox-engine");
INSERT INTO `wp_actionscheduler_groups` VALUES("6", "rocket-preload");
INSERT INTO `wp_actionscheduler_groups` VALUES("7", "rocket-rucss");
INSERT INTO `wp_actionscheduler_groups` VALUES("8", "");
INSERT INTO `wp_actionscheduler_groups` VALUES("9", "wc_update_product_default_cat");

/* INSERT TABLE DATA: wp_actionscheduler_logs */
INSERT INTO `wp_actionscheduler_logs` VALUES("2312", "778", "ایجاد فعالیت", "2023-02-24 23:40:48", "2023-02-24 22:40:48");
INSERT INTO `wp_actionscheduler_logs` VALUES("2315", "778", "عملیات توسط Async Request شروع شد", "2023-02-24 23:40:51", "2023-02-24 22:40:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("2316", "778", "اقدام از طریق Async Request انجام نشد: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.", "2023-02-24 23:40:51", "2023-02-24 22:40:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("2599", "873", "ایجاد فعالیت", "2023-05-03 12:22:51", "2023-05-03 12:22:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("2600", "873", "عملیات توسط WP Cron شروع شد", "2023-05-03 12:22:53", "2023-05-03 12:22:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2601", "873", "اقدام از طریق WP Cron انجام نشد: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.", "2023-05-03 12:22:53", "2023-05-03 12:22:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2710", "910", "ایجاد فعالیت", "2023-05-03 12:53:31", "2023-05-03 12:53:31");
INSERT INTO `wp_actionscheduler_logs` VALUES("2711", "910", "عملیات توسط Async Request شروع شد", "2023-05-03 12:54:37", "2023-05-03 12:54:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2712", "910", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-05-03 12:54:37", "2023-05-03 12:54:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("2773", "931", "ایجاد فعالیت", "2023-05-27 02:04:53", "2023-05-27 02:04:53");
INSERT INTO `wp_actionscheduler_logs` VALUES("2775", "931", "عملیات توسط Async Request شروع شد", "2023-05-27 02:05:16", "2023-05-27 02:05:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("2776", "931", "اقدام از طریق Async Request انجام نشد: Scheduled action for woocommerce_run_on_woocommerce_admin_updated will not be executed as no callbacks are registered.", "2023-05-27 02:05:16", "2023-05-27 02:05:16");
INSERT INTO `wp_actionscheduler_logs` VALUES("2779", "933", "ایجاد فعالیت", "2023-05-27 02:06:35", "2023-05-27 02:06:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("2780", "933", "عملیات توسط WP Cron شروع شد", "2023-05-27 02:08:38", "2023-05-27 02:08:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("2781", "933", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-05-27 02:08:38", "2023-05-27 02:08:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("3112", "1044", "ایجاد فعالیت", "2023-09-16 12:48:22", "2023-09-16 12:48:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("3113", "1044", "عملیات توسط WP Cron شروع شد", "2023-09-16 12:49:29", "2023-09-16 12:49:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("3114", "1044", "اقدام از طریق WP Cron انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-09-16 12:49:29", "2023-09-16 12:49:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("4358", "1460", "ایجاد فعالیت", "2023-09-17 13:41:38", "2023-09-17 13:41:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("4360", "1461", "ایجاد فعالیت", "2023-09-17 13:43:04", "2023-09-17 13:43:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("4362", "1460", "عملیات توسط Async Request شروع شد", "2023-09-17 13:43:04", "2023-09-17 13:43:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("4363", "1460", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2023-09-17 13:43:04", "2023-09-17 13:43:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("4366", "1461", "عملیات توسط Async Request شروع شد", "2023-09-17 13:44:28", "2023-09-17 13:44:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("4367", "1461", "اقدام از طریق Async Request انجام نشد: Scheduled action for rocket_preload_job_check_finished will not be executed as no callbacks are registered.", "2023-09-17 13:44:28", "2023-09-17 13:44:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("10996", "3738", "ایجاد فعالیت", "2024-02-05 20:12:03", "2024-02-05 19:12:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("10997", "3739", "ایجاد فعالیت", "2024-02-05 20:12:03", "2024-02-05 19:12:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("10998", "3740", "ایجاد فعالیت", "2024-02-05 20:12:03", "2024-02-05 19:12:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("10999", "3741", "ایجاد فعالیت", "2024-02-05 20:12:03", "2024-02-05 19:12:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11000", "3742", "ایجاد فعالیت", "2024-02-05 20:12:03", "2024-02-05 19:12:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11001", "3743", "ایجاد فعالیت", "2024-02-05 20:12:03", "2024-02-05 19:12:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11002", "3744", "ایجاد فعالیت", "2024-02-05 20:12:03", "2024-02-05 19:12:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11003", "3745", "ایجاد فعالیت", "2024-02-05 20:12:03", "2024-02-05 19:12:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11004", "3746", "ایجاد فعالیت", "2024-02-05 20:12:03", "2024-02-05 19:12:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11040", "3747", "ایجاد فعالیت", "2024-02-05 20:13:15", "2024-02-05 19:13:15");
INSERT INTO `wp_actionscheduler_logs` VALUES("11065", "3748", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11066", "3749", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11067", "3750", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11068", "3751", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11069", "3752", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11070", "3753", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11071", "3754", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11072", "3755", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11073", "3756", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11074", "3757", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11075", "3758", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11076", "3759", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11077", "3760", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11078", "3761", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11079", "3762", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11080", "3763", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11081", "3764", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11082", "3765", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11083", "3766", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11084", "3767", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11085", "3768", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11086", "3769", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11087", "3770", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11088", "3771", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11089", "3772", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11090", "3773", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11091", "3774", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11092", "3775", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11093", "3776", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11094", "3777", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11095", "3778", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11096", "3779", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11097", "3780", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11098", "3781", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11099", "3782", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11100", "3783", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11101", "3784", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11102", "3785", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11103", "3786", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11104", "3787", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11105", "3788", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11106", "3789", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11107", "3790", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11108", "3791", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11109", "3792", "ایجاد فعالیت", "2024-02-05 20:14:02", "2024-02-05 19:14:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("11124", "3793", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11125", "3794", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11126", "3795", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11127", "3796", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11128", "3797", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11129", "3798", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11130", "3799", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11131", "3800", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11132", "3801", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11133", "3802", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11134", "3803", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11135", "3804", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11136", "3805", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11137", "3806", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11138", "3807", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11139", "3808", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11140", "3809", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11141", "3810", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11142", "3811", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11143", "3812", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11144", "3813", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11145", "3814", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11146", "3815", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11147", "3816", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11148", "3817", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11149", "3818", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11150", "3819", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11151", "3820", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11152", "3821", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11153", "3822", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11154", "3823", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11155", "3824", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11156", "3825", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11157", "3826", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11158", "3827", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11159", "3828", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11160", "3829", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11161", "3830", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11162", "3831", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11163", "3832", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11164", "3833", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11165", "3834", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11166", "3835", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11167", "3836", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11168", "3837", "ایجاد فعالیت", "2024-02-05 20:15:12", "2024-02-05 19:15:12");
INSERT INTO `wp_actionscheduler_logs` VALUES("11195", "3838", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11196", "3839", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11197", "3840", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11198", "3841", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11199", "3842", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11200", "3843", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11201", "3844", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11202", "3845", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11203", "3846", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11204", "3847", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11205", "3848", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11206", "3849", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11207", "3850", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11208", "3851", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11209", "3852", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11210", "3853", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11211", "3854", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11212", "3855", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11213", "3856", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11214", "3857", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11215", "3858", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11216", "3859", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11217", "3860", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11218", "3861", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11219", "3862", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11220", "3863", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11221", "3864", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11222", "3865", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11223", "3866", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11224", "3867", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11225", "3868", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11226", "3869", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11227", "3870", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11228", "3871", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11229", "3872", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11230", "3873", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11231", "3874", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11232", "3875", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11233", "3876", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11234", "3877", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11235", "3878", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11236", "3879", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11237", "3880", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11238", "3881", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11239", "3882", "ایجاد فعالیت", "2024-02-05 20:16:04", "2024-02-05 19:16:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11270", "3883", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11271", "3884", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11272", "3885", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11273", "3886", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11274", "3887", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11275", "3888", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11276", "3889", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11277", "3890", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11278", "3891", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11279", "3892", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11280", "3893", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11281", "3894", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11282", "3895", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11283", "3896", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11284", "3897", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11285", "3898", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11286", "3899", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11287", "3900", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11288", "3901", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11289", "3902", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11290", "3903", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11291", "3904", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11292", "3905", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11293", "3906", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11294", "3907", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11295", "3908", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11296", "3909", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11297", "3910", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11298", "3911", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11299", "3912", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11300", "3913", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11301", "3914", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11302", "3915", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11303", "3916", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11304", "3917", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11305", "3918", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11306", "3919", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11307", "3920", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11308", "3921", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11309", "3922", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11310", "3923", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11311", "3924", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11312", "3925", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11313", "3926", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11314", "3927", "ایجاد فعالیت", "2024-02-05 20:17:03", "2024-02-05 19:17:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11349", "3928", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11350", "3929", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11351", "3930", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11352", "3931", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11353", "3932", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11354", "3933", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11355", "3934", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11356", "3935", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11357", "3936", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11358", "3937", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11359", "3938", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11360", "3939", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11361", "3940", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11362", "3941", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11363", "3942", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11364", "3943", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11365", "3944", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11366", "3945", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11367", "3946", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11368", "3947", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11369", "3948", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11370", "3949", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11371", "3950", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11372", "3951", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11373", "3952", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11374", "3953", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11375", "3954", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11376", "3955", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11377", "3956", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11378", "3957", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11379", "3958", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11380", "3959", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11381", "3960", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11382", "3961", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11383", "3962", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11384", "3963", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11385", "3964", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11386", "3965", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11387", "3966", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11388", "3967", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11389", "3968", "ایجاد فعالیت", "2024-02-05 20:18:03", "2024-02-05 19:18:03");
INSERT INTO `wp_actionscheduler_logs` VALUES("11390", "3969", "ایجاد فعالیت", "2024-02-05 20:18:04", "2024-02-05 19:18:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11391", "3970", "ایجاد فعالیت", "2024-02-05 20:18:04", "2024-02-05 19:18:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11392", "3971", "ایجاد فعالیت", "2024-02-05 20:18:04", "2024-02-05 19:18:04");
INSERT INTO `wp_actionscheduler_logs` VALUES("11430", "3738", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11431", "3738", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11432", "3739", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11433", "3739", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11434", "3740", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11435", "3740", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11436", "3741", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11437", "3741", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11438", "3742", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11439", "3742", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11440", "3743", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11441", "3743", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11442", "3744", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11443", "3744", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11444", "3745", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11445", "3745", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11446", "3746", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11447", "3746", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11448", "3748", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11449", "3748", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11450", "3749", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11451", "3749", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11452", "3750", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11453", "3750", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11454", "3751", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11455", "3751", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11456", "3752", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11457", "3752", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11458", "3753", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11459", "3753", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11460", "3754", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11461", "3754", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11462", "3755", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11463", "3755", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11464", "3756", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11465", "3756", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11466", "3757", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11467", "3757", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11468", "3758", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11469", "3758", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11470", "3759", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11471", "3759", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11472", "3760", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11473", "3760", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11474", "3761", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11475", "3761", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11476", "3762", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11477", "3762", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11478", "3763", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11479", "3763", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11480", "3764", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11481", "3764", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11482", "3765", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11483", "3765", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11484", "3766", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11485", "3766", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11486", "3767", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11487", "3767", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11488", "3768", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11489", "3768", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11490", "3769", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11491", "3769", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11492", "3770", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11493", "3770", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11494", "3771", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11495", "3771", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11496", "3772", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11497", "3772", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11498", "3773", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11499", "3773", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11500", "3774", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11501", "3774", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11502", "3775", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11503", "3775", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11504", "3776", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11505", "3776", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11506", "3777", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11507", "3777", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11508", "3778", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11509", "3778", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11510", "3779", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11511", "3779", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11512", "3780", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11513", "3780", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11514", "3781", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11515", "3781", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11516", "3782", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11517", "3782", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11518", "3783", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11519", "3783", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11520", "3784", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11521", "3784", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11522", "3785", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11523", "3785", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11524", "3786", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11525", "3786", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11526", "3787", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11527", "3787", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11528", "3788", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11529", "3788", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11530", "3789", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11531", "3789", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11532", "3790", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11533", "3790", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11534", "3791", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11535", "3791", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11536", "3792", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11537", "3792", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11538", "3747", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11539", "3747", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_check_finished will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11540", "3793", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11541", "3793", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11542", "3794", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11543", "3794", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11544", "3795", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11545", "3795", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11546", "3796", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11547", "3796", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11548", "3797", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11549", "3797", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11550", "3798", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11551", "3798", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11552", "3799", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11553", "3799", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11554", "3800", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11555", "3800", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11556", "3801", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11557", "3801", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11558", "3802", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11559", "3802", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11560", "3803", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11561", "3803", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11562", "3804", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11563", "3804", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11564", "3805", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11565", "3805", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11566", "3806", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11567", "3806", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:09", "2024-02-05 19:22:09");
INSERT INTO `wp_actionscheduler_logs` VALUES("11568", "3807", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11569", "3807", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11570", "3808", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11571", "3808", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11572", "3809", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11573", "3809", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11574", "3810", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11575", "3810", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11576", "3811", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11577", "3811", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11578", "3812", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11579", "3812", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11580", "3813", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11581", "3813", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11582", "3814", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11583", "3814", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11584", "3815", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11585", "3815", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11586", "3816", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11587", "3816", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11588", "3817", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11589", "3817", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11590", "3818", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11591", "3818", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11592", "3819", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11593", "3819", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11594", "3820", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11595", "3820", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11596", "3821", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11597", "3821", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11598", "3822", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11599", "3822", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11600", "3823", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11601", "3823", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11602", "3824", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11603", "3824", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11604", "3825", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11605", "3825", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11606", "3826", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11607", "3826", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11608", "3827", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11609", "3827", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11610", "3828", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11611", "3828", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11612", "3829", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11613", "3829", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11614", "3830", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11615", "3830", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11616", "3831", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11617", "3831", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11618", "3832", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11619", "3832", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11620", "3833", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11621", "3833", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11622", "3834", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11623", "3834", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11624", "3835", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11625", "3835", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11626", "3836", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11627", "3836", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11628", "3837", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11629", "3837", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11630", "3838", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11631", "3838", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11632", "3839", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11633", "3839", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11634", "3840", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11635", "3840", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11636", "3841", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11637", "3841", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11638", "3842", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11639", "3842", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11640", "3843", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11641", "3843", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11642", "3844", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11643", "3844", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11644", "3845", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11645", "3845", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11646", "3846", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11647", "3846", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11648", "3847", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11649", "3847", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11650", "3848", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11651", "3848", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11652", "3849", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11653", "3849", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11654", "3850", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11655", "3850", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11656", "3851", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11657", "3851", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11658", "3852", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11659", "3852", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11660", "3853", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11661", "3853", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11662", "3854", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11663", "3854", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11664", "3855", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11665", "3855", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11666", "3856", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11667", "3856", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11668", "3857", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11669", "3857", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11670", "3858", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11671", "3858", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11672", "3859", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11673", "3859", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11674", "3860", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11675", "3860", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11676", "3861", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11677", "3861", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11678", "3862", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11679", "3862", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11680", "3863", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11681", "3863", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11682", "3864", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11683", "3864", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11684", "3865", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11685", "3865", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11686", "3866", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11687", "3866", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11688", "3867", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11689", "3867", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11690", "3868", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11691", "3868", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11692", "3869", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11693", "3869", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11694", "3870", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11695", "3870", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11696", "3871", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11697", "3871", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11698", "3872", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11699", "3872", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11700", "3873", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11701", "3873", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11702", "3874", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11703", "3874", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11704", "3875", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11705", "3875", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11706", "3876", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11707", "3876", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11708", "3877", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11709", "3877", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11710", "3878", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11711", "3878", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11712", "3879", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11713", "3879", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11714", "3880", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11715", "3880", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11716", "3881", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11717", "3881", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11718", "3882", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11719", "3882", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11720", "3883", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11721", "3883", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11722", "3884", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11723", "3884", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11724", "3885", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11725", "3885", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11726", "3886", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11727", "3886", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11728", "3887", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11729", "3887", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11730", "3888", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11731", "3888", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11732", "3889", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11733", "3889", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11734", "3890", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11735", "3890", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11736", "3891", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11737", "3891", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11738", "3892", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11739", "3892", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11740", "3893", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11741", "3893", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11742", "3894", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11743", "3894", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11744", "3895", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11745", "3895", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11746", "3896", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11747", "3896", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11748", "3897", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11749", "3897", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11750", "3898", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11751", "3898", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11752", "3899", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11753", "3899", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11754", "3900", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11755", "3900", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11756", "3901", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11757", "3901", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11758", "3902", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11759", "3902", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11760", "3903", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11761", "3903", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11762", "3904", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11763", "3904", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11764", "3905", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11765", "3905", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11766", "3906", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11767", "3906", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11768", "3907", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11769", "3907", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11770", "3908", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11771", "3908", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11772", "3909", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11773", "3909", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11774", "3910", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11775", "3910", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11776", "3911", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11777", "3911", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11778", "3912", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11779", "3912", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11780", "3913", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11781", "3913", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11782", "3914", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11783", "3914", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11784", "3915", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11785", "3915", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11786", "3916", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11787", "3916", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11788", "3917", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11789", "3917", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11790", "3918", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11791", "3918", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11792", "3919", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11793", "3919", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11794", "3920", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11795", "3920", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11796", "3921", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11797", "3921", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11798", "3922", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11799", "3922", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11800", "3923", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11801", "3923", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11802", "3924", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11803", "3924", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11804", "3925", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11805", "3925", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11806", "3926", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11807", "3926", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11808", "3927", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11809", "3927", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11810", "3928", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11811", "3928", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11812", "3929", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11813", "3929", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11814", "3930", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11815", "3930", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11816", "3931", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11817", "3931", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11818", "3932", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11819", "3932", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11820", "3933", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11821", "3933", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11822", "3934", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11823", "3934", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11824", "3935", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11825", "3935", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11826", "3936", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11827", "3936", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11828", "3937", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11829", "3937", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11830", "3938", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11831", "3938", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11832", "3939", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11833", "3939", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11834", "3940", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11835", "3940", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11836", "3941", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11837", "3941", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11838", "3942", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11839", "3942", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11840", "3943", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11841", "3943", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11842", "3944", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11843", "3944", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11844", "3945", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11845", "3945", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11846", "3946", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11847", "3946", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11848", "3947", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11849", "3947", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11850", "3948", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11851", "3948", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11852", "3949", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11853", "3949", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11854", "3950", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11855", "3950", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11856", "3951", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11857", "3951", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11858", "3952", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11859", "3952", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11860", "3953", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11861", "3953", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11862", "3954", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11863", "3954", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11864", "3955", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11865", "3955", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11866", "3956", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11867", "3956", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11868", "3957", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11869", "3957", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11870", "3958", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11871", "3958", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11872", "3959", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11873", "3959", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11874", "3960", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11875", "3960", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11876", "3961", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11877", "3961", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11878", "3962", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11879", "3962", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11880", "3963", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11881", "3963", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11882", "3964", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11883", "3964", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11884", "3965", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11885", "3965", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11886", "3966", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11887", "3966", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11888", "3967", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11889", "3967", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11890", "3968", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11891", "3968", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11892", "3969", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11893", "3969", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11894", "3970", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11895", "3970", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11896", "3971", "عملیات توسط WP Cron شروع شد", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("11897", "3971", "اقدام از طریق WP Cron انجام نشد: Scheduled action for rocket_preload_job_preload_url will not be executed as no callbacks are registered.", "2024-02-05 20:22:10", "2024-02-05 19:22:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("12760", "4260", "ایجاد فعالیت", "2024-11-19 10:39:29", "2024-11-19 09:39:29");
INSERT INTO `wp_actionscheduler_logs` VALUES("12761", "4260", "عملیات توسط Async Request شروع شد", "2024-11-19 10:40:33", "2024-11-19 09:40:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("12762", "4260", "اقدام از طریق Async Request انجام نشد: Scheduled action for action_scheduler/migration_hook will not be executed as no callbacks are registered.", "2024-11-19 10:40:33", "2024-11-19 09:40:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("12780", "4266", "ایجاد فعالیت", "2024-11-25 09:29:13", "2024-11-25 08:29:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("12781", "4266", "عملیات توسط WP Cron شروع شد", "2024-11-26 09:53:37", "2024-11-26 08:53:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("12782", "4266", "عملیات توسط WP Cron کامل شد", "2024-11-26 09:53:37", "2024-11-26 08:53:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("12783", "4267", "ایجاد فعالیت", "2024-11-26 09:53:37", "2024-11-26 08:53:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("12784", "4267", "عملیات توسط WP Cron شروع شد", "2024-11-27 11:30:14", "2024-11-27 10:30:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("12785", "4267", "عملیات توسط WP Cron کامل شد", "2024-11-27 11:30:14", "2024-11-27 10:30:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("12786", "4268", "ایجاد فعالیت", "2024-11-27 11:30:14", "2024-11-27 10:30:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("12787", "4269", "ایجاد فعالیت", "2024-11-27 18:38:52", "2024-11-27 17:38:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("12788", "4269", "عملیات توسط WP Cron شروع شد", "2024-11-27 18:39:22", "2024-11-27 17:39:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("12789", "4269", "عملیات توسط WP Cron کامل شد", "2024-11-27 18:39:22", "2024-11-27 17:39:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("12790", "4270", "ایجاد فعالیت", "2024-11-27 18:39:33", "2024-11-27 17:39:33");
INSERT INTO `wp_actionscheduler_logs` VALUES("12791", "4270", "عملیات توسط Async Request شروع شد", "2024-11-27 18:39:43", "2024-11-27 17:39:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("12792", "4270", "عملیات توسط Async Request کامل شد", "2024-11-27 18:39:43", "2024-11-27 17:39:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("12793", "4271", "ایجاد فعالیت", "2024-11-27 18:40:23", "2024-11-27 17:40:23");
INSERT INTO `wp_actionscheduler_logs` VALUES("12794", "4272", "ایجاد فعالیت", "2024-11-27 18:40:39", "2024-11-27 17:40:39");
INSERT INTO `wp_actionscheduler_logs` VALUES("12795", "4271", "عملیات توسط Async Request شروع شد", "2024-11-27 18:40:49", "2024-11-27 17:40:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("12796", "4271", "عملیات توسط Async Request کامل شد", "2024-11-27 18:40:49", "2024-11-27 17:40:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("12797", "4272", "عملیات توسط Async Request شروع شد", "2024-11-27 18:40:49", "2024-11-27 17:40:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("12798", "4272", "عملیات توسط Async Request کامل شد", "2024-11-27 18:40:49", "2024-11-27 17:40:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("12799", "4273", "ایجاد فعالیت", "2024-11-27 18:40:51", "2024-11-27 17:40:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("12800", "4273", "عملیات توسط Async Request شروع شد", "2024-11-27 18:40:55", "2024-11-27 17:40:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("12801", "4273", "عملیات توسط Async Request کامل شد", "2024-11-27 18:40:55", "2024-11-27 17:40:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("12802", "4274", "ایجاد فعالیت", "2024-11-27 18:40:59", "2024-11-27 17:40:59");
INSERT INTO `wp_actionscheduler_logs` VALUES("12803", "4274", "عملیات توسط Async Request شروع شد", "2024-11-27 18:41:02", "2024-11-27 17:41:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("12804", "4274", "عملیات توسط Async Request کامل شد", "2024-11-27 18:41:02", "2024-11-27 17:41:02");
INSERT INTO `wp_actionscheduler_logs` VALUES("12805", "4275", "ایجاد فعالیت", "2024-11-27 18:41:05", "2024-11-27 17:41:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("12806", "4275", "عملیات توسط Async Request شروع شد", "2024-11-27 18:41:08", "2024-11-27 17:41:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("12807", "4275", "عملیات توسط Async Request کامل شد", "2024-11-27 18:41:08", "2024-11-27 17:41:08");
INSERT INTO `wp_actionscheduler_logs` VALUES("12808", "4276", "ایجاد فعالیت", "2024-11-27 18:41:13", "2024-11-27 17:41:13");
INSERT INTO `wp_actionscheduler_logs` VALUES("12809", "4276", "عملیات توسط WP Cron شروع شد", "2024-11-27 18:41:21", "2024-11-27 17:41:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("12810", "4276", "عملیات توسط WP Cron کامل شد", "2024-11-27 18:41:21", "2024-11-27 17:41:21");
INSERT INTO `wp_actionscheduler_logs` VALUES("12811", "4268", "عملیات توسط WP Cron شروع شد", "2024-11-28 11:33:17", "2024-11-28 10:33:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("12812", "4268", "عملیات توسط WP Cron کامل شد", "2024-11-28 11:33:17", "2024-11-28 10:33:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("12813", "4277", "ایجاد فعالیت", "2024-11-28 11:33:17", "2024-11-28 10:33:17");
INSERT INTO `wp_actionscheduler_logs` VALUES("12814", "4277", "عملیات توسط WP Cron شروع شد", "2024-11-29 12:03:00", "2024-11-29 11:03:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("12815", "4277", "عملیات توسط WP Cron کامل شد", "2024-11-29 12:03:00", "2024-11-29 11:03:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("12816", "4278", "ایجاد فعالیت", "2024-11-29 12:03:00", "2024-11-29 11:03:00");
INSERT INTO `wp_actionscheduler_logs` VALUES("12817", "4278", "عملیات توسط WP Cron شروع شد", "2024-11-30 12:03:22", "2024-11-30 11:03:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("12818", "4278", "عملیات توسط WP Cron کامل شد", "2024-11-30 12:03:22", "2024-11-30 11:03:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("12819", "4279", "ایجاد فعالیت", "2024-11-30 12:03:22", "2024-11-30 11:03:22");
INSERT INTO `wp_actionscheduler_logs` VALUES("12820", "4279", "عملیات توسط WP Cron شروع شد", "2024-12-01 12:03:46", "2024-12-01 11:03:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("12821", "4279", "عملیات توسط WP Cron کامل شد", "2024-12-01 12:03:46", "2024-12-01 11:03:46");
INSERT INTO `wp_actionscheduler_logs` VALUES("12822", "4280", "ایجاد فعالیت", "2024-12-01 12:03:47", "2024-12-01 11:03:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("12823", "4280", "عملیات توسط WP Cron شروع شد", "2024-12-02 12:04:05", "2024-12-02 11:04:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("12824", "4280", "عملیات توسط WP Cron کامل شد", "2024-12-02 12:04:05", "2024-12-02 11:04:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("12825", "4281", "ایجاد فعالیت", "2024-12-02 12:04:05", "2024-12-02 11:04:05");
INSERT INTO `wp_actionscheduler_logs` VALUES("12826", "4281", "عملیات توسط WP Cron شروع شد", "2024-12-03 12:04:28", "2024-12-03 11:04:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("12827", "4281", "عملیات توسط WP Cron کامل شد", "2024-12-03 12:04:28", "2024-12-03 11:04:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("12828", "4282", "ایجاد فعالیت", "2024-12-03 12:04:28", "2024-12-03 11:04:28");
INSERT INTO `wp_actionscheduler_logs` VALUES("12829", "4282", "عملیات توسط WP Cron شروع شد", "2024-12-04 12:07:54", "2024-12-04 11:07:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("12830", "4282", "عملیات توسط WP Cron کامل شد", "2024-12-04 12:07:54", "2024-12-04 11:07:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("12831", "4283", "ایجاد فعالیت", "2024-12-04 12:07:54", "2024-12-04 11:07:54");
INSERT INTO `wp_actionscheduler_logs` VALUES("12832", "4283", "عملیات توسط WP Cron شروع شد", "2024-12-05 12:11:52", "2024-12-05 11:11:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("12833", "4283", "عملیات توسط WP Cron کامل شد", "2024-12-05 12:11:52", "2024-12-05 11:11:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("12834", "4284", "ایجاد فعالیت", "2024-12-05 12:11:52", "2024-12-05 11:11:52");
INSERT INTO `wp_actionscheduler_logs` VALUES("12835", "4284", "عملیات توسط WP Cron شروع شد", "2024-12-06 12:15:11", "2024-12-06 11:15:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("12836", "4284", "عملیات توسط WP Cron کامل شد", "2024-12-06 12:15:11", "2024-12-06 11:15:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("12837", "4285", "ایجاد فعالیت", "2024-12-06 12:15:11", "2024-12-06 11:15:11");
INSERT INTO `wp_actionscheduler_logs` VALUES("12838", "4285", "عملیات توسط WP Cron شروع شد", "2024-12-07 12:22:51", "2024-12-07 11:22:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("12839", "4285", "عملیات توسط WP Cron کامل شد", "2024-12-07 12:22:51", "2024-12-07 11:22:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("12840", "4286", "ایجاد فعالیت", "2024-12-07 12:22:51", "2024-12-07 11:22:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("12841", "4286", "عملیات توسط WP Cron شروع شد", "2024-12-08 13:40:30", "2024-12-08 12:40:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("12842", "4286", "عملیات توسط WP Cron کامل شد", "2024-12-08 13:40:30", "2024-12-08 12:40:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("12843", "4287", "ایجاد فعالیت", "2024-12-08 13:40:30", "2024-12-08 12:40:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("12844", "4287", "عملیات توسط WP Cron شروع شد", "2024-12-09 13:56:07", "2024-12-09 12:56:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("12845", "4287", "عملیات توسط WP Cron کامل شد", "2024-12-09 13:56:07", "2024-12-09 12:56:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("12846", "4288", "ایجاد فعالیت", "2024-12-09 13:56:07", "2024-12-09 12:56:07");
INSERT INTO `wp_actionscheduler_logs` VALUES("12847", "4288", "عملیات توسط WP Cron شروع شد", "2024-12-10 14:27:37", "2024-12-10 13:27:37");
INSERT INTO `wp_actionscheduler_logs` VALUES("12848", "4288", "عملیات توسط WP Cron کامل شد", "2024-12-10 14:27:38", "2024-12-10 13:27:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("12849", "4289", "ایجاد فعالیت", "2024-12-10 14:27:38", "2024-12-10 13:27:38");
INSERT INTO `wp_actionscheduler_logs` VALUES("12850", "4289", "عملیات توسط WP Cron شروع شد", "2024-12-11 14:35:44", "2024-12-11 13:35:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("12851", "4289", "عملیات توسط WP Cron کامل شد", "2024-12-11 14:35:44", "2024-12-11 13:35:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("12852", "4290", "ایجاد فعالیت", "2024-12-11 14:35:44", "2024-12-11 13:35:44");
INSERT INTO `wp_actionscheduler_logs` VALUES("12853", "4290", "عملیات توسط WP Cron شروع شد", "2024-12-12 15:07:25", "2024-12-12 14:07:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("12854", "4290", "عملیات توسط WP Cron کامل شد", "2024-12-12 15:07:25", "2024-12-12 14:07:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("12855", "4291", "ایجاد فعالیت", "2024-12-12 15:07:25", "2024-12-12 14:07:25");
INSERT INTO `wp_actionscheduler_logs` VALUES("12856", "4291", "عملیات توسط WP Cron شروع شد", "2024-12-13 15:07:49", "2024-12-13 14:07:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("12857", "4291", "عملیات توسط WP Cron کامل شد", "2024-12-13 15:07:49", "2024-12-13 14:07:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("12858", "4292", "ایجاد فعالیت", "2024-12-13 15:07:49", "2024-12-13 14:07:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("12859", "4292", "عملیات توسط WP Cron شروع شد", "2024-12-14 15:08:10", "2024-12-14 14:08:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("12860", "4292", "عملیات توسط WP Cron کامل شد", "2024-12-14 15:08:10", "2024-12-14 14:08:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("12861", "4293", "ایجاد فعالیت", "2024-12-14 15:08:10", "2024-12-14 14:08:10");
INSERT INTO `wp_actionscheduler_logs` VALUES("12862", "4293", "عملیات توسط WP Cron شروع شد", "2024-12-15 15:08:30", "2024-12-15 14:08:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("12863", "4293", "عملیات توسط WP Cron کامل شد", "2024-12-15 15:08:30", "2024-12-15 14:08:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("12864", "4294", "ایجاد فعالیت", "2024-12-15 15:08:30", "2024-12-15 14:08:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("12865", "4294", "عملیات توسط WP Cron شروع شد", "2024-12-16 15:08:55", "2024-12-16 14:08:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("12866", "4294", "عملیات توسط WP Cron کامل شد", "2024-12-16 15:08:55", "2024-12-16 14:08:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("12867", "4295", "ایجاد فعالیت", "2024-12-16 15:08:55", "2024-12-16 14:08:55");
INSERT INTO `wp_actionscheduler_logs` VALUES("12868", "4295", "عملیات توسط WP Cron شروع شد", "2024-12-17 15:35:40", "2024-12-17 14:35:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("12869", "4295", "عملیات توسط WP Cron کامل شد", "2024-12-17 15:35:40", "2024-12-17 14:35:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("12870", "4296", "ایجاد فعالیت", "2024-12-17 15:35:40", "2024-12-17 14:35:40");
INSERT INTO `wp_actionscheduler_logs` VALUES("12871", "4296", "عملیات توسط WP Cron شروع شد", "2024-12-18 15:54:45", "2024-12-18 14:54:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("12872", "4296", "عملیات توسط WP Cron کامل شد", "2024-12-18 15:54:45", "2024-12-18 14:54:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("12873", "4297", "ایجاد فعالیت", "2024-12-18 15:54:45", "2024-12-18 14:54:45");
INSERT INTO `wp_actionscheduler_logs` VALUES("12874", "4297", "عملیات توسط WP Cron شروع شد", "2024-12-19 17:25:49", "2024-12-19 16:25:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("12875", "4297", "عملیات توسط WP Cron کامل شد", "2024-12-19 17:25:49", "2024-12-19 16:25:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("12876", "4298", "ایجاد فعالیت", "2024-12-19 17:25:49", "2024-12-19 16:25:49");
INSERT INTO `wp_actionscheduler_logs` VALUES("12877", "4298", "عملیات توسط WP Cron شروع شد", "2024-12-20 17:39:43", "2024-12-20 16:39:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("12878", "4298", "عملیات توسط WP Cron کامل شد", "2024-12-20 17:39:43", "2024-12-20 16:39:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("12879", "4299", "ایجاد فعالیت", "2024-12-20 17:39:43", "2024-12-20 16:39:43");
INSERT INTO `wp_actionscheduler_logs` VALUES("12880", "4299", "عملیات توسط WP Cron شروع شد", "2024-12-21 17:51:51", "2024-12-21 16:51:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("12881", "4299", "عملیات توسط WP Cron کامل شد", "2024-12-21 17:51:51", "2024-12-21 16:51:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("12882", "4300", "ایجاد فعالیت", "2024-12-21 17:51:51", "2024-12-21 16:51:51");
INSERT INTO `wp_actionscheduler_logs` VALUES("12883", "4300", "عملیات توسط WP Cron شروع شد", "2024-12-22 18:11:14", "2024-12-22 17:11:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("12884", "4300", "عملیات توسط WP Cron کامل شد", "2024-12-22 18:11:14", "2024-12-22 17:11:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("12885", "4301", "ایجاد فعالیت", "2024-12-22 18:11:14", "2024-12-22 17:11:14");
INSERT INTO `wp_actionscheduler_logs` VALUES("12886", "4301", "عملیات توسط WP Cron شروع شد", "2024-12-23 18:11:30", "2024-12-23 17:11:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("12887", "4301", "عملیات توسط WP Cron کامل شد", "2024-12-23 18:11:30", "2024-12-23 17:11:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("12888", "4302", "ایجاد فعالیت", "2024-12-23 18:11:30", "2024-12-23 17:11:30");
INSERT INTO `wp_actionscheduler_logs` VALUES("12889", "4303", "ایجاد فعالیت", "2024-12-24 10:12:35", "2024-12-24 09:12:35");
INSERT INTO `wp_actionscheduler_logs` VALUES("12890", "4304", "ایجاد فعالیت", "2024-12-24 10:12:56", "2024-12-24 09:12:56");
INSERT INTO `wp_actionscheduler_logs` VALUES("12891", "4303", "عملیات توسط Async Request شروع شد", "2024-12-24 10:12:58", "2024-12-24 09:12:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("12892", "4303", "عملیات توسط Async Request کامل شد", "2024-12-24 10:12:58", "2024-12-24 09:12:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("12893", "4304", "عملیات توسط Async Request شروع شد", "2024-12-24 10:12:58", "2024-12-24 09:12:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("12894", "4304", "عملیات توسط Async Request کامل شد", "2024-12-24 10:12:58", "2024-12-24 09:12:58");
INSERT INTO `wp_actionscheduler_logs` VALUES("12895", "4302", "عملیات توسط WP Cron شروع شد", "2024-12-24 18:11:47", "2024-12-24 17:11:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("12896", "4302", "عملیات توسط WP Cron کامل شد", "2024-12-24 18:11:47", "2024-12-24 17:11:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("12897", "4305", "ایجاد فعالیت", "2024-12-24 18:11:47", "2024-12-24 17:11:47");
INSERT INTO `wp_actionscheduler_logs` VALUES("12898", "4305", "عملیات توسط WP Cron شروع شد", "2024-12-25 18:12:06", "2024-12-25 17:12:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("12899", "4305", "عملیات توسط WP Cron کامل شد", "2024-12-25 18:12:06", "2024-12-25 17:12:06");
INSERT INTO `wp_actionscheduler_logs` VALUES("12900", "4306", "ایجاد فعالیت", "2024-12-25 18:12:06", "2024-12-25 17:12:06");

/* INSERT TABLE DATA: wp_appwoodart_woo_api_geo_fencing */
INSERT INTO `wp_appwoodart_woo_api_geo_fencing` VALUES("1", "111", "da9ce868f64e9507689923e874110ac9c016e963", "0", "0", "0");

/* INSERT TABLE DATA: wp_commentmeta */
INSERT INTO `wp_commentmeta` VALUES("7", "59", "rating", "5");
INSERT INTO `wp_commentmeta` VALUES("8", "59", "verified", "0");
INSERT INTO `wp_commentmeta` VALUES("9", "59", "wd_likes", "0");
INSERT INTO `wp_commentmeta` VALUES("10", "59", "wd_dislikes", "0");
INSERT INTO `wp_commentmeta` VALUES("11", "59", "wd_total_vote", "0");

/* INSERT TABLE DATA: wp_comments */
INSERT INTO `wp_comments` VALUES("1", "1", "یک نویسندهٔ دیدگاه در وردپرس", "wapuu@wordpress.example", "https://wordpress.org/", "", "2021-12-01 16:35:12", "2021-12-01 13:05:12", "سلام، این یک دیدگاه است.\nبرای شروع مدیریت، ویرایش و پاک کردن دیدگاه‌ها، لطفا بخش دیدگاه‌ها در پیشخوان را ببینید.\nتصاویر نویسندگان دیدگاه از <a href=\"https://gravatar.com\">Gravatar</a> گرفته می‌شود.", "0", "1", "", "comment", "0", "0");
INSERT INTO `wp_comments` VALUES("59", "3594", "Asdfdsfsfsdf@sdfds.com", "Asdfdsfsfsdf@sdfds.com", "", "188.229.59.91", "2024-03-18 06:24:27", "2024-03-18 07:24:27", "Asdfdsfsfsdf", "0", "0", "Mozilla/5.0 (Windows NT 10.0; Win64; x64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/109.0.0.0 Safari/537.36", "review", "0", "0");

/* INSERT TABLE DATA: wp_dokan_orders */
INSERT INTO `wp_dokan_orders` VALUES("1", "3136", "1", "101000.0000", "101000.0000", "wc-cancelled");
INSERT INTO `wp_dokan_orders` VALUES("2", "3138", "1", "59000.0000", "59000.0000", "wc-cancelled");
INSERT INTO `wp_dokan_orders` VALUES("3", "3139", "1", "89000.0000", "89000.0000", "wc-cancelled");
INSERT INTO `wp_dokan_orders` VALUES("4", "3140", "1", "70000.0000", "70000.0000", "wc-cancelled");
INSERT INTO `wp_dokan_orders` VALUES("5", "3171", "1", "47000.0000", "47000.0000", "wc-cancelled");
INSERT INTO `wp_dokan_orders` VALUES("6", "3176", "1", "47000.0000", "47000.0000", "wc-cancelled");
INSERT INTO `wp_dokan_orders` VALUES("7", "3200", "1", "282000.0000", "282000.0000", "wc-cancelled");

/* INSERT TABLE DATA: wp_dokan_vendor_balance */
INSERT INTO `wp_dokan_vendor_balance` VALUES("1", "1", "3136", "dokan_orders", "New order", "101000.0000", "0.0000", "wc-cancelled", "2022-06-07 21:40:19", "2022-06-07 04:05:59");
INSERT INTO `wp_dokan_vendor_balance` VALUES("2", "1", "3138", "dokan_orders", "New order", "59000.0000", "0.0000", "wc-cancelled", "2022-06-21 07:21:47", "2022-06-21 01:32:26");
INSERT INTO `wp_dokan_vendor_balance` VALUES("3", "1", "3139", "dokan_orders", "New order", "89000.0000", "0.0000", "wc-cancelled", "2022-06-26 00:48:18", "2022-06-25 06:42:23");
INSERT INTO `wp_dokan_vendor_balance` VALUES("4", "1", "3140", "dokan_orders", "New order", "70000.0000", "0.0000", "wc-cancelled", "2022-06-26 04:05:59", "2022-06-25 09:55:53");
INSERT INTO `wp_dokan_vendor_balance` VALUES("5", "1", "3171", "dokan_orders", "New order", "47000.0000", "0.0000", "wc-cancelled", "2022-07-27 01:16:43", "2022-07-26 07:35:46");
INSERT INTO `wp_dokan_vendor_balance` VALUES("6", "1", "3176", "dokan_orders", "New order", "47000.0000", "0.0000", "wc-cancelled", "2022-07-28 22:27:24", "2022-07-28 04:54:32");
INSERT INTO `wp_dokan_vendor_balance` VALUES("7", "1", "3200", "dokan_orders", "New order", "282000.0000", "0.0000", "wc-cancelled", "2022-08-30 22:35:32", "2022-08-30 04:31:58");

/* INSERT TABLE DATA: wp_duplicator_packages */
INSERT INTO `wp_duplicator_packages` VALUES("22", "20230527_d8afd985d988d8aadb8cdaa9d8a7d12", "cc9610d4a9b2131f7315_20241226132219", "22", "2024-12-26 13:22:43", "admina", "O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-12-26 13:22:19\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.7.1\";s:9:\"VersionDB\";s:7:\"10.6.19\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";i:22;s:4:\"Name\";s:40:\"20230527_d8afd985d988d8aadb8cdaa9d8a7d12\";s:4:\"Hash\";s:35:\"cc9610d4a9b2131f7315_20241226132219\";s:8:\"NameHash\";s:76:\"20230527_d8afd985d988d8aadb8cdaa9d8a7d12_cc9610d4a9b2131f7315_20241226132219\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";s:86:\"20230527_d8afd985d988d8aadb8cdaa9d8a7d12_cc9610d4a9b2131f7315_20241226132219_scan.json\";s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";s:4:\"21.5\";s:6:\"WPUser\";s:6:\"admina\";s:7:\"Archive\";O:11:\"DUP_Archive\":26:{s:10:\"FilterDirs\";s:0:\"\";s:11:\"FilterFiles\";s:0:\"\";s:10:\"FilterExts\";s:0:\"\";s:13:\"FilterDirsAll\";a:0:{}s:14:\"FilterFilesAll\";a:0:{}s:13:\"FilterExtsAll\";a:0:{}s:8:\"FilterOn\";i:0;s:12:\"ExportOnlyDB\";i:0;s:4:\"File\";s:88:\"20230527_d8afd985d988d8aadb8cdaa9d8a7d12_cc9610d4a9b2131f7315_20241226132219_archive.zip\";s:6:\"Format\";s:3:\"ZIP\";s:7:\"PackDir\";s:63:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/tikakala\";s:4:\"Size\";i:0;s:4:\"Dirs\";a:0:{}s:9:\"dirsCount\";i:2981;s:5:\"Files\";a:0:{}s:10:\"filesCount\";i:20278;s:10:\"FilterInfo\";O:23:\"DUP_Archive_Filter_Info\":8:{s:4:\"Dirs\";O:34:\"DUP_Archive_Filter_Scope_Directory\":6:{s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:5:\"Files\";O:29:\"DUP_Archive_Filter_Scope_File\":7:{s:4:\"Size\";a:0:{}s:7:\"Warning\";a:0:{}s:10:\"Unreadable\";a:0:{}s:10:\"AddonSites\";a:0:{}s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:4:\"Exts\";O:29:\"DUP_Archive_Filter_Scope_Base\":3:{s:4:\"Core\";a:0:{}s:6:\"Global\";a:0:{}s:8:\"Instance\";a:0:{}}s:9:\"UDirCount\";i:0;s:10:\"UFileCount\";i:0;s:9:\"UExtCount\";i:0;s:8:\"TreeSize\";a:0:{}s:11:\"TreeWarning\";a:0:{}}s:14:\"RecursiveLinks\";a:0:{}s:10:\"file_count\";i:-1;s:10:\"\0*\0Package\";O:11:\"DUP_Package\":23:{s:7:\"Created\";s:19:\"2024-12-26 13:22:19\";s:7:\"Version\";s:8:\"1.5.11.2\";s:9:\"VersionWP\";s:5:\"6.7.1\";s:9:\"VersionDB\";s:7:\"10.6.19\";s:10:\"VersionPHP\";s:6:\"7.4.33\";s:9:\"VersionOS\";s:5:\"Linux\";s:2:\"ID\";N;s:4:\"Name\";s:40:\"20230527_d8afd985d988d8aadb8cdaa9d8a7d12\";s:4:\"Hash\";s:35:\"cc9610d4a9b2131f7315_20241226132219\";s:8:\"NameHash\";s:76:\"20230527_d8afd985d988d8aadb8cdaa9d8a7d12_cc9610d4a9b2131f7315_20241226132219\";s:4:\"Type\";i:0;s:5:\"Notes\";s:0:\"\";s:8:\"ScanFile\";N;s:10:\"TimerStart\";i:-1;s:7:\"Runtime\";N;s:7:\"ExeSize\";N;s:7:\"ZipSize\";N;s:6:\"Status\";i:0;s:6:\"WPUser\";N;s:7:\"Archive\";r:21;s:9:\"Installer\";O:13:\"DUP_Installer\":15:{s:4:\"File\";s:94:\"20230527_d8afd985d988d8aadb8cdaa9d8a7d12_cc9610d4a9b2131f7315_20241226132219_installer.php.bak\";s:4:\"Size\";i:0;s:10:\"OptsDBHost\";s:0:\"\";s:10:\"OptsDBPort\";s:0:\"\";s:10:\"OptsDBName\";s:0:\"\";s:10:\"OptsDBUser\";s:0:\"\";s:13:\"OptsDBCharset\";s:0:\"\";s:15:\"OptsDBCollation\";s:0:\"\";s:12:\"OptsSecureOn\";i:0;s:14:\"OptsSecurePass\";s:0:\"\";s:13:\"numFilesAdded\";i:0;s:12:\"numDirsAdded\";i:0;s:10:\"\0*\0Package\";r:65;s:17:\"\0*\0origFileManger\";N;s:32:\"\0DUP_Installer\0configTransformer\";O:44:\"Duplicator\\Libs\\WpConfig\\WPConfigTransformer\":3:{s:17:\"\0*\0wp_config_path\";s:77:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/tikakala/wp-config.php\";s:16:\"\0*\0wp_config_src\";N;s:13:\"\0*\0wp_configs\";a:0:{}}}s:8:\"Database\";O:12:\"DUP_Database\":15:{s:4:\"Type\";s:5:\"MySQL\";s:4:\"Size\";N;s:4:\"File\";s:89:\"20230527_d8afd985d988d8aadb8cdaa9d8a7d12_cc9610d4a9b2131f7315_20241226132219_database.sql\";s:4:\"Path\";N;s:12:\"FilterTables\";s:0:\"\";s:8:\"FilterOn\";i:0;s:4:\"Name\";N;s:10:\"Compatible\";s:0:\"\";s:8:\"Comments\";s:14:\"MariaDB Server\";s:19:\"sameNameTableExists\";b:0;s:4:\"info\";O:16:\"DUP_DatabaseInfo\":23:{s:9:\"buildMode\";s:3:\"PHP\";s:11:\"charSetList\";a:0:{}s:13:\"collationList\";a:0:{}s:10:\"engineList\";a:0:{}s:17:\"isTablesUpperCase\";b:0;s:15:\"isNameUpperCase\";b:0;s:4:\"name\";s:0:\"\";s:15:\"tablesBaseCount\";i:0;s:16:\"tablesFinalCount\";i:0;s:20:\"muFilteredTableCount\";i:0;s:14:\"tablesRowCount\";i:0;s:16:\"tablesSizeOnDisk\";i:0;s:10:\"tablesList\";a:0:{}s:19:\"lowerCaseTableNames\";i:0;s:8:\"dbEngine\";s:0:\"\";s:7:\"version\";i:0;s:14:\"versionComment\";i:0;s:9:\"viewCount\";i:0;s:9:\"procCount\";i:0;s:9:\"funcCount\";i:0;s:11:\"triggerList\";a:0:{}s:33:\"\0DUP_DatabaseInfo\0intFieldsStruct\";a:0:{}s:42:\"\0DUP_DatabaseInfo\0indexProcessedSchemaSize\";a:0:{}}s:10:\"\0*\0Package\";r:1;s:24:\"\0DUP_Database\0tempDbPath\";s:185:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/tikakala/wp-content/backups-dup-lite/tmp/20230527_d8afd985d988d8aadb8cdaa9d8a7d12_cc9610d4a9b2131f7315_20241226132219_database.sql\";s:23:\"\0DUP_Database\0EOFMarker\";s:0:\"\";s:26:\"\0DUP_Database\0networkFlush\";b:0;}s:13:\"BuildProgress\";O:18:\"DUP_Build_Progress\":12:{s:17:\"thread_start_time\";N;s:11:\"initialized\";b:0;s:15:\"installer_built\";b:0;s:15:\"archive_started\";b:0;s:20:\"archive_has_database\";b:0;s:13:\"archive_built\";b:0;s:21:\"database_script_built\";b:0;s:6:\"failed\";b:0;s:7:\"retries\";i:0;s:14:\"build_failures\";a:0:{}s:19:\"validation_failures\";a:0:{}s:27:\"\0DUP_Build_Progress\0package\";r:65;}}s:29:\"\0DUP_Archive\0tmpFilterDirsAll\";a:0:{}s:24:\"\0DUP_Archive\0wpCorePaths\";a:3:{i:0;s:72:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/tikakala/wp-admin\";i:1;s:75:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/tikakala/wp-includes\";i:2;s:84:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/tikakala/wp-content/languages\";}s:29:\"\0DUP_Archive\0wpCoreExactPaths\";a:7:{i:0;s:63:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/tikakala\";i:1;s:63:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/tikakala\";i:2;s:74:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/tikakala/wp-content\";i:3;s:82:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/tikakala/wp-content/uploads\";i:4;s:82:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/tikakala/wp-content/plugins\";i:5;s:85:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/tikakala/wp-content/mu-plugins\";i:6;s:81:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/tikakala/wp-content/themes\";}s:31:\"\0DUP_Archive\0relativeFiltersDir\";a:2:{i:0;s:95:\"/home/aramisco/domains/demoes.aramis-co.ir/public_html/tikakala/wp-content/backups-dup-lite/tmp\";i:1;s:15:\"backups-dup-pro\";}s:24:\"\0DUP_Archive\0listFileObj\";N;s:23:\"\0DUP_Archive\0listDirObj\";N;}s:9:\"Installer\";r:86;s:8:\"Database\";r:105;s:13:\"BuildProgress\";r:144;}");

/* INSERT TABLE DATA: wp_duplicator_pro_entities */
INSERT INTO `wp_duplicator_pro_entities` VALUES("1", "DUP_PRO_Global_Entity", "{\n    \"uninstall_settings\": false,\n    \"uninstall_packages\": false,\n    \"uninstall_tables\": true,\n    \"crypt\": true,\n    \"wpfront_integrate\": false,\n    \"package_ui_created\": 1,\n    \"package_mysqldump\": false,\n    \"package_mysqldump_path\": \"\",\n    \"package_phpdump_mode\": 0,\n    \"package_phpdump_qrylimit\": 500,\n    \"package_php_chunking\": null,\n    \"package_mysqldump_qrylimit\": 131072,\n    \"archive_build_mode\": 1,\n    \"archive_compression\": true,\n    \"ziparchive_validation\": false,\n    \"ziparchive_mode\": 0,\n    \"ziparchive_chunk_size_in_mb\": 6,\n    \"archive_build_mode_schedule\": -1,\n    \"archive_compression_schedule\": true,\n    \"server_load_reduction\": 0,\n    \"max_package_runtime_in_min\": 90,\n    \"php_max_worker_time_in_sec\": 18,\n    \"lock_mode\": 1,\n    \"json_mode\": 0,\n    \"ajax_protocol\": \"https\",\n    \"custom_ajax_url\": \"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-admin\\/admin-ajax.php\",\n    \"server_kick_off_sslverify\": true,\n    \"clientside_kickoff\": false,\n    \"basic_auth_enabled\": false,\n    \"basic_auth_user\": \"\",\n    \"basic_auth_password\": \"\",\n    \"installer_base_name\": \"installer.php\",\n    \"chunk_size\": 2048,\n    \"skip_archive_scan\": false,\n    \"send_email_on_build_mode\": 1,\n    \"notification_email_address\": \"\",\n    \"storage_htaccess_off\": false,\n    \"max_storage_retries\": 10,\n    \"max_default_store_files\": 20,\n    \"purge_default_package_record\": false,\n    \"dropbox_upload_chunksize_in_kb\": 2000,\n    \"dropbox_transfer_mode\": 1,\n    \"gdrive_upload_chunksize_in_kb\": 1000,\n    \"s3_upload_part_size_in_kb\": 6000,\n    \"manual_mode_storage_ids\": [\n        -2\n    ],\n    \"license_status\": 0,\n    \"license_expiration_time\": 1642785283,\n    \"license_no_activations_left\": false,\n    \"license_key_visible\": true,\n    \"lkp\": \"\",\n    \"license_limit\": -1,\n    \"last_edd_api_response\": null,\n    \"last_edd_api_timestamp\": 0,\n    \"last_system_check_timestamp\": 1642785295,\n    \"initial_activation_timestamp\": 1642785295,\n    \"ssl_useservercerts\": true,\n    \"ssl_disableverify\": true,\n    \"ipv4_only\": false,\n    \"debug_on\": false,\n    \"trace_profiler_on\": false,\n    \"unhook_third_party_js\": false,\n    \"unhook_third_party_css\": false,\n    \"profile_idea\": false,\n    \"profile_beta\": false,\n    \"dupHidePackagesGiftFeatures\": true,\n    \"type\": \"DUP_PRO_Global_Entity\",\n    \"notices\": {\n        \"dupArchiveSwitch\": true\n    }\n}");
INSERT INTO `wp_duplicator_pro_entities` VALUES("2", "DUP_PRO_Secure_Global_Entity", "{\n    \"basic_auth_password\": null,\n    \"lkp\": \"\",\n    \"type\": \"DUP_PRO_Secure_Global_Entity\"\n}");
INSERT INTO `wp_duplicator_pro_entities` VALUES("3", "DUP_PRO_System_Global_Entity", "{\n    \"recommended_fixes\": [],\n    \"schedule_failed\": false,\n    \"package_check_ts\": 1642785407,\n    \"type\": \"DUP_PRO_System_Global_Entity\"\n}");
INSERT INTO `wp_duplicator_pro_entities` VALUES("4", "DUP_PRO_Package_Template_Entity", "{\"name\":\"Default\",\"notes\":\"The default template.\",\"filter_sites\":[],\"archive_export_onlydb\":0,\"archive_filter_on\":0,\"archive_filter_dirs\":\"\",\"archive_filter_exts\":\"\",\"archive_filter_files\":\"\",\"database_filter_on\":0,\"database_filter_tables\":\"\",\"database_compatibility_modes\":[],\"installer_opts_secure_on\":null,\"installer_opts_secure_pass\":null,\"installer_opts_skip_scan\":null,\"installer_opts_db_host\":null,\"installer_opts_db_name\":null,\"installer_opts_db_user\":null,\"installer_opts_cpnl_enable\":false,\"installer_opts_cpnl_host\":\"\",\"installer_opts_cpnl_user\":\"\",\"installer_opts_cpnl_pass\":\"\",\"installer_opts_cpnl_db_action\":\"create\",\"installer_opts_cpnl_db_host\":\"\",\"installer_opts_cpnl_db_name\":\"\",\"installer_opts_cpnl_db_user\":\"\",\"installer_opts_brand\":-2,\"is_default\":true,\"is_manual\":false,\"type\":\"DUP_PRO_Package_Template_Entity\"}");
INSERT INTO `wp_duplicator_pro_entities` VALUES("5", "DUP_PRO_Package_Template_Entity", "{\"name\":\"[Manual Mode]\",\"notes\":\"\",\"filter_sites\":[],\"archive_export_onlydb\":0,\"archive_filter_on\":0,\"archive_filter_dirs\":\"\",\"archive_filter_exts\":\"\",\"archive_filter_files\":\"\",\"database_filter_on\":0,\"database_filter_tables\":\"\",\"database_compatibility_modes\":[],\"installer_opts_secure_on\":null,\"installer_opts_secure_pass\":null,\"installer_opts_skip_scan\":null,\"installer_opts_db_host\":null,\"installer_opts_db_name\":null,\"installer_opts_db_user\":null,\"installer_opts_cpnl_enable\":false,\"installer_opts_cpnl_host\":\"\",\"installer_opts_cpnl_user\":\"\",\"installer_opts_cpnl_pass\":\"\",\"installer_opts_cpnl_db_action\":\"create\",\"installer_opts_cpnl_db_host\":\"\",\"installer_opts_cpnl_db_name\":\"\",\"installer_opts_cpnl_db_user\":\"\",\"installer_opts_brand\":-2,\"is_default\":false,\"is_manual\":true,\"type\":\"DUP_PRO_Package_Template_Entity\"}");

/* INSERT TABLE DATA: wp_gla_budget_recommendations */
INSERT INTO `wp_gla_budget_recommendations` VALUES("1", "AED", "US", "45", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2", "AED", "CH", "40", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3", "AED", "AU", "35", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4", "AED", "GB", "30", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("5", "AED", "DE", "30", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("6", "AED", "DK", "30", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("7", "AED", "AT", "20", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("8", "AED", "NO", "25", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("9", "AED", "CA", "25", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("10", "AED", "NL", "30", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("11", "AED", "SE", "25", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("12", "AED", "IE", "25", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("13", "AED", "BE", "20", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("14", "AED", "FI", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("15", "AED", "FR", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("16", "AED", "NZ", "20", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("17", "AED", "HK", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("18", "AED", "CZ", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("19", "AED", "SK", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("20", "AED", "AE", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("21", "AED", "SG", "20", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("22", "AED", "IL", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("23", "AED", "KW", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("24", "AED", "IT", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("25", "AED", "JP", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("26", "AED", "ES", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("27", "AED", "VE", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("28", "AED", "HU", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("29", "AED", "PT", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("30", "AED", "GR", "15", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("31", "AED", "KR", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("32", "AED", "TW", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("33", "AED", "PL", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("34", "AED", "ZM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("35", "AED", "PR", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("36", "AED", "CI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("37", "AED", "RO", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("38", "AED", "BH", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("39", "AED", "PA", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("40", "AED", "GH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("41", "AED", "KH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("42", "AED", "SN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("43", "AED", "SA", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("44", "AED", "RU", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("45", "AED", "UG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("46", "AED", "BR", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("47", "AED", "NI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("48", "AED", "MG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("49", "AED", "DO", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("50", "AED", "MX", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("51", "AED", "OM", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("52", "AED", "CM", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("53", "AED", "ZA", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("54", "AED", "CL", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("55", "AED", "KE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("56", "AED", "NP", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("57", "AED", "PE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("58", "AED", "UA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("59", "AED", "MZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("60", "AED", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("61", "AED", "AO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("62", "AED", "JO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("63", "AED", "ZW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("64", "AED", "TR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("65", "AED", "MU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("66", "AED", "SV", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("67", "AED", "TH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("68", "AED", "CO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("69", "AED", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("70", "AED", "CR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("71", "AED", "AR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("72", "AED", "MA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("73", "AED", "MY", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("74", "AED", "KZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("75", "AED", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("76", "AED", "ID", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("77", "AED", "NG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("78", "AED", "GT", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("79", "AED", "VN", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("80", "AED", "BY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("81", "AED", "EG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("82", "AED", "UY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("83", "AED", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("84", "AED", "PK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("85", "AED", "PH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("86", "AED", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("87", "AED", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("88", "AED", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("89", "AED", "IN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("90", "AED", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("91", "AED", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("92", "AED", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("93", "AED", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("94", "AED", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("95", "ARS", "US", "1010", "2845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("96", "ARS", "CH", "940", "2475");
INSERT INTO `wp_gla_budget_recommendations` VALUES("97", "ARS", "AU", "855", "2200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("98", "ARS", "GB", "745", "1910");
INSERT INTO `wp_gla_budget_recommendations` VALUES("99", "ARS", "DE", "740", "1895");
INSERT INTO `wp_gla_budget_recommendations` VALUES("100", "ARS", "DK", "680", "1690");
INSERT INTO `wp_gla_budget_recommendations` VALUES("101", "ARS", "AT", "495", "1545");
INSERT INTO `wp_gla_budget_recommendations` VALUES("102", "ARS", "NO", "565", "1575");
INSERT INTO `wp_gla_budget_recommendations` VALUES("103", "ARS", "CA", "625", "1910");
INSERT INTO `wp_gla_budget_recommendations` VALUES("104", "ARS", "NL", "665", "1690");
INSERT INTO `wp_gla_budget_recommendations` VALUES("105", "ARS", "SE", "535", "1445");
INSERT INTO `wp_gla_budget_recommendations` VALUES("106", "ARS", "IE", "530", "1390");
INSERT INTO `wp_gla_budget_recommendations` VALUES("107", "ARS", "BE", "485", "1425");
INSERT INTO `wp_gla_budget_recommendations` VALUES("108", "ARS", "FI", "365", "1105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("109", "ARS", "FR", "450", "1205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("110", "ARS", "NZ", "460", "1345");
INSERT INTO `wp_gla_budget_recommendations` VALUES("111", "ARS", "HK", "415", "1175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("112", "ARS", "CZ", "395", "950");
INSERT INTO `wp_gla_budget_recommendations` VALUES("113", "ARS", "SK", "375", "810");
INSERT INTO `wp_gla_budget_recommendations` VALUES("114", "ARS", "AE", "355", "1110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("115", "ARS", "SG", "460", "1360");
INSERT INTO `wp_gla_budget_recommendations` VALUES("116", "ARS", "IL", "400", "985");
INSERT INTO `wp_gla_budget_recommendations` VALUES("117", "ARS", "KW", "180", "885");
INSERT INTO `wp_gla_budget_recommendations` VALUES("118", "ARS", "IT", "275", "725");
INSERT INTO `wp_gla_budget_recommendations` VALUES("119", "ARS", "JP", "345", "975");
INSERT INTO `wp_gla_budget_recommendations` VALUES("120", "ARS", "ES", "280", "745");
INSERT INTO `wp_gla_budget_recommendations` VALUES("121", "ARS", "VE", "35", "570");
INSERT INTO `wp_gla_budget_recommendations` VALUES("122", "ARS", "HU", "235", "550");
INSERT INTO `wp_gla_budget_recommendations` VALUES("123", "ARS", "PT", "235", "615");
INSERT INTO `wp_gla_budget_recommendations` VALUES("124", "ARS", "GR", "290", "600");
INSERT INTO `wp_gla_budget_recommendations` VALUES("125", "ARS", "KR", "360", "955");
INSERT INTO `wp_gla_budget_recommendations` VALUES("126", "ARS", "TW", "290", "785");
INSERT INTO `wp_gla_budget_recommendations` VALUES("127", "ARS", "PL", "250", "620");
INSERT INTO `wp_gla_budget_recommendations` VALUES("128", "ARS", "ZM", "35", "205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("129", "ARS", "PR", "90", "830");
INSERT INTO `wp_gla_budget_recommendations` VALUES("130", "ARS", "CI", "50", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("131", "ARS", "RO", "230", "555");
INSERT INTO `wp_gla_budget_recommendations` VALUES("132", "ARS", "BH", "105", "580");
INSERT INTO `wp_gla_budget_recommendations` VALUES("133", "ARS", "PA", "70", "795");
INSERT INTO `wp_gla_budget_recommendations` VALUES("134", "ARS", "GH", "85", "235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("135", "ARS", "KH", "50", "230");
INSERT INTO `wp_gla_budget_recommendations` VALUES("136", "ARS", "SN", "35", "250");
INSERT INTO `wp_gla_budget_recommendations` VALUES("137", "ARS", "SA", "150", "575");
INSERT INTO `wp_gla_budget_recommendations` VALUES("138", "ARS", "RU", "150", "475");
INSERT INTO `wp_gla_budget_recommendations` VALUES("139", "ARS", "UG", "35", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("140", "ARS", "BR", "160", "390");
INSERT INTO `wp_gla_budget_recommendations` VALUES("141", "ARS", "NI", "35", "250");
INSERT INTO `wp_gla_budget_recommendations` VALUES("142", "ARS", "MG", "35", "180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("143", "ARS", "DO", "40", "295");
INSERT INTO `wp_gla_budget_recommendations` VALUES("144", "ARS", "MX", "120", "435");
INSERT INTO `wp_gla_budget_recommendations` VALUES("145", "ARS", "OM", "75", "435");
INSERT INTO `wp_gla_budget_recommendations` VALUES("146", "ARS", "CM", "35", "325");
INSERT INTO `wp_gla_budget_recommendations` VALUES("147", "ARS", "ZA", "145", "460");
INSERT INTO `wp_gla_budget_recommendations` VALUES("148", "ARS", "CL", "150", "445");
INSERT INTO `wp_gla_budget_recommendations` VALUES("149", "ARS", "KE", "45", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("150", "ARS", "NP", "35", "170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("151", "ARS", "PE", "90", "375");
INSERT INTO `wp_gla_budget_recommendations` VALUES("152", "ARS", "UA", "85", "265");
INSERT INTO `wp_gla_budget_recommendations` VALUES("153", "ARS", "MZ", "35", "350");
INSERT INTO `wp_gla_budget_recommendations` VALUES("154", "ARS", "TZ", "5", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("155", "ARS", "AO", "75", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("156", "ARS", "JO", "55", "270");
INSERT INTO `wp_gla_budget_recommendations` VALUES("157", "ARS", "ZW", "35", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("158", "ARS", "TR", "90", "250");
INSERT INTO `wp_gla_budget_recommendations` VALUES("159", "ARS", "MU", "45", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("160", "ARS", "SV", "35", "195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("161", "ARS", "TH", "135", "430");
INSERT INTO `wp_gla_budget_recommendations` VALUES("162", "ARS", "CO", "70", "270");
INSERT INTO `wp_gla_budget_recommendations` VALUES("163", "ARS", "LK", "35", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("164", "ARS", "CR", "40", "280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("165", "ARS", "AR", "95", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("166", "ARS", "MA", "40", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("167", "ARS", "MY", "120", "440");
INSERT INTO `wp_gla_budget_recommendations` VALUES("168", "ARS", "KZ", "50", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("169", "ARS", "DZ", "40", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("170", "ARS", "ID", "105", "395");
INSERT INTO `wp_gla_budget_recommendations` VALUES("171", "ARS", "NG", "60", "380");
INSERT INTO `wp_gla_budget_recommendations` VALUES("172", "ARS", "GT", "40", "295");
INSERT INTO `wp_gla_budget_recommendations` VALUES("173", "ARS", "VN", "85", "330");
INSERT INTO `wp_gla_budget_recommendations` VALUES("174", "ARS", "BY", "40", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("175", "ARS", "EG", "55", "335");
INSERT INTO `wp_gla_budget_recommendations` VALUES("176", "ARS", "UY", "45", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("177", "ARS", "BD", "35", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("178", "ARS", "PK", "40", "225");
INSERT INTO `wp_gla_budget_recommendations` VALUES("179", "ARS", "PH", "70", "250");
INSERT INTO `wp_gla_budget_recommendations` VALUES("180", "ARS", "ET", "10", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("181", "ARS", "TN", "40", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("182", "ARS", "LB", "40", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("183", "ARS", "IN", "40", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("184", "ARS", "PY", "40", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("185", "ARS", "UZ", "40", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("186", "ARS", "EC", "40", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("187", "ARS", "MM", "40", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("188", "ARS", "GE", "40", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("189", "AUD", "US", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("190", "AUD", "CH", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("191", "AUD", "AU", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("192", "AUD", "GB", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("193", "AUD", "DE", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("194", "AUD", "DK", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("195", "AUD", "AT", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("196", "AUD", "NO", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("197", "AUD", "CA", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("198", "AUD", "NL", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("199", "AUD", "SE", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("200", "AUD", "IE", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("201", "AUD", "BE", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("202", "AUD", "FI", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("203", "AUD", "FR", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("204", "AUD", "NZ", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("205", "AUD", "HK", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("206", "AUD", "CZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("207", "AUD", "SK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("208", "AUD", "AE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("209", "AUD", "SG", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("210", "AUD", "IL", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("211", "AUD", "KW", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("212", "AUD", "IT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("213", "AUD", "JP", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("214", "AUD", "ES", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("215", "AUD", "VE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("216", "AUD", "HU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("217", "AUD", "PT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("218", "AUD", "GR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("219", "AUD", "KR", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("220", "AUD", "TW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("221", "AUD", "PL", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("222", "AUD", "ZM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("223", "AUD", "PR", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("224", "AUD", "CI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("225", "AUD", "RO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("226", "AUD", "BH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("227", "AUD", "PA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("228", "AUD", "GH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("229", "AUD", "KH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("230", "AUD", "SN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("231", "AUD", "SA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("232", "AUD", "RU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("233", "AUD", "UG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("234", "AUD", "BR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("235", "AUD", "NI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("236", "AUD", "MG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("237", "AUD", "DO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("238", "AUD", "MX", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("239", "AUD", "OM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("240", "AUD", "CM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("241", "AUD", "ZA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("242", "AUD", "CL", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("243", "AUD", "KE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("244", "AUD", "NP", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("245", "AUD", "PE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("246", "AUD", "UA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("247", "AUD", "MZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("248", "AUD", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("249", "AUD", "AO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("250", "AUD", "JO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("251", "AUD", "ZW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("252", "AUD", "TR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("253", "AUD", "MU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("254", "AUD", "SV", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("255", "AUD", "TH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("256", "AUD", "CO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("257", "AUD", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("258", "AUD", "CR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("259", "AUD", "AR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("260", "AUD", "MA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("261", "AUD", "MY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("262", "AUD", "KZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("263", "AUD", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("264", "AUD", "ID", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("265", "AUD", "NG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("266", "AUD", "GT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("267", "AUD", "VN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("268", "AUD", "BY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("269", "AUD", "EG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("270", "AUD", "UY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("271", "AUD", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("272", "AUD", "PK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("273", "AUD", "PH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("274", "AUD", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("275", "AUD", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("276", "AUD", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("277", "AUD", "IN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("278", "AUD", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("279", "AUD", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("280", "AUD", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("281", "AUD", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("282", "AUD", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("283", "BGN", "US", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("284", "BGN", "CH", "20", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("285", "BGN", "AU", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("286", "BGN", "GB", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("287", "BGN", "DE", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("288", "BGN", "DK", "15", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("289", "BGN", "AT", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("290", "BGN", "NO", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("291", "BGN", "CA", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("292", "BGN", "NL", "15", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("293", "BGN", "SE", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("294", "BGN", "IE", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("295", "BGN", "BE", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("296", "BGN", "FI", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("297", "BGN", "FR", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("298", "BGN", "NZ", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("299", "BGN", "HK", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("300", "BGN", "CZ", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("301", "BGN", "SK", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("302", "BGN", "AE", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("303", "BGN", "SG", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("304", "BGN", "IL", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("305", "BGN", "KW", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("306", "BGN", "IT", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("307", "BGN", "JP", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("308", "BGN", "ES", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("309", "BGN", "VE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("310", "BGN", "HU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("311", "BGN", "PT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("312", "BGN", "GR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("313", "BGN", "KR", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("314", "BGN", "TW", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("315", "BGN", "PL", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("316", "BGN", "ZM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("317", "BGN", "PR", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("318", "BGN", "CI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("319", "BGN", "RO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("320", "BGN", "BH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("321", "BGN", "PA", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("322", "BGN", "GH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("323", "BGN", "KH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("324", "BGN", "SN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("325", "BGN", "SA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("326", "BGN", "RU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("327", "BGN", "UG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("328", "BGN", "BR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("329", "BGN", "NI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("330", "BGN", "MG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("331", "BGN", "DO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("332", "BGN", "MX", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("333", "BGN", "OM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("334", "BGN", "CM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("335", "BGN", "ZA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("336", "BGN", "CL", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("337", "BGN", "KE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("338", "BGN", "NP", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("339", "BGN", "PE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("340", "BGN", "UA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("341", "BGN", "MZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("342", "BGN", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("343", "BGN", "AO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("344", "BGN", "JO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("345", "BGN", "ZW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("346", "BGN", "TR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("347", "BGN", "MU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("348", "BGN", "SV", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("349", "BGN", "TH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("350", "BGN", "CO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("351", "BGN", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("352", "BGN", "CR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("353", "BGN", "AR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("354", "BGN", "MA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("355", "BGN", "MY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("356", "BGN", "KZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("357", "BGN", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("358", "BGN", "ID", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("359", "BGN", "NG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("360", "BGN", "GT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("361", "BGN", "VN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("362", "BGN", "BY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("363", "BGN", "EG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("364", "BGN", "UY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("365", "BGN", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("366", "BGN", "PK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("367", "BGN", "PH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("368", "BGN", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("369", "BGN", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("370", "BGN", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("371", "BGN", "IN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("372", "BGN", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("373", "BGN", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("374", "BGN", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("375", "BGN", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("376", "BGN", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("377", "BOB", "US", "80", "230");
INSERT INTO `wp_gla_budget_recommendations` VALUES("378", "BOB", "CH", "75", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("379", "BOB", "AU", "70", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("380", "BOB", "GB", "60", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("381", "BOB", "DE", "60", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("382", "BOB", "DK", "55", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("383", "BOB", "AT", "40", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("384", "BOB", "NO", "45", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("385", "BOB", "CA", "50", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("386", "BOB", "NL", "55", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("387", "BOB", "SE", "45", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("388", "BOB", "IE", "40", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("389", "BOB", "BE", "40", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("390", "BOB", "FI", "30", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("391", "BOB", "FR", "35", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("392", "BOB", "NZ", "35", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("393", "BOB", "HK", "35", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("394", "BOB", "CZ", "30", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("395", "BOB", "SK", "30", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("396", "BOB", "AE", "30", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("397", "BOB", "SG", "35", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("398", "BOB", "IL", "30", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("399", "BOB", "KW", "15", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("400", "BOB", "IT", "20", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("401", "BOB", "JP", "30", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("402", "BOB", "ES", "25", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("403", "BOB", "VE", "5", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("404", "BOB", "HU", "20", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("405", "BOB", "PT", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("406", "BOB", "GR", "25", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("407", "BOB", "KR", "30", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("408", "BOB", "TW", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("409", "BOB", "PL", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("410", "BOB", "ZM", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("411", "BOB", "PR", "5", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("412", "BOB", "CI", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("413", "BOB", "RO", "20", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("414", "BOB", "BH", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("415", "BOB", "PA", "5", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("416", "BOB", "GH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("417", "BOB", "KH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("418", "BOB", "SN", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("419", "BOB", "SA", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("420", "BOB", "RU", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("421", "BOB", "UG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("422", "BOB", "BR", "15", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("423", "BOB", "NI", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("424", "BOB", "MG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("425", "BOB", "DO", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("426", "BOB", "MX", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("427", "BOB", "OM", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("428", "BOB", "CM", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("429", "BOB", "ZA", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("430", "BOB", "CL", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("431", "BOB", "KE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("432", "BOB", "NP", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("433", "BOB", "PE", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("434", "BOB", "UA", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("435", "BOB", "MZ", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("436", "BOB", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("437", "BOB", "AO", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("438", "BOB", "JO", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("439", "BOB", "ZW", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("440", "BOB", "TR", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("441", "BOB", "MU", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("442", "BOB", "SV", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("443", "BOB", "TH", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("444", "BOB", "CO", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("445", "BOB", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("446", "BOB", "CR", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("447", "BOB", "AR", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("448", "BOB", "MA", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("449", "BOB", "MY", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("450", "BOB", "KZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("451", "BOB", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("452", "BOB", "ID", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("453", "BOB", "NG", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("454", "BOB", "GT", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("455", "BOB", "VN", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("456", "BOB", "BY", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("457", "BOB", "EG", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("458", "BOB", "UY", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("459", "BOB", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("460", "BOB", "PK", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("461", "BOB", "PH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("462", "BOB", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("463", "BOB", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("464", "BOB", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("465", "BOB", "IN", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("466", "BOB", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("467", "BOB", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("468", "BOB", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("469", "BOB", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("470", "BOB", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("471", "BRL", "US", "65", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("472", "BRL", "CH", "60", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("473", "BRL", "AU", "55", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("474", "BRL", "GB", "45", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("475", "BRL", "DE", "45", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("476", "BRL", "DK", "40", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("477", "BRL", "AT", "30", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("478", "BRL", "NO", "35", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("479", "BRL", "CA", "40", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("480", "BRL", "NL", "40", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("481", "BRL", "SE", "35", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("482", "BRL", "IE", "35", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("483", "BRL", "BE", "30", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("484", "BRL", "FI", "20", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("485", "BRL", "FR", "30", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("486", "BRL", "NZ", "30", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("487", "BRL", "HK", "25", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("488", "BRL", "CZ", "25", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("489", "BRL", "SK", "25", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("490", "BRL", "AE", "20", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("491", "BRL", "SG", "30", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("492", "BRL", "IL", "25", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("493", "BRL", "KW", "10", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("494", "BRL", "IT", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("495", "BRL", "JP", "20", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("496", "BRL", "ES", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("497", "BRL", "VE", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("498", "BRL", "HU", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("499", "BRL", "PT", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("500", "BRL", "GR", "20", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("501", "BRL", "KR", "20", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("502", "BRL", "TW", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("503", "BRL", "PL", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("504", "BRL", "ZM", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("505", "BRL", "PR", "5", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("506", "BRL", "CI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("507", "BRL", "RO", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("508", "BRL", "BH", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("509", "BRL", "PA", "5", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("510", "BRL", "GH", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("511", "BRL", "KH", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("512", "BRL", "SN", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("513", "BRL", "SA", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("514", "BRL", "RU", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("515", "BRL", "UG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("516", "BRL", "BR", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("517", "BRL", "NI", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("518", "BRL", "MG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("519", "BRL", "DO", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("520", "BRL", "MX", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("521", "BRL", "OM", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("522", "BRL", "CM", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("523", "BRL", "ZA", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("524", "BRL", "CL", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("525", "BRL", "KE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("526", "BRL", "NP", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("527", "BRL", "PE", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("528", "BRL", "UA", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("529", "BRL", "MZ", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("530", "BRL", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("531", "BRL", "AO", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("532", "BRL", "JO", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("533", "BRL", "ZW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("534", "BRL", "TR", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("535", "BRL", "MU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("536", "BRL", "SV", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("537", "BRL", "TH", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("538", "BRL", "CO", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("539", "BRL", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("540", "BRL", "CR", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("541", "BRL", "AR", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("542", "BRL", "MA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("543", "BRL", "MY", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("544", "BRL", "KZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("545", "BRL", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("546", "BRL", "ID", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("547", "BRL", "NG", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("548", "BRL", "GT", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("549", "BRL", "VN", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("550", "BRL", "BY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("551", "BRL", "EG", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("552", "BRL", "UY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("553", "BRL", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("554", "BRL", "PK", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("555", "BRL", "PH", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("556", "BRL", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("557", "BRL", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("558", "BRL", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("559", "BRL", "IN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("560", "BRL", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("561", "BRL", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("562", "BRL", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("563", "BRL", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("564", "BRL", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("565", "CAD", "US", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("566", "CAD", "CH", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("567", "CAD", "AU", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("568", "CAD", "GB", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("569", "CAD", "DE", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("570", "CAD", "DK", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("571", "CAD", "AT", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("572", "CAD", "NO", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("573", "CAD", "CA", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("574", "CAD", "NL", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("575", "CAD", "SE", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("576", "CAD", "IE", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("577", "CAD", "BE", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("578", "CAD", "FI", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("579", "CAD", "FR", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("580", "CAD", "NZ", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("581", "CAD", "HK", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("582", "CAD", "CZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("583", "CAD", "SK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("584", "CAD", "AE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("585", "CAD", "SG", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("586", "CAD", "IL", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("587", "CAD", "KW", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("588", "CAD", "IT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("589", "CAD", "JP", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("590", "CAD", "ES", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("591", "CAD", "VE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("592", "CAD", "HU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("593", "CAD", "PT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("594", "CAD", "GR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("595", "CAD", "KR", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("596", "CAD", "TW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("597", "CAD", "PL", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("598", "CAD", "ZM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("599", "CAD", "PR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("600", "CAD", "CI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("601", "CAD", "RO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("602", "CAD", "BH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("603", "CAD", "PA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("604", "CAD", "GH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("605", "CAD", "KH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("606", "CAD", "SN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("607", "CAD", "SA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("608", "CAD", "RU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("609", "CAD", "UG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("610", "CAD", "BR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("611", "CAD", "NI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("612", "CAD", "MG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("613", "CAD", "DO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("614", "CAD", "MX", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("615", "CAD", "OM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("616", "CAD", "CM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("617", "CAD", "ZA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("618", "CAD", "CL", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("619", "CAD", "KE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("620", "CAD", "NP", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("621", "CAD", "PE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("622", "CAD", "UA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("623", "CAD", "MZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("624", "CAD", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("625", "CAD", "AO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("626", "CAD", "JO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("627", "CAD", "ZW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("628", "CAD", "TR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("629", "CAD", "MU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("630", "CAD", "SV", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("631", "CAD", "TH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("632", "CAD", "CO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("633", "CAD", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("634", "CAD", "CR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("635", "CAD", "AR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("636", "CAD", "MA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("637", "CAD", "MY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("638", "CAD", "KZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("639", "CAD", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("640", "CAD", "ID", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("641", "CAD", "NG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("642", "CAD", "GT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("643", "CAD", "VN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("644", "CAD", "BY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("645", "CAD", "EG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("646", "CAD", "UY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("647", "CAD", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("648", "CAD", "PK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("649", "CAD", "PH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("650", "CAD", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("651", "CAD", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("652", "CAD", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("653", "CAD", "IN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("654", "CAD", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("655", "CAD", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("656", "CAD", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("657", "CAD", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("658", "CAD", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("659", "CHF", "US", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("660", "CHF", "CH", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("661", "CHF", "AU", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("662", "CHF", "GB", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("663", "CHF", "DE", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("664", "CHF", "DK", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("665", "CHF", "AT", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("666", "CHF", "NO", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("667", "CHF", "CA", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("668", "CHF", "NL", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("669", "CHF", "SE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("670", "CHF", "IE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("671", "CHF", "BE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("672", "CHF", "FI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("673", "CHF", "FR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("674", "CHF", "NZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("675", "CHF", "HK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("676", "CHF", "CZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("677", "CHF", "SK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("678", "CHF", "AE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("679", "CHF", "SG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("680", "CHF", "IL", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("681", "CHF", "KW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("682", "CHF", "IT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("683", "CHF", "JP", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("684", "CHF", "ES", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("685", "CHF", "VE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("686", "CHF", "HU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("687", "CHF", "PT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("688", "CHF", "GR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("689", "CHF", "KR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("690", "CHF", "TW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("691", "CHF", "PL", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("692", "CHF", "ZM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("693", "CHF", "PR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("694", "CHF", "CI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("695", "CHF", "RO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("696", "CHF", "BH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("697", "CHF", "PA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("698", "CHF", "GH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("699", "CHF", "KH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("700", "CHF", "SN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("701", "CHF", "SA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("702", "CHF", "RU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("703", "CHF", "UG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("704", "CHF", "BR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("705", "CHF", "NI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("706", "CHF", "MG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("707", "CHF", "DO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("708", "CHF", "MX", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("709", "CHF", "OM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("710", "CHF", "CM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("711", "CHF", "ZA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("712", "CHF", "CL", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("713", "CHF", "KE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("714", "CHF", "NP", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("715", "CHF", "PE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("716", "CHF", "UA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("717", "CHF", "MZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("718", "CHF", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("719", "CHF", "AO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("720", "CHF", "JO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("721", "CHF", "ZW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("722", "CHF", "TR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("723", "CHF", "MU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("724", "CHF", "SV", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("725", "CHF", "TH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("726", "CHF", "CO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("727", "CHF", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("728", "CHF", "CR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("729", "CHF", "AR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("730", "CHF", "MA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("731", "CHF", "MY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("732", "CHF", "KZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("733", "CHF", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("734", "CHF", "ID", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("735", "CHF", "NG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("736", "CHF", "GT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("737", "CHF", "VN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("738", "CHF", "BY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("739", "CHF", "EG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("740", "CHF", "UY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("741", "CHF", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("742", "CHF", "PK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("743", "CHF", "PH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("744", "CHF", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("745", "CHF", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("746", "CHF", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("747", "CHF", "IN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("748", "CHF", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("749", "CHF", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("750", "CHF", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("751", "CHF", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("752", "CHF", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("753", "CLP", "US", "8700", "24555");
INSERT INTO `wp_gla_budget_recommendations` VALUES("754", "CLP", "CH", "8115", "21355");
INSERT INTO `wp_gla_budget_recommendations` VALUES("755", "CLP", "AU", "7385", "18960");
INSERT INTO `wp_gla_budget_recommendations` VALUES("756", "CLP", "GB", "6440", "16475");
INSERT INTO `wp_gla_budget_recommendations` VALUES("757", "CLP", "DE", "6390", "16340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("758", "CLP", "DK", "5880", "14590");
INSERT INTO `wp_gla_budget_recommendations` VALUES("759", "CLP", "AT", "4290", "13330");
INSERT INTO `wp_gla_budget_recommendations` VALUES("760", "CLP", "NO", "4860", "13575");
INSERT INTO `wp_gla_budget_recommendations` VALUES("761", "CLP", "CA", "5375", "16480");
INSERT INTO `wp_gla_budget_recommendations` VALUES("762", "CLP", "NL", "5750", "14595");
INSERT INTO `wp_gla_budget_recommendations` VALUES("763", "CLP", "SE", "4605", "12445");
INSERT INTO `wp_gla_budget_recommendations` VALUES("764", "CLP", "IE", "4555", "12005");
INSERT INTO `wp_gla_budget_recommendations` VALUES("765", "CLP", "BE", "4190", "12275");
INSERT INTO `wp_gla_budget_recommendations` VALUES("766", "CLP", "FI", "3130", "9510");
INSERT INTO `wp_gla_budget_recommendations` VALUES("767", "CLP", "FR", "3875", "10380");
INSERT INTO `wp_gla_budget_recommendations` VALUES("768", "CLP", "NZ", "3945", "11615");
INSERT INTO `wp_gla_budget_recommendations` VALUES("769", "CLP", "HK", "3590", "10150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("770", "CLP", "CZ", "3420", "8215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("771", "CLP", "SK", "3230", "6995");
INSERT INTO `wp_gla_budget_recommendations` VALUES("772", "CLP", "AE", "3045", "9560");
INSERT INTO `wp_gla_budget_recommendations` VALUES("773", "CLP", "SG", "3975", "11745");
INSERT INTO `wp_gla_budget_recommendations` VALUES("774", "CLP", "IL", "3470", "8485");
INSERT INTO `wp_gla_budget_recommendations` VALUES("775", "CLP", "KW", "1565", "7625");
INSERT INTO `wp_gla_budget_recommendations` VALUES("776", "CLP", "IT", "2360", "6235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("777", "CLP", "JP", "2960", "8415");
INSERT INTO `wp_gla_budget_recommendations` VALUES("778", "CLP", "ES", "2425", "6420");
INSERT INTO `wp_gla_budget_recommendations` VALUES("779", "CLP", "VE", "320", "4915");
INSERT INTO `wp_gla_budget_recommendations` VALUES("780", "CLP", "HU", "2045", "4760");
INSERT INTO `wp_gla_budget_recommendations` VALUES("781", "CLP", "PT", "2040", "5320");
INSERT INTO `wp_gla_budget_recommendations` VALUES("782", "CLP", "GR", "2515", "5155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("783", "CLP", "KR", "3105", "8220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("784", "CLP", "TW", "2525", "6755");
INSERT INTO `wp_gla_budget_recommendations` VALUES("785", "CLP", "PL", "2160", "5345");
INSERT INTO `wp_gla_budget_recommendations` VALUES("786", "CLP", "ZM", "310", "1780");
INSERT INTO `wp_gla_budget_recommendations` VALUES("787", "CLP", "PR", "760", "7165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("788", "CLP", "CI", "415", "1720");
INSERT INTO `wp_gla_budget_recommendations` VALUES("789", "CLP", "RO", "1985", "4795");
INSERT INTO `wp_gla_budget_recommendations` VALUES("790", "CLP", "BH", "900", "4990");
INSERT INTO `wp_gla_budget_recommendations` VALUES("791", "CLP", "PA", "605", "6850");
INSERT INTO `wp_gla_budget_recommendations` VALUES("792", "CLP", "GH", "725", "2015");
INSERT INTO `wp_gla_budget_recommendations` VALUES("793", "CLP", "KH", "415", "2000");
INSERT INTO `wp_gla_budget_recommendations` VALUES("794", "CLP", "SN", "305", "2175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("795", "CLP", "SA", "1295", "4955");
INSERT INTO `wp_gla_budget_recommendations` VALUES("796", "CLP", "RU", "1285", "4105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("797", "CLP", "UG", "300", "1590");
INSERT INTO `wp_gla_budget_recommendations` VALUES("798", "CLP", "BR", "1370", "3380");
INSERT INTO `wp_gla_budget_recommendations` VALUES("799", "CLP", "NI", "300", "2165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("800", "CLP", "MG", "305", "1535");
INSERT INTO `wp_gla_budget_recommendations` VALUES("801", "CLP", "DO", "365", "2545");
INSERT INTO `wp_gla_budget_recommendations` VALUES("802", "CLP", "MX", "1035", "3740");
INSERT INTO `wp_gla_budget_recommendations` VALUES("803", "CLP", "OM", "650", "3740");
INSERT INTO `wp_gla_budget_recommendations` VALUES("804", "CLP", "CM", "300", "2790");
INSERT INTO `wp_gla_budget_recommendations` VALUES("805", "CLP", "ZA", "1230", "3965");
INSERT INTO `wp_gla_budget_recommendations` VALUES("806", "CLP", "CL", "1285", "3835");
INSERT INTO `wp_gla_budget_recommendations` VALUES("807", "CLP", "KE", "370", "1600");
INSERT INTO `wp_gla_budget_recommendations` VALUES("808", "CLP", "NP", "300", "1455");
INSERT INTO `wp_gla_budget_recommendations` VALUES("809", "CLP", "PE", "765", "3225");
INSERT INTO `wp_gla_budget_recommendations` VALUES("810", "CLP", "UA", "730", "2285");
INSERT INTO `wp_gla_budget_recommendations` VALUES("811", "CLP", "MZ", "300", "3030");
INSERT INTO `wp_gla_budget_recommendations` VALUES("812", "CLP", "TZ", "40", "695");
INSERT INTO `wp_gla_budget_recommendations` VALUES("813", "CLP", "AO", "670", "1740");
INSERT INTO `wp_gla_budget_recommendations` VALUES("814", "CLP", "JO", "490", "2340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("815", "CLP", "ZW", "305", "1660");
INSERT INTO `wp_gla_budget_recommendations` VALUES("816", "CLP", "TR", "785", "2145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("817", "CLP", "MU", "400", "1375");
INSERT INTO `wp_gla_budget_recommendations` VALUES("818", "CLP", "SV", "300", "1665");
INSERT INTO `wp_gla_budget_recommendations` VALUES("819", "CLP", "TH", "1175", "3705");
INSERT INTO `wp_gla_budget_recommendations` VALUES("820", "CLP", "CO", "595", "2310");
INSERT INTO `wp_gla_budget_recommendations` VALUES("821", "CLP", "LK", "290", "400");
INSERT INTO `wp_gla_budget_recommendations` VALUES("822", "CLP", "CR", "365", "2415");
INSERT INTO `wp_gla_budget_recommendations` VALUES("823", "CLP", "AR", "815", "2200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("824", "CLP", "MA", "365", "1425");
INSERT INTO `wp_gla_budget_recommendations` VALUES("825", "CLP", "MY", "1030", "3785");
INSERT INTO `wp_gla_budget_recommendations` VALUES("826", "CLP", "KZ", "440", "1610");
INSERT INTO `wp_gla_budget_recommendations` VALUES("827", "CLP", "DZ", "360", "765");
INSERT INTO `wp_gla_budget_recommendations` VALUES("828", "CLP", "ID", "920", "3410");
INSERT INTO `wp_gla_budget_recommendations` VALUES("829", "CLP", "NG", "515", "3265");
INSERT INTO `wp_gla_budget_recommendations` VALUES("830", "CLP", "GT", "360", "2560");
INSERT INTO `wp_gla_budget_recommendations` VALUES("831", "CLP", "VN", "750", "2850");
INSERT INTO `wp_gla_budget_recommendations` VALUES("832", "CLP", "BY", "355", "1375");
INSERT INTO `wp_gla_budget_recommendations` VALUES("833", "CLP", "EG", "475", "2910");
INSERT INTO `wp_gla_budget_recommendations` VALUES("834", "CLP", "UY", "375", "1730");
INSERT INTO `wp_gla_budget_recommendations` VALUES("835", "CLP", "BD", "310", "685");
INSERT INTO `wp_gla_budget_recommendations` VALUES("836", "CLP", "PK", "340", "1950");
INSERT INTO `wp_gla_budget_recommendations` VALUES("837", "CLP", "PH", "585", "2165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("838", "CLP", "ET", "95", "715");
INSERT INTO `wp_gla_budget_recommendations` VALUES("839", "CLP", "TN", "360", "655");
INSERT INTO `wp_gla_budget_recommendations` VALUES("840", "CLP", "LB", "365", "1090");
INSERT INTO `wp_gla_budget_recommendations` VALUES("841", "CLP", "IN", "335", "1520");
INSERT INTO `wp_gla_budget_recommendations` VALUES("842", "CLP", "PY", "360", "1165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("843", "CLP", "UZ", "360", "705");
INSERT INTO `wp_gla_budget_recommendations` VALUES("844", "CLP", "EC", "350", "1205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("845", "CLP", "MM", "360", "395");
INSERT INTO `wp_gla_budget_recommendations` VALUES("846", "CLP", "GE", "365", "465");
INSERT INTO `wp_gla_budget_recommendations` VALUES("847", "CNY", "US", "75", "215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("848", "CNY", "CH", "70", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("849", "CNY", "AU", "65", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("850", "CNY", "GB", "55", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("851", "CNY", "DE", "55", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("852", "CNY", "DK", "50", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("853", "CNY", "AT", "40", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("854", "CNY", "NO", "45", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("855", "CNY", "CA", "45", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("856", "CNY", "NL", "50", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("857", "CNY", "SE", "40", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("858", "CNY", "IE", "40", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("859", "CNY", "BE", "35", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("860", "CNY", "FI", "25", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("861", "CNY", "FR", "35", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("862", "CNY", "NZ", "35", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("863", "CNY", "HK", "30", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("864", "CNY", "CZ", "30", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("865", "CNY", "SK", "30", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("866", "CNY", "AE", "25", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("867", "CNY", "SG", "35", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("868", "CNY", "IL", "30", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("869", "CNY", "KW", "15", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("870", "CNY", "IT", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("871", "CNY", "JP", "25", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("872", "CNY", "ES", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("873", "CNY", "VE", "5", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("874", "CNY", "HU", "20", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("875", "CNY", "PT", "20", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("876", "CNY", "GR", "20", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("877", "CNY", "KR", "25", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("878", "CNY", "TW", "20", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("879", "CNY", "PL", "20", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("880", "CNY", "ZM", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("881", "CNY", "PR", "5", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("882", "CNY", "CI", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("883", "CNY", "RO", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("884", "CNY", "BH", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("885", "CNY", "PA", "5", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("886", "CNY", "GH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("887", "CNY", "KH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("888", "CNY", "SN", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("889", "CNY", "SA", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("890", "CNY", "RU", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("891", "CNY", "UG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("892", "CNY", "BR", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("893", "CNY", "NI", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("894", "CNY", "MG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("895", "CNY", "DO", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("896", "CNY", "MX", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("897", "CNY", "OM", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("898", "CNY", "CM", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("899", "CNY", "ZA", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("900", "CNY", "CL", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("901", "CNY", "KE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("902", "CNY", "NP", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("903", "CNY", "PE", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("904", "CNY", "UA", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("905", "CNY", "MZ", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("906", "CNY", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("907", "CNY", "AO", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("908", "CNY", "JO", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("909", "CNY", "ZW", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("910", "CNY", "TR", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("911", "CNY", "MU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("912", "CNY", "SV", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("913", "CNY", "TH", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("914", "CNY", "CO", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("915", "CNY", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("916", "CNY", "CR", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("917", "CNY", "AR", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("918", "CNY", "MA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("919", "CNY", "MY", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("920", "CNY", "KZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("921", "CNY", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("922", "CNY", "ID", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("923", "CNY", "NG", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("924", "CNY", "GT", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("925", "CNY", "VN", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("926", "CNY", "BY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("927", "CNY", "EG", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("928", "CNY", "UY", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("929", "CNY", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("930", "CNY", "PK", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("931", "CNY", "PH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("932", "CNY", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("933", "CNY", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("934", "CNY", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("935", "CNY", "IN", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("936", "CNY", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("937", "CNY", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("938", "CNY", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("939", "CNY", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("940", "CNY", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("941", "COP", "US", "41010", "115710");
INSERT INTO `wp_gla_budget_recommendations` VALUES("942", "COP", "CH", "38240", "100635");
INSERT INTO `wp_gla_budget_recommendations` VALUES("943", "COP", "AU", "34795", "89340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("944", "COP", "GB", "30340", "77640");
INSERT INTO `wp_gla_budget_recommendations` VALUES("945", "COP", "DE", "30105", "77010");
INSERT INTO `wp_gla_budget_recommendations` VALUES("946", "COP", "DK", "27700", "68745");
INSERT INTO `wp_gla_budget_recommendations` VALUES("947", "COP", "AT", "20215", "62815");
INSERT INTO `wp_gla_budget_recommendations` VALUES("948", "COP", "NO", "22910", "63965");
INSERT INTO `wp_gla_budget_recommendations` VALUES("949", "COP", "CA", "25325", "77660");
INSERT INTO `wp_gla_budget_recommendations` VALUES("950", "COP", "NL", "27095", "68775");
INSERT INTO `wp_gla_budget_recommendations` VALUES("951", "COP", "SE", "21690", "58650");
INSERT INTO `wp_gla_budget_recommendations` VALUES("952", "COP", "IE", "21465", "56575");
INSERT INTO `wp_gla_budget_recommendations` VALUES("953", "COP", "BE", "19735", "57845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("954", "COP", "FI", "14755", "44810");
INSERT INTO `wp_gla_budget_recommendations` VALUES("955", "COP", "FR", "18270", "48905");
INSERT INTO `wp_gla_budget_recommendations` VALUES("956", "COP", "NZ", "18595", "54740");
INSERT INTO `wp_gla_budget_recommendations` VALUES("957", "COP", "HK", "16910", "47820");
INSERT INTO `wp_gla_budget_recommendations` VALUES("958", "COP", "CZ", "16120", "38705");
INSERT INTO `wp_gla_budget_recommendations` VALUES("959", "COP", "SK", "15210", "32965");
INSERT INTO `wp_gla_budget_recommendations` VALUES("960", "COP", "AE", "14355", "45045");
INSERT INTO `wp_gla_budget_recommendations` VALUES("961", "COP", "SG", "18730", "55350");
INSERT INTO `wp_gla_budget_recommendations` VALUES("962", "COP", "IL", "16345", "39980");
INSERT INTO `wp_gla_budget_recommendations` VALUES("963", "COP", "KW", "7370", "35935");
INSERT INTO `wp_gla_budget_recommendations` VALUES("964", "COP", "IT", "11125", "29370");
INSERT INTO `wp_gla_budget_recommendations` VALUES("965", "COP", "JP", "13950", "39645");
INSERT INTO `wp_gla_budget_recommendations` VALUES("966", "COP", "ES", "11435", "30245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("967", "COP", "VE", "1500", "23165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("968", "COP", "HU", "9635", "22420");
INSERT INTO `wp_gla_budget_recommendations` VALUES("969", "COP", "PT", "9620", "25080");
INSERT INTO `wp_gla_budget_recommendations` VALUES("970", "COP", "GR", "11860", "24295");
INSERT INTO `wp_gla_budget_recommendations` VALUES("971", "COP", "KR", "14625", "38730");
INSERT INTO `wp_gla_budget_recommendations` VALUES("972", "COP", "TW", "11885", "31820");
INSERT INTO `wp_gla_budget_recommendations` VALUES("973", "COP", "PL", "10170", "25175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("974", "COP", "ZM", "1470", "8380");
INSERT INTO `wp_gla_budget_recommendations` VALUES("975", "COP", "PR", "3595", "33775");
INSERT INTO `wp_gla_budget_recommendations` VALUES("976", "COP", "CI", "1960", "8100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("977", "COP", "RO", "9345", "22605");
INSERT INTO `wp_gla_budget_recommendations` VALUES("978", "COP", "BH", "4245", "23520");
INSERT INTO `wp_gla_budget_recommendations` VALUES("979", "COP", "PA", "2840", "32285");
INSERT INTO `wp_gla_budget_recommendations` VALUES("980", "COP", "GH", "3405", "9505");
INSERT INTO `wp_gla_budget_recommendations` VALUES("981", "COP", "KH", "1965", "9430");
INSERT INTO `wp_gla_budget_recommendations` VALUES("982", "COP", "SN", "1430", "10245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("983", "COP", "SA", "6100", "23350");
INSERT INTO `wp_gla_budget_recommendations` VALUES("984", "COP", "RU", "6060", "19340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("985", "COP", "UG", "1425", "7485");
INSERT INTO `wp_gla_budget_recommendations` VALUES("986", "COP", "BR", "6460", "15930");
INSERT INTO `wp_gla_budget_recommendations` VALUES("987", "COP", "NI", "1420", "10200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("988", "COP", "MG", "1440", "7230");
INSERT INTO `wp_gla_budget_recommendations` VALUES("989", "COP", "DO", "1725", "11990");
INSERT INTO `wp_gla_budget_recommendations` VALUES("990", "COP", "MX", "4875", "17635");
INSERT INTO `wp_gla_budget_recommendations` VALUES("991", "COP", "OM", "3065", "17635");
INSERT INTO `wp_gla_budget_recommendations` VALUES("992", "COP", "CM", "1420", "13140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("993", "COP", "ZA", "5805", "18690");
INSERT INTO `wp_gla_budget_recommendations` VALUES("994", "COP", "CL", "6050", "18080");
INSERT INTO `wp_gla_budget_recommendations` VALUES("995", "COP", "KE", "1745", "7545");
INSERT INTO `wp_gla_budget_recommendations` VALUES("996", "COP", "NP", "1420", "6855");
INSERT INTO `wp_gla_budget_recommendations` VALUES("997", "COP", "PE", "3615", "15210");
INSERT INTO `wp_gla_budget_recommendations` VALUES("998", "COP", "UA", "3445", "10760");
INSERT INTO `wp_gla_budget_recommendations` VALUES("999", "COP", "MZ", "1420", "14270");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1000", "COP", "TZ", "180", "3275");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1001", "COP", "AO", "3145", "8205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1002", "COP", "JO", "2320", "11020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1003", "COP", "ZW", "1425", "7820");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1004", "COP", "TR", "3695", "10115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1005", "COP", "MU", "1895", "6470");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1006", "COP", "SV", "1420", "7835");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1007", "COP", "TH", "5545", "17450");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1008", "COP", "CO", "2810", "10885");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1009", "COP", "LK", "1365", "1885");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1010", "COP", "CR", "1715", "11390");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1011", "COP", "AR", "3830", "10375");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1012", "COP", "MA", "1710", "6715");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1013", "COP", "MY", "4855", "17845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1014", "COP", "KZ", "2075", "7595");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1015", "COP", "DZ", "1700", "3600");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1016", "COP", "ID", "4330", "16065");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1017", "COP", "NG", "2435", "15395");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1018", "COP", "GT", "1705", "12060");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1019", "COP", "VN", "3545", "13425");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1020", "COP", "BY", "1665", "6475");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1021", "COP", "EG", "2245", "13705");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1022", "COP", "UY", "1770", "8150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1023", "COP", "BD", "1455", "3225");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1024", "COP", "PK", "1595", "9190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1025", "COP", "PH", "2765", "10205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1026", "COP", "ET", "445", "3380");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1027", "COP", "TN", "1705", "3085");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1028", "COP", "LB", "1720", "5140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1029", "COP", "IN", "1585", "7160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1030", "COP", "PY", "1705", "5480");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1031", "COP", "UZ", "1705", "3325");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1032", "COP", "EC", "1655", "5685");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1033", "COP", "MM", "1705", "1865");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1034", "COP", "GE", "1710", "2180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1035", "CZK", "US", "255", "715");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1036", "CZK", "CH", "235", "625");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1037", "CZK", "AU", "215", "555");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1038", "CZK", "GB", "190", "480");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1039", "CZK", "DE", "185", "475");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1040", "CZK", "DK", "170", "425");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1041", "CZK", "AT", "125", "390");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1042", "CZK", "NO", "140", "395");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1043", "CZK", "CA", "155", "480");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1044", "CZK", "NL", "170", "425");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1045", "CZK", "SE", "135", "365");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1046", "CZK", "IE", "135", "350");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1047", "CZK", "BE", "120", "360");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1048", "CZK", "FI", "90", "275");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1049", "CZK", "FR", "115", "305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1050", "CZK", "NZ", "115", "340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1051", "CZK", "HK", "105", "295");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1052", "CZK", "CZ", "100", "240");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1053", "CZK", "SK", "95", "205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1054", "CZK", "AE", "90", "280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1055", "CZK", "SG", "115", "345");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1056", "CZK", "IL", "100", "245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1057", "CZK", "KW", "45", "220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1058", "CZK", "IT", "70", "180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1059", "CZK", "JP", "85", "245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1060", "CZK", "ES", "70", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1061", "CZK", "VE", "10", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1062", "CZK", "HU", "60", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1063", "CZK", "PT", "60", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1064", "CZK", "GR", "75", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1065", "CZK", "KR", "90", "240");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1066", "CZK", "TW", "75", "195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1067", "CZK", "PL", "65", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1068", "CZK", "ZM", "10", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1069", "CZK", "PR", "20", "210");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1070", "CZK", "CI", "10", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1071", "CZK", "RO", "60", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1072", "CZK", "BH", "25", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1073", "CZK", "PA", "20", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1074", "CZK", "GH", "20", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1075", "CZK", "KH", "10", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1076", "CZK", "SN", "10", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1077", "CZK", "SA", "40", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1078", "CZK", "RU", "40", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1079", "CZK", "UG", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1080", "CZK", "BR", "40", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1081", "CZK", "NI", "10", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1082", "CZK", "MG", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1083", "CZK", "DO", "10", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1084", "CZK", "MX", "30", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1085", "CZK", "OM", "20", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1086", "CZK", "CM", "10", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1087", "CZK", "ZA", "35", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1088", "CZK", "CL", "35", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1089", "CZK", "KE", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1090", "CZK", "NP", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1091", "CZK", "PE", "20", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1092", "CZK", "UA", "20", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1093", "CZK", "MZ", "10", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1094", "CZK", "TZ", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1095", "CZK", "AO", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1096", "CZK", "JO", "15", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1097", "CZK", "ZW", "10", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1098", "CZK", "TR", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1099", "CZK", "MU", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1100", "CZK", "SV", "10", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1101", "CZK", "TH", "35", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1102", "CZK", "CO", "15", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1103", "CZK", "LK", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1104", "CZK", "CR", "10", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1105", "CZK", "AR", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1106", "CZK", "MA", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1107", "CZK", "MY", "30", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1108", "CZK", "KZ", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1109", "CZK", "DZ", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1110", "CZK", "ID", "25", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1111", "CZK", "NG", "15", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1112", "CZK", "GT", "10", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1113", "CZK", "VN", "20", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1114", "CZK", "BY", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1115", "CZK", "EG", "15", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1116", "CZK", "UY", "10", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1117", "CZK", "BD", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1118", "CZK", "PK", "10", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1119", "CZK", "PH", "15", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1120", "CZK", "ET", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1121", "CZK", "TN", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1122", "CZK", "LB", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1123", "CZK", "IN", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1124", "CZK", "PY", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1125", "CZK", "UZ", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1126", "CZK", "EC", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1127", "CZK", "MM", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1128", "CZK", "GE", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1129", "DKK", "US", "70", "205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1130", "DKK", "CH", "65", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1131", "DKK", "AU", "60", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1132", "DKK", "GB", "55", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1133", "DKK", "DE", "55", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1134", "DKK", "DK", "50", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1135", "DKK", "AT", "35", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1136", "DKK", "NO", "40", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1137", "DKK", "CA", "45", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1138", "DKK", "NL", "50", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1139", "DKK", "SE", "40", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1140", "DKK", "IE", "40", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1141", "DKK", "BE", "35", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1142", "DKK", "FI", "25", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1143", "DKK", "FR", "30", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1144", "DKK", "NZ", "35", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1145", "DKK", "HK", "30", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1146", "DKK", "CZ", "30", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1147", "DKK", "SK", "25", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1148", "DKK", "AE", "25", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1149", "DKK", "SG", "35", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1150", "DKK", "IL", "30", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1151", "DKK", "KW", "15", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1152", "DKK", "IT", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1153", "DKK", "JP", "25", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1154", "DKK", "ES", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1155", "DKK", "VE", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1156", "DKK", "HU", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1157", "DKK", "PT", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1158", "DKK", "GR", "20", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1159", "DKK", "KR", "25", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1160", "DKK", "TW", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1161", "DKK", "PL", "20", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1162", "DKK", "ZM", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1163", "DKK", "PR", "5", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1164", "DKK", "CI", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1165", "DKK", "RO", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1166", "DKK", "BH", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1167", "DKK", "PA", "5", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1168", "DKK", "GH", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1169", "DKK", "KH", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1170", "DKK", "SN", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1171", "DKK", "SA", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1172", "DKK", "RU", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1173", "DKK", "UG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1174", "DKK", "BR", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1175", "DKK", "NI", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1176", "DKK", "MG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1177", "DKK", "DO", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1178", "DKK", "MX", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1179", "DKK", "OM", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1180", "DKK", "CM", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1181", "DKK", "ZA", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1182", "DKK", "CL", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1183", "DKK", "KE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1184", "DKK", "NP", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1185", "DKK", "PE", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1186", "DKK", "UA", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1187", "DKK", "MZ", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1188", "DKK", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1189", "DKK", "AO", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1190", "DKK", "JO", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1191", "DKK", "ZW", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1192", "DKK", "TR", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1193", "DKK", "MU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1194", "DKK", "SV", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1195", "DKK", "TH", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1196", "DKK", "CO", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1197", "DKK", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1198", "DKK", "CR", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1199", "DKK", "AR", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1200", "DKK", "MA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1201", "DKK", "MY", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1202", "DKK", "KZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1203", "DKK", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1204", "DKK", "ID", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1205", "DKK", "NG", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1206", "DKK", "GT", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1207", "DKK", "VN", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1208", "DKK", "BY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1209", "DKK", "EG", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1210", "DKK", "UY", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1211", "DKK", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1212", "DKK", "PK", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1213", "DKK", "PH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1214", "DKK", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1215", "DKK", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1216", "DKK", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1217", "DKK", "IN", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1218", "DKK", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1219", "DKK", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1220", "DKK", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1221", "DKK", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1222", "DKK", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1223", "EGP", "US", "185", "520");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1224", "EGP", "CH", "170", "455");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1225", "EGP", "AU", "155", "400");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1226", "EGP", "GB", "135", "350");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1227", "EGP", "DE", "135", "345");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1228", "EGP", "DK", "125", "310");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1229", "EGP", "AT", "90", "285");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1230", "EGP", "NO", "105", "290");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1231", "EGP", "CA", "115", "350");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1232", "EGP", "NL", "120", "310");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1233", "EGP", "SE", "100", "265");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1234", "EGP", "IE", "95", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1235", "EGP", "BE", "90", "260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1236", "EGP", "FI", "65", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1237", "EGP", "FR", "80", "220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1238", "EGP", "NZ", "85", "245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1239", "EGP", "HK", "75", "215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1240", "EGP", "CZ", "75", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1241", "EGP", "SK", "70", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1242", "EGP", "AE", "65", "205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1243", "EGP", "SG", "85", "250");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1244", "EGP", "IL", "75", "180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1245", "EGP", "KW", "35", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1246", "EGP", "IT", "50", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1247", "EGP", "JP", "65", "180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1248", "EGP", "ES", "50", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1249", "EGP", "VE", "5", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1250", "EGP", "HU", "45", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1251", "EGP", "PT", "45", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1252", "EGP", "GR", "55", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1253", "EGP", "KR", "65", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1254", "EGP", "TW", "55", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1255", "EGP", "PL", "45", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1256", "EGP", "ZM", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1257", "EGP", "PR", "15", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1258", "EGP", "CI", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1259", "EGP", "RO", "40", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1260", "EGP", "BH", "20", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1261", "EGP", "PA", "15", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1262", "EGP", "GH", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1263", "EGP", "KH", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1264", "EGP", "SN", "5", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1265", "EGP", "SA", "25", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1266", "EGP", "RU", "25", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1267", "EGP", "UG", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1268", "EGP", "BR", "30", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1269", "EGP", "NI", "5", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1270", "EGP", "MG", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1271", "EGP", "DO", "10", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1272", "EGP", "MX", "20", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1273", "EGP", "OM", "15", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1274", "EGP", "CM", "5", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1275", "EGP", "ZA", "25", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1276", "EGP", "CL", "25", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1277", "EGP", "KE", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1278", "EGP", "NP", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1279", "EGP", "PE", "15", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1280", "EGP", "UA", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1281", "EGP", "MZ", "5", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1282", "EGP", "TZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1283", "EGP", "AO", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1284", "EGP", "JO", "10", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1285", "EGP", "ZW", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1286", "EGP", "TR", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1287", "EGP", "MU", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1288", "EGP", "SV", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1289", "EGP", "TH", "25", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1290", "EGP", "CO", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1291", "EGP", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1292", "EGP", "CR", "10", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1293", "EGP", "AR", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1294", "EGP", "MA", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1295", "EGP", "MY", "20", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1296", "EGP", "KZ", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1297", "EGP", "DZ", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1298", "EGP", "ID", "20", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1299", "EGP", "NG", "10", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1300", "EGP", "GT", "10", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1301", "EGP", "VN", "15", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1302", "EGP", "BY", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1303", "EGP", "EG", "10", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1304", "EGP", "UY", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1305", "EGP", "BD", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1306", "EGP", "PK", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1307", "EGP", "PH", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1308", "EGP", "ET", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1309", "EGP", "TN", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1310", "EGP", "LB", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1311", "EGP", "IN", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1312", "EGP", "PY", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1313", "EGP", "UZ", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1314", "EGP", "EC", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1315", "EGP", "MM", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1316", "EGP", "GE", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1317", "EUR", "US", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1318", "EUR", "CH", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1319", "EUR", "AU", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1320", "EUR", "GB", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1321", "EUR", "DE", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1322", "EUR", "DK", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1323", "EUR", "AT", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1324", "EUR", "NO", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1325", "EUR", "CA", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1326", "EUR", "NL", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1327", "EUR", "SE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1328", "EUR", "IE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1329", "EUR", "BE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1330", "EUR", "FI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1331", "EUR", "FR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1332", "EUR", "NZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1333", "EUR", "HK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1334", "EUR", "CZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1335", "EUR", "SK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1336", "EUR", "AE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1337", "EUR", "SG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1338", "EUR", "IL", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1339", "EUR", "KW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1340", "EUR", "IT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1341", "EUR", "JP", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1342", "EUR", "ES", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1343", "EUR", "VE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1344", "EUR", "HU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1345", "EUR", "PT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1346", "EUR", "GR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1347", "EUR", "KR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1348", "EUR", "TW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1349", "EUR", "PL", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1350", "EUR", "ZM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1351", "EUR", "PR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1352", "EUR", "CI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1353", "EUR", "RO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1354", "EUR", "BH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1355", "EUR", "PA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1356", "EUR", "GH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1357", "EUR", "KH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1358", "EUR", "SN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1359", "EUR", "SA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1360", "EUR", "RU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1361", "EUR", "UG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1362", "EUR", "BR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1363", "EUR", "NI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1364", "EUR", "MG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1365", "EUR", "DO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1366", "EUR", "MX", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1367", "EUR", "OM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1368", "EUR", "CM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1369", "EUR", "ZA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1370", "EUR", "CL", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1371", "EUR", "KE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1372", "EUR", "NP", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1373", "EUR", "PE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1374", "EUR", "UA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1375", "EUR", "MZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1376", "EUR", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1377", "EUR", "AO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1378", "EUR", "JO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1379", "EUR", "ZW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1380", "EUR", "TR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1381", "EUR", "MU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1382", "EUR", "SV", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1383", "EUR", "TH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1384", "EUR", "CO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1385", "EUR", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1386", "EUR", "CR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1387", "EUR", "AR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1388", "EUR", "MA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1389", "EUR", "MY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1390", "EUR", "KZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1391", "EUR", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1392", "EUR", "ID", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1393", "EUR", "NG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1394", "EUR", "GT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1395", "EUR", "VN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1396", "EUR", "BY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1397", "EUR", "EG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1398", "EUR", "UY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1399", "EUR", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1400", "EUR", "PK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1401", "EUR", "PH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1402", "EUR", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1403", "EUR", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1404", "EUR", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1405", "EUR", "IN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1406", "EUR", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1407", "EUR", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1408", "EUR", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1409", "EUR", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1410", "EUR", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1411", "GBP", "US", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1412", "GBP", "CH", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1413", "GBP", "AU", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1414", "GBP", "GB", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1415", "GBP", "DE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1416", "GBP", "DK", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1417", "GBP", "AT", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1418", "GBP", "NO", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1419", "GBP", "CA", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1420", "GBP", "NL", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1421", "GBP", "SE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1422", "GBP", "IE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1423", "GBP", "BE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1424", "GBP", "FI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1425", "GBP", "FR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1426", "GBP", "NZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1427", "GBP", "HK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1428", "GBP", "CZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1429", "GBP", "SK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1430", "GBP", "AE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1431", "GBP", "SG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1432", "GBP", "IL", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1433", "GBP", "KW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1434", "GBP", "IT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1435", "GBP", "JP", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1436", "GBP", "ES", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1437", "GBP", "VE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1438", "GBP", "HU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1439", "GBP", "PT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1440", "GBP", "GR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1441", "GBP", "KR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1442", "GBP", "TW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1443", "GBP", "PL", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1444", "GBP", "ZM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1445", "GBP", "PR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1446", "GBP", "CI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1447", "GBP", "RO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1448", "GBP", "BH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1449", "GBP", "PA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1450", "GBP", "GH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1451", "GBP", "KH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1452", "GBP", "SN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1453", "GBP", "SA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1454", "GBP", "RU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1455", "GBP", "UG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1456", "GBP", "BR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1457", "GBP", "NI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1458", "GBP", "MG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1459", "GBP", "DO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1460", "GBP", "MX", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1461", "GBP", "OM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1462", "GBP", "CM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1463", "GBP", "ZA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1464", "GBP", "CL", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1465", "GBP", "KE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1466", "GBP", "NP", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1467", "GBP", "PE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1468", "GBP", "UA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1469", "GBP", "MZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1470", "GBP", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1471", "GBP", "AO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1472", "GBP", "JO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1473", "GBP", "ZW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1474", "GBP", "TR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1475", "GBP", "MU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1476", "GBP", "SV", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1477", "GBP", "TH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1478", "GBP", "CO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1479", "GBP", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1480", "GBP", "CR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1481", "GBP", "AR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1482", "GBP", "MA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1483", "GBP", "MY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1484", "GBP", "KZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1485", "GBP", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1486", "GBP", "ID", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1487", "GBP", "NG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1488", "GBP", "GT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1489", "GBP", "VN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1490", "GBP", "BY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1491", "GBP", "EG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1492", "GBP", "UY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1493", "GBP", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1494", "GBP", "PK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1495", "GBP", "PH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1496", "GBP", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1497", "GBP", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1498", "GBP", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1499", "GBP", "IN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1500", "GBP", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1501", "GBP", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1502", "GBP", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1503", "GBP", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1504", "GBP", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1505", "HKD", "US", "90", "260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1506", "HKD", "CH", "85", "225");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1507", "HKD", "AU", "80", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1508", "HKD", "GB", "70", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1509", "HKD", "DE", "65", "170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1510", "HKD", "DK", "60", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1511", "HKD", "AT", "45", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1512", "HKD", "NO", "50", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1513", "HKD", "CA", "55", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1514", "HKD", "NL", "60", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1515", "HKD", "SE", "50", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1516", "HKD", "IE", "50", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1517", "HKD", "BE", "45", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1518", "HKD", "FI", "35", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1519", "HKD", "FR", "40", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1520", "HKD", "NZ", "40", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1521", "HKD", "HK", "40", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1522", "HKD", "CZ", "35", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1523", "HKD", "SK", "35", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1524", "HKD", "AE", "30", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1525", "HKD", "SG", "40", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1526", "HKD", "IL", "35", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1527", "HKD", "KW", "15", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1528", "HKD", "IT", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1529", "HKD", "JP", "30", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1530", "HKD", "ES", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1531", "HKD", "VE", "5", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1532", "HKD", "HU", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1533", "HKD", "PT", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1534", "HKD", "GR", "25", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1535", "HKD", "KR", "35", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1536", "HKD", "TW", "25", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1537", "HKD", "PL", "25", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1538", "HKD", "ZM", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1539", "HKD", "PR", "10", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1540", "HKD", "CI", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1541", "HKD", "RO", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1542", "HKD", "BH", "10", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1543", "HKD", "PA", "5", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1544", "HKD", "GH", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1545", "HKD", "KH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1546", "HKD", "SN", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1547", "HKD", "SA", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1548", "HKD", "RU", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1549", "HKD", "UG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1550", "HKD", "BR", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1551", "HKD", "NI", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1552", "HKD", "MG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1553", "HKD", "DO", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1554", "HKD", "MX", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1555", "HKD", "OM", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1556", "HKD", "CM", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1557", "HKD", "ZA", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1558", "HKD", "CL", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1559", "HKD", "KE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1560", "HKD", "NP", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1561", "HKD", "PE", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1562", "HKD", "UA", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1563", "HKD", "MZ", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1564", "HKD", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1565", "HKD", "AO", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1566", "HKD", "JO", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1567", "HKD", "ZW", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1568", "HKD", "TR", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1569", "HKD", "MU", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1570", "HKD", "SV", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1571", "HKD", "TH", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1572", "HKD", "CO", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1573", "HKD", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1574", "HKD", "CR", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1575", "HKD", "AR", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1576", "HKD", "MA", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1577", "HKD", "MY", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1578", "HKD", "KZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1579", "HKD", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1580", "HKD", "ID", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1581", "HKD", "NG", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1582", "HKD", "GT", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1583", "HKD", "VN", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1584", "HKD", "BY", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1585", "HKD", "EG", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1586", "HKD", "UY", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1587", "HKD", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1588", "HKD", "PK", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1589", "HKD", "PH", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1590", "HKD", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1591", "HKD", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1592", "HKD", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1593", "HKD", "IN", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1594", "HKD", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1595", "HKD", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1596", "HKD", "EC", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1597", "HKD", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1598", "HKD", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1599", "HUF", "US", "3500", "9870");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1600", "HUF", "CH", "3260", "8585");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1601", "HUF", "AU", "2970", "7620");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1602", "HUF", "GB", "2590", "6625");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1603", "HUF", "DE", "2570", "6570");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1604", "HUF", "DK", "2365", "5865");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1605", "HUF", "AT", "1725", "5360");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1606", "HUF", "NO", "1955", "5455");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1607", "HUF", "CA", "2160", "6625");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1608", "HUF", "NL", "2310", "5865");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1609", "HUF", "SE", "1850", "5005");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1610", "HUF", "IE", "1830", "4825");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1611", "HUF", "BE", "1685", "4935");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1612", "HUF", "FI", "1260", "3825");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1613", "HUF", "FR", "1560", "4170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1614", "HUF", "NZ", "1585", "4670");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1615", "HUF", "HK", "1445", "4080");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1616", "HUF", "CZ", "1375", "3300");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1617", "HUF", "SK", "1295", "2810");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1618", "HUF", "AE", "1225", "3845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1619", "HUF", "SG", "1600", "4720");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1620", "HUF", "IL", "1395", "3410");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1621", "HUF", "KW", "630", "3065");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1622", "HUF", "IT", "950", "2505");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1623", "HUF", "JP", "1190", "3380");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1624", "HUF", "ES", "975", "2580");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1625", "HUF", "VE", "130", "1975");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1626", "HUF", "HU", "820", "1915");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1627", "HUF", "PT", "820", "2140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1628", "HUF", "GR", "1010", "2070");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1629", "HUF", "KR", "1250", "3305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1630", "HUF", "TW", "1015", "2715");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1631", "HUF", "PL", "870", "2150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1632", "HUF", "ZM", "125", "715");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1633", "HUF", "PR", "305", "2880");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1634", "HUF", "CI", "165", "690");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1635", "HUF", "RO", "795", "1930");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1636", "HUF", "BH", "360", "2005");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1637", "HUF", "PA", "240", "2755");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1638", "HUF", "GH", "290", "810");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1639", "HUF", "KH", "165", "805");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1640", "HUF", "SN", "120", "875");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1641", "HUF", "SA", "520", "1990");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1642", "HUF", "RU", "515", "1650");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1643", "HUF", "UG", "120", "640");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1644", "HUF", "BR", "550", "1360");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1645", "HUF", "NI", "120", "870");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1646", "HUF", "MG", "125", "615");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1647", "HUF", "DO", "145", "1025");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1648", "HUF", "MX", "415", "1505");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1649", "HUF", "OM", "260", "1505");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1650", "HUF", "CM", "120", "1120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1651", "HUF", "ZA", "495", "1595");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1652", "HUF", "CL", "515", "1540");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1653", "HUF", "KE", "150", "645");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1654", "HUF", "NP", "120", "585");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1655", "HUF", "PE", "310", "1295");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1656", "HUF", "UA", "295", "920");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1657", "HUF", "MZ", "120", "1215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1658", "HUF", "TZ", "15", "280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1659", "HUF", "AO", "270", "700");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1660", "HUF", "JO", "200", "940");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1661", "HUF", "ZW", "120", "665");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1662", "HUF", "TR", "315", "865");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1663", "HUF", "MU", "160", "550");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1664", "HUF", "SV", "120", "670");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1665", "HUF", "TH", "475", "1490");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1666", "HUF", "CO", "240", "930");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1667", "HUF", "LK", "115", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1668", "HUF", "CR", "145", "970");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1669", "HUF", "AR", "325", "885");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1670", "HUF", "MA", "145", "575");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1671", "HUF", "MY", "415", "1520");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1672", "HUF", "KZ", "175", "650");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1673", "HUF", "DZ", "145", "305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1674", "HUF", "ID", "370", "1370");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1675", "HUF", "NG", "210", "1315");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1676", "HUF", "GT", "145", "1030");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1677", "HUF", "VN", "300", "1145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1678", "HUF", "BY", "140", "550");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1679", "HUF", "EG", "190", "1170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1680", "HUF", "UY", "150", "695");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1681", "HUF", "BD", "125", "275");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1682", "HUF", "PK", "135", "785");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1683", "HUF", "PH", "235", "870");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1684", "HUF", "ET", "40", "290");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1685", "HUF", "TN", "145", "265");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1686", "HUF", "LB", "145", "440");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1687", "HUF", "IN", "135", "610");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1688", "HUF", "PY", "145", "465");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1689", "HUF", "UZ", "145", "285");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1690", "HUF", "EC", "140", "485");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1691", "HUF", "MM", "145", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1692", "HUF", "GE", "145", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1693", "IDR", "US", "166005", "468405");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1694", "IDR", "CH", "154810", "407370");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1695", "IDR", "AU", "140860", "361660");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1696", "IDR", "GB", "122810", "314285");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1697", "IDR", "DE", "121875", "311745");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1698", "IDR", "DK", "112135", "278285");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1699", "IDR", "AT", "81825", "254270");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1700", "IDR", "NO", "92740", "258940");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1701", "IDR", "CA", "102520", "314385");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1702", "IDR", "NL", "109690", "278400");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1703", "IDR", "SE", "87800", "237425");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1704", "IDR", "IE", "86880", "229025");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1705", "IDR", "BE", "79895", "234155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1706", "IDR", "FI", "59730", "181395");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1707", "IDR", "FR", "73960", "197970");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1708", "IDR", "NZ", "75275", "221595");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1709", "IDR", "HK", "68450", "193585");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1710", "IDR", "CZ", "65260", "156680");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1711", "IDR", "SK", "61570", "133435");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1712", "IDR", "AE", "58105", "182350");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1713", "IDR", "SG", "75815", "224065");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1714", "IDR", "IL", "66160", "161835");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1715", "IDR", "KW", "29840", "145460");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1716", "IDR", "IT", "45035", "118890");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1717", "IDR", "JP", "56465", "160485");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1718", "IDR", "ES", "46295", "122430");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1719", "IDR", "VE", "6070", "93775");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1720", "IDR", "HU", "39010", "90770");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1721", "IDR", "PT", "38945", "101515");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1722", "IDR", "GR", "48020", "98345");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1723", "IDR", "KR", "59205", "156780");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1724", "IDR", "TW", "48120", "128815");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1725", "IDR", "PL", "41175", "101920");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1726", "IDR", "ZM", "5945", "33930");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1727", "IDR", "PR", "14545", "136720");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1728", "IDR", "CI", "7935", "32800");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1729", "IDR", "RO", "37820", "91515");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1730", "IDR", "BH", "17175", "95210");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1731", "IDR", "PA", "11505", "130685");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1732", "IDR", "GH", "13790", "38475");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1733", "IDR", "KH", "7950", "38170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1734", "IDR", "SN", "5785", "41470");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1735", "IDR", "SA", "24685", "94520");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1736", "IDR", "RU", "24535", "78285");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1737", "IDR", "UG", "5765", "30305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1738", "IDR", "BR", "26155", "64490");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1739", "IDR", "NI", "5755", "41295");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1740", "IDR", "MG", "5820", "29275");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1741", "IDR", "DO", "6980", "48535");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1742", "IDR", "MX", "19725", "71380");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1743", "IDR", "OM", "12400", "71385");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1744", "IDR", "CM", "5745", "53195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1745", "IDR", "ZA", "23505", "75650");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1746", "IDR", "CL", "24490", "73180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1747", "IDR", "KE", "7070", "30545");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1748", "IDR", "NP", "5745", "27745");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1749", "IDR", "PE", "14625", "61565");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1750", "IDR", "UA", "13945", "43550");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1751", "IDR", "MZ", "5745", "57770");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1752", "IDR", "TZ", "725", "13255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1753", "IDR", "AO", "12740", "33215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1754", "IDR", "JO", "9395", "44610");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1755", "IDR", "ZW", "5775", "31660");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1756", "IDR", "TR", "14965", "40940");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1757", "IDR", "MU", "7665", "26185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1758", "IDR", "SV", "5745", "31720");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1759", "IDR", "TH", "22445", "70630");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1760", "IDR", "CO", "11385", "44060");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1761", "IDR", "LK", "5530", "7635");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1762", "IDR", "CR", "6940", "46100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1763", "IDR", "AR", "15500", "41990");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1764", "IDR", "MA", "6925", "27175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1765", "IDR", "MY", "19645", "72245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1766", "IDR", "KZ", "8405", "30755");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1767", "IDR", "DZ", "6890", "14580");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1768", "IDR", "ID", "17530", "65030");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1769", "IDR", "NG", "9855", "62330");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1770", "IDR", "GT", "6905", "48810");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1771", "IDR", "VN", "14340", "54355");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1772", "IDR", "BY", "6735", "26215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1773", "IDR", "EG", "9080", "55475");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1774", "IDR", "UY", "7160", "32995");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1775", "IDR", "BD", "5895", "13050");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1776", "IDR", "PK", "6460", "37200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1777", "IDR", "PH", "11190", "41300");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1778", "IDR", "ET", "1795", "13680");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1779", "IDR", "TN", "6895", "12495");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1780", "IDR", "LB", "6960", "20810");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1781", "IDR", "IN", "6420", "28990");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1782", "IDR", "PY", "6900", "22185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1783", "IDR", "UZ", "6905", "13470");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1784", "IDR", "EC", "6705", "23005");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1785", "IDR", "MM", "6905", "7540");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1786", "IDR", "GE", "6925", "8825");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1787", "ILS", "US", "35", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1788", "ILS", "CH", "35", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1789", "ILS", "AU", "30", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1790", "ILS", "GB", "25", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1791", "ILS", "DE", "25", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1792", "ILS", "DK", "25", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1793", "ILS", "AT", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1794", "ILS", "NO", "20", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1795", "ILS", "CA", "25", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1796", "ILS", "NL", "25", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1797", "ILS", "SE", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1798", "ILS", "IE", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1799", "ILS", "BE", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1800", "ILS", "FI", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1801", "ILS", "FR", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1802", "ILS", "NZ", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1803", "ILS", "HK", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1804", "ILS", "CZ", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1805", "ILS", "SK", "15", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1806", "ILS", "AE", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1807", "ILS", "SG", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1808", "ILS", "IL", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1809", "ILS", "KW", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1810", "ILS", "IT", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1811", "ILS", "JP", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1812", "ILS", "ES", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1813", "ILS", "VE", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1814", "ILS", "HU", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1815", "ILS", "PT", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1816", "ILS", "GR", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1817", "ILS", "KR", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1818", "ILS", "TW", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1819", "ILS", "PL", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1820", "ILS", "ZM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1821", "ILS", "PR", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1822", "ILS", "CI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1823", "ILS", "RO", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1824", "ILS", "BH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1825", "ILS", "PA", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1826", "ILS", "GH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1827", "ILS", "KH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1828", "ILS", "SN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1829", "ILS", "SA", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1830", "ILS", "RU", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1831", "ILS", "UG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1832", "ILS", "BR", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1833", "ILS", "NI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1834", "ILS", "MG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1835", "ILS", "DO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1836", "ILS", "MX", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1837", "ILS", "OM", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1838", "ILS", "CM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1839", "ILS", "ZA", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1840", "ILS", "CL", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1841", "ILS", "KE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1842", "ILS", "NP", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1843", "ILS", "PE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1844", "ILS", "UA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1845", "ILS", "MZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1846", "ILS", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1847", "ILS", "AO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1848", "ILS", "JO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1849", "ILS", "ZW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1850", "ILS", "TR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1851", "ILS", "MU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1852", "ILS", "SV", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1853", "ILS", "TH", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1854", "ILS", "CO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1855", "ILS", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1856", "ILS", "CR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1857", "ILS", "AR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1858", "ILS", "MA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1859", "ILS", "MY", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1860", "ILS", "KZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1861", "ILS", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1862", "ILS", "ID", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1863", "ILS", "NG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1864", "ILS", "GT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1865", "ILS", "VN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1866", "ILS", "BY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1867", "ILS", "EG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1868", "ILS", "UY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1869", "ILS", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1870", "ILS", "PK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1871", "ILS", "PH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1872", "ILS", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1873", "ILS", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1874", "ILS", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1875", "ILS", "IN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1876", "ILS", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1877", "ILS", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1878", "ILS", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1879", "ILS", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1880", "ILS", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1881", "INR", "US", "865", "2435");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1882", "INR", "CH", "805", "2115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1883", "INR", "AU", "730", "1880");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1884", "INR", "GB", "640", "1635");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1885", "INR", "DE", "635", "1620");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1886", "INR", "DK", "585", "1445");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1887", "INR", "AT", "425", "1320");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1888", "INR", "NO", "480", "1345");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1889", "INR", "CA", "535", "1635");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1890", "INR", "NL", "570", "1445");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1891", "INR", "SE", "455", "1235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1892", "INR", "IE", "450", "1190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1893", "INR", "BE", "415", "1215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1894", "INR", "FI", "310", "945");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1895", "INR", "FR", "385", "1030");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1896", "INR", "NZ", "390", "1150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1897", "INR", "HK", "355", "1005");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1898", "INR", "CZ", "340", "815");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1899", "INR", "SK", "320", "695");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1900", "INR", "AE", "300", "950");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1901", "INR", "SG", "395", "1165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1902", "INR", "IL", "345", "840");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1903", "INR", "KW", "155", "755");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1904", "INR", "IT", "235", "620");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1905", "INR", "JP", "295", "835");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1906", "INR", "ES", "240", "635");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1907", "INR", "VE", "30", "485");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1908", "INR", "HU", "205", "470");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1909", "INR", "PT", "200", "530");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1910", "INR", "GR", "250", "510");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1911", "INR", "KR", "310", "815");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1912", "INR", "TW", "250", "670");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1913", "INR", "PL", "215", "530");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1914", "INR", "ZM", "30", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1915", "INR", "PR", "75", "710");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1916", "INR", "CI", "40", "170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1917", "INR", "RO", "195", "475");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1918", "INR", "BH", "90", "495");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1919", "INR", "PA", "60", "680");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1920", "INR", "GH", "70", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1921", "INR", "KH", "40", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1922", "INR", "SN", "30", "215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1923", "INR", "SA", "130", "490");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1924", "INR", "RU", "130", "405");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1925", "INR", "UG", "30", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1926", "INR", "BR", "135", "335");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1927", "INR", "NI", "30", "215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1928", "INR", "MG", "30", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1929", "INR", "DO", "35", "250");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1930", "INR", "MX", "105", "370");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1931", "INR", "OM", "65", "370");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1932", "INR", "CM", "30", "275");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1933", "INR", "ZA", "120", "395");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1934", "INR", "CL", "125", "380");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1935", "INR", "KE", "35", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1936", "INR", "NP", "30", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1937", "INR", "PE", "75", "320");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1938", "INR", "UA", "70", "225");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1939", "INR", "MZ", "30", "300");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1940", "INR", "TZ", "5", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1941", "INR", "AO", "65", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1942", "INR", "JO", "50", "230");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1943", "INR", "ZW", "30", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1944", "INR", "TR", "80", "215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1945", "INR", "MU", "40", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1946", "INR", "SV", "30", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1947", "INR", "TH", "115", "365");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1948", "INR", "CO", "60", "230");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1949", "INR", "LK", "30", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1950", "INR", "CR", "35", "240");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1951", "INR", "AR", "80", "220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1952", "INR", "MA", "35", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1953", "INR", "MY", "100", "375");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1954", "INR", "KZ", "45", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1955", "INR", "DZ", "35", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1956", "INR", "ID", "90", "340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1957", "INR", "NG", "50", "325");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1958", "INR", "GT", "35", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1959", "INR", "VN", "75", "280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1960", "INR", "BY", "35", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1961", "INR", "EG", "45", "290");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1962", "INR", "UY", "35", "170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1963", "INR", "BD", "30", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1964", "INR", "PK", "35", "195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1965", "INR", "PH", "60", "215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1966", "INR", "ET", "10", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1967", "INR", "TN", "35", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1968", "INR", "LB", "35", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1969", "INR", "IN", "35", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1970", "INR", "PY", "35", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1971", "INR", "UZ", "35", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1972", "INR", "EC", "35", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1973", "INR", "MM", "35", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1974", "INR", "GE", "35", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1975", "JPY", "US", "1225", "3455");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1976", "JPY", "CH", "1145", "3005");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1977", "JPY", "AU", "1040", "2670");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1978", "JPY", "GB", "905", "2320");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1979", "JPY", "DE", "900", "2300");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1980", "JPY", "DK", "830", "2055");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1981", "JPY", "AT", "605", "1875");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1982", "JPY", "NO", "685", "1910");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1983", "JPY", "CA", "755", "2320");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1984", "JPY", "NL", "810", "2055");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1985", "JPY", "SE", "650", "1750");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1986", "JPY", "IE", "640", "1690");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1987", "JPY", "BE", "590", "1730");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1988", "JPY", "FI", "440", "1340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1989", "JPY", "FR", "545", "1460");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1990", "JPY", "NZ", "555", "1635");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1991", "JPY", "HK", "505", "1430");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1992", "JPY", "CZ", "480", "1155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1993", "JPY", "SK", "455", "985");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1994", "JPY", "AE", "430", "1345");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1995", "JPY", "SG", "560", "1655");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1996", "JPY", "IL", "490", "1195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1997", "JPY", "KW", "220", "1075");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1998", "JPY", "IT", "330", "875");
INSERT INTO `wp_gla_budget_recommendations` VALUES("1999", "JPY", "JP", "415", "1185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2000", "JPY", "ES", "340", "905");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2001", "JPY", "VE", "45", "690");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2002", "JPY", "HU", "290", "670");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2003", "JPY", "PT", "285", "750");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2004", "JPY", "GR", "355", "725");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2005", "JPY", "KR", "435", "1155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2006", "JPY", "TW", "355", "950");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2007", "JPY", "PL", "305", "750");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2008", "JPY", "ZM", "45", "250");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2009", "JPY", "PR", "105", "1010");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2010", "JPY", "CI", "60", "240");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2011", "JPY", "RO", "280", "675");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2012", "JPY", "BH", "125", "705");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2013", "JPY", "PA", "85", "965");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2014", "JPY", "GH", "100", "285");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2015", "JPY", "KH", "60", "280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2016", "JPY", "SN", "45", "305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2017", "JPY", "SA", "180", "700");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2018", "JPY", "RU", "180", "580");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2019", "JPY", "UG", "45", "225");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2020", "JPY", "BR", "195", "475");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2021", "JPY", "NI", "40", "305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2022", "JPY", "MG", "45", "215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2023", "JPY", "DO", "50", "360");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2024", "JPY", "MX", "145", "525");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2025", "JPY", "OM", "90", "525");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2026", "JPY", "CM", "40", "395");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2027", "JPY", "ZA", "175", "560");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2028", "JPY", "CL", "180", "540");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2029", "JPY", "KE", "50", "225");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2030", "JPY", "NP", "40", "205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2031", "JPY", "PE", "110", "455");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2032", "JPY", "UA", "105", "320");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2033", "JPY", "MZ", "40", "425");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2034", "JPY", "TZ", "5", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2035", "JPY", "AO", "95", "245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2036", "JPY", "JO", "70", "330");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2037", "JPY", "ZW", "45", "235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2038", "JPY", "TR", "110", "300");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2039", "JPY", "MU", "55", "195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2040", "JPY", "SV", "40", "235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2041", "JPY", "TH", "165", "520");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2042", "JPY", "CO", "85", "325");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2043", "JPY", "LK", "40", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2044", "JPY", "CR", "50", "340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2045", "JPY", "AR", "115", "310");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2046", "JPY", "MA", "50", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2047", "JPY", "MY", "145", "535");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2048", "JPY", "KZ", "60", "225");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2049", "JPY", "DZ", "50", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2050", "JPY", "ID", "130", "480");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2051", "JPY", "NG", "75", "460");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2052", "JPY", "GT", "50", "360");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2053", "JPY", "VN", "105", "400");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2054", "JPY", "BY", "50", "195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2055", "JPY", "EG", "65", "410");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2056", "JPY", "UY", "55", "245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2057", "JPY", "BD", "45", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2058", "JPY", "PK", "50", "275");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2059", "JPY", "PH", "85", "305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2060", "JPY", "ET", "15", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2061", "JPY", "TN", "50", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2062", "JPY", "LB", "50", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2063", "JPY", "IN", "45", "215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2064", "JPY", "PY", "50", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2065", "JPY", "UZ", "50", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2066", "JPY", "EC", "50", "170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2067", "JPY", "MM", "50", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2068", "JPY", "GE", "50", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2069", "KRW", "US", "12955", "36545");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2070", "KRW", "CH", "12080", "31785");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2071", "KRW", "AU", "10990", "28220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2072", "KRW", "GB", "9580", "24520");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2073", "KRW", "DE", "9510", "24325");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2074", "KRW", "DK", "8750", "21715");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2075", "KRW", "AT", "6385", "19840");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2076", "KRW", "NO", "7235", "20205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2077", "KRW", "CA", "8000", "24530");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2078", "KRW", "NL", "8560", "21720");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2079", "KRW", "SE", "6850", "18525");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2080", "KRW", "IE", "6780", "17870");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2081", "KRW", "BE", "6235", "18270");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2082", "KRW", "FI", "4660", "14155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2083", "KRW", "FR", "5770", "15445");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2084", "KRW", "NZ", "5875", "17290");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2085", "KRW", "HK", "5340", "15105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2086", "KRW", "CZ", "5090", "12225");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2087", "KRW", "SK", "4805", "10410");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2088", "KRW", "AE", "4535", "14230");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2089", "KRW", "SG", "5915", "17485");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2090", "KRW", "IL", "5160", "12625");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2091", "KRW", "KW", "2330", "11350");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2092", "KRW", "IT", "3515", "9275");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2093", "KRW", "JP", "4405", "12520");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2094", "KRW", "ES", "3610", "9550");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2095", "KRW", "VE", "475", "7315");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2096", "KRW", "HU", "3045", "7080");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2097", "KRW", "PT", "3040", "7920");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2098", "KRW", "GR", "3745", "7675");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2099", "KRW", "KR", "4620", "12235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2100", "KRW", "TW", "3755", "10050");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2101", "KRW", "PL", "3210", "7950");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2102", "KRW", "ZM", "465", "2645");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2103", "KRW", "PR", "1135", "10665");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2104", "KRW", "CI", "620", "2560");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2105", "KRW", "RO", "2950", "7140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2106", "KRW", "BH", "1340", "7430");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2107", "KRW", "PA", "900", "10195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2108", "KRW", "GH", "1075", "3000");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2109", "KRW", "KH", "620", "2980");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2110", "KRW", "SN", "450", "3235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2111", "KRW", "SA", "1925", "7375");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2112", "KRW", "RU", "1915", "6110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2113", "KRW", "UG", "450", "2365");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2114", "KRW", "BR", "2040", "5030");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2115", "KRW", "NI", "450", "3220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2116", "KRW", "MG", "455", "2285");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2117", "KRW", "DO", "545", "3785");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2118", "KRW", "MX", "1540", "5570");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2119", "KRW", "OM", "965", "5570");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2120", "KRW", "CM", "450", "4150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2121", "KRW", "ZA", "1835", "5905");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2122", "KRW", "CL", "1910", "5710");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2123", "KRW", "KE", "550", "2385");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2124", "KRW", "NP", "450", "2165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2125", "KRW", "PE", "1140", "4805");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2126", "KRW", "UA", "1090", "3400");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2127", "KRW", "MZ", "450", "4505");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2128", "KRW", "TZ", "55", "1035");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2129", "KRW", "AO", "995", "2590");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2130", "KRW", "JO", "735", "3480");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2131", "KRW", "ZW", "450", "2470");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2132", "KRW", "TR", "1165", "3195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2133", "KRW", "MU", "600", "2045");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2134", "KRW", "SV", "450", "2475");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2135", "KRW", "TH", "1750", "5510");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2136", "KRW", "CO", "890", "3440");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2137", "KRW", "LK", "430", "595");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2138", "KRW", "CR", "540", "3595");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2139", "KRW", "AR", "1210", "3275");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2140", "KRW", "MA", "540", "2120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2141", "KRW", "MY", "1535", "5635");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2142", "KRW", "KZ", "655", "2400");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2143", "KRW", "DZ", "535", "1140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2144", "KRW", "ID", "1370", "5075");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2145", "KRW", "NG", "770", "4865");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2146", "KRW", "GT", "540", "3810");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2147", "KRW", "VN", "1120", "4240");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2148", "KRW", "BY", "525", "2045");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2149", "KRW", "EG", "710", "4330");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2150", "KRW", "UY", "560", "2575");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2151", "KRW", "BD", "460", "1020");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2152", "KRW", "PK", "505", "2905");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2153", "KRW", "PH", "875", "3225");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2154", "KRW", "ET", "140", "1065");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2155", "KRW", "TN", "540", "975");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2156", "KRW", "LB", "545", "1625");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2157", "KRW", "IN", "500", "2260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2158", "KRW", "PY", "540", "1730");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2159", "KRW", "UZ", "540", "1050");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2160", "KRW", "EC", "525", "1795");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2161", "KRW", "MM", "540", "590");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2162", "KRW", "GE", "540", "690");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2163", "MAD", "US", "105", "295");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2164", "MAD", "CH", "100", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2165", "MAD", "AU", "90", "230");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2166", "MAD", "GB", "75", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2167", "MAD", "DE", "75", "195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2168", "MAD", "DK", "70", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2169", "MAD", "AT", "50", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2170", "MAD", "NO", "60", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2171", "MAD", "CA", "65", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2172", "MAD", "NL", "70", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2173", "MAD", "SE", "55", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2174", "MAD", "IE", "55", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2175", "MAD", "BE", "50", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2176", "MAD", "FI", "40", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2177", "MAD", "FR", "45", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2178", "MAD", "NZ", "45", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2179", "MAD", "HK", "45", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2180", "MAD", "CZ", "40", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2181", "MAD", "SK", "40", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2182", "MAD", "AE", "35", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2183", "MAD", "SG", "50", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2184", "MAD", "IL", "40", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2185", "MAD", "KW", "20", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2186", "MAD", "IT", "30", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2187", "MAD", "JP", "35", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2188", "MAD", "ES", "30", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2189", "MAD", "VE", "5", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2190", "MAD", "HU", "25", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2191", "MAD", "PT", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2192", "MAD", "GR", "30", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2193", "MAD", "KR", "35", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2194", "MAD", "TW", "30", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2195", "MAD", "PL", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2196", "MAD", "ZM", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2197", "MAD", "PR", "10", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2198", "MAD", "CI", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2199", "MAD", "RO", "25", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2200", "MAD", "BH", "10", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2201", "MAD", "PA", "5", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2202", "MAD", "GH", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2203", "MAD", "KH", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2204", "MAD", "SN", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2205", "MAD", "SA", "15", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2206", "MAD", "RU", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2207", "MAD", "UG", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2208", "MAD", "BR", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2209", "MAD", "NI", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2210", "MAD", "MG", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2211", "MAD", "DO", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2212", "MAD", "MX", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2213", "MAD", "OM", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2214", "MAD", "CM", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2215", "MAD", "ZA", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2216", "MAD", "CL", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2217", "MAD", "KE", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2218", "MAD", "NP", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2219", "MAD", "PE", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2220", "MAD", "UA", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2221", "MAD", "MZ", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2222", "MAD", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2223", "MAD", "AO", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2224", "MAD", "JO", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2225", "MAD", "ZW", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2226", "MAD", "TR", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2227", "MAD", "MU", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2228", "MAD", "SV", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2229", "MAD", "TH", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2230", "MAD", "CO", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2231", "MAD", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2232", "MAD", "CR", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2233", "MAD", "AR", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2234", "MAD", "MA", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2235", "MAD", "MY", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2236", "MAD", "KZ", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2237", "MAD", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2238", "MAD", "ID", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2239", "MAD", "NG", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2240", "MAD", "GT", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2241", "MAD", "VN", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2242", "MAD", "BY", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2243", "MAD", "EG", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2244", "MAD", "UY", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2245", "MAD", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2246", "MAD", "PK", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2247", "MAD", "PH", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2248", "MAD", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2249", "MAD", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2250", "MAD", "LB", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2251", "MAD", "IN", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2252", "MAD", "PY", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2253", "MAD", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2254", "MAD", "EC", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2255", "MAD", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2256", "MAD", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2257", "MXN", "US", "235", "660");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2258", "MXN", "CH", "220", "575");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2259", "MXN", "AU", "200", "510");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2260", "MXN", "GB", "175", "445");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2261", "MXN", "DE", "170", "440");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2262", "MXN", "DK", "160", "390");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2263", "MXN", "AT", "115", "360");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2264", "MXN", "NO", "130", "365");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2265", "MXN", "CA", "145", "445");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2266", "MXN", "NL", "155", "395");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2267", "MXN", "SE", "125", "335");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2268", "MXN", "IE", "120", "325");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2269", "MXN", "BE", "115", "330");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2270", "MXN", "FI", "85", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2271", "MXN", "FR", "105", "280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2272", "MXN", "NZ", "105", "310");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2273", "MXN", "HK", "95", "275");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2274", "MXN", "CZ", "90", "220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2275", "MXN", "SK", "85", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2276", "MXN", "AE", "80", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2277", "MXN", "SG", "105", "315");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2278", "MXN", "IL", "95", "230");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2279", "MXN", "KW", "40", "205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2280", "MXN", "IT", "65", "170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2281", "MXN", "JP", "80", "225");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2282", "MXN", "ES", "65", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2283", "MXN", "VE", "10", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2284", "MXN", "HU", "55", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2285", "MXN", "PT", "55", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2286", "MXN", "GR", "70", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2287", "MXN", "KR", "85", "220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2288", "MXN", "TW", "70", "180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2289", "MXN", "PL", "60", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2290", "MXN", "ZM", "10", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2291", "MXN", "PR", "20", "195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2292", "MXN", "CI", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2293", "MXN", "RO", "55", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2294", "MXN", "BH", "25", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2295", "MXN", "PA", "15", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2296", "MXN", "GH", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2297", "MXN", "KH", "10", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2298", "MXN", "SN", "10", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2299", "MXN", "SA", "35", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2300", "MXN", "RU", "35", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2301", "MXN", "UG", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2302", "MXN", "BR", "35", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2303", "MXN", "NI", "10", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2304", "MXN", "MG", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2305", "MXN", "DO", "10", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2306", "MXN", "MX", "30", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2307", "MXN", "OM", "15", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2308", "MXN", "CM", "10", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2309", "MXN", "ZA", "35", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2310", "MXN", "CL", "35", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2311", "MXN", "KE", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2312", "MXN", "NP", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2313", "MXN", "PE", "20", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2314", "MXN", "UA", "20", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2315", "MXN", "MZ", "10", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2316", "MXN", "TZ", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2317", "MXN", "AO", "20", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2318", "MXN", "JO", "15", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2319", "MXN", "ZW", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2320", "MXN", "TR", "20", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2321", "MXN", "MU", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2322", "MXN", "SV", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2323", "MXN", "TH", "30", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2324", "MXN", "CO", "15", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2325", "MXN", "LK", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2326", "MXN", "CR", "10", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2327", "MXN", "AR", "20", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2328", "MXN", "MA", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2329", "MXN", "MY", "30", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2330", "MXN", "KZ", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2331", "MXN", "DZ", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2332", "MXN", "ID", "25", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2333", "MXN", "NG", "15", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2334", "MXN", "GT", "10", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2335", "MXN", "VN", "20", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2336", "MXN", "BY", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2337", "MXN", "EG", "15", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2338", "MXN", "UY", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2339", "MXN", "BD", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2340", "MXN", "PK", "10", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2341", "MXN", "PH", "15", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2342", "MXN", "ET", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2343", "MXN", "TN", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2344", "MXN", "LB", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2345", "MXN", "IN", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2346", "MXN", "PY", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2347", "MXN", "UZ", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2348", "MXN", "EC", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2349", "MXN", "MM", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2350", "MXN", "GE", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2351", "MYR", "US", "50", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2352", "MYR", "CH", "45", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2353", "MYR", "AU", "40", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2354", "MYR", "GB", "35", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2355", "MYR", "DE", "35", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2356", "MYR", "DK", "30", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2357", "MYR", "AT", "25", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2358", "MYR", "NO", "25", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2359", "MYR", "CA", "30", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2360", "MYR", "NL", "30", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2361", "MYR", "SE", "25", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2362", "MYR", "IE", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2363", "MYR", "BE", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2364", "MYR", "FI", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2365", "MYR", "FR", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2366", "MYR", "NZ", "20", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2367", "MYR", "HK", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2368", "MYR", "CZ", "20", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2369", "MYR", "SK", "20", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2370", "MYR", "AE", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2371", "MYR", "SG", "20", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2372", "MYR", "IL", "20", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2373", "MYR", "KW", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2374", "MYR", "IT", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2375", "MYR", "JP", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2376", "MYR", "ES", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2377", "MYR", "VE", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2378", "MYR", "HU", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2379", "MYR", "PT", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2380", "MYR", "GR", "15", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2381", "MYR", "KR", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2382", "MYR", "TW", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2383", "MYR", "PL", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2384", "MYR", "ZM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2385", "MYR", "PR", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2386", "MYR", "CI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2387", "MYR", "RO", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2388", "MYR", "BH", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2389", "MYR", "PA", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2390", "MYR", "GH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2391", "MYR", "KH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2392", "MYR", "SN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2393", "MYR", "SA", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2394", "MYR", "RU", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2395", "MYR", "UG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2396", "MYR", "BR", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2397", "MYR", "NI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2398", "MYR", "MG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2399", "MYR", "DO", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2400", "MYR", "MX", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2401", "MYR", "OM", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2402", "MYR", "CM", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2403", "MYR", "ZA", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2404", "MYR", "CL", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2405", "MYR", "KE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2406", "MYR", "NP", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2407", "MYR", "PE", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2408", "MYR", "UA", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2409", "MYR", "MZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2410", "MYR", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2411", "MYR", "AO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2412", "MYR", "JO", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2413", "MYR", "ZW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2414", "MYR", "TR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2415", "MYR", "MU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2416", "MYR", "SV", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2417", "MYR", "TH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2418", "MYR", "CO", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2419", "MYR", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2420", "MYR", "CR", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2421", "MYR", "AR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2422", "MYR", "MA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2423", "MYR", "MY", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2424", "MYR", "KZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2425", "MYR", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2426", "MYR", "ID", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2427", "MYR", "NG", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2428", "MYR", "GT", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2429", "MYR", "VN", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2430", "MYR", "BY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2431", "MYR", "EG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2432", "MYR", "UY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2433", "MYR", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2434", "MYR", "PK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2435", "MYR", "PH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2436", "MYR", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2437", "MYR", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2438", "MYR", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2439", "MYR", "IN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2440", "MYR", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2441", "MYR", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2442", "MYR", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2443", "MYR", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2444", "MYR", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2445", "NGN", "US", "4490", "12665");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2446", "NGN", "CH", "4185", "11015");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2447", "NGN", "AU", "3810", "9780");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2448", "NGN", "GB", "3320", "8495");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2449", "NGN", "DE", "3295", "8430");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2450", "NGN", "DK", "3030", "7525");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2451", "NGN", "AT", "2210", "6875");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2452", "NGN", "NO", "2505", "7000");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2453", "NGN", "CA", "2770", "8500");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2454", "NGN", "NL", "2965", "7525");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2455", "NGN", "SE", "2375", "6420");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2456", "NGN", "IE", "2350", "6190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2457", "NGN", "BE", "2160", "6330");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2458", "NGN", "FI", "1615", "4905");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2459", "NGN", "FR", "2000", "5350");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2460", "NGN", "NZ", "2035", "5990");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2461", "NGN", "HK", "1850", "5235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2462", "NGN", "CZ", "1765", "4235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2463", "NGN", "SK", "1665", "3610");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2464", "NGN", "AE", "1570", "4930");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2465", "NGN", "SG", "2050", "6060");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2466", "NGN", "IL", "1790", "4375");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2467", "NGN", "KW", "805", "3935");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2468", "NGN", "IT", "1220", "3215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2469", "NGN", "JP", "1525", "4340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2470", "NGN", "ES", "1250", "3310");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2471", "NGN", "VE", "165", "2535");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2472", "NGN", "HU", "1055", "2455");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2473", "NGN", "PT", "1055", "2745");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2474", "NGN", "GR", "1300", "2660");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2475", "NGN", "KR", "1600", "4240");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2476", "NGN", "TW", "1300", "3485");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2477", "NGN", "PL", "1115", "2755");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2478", "NGN", "ZM", "160", "915");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2479", "NGN", "PR", "395", "3695");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2480", "NGN", "CI", "215", "885");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2481", "NGN", "RO", "1025", "2475");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2482", "NGN", "BH", "465", "2575");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2483", "NGN", "PA", "310", "3535");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2484", "NGN", "GH", "375", "1040");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2485", "NGN", "KH", "215", "1030");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2486", "NGN", "SN", "155", "1120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2487", "NGN", "SA", "665", "2555");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2488", "NGN", "RU", "665", "2115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2489", "NGN", "UG", "155", "820");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2490", "NGN", "BR", "705", "1745");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2491", "NGN", "NI", "155", "1115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2492", "NGN", "MG", "155", "790");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2493", "NGN", "DO", "190", "1310");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2494", "NGN", "MX", "535", "1930");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2495", "NGN", "OM", "335", "1930");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2496", "NGN", "CM", "155", "1440");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2497", "NGN", "ZA", "635", "2045");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2498", "NGN", "CL", "660", "1980");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2499", "NGN", "KE", "190", "825");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2500", "NGN", "NP", "155", "750");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2501", "NGN", "PE", "395", "1665");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2502", "NGN", "UA", "375", "1175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2503", "NGN", "MZ", "155", "1560");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2504", "NGN", "TZ", "20", "360");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2505", "NGN", "AO", "345", "900");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2506", "NGN", "JO", "255", "1205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2507", "NGN", "ZW", "155", "855");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2508", "NGN", "TR", "405", "1105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2509", "NGN", "MU", "205", "710");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2510", "NGN", "SV", "155", "860");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2511", "NGN", "TH", "605", "1910");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2512", "NGN", "CO", "310", "1190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2513", "NGN", "LK", "150", "205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2514", "NGN", "CR", "190", "1245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2515", "NGN", "AR", "420", "1135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2516", "NGN", "MA", "185", "735");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2517", "NGN", "MY", "530", "1955");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2518", "NGN", "KZ", "225", "830");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2519", "NGN", "DZ", "185", "395");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2520", "NGN", "ID", "475", "1760");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2521", "NGN", "NG", "265", "1685");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2522", "NGN", "GT", "185", "1320");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2523", "NGN", "VN", "390", "1470");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2524", "NGN", "BY", "180", "710");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2525", "NGN", "EG", "245", "1500");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2526", "NGN", "UY", "195", "890");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2527", "NGN", "BD", "160", "355");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2528", "NGN", "PK", "175", "1005");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2529", "NGN", "PH", "305", "1115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2530", "NGN", "ET", "50", "370");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2531", "NGN", "TN", "185", "340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2532", "NGN", "LB", "190", "565");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2533", "NGN", "IN", "175", "785");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2534", "NGN", "PY", "185", "600");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2535", "NGN", "UZ", "185", "365");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2536", "NGN", "EC", "180", "620");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2537", "NGN", "MM", "185", "205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2538", "NGN", "GE", "185", "240");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2539", "NOK", "US", "100", "280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2540", "NOK", "CH", "95", "245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2541", "NOK", "AU", "85", "220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2542", "NOK", "GB", "75", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2543", "NOK", "DE", "75", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2544", "NOK", "DK", "70", "170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2545", "NOK", "AT", "50", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2546", "NOK", "NO", "55", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2547", "NOK", "CA", "60", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2548", "NOK", "NL", "65", "170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2549", "NOK", "SE", "55", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2550", "NOK", "IE", "50", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2551", "NOK", "BE", "50", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2552", "NOK", "FI", "35", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2553", "NOK", "FR", "45", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2554", "NOK", "NZ", "45", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2555", "NOK", "HK", "40", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2556", "NOK", "CZ", "40", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2557", "NOK", "SK", "35", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2558", "NOK", "AE", "35", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2559", "NOK", "SG", "45", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2560", "NOK", "IL", "40", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2561", "NOK", "KW", "20", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2562", "NOK", "IT", "25", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2563", "NOK", "JP", "35", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2564", "NOK", "ES", "30", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2565", "NOK", "VE", "5", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2566", "NOK", "HU", "25", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2567", "NOK", "PT", "25", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2568", "NOK", "GR", "30", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2569", "NOK", "KR", "35", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2570", "NOK", "TW", "30", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2571", "NOK", "PL", "25", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2572", "NOK", "ZM", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2573", "NOK", "PR", "10", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2574", "NOK", "CI", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2575", "NOK", "RO", "25", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2576", "NOK", "BH", "10", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2577", "NOK", "PA", "5", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2578", "NOK", "GH", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2579", "NOK", "KH", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2580", "NOK", "SN", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2581", "NOK", "SA", "15", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2582", "NOK", "RU", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2583", "NOK", "UG", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2584", "NOK", "BR", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2585", "NOK", "NI", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2586", "NOK", "MG", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2587", "NOK", "DO", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2588", "NOK", "MX", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2589", "NOK", "OM", "5", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2590", "NOK", "CM", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2591", "NOK", "ZA", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2592", "NOK", "CL", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2593", "NOK", "KE", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2594", "NOK", "NP", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2595", "NOK", "PE", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2596", "NOK", "UA", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2597", "NOK", "MZ", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2598", "NOK", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2599", "NOK", "AO", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2600", "NOK", "JO", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2601", "NOK", "ZW", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2602", "NOK", "TR", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2603", "NOK", "MU", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2604", "NOK", "SV", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2605", "NOK", "TH", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2606", "NOK", "CO", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2607", "NOK", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2608", "NOK", "CR", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2609", "NOK", "AR", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2610", "NOK", "MA", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2611", "NOK", "MY", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2612", "NOK", "KZ", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2613", "NOK", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2614", "NOK", "ID", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2615", "NOK", "NG", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2616", "NOK", "GT", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2617", "NOK", "VN", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2618", "NOK", "BY", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2619", "NOK", "EG", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2620", "NOK", "UY", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2621", "NOK", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2622", "NOK", "PK", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2623", "NOK", "PH", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2624", "NOK", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2625", "NOK", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2626", "NOK", "LB", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2627", "NOK", "IN", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2628", "NOK", "PY", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2629", "NOK", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2630", "NOK", "EC", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2631", "NOK", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2632", "NOK", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2633", "PEN", "US", "45", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2634", "PEN", "CH", "40", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2635", "PEN", "AU", "35", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2636", "PEN", "GB", "30", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2637", "PEN", "DE", "30", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2638", "PEN", "DK", "30", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2639", "PEN", "AT", "20", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2640", "PEN", "NO", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2641", "PEN", "CA", "25", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2642", "PEN", "NL", "30", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2643", "PEN", "SE", "25", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2644", "PEN", "IE", "20", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2645", "PEN", "BE", "20", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2646", "PEN", "FI", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2647", "PEN", "FR", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2648", "PEN", "NZ", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2649", "PEN", "HK", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2650", "PEN", "CZ", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2651", "PEN", "SK", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2652", "PEN", "AE", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2653", "PEN", "SG", "20", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2654", "PEN", "IL", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2655", "PEN", "KW", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2656", "PEN", "IT", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2657", "PEN", "JP", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2658", "PEN", "ES", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2659", "PEN", "VE", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2660", "PEN", "HU", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2661", "PEN", "PT", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2662", "PEN", "GR", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2663", "PEN", "KR", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2664", "PEN", "TW", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2665", "PEN", "PL", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2666", "PEN", "ZM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2667", "PEN", "PR", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2668", "PEN", "CI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2669", "PEN", "RO", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2670", "PEN", "BH", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2671", "PEN", "PA", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2672", "PEN", "GH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2673", "PEN", "KH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2674", "PEN", "SN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2675", "PEN", "SA", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2676", "PEN", "RU", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2677", "PEN", "UG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2678", "PEN", "BR", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2679", "PEN", "NI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2680", "PEN", "MG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2681", "PEN", "DO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2682", "PEN", "MX", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2683", "PEN", "OM", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2684", "PEN", "CM", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2685", "PEN", "ZA", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2686", "PEN", "CL", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2687", "PEN", "KE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2688", "PEN", "NP", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2689", "PEN", "PE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2690", "PEN", "UA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2691", "PEN", "MZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2692", "PEN", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2693", "PEN", "AO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2694", "PEN", "JO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2695", "PEN", "ZW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2696", "PEN", "TR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2697", "PEN", "MU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2698", "PEN", "SV", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2699", "PEN", "TH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2700", "PEN", "CO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2701", "PEN", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2702", "PEN", "CR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2703", "PEN", "AR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2704", "PEN", "MA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2705", "PEN", "MY", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2706", "PEN", "KZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2707", "PEN", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2708", "PEN", "ID", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2709", "PEN", "NG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2710", "PEN", "GT", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2711", "PEN", "VN", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2712", "PEN", "BY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2713", "PEN", "EG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2714", "PEN", "UY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2715", "PEN", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2716", "PEN", "PK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2717", "PEN", "PH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2718", "PEN", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2719", "PEN", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2720", "PEN", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2721", "PEN", "IN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2722", "PEN", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2723", "PEN", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2724", "PEN", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2725", "PEN", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2726", "PEN", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2727", "PHP", "US", "565", "1600");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2728", "PHP", "CH", "530", "1390");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2729", "PHP", "AU", "480", "1235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2730", "PHP", "GB", "420", "1070");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2731", "PHP", "DE", "415", "1065");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2732", "PHP", "DK", "380", "950");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2733", "PHP", "AT", "280", "865");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2734", "PHP", "NO", "315", "885");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2735", "PHP", "CA", "350", "1070");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2736", "PHP", "NL", "375", "950");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2737", "PHP", "SE", "300", "810");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2738", "PHP", "IE", "295", "780");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2739", "PHP", "BE", "275", "800");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2740", "PHP", "FI", "205", "620");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2741", "PHP", "FR", "250", "675");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2742", "PHP", "NZ", "255", "755");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2743", "PHP", "HK", "235", "660");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2744", "PHP", "CZ", "225", "535");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2745", "PHP", "SK", "210", "455");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2746", "PHP", "AE", "200", "620");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2747", "PHP", "SG", "260", "765");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2748", "PHP", "IL", "225", "550");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2749", "PHP", "KW", "100", "495");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2750", "PHP", "IT", "155", "405");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2751", "PHP", "JP", "195", "545");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2752", "PHP", "ES", "160", "420");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2753", "PHP", "VE", "20", "320");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2754", "PHP", "HU", "135", "310");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2755", "PHP", "PT", "135", "345");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2756", "PHP", "GR", "165", "335");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2757", "PHP", "KR", "200", "535");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2758", "PHP", "TW", "165", "440");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2759", "PHP", "PL", "140", "350");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2760", "PHP", "ZM", "20", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2761", "PHP", "PR", "50", "465");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2762", "PHP", "CI", "25", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2763", "PHP", "RO", "130", "310");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2764", "PHP", "BH", "60", "325");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2765", "PHP", "PA", "40", "445");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2766", "PHP", "GH", "45", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2767", "PHP", "KH", "25", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2768", "PHP", "SN", "20", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2769", "PHP", "SA", "85", "320");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2770", "PHP", "RU", "85", "265");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2771", "PHP", "UG", "20", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2772", "PHP", "BR", "90", "220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2773", "PHP", "NI", "20", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2774", "PHP", "MG", "20", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2775", "PHP", "DO", "25", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2776", "PHP", "MX", "65", "245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2777", "PHP", "OM", "40", "245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2778", "PHP", "CM", "20", "180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2779", "PHP", "ZA", "80", "260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2780", "PHP", "CL", "85", "250");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2781", "PHP", "KE", "25", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2782", "PHP", "NP", "20", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2783", "PHP", "PE", "50", "210");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2784", "PHP", "UA", "50", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2785", "PHP", "MZ", "20", "195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2786", "PHP", "TZ", "5", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2787", "PHP", "AO", "45", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2788", "PHP", "JO", "30", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2789", "PHP", "ZW", "20", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2790", "PHP", "TR", "50", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2791", "PHP", "MU", "25", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2792", "PHP", "SV", "20", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2793", "PHP", "TH", "75", "240");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2794", "PHP", "CO", "40", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2795", "PHP", "LK", "20", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2796", "PHP", "CR", "25", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2797", "PHP", "AR", "55", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2798", "PHP", "MA", "25", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2799", "PHP", "MY", "65", "245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2800", "PHP", "KZ", "30", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2801", "PHP", "DZ", "25", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2802", "PHP", "ID", "60", "220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2803", "PHP", "NG", "35", "215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2804", "PHP", "GT", "25", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2805", "PHP", "VN", "50", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2806", "PHP", "BY", "25", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2807", "PHP", "EG", "30", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2808", "PHP", "UY", "25", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2809", "PHP", "BD", "20", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2810", "PHP", "PK", "20", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2811", "PHP", "PH", "40", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2812", "PHP", "ET", "5", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2813", "PHP", "TN", "25", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2814", "PHP", "LB", "25", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2815", "PHP", "IN", "20", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2816", "PHP", "PY", "25", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2817", "PHP", "UZ", "25", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2818", "PHP", "EC", "25", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2819", "PHP", "MM", "25", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2820", "PHP", "GE", "25", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2821", "PKR", "US", "1895", "5340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2822", "PKR", "CH", "1765", "4645");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2823", "PKR", "AU", "1605", "4125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2824", "PKR", "GB", "1400", "3585");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2825", "PKR", "DE", "1390", "3555");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2826", "PKR", "DK", "1280", "3175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2827", "PKR", "AT", "935", "2900");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2828", "PKR", "NO", "1055", "2955");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2829", "PKR", "CA", "1170", "3585");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2830", "PKR", "NL", "1250", "3175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2831", "PKR", "SE", "1000", "2705");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2832", "PKR", "IE", "990", "2610");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2833", "PKR", "BE", "910", "2670");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2834", "PKR", "FI", "680", "2070");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2835", "PKR", "FR", "845", "2255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2836", "PKR", "NZ", "860", "2525");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2837", "PKR", "HK", "780", "2205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2838", "PKR", "CZ", "745", "1785");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2839", "PKR", "SK", "700", "1520");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2840", "PKR", "AE", "665", "2080");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2841", "PKR", "SG", "865", "2555");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2842", "PKR", "IL", "755", "1845");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2843", "PKR", "KW", "340", "1660");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2844", "PKR", "IT", "515", "1355");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2845", "PKR", "JP", "645", "1830");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2846", "PKR", "ES", "530", "1395");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2847", "PKR", "VE", "70", "1070");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2848", "PKR", "HU", "445", "1035");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2849", "PKR", "PT", "445", "1160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2850", "PKR", "GR", "550", "1120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2851", "PKR", "KR", "675", "1790");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2852", "PKR", "TW", "550", "1470");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2853", "PKR", "PL", "470", "1160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2854", "PKR", "ZM", "70", "385");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2855", "PKR", "PR", "165", "1560");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2856", "PKR", "CI", "90", "375");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2857", "PKR", "RO", "430", "1045");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2858", "PKR", "BH", "195", "1085");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2859", "PKR", "PA", "130", "1490");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2860", "PKR", "GH", "155", "440");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2861", "PKR", "KH", "90", "435");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2862", "PKR", "SN", "65", "475");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2863", "PKR", "SA", "280", "1080");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2864", "PKR", "RU", "280", "895");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2865", "PKR", "UG", "65", "345");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2866", "PKR", "BR", "300", "735");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2867", "PKR", "NI", "65", "470");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2868", "PKR", "MG", "65", "335");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2869", "PKR", "DO", "80", "555");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2870", "PKR", "MX", "225", "815");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2871", "PKR", "OM", "140", "815");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2872", "PKR", "CM", "65", "605");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2873", "PKR", "ZA", "270", "865");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2874", "PKR", "CL", "280", "835");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2875", "PKR", "KE", "80", "350");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2876", "PKR", "NP", "65", "315");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2877", "PKR", "PE", "165", "700");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2878", "PKR", "UA", "160", "495");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2879", "PKR", "MZ", "65", "660");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2880", "PKR", "TZ", "10", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2881", "PKR", "AO", "145", "380");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2882", "PKR", "JO", "105", "510");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2883", "PKR", "ZW", "65", "360");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2884", "PKR", "TR", "170", "465");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2885", "PKR", "MU", "85", "300");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2886", "PKR", "SV", "65", "360");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2887", "PKR", "TH", "255", "805");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2888", "PKR", "CO", "130", "500");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2889", "PKR", "LK", "65", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2890", "PKR", "CR", "80", "525");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2891", "PKR", "AR", "175", "480");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2892", "PKR", "MA", "80", "310");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2893", "PKR", "MY", "225", "825");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2894", "PKR", "KZ", "95", "350");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2895", "PKR", "DZ", "80", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2896", "PKR", "ID", "200", "740");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2897", "PKR", "NG", "110", "710");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2898", "PKR", "GT", "80", "555");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2899", "PKR", "VN", "165", "620");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2900", "PKR", "BY", "75", "300");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2901", "PKR", "EG", "105", "635");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2902", "PKR", "UY", "80", "375");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2903", "PKR", "BD", "65", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2904", "PKR", "PK", "75", "425");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2905", "PKR", "PH", "130", "470");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2906", "PKR", "ET", "20", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2907", "PKR", "TN", "80", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2908", "PKR", "LB", "80", "235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2909", "PKR", "IN", "75", "330");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2910", "PKR", "PY", "80", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2911", "PKR", "UZ", "80", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2912", "PKR", "EC", "75", "260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2913", "PKR", "MM", "80", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2914", "PKR", "GE", "80", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2915", "PLN", "US", "45", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2916", "PLN", "CH", "40", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2917", "PLN", "AU", "35", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2918", "PLN", "GB", "35", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2919", "PLN", "DE", "30", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2920", "PLN", "DK", "30", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2921", "PLN", "AT", "20", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2922", "PLN", "NO", "25", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2923", "PLN", "CA", "25", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2924", "PLN", "NL", "30", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2925", "PLN", "SE", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2926", "PLN", "IE", "25", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2927", "PLN", "BE", "20", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2928", "PLN", "FI", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2929", "PLN", "FR", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2930", "PLN", "NZ", "20", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2931", "PLN", "HK", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2932", "PLN", "CZ", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2933", "PLN", "SK", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2934", "PLN", "AE", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2935", "PLN", "SG", "20", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2936", "PLN", "IL", "20", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2937", "PLN", "KW", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2938", "PLN", "IT", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2939", "PLN", "JP", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2940", "PLN", "ES", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2941", "PLN", "VE", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2942", "PLN", "HU", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2943", "PLN", "PT", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2944", "PLN", "GR", "15", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2945", "PLN", "KR", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2946", "PLN", "TW", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2947", "PLN", "PL", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2948", "PLN", "ZM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2949", "PLN", "PR", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2950", "PLN", "CI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2951", "PLN", "RO", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2952", "PLN", "BH", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2953", "PLN", "PA", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2954", "PLN", "GH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2955", "PLN", "KH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2956", "PLN", "SN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2957", "PLN", "SA", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2958", "PLN", "RU", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2959", "PLN", "UG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2960", "PLN", "BR", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2961", "PLN", "NI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2962", "PLN", "MG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2963", "PLN", "DO", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2964", "PLN", "MX", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2965", "PLN", "OM", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2966", "PLN", "CM", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2967", "PLN", "ZA", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2968", "PLN", "CL", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2969", "PLN", "KE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2970", "PLN", "NP", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2971", "PLN", "PE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2972", "PLN", "UA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2973", "PLN", "MZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2974", "PLN", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2975", "PLN", "AO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2976", "PLN", "JO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2977", "PLN", "ZW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2978", "PLN", "TR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2979", "PLN", "MU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2980", "PLN", "SV", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2981", "PLN", "TH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2982", "PLN", "CO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2983", "PLN", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2984", "PLN", "CR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2985", "PLN", "AR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2986", "PLN", "MA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2987", "PLN", "MY", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2988", "PLN", "KZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2989", "PLN", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2990", "PLN", "ID", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2991", "PLN", "NG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2992", "PLN", "GT", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2993", "PLN", "VN", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2994", "PLN", "BY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2995", "PLN", "EG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2996", "PLN", "UY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2997", "PLN", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2998", "PLN", "PK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("2999", "PLN", "PH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3000", "PLN", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3001", "PLN", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3002", "PLN", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3003", "PLN", "IN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3004", "PLN", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3005", "PLN", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3006", "PLN", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3007", "PLN", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3008", "PLN", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3009", "RON", "US", "45", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3010", "RON", "CH", "45", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3011", "RON", "AU", "40", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3012", "RON", "GB", "35", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3013", "RON", "DE", "35", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3014", "RON", "DK", "30", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3015", "RON", "AT", "25", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3016", "RON", "NO", "25", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3017", "RON", "CA", "30", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3018", "RON", "NL", "30", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3019", "RON", "SE", "25", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3020", "RON", "IE", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3021", "RON", "BE", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3022", "RON", "FI", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3023", "RON", "FR", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3024", "RON", "NZ", "20", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3025", "RON", "HK", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3026", "RON", "CZ", "20", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3027", "RON", "SK", "20", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3028", "RON", "AE", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3029", "RON", "SG", "20", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3030", "RON", "IL", "20", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3031", "RON", "KW", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3032", "RON", "IT", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3033", "RON", "JP", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3034", "RON", "ES", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3035", "RON", "VE", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3036", "RON", "HU", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3037", "RON", "PT", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3038", "RON", "GR", "15", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3039", "RON", "KR", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3040", "RON", "TW", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3041", "RON", "PL", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3042", "RON", "ZM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3043", "RON", "PR", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3044", "RON", "CI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3045", "RON", "RO", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3046", "RON", "BH", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3047", "RON", "PA", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3048", "RON", "GH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3049", "RON", "KH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3050", "RON", "SN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3051", "RON", "SA", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3052", "RON", "RU", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3053", "RON", "UG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3054", "RON", "BR", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3055", "RON", "NI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3056", "RON", "MG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3057", "RON", "DO", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3058", "RON", "MX", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3059", "RON", "OM", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3060", "RON", "CM", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3061", "RON", "ZA", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3062", "RON", "CL", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3063", "RON", "KE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3064", "RON", "NP", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3065", "RON", "PE", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3066", "RON", "UA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3067", "RON", "MZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3068", "RON", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3069", "RON", "AO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3070", "RON", "JO", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3071", "RON", "ZW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3072", "RON", "TR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3073", "RON", "MU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3074", "RON", "SV", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3075", "RON", "TH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3076", "RON", "CO", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3077", "RON", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3078", "RON", "CR", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3079", "RON", "AR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3080", "RON", "MA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3081", "RON", "MY", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3082", "RON", "KZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3083", "RON", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3084", "RON", "ID", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3085", "RON", "NG", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3086", "RON", "GT", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3087", "RON", "VN", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3088", "RON", "BY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3089", "RON", "EG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3090", "RON", "UY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3091", "RON", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3092", "RON", "PK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3093", "RON", "PH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3094", "RON", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3095", "RON", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3096", "RON", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3097", "RON", "IN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3098", "RON", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3099", "RON", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3100", "RON", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3101", "RON", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3102", "RON", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3103", "RSD", "US", "1140", "3220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3104", "RSD", "CH", "1065", "2800");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3105", "RSD", "AU", "970", "2485");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3106", "RSD", "GB", "845", "2160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3107", "RSD", "DE", "840", "2145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3108", "RSD", "DK", "770", "1915");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3109", "RSD", "AT", "560", "1750");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3110", "RSD", "NO", "635", "1780");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3111", "RSD", "CA", "705", "2160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3112", "RSD", "NL", "755", "1915");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3113", "RSD", "SE", "605", "1630");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3114", "RSD", "IE", "595", "1575");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3115", "RSD", "BE", "550", "1610");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3116", "RSD", "FI", "410", "1245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3117", "RSD", "FR", "510", "1360");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3118", "RSD", "NZ", "515", "1525");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3119", "RSD", "HK", "470", "1330");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3120", "RSD", "CZ", "450", "1075");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3121", "RSD", "SK", "425", "915");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3122", "RSD", "AE", "400", "1255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3123", "RSD", "SG", "520", "1540");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3124", "RSD", "IL", "455", "1110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3125", "RSD", "KW", "205", "1000");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3126", "RSD", "IT", "310", "815");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3127", "RSD", "JP", "390", "1105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3128", "RSD", "ES", "320", "840");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3129", "RSD", "VE", "40", "645");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3130", "RSD", "HU", "270", "625");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3131", "RSD", "PT", "270", "700");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3132", "RSD", "GR", "330", "675");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3133", "RSD", "KR", "405", "1075");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3134", "RSD", "TW", "330", "885");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3135", "RSD", "PL", "285", "700");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3136", "RSD", "ZM", "40", "235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3137", "RSD", "PR", "100", "940");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3138", "RSD", "CI", "55", "225");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3139", "RSD", "RO", "260", "630");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3140", "RSD", "BH", "120", "655");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3141", "RSD", "PA", "80", "900");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3142", "RSD", "GH", "95", "265");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3143", "RSD", "KH", "55", "260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3144", "RSD", "SN", "40", "285");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3145", "RSD", "SA", "170", "650");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3146", "RSD", "RU", "170", "540");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3147", "RSD", "UG", "40", "210");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3148", "RSD", "BR", "180", "445");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3149", "RSD", "NI", "40", "285");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3150", "RSD", "MG", "40", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3151", "RSD", "DO", "50", "335");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3152", "RSD", "MX", "135", "490");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3153", "RSD", "OM", "85", "490");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3154", "RSD", "CM", "40", "365");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3155", "RSD", "ZA", "160", "520");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3156", "RSD", "CL", "170", "505");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3157", "RSD", "KE", "50", "210");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3158", "RSD", "NP", "40", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3159", "RSD", "PE", "100", "425");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3160", "RSD", "UA", "95", "300");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3161", "RSD", "MZ", "40", "395");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3162", "RSD", "TZ", "5", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3163", "RSD", "AO", "90", "230");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3164", "RSD", "JO", "65", "305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3165", "RSD", "ZW", "40", "220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3166", "RSD", "TR", "105", "280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3167", "RSD", "MU", "55", "180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3168", "RSD", "SV", "40", "220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3169", "RSD", "TH", "155", "485");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3170", "RSD", "CO", "80", "305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3171", "RSD", "LK", "40", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3172", "RSD", "CR", "50", "315");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3173", "RSD", "AR", "105", "290");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3174", "RSD", "MA", "50", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3175", "RSD", "MY", "135", "495");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3176", "RSD", "KZ", "60", "210");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3177", "RSD", "DZ", "45", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3178", "RSD", "ID", "120", "445");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3179", "RSD", "NG", "70", "430");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3180", "RSD", "GT", "45", "335");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3181", "RSD", "VN", "100", "375");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3182", "RSD", "BY", "45", "180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3183", "RSD", "EG", "60", "380");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3184", "RSD", "UY", "50", "225");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3185", "RSD", "BD", "40", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3186", "RSD", "PK", "45", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3187", "RSD", "PH", "75", "285");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3188", "RSD", "ET", "10", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3189", "RSD", "TN", "45", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3190", "RSD", "LB", "50", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3191", "RSD", "IN", "45", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3192", "RSD", "PY", "45", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3193", "RSD", "UZ", "45", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3194", "RSD", "EC", "45", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3195", "RSD", "MM", "45", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3196", "RSD", "GE", "50", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3197", "RUB", "US", "870", "2455");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3198", "RUB", "CH", "810", "2135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3199", "RUB", "AU", "740", "1895");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3200", "RUB", "GB", "645", "1650");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3201", "RUB", "DE", "640", "1635");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3202", "RUB", "DK", "590", "1460");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3203", "RUB", "AT", "430", "1335");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3204", "RUB", "NO", "485", "1360");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3205", "RUB", "CA", "540", "1650");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3206", "RUB", "NL", "575", "1460");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3207", "RUB", "SE", "460", "1245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3208", "RUB", "IE", "455", "1200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3209", "RUB", "BE", "420", "1230");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3210", "RUB", "FI", "315", "950");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3211", "RUB", "FR", "390", "1040");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3212", "RUB", "NZ", "395", "1160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3213", "RUB", "HK", "360", "1015");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3214", "RUB", "CZ", "340", "820");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3215", "RUB", "SK", "325", "700");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3216", "RUB", "AE", "305", "955");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3217", "RUB", "SG", "400", "1175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3218", "RUB", "IL", "345", "850");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3219", "RUB", "KW", "155", "765");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3220", "RUB", "IT", "235", "625");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3221", "RUB", "JP", "295", "840");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3222", "RUB", "ES", "245", "640");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3223", "RUB", "VE", "30", "490");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3224", "RUB", "HU", "205", "475");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3225", "RUB", "PT", "205", "530");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3226", "RUB", "GR", "250", "515");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3227", "RUB", "KR", "310", "820");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3228", "RUB", "TW", "250", "675");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3229", "RUB", "PL", "215", "535");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3230", "RUB", "ZM", "30", "180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3231", "RUB", "PR", "75", "715");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3232", "RUB", "CI", "40", "170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3233", "RUB", "RO", "200", "480");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3234", "RUB", "BH", "90", "500");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3235", "RUB", "PA", "60", "685");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3236", "RUB", "GH", "70", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3237", "RUB", "KH", "40", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3238", "RUB", "SN", "30", "220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3239", "RUB", "SA", "130", "495");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3240", "RUB", "RU", "130", "410");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3241", "RUB", "UG", "30", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3242", "RUB", "BR", "135", "340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3243", "RUB", "NI", "30", "215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3244", "RUB", "MG", "30", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3245", "RUB", "DO", "35", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3246", "RUB", "MX", "105", "375");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3247", "RUB", "OM", "65", "375");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3248", "RUB", "CM", "30", "280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3249", "RUB", "ZA", "125", "395");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3250", "RUB", "CL", "130", "385");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3251", "RUB", "KE", "35", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3252", "RUB", "NP", "30", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3253", "RUB", "PE", "75", "325");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3254", "RUB", "UA", "75", "230");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3255", "RUB", "MZ", "30", "305");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3256", "RUB", "TZ", "5", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3257", "RUB", "AO", "65", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3258", "RUB", "JO", "50", "235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3259", "RUB", "ZW", "30", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3260", "RUB", "TR", "80", "215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3261", "RUB", "MU", "40", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3262", "RUB", "SV", "30", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3263", "RUB", "TH", "120", "370");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3264", "RUB", "CO", "60", "230");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3265", "RUB", "LK", "30", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3266", "RUB", "CR", "35", "240");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3267", "RUB", "AR", "80", "220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3268", "RUB", "MA", "35", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3269", "RUB", "MY", "105", "380");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3270", "RUB", "KZ", "45", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3271", "RUB", "DZ", "35", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3272", "RUB", "ID", "90", "340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3273", "RUB", "NG", "50", "325");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3274", "RUB", "GT", "35", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3275", "RUB", "VN", "75", "285");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3276", "RUB", "BY", "35", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3277", "RUB", "EG", "50", "290");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3278", "RUB", "UY", "40", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3279", "RUB", "BD", "30", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3280", "RUB", "PK", "35", "195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3281", "RUB", "PH", "60", "215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3282", "RUB", "ET", "10", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3283", "RUB", "TN", "35", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3284", "RUB", "LB", "35", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3285", "RUB", "IN", "35", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3286", "RUB", "PY", "35", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3287", "RUB", "UZ", "35", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3288", "RUB", "EC", "35", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3289", "RUB", "MM", "35", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3290", "RUB", "GE", "35", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3291", "SAR", "US", "45", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3292", "SAR", "CH", "40", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3293", "SAR", "AU", "40", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3294", "SAR", "GB", "35", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3295", "SAR", "DE", "30", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3296", "SAR", "DK", "30", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3297", "SAR", "AT", "20", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3298", "SAR", "NO", "25", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3299", "SAR", "CA", "25", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3300", "SAR", "NL", "30", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3301", "SAR", "SE", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3302", "SAR", "IE", "25", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3303", "SAR", "BE", "20", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3304", "SAR", "FI", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3305", "SAR", "FR", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3306", "SAR", "NZ", "20", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3307", "SAR", "HK", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3308", "SAR", "CZ", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3309", "SAR", "SK", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3310", "SAR", "AE", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3311", "SAR", "SG", "20", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3312", "SAR", "IL", "20", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3313", "SAR", "KW", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3314", "SAR", "IT", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3315", "SAR", "JP", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3316", "SAR", "ES", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3317", "SAR", "VE", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3318", "SAR", "HU", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3319", "SAR", "PT", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3320", "SAR", "GR", "15", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3321", "SAR", "KR", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3322", "SAR", "TW", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3323", "SAR", "PL", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3324", "SAR", "ZM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3325", "SAR", "PR", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3326", "SAR", "CI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3327", "SAR", "RO", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3328", "SAR", "BH", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3329", "SAR", "PA", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3330", "SAR", "GH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3331", "SAR", "KH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3332", "SAR", "SN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3333", "SAR", "SA", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3334", "SAR", "RU", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3335", "SAR", "UG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3336", "SAR", "BR", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3337", "SAR", "NI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3338", "SAR", "MG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3339", "SAR", "DO", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3340", "SAR", "MX", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3341", "SAR", "OM", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3342", "SAR", "CM", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3343", "SAR", "ZA", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3344", "SAR", "CL", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3345", "SAR", "KE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3346", "SAR", "NP", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3347", "SAR", "PE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3348", "SAR", "UA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3349", "SAR", "MZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3350", "SAR", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3351", "SAR", "AO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3352", "SAR", "JO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3353", "SAR", "ZW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3354", "SAR", "TR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3355", "SAR", "MU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3356", "SAR", "SV", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3357", "SAR", "TH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3358", "SAR", "CO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3359", "SAR", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3360", "SAR", "CR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3361", "SAR", "AR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3362", "SAR", "MA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3363", "SAR", "MY", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3364", "SAR", "KZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3365", "SAR", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3366", "SAR", "ID", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3367", "SAR", "NG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3368", "SAR", "GT", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3369", "SAR", "VN", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3370", "SAR", "BY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3371", "SAR", "EG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3372", "SAR", "UY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3373", "SAR", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3374", "SAR", "PK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3375", "SAR", "PH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3376", "SAR", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3377", "SAR", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3378", "SAR", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3379", "SAR", "IN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3380", "SAR", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3381", "SAR", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3382", "SAR", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3383", "SAR", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3384", "SAR", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3385", "SEK", "US", "100", "280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3386", "SEK", "CH", "90", "240");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3387", "SEK", "AU", "85", "215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3388", "SEK", "GB", "75", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3389", "SEK", "DE", "70", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3390", "SEK", "DK", "65", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3391", "SEK", "AT", "50", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3392", "SEK", "NO", "55", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3393", "SEK", "CA", "60", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3394", "SEK", "NL", "65", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3395", "SEK", "SE", "50", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3396", "SEK", "IE", "50", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3397", "SEK", "BE", "45", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3398", "SEK", "FI", "35", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3399", "SEK", "FR", "45", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3400", "SEK", "NZ", "45", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3401", "SEK", "HK", "40", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3402", "SEK", "CZ", "40", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3403", "SEK", "SK", "35", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3404", "SEK", "AE", "35", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3405", "SEK", "SG", "45", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3406", "SEK", "IL", "40", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3407", "SEK", "KW", "20", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3408", "SEK", "IT", "25", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3409", "SEK", "JP", "35", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3410", "SEK", "ES", "25", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3411", "SEK", "VE", "5", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3412", "SEK", "HU", "25", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3413", "SEK", "PT", "25", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3414", "SEK", "GR", "30", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3415", "SEK", "KR", "35", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3416", "SEK", "TW", "30", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3417", "SEK", "PL", "25", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3418", "SEK", "ZM", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3419", "SEK", "PR", "10", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3420", "SEK", "CI", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3421", "SEK", "RO", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3422", "SEK", "BH", "10", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3423", "SEK", "PA", "5", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3424", "SEK", "GH", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3425", "SEK", "KH", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3426", "SEK", "SN", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3427", "SEK", "SA", "15", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3428", "SEK", "RU", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3429", "SEK", "UG", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3430", "SEK", "BR", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3431", "SEK", "NI", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3432", "SEK", "MG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3433", "SEK", "DO", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3434", "SEK", "MX", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3435", "SEK", "OM", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3436", "SEK", "CM", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3437", "SEK", "ZA", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3438", "SEK", "CL", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3439", "SEK", "KE", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3440", "SEK", "NP", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3441", "SEK", "PE", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3442", "SEK", "UA", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3443", "SEK", "MZ", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3444", "SEK", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3445", "SEK", "AO", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3446", "SEK", "JO", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3447", "SEK", "ZW", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3448", "SEK", "TR", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3449", "SEK", "MU", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3450", "SEK", "SV", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3451", "SEK", "TH", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3452", "SEK", "CO", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3453", "SEK", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3454", "SEK", "CR", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3455", "SEK", "AR", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3456", "SEK", "MA", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3457", "SEK", "MY", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3458", "SEK", "KZ", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3459", "SEK", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3460", "SEK", "ID", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3461", "SEK", "NG", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3462", "SEK", "GT", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3463", "SEK", "VN", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3464", "SEK", "BY", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3465", "SEK", "EG", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3466", "SEK", "UY", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3467", "SEK", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3468", "SEK", "PK", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3469", "SEK", "PH", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3470", "SEK", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3471", "SEK", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3472", "SEK", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3473", "SEK", "IN", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3474", "SEK", "PY", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3475", "SEK", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3476", "SEK", "EC", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3477", "SEK", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3478", "SEK", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3479", "SGD", "US", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3480", "SGD", "CH", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3481", "SGD", "AU", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3482", "SGD", "GB", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3483", "SGD", "DE", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3484", "SGD", "DK", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3485", "SGD", "AT", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3486", "SGD", "NO", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3487", "SGD", "CA", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3488", "SGD", "NL", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3489", "SGD", "SE", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3490", "SGD", "IE", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3491", "SGD", "BE", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3492", "SGD", "FI", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3493", "SGD", "FR", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3494", "SGD", "NZ", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3495", "SGD", "HK", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3496", "SGD", "CZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3497", "SGD", "SK", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3498", "SGD", "AE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3499", "SGD", "SG", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3500", "SGD", "IL", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3501", "SGD", "KW", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3502", "SGD", "IT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3503", "SGD", "JP", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3504", "SGD", "ES", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3505", "SGD", "VE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3506", "SGD", "HU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3507", "SGD", "PT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3508", "SGD", "GR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3509", "SGD", "KR", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3510", "SGD", "TW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3511", "SGD", "PL", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3512", "SGD", "ZM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3513", "SGD", "PR", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3514", "SGD", "CI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3515", "SGD", "RO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3516", "SGD", "BH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3517", "SGD", "PA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3518", "SGD", "GH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3519", "SGD", "KH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3520", "SGD", "SN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3521", "SGD", "SA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3522", "SGD", "RU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3523", "SGD", "UG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3524", "SGD", "BR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3525", "SGD", "NI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3526", "SGD", "MG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3527", "SGD", "DO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3528", "SGD", "MX", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3529", "SGD", "OM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3530", "SGD", "CM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3531", "SGD", "ZA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3532", "SGD", "CL", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3533", "SGD", "KE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3534", "SGD", "NP", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3535", "SGD", "PE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3536", "SGD", "UA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3537", "SGD", "MZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3538", "SGD", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3539", "SGD", "AO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3540", "SGD", "JO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3541", "SGD", "ZW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3542", "SGD", "TR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3543", "SGD", "MU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3544", "SGD", "SV", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3545", "SGD", "TH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3546", "SGD", "CO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3547", "SGD", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3548", "SGD", "CR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3549", "SGD", "AR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3550", "SGD", "MA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3551", "SGD", "MY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3552", "SGD", "KZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3553", "SGD", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3554", "SGD", "ID", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3555", "SGD", "NG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3556", "SGD", "GT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3557", "SGD", "VN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3558", "SGD", "BY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3559", "SGD", "EG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3560", "SGD", "UY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3561", "SGD", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3562", "SGD", "PK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3563", "SGD", "PH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3564", "SGD", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3565", "SGD", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3566", "SGD", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3567", "SGD", "IN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3568", "SGD", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3569", "SGD", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3570", "SGD", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3571", "SGD", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3572", "SGD", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3573", "THB", "US", "355", "1000");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3574", "THB", "CH", "330", "870");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3575", "THB", "AU", "300", "770");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3576", "THB", "GB", "260", "670");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3577", "THB", "DE", "260", "665");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3578", "THB", "DK", "240", "595");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3579", "THB", "AT", "175", "545");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3580", "THB", "NO", "200", "550");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3581", "THB", "CA", "220", "670");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3582", "THB", "NL", "235", "595");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3583", "THB", "SE", "185", "505");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3584", "THB", "IE", "185", "490");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3585", "THB", "BE", "170", "500");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3586", "THB", "FI", "125", "385");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3587", "THB", "FR", "160", "420");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3588", "THB", "NZ", "160", "475");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3589", "THB", "HK", "145", "415");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3590", "THB", "CZ", "140", "335");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3591", "THB", "SK", "130", "285");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3592", "THB", "AE", "125", "390");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3593", "THB", "SG", "160", "480");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3594", "THB", "IL", "140", "345");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3595", "THB", "KW", "65", "310");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3596", "THB", "IT", "95", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3597", "THB", "JP", "120", "340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3598", "THB", "ES", "100", "260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3599", "THB", "VE", "15", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3600", "THB", "HU", "85", "195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3601", "THB", "PT", "85", "215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3602", "THB", "GR", "100", "210");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3603", "THB", "KR", "125", "335");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3604", "THB", "TW", "105", "275");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3605", "THB", "PL", "90", "215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3606", "THB", "ZM", "15", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3607", "THB", "PR", "30", "290");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3608", "THB", "CI", "15", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3609", "THB", "RO", "80", "195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3610", "THB", "BH", "35", "205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3611", "THB", "PA", "25", "280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3612", "THB", "GH", "30", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3613", "THB", "KH", "15", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3614", "THB", "SN", "10", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3615", "THB", "SA", "55", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3616", "THB", "RU", "50", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3617", "THB", "UG", "10", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3618", "THB", "BR", "55", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3619", "THB", "NI", "10", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3620", "THB", "MG", "10", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3621", "THB", "DO", "15", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3622", "THB", "MX", "40", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3623", "THB", "OM", "25", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3624", "THB", "CM", "10", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3625", "THB", "ZA", "50", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3626", "THB", "CL", "50", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3627", "THB", "KE", "15", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3628", "THB", "NP", "10", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3629", "THB", "PE", "30", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3630", "THB", "UA", "30", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3631", "THB", "MZ", "10", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3632", "THB", "TZ", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3633", "THB", "AO", "25", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3634", "THB", "JO", "20", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3635", "THB", "ZW", "10", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3636", "THB", "TR", "30", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3637", "THB", "MU", "15", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3638", "THB", "SV", "10", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3639", "THB", "TH", "50", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3640", "THB", "CO", "25", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3641", "THB", "LK", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3642", "THB", "CR", "15", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3643", "THB", "AR", "35", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3644", "THB", "MA", "15", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3645", "THB", "MY", "40", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3646", "THB", "KZ", "20", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3647", "THB", "DZ", "15", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3648", "THB", "ID", "35", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3649", "THB", "NG", "20", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3650", "THB", "GT", "15", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3651", "THB", "VN", "30", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3652", "THB", "BY", "15", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3653", "THB", "EG", "20", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3654", "THB", "UY", "15", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3655", "THB", "BD", "15", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3656", "THB", "PK", "15", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3657", "THB", "PH", "25", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3658", "THB", "ET", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3659", "THB", "TN", "15", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3660", "THB", "LB", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3661", "THB", "IN", "15", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3662", "THB", "PY", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3663", "THB", "UZ", "15", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3664", "THB", "EC", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3665", "THB", "MM", "15", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3666", "THB", "GE", "15", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3667", "TRY", "US", "85", "245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3668", "TRY", "CH", "80", "215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3669", "TRY", "AU", "75", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3670", "TRY", "GB", "65", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3671", "TRY", "DE", "65", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3672", "TRY", "DK", "60", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3673", "TRY", "AT", "45", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3674", "TRY", "NO", "50", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3675", "TRY", "CA", "55", "165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3676", "TRY", "NL", "60", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3677", "TRY", "SE", "45", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3678", "TRY", "IE", "45", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3679", "TRY", "BE", "40", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3680", "TRY", "FI", "30", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3681", "TRY", "FR", "40", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3682", "TRY", "NZ", "40", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3683", "TRY", "HK", "35", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3684", "TRY", "CZ", "35", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3685", "TRY", "SK", "30", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3686", "TRY", "AE", "30", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3687", "TRY", "SG", "40", "120");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3688", "TRY", "IL", "35", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3689", "TRY", "KW", "15", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3690", "TRY", "IT", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3691", "TRY", "JP", "30", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3692", "TRY", "ES", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3693", "TRY", "VE", "5", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3694", "TRY", "HU", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3695", "TRY", "PT", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3696", "TRY", "GR", "25", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3697", "TRY", "KR", "30", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3698", "TRY", "TW", "25", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3699", "TRY", "PL", "20", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3700", "TRY", "ZM", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3701", "TRY", "PR", "10", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3702", "TRY", "CI", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3703", "TRY", "RO", "20", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3704", "TRY", "BH", "10", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3705", "TRY", "PA", "5", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3706", "TRY", "GH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3707", "TRY", "KH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3708", "TRY", "SN", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3709", "TRY", "SA", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3710", "TRY", "RU", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3711", "TRY", "UG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3712", "TRY", "BR", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3713", "TRY", "NI", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3714", "TRY", "MG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3715", "TRY", "DO", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3716", "TRY", "MX", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3717", "TRY", "OM", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3718", "TRY", "CM", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3719", "TRY", "ZA", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3720", "TRY", "CL", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3721", "TRY", "KE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3722", "TRY", "NP", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3723", "TRY", "PE", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3724", "TRY", "UA", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3725", "TRY", "MZ", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3726", "TRY", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3727", "TRY", "AO", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3728", "TRY", "JO", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3729", "TRY", "ZW", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3730", "TRY", "TR", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3731", "TRY", "MU", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3732", "TRY", "SV", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3733", "TRY", "TH", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3734", "TRY", "CO", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3735", "TRY", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3736", "TRY", "CR", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3737", "TRY", "AR", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3738", "TRY", "MA", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3739", "TRY", "MY", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3740", "TRY", "KZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3741", "TRY", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3742", "TRY", "ID", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3743", "TRY", "NG", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3744", "TRY", "GT", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3745", "TRY", "VN", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3746", "TRY", "BY", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3747", "TRY", "EG", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3748", "TRY", "UY", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3749", "TRY", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3750", "TRY", "PK", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3751", "TRY", "PH", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3752", "TRY", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3753", "TRY", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3754", "TRY", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3755", "TRY", "IN", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3756", "TRY", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3757", "TRY", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3758", "TRY", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3759", "TRY", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3760", "TRY", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3761", "TWD", "US", "330", "930");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3762", "TWD", "CH", "310", "810");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3763", "TWD", "AU", "280", "720");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3764", "TWD", "GB", "245", "625");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3765", "TWD", "DE", "245", "620");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3766", "TWD", "DK", "225", "555");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3767", "TWD", "AT", "165", "505");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3768", "TWD", "NO", "185", "515");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3769", "TWD", "CA", "205", "625");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3770", "TWD", "NL", "220", "555");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3771", "TWD", "SE", "175", "475");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3772", "TWD", "IE", "175", "455");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3773", "TWD", "BE", "160", "465");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3774", "TWD", "FI", "120", "360");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3775", "TWD", "FR", "145", "395");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3776", "TWD", "NZ", "150", "440");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3777", "TWD", "HK", "135", "385");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3778", "TWD", "CZ", "130", "310");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3779", "TWD", "SK", "125", "265");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3780", "TWD", "AE", "115", "365");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3781", "TWD", "SG", "150", "445");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3782", "TWD", "IL", "130", "320");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3783", "TWD", "KW", "60", "290");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3784", "TWD", "IT", "90", "235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3785", "TWD", "JP", "110", "320");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3786", "TWD", "ES", "90", "245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3787", "TWD", "VE", "10", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3788", "TWD", "HU", "80", "180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3789", "TWD", "PT", "80", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3790", "TWD", "GR", "95", "195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3791", "TWD", "KR", "120", "310");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3792", "TWD", "TW", "95", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3793", "TWD", "PL", "80", "205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3794", "TWD", "ZM", "10", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3795", "TWD", "PR", "30", "270");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3796", "TWD", "CI", "15", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3797", "TWD", "RO", "75", "180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3798", "TWD", "BH", "35", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3799", "TWD", "PA", "25", "260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3800", "TWD", "GH", "25", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3801", "TWD", "KH", "15", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3802", "TWD", "SN", "10", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3803", "TWD", "SA", "50", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3804", "TWD", "RU", "50", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3805", "TWD", "UG", "10", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3806", "TWD", "BR", "50", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3807", "TWD", "NI", "10", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3808", "TWD", "MG", "10", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3809", "TWD", "DO", "15", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3810", "TWD", "MX", "40", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3811", "TWD", "OM", "25", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3812", "TWD", "CM", "10", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3813", "TWD", "ZA", "45", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3814", "TWD", "CL", "50", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3815", "TWD", "KE", "15", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3816", "TWD", "NP", "10", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3817", "TWD", "PE", "30", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3818", "TWD", "UA", "30", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3819", "TWD", "MZ", "10", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3820", "TWD", "TZ", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3821", "TWD", "AO", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3822", "TWD", "JO", "20", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3823", "TWD", "ZW", "10", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3824", "TWD", "TR", "30", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3825", "TWD", "MU", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3826", "TWD", "SV", "10", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3827", "TWD", "TH", "45", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3828", "TWD", "CO", "25", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3829", "TWD", "LK", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3830", "TWD", "CR", "15", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3831", "TWD", "AR", "30", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3832", "TWD", "MA", "15", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3833", "TWD", "MY", "40", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3834", "TWD", "KZ", "15", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3835", "TWD", "DZ", "15", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3836", "TWD", "ID", "35", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3837", "TWD", "NG", "20", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3838", "TWD", "GT", "15", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3839", "TWD", "VN", "30", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3840", "TWD", "BY", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3841", "TWD", "EG", "20", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3842", "TWD", "UY", "15", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3843", "TWD", "BD", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3844", "TWD", "PK", "15", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3845", "TWD", "PH", "20", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3846", "TWD", "ET", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3847", "TWD", "TN", "15", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3848", "TWD", "LB", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3849", "TWD", "IN", "15", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3850", "TWD", "PY", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3851", "TWD", "UZ", "15", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3852", "TWD", "EC", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3853", "TWD", "MM", "15", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3854", "TWD", "GE", "15", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3855", "UAH", "US", "330", "935");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3856", "UAH", "CH", "310", "810");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3857", "UAH", "AU", "280", "720");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3858", "UAH", "GB", "245", "625");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3859", "UAH", "DE", "245", "620");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3860", "UAH", "DK", "225", "555");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3861", "UAH", "AT", "165", "505");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3862", "UAH", "NO", "185", "515");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3863", "UAH", "CA", "205", "625");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3864", "UAH", "NL", "220", "555");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3865", "UAH", "SE", "175", "475");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3866", "UAH", "IE", "175", "455");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3867", "UAH", "BE", "160", "465");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3868", "UAH", "FI", "120", "360");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3869", "UAH", "FR", "145", "395");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3870", "UAH", "NZ", "150", "440");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3871", "UAH", "HK", "135", "385");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3872", "UAH", "CZ", "130", "310");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3873", "UAH", "SK", "125", "265");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3874", "UAH", "AE", "115", "365");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3875", "UAH", "SG", "150", "445");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3876", "UAH", "IL", "130", "325");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3877", "UAH", "KW", "60", "290");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3878", "UAH", "IT", "90", "235");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3879", "UAH", "JP", "115", "320");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3880", "UAH", "ES", "90", "245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3881", "UAH", "VE", "10", "185");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3882", "UAH", "HU", "80", "180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3883", "UAH", "PT", "80", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3884", "UAH", "GR", "95", "195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3885", "UAH", "KR", "120", "315");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3886", "UAH", "TW", "95", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3887", "UAH", "PL", "80", "205");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3888", "UAH", "ZM", "10", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3889", "UAH", "PR", "30", "275");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3890", "UAH", "CI", "15", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3891", "UAH", "RO", "75", "180");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3892", "UAH", "BH", "35", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3893", "UAH", "PA", "25", "260");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3894", "UAH", "GH", "25", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3895", "UAH", "KH", "15", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3896", "UAH", "SN", "10", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3897", "UAH", "SA", "50", "190");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3898", "UAH", "RU", "50", "155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3899", "UAH", "UG", "10", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3900", "UAH", "BR", "50", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3901", "UAH", "NI", "10", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3902", "UAH", "MG", "10", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3903", "UAH", "DO", "15", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3904", "UAH", "MX", "40", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3905", "UAH", "OM", "25", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3906", "UAH", "CM", "10", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3907", "UAH", "ZA", "45", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3908", "UAH", "CL", "50", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3909", "UAH", "KE", "15", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3910", "UAH", "NP", "10", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3911", "UAH", "PE", "30", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3912", "UAH", "UA", "30", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3913", "UAH", "MZ", "10", "115");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3914", "UAH", "TZ", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3915", "UAH", "AO", "25", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3916", "UAH", "JO", "20", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3917", "UAH", "ZW", "10", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3918", "UAH", "TR", "30", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3919", "UAH", "MU", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3920", "UAH", "SV", "10", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3921", "UAH", "TH", "45", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3922", "UAH", "CO", "25", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3923", "UAH", "LK", "10", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3924", "UAH", "CR", "15", "90");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3925", "UAH", "AR", "30", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3926", "UAH", "MA", "15", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3927", "UAH", "MY", "40", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3928", "UAH", "KZ", "15", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3929", "UAH", "DZ", "15", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3930", "UAH", "ID", "35", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3931", "UAH", "NG", "20", "125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3932", "UAH", "GT", "15", "95");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3933", "UAH", "VN", "30", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3934", "UAH", "BY", "15", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3935", "UAH", "EG", "20", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3936", "UAH", "UY", "15", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3937", "UAH", "BD", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3938", "UAH", "PK", "15", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3939", "UAH", "PH", "20", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3940", "UAH", "ET", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3941", "UAH", "TN", "15", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3942", "UAH", "LB", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3943", "UAH", "IN", "15", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3944", "UAH", "PY", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3945", "UAH", "UZ", "15", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3946", "UAH", "EC", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3947", "UAH", "MM", "15", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3948", "UAH", "GE", "15", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3949", "USD", "US", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3950", "USD", "CH", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3951", "USD", "AU", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3952", "USD", "GB", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3953", "USD", "DE", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3954", "USD", "DK", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3955", "USD", "AT", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3956", "USD", "NO", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3957", "USD", "CA", "5", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3958", "USD", "NL", "10", "20");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3959", "USD", "SE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3960", "USD", "IE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3961", "USD", "BE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3962", "USD", "FI", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3963", "USD", "FR", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3964", "USD", "NZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3965", "USD", "HK", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3966", "USD", "CZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3967", "USD", "SK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3968", "USD", "AE", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3969", "USD", "SG", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3970", "USD", "IL", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3971", "USD", "KW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3972", "USD", "IT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3973", "USD", "JP", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3974", "USD", "ES", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3975", "USD", "VE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3976", "USD", "HU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3977", "USD", "PT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3978", "USD", "GR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3979", "USD", "KR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3980", "USD", "TW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3981", "USD", "PL", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3982", "USD", "ZM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3983", "USD", "PR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3984", "USD", "CI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3985", "USD", "RO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3986", "USD", "BH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3987", "USD", "PA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3988", "USD", "GH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3989", "USD", "KH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3990", "USD", "SN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3991", "USD", "SA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3992", "USD", "RU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3993", "USD", "UG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3994", "USD", "BR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3995", "USD", "NI", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3996", "USD", "MG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3997", "USD", "DO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3998", "USD", "MX", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("3999", "USD", "OM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4000", "USD", "CM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4001", "USD", "ZA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4002", "USD", "CL", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4003", "USD", "KE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4004", "USD", "NP", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4005", "USD", "PE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4006", "USD", "UA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4007", "USD", "MZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4008", "USD", "TZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4009", "USD", "AO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4010", "USD", "JO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4011", "USD", "ZW", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4012", "USD", "TR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4013", "USD", "MU", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4014", "USD", "SV", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4015", "USD", "TH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4016", "USD", "CO", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4017", "USD", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4018", "USD", "CR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4019", "USD", "AR", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4020", "USD", "MA", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4021", "USD", "MY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4022", "USD", "KZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4023", "USD", "DZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4024", "USD", "ID", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4025", "USD", "NG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4026", "USD", "GT", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4027", "USD", "VN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4028", "USD", "BY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4029", "USD", "EG", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4030", "USD", "UY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4031", "USD", "BD", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4032", "USD", "PK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4033", "USD", "PH", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4034", "USD", "ET", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4035", "USD", "TN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4036", "USD", "LB", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4037", "USD", "IN", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4038", "USD", "PY", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4039", "USD", "UZ", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4040", "USD", "EC", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4041", "USD", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4042", "USD", "GE", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4043", "VND", "US", "272110", "767785");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4044", "VND", "CH", "253755", "667740");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4045", "VND", "AU", "230890", "592820");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4046", "VND", "GB", "201305", "515160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4047", "VND", "DE", "199775", "510995");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4048", "VND", "DK", "183805", "456155");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4049", "VND", "AT", "134120", "416790");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4050", "VND", "NO", "152020", "424445");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4051", "VND", "CA", "168050", "515320");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4052", "VND", "NL", "179795", "456340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4053", "VND", "SE", "143915", "389175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4054", "VND", "IE", "142415", "375410");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4055", "VND", "BE", "130965", "383820");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4056", "VND", "FI", "97910", "297340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4057", "VND", "FR", "121230", "324500");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4058", "VND", "NZ", "123385", "363230");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4059", "VND", "HK", "112205", "317315");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4060", "VND", "CZ", "106975", "256825");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4061", "VND", "SK", "100925", "218725");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4062", "VND", "AE", "95240", "298900");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4063", "VND", "SG", "124270", "367275");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4064", "VND", "IL", "108450", "265275");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4065", "VND", "KW", "48915", "238435");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4066", "VND", "IT", "73820", "194880");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4067", "VND", "JP", "92560", "263055");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4068", "VND", "ES", "75885", "200680");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4069", "VND", "VE", "9950", "153710");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4070", "VND", "HU", "63945", "148785");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4071", "VND", "PT", "63835", "166400");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4072", "VND", "GR", "78710", "161200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4073", "VND", "KR", "97045", "256985");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4074", "VND", "TW", "78875", "211150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4075", "VND", "PL", "67490", "167065");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4076", "VND", "ZM", "9745", "55615");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4077", "VND", "PR", "23840", "224105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4078", "VND", "CI", "13010", "53765");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4079", "VND", "RO", "61995", "150005");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4080", "VND", "BH", "28150", "156065");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4081", "VND", "PA", "18855", "214215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4082", "VND", "GH", "22600", "63065");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4083", "VND", "KH", "13030", "62565");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4084", "VND", "SN", "9485", "67975");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4085", "VND", "SA", "40465", "154935");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4086", "VND", "RU", "40215", "128320");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4087", "VND", "UG", "9450", "49675");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4088", "VND", "BR", "42875", "105710");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4089", "VND", "NI", "9430", "67690");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4090", "VND", "MG", "9540", "47985");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4091", "VND", "DO", "11440", "79555");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4092", "VND", "MX", "32330", "117005");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4093", "VND", "OM", "20325", "117010");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4094", "VND", "CM", "9415", "87195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4095", "VND", "ZA", "38525", "124000");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4096", "VND", "CL", "40140", "119955");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4097", "VND", "KE", "11585", "50070");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4098", "VND", "NP", "9415", "45480");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4099", "VND", "PE", "23975", "100915");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4100", "VND", "UA", "22855", "71385");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4101", "VND", "MZ", "9415", "94695");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4102", "VND", "TZ", "1190", "21730");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4103", "VND", "AO", "20880", "54445");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4104", "VND", "JO", "15395", "73125");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4105", "VND", "ZW", "9465", "51890");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4106", "VND", "TR", "24525", "67110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4107", "VND", "MU", "12560", "42925");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4108", "VND", "SV", "9415", "51990");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4109", "VND", "TH", "36795", "115775");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4110", "VND", "CO", "18660", "72220");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4111", "VND", "LK", "9060", "12515");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4112", "VND", "CR", "11375", "75570");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4113", "VND", "AR", "25410", "68830");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4114", "VND", "MA", "11350", "44545");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4115", "VND", "MY", "32200", "118425");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4116", "VND", "KZ", "13775", "50410");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4117", "VND", "DZ", "11290", "23900");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4118", "VND", "ID", "28735", "106590");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4119", "VND", "NG", "16150", "102165");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4120", "VND", "GT", "11315", "80010");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4121", "VND", "VN", "23510", "89095");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4122", "VND", "BY", "11040", "42975");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4123", "VND", "EG", "14885", "90930");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4124", "VND", "UY", "11735", "54085");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4125", "VND", "BD", "9660", "21390");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4126", "VND", "PK", "10595", "60980");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4127", "VND", "PH", "18345", "67700");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4128", "VND", "ET", "2945", "22425");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4129", "VND", "TN", "11305", "20480");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4130", "VND", "LB", "11410", "34110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4131", "VND", "IN", "10520", "47520");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4132", "VND", "PY", "11310", "36360");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4133", "VND", "UZ", "11315", "22075");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4134", "VND", "EC", "10995", "37710");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4135", "VND", "MM", "11315", "12360");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4136", "VND", "GE", "11355", "14470");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4137", "ZAR", "US", "180", "510");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4138", "ZAR", "CH", "170", "440");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4139", "ZAR", "AU", "155", "390");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4140", "ZAR", "GB", "135", "340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4141", "ZAR", "DE", "130", "340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4142", "ZAR", "DK", "120", "300");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4143", "ZAR", "AT", "90", "275");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4144", "ZAR", "NO", "100", "280");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4145", "ZAR", "CA", "110", "340");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4146", "ZAR", "NL", "120", "300");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4147", "ZAR", "SE", "95", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4148", "ZAR", "IE", "95", "250");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4149", "ZAR", "BE", "85", "255");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4150", "ZAR", "FI", "65", "195");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4151", "ZAR", "FR", "80", "215");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4152", "ZAR", "NZ", "80", "240");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4153", "ZAR", "HK", "75", "210");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4154", "ZAR", "CZ", "70", "170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4155", "ZAR", "SK", "65", "145");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4156", "ZAR", "AE", "65", "200");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4157", "ZAR", "SG", "80", "245");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4158", "ZAR", "IL", "70", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4159", "ZAR", "KW", "30", "160");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4160", "ZAR", "IT", "50", "130");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4161", "ZAR", "JP", "60", "175");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4162", "ZAR", "ES", "50", "135");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4163", "ZAR", "VE", "5", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4164", "ZAR", "HU", "40", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4165", "ZAR", "PT", "40", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4166", "ZAR", "GR", "50", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4167", "ZAR", "KR", "65", "170");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4168", "ZAR", "TW", "50", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4169", "ZAR", "PL", "45", "110");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4170", "ZAR", "ZM", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4171", "ZAR", "PR", "15", "150");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4172", "ZAR", "CI", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4173", "ZAR", "RO", "40", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4174", "ZAR", "BH", "20", "105");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4175", "ZAR", "PA", "10", "140");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4176", "ZAR", "GH", "15", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4177", "ZAR", "KH", "10", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4178", "ZAR", "SN", "5", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4179", "ZAR", "SA", "25", "100");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4180", "ZAR", "RU", "25", "85");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4181", "ZAR", "UG", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4182", "ZAR", "BR", "30", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4183", "ZAR", "NI", "5", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4184", "ZAR", "MG", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4185", "ZAR", "DO", "10", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4186", "ZAR", "MX", "20", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4187", "ZAR", "OM", "15", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4188", "ZAR", "CM", "5", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4189", "ZAR", "ZA", "25", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4190", "ZAR", "CL", "25", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4191", "ZAR", "KE", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4192", "ZAR", "NP", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4193", "ZAR", "PE", "15", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4194", "ZAR", "UA", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4195", "ZAR", "MZ", "5", "65");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4196", "ZAR", "TZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4197", "ZAR", "AO", "15", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4198", "ZAR", "JO", "10", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4199", "ZAR", "ZW", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4200", "ZAR", "TR", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4201", "ZAR", "MU", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4202", "ZAR", "SV", "5", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4203", "ZAR", "TH", "25", "75");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4204", "ZAR", "CO", "10", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4205", "ZAR", "LK", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4206", "ZAR", "CR", "10", "50");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4207", "ZAR", "AR", "15", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4208", "ZAR", "MA", "10", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4209", "ZAR", "MY", "20", "80");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4210", "ZAR", "KZ", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4211", "ZAR", "DZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4212", "ZAR", "ID", "20", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4213", "ZAR", "NG", "10", "70");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4214", "ZAR", "GT", "5", "55");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4215", "ZAR", "VN", "15", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4216", "ZAR", "BY", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4217", "ZAR", "EG", "10", "60");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4218", "ZAR", "UY", "10", "35");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4219", "ZAR", "BD", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4220", "ZAR", "PK", "5", "40");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4221", "ZAR", "PH", "10", "45");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4222", "ZAR", "ET", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4223", "ZAR", "TN", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4224", "ZAR", "LB", "10", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4225", "ZAR", "IN", "5", "30");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4226", "ZAR", "PY", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4227", "ZAR", "UZ", "5", "15");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4228", "ZAR", "EC", "5", "25");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4229", "ZAR", "MM", "5", "10");
INSERT INTO `wp_gla_budget_recommendations` VALUES("4230", "ZAR", "GE", "10", "15");

/* INSERT TABLE DATA: wp_mailpoet_newsletter_option_fields */
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("1", "isScheduled", "standard", NULL, "2022-02-27 09:44:15");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("2", "scheduledAt", "standard", NULL, "2022-02-27 09:44:15");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("3", "event", "welcome", NULL, "2022-02-27 09:44:15");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("4", "segment", "welcome", NULL, "2022-02-27 09:44:15");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("5", "role", "welcome", NULL, "2022-02-27 09:44:15");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("6", "afterTimeNumber", "welcome", NULL, "2022-02-27 09:44:15");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("7", "afterTimeType", "welcome", NULL, "2022-02-27 09:44:15");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("8", "intervalType", "notification", NULL, "2022-02-27 09:44:15");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("9", "timeOfDay", "notification", NULL, "2022-02-27 09:44:15");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("10", "weekDay", "notification", NULL, "2022-02-27 09:44:15");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("11", "monthDay", "notification", NULL, "2022-02-27 09:44:15");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("12", "nthWeekDay", "notification", NULL, "2022-02-27 09:44:15");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("13", "schedule", "notification", NULL, "2022-02-27 09:44:15");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("14", "group", "automatic", NULL, "2022-02-27 09:44:15");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("15", "event", "automatic", NULL, "2022-02-27 09:44:15");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("16", "sendTo", "automatic", NULL, "2022-02-27 09:44:15");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("17", "segment", "automatic", NULL, "2022-02-27 09:44:15");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("18", "afterTimeNumber", "automatic", NULL, "2022-02-27 09:44:15");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("19", "afterTimeType", "automatic", NULL, "2022-02-27 09:44:15");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("20", "meta", "automatic", NULL, "2022-02-27 09:44:15");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("21", "afterTimeNumber", "re_engagement", NULL, "2022-02-27 09:44:15");
INSERT INTO `wp_mailpoet_newsletter_option_fields` VALUES("22", "afterTimeType", "re_engagement", NULL, "2022-02-27 09:44:16");

/* INSERT TABLE DATA: wp_mailpoet_newsletter_templates */
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("1", "0", "ایمیل خوش آمد گویی: نمونه خالی با الگوی 1 ستون", "[\"welcome\",\"blank\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/blank_templates\\/fake-logo.png\",\"alt\":\"\\u0622\\u0631\\u0645 \\u062c\\u0639\\u0644\\u06cc\",\"fullWidth\":false,\"width\":\"598px\",\"height\":\"71px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>\\u0633\\u0644\\u0627\\u0645\\u060c \\u0645\\u0634\\u062a\\u0631\\u06a9 \\u062c\\u062f\\u06cc\\u062f!<\\/strong><\\/h1>\\n<p>&nbsp;<\\/p>\\n<p>[subscriber:firstname | default:Subscriber],<\\/p>\\n<p>&nbsp;<\\/p>\\n<p>\\u0634\\u0645\\u0627 \\u0628\\u0647 \\u062a\\u0627\\u0632\\u06af\\u06cc \\u0628\\u0647 \\u0644\\u06cc\\u0633\\u062a \\u0645\\u0627 \\u067e\\u06cc\\u0648\\u0633\\u062a\\u0647 \\u0627\\u06cc\\u062f \\u0648 \\u0645\\u0627 \\u0645\\u06cc \\u062e\\u0648\\u0627\\u0647\\u06cc\\u0645 \\u0627\\u0632 \\u0634\\u0645\\u0627 \\u06cc\\u06a9 \\u0627\\u0633\\u062a\\u0642\\u0628\\u0627\\u0644 \\u06af\\u0631\\u0645 \\u062f\\u0627\\u0634\\u062a\\u0647 \\u0628\\u0627\\u0634\\u06cc\\u0645!<\\/p>\\n<p>&nbsp;<\\/p>\\n<p>\\u0645\\u06cc \\u062e\\u0648\\u0627\\u0647\\u06cc\\u062f \\u0627\\u0637\\u0644\\u0627\\u0639\\u0627\\u062a \\u0628\\u0647\\u062a\\u0631\\u06cc \\u0627\\u0632 \\u0645\\u0627 \\u062f\\u0631\\u06cc\\u0627\\u0641\\u062a \\u06a9\\u0646\\u06cc\\u062f\\u061f \\u0628\\u0631\\u062e\\u06cc \\u0627\\u0632 \\u0645\\u062d\\u0628\\u0648\\u0628 \\u062a\\u0631\\u06cc\\u0646 \\u0645\\u0642\\u0627\\u0644\\u0627\\u062a \\u0645\\u0627 \\u0631\\u0627 \\u0628\\u0631\\u0631\\u0633\\u06cc \\u06a9\\u0646\\u06cc\\u062f: <\\/p>\\n<ol>\\n<li><a href=\\\"http:\\/\\/www.mailpoet.com\\/the-importance-of-focus-when-writing\\/\\\">\\u0627\\u0647\\u0645\\u06cc\\u062a \\u062a\\u0645\\u0631\\u06a9\\u0632 \\u0647\\u0646\\u06af\\u0627\\u0645 \\u0646\\u0648\\u0634\\u062a\\u0646<\\/a><\\/li>\\n<li><a href=\\\"http:\\/\\/www.mailpoet.com\\/write-great-subject-line\\/\\\">\\u0686\\u06af\\u0648\\u0646\\u0647 \\u06cc\\u06a9 \\u062e\\u0637 \\u0645\\u0648\\u0636\\u0648\\u0639 \\u0628\\u0631\\u062c\\u0633\\u062a\\u0647 \\u0628\\u0646\\u0648\\u06cc\\u0633\\u06cc\\u0645\\u061f<\\/a><\\/li>\\n<li><a href=\\\"http:\\/\\/www.mailpoet.com\\/just-sit-write-advice-motivation-ernest-hemingway\\/\\\">\\u0641\\u0642\\u0637 \\u0628\\u0646\\u0634\\u06cc\\u0646\\u06cc\\u062f \\u0648 \\u0628\\u0646\\u0648\\u06cc\\u0633\\u06cc\\u062f &ndash;  \\u0645\\u0634\\u0627\\u0648\\u0631\\u0647 \\u062f\\u0631 \\u0645\\u0648\\u0631\\u062f \\u0627\\u0646\\u06af\\u06cc\\u0632\\u0647 \\u0627\\u0632 \\u0627\\u0631\\u0646\\u0633\\u062a \\u0647\\u0645\\u06cc\\u0646\\u06af\\u0648\\u06cc<\\/a><\\/li>\\n<\\/ol>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"24.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/welcome-email-blank-1-column/thumbnail.20190411-1500.jpg", NULL, "1", NULL, "2023-05-24 13:18:22");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("2", "0", "ایمیل خوش آمد گویی: نمونه خالی با الگوی 1:2 ستون", "[\"welcome\",\"blank\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/blank_templates\\/fake-logo.png\",\"alt\":\"\\u0622\\u0631\\u0645 \\u062c\\u0639\\u0644\\u06cc\",\"fullWidth\":false,\"width\":\"598px\",\"height\":\"71px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>\\u0633\\u0644\\u0627\\u0645\\u060c \\u0645\\u0634\\u062a\\u0631\\u06a9 \\u062c\\u062f\\u06cc\\u062f!<\\/strong><\\/h1>\\n<p>&nbsp;<\\/p>\\n<p>[subscriber:firstname | default:Subscriber],<\\/p>\\n<p>&nbsp;<\\/p>\\n<p>\\u0634\\u0645\\u0627 \\u0628\\u0647 \\u062a\\u0627\\u0632\\u06af\\u06cc \\u0628\\u0647 \\u0644\\u06cc\\u0633\\u062a \\u0645\\u0627 \\u067e\\u06cc\\u0648\\u0633\\u062a\\u0647 \\u0627\\u06cc\\u062f \\u0648 \\u0645\\u0627 \\u0645\\u06cc \\u062e\\u0648\\u0627\\u0647\\u06cc\\u0645 \\u0627\\u0632 \\u0634\\u0645\\u0627 \\u06cc\\u06a9 \\u0627\\u0633\\u062a\\u0642\\u0628\\u0627\\u0644 \\u06af\\u0631\\u0645 \\u062f\\u0627\\u0634\\u062a\\u0647 \\u0628\\u0627\\u0634\\u06cc\\u0645!<\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>\\u0645\\u062d\\u0628\\u0648\\u0628 \\u062a\\u0631\\u06cc\\u0646 \\u067e\\u0633\\u062a \\u0647\\u0627\\u06cc \\u0645\\u0627<\\/h3>\"},{\"type\":\"text\",\"text\":\"<ul>\\n<li><a href=\\\"http:\\/\\/www.mailpoet.com\\/the-importance-of-focus-when-writing\\/\\\">\\u0627\\u0647\\u0645\\u06cc\\u062a \\u062a\\u0645\\u0631\\u06a9\\u0632 \\u062f\\u0631 \\u0647\\u0646\\u06af\\u0627\\u0645 \\u0646\\u0648\\u0634\\u062a\\u0646<\\/a><\\/li>\\n<li><a href=\\\"http:\\/\\/www.mailpoet.com\\/write-great-subject-line\\/\\\">\\u0686\\u06af\\u0648\\u0646\\u06af\\u06cc \\u0646\\u0648\\u0634\\u062a\\u0646 \\u06cc\\u06a9 \\u062e\\u0637 \\u0645\\u0648\\u0636\\u0648\\u0639 \\u0628\\u0632\\u0631\\u06af<\\/a><\\/li>\\n<li><a href=\\\"http:\\/\\/www.mailpoet.com\\/just-sit-write-advice-motivation-ernest-hemingway\\/\\\">\\u0641\\u0642\\u0637 \\u0628\\u0646\\u0634\\u06cc\\u0646\\u06cc\\u062f \\u0648 \\u0628\\u0646\\u0648\\u06cc\\u0633\\u06cc\\u062f &ndash;  \\u0645\\u0634\\u0627\\u0648\\u0631\\u0647 \\u062f\\u0631 \\u0645\\u0648\\u0631\\u062f \\u0627\\u0646\\u06af\\u06cc\\u0632\\u0647 \\u0627\\u0632 \\u0627\\u0631\\u0646\\u0633\\u062a \\u0647\\u0645\\u06cc\\u0646\\u06af\\u0648\\u06cc <\\/a><\\/li>\\n<\\/ul>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>\\u0628\\u0639\\u062f\\u06cc \\u0686\\u06cc\\u0633\\u062a\\u061f<\\/h3>\"},{\"type\":\"text\",\"text\":\"<p>\\u06cc\\u06a9 \\u062f\\u06a9\\u0645\\u0647 \\u0628\\u0647 \\u0645\\u0646\\u0638\\u0648\\u0631 \\u062f\\u0639\\u0648\\u062a \\u0628\\u0647 \\u0627\\u0642\\u062f\\u0627\\u0645 \\u0628\\u0647 \\u062e\\u0628\\u0631\\u0646\\u0627\\u0645\\u0647 \\u062e\\u0648\\u062f \\u0627\\u0636\\u0627\\u0641\\u0647 \\u06a9\\u0646\\u06cc\\u062f. \\u0627\\u06cc\\u0646 \\u06a9\\u0627\\u0631 \\u0646\\u0631\\u062e \\u06a9\\u0644\\u06cc\\u06a9 \\u0634\\u062f\\u0646 \\u0627\\u06cc\\u0645\\u06cc\\u0644 \\u0634\\u0645\\u0627 \\u0631\\u0627 \\u0627\\u0641\\u0632\\u0627\\u06cc\\u0634 \\u0645\\u06cc \\u062f\\u0647\\u062f.<\\/p>\"},{\"type\":\"button\",\"text\":\"\\u062f\\u0641\\u0639\\u0627\\u062a \\u0628\\u0627\\u0632\\u062f\\u06cc\\u062f!\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"24.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"26px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/welcome-email-blank-1-2-column/thumbnail.20190411-1500.jpg", NULL, "1", NULL, "2023-05-24 13:18:22");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("3", "0", "Gift Welcome", "[\"welcome\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/gift\\/Gift-Header-1.jpg\",\"alt\":\"Gift-Header-1\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"920px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#e7e7e7\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #dd2d2d;\\\">We\'re so happy you\'re onboard!<\\/span><\\/h2>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra. Pellentesque in interdum eros, a venenatis velit. Fusce finibus convallis augue, ut viverra felis placerat in. <\\/span><\\/p>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\"><\\/span><\\/p>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\">Curabitur et commodo ipsum. Mauris tellus metus, tristique vel sollicitudin ut, malesuada in augue. Aliquam ultricies purus vel commodo vehicula.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Get Started\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#dd2d2d\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/gift\\/Gift-Footer.jpg\",\"alt\":\"Gift-Footer\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"920px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"23px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"font-size: 11px; text-align: center;\\\"><span style=\\\"color: #808080;\\\"><strong>Address Line 1<\\/strong><\\/span><\\/p>\\n<p style=\\\"font-size: 11px; text-align: center;\\\"><span style=\\\"color: #808080;\\\"><strong>Address Line 2<\\/strong><\\/span><\\/p>\\n<p style=\\\"font-size: 11px; text-align: center;\\\"><span style=\\\"color: #808080;\\\"><strong>City<\\/strong><\\/span><\\/p>\\n<p style=\\\"font-size: 11px; text-align: center;\\\"><span style=\\\"color: #808080;\\\"><strong>Country<\\/strong><\\/span><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"5.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Instagram.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 11px;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a><span>&nbsp;|&nbsp;<\\/span><a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/p>\"}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#dd2d2d\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#ffffff\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/gift/thumbnail.20190411-1500.jpg", NULL, "1", NULL, "2023-05-24 13:18:22");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("4", "0", "Minimal", "[\"welcome\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"29px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#303c54\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"60px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/minimal\\/Minimal-Logo1.png\",\"alt\":\"Minimal-Logo1\",\"fullWidth\":false,\"width\":\"590px\",\"height\":\"93px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"60px\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"80px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: right;\\\"><span style=\\\"color: #8b9cbc;\\\">EST.2009<\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"41px\"}}},{\"type\":\"text\",\"text\":\"<h2>Welcome to Minimal, Kim.<\\/h2>\"},{\"type\":\"text\",\"text\":\"<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra. Pellentesque in interdum eros, a venenatis velit. Fusce finibus convallis augue, ut viverra felis placerat in. Curabitur et commodo ipsum. Mauris tellus metus, tristique vel sollicitudin ut, malesuada in augue. Aliquam ultricies purus vel commodo vehicula. Cras sollicitudin nunc facilisis neque tristique sagittis.<\\/p>\\n<p><\\/p>\\n<p>Maecenas iaculis, lacus malesuada dictum dapibus, justo justo molestie lorem, ac dapibus magna urna vel arcu. Aliquam erat volutpat. Sed bibendum, ipsum sed ullamcorper blandit, eros odio interdum nibh, non venenatis metus lacus vitae lectus.<\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"30px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"2px\",\"borderColor\":\"#d9d9d9\"}}},{\"type\":\"text\",\"text\":\"<h2>Some of our recent stories<\\/h2>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/minimal\\/plasma-stingray111-800x533.jpg\",\"alt\":\"plasma-stingray111-800x533\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"533px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>Story Title Goes Here<\\/h3>\\n<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra.<\\/span><\\/p>\\n<p><span><\\/span><\\/p>\\n<p><strong><a href=\\\"https:\\/\\/wordpress.org\\/\\\">Read More<\\/a><\\/strong><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/minimal\\/gettyimages-578313682-800x533.jpg\",\"alt\":\"gettyimages-578313682-800x533\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"533px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>Story Title Goes Here<\\/h3>\\n<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra.<\\/span><\\/p>\\n<p><span><\\/span><\\/p>\\n<p><strong><a href=\\\"https:\\/\\/wordpress.org\\/\\\">Read More<\\/a><\\/strong><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/minimal\\/5_what_to_do_p352m1141746-800x533.jpg\",\"alt\":\"5_what_to_do_p352m1141746-800x533\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"533px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3>Story Title Goes Here<\\/h3>\\n<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra.<\\/span><\\/p>\\n<p><span><\\/span><\\/p>\\n<p><strong><a href=\\\"https:\\/\\/wordpress.org\\/\\\">Read More<\\/a><\\/strong><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"35px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f3f3f3\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"47px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/minimal\\/Minimal-Logo-Small.png\",\"alt\":\"Minimal-Logo-Small\",\"fullWidth\":false,\"width\":\"120px\",\"height\":\"23px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-color\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Instagram.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #808080;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #808080;\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a><\\/span><\\/p>\\n<p><span style=\\\"color: #808080;\\\"><a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #808080;\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/span><br \\/><span style=\\\"color: #999999;\\\">\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f3f3f3\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Georgia\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Georgia\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Georgia\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Georgia\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#303c54\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#ffffff\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Button\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"30px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"2px\",\"borderColor\":\"#d9d9d9\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png?mailpoet_version=3.8.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png?mailpoet_version=3.8.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"29px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/minimal/thumbnail.20190411-1500.jpg", NULL, "1", NULL, "2023-05-24 13:18:22");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("5", "0", "New Phone Purchase", "[\"welcome\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#1b1821\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/phone\\/Phone-Logo.png\",\"alt\":\"Phone-Logo\",\"fullWidth\":true,\"width\":\"122px\",\"height\":\"23px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#1b1821\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/phone\\/Phone-Title.png\",\"alt\":\"Phone-Title\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"215px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/phone\\/Phone-Header.jpg\",\"alt\":\"Phone-Header\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"920px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\"><strong>Welcome to your brand new Casia 7200.<\\/strong><\\/span><\\/h3>\\n<p style=\\\"text-align: center;\\\"><strong><span style=\\\"color: #8748d5;\\\">Let\'s get you all set up.<\\/span><\\/strong><\\/p>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #999999;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra. Pellentesque in interdum eros, a venenatis velit. Fusce finibus convallis augue, ut viverra felis placerat in.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Get Started\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#8748d5\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"159px\",\"lineHeight\":\"45px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#2c2c2c\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"font-size: 11px; text-align: left;\\\"><span style=\\\"color: #999999;\\\">Address Line 1<\\/span><\\/p>\\n<p style=\\\"font-size: 11px; text-align: left;\\\"><span style=\\\"color: #999999;\\\">Address Line 2<\\/span><\\/p>\\n<p style=\\\"font-size: 11px; text-align: left;\\\"><span style=\\\"color: #999999;\\\">City<\\/span><\\/p>\\n<p style=\\\"font-size: 11px; text-align: left;\\\"><span style=\\\"color: #999999;\\\">Country<\\/span><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/phone\\/Phone-Logo.png\",\"alt\":\"Phone-Logo\",\"fullWidth\":false,\"width\":\"122px\",\"height\":\"23px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"pinterest\",\"link\":\"http:\\/\\/www.pinterest.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Pinterest.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Pinterest\"},{\"type\":\"socialIcon\",\"iconType\":\"linkedin\",\"link\":\"http:\\/\\/www.linkedin.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/LinkedIn.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"LinkedIn\"}]}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: right; font-size: 11px;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a><\\/p>\\n<p style=\\\"text-align: right; font-size: 11px;\\\"><a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/p>\"}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#8748d5\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#1b1821\"},\"body\":{\"backgroundColor\":\"#1b1821\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Button\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png?mailpoet_version=3.9.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png?mailpoet_version=3.9.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/phone/thumbnail.20190411-1500.jpg", NULL, "1", NULL, "2023-05-24 13:18:22");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("6", "0", "Sunglasses", "[\"welcome\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/sunglasses\\/Glasses-Logo.jpg\",\"alt\":\"Glasses-Logo\",\"fullWidth\":false,\"width\":\"250px\",\"height\":\"66px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"padding\":\"17px\",\"borderStyle\":\"solid\",\"borderWidth\":\"2px\",\"borderColor\":\"#f8b849\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/sunglasses\\/Glasses-Header-2.jpg\",\"alt\":\"Glasses-Header-2\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"116px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\"><strong>Here\'s what we sent you<\\/strong><\\/span><\\/h3>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/sunglasses\\/Glasses-Images-1.jpg\",\"alt\":\"Glasses-Images-1\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"650px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Choose These Frames\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8b849\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"195px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/sunglasses\\/Glasses-Images-2.jpg\",\"alt\":\"Glasses-Images-2\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"650px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Choose These Frames\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8b849\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"195px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/sunglasses\\/Glasses-Images-3.jpg\",\"alt\":\"Glasses-Images-3\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"650px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Choose These Frames\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8b849\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"195px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"padding\":\"34.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"2px\",\"borderColor\":\"#f8b849\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/sunglasses\\/Glasses-Header.jpg\",\"alt\":\"Glasses-Header\",\"fullWidth\":true,\"width\":\"640px\",\"height\":\"920px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"60px\"}}},{\"type\":\"text\",\"text\":\"<h3><strong>Our Summer Range Is Here<\\/strong><\\/h3>\\n<p>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex pulvinar molestie. Sed pulvinar placerat justo eu viverra. Pellentesque in interdum eros, a venenatis velit.<\\/p>\\n<p><\\/p>\\n<p>Fusce finibus convallis augue, ut viverra felis placerat in. Curabitur et commodo ipsum. Mauris tellus metus, tristique vel sollicitudin ut, malesuada in augue.&nbsp;<\\/p>\"},{\"type\":\"button\",\"text\":\"Find Out More\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8b849\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"137px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"padding\":\"34.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"2px\",\"borderColor\":\"#f8b849\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\"><strong>Got any questions or need some help?<\\/strong><\\/span><\\/h2>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\">We\'re just a click or a phone call away.<\\/span><\\/p>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\"><\\/span><\\/p>\\n<h3 style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\"><strong>Call Us:<\\/strong> 08856877854<\\/span><\\/h3>\\n<h3 style=\\\"text-align: center;\\\"><\\/h3>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"padding\":\"23.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"2px\",\"borderColor\":\"#f8b849\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Email.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"}]},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 11px;\\\"><strong><span style=\\\"color: #808080;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #808080;\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a>&nbsp;|&nbsp;<a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #808080;\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/span><\\/strong><br \\/><span style=\\\"color: #808080;\\\">\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/span><\\/p>\"}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#ffffff\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/sunglasses/thumbnail.20190411-1500.jpg", NULL, "1", NULL, "2023-05-24 13:18:22");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("7", "0", "Real Estate", "[\"welcome\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#8691be\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/real-estate\\/Property-Logo-1-150x84.jpg\",\"alt\":\"Property-Logo-1\",\"fullWidth\":false,\"width\":\"150px\",\"height\":\"84px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"25px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Website.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#8691be\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"25px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><strong><span style=\\\"color: #ffffff;\\\">TAKING&nbsp;THE WORRY OUT OF REAL ESTATE<\\/span><\\/strong><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">Welcome Home<\\/span><\\/h1>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/real-estate\\/Property-Header.jpg\",\"alt\":\"Property-Header\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"782px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"35px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\">We\'re here to help you move<\\/h3>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/real-estate\\/Property-Icon-1.png\",\"alt\":\"Property-Icon-1\",\"fullWidth\":false,\"width\":\"48px\",\"height\":\"48px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 12px;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex.<\\/span><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/real-estate\\/Property-Icon-2.png\",\"alt\":\"Property-Icon-2\",\"fullWidth\":false,\"width\":\"48px\",\"height\":\"48px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 12px;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex.<\\/span><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/real-estate\\/Property-Icon-3.png\",\"alt\":\"Property-Icon-3\",\"fullWidth\":false,\"width\":\"48px\",\"height\":\"48px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 12px;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur nec nisi quis ex.<\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"22.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#8691be\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\">We\'d love to keep you updated with our latest news. <\\/span><\\/p>\\n<p style=\\\"text-align: center;\\\"><span style=\\\"color: #333333;\\\">Sign up to our newsletter now and you\'ll never miss a thing.<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Sign Up Now\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#8691be\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"24px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#6a7087\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"25px\"}}},{\"type\":\"footer\",\"text\":\"<p><strong><span style=\\\"color: #ffffff;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #ffffff;\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #ffffff;\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/span><\\/strong><br \\/><span style=\\\"color: #ffffff;\\\">\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"40px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#6a7087\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Button\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png?mailpoet_version=3.8.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png?mailpoet_version=3.8.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/real-estate/thumbnail.20190411-1500.jpg", NULL, "1", NULL, "2023-05-24 13:18:22");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("8", "0", "خوش آمد گویی برنامه", "[\"welcome\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#eeeeee\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#eeeeee\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#32b6c6\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/app_welcome\\/App-Signup-Logo-1.png\",\"alt\":\"App-Signup-Logo\",\"fullWidth\":false,\"width\":\"80px\",\"height\":\"80px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center; margin: 0;\\\"><strong>Welcome to Appy<\\/strong><\\/h1><p style=\\\"text-align: center; margin: 0;\\\"><span style=\\\"color: #ffffff;\\\">Let\'s get started!<\\/span><\\/p>\"},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/app_welcome\\/App-Signup-Header.png\",\"alt\":\"App-Signup-Header\",\"fullWidth\":false,\"width\":\"1280px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\">Hi [subscriber:firstname | default:subscriber],<\\/p>\\n                                  <p style=\\\"text-align: center;\\\"><\\/p>\\n                                  <p style=\\\"text-align: center;\\\">In MailPoet, you can write emails in plain text, just like in a regular email. This can make your email newsletters more personal and attention-grabbing.<\\/p>\\n                                  <p style=\\\"text-align: center;\\\"><\\/p>\\n                                  <p style=\\\"text-align: center;\\\">Is this too simple? You can still style your text with basic formatting, like <strong>bold<\\/strong> or <em>italics.<\\/em><\\/p>\\n                                  <p style=\\\"text-align: center;\\\"><\\/p>\\n                                  <p style=\\\"text-align: center;\\\">Finally, you can also add a call-to-action button between 2 blocks of text, like this:<\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"23px\"}}},{\"type\":\"button\",\"text\":\"Get Started Here\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#32b6c6\",\"borderColor\":\"#32b6c6\",\"borderWidth\":\"0px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"188px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"35px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/app_welcome\\/App-Signup-Team.jpg\",\"alt\":\"App-Signup-Team\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"700px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#eeeeee\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/app_welcome\\/App-Signup-Logo-Footer.png\",\"alt\":\"App-Signup-Logo-Footer\",\"fullWidth\":false,\"width\":\"50px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 12px;\\\"><strong>Appy<\\/strong><\\/p>\\n                                <p style=\\\"text-align: center; font-size: 12px;\\\"><span>Address Line 1<\\/span><\\/p>\\n                                <p style=\\\"text-align: center; font-size: 12px;\\\"><span>Address Line 2<\\/span><\\/p>\\n                                <p style=\\\"text-align: center; font-size: 12px;\\\"><span>City<\\/span><\\/p>\\n                                <p style=\\\"text-align: center; font-size: 12px;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a><span> | <\\/span><a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/p>\"},{\"type\":\"social\",\"iconSet\":\"full-symbol-color\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#404040\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"26px\"},\"h2\":{\"fontColor\":\"#404040\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"h3\":{\"fontColor\":\"#32b6c6\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#32b6c6\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/app_welcome/thumbnail.20190411-1500.jpg", NULL, "1", NULL, "2023-05-24 13:18:22");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("9", "0", "به فودباکس خوش آمدید", "[\"welcome\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f4f4f4\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/food_box\\/Food-Delivery-Logo.png\",\"alt\":\"Food-Delivery-Logo\",\"fullWidth\":false,\"width\":\"640px\",\"height\":\"180px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/food_box\\/Food-Delivery-App.png\",\"alt\":\"Food-Delivery-App\",\"fullWidth\":false,\"width\":\"640px\",\"height\":\"180px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"text\",\"text\":\"<h1><strong>Welcome to FoodBox<\\/strong><\\/h1>\\n                                  <h2><strong>Lorem ipsum dolor sit amet<\\/strong><\\/h2>\\n                                  <p>Curabitur sollicitudin eros eu cursus sollicitudin. Suspendisse laoreet sollicitudin urna, ut lacinia risus dictum a. Integer a neque eu magna commodo sodales eu eget ante.<\\/p>\"},{\"type\":\"button\",\"text\":\"Get Started\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#7cc119\",\"borderColor\":\"#7cc119\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"100px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/food_box\\/Food-Delivery-Focus.jpg\",\"alt\":\"Food-Delivery-Focus\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"800px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"31.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"2px\",\"borderColor\":\"#e5e5e5\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\">Get started in 3 simple steps<\\/h2>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/food_box\\/Food-Delivery-1-1.png\",\"alt\":\"Food-Delivery-1\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"250px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur sollicitudin eros eu cursus sollicitudin.<\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/food_box\\/Food-Delivery-2-1.png\",\"alt\":\"Food-Delivery-2\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"250px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"text-align: center;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur sollicitudin eros eu cursus sollicitudin.<\\/span><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/food_box\\/Food-Delivery-3-1.png\",\"alt\":\"Food-Delivery-3\",\"fullWidth\":false,\"width\":\"800px\",\"height\":\"250px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"text-align: center;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Curabitur sollicitudin eros eu cursus sollicitudin.<\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"button\",\"text\":\"Get Started\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#7cc119\",\"borderColor\":\"#7cc119\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"100px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"25px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#4599da\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center; font-size: 14px;\\\"><strong><span style=\\\"color: #ffffff;\\\">Link 1 - Link 2 - Link 3 - Link 4<\\/span><\\/strong><\\/p>\"}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"24px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Website.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"}]}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#4599da\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"25px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f4f4f4\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\"},\"h1\":{\"fontColor\":\"#4599da\",\"fontFamily\":\"Arial\",\"fontSize\":\"26px\"},\"h2\":{\"fontColor\":\"#878787\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\"},\"link\":{\"fontColor\":\"#4599da\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#f4f4f4\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/food_box/thumbnail.20190411-1500.jpg", NULL, "1", NULL, "2023-05-24 13:18:22");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("10", "0", "Poet", "[\"welcome\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ebebeb\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/poet\\/Poet-Header.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ebebeb\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<p><a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#909090\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"144px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/poet\\/Poet-Logo.png\",\"alt\":\"Poet-Logo\",\"fullWidth\":false,\"width\":\"166px\",\"height\":\"144px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h1>Thanks for signing up!<\\/h1>\\n    <p><span style=\\\"color: #000000;\\\">Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis ut fringilla velit, id malesuada nisi. Nam ac rutrum diam.<\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":\"2_1\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"66px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"font-size: 12px;\\\"><span style=\\\"color: #999999;\\\"><strong>Latest p<\\/strong><\\/span><\\/p>\\n    <h2><strong>The 26th of December<\\/strong><\\/h2>\\n    <h3><span>A Tuesday, day of Tiw,<\\/span><br \\/><span>god of war, dawns in darkness.<\\/span><br \\/><span>The short holiday day of talking by the fire,<\\/span><br \\/><span>floating on snowshoes among<\\/span><br \\/><span>ancient self-pollarded maples,<\\/span><br \\/><span>visiting, being visited, giving<\\/span><br \\/><span>a rain gauge, receiving red socks,<\\/span><br \\/><span>watching snow buntings nearly over<\\/span><br \\/><span>their heads in snow stab at spirtled bits<\\/span><br \\/><span>of sunflower seeds the chickadees<\\/span><br \\/><span>hold with their feet to a bough<\\/span><br \\/><span>and hack apart, scattering debris<\\/span><br \\/><span>like sloppy butchers, is over.<\\/span><br \\/><span>Irregular life begins. Telephone calls,<\\/span><br \\/><span>Google searches, evasive letters,<\\/span><br \\/><span>complicated arrangements, faxes,<\\/span><br \\/><span>second thoughts, consultations,<\\/span><br \\/><span>e-mails, solemnly given kisses.<\\/span><\\/h3>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/poet\\/Poet-Images-1.jpg\",\"alt\":\"Poet-Images\",\"fullWidth\":true,\"width\":\"400px\",\"height\":\"1200px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#393939\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: right;\\\"><span style=\\\"color: #ffffff;\\\">What did you think of this poem? Let me know on one of my social media channels.<\\/span><\\/p>\"},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"styles\":{\"block\":{\"textAlign\":\"right\"}},\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\">Poetry books<\\/h1>\\n    <p style=\\\"text-align: center;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Duis ut fringilla velit, id malesuada nisi. Nam ac rutrum diam.<\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/poet\\/Poet-Books-1.png\",\"alt\":\"Poet-Books-1\",\"fullWidth\":false,\"width\":\"220px\",\"height\":\"646px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"button\",\"text\":\"Buy online\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#393939\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/poet\\/Poet-Books-3.png\",\"alt\":\"Poet-Books-3\",\"fullWidth\":false,\"width\":\"600px\",\"height\":\"646px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"button\",\"text\":\"Buy online\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#393939\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/poet\\/Poet-Books-2.png\",\"alt\":\"Poet-Books-2\",\"fullWidth\":false,\"width\":\"600px\",\"height\":\"646px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"button\",\"text\":\"Buy online\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#393939\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/poet\\/Poet-Logo.png\",\"alt\":\"Poet-Logo\",\"fullWidth\":false,\"width\":\"166px\",\"height\":\"144px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#939393\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#333333\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#646464\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#393939\",\"fontFamily\":\"Merriweather\",\"fontSize\":\"24px\"},\"h2\":{\"fontColor\":\"#393939\",\"fontFamily\":\"Merriweather\",\"fontSize\":\"30px\"},\"h3\":{\"fontColor\":\"#646464\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"16px\"},\"link\":{\"fontColor\":\"#393939\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ebebeb\"},\"body\":{\"backgroundColor\":\"#ebebeb\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"button\":{\"text\":\"Buy online\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#393939\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#939393\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#333333\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}],\"type\":\"social\",\"styles\":{\"block\":{\"textAlign\":\"right\"}}},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"12px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#909090\",\"textDecoration\":\"none\"}},\"type\":\"header\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/poet/thumbnail.20190411-1500.jpg", NULL, "1", NULL, "2023-05-24 13:18:22");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("11", "0", "آگاه ساز پست: نمونه خالی با الگوی 1 ستون", "[\"notification\",\"blank\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"header\",\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/blank_templates\\/fake-logo.png\",\"alt\":\"fake-logo\",\"fullWidth\":false,\"width\":\"598px\",\"height\":\"71px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><strong>\\u067e\\u0633\\u062a \\u0647\\u0627\\u06cc \\u062c\\u062f\\u06cc\\u062f \\u0648\\u0628\\u0644\\u0627\\u06af \\u0645\\u0627 \\u0631\\u0627 \\u0628\\u0631\\u0631\\u0633\\u06cc \\u06a9\\u0646\\u06cc\\u062f! <\\/strong><\\/h1>\\n<p>&nbsp;<\\/p>\\n<p>\\u0645\\u06cc\\u0644 \\u067e\\u0648\\u0626\\u062a \\u0645\\u06cc \\u062a\\u0648\\u0627\\u0646\\u062f <span style=\\\"line-height: 1.6em; background-color: inherit;\\\"><em>\\u0628\\u0635\\u0648\\u0631\\u062a \\u0627\\u062a\\u0648\\u0645\\u0627\\u062a\\u06cc\\u06a9<\\/em> <\\/span><span style=\\\"line-height: 1.6em; background-color: inherit;\\\">\\u067e\\u0633\\u062a \\u0647\\u0627\\u06cc \\u062c\\u062f\\u06cc\\u062f \\u0648\\u0628\\u0644\\u0627\\u06af \\u0634\\u0645\\u0627 \\u0631\\u0627 \\u0628\\u0647 \\u0645\\u0634\\u062a\\u0631\\u06a9\\u0627\\u0646\\u062a\\u0627\\u0646 \\u0627\\u0631\\u0633\\u0627\\u0644 \\u06a9\\u0646\\u062f!<\\/span><\\/p>\\n<p><span style=\\\"line-height: 1.6em; background-color: inherit;\\\"><\\/span><\\/p>\\n<p><span style=\\\"line-height: 1.6em; background-color: inherit;\\\">\\u062f\\u0631 \\u0632\\u06cc\\u0631\\u060c \\u0645\\u06cc \\u062a\\u0648\\u0627\\u0646\\u06cc\\u062f \\u0633\\u0647 \\u067e\\u0633\\u062a \\u0622\\u062e\\u0631\\u06cc \\u0631\\u0627 \\u06a9\\u0647 \\u0628\\u0635\\u0648\\u0631\\u062a \\u0627\\u062a\\u0648\\u0645\\u0627\\u062a\\u06cc\\u06a9 \\u0646\\u0645\\u0627\\u06cc\\u0634 \\u062f\\u0627\\u062f\\u0647 \\u0634\\u062f\\u0647 \\u0631\\u0627 \\u067e\\u06cc\\u062f\\u0627 \\u06a9\\u0646\\u06cc\\u062f, \\u0628\\u0647 \\u0644\\u0637\\u0641 \\u0648\\u06cc\\u062c\\u062a <em>\\u0622\\u062e\\u0631\\u06cc\\u0646 \\u0645\\u062d\\u062a\\u0648\\u0627\\u06cc \\u0627\\u062a\\u0648\\u0645\\u0627\\u062a\\u06cc\\u06a9<\\/em> , \\u06a9\\u0647 \\u0645\\u06cc \\u062a\\u0648\\u0627\\u0646\\u06cc\\u062f \\u0622\\u0646\\u0631\\u0627 \\u062f\\u0631 \\u0646\\u0648\\u0627\\u0631 \\u06a9\\u0646\\u0627\\u0631\\u06cc \\u0633\\u0645\\u062a \\u0631\\u0627\\u0633\\u062a \\u067e\\u06cc\\u062f\\u0627 \\u06a9\\u0646\\u06cc\\u062f, \\u0632\\u06cc\\u0631 <em>\\u0645\\u062d\\u062a\\u0648\\u0627<\\/em>.<\\/span><\\/p>\\n<p><span style=\\\"line-height: 1.6em; background-color: inherit;\\\"><\\/span><\\/p>\\n<p><span style=\\\"line-height: 1.6em; background-color: inherit;\\\">\\u0628\\u0631\\u0627\\u06cc \\u0648\\u06cc\\u0631\\u0627\\u06cc\\u0634 \\u062a\\u0646\\u0638\\u06cc\\u0645\\u0627\\u062a \\u0648 \\u0633\\u0628\\u06a9 \\u067e\\u0633\\u062a \\u0647\\u0627\\u060c \\u0628\\u0647 \\u0633\\u0627\\u062f\\u06af\\u06cc \\u06a9\\u0644\\u06cc\\u06a9 \\u06a9\\u0646\\u06cc\\u062f \\u0628\\u0631 \\u0631\\u0648\\u06cc \\u06cc\\u06a9 \\u067e\\u0633\\u062a \\u062f\\u0631 \\u0632\\u06cc\\u0631.<\\/span><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"3\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"\\u0646\\u0648\\u06cc\\u0633\\u0646\\u062f\\u0647:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"\\u062f\\u0633\\u062a\\u0647 \\u0647\\u0627:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"\\u062e\\u0648\\u0627\\u0646\\u062f\\u0646 \\u067e\\u0633\\u062a\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"160px\",\"lineHeight\":\"30px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"orientation\":\"horizontal\",\"styles\":{\"block\":{\"backgroundColor\":\"#f8f8f8\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"24.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"social\",\"iconSet\":\"grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/02-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"7.5px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},{\"type\":\"footer\",\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Trebuchet MS\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#eeeeee\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/post-notifications-blank-1-column/thumbnail.20190411-1500.jpg", NULL, "1", NULL, "2023-05-24 13:18:22");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("12", "0", "Modular Style Stories", "[\"notification\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#efe7f0\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#efe7f0\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/modular-style-stories\\/Modular-Logo.png\",\"alt\":\"Modular-Logo\",\"fullWidth\":false,\"width\":\"271px\",\"height\":\"37px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"26px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-color\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Instagram.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"pinterest\",\"link\":\"http:\\/\\/www.pinterest.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Pinterest.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Pinterest\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#efe7f0\",\"height\":\"40px\"}}}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"3\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#ffffff\",\"borderWidth\":\"1px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"120px\",\"lineHeight\":\"40px\",\"fontColor\":\"#b956c5\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"context\":\"automatedLatestContentLayout.readMoreButton\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"3px\",\"borderColor\":\"#efe7f0\"}},\"context\":\"automatedLatestContentLayout.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#efe7f0\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#b956c5\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/ladybirds-transparent-shell-reveals-how-it-folds-its-wings\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/modular-style-stories\\/gettyimages-578313682-800x533.jpg\",\"alt\":\"Ladybird\\u2019s transparent shell reveals how it folds its wings\",\"fullWidth\":false,\"width\":660,\"height\":440,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><strong>Ladybird&rsquo;s transparent shell reveals how it folds its wings<\\/strong><\\/h3>\\n<p class=\\\"mailpoet_wp_post\\\">They certainly know how to fold. A see-through artificial wing case has been used to watch for the first time as ladybirds put away their wings after flight.<\\/p>\"},{\"type\":\"button\",\"text\":\"Read More\",\"url\":\"http:\\/\\/mailpoet.info\\/ladybirds-transparent-shell-reveals-how-it-folds-its-wings\\/\",\"styles\":{\"block\":{\"backgroundColor\":\"#b956c5\",\"borderColor\":\"#000000\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"103px\",\"lineHeight\":\"34px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/plasma-jet-engines-that-could-take-you-from-the-ground-to-space\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/modular-style-stories\\/plasma-stingray111-800x533.jpg\",\"alt\":\"Plasma jet engines that could take you from the ground to space\",\"fullWidth\":false,\"width\":660,\"height\":440,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><strong>Plasma jet engines that could take you from ground to space<\\/strong><\\/h3>\\n<p class=\\\"mailpoet_wp_post\\\">FORGET fuel-powered jet engines. We&rsquo;re on the verge of having aircraft that can fly from the ground up to the edge of space using air and electricity alone.<\\/p>\"},{\"type\":\"button\",\"text\":\"Read More\",\"url\":\"http:\\/\\/mailpoet.info\\/plasma-jet-engines-that-could-take-you-from-the-ground-to-space\\/\",\"styles\":{\"block\":{\"backgroundColor\":\"#b956c5\",\"borderColor\":\"#000000\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"103px\",\"lineHeight\":\"34px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#efe7f0\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#efe7f0\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/cutting-through-the-smog-what-to-do-to-fight-air-pollution\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/modular-style-stories\\/5_what_to_do_p352m1141746-800x533.jpg\",\"alt\":\"Cutting through the smog: What to do to fight air pollution\",\"fullWidth\":false,\"width\":660,\"height\":440,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><span style=\\\"color: #333333;\\\"><strong>Cutting through the smog: What to do to fight air pollution<\\/strong><\\/span><\\/h3>\"},{\"type\":\"button\",\"text\":\"Read More\",\"url\":\"http:\\/\\/mailpoet.info\\/cutting-through-the-smog-what-to-do-to-fight-air-pollution\\/\",\"styles\":{\"block\":{\"backgroundColor\":\"#b956c5\",\"borderColor\":\"#000000\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"103px\",\"lineHeight\":\"34px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/ladybirds-transparent-shell-reveals-how-it-folds-its-wings\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/modular-style-stories\\/gettyimages-578313682-800x533.jpg\",\"alt\":\"Ladybird\\u2019s transparent shell reveals how it folds its wings\",\"fullWidth\":false,\"width\":660,\"height\":440,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><span style=\\\"color: #333333;\\\"><strong>Ladybird&rsquo;s transparent shell reveals how it folds its wings<\\/strong><\\/span><\\/h3>\"},{\"type\":\"button\",\"text\":\"Read More\",\"url\":\"http:\\/\\/mailpoet.info\\/ladybirds-transparent-shell-reveals-how-it-folds-its-wings\\/\",\"styles\":{\"block\":{\"backgroundColor\":\"#b956c5\",\"borderColor\":\"#000000\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"103px\",\"lineHeight\":\"34px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"http:\\/\\/mailpoet.info\\/plasma-jet-engines-that-could-take-you-from-the-ground-to-space\\/\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/modular-style-stories\\/plasma-stingray111-800x533.jpg\",\"alt\":\"Plasma jet engines that could take you from the ground to space\",\"fullWidth\":false,\"width\":660,\"height\":440,\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><span style=\\\"color: #333333;\\\"><strong>Plasma jet engines that could take you from the ground to space<\\/strong><\\/span><\\/h3>\"},{\"type\":\"button\",\"text\":\"Read More\",\"url\":\"http:\\/\\/mailpoet.info\\/plasma-jet-engines-that-could-take-you-from-the-ground-to-space\\/\",\"styles\":{\"block\":{\"backgroundColor\":\"#b956c5\",\"borderColor\":\"#000000\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"103px\",\"lineHeight\":\"34px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#efe7f0\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#b956c5\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"21px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Website.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #ffffff;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #ffffff;\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #ffffff;\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/span><br \\/><span style=\\\"color: #ffffff;\\\">\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"26px\"},\"h3\":{\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"20px\"},\"link\":{\"fontColor\":\"#ffffff\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#b956c5\"},\"body\":{\"backgroundColor\":\"#efe7f0\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"2\",\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h2\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":true,\"featuredImagePosition\":\"aboveTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"116px\",\"lineHeight\":\"40px\",\"fontColor\":\"#b956c5\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"3px\",\"borderColor\":\"#ffffff\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContent\",\"terms\":[],\"withLayout\":false},\"automatedLatestContentLayout\":{\"amount\":\"3\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#ffffff\",\"borderWidth\":\"1px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"120px\",\"lineHeight\":\"40px\",\"fontColor\":\"#b956c5\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"3px\",\"borderColor\":\"#efe7f0\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContentLayout\",\"terms\":[]},\"button\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"container\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":true,\"featuredImagePosition\":\"aboveTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"posts\",\"offset\":0,\"terms\":[],\"search\":\"\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png?mailpoet_version=3.7.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png?mailpoet_version=3.7.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"#efe7f0\",\"height\":\"40px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/modular-style-stories/thumbnail.20190411-1500.jpg", NULL, "1", NULL, "2023-05-24 13:18:22");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("13", "0", "Stripped RSS Style Layout", "[\"notification\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f4f4f4\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"25px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/rss-simple-news\\/RSS-Logo-2.png\",\"alt\":\"RSS-Logo-2\",\"fullWidth\":true,\"width\":\"210px\",\"height\":\"90px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"24px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-color\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/06-full-symbol-color\\/Website.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"}]}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: left;\\\"><strong><span style=\\\"color: #333333;\\\">Latest RSS Simple&nbsp;Posts<\\/span><\\/strong><\\/h3>\\n<p><span style=\\\"color: #999999;\\\">Week 23: 23\\/19\\/19<\\/span><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"5\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":true,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more.\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"context\":\"automatedLatestContentLayout.readMoreButton\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#ececec\"}},\"context\":\"automatedLatestContentLayout.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f4f4f4\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<p><span style=\\\"color: #808080;\\\"><strong>RSS Simple<\\/strong><\\/span><\\/p>\\n<p><span style=\\\"color: #808080; font-size: 11px;\\\"><strong><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a><span>&nbsp;|&nbsp;<\\/span><a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/strong><\\/span><\\/p>\\n<p><span style=\\\"color: #808080; font-size: 11px;\\\"><strong><span>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/span><\\/strong><\\/span><\\/p>\"}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#3478f5\",\"fontFamily\":\"Arial\",\"fontSize\":\"20px\"},\"link\":{\"fontColor\":\"#3478f5\",\"textDecoration\":\"none\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#f4f4f4\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"3\",\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":true,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#efe7f0\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContent\",\"terms\":[],\"withLayout\":false},\"automatedLatestContentLayout\":{\"amount\":\"5\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":true,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more.\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#ececec\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContentLayout\",\"terms\":[]},\"button\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"container\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png?mailpoet_version=3.7.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png?mailpoet_version=3.7.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/rss-simple-news/thumbnail.20190411-1500.jpg", NULL, "1", NULL, "2023-05-24 13:18:22");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("14", "0", "One Full Post In An Email", "[\"notification\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/not-so-medium\\/Not-So-Medium-Logo.png\",\"alt\":\"Not-So-Medium-Logo\",\"fullWidth\":false,\"width\":\"210px\",\"height\":\"90px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Website.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ebebeb\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p><strong><em>Welcome to this week\'s post. <\\/em><\\/strong><\\/p>\\n<p><em>Every Friday, we send you the most interesting story&nbsp;of the week in full.<\\/em><\\/p>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#d6d6d6\",\"height\":\"20px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"63px\"}}}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"1\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"full\",\"titleFormat\":\"h1\",\"titleAlignment\":\"center\",\"titleIsLink\":true,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"aboveText\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"aboveText\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"View this post online & share!\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"context\":\"automatedLatestContentLayout.readMoreButton\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}},\"context\":\"automatedLatestContentLayout.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ebebeb\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><strong><em>Share this with your friends<\\/em><\\/strong><\\/p>\\n<p style=\\\"text-align: center;\\\"><em>We promise not to spam anyone, and we only send our great articles to any email addresses in our list. Promise!<\\/em><\\/p>\"},{\"type\":\"social\",\"iconSet\":\"circles\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"google-plus\",\"link\":\"http:\\/\\/plus.google.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Google-Plus.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Google Plus\"},{\"type\":\"socialIcon\",\"iconType\":\"linkedin\",\"link\":\"http:\\/\\/www.linkedin.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/LinkedIn.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"LinkedIn\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Email.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"}]},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#d6d6d6\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"footer\",\"text\":\"<p><strong><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/strong><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#2c2c2c\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Georgia\",\"fontSize\":\"18px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#ffffff\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"1\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"full\",\"titleFormat\":\"h1\",\"titleAlignment\":\"center\",\"titleIsLink\":true,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"aboveText\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"aboveText\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"View this post online & share!\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"1px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContentLayout\",\"terms\":[]},\"button\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"container\":{\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png?mailpoet_version=3.9.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png?mailpoet_version=3.9.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"63px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/not-so-medium/thumbnail.20190411-1500.jpg", NULL, "1", NULL, "2023-05-24 13:18:22");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("15", "0", "Wide Story Layout", "[\"notification\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f0f0f0\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"50px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/wide-story-layout\\/Wide-Logo.png\",\"alt\":\"Wide-Logo\",\"fullWidth\":false,\"width\":\"200px\",\"height\":\"37px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><span style=\\\"color: #808080;\\\">Our Latest Posts<\\/span><\\/h3>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"3\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read The Post\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#5ecd39\",\"borderColor\":\"#000000\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"36px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Lucida\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"context\":\"automatedLatestContentLayout.readMoreButton\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#f0f0f0\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"30px\",\"borderColor\":\"#f0f0f0\"}},\"context\":\"automatedLatestContentLayout.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/wide-story-layout\\/Wide-Footer.jpg\",\"alt\":\"Wide-Footer\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"721px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#5ecd39\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"21px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Website.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png?mailpoet_version=3.0.0-rc.2.0.0\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #ffffff;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #ffffff;\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #ffffff;\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/span><br \\/><span style=\\\"color: #ffffff;\\\">\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"40px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Lucida\",\"fontSize\":\"30px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Lucida\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Lucida\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#5ecd39\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#f0f0f0\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"3\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read The Post\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#5ecd39\",\"borderColor\":\"#000000\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"36px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Lucida\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#f0f0f0\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"30px\",\"borderColor\":\"#f0f0f0\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContentLayout\",\"terms\":[]},\"button\":{\"text\":\"Read The Post\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#5ecd39\",\"borderColor\":\"#000000\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"36px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Lucida\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"container\":{\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"default\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Facebook.png?mailpoet_version=3.11.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/01-social\\/Twitter.png?mailpoet_version=3.11.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"40px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/wide-story-layout/thumbnail.20190411-1500.jpg", NULL, "1", NULL, "2023-05-24 13:18:22");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("16", "0", "Industry Conference", "[\"notification\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"50px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/industry-conference\\/Conf-Logo.png\",\"alt\":\"Conf-Logo\",\"fullWidth\":false,\"width\":\"150px\",\"height\":\"150px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff; font-size: 11px; text-transform: uppercase; opacity: 0.5; letter-spacing: 3px;\\\">Get ready for the biggest email conference of the year<\\/span><\\/p>\"}]}]},{\"type\":\"container\",\"columnLayout\":\"2_1\",\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/industry-conference\\/Conf-Header-2.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"56px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/industry-conference\\/Conf-Ticket.png\",\"alt\":\"Conf-Ticket\",\"fullWidth\":false,\"width\":\"339px\",\"height\":\"177px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}},{\"type\":\"text\",\"text\":\"<h3><span style=\\\"font-size: 42px;\\\"><strong><span style=\\\"color: #ffffff; line-height: 1.2; position: relative; top: -5px;\\\">Email Boston 2018<\\/span><\\/strong><\\/span><\\/h3>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"133px\"}}}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"3\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h2\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"right\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read the post\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#b8291e\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"147px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Georgia\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}},\"context\":\"automatedLatestContentLayout.readMoreButton\"},\"sortBy\":\"oldest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"4px\",\"borderColor\":\"#dddddd\"}},\"context\":\"automatedLatestContentLayout.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/industry-conference\\/Conf-Bottom-2.png\",\"alt\":\"Conf-Bottom\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#222222\",\"height\":\"34px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/industry-conference\\/Industry-Coupon.png\",\"display\":\"fit\"},\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"75px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">---<\\/span><\\/h3>\\n    <h3 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">Grab 20% off your tickets right now<\\/span><\\/h3>\\n    <p style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\">We\'re offering an exclusive 20% off tickets with this coupon code!<\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"CouPon_Code\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#b8291e\",\"borderColor\":\"#ffffff\",\"borderWidth\":\"3px\",\"borderRadius\":\"14px\",\"borderStyle\":\"solid\",\"width\":\"229px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"26px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"33px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"45px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#222222\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/industry-conference\\/Conf-Top.png\",\"alt\":\"Conf-Top\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"12px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"padding\":\"14px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"7px\",\"borderColor\":\"#e1e1e1\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"30px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/industry-conference\\/Conf-Holding.jpg\",\"alt\":\"Conf-Holding\",\"fullWidth\":false,\"width\":\"1000px\",\"height\":\"667px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"46px\"}}},{\"type\":\"text\",\"text\":\"<h3><strong>Check out&nbsp;this year\'s event<\\/strong><\\/h3>\\n    <p>We\'ve ramped up everything this year for our conference, including amazing new speakers and guests, and a few surprises for everyone.<\\/p>\"},{\"type\":\"button\",\"text\":\"Buy a ticket here\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#b8291e\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"147px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Georgia\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"20px\"}}},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"padding\":\"1.5px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"7px\",\"borderColor\":\"#e1e1e1\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/industry-conference\\/Conf-Bottom-2.png\",\"alt\":\"Conf-Bottom\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#222222\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#222222\",\"height\":\"30px\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#222222\",\"height\":\"20px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Email.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]},{\"type\":\"header\",\"text\":\"<p>&nbsp;<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#8d8d8d\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#ffffff\",\"textDecoration\":\"underline\"}}},{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #b8291e;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #b8291e;\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #b8291e;\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/span><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arvo\",\"fontSize\":\"40px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arvo\",\"fontSize\":\"26px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arvo\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#b8291e\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#222222\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"3\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h2\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"right\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read the post\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#b8291e\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"0px\",\"borderRadius\":\"0px\",\"borderStyle\":\"solid\",\"width\":\"147px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Georgia\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}},\"type\":\"button\"},\"sortBy\":\"oldest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"4px\",\"borderColor\":\"#dddddd\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContentLayout\",\"terms\":[]},\"button\":{\"text\":\"Read the post\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#b8291e\",\"borderColor\":\"#ffffff\",\"borderWidth\":\"3px\",\"borderRadius\":\"14px\",\"borderStyle\":\"solid\",\"width\":\"229px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Courier New\",\"fontSize\":\"26px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"#222222\",\"padding\":\"1.5px\",\"borderStyle\":\"dotted\",\"borderWidth\":\"7px\",\"borderColor\":\"#515151\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-grey\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Email.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/08-full-symbol-grey\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"75px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#8d8d8d\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#ffffff\",\"textDecoration\":\"underline\"}},\"type\":\"header\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/industry-conference/thumbnail.20190411-1500.jpg", NULL, "1", NULL, "2023-05-24 13:18:22");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("17", "0", "هفته نامه علمی", "[\"notification\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/science_weekly\\/Science-Logo.png\",\"alt\":\"Science-Logo\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"300px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/science_weekly\\/Health-Mag-Title-22.png\",\"alt\":\"Health-Mag-Title-2\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"214px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#b1b6d1\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: center;\\\"><span style=\\\"color: #ffffff;\\\"><strong>The latest news from the world of science<\\/strong><\\/span><\\/h1>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"40px\"}}}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"2\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2b2d37\",\"borderColor\":\"#2b2d37\",\"borderWidth\":\"1px\",\"borderRadius\":\"21px\",\"borderStyle\":\"solid\",\"width\":\"114px\",\"lineHeight\":\"33px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"14px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}},\"context\":\"automatedLatestContentLayout.readMoreButton\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"context\":\"automatedLatestContentLayout.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#b1b6d1\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/science_weekly\\/Health-Mag-End-1.png\",\"alt\":\"Health-Mag-End\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#2b2d37\",\"height\":\"35px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/science_weekly\\/Health-Mag-Promo-Start.png\",\"alt\":\"Health-Mag-Promo-Start\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"50px\"}}},{\"type\":\"text\",\"text\":\"<h2><strong>Download our app!<\\/strong><\\/h2>\\n                      <p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Sed in odio dui. Duis et dolor nec erat dictum laoreet. Morbi dapibus turpis id eros viverra tempor. <\\/span><\\/p>\\n                      <p><span><\\/span><\\/p>\\n                      <p><span>Fusce et diam ac sapien posuere luctus. Etiam in vehicula metus, ac viverra elit. Duis diam lacus, molestie vel enim non, rutrum placerat massa. Suspendisse a elit tincidunt, egestas lacus at, maximus diam. <\\/span><\\/p>\\n                      <p><span><\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Download Now\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#2b2d37\",\"borderColor\":\"#2b2d37\",\"borderWidth\":\"1px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"144px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/science_weekly\\/Health-Mag-Phone.png\",\"alt\":\"Health-Mag-Phone\",\"fullWidth\":false,\"width\":\"400px\",\"height\":\"573px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/science_weekly\\/Health-Mag-Promo-End.png\",\"alt\":\"Health-Mag-Promo-End\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#2b2d37\",\"height\":\"35px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/science_weekly\\/Health-Mag-Promo-Start.png\",\"alt\":\"Health-Mag-Promo-Start\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: center;\\\">Keep In Touch With Us<\\/h3>\"},{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png?mailpoet_version=3.11.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png?mailpoet_version=3.11.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}]}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/science_weekly\\/Health-Mag-Promo-End.png\",\"alt\":\"Health-Mag-Promo-End\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"50px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#2b2d37\",\"height\":\"26px\"}}},{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #b1b6d1;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #b1b6d1;\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #b1b6d1;\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/span><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"#2b2d37\"},\"text\":{\"fontColor\":\"#d6d6d6\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#2b2d37\",\"height\":\"40px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Arial\",\"fontSize\":\"26px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"22px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Arial\",\"fontSize\":\"20px\"},\"link\":{\"fontColor\":\"#21759B\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#2b2d37\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"2\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2b2d37\",\"borderColor\":\"#2b2d37\",\"borderWidth\":\"1px\",\"borderRadius\":\"21px\",\"borderStyle\":\"solid\",\"width\":\"114px\",\"lineHeight\":\"33px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"14px\",\"fontWeight\":\"normal\",\"textAlign\":\"left\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContentLayout\",\"terms\":[]},\"button\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"container\":{\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}}},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png?mailpoet_version=3.11.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png?mailpoet_version=3.11.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"40px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}},\"type\":\"header\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/science_weekly/thumbnail.20190411-1500.jpg", NULL, "1", NULL, "2023-05-24 13:18:22");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("18", "0", "Newspaper Traditional", "[\"notification\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f2f9f8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"28px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"font-size: 15px;\\\"><em><strong>[date:mtext][date:dordinal],[date:y]<\\/strong><\\/em><\\/h3>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"header\",\"text\":\"<p><span style=\\\"color: #008080;\\\"><a href=\\\"[link:newsletter_view_in_browser_url]\\\" style=\\\"color: #008080;\\\">View this in your browser.<\\/a><\\/span><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"columnLayout\":\"2_1\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#f2f9f8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/newspaper-traditional\\/News-Logo.png\",\"alt\":\"News-Logo\",\"fullWidth\":false,\"width\":\"200px\",\"height\":\"100px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png?mailpoet_version=3.12.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png?mailpoet_version=3.12.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"website\",\"link\":\"\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Website.png?mailpoet_version=3.12.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Website\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png?mailpoet_version=3.12.1\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#c6dbd8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p><strong>Local News<\\/strong><\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><strong>Sports&nbsp;Updates &amp; Scores<\\/strong><\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: right;\\\"><strong>Business News<\\/strong><\\/p>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: left;\\\"><strong>Check Out Our New Blog Posts! <\\/strong><\\/h1>\\n    <p style=\\\"text-align: left;\\\">&nbsp;<\\/p>\\n    <p style=\\\"text-align: left;\\\">MailPoet can <span style=\\\"line-height: 1.6em; background-color: inherit;\\\"><em>automatically<\\/em> <\\/span><span style=\\\"line-height: 1.6em; background-color: inherit;\\\">send your new blog posts to your subscribers.<\\/span><\\/p>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"line-height: 1.6em; background-color: inherit;\\\"><\\/span><\\/p>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"line-height: 1.6em; background-color: inherit;\\\">Below, you\'ll find three recent posts, which are displayed automatically, thanks to the <em>Automatic Latest Content<\\/em> widget, which can be found in the right sidebar, under <em>Content<\\/em>.<\\/span><\\/p>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"line-height: 1.6em; background-color: inherit;\\\"><\\/span><\\/p>\\n    <p style=\\\"text-align: left;\\\"><span style=\\\"line-height: 1.6em; background-color: inherit;\\\">To edit the settings and styles of your post, simply click on a post below.<\\/span><\\/p>\"},{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"double\",\"borderWidth\":\"7px\",\"borderColor\":\"#c6dbd8\"}}}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"3\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":true,\"imageFullWidth\":false,\"featuredImagePosition\":\"left\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read the post\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"160px\",\"lineHeight\":\"30px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"double\",\"borderWidth\":\"7px\",\"borderColor\":\"#c6dbd8\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#c6dbd8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#c6dbd8\",\"height\":\"30px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#c6dbd8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#c6dbd8\",\"height\":\"28px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/newspaper-traditional\\/News-Logo.png\",\"alt\":\"News-Logo\",\"fullWidth\":false,\"width\":\"200px\",\"height\":\"100px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"footer\",\"text\":\"<p><span style=\\\"color: #458687;\\\"><a href=\\\"[link:subscription_unsubscribe_url]\\\" style=\\\"color: #458687;\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\" style=\\\"color: #458687;\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/span><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Email.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"}]}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#c6dbd8\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#c6dbd8\",\"height\":\"21px\"}}}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Playfair Display\",\"fontSize\":\"14px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Merriweather\",\"fontSize\":\"26px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather\",\"fontSize\":\"22px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Merriweather\",\"fontSize\":\"18px\"},\"link\":{\"fontColor\":\"#3d8076\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#f2f9f8\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"3\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h3\",\"titleAlignment\":\"left\",\"titleIsLink\":true,\"imageFullWidth\":false,\"featuredImagePosition\":\"left\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read the post\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"160px\",\"lineHeight\":\"30px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"16px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"double\",\"borderWidth\":\"7px\",\"borderColor\":\"#c6dbd8\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContentLayout\",\"terms\":[]},\"button\":{\"text\":\"Read the post\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"double\",\"borderWidth\":\"7px\",\"borderColor\":\"#c6dbd8\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"center\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"none\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"alternate\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"link\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"social\":{\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"},{\"type\":\"socialIcon\",\"iconType\":\"email\",\"link\":\"\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Email.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Email\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"12px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#6cb7d4\",\"textDecoration\":\"underline\"}},\"type\":\"header\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/newspaper-traditional/thumbnail.20190411-1500.jpg", NULL, "1", NULL, "2023-05-24 13:18:22");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("19", "0", "Clear News", "[\"notification\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"27px\"}}},{\"type\":\"header\",\"text\":\"<p><a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a><\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"11px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#e2973f\",\"textDecoration\":\"underline\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/clear-news\\/News-Logo-1.png\",\"alt\":\"News-Logo\",\"fullWidth\":false,\"width\":\"120px\",\"height\":\"167px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"30px\"}}},{\"type\":\"text\",\"text\":\"<h3 style=\\\"text-align: right;\\\"><span style=\\\"color: #808080;\\\"><strong>October 2018<\\/strong><\\/span><\\/h3>\"}]}]},{\"type\":\"container\",\"columnLayout\":\"2_1\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<h1 style=\\\"text-align: left; line-height: 1.3;\\\"><strong>Good Morning!<\\/strong><\\/h1>\\n    <h3>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Fusce egestas nisl vel ante finibus fringilla ullamcorper non lectus. Aenean leo neque, egestas et lacus eu, viverra luctus nisi. Donec dapibus mauris at fringilla consequat. Cras sed porta nunc. Ut tincidunt luctus felis sed suscipit. Sed tristique faucibus fermentum.<\\/h3>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"24px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/clear-news\\/UEl2.gif\",\"alt\":\"UEl2\",\"fullWidth\":false,\"width\":\"360px\",\"height\":\"400px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#e2973f\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h2><strong>Today\'s Top Stories<\\/strong><\\/h2>\"}]}]},{\"type\":\"automatedLatestContentLayout\",\"withLayout\":true,\"amount\":\"3\",\"contentType\":\"post\",\"terms\":[],\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h2\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":true,\"featuredImagePosition\":\"left\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"type\":\"button\",\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#e2973f\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"110px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}},\"context\":\"automatedLatestContentLayout.readMoreButton\"},\"sortBy\":\"newest\",\"showDivider\":false,\"divider\":{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"context\":\"automatedLatestContentLayout.divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#e2973f\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"20px\"}}},{\"type\":\"text\",\"text\":\"<h2><strong>We cover all types of news<\\/strong><\\/h2>\"}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"World\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#e23f3f\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Business\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#50b6ce\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Politics\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#506dce\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Sports\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#e1bc2d\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Science\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#a650ce\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Health\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#64b03c\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Family\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#278f6e\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Arts\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#7c5e5e\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"button\",\"text\":\"Local\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#4d4d4d\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":\"1_2\",\"orientation\":\"horizontal\",\"image\":{\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/clear-news\\/News-Crossword.jpg\",\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"60px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: right;\\\"><span style=\\\"color: #ffffff;\\\">The Friday Crossword<\\/span><\\/h2>\\n    <p style=\\\"text-align: right;\\\"><span style=\\\"color: #ffffff;\\\"><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Vestibulum vitae ornare elit. Duis laoreet justo sed fringilla maximus. Aenean pharetra nec risus a vestibulum.<\\/span><\\/span><\\/p>\"},{\"type\":\"button\",\"text\":\"Get started\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#e2973f\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"110px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"right\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"22px\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"34.5px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#e2973f\"}}}]}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/clear-news\\/News-Logo-1.png\",\"alt\":\"News-Logo\",\"fullWidth\":false,\"width\":\"120px\",\"height\":\"167px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\"><strong><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a><\\/strong><\\/p>\\n    <p style=\\\"text-align: center;\\\"><strong><a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><\\/strong><\\/p>\"},{\"type\":\"text\",\"text\":\"<p style=\\\"text-align: center;\\\">Add your postal address!<\\/p>\"}]},{\"type\":\"container\",\"columnLayout\":false,\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"social\",\"iconSet\":\"circles\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"}]},{\"type\":\"social\",\"iconSet\":\"default\",\"icons\":[]}]}]}]},\"globalStyles\":{\"text\":{\"fontColor\":\"#000000\",\"fontFamily\":\"Source Sans Pro\",\"fontSize\":\"15px\"},\"h1\":{\"fontColor\":\"#111111\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"40px\"},\"h2\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"24px\"},\"h3\":{\"fontColor\":\"#333333\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"16px\"},\"link\":{\"fontColor\":\"#e2973f\",\"textDecoration\":\"underline\"},\"wrapper\":{\"backgroundColor\":\"#ffffff\"},\"body\":{\"backgroundColor\":\"#ffffff\"}},\"blockDefaults\":{\"automatedLatestContent\":{\"amount\":\"5\",\"withLayout\":false,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h1\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":false,\"featuredImagePosition\":\"belowTitle\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContent.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#2ea1cd\",\"borderColor\":\"#0074a2\",\"borderWidth\":\"1px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"180px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Verdana\",\"fontSize\":\"18px\",\"fontWeight\":\"normal\",\"textAlign\":\"center\"}}},\"sortBy\":\"newest\",\"showDivider\":true,\"divider\":{\"context\":\"automatedLatestContent.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}}},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\"},\"automatedLatestContentLayout\":{\"amount\":\"3\",\"withLayout\":true,\"contentType\":\"post\",\"inclusionType\":\"include\",\"displayType\":\"excerpt\",\"titleFormat\":\"h2\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":true,\"featuredImagePosition\":\"left\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"context\":\"automatedLatestContentLayout.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#e2973f\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"110px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":false,\"divider\":{\"context\":\"automatedLatestContentLayout.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"automatedLatestContentLayout\",\"terms\":[]},\"button\":{\"text\":\"Read more\",\"url\":\"[postLink]\",\"styles\":{\"block\":{\"backgroundColor\":\"#4d4d4d\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"5px\",\"borderStyle\":\"solid\",\"width\":\"288px\",\"lineHeight\":\"50px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Merriweather Sans\",\"fontSize\":\"20px\",\"fontWeight\":\"bold\",\"textAlign\":\"center\"}},\"type\":\"button\"},\"divider\":{\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"34.5px\",\"borderStyle\":\"dashed\",\"borderWidth\":\"2px\",\"borderColor\":\"#e2973f\"}},\"type\":\"divider\"},\"footer\":{\"text\":\"<p><a href=\\\"[link:subscription_unsubscribe_url]\\\">\\u0644\\u063a\\u0648 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9<\\/a> | <a href=\\\"[link:subscription_manage_url]\\\">\\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0634\\u0645\\u0627<\\/a><br \\/>\\u0622\\u062f\\u0631\\u0633 \\u067e\\u0633\\u062a\\u06cc \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0627\\u06cc\\u0646\\u062c\\u0627 \\u0648\\u0627\\u0631\\u062f \\u06a9\\u0646\\u06cc\\u062f!<\\/p>\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"13px\",\"textAlign\":\"right\"},\"link\":{\"fontColor\":\"#e2973f\",\"textDecoration\":\"underline\"}},\"type\":\"footer\"},\"posts\":{\"amount\":\"10\",\"withLayout\":true,\"contentType\":\"post\",\"postStatus\":\"publish\",\"inclusionType\":\"include\",\"displayType\":\"titleOnly\",\"titleFormat\":\"h2\",\"titleAlignment\":\"left\",\"titleIsLink\":false,\"imageFullWidth\":true,\"featuredImagePosition\":\"centered\",\"showAuthor\":\"no\",\"authorPrecededBy\":\"Author:\",\"showCategories\":\"no\",\"categoriesPrecededBy\":\"Categories:\",\"readMoreType\":\"button\",\"readMoreText\":\"Read more\",\"readMoreButton\":{\"text\":\"Read more\",\"url\":\"http:\\/\\/mailpoet.info\\/ladybirds-transparent-shell-reveals-how-it-folds-its-wings\\/\",\"context\":\"posts.readMoreButton\",\"styles\":{\"block\":{\"backgroundColor\":\"#e2973f\",\"borderColor\":\"#e2973f\",\"borderWidth\":\"0px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"110px\",\"lineHeight\":\"40px\",\"fontColor\":\"#ffffff\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}},\"type\":\"button\"},\"sortBy\":\"newest\",\"showDivider\":false,\"divider\":{\"context\":\"posts.divider\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"padding\":\"13px\",\"borderStyle\":\"solid\",\"borderWidth\":\"3px\",\"borderColor\":\"#aaaaaa\"}},\"type\":\"divider\"},\"backgroundColor\":\"#ffffff\",\"backgroundColorAlternate\":\"#eeeeee\",\"type\":\"posts\",\"offset\":0,\"terms\":[],\"search\":\"\"},\"social\":{\"iconSet\":\"circles\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Facebook.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Twitter.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"youtube\",\"link\":\"http:\\/\\/www.youtube.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/03-circles\\/Youtube.png\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Youtube\"}],\"type\":\"social\"},\"spacer\":{\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\",\"height\":\"20px\"}},\"type\":\"spacer\"},\"header\":{\"text\":\"<a href=\\\"[link:newsletter_view_in_browser_url]\\\">View this in your browser.<\\/a>\",\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"},\"text\":{\"fontColor\":\"#222222\",\"fontFamily\":\"Arial\",\"fontSize\":\"11px\",\"textAlign\":\"left\"},\"link\":{\"fontColor\":\"#e2973f\",\"textDecoration\":\"underline\"}},\"type\":\"header\"}}}", "https://ps.w.org/mailpoet/assets/newsletter-templates/clear-news/thumbnail.20190411-1500.jpg", NULL, "1", NULL, "2023-05-24 13:18:22");
INSERT INTO `wp_mailpoet_newsletter_templates` VALUES("20", "0", "Dog Food", "[\"woocommerce\",\"all\"]", "", "{\"content\":{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/dog-food\\/Dog-Logo.png\",\"alt\":\"Dog-Logo\",\"fullWidth\":false,\"width\":\"42px\",\"height\":\"91px\",\"styles\":{\"block\":{\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"31px\"}}},{\"type\":\"social\",\"iconSet\":\"full-symbol-black\",\"icons\":[{\"type\":\"socialIcon\",\"iconType\":\"facebook\",\"link\":\"http:\\/\\/www.facebook.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Facebook.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Facebook\"},{\"type\":\"socialIcon\",\"iconType\":\"twitter\",\"link\":\"http:\\/\\/www.twitter.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Twitter.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Twitter\"},{\"type\":\"socialIcon\",\"iconType\":\"instagram\",\"link\":\"http:\\/\\/instagram.com\",\"image\":\"https:\\/\\/demoes.aramis-co.ir\\/tikakala\\/wp-content\\/plugins\\/mailpoet\\/assets\\/img\\/newsletter_editor\\/social-icons\\/07-full-symbol-black\\/Instagram.png?mailpoet_version=3.7.3\",\"height\":\"32px\",\"width\":\"32px\",\"text\":\"Instagram\"}]}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"25px\"}}},{\"type\":\"text\",\"text\":\"<h1 style=\\\"line-height: 1.2em;\\\"><strong>Thanks for buying your dog food from us<\\/strong><\\/h1>\"}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"#ffffff\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}},{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/dog-food\\/Dog-Header-1024x409.jpg\",\"alt\":\"Dog-Header\",\"fullWidth\":true,\"width\":\"1280px\",\"height\":\"511px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"50px\"}}},{\"type\":\"text\",\"text\":\"<h2 style=\\\"text-align: center;\\\"><strong>Here\'s some other pawsome things to try...&nbsp;<\\/strong><\\/h2>\"},{\"type\":\"spacer\",\"styles\":{\"block\":{\"backgroundColor\":\"transparent\",\"height\":\"20px\"}}}]}]},{\"type\":\"container\",\"orientation\":\"horizontal\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"container\",\"orientation\":\"vertical\",\"image\":{\"src\":null,\"display\":\"scale\"},\"styles\":{\"block\":{\"backgroundColor\":\"transparent\"}},\"blocks\":[{\"type\":\"image\",\"link\":\"\",\"src\":\"https:\\/\\/ps.w.org\\/mailpoet\\/assets\\/newsletter-templates\\/dog-food\\/Dog-Product-1.jpg\",\"alt\":\"Dog-Product-1\",\"fullWidth\":false,\"width\":\"500px\",\"height\":\"500px\",\"styles\":{\"block\":{\"textAlign\":\"center\"}}},{\"type\":\"text\",\"text\":\"<h3><strong>Dog Jumper<\\/strong><\\/h3>\\n<p><span>Lorem ipsum dolor sit amet, consectetur adipiscing elit. Aliquam a elementum ex.<\\/span><\\/p>\\n<p><span><strong><\\/strong><\\/span><\\/p>\\n<p><em><strong>$19.99<\\/strong><\\/em><\\/p>\"},{\"type\":\"button\",\"text\":\"Check it out\",\"url\":\"\",\"styles\":{\"block\":{\"backgroundColor\":\"#f6f6f6\",\"borderColor\":\"#000000\",\"borderWidth\":\"3px\",\"borderRadius\":\"40px\",\"borderStyle\":\"solid\",\"width\":\"113px\",\"lineHeight\":\"28px\",\"fontColor\":\"#000000\",\"fontFamily\":\"Arial\",\"fontSize\":\"14px\",\"fontWeight\":\"bold\",\"textAlign\":\"left\"}}}]},{\"type\":\"container\",\"orientation\":